package v1alpha1

// This file contains a collection of methods that can be used from go-restful to
// generate Swagger API documentation for its models. Please read this PR for more
// information on the implementation: https://github.com/emicklei/go-restful/pull/215
//
// TODOs are ignored from the parser (e.g. TODO(andronat):... || TODO:...) if and only if
// they are on one line! For multiple line or blocks that you want to ignore use ---.
// Any context after a --- is ignored.
//
// Those methods can be generated by using hack/update-swagger-docs.sh

// AUTO-GENERATED FUNCTIONS START HERE
var map_AlertRelabelConfig = map[string]string{
	"":         "AlertRelabelConfig defines a set of relabel configs for alerts.\n\nCompatibility level 4: No compatibility is provided, the API can change at any point for any reason. These capabilities should not be used by applications needing long term support.",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "spec describes the desired state of this AlertRelabelConfig object.",
	"status":   "status describes the current state of this AlertRelabelConfig object.",
}

func (AlertRelabelConfig) SwaggerDoc() map[string]string {
	return map_AlertRelabelConfig
}

var map_AlertRelabelConfigList = map[string]string{
	"":         "AlertRelabelConfigList is a list of AlertRelabelConfigs.\n\nCompatibility level 4: No compatibility is provided, the API can change at any point for any reason. These capabilities should not be used by applications needing long term support.",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"items":    "items is a list of AlertRelabelConfigs.",
}

func (AlertRelabelConfigList) SwaggerDoc() map[string]string {
	return map_AlertRelabelConfigList
}

var map_AlertRelabelConfigSpec = map[string]string{
	"":        "AlertRelabelConfigsSpec is the desired state of an AlertRelabelConfig resource.",
	"configs": "configs is a list of sequentially evaluated alert relabel configs.",
}

func (AlertRelabelConfigSpec) SwaggerDoc() map[string]string {
	return map_AlertRelabelConfigSpec
}

var map_AlertRelabelConfigStatus = map[string]string{
	"":           "AlertRelabelConfigStatus is the status of an AlertRelabelConfig resource.",
	"conditions": "conditions contains details on the state of the AlertRelabelConfig, may be empty.",
}

func (AlertRelabelConfigStatus) SwaggerDoc() map[string]string {
	return map_AlertRelabelConfigStatus
}

var map_AlertingRule = map[string]string{
	"":         "AlertingRule represents a set of user-defined Prometheus rule groups containing alerting rules.  This resource is the supported method for cluster admins to create alerts based on metrics recorded by the platform monitoring stack in OpenShift, i.e. the Prometheus instance deployed to the openshift-monitoring namespace.  You might use this to create custom alerting rules not shipped with OpenShift based on metrics from components such as the node_exporter, which provides machine-level metrics such as CPU usage, or kube-state-metrics, which provides metrics on Kubernetes usage.\n\nThe API is mostly compatible with the upstream PrometheusRule type from the prometheus-operator.  The primary difference being that recording rules are not allowed here -- only alerting rules.  For each AlertingRule resource created, a corresponding PrometheusRule will be created in the openshift-monitoring namespace.  OpenShift requires admins to use the AlertingRule resource rather than the upstream type in order to allow better OpenShift specific defaulting and validation, while not modifying the upstream APIs directly.\n\nYou can find upstream API documentation for PrometheusRule resources here:\n\nhttps://github.com/prometheus-operator/prometheus-operator/blob/main/Documentation/api.md\n\nCompatibility level 4: No compatibility is provided, the API can change at any point for any reason. These capabilities should not be used by applications needing long term support.",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "spec describes the desired state of this AlertingRule object.",
	"status":   "status describes the current state of this AlertOverrides object.",
}

func (AlertingRule) SwaggerDoc() map[string]string {
	return map_AlertingRule
}

var map_AlertingRuleList = map[string]string{
	"":         "AlertingRuleList is a list of AlertingRule objects.\n\nCompatibility level 4: No compatibility is provided, the API can change at any point for any reason. These capabilities should not be used by applications needing long term support.",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"items":    "items is a list of AlertingRule objects.",
}

func (AlertingRuleList) SwaggerDoc() map[string]string {
	return map_AlertingRuleList
}

var map_AlertingRuleSpec = map[string]string{
	"":       "AlertingRuleSpec is the desired state of an AlertingRule resource.",
	"groups": "groups is a list of grouped alerting rules.  Rule groups are the unit at which Prometheus parallelizes rule processing.  All rules in a single group share a configured evaluation interval.  All rules in the group will be processed together on this interval, sequentially, and all rules will be processed.\n\nIt's common to group related alerting rules into a single AlertingRule resources, and within that resource, closely related alerts, or simply alerts with the same interval, into individual groups.  You are also free to create AlertingRule resources with only a single rule group, but be aware that this can have a performance impact on Prometheus if the group is extremely large or has very complex query expressions to evaluate. Spreading very complex rules across multiple groups to allow them to be processed in parallel is also a common use-case.",
}

func (AlertingRuleSpec) SwaggerDoc() map[string]string {
	return map_AlertingRuleSpec
}

var map_AlertingRuleStatus = map[string]string{
	"":                   "AlertingRuleStatus is the status of an AlertingRule resource.",
	"observedGeneration": "observedGeneration is the last generation change you've dealt with.",
	"prometheusRule":     "prometheusRule is the generated PrometheusRule for this AlertingRule.  Each AlertingRule instance results in a generated PrometheusRule object in the same namespace, which is always the openshift-monitoring namespace.",
}

func (AlertingRuleStatus) SwaggerDoc() map[string]string {
	return map_AlertingRuleStatus
}

var map_PrometheusRuleRef = map[string]string{
	"":     "PrometheusRuleRef is a reference to an existing PrometheusRule object.  Each AlertingRule instance results in a generated PrometheusRule object in the same namespace, which is always the openshift-monitoring namespace.  This is used to point to the generated PrometheusRule object in the AlertingRule status.",
	"name": "name of the referenced PrometheusRule.",
}

func (PrometheusRuleRef) SwaggerDoc() map[string]string {
	return map_PrometheusRuleRef
}

var map_RelabelConfig = map[string]string{
	"":             "RelabelConfig allows dynamic rewriting of label sets for alerts. See Prometheus documentation: - https://prometheus.io/docs/prometheus/latest/configuration/configuration/#alert_relabel_configs - https://prometheus.io/docs/prometheus/latest/configuration/configuration/#relabel_config",
	"sourceLabels": "sourceLabels select values from existing labels. Their content is concatenated using the configured separator and matched against the configured regular expression for the Replace, Keep, and Drop actions.",
	"separator":    "separator placed between concatenated source label values. When omitted, Prometheus will use its default value of ';'.",
	"targetLabel":  "targetLabel to which the resulting value is written in a 'Replace' action. It is mandatory for 'Replace' and 'HashMod' actions. Regex capture groups are available.",
	"regex":        "regex against which the extracted value is matched. Default is: '(.*)'",
	"modulus":      "modulus to take of the hash of the source label values.  This can be combined with the 'HashMod' action to set 'target_label' to the 'modulus' of a hash of the concatenated 'source_labels'.",
	"replacement":  "replacement value against which a regex replace is performed if the regular expression matches. This is required if the action is 'Replace' or 'LabelMap'. Regex capture groups are available. Default is: '$1'",
	"action":       "action to perform based on regex matching. Must be one of: Replace, Keep, Drop, HashMod, LabelMap, LabelDrop, or LabelKeep.  Default is: 'Replace'",
}

func (RelabelConfig) SwaggerDoc() map[string]string {
	return map_RelabelConfig
}

var map_Rule = map[string]string{
	"":            "Rule describes an alerting rule. See Prometheus documentation: - https://www.prometheus.io/docs/prometheus/latest/configuration/alerting_rules",
	"alert":       "alert is the name of the alert. Must be a valid label value, i.e. only contain ASCII letters, numbers, and underscores.",
	"expr":        "expr is the PromQL expression to evaluate. Every evaluation cycle this is evaluated at the current time, and all resultant time series become pending or firing alerts.  This is most often a string representing a PromQL expression, e.g.:\n\n  mapi_current_pending_csr > mapi_max_pending_csr\n\nIn rare cases this could be a simple integer, e.g. a simple \"1\" if the intent is to create an alert that is always firing.  This is sometimes used to create an always-firing \"Watchdog\" alert in order to ensure the alerting pipeline is functional.",
	"for":         "for is the time period after which alerts are considered firing after first returning results.  Alerts which have not yet fired for long enough are considered pending. This is represented as a Prometheus duration, for details on the format see: - https://prometheus.io/docs/prometheus/latest/configuration/configuration/#duration",
	"labels":      "labels to add or overwrite for each alert.  The results of the PromQL expression for the alert will result in an existing set of labels for the alert, after evaluating the expression, for any label specified here with the same name as a label in that set, the label here wins and overwrites the previous value.  These should typically be short identifying values that may be useful to query against.  A common example is the alert severity:\n\n  labels:\n    severity: warning",
	"annotations": "annotations to add to each alert.  These are values that can be used to store longer additional information that you won't query on, such as alert descriptions or runbook links, e.g.:\n\n  annotations:\n    summary: HAProxy reload failure\n    description: |\n      This alert fires when HAProxy fails to reload its\n      configuration, which will result in the router not picking up\n      recently created or modified routes.",
}

func (Rule) SwaggerDoc() map[string]string {
	return map_Rule
}

var map_RuleGroup = map[string]string{
	"":         "RuleGroup is a list of sequentially evaluated alerting rules.",
	"name":     "name is the name of the group.",
	"interval": "interval is how often rules in the group are evaluated.  If not specified, it defaults to the global.evaluation_interval configured in Prometheus, which itself defaults to 30 seconds.  You can check if this value has been modified from the default on your cluster by inspecting the platform Prometheus configuration:\n\n$ oc -n openshift-monitoring describe prometheus k8s\n\nThe relevant field in that resource is: spec.evaluationInterval\n\nThis is represented as a Prometheus duration, e.g. 1d, 1h30m, 5m, 10s.  You can find the upstream documentation here:\n\nhttps://prometheus.io/docs/prometheus/latest/configuration/configuration/#duration",
	"rules":    "rules is a list of sequentially evaluated alerting rules.  Prometheus may process rule groups in parallel, but rules within a single group are always processed sequentially, and all rules are processed.",
}

func (RuleGroup) SwaggerDoc() map[string]string {
	return map_RuleGroup
}

// AUTO-GENERATED FUNCTIONS END HERE
