// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package datazoneiface provides an interface to enable mocking the Amazon DataZone service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package datazoneiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/datazone"
)

// DataZoneAPI provides an interface to enable mocking the
// datazone.DataZone service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon DataZone.
//	func myFunc(svc datazoneiface.DataZoneAPI) bool {
//	    // Make svc.AcceptPredictions request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := datazone.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockDataZoneClient struct {
//	    datazoneiface.DataZoneAPI
//	}
//	func (m *mockDataZoneClient) AcceptPredictions(input *datazone.AcceptPredictionsInput) (*datazone.AcceptPredictionsOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockDataZoneClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type DataZoneAPI interface {
	AcceptPredictions(*datazone.AcceptPredictionsInput) (*datazone.AcceptPredictionsOutput, error)
	AcceptPredictionsWithContext(aws.Context, *datazone.AcceptPredictionsInput, ...request.Option) (*datazone.AcceptPredictionsOutput, error)
	AcceptPredictionsRequest(*datazone.AcceptPredictionsInput) (*request.Request, *datazone.AcceptPredictionsOutput)

	AcceptSubscriptionRequest(*datazone.AcceptSubscriptionRequestInput) (*datazone.AcceptSubscriptionRequestOutput, error)
	AcceptSubscriptionRequestWithContext(aws.Context, *datazone.AcceptSubscriptionRequestInput, ...request.Option) (*datazone.AcceptSubscriptionRequestOutput, error)
	AcceptSubscriptionRequestRequest(*datazone.AcceptSubscriptionRequestInput) (*request.Request, *datazone.AcceptSubscriptionRequestOutput)

	CancelMetadataGenerationRun(*datazone.CancelMetadataGenerationRunInput) (*datazone.CancelMetadataGenerationRunOutput, error)
	CancelMetadataGenerationRunWithContext(aws.Context, *datazone.CancelMetadataGenerationRunInput, ...request.Option) (*datazone.CancelMetadataGenerationRunOutput, error)
	CancelMetadataGenerationRunRequest(*datazone.CancelMetadataGenerationRunInput) (*request.Request, *datazone.CancelMetadataGenerationRunOutput)

	CancelSubscription(*datazone.CancelSubscriptionInput) (*datazone.CancelSubscriptionOutput, error)
	CancelSubscriptionWithContext(aws.Context, *datazone.CancelSubscriptionInput, ...request.Option) (*datazone.CancelSubscriptionOutput, error)
	CancelSubscriptionRequest(*datazone.CancelSubscriptionInput) (*request.Request, *datazone.CancelSubscriptionOutput)

	CreateAsset(*datazone.CreateAssetInput) (*datazone.CreateAssetOutput, error)
	CreateAssetWithContext(aws.Context, *datazone.CreateAssetInput, ...request.Option) (*datazone.CreateAssetOutput, error)
	CreateAssetRequest(*datazone.CreateAssetInput) (*request.Request, *datazone.CreateAssetOutput)

	CreateAssetRevision(*datazone.CreateAssetRevisionInput) (*datazone.CreateAssetRevisionOutput, error)
	CreateAssetRevisionWithContext(aws.Context, *datazone.CreateAssetRevisionInput, ...request.Option) (*datazone.CreateAssetRevisionOutput, error)
	CreateAssetRevisionRequest(*datazone.CreateAssetRevisionInput) (*request.Request, *datazone.CreateAssetRevisionOutput)

	CreateAssetType(*datazone.CreateAssetTypeInput) (*datazone.CreateAssetTypeOutput, error)
	CreateAssetTypeWithContext(aws.Context, *datazone.CreateAssetTypeInput, ...request.Option) (*datazone.CreateAssetTypeOutput, error)
	CreateAssetTypeRequest(*datazone.CreateAssetTypeInput) (*request.Request, *datazone.CreateAssetTypeOutput)

	CreateDataSource(*datazone.CreateDataSourceInput) (*datazone.CreateDataSourceOutput, error)
	CreateDataSourceWithContext(aws.Context, *datazone.CreateDataSourceInput, ...request.Option) (*datazone.CreateDataSourceOutput, error)
	CreateDataSourceRequest(*datazone.CreateDataSourceInput) (*request.Request, *datazone.CreateDataSourceOutput)

	CreateDomain(*datazone.CreateDomainInput) (*datazone.CreateDomainOutput, error)
	CreateDomainWithContext(aws.Context, *datazone.CreateDomainInput, ...request.Option) (*datazone.CreateDomainOutput, error)
	CreateDomainRequest(*datazone.CreateDomainInput) (*request.Request, *datazone.CreateDomainOutput)

	CreateEnvironment(*datazone.CreateEnvironmentInput) (*datazone.CreateEnvironmentOutput, error)
	CreateEnvironmentWithContext(aws.Context, *datazone.CreateEnvironmentInput, ...request.Option) (*datazone.CreateEnvironmentOutput, error)
	CreateEnvironmentRequest(*datazone.CreateEnvironmentInput) (*request.Request, *datazone.CreateEnvironmentOutput)

	CreateEnvironmentProfile(*datazone.CreateEnvironmentProfileInput) (*datazone.CreateEnvironmentProfileOutput, error)
	CreateEnvironmentProfileWithContext(aws.Context, *datazone.CreateEnvironmentProfileInput, ...request.Option) (*datazone.CreateEnvironmentProfileOutput, error)
	CreateEnvironmentProfileRequest(*datazone.CreateEnvironmentProfileInput) (*request.Request, *datazone.CreateEnvironmentProfileOutput)

	CreateFormType(*datazone.CreateFormTypeInput) (*datazone.CreateFormTypeOutput, error)
	CreateFormTypeWithContext(aws.Context, *datazone.CreateFormTypeInput, ...request.Option) (*datazone.CreateFormTypeOutput, error)
	CreateFormTypeRequest(*datazone.CreateFormTypeInput) (*request.Request, *datazone.CreateFormTypeOutput)

	CreateGlossary(*datazone.CreateGlossaryInput) (*datazone.CreateGlossaryOutput, error)
	CreateGlossaryWithContext(aws.Context, *datazone.CreateGlossaryInput, ...request.Option) (*datazone.CreateGlossaryOutput, error)
	CreateGlossaryRequest(*datazone.CreateGlossaryInput) (*request.Request, *datazone.CreateGlossaryOutput)

	CreateGlossaryTerm(*datazone.CreateGlossaryTermInput) (*datazone.CreateGlossaryTermOutput, error)
	CreateGlossaryTermWithContext(aws.Context, *datazone.CreateGlossaryTermInput, ...request.Option) (*datazone.CreateGlossaryTermOutput, error)
	CreateGlossaryTermRequest(*datazone.CreateGlossaryTermInput) (*request.Request, *datazone.CreateGlossaryTermOutput)

	CreateGroupProfile(*datazone.CreateGroupProfileInput) (*datazone.CreateGroupProfileOutput, error)
	CreateGroupProfileWithContext(aws.Context, *datazone.CreateGroupProfileInput, ...request.Option) (*datazone.CreateGroupProfileOutput, error)
	CreateGroupProfileRequest(*datazone.CreateGroupProfileInput) (*request.Request, *datazone.CreateGroupProfileOutput)

	CreateListingChangeSet(*datazone.CreateListingChangeSetInput) (*datazone.CreateListingChangeSetOutput, error)
	CreateListingChangeSetWithContext(aws.Context, *datazone.CreateListingChangeSetInput, ...request.Option) (*datazone.CreateListingChangeSetOutput, error)
	CreateListingChangeSetRequest(*datazone.CreateListingChangeSetInput) (*request.Request, *datazone.CreateListingChangeSetOutput)

	CreateProject(*datazone.CreateProjectInput) (*datazone.CreateProjectOutput, error)
	CreateProjectWithContext(aws.Context, *datazone.CreateProjectInput, ...request.Option) (*datazone.CreateProjectOutput, error)
	CreateProjectRequest(*datazone.CreateProjectInput) (*request.Request, *datazone.CreateProjectOutput)

	CreateProjectMembership(*datazone.CreateProjectMembershipInput) (*datazone.CreateProjectMembershipOutput, error)
	CreateProjectMembershipWithContext(aws.Context, *datazone.CreateProjectMembershipInput, ...request.Option) (*datazone.CreateProjectMembershipOutput, error)
	CreateProjectMembershipRequest(*datazone.CreateProjectMembershipInput) (*request.Request, *datazone.CreateProjectMembershipOutput)

	CreateSubscriptionGrant(*datazone.CreateSubscriptionGrantInput) (*datazone.CreateSubscriptionGrantOutput, error)
	CreateSubscriptionGrantWithContext(aws.Context, *datazone.CreateSubscriptionGrantInput, ...request.Option) (*datazone.CreateSubscriptionGrantOutput, error)
	CreateSubscriptionGrantRequest(*datazone.CreateSubscriptionGrantInput) (*request.Request, *datazone.CreateSubscriptionGrantOutput)

	CreateSubscriptionRequest(*datazone.CreateSubscriptionRequestInput) (*datazone.CreateSubscriptionRequestOutput, error)
	CreateSubscriptionRequestWithContext(aws.Context, *datazone.CreateSubscriptionRequestInput, ...request.Option) (*datazone.CreateSubscriptionRequestOutput, error)
	CreateSubscriptionRequestRequest(*datazone.CreateSubscriptionRequestInput) (*request.Request, *datazone.CreateSubscriptionRequestOutput)

	CreateSubscriptionTarget(*datazone.CreateSubscriptionTargetInput) (*datazone.CreateSubscriptionTargetOutput, error)
	CreateSubscriptionTargetWithContext(aws.Context, *datazone.CreateSubscriptionTargetInput, ...request.Option) (*datazone.CreateSubscriptionTargetOutput, error)
	CreateSubscriptionTargetRequest(*datazone.CreateSubscriptionTargetInput) (*request.Request, *datazone.CreateSubscriptionTargetOutput)

	CreateUserProfile(*datazone.CreateUserProfileInput) (*datazone.CreateUserProfileOutput, error)
	CreateUserProfileWithContext(aws.Context, *datazone.CreateUserProfileInput, ...request.Option) (*datazone.CreateUserProfileOutput, error)
	CreateUserProfileRequest(*datazone.CreateUserProfileInput) (*request.Request, *datazone.CreateUserProfileOutput)

	DeleteAsset(*datazone.DeleteAssetInput) (*datazone.DeleteAssetOutput, error)
	DeleteAssetWithContext(aws.Context, *datazone.DeleteAssetInput, ...request.Option) (*datazone.DeleteAssetOutput, error)
	DeleteAssetRequest(*datazone.DeleteAssetInput) (*request.Request, *datazone.DeleteAssetOutput)

	DeleteAssetType(*datazone.DeleteAssetTypeInput) (*datazone.DeleteAssetTypeOutput, error)
	DeleteAssetTypeWithContext(aws.Context, *datazone.DeleteAssetTypeInput, ...request.Option) (*datazone.DeleteAssetTypeOutput, error)
	DeleteAssetTypeRequest(*datazone.DeleteAssetTypeInput) (*request.Request, *datazone.DeleteAssetTypeOutput)

	DeleteDataSource(*datazone.DeleteDataSourceInput) (*datazone.DeleteDataSourceOutput, error)
	DeleteDataSourceWithContext(aws.Context, *datazone.DeleteDataSourceInput, ...request.Option) (*datazone.DeleteDataSourceOutput, error)
	DeleteDataSourceRequest(*datazone.DeleteDataSourceInput) (*request.Request, *datazone.DeleteDataSourceOutput)

	DeleteDomain(*datazone.DeleteDomainInput) (*datazone.DeleteDomainOutput, error)
	DeleteDomainWithContext(aws.Context, *datazone.DeleteDomainInput, ...request.Option) (*datazone.DeleteDomainOutput, error)
	DeleteDomainRequest(*datazone.DeleteDomainInput) (*request.Request, *datazone.DeleteDomainOutput)

	DeleteEnvironment(*datazone.DeleteEnvironmentInput) (*datazone.DeleteEnvironmentOutput, error)
	DeleteEnvironmentWithContext(aws.Context, *datazone.DeleteEnvironmentInput, ...request.Option) (*datazone.DeleteEnvironmentOutput, error)
	DeleteEnvironmentRequest(*datazone.DeleteEnvironmentInput) (*request.Request, *datazone.DeleteEnvironmentOutput)

	DeleteEnvironmentBlueprintConfiguration(*datazone.DeleteEnvironmentBlueprintConfigurationInput) (*datazone.DeleteEnvironmentBlueprintConfigurationOutput, error)
	DeleteEnvironmentBlueprintConfigurationWithContext(aws.Context, *datazone.DeleteEnvironmentBlueprintConfigurationInput, ...request.Option) (*datazone.DeleteEnvironmentBlueprintConfigurationOutput, error)
	DeleteEnvironmentBlueprintConfigurationRequest(*datazone.DeleteEnvironmentBlueprintConfigurationInput) (*request.Request, *datazone.DeleteEnvironmentBlueprintConfigurationOutput)

	DeleteEnvironmentProfile(*datazone.DeleteEnvironmentProfileInput) (*datazone.DeleteEnvironmentProfileOutput, error)
	DeleteEnvironmentProfileWithContext(aws.Context, *datazone.DeleteEnvironmentProfileInput, ...request.Option) (*datazone.DeleteEnvironmentProfileOutput, error)
	DeleteEnvironmentProfileRequest(*datazone.DeleteEnvironmentProfileInput) (*request.Request, *datazone.DeleteEnvironmentProfileOutput)

	DeleteFormType(*datazone.DeleteFormTypeInput) (*datazone.DeleteFormTypeOutput, error)
	DeleteFormTypeWithContext(aws.Context, *datazone.DeleteFormTypeInput, ...request.Option) (*datazone.DeleteFormTypeOutput, error)
	DeleteFormTypeRequest(*datazone.DeleteFormTypeInput) (*request.Request, *datazone.DeleteFormTypeOutput)

	DeleteGlossary(*datazone.DeleteGlossaryInput) (*datazone.DeleteGlossaryOutput, error)
	DeleteGlossaryWithContext(aws.Context, *datazone.DeleteGlossaryInput, ...request.Option) (*datazone.DeleteGlossaryOutput, error)
	DeleteGlossaryRequest(*datazone.DeleteGlossaryInput) (*request.Request, *datazone.DeleteGlossaryOutput)

	DeleteGlossaryTerm(*datazone.DeleteGlossaryTermInput) (*datazone.DeleteGlossaryTermOutput, error)
	DeleteGlossaryTermWithContext(aws.Context, *datazone.DeleteGlossaryTermInput, ...request.Option) (*datazone.DeleteGlossaryTermOutput, error)
	DeleteGlossaryTermRequest(*datazone.DeleteGlossaryTermInput) (*request.Request, *datazone.DeleteGlossaryTermOutput)

	DeleteListing(*datazone.DeleteListingInput) (*datazone.DeleteListingOutput, error)
	DeleteListingWithContext(aws.Context, *datazone.DeleteListingInput, ...request.Option) (*datazone.DeleteListingOutput, error)
	DeleteListingRequest(*datazone.DeleteListingInput) (*request.Request, *datazone.DeleteListingOutput)

	DeleteProject(*datazone.DeleteProjectInput) (*datazone.DeleteProjectOutput, error)
	DeleteProjectWithContext(aws.Context, *datazone.DeleteProjectInput, ...request.Option) (*datazone.DeleteProjectOutput, error)
	DeleteProjectRequest(*datazone.DeleteProjectInput) (*request.Request, *datazone.DeleteProjectOutput)

	DeleteProjectMembership(*datazone.DeleteProjectMembershipInput) (*datazone.DeleteProjectMembershipOutput, error)
	DeleteProjectMembershipWithContext(aws.Context, *datazone.DeleteProjectMembershipInput, ...request.Option) (*datazone.DeleteProjectMembershipOutput, error)
	DeleteProjectMembershipRequest(*datazone.DeleteProjectMembershipInput) (*request.Request, *datazone.DeleteProjectMembershipOutput)

	DeleteSubscriptionGrant(*datazone.DeleteSubscriptionGrantInput) (*datazone.DeleteSubscriptionGrantOutput, error)
	DeleteSubscriptionGrantWithContext(aws.Context, *datazone.DeleteSubscriptionGrantInput, ...request.Option) (*datazone.DeleteSubscriptionGrantOutput, error)
	DeleteSubscriptionGrantRequest(*datazone.DeleteSubscriptionGrantInput) (*request.Request, *datazone.DeleteSubscriptionGrantOutput)

	DeleteSubscriptionRequest(*datazone.DeleteSubscriptionRequestInput) (*datazone.DeleteSubscriptionRequestOutput, error)
	DeleteSubscriptionRequestWithContext(aws.Context, *datazone.DeleteSubscriptionRequestInput, ...request.Option) (*datazone.DeleteSubscriptionRequestOutput, error)
	DeleteSubscriptionRequestRequest(*datazone.DeleteSubscriptionRequestInput) (*request.Request, *datazone.DeleteSubscriptionRequestOutput)

	DeleteSubscriptionTarget(*datazone.DeleteSubscriptionTargetInput) (*datazone.DeleteSubscriptionTargetOutput, error)
	DeleteSubscriptionTargetWithContext(aws.Context, *datazone.DeleteSubscriptionTargetInput, ...request.Option) (*datazone.DeleteSubscriptionTargetOutput, error)
	DeleteSubscriptionTargetRequest(*datazone.DeleteSubscriptionTargetInput) (*request.Request, *datazone.DeleteSubscriptionTargetOutput)

	DeleteTimeSeriesDataPoints(*datazone.DeleteTimeSeriesDataPointsInput) (*datazone.DeleteTimeSeriesDataPointsOutput, error)
	DeleteTimeSeriesDataPointsWithContext(aws.Context, *datazone.DeleteTimeSeriesDataPointsInput, ...request.Option) (*datazone.DeleteTimeSeriesDataPointsOutput, error)
	DeleteTimeSeriesDataPointsRequest(*datazone.DeleteTimeSeriesDataPointsInput) (*request.Request, *datazone.DeleteTimeSeriesDataPointsOutput)

	GetAsset(*datazone.GetAssetInput) (*datazone.GetAssetOutput, error)
	GetAssetWithContext(aws.Context, *datazone.GetAssetInput, ...request.Option) (*datazone.GetAssetOutput, error)
	GetAssetRequest(*datazone.GetAssetInput) (*request.Request, *datazone.GetAssetOutput)

	GetAssetType(*datazone.GetAssetTypeInput) (*datazone.GetAssetTypeOutput, error)
	GetAssetTypeWithContext(aws.Context, *datazone.GetAssetTypeInput, ...request.Option) (*datazone.GetAssetTypeOutput, error)
	GetAssetTypeRequest(*datazone.GetAssetTypeInput) (*request.Request, *datazone.GetAssetTypeOutput)

	GetDataSource(*datazone.GetDataSourceInput) (*datazone.GetDataSourceOutput, error)
	GetDataSourceWithContext(aws.Context, *datazone.GetDataSourceInput, ...request.Option) (*datazone.GetDataSourceOutput, error)
	GetDataSourceRequest(*datazone.GetDataSourceInput) (*request.Request, *datazone.GetDataSourceOutput)

	GetDataSourceRun(*datazone.GetDataSourceRunInput) (*datazone.GetDataSourceRunOutput, error)
	GetDataSourceRunWithContext(aws.Context, *datazone.GetDataSourceRunInput, ...request.Option) (*datazone.GetDataSourceRunOutput, error)
	GetDataSourceRunRequest(*datazone.GetDataSourceRunInput) (*request.Request, *datazone.GetDataSourceRunOutput)

	GetDomain(*datazone.GetDomainInput) (*datazone.GetDomainOutput, error)
	GetDomainWithContext(aws.Context, *datazone.GetDomainInput, ...request.Option) (*datazone.GetDomainOutput, error)
	GetDomainRequest(*datazone.GetDomainInput) (*request.Request, *datazone.GetDomainOutput)

	GetEnvironment(*datazone.GetEnvironmentInput) (*datazone.GetEnvironmentOutput, error)
	GetEnvironmentWithContext(aws.Context, *datazone.GetEnvironmentInput, ...request.Option) (*datazone.GetEnvironmentOutput, error)
	GetEnvironmentRequest(*datazone.GetEnvironmentInput) (*request.Request, *datazone.GetEnvironmentOutput)

	GetEnvironmentBlueprint(*datazone.GetEnvironmentBlueprintInput) (*datazone.GetEnvironmentBlueprintOutput, error)
	GetEnvironmentBlueprintWithContext(aws.Context, *datazone.GetEnvironmentBlueprintInput, ...request.Option) (*datazone.GetEnvironmentBlueprintOutput, error)
	GetEnvironmentBlueprintRequest(*datazone.GetEnvironmentBlueprintInput) (*request.Request, *datazone.GetEnvironmentBlueprintOutput)

	GetEnvironmentBlueprintConfiguration(*datazone.GetEnvironmentBlueprintConfigurationInput) (*datazone.GetEnvironmentBlueprintConfigurationOutput, error)
	GetEnvironmentBlueprintConfigurationWithContext(aws.Context, *datazone.GetEnvironmentBlueprintConfigurationInput, ...request.Option) (*datazone.GetEnvironmentBlueprintConfigurationOutput, error)
	GetEnvironmentBlueprintConfigurationRequest(*datazone.GetEnvironmentBlueprintConfigurationInput) (*request.Request, *datazone.GetEnvironmentBlueprintConfigurationOutput)

	GetEnvironmentProfile(*datazone.GetEnvironmentProfileInput) (*datazone.GetEnvironmentProfileOutput, error)
	GetEnvironmentProfileWithContext(aws.Context, *datazone.GetEnvironmentProfileInput, ...request.Option) (*datazone.GetEnvironmentProfileOutput, error)
	GetEnvironmentProfileRequest(*datazone.GetEnvironmentProfileInput) (*request.Request, *datazone.GetEnvironmentProfileOutput)

	GetFormType(*datazone.GetFormTypeInput) (*datazone.GetFormTypeOutput, error)
	GetFormTypeWithContext(aws.Context, *datazone.GetFormTypeInput, ...request.Option) (*datazone.GetFormTypeOutput, error)
	GetFormTypeRequest(*datazone.GetFormTypeInput) (*request.Request, *datazone.GetFormTypeOutput)

	GetGlossary(*datazone.GetGlossaryInput) (*datazone.GetGlossaryOutput, error)
	GetGlossaryWithContext(aws.Context, *datazone.GetGlossaryInput, ...request.Option) (*datazone.GetGlossaryOutput, error)
	GetGlossaryRequest(*datazone.GetGlossaryInput) (*request.Request, *datazone.GetGlossaryOutput)

	GetGlossaryTerm(*datazone.GetGlossaryTermInput) (*datazone.GetGlossaryTermOutput, error)
	GetGlossaryTermWithContext(aws.Context, *datazone.GetGlossaryTermInput, ...request.Option) (*datazone.GetGlossaryTermOutput, error)
	GetGlossaryTermRequest(*datazone.GetGlossaryTermInput) (*request.Request, *datazone.GetGlossaryTermOutput)

	GetGroupProfile(*datazone.GetGroupProfileInput) (*datazone.GetGroupProfileOutput, error)
	GetGroupProfileWithContext(aws.Context, *datazone.GetGroupProfileInput, ...request.Option) (*datazone.GetGroupProfileOutput, error)
	GetGroupProfileRequest(*datazone.GetGroupProfileInput) (*request.Request, *datazone.GetGroupProfileOutput)

	GetIamPortalLoginUrl(*datazone.GetIamPortalLoginUrlInput) (*datazone.GetIamPortalLoginUrlOutput, error)
	GetIamPortalLoginUrlWithContext(aws.Context, *datazone.GetIamPortalLoginUrlInput, ...request.Option) (*datazone.GetIamPortalLoginUrlOutput, error)
	GetIamPortalLoginUrlRequest(*datazone.GetIamPortalLoginUrlInput) (*request.Request, *datazone.GetIamPortalLoginUrlOutput)

	GetListing(*datazone.GetListingInput) (*datazone.GetListingOutput, error)
	GetListingWithContext(aws.Context, *datazone.GetListingInput, ...request.Option) (*datazone.GetListingOutput, error)
	GetListingRequest(*datazone.GetListingInput) (*request.Request, *datazone.GetListingOutput)

	GetMetadataGenerationRun(*datazone.GetMetadataGenerationRunInput) (*datazone.GetMetadataGenerationRunOutput, error)
	GetMetadataGenerationRunWithContext(aws.Context, *datazone.GetMetadataGenerationRunInput, ...request.Option) (*datazone.GetMetadataGenerationRunOutput, error)
	GetMetadataGenerationRunRequest(*datazone.GetMetadataGenerationRunInput) (*request.Request, *datazone.GetMetadataGenerationRunOutput)

	GetProject(*datazone.GetProjectInput) (*datazone.GetProjectOutput, error)
	GetProjectWithContext(aws.Context, *datazone.GetProjectInput, ...request.Option) (*datazone.GetProjectOutput, error)
	GetProjectRequest(*datazone.GetProjectInput) (*request.Request, *datazone.GetProjectOutput)

	GetSubscription(*datazone.GetSubscriptionInput) (*datazone.GetSubscriptionOutput, error)
	GetSubscriptionWithContext(aws.Context, *datazone.GetSubscriptionInput, ...request.Option) (*datazone.GetSubscriptionOutput, error)
	GetSubscriptionRequest(*datazone.GetSubscriptionInput) (*request.Request, *datazone.GetSubscriptionOutput)

	GetSubscriptionGrant(*datazone.GetSubscriptionGrantInput) (*datazone.GetSubscriptionGrantOutput, error)
	GetSubscriptionGrantWithContext(aws.Context, *datazone.GetSubscriptionGrantInput, ...request.Option) (*datazone.GetSubscriptionGrantOutput, error)
	GetSubscriptionGrantRequest(*datazone.GetSubscriptionGrantInput) (*request.Request, *datazone.GetSubscriptionGrantOutput)

	GetSubscriptionRequestDetails(*datazone.GetSubscriptionRequestDetailsInput) (*datazone.GetSubscriptionRequestDetailsOutput, error)
	GetSubscriptionRequestDetailsWithContext(aws.Context, *datazone.GetSubscriptionRequestDetailsInput, ...request.Option) (*datazone.GetSubscriptionRequestDetailsOutput, error)
	GetSubscriptionRequestDetailsRequest(*datazone.GetSubscriptionRequestDetailsInput) (*request.Request, *datazone.GetSubscriptionRequestDetailsOutput)

	GetSubscriptionTarget(*datazone.GetSubscriptionTargetInput) (*datazone.GetSubscriptionTargetOutput, error)
	GetSubscriptionTargetWithContext(aws.Context, *datazone.GetSubscriptionTargetInput, ...request.Option) (*datazone.GetSubscriptionTargetOutput, error)
	GetSubscriptionTargetRequest(*datazone.GetSubscriptionTargetInput) (*request.Request, *datazone.GetSubscriptionTargetOutput)

	GetTimeSeriesDataPoint(*datazone.GetTimeSeriesDataPointInput) (*datazone.GetTimeSeriesDataPointOutput, error)
	GetTimeSeriesDataPointWithContext(aws.Context, *datazone.GetTimeSeriesDataPointInput, ...request.Option) (*datazone.GetTimeSeriesDataPointOutput, error)
	GetTimeSeriesDataPointRequest(*datazone.GetTimeSeriesDataPointInput) (*request.Request, *datazone.GetTimeSeriesDataPointOutput)

	GetUserProfile(*datazone.GetUserProfileInput) (*datazone.GetUserProfileOutput, error)
	GetUserProfileWithContext(aws.Context, *datazone.GetUserProfileInput, ...request.Option) (*datazone.GetUserProfileOutput, error)
	GetUserProfileRequest(*datazone.GetUserProfileInput) (*request.Request, *datazone.GetUserProfileOutput)

	ListAssetRevisions(*datazone.ListAssetRevisionsInput) (*datazone.ListAssetRevisionsOutput, error)
	ListAssetRevisionsWithContext(aws.Context, *datazone.ListAssetRevisionsInput, ...request.Option) (*datazone.ListAssetRevisionsOutput, error)
	ListAssetRevisionsRequest(*datazone.ListAssetRevisionsInput) (*request.Request, *datazone.ListAssetRevisionsOutput)

	ListAssetRevisionsPages(*datazone.ListAssetRevisionsInput, func(*datazone.ListAssetRevisionsOutput, bool) bool) error
	ListAssetRevisionsPagesWithContext(aws.Context, *datazone.ListAssetRevisionsInput, func(*datazone.ListAssetRevisionsOutput, bool) bool, ...request.Option) error

	ListDataSourceRunActivities(*datazone.ListDataSourceRunActivitiesInput) (*datazone.ListDataSourceRunActivitiesOutput, error)
	ListDataSourceRunActivitiesWithContext(aws.Context, *datazone.ListDataSourceRunActivitiesInput, ...request.Option) (*datazone.ListDataSourceRunActivitiesOutput, error)
	ListDataSourceRunActivitiesRequest(*datazone.ListDataSourceRunActivitiesInput) (*request.Request, *datazone.ListDataSourceRunActivitiesOutput)

	ListDataSourceRunActivitiesPages(*datazone.ListDataSourceRunActivitiesInput, func(*datazone.ListDataSourceRunActivitiesOutput, bool) bool) error
	ListDataSourceRunActivitiesPagesWithContext(aws.Context, *datazone.ListDataSourceRunActivitiesInput, func(*datazone.ListDataSourceRunActivitiesOutput, bool) bool, ...request.Option) error

	ListDataSourceRuns(*datazone.ListDataSourceRunsInput) (*datazone.ListDataSourceRunsOutput, error)
	ListDataSourceRunsWithContext(aws.Context, *datazone.ListDataSourceRunsInput, ...request.Option) (*datazone.ListDataSourceRunsOutput, error)
	ListDataSourceRunsRequest(*datazone.ListDataSourceRunsInput) (*request.Request, *datazone.ListDataSourceRunsOutput)

	ListDataSourceRunsPages(*datazone.ListDataSourceRunsInput, func(*datazone.ListDataSourceRunsOutput, bool) bool) error
	ListDataSourceRunsPagesWithContext(aws.Context, *datazone.ListDataSourceRunsInput, func(*datazone.ListDataSourceRunsOutput, bool) bool, ...request.Option) error

	ListDataSources(*datazone.ListDataSourcesInput) (*datazone.ListDataSourcesOutput, error)
	ListDataSourcesWithContext(aws.Context, *datazone.ListDataSourcesInput, ...request.Option) (*datazone.ListDataSourcesOutput, error)
	ListDataSourcesRequest(*datazone.ListDataSourcesInput) (*request.Request, *datazone.ListDataSourcesOutput)

	ListDataSourcesPages(*datazone.ListDataSourcesInput, func(*datazone.ListDataSourcesOutput, bool) bool) error
	ListDataSourcesPagesWithContext(aws.Context, *datazone.ListDataSourcesInput, func(*datazone.ListDataSourcesOutput, bool) bool, ...request.Option) error

	ListDomains(*datazone.ListDomainsInput) (*datazone.ListDomainsOutput, error)
	ListDomainsWithContext(aws.Context, *datazone.ListDomainsInput, ...request.Option) (*datazone.ListDomainsOutput, error)
	ListDomainsRequest(*datazone.ListDomainsInput) (*request.Request, *datazone.ListDomainsOutput)

	ListDomainsPages(*datazone.ListDomainsInput, func(*datazone.ListDomainsOutput, bool) bool) error
	ListDomainsPagesWithContext(aws.Context, *datazone.ListDomainsInput, func(*datazone.ListDomainsOutput, bool) bool, ...request.Option) error

	ListEnvironmentBlueprintConfigurations(*datazone.ListEnvironmentBlueprintConfigurationsInput) (*datazone.ListEnvironmentBlueprintConfigurationsOutput, error)
	ListEnvironmentBlueprintConfigurationsWithContext(aws.Context, *datazone.ListEnvironmentBlueprintConfigurationsInput, ...request.Option) (*datazone.ListEnvironmentBlueprintConfigurationsOutput, error)
	ListEnvironmentBlueprintConfigurationsRequest(*datazone.ListEnvironmentBlueprintConfigurationsInput) (*request.Request, *datazone.ListEnvironmentBlueprintConfigurationsOutput)

	ListEnvironmentBlueprintConfigurationsPages(*datazone.ListEnvironmentBlueprintConfigurationsInput, func(*datazone.ListEnvironmentBlueprintConfigurationsOutput, bool) bool) error
	ListEnvironmentBlueprintConfigurationsPagesWithContext(aws.Context, *datazone.ListEnvironmentBlueprintConfigurationsInput, func(*datazone.ListEnvironmentBlueprintConfigurationsOutput, bool) bool, ...request.Option) error

	ListEnvironmentBlueprints(*datazone.ListEnvironmentBlueprintsInput) (*datazone.ListEnvironmentBlueprintsOutput, error)
	ListEnvironmentBlueprintsWithContext(aws.Context, *datazone.ListEnvironmentBlueprintsInput, ...request.Option) (*datazone.ListEnvironmentBlueprintsOutput, error)
	ListEnvironmentBlueprintsRequest(*datazone.ListEnvironmentBlueprintsInput) (*request.Request, *datazone.ListEnvironmentBlueprintsOutput)

	ListEnvironmentBlueprintsPages(*datazone.ListEnvironmentBlueprintsInput, func(*datazone.ListEnvironmentBlueprintsOutput, bool) bool) error
	ListEnvironmentBlueprintsPagesWithContext(aws.Context, *datazone.ListEnvironmentBlueprintsInput, func(*datazone.ListEnvironmentBlueprintsOutput, bool) bool, ...request.Option) error

	ListEnvironmentProfiles(*datazone.ListEnvironmentProfilesInput) (*datazone.ListEnvironmentProfilesOutput, error)
	ListEnvironmentProfilesWithContext(aws.Context, *datazone.ListEnvironmentProfilesInput, ...request.Option) (*datazone.ListEnvironmentProfilesOutput, error)
	ListEnvironmentProfilesRequest(*datazone.ListEnvironmentProfilesInput) (*request.Request, *datazone.ListEnvironmentProfilesOutput)

	ListEnvironmentProfilesPages(*datazone.ListEnvironmentProfilesInput, func(*datazone.ListEnvironmentProfilesOutput, bool) bool) error
	ListEnvironmentProfilesPagesWithContext(aws.Context, *datazone.ListEnvironmentProfilesInput, func(*datazone.ListEnvironmentProfilesOutput, bool) bool, ...request.Option) error

	ListEnvironments(*datazone.ListEnvironmentsInput) (*datazone.ListEnvironmentsOutput, error)
	ListEnvironmentsWithContext(aws.Context, *datazone.ListEnvironmentsInput, ...request.Option) (*datazone.ListEnvironmentsOutput, error)
	ListEnvironmentsRequest(*datazone.ListEnvironmentsInput) (*request.Request, *datazone.ListEnvironmentsOutput)

	ListEnvironmentsPages(*datazone.ListEnvironmentsInput, func(*datazone.ListEnvironmentsOutput, bool) bool) error
	ListEnvironmentsPagesWithContext(aws.Context, *datazone.ListEnvironmentsInput, func(*datazone.ListEnvironmentsOutput, bool) bool, ...request.Option) error

	ListMetadataGenerationRuns(*datazone.ListMetadataGenerationRunsInput) (*datazone.ListMetadataGenerationRunsOutput, error)
	ListMetadataGenerationRunsWithContext(aws.Context, *datazone.ListMetadataGenerationRunsInput, ...request.Option) (*datazone.ListMetadataGenerationRunsOutput, error)
	ListMetadataGenerationRunsRequest(*datazone.ListMetadataGenerationRunsInput) (*request.Request, *datazone.ListMetadataGenerationRunsOutput)

	ListMetadataGenerationRunsPages(*datazone.ListMetadataGenerationRunsInput, func(*datazone.ListMetadataGenerationRunsOutput, bool) bool) error
	ListMetadataGenerationRunsPagesWithContext(aws.Context, *datazone.ListMetadataGenerationRunsInput, func(*datazone.ListMetadataGenerationRunsOutput, bool) bool, ...request.Option) error

	ListNotifications(*datazone.ListNotificationsInput) (*datazone.ListNotificationsOutput, error)
	ListNotificationsWithContext(aws.Context, *datazone.ListNotificationsInput, ...request.Option) (*datazone.ListNotificationsOutput, error)
	ListNotificationsRequest(*datazone.ListNotificationsInput) (*request.Request, *datazone.ListNotificationsOutput)

	ListNotificationsPages(*datazone.ListNotificationsInput, func(*datazone.ListNotificationsOutput, bool) bool) error
	ListNotificationsPagesWithContext(aws.Context, *datazone.ListNotificationsInput, func(*datazone.ListNotificationsOutput, bool) bool, ...request.Option) error

	ListProjectMemberships(*datazone.ListProjectMembershipsInput) (*datazone.ListProjectMembershipsOutput, error)
	ListProjectMembershipsWithContext(aws.Context, *datazone.ListProjectMembershipsInput, ...request.Option) (*datazone.ListProjectMembershipsOutput, error)
	ListProjectMembershipsRequest(*datazone.ListProjectMembershipsInput) (*request.Request, *datazone.ListProjectMembershipsOutput)

	ListProjectMembershipsPages(*datazone.ListProjectMembershipsInput, func(*datazone.ListProjectMembershipsOutput, bool) bool) error
	ListProjectMembershipsPagesWithContext(aws.Context, *datazone.ListProjectMembershipsInput, func(*datazone.ListProjectMembershipsOutput, bool) bool, ...request.Option) error

	ListProjects(*datazone.ListProjectsInput) (*datazone.ListProjectsOutput, error)
	ListProjectsWithContext(aws.Context, *datazone.ListProjectsInput, ...request.Option) (*datazone.ListProjectsOutput, error)
	ListProjectsRequest(*datazone.ListProjectsInput) (*request.Request, *datazone.ListProjectsOutput)

	ListProjectsPages(*datazone.ListProjectsInput, func(*datazone.ListProjectsOutput, bool) bool) error
	ListProjectsPagesWithContext(aws.Context, *datazone.ListProjectsInput, func(*datazone.ListProjectsOutput, bool) bool, ...request.Option) error

	ListSubscriptionGrants(*datazone.ListSubscriptionGrantsInput) (*datazone.ListSubscriptionGrantsOutput, error)
	ListSubscriptionGrantsWithContext(aws.Context, *datazone.ListSubscriptionGrantsInput, ...request.Option) (*datazone.ListSubscriptionGrantsOutput, error)
	ListSubscriptionGrantsRequest(*datazone.ListSubscriptionGrantsInput) (*request.Request, *datazone.ListSubscriptionGrantsOutput)

	ListSubscriptionGrantsPages(*datazone.ListSubscriptionGrantsInput, func(*datazone.ListSubscriptionGrantsOutput, bool) bool) error
	ListSubscriptionGrantsPagesWithContext(aws.Context, *datazone.ListSubscriptionGrantsInput, func(*datazone.ListSubscriptionGrantsOutput, bool) bool, ...request.Option) error

	ListSubscriptionRequests(*datazone.ListSubscriptionRequestsInput) (*datazone.ListSubscriptionRequestsOutput, error)
	ListSubscriptionRequestsWithContext(aws.Context, *datazone.ListSubscriptionRequestsInput, ...request.Option) (*datazone.ListSubscriptionRequestsOutput, error)
	ListSubscriptionRequestsRequest(*datazone.ListSubscriptionRequestsInput) (*request.Request, *datazone.ListSubscriptionRequestsOutput)

	ListSubscriptionRequestsPages(*datazone.ListSubscriptionRequestsInput, func(*datazone.ListSubscriptionRequestsOutput, bool) bool) error
	ListSubscriptionRequestsPagesWithContext(aws.Context, *datazone.ListSubscriptionRequestsInput, func(*datazone.ListSubscriptionRequestsOutput, bool) bool, ...request.Option) error

	ListSubscriptionTargets(*datazone.ListSubscriptionTargetsInput) (*datazone.ListSubscriptionTargetsOutput, error)
	ListSubscriptionTargetsWithContext(aws.Context, *datazone.ListSubscriptionTargetsInput, ...request.Option) (*datazone.ListSubscriptionTargetsOutput, error)
	ListSubscriptionTargetsRequest(*datazone.ListSubscriptionTargetsInput) (*request.Request, *datazone.ListSubscriptionTargetsOutput)

	ListSubscriptionTargetsPages(*datazone.ListSubscriptionTargetsInput, func(*datazone.ListSubscriptionTargetsOutput, bool) bool) error
	ListSubscriptionTargetsPagesWithContext(aws.Context, *datazone.ListSubscriptionTargetsInput, func(*datazone.ListSubscriptionTargetsOutput, bool) bool, ...request.Option) error

	ListSubscriptions(*datazone.ListSubscriptionsInput) (*datazone.ListSubscriptionsOutput, error)
	ListSubscriptionsWithContext(aws.Context, *datazone.ListSubscriptionsInput, ...request.Option) (*datazone.ListSubscriptionsOutput, error)
	ListSubscriptionsRequest(*datazone.ListSubscriptionsInput) (*request.Request, *datazone.ListSubscriptionsOutput)

	ListSubscriptionsPages(*datazone.ListSubscriptionsInput, func(*datazone.ListSubscriptionsOutput, bool) bool) error
	ListSubscriptionsPagesWithContext(aws.Context, *datazone.ListSubscriptionsInput, func(*datazone.ListSubscriptionsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*datazone.ListTagsForResourceInput) (*datazone.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *datazone.ListTagsForResourceInput, ...request.Option) (*datazone.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*datazone.ListTagsForResourceInput) (*request.Request, *datazone.ListTagsForResourceOutput)

	ListTimeSeriesDataPoints(*datazone.ListTimeSeriesDataPointsInput) (*datazone.ListTimeSeriesDataPointsOutput, error)
	ListTimeSeriesDataPointsWithContext(aws.Context, *datazone.ListTimeSeriesDataPointsInput, ...request.Option) (*datazone.ListTimeSeriesDataPointsOutput, error)
	ListTimeSeriesDataPointsRequest(*datazone.ListTimeSeriesDataPointsInput) (*request.Request, *datazone.ListTimeSeriesDataPointsOutput)

	ListTimeSeriesDataPointsPages(*datazone.ListTimeSeriesDataPointsInput, func(*datazone.ListTimeSeriesDataPointsOutput, bool) bool) error
	ListTimeSeriesDataPointsPagesWithContext(aws.Context, *datazone.ListTimeSeriesDataPointsInput, func(*datazone.ListTimeSeriesDataPointsOutput, bool) bool, ...request.Option) error

	PostTimeSeriesDataPoints(*datazone.PostTimeSeriesDataPointsInput) (*datazone.PostTimeSeriesDataPointsOutput, error)
	PostTimeSeriesDataPointsWithContext(aws.Context, *datazone.PostTimeSeriesDataPointsInput, ...request.Option) (*datazone.PostTimeSeriesDataPointsOutput, error)
	PostTimeSeriesDataPointsRequest(*datazone.PostTimeSeriesDataPointsInput) (*request.Request, *datazone.PostTimeSeriesDataPointsOutput)

	PutEnvironmentBlueprintConfiguration(*datazone.PutEnvironmentBlueprintConfigurationInput) (*datazone.PutEnvironmentBlueprintConfigurationOutput, error)
	PutEnvironmentBlueprintConfigurationWithContext(aws.Context, *datazone.PutEnvironmentBlueprintConfigurationInput, ...request.Option) (*datazone.PutEnvironmentBlueprintConfigurationOutput, error)
	PutEnvironmentBlueprintConfigurationRequest(*datazone.PutEnvironmentBlueprintConfigurationInput) (*request.Request, *datazone.PutEnvironmentBlueprintConfigurationOutput)

	RejectPredictions(*datazone.RejectPredictionsInput) (*datazone.RejectPredictionsOutput, error)
	RejectPredictionsWithContext(aws.Context, *datazone.RejectPredictionsInput, ...request.Option) (*datazone.RejectPredictionsOutput, error)
	RejectPredictionsRequest(*datazone.RejectPredictionsInput) (*request.Request, *datazone.RejectPredictionsOutput)

	RejectSubscriptionRequest(*datazone.RejectSubscriptionRequestInput) (*datazone.RejectSubscriptionRequestOutput, error)
	RejectSubscriptionRequestWithContext(aws.Context, *datazone.RejectSubscriptionRequestInput, ...request.Option) (*datazone.RejectSubscriptionRequestOutput, error)
	RejectSubscriptionRequestRequest(*datazone.RejectSubscriptionRequestInput) (*request.Request, *datazone.RejectSubscriptionRequestOutput)

	RevokeSubscription(*datazone.RevokeSubscriptionInput) (*datazone.RevokeSubscriptionOutput, error)
	RevokeSubscriptionWithContext(aws.Context, *datazone.RevokeSubscriptionInput, ...request.Option) (*datazone.RevokeSubscriptionOutput, error)
	RevokeSubscriptionRequest(*datazone.RevokeSubscriptionInput) (*request.Request, *datazone.RevokeSubscriptionOutput)

	Search(*datazone.SearchInput) (*datazone.SearchOutput, error)
	SearchWithContext(aws.Context, *datazone.SearchInput, ...request.Option) (*datazone.SearchOutput, error)
	SearchRequest(*datazone.SearchInput) (*request.Request, *datazone.SearchOutput)

	SearchPages(*datazone.SearchInput, func(*datazone.SearchOutput, bool) bool) error
	SearchPagesWithContext(aws.Context, *datazone.SearchInput, func(*datazone.SearchOutput, bool) bool, ...request.Option) error

	SearchGroupProfiles(*datazone.SearchGroupProfilesInput) (*datazone.SearchGroupProfilesOutput, error)
	SearchGroupProfilesWithContext(aws.Context, *datazone.SearchGroupProfilesInput, ...request.Option) (*datazone.SearchGroupProfilesOutput, error)
	SearchGroupProfilesRequest(*datazone.SearchGroupProfilesInput) (*request.Request, *datazone.SearchGroupProfilesOutput)

	SearchGroupProfilesPages(*datazone.SearchGroupProfilesInput, func(*datazone.SearchGroupProfilesOutput, bool) bool) error
	SearchGroupProfilesPagesWithContext(aws.Context, *datazone.SearchGroupProfilesInput, func(*datazone.SearchGroupProfilesOutput, bool) bool, ...request.Option) error

	SearchListings(*datazone.SearchListingsInput) (*datazone.SearchListingsOutput, error)
	SearchListingsWithContext(aws.Context, *datazone.SearchListingsInput, ...request.Option) (*datazone.SearchListingsOutput, error)
	SearchListingsRequest(*datazone.SearchListingsInput) (*request.Request, *datazone.SearchListingsOutput)

	SearchListingsPages(*datazone.SearchListingsInput, func(*datazone.SearchListingsOutput, bool) bool) error
	SearchListingsPagesWithContext(aws.Context, *datazone.SearchListingsInput, func(*datazone.SearchListingsOutput, bool) bool, ...request.Option) error

	SearchTypes(*datazone.SearchTypesInput) (*datazone.SearchTypesOutput, error)
	SearchTypesWithContext(aws.Context, *datazone.SearchTypesInput, ...request.Option) (*datazone.SearchTypesOutput, error)
	SearchTypesRequest(*datazone.SearchTypesInput) (*request.Request, *datazone.SearchTypesOutput)

	SearchTypesPages(*datazone.SearchTypesInput, func(*datazone.SearchTypesOutput, bool) bool) error
	SearchTypesPagesWithContext(aws.Context, *datazone.SearchTypesInput, func(*datazone.SearchTypesOutput, bool) bool, ...request.Option) error

	SearchUserProfiles(*datazone.SearchUserProfilesInput) (*datazone.SearchUserProfilesOutput, error)
	SearchUserProfilesWithContext(aws.Context, *datazone.SearchUserProfilesInput, ...request.Option) (*datazone.SearchUserProfilesOutput, error)
	SearchUserProfilesRequest(*datazone.SearchUserProfilesInput) (*request.Request, *datazone.SearchUserProfilesOutput)

	SearchUserProfilesPages(*datazone.SearchUserProfilesInput, func(*datazone.SearchUserProfilesOutput, bool) bool) error
	SearchUserProfilesPagesWithContext(aws.Context, *datazone.SearchUserProfilesInput, func(*datazone.SearchUserProfilesOutput, bool) bool, ...request.Option) error

	StartDataSourceRun(*datazone.StartDataSourceRunInput) (*datazone.StartDataSourceRunOutput, error)
	StartDataSourceRunWithContext(aws.Context, *datazone.StartDataSourceRunInput, ...request.Option) (*datazone.StartDataSourceRunOutput, error)
	StartDataSourceRunRequest(*datazone.StartDataSourceRunInput) (*request.Request, *datazone.StartDataSourceRunOutput)

	StartMetadataGenerationRun(*datazone.StartMetadataGenerationRunInput) (*datazone.StartMetadataGenerationRunOutput, error)
	StartMetadataGenerationRunWithContext(aws.Context, *datazone.StartMetadataGenerationRunInput, ...request.Option) (*datazone.StartMetadataGenerationRunOutput, error)
	StartMetadataGenerationRunRequest(*datazone.StartMetadataGenerationRunInput) (*request.Request, *datazone.StartMetadataGenerationRunOutput)

	TagResource(*datazone.TagResourceInput) (*datazone.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *datazone.TagResourceInput, ...request.Option) (*datazone.TagResourceOutput, error)
	TagResourceRequest(*datazone.TagResourceInput) (*request.Request, *datazone.TagResourceOutput)

	UntagResource(*datazone.UntagResourceInput) (*datazone.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *datazone.UntagResourceInput, ...request.Option) (*datazone.UntagResourceOutput, error)
	UntagResourceRequest(*datazone.UntagResourceInput) (*request.Request, *datazone.UntagResourceOutput)

	UpdateDataSource(*datazone.UpdateDataSourceInput) (*datazone.UpdateDataSourceOutput, error)
	UpdateDataSourceWithContext(aws.Context, *datazone.UpdateDataSourceInput, ...request.Option) (*datazone.UpdateDataSourceOutput, error)
	UpdateDataSourceRequest(*datazone.UpdateDataSourceInput) (*request.Request, *datazone.UpdateDataSourceOutput)

	UpdateDomain(*datazone.UpdateDomainInput) (*datazone.UpdateDomainOutput, error)
	UpdateDomainWithContext(aws.Context, *datazone.UpdateDomainInput, ...request.Option) (*datazone.UpdateDomainOutput, error)
	UpdateDomainRequest(*datazone.UpdateDomainInput) (*request.Request, *datazone.UpdateDomainOutput)

	UpdateEnvironment(*datazone.UpdateEnvironmentInput) (*datazone.UpdateEnvironmentOutput, error)
	UpdateEnvironmentWithContext(aws.Context, *datazone.UpdateEnvironmentInput, ...request.Option) (*datazone.UpdateEnvironmentOutput, error)
	UpdateEnvironmentRequest(*datazone.UpdateEnvironmentInput) (*request.Request, *datazone.UpdateEnvironmentOutput)

	UpdateEnvironmentProfile(*datazone.UpdateEnvironmentProfileInput) (*datazone.UpdateEnvironmentProfileOutput, error)
	UpdateEnvironmentProfileWithContext(aws.Context, *datazone.UpdateEnvironmentProfileInput, ...request.Option) (*datazone.UpdateEnvironmentProfileOutput, error)
	UpdateEnvironmentProfileRequest(*datazone.UpdateEnvironmentProfileInput) (*request.Request, *datazone.UpdateEnvironmentProfileOutput)

	UpdateGlossary(*datazone.UpdateGlossaryInput) (*datazone.UpdateGlossaryOutput, error)
	UpdateGlossaryWithContext(aws.Context, *datazone.UpdateGlossaryInput, ...request.Option) (*datazone.UpdateGlossaryOutput, error)
	UpdateGlossaryRequest(*datazone.UpdateGlossaryInput) (*request.Request, *datazone.UpdateGlossaryOutput)

	UpdateGlossaryTerm(*datazone.UpdateGlossaryTermInput) (*datazone.UpdateGlossaryTermOutput, error)
	UpdateGlossaryTermWithContext(aws.Context, *datazone.UpdateGlossaryTermInput, ...request.Option) (*datazone.UpdateGlossaryTermOutput, error)
	UpdateGlossaryTermRequest(*datazone.UpdateGlossaryTermInput) (*request.Request, *datazone.UpdateGlossaryTermOutput)

	UpdateGroupProfile(*datazone.UpdateGroupProfileInput) (*datazone.UpdateGroupProfileOutput, error)
	UpdateGroupProfileWithContext(aws.Context, *datazone.UpdateGroupProfileInput, ...request.Option) (*datazone.UpdateGroupProfileOutput, error)
	UpdateGroupProfileRequest(*datazone.UpdateGroupProfileInput) (*request.Request, *datazone.UpdateGroupProfileOutput)

	UpdateProject(*datazone.UpdateProjectInput) (*datazone.UpdateProjectOutput, error)
	UpdateProjectWithContext(aws.Context, *datazone.UpdateProjectInput, ...request.Option) (*datazone.UpdateProjectOutput, error)
	UpdateProjectRequest(*datazone.UpdateProjectInput) (*request.Request, *datazone.UpdateProjectOutput)

	UpdateSubscriptionGrantStatus(*datazone.UpdateSubscriptionGrantStatusInput) (*datazone.UpdateSubscriptionGrantStatusOutput, error)
	UpdateSubscriptionGrantStatusWithContext(aws.Context, *datazone.UpdateSubscriptionGrantStatusInput, ...request.Option) (*datazone.UpdateSubscriptionGrantStatusOutput, error)
	UpdateSubscriptionGrantStatusRequest(*datazone.UpdateSubscriptionGrantStatusInput) (*request.Request, *datazone.UpdateSubscriptionGrantStatusOutput)

	UpdateSubscriptionRequest(*datazone.UpdateSubscriptionRequestInput) (*datazone.UpdateSubscriptionRequestOutput, error)
	UpdateSubscriptionRequestWithContext(aws.Context, *datazone.UpdateSubscriptionRequestInput, ...request.Option) (*datazone.UpdateSubscriptionRequestOutput, error)
	UpdateSubscriptionRequestRequest(*datazone.UpdateSubscriptionRequestInput) (*request.Request, *datazone.UpdateSubscriptionRequestOutput)

	UpdateSubscriptionTarget(*datazone.UpdateSubscriptionTargetInput) (*datazone.UpdateSubscriptionTargetOutput, error)
	UpdateSubscriptionTargetWithContext(aws.Context, *datazone.UpdateSubscriptionTargetInput, ...request.Option) (*datazone.UpdateSubscriptionTargetOutput, error)
	UpdateSubscriptionTargetRequest(*datazone.UpdateSubscriptionTargetInput) (*request.Request, *datazone.UpdateSubscriptionTargetOutput)

	UpdateUserProfile(*datazone.UpdateUserProfileInput) (*datazone.UpdateUserProfileOutput, error)
	UpdateUserProfileWithContext(aws.Context, *datazone.UpdateUserProfileInput, ...request.Option) (*datazone.UpdateUserProfileOutput, error)
	UpdateUserProfileRequest(*datazone.UpdateUserProfileInput) (*request.Request, *datazone.UpdateUserProfileOutput)
}

var _ DataZoneAPI = (*datazone.DataZone)(nil)
