//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package keyvault

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/keyvault/mgmt/2022-07-01/keyvault"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AccessPolicyUpdateKind = original.AccessPolicyUpdateKind

const (
	Add     AccessPolicyUpdateKind = original.Add
	Remove  AccessPolicyUpdateKind = original.Remove
	Replace AccessPolicyUpdateKind = original.Replace
)

type ActionsRequired = original.ActionsRequired

const (
	None ActionsRequired = original.None
)

type ActivationStatus = original.ActivationStatus

const (
	Active       ActivationStatus = original.Active
	Failed       ActivationStatus = original.Failed
	NotActivated ActivationStatus = original.NotActivated
	Unknown      ActivationStatus = original.Unknown
)

type CertificatePermissions = original.CertificatePermissions

const (
	All            CertificatePermissions = original.All
	Backup         CertificatePermissions = original.Backup
	Create         CertificatePermissions = original.Create
	Delete         CertificatePermissions = original.Delete
	Deleteissuers  CertificatePermissions = original.Deleteissuers
	Get            CertificatePermissions = original.Get
	Getissuers     CertificatePermissions = original.Getissuers
	Import         CertificatePermissions = original.Import
	List           CertificatePermissions = original.List
	Listissuers    CertificatePermissions = original.Listissuers
	Managecontacts CertificatePermissions = original.Managecontacts
	Manageissuers  CertificatePermissions = original.Manageissuers
	Purge          CertificatePermissions = original.Purge
	Recover        CertificatePermissions = original.Recover
	Restore        CertificatePermissions = original.Restore
	Setissuers     CertificatePermissions = original.Setissuers
	Update         CertificatePermissions = original.Update
)

type CreateMode = original.CreateMode

const (
	CreateModeDefault CreateMode = original.CreateModeDefault
	CreateModeRecover CreateMode = original.CreateModeRecover
)

type DeletionRecoveryLevel = original.DeletionRecoveryLevel

const (
	Purgeable                        DeletionRecoveryLevel = original.Purgeable
	Recoverable                      DeletionRecoveryLevel = original.Recoverable
	RecoverableProtectedSubscription DeletionRecoveryLevel = original.RecoverableProtectedSubscription
	RecoverablePurgeable             DeletionRecoveryLevel = original.RecoverablePurgeable
)

type IdentityType = original.IdentityType

const (
	IdentityTypeApplication     IdentityType = original.IdentityTypeApplication
	IdentityTypeKey             IdentityType = original.IdentityTypeKey
	IdentityTypeManagedIdentity IdentityType = original.IdentityTypeManagedIdentity
	IdentityTypeUser            IdentityType = original.IdentityTypeUser
)

type JSONWebKeyCurveName = original.JSONWebKeyCurveName

const (
	P256  JSONWebKeyCurveName = original.P256
	P256K JSONWebKeyCurveName = original.P256K
	P384  JSONWebKeyCurveName = original.P384
	P521  JSONWebKeyCurveName = original.P521
)

type JSONWebKeyOperation = original.JSONWebKeyOperation

const (
	JSONWebKeyOperationDecrypt   JSONWebKeyOperation = original.JSONWebKeyOperationDecrypt
	JSONWebKeyOperationEncrypt   JSONWebKeyOperation = original.JSONWebKeyOperationEncrypt
	JSONWebKeyOperationImport    JSONWebKeyOperation = original.JSONWebKeyOperationImport
	JSONWebKeyOperationRelease   JSONWebKeyOperation = original.JSONWebKeyOperationRelease
	JSONWebKeyOperationSign      JSONWebKeyOperation = original.JSONWebKeyOperationSign
	JSONWebKeyOperationUnwrapKey JSONWebKeyOperation = original.JSONWebKeyOperationUnwrapKey
	JSONWebKeyOperationVerify    JSONWebKeyOperation = original.JSONWebKeyOperationVerify
	JSONWebKeyOperationWrapKey   JSONWebKeyOperation = original.JSONWebKeyOperationWrapKey
)

type JSONWebKeyType = original.JSONWebKeyType

const (
	EC     JSONWebKeyType = original.EC
	ECHSM  JSONWebKeyType = original.ECHSM
	RSA    JSONWebKeyType = original.RSA
	RSAHSM JSONWebKeyType = original.RSAHSM
)

type KeyPermissions = original.KeyPermissions

const (
	KeyPermissionsAll               KeyPermissions = original.KeyPermissionsAll
	KeyPermissionsBackup            KeyPermissions = original.KeyPermissionsBackup
	KeyPermissionsCreate            KeyPermissions = original.KeyPermissionsCreate
	KeyPermissionsDecrypt           KeyPermissions = original.KeyPermissionsDecrypt
	KeyPermissionsDelete            KeyPermissions = original.KeyPermissionsDelete
	KeyPermissionsEncrypt           KeyPermissions = original.KeyPermissionsEncrypt
	KeyPermissionsGet               KeyPermissions = original.KeyPermissionsGet
	KeyPermissionsGetrotationpolicy KeyPermissions = original.KeyPermissionsGetrotationpolicy
	KeyPermissionsImport            KeyPermissions = original.KeyPermissionsImport
	KeyPermissionsList              KeyPermissions = original.KeyPermissionsList
	KeyPermissionsPurge             KeyPermissions = original.KeyPermissionsPurge
	KeyPermissionsRecover           KeyPermissions = original.KeyPermissionsRecover
	KeyPermissionsRelease           KeyPermissions = original.KeyPermissionsRelease
	KeyPermissionsRestore           KeyPermissions = original.KeyPermissionsRestore
	KeyPermissionsRotate            KeyPermissions = original.KeyPermissionsRotate
	KeyPermissionsSetrotationpolicy KeyPermissions = original.KeyPermissionsSetrotationpolicy
	KeyPermissionsSign              KeyPermissions = original.KeyPermissionsSign
	KeyPermissionsUnwrapKey         KeyPermissions = original.KeyPermissionsUnwrapKey
	KeyPermissionsUpdate            KeyPermissions = original.KeyPermissionsUpdate
	KeyPermissionsVerify            KeyPermissions = original.KeyPermissionsVerify
	KeyPermissionsWrapKey           KeyPermissions = original.KeyPermissionsWrapKey
)

type KeyRotationPolicyActionType = original.KeyRotationPolicyActionType

const (
	Notify KeyRotationPolicyActionType = original.Notify
	Rotate KeyRotationPolicyActionType = original.Rotate
)

type ManagedHsmSkuName = original.ManagedHsmSkuName

const (
	CustomB32  ManagedHsmSkuName = original.CustomB32
	StandardB1 ManagedHsmSkuName = original.StandardB1
)

type NetworkRuleAction = original.NetworkRuleAction

const (
	Allow NetworkRuleAction = original.Allow
	Deny  NetworkRuleAction = original.Deny
)

type NetworkRuleBypassOptions = original.NetworkRuleBypassOptions

const (
	NetworkRuleBypassOptionsAzureServices NetworkRuleBypassOptions = original.NetworkRuleBypassOptionsAzureServices
	NetworkRuleBypassOptionsNone          NetworkRuleBypassOptions = original.NetworkRuleBypassOptionsNone
)

type PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningState

const (
	PrivateEndpointConnectionProvisioningStateCreating     PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateCreating
	PrivateEndpointConnectionProvisioningStateDeleting     PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateDeleting
	PrivateEndpointConnectionProvisioningStateDisconnected PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateDisconnected
	PrivateEndpointConnectionProvisioningStateFailed       PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateFailed
	PrivateEndpointConnectionProvisioningStateSucceeded    PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateSucceeded
	PrivateEndpointConnectionProvisioningStateUpdating     PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateUpdating
)

type PrivateEndpointServiceConnectionStatus = original.PrivateEndpointServiceConnectionStatus

const (
	Approved     PrivateEndpointServiceConnectionStatus = original.Approved
	Disconnected PrivateEndpointServiceConnectionStatus = original.Disconnected
	Pending      PrivateEndpointServiceConnectionStatus = original.Pending
	Rejected     PrivateEndpointServiceConnectionStatus = original.Rejected
)

type ProvisioningState = original.ProvisioningState

const (
	ProvisioningStateActivated             ProvisioningState = original.ProvisioningStateActivated
	ProvisioningStateDeleting              ProvisioningState = original.ProvisioningStateDeleting
	ProvisioningStateFailed                ProvisioningState = original.ProvisioningStateFailed
	ProvisioningStateProvisioning          ProvisioningState = original.ProvisioningStateProvisioning
	ProvisioningStateRestoring             ProvisioningState = original.ProvisioningStateRestoring
	ProvisioningStateSecurityDomainRestore ProvisioningState = original.ProvisioningStateSecurityDomainRestore
	ProvisioningStateSucceeded             ProvisioningState = original.ProvisioningStateSucceeded
	ProvisioningStateUpdating              ProvisioningState = original.ProvisioningStateUpdating
)

type PublicNetworkAccess = original.PublicNetworkAccess

const (
	Disabled PublicNetworkAccess = original.Disabled
	Enabled  PublicNetworkAccess = original.Enabled
)

type ReasonForKeyVault = original.ReasonForKeyVault

const (
	AccountNameInvalid ReasonForKeyVault = original.AccountNameInvalid
	AlreadyExists      ReasonForKeyVault = original.AlreadyExists
)

type ReasonForManagedHsm = original.ReasonForManagedHsm

const (
	ReasonForManagedHsmAccountNameInvalid ReasonForManagedHsm = original.ReasonForManagedHsmAccountNameInvalid
	ReasonForManagedHsmAlreadyExists      ReasonForManagedHsm = original.ReasonForManagedHsmAlreadyExists
)

type SecretPermissions = original.SecretPermissions

const (
	SecretPermissionsAll     SecretPermissions = original.SecretPermissionsAll
	SecretPermissionsBackup  SecretPermissions = original.SecretPermissionsBackup
	SecretPermissionsDelete  SecretPermissions = original.SecretPermissionsDelete
	SecretPermissionsGet     SecretPermissions = original.SecretPermissionsGet
	SecretPermissionsList    SecretPermissions = original.SecretPermissionsList
	SecretPermissionsPurge   SecretPermissions = original.SecretPermissionsPurge
	SecretPermissionsRecover SecretPermissions = original.SecretPermissionsRecover
	SecretPermissionsRestore SecretPermissions = original.SecretPermissionsRestore
	SecretPermissionsSet     SecretPermissions = original.SecretPermissionsSet
)

type SkuName = original.SkuName

const (
	Premium  SkuName = original.Premium
	Standard SkuName = original.Standard
)

type StoragePermissions = original.StoragePermissions

const (
	StoragePermissionsAll           StoragePermissions = original.StoragePermissionsAll
	StoragePermissionsBackup        StoragePermissions = original.StoragePermissionsBackup
	StoragePermissionsDelete        StoragePermissions = original.StoragePermissionsDelete
	StoragePermissionsDeletesas     StoragePermissions = original.StoragePermissionsDeletesas
	StoragePermissionsGet           StoragePermissions = original.StoragePermissionsGet
	StoragePermissionsGetsas        StoragePermissions = original.StoragePermissionsGetsas
	StoragePermissionsList          StoragePermissions = original.StoragePermissionsList
	StoragePermissionsListsas       StoragePermissions = original.StoragePermissionsListsas
	StoragePermissionsPurge         StoragePermissions = original.StoragePermissionsPurge
	StoragePermissionsRecover       StoragePermissions = original.StoragePermissionsRecover
	StoragePermissionsRegeneratekey StoragePermissions = original.StoragePermissionsRegeneratekey
	StoragePermissionsRestore       StoragePermissions = original.StoragePermissionsRestore
	StoragePermissionsSet           StoragePermissions = original.StoragePermissionsSet
	StoragePermissionsSetsas        StoragePermissions = original.StoragePermissionsSetsas
	StoragePermissionsUpdate        StoragePermissions = original.StoragePermissionsUpdate
)

type VaultProvisioningState = original.VaultProvisioningState

const (
	RegisteringDNS VaultProvisioningState = original.RegisteringDNS
	Succeeded      VaultProvisioningState = original.Succeeded
)

type AccessPolicyEntry = original.AccessPolicyEntry
type Action = original.Action
type Attributes = original.Attributes
type BaseClient = original.BaseClient
type CheckMhsmNameAvailabilityParameters = original.CheckMhsmNameAvailabilityParameters
type CheckMhsmNameAvailabilityResult = original.CheckMhsmNameAvailabilityResult
type CheckNameAvailabilityResult = original.CheckNameAvailabilityResult
type CloudError = original.CloudError
type CloudErrorBody = original.CloudErrorBody
type DeletedManagedHsm = original.DeletedManagedHsm
type DeletedManagedHsmListResult = original.DeletedManagedHsmListResult
type DeletedManagedHsmListResultIterator = original.DeletedManagedHsmListResultIterator
type DeletedManagedHsmListResultPage = original.DeletedManagedHsmListResultPage
type DeletedManagedHsmProperties = original.DeletedManagedHsmProperties
type DeletedVault = original.DeletedVault
type DeletedVaultListResult = original.DeletedVaultListResult
type DeletedVaultListResultIterator = original.DeletedVaultListResultIterator
type DeletedVaultListResultPage = original.DeletedVaultListResultPage
type DeletedVaultProperties = original.DeletedVaultProperties
type DimensionProperties = original.DimensionProperties
type Error = original.Error
type IPRule = original.IPRule
type Key = original.Key
type KeyAttributes = original.KeyAttributes
type KeyCreateParameters = original.KeyCreateParameters
type KeyListResult = original.KeyListResult
type KeyListResultIterator = original.KeyListResultIterator
type KeyListResultPage = original.KeyListResultPage
type KeyProperties = original.KeyProperties
type KeyReleasePolicy = original.KeyReleasePolicy
type KeyRotationPolicyAttributes = original.KeyRotationPolicyAttributes
type KeysClient = original.KeysClient
type LifetimeAction = original.LifetimeAction
type LogSpecification = original.LogSpecification
type MHSMIPRule = original.MHSMIPRule
type MHSMNetworkRuleSet = original.MHSMNetworkRuleSet
type MHSMPrivateEndpoint = original.MHSMPrivateEndpoint
type MHSMPrivateEndpointConnection = original.MHSMPrivateEndpointConnection
type MHSMPrivateEndpointConnectionItem = original.MHSMPrivateEndpointConnectionItem
type MHSMPrivateEndpointConnectionProperties = original.MHSMPrivateEndpointConnectionProperties
type MHSMPrivateEndpointConnectionsClient = original.MHSMPrivateEndpointConnectionsClient
type MHSMPrivateEndpointConnectionsDeleteFuture = original.MHSMPrivateEndpointConnectionsDeleteFuture
type MHSMPrivateEndpointConnectionsListResult = original.MHSMPrivateEndpointConnectionsListResult
type MHSMPrivateEndpointConnectionsListResultIterator = original.MHSMPrivateEndpointConnectionsListResultIterator
type MHSMPrivateEndpointConnectionsListResultPage = original.MHSMPrivateEndpointConnectionsListResultPage
type MHSMPrivateLinkResource = original.MHSMPrivateLinkResource
type MHSMPrivateLinkResourceListResult = original.MHSMPrivateLinkResourceListResult
type MHSMPrivateLinkResourceProperties = original.MHSMPrivateLinkResourceProperties
type MHSMPrivateLinkResourcesClient = original.MHSMPrivateLinkResourcesClient
type MHSMPrivateLinkServiceConnectionState = original.MHSMPrivateLinkServiceConnectionState
type MHSMVirtualNetworkRule = original.MHSMVirtualNetworkRule
type ManagedHSMSecurityDomainProperties = original.ManagedHSMSecurityDomainProperties
type ManagedHsm = original.ManagedHsm
type ManagedHsmError = original.ManagedHsmError
type ManagedHsmListResult = original.ManagedHsmListResult
type ManagedHsmListResultIterator = original.ManagedHsmListResultIterator
type ManagedHsmListResultPage = original.ManagedHsmListResultPage
type ManagedHsmProperties = original.ManagedHsmProperties
type ManagedHsmResource = original.ManagedHsmResource
type ManagedHsmSku = original.ManagedHsmSku
type ManagedHsmsClient = original.ManagedHsmsClient
type ManagedHsmsCreateOrUpdateFuture = original.ManagedHsmsCreateOrUpdateFuture
type ManagedHsmsDeleteFuture = original.ManagedHsmsDeleteFuture
type ManagedHsmsPurgeDeletedFuture = original.ManagedHsmsPurgeDeletedFuture
type ManagedHsmsUpdateFuture = original.ManagedHsmsUpdateFuture
type MetricSpecification = original.MetricSpecification
type NetworkRuleSet = original.NetworkRuleSet
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationProperties = original.OperationProperties
type OperationsClient = original.OperationsClient
type Permissions = original.Permissions
type PrivateEndpoint = original.PrivateEndpoint
type PrivateEndpointConnection = original.PrivateEndpointConnection
type PrivateEndpointConnectionItem = original.PrivateEndpointConnectionItem
type PrivateEndpointConnectionListResult = original.PrivateEndpointConnectionListResult
type PrivateEndpointConnectionListResultIterator = original.PrivateEndpointConnectionListResultIterator
type PrivateEndpointConnectionListResultPage = original.PrivateEndpointConnectionListResultPage
type PrivateEndpointConnectionProperties = original.PrivateEndpointConnectionProperties
type PrivateEndpointConnectionsClient = original.PrivateEndpointConnectionsClient
type PrivateEndpointConnectionsDeleteFuture = original.PrivateEndpointConnectionsDeleteFuture
type PrivateLinkResource = original.PrivateLinkResource
type PrivateLinkResourceListResult = original.PrivateLinkResourceListResult
type PrivateLinkResourceProperties = original.PrivateLinkResourceProperties
type PrivateLinkResourcesClient = original.PrivateLinkResourcesClient
type PrivateLinkServiceConnectionState = original.PrivateLinkServiceConnectionState
type Resource = original.Resource
type ResourceListResult = original.ResourceListResult
type ResourceListResultIterator = original.ResourceListResultIterator
type ResourceListResultPage = original.ResourceListResultPage
type RotationPolicy = original.RotationPolicy
type Secret = original.Secret
type SecretAttributes = original.SecretAttributes
type SecretCreateOrUpdateParameters = original.SecretCreateOrUpdateParameters
type SecretListResult = original.SecretListResult
type SecretListResultIterator = original.SecretListResultIterator
type SecretListResultPage = original.SecretListResultPage
type SecretPatchParameters = original.SecretPatchParameters
type SecretPatchProperties = original.SecretPatchProperties
type SecretProperties = original.SecretProperties
type SecretsClient = original.SecretsClient
type ServiceSpecification = original.ServiceSpecification
type Sku = original.Sku
type SystemData = original.SystemData
type Trigger = original.Trigger
type Vault = original.Vault
type VaultAccessPolicyParameters = original.VaultAccessPolicyParameters
type VaultAccessPolicyProperties = original.VaultAccessPolicyProperties
type VaultCheckNameAvailabilityParameters = original.VaultCheckNameAvailabilityParameters
type VaultCreateOrUpdateParameters = original.VaultCreateOrUpdateParameters
type VaultListResult = original.VaultListResult
type VaultListResultIterator = original.VaultListResultIterator
type VaultListResultPage = original.VaultListResultPage
type VaultPatchParameters = original.VaultPatchParameters
type VaultPatchProperties = original.VaultPatchProperties
type VaultProperties = original.VaultProperties
type VaultsClient = original.VaultsClient
type VaultsCreateOrUpdateFuture = original.VaultsCreateOrUpdateFuture
type VaultsPurgeDeletedFuture = original.VaultsPurgeDeletedFuture
type VirtualNetworkRule = original.VirtualNetworkRule

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewDeletedManagedHsmListResultIterator(page DeletedManagedHsmListResultPage) DeletedManagedHsmListResultIterator {
	return original.NewDeletedManagedHsmListResultIterator(page)
}
func NewDeletedManagedHsmListResultPage(cur DeletedManagedHsmListResult, getNextPage func(context.Context, DeletedManagedHsmListResult) (DeletedManagedHsmListResult, error)) DeletedManagedHsmListResultPage {
	return original.NewDeletedManagedHsmListResultPage(cur, getNextPage)
}
func NewDeletedVaultListResultIterator(page DeletedVaultListResultPage) DeletedVaultListResultIterator {
	return original.NewDeletedVaultListResultIterator(page)
}
func NewDeletedVaultListResultPage(cur DeletedVaultListResult, getNextPage func(context.Context, DeletedVaultListResult) (DeletedVaultListResult, error)) DeletedVaultListResultPage {
	return original.NewDeletedVaultListResultPage(cur, getNextPage)
}
func NewKeyListResultIterator(page KeyListResultPage) KeyListResultIterator {
	return original.NewKeyListResultIterator(page)
}
func NewKeyListResultPage(cur KeyListResult, getNextPage func(context.Context, KeyListResult) (KeyListResult, error)) KeyListResultPage {
	return original.NewKeyListResultPage(cur, getNextPage)
}
func NewKeysClient(subscriptionID string) KeysClient {
	return original.NewKeysClient(subscriptionID)
}
func NewKeysClientWithBaseURI(baseURI string, subscriptionID string) KeysClient {
	return original.NewKeysClientWithBaseURI(baseURI, subscriptionID)
}
func NewMHSMPrivateEndpointConnectionsClient(subscriptionID string) MHSMPrivateEndpointConnectionsClient {
	return original.NewMHSMPrivateEndpointConnectionsClient(subscriptionID)
}
func NewMHSMPrivateEndpointConnectionsClientWithBaseURI(baseURI string, subscriptionID string) MHSMPrivateEndpointConnectionsClient {
	return original.NewMHSMPrivateEndpointConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewMHSMPrivateEndpointConnectionsListResultIterator(page MHSMPrivateEndpointConnectionsListResultPage) MHSMPrivateEndpointConnectionsListResultIterator {
	return original.NewMHSMPrivateEndpointConnectionsListResultIterator(page)
}
func NewMHSMPrivateEndpointConnectionsListResultPage(cur MHSMPrivateEndpointConnectionsListResult, getNextPage func(context.Context, MHSMPrivateEndpointConnectionsListResult) (MHSMPrivateEndpointConnectionsListResult, error)) MHSMPrivateEndpointConnectionsListResultPage {
	return original.NewMHSMPrivateEndpointConnectionsListResultPage(cur, getNextPage)
}
func NewMHSMPrivateLinkResourcesClient(subscriptionID string) MHSMPrivateLinkResourcesClient {
	return original.NewMHSMPrivateLinkResourcesClient(subscriptionID)
}
func NewMHSMPrivateLinkResourcesClientWithBaseURI(baseURI string, subscriptionID string) MHSMPrivateLinkResourcesClient {
	return original.NewMHSMPrivateLinkResourcesClientWithBaseURI(baseURI, subscriptionID)
}
func NewManagedHsmListResultIterator(page ManagedHsmListResultPage) ManagedHsmListResultIterator {
	return original.NewManagedHsmListResultIterator(page)
}
func NewManagedHsmListResultPage(cur ManagedHsmListResult, getNextPage func(context.Context, ManagedHsmListResult) (ManagedHsmListResult, error)) ManagedHsmListResultPage {
	return original.NewManagedHsmListResultPage(cur, getNextPage)
}
func NewManagedHsmsClient(subscriptionID string) ManagedHsmsClient {
	return original.NewManagedHsmsClient(subscriptionID)
}
func NewManagedHsmsClientWithBaseURI(baseURI string, subscriptionID string) ManagedHsmsClient {
	return original.NewManagedHsmsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return original.NewOperationListResultIterator(page)
}
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return original.NewOperationListResultPage(cur, getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateEndpointConnectionListResultIterator(page PrivateEndpointConnectionListResultPage) PrivateEndpointConnectionListResultIterator {
	return original.NewPrivateEndpointConnectionListResultIterator(page)
}
func NewPrivateEndpointConnectionListResultPage(cur PrivateEndpointConnectionListResult, getNextPage func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)) PrivateEndpointConnectionListResultPage {
	return original.NewPrivateEndpointConnectionListResultPage(cur, getNextPage)
}
func NewPrivateEndpointConnectionsClient(subscriptionID string) PrivateEndpointConnectionsClient {
	return original.NewPrivateEndpointConnectionsClient(subscriptionID)
}
func NewPrivateEndpointConnectionsClientWithBaseURI(baseURI string, subscriptionID string) PrivateEndpointConnectionsClient {
	return original.NewPrivateEndpointConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateLinkResourcesClient(subscriptionID string) PrivateLinkResourcesClient {
	return original.NewPrivateLinkResourcesClient(subscriptionID)
}
func NewPrivateLinkResourcesClientWithBaseURI(baseURI string, subscriptionID string) PrivateLinkResourcesClient {
	return original.NewPrivateLinkResourcesClientWithBaseURI(baseURI, subscriptionID)
}
func NewResourceListResultIterator(page ResourceListResultPage) ResourceListResultIterator {
	return original.NewResourceListResultIterator(page)
}
func NewResourceListResultPage(cur ResourceListResult, getNextPage func(context.Context, ResourceListResult) (ResourceListResult, error)) ResourceListResultPage {
	return original.NewResourceListResultPage(cur, getNextPage)
}
func NewSecretListResultIterator(page SecretListResultPage) SecretListResultIterator {
	return original.NewSecretListResultIterator(page)
}
func NewSecretListResultPage(cur SecretListResult, getNextPage func(context.Context, SecretListResult) (SecretListResult, error)) SecretListResultPage {
	return original.NewSecretListResultPage(cur, getNextPage)
}
func NewSecretsClient(subscriptionID string) SecretsClient {
	return original.NewSecretsClient(subscriptionID)
}
func NewSecretsClientWithBaseURI(baseURI string, subscriptionID string) SecretsClient {
	return original.NewSecretsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVaultListResultIterator(page VaultListResultPage) VaultListResultIterator {
	return original.NewVaultListResultIterator(page)
}
func NewVaultListResultPage(cur VaultListResult, getNextPage func(context.Context, VaultListResult) (VaultListResult, error)) VaultListResultPage {
	return original.NewVaultListResultPage(cur, getNextPage)
}
func NewVaultsClient(subscriptionID string) VaultsClient {
	return original.NewVaultsClient(subscriptionID)
}
func NewVaultsClientWithBaseURI(baseURI string, subscriptionID string) VaultsClient {
	return original.NewVaultsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAccessPolicyUpdateKindValues() []AccessPolicyUpdateKind {
	return original.PossibleAccessPolicyUpdateKindValues()
}
func PossibleActionsRequiredValues() []ActionsRequired {
	return original.PossibleActionsRequiredValues()
}
func PossibleActivationStatusValues() []ActivationStatus {
	return original.PossibleActivationStatusValues()
}
func PossibleCertificatePermissionsValues() []CertificatePermissions {
	return original.PossibleCertificatePermissionsValues()
}
func PossibleCreateModeValues() []CreateMode {
	return original.PossibleCreateModeValues()
}
func PossibleDeletionRecoveryLevelValues() []DeletionRecoveryLevel {
	return original.PossibleDeletionRecoveryLevelValues()
}
func PossibleIdentityTypeValues() []IdentityType {
	return original.PossibleIdentityTypeValues()
}
func PossibleJSONWebKeyCurveNameValues() []JSONWebKeyCurveName {
	return original.PossibleJSONWebKeyCurveNameValues()
}
func PossibleJSONWebKeyOperationValues() []JSONWebKeyOperation {
	return original.PossibleJSONWebKeyOperationValues()
}
func PossibleJSONWebKeyTypeValues() []JSONWebKeyType {
	return original.PossibleJSONWebKeyTypeValues()
}
func PossibleKeyPermissionsValues() []KeyPermissions {
	return original.PossibleKeyPermissionsValues()
}
func PossibleKeyRotationPolicyActionTypeValues() []KeyRotationPolicyActionType {
	return original.PossibleKeyRotationPolicyActionTypeValues()
}
func PossibleManagedHsmSkuNameValues() []ManagedHsmSkuName {
	return original.PossibleManagedHsmSkuNameValues()
}
func PossibleNetworkRuleActionValues() []NetworkRuleAction {
	return original.PossibleNetworkRuleActionValues()
}
func PossibleNetworkRuleBypassOptionsValues() []NetworkRuleBypassOptions {
	return original.PossibleNetworkRuleBypassOptionsValues()
}
func PossiblePrivateEndpointConnectionProvisioningStateValues() []PrivateEndpointConnectionProvisioningState {
	return original.PossiblePrivateEndpointConnectionProvisioningStateValues()
}
func PossiblePrivateEndpointServiceConnectionStatusValues() []PrivateEndpointServiceConnectionStatus {
	return original.PossiblePrivateEndpointServiceConnectionStatusValues()
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return original.PossiblePublicNetworkAccessValues()
}
func PossibleReasonForKeyVaultValues() []ReasonForKeyVault {
	return original.PossibleReasonForKeyVaultValues()
}
func PossibleReasonForManagedHsmValues() []ReasonForManagedHsm {
	return original.PossibleReasonForManagedHsmValues()
}
func PossibleSecretPermissionsValues() []SecretPermissions {
	return original.PossibleSecretPermissionsValues()
}
func PossibleSkuNameValues() []SkuName {
	return original.PossibleSkuNameValues()
}
func PossibleStoragePermissionsValues() []StoragePermissions {
	return original.PossibleStoragePermissionsValues()
}
func PossibleVaultProvisioningStateValues() []VaultProvisioningState {
	return original.PossibleVaultProvisioningStateValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/latest"
}
func Version() string {
	return original.Version()
}
