// Code generated by protoc-gen-go.
// source: google.golang.org/appengine/internal/search/search.proto
// DO NOT EDIT!

/*
Package search is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/appengine/internal/search/search.proto

It has these top-level messages:
	Scope
	Entry
	AccessControlList
	FieldValue
	Field
	FieldTypes
	IndexShardSettings
	FacetValue
	Facet
	DocumentMetadata
	Document
	SearchServiceError
	RequestStatus
	IndexSpec
	IndexMetadata
	IndexDocumentParams
	IndexDocumentRequest
	IndexDocumentResponse
	DeleteDocumentParams
	DeleteDocumentRequest
	DeleteDocumentResponse
	ListDocumentsParams
	ListDocumentsRequest
	ListDocumentsResponse
	ListIndexesParams
	ListIndexesRequest
	ListIndexesResponse
	DeleteSchemaParams
	DeleteSchemaRequest
	DeleteSchemaResponse
	SortSpec
	ScorerSpec
	FieldSpec
	FacetRange
	FacetRequestParam
	FacetAutoDetectParam
	FacetRequest
	FacetRefinement
	SearchParams
	SearchRequest
	FacetResultValue
	FacetResult
	SearchResult
	SearchResponse
*/
package search

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type Scope_Type int32

const (
	Scope_USER_BY_CANONICAL_ID    Scope_Type = 1
	Scope_USER_BY_EMAIL           Scope_Type = 2
	Scope_GROUP_BY_CANONICAL_ID   Scope_Type = 3
	Scope_GROUP_BY_EMAIL          Scope_Type = 4
	Scope_GROUP_BY_DOMAIN         Scope_Type = 5
	Scope_ALL_USERS               Scope_Type = 6
	Scope_ALL_AUTHENTICATED_USERS Scope_Type = 7
)

var Scope_Type_name = map[int32]string{
	1: "USER_BY_CANONICAL_ID",
	2: "USER_BY_EMAIL",
	3: "GROUP_BY_CANONICAL_ID",
	4: "GROUP_BY_EMAIL",
	5: "GROUP_BY_DOMAIN",
	6: "ALL_USERS",
	7: "ALL_AUTHENTICATED_USERS",
}
var Scope_Type_value = map[string]int32{
	"USER_BY_CANONICAL_ID":    1,
	"USER_BY_EMAIL":           2,
	"GROUP_BY_CANONICAL_ID":   3,
	"GROUP_BY_EMAIL":          4,
	"GROUP_BY_DOMAIN":         5,
	"ALL_USERS":               6,
	"ALL_AUTHENTICATED_USERS": 7,
}

func (x Scope_Type) Enum() *Scope_Type {
	p := new(Scope_Type)
	*p = x
	return p
}
func (x Scope_Type) String() string {
	return proto.EnumName(Scope_Type_name, int32(x))
}
func (x *Scope_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Scope_Type_value, data, "Scope_Type")
	if err != nil {
		return err
	}
	*x = Scope_Type(value)
	return nil
}
func (Scope_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0, 0} }

type Entry_Permission int32

const (
	Entry_READ         Entry_Permission = 1
	Entry_WRITE        Entry_Permission = 2
	Entry_FULL_CONTROL Entry_Permission = 3
)

var Entry_Permission_name = map[int32]string{
	1: "READ",
	2: "WRITE",
	3: "FULL_CONTROL",
}
var Entry_Permission_value = map[string]int32{
	"READ":         1,
	"WRITE":        2,
	"FULL_CONTROL": 3,
}

func (x Entry_Permission) Enum() *Entry_Permission {
	p := new(Entry_Permission)
	*p = x
	return p
}
func (x Entry_Permission) String() string {
	return proto.EnumName(Entry_Permission_name, int32(x))
}
func (x *Entry_Permission) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Entry_Permission_value, data, "Entry_Permission")
	if err != nil {
		return err
	}
	*x = Entry_Permission(value)
	return nil
}
func (Entry_Permission) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1, 0} }

type FieldValue_ContentType int32

const (
	FieldValue_TEXT   FieldValue_ContentType = 0
	FieldValue_HTML   FieldValue_ContentType = 1
	FieldValue_ATOM   FieldValue_ContentType = 2
	FieldValue_DATE   FieldValue_ContentType = 3
	FieldValue_NUMBER FieldValue_ContentType = 4
	FieldValue_GEO    FieldValue_ContentType = 5
)

var FieldValue_ContentType_name = map[int32]string{
	0: "TEXT",
	1: "HTML",
	2: "ATOM",
	3: "DATE",
	4: "NUMBER",
	5: "GEO",
}
var FieldValue_ContentType_value = map[string]int32{
	"TEXT":   0,
	"HTML":   1,
	"ATOM":   2,
	"DATE":   3,
	"NUMBER": 4,
	"GEO":    5,
}

func (x FieldValue_ContentType) Enum() *FieldValue_ContentType {
	p := new(FieldValue_ContentType)
	*p = x
	return p
}
func (x FieldValue_ContentType) String() string {
	return proto.EnumName(FieldValue_ContentType_name, int32(x))
}
func (x *FieldValue_ContentType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(FieldValue_ContentType_value, data, "FieldValue_ContentType")
	if err != nil {
		return err
	}
	*x = FieldValue_ContentType(value)
	return nil
}
func (FieldValue_ContentType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{3, 0} }

type FacetValue_ContentType int32

const (
	FacetValue_ATOM   FacetValue_ContentType = 2
	FacetValue_NUMBER FacetValue_ContentType = 4
)

var FacetValue_ContentType_name = map[int32]string{
	2: "ATOM",
	4: "NUMBER",
}
var FacetValue_ContentType_value = map[string]int32{
	"ATOM":   2,
	"NUMBER": 4,
}

func (x FacetValue_ContentType) Enum() *FacetValue_ContentType {
	p := new(FacetValue_ContentType)
	*p = x
	return p
}
func (x FacetValue_ContentType) String() string {
	return proto.EnumName(FacetValue_ContentType_name, int32(x))
}
func (x *FacetValue_ContentType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(FacetValue_ContentType_value, data, "FacetValue_ContentType")
	if err != nil {
		return err
	}
	*x = FacetValue_ContentType(value)
	return nil
}
func (FacetValue_ContentType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{7, 0} }

type Document_OrderIdSource int32

const (
	Document_DEFAULTED Document_OrderIdSource = 0
	Document_SUPPLIED  Document_OrderIdSource = 1
)

var Document_OrderIdSource_name = map[int32]string{
	0: "DEFAULTED",
	1: "SUPPLIED",
}
var Document_OrderIdSource_value = map[string]int32{
	"DEFAULTED": 0,
	"SUPPLIED":  1,
}

func (x Document_OrderIdSource) Enum() *Document_OrderIdSource {
	p := new(Document_OrderIdSource)
	*p = x
	return p
}
func (x Document_OrderIdSource) String() string {
	return proto.EnumName(Document_OrderIdSource_name, int32(x))
}
func (x *Document_OrderIdSource) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Document_OrderIdSource_value, data, "Document_OrderIdSource")
	if err != nil {
		return err
	}
	*x = Document_OrderIdSource(value)
	return nil
}
func (Document_OrderIdSource) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{10, 0} }

type Document_Storage int32

const (
	Document_DISK Document_Storage = 0
)

var Document_Storage_name = map[int32]string{
	0: "DISK",
}
var Document_Storage_value = map[string]int32{
	"DISK": 0,
}

func (x Document_Storage) Enum() *Document_Storage {
	p := new(Document_Storage)
	*p = x
	return p
}
func (x Document_Storage) String() string {
	return proto.EnumName(Document_Storage_name, int32(x))
}
func (x *Document_Storage) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Document_Storage_value, data, "Document_Storage")
	if err != nil {
		return err
	}
	*x = Document_Storage(value)
	return nil
}
func (Document_Storage) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{10, 1} }

type SearchServiceError_ErrorCode int32

const (
	SearchServiceError_OK                     SearchServiceError_ErrorCode = 0
	SearchServiceError_INVALID_REQUEST        SearchServiceError_ErrorCode = 1
	SearchServiceError_TRANSIENT_ERROR        SearchServiceError_ErrorCode = 2
	SearchServiceError_INTERNAL_ERROR         SearchServiceError_ErrorCode = 3
	SearchServiceError_PERMISSION_DENIED      SearchServiceError_ErrorCode = 4
	SearchServiceError_TIMEOUT                SearchServiceError_ErrorCode = 5
	SearchServiceError_CONCURRENT_TRANSACTION SearchServiceError_ErrorCode = 6
)

var SearchServiceError_ErrorCode_name = map[int32]string{
	0: "OK",
	1: "INVALID_REQUEST",
	2: "TRANSIENT_ERROR",
	3: "INTERNAL_ERROR",
	4: "PERMISSION_DENIED",
	5: "TIMEOUT",
	6: "CONCURRENT_TRANSACTION",
}
var SearchServiceError_ErrorCode_value = map[string]int32{
	"OK":                     0,
	"INVALID_REQUEST":        1,
	"TRANSIENT_ERROR":        2,
	"INTERNAL_ERROR":         3,
	"PERMISSION_DENIED":      4,
	"TIMEOUT":                5,
	"CONCURRENT_TRANSACTION": 6,
}

func (x SearchServiceError_ErrorCode) Enum() *SearchServiceError_ErrorCode {
	p := new(SearchServiceError_ErrorCode)
	*p = x
	return p
}
func (x SearchServiceError_ErrorCode) String() string {
	return proto.EnumName(SearchServiceError_ErrorCode_name, int32(x))
}
func (x *SearchServiceError_ErrorCode) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(SearchServiceError_ErrorCode_value, data, "SearchServiceError_ErrorCode")
	if err != nil {
		return err
	}
	*x = SearchServiceError_ErrorCode(value)
	return nil
}
func (SearchServiceError_ErrorCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{11, 0}
}

type IndexSpec_Consistency int32

const (
	IndexSpec_GLOBAL       IndexSpec_Consistency = 0
	IndexSpec_PER_DOCUMENT IndexSpec_Consistency = 1
)

var IndexSpec_Consistency_name = map[int32]string{
	0: "GLOBAL",
	1: "PER_DOCUMENT",
}
var IndexSpec_Consistency_value = map[string]int32{
	"GLOBAL":       0,
	"PER_DOCUMENT": 1,
}

func (x IndexSpec_Consistency) Enum() *IndexSpec_Consistency {
	p := new(IndexSpec_Consistency)
	*p = x
	return p
}
func (x IndexSpec_Consistency) String() string {
	return proto.EnumName(IndexSpec_Consistency_name, int32(x))
}
func (x *IndexSpec_Consistency) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(IndexSpec_Consistency_value, data, "IndexSpec_Consistency")
	if err != nil {
		return err
	}
	*x = IndexSpec_Consistency(value)
	return nil
}
func (IndexSpec_Consistency) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{13, 0} }

type IndexSpec_Source int32

const (
	IndexSpec_SEARCH        IndexSpec_Source = 0
	IndexSpec_DATASTORE     IndexSpec_Source = 1
	IndexSpec_CLOUD_STORAGE IndexSpec_Source = 2
)

var IndexSpec_Source_name = map[int32]string{
	0: "SEARCH",
	1: "DATASTORE",
	2: "CLOUD_STORAGE",
}
var IndexSpec_Source_value = map[string]int32{
	"SEARCH":        0,
	"DATASTORE":     1,
	"CLOUD_STORAGE": 2,
}

func (x IndexSpec_Source) Enum() *IndexSpec_Source {
	p := new(IndexSpec_Source)
	*p = x
	return p
}
func (x IndexSpec_Source) String() string {
	return proto.EnumName(IndexSpec_Source_name, int32(x))
}
func (x *IndexSpec_Source) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(IndexSpec_Source_value, data, "IndexSpec_Source")
	if err != nil {
		return err
	}
	*x = IndexSpec_Source(value)
	return nil
}
func (IndexSpec_Source) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{13, 1} }

type IndexSpec_Mode int32

const (
	IndexSpec_PRIORITY   IndexSpec_Mode = 0
	IndexSpec_BACKGROUND IndexSpec_Mode = 1
)

var IndexSpec_Mode_name = map[int32]string{
	0: "PRIORITY",
	1: "BACKGROUND",
}
var IndexSpec_Mode_value = map[string]int32{
	"PRIORITY":   0,
	"BACKGROUND": 1,
}

func (x IndexSpec_Mode) Enum() *IndexSpec_Mode {
	p := new(IndexSpec_Mode)
	*p = x
	return p
}
func (x IndexSpec_Mode) String() string {
	return proto.EnumName(IndexSpec_Mode_name, int32(x))
}
func (x *IndexSpec_Mode) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(IndexSpec_Mode_value, data, "IndexSpec_Mode")
	if err != nil {
		return err
	}
	*x = IndexSpec_Mode(value)
	return nil
}
func (IndexSpec_Mode) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{13, 2} }

type IndexDocumentParams_Freshness int32

const (
	IndexDocumentParams_SYNCHRONOUSLY   IndexDocumentParams_Freshness = 0
	IndexDocumentParams_WHEN_CONVENIENT IndexDocumentParams_Freshness = 1
)

var IndexDocumentParams_Freshness_name = map[int32]string{
	0: "SYNCHRONOUSLY",
	1: "WHEN_CONVENIENT",
}
var IndexDocumentParams_Freshness_value = map[string]int32{
	"SYNCHRONOUSLY":   0,
	"WHEN_CONVENIENT": 1,
}

func (x IndexDocumentParams_Freshness) Enum() *IndexDocumentParams_Freshness {
	p := new(IndexDocumentParams_Freshness)
	*p = x
	return p
}
func (x IndexDocumentParams_Freshness) String() string {
	return proto.EnumName(IndexDocumentParams_Freshness_name, int32(x))
}
func (x *IndexDocumentParams_Freshness) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(IndexDocumentParams_Freshness_value, data, "IndexDocumentParams_Freshness")
	if err != nil {
		return err
	}
	*x = IndexDocumentParams_Freshness(value)
	return nil
}
func (IndexDocumentParams_Freshness) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{15, 0}
}

type ScorerSpec_Scorer int32

const (
	ScorerSpec_RESCORING_MATCH_SCORER ScorerSpec_Scorer = 0
	ScorerSpec_MATCH_SCORER           ScorerSpec_Scorer = 2
)

var ScorerSpec_Scorer_name = map[int32]string{
	0: "RESCORING_MATCH_SCORER",
	2: "MATCH_SCORER",
}
var ScorerSpec_Scorer_value = map[string]int32{
	"RESCORING_MATCH_SCORER": 0,
	"MATCH_SCORER":           2,
}

func (x ScorerSpec_Scorer) Enum() *ScorerSpec_Scorer {
	p := new(ScorerSpec_Scorer)
	*p = x
	return p
}
func (x ScorerSpec_Scorer) String() string {
	return proto.EnumName(ScorerSpec_Scorer_name, int32(x))
}
func (x *ScorerSpec_Scorer) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ScorerSpec_Scorer_value, data, "ScorerSpec_Scorer")
	if err != nil {
		return err
	}
	*x = ScorerSpec_Scorer(value)
	return nil
}
func (ScorerSpec_Scorer) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{31, 0} }

type SearchParams_CursorType int32

const (
	SearchParams_NONE       SearchParams_CursorType = 0
	SearchParams_SINGLE     SearchParams_CursorType = 1
	SearchParams_PER_RESULT SearchParams_CursorType = 2
)

var SearchParams_CursorType_name = map[int32]string{
	0: "NONE",
	1: "SINGLE",
	2: "PER_RESULT",
}
var SearchParams_CursorType_value = map[string]int32{
	"NONE":       0,
	"SINGLE":     1,
	"PER_RESULT": 2,
}

func (x SearchParams_CursorType) Enum() *SearchParams_CursorType {
	p := new(SearchParams_CursorType)
	*p = x
	return p
}
func (x SearchParams_CursorType) String() string {
	return proto.EnumName(SearchParams_CursorType_name, int32(x))
}
func (x *SearchParams_CursorType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(SearchParams_CursorType_value, data, "SearchParams_CursorType")
	if err != nil {
		return err
	}
	*x = SearchParams_CursorType(value)
	return nil
}
func (SearchParams_CursorType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{38, 0} }

type SearchParams_ParsingMode int32

const (
	SearchParams_STRICT  SearchParams_ParsingMode = 0
	SearchParams_RELAXED SearchParams_ParsingMode = 1
)

var SearchParams_ParsingMode_name = map[int32]string{
	0: "STRICT",
	1: "RELAXED",
}
var SearchParams_ParsingMode_value = map[string]int32{
	"STRICT":  0,
	"RELAXED": 1,
}

func (x SearchParams_ParsingMode) Enum() *SearchParams_ParsingMode {
	p := new(SearchParams_ParsingMode)
	*p = x
	return p
}
func (x SearchParams_ParsingMode) String() string {
	return proto.EnumName(SearchParams_ParsingMode_name, int32(x))
}
func (x *SearchParams_ParsingMode) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(SearchParams_ParsingMode_value, data, "SearchParams_ParsingMode")
	if err != nil {
		return err
	}
	*x = SearchParams_ParsingMode(value)
	return nil
}
func (SearchParams_ParsingMode) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{38, 1} }

type Scope struct {
	Type             *Scope_Type `protobuf:"varint,1,opt,name=type,enum=search.Scope_Type" json:"type,omitempty"`
	Value            *string     `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *Scope) Reset()                    { *m = Scope{} }
func (m *Scope) String() string            { return proto.CompactTextString(m) }
func (*Scope) ProtoMessage()               {}
func (*Scope) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Scope) GetType() Scope_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Scope_USER_BY_CANONICAL_ID
}

func (m *Scope) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

type Entry struct {
	Scope            *Scope            `protobuf:"bytes,1,opt,name=scope" json:"scope,omitempty"`
	Permission       *Entry_Permission `protobuf:"varint,2,opt,name=permission,enum=search.Entry_Permission" json:"permission,omitempty"`
	DisplayName      *string           `protobuf:"bytes,3,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *Entry) Reset()                    { *m = Entry{} }
func (m *Entry) String() string            { return proto.CompactTextString(m) }
func (*Entry) ProtoMessage()               {}
func (*Entry) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *Entry) GetScope() *Scope {
	if m != nil {
		return m.Scope
	}
	return nil
}

func (m *Entry) GetPermission() Entry_Permission {
	if m != nil && m.Permission != nil {
		return *m.Permission
	}
	return Entry_READ
}

func (m *Entry) GetDisplayName() string {
	if m != nil && m.DisplayName != nil {
		return *m.DisplayName
	}
	return ""
}

type AccessControlList struct {
	Owner            *string  `protobuf:"bytes,1,opt,name=owner" json:"owner,omitempty"`
	Entries          []*Entry `protobuf:"bytes,2,rep,name=entries" json:"entries,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *AccessControlList) Reset()                    { *m = AccessControlList{} }
func (m *AccessControlList) String() string            { return proto.CompactTextString(m) }
func (*AccessControlList) ProtoMessage()               {}
func (*AccessControlList) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *AccessControlList) GetOwner() string {
	if m != nil && m.Owner != nil {
		return *m.Owner
	}
	return ""
}

func (m *AccessControlList) GetEntries() []*Entry {
	if m != nil {
		return m.Entries
	}
	return nil
}

type FieldValue struct {
	Type             *FieldValue_ContentType `protobuf:"varint,1,opt,name=type,enum=search.FieldValue_ContentType,def=0" json:"type,omitempty"`
	Language         *string                 `protobuf:"bytes,2,opt,name=language,def=en" json:"language,omitempty"`
	StringValue      *string                 `protobuf:"bytes,3,opt,name=string_value,json=stringValue" json:"string_value,omitempty"`
	Geo              *FieldValue_Geo         `protobuf:"group,4,opt,name=Geo,json=geo" json:"geo,omitempty"`
	XXX_unrecognized []byte                  `json:"-"`
}

func (m *FieldValue) Reset()                    { *m = FieldValue{} }
func (m *FieldValue) String() string            { return proto.CompactTextString(m) }
func (*FieldValue) ProtoMessage()               {}
func (*FieldValue) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

const Default_FieldValue_Type FieldValue_ContentType = FieldValue_TEXT
const Default_FieldValue_Language string = "en"

func (m *FieldValue) GetType() FieldValue_ContentType {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Default_FieldValue_Type
}

func (m *FieldValue) GetLanguage() string {
	if m != nil && m.Language != nil {
		return *m.Language
	}
	return Default_FieldValue_Language
}

func (m *FieldValue) GetStringValue() string {
	if m != nil && m.StringValue != nil {
		return *m.StringValue
	}
	return ""
}

func (m *FieldValue) GetGeo() *FieldValue_Geo {
	if m != nil {
		return m.Geo
	}
	return nil
}

type FieldValue_Geo struct {
	Lat              *float64 `protobuf:"fixed64,5,req,name=lat" json:"lat,omitempty"`
	Lng              *float64 `protobuf:"fixed64,6,req,name=lng" json:"lng,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *FieldValue_Geo) Reset()                    { *m = FieldValue_Geo{} }
func (m *FieldValue_Geo) String() string            { return proto.CompactTextString(m) }
func (*FieldValue_Geo) ProtoMessage()               {}
func (*FieldValue_Geo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3, 0} }

func (m *FieldValue_Geo) GetLat() float64 {
	if m != nil && m.Lat != nil {
		return *m.Lat
	}
	return 0
}

func (m *FieldValue_Geo) GetLng() float64 {
	if m != nil && m.Lng != nil {
		return *m.Lng
	}
	return 0
}

type Field struct {
	Name             *string     `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Value            *FieldValue `protobuf:"bytes,2,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *Field) Reset()                    { *m = Field{} }
func (m *Field) String() string            { return proto.CompactTextString(m) }
func (*Field) ProtoMessage()               {}
func (*Field) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *Field) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Field) GetValue() *FieldValue {
	if m != nil {
		return m.Value
	}
	return nil
}

type FieldTypes struct {
	Name             *string                  `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Type             []FieldValue_ContentType `protobuf:"varint,2,rep,name=type,enum=search.FieldValue_ContentType" json:"type,omitempty"`
	XXX_unrecognized []byte                   `json:"-"`
}

func (m *FieldTypes) Reset()                    { *m = FieldTypes{} }
func (m *FieldTypes) String() string            { return proto.CompactTextString(m) }
func (*FieldTypes) ProtoMessage()               {}
func (*FieldTypes) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *FieldTypes) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *FieldTypes) GetType() []FieldValue_ContentType {
	if m != nil {
		return m.Type
	}
	return nil
}

type IndexShardSettings struct {
	PrevNumShards            []int32 `protobuf:"varint,1,rep,name=prev_num_shards,json=prevNumShards" json:"prev_num_shards,omitempty"`
	NumShards                *int32  `protobuf:"varint,2,req,name=num_shards,json=numShards,def=1" json:"num_shards,omitempty"`
	PrevNumShardsSearchFalse []int32 `protobuf:"varint,3,rep,name=prev_num_shards_search_false,json=prevNumShardsSearchFalse" json:"prev_num_shards_search_false,omitempty"`
	LocalReplica             *string `protobuf:"bytes,4,opt,name=local_replica,json=localReplica,def=" json:"local_replica,omitempty"`
	XXX_unrecognized         []byte  `json:"-"`
}

func (m *IndexShardSettings) Reset()                    { *m = IndexShardSettings{} }
func (m *IndexShardSettings) String() string            { return proto.CompactTextString(m) }
func (*IndexShardSettings) ProtoMessage()               {}
func (*IndexShardSettings) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

const Default_IndexShardSettings_NumShards int32 = 1

func (m *IndexShardSettings) GetPrevNumShards() []int32 {
	if m != nil {
		return m.PrevNumShards
	}
	return nil
}

func (m *IndexShardSettings) GetNumShards() int32 {
	if m != nil && m.NumShards != nil {
		return *m.NumShards
	}
	return Default_IndexShardSettings_NumShards
}

func (m *IndexShardSettings) GetPrevNumShardsSearchFalse() []int32 {
	if m != nil {
		return m.PrevNumShardsSearchFalse
	}
	return nil
}

func (m *IndexShardSettings) GetLocalReplica() string {
	if m != nil && m.LocalReplica != nil {
		return *m.LocalReplica
	}
	return ""
}

type FacetValue struct {
	Type             *FacetValue_ContentType `protobuf:"varint,1,opt,name=type,enum=search.FacetValue_ContentType,def=2" json:"type,omitempty"`
	StringValue      *string                 `protobuf:"bytes,3,opt,name=string_value,json=stringValue" json:"string_value,omitempty"`
	XXX_unrecognized []byte                  `json:"-"`
}

func (m *FacetValue) Reset()                    { *m = FacetValue{} }
func (m *FacetValue) String() string            { return proto.CompactTextString(m) }
func (*FacetValue) ProtoMessage()               {}
func (*FacetValue) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

const Default_FacetValue_Type FacetValue_ContentType = FacetValue_ATOM

func (m *FacetValue) GetType() FacetValue_ContentType {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Default_FacetValue_Type
}

func (m *FacetValue) GetStringValue() string {
	if m != nil && m.StringValue != nil {
		return *m.StringValue
	}
	return ""
}

type Facet struct {
	Name             *string     `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Value            *FacetValue `protobuf:"bytes,2,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *Facet) Reset()                    { *m = Facet{} }
func (m *Facet) String() string            { return proto.CompactTextString(m) }
func (*Facet) ProtoMessage()               {}
func (*Facet) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *Facet) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Facet) GetValue() *FacetValue {
	if m != nil {
		return m.Value
	}
	return nil
}

type DocumentMetadata struct {
	Version            *int64 `protobuf:"varint,1,opt,name=version" json:"version,omitempty"`
	CommittedStVersion *int64 `protobuf:"varint,2,opt,name=committed_st_version,json=committedStVersion" json:"committed_st_version,omitempty"`
	XXX_unrecognized   []byte `json:"-"`
}

func (m *DocumentMetadata) Reset()                    { *m = DocumentMetadata{} }
func (m *DocumentMetadata) String() string            { return proto.CompactTextString(m) }
func (*DocumentMetadata) ProtoMessage()               {}
func (*DocumentMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *DocumentMetadata) GetVersion() int64 {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return 0
}

func (m *DocumentMetadata) GetCommittedStVersion() int64 {
	if m != nil && m.CommittedStVersion != nil {
		return *m.CommittedStVersion
	}
	return 0
}

type Document struct {
	Id               *string                 `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Language         *string                 `protobuf:"bytes,2,opt,name=language,def=en" json:"language,omitempty"`
	Field            []*Field                `protobuf:"bytes,3,rep,name=field" json:"field,omitempty"`
	OrderId          *int32                  `protobuf:"varint,4,opt,name=order_id,json=orderId" json:"order_id,omitempty"`
	OrderIdSource    *Document_OrderIdSource `protobuf:"varint,6,opt,name=order_id_source,json=orderIdSource,enum=search.Document_OrderIdSource,def=1" json:"order_id_source,omitempty"`
	Storage          *Document_Storage       `protobuf:"varint,5,opt,name=storage,enum=search.Document_Storage,def=0" json:"storage,omitempty"`
	Facet            []*Facet                `protobuf:"bytes,8,rep,name=facet" json:"facet,omitempty"`
	XXX_unrecognized []byte                  `json:"-"`
}

func (m *Document) Reset()                    { *m = Document{} }
func (m *Document) String() string            { return proto.CompactTextString(m) }
func (*Document) ProtoMessage()               {}
func (*Document) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

const Default_Document_Language string = "en"
const Default_Document_OrderIdSource Document_OrderIdSource = Document_SUPPLIED
const Default_Document_Storage Document_Storage = Document_DISK

func (m *Document) GetId() string {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return ""
}

func (m *Document) GetLanguage() string {
	if m != nil && m.Language != nil {
		return *m.Language
	}
	return Default_Document_Language
}

func (m *Document) GetField() []*Field {
	if m != nil {
		return m.Field
	}
	return nil
}

func (m *Document) GetOrderId() int32 {
	if m != nil && m.OrderId != nil {
		return *m.OrderId
	}
	return 0
}

func (m *Document) GetOrderIdSource() Document_OrderIdSource {
	if m != nil && m.OrderIdSource != nil {
		return *m.OrderIdSource
	}
	return Default_Document_OrderIdSource
}

func (m *Document) GetStorage() Document_Storage {
	if m != nil && m.Storage != nil {
		return *m.Storage
	}
	return Default_Document_Storage
}

func (m *Document) GetFacet() []*Facet {
	if m != nil {
		return m.Facet
	}
	return nil
}

type SearchServiceError struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *SearchServiceError) Reset()                    { *m = SearchServiceError{} }
func (m *SearchServiceError) String() string            { return proto.CompactTextString(m) }
func (*SearchServiceError) ProtoMessage()               {}
func (*SearchServiceError) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

type RequestStatus struct {
	Code             *SearchServiceError_ErrorCode `protobuf:"varint,1,req,name=code,enum=search.SearchServiceError_ErrorCode" json:"code,omitempty"`
	ErrorDetail      *string                       `protobuf:"bytes,2,opt,name=error_detail,json=errorDetail" json:"error_detail,omitempty"`
	CanonicalCode    *int32                        `protobuf:"varint,3,opt,name=canonical_code,json=canonicalCode" json:"canonical_code,omitempty"`
	XXX_unrecognized []byte                        `json:"-"`
}

func (m *RequestStatus) Reset()                    { *m = RequestStatus{} }
func (m *RequestStatus) String() string            { return proto.CompactTextString(m) }
func (*RequestStatus) ProtoMessage()               {}
func (*RequestStatus) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *RequestStatus) GetCode() SearchServiceError_ErrorCode {
	if m != nil && m.Code != nil {
		return *m.Code
	}
	return SearchServiceError_OK
}

func (m *RequestStatus) GetErrorDetail() string {
	if m != nil && m.ErrorDetail != nil {
		return *m.ErrorDetail
	}
	return ""
}

func (m *RequestStatus) GetCanonicalCode() int32 {
	if m != nil && m.CanonicalCode != nil {
		return *m.CanonicalCode
	}
	return 0
}

type IndexSpec struct {
	Name             *string                `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Consistency      *IndexSpec_Consistency `protobuf:"varint,2,opt,name=consistency,enum=search.IndexSpec_Consistency,def=1" json:"consistency,omitempty"`
	Namespace        *string                `protobuf:"bytes,3,opt,name=namespace" json:"namespace,omitempty"`
	Version          *int32                 `protobuf:"varint,4,opt,name=version" json:"version,omitempty"`
	Source           *IndexSpec_Source      `protobuf:"varint,5,opt,name=source,enum=search.IndexSpec_Source,def=0" json:"source,omitempty"`
	Mode             *IndexSpec_Mode        `protobuf:"varint,6,opt,name=mode,enum=search.IndexSpec_Mode,def=0" json:"mode,omitempty"`
	XXX_unrecognized []byte                 `json:"-"`
}

func (m *IndexSpec) Reset()                    { *m = IndexSpec{} }
func (m *IndexSpec) String() string            { return proto.CompactTextString(m) }
func (*IndexSpec) ProtoMessage()               {}
func (*IndexSpec) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

const Default_IndexSpec_Consistency IndexSpec_Consistency = IndexSpec_PER_DOCUMENT
const Default_IndexSpec_Source IndexSpec_Source = IndexSpec_SEARCH
const Default_IndexSpec_Mode IndexSpec_Mode = IndexSpec_PRIORITY

func (m *IndexSpec) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *IndexSpec) GetConsistency() IndexSpec_Consistency {
	if m != nil && m.Consistency != nil {
		return *m.Consistency
	}
	return Default_IndexSpec_Consistency
}

func (m *IndexSpec) GetNamespace() string {
	if m != nil && m.Namespace != nil {
		return *m.Namespace
	}
	return ""
}

func (m *IndexSpec) GetVersion() int32 {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return 0
}

func (m *IndexSpec) GetSource() IndexSpec_Source {
	if m != nil && m.Source != nil {
		return *m.Source
	}
	return Default_IndexSpec_Source
}

func (m *IndexSpec) GetMode() IndexSpec_Mode {
	if m != nil && m.Mode != nil {
		return *m.Mode
	}
	return Default_IndexSpec_Mode
}

type IndexMetadata struct {
	IndexSpec        *IndexSpec             `protobuf:"bytes,1,req,name=index_spec,json=indexSpec" json:"index_spec,omitempty"`
	Field            []*FieldTypes          `protobuf:"bytes,2,rep,name=field" json:"field,omitempty"`
	Storage          *IndexMetadata_Storage `protobuf:"bytes,3,opt,name=storage" json:"storage,omitempty"`
	XXX_unrecognized []byte                 `json:"-"`
}

func (m *IndexMetadata) Reset()                    { *m = IndexMetadata{} }
func (m *IndexMetadata) String() string            { return proto.CompactTextString(m) }
func (*IndexMetadata) ProtoMessage()               {}
func (*IndexMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *IndexMetadata) GetIndexSpec() *IndexSpec {
	if m != nil {
		return m.IndexSpec
	}
	return nil
}

func (m *IndexMetadata) GetField() []*FieldTypes {
	if m != nil {
		return m.Field
	}
	return nil
}

func (m *IndexMetadata) GetStorage() *IndexMetadata_Storage {
	if m != nil {
		return m.Storage
	}
	return nil
}

type IndexMetadata_Storage struct {
	AmountUsed       *int64 `protobuf:"varint,1,opt,name=amount_used,json=amountUsed" json:"amount_used,omitempty"`
	Limit            *int64 `protobuf:"varint,2,opt,name=limit" json:"limit,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *IndexMetadata_Storage) Reset()                    { *m = IndexMetadata_Storage{} }
func (m *IndexMetadata_Storage) String() string            { return proto.CompactTextString(m) }
func (*IndexMetadata_Storage) ProtoMessage()               {}
func (*IndexMetadata_Storage) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14, 0} }

func (m *IndexMetadata_Storage) GetAmountUsed() int64 {
	if m != nil && m.AmountUsed != nil {
		return *m.AmountUsed
	}
	return 0
}

func (m *IndexMetadata_Storage) GetLimit() int64 {
	if m != nil && m.Limit != nil {
		return *m.Limit
	}
	return 0
}

type IndexDocumentParams struct {
	Document         []*Document                    `protobuf:"bytes,1,rep,name=document" json:"document,omitempty"`
	Freshness        *IndexDocumentParams_Freshness `protobuf:"varint,2,opt,name=freshness,enum=search.IndexDocumentParams_Freshness,def=0" json:"freshness,omitempty"`
	IndexSpec        *IndexSpec                     `protobuf:"bytes,3,req,name=index_spec,json=indexSpec" json:"index_spec,omitempty"`
	XXX_unrecognized []byte                         `json:"-"`
}

func (m *IndexDocumentParams) Reset()                    { *m = IndexDocumentParams{} }
func (m *IndexDocumentParams) String() string            { return proto.CompactTextString(m) }
func (*IndexDocumentParams) ProtoMessage()               {}
func (*IndexDocumentParams) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

const Default_IndexDocumentParams_Freshness IndexDocumentParams_Freshness = IndexDocumentParams_SYNCHRONOUSLY

func (m *IndexDocumentParams) GetDocument() []*Document {
	if m != nil {
		return m.Document
	}
	return nil
}

func (m *IndexDocumentParams) GetFreshness() IndexDocumentParams_Freshness {
	if m != nil && m.Freshness != nil {
		return *m.Freshness
	}
	return Default_IndexDocumentParams_Freshness
}

func (m *IndexDocumentParams) GetIndexSpec() *IndexSpec {
	if m != nil {
		return m.IndexSpec
	}
	return nil
}

type IndexDocumentRequest struct {
	Params           *IndexDocumentParams `protobuf:"bytes,1,req,name=params" json:"params,omitempty"`
	AppId            []byte               `protobuf:"bytes,3,opt,name=app_id,json=appId" json:"app_id,omitempty"`
	XXX_unrecognized []byte               `json:"-"`
}

func (m *IndexDocumentRequest) Reset()                    { *m = IndexDocumentRequest{} }
func (m *IndexDocumentRequest) String() string            { return proto.CompactTextString(m) }
func (*IndexDocumentRequest) ProtoMessage()               {}
func (*IndexDocumentRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *IndexDocumentRequest) GetParams() *IndexDocumentParams {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *IndexDocumentRequest) GetAppId() []byte {
	if m != nil {
		return m.AppId
	}
	return nil
}

type IndexDocumentResponse struct {
	Status           []*RequestStatus `protobuf:"bytes,1,rep,name=status" json:"status,omitempty"`
	DocId            []string         `protobuf:"bytes,2,rep,name=doc_id,json=docId" json:"doc_id,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *IndexDocumentResponse) Reset()                    { *m = IndexDocumentResponse{} }
func (m *IndexDocumentResponse) String() string            { return proto.CompactTextString(m) }
func (*IndexDocumentResponse) ProtoMessage()               {}
func (*IndexDocumentResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *IndexDocumentResponse) GetStatus() []*RequestStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *IndexDocumentResponse) GetDocId() []string {
	if m != nil {
		return m.DocId
	}
	return nil
}

type DeleteDocumentParams struct {
	DocId            []string   `protobuf:"bytes,1,rep,name=doc_id,json=docId" json:"doc_id,omitempty"`
	IndexSpec        *IndexSpec `protobuf:"bytes,2,req,name=index_spec,json=indexSpec" json:"index_spec,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *DeleteDocumentParams) Reset()                    { *m = DeleteDocumentParams{} }
func (m *DeleteDocumentParams) String() string            { return proto.CompactTextString(m) }
func (*DeleteDocumentParams) ProtoMessage()               {}
func (*DeleteDocumentParams) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *DeleteDocumentParams) GetDocId() []string {
	if m != nil {
		return m.DocId
	}
	return nil
}

func (m *DeleteDocumentParams) GetIndexSpec() *IndexSpec {
	if m != nil {
		return m.IndexSpec
	}
	return nil
}

type DeleteDocumentRequest struct {
	Params           *DeleteDocumentParams `protobuf:"bytes,1,req,name=params" json:"params,omitempty"`
	AppId            []byte                `protobuf:"bytes,3,opt,name=app_id,json=appId" json:"app_id,omitempty"`
	XXX_unrecognized []byte                `json:"-"`
}

func (m *DeleteDocumentRequest) Reset()                    { *m = DeleteDocumentRequest{} }
func (m *DeleteDocumentRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteDocumentRequest) ProtoMessage()               {}
func (*DeleteDocumentRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *DeleteDocumentRequest) GetParams() *DeleteDocumentParams {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *DeleteDocumentRequest) GetAppId() []byte {
	if m != nil {
		return m.AppId
	}
	return nil
}

type DeleteDocumentResponse struct {
	Status           []*RequestStatus `protobuf:"bytes,1,rep,name=status" json:"status,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *DeleteDocumentResponse) Reset()                    { *m = DeleteDocumentResponse{} }
func (m *DeleteDocumentResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteDocumentResponse) ProtoMessage()               {}
func (*DeleteDocumentResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *DeleteDocumentResponse) GetStatus() []*RequestStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

type ListDocumentsParams struct {
	IndexSpec        *IndexSpec `protobuf:"bytes,1,req,name=index_spec,json=indexSpec" json:"index_spec,omitempty"`
	StartDocId       *string    `protobuf:"bytes,2,opt,name=start_doc_id,json=startDocId" json:"start_doc_id,omitempty"`
	IncludeStartDoc  *bool      `protobuf:"varint,3,opt,name=include_start_doc,json=includeStartDoc,def=1" json:"include_start_doc,omitempty"`
	Limit            *int32     `protobuf:"varint,4,opt,name=limit,def=100" json:"limit,omitempty"`
	KeysOnly         *bool      `protobuf:"varint,5,opt,name=keys_only,json=keysOnly" json:"keys_only,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *ListDocumentsParams) Reset()                    { *m = ListDocumentsParams{} }
func (m *ListDocumentsParams) String() string            { return proto.CompactTextString(m) }
func (*ListDocumentsParams) ProtoMessage()               {}
func (*ListDocumentsParams) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

const Default_ListDocumentsParams_IncludeStartDoc bool = true
const Default_ListDocumentsParams_Limit int32 = 100

func (m *ListDocumentsParams) GetIndexSpec() *IndexSpec {
	if m != nil {
		return m.IndexSpec
	}
	return nil
}

func (m *ListDocumentsParams) GetStartDocId() string {
	if m != nil && m.StartDocId != nil {
		return *m.StartDocId
	}
	return ""
}

func (m *ListDocumentsParams) GetIncludeStartDoc() bool {
	if m != nil && m.IncludeStartDoc != nil {
		return *m.IncludeStartDoc
	}
	return Default_ListDocumentsParams_IncludeStartDoc
}

func (m *ListDocumentsParams) GetLimit() int32 {
	if m != nil && m.Limit != nil {
		return *m.Limit
	}
	return Default_ListDocumentsParams_Limit
}

func (m *ListDocumentsParams) GetKeysOnly() bool {
	if m != nil && m.KeysOnly != nil {
		return *m.KeysOnly
	}
	return false
}

type ListDocumentsRequest struct {
	Params           *ListDocumentsParams `protobuf:"bytes,1,req,name=params" json:"params,omitempty"`
	AppId            []byte               `protobuf:"bytes,2,opt,name=app_id,json=appId" json:"app_id,omitempty"`
	XXX_unrecognized []byte               `json:"-"`
}

func (m *ListDocumentsRequest) Reset()                    { *m = ListDocumentsRequest{} }
func (m *ListDocumentsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListDocumentsRequest) ProtoMessage()               {}
func (*ListDocumentsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *ListDocumentsRequest) GetParams() *ListDocumentsParams {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *ListDocumentsRequest) GetAppId() []byte {
	if m != nil {
		return m.AppId
	}
	return nil
}

type ListDocumentsResponse struct {
	Status           *RequestStatus `protobuf:"bytes,1,req,name=status" json:"status,omitempty"`
	Document         []*Document    `protobuf:"bytes,2,rep,name=document" json:"document,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *ListDocumentsResponse) Reset()                    { *m = ListDocumentsResponse{} }
func (m *ListDocumentsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListDocumentsResponse) ProtoMessage()               {}
func (*ListDocumentsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *ListDocumentsResponse) GetStatus() *RequestStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *ListDocumentsResponse) GetDocument() []*Document {
	if m != nil {
		return m.Document
	}
	return nil
}

type ListIndexesParams struct {
	FetchSchema       *bool             `protobuf:"varint,1,opt,name=fetch_schema,json=fetchSchema" json:"fetch_schema,omitempty"`
	Limit             *int32            `protobuf:"varint,2,opt,name=limit,def=20" json:"limit,omitempty"`
	Namespace         *string           `protobuf:"bytes,3,opt,name=namespace" json:"namespace,omitempty"`
	StartIndexName    *string           `protobuf:"bytes,4,opt,name=start_index_name,json=startIndexName" json:"start_index_name,omitempty"`
	IncludeStartIndex *bool             `protobuf:"varint,5,opt,name=include_start_index,json=includeStartIndex,def=1" json:"include_start_index,omitempty"`
	IndexNamePrefix   *string           `protobuf:"bytes,6,opt,name=index_name_prefix,json=indexNamePrefix" json:"index_name_prefix,omitempty"`
	Offset            *int32            `protobuf:"varint,7,opt,name=offset" json:"offset,omitempty"`
	Source            *IndexSpec_Source `protobuf:"varint,8,opt,name=source,enum=search.IndexSpec_Source,def=0" json:"source,omitempty"`
	XXX_unrecognized  []byte            `json:"-"`
}

func (m *ListIndexesParams) Reset()                    { *m = ListIndexesParams{} }
func (m *ListIndexesParams) String() string            { return proto.CompactTextString(m) }
func (*ListIndexesParams) ProtoMessage()               {}
func (*ListIndexesParams) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

const Default_ListIndexesParams_Limit int32 = 20
const Default_ListIndexesParams_IncludeStartIndex bool = true
const Default_ListIndexesParams_Source IndexSpec_Source = IndexSpec_SEARCH

func (m *ListIndexesParams) GetFetchSchema() bool {
	if m != nil && m.FetchSchema != nil {
		return *m.FetchSchema
	}
	return false
}

func (m *ListIndexesParams) GetLimit() int32 {
	if m != nil && m.Limit != nil {
		return *m.Limit
	}
	return Default_ListIndexesParams_Limit
}

func (m *ListIndexesParams) GetNamespace() string {
	if m != nil && m.Namespace != nil {
		return *m.Namespace
	}
	return ""
}

func (m *ListIndexesParams) GetStartIndexName() string {
	if m != nil && m.StartIndexName != nil {
		return *m.StartIndexName
	}
	return ""
}

func (m *ListIndexesParams) GetIncludeStartIndex() bool {
	if m != nil && m.IncludeStartIndex != nil {
		return *m.IncludeStartIndex
	}
	return Default_ListIndexesParams_IncludeStartIndex
}

func (m *ListIndexesParams) GetIndexNamePrefix() string {
	if m != nil && m.IndexNamePrefix != nil {
		return *m.IndexNamePrefix
	}
	return ""
}

func (m *ListIndexesParams) GetOffset() int32 {
	if m != nil && m.Offset != nil {
		return *m.Offset
	}
	return 0
}

func (m *ListIndexesParams) GetSource() IndexSpec_Source {
	if m != nil && m.Source != nil {
		return *m.Source
	}
	return Default_ListIndexesParams_Source
}

type ListIndexesRequest struct {
	Params           *ListIndexesParams `protobuf:"bytes,1,req,name=params" json:"params,omitempty"`
	AppId            []byte             `protobuf:"bytes,3,opt,name=app_id,json=appId" json:"app_id,omitempty"`
	XXX_unrecognized []byte             `json:"-"`
}

func (m *ListIndexesRequest) Reset()                    { *m = ListIndexesRequest{} }
func (m *ListIndexesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListIndexesRequest) ProtoMessage()               {}
func (*ListIndexesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

func (m *ListIndexesRequest) GetParams() *ListIndexesParams {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *ListIndexesRequest) GetAppId() []byte {
	if m != nil {
		return m.AppId
	}
	return nil
}

type ListIndexesResponse struct {
	Status           *RequestStatus   `protobuf:"bytes,1,req,name=status" json:"status,omitempty"`
	IndexMetadata    []*IndexMetadata `protobuf:"bytes,2,rep,name=index_metadata,json=indexMetadata" json:"index_metadata,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *ListIndexesResponse) Reset()                    { *m = ListIndexesResponse{} }
func (m *ListIndexesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListIndexesResponse) ProtoMessage()               {}
func (*ListIndexesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

func (m *ListIndexesResponse) GetStatus() *RequestStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *ListIndexesResponse) GetIndexMetadata() []*IndexMetadata {
	if m != nil {
		return m.IndexMetadata
	}
	return nil
}

type DeleteSchemaParams struct {
	Source           *IndexSpec_Source `protobuf:"varint,1,opt,name=source,enum=search.IndexSpec_Source,def=0" json:"source,omitempty"`
	IndexSpec        []*IndexSpec      `protobuf:"bytes,2,rep,name=index_spec,json=indexSpec" json:"index_spec,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *DeleteSchemaParams) Reset()                    { *m = DeleteSchemaParams{} }
func (m *DeleteSchemaParams) String() string            { return proto.CompactTextString(m) }
func (*DeleteSchemaParams) ProtoMessage()               {}
func (*DeleteSchemaParams) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

const Default_DeleteSchemaParams_Source IndexSpec_Source = IndexSpec_SEARCH

func (m *DeleteSchemaParams) GetSource() IndexSpec_Source {
	if m != nil && m.Source != nil {
		return *m.Source
	}
	return Default_DeleteSchemaParams_Source
}

func (m *DeleteSchemaParams) GetIndexSpec() []*IndexSpec {
	if m != nil {
		return m.IndexSpec
	}
	return nil
}

type DeleteSchemaRequest struct {
	Params           *DeleteSchemaParams `protobuf:"bytes,1,req,name=params" json:"params,omitempty"`
	AppId            []byte              `protobuf:"bytes,3,opt,name=app_id,json=appId" json:"app_id,omitempty"`
	XXX_unrecognized []byte              `json:"-"`
}

func (m *DeleteSchemaRequest) Reset()                    { *m = DeleteSchemaRequest{} }
func (m *DeleteSchemaRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteSchemaRequest) ProtoMessage()               {}
func (*DeleteSchemaRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

func (m *DeleteSchemaRequest) GetParams() *DeleteSchemaParams {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *DeleteSchemaRequest) GetAppId() []byte {
	if m != nil {
		return m.AppId
	}
	return nil
}

type DeleteSchemaResponse struct {
	Status           []*RequestStatus `protobuf:"bytes,1,rep,name=status" json:"status,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *DeleteSchemaResponse) Reset()                    { *m = DeleteSchemaResponse{} }
func (m *DeleteSchemaResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteSchemaResponse) ProtoMessage()               {}
func (*DeleteSchemaResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *DeleteSchemaResponse) GetStatus() []*RequestStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

type SortSpec struct {
	SortExpression      *string  `protobuf:"bytes,1,req,name=sort_expression,json=sortExpression" json:"sort_expression,omitempty"`
	SortDescending      *bool    `protobuf:"varint,2,opt,name=sort_descending,json=sortDescending,def=1" json:"sort_descending,omitempty"`
	DefaultValueText    *string  `protobuf:"bytes,4,opt,name=default_value_text,json=defaultValueText" json:"default_value_text,omitempty"`
	DefaultValueNumeric *float64 `protobuf:"fixed64,5,opt,name=default_value_numeric,json=defaultValueNumeric" json:"default_value_numeric,omitempty"`
	XXX_unrecognized    []byte   `json:"-"`
}

func (m *SortSpec) Reset()                    { *m = SortSpec{} }
func (m *SortSpec) String() string            { return proto.CompactTextString(m) }
func (*SortSpec) ProtoMessage()               {}
func (*SortSpec) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

const Default_SortSpec_SortDescending bool = true

func (m *SortSpec) GetSortExpression() string {
	if m != nil && m.SortExpression != nil {
		return *m.SortExpression
	}
	return ""
}

func (m *SortSpec) GetSortDescending() bool {
	if m != nil && m.SortDescending != nil {
		return *m.SortDescending
	}
	return Default_SortSpec_SortDescending
}

func (m *SortSpec) GetDefaultValueText() string {
	if m != nil && m.DefaultValueText != nil {
		return *m.DefaultValueText
	}
	return ""
}

func (m *SortSpec) GetDefaultValueNumeric() float64 {
	if m != nil && m.DefaultValueNumeric != nil {
		return *m.DefaultValueNumeric
	}
	return 0
}

type ScorerSpec struct {
	Scorer                *ScorerSpec_Scorer `protobuf:"varint,1,opt,name=scorer,enum=search.ScorerSpec_Scorer,def=2" json:"scorer,omitempty"`
	Limit                 *int32             `protobuf:"varint,2,opt,name=limit,def=1000" json:"limit,omitempty"`
	MatchScorerParameters *string            `protobuf:"bytes,9,opt,name=match_scorer_parameters,json=matchScorerParameters" json:"match_scorer_parameters,omitempty"`
	XXX_unrecognized      []byte             `json:"-"`
}

func (m *ScorerSpec) Reset()                    { *m = ScorerSpec{} }
func (m *ScorerSpec) String() string            { return proto.CompactTextString(m) }
func (*ScorerSpec) ProtoMessage()               {}
func (*ScorerSpec) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

const Default_ScorerSpec_Scorer ScorerSpec_Scorer = ScorerSpec_MATCH_SCORER
const Default_ScorerSpec_Limit int32 = 1000

func (m *ScorerSpec) GetScorer() ScorerSpec_Scorer {
	if m != nil && m.Scorer != nil {
		return *m.Scorer
	}
	return Default_ScorerSpec_Scorer
}

func (m *ScorerSpec) GetLimit() int32 {
	if m != nil && m.Limit != nil {
		return *m.Limit
	}
	return Default_ScorerSpec_Limit
}

func (m *ScorerSpec) GetMatchScorerParameters() string {
	if m != nil && m.MatchScorerParameters != nil {
		return *m.MatchScorerParameters
	}
	return ""
}

type FieldSpec struct {
	Name             []string                `protobuf:"bytes,1,rep,name=name" json:"name,omitempty"`
	Expression       []*FieldSpec_Expression `protobuf:"group,2,rep,name=Expression,json=expression" json:"expression,omitempty"`
	XXX_unrecognized []byte                  `json:"-"`
}

func (m *FieldSpec) Reset()                    { *m = FieldSpec{} }
func (m *FieldSpec) String() string            { return proto.CompactTextString(m) }
func (*FieldSpec) ProtoMessage()               {}
func (*FieldSpec) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

func (m *FieldSpec) GetName() []string {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *FieldSpec) GetExpression() []*FieldSpec_Expression {
	if m != nil {
		return m.Expression
	}
	return nil
}

type FieldSpec_Expression struct {
	Name             *string `protobuf:"bytes,3,req,name=name" json:"name,omitempty"`
	Expression       *string `protobuf:"bytes,4,req,name=expression" json:"expression,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *FieldSpec_Expression) Reset()                    { *m = FieldSpec_Expression{} }
func (m *FieldSpec_Expression) String() string            { return proto.CompactTextString(m) }
func (*FieldSpec_Expression) ProtoMessage()               {}
func (*FieldSpec_Expression) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32, 0} }

func (m *FieldSpec_Expression) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *FieldSpec_Expression) GetExpression() string {
	if m != nil && m.Expression != nil {
		return *m.Expression
	}
	return ""
}

type FacetRange struct {
	Name             *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Start            *string `protobuf:"bytes,2,opt,name=start" json:"start,omitempty"`
	End              *string `protobuf:"bytes,3,opt,name=end" json:"end,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *FacetRange) Reset()                    { *m = FacetRange{} }
func (m *FacetRange) String() string            { return proto.CompactTextString(m) }
func (*FacetRange) ProtoMessage()               {}
func (*FacetRange) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

func (m *FacetRange) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *FacetRange) GetStart() string {
	if m != nil && m.Start != nil {
		return *m.Start
	}
	return ""
}

func (m *FacetRange) GetEnd() string {
	if m != nil && m.End != nil {
		return *m.End
	}
	return ""
}

type FacetRequestParam struct {
	ValueLimit       *int32        `protobuf:"varint,1,opt,name=value_limit,json=valueLimit" json:"value_limit,omitempty"`
	Range            []*FacetRange `protobuf:"bytes,2,rep,name=range" json:"range,omitempty"`
	ValueConstraint  []string      `protobuf:"bytes,3,rep,name=value_constraint,json=valueConstraint" json:"value_constraint,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *FacetRequestParam) Reset()                    { *m = FacetRequestParam{} }
func (m *FacetRequestParam) String() string            { return proto.CompactTextString(m) }
func (*FacetRequestParam) ProtoMessage()               {}
func (*FacetRequestParam) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

func (m *FacetRequestParam) GetValueLimit() int32 {
	if m != nil && m.ValueLimit != nil {
		return *m.ValueLimit
	}
	return 0
}

func (m *FacetRequestParam) GetRange() []*FacetRange {
	if m != nil {
		return m.Range
	}
	return nil
}

func (m *FacetRequestParam) GetValueConstraint() []string {
	if m != nil {
		return m.ValueConstraint
	}
	return nil
}

type FacetAutoDetectParam struct {
	ValueLimit       *int32 `protobuf:"varint,1,opt,name=value_limit,json=valueLimit,def=10" json:"value_limit,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *FacetAutoDetectParam) Reset()                    { *m = FacetAutoDetectParam{} }
func (m *FacetAutoDetectParam) String() string            { return proto.CompactTextString(m) }
func (*FacetAutoDetectParam) ProtoMessage()               {}
func (*FacetAutoDetectParam) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

const Default_FacetAutoDetectParam_ValueLimit int32 = 10

func (m *FacetAutoDetectParam) GetValueLimit() int32 {
	if m != nil && m.ValueLimit != nil {
		return *m.ValueLimit
	}
	return Default_FacetAutoDetectParam_ValueLimit
}

type FacetRequest struct {
	Name             *string            `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Params           *FacetRequestParam `protobuf:"bytes,2,opt,name=params" json:"params,omitempty"`
	XXX_unrecognized []byte             `json:"-"`
}

func (m *FacetRequest) Reset()                    { *m = FacetRequest{} }
func (m *FacetRequest) String() string            { return proto.CompactTextString(m) }
func (*FacetRequest) ProtoMessage()               {}
func (*FacetRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{36} }

func (m *FacetRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *FacetRequest) GetParams() *FacetRequestParam {
	if m != nil {
		return m.Params
	}
	return nil
}

type FacetRefinement struct {
	Name             *string                `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Value            *string                `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	Range            *FacetRefinement_Range `protobuf:"bytes,3,opt,name=range" json:"range,omitempty"`
	XXX_unrecognized []byte                 `json:"-"`
}

func (m *FacetRefinement) Reset()                    { *m = FacetRefinement{} }
func (m *FacetRefinement) String() string            { return proto.CompactTextString(m) }
func (*FacetRefinement) ProtoMessage()               {}
func (*FacetRefinement) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37} }

func (m *FacetRefinement) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *FacetRefinement) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

func (m *FacetRefinement) GetRange() *FacetRefinement_Range {
	if m != nil {
		return m.Range
	}
	return nil
}

type FacetRefinement_Range struct {
	Start            *string `protobuf:"bytes,1,opt,name=start" json:"start,omitempty"`
	End              *string `protobuf:"bytes,2,opt,name=end" json:"end,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *FacetRefinement_Range) Reset()                    { *m = FacetRefinement_Range{} }
func (m *FacetRefinement_Range) String() string            { return proto.CompactTextString(m) }
func (*FacetRefinement_Range) ProtoMessage()               {}
func (*FacetRefinement_Range) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37, 0} }

func (m *FacetRefinement_Range) GetStart() string {
	if m != nil && m.Start != nil {
		return *m.Start
	}
	return ""
}

func (m *FacetRefinement_Range) GetEnd() string {
	if m != nil && m.End != nil {
		return *m.End
	}
	return ""
}

type SearchParams struct {
	IndexSpec              *IndexSpec                `protobuf:"bytes,1,req,name=index_spec,json=indexSpec" json:"index_spec,omitempty"`
	Query                  *string                   `protobuf:"bytes,2,req,name=query" json:"query,omitempty"`
	Cursor                 *string                   `protobuf:"bytes,4,opt,name=cursor" json:"cursor,omitempty"`
	Offset                 *int32                    `protobuf:"varint,11,opt,name=offset" json:"offset,omitempty"`
	CursorType             *SearchParams_CursorType  `protobuf:"varint,5,opt,name=cursor_type,json=cursorType,enum=search.SearchParams_CursorType,def=0" json:"cursor_type,omitempty"`
	Limit                  *int32                    `protobuf:"varint,6,opt,name=limit,def=20" json:"limit,omitempty"`
	MatchedCountAccuracy   *int32                    `protobuf:"varint,7,opt,name=matched_count_accuracy,json=matchedCountAccuracy" json:"matched_count_accuracy,omitempty"`
	SortSpec               []*SortSpec               `protobuf:"bytes,8,rep,name=sort_spec,json=sortSpec" json:"sort_spec,omitempty"`
	ScorerSpec             *ScorerSpec               `protobuf:"bytes,9,opt,name=scorer_spec,json=scorerSpec" json:"scorer_spec,omitempty"`
	FieldSpec              *FieldSpec                `protobuf:"bytes,10,opt,name=field_spec,json=fieldSpec" json:"field_spec,omitempty"`
	KeysOnly               *bool                     `protobuf:"varint,12,opt,name=keys_only,json=keysOnly" json:"keys_only,omitempty"`
	ParsingMode            *SearchParams_ParsingMode `protobuf:"varint,13,opt,name=parsing_mode,json=parsingMode,enum=search.SearchParams_ParsingMode,def=0" json:"parsing_mode,omitempty"`
	AutoDiscoverFacetCount *int32                    `protobuf:"varint,15,opt,name=auto_discover_facet_count,json=autoDiscoverFacetCount,def=0" json:"auto_discover_facet_count,omitempty"`
	IncludeFacet           []*FacetRequest           `protobuf:"bytes,16,rep,name=include_facet,json=includeFacet" json:"include_facet,omitempty"`
	FacetRefinement        []*FacetRefinement        `protobuf:"bytes,17,rep,name=facet_refinement,json=facetRefinement" json:"facet_refinement,omitempty"`
	FacetAutoDetectParam   *FacetAutoDetectParam     `protobuf:"bytes,18,opt,name=facet_auto_detect_param,json=facetAutoDetectParam" json:"facet_auto_detect_param,omitempty"`
	FacetDepth             *int32                    `protobuf:"varint,19,opt,name=facet_depth,json=facetDepth,def=1000" json:"facet_depth,omitempty"`
	XXX_unrecognized       []byte                    `json:"-"`
}

func (m *SearchParams) Reset()                    { *m = SearchParams{} }
func (m *SearchParams) String() string            { return proto.CompactTextString(m) }
func (*SearchParams) ProtoMessage()               {}
func (*SearchParams) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{38} }

const Default_SearchParams_CursorType SearchParams_CursorType = SearchParams_NONE
const Default_SearchParams_Limit int32 = 20
const Default_SearchParams_ParsingMode SearchParams_ParsingMode = SearchParams_STRICT
const Default_SearchParams_AutoDiscoverFacetCount int32 = 0
const Default_SearchParams_FacetDepth int32 = 1000

func (m *SearchParams) GetIndexSpec() *IndexSpec {
	if m != nil {
		return m.IndexSpec
	}
	return nil
}

func (m *SearchParams) GetQuery() string {
	if m != nil && m.Query != nil {
		return *m.Query
	}
	return ""
}

func (m *SearchParams) GetCursor() string {
	if m != nil && m.Cursor != nil {
		return *m.Cursor
	}
	return ""
}

func (m *SearchParams) GetOffset() int32 {
	if m != nil && m.Offset != nil {
		return *m.Offset
	}
	return 0
}

func (m *SearchParams) GetCursorType() SearchParams_CursorType {
	if m != nil && m.CursorType != nil {
		return *m.CursorType
	}
	return Default_SearchParams_CursorType
}

func (m *SearchParams) GetLimit() int32 {
	if m != nil && m.Limit != nil {
		return *m.Limit
	}
	return Default_SearchParams_Limit
}

func (m *SearchParams) GetMatchedCountAccuracy() int32 {
	if m != nil && m.MatchedCountAccuracy != nil {
		return *m.MatchedCountAccuracy
	}
	return 0
}

func (m *SearchParams) GetSortSpec() []*SortSpec {
	if m != nil {
		return m.SortSpec
	}
	return nil
}

func (m *SearchParams) GetScorerSpec() *ScorerSpec {
	if m != nil {
		return m.ScorerSpec
	}
	return nil
}

func (m *SearchParams) GetFieldSpec() *FieldSpec {
	if m != nil {
		return m.FieldSpec
	}
	return nil
}

func (m *SearchParams) GetKeysOnly() bool {
	if m != nil && m.KeysOnly != nil {
		return *m.KeysOnly
	}
	return false
}

func (m *SearchParams) GetParsingMode() SearchParams_ParsingMode {
	if m != nil && m.ParsingMode != nil {
		return *m.ParsingMode
	}
	return Default_SearchParams_ParsingMode
}

func (m *SearchParams) GetAutoDiscoverFacetCount() int32 {
	if m != nil && m.AutoDiscoverFacetCount != nil {
		return *m.AutoDiscoverFacetCount
	}
	return Default_SearchParams_AutoDiscoverFacetCount
}

func (m *SearchParams) GetIncludeFacet() []*FacetRequest {
	if m != nil {
		return m.IncludeFacet
	}
	return nil
}

func (m *SearchParams) GetFacetRefinement() []*FacetRefinement {
	if m != nil {
		return m.FacetRefinement
	}
	return nil
}

func (m *SearchParams) GetFacetAutoDetectParam() *FacetAutoDetectParam {
	if m != nil {
		return m.FacetAutoDetectParam
	}
	return nil
}

func (m *SearchParams) GetFacetDepth() int32 {
	if m != nil && m.FacetDepth != nil {
		return *m.FacetDepth
	}
	return Default_SearchParams_FacetDepth
}

type SearchRequest struct {
	Params           *SearchParams `protobuf:"bytes,1,req,name=params" json:"params,omitempty"`
	AppId            []byte        `protobuf:"bytes,3,opt,name=app_id,json=appId" json:"app_id,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *SearchRequest) Reset()                    { *m = SearchRequest{} }
func (m *SearchRequest) String() string            { return proto.CompactTextString(m) }
func (*SearchRequest) ProtoMessage()               {}
func (*SearchRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{39} }

func (m *SearchRequest) GetParams() *SearchParams {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *SearchRequest) GetAppId() []byte {
	if m != nil {
		return m.AppId
	}
	return nil
}

type FacetResultValue struct {
	Name             *string          `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Count            *int32           `protobuf:"varint,2,req,name=count" json:"count,omitempty"`
	Refinement       *FacetRefinement `protobuf:"bytes,3,req,name=refinement" json:"refinement,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *FacetResultValue) Reset()                    { *m = FacetResultValue{} }
func (m *FacetResultValue) String() string            { return proto.CompactTextString(m) }
func (*FacetResultValue) ProtoMessage()               {}
func (*FacetResultValue) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{40} }

func (m *FacetResultValue) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *FacetResultValue) GetCount() int32 {
	if m != nil && m.Count != nil {
		return *m.Count
	}
	return 0
}

func (m *FacetResultValue) GetRefinement() *FacetRefinement {
	if m != nil {
		return m.Refinement
	}
	return nil
}

type FacetResult struct {
	Name             *string             `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Value            []*FacetResultValue `protobuf:"bytes,2,rep,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte              `json:"-"`
}

func (m *FacetResult) Reset()                    { *m = FacetResult{} }
func (m *FacetResult) String() string            { return proto.CompactTextString(m) }
func (*FacetResult) ProtoMessage()               {}
func (*FacetResult) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{41} }

func (m *FacetResult) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *FacetResult) GetValue() []*FacetResultValue {
	if m != nil {
		return m.Value
	}
	return nil
}

type SearchResult struct {
	Document         *Document `protobuf:"bytes,1,req,name=document" json:"document,omitempty"`
	Expression       []*Field  `protobuf:"bytes,4,rep,name=expression" json:"expression,omitempty"`
	Score            []float64 `protobuf:"fixed64,2,rep,name=score" json:"score,omitempty"`
	Cursor           *string   `protobuf:"bytes,3,opt,name=cursor" json:"cursor,omitempty"`
	XXX_unrecognized []byte    `json:"-"`
}

func (m *SearchResult) Reset()                    { *m = SearchResult{} }
func (m *SearchResult) String() string            { return proto.CompactTextString(m) }
func (*SearchResult) ProtoMessage()               {}
func (*SearchResult) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{42} }

func (m *SearchResult) GetDocument() *Document {
	if m != nil {
		return m.Document
	}
	return nil
}

func (m *SearchResult) GetExpression() []*Field {
	if m != nil {
		return m.Expression
	}
	return nil
}

func (m *SearchResult) GetScore() []float64 {
	if m != nil {
		return m.Score
	}
	return nil
}

func (m *SearchResult) GetCursor() string {
	if m != nil && m.Cursor != nil {
		return *m.Cursor
	}
	return ""
}

type SearchResponse struct {
	Result                       []*SearchResult `protobuf:"bytes,1,rep,name=result" json:"result,omitempty"`
	MatchedCount                 *int64          `protobuf:"varint,2,req,name=matched_count,json=matchedCount" json:"matched_count,omitempty"`
	Status                       *RequestStatus  `protobuf:"bytes,3,req,name=status" json:"status,omitempty"`
	Cursor                       *string         `protobuf:"bytes,4,opt,name=cursor" json:"cursor,omitempty"`
	FacetResult                  []*FacetResult  `protobuf:"bytes,5,rep,name=facet_result,json=facetResult" json:"facet_result,omitempty"`
	proto.XXX_InternalExtensions `json:"-"`
	XXX_unrecognized             []byte `json:"-"`
}

func (m *SearchResponse) Reset()                    { *m = SearchResponse{} }
func (m *SearchResponse) String() string            { return proto.CompactTextString(m) }
func (*SearchResponse) ProtoMessage()               {}
func (*SearchResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{43} }

var extRange_SearchResponse = []proto.ExtensionRange{
	{1000, 9999},
}

func (*SearchResponse) ExtensionRangeArray() []proto.ExtensionRange {
	return extRange_SearchResponse
}

func (m *SearchResponse) GetResult() []*SearchResult {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *SearchResponse) GetMatchedCount() int64 {
	if m != nil && m.MatchedCount != nil {
		return *m.MatchedCount
	}
	return 0
}

func (m *SearchResponse) GetStatus() *RequestStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *SearchResponse) GetCursor() string {
	if m != nil && m.Cursor != nil {
		return *m.Cursor
	}
	return ""
}

func (m *SearchResponse) GetFacetResult() []*FacetResult {
	if m != nil {
		return m.FacetResult
	}
	return nil
}

func init() {
	proto.RegisterType((*Scope)(nil), "search.Scope")
	proto.RegisterType((*Entry)(nil), "search.Entry")
	proto.RegisterType((*AccessControlList)(nil), "search.AccessControlList")
	proto.RegisterType((*FieldValue)(nil), "search.FieldValue")
	proto.RegisterType((*FieldValue_Geo)(nil), "search.FieldValue.Geo")
	proto.RegisterType((*Field)(nil), "search.Field")
	proto.RegisterType((*FieldTypes)(nil), "search.FieldTypes")
	proto.RegisterType((*IndexShardSettings)(nil), "search.IndexShardSettings")
	proto.RegisterType((*FacetValue)(nil), "search.FacetValue")
	proto.RegisterType((*Facet)(nil), "search.Facet")
	proto.RegisterType((*DocumentMetadata)(nil), "search.DocumentMetadata")
	proto.RegisterType((*Document)(nil), "search.Document")
	proto.RegisterType((*SearchServiceError)(nil), "search.SearchServiceError")
	proto.RegisterType((*RequestStatus)(nil), "search.RequestStatus")
	proto.RegisterType((*IndexSpec)(nil), "search.IndexSpec")
	proto.RegisterType((*IndexMetadata)(nil), "search.IndexMetadata")
	proto.RegisterType((*IndexMetadata_Storage)(nil), "search.IndexMetadata.Storage")
	proto.RegisterType((*IndexDocumentParams)(nil), "search.IndexDocumentParams")
	proto.RegisterType((*IndexDocumentRequest)(nil), "search.IndexDocumentRequest")
	proto.RegisterType((*IndexDocumentResponse)(nil), "search.IndexDocumentResponse")
	proto.RegisterType((*DeleteDocumentParams)(nil), "search.DeleteDocumentParams")
	proto.RegisterType((*DeleteDocumentRequest)(nil), "search.DeleteDocumentRequest")
	proto.RegisterType((*DeleteDocumentResponse)(nil), "search.DeleteDocumentResponse")
	proto.RegisterType((*ListDocumentsParams)(nil), "search.ListDocumentsParams")
	proto.RegisterType((*ListDocumentsRequest)(nil), "search.ListDocumentsRequest")
	proto.RegisterType((*ListDocumentsResponse)(nil), "search.ListDocumentsResponse")
	proto.RegisterType((*ListIndexesParams)(nil), "search.ListIndexesParams")
	proto.RegisterType((*ListIndexesRequest)(nil), "search.ListIndexesRequest")
	proto.RegisterType((*ListIndexesResponse)(nil), "search.ListIndexesResponse")
	proto.RegisterType((*DeleteSchemaParams)(nil), "search.DeleteSchemaParams")
	proto.RegisterType((*DeleteSchemaRequest)(nil), "search.DeleteSchemaRequest")
	proto.RegisterType((*DeleteSchemaResponse)(nil), "search.DeleteSchemaResponse")
	proto.RegisterType((*SortSpec)(nil), "search.SortSpec")
	proto.RegisterType((*ScorerSpec)(nil), "search.ScorerSpec")
	proto.RegisterType((*FieldSpec)(nil), "search.FieldSpec")
	proto.RegisterType((*FieldSpec_Expression)(nil), "search.FieldSpec.Expression")
	proto.RegisterType((*FacetRange)(nil), "search.FacetRange")
	proto.RegisterType((*FacetRequestParam)(nil), "search.FacetRequestParam")
	proto.RegisterType((*FacetAutoDetectParam)(nil), "search.FacetAutoDetectParam")
	proto.RegisterType((*FacetRequest)(nil), "search.FacetRequest")
	proto.RegisterType((*FacetRefinement)(nil), "search.FacetRefinement")
	proto.RegisterType((*FacetRefinement_Range)(nil), "search.FacetRefinement.Range")
	proto.RegisterType((*SearchParams)(nil), "search.SearchParams")
	proto.RegisterType((*SearchRequest)(nil), "search.SearchRequest")
	proto.RegisterType((*FacetResultValue)(nil), "search.FacetResultValue")
	proto.RegisterType((*FacetResult)(nil), "search.FacetResult")
	proto.RegisterType((*SearchResult)(nil), "search.SearchResult")
	proto.RegisterType((*SearchResponse)(nil), "search.SearchResponse")
	proto.RegisterEnum("search.Scope_Type", Scope_Type_name, Scope_Type_value)
	proto.RegisterEnum("search.Entry_Permission", Entry_Permission_name, Entry_Permission_value)
	proto.RegisterEnum("search.FieldValue_ContentType", FieldValue_ContentType_name, FieldValue_ContentType_value)
	proto.RegisterEnum("search.FacetValue_ContentType", FacetValue_ContentType_name, FacetValue_ContentType_value)
	proto.RegisterEnum("search.Document_OrderIdSource", Document_OrderIdSource_name, Document_OrderIdSource_value)
	proto.RegisterEnum("search.Document_Storage", Document_Storage_name, Document_Storage_value)
	proto.RegisterEnum("search.SearchServiceError_ErrorCode", SearchServiceError_ErrorCode_name, SearchServiceError_ErrorCode_value)
	proto.RegisterEnum("search.IndexSpec_Consistency", IndexSpec_Consistency_name, IndexSpec_Consistency_value)
	proto.RegisterEnum("search.IndexSpec_Source", IndexSpec_Source_name, IndexSpec_Source_value)
	proto.RegisterEnum("search.IndexSpec_Mode", IndexSpec_Mode_name, IndexSpec_Mode_value)
	proto.RegisterEnum("search.IndexDocumentParams_Freshness", IndexDocumentParams_Freshness_name, IndexDocumentParams_Freshness_value)
	proto.RegisterEnum("search.ScorerSpec_Scorer", ScorerSpec_Scorer_name, ScorerSpec_Scorer_value)
	proto.RegisterEnum("search.SearchParams_CursorType", SearchParams_CursorType_name, SearchParams_CursorType_value)
	proto.RegisterEnum("search.SearchParams_ParsingMode", SearchParams_ParsingMode_name, SearchParams_ParsingMode_value)
}

func init() { proto.RegisterFile("search.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 2960 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x9c, 0x59, 0xcf, 0x73, 0xdb, 0xc6,
	0xf5, 0x17, 0x40, 0x91, 0x22, 0x1f, 0x49, 0x09, 0x5a, 0xfd, 0x30, 0xed, 0xf8, 0x9b, 0x28, 0x70,
	0x9c, 0x28, 0xf9, 0xda, 0xfa, 0xca, 0xb2, 0x27, 0xf1, 0x57, 0xcd, 0xb4, 0xa1, 0x49, 0x58, 0x66,
	0x4d, 0x91, 0xca, 0x12, 0x74, 0xe2, 0xce, 0x34, 0x28, 0x0a, 0xac, 0x64, 0x4c, 0x49, 0x80, 0x01,
	0x40, 0xd7, 0xba, 0x75, 0x72, 0xeb, 0xa5, 0xd3, 0x4e, 0x4f, 0x3d, 0x75, 0x32, 0xbd, 0x74, 0x7a,
	0xed, 0xbd, 0xa7, 0xf6, 0xd6, 0x5b, 0x4f, 0xfd, 0x07, 0x3a, 0x9d, 0x76, 0xa6, 0x7f, 0x43, 0x67,
	0xdf, 0x2e, 0x40, 0x80, 0xa2, 0xa3, 0xd8, 0x37, 0xe2, 0xed, 0xdb, 0xb7, 0x6f, 0xdf, 0xe7, 0xbd,
	0xcf, 0xbe, 0x5d, 0x42, 0x2d, 0x62, 0x76, 0xe8, 0x3c, 0xdb, 0x9b, 0x84, 0x41, 0x1c, 0x90, 0x92,
	0xf8, 0xd2, 0xff, 0xad, 0x40, 0x71, 0xe0, 0x04, 0x13, 0x46, 0xde, 0x85, 0xe5, 0xf8, 0x7c, 0xc2,
	0x1a, 0xca, 0x8e, 0xb2, 0xbb, 0x7a, 0x40, 0xf6, 0xa4, 0x3a, 0x0e, 0xee, 0x99, 0xe7, 0x13, 0x46,
	0x71, 0x9c, 0x6c, 0x42, 0xf1, 0xb9, 0x3d, 0x9a, 0xb2, 0x86, 0xba, 0xa3, 0xec, 0x56, 0xa8, 0xf8,
	0xd0, 0x7f, 0xa7, 0xc0, 0x32, 0x57, 0x22, 0x0d, 0xd8, 0x1c, 0x0e, 0x0c, 0x6a, 0x3d, 0x78, 0x6a,
	0xb5, 0x9a, 0xbd, 0x7e, 0xaf, 0xd3, 0x6a, 0x76, 0xad, 0x4e, 0x5b, 0x53, 0xc8, 0x3a, 0xd4, 0x93,
	0x11, 0xe3, 0xb8, 0xd9, 0xe9, 0x6a, 0x2a, 0xb9, 0x0a, 0x5b, 0x47, 0xb4, 0x3f, 0x3c, 0xb9, 0xa0,
	0x5d, 0x20, 0x04, 0x56, 0xd3, 0x21, 0xa1, 0xbe, 0x4c, 0x36, 0x60, 0x2d, 0x95, 0xb5, 0xfb, 0xc7,
	0xcd, 0x4e, 0x4f, 0x2b, 0x92, 0x3a, 0x54, 0x9a, 0xdd, 0xae, 0xc5, 0x4d, 0x0f, 0xb4, 0x12, 0x79,
	0x03, 0xae, 0xf0, 0xcf, 0xe6, 0xd0, 0x7c, 0x64, 0xf4, 0xcc, 0x4e, 0xab, 0x69, 0x1a, 0x6d, 0x39,
	0xb8, 0xa2, 0xff, 0x49, 0x81, 0xa2, 0xe1, 0xc7, 0xe1, 0x39, 0xb9, 0x01, 0xc5, 0x88, 0xef, 0x0c,
	0xb7, 0x5b, 0x3d, 0xa8, 0xe7, 0xb6, 0x4b, 0xc5, 0x18, 0xb9, 0x0f, 0x30, 0x61, 0xe1, 0xd8, 0x8b,
	0x22, 0x2f, 0xf0, 0x71, 0xbf, 0xab, 0x07, 0x8d, 0x44, 0x13, 0xed, 0xec, 0x9d, 0xa4, 0xe3, 0x34,
	0xa3, 0x4b, 0xde, 0x86, 0x9a, 0xeb, 0x45, 0x93, 0x91, 0x7d, 0x6e, 0xf9, 0xf6, 0x98, 0x35, 0x0a,
	0x18, 0xab, 0xaa, 0x94, 0xf5, 0xec, 0x31, 0xd3, 0xef, 0x02, 0xcc, 0x26, 0x93, 0x32, 0x2c, 0x53,
	0xa3, 0xc9, 0xc3, 0x54, 0x81, 0xe2, 0x67, 0xb4, 0x63, 0x1a, 0x9a, 0x4a, 0x34, 0xa8, 0x3d, 0x1c,
	0x76, 0xbb, 0x56, 0xab, 0xdf, 0x33, 0x69, 0xbf, 0xab, 0x15, 0x74, 0x0a, 0xeb, 0x4d, 0xc7, 0x61,
	0x51, 0xd4, 0x0a, 0xfc, 0x38, 0x0c, 0x46, 0x5d, 0x2f, 0x8a, 0x39, 0x22, 0xc1, 0x4f, 0x7d, 0x16,
	0xe2, 0x5e, 0x2a, 0x54, 0x7c, 0x90, 0xf7, 0x60, 0x85, 0xf9, 0x71, 0xe8, 0xb1, 0xa8, 0xa1, 0xee,
	0x14, 0xb2, 0x7b, 0x44, 0xcf, 0x69, 0x32, 0xaa, 0xff, 0x41, 0x05, 0x78, 0xe8, 0xb1, 0x91, 0xfb,
	0x84, 0x23, 0x49, 0xee, 0xe7, 0xf2, 0xe0, 0xcd, 0x64, 0xd2, 0x4c, 0x63, 0x8f, 0xaf, 0xcd, 0xfc,
	0x98, 0xc3, 0x7d, 0xb8, 0x6c, 0x1a, 0x9f, 0x9b, 0x32, 0x33, 0xde, 0x84, 0xf2, 0xc8, 0xf6, 0xcf,
	0xa6, 0xf6, 0x99, 0x4c, 0x8e, 0x43, 0x95, 0xf9, 0x34, 0x95, 0xf1, 0xa0, 0x44, 0x71, 0xe8, 0xf9,
	0x67, 0x96, 0x48, 0x20, 0x19, 0x14, 0x21, 0x13, 0x8b, 0xef, 0x42, 0xe1, 0x8c, 0x05, 0x8d, 0xe5,
	0x1d, 0x65, 0x17, 0x0e, 0xb6, 0x17, 0xac, 0x7d, 0xc4, 0x02, 0xca, 0x55, 0xae, 0xbd, 0x0f, 0x85,
	0x23, 0x16, 0x10, 0x0d, 0x0a, 0x23, 0x3b, 0x6e, 0x14, 0x77, 0xd4, 0x5d, 0x85, 0xf2, 0x9f, 0x28,
	0xf1, 0xcf, 0x1a, 0x25, 0x29, 0xf1, 0xcf, 0xf4, 0xef, 0x43, 0x35, 0xe3, 0x32, 0x0f, 0x35, 0x77,
	0x5a, 0x5b, 0xe2, 0xbf, 0x1e, 0x99, 0xc7, 0x5d, 0x4d, 0xe1, 0xbf, 0x9a, 0x66, 0xff, 0x58, 0x53,
	0xf9, 0xaf, 0x76, 0xd3, 0x34, 0xb4, 0x02, 0x01, 0x28, 0xf5, 0x86, 0xc7, 0x0f, 0x0c, 0xaa, 0x2d,
	0x93, 0x15, 0x28, 0x1c, 0x19, 0x7d, 0xad, 0xa8, 0x1b, 0x50, 0x44, 0x6f, 0x08, 0x81, 0x65, 0x44,
	0x56, 0xd9, 0x51, 0x77, 0x2b, 0x14, 0x7f, 0x93, 0xdd, 0x59, 0x69, 0xa8, 0xbb, 0xd5, 0x59, 0x0d,
	0xcd, 0xfc, 0x4f, 0xca, 0xc5, 0x94, 0x21, 0xe7, 0x0e, 0x45, 0x0b, 0x6d, 0x1d, 0x48, 0x18, 0x38,
	0x76, 0x97, 0xc2, 0x20, 0x00, 0xd0, 0xff, 0xa2, 0x00, 0xe9, 0xf8, 0x2e, 0x7b, 0x31, 0x78, 0x66,
	0x87, 0xee, 0x80, 0xc5, 0xb1, 0xe7, 0x9f, 0x45, 0xe4, 0x5d, 0x58, 0x9b, 0x84, 0xec, 0xb9, 0xe5,
	0x4f, 0xc7, 0x56, 0xc4, 0x47, 0xa2, 0x86, 0xb2, 0x53, 0xd8, 0x2d, 0xd2, 0x3a, 0x17, 0xf7, 0xa6,
	0x63, 0x54, 0x8f, 0xc8, 0x0e, 0x40, 0x46, 0x85, 0xef, 0xa1, 0x78, 0xa8, 0xdc, 0xa1, 0x15, 0x3f,
	0xd5, 0xf8, 0x2e, 0x5c, 0x9f, 0xb3, 0x64, 0x09, 0xbf, 0xac, 0x53, 0x7b, 0x14, 0x71, 0x44, 0xb9,
	0xd9, 0x46, 0xce, 0xec, 0x00, 0x15, 0x1e, 0xf2, 0x71, 0x72, 0x13, 0xea, 0xa3, 0xc0, 0xb1, 0x47,
	0x56, 0xc8, 0x26, 0x23, 0xcf, 0xb1, 0x11, 0xe8, 0xca, 0xe1, 0x12, 0xad, 0xa1, 0x98, 0x0a, 0xa9,
	0xfe, 0x0b, 0x05, 0xe0, 0xa1, 0xed, 0xb0, 0xf8, 0x9b, 0x33, 0x32, 0xd5, 0xc8, 0x67, 0x24, 0x07,
	0x52, 0x66, 0xe4, 0xe5, 0x19, 0xa7, 0xdf, 0xb8, 0x90, 0x1c, 0x32, 0x11, 0x32, 0xf0, 0x23, 0xea,
	0x7c, 0xb5, 0x57, 0x43, 0x3d, 0xf5, 0x2f, 0x41, 0xfd, 0x0b, 0xd0, 0xda, 0x81, 0x33, 0x1d, 0x33,
	0x3f, 0x3e, 0x66, 0xb1, 0xed, 0xda, 0xb1, 0x4d, 0x1a, 0xb0, 0xf2, 0x9c, 0x85, 0x48, 0x30, 0x7c,
	0x7f, 0x05, 0x9a, 0x7c, 0x92, 0x7d, 0xd8, 0x74, 0x82, 0xf1, 0xd8, 0x8b, 0x63, 0xe6, 0x5a, 0x51,
	0x6c, 0x25, 0x6a, 0x2a, 0xaa, 0x91, 0x74, 0x6c, 0x10, 0x3f, 0x11, 0x23, 0xfa, 0x7f, 0x54, 0x28,
	0x27, 0x0b, 0x90, 0x55, 0x50, 0x3d, 0x57, 0x52, 0x82, 0xea, 0xb9, 0x97, 0x56, 0xe7, 0x0d, 0x28,
	0x9e, 0xf2, 0xe4, 0x42, 0x10, 0x33, 0x6c, 0x81, 0x19, 0x47, 0xc5, 0x18, 0xb9, 0x0a, 0xe5, 0x20,
	0x74, 0x59, 0x68, 0x79, 0x2e, 0x62, 0x57, 0xa4, 0x2b, 0xf8, 0xdd, 0x71, 0xc9, 0x09, 0xac, 0x25,
	0x43, 0x56, 0x14, 0x4c, 0x43, 0x87, 0x35, 0x4a, 0x79, 0xc0, 0x12, 0xd7, 0xf6, 0xfa, 0x62, 0xca,
	0x00, 0xb5, 0x0e, 0xcb, 0x83, 0xe1, 0xc9, 0x49, 0xb7, 0x63, 0xb4, 0x69, 0x3d, 0xc8, 0x0e, 0x90,
	0xfb, 0xb0, 0x12, 0xc5, 0x41, 0xc8, 0x1d, 0x2e, 0xe6, 0xb9, 0x37, 0xb5, 0x34, 0x10, 0xe3, 0x87,
	0xcb, 0xed, 0xce, 0xe0, 0x31, 0x4d, 0xd4, 0x71, 0x2f, 0x3c, 0xfa, 0x8d, 0xf2, 0xdc, 0x5e, 0xb8,
	0x90, 0x8a, 0x31, 0xfd, 0x16, 0xd4, 0x73, 0x8e, 0xf0, 0x93, 0xa4, 0x6d, 0x3c, 0x6c, 0x0e, 0xbb,
	0xa6, 0xd1, 0xd6, 0x96, 0x48, 0x0d, 0x52, 0xcf, 0x34, 0x45, 0xdf, 0x80, 0x15, 0xb9, 0x18, 0x52,
	0x44, 0x67, 0xf0, 0x58, 0x5b, 0xd2, 0x7f, 0xaf, 0x00, 0x11, 0xf9, 0x3d, 0x60, 0xe1, 0x73, 0xcf,
	0x61, 0x46, 0x18, 0x06, 0xa1, 0xfe, 0x2b, 0x05, 0x2a, 0xf8, 0xab, 0x15, 0xb8, 0x8c, 0x94, 0x40,
	0xed, 0x3f, 0xd6, 0x96, 0xf8, 0xe9, 0xd5, 0xe9, 0x3d, 0x69, 0x76, 0x3b, 0x6d, 0x8b, 0x1a, 0x9f,
	0x0e, 0x8d, 0x81, 0xa9, 0x29, 0x5c, 0x68, 0xd2, 0x66, 0x6f, 0xd0, 0x31, 0x7a, 0xa6, 0x65, 0x50,
	0xda, 0xa7, 0x9a, 0xca, 0xcf, 0xbe, 0x4e, 0xcf, 0x34, 0x68, 0xaf, 0xd9, 0x95, 0xb2, 0x02, 0xd9,
	0x82, 0xf5, 0x13, 0x83, 0x1e, 0x77, 0x06, 0x83, 0x4e, 0xbf, 0x67, 0xb5, 0x8d, 0x1e, 0x77, 0x6b,
	0x99, 0x54, 0x61, 0xc5, 0xec, 0x1c, 0x1b, 0xfd, 0xa1, 0xa9, 0x15, 0xc9, 0x35, 0xd8, 0x6e, 0xf5,
	0x7b, 0xad, 0x21, 0xa5, 0xdc, 0x1a, 0xda, 0x6d, 0xb6, 0xcc, 0x4e, 0xbf, 0xa7, 0x95, 0xf4, 0x5f,
	0x2b, 0x50, 0xa7, 0xec, 0xcb, 0x29, 0x8b, 0xe2, 0x41, 0x6c, 0xc7, 0xd3, 0x88, 0x97, 0x95, 0x13,
	0xb8, 0x22, 0x97, 0x57, 0x0f, 0xde, 0x49, 0x4f, 0xc0, 0x0b, 0xfb, 0xd9, 0x4b, 0xf7, 0x42, 0x71,
	0x06, 0x2f, 0x2b, 0xc6, 0x45, 0x96, 0xcb, 0x62, 0xdb, 0x1b, 0xc9, 0x4e, 0xa0, 0x8a, 0xb2, 0x36,
	0x8a, 0xc8, 0x4d, 0x58, 0x75, 0x6c, 0x3f, 0xf0, 0x3d, 0x5e, 0xed, 0xb8, 0x4c, 0x01, 0xd3, 0xa5,
	0x9e, 0x4a, 0xb9, 0x3d, 0xfd, 0xeb, 0x02, 0x54, 0x04, 0x63, 0x4d, 0x98, 0xb3, 0xb0, 0xba, 0x8e,
	0xa1, 0xea, 0x04, 0x7e, 0xe4, 0x45, 0x31, 0xf3, 0x9d, 0x73, 0x79, 0x08, 0xff, 0x4f, 0xe2, 0x6c,
	0x3a, 0x97, 0x53, 0x40, 0xa2, 0x74, 0x58, 0x3b, 0x31, 0xa8, 0xd5, 0xee, 0xb7, 0x86, 0xc7, 0x46,
	0xcf, 0xa4, 0xd9, 0xf9, 0xe4, 0x3a, 0x54, 0xb8, 0xd9, 0x68, 0x62, 0x3b, 0x09, 0x1d, 0xcc, 0x04,
	0xd9, 0x62, 0x94, 0xd9, 0x9d, 0x14, 0xe3, 0x7d, 0x28, 0xc9, 0xa4, 0x9e, 0x4b, 0xc5, 0x99, 0x07,
	0x32, 0x9d, 0x4b, 0x03, 0xa3, 0x49, 0x5b, 0x8f, 0xa8, 0xd4, 0x27, 0xf7, 0x60, 0x79, 0xcc, 0xf7,
	0x2f, 0x8a, 0x61, 0xfb, 0xe2, 0xbc, 0xe3, 0xc0, 0x65, 0x87, 0xe5, 0x13, 0xda, 0xe9, 0xd3, 0x8e,
	0xf9, 0x94, 0xa2, 0xb6, 0xfe, 0xbf, 0x48, 0x4b, 0xa9, 0xdb, 0x00, 0xa5, 0xa3, 0x6e, 0xff, 0x41,
	0xb3, 0xab, 0x2d, 0xf1, 0xae, 0x20, 0xbb, 0x3f, 0x4d, 0xd1, 0x3f, 0x84, 0x92, 0x4c, 0x61, 0x00,
	0xb9, 0xbc, 0xb6, 0x84, 0xe9, 0xdc, 0x34, 0x9b, 0x03, 0xb3, 0x4f, 0x0d, 0xd1, 0x7e, 0xb5, 0xba,
	0xfd, 0x61, 0xdb, 0xe2, 0x82, 0xe6, 0x91, 0xa1, 0xa9, 0xfa, 0x3b, 0xb0, 0xcc, 0x17, 0xe7, 0x99,
	0x9e, 0x2c, 0xaf, 0x2d, 0x91, 0x55, 0x80, 0x07, 0xcd, 0xd6, 0x63, 0xde, 0x69, 0xf5, 0x78, 0xe6,
	0xff, 0x43, 0x81, 0x3a, 0x7a, 0x9b, 0x72, 0xd6, 0x3e, 0x80, 0xc7, 0x05, 0x56, 0x34, 0x61, 0x0e,
	0xa2, 0x55, 0x3d, 0x58, 0xbf, 0xb0, 0x31, 0x5a, 0xf1, 0x52, 0x64, 0x77, 0x13, 0x72, 0x11, 0xad,
	0x48, 0xfe, 0x64, 0xc4, 0x43, 0x30, 0x61, 0x98, 0x8f, 0x66, 0x45, 0x5f, 0xc0, 0xd6, 0x2c, 0x8f,
	0x75, 0xe2, 0x43, 0x52, 0xf9, 0x69, 0xcd, 0x5f, 0xfb, 0x64, 0x56, 0xa0, 0x6f, 0x41, 0xd5, 0x1e,
	0x07, 0x53, 0x3f, 0xb6, 0xa6, 0x11, 0x73, 0x25, 0xaf, 0x82, 0x10, 0x0d, 0x23, 0xe6, 0xf2, 0x8e,
	0x69, 0xe4, 0x8d, 0xbd, 0x58, 0x72, 0xa9, 0xf8, 0xd0, 0xbf, 0x52, 0x61, 0x03, 0x17, 0x49, 0xe8,
	0xe5, 0xc4, 0x0e, 0xed, 0x71, 0x44, 0x6e, 0x41, 0xd9, 0x95, 0x12, 0x3c, 0x38, 0xab, 0x07, 0xda,
	0x3c, 0x11, 0xd1, 0x54, 0x83, 0x3c, 0x81, 0xca, 0x69, 0xc8, 0xa2, 0x67, 0x3e, 0x8b, 0x22, 0x99,
	0xae, 0x37, 0x73, 0x5b, 0xc8, 0x5b, 0xdf, 0x7b, 0x98, 0x28, 0x1f, 0xd6, 0x07, 0x4f, 0x7b, 0xad,
	0x47, 0xb4, 0xdf, 0xeb, 0x0f, 0x07, 0xdd, 0xa7, 0x0f, 0xd4, 0x86, 0x42, 0x67, 0xa6, 0xe6, 0x82,
	0x5e, 0xb8, 0x3c, 0xe8, 0xfa, 0x5d, 0xa8, 0xa4, 0xc6, 0x39, 0xfc, 0x39, 0xf3, 0x82, 0x90, 0x3e,
	0x7b, 0x64, 0xf4, 0x78, 0x7b, 0xf9, 0x84, 0xf3, 0x09, 0xe6, 0xd2, 0x8f, 0x61, 0x33, 0xe7, 0xa5,
	0xe4, 0x0c, 0x72, 0x17, 0x4a, 0x13, 0x74, 0x58, 0xe2, 0xfd, 0xc6, 0x37, 0xec, 0x89, 0x4a, 0x55,
	0xb2, 0x05, 0x25, 0x7b, 0x32, 0xe1, 0x87, 0x05, 0xc7, 0xb2, 0x46, 0x8b, 0xf6, 0x64, 0xd2, 0x71,
	0xf5, 0x1f, 0xc2, 0xd6, 0xdc, 0x1a, 0xd1, 0x24, 0xf0, 0x23, 0x46, 0x6e, 0x43, 0x29, 0x42, 0x72,
	0x92, 0x71, 0xde, 0x4a, 0x16, 0xc9, 0x31, 0x17, 0x95, 0x4a, 0xdc, 0xbc, 0x1b, 0x38, 0xdc, 0x3c,
	0x4f, 0xab, 0x0a, 0x2d, 0xba, 0x81, 0xd3, 0x71, 0x75, 0x0b, 0x36, 0xdb, 0x6c, 0xc4, 0x62, 0x36,
	0x87, 0xe3, 0x4c, 0x5d, 0xc9, 0xa8, 0xcf, 0x05, 0x56, 0xfd, 0x16, 0x81, 0x75, 0x61, 0x2b, 0xbf,
	0x40, 0x12, 0xa4, 0x7b, 0x73, 0x41, 0xba, 0x9e, 0xe6, 0xc9, 0x02, 0x7f, 0x2e, 0x8b, 0xd2, 0x11,
	0x6c, 0xcf, 0xaf, 0xf2, 0x5a, 0x61, 0xd2, 0xff, 0xa6, 0xc0, 0x06, 0xbf, 0x28, 0x24, 0x76, 0x22,
	0x19, 0x8f, 0x57, 0x2f, 0xe3, 0x1d, 0xde, 0x4f, 0xd9, 0x61, 0x6c, 0xa5, 0x61, 0xe7, 0x04, 0x0a,
	0x28, 0x6b, 0xcb, 0x60, 0xae, 0x7b, 0xbe, 0x33, 0x9a, 0xba, 0xcc, 0x4a, 0x35, 0x71, 0x5b, 0xe5,
	0xc3, 0xe5, 0x38, 0x9c, 0x32, 0xba, 0x26, 0x87, 0x07, 0x72, 0x0e, 0xb9, 0x9a, 0xd4, 0x22, 0x32,
	0xee, 0x61, 0xe1, 0xce, 0xfe, 0xbe, 0x2c, 0x48, 0xf2, 0x06, 0x54, 0x7e, 0xc2, 0xce, 0x23, 0x2b,
	0xf0, 0x47, 0xe7, 0xc8, 0xbb, 0x65, 0x5a, 0xe6, 0x82, 0xbe, 0x3f, 0x3a, 0xe7, 0x89, 0x9a, 0xdb,
	0xd4, 0xa5, 0x89, 0xba, 0x20, 0x04, 0x0b, 0x20, 0x50, 0xb3, 0x10, 0xc4, 0xb0, 0x35, 0xb7, 0xc6,
	0x02, 0x04, 0xd4, 0xcb, 0x13, 0x35, 0xcb, 0x20, 0xea, 0x65, 0x0c, 0xa2, 0xff, 0x55, 0x85, 0x75,
	0xbe, 0x2c, 0x42, 0xc0, 0x12, 0xb4, 0xde, 0x86, 0xda, 0x29, 0x8b, 0x9d, 0x67, 0x56, 0xe4, 0x3c,
	0x63, 0x63, 0x1b, 0x59, 0xad, 0x4c, 0xab, 0x28, 0x1b, 0xa0, 0x88, 0x34, 0xb2, 0xb4, 0x56, 0x3c,
	0x54, 0x0f, 0xd2, 0x48, 0x7e, 0xf3, 0xb1, 0xb7, 0x0b, 0x9a, 0x00, 0x4b, 0xa4, 0x03, 0x9e, 0xc1,
	0xd8, 0x99, 0xd3, 0x55, 0x94, 0xa3, 0x23, 0xfc, 0xd2, 0x4a, 0xee, 0xc1, 0x46, 0x1e, 0x5e, 0x9c,
	0x21, 0xb0, 0x91, 0x00, 0xaf, 0x67, 0x01, 0xc6, 0x99, 0xe4, 0x03, 0x9e, 0x14, 0x89, 0x65, 0x6b,
	0x12, 0xb2, 0x53, 0xef, 0x05, 0x9e, 0x87, 0x15, 0x9e, 0x0e, 0xd2, 0xf6, 0x09, 0x8a, 0xc9, 0x36,
	0x94, 0x82, 0xd3, 0xd3, 0x88, 0xc5, 0x8d, 0x15, 0x3c, 0x81, 0xe5, 0x57, 0xe6, 0x00, 0x2e, 0xbf,
	0xda, 0x01, 0xac, 0x7f, 0x01, 0x24, 0x13, 0xcd, 0x24, 0x4d, 0xee, 0xcc, 0xa5, 0xc9, 0xd5, 0x6c,
	0x9a, 0xe4, 0x22, 0x7f, 0x59, 0x9d, 0x7e, 0x25, 0xcb, 0x2b, 0x5d, 0xe0, 0xf5, 0x72, 0xe4, 0x63,
	0x58, 0x15, 0x41, 0x1a, 0xcb, 0x23, 0x4e, 0x66, 0xca, 0xd6, 0xc2, 0xf3, 0x8f, 0xd6, 0xbd, 0xec,
	0xa7, 0xfe, 0x33, 0x05, 0x88, 0x60, 0x0b, 0x91, 0x0b, 0x32, 0x69, 0x66, 0x51, 0x53, 0x5e, 0xb1,
	0x6d, 0x99, 0x67, 0xc5, 0xc2, 0xa5, 0xac, 0xf8, 0x23, 0xd8, 0xc8, 0x7a, 0x90, 0x04, 0xfa, 0x60,
	0x2e, 0xd0, 0xd7, 0xf2, 0x9c, 0x98, 0x75, 0xf7, 0xb2, 0x48, 0x1b, 0x09, 0xb1, 0x27, 0x2b, 0xbc,
	0x1e, 0x1f, 0xfe, 0x59, 0x81, 0xf2, 0x20, 0x08, 0x63, 0xa4, 0xb4, 0xf7, 0x60, 0x2d, 0x0a, 0xc2,
	0xd8, 0x62, 0x2f, 0x26, 0x21, 0x8b, 0xe4, 0x3d, 0x4c, 0xc5, 0xd4, 0x0f, 0xc2, 0xd8, 0x48, 0xa5,
	0xe4, 0xb6, 0x54, 0x74, 0x59, 0xe4, 0x30, 0xdf, 0xf5, 0xfc, 0x33, 0x2c, 0xb3, 0x24, 0xed, 0x51,
	0xbd, 0x9d, 0x8e, 0x91, 0x5b, 0x40, 0x5c, 0x76, 0x6a, 0x4f, 0x47, 0xb1, 0xb8, 0x7b, 0x5a, 0x31,
	0x7b, 0x11, 0xcb, 0xaa, 0xd2, 0xe4, 0x08, 0x5e, 0x0e, 0x4d, 0xf6, 0x82, 0x07, 0x69, 0x2b, 0xaf,
	0xed, 0x4f, 0xc7, 0x2c, 0xf4, 0x1c, 0xac, 0x2c, 0x85, 0x6e, 0x64, 0x27, 0xf4, 0xc4, 0x90, 0xfe,
	0x77, 0x05, 0x60, 0xe0, 0x04, 0x21, 0x0b, 0x71, 0x23, 0xdf, 0x83, 0x52, 0x84, 0x5f, 0x12, 0xea,
	0xab, 0x99, 0x27, 0x2d, 0xa9, 0x23, 0x7f, 0x1e, 0xd6, 0x8e, 0x9b, 0x66, 0xeb, 0x91, 0x35, 0x68,
	0xf5, 0xa9, 0x41, 0xa9, 0x9c, 0x46, 0xae, 0xe5, 0xd9, 0x63, 0xf9, 0xce, 0xfe, 0x8c, 0x89, 0x3f,
	0x84, 0x2b, 0x63, 0x5b, 0x90, 0x0f, 0xd7, 0xb5, 0x10, 0x27, 0x16, 0xb3, 0x30, 0x6a, 0x54, 0x70,
	0x4b, 0x5b, 0x38, 0x2c, 0xec, 0x9f, 0xa4, 0x83, 0xd8, 0x99, 0x26, 0xd6, 0xb7, 0xa9, 0xc1, 0x57,
	0xec, 0xf4, 0x8e, 0xac, 0xec, 0xfa, 0xa2, 0xa3, 0xcd, 0x49, 0x54, 0xfd, 0xb7, 0x0a, 0x54, 0xb0,
	0x37, 0x9c, 0xbb, 0x17, 0x14, 0xd2, 0x7b, 0xc1, 0xc7, 0x00, 0x19, 0xc8, 0x78, 0x7e, 0xc2, 0xec,
	0xb8, 0x4d, 0xa7, 0xee, 0xcd, 0x00, 0xa4, 0x19, 0xfd, 0x6b, 0x9f, 0x00, 0x64, 0xa0, 0x4d, 0xec,
	0x17, 0x32, 0xf7, 0x8e, 0x37, 0x73, 0xf6, 0x97, 0x71, 0x24, 0x23, 0xd1, 0x1f, 0xc9, 0x27, 0x0a,
	0x6a, 0xfb, 0x67, 0x2c, 0xe3, 0xa1, 0x92, 0x5a, 0xd8, 0x84, 0x22, 0x72, 0x64, 0xf2, 0x50, 0x8a,
	0x1f, 0x44, 0x83, 0x02, 0xf3, 0x5d, 0xc9, 0xc1, 0xfc, 0xa7, 0xfe, 0x73, 0x05, 0xd6, 0x85, 0x29,
	0x91, 0xad, 0x18, 0x3e, 0xde, 0xc3, 0x8a, 0x4c, 0x10, 0x98, 0x28, 0x48, 0x86, 0x80, 0xa2, 0x2e,
	0x42, 0xb2, 0x0b, 0xc5, 0x90, 0xaf, 0x7d, 0xa1, 0xa5, 0x4e, 0xbd, 0xa2, 0x42, 0x81, 0xbc, 0x0f,
	0x9a, 0x30, 0xc5, 0x2f, 0x42, 0x71, 0x68, 0x7b, 0x7e, 0x8c, 0x97, 0xfc, 0x0a, 0x5d, 0x43, 0x79,
	0x2b, 0x15, 0xeb, 0xdf, 0x81, 0x4d, 0x9c, 0xdf, 0x9c, 0xc6, 0x41, 0x9b, 0xc5, 0xcc, 0x91, 0xde,
	0xdc, 0x58, 0xe0, 0xcd, 0xa1, 0x7a, 0x67, 0x3f, 0xeb, 0x91, 0x3e, 0x84, 0x5a, 0x76, 0x1f, 0x0b,
	0xaf, 0x73, 0x33, 0xda, 0x55, 0xb1, 0xbb, 0xbf, 0x9a, 0x77, 0x3b, 0x13, 0x81, 0x84, 0x0c, 0xf4,
	0xaf, 0x15, 0x58, 0x93, 0xa3, 0xa7, 0x9e, 0xcf, 0xb0, 0xc9, 0x5e, 0x64, 0x7a, 0xe1, 0xc3, 0x34,
	0xb9, 0x9b, 0x84, 0x69, 0xee, 0x36, 0x31, 0x67, 0x71, 0x2f, 0x1b, 0xb1, 0x6b, 0xff, 0x07, 0x45,
	0x81, 0x6b, 0x8a, 0xa1, 0xb2, 0x00, 0x43, 0x75, 0x86, 0xe1, 0x1f, 0x57, 0xa0, 0x26, 0x2e, 0xce,
	0xaf, 0xdd, 0x5b, 0x6d, 0x42, 0xf1, 0xcb, 0x29, 0x0b, 0xcf, 0xb1, 0x03, 0xad, 0x50, 0xf1, 0xc1,
	0x8f, 0x43, 0x67, 0x1a, 0x46, 0x41, 0x28, 0xa9, 0x43, 0x7e, 0x65, 0x8e, 0xc9, 0x6a, 0xee, 0x98,
	0x7c, 0x08, 0x55, 0xa1, 0x61, 0xe1, 0x93, 0x99, 0xb8, 0xac, 0xbe, 0x95, 0xbf, 0xdb, 0xcb, 0x8b,
	0x47, 0x0b, 0xf5, 0xc4, 0x9b, 0x59, 0xaf, 0xdf, 0x33, 0x28, 0x38, 0xa9, 0x64, 0xd6, 0x4a, 0x94,
	0xe6, 0x5b, 0x89, 0x7b, 0xb0, 0x8d, 0xb5, 0xce, 0x5c, 0xcb, 0xc1, 0x3b, 0x96, 0xed, 0x38, 0xd3,
	0xd0, 0x76, 0xce, 0xe5, 0x81, 0xbd, 0x29, 0x47, 0x5b, 0x7c, 0xb0, 0x29, 0xc7, 0xc8, 0x6d, 0xa8,
	0x20, 0x7b, 0x62, 0x38, 0xca, 0xf9, 0x16, 0x28, 0xe1, 0x62, 0x5a, 0x8e, 0x12, 0x56, 0xbe, 0x0b,
	0x55, 0xc9, 0x34, 0x38, 0xa1, 0x82, 0xd8, 0x91, 0x8b, 0x8c, 0x46, 0x21, 0x9a, 0x31, 0xe0, 0x3e,
	0x00, 0xde, 0x21, 0xc5, 0x1c, 0xc0, 0x39, 0xeb, 0x17, 0x28, 0x81, 0x56, 0x4e, 0x53, 0x62, 0xc9,
	0x35, 0x98, 0xb5, 0x7c, 0x83, 0x49, 0x1e, 0x43, 0x6d, 0x62, 0x87, 0x91, 0xe7, 0x9f, 0x59, 0x78,
	0x81, 0xaf, 0x63, 0x2c, 0x77, 0x16, 0xc6, 0xf2, 0x44, 0x28, 0xe2, 0x55, 0xbe, 0x34, 0x30, 0x69,
	0xa7, 0x65, 0xd2, 0xea, 0x64, 0x26, 0x24, 0x1f, 0xc3, 0x55, 0x7b, 0x1a, 0x07, 0x96, 0xeb, 0x45,
	0x4e, 0xf0, 0x9c, 0x85, 0x16, 0xbe, 0x41, 0x89, 0x08, 0x36, 0xd6, 0x30, 0xc6, 0xca, 0x3e, 0xdd,
	0xe6, 0x3a, 0x6d, 0xa9, 0x82, 0x19, 0x8a, 0x51, 0x24, 0xff, 0x0f, 0xf5, 0xa4, 0xed, 0x12, 0xef,
	0x5a, 0x1a, 0x46, 0x70, 0x73, 0x51, 0xf1, 0xd0, 0x9a, 0x54, 0x15, 0x2f, 0x96, 0x0f, 0x40, 0x13,
	0x4b, 0x85, 0x69, 0xae, 0x37, 0xd6, 0x71, 0xf6, 0x95, 0x97, 0x94, 0x02, 0x5d, 0x3b, 0x9d, 0xab,
	0xb6, 0x01, 0x5c, 0x11, 0x36, 0xc4, 0x16, 0x90, 0x17, 0xc4, 0x11, 0xd0, 0x20, 0x18, 0xe5, 0xeb,
	0x39, 0x53, 0x73, 0xe4, 0x41, 0x37, 0x4f, 0x17, 0x51, 0xca, 0x4d, 0xa8, 0x0a, 0xa3, 0x2e, 0x9b,
	0xc4, 0xcf, 0x1a, 0x1b, 0x99, 0x43, 0x07, 0x70, 0xa0, 0xcd, 0xe5, 0xfa, 0x01, 0xc0, 0x2c, 0x51,
	0x49, 0x19, 0x30, 0x55, 0xb5, 0x25, 0x7c, 0xe9, 0xe8, 0xf4, 0x8e, 0xba, 0x86, 0xa6, 0x90, 0x55,
	0x80, 0x13, 0x83, 0x5a, 0xd4, 0x18, 0x0c, 0xbb, 0xa6, 0xa6, 0xea, 0xef, 0x42, 0x35, 0x03, 0x08,
	0xaa, 0x22, 0x24, 0xda, 0x12, 0xa9, 0xc2, 0x0a, 0x35, 0xba, 0xcd, 0xcf, 0xf1, 0x4d, 0xcf, 0x84,
	0xba, 0x40, 0x31, 0x61, 0xac, 0x5b, 0x73, 0xbd, 0xca, 0xe6, 0x22, 0xb0, 0x2f, 0xeb, 0x52, 0xa6,
	0xa0, 0xc9, 0x88, 0x46, 0xc9, 0x91, 0xfd, 0x32, 0xbe, 0x12, 0xf0, 0xe3, 0x4b, 0x3b, 0x15, 0x1f,
	0xe4, 0x23, 0x80, 0x0c, 0x52, 0xe2, 0x9a, 0xff, 0x52, 0xa4, 0x32, 0xaa, 0xfa, 0xa7, 0x50, 0xcd,
	0x2c, 0xbb, 0x70, 0xc5, 0xbd, 0x19, 0x43, 0xf2, 0x04, 0x68, 0xcc, 0x99, 0x4d, 0xdd, 0x4d, 0xde,
	0xab, 0x7f, 0xa3, 0x24, 0xac, 0x26, 0x8d, 0xe6, 0x5f, 0x42, 0xd4, 0x4b, 0x5e, 0x42, 0x6e, 0xcf,
	0x1d, 0xa1, 0x0b, 0x9e, 0x95, 0x33, 0x0a, 0xc8, 0xb5, 0xbc, 0x98, 0xd1, 0x3b, 0x85, 0x8a, 0x8f,
	0x0c, 0x01, 0x16, 0xb2, 0x04, 0xa8, 0xff, 0x4b, 0x81, 0xd5, 0xd4, 0x37, 0xd1, 0x06, 0xde, 0x82,
	0x52, 0x88, 0x7e, 0xca, 0x36, 0x70, 0x0e, 0x3d, 0xb1, 0x07, 0x2a, 0x75, 0xc8, 0x0d, 0xa8, 0xe7,
	0x78, 0x0c, 0x61, 0x28, 0xd0, 0x5a, 0x96, 0xbe, 0x32, 0x9d, 0x65, 0xe1, 0xdb, 0xf4, 0xf0, 0x2f,
	0x63, 0xeb, 0x0f, 0xa1, 0x96, 0x14, 0x21, 0xfa, 0x57, 0x44, 0xff, 0x36, 0x16, 0xc4, 0x9f, 0x56,
	0x4f, 0x67, 0x1f, 0x1f, 0x94, 0xca, 0xff, 0x5c, 0xd1, 0x7e, 0xd9, 0x7b, 0x50, 0xfe, 0x81, 0xfc,
	0xbf, 0xf6, 0xbf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x0c, 0x12, 0xcb, 0x31, 0xc6, 0x1d, 0x00, 0x00,
}
