package servicefabric

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// DeployedApplicationHealthsClient is the client for the DeployedApplicationHealths methods of the Servicefabric
// service.
type DeployedApplicationHealthsClient struct {
	BaseClient
}

// NewDeployedApplicationHealthsClient creates an instance of the DeployedApplicationHealthsClient client.
func NewDeployedApplicationHealthsClient(timeout *int32) DeployedApplicationHealthsClient {
	return NewDeployedApplicationHealthsClientWithBaseURI(DefaultBaseURI, timeout)
}

// NewDeployedApplicationHealthsClientWithBaseURI creates an instance of the DeployedApplicationHealthsClient client.
func NewDeployedApplicationHealthsClientWithBaseURI(baseURI string, timeout *int32) DeployedApplicationHealthsClient {
	return DeployedApplicationHealthsClient{NewWithBaseURI(baseURI, timeout)}
}

// Get get deployed application healths
// Parameters:
// nodeName - the name of the node
// applicationName - the name of the application
// eventsHealthStateFilter - the filter of the events health state
// deployedServicePackagesHealthStateFilter - the filter of the deployed service packages health state
func (client DeployedApplicationHealthsClient) Get(ctx context.Context, nodeName string, applicationName string, eventsHealthStateFilter string, deployedServicePackagesHealthStateFilter string) (result DeployedApplicationHealth, err error) {
	req, err := client.GetPreparer(ctx, nodeName, applicationName, eventsHealthStateFilter, deployedServicePackagesHealthStateFilter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.DeployedApplicationHealthsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "servicefabric.DeployedApplicationHealthsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.DeployedApplicationHealthsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client DeployedApplicationHealthsClient) GetPreparer(ctx context.Context, nodeName string, applicationName string, eventsHealthStateFilter string, deployedServicePackagesHealthStateFilter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"applicationName": applicationName,
		"nodeName":        autorest.Encode("path", nodeName),
	}

	const APIVersion = "1.0.0"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(eventsHealthStateFilter) > 0 {
		queryParameters["EventsHealthStateFilter"] = autorest.Encode("query", eventsHealthStateFilter)
	}
	if len(deployedServicePackagesHealthStateFilter) > 0 {
		queryParameters["DeployedServicePackagesHealthStateFilter"] = autorest.Encode("query", deployedServicePackagesHealthStateFilter)
	}
	if client.Timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *client.Timeout)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Nodes/{nodeName}/$/GetApplications/{applicationName}/$/GetHealth", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client DeployedApplicationHealthsClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client DeployedApplicationHealthsClient) GetResponder(resp *http.Response) (result DeployedApplicationHealth, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Send send deployed application health
// Parameters:
// nodeName - the name of the node
// applicationName - the name of the application
// deployedApplicationHealthReport - the report of the deployed application health
func (client DeployedApplicationHealthsClient) Send(ctx context.Context, nodeName string, applicationName string, deployedApplicationHealthReport DeployedApplicationHealthReport) (result String, err error) {
	req, err := client.SendPreparer(ctx, nodeName, applicationName, deployedApplicationHealthReport)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.DeployedApplicationHealthsClient", "Send", nil, "Failure preparing request")
		return
	}

	resp, err := client.SendSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "servicefabric.DeployedApplicationHealthsClient", "Send", resp, "Failure sending request")
		return
	}

	result, err = client.SendResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.DeployedApplicationHealthsClient", "Send", resp, "Failure responding to request")
	}

	return
}

// SendPreparer prepares the Send request.
func (client DeployedApplicationHealthsClient) SendPreparer(ctx context.Context, nodeName string, applicationName string, deployedApplicationHealthReport DeployedApplicationHealthReport) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"applicationName": applicationName,
		"nodeName":        autorest.Encode("path", nodeName),
	}

	const APIVersion = "1.0.0"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if client.Timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *client.Timeout)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Nodes/{nodeName}/$/GetApplications/{applicationName}/$/ReportHealth", pathParameters),
		autorest.WithJSON(deployedApplicationHealthReport),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SendSender sends the Send request. The method will close the
// http.Response Body if it receives an error.
func (client DeployedApplicationHealthsClient) SendSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// SendResponder handles the response to the Send request. The method always
// closes the http.Response Body.
func (client DeployedApplicationHealthsClient) SendResponder(resp *http.Response) (result String, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
