package keyvault

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// ActionType enumerates the values for action type.
type ActionType string

const (
	// AutoRenew ...
	AutoRenew ActionType = "AutoRenew"
	// EmailContacts ...
	EmailContacts ActionType = "EmailContacts"
)

// PossibleActionTypeValues returns an array of possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{AutoRenew, EmailContacts}
}

// DeletionRecoveryLevel enumerates the values for deletion recovery level.
type DeletionRecoveryLevel string

const (
	// Purgeable Soft-delete is not enabled for this vault. A DELETE operation results in immediate and
	// irreversible data loss.
	Purgeable DeletionRecoveryLevel = "Purgeable"
	// Recoverable Soft-delete is enabled for this vault and purge has been disabled. A deleted entity will
	// remain in this state until recovered, or the end of the retention interval.
	Recoverable DeletionRecoveryLevel = "Recoverable"
	// RecoverableProtectedSubscription Soft-delete is enabled for this vault, and the subscription is
	// protected against immediate deletion.
	RecoverableProtectedSubscription DeletionRecoveryLevel = "Recoverable+ProtectedSubscription"
	// RecoverablePurgeable Soft-delete is enabled for this vault; A priveleged user may trigger an immediate,
	// irreversible deletion(purge) of a deleted entity.
	RecoverablePurgeable DeletionRecoveryLevel = "Recoverable+Purgeable"
)

// PossibleDeletionRecoveryLevelValues returns an array of possible values for the DeletionRecoveryLevel const type.
func PossibleDeletionRecoveryLevelValues() []DeletionRecoveryLevel {
	return []DeletionRecoveryLevel{Purgeable, Recoverable, RecoverableProtectedSubscription, RecoverablePurgeable}
}

// JSONWebKeyCurveName enumerates the values for json web key curve name.
type JSONWebKeyCurveName string

const (
	// P256 The NIST P-256 elliptic curve, AKA SECG curve SECP256R1.
	P256 JSONWebKeyCurveName = "P-256"
	// P384 The NIST P-384 elliptic curve, AKA SECG curve SECP384R1.
	P384 JSONWebKeyCurveName = "P-384"
	// P521 The NIST P-521 elliptic curve, AKA SECG curve SECP521R1.
	P521 JSONWebKeyCurveName = "P-521"
	// SECP256K1 The SECG SECP256K1 elliptic curve.
	SECP256K1 JSONWebKeyCurveName = "SECP256K1"
)

// PossibleJSONWebKeyCurveNameValues returns an array of possible values for the JSONWebKeyCurveName const type.
func PossibleJSONWebKeyCurveNameValues() []JSONWebKeyCurveName {
	return []JSONWebKeyCurveName{P256, P384, P521, SECP256K1}
}

// JSONWebKeyEncryptionAlgorithm enumerates the values for json web key encryption algorithm.
type JSONWebKeyEncryptionAlgorithm string

const (
	// RSA15 ...
	RSA15 JSONWebKeyEncryptionAlgorithm = "RSA1_5"
	// RSAOAEP ...
	RSAOAEP JSONWebKeyEncryptionAlgorithm = "RSA-OAEP"
	// RSAOAEP256 ...
	RSAOAEP256 JSONWebKeyEncryptionAlgorithm = "RSA-OAEP-256"
)

// PossibleJSONWebKeyEncryptionAlgorithmValues returns an array of possible values for the JSONWebKeyEncryptionAlgorithm const type.
func PossibleJSONWebKeyEncryptionAlgorithmValues() []JSONWebKeyEncryptionAlgorithm {
	return []JSONWebKeyEncryptionAlgorithm{RSA15, RSAOAEP, RSAOAEP256}
}

// JSONWebKeyOperation enumerates the values for json web key operation.
type JSONWebKeyOperation string

const (
	// Decrypt ...
	Decrypt JSONWebKeyOperation = "decrypt"
	// Encrypt ...
	Encrypt JSONWebKeyOperation = "encrypt"
	// Sign ...
	Sign JSONWebKeyOperation = "sign"
	// UnwrapKey ...
	UnwrapKey JSONWebKeyOperation = "unwrapKey"
	// Verify ...
	Verify JSONWebKeyOperation = "verify"
	// WrapKey ...
	WrapKey JSONWebKeyOperation = "wrapKey"
)

// PossibleJSONWebKeyOperationValues returns an array of possible values for the JSONWebKeyOperation const type.
func PossibleJSONWebKeyOperationValues() []JSONWebKeyOperation {
	return []JSONWebKeyOperation{Decrypt, Encrypt, Sign, UnwrapKey, Verify, WrapKey}
}

// JSONWebKeySignatureAlgorithm enumerates the values for json web key signature algorithm.
type JSONWebKeySignatureAlgorithm string

const (
	// ECDSA256 ...
	ECDSA256 JSONWebKeySignatureAlgorithm = "ECDSA256"
	// ES256 ...
	ES256 JSONWebKeySignatureAlgorithm = "ES256"
	// ES384 ...
	ES384 JSONWebKeySignatureAlgorithm = "ES384"
	// ES512 ...
	ES512 JSONWebKeySignatureAlgorithm = "ES512"
	// PS256 ...
	PS256 JSONWebKeySignatureAlgorithm = "PS256"
	// PS384 ...
	PS384 JSONWebKeySignatureAlgorithm = "PS384"
	// PS512 ...
	PS512 JSONWebKeySignatureAlgorithm = "PS512"
	// RS256 ...
	RS256 JSONWebKeySignatureAlgorithm = "RS256"
	// RS384 ...
	RS384 JSONWebKeySignatureAlgorithm = "RS384"
	// RS512 ...
	RS512 JSONWebKeySignatureAlgorithm = "RS512"
	// RSNULL ...
	RSNULL JSONWebKeySignatureAlgorithm = "RSNULL"
)

// PossibleJSONWebKeySignatureAlgorithmValues returns an array of possible values for the JSONWebKeySignatureAlgorithm const type.
func PossibleJSONWebKeySignatureAlgorithmValues() []JSONWebKeySignatureAlgorithm {
	return []JSONWebKeySignatureAlgorithm{ECDSA256, ES256, ES384, ES512, PS256, PS384, PS512, RS256, RS384, RS512, RSNULL}
}

// JSONWebKeyType enumerates the values for json web key type.
type JSONWebKeyType string

const (
	// EC ...
	EC JSONWebKeyType = "EC"
	// ECHSM ...
	ECHSM JSONWebKeyType = "EC-HSM"
	// Oct ...
	Oct JSONWebKeyType = "oct"
	// RSA ...
	RSA JSONWebKeyType = "RSA"
	// RSAHSM ...
	RSAHSM JSONWebKeyType = "RSA-HSM"
)

// PossibleJSONWebKeyTypeValues returns an array of possible values for the JSONWebKeyType const type.
func PossibleJSONWebKeyTypeValues() []JSONWebKeyType {
	return []JSONWebKeyType{EC, ECHSM, Oct, RSA, RSAHSM}
}

// KeyUsageType enumerates the values for key usage type.
type KeyUsageType string

const (
	// CRLSign ...
	CRLSign KeyUsageType = "cRLSign"
	// DataEncipherment ...
	DataEncipherment KeyUsageType = "dataEncipherment"
	// DecipherOnly ...
	DecipherOnly KeyUsageType = "decipherOnly"
	// DigitalSignature ...
	DigitalSignature KeyUsageType = "digitalSignature"
	// EncipherOnly ...
	EncipherOnly KeyUsageType = "encipherOnly"
	// KeyAgreement ...
	KeyAgreement KeyUsageType = "keyAgreement"
	// KeyCertSign ...
	KeyCertSign KeyUsageType = "keyCertSign"
	// KeyEncipherment ...
	KeyEncipherment KeyUsageType = "keyEncipherment"
	// NonRepudiation ...
	NonRepudiation KeyUsageType = "nonRepudiation"
)

// PossibleKeyUsageTypeValues returns an array of possible values for the KeyUsageType const type.
func PossibleKeyUsageTypeValues() []KeyUsageType {
	return []KeyUsageType{CRLSign, DataEncipherment, DecipherOnly, DigitalSignature, EncipherOnly, KeyAgreement, KeyCertSign, KeyEncipherment, NonRepudiation}
}

// Action the action that will be executed.
type Action struct {
	// ActionType - The type of the action. Possible values include: 'EmailContacts', 'AutoRenew'
	ActionType ActionType `json:"action_type,omitempty"`
}

// AdministratorDetails details of the organization administrator of the certificate issuer.
type AdministratorDetails struct {
	// FirstName - First name.
	FirstName *string `json:"first_name,omitempty"`
	// LastName - Last name.
	LastName *string `json:"last_name,omitempty"`
	// EmailAddress - Email addresss.
	EmailAddress *string `json:"email,omitempty"`
	// Phone - Phone number.
	Phone *string `json:"phone,omitempty"`
}

// Attributes the object attributes managed by the KeyVault service.
type Attributes struct {
	// Enabled - Determines whether the object is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// NotBefore - Not before date in UTC.
	NotBefore *date.UnixTime `json:"nbf,omitempty"`
	// Expires - Expiry date in UTC.
	Expires *date.UnixTime `json:"exp,omitempty"`
	// Created - Creation time in UTC.
	Created *date.UnixTime `json:"created,omitempty"`
	// Updated - Last updated time in UTC.
	Updated *date.UnixTime `json:"updated,omitempty"`
}

// BackupKeyResult the backup key result, containing the backup blob.
type BackupKeyResult struct {
	autorest.Response `json:"-"`
	// Value - The backup blob containing the backed up key.
	Value *string `json:"value,omitempty"`
}

// BackupSecretResult the backup secret result, containing the backup blob.
type BackupSecretResult struct {
	autorest.Response `json:"-"`
	// Value - The backup blob containing the backed up secret.
	Value *string `json:"value,omitempty"`
}

// CertificateAttributes the certificate management attributes.
type CertificateAttributes struct {
	// RecoveryLevel - Reflects the deletion recovery level currently in effect for certificates in the current vault. If it contains 'Purgeable', the certificate can be permanently deleted by a privileged user; otherwise, only the system can purge the certificate, at the end of the retention interval. Possible values include: 'Purgeable', 'RecoverablePurgeable', 'Recoverable', 'RecoverableProtectedSubscription'
	RecoveryLevel DeletionRecoveryLevel `json:"recoveryLevel,omitempty"`
	// Enabled - Determines whether the object is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// NotBefore - Not before date in UTC.
	NotBefore *date.UnixTime `json:"nbf,omitempty"`
	// Expires - Expiry date in UTC.
	Expires *date.UnixTime `json:"exp,omitempty"`
	// Created - Creation time in UTC.
	Created *date.UnixTime `json:"created,omitempty"`
	// Updated - Last updated time in UTC.
	Updated *date.UnixTime `json:"updated,omitempty"`
}

// CertificateBundle a certificate bundle consists of a certificate (X509) plus its attributes.
type CertificateBundle struct {
	autorest.Response `json:"-"`
	// ID - The certificate id.
	ID *string `json:"id,omitempty"`
	// Kid - The key id.
	Kid *string `json:"kid,omitempty"`
	// Sid - The secret id.
	Sid *string `json:"sid,omitempty"`
	// X509Thumbprint - Thumbprint of the certificate.
	X509Thumbprint *string `json:"x5t,omitempty"`
	// Policy - The management policy.
	Policy *CertificatePolicy `json:"policy,omitempty"`
	// Cer - CER contents of x509 certificate.
	Cer *[]byte `json:"cer,omitempty"`
	// ContentType - The content type of the secret.
	ContentType *string `json:"contentType,omitempty"`
	// Attributes - The certificate attributes.
	Attributes *CertificateAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CertificateBundle.
func (cb CertificateBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cb.ID != nil {
		objectMap["id"] = cb.ID
	}
	if cb.Kid != nil {
		objectMap["kid"] = cb.Kid
	}
	if cb.Sid != nil {
		objectMap["sid"] = cb.Sid
	}
	if cb.X509Thumbprint != nil {
		objectMap["x5t"] = cb.X509Thumbprint
	}
	if cb.Policy != nil {
		objectMap["policy"] = cb.Policy
	}
	if cb.Cer != nil {
		objectMap["cer"] = cb.Cer
	}
	if cb.ContentType != nil {
		objectMap["contentType"] = cb.ContentType
	}
	if cb.Attributes != nil {
		objectMap["attributes"] = cb.Attributes
	}
	if cb.Tags != nil {
		objectMap["tags"] = cb.Tags
	}
	return json.Marshal(objectMap)
}

// CertificateCreateParameters the certificate create parameters.
type CertificateCreateParameters struct {
	// CertificatePolicy - The management policy for the certificate.
	CertificatePolicy *CertificatePolicy `json:"policy,omitempty"`
	// CertificateAttributes - The attributes of the certificate (optional).
	CertificateAttributes *CertificateAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CertificateCreateParameters.
func (ccp CertificateCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccp.CertificatePolicy != nil {
		objectMap["policy"] = ccp.CertificatePolicy
	}
	if ccp.CertificateAttributes != nil {
		objectMap["attributes"] = ccp.CertificateAttributes
	}
	if ccp.Tags != nil {
		objectMap["tags"] = ccp.Tags
	}
	return json.Marshal(objectMap)
}

// CertificateImportParameters the certificate import parameters.
type CertificateImportParameters struct {
	// Base64EncodedCertificate - Base64 encoded representation of the certificate object to import. This certificate needs to contain the private key.
	Base64EncodedCertificate *string `json:"value,omitempty"`
	// Password - If the private key in base64EncodedCertificate is encrypted, the password used for encryption.
	Password *string `json:"pwd,omitempty"`
	// CertificatePolicy - The management policy for the certificate.
	CertificatePolicy *CertificatePolicy `json:"policy,omitempty"`
	// CertificateAttributes - The attributes of the certificate (optional).
	CertificateAttributes *CertificateAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CertificateImportParameters.
func (cip CertificateImportParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cip.Base64EncodedCertificate != nil {
		objectMap["value"] = cip.Base64EncodedCertificate
	}
	if cip.Password != nil {
		objectMap["pwd"] = cip.Password
	}
	if cip.CertificatePolicy != nil {
		objectMap["policy"] = cip.CertificatePolicy
	}
	if cip.CertificateAttributes != nil {
		objectMap["attributes"] = cip.CertificateAttributes
	}
	if cip.Tags != nil {
		objectMap["tags"] = cip.Tags
	}
	return json.Marshal(objectMap)
}

// CertificateIssuerItem the certificate issuer item containing certificate issuer metadata.
type CertificateIssuerItem struct {
	// ID - Certificate Identifier.
	ID *string `json:"id,omitempty"`
	// Provider - The issuer provider.
	Provider *string `json:"provider,omitempty"`
}

// CertificateIssuerListResult the certificate issuer list result.
type CertificateIssuerListResult struct {
	autorest.Response `json:"-"`
	// Value - A response message containing a list of certificate issuers in the key vault along with a link to the next page of certificate issuers.
	Value *[]CertificateIssuerItem `json:"value,omitempty"`
	// NextLink - The URL to get the next set of certificate issuers.
	NextLink *string `json:"nextLink,omitempty"`
}

// CertificateIssuerListResultIterator provides access to a complete listing of CertificateIssuerItem values.
type CertificateIssuerListResultIterator struct {
	i    int
	page CertificateIssuerListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CertificateIssuerListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CertificateIssuerListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CertificateIssuerListResultIterator) Response() CertificateIssuerListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CertificateIssuerListResultIterator) Value() CertificateIssuerItem {
	if !iter.page.NotDone() {
		return CertificateIssuerItem{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (cilr CertificateIssuerListResult) IsEmpty() bool {
	return cilr.Value == nil || len(*cilr.Value) == 0
}

// certificateIssuerListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cilr CertificateIssuerListResult) certificateIssuerListResultPreparer() (*http.Request, error) {
	if cilr.NextLink == nil || len(to.String(cilr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cilr.NextLink)))
}

// CertificateIssuerListResultPage contains a page of CertificateIssuerItem values.
type CertificateIssuerListResultPage struct {
	fn   func(CertificateIssuerListResult) (CertificateIssuerListResult, error)
	cilr CertificateIssuerListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CertificateIssuerListResultPage) Next() error {
	next, err := page.fn(page.cilr)
	if err != nil {
		return err
	}
	page.cilr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CertificateIssuerListResultPage) NotDone() bool {
	return !page.cilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CertificateIssuerListResultPage) Response() CertificateIssuerListResult {
	return page.cilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CertificateIssuerListResultPage) Values() []CertificateIssuerItem {
	if page.cilr.IsEmpty() {
		return nil
	}
	return *page.cilr.Value
}

// CertificateIssuerSetParameters the certificate issuer set parameters.
type CertificateIssuerSetParameters struct {
	// Provider - The issuer provider.
	Provider *string `json:"provider,omitempty"`
	// Credentials - The credentials to be used for the issuer.
	Credentials *IssuerCredentials `json:"credentials,omitempty"`
	// OrganizationDetails - Details of the organization as provided to the issuer.
	OrganizationDetails *OrganizationDetails `json:"org_details,omitempty"`
	// Attributes - Attributes of the issuer object.
	Attributes *IssuerAttributes `json:"attributes,omitempty"`
}

// CertificateIssuerUpdateParameters the certificate issuer update parameters.
type CertificateIssuerUpdateParameters struct {
	// Provider - The issuer provider.
	Provider *string `json:"provider,omitempty"`
	// Credentials - The credentials to be used for the issuer.
	Credentials *IssuerCredentials `json:"credentials,omitempty"`
	// OrganizationDetails - Details of the organization as provided to the issuer.
	OrganizationDetails *OrganizationDetails `json:"org_details,omitempty"`
	// Attributes - Attributes of the issuer object.
	Attributes *IssuerAttributes `json:"attributes,omitempty"`
}

// CertificateItem the certificate item containing certificate metadata.
type CertificateItem struct {
	// ID - Certificate identifier.
	ID *string `json:"id,omitempty"`
	// Attributes - The certificate management attributes.
	Attributes *CertificateAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
	// X509Thumbprint - Thumbprint of the certificate.
	X509Thumbprint *string `json:"x5t,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateItem.
func (ci CertificateItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ci.ID != nil {
		objectMap["id"] = ci.ID
	}
	if ci.Attributes != nil {
		objectMap["attributes"] = ci.Attributes
	}
	if ci.Tags != nil {
		objectMap["tags"] = ci.Tags
	}
	if ci.X509Thumbprint != nil {
		objectMap["x5t"] = ci.X509Thumbprint
	}
	return json.Marshal(objectMap)
}

// CertificateListResult the certificate list result.
type CertificateListResult struct {
	autorest.Response `json:"-"`
	// Value - A response message containing a list of certificates in the key vault along with a link to the next page of certificates.
	Value *[]CertificateItem `json:"value,omitempty"`
	// NextLink - The URL to get the next set of certificates.
	NextLink *string `json:"nextLink,omitempty"`
}

// CertificateListResultIterator provides access to a complete listing of CertificateItem values.
type CertificateListResultIterator struct {
	i    int
	page CertificateListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CertificateListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CertificateListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CertificateListResultIterator) Response() CertificateListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CertificateListResultIterator) Value() CertificateItem {
	if !iter.page.NotDone() {
		return CertificateItem{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (clr CertificateListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// certificateListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr CertificateListResult) certificateListResultPreparer() (*http.Request, error) {
	if clr.NextLink == nil || len(to.String(clr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// CertificateListResultPage contains a page of CertificateItem values.
type CertificateListResultPage struct {
	fn  func(CertificateListResult) (CertificateListResult, error)
	clr CertificateListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CertificateListResultPage) Next() error {
	next, err := page.fn(page.clr)
	if err != nil {
		return err
	}
	page.clr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CertificateListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CertificateListResultPage) Response() CertificateListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CertificateListResultPage) Values() []CertificateItem {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// CertificateMergeParameters the certificate merge parameters
type CertificateMergeParameters struct {
	// X509Certificates - The certificate or the certificate chain to merge.
	X509Certificates *[][]byte `json:"x5c,omitempty"`
	// CertificateAttributes - The attributes of the certificate (optional).
	CertificateAttributes *CertificateAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CertificateMergeParameters.
func (cmp CertificateMergeParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cmp.X509Certificates != nil {
		objectMap["x5c"] = cmp.X509Certificates
	}
	if cmp.CertificateAttributes != nil {
		objectMap["attributes"] = cmp.CertificateAttributes
	}
	if cmp.Tags != nil {
		objectMap["tags"] = cmp.Tags
	}
	return json.Marshal(objectMap)
}

// CertificateOperation a certificate operation is returned in case of asynchronous requests.
type CertificateOperation struct {
	autorest.Response `json:"-"`
	// ID - The certificate id.
	ID *string `json:"id,omitempty"`
	// IssuerParameters - Parameters for the issuer of the X509 component of a certificate.
	IssuerParameters *IssuerParameters `json:"issuer,omitempty"`
	// Csr - The certificate signing request (CSR) that is being used in the certificate operation.
	Csr *[]byte `json:"csr,omitempty"`
	// CancellationRequested - Indicates if cancellation was requested on the certificate operation.
	CancellationRequested *bool `json:"cancellation_requested,omitempty"`
	// Status - Status of the certificate operation.
	Status *string `json:"status,omitempty"`
	// StatusDetails - The status details of the certificate operation.
	StatusDetails *string `json:"status_details,omitempty"`
	// Error - Error encountered, if any, during the certificate operation.
	Error *Error `json:"error,omitempty"`
	// Target - Location which contains the result of the certificate operation.
	Target *string `json:"target,omitempty"`
	// RequestID - Identifier for the certificate operation.
	RequestID *string `json:"request_id,omitempty"`
}

// CertificateOperationUpdateParameter the certificate operation update parameters.
type CertificateOperationUpdateParameter struct {
	// CancellationRequested - Indicates if cancellation was requested on the certificate operation.
	CancellationRequested *bool `json:"cancellation_requested,omitempty"`
}

// CertificatePolicy management policy for a certificate.
type CertificatePolicy struct {
	autorest.Response `json:"-"`
	// ID - The certificate id.
	ID *string `json:"id,omitempty"`
	// KeyProperties - Properties of the key backing a certificate.
	KeyProperties *KeyProperties `json:"key_props,omitempty"`
	// SecretProperties - Properties of the secret backing a certificate.
	SecretProperties *SecretProperties `json:"secret_props,omitempty"`
	// X509CertificateProperties - Properties of the X509 component of a certificate.
	X509CertificateProperties *X509CertificateProperties `json:"x509_props,omitempty"`
	// LifetimeActions - Actions that will be performed by Key Vault over the lifetime of a certificate.
	LifetimeActions *[]LifetimeAction `json:"lifetime_actions,omitempty"`
	// IssuerParameters - Parameters for the issuer of the X509 component of a certificate.
	IssuerParameters *IssuerParameters `json:"issuer,omitempty"`
	// Attributes - The certificate attributes.
	Attributes *CertificateAttributes `json:"attributes,omitempty"`
}

// CertificateUpdateParameters the certificate update parameters.
type CertificateUpdateParameters struct {
	// CertificatePolicy - The management policy for the certificate.
	CertificatePolicy *CertificatePolicy `json:"policy,omitempty"`
	// CertificateAttributes - The attributes of the certificate (optional).
	CertificateAttributes *CertificateAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CertificateUpdateParameters.
func (cup CertificateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cup.CertificatePolicy != nil {
		objectMap["policy"] = cup.CertificatePolicy
	}
	if cup.CertificateAttributes != nil {
		objectMap["attributes"] = cup.CertificateAttributes
	}
	if cup.Tags != nil {
		objectMap["tags"] = cup.Tags
	}
	return json.Marshal(objectMap)
}

// Contact the contact information for the vault certificates.
type Contact struct {
	// EmailAddress - Email addresss.
	EmailAddress *string `json:"email,omitempty"`
	// Name - Name.
	Name *string `json:"name,omitempty"`
	// Phone - Phone number.
	Phone *string `json:"phone,omitempty"`
}

// Contacts the contacts for the vault certificates.
type Contacts struct {
	autorest.Response `json:"-"`
	// ID - Identifier for the contacts collection.
	ID *string `json:"id,omitempty"`
	// ContactList - The contact list for the vault certificates.
	ContactList *[]Contact `json:"contacts,omitempty"`
}

// DeletedCertificateBundle a Deleted Certificate consisting of its previous id, attributes and its tags, as well
// as information on when it will be purged.
type DeletedCertificateBundle struct {
	autorest.Response `json:"-"`
	// RecoveryID - The url of the recovery object, used to identify and recover the deleted certificate.
	RecoveryID *string `json:"recoveryId,omitempty"`
	// ScheduledPurgeDate - The time when the certificate is scheduled to be purged, in UTC
	ScheduledPurgeDate *date.UnixTime `json:"scheduledPurgeDate,omitempty"`
	// DeletedDate - The time when the certificate was deleted, in UTC
	DeletedDate *date.UnixTime `json:"deletedDate,omitempty"`
	// ID - The certificate id.
	ID *string `json:"id,omitempty"`
	// Kid - The key id.
	Kid *string `json:"kid,omitempty"`
	// Sid - The secret id.
	Sid *string `json:"sid,omitempty"`
	// X509Thumbprint - Thumbprint of the certificate.
	X509Thumbprint *string `json:"x5t,omitempty"`
	// Policy - The management policy.
	Policy *CertificatePolicy `json:"policy,omitempty"`
	// Cer - CER contents of x509 certificate.
	Cer *[]byte `json:"cer,omitempty"`
	// ContentType - The content type of the secret.
	ContentType *string `json:"contentType,omitempty"`
	// Attributes - The certificate attributes.
	Attributes *CertificateAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DeletedCertificateBundle.
func (dcb DeletedCertificateBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcb.RecoveryID != nil {
		objectMap["recoveryId"] = dcb.RecoveryID
	}
	if dcb.ScheduledPurgeDate != nil {
		objectMap["scheduledPurgeDate"] = dcb.ScheduledPurgeDate
	}
	if dcb.DeletedDate != nil {
		objectMap["deletedDate"] = dcb.DeletedDate
	}
	if dcb.ID != nil {
		objectMap["id"] = dcb.ID
	}
	if dcb.Kid != nil {
		objectMap["kid"] = dcb.Kid
	}
	if dcb.Sid != nil {
		objectMap["sid"] = dcb.Sid
	}
	if dcb.X509Thumbprint != nil {
		objectMap["x5t"] = dcb.X509Thumbprint
	}
	if dcb.Policy != nil {
		objectMap["policy"] = dcb.Policy
	}
	if dcb.Cer != nil {
		objectMap["cer"] = dcb.Cer
	}
	if dcb.ContentType != nil {
		objectMap["contentType"] = dcb.ContentType
	}
	if dcb.Attributes != nil {
		objectMap["attributes"] = dcb.Attributes
	}
	if dcb.Tags != nil {
		objectMap["tags"] = dcb.Tags
	}
	return json.Marshal(objectMap)
}

// DeletedCertificateItem the deleted certificate item containing metadata about the deleted certificate.
type DeletedCertificateItem struct {
	// RecoveryID - The url of the recovery object, used to identify and recover the deleted certificate.
	RecoveryID *string `json:"recoveryId,omitempty"`
	// ScheduledPurgeDate - The time when the certificate is scheduled to be purged, in UTC
	ScheduledPurgeDate *date.UnixTime `json:"scheduledPurgeDate,omitempty"`
	// DeletedDate - The time when the certificate was deleted, in UTC
	DeletedDate *date.UnixTime `json:"deletedDate,omitempty"`
	// ID - Certificate identifier.
	ID *string `json:"id,omitempty"`
	// Attributes - The certificate management attributes.
	Attributes *CertificateAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
	// X509Thumbprint - Thumbprint of the certificate.
	X509Thumbprint *string `json:"x5t,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedCertificateItem.
func (dci DeletedCertificateItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dci.RecoveryID != nil {
		objectMap["recoveryId"] = dci.RecoveryID
	}
	if dci.ScheduledPurgeDate != nil {
		objectMap["scheduledPurgeDate"] = dci.ScheduledPurgeDate
	}
	if dci.DeletedDate != nil {
		objectMap["deletedDate"] = dci.DeletedDate
	}
	if dci.ID != nil {
		objectMap["id"] = dci.ID
	}
	if dci.Attributes != nil {
		objectMap["attributes"] = dci.Attributes
	}
	if dci.Tags != nil {
		objectMap["tags"] = dci.Tags
	}
	if dci.X509Thumbprint != nil {
		objectMap["x5t"] = dci.X509Thumbprint
	}
	return json.Marshal(objectMap)
}

// DeletedCertificateListResult a list of certificates that have been deleted in this vault.
type DeletedCertificateListResult struct {
	autorest.Response `json:"-"`
	// Value - A response message containing a list of deleted certificates in the vault along with a link to the next page of deleted certificates
	Value *[]DeletedCertificateItem `json:"value,omitempty"`
	// NextLink - The URL to get the next set of deleted certificates.
	NextLink *string `json:"nextLink,omitempty"`
}

// DeletedCertificateListResultIterator provides access to a complete listing of DeletedCertificateItem values.
type DeletedCertificateListResultIterator struct {
	i    int
	page DeletedCertificateListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeletedCertificateListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeletedCertificateListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeletedCertificateListResultIterator) Response() DeletedCertificateListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeletedCertificateListResultIterator) Value() DeletedCertificateItem {
	if !iter.page.NotDone() {
		return DeletedCertificateItem{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (dclr DeletedCertificateListResult) IsEmpty() bool {
	return dclr.Value == nil || len(*dclr.Value) == 0
}

// deletedCertificateListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dclr DeletedCertificateListResult) deletedCertificateListResultPreparer() (*http.Request, error) {
	if dclr.NextLink == nil || len(to.String(dclr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dclr.NextLink)))
}

// DeletedCertificateListResultPage contains a page of DeletedCertificateItem values.
type DeletedCertificateListResultPage struct {
	fn   func(DeletedCertificateListResult) (DeletedCertificateListResult, error)
	dclr DeletedCertificateListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeletedCertificateListResultPage) Next() error {
	next, err := page.fn(page.dclr)
	if err != nil {
		return err
	}
	page.dclr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeletedCertificateListResultPage) NotDone() bool {
	return !page.dclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeletedCertificateListResultPage) Response() DeletedCertificateListResult {
	return page.dclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeletedCertificateListResultPage) Values() []DeletedCertificateItem {
	if page.dclr.IsEmpty() {
		return nil
	}
	return *page.dclr.Value
}

// DeletedKeyBundle a DeletedKeyBundle consisting of a WebKey plus its Attributes and deletion info
type DeletedKeyBundle struct {
	autorest.Response `json:"-"`
	// RecoveryID - The url of the recovery object, used to identify and recover the deleted key.
	RecoveryID *string `json:"recoveryId,omitempty"`
	// ScheduledPurgeDate - The time when the key is scheduled to be purged, in UTC
	ScheduledPurgeDate *date.UnixTime `json:"scheduledPurgeDate,omitempty"`
	// DeletedDate - The time when the key was deleted, in UTC
	DeletedDate *date.UnixTime `json:"deletedDate,omitempty"`
	// Key - The Json web key.
	Key *JSONWebKey `json:"key,omitempty"`
	// Attributes - The key management attributes.
	Attributes *KeyAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
	// Managed - True if the key's lifetime is managed by key vault. If this is a key backing a certificate, then managed will be true.
	Managed *bool `json:"managed,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedKeyBundle.
func (dkb DeletedKeyBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dkb.RecoveryID != nil {
		objectMap["recoveryId"] = dkb.RecoveryID
	}
	if dkb.ScheduledPurgeDate != nil {
		objectMap["scheduledPurgeDate"] = dkb.ScheduledPurgeDate
	}
	if dkb.DeletedDate != nil {
		objectMap["deletedDate"] = dkb.DeletedDate
	}
	if dkb.Key != nil {
		objectMap["key"] = dkb.Key
	}
	if dkb.Attributes != nil {
		objectMap["attributes"] = dkb.Attributes
	}
	if dkb.Tags != nil {
		objectMap["tags"] = dkb.Tags
	}
	if dkb.Managed != nil {
		objectMap["managed"] = dkb.Managed
	}
	return json.Marshal(objectMap)
}

// DeletedKeyItem the deleted key item containing the deleted key metadata and information about deletion.
type DeletedKeyItem struct {
	// RecoveryID - The url of the recovery object, used to identify and recover the deleted key.
	RecoveryID *string `json:"recoveryId,omitempty"`
	// ScheduledPurgeDate - The time when the key is scheduled to be purged, in UTC
	ScheduledPurgeDate *date.UnixTime `json:"scheduledPurgeDate,omitempty"`
	// DeletedDate - The time when the key was deleted, in UTC
	DeletedDate *date.UnixTime `json:"deletedDate,omitempty"`
	// Kid - Key identifier.
	Kid *string `json:"kid,omitempty"`
	// Attributes - The key management attributes.
	Attributes *KeyAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
	// Managed - True if the key's lifetime is managed by key vault. If this is a key backing a certificate, then managed will be true.
	Managed *bool `json:"managed,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedKeyItem.
func (dki DeletedKeyItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dki.RecoveryID != nil {
		objectMap["recoveryId"] = dki.RecoveryID
	}
	if dki.ScheduledPurgeDate != nil {
		objectMap["scheduledPurgeDate"] = dki.ScheduledPurgeDate
	}
	if dki.DeletedDate != nil {
		objectMap["deletedDate"] = dki.DeletedDate
	}
	if dki.Kid != nil {
		objectMap["kid"] = dki.Kid
	}
	if dki.Attributes != nil {
		objectMap["attributes"] = dki.Attributes
	}
	if dki.Tags != nil {
		objectMap["tags"] = dki.Tags
	}
	if dki.Managed != nil {
		objectMap["managed"] = dki.Managed
	}
	return json.Marshal(objectMap)
}

// DeletedKeyListResult a list of keys that have been deleted in this vault.
type DeletedKeyListResult struct {
	autorest.Response `json:"-"`
	// Value - A response message containing a list of deleted keys in the vault along with a link to the next page of deleted keys
	Value *[]DeletedKeyItem `json:"value,omitempty"`
	// NextLink - The URL to get the next set of deleted keys.
	NextLink *string `json:"nextLink,omitempty"`
}

// DeletedKeyListResultIterator provides access to a complete listing of DeletedKeyItem values.
type DeletedKeyListResultIterator struct {
	i    int
	page DeletedKeyListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeletedKeyListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeletedKeyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeletedKeyListResultIterator) Response() DeletedKeyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeletedKeyListResultIterator) Value() DeletedKeyItem {
	if !iter.page.NotDone() {
		return DeletedKeyItem{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (dklr DeletedKeyListResult) IsEmpty() bool {
	return dklr.Value == nil || len(*dklr.Value) == 0
}

// deletedKeyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dklr DeletedKeyListResult) deletedKeyListResultPreparer() (*http.Request, error) {
	if dklr.NextLink == nil || len(to.String(dklr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dklr.NextLink)))
}

// DeletedKeyListResultPage contains a page of DeletedKeyItem values.
type DeletedKeyListResultPage struct {
	fn   func(DeletedKeyListResult) (DeletedKeyListResult, error)
	dklr DeletedKeyListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeletedKeyListResultPage) Next() error {
	next, err := page.fn(page.dklr)
	if err != nil {
		return err
	}
	page.dklr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeletedKeyListResultPage) NotDone() bool {
	return !page.dklr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeletedKeyListResultPage) Response() DeletedKeyListResult {
	return page.dklr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeletedKeyListResultPage) Values() []DeletedKeyItem {
	if page.dklr.IsEmpty() {
		return nil
	}
	return *page.dklr.Value
}

// DeletedSecretBundle a Deleted Secret consisting of its previous id, attributes and its tags, as well as
// information on when it will be purged.
type DeletedSecretBundle struct {
	autorest.Response `json:"-"`
	// RecoveryID - The url of the recovery object, used to identify and recover the deleted secret.
	RecoveryID *string `json:"recoveryId,omitempty"`
	// ScheduledPurgeDate - The time when the secret is scheduled to be purged, in UTC
	ScheduledPurgeDate *date.UnixTime `json:"scheduledPurgeDate,omitempty"`
	// DeletedDate - The time when the secret was deleted, in UTC
	DeletedDate *date.UnixTime `json:"deletedDate,omitempty"`
	// Value - The secret value.
	Value *string `json:"value,omitempty"`
	// ID - The secret id.
	ID *string `json:"id,omitempty"`
	// ContentType - The content type of the secret.
	ContentType *string `json:"contentType,omitempty"`
	// Attributes - The secret management attributes.
	Attributes *SecretAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
	// Kid - If this is a secret backing a KV certificate, then this field specifies the corresponding key backing the KV certificate.
	Kid *string `json:"kid,omitempty"`
	// Managed - True if the secret's lifetime is managed by key vault. If this is a secret backing a certificate, then managed will be true.
	Managed *bool `json:"managed,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedSecretBundle.
func (dsb DeletedSecretBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsb.RecoveryID != nil {
		objectMap["recoveryId"] = dsb.RecoveryID
	}
	if dsb.ScheduledPurgeDate != nil {
		objectMap["scheduledPurgeDate"] = dsb.ScheduledPurgeDate
	}
	if dsb.DeletedDate != nil {
		objectMap["deletedDate"] = dsb.DeletedDate
	}
	if dsb.Value != nil {
		objectMap["value"] = dsb.Value
	}
	if dsb.ID != nil {
		objectMap["id"] = dsb.ID
	}
	if dsb.ContentType != nil {
		objectMap["contentType"] = dsb.ContentType
	}
	if dsb.Attributes != nil {
		objectMap["attributes"] = dsb.Attributes
	}
	if dsb.Tags != nil {
		objectMap["tags"] = dsb.Tags
	}
	if dsb.Kid != nil {
		objectMap["kid"] = dsb.Kid
	}
	if dsb.Managed != nil {
		objectMap["managed"] = dsb.Managed
	}
	return json.Marshal(objectMap)
}

// DeletedSecretItem the deleted secret item containing metadata about the deleted secret.
type DeletedSecretItem struct {
	// RecoveryID - The url of the recovery object, used to identify and recover the deleted secret.
	RecoveryID *string `json:"recoveryId,omitempty"`
	// ScheduledPurgeDate - The time when the secret is scheduled to be purged, in UTC
	ScheduledPurgeDate *date.UnixTime `json:"scheduledPurgeDate,omitempty"`
	// DeletedDate - The time when the secret was deleted, in UTC
	DeletedDate *date.UnixTime `json:"deletedDate,omitempty"`
	// ID - Secret identifier.
	ID *string `json:"id,omitempty"`
	// Attributes - The secret management attributes.
	Attributes *SecretAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
	// ContentType - Type of the secret value such as a password.
	ContentType *string `json:"contentType,omitempty"`
	// Managed - True if the secret's lifetime is managed by key vault. If this is a key backing a certificate, then managed will be true.
	Managed *bool `json:"managed,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedSecretItem.
func (dsi DeletedSecretItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsi.RecoveryID != nil {
		objectMap["recoveryId"] = dsi.RecoveryID
	}
	if dsi.ScheduledPurgeDate != nil {
		objectMap["scheduledPurgeDate"] = dsi.ScheduledPurgeDate
	}
	if dsi.DeletedDate != nil {
		objectMap["deletedDate"] = dsi.DeletedDate
	}
	if dsi.ID != nil {
		objectMap["id"] = dsi.ID
	}
	if dsi.Attributes != nil {
		objectMap["attributes"] = dsi.Attributes
	}
	if dsi.Tags != nil {
		objectMap["tags"] = dsi.Tags
	}
	if dsi.ContentType != nil {
		objectMap["contentType"] = dsi.ContentType
	}
	if dsi.Managed != nil {
		objectMap["managed"] = dsi.Managed
	}
	return json.Marshal(objectMap)
}

// DeletedSecretListResult the deleted secret list result
type DeletedSecretListResult struct {
	autorest.Response `json:"-"`
	// Value - A response message containing a list of the deleted secrets in the vault along with a link to the next page of deleted secrets
	Value *[]DeletedSecretItem `json:"value,omitempty"`
	// NextLink - The URL to get the next set of deleted secrets.
	NextLink *string `json:"nextLink,omitempty"`
}

// DeletedSecretListResultIterator provides access to a complete listing of DeletedSecretItem values.
type DeletedSecretListResultIterator struct {
	i    int
	page DeletedSecretListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeletedSecretListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeletedSecretListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeletedSecretListResultIterator) Response() DeletedSecretListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeletedSecretListResultIterator) Value() DeletedSecretItem {
	if !iter.page.NotDone() {
		return DeletedSecretItem{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (dslr DeletedSecretListResult) IsEmpty() bool {
	return dslr.Value == nil || len(*dslr.Value) == 0
}

// deletedSecretListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dslr DeletedSecretListResult) deletedSecretListResultPreparer() (*http.Request, error) {
	if dslr.NextLink == nil || len(to.String(dslr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dslr.NextLink)))
}

// DeletedSecretListResultPage contains a page of DeletedSecretItem values.
type DeletedSecretListResultPage struct {
	fn   func(DeletedSecretListResult) (DeletedSecretListResult, error)
	dslr DeletedSecretListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeletedSecretListResultPage) Next() error {
	next, err := page.fn(page.dslr)
	if err != nil {
		return err
	}
	page.dslr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeletedSecretListResultPage) NotDone() bool {
	return !page.dslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeletedSecretListResultPage) Response() DeletedSecretListResult {
	return page.dslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeletedSecretListResultPage) Values() []DeletedSecretItem {
	if page.dslr.IsEmpty() {
		return nil
	}
	return *page.dslr.Value
}

// Error the key vault server error.
type Error struct {
	// Code - The error code.
	Code *string `json:"code,omitempty"`
	// Message - The error message.
	Message    *string `json:"message,omitempty"`
	InnerError *Error  `json:"innererror,omitempty"`
}

// ErrorType the key vault error exception.
type ErrorType struct {
	Error *Error `json:"error,omitempty"`
}

// IssuerAttributes the attributes of an issuer managed by the Key Vault service.
type IssuerAttributes struct {
	// Enabled - Determines whether the issuer is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// Created - Creation time in UTC.
	Created *date.UnixTime `json:"created,omitempty"`
	// Updated - Last updated time in UTC.
	Updated *date.UnixTime `json:"updated,omitempty"`
}

// IssuerBundle the issuer for Key Vault certificate.
type IssuerBundle struct {
	autorest.Response `json:"-"`
	// ID - Identifier for the issuer object.
	ID *string `json:"id,omitempty"`
	// Provider - The issuer provider.
	Provider *string `json:"provider,omitempty"`
	// Credentials - The credentials to be used for the issuer.
	Credentials *IssuerCredentials `json:"credentials,omitempty"`
	// OrganizationDetails - Details of the organization as provided to the issuer.
	OrganizationDetails *OrganizationDetails `json:"org_details,omitempty"`
	// Attributes - Attributes of the issuer object.
	Attributes *IssuerAttributes `json:"attributes,omitempty"`
}

// IssuerCredentials the credentials to be used for the certificate issuer.
type IssuerCredentials struct {
	// AccountID - The user name/account name/account id.
	AccountID *string `json:"account_id,omitempty"`
	// Password - The password/secret/account key.
	Password *string `json:"pwd,omitempty"`
}

// IssuerParameters parameters for the issuer of the X509 component of a certificate.
type IssuerParameters struct {
	// Name - Name of the referenced issuer object or reserved names; for example, 'Self' or 'Unknown'.
	Name *string `json:"name,omitempty"`
	// CertificateType - Type of certificate to be requested from the issuer provider.
	CertificateType *string `json:"cty,omitempty"`
}

// JSONWebKey as of http://tools.ietf.org/html/draft-ietf-jose-json-web-key-18
type JSONWebKey struct {
	// Kid - Key identifier.
	Kid *string `json:"kid,omitempty"`
	// Kty - JsonWebKey key type (kty). Possible values include: 'EC', 'ECHSM', 'RSA', 'RSAHSM', 'Oct'
	Kty    JSONWebKeyType `json:"kty,omitempty"`
	KeyOps *[]string      `json:"key_ops,omitempty"`
	// N - RSA modulus.
	N *string `json:"n,omitempty"`
	// E - RSA public exponent.
	E *string `json:"e,omitempty"`
	// D - RSA private exponent, or the D component of an EC private key.
	D *string `json:"d,omitempty"`
	// DP - RSA private key parameter.
	DP *string `json:"dp,omitempty"`
	// DQ - RSA private key parameter.
	DQ *string `json:"dq,omitempty"`
	// QI - RSA private key parameter.
	QI *string `json:"qi,omitempty"`
	// P - RSA secret prime.
	P *string `json:"p,omitempty"`
	// Q - RSA secret prime, with p < q.
	Q *string `json:"q,omitempty"`
	// K - Symmetric key.
	K *string `json:"k,omitempty"`
	// T - HSM Token, used with 'Bring Your Own Key'.
	T *string `json:"key_hsm,omitempty"`
	// Crv - Elliptic curve name. For valid values, see JsonWebKeyCurveName. Possible values include: 'P256', 'P384', 'P521', 'SECP256K1'
	Crv JSONWebKeyCurveName `json:"crv,omitempty"`
	// X - X component of an EC public key.
	X *string `json:"x,omitempty"`
	// Y - Y component of an EC public key.
	Y *string `json:"y,omitempty"`
}

// KeyAttributes the attributes of a key managed by the key vault service.
type KeyAttributes struct {
	// RecoveryLevel - Reflects the deletion recovery level currently in effect for keys in the current vault. If it contains 'Purgeable' the key can be permanently deleted by a privileged user; otherwise, only the system can purge the key, at the end of the retention interval. Possible values include: 'Purgeable', 'RecoverablePurgeable', 'Recoverable', 'RecoverableProtectedSubscription'
	RecoveryLevel DeletionRecoveryLevel `json:"recoveryLevel,omitempty"`
	// Enabled - Determines whether the object is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// NotBefore - Not before date in UTC.
	NotBefore *date.UnixTime `json:"nbf,omitempty"`
	// Expires - Expiry date in UTC.
	Expires *date.UnixTime `json:"exp,omitempty"`
	// Created - Creation time in UTC.
	Created *date.UnixTime `json:"created,omitempty"`
	// Updated - Last updated time in UTC.
	Updated *date.UnixTime `json:"updated,omitempty"`
}

// KeyBundle a KeyBundle consisting of a WebKey plus its attributes.
type KeyBundle struct {
	autorest.Response `json:"-"`
	// Key - The Json web key.
	Key *JSONWebKey `json:"key,omitempty"`
	// Attributes - The key management attributes.
	Attributes *KeyAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
	// Managed - True if the key's lifetime is managed by key vault. If this is a key backing a certificate, then managed will be true.
	Managed *bool `json:"managed,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyBundle.
func (kb KeyBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kb.Key != nil {
		objectMap["key"] = kb.Key
	}
	if kb.Attributes != nil {
		objectMap["attributes"] = kb.Attributes
	}
	if kb.Tags != nil {
		objectMap["tags"] = kb.Tags
	}
	if kb.Managed != nil {
		objectMap["managed"] = kb.Managed
	}
	return json.Marshal(objectMap)
}

// KeyCreateParameters the key create parameters.
type KeyCreateParameters struct {
	// Kty - The type of key to create. For valid values, see JsonWebKeyType. Possible values include: 'EC', 'ECHSM', 'RSA', 'RSAHSM', 'Oct'
	Kty JSONWebKeyType `json:"kty,omitempty"`
	// KeySize - The key size in bits. For example: 2048, 3072, or 4096 for RSA.
	KeySize       *int32                 `json:"key_size,omitempty"`
	KeyOps        *[]JSONWebKeyOperation `json:"key_ops,omitempty"`
	KeyAttributes *KeyAttributes         `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
	// Curve - Elliptic curve name. For valid values, see JsonWebKeyCurveName. Possible values include: 'P256', 'P384', 'P521', 'SECP256K1'
	Curve JSONWebKeyCurveName `json:"crv,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyCreateParameters.
func (kcp KeyCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kcp.Kty != "" {
		objectMap["kty"] = kcp.Kty
	}
	if kcp.KeySize != nil {
		objectMap["key_size"] = kcp.KeySize
	}
	if kcp.KeyOps != nil {
		objectMap["key_ops"] = kcp.KeyOps
	}
	if kcp.KeyAttributes != nil {
		objectMap["attributes"] = kcp.KeyAttributes
	}
	if kcp.Tags != nil {
		objectMap["tags"] = kcp.Tags
	}
	if kcp.Curve != "" {
		objectMap["crv"] = kcp.Curve
	}
	return json.Marshal(objectMap)
}

// KeyImportParameters the key import parameters.
type KeyImportParameters struct {
	// Hsm - Whether to import as a hardware key (HSM) or software key.
	Hsm *bool `json:"Hsm,omitempty"`
	// Key - The Json web key
	Key *JSONWebKey `json:"key,omitempty"`
	// KeyAttributes - The key management attributes.
	KeyAttributes *KeyAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for KeyImportParameters.
func (kip KeyImportParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kip.Hsm != nil {
		objectMap["Hsm"] = kip.Hsm
	}
	if kip.Key != nil {
		objectMap["key"] = kip.Key
	}
	if kip.KeyAttributes != nil {
		objectMap["attributes"] = kip.KeyAttributes
	}
	if kip.Tags != nil {
		objectMap["tags"] = kip.Tags
	}
	return json.Marshal(objectMap)
}

// KeyItem the key item containing key metadata.
type KeyItem struct {
	// Kid - Key identifier.
	Kid *string `json:"kid,omitempty"`
	// Attributes - The key management attributes.
	Attributes *KeyAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
	// Managed - True if the key's lifetime is managed by key vault. If this is a key backing a certificate, then managed will be true.
	Managed *bool `json:"managed,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyItem.
func (ki KeyItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ki.Kid != nil {
		objectMap["kid"] = ki.Kid
	}
	if ki.Attributes != nil {
		objectMap["attributes"] = ki.Attributes
	}
	if ki.Tags != nil {
		objectMap["tags"] = ki.Tags
	}
	if ki.Managed != nil {
		objectMap["managed"] = ki.Managed
	}
	return json.Marshal(objectMap)
}

// KeyListResult the key list result.
type KeyListResult struct {
	autorest.Response `json:"-"`
	// Value - A response message containing a list of keys in the key vault along with a link to the next page of keys.
	Value *[]KeyItem `json:"value,omitempty"`
	// NextLink - The URL to get the next set of keys.
	NextLink *string `json:"nextLink,omitempty"`
}

// KeyListResultIterator provides access to a complete listing of KeyItem values.
type KeyListResultIterator struct {
	i    int
	page KeyListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *KeyListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter KeyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter KeyListResultIterator) Response() KeyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter KeyListResultIterator) Value() KeyItem {
	if !iter.page.NotDone() {
		return KeyItem{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (klr KeyListResult) IsEmpty() bool {
	return klr.Value == nil || len(*klr.Value) == 0
}

// keyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (klr KeyListResult) keyListResultPreparer() (*http.Request, error) {
	if klr.NextLink == nil || len(to.String(klr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(klr.NextLink)))
}

// KeyListResultPage contains a page of KeyItem values.
type KeyListResultPage struct {
	fn  func(KeyListResult) (KeyListResult, error)
	klr KeyListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *KeyListResultPage) Next() error {
	next, err := page.fn(page.klr)
	if err != nil {
		return err
	}
	page.klr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page KeyListResultPage) NotDone() bool {
	return !page.klr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page KeyListResultPage) Response() KeyListResult {
	return page.klr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page KeyListResultPage) Values() []KeyItem {
	if page.klr.IsEmpty() {
		return nil
	}
	return *page.klr.Value
}

// KeyOperationResult the key operation result.
type KeyOperationResult struct {
	autorest.Response `json:"-"`
	// Kid - Key identifier
	Kid    *string `json:"kid,omitempty"`
	Result *string `json:"value,omitempty"`
}

// KeyOperationsParameters the key operations parameters.
type KeyOperationsParameters struct {
	// Algorithm - algorithm identifier. Possible values include: 'RSAOAEP', 'RSAOAEP256', 'RSA15'
	Algorithm JSONWebKeyEncryptionAlgorithm `json:"alg,omitempty"`
	Value     *string                       `json:"value,omitempty"`
}

// KeyProperties properties of the key pair backing a certificate.
type KeyProperties struct {
	// Exportable - Indicates if the private key can be exported.
	Exportable *bool `json:"exportable,omitempty"`
	// KeyType - The key type.
	KeyType *string `json:"kty,omitempty"`
	// KeySize - The key size in bits. For example: 2048, 3072, or 4096 for RSA.
	KeySize *int32 `json:"key_size,omitempty"`
	// ReuseKey - Indicates if the same key pair will be used on certificate renewal.
	ReuseKey *bool `json:"reuse_key,omitempty"`
}

// KeyRestoreParameters the key restore parameters.
type KeyRestoreParameters struct {
	// KeyBundleBackup - The backup blob associated with a key bundle.
	KeyBundleBackup *string `json:"value,omitempty"`
}

// KeySignParameters the key operations parameters.
type KeySignParameters struct {
	// Algorithm - The signing/verification algorithm identifier. For more information on possible algorithm types, see JsonWebKeySignatureAlgorithm. Possible values include: 'PS256', 'PS384', 'PS512', 'RS256', 'RS384', 'RS512', 'RSNULL', 'ES256', 'ES384', 'ES512', 'ECDSA256'
	Algorithm JSONWebKeySignatureAlgorithm `json:"alg,omitempty"`
	Value     *string                      `json:"value,omitempty"`
}

// KeyUpdateParameters the key update parameters.
type KeyUpdateParameters struct {
	// KeyOps - Json web key operations. For more information on possible key operations, see JsonWebKeyOperation.
	KeyOps        *[]JSONWebKeyOperation `json:"key_ops,omitempty"`
	KeyAttributes *KeyAttributes         `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for KeyUpdateParameters.
func (kup KeyUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kup.KeyOps != nil {
		objectMap["key_ops"] = kup.KeyOps
	}
	if kup.KeyAttributes != nil {
		objectMap["attributes"] = kup.KeyAttributes
	}
	if kup.Tags != nil {
		objectMap["tags"] = kup.Tags
	}
	return json.Marshal(objectMap)
}

// KeyVerifyParameters the key verify parameters.
type KeyVerifyParameters struct {
	// Algorithm - The signing/verification algorithm. For more information on possible algorithm types, see JsonWebKeySignatureAlgorithm. Possible values include: 'PS256', 'PS384', 'PS512', 'RS256', 'RS384', 'RS512', 'RSNULL', 'ES256', 'ES384', 'ES512', 'ECDSA256'
	Algorithm JSONWebKeySignatureAlgorithm `json:"alg,omitempty"`
	// Digest - The digest used for signing.
	Digest *string `json:"digest,omitempty"`
	// Signature - The signature to be verified.
	Signature *string `json:"value,omitempty"`
}

// KeyVerifyResult the key verify result.
type KeyVerifyResult struct {
	autorest.Response `json:"-"`
	// Value - True if the signature is verified, otherwise false.
	Value *bool `json:"value,omitempty"`
}

// LifetimeAction action and its trigger that will be performed by Key Vault over the lifetime of a certificate.
type LifetimeAction struct {
	// Trigger - The condition that will execute the action.
	Trigger *Trigger `json:"trigger,omitempty"`
	// Action - The action that will be executed.
	Action *Action `json:"action,omitempty"`
}

// OrganizationDetails details of the organization of the certificate issuer.
type OrganizationDetails struct {
	// ID - Id of the organization.
	ID *string `json:"id,omitempty"`
	// AdminDetails - Details of the organization administrator.
	AdminDetails *[]AdministratorDetails `json:"admin_details,omitempty"`
}

// PendingCertificateSigningRequestResult the pending certificate signing request result.
type PendingCertificateSigningRequestResult struct {
	// Value - The pending certificate signing request as Base64 encoded string.
	Value *string `json:"value,omitempty"`
}

// SasDefinitionAttributes the SAS definition management attributes.
type SasDefinitionAttributes struct {
	// Enabled - the enabled state of the object.
	Enabled *bool `json:"enabled,omitempty"`
	// Created - Creation time in UTC.
	Created *date.UnixTime `json:"created,omitempty"`
	// Updated - Last updated time in UTC.
	Updated *date.UnixTime `json:"updated,omitempty"`
}

// SasDefinitionBundle a SAS definition bundle consists of key vault SAS definition details plus its attributes.
type SasDefinitionBundle struct {
	autorest.Response `json:"-"`
	// ID - The SAS definition id.
	ID *string `json:"id,omitempty"`
	// SecretID - Storage account SAS definition secret id.
	SecretID *string `json:"sid,omitempty"`
	// Parameters - The SAS definition metadata in the form of key-value pairs.
	Parameters map[string]*string `json:"parameters"`
	// Attributes - The SAS definition attributes.
	Attributes *SasDefinitionAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SasDefinitionBundle.
func (sdb SasDefinitionBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sdb.ID != nil {
		objectMap["id"] = sdb.ID
	}
	if sdb.SecretID != nil {
		objectMap["sid"] = sdb.SecretID
	}
	if sdb.Parameters != nil {
		objectMap["parameters"] = sdb.Parameters
	}
	if sdb.Attributes != nil {
		objectMap["attributes"] = sdb.Attributes
	}
	if sdb.Tags != nil {
		objectMap["tags"] = sdb.Tags
	}
	return json.Marshal(objectMap)
}

// SasDefinitionCreateParameters the SAS definition create parameters.
type SasDefinitionCreateParameters struct {
	// Parameters - Sas definition creation metadata in the form of key-value pairs.
	Parameters map[string]*string `json:"parameters"`
	// SasDefinitionAttributes - The attributes of the SAS definition.
	SasDefinitionAttributes *SasDefinitionAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SasDefinitionCreateParameters.
func (sdcp SasDefinitionCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sdcp.Parameters != nil {
		objectMap["parameters"] = sdcp.Parameters
	}
	if sdcp.SasDefinitionAttributes != nil {
		objectMap["attributes"] = sdcp.SasDefinitionAttributes
	}
	if sdcp.Tags != nil {
		objectMap["tags"] = sdcp.Tags
	}
	return json.Marshal(objectMap)
}

// SasDefinitionItem the SAS definition item containing storage SAS definition metadata.
type SasDefinitionItem struct {
	// ID - The storage SAS identifier.
	ID *string `json:"id,omitempty"`
	// SecretID - The storage account SAS definition secret id.
	SecretID *string `json:"sid,omitempty"`
	// Attributes - The SAS definition management attributes.
	Attributes *SasDefinitionAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SasDefinitionItem.
func (sdi SasDefinitionItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sdi.ID != nil {
		objectMap["id"] = sdi.ID
	}
	if sdi.SecretID != nil {
		objectMap["sid"] = sdi.SecretID
	}
	if sdi.Attributes != nil {
		objectMap["attributes"] = sdi.Attributes
	}
	if sdi.Tags != nil {
		objectMap["tags"] = sdi.Tags
	}
	return json.Marshal(objectMap)
}

// SasDefinitionListResult the storage account SAS definition list result.
type SasDefinitionListResult struct {
	autorest.Response `json:"-"`
	// Value - A response message containing a list of SAS definitions along with a link to the next page of SAS definitions.
	Value *[]SasDefinitionItem `json:"value,omitempty"`
	// NextLink - The URL to get the next set of SAS defintions.
	NextLink *string `json:"nextLink,omitempty"`
}

// SasDefinitionListResultIterator provides access to a complete listing of SasDefinitionItem values.
type SasDefinitionListResultIterator struct {
	i    int
	page SasDefinitionListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SasDefinitionListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SasDefinitionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SasDefinitionListResultIterator) Response() SasDefinitionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SasDefinitionListResultIterator) Value() SasDefinitionItem {
	if !iter.page.NotDone() {
		return SasDefinitionItem{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (sdlr SasDefinitionListResult) IsEmpty() bool {
	return sdlr.Value == nil || len(*sdlr.Value) == 0
}

// sasDefinitionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sdlr SasDefinitionListResult) sasDefinitionListResultPreparer() (*http.Request, error) {
	if sdlr.NextLink == nil || len(to.String(sdlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sdlr.NextLink)))
}

// SasDefinitionListResultPage contains a page of SasDefinitionItem values.
type SasDefinitionListResultPage struct {
	fn   func(SasDefinitionListResult) (SasDefinitionListResult, error)
	sdlr SasDefinitionListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SasDefinitionListResultPage) Next() error {
	next, err := page.fn(page.sdlr)
	if err != nil {
		return err
	}
	page.sdlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SasDefinitionListResultPage) NotDone() bool {
	return !page.sdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SasDefinitionListResultPage) Response() SasDefinitionListResult {
	return page.sdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SasDefinitionListResultPage) Values() []SasDefinitionItem {
	if page.sdlr.IsEmpty() {
		return nil
	}
	return *page.sdlr.Value
}

// SasDefinitionUpdateParameters the SAS definition update parameters.
type SasDefinitionUpdateParameters struct {
	// Parameters - Sas definition update metadata in the form of key-value pairs.
	Parameters map[string]*string `json:"parameters"`
	// SasDefinitionAttributes - The attributes of the SAS definition.
	SasDefinitionAttributes *SasDefinitionAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SasDefinitionUpdateParameters.
func (sdup SasDefinitionUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sdup.Parameters != nil {
		objectMap["parameters"] = sdup.Parameters
	}
	if sdup.SasDefinitionAttributes != nil {
		objectMap["attributes"] = sdup.SasDefinitionAttributes
	}
	if sdup.Tags != nil {
		objectMap["tags"] = sdup.Tags
	}
	return json.Marshal(objectMap)
}

// SecretAttributes the secret management attributes.
type SecretAttributes struct {
	// RecoveryLevel - Reflects the deletion recovery level currently in effect for secrets in the current vault. If it contains 'Purgeable', the secret can be permanently deleted by a privileged user; otherwise, only the system can purge the secret, at the end of the retention interval. Possible values include: 'Purgeable', 'RecoverablePurgeable', 'Recoverable', 'RecoverableProtectedSubscription'
	RecoveryLevel DeletionRecoveryLevel `json:"recoveryLevel,omitempty"`
	// Enabled - Determines whether the object is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// NotBefore - Not before date in UTC.
	NotBefore *date.UnixTime `json:"nbf,omitempty"`
	// Expires - Expiry date in UTC.
	Expires *date.UnixTime `json:"exp,omitempty"`
	// Created - Creation time in UTC.
	Created *date.UnixTime `json:"created,omitempty"`
	// Updated - Last updated time in UTC.
	Updated *date.UnixTime `json:"updated,omitempty"`
}

// SecretBundle a secret consisting of a value, id and its attributes.
type SecretBundle struct {
	autorest.Response `json:"-"`
	// Value - The secret value.
	Value *string `json:"value,omitempty"`
	// ID - The secret id.
	ID *string `json:"id,omitempty"`
	// ContentType - The content type of the secret.
	ContentType *string `json:"contentType,omitempty"`
	// Attributes - The secret management attributes.
	Attributes *SecretAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
	// Kid - If this is a secret backing a KV certificate, then this field specifies the corresponding key backing the KV certificate.
	Kid *string `json:"kid,omitempty"`
	// Managed - True if the secret's lifetime is managed by key vault. If this is a secret backing a certificate, then managed will be true.
	Managed *bool `json:"managed,omitempty"`
}

// MarshalJSON is the custom marshaler for SecretBundle.
func (sb SecretBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sb.Value != nil {
		objectMap["value"] = sb.Value
	}
	if sb.ID != nil {
		objectMap["id"] = sb.ID
	}
	if sb.ContentType != nil {
		objectMap["contentType"] = sb.ContentType
	}
	if sb.Attributes != nil {
		objectMap["attributes"] = sb.Attributes
	}
	if sb.Tags != nil {
		objectMap["tags"] = sb.Tags
	}
	if sb.Kid != nil {
		objectMap["kid"] = sb.Kid
	}
	if sb.Managed != nil {
		objectMap["managed"] = sb.Managed
	}
	return json.Marshal(objectMap)
}

// SecretItem the secret item containing secret metadata.
type SecretItem struct {
	// ID - Secret identifier.
	ID *string `json:"id,omitempty"`
	// Attributes - The secret management attributes.
	Attributes *SecretAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
	// ContentType - Type of the secret value such as a password.
	ContentType *string `json:"contentType,omitempty"`
	// Managed - True if the secret's lifetime is managed by key vault. If this is a key backing a certificate, then managed will be true.
	Managed *bool `json:"managed,omitempty"`
}

// MarshalJSON is the custom marshaler for SecretItem.
func (si SecretItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if si.ID != nil {
		objectMap["id"] = si.ID
	}
	if si.Attributes != nil {
		objectMap["attributes"] = si.Attributes
	}
	if si.Tags != nil {
		objectMap["tags"] = si.Tags
	}
	if si.ContentType != nil {
		objectMap["contentType"] = si.ContentType
	}
	if si.Managed != nil {
		objectMap["managed"] = si.Managed
	}
	return json.Marshal(objectMap)
}

// SecretListResult the secret list result.
type SecretListResult struct {
	autorest.Response `json:"-"`
	// Value - A response message containing a list of secrets in the key vault along with a link to the next page of secrets.
	Value *[]SecretItem `json:"value,omitempty"`
	// NextLink - The URL to get the next set of secrets.
	NextLink *string `json:"nextLink,omitempty"`
}

// SecretListResultIterator provides access to a complete listing of SecretItem values.
type SecretListResultIterator struct {
	i    int
	page SecretListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SecretListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SecretListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SecretListResultIterator) Response() SecretListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SecretListResultIterator) Value() SecretItem {
	if !iter.page.NotDone() {
		return SecretItem{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (slr SecretListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// secretListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr SecretListResult) secretListResultPreparer() (*http.Request, error) {
	if slr.NextLink == nil || len(to.String(slr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// SecretListResultPage contains a page of SecretItem values.
type SecretListResultPage struct {
	fn  func(SecretListResult) (SecretListResult, error)
	slr SecretListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SecretListResultPage) Next() error {
	next, err := page.fn(page.slr)
	if err != nil {
		return err
	}
	page.slr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SecretListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SecretListResultPage) Response() SecretListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SecretListResultPage) Values() []SecretItem {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// SecretProperties properties of the key backing a certificate.
type SecretProperties struct {
	// ContentType - The media type (MIME type).
	ContentType *string `json:"contentType,omitempty"`
}

// SecretRestoreParameters the secret restore parameters.
type SecretRestoreParameters struct {
	// SecretBundleBackup - The backup blob associated with a secret bundle.
	SecretBundleBackup *string `json:"value,omitempty"`
}

// SecretSetParameters the secret set parameters.
type SecretSetParameters struct {
	// Value - The value of the secret.
	Value *string `json:"value,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
	// ContentType - Type of the secret value such as a password.
	ContentType *string `json:"contentType,omitempty"`
	// SecretAttributes - The secret management attributes.
	SecretAttributes *SecretAttributes `json:"attributes,omitempty"`
}

// MarshalJSON is the custom marshaler for SecretSetParameters.
func (ssp SecretSetParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssp.Value != nil {
		objectMap["value"] = ssp.Value
	}
	if ssp.Tags != nil {
		objectMap["tags"] = ssp.Tags
	}
	if ssp.ContentType != nil {
		objectMap["contentType"] = ssp.ContentType
	}
	if ssp.SecretAttributes != nil {
		objectMap["attributes"] = ssp.SecretAttributes
	}
	return json.Marshal(objectMap)
}

// SecretUpdateParameters the secret update parameters.
type SecretUpdateParameters struct {
	// ContentType - Type of the secret value such as a password.
	ContentType *string `json:"contentType,omitempty"`
	// SecretAttributes - The secret management attributes.
	SecretAttributes *SecretAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SecretUpdateParameters.
func (sup SecretUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sup.ContentType != nil {
		objectMap["contentType"] = sup.ContentType
	}
	if sup.SecretAttributes != nil {
		objectMap["attributes"] = sup.SecretAttributes
	}
	if sup.Tags != nil {
		objectMap["tags"] = sup.Tags
	}
	return json.Marshal(objectMap)
}

// StorageAccountAttributes the storage account management attributes.
type StorageAccountAttributes struct {
	// Enabled - the enabled state of the object.
	Enabled *bool `json:"enabled,omitempty"`
	// Created - Creation time in UTC.
	Created *date.UnixTime `json:"created,omitempty"`
	// Updated - Last updated time in UTC.
	Updated *date.UnixTime `json:"updated,omitempty"`
}

// StorageAccountCreateParameters the storage account create parameters.
type StorageAccountCreateParameters struct {
	// ResourceID - Storage account resource id.
	ResourceID *string `json:"resourceId,omitempty"`
	// ActiveKeyName - Current active storage account key name.
	ActiveKeyName *string `json:"activeKeyName,omitempty"`
	// AutoRegenerateKey - whether keyvault should manage the storage account for the user.
	AutoRegenerateKey *bool `json:"autoRegenerateKey,omitempty"`
	// RegenerationPeriod - The key regeneration time duration specified in ISO-8601 format.
	RegenerationPeriod *string `json:"regenerationPeriod,omitempty"`
	// StorageAccountAttributes - The attributes of the storage account.
	StorageAccountAttributes *StorageAccountAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for StorageAccountCreateParameters.
func (sacp StorageAccountCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sacp.ResourceID != nil {
		objectMap["resourceId"] = sacp.ResourceID
	}
	if sacp.ActiveKeyName != nil {
		objectMap["activeKeyName"] = sacp.ActiveKeyName
	}
	if sacp.AutoRegenerateKey != nil {
		objectMap["autoRegenerateKey"] = sacp.AutoRegenerateKey
	}
	if sacp.RegenerationPeriod != nil {
		objectMap["regenerationPeriod"] = sacp.RegenerationPeriod
	}
	if sacp.StorageAccountAttributes != nil {
		objectMap["attributes"] = sacp.StorageAccountAttributes
	}
	if sacp.Tags != nil {
		objectMap["tags"] = sacp.Tags
	}
	return json.Marshal(objectMap)
}

// StorageAccountItem the storage account item containing storage account metadata.
type StorageAccountItem struct {
	// ID - Storage identifier.
	ID *string `json:"id,omitempty"`
	// ResourceID - Storage account resource Id.
	ResourceID *string `json:"resourceId,omitempty"`
	// Attributes - The storage account management attributes.
	Attributes *StorageAccountAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for StorageAccountItem.
func (sai StorageAccountItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sai.ID != nil {
		objectMap["id"] = sai.ID
	}
	if sai.ResourceID != nil {
		objectMap["resourceId"] = sai.ResourceID
	}
	if sai.Attributes != nil {
		objectMap["attributes"] = sai.Attributes
	}
	if sai.Tags != nil {
		objectMap["tags"] = sai.Tags
	}
	return json.Marshal(objectMap)
}

// StorageAccountRegenerteKeyParameters the storage account key regenerate parameters.
type StorageAccountRegenerteKeyParameters struct {
	// KeyName - The storage account key name.
	KeyName *string `json:"keyName,omitempty"`
}

// StorageAccountUpdateParameters the storage account update parameters.
type StorageAccountUpdateParameters struct {
	// ActiveKeyName - The current active storage account key name.
	ActiveKeyName *string `json:"activeKeyName,omitempty"`
	// AutoRegenerateKey - whether keyvault should manage the storage account for the user.
	AutoRegenerateKey *bool `json:"autoRegenerateKey,omitempty"`
	// RegenerationPeriod - The key regeneration time duration specified in ISO-8601 format.
	RegenerationPeriod *string `json:"regenerationPeriod,omitempty"`
	// StorageAccountAttributes - The attributes of the storage account.
	StorageAccountAttributes *StorageAccountAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for StorageAccountUpdateParameters.
func (saup StorageAccountUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if saup.ActiveKeyName != nil {
		objectMap["activeKeyName"] = saup.ActiveKeyName
	}
	if saup.AutoRegenerateKey != nil {
		objectMap["autoRegenerateKey"] = saup.AutoRegenerateKey
	}
	if saup.RegenerationPeriod != nil {
		objectMap["regenerationPeriod"] = saup.RegenerationPeriod
	}
	if saup.StorageAccountAttributes != nil {
		objectMap["attributes"] = saup.StorageAccountAttributes
	}
	if saup.Tags != nil {
		objectMap["tags"] = saup.Tags
	}
	return json.Marshal(objectMap)
}

// StorageBundle a Storage account bundle consists of key vault storage account details plus its attributes.
type StorageBundle struct {
	autorest.Response `json:"-"`
	// ID - The storage account id.
	ID *string `json:"id,omitempty"`
	// ResourceID - The storage account resource id.
	ResourceID *string `json:"resourceId,omitempty"`
	// ActiveKeyName - The current active storage account key name.
	ActiveKeyName *string `json:"activeKeyName,omitempty"`
	// AutoRegenerateKey - whether keyvault should manage the storage account for the user.
	AutoRegenerateKey *bool `json:"autoRegenerateKey,omitempty"`
	// RegenerationPeriod - The key regeneration time duration specified in ISO-8601 format.
	RegenerationPeriod *string `json:"regenerationPeriod,omitempty"`
	// Attributes - The storage account attributes.
	Attributes *StorageAccountAttributes `json:"attributes,omitempty"`
	// Tags - Application specific metadata in the form of key-value pairs
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for StorageBundle.
func (sb StorageBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sb.ID != nil {
		objectMap["id"] = sb.ID
	}
	if sb.ResourceID != nil {
		objectMap["resourceId"] = sb.ResourceID
	}
	if sb.ActiveKeyName != nil {
		objectMap["activeKeyName"] = sb.ActiveKeyName
	}
	if sb.AutoRegenerateKey != nil {
		objectMap["autoRegenerateKey"] = sb.AutoRegenerateKey
	}
	if sb.RegenerationPeriod != nil {
		objectMap["regenerationPeriod"] = sb.RegenerationPeriod
	}
	if sb.Attributes != nil {
		objectMap["attributes"] = sb.Attributes
	}
	if sb.Tags != nil {
		objectMap["tags"] = sb.Tags
	}
	return json.Marshal(objectMap)
}

// StorageListResult the storage accounts list result.
type StorageListResult struct {
	autorest.Response `json:"-"`
	// Value - A response message containing a list of storage accounts in the key vault along with a link to the next page of storage accounts.
	Value *[]StorageAccountItem `json:"value,omitempty"`
	// NextLink - The URL to get the next set of storage accounts.
	NextLink *string `json:"nextLink,omitempty"`
}

// StorageListResultIterator provides access to a complete listing of StorageAccountItem values.
type StorageListResultIterator struct {
	i    int
	page StorageListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StorageListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StorageListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StorageListResultIterator) Response() StorageListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StorageListResultIterator) Value() StorageAccountItem {
	if !iter.page.NotDone() {
		return StorageAccountItem{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (slr StorageListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// storageListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr StorageListResult) storageListResultPreparer() (*http.Request, error) {
	if slr.NextLink == nil || len(to.String(slr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// StorageListResultPage contains a page of StorageAccountItem values.
type StorageListResultPage struct {
	fn  func(StorageListResult) (StorageListResult, error)
	slr StorageListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StorageListResultPage) Next() error {
	next, err := page.fn(page.slr)
	if err != nil {
		return err
	}
	page.slr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StorageListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StorageListResultPage) Response() StorageListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StorageListResultPage) Values() []StorageAccountItem {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// SubjectAlternativeNames the subject alternate names of a X509 object.
type SubjectAlternativeNames struct {
	// Emails - Email addresses.
	Emails *[]string `json:"emails,omitempty"`
	// DNSNames - Domain names.
	DNSNames *[]string `json:"dns_names,omitempty"`
	// Upns - User principal names.
	Upns *[]string `json:"upns,omitempty"`
}

// Trigger a condition to be satisfied for an action to be executed.
type Trigger struct {
	// LifetimePercentage - Percentage of lifetime at which to trigger. Value should be between 1 and 99.
	LifetimePercentage *int32 `json:"lifetime_percentage,omitempty"`
	// DaysBeforeExpiry - Days before expiry to attempt renewal. Value should be between 1 and validity_in_months multiplied by 27. If validity_in_months is 36, then value should be between 1 and 972 (36 * 27).
	DaysBeforeExpiry *int32 `json:"days_before_expiry,omitempty"`
}

// X509CertificateProperties properties of the X509 component of a certificate.
type X509CertificateProperties struct {
	// Subject - The subject name. Should be a valid X509 distinguished Name.
	Subject *string `json:"subject,omitempty"`
	// Ekus - The enhanced key usage.
	Ekus *[]string `json:"ekus,omitempty"`
	// SubjectAlternativeNames - The subject alternative names.
	SubjectAlternativeNames *SubjectAlternativeNames `json:"sans,omitempty"`
	// KeyUsage - List of key usages.
	KeyUsage *[]KeyUsageType `json:"key_usage,omitempty"`
	// ValidityInMonths - The duration that the ceritifcate is valid in months.
	ValidityInMonths *int32 `json:"validity_months,omitempty"`
}
