// +build go1.9

// Copyright 2018 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package network

import original "github.com/Azure/azure-sdk-for-go/services/network/mgmt/2018-05-01/network"

type ApplicationGatewaysClient = original.ApplicationGatewaysClient
type ApplicationSecurityGroupsClient = original.ApplicationSecurityGroupsClient
type AvailableEndpointServicesClient = original.AvailableEndpointServicesClient
type BgpServiceCommunitiesClient = original.BgpServiceCommunitiesClient

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BaseClient = original.BaseClient
type ConnectionMonitorsClient = original.ConnectionMonitorsClient
type DdosProtectionPlansClient = original.DdosProtectionPlansClient
type DefaultSecurityRulesClient = original.DefaultSecurityRulesClient
type ExpressRouteCircuitAuthorizationsClient = original.ExpressRouteCircuitAuthorizationsClient
type ExpressRouteCircuitConnectionsClient = original.ExpressRouteCircuitConnectionsClient
type ExpressRouteCircuitPeeringsClient = original.ExpressRouteCircuitPeeringsClient
type ExpressRouteCircuitsClient = original.ExpressRouteCircuitsClient
type ExpressRouteCrossConnectionPeeringsClient = original.ExpressRouteCrossConnectionPeeringsClient
type ExpressRouteCrossConnectionsClient = original.ExpressRouteCrossConnectionsClient
type ExpressRouteServiceProvidersClient = original.ExpressRouteServiceProvidersClient
type InboundNatRulesClient = original.InboundNatRulesClient
type InterfaceIPConfigurationsClient = original.InterfaceIPConfigurationsClient
type InterfaceLoadBalancersClient = original.InterfaceLoadBalancersClient
type InterfacesClient = original.InterfacesClient
type LoadBalancerBackendAddressPoolsClient = original.LoadBalancerBackendAddressPoolsClient
type LoadBalancerFrontendIPConfigurationsClient = original.LoadBalancerFrontendIPConfigurationsClient
type LoadBalancerLoadBalancingRulesClient = original.LoadBalancerLoadBalancingRulesClient
type LoadBalancerNetworkInterfacesClient = original.LoadBalancerNetworkInterfacesClient
type LoadBalancerProbesClient = original.LoadBalancerProbesClient
type LoadBalancersClient = original.LoadBalancersClient
type LocalNetworkGatewaysClient = original.LocalNetworkGatewaysClient
type Access = original.Access

const (
	Allow Access = original.Allow
	Deny  Access = original.Deny
)

type ApplicationGatewayBackendHealthServerHealth = original.ApplicationGatewayBackendHealthServerHealth

const (
	Down     ApplicationGatewayBackendHealthServerHealth = original.Down
	Draining ApplicationGatewayBackendHealthServerHealth = original.Draining
	Partial  ApplicationGatewayBackendHealthServerHealth = original.Partial
	Unknown  ApplicationGatewayBackendHealthServerHealth = original.Unknown
	Up       ApplicationGatewayBackendHealthServerHealth = original.Up
)

type ApplicationGatewayCookieBasedAffinity = original.ApplicationGatewayCookieBasedAffinity

const (
	Disabled ApplicationGatewayCookieBasedAffinity = original.Disabled
	Enabled  ApplicationGatewayCookieBasedAffinity = original.Enabled
)

type ApplicationGatewayFirewallMode = original.ApplicationGatewayFirewallMode

const (
	Detection  ApplicationGatewayFirewallMode = original.Detection
	Prevention ApplicationGatewayFirewallMode = original.Prevention
)

type ApplicationGatewayOperationalState = original.ApplicationGatewayOperationalState

const (
	Running  ApplicationGatewayOperationalState = original.Running
	Starting ApplicationGatewayOperationalState = original.Starting
	Stopped  ApplicationGatewayOperationalState = original.Stopped
	Stopping ApplicationGatewayOperationalState = original.Stopping
)

type ApplicationGatewayProtocol = original.ApplicationGatewayProtocol

const (
	HTTP  ApplicationGatewayProtocol = original.HTTP
	HTTPS ApplicationGatewayProtocol = original.HTTPS
)

type ApplicationGatewayRedirectType = original.ApplicationGatewayRedirectType

const (
	Found     ApplicationGatewayRedirectType = original.Found
	Permanent ApplicationGatewayRedirectType = original.Permanent
	SeeOther  ApplicationGatewayRedirectType = original.SeeOther
	Temporary ApplicationGatewayRedirectType = original.Temporary
)

type ApplicationGatewayRequestRoutingRuleType = original.ApplicationGatewayRequestRoutingRuleType

const (
	Basic            ApplicationGatewayRequestRoutingRuleType = original.Basic
	PathBasedRouting ApplicationGatewayRequestRoutingRuleType = original.PathBasedRouting
)

type ApplicationGatewaySkuName = original.ApplicationGatewaySkuName

const (
	StandardLarge  ApplicationGatewaySkuName = original.StandardLarge
	StandardMedium ApplicationGatewaySkuName = original.StandardMedium
	StandardSmall  ApplicationGatewaySkuName = original.StandardSmall
	WAFLarge       ApplicationGatewaySkuName = original.WAFLarge
	WAFMedium      ApplicationGatewaySkuName = original.WAFMedium
)

type ApplicationGatewaySslCipherSuite = original.ApplicationGatewaySslCipherSuite

const (
	TLSDHEDSSWITHAES128CBCSHA        ApplicationGatewaySslCipherSuite = original.TLSDHEDSSWITHAES128CBCSHA
	TLSDHEDSSWITHAES128CBCSHA256     ApplicationGatewaySslCipherSuite = original.TLSDHEDSSWITHAES128CBCSHA256
	TLSDHEDSSWITHAES256CBCSHA        ApplicationGatewaySslCipherSuite = original.TLSDHEDSSWITHAES256CBCSHA
	TLSDHEDSSWITHAES256CBCSHA256     ApplicationGatewaySslCipherSuite = original.TLSDHEDSSWITHAES256CBCSHA256
	TLSDHERSAWITHAES128CBCSHA        ApplicationGatewaySslCipherSuite = original.TLSDHERSAWITHAES128CBCSHA
	TLSDHERSAWITHAES128GCMSHA256     ApplicationGatewaySslCipherSuite = original.TLSDHERSAWITHAES128GCMSHA256
	TLSDHERSAWITHAES256CBCSHA        ApplicationGatewaySslCipherSuite = original.TLSDHERSAWITHAES256CBCSHA
	TLSDHERSAWITHAES256GCMSHA384     ApplicationGatewaySslCipherSuite = original.TLSDHERSAWITHAES256GCMSHA384
	TLSECDHEECDSAWITHAES128CBCSHA    ApplicationGatewaySslCipherSuite = original.TLSECDHEECDSAWITHAES128CBCSHA
	TLSECDHEECDSAWITHAES128CBCSHA256 ApplicationGatewaySslCipherSuite = original.TLSECDHEECDSAWITHAES128CBCSHA256
	TLSECDHEECDSAWITHAES128GCMSHA256 ApplicationGatewaySslCipherSuite = original.TLSECDHEECDSAWITHAES128GCMSHA256
	TLSECDHEECDSAWITHAES256CBCSHA    ApplicationGatewaySslCipherSuite = original.TLSECDHEECDSAWITHAES256CBCSHA
	TLSECDHEECDSAWITHAES256CBCSHA384 ApplicationGatewaySslCipherSuite = original.TLSECDHEECDSAWITHAES256CBCSHA384
	TLSECDHEECDSAWITHAES256GCMSHA384 ApplicationGatewaySslCipherSuite = original.TLSECDHEECDSAWITHAES256GCMSHA384
	TLSECDHERSAWITHAES128CBCSHA      ApplicationGatewaySslCipherSuite = original.TLSECDHERSAWITHAES128CBCSHA
	TLSECDHERSAWITHAES128CBCSHA256   ApplicationGatewaySslCipherSuite = original.TLSECDHERSAWITHAES128CBCSHA256
	TLSECDHERSAWITHAES256CBCSHA      ApplicationGatewaySslCipherSuite = original.TLSECDHERSAWITHAES256CBCSHA
	TLSECDHERSAWITHAES256CBCSHA384   ApplicationGatewaySslCipherSuite = original.TLSECDHERSAWITHAES256CBCSHA384
	TLSRSAWITH3DESEDECBCSHA          ApplicationGatewaySslCipherSuite = original.TLSRSAWITH3DESEDECBCSHA
	TLSRSAWITHAES128CBCSHA           ApplicationGatewaySslCipherSuite = original.TLSRSAWITHAES128CBCSHA
	TLSRSAWITHAES128CBCSHA256        ApplicationGatewaySslCipherSuite = original.TLSRSAWITHAES128CBCSHA256
	TLSRSAWITHAES128GCMSHA256        ApplicationGatewaySslCipherSuite = original.TLSRSAWITHAES128GCMSHA256
	TLSRSAWITHAES256CBCSHA           ApplicationGatewaySslCipherSuite = original.TLSRSAWITHAES256CBCSHA
	TLSRSAWITHAES256CBCSHA256        ApplicationGatewaySslCipherSuite = original.TLSRSAWITHAES256CBCSHA256
	TLSRSAWITHAES256GCMSHA384        ApplicationGatewaySslCipherSuite = original.TLSRSAWITHAES256GCMSHA384
)

type ApplicationGatewaySslPolicyName = original.ApplicationGatewaySslPolicyName

const (
	AppGwSslPolicy20150501  ApplicationGatewaySslPolicyName = original.AppGwSslPolicy20150501
	AppGwSslPolicy20170401  ApplicationGatewaySslPolicyName = original.AppGwSslPolicy20170401
	AppGwSslPolicy20170401S ApplicationGatewaySslPolicyName = original.AppGwSslPolicy20170401S
)

type ApplicationGatewaySslPolicyType = original.ApplicationGatewaySslPolicyType

const (
	Custom     ApplicationGatewaySslPolicyType = original.Custom
	Predefined ApplicationGatewaySslPolicyType = original.Predefined
)

type ApplicationGatewaySslProtocol = original.ApplicationGatewaySslProtocol

const (
	TLSv10 ApplicationGatewaySslProtocol = original.TLSv10
	TLSv11 ApplicationGatewaySslProtocol = original.TLSv11
	TLSv12 ApplicationGatewaySslProtocol = original.TLSv12
)

type ApplicationGatewayTier = original.ApplicationGatewayTier

const (
	Standard ApplicationGatewayTier = original.Standard
	WAF      ApplicationGatewayTier = original.WAF
)

type AssociationType = original.AssociationType

const (
	Associated AssociationType = original.Associated
	Contains   AssociationType = original.Contains
)

type AuthenticationMethod = original.AuthenticationMethod

const (
	EAPMSCHAPv2 AuthenticationMethod = original.EAPMSCHAPv2
	EAPTLS      AuthenticationMethod = original.EAPTLS
)

type AuthorizationUseStatus = original.AuthorizationUseStatus

const (
	Available AuthorizationUseStatus = original.Available
	InUse     AuthorizationUseStatus = original.InUse
)

type BgpPeerState = original.BgpPeerState

const (
	BgpPeerStateConnected  BgpPeerState = original.BgpPeerStateConnected
	BgpPeerStateConnecting BgpPeerState = original.BgpPeerStateConnecting
	BgpPeerStateIdle       BgpPeerState = original.BgpPeerStateIdle
	BgpPeerStateStopped    BgpPeerState = original.BgpPeerStateStopped
	BgpPeerStateUnknown    BgpPeerState = original.BgpPeerStateUnknown
)

type CircuitConnectionStatus = original.CircuitConnectionStatus

const (
	Connected    CircuitConnectionStatus = original.Connected
	Connecting   CircuitConnectionStatus = original.Connecting
	Disconnected CircuitConnectionStatus = original.Disconnected
)

type ConnectionMonitorSourceStatus = original.ConnectionMonitorSourceStatus

const (
	Active   ConnectionMonitorSourceStatus = original.Active
	Inactive ConnectionMonitorSourceStatus = original.Inactive
	Uknown   ConnectionMonitorSourceStatus = original.Uknown
)

type ConnectionState = original.ConnectionState

const (
	ConnectionStateReachable   ConnectionState = original.ConnectionStateReachable
	ConnectionStateUnknown     ConnectionState = original.ConnectionStateUnknown
	ConnectionStateUnreachable ConnectionState = original.ConnectionStateUnreachable
)

type ConnectionStatus = original.ConnectionStatus

const (
	ConnectionStatusConnected    ConnectionStatus = original.ConnectionStatusConnected
	ConnectionStatusDegraded     ConnectionStatus = original.ConnectionStatusDegraded
	ConnectionStatusDisconnected ConnectionStatus = original.ConnectionStatusDisconnected
	ConnectionStatusUnknown      ConnectionStatus = original.ConnectionStatusUnknown
)

type DhGroup = original.DhGroup

const (
	DHGroup1    DhGroup = original.DHGroup1
	DHGroup14   DhGroup = original.DHGroup14
	DHGroup2    DhGroup = original.DHGroup2
	DHGroup2048 DhGroup = original.DHGroup2048
	DHGroup24   DhGroup = original.DHGroup24
	ECP256      DhGroup = original.ECP256
	ECP384      DhGroup = original.ECP384
	None        DhGroup = original.None
)

type Direction = original.Direction

const (
	Inbound  Direction = original.Inbound
	Outbound Direction = original.Outbound
)

type EffectiveRouteSource = original.EffectiveRouteSource

const (
	EffectiveRouteSourceDefault               EffectiveRouteSource = original.EffectiveRouteSourceDefault
	EffectiveRouteSourceUnknown               EffectiveRouteSource = original.EffectiveRouteSourceUnknown
	EffectiveRouteSourceUser                  EffectiveRouteSource = original.EffectiveRouteSourceUser
	EffectiveRouteSourceVirtualNetworkGateway EffectiveRouteSource = original.EffectiveRouteSourceVirtualNetworkGateway
)

type EffectiveRouteState = original.EffectiveRouteState

const (
	EffectiveRouteStateActive  EffectiveRouteState = original.EffectiveRouteStateActive
	EffectiveRouteStateInvalid EffectiveRouteState = original.EffectiveRouteStateInvalid
)

type EffectiveSecurityRuleProtocol = original.EffectiveSecurityRuleProtocol

const (
	All EffectiveSecurityRuleProtocol = original.All
	TCP EffectiveSecurityRuleProtocol = original.TCP
	UDP EffectiveSecurityRuleProtocol = original.UDP
)

type EvaluationState = original.EvaluationState

const (
	Completed  EvaluationState = original.Completed
	InProgress EvaluationState = original.InProgress
	NotStarted EvaluationState = original.NotStarted
)

type ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = original.ExpressRouteCircuitPeeringAdvertisedPublicPrefixState

const (
	Configured       ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = original.Configured
	Configuring      ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = original.Configuring
	NotConfigured    ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = original.NotConfigured
	ValidationNeeded ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = original.ValidationNeeded
)

type ExpressRouteCircuitPeeringState = original.ExpressRouteCircuitPeeringState

const (
	ExpressRouteCircuitPeeringStateDisabled ExpressRouteCircuitPeeringState = original.ExpressRouteCircuitPeeringStateDisabled
	ExpressRouteCircuitPeeringStateEnabled  ExpressRouteCircuitPeeringState = original.ExpressRouteCircuitPeeringStateEnabled
)

type ExpressRouteCircuitSkuFamily = original.ExpressRouteCircuitSkuFamily

const (
	MeteredData   ExpressRouteCircuitSkuFamily = original.MeteredData
	UnlimitedData ExpressRouteCircuitSkuFamily = original.UnlimitedData
)

type ExpressRouteCircuitSkuTier = original.ExpressRouteCircuitSkuTier

const (
	ExpressRouteCircuitSkuTierPremium  ExpressRouteCircuitSkuTier = original.ExpressRouteCircuitSkuTierPremium
	ExpressRouteCircuitSkuTierStandard ExpressRouteCircuitSkuTier = original.ExpressRouteCircuitSkuTierStandard
)

type ExpressRoutePeeringState = original.ExpressRoutePeeringState

const (
	ExpressRoutePeeringStateDisabled ExpressRoutePeeringState = original.ExpressRoutePeeringStateDisabled
	ExpressRoutePeeringStateEnabled  ExpressRoutePeeringState = original.ExpressRoutePeeringStateEnabled
)

type ExpressRoutePeeringType = original.ExpressRoutePeeringType

const (
	AzurePrivatePeering ExpressRoutePeeringType = original.AzurePrivatePeering
	AzurePublicPeering  ExpressRoutePeeringType = original.AzurePublicPeering
	MicrosoftPeering    ExpressRoutePeeringType = original.MicrosoftPeering
)

type HTTPMethod = original.HTTPMethod

const (
	Get HTTPMethod = original.Get
)

type IkeEncryption = original.IkeEncryption

const (
	AES128    IkeEncryption = original.AES128
	AES192    IkeEncryption = original.AES192
	AES256    IkeEncryption = original.AES256
	DES       IkeEncryption = original.DES
	DES3      IkeEncryption = original.DES3
	GCMAES128 IkeEncryption = original.GCMAES128
	GCMAES256 IkeEncryption = original.GCMAES256
)

type IkeIntegrity = original.IkeIntegrity

const (
	IkeIntegrityGCMAES128 IkeIntegrity = original.IkeIntegrityGCMAES128
	IkeIntegrityGCMAES256 IkeIntegrity = original.IkeIntegrityGCMAES256
	IkeIntegrityMD5       IkeIntegrity = original.IkeIntegrityMD5
	IkeIntegritySHA1      IkeIntegrity = original.IkeIntegritySHA1
	IkeIntegritySHA256    IkeIntegrity = original.IkeIntegritySHA256
	IkeIntegritySHA384    IkeIntegrity = original.IkeIntegritySHA384
)

type IPAllocationMethod = original.IPAllocationMethod

const (
	Dynamic IPAllocationMethod = original.Dynamic
	Static  IPAllocationMethod = original.Static
)

type IPFlowProtocol = original.IPFlowProtocol

const (
	IPFlowProtocolTCP IPFlowProtocol = original.IPFlowProtocolTCP
	IPFlowProtocolUDP IPFlowProtocol = original.IPFlowProtocolUDP
)

type IpsecEncryption = original.IpsecEncryption

const (
	IpsecEncryptionAES128    IpsecEncryption = original.IpsecEncryptionAES128
	IpsecEncryptionAES192    IpsecEncryption = original.IpsecEncryptionAES192
	IpsecEncryptionAES256    IpsecEncryption = original.IpsecEncryptionAES256
	IpsecEncryptionDES       IpsecEncryption = original.IpsecEncryptionDES
	IpsecEncryptionDES3      IpsecEncryption = original.IpsecEncryptionDES3
	IpsecEncryptionGCMAES128 IpsecEncryption = original.IpsecEncryptionGCMAES128
	IpsecEncryptionGCMAES192 IpsecEncryption = original.IpsecEncryptionGCMAES192
	IpsecEncryptionGCMAES256 IpsecEncryption = original.IpsecEncryptionGCMAES256
	IpsecEncryptionNone      IpsecEncryption = original.IpsecEncryptionNone
)

type IpsecIntegrity = original.IpsecIntegrity

const (
	IpsecIntegrityGCMAES128 IpsecIntegrity = original.IpsecIntegrityGCMAES128
	IpsecIntegrityGCMAES192 IpsecIntegrity = original.IpsecIntegrityGCMAES192
	IpsecIntegrityGCMAES256 IpsecIntegrity = original.IpsecIntegrityGCMAES256
	IpsecIntegrityMD5       IpsecIntegrity = original.IpsecIntegrityMD5
	IpsecIntegritySHA1      IpsecIntegrity = original.IpsecIntegritySHA1
	IpsecIntegritySHA256    IpsecIntegrity = original.IpsecIntegritySHA256
)

type IPVersion = original.IPVersion

const (
	IPv4 IPVersion = original.IPv4
	IPv6 IPVersion = original.IPv6
)

type IssueType = original.IssueType

const (
	IssueTypeAgentStopped        IssueType = original.IssueTypeAgentStopped
	IssueTypeDNSResolution       IssueType = original.IssueTypeDNSResolution
	IssueTypeGuestFirewall       IssueType = original.IssueTypeGuestFirewall
	IssueTypeNetworkSecurityRule IssueType = original.IssueTypeNetworkSecurityRule
	IssueTypePlatform            IssueType = original.IssueTypePlatform
	IssueTypePortThrottled       IssueType = original.IssueTypePortThrottled
	IssueTypeSocketBind          IssueType = original.IssueTypeSocketBind
	IssueTypeUnknown             IssueType = original.IssueTypeUnknown
	IssueTypeUserDefinedRoute    IssueType = original.IssueTypeUserDefinedRoute
)

type LoadBalancerSkuName = original.LoadBalancerSkuName

const (
	LoadBalancerSkuNameBasic    LoadBalancerSkuName = original.LoadBalancerSkuNameBasic
	LoadBalancerSkuNameStandard LoadBalancerSkuName = original.LoadBalancerSkuNameStandard
)

type LoadDistribution = original.LoadDistribution

const (
	Default          LoadDistribution = original.Default
	SourceIP         LoadDistribution = original.SourceIP
	SourceIPProtocol LoadDistribution = original.SourceIPProtocol
)

type NextHopType = original.NextHopType

const (
	NextHopTypeHyperNetGateway       NextHopType = original.NextHopTypeHyperNetGateway
	NextHopTypeInternet              NextHopType = original.NextHopTypeInternet
	NextHopTypeNone                  NextHopType = original.NextHopTypeNone
	NextHopTypeVirtualAppliance      NextHopType = original.NextHopTypeVirtualAppliance
	NextHopTypeVirtualNetworkGateway NextHopType = original.NextHopTypeVirtualNetworkGateway
	NextHopTypeVnetLocal             NextHopType = original.NextHopTypeVnetLocal
)

type OperationStatus = original.OperationStatus

const (
	OperationStatusFailed     OperationStatus = original.OperationStatusFailed
	OperationStatusInProgress OperationStatus = original.OperationStatusInProgress
	OperationStatusSucceeded  OperationStatus = original.OperationStatusSucceeded
)

type Origin = original.Origin

const (
	OriginInbound  Origin = original.OriginInbound
	OriginLocal    Origin = original.OriginLocal
	OriginOutbound Origin = original.OriginOutbound
)

type PcError = original.PcError

const (
	AgentStopped    PcError = original.AgentStopped
	CaptureFailed   PcError = original.CaptureFailed
	InternalError   PcError = original.InternalError
	LocalFileFailed PcError = original.LocalFileFailed
	StorageFailed   PcError = original.StorageFailed
)

type PcProtocol = original.PcProtocol

const (
	PcProtocolAny PcProtocol = original.PcProtocolAny
	PcProtocolTCP PcProtocol = original.PcProtocolTCP
	PcProtocolUDP PcProtocol = original.PcProtocolUDP
)

type PcStatus = original.PcStatus

const (
	PcStatusError      PcStatus = original.PcStatusError
	PcStatusNotStarted PcStatus = original.PcStatusNotStarted
	PcStatusRunning    PcStatus = original.PcStatusRunning
	PcStatusStopped    PcStatus = original.PcStatusStopped
	PcStatusUnknown    PcStatus = original.PcStatusUnknown
)

type PfsGroup = original.PfsGroup

const (
	PfsGroupECP256  PfsGroup = original.PfsGroupECP256
	PfsGroupECP384  PfsGroup = original.PfsGroupECP384
	PfsGroupNone    PfsGroup = original.PfsGroupNone
	PfsGroupPFS1    PfsGroup = original.PfsGroupPFS1
	PfsGroupPFS14   PfsGroup = original.PfsGroupPFS14
	PfsGroupPFS2    PfsGroup = original.PfsGroupPFS2
	PfsGroupPFS2048 PfsGroup = original.PfsGroupPFS2048
	PfsGroupPFS24   PfsGroup = original.PfsGroupPFS24
	PfsGroupPFSMM   PfsGroup = original.PfsGroupPFSMM
)

type ProbeProtocol = original.ProbeProtocol

const (
	ProbeProtocolHTTP  ProbeProtocol = original.ProbeProtocolHTTP
	ProbeProtocolHTTPS ProbeProtocol = original.ProbeProtocolHTTPS
	ProbeProtocolTCP   ProbeProtocol = original.ProbeProtocolTCP
)

type ProcessorArchitecture = original.ProcessorArchitecture

const (
	Amd64 ProcessorArchitecture = original.Amd64
	X86   ProcessorArchitecture = original.X86
)

type Protocol = original.Protocol

const (
	ProtocolHTTP  Protocol = original.ProtocolHTTP
	ProtocolHTTPS Protocol = original.ProtocolHTTPS
	ProtocolIcmp  Protocol = original.ProtocolIcmp
	ProtocolTCP   Protocol = original.ProtocolTCP
)

type ProvisioningState = original.ProvisioningState

const (
	Deleting  ProvisioningState = original.Deleting
	Failed    ProvisioningState = original.Failed
	Succeeded ProvisioningState = original.Succeeded
	Updating  ProvisioningState = original.Updating
)

type PublicIPAddressSkuName = original.PublicIPAddressSkuName

const (
	PublicIPAddressSkuNameBasic    PublicIPAddressSkuName = original.PublicIPAddressSkuNameBasic
	PublicIPAddressSkuNameStandard PublicIPAddressSkuName = original.PublicIPAddressSkuNameStandard
)

type RouteNextHopType = original.RouteNextHopType

const (
	RouteNextHopTypeInternet              RouteNextHopType = original.RouteNextHopTypeInternet
	RouteNextHopTypeNone                  RouteNextHopType = original.RouteNextHopTypeNone
	RouteNextHopTypeVirtualAppliance      RouteNextHopType = original.RouteNextHopTypeVirtualAppliance
	RouteNextHopTypeVirtualNetworkGateway RouteNextHopType = original.RouteNextHopTypeVirtualNetworkGateway
	RouteNextHopTypeVnetLocal             RouteNextHopType = original.RouteNextHopTypeVnetLocal
)

type SecurityRuleAccess = original.SecurityRuleAccess

const (
	SecurityRuleAccessAllow SecurityRuleAccess = original.SecurityRuleAccessAllow
	SecurityRuleAccessDeny  SecurityRuleAccess = original.SecurityRuleAccessDeny
)

type SecurityRuleDirection = original.SecurityRuleDirection

const (
	SecurityRuleDirectionInbound  SecurityRuleDirection = original.SecurityRuleDirectionInbound
	SecurityRuleDirectionOutbound SecurityRuleDirection = original.SecurityRuleDirectionOutbound
)

type SecurityRuleProtocol = original.SecurityRuleProtocol

const (
	SecurityRuleProtocolAsterisk SecurityRuleProtocol = original.SecurityRuleProtocolAsterisk
	SecurityRuleProtocolTCP      SecurityRuleProtocol = original.SecurityRuleProtocolTCP
	SecurityRuleProtocolUDP      SecurityRuleProtocol = original.SecurityRuleProtocolUDP
)

type ServiceProviderProvisioningState = original.ServiceProviderProvisioningState

const (
	Deprovisioning ServiceProviderProvisioningState = original.Deprovisioning
	NotProvisioned ServiceProviderProvisioningState = original.NotProvisioned
	Provisioned    ServiceProviderProvisioningState = original.Provisioned
	Provisioning   ServiceProviderProvisioningState = original.Provisioning
)

type Severity = original.Severity

const (
	SeverityError   Severity = original.SeverityError
	SeverityWarning Severity = original.SeverityWarning
)

type TransportProtocol = original.TransportProtocol

const (
	TransportProtocolAll TransportProtocol = original.TransportProtocolAll
	TransportProtocolTCP TransportProtocol = original.TransportProtocolTCP
	TransportProtocolUDP TransportProtocol = original.TransportProtocolUDP
)

type VirtualNetworkGatewayConnectionStatus = original.VirtualNetworkGatewayConnectionStatus

const (
	VirtualNetworkGatewayConnectionStatusConnected    VirtualNetworkGatewayConnectionStatus = original.VirtualNetworkGatewayConnectionStatusConnected
	VirtualNetworkGatewayConnectionStatusConnecting   VirtualNetworkGatewayConnectionStatus = original.VirtualNetworkGatewayConnectionStatusConnecting
	VirtualNetworkGatewayConnectionStatusNotConnected VirtualNetworkGatewayConnectionStatus = original.VirtualNetworkGatewayConnectionStatusNotConnected
	VirtualNetworkGatewayConnectionStatusUnknown      VirtualNetworkGatewayConnectionStatus = original.VirtualNetworkGatewayConnectionStatusUnknown
)

type VirtualNetworkGatewayConnectionType = original.VirtualNetworkGatewayConnectionType

const (
	ExpressRoute VirtualNetworkGatewayConnectionType = original.ExpressRoute
	IPsec        VirtualNetworkGatewayConnectionType = original.IPsec
	Vnet2Vnet    VirtualNetworkGatewayConnectionType = original.Vnet2Vnet
	VPNClient    VirtualNetworkGatewayConnectionType = original.VPNClient
)

type VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuName

const (
	VirtualNetworkGatewaySkuNameBasic            VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameBasic
	VirtualNetworkGatewaySkuNameErGw1AZ          VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameErGw1AZ
	VirtualNetworkGatewaySkuNameErGw2AZ          VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameErGw2AZ
	VirtualNetworkGatewaySkuNameErGw3AZ          VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameErGw3AZ
	VirtualNetworkGatewaySkuNameHighPerformance  VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameHighPerformance
	VirtualNetworkGatewaySkuNameStandard         VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameStandard
	VirtualNetworkGatewaySkuNameUltraPerformance VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameUltraPerformance
	VirtualNetworkGatewaySkuNameVpnGw1           VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw1
	VirtualNetworkGatewaySkuNameVpnGw1AZ         VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw1AZ
	VirtualNetworkGatewaySkuNameVpnGw2           VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw2
	VirtualNetworkGatewaySkuNameVpnGw2AZ         VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw2AZ
	VirtualNetworkGatewaySkuNameVpnGw3           VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw3
	VirtualNetworkGatewaySkuNameVpnGw3AZ         VirtualNetworkGatewaySkuName = original.VirtualNetworkGatewaySkuNameVpnGw3AZ
)

type VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTier

const (
	VirtualNetworkGatewaySkuTierBasic            VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierBasic
	VirtualNetworkGatewaySkuTierErGw1AZ          VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierErGw1AZ
	VirtualNetworkGatewaySkuTierErGw2AZ          VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierErGw2AZ
	VirtualNetworkGatewaySkuTierErGw3AZ          VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierErGw3AZ
	VirtualNetworkGatewaySkuTierHighPerformance  VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierHighPerformance
	VirtualNetworkGatewaySkuTierStandard         VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierStandard
	VirtualNetworkGatewaySkuTierUltraPerformance VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierUltraPerformance
	VirtualNetworkGatewaySkuTierVpnGw1           VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw1
	VirtualNetworkGatewaySkuTierVpnGw1AZ         VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw1AZ
	VirtualNetworkGatewaySkuTierVpnGw2           VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw2
	VirtualNetworkGatewaySkuTierVpnGw2AZ         VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw2AZ
	VirtualNetworkGatewaySkuTierVpnGw3           VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw3
	VirtualNetworkGatewaySkuTierVpnGw3AZ         VirtualNetworkGatewaySkuTier = original.VirtualNetworkGatewaySkuTierVpnGw3AZ
)

type VirtualNetworkGatewayType = original.VirtualNetworkGatewayType

const (
	VirtualNetworkGatewayTypeExpressRoute VirtualNetworkGatewayType = original.VirtualNetworkGatewayTypeExpressRoute
	VirtualNetworkGatewayTypeVpn          VirtualNetworkGatewayType = original.VirtualNetworkGatewayTypeVpn
)

type VirtualNetworkPeeringState = original.VirtualNetworkPeeringState

const (
	VirtualNetworkPeeringStateConnected    VirtualNetworkPeeringState = original.VirtualNetworkPeeringStateConnected
	VirtualNetworkPeeringStateDisconnected VirtualNetworkPeeringState = original.VirtualNetworkPeeringStateDisconnected
	VirtualNetworkPeeringStateInitiated    VirtualNetworkPeeringState = original.VirtualNetworkPeeringStateInitiated
)

type VpnClientProtocol = original.VpnClientProtocol

const (
	IkeV2 VpnClientProtocol = original.IkeV2
	SSTP  VpnClientProtocol = original.SSTP
)

type VpnType = original.VpnType

const (
	PolicyBased VpnType = original.PolicyBased
	RouteBased  VpnType = original.RouteBased
)

type AddressSpace = original.AddressSpace
type ApplicationGateway = original.ApplicationGateway
type ApplicationGatewayAuthenticationCertificate = original.ApplicationGatewayAuthenticationCertificate
type ApplicationGatewayAuthenticationCertificatePropertiesFormat = original.ApplicationGatewayAuthenticationCertificatePropertiesFormat
type ApplicationGatewayAvailableSslOptions = original.ApplicationGatewayAvailableSslOptions
type ApplicationGatewayAvailableSslOptionsPropertiesFormat = original.ApplicationGatewayAvailableSslOptionsPropertiesFormat
type ApplicationGatewayAvailableSslPredefinedPolicies = original.ApplicationGatewayAvailableSslPredefinedPolicies
type ApplicationGatewayAvailableSslPredefinedPoliciesIterator = original.ApplicationGatewayAvailableSslPredefinedPoliciesIterator
type ApplicationGatewayAvailableSslPredefinedPoliciesPage = original.ApplicationGatewayAvailableSslPredefinedPoliciesPage
type ApplicationGatewayAvailableWafRuleSetsResult = original.ApplicationGatewayAvailableWafRuleSetsResult
type ApplicationGatewayBackendAddress = original.ApplicationGatewayBackendAddress
type ApplicationGatewayBackendAddressPool = original.ApplicationGatewayBackendAddressPool
type ApplicationGatewayBackendAddressPoolPropertiesFormat = original.ApplicationGatewayBackendAddressPoolPropertiesFormat
type ApplicationGatewayBackendHealth = original.ApplicationGatewayBackendHealth
type ApplicationGatewayBackendHealthHTTPSettings = original.ApplicationGatewayBackendHealthHTTPSettings
type ApplicationGatewayBackendHealthPool = original.ApplicationGatewayBackendHealthPool
type ApplicationGatewayBackendHealthServer = original.ApplicationGatewayBackendHealthServer
type ApplicationGatewayBackendHTTPSettings = original.ApplicationGatewayBackendHTTPSettings
type ApplicationGatewayBackendHTTPSettingsPropertiesFormat = original.ApplicationGatewayBackendHTTPSettingsPropertiesFormat
type ApplicationGatewayConnectionDraining = original.ApplicationGatewayConnectionDraining
type ApplicationGatewayFirewallDisabledRuleGroup = original.ApplicationGatewayFirewallDisabledRuleGroup
type ApplicationGatewayFirewallRule = original.ApplicationGatewayFirewallRule
type ApplicationGatewayFirewallRuleGroup = original.ApplicationGatewayFirewallRuleGroup
type ApplicationGatewayFirewallRuleSet = original.ApplicationGatewayFirewallRuleSet
type ApplicationGatewayFirewallRuleSetPropertiesFormat = original.ApplicationGatewayFirewallRuleSetPropertiesFormat
type ApplicationGatewayFrontendIPConfiguration = original.ApplicationGatewayFrontendIPConfiguration
type ApplicationGatewayFrontendIPConfigurationPropertiesFormat = original.ApplicationGatewayFrontendIPConfigurationPropertiesFormat
type ApplicationGatewayFrontendPort = original.ApplicationGatewayFrontendPort
type ApplicationGatewayFrontendPortPropertiesFormat = original.ApplicationGatewayFrontendPortPropertiesFormat
type ApplicationGatewayHTTPListener = original.ApplicationGatewayHTTPListener
type ApplicationGatewayHTTPListenerPropertiesFormat = original.ApplicationGatewayHTTPListenerPropertiesFormat
type ApplicationGatewayIPConfiguration = original.ApplicationGatewayIPConfiguration
type ApplicationGatewayIPConfigurationPropertiesFormat = original.ApplicationGatewayIPConfigurationPropertiesFormat
type ApplicationGatewayListResult = original.ApplicationGatewayListResult
type ApplicationGatewayListResultIterator = original.ApplicationGatewayListResultIterator
type ApplicationGatewayListResultPage = original.ApplicationGatewayListResultPage
type ApplicationGatewayPathRule = original.ApplicationGatewayPathRule
type ApplicationGatewayPathRulePropertiesFormat = original.ApplicationGatewayPathRulePropertiesFormat
type ApplicationGatewayProbe = original.ApplicationGatewayProbe
type ApplicationGatewayProbeHealthResponseMatch = original.ApplicationGatewayProbeHealthResponseMatch
type ApplicationGatewayProbePropertiesFormat = original.ApplicationGatewayProbePropertiesFormat
type ApplicationGatewayPropertiesFormat = original.ApplicationGatewayPropertiesFormat
type ApplicationGatewayRedirectConfiguration = original.ApplicationGatewayRedirectConfiguration
type ApplicationGatewayRedirectConfigurationPropertiesFormat = original.ApplicationGatewayRedirectConfigurationPropertiesFormat
type ApplicationGatewayRequestRoutingRule = original.ApplicationGatewayRequestRoutingRule
type ApplicationGatewayRequestRoutingRulePropertiesFormat = original.ApplicationGatewayRequestRoutingRulePropertiesFormat
type ApplicationGatewaysBackendHealthFuture = original.ApplicationGatewaysBackendHealthFuture
type ApplicationGatewaysCreateOrUpdateFuture = original.ApplicationGatewaysCreateOrUpdateFuture
type ApplicationGatewaysDeleteFuture = original.ApplicationGatewaysDeleteFuture
type ApplicationGatewaySku = original.ApplicationGatewaySku
type ApplicationGatewaySslCertificate = original.ApplicationGatewaySslCertificate
type ApplicationGatewaySslCertificatePropertiesFormat = original.ApplicationGatewaySslCertificatePropertiesFormat
type ApplicationGatewaySslPolicy = original.ApplicationGatewaySslPolicy
type ApplicationGatewaySslPredefinedPolicy = original.ApplicationGatewaySslPredefinedPolicy
type ApplicationGatewaySslPredefinedPolicyPropertiesFormat = original.ApplicationGatewaySslPredefinedPolicyPropertiesFormat
type ApplicationGatewaysStartFuture = original.ApplicationGatewaysStartFuture
type ApplicationGatewaysStopFuture = original.ApplicationGatewaysStopFuture
type ApplicationGatewaysUpdateTagsFuture = original.ApplicationGatewaysUpdateTagsFuture
type ApplicationGatewayURLPathMap = original.ApplicationGatewayURLPathMap
type ApplicationGatewayURLPathMapPropertiesFormat = original.ApplicationGatewayURLPathMapPropertiesFormat
type ApplicationGatewayWebApplicationFirewallConfiguration = original.ApplicationGatewayWebApplicationFirewallConfiguration
type ApplicationSecurityGroup = original.ApplicationSecurityGroup
type ApplicationSecurityGroupListResult = original.ApplicationSecurityGroupListResult
type ApplicationSecurityGroupListResultIterator = original.ApplicationSecurityGroupListResultIterator
type ApplicationSecurityGroupListResultPage = original.ApplicationSecurityGroupListResultPage
type ApplicationSecurityGroupPropertiesFormat = original.ApplicationSecurityGroupPropertiesFormat
type ApplicationSecurityGroupsCreateOrUpdateFuture = original.ApplicationSecurityGroupsCreateOrUpdateFuture
type ApplicationSecurityGroupsDeleteFuture = original.ApplicationSecurityGroupsDeleteFuture
type AuthorizationListResult = original.AuthorizationListResult
type AuthorizationListResultIterator = original.AuthorizationListResultIterator
type AuthorizationListResultPage = original.AuthorizationListResultPage
type AuthorizationPropertiesFormat = original.AuthorizationPropertiesFormat
type Availability = original.Availability
type AvailableProvidersList = original.AvailableProvidersList
type AvailableProvidersListCity = original.AvailableProvidersListCity
type AvailableProvidersListCountry = original.AvailableProvidersListCountry
type AvailableProvidersListParameters = original.AvailableProvidersListParameters
type AvailableProvidersListState = original.AvailableProvidersListState
type AzureAsyncOperationResult = original.AzureAsyncOperationResult
type AzureReachabilityReport = original.AzureReachabilityReport
type AzureReachabilityReportItem = original.AzureReachabilityReportItem
type AzureReachabilityReportLatencyInfo = original.AzureReachabilityReportLatencyInfo
type AzureReachabilityReportLocation = original.AzureReachabilityReportLocation
type AzureReachabilityReportParameters = original.AzureReachabilityReportParameters
type BackendAddressPool = original.BackendAddressPool
type BackendAddressPoolPropertiesFormat = original.BackendAddressPoolPropertiesFormat
type BGPCommunity = original.BGPCommunity
type BgpPeerStatus = original.BgpPeerStatus
type BgpPeerStatusListResult = original.BgpPeerStatusListResult
type BgpServiceCommunity = original.BgpServiceCommunity
type BgpServiceCommunityListResult = original.BgpServiceCommunityListResult
type BgpServiceCommunityListResultIterator = original.BgpServiceCommunityListResultIterator
type BgpServiceCommunityListResultPage = original.BgpServiceCommunityListResultPage
type BgpServiceCommunityPropertiesFormat = original.BgpServiceCommunityPropertiesFormat
type BgpSettings = original.BgpSettings
type ConnectionMonitor = original.ConnectionMonitor
type ConnectionMonitorDestination = original.ConnectionMonitorDestination
type ConnectionMonitorListResult = original.ConnectionMonitorListResult
type ConnectionMonitorParameters = original.ConnectionMonitorParameters
type ConnectionMonitorQueryResult = original.ConnectionMonitorQueryResult
type ConnectionMonitorResult = original.ConnectionMonitorResult
type ConnectionMonitorResultProperties = original.ConnectionMonitorResultProperties
type ConnectionMonitorsCreateOrUpdateFuture = original.ConnectionMonitorsCreateOrUpdateFuture
type ConnectionMonitorsDeleteFuture = original.ConnectionMonitorsDeleteFuture
type ConnectionMonitorSource = original.ConnectionMonitorSource
type ConnectionMonitorsQueryFuture = original.ConnectionMonitorsQueryFuture
type ConnectionMonitorsStartFuture = original.ConnectionMonitorsStartFuture
type ConnectionMonitorsStopFuture = original.ConnectionMonitorsStopFuture
type ConnectionResetSharedKey = original.ConnectionResetSharedKey
type ConnectionSharedKey = original.ConnectionSharedKey
type ConnectionStateSnapshot = original.ConnectionStateSnapshot
type ConnectivityDestination = original.ConnectivityDestination
type ConnectivityHop = original.ConnectivityHop
type ConnectivityInformation = original.ConnectivityInformation
type ConnectivityIssue = original.ConnectivityIssue
type ConnectivityParameters = original.ConnectivityParameters
type ConnectivitySource = original.ConnectivitySource
type DdosProtectionPlan = original.DdosProtectionPlan
type DdosProtectionPlanListResult = original.DdosProtectionPlanListResult
type DdosProtectionPlanListResultIterator = original.DdosProtectionPlanListResultIterator
type DdosProtectionPlanListResultPage = original.DdosProtectionPlanListResultPage
type DdosProtectionPlanPropertiesFormat = original.DdosProtectionPlanPropertiesFormat
type DdosProtectionPlansCreateOrUpdateFuture = original.DdosProtectionPlansCreateOrUpdateFuture
type DdosProtectionPlansDeleteFuture = original.DdosProtectionPlansDeleteFuture
type DhcpOptions = original.DhcpOptions
type Dimension = original.Dimension
type DNSNameAvailabilityResult = original.DNSNameAvailabilityResult
type EffectiveNetworkSecurityGroup = original.EffectiveNetworkSecurityGroup
type EffectiveNetworkSecurityGroupAssociation = original.EffectiveNetworkSecurityGroupAssociation
type EffectiveNetworkSecurityGroupListResult = original.EffectiveNetworkSecurityGroupListResult
type EffectiveNetworkSecurityRule = original.EffectiveNetworkSecurityRule
type EffectiveRoute = original.EffectiveRoute
type EffectiveRouteListResult = original.EffectiveRouteListResult
type EndpointServiceResult = original.EndpointServiceResult
type EndpointServicesListResult = original.EndpointServicesListResult
type EndpointServicesListResultIterator = original.EndpointServicesListResultIterator
type EndpointServicesListResultPage = original.EndpointServicesListResultPage
type Error = original.Error
type ErrorDetails = original.ErrorDetails
type ExpressRouteCircuit = original.ExpressRouteCircuit
type ExpressRouteCircuitArpTable = original.ExpressRouteCircuitArpTable
type ExpressRouteCircuitAuthorization = original.ExpressRouteCircuitAuthorization
type ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture = original.ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture
type ExpressRouteCircuitAuthorizationsDeleteFuture = original.ExpressRouteCircuitAuthorizationsDeleteFuture
type ExpressRouteCircuitConnection = original.ExpressRouteCircuitConnection
type ExpressRouteCircuitConnectionPropertiesFormat = original.ExpressRouteCircuitConnectionPropertiesFormat
type ExpressRouteCircuitConnectionsCreateOrUpdateFuture = original.ExpressRouteCircuitConnectionsCreateOrUpdateFuture
type ExpressRouteCircuitConnectionsDeleteFuture = original.ExpressRouteCircuitConnectionsDeleteFuture
type ExpressRouteCircuitListResult = original.ExpressRouteCircuitListResult
type ExpressRouteCircuitListResultIterator = original.ExpressRouteCircuitListResultIterator
type ExpressRouteCircuitListResultPage = original.ExpressRouteCircuitListResultPage
type ExpressRouteCircuitPeering = original.ExpressRouteCircuitPeering
type ExpressRouteCircuitPeeringConfig = original.ExpressRouteCircuitPeeringConfig
type ExpressRouteCircuitPeeringListResult = original.ExpressRouteCircuitPeeringListResult
type ExpressRouteCircuitPeeringListResultIterator = original.ExpressRouteCircuitPeeringListResultIterator
type ExpressRouteCircuitPeeringListResultPage = original.ExpressRouteCircuitPeeringListResultPage
type ExpressRouteCircuitPeeringPropertiesFormat = original.ExpressRouteCircuitPeeringPropertiesFormat
type ExpressRouteCircuitPeeringsCreateOrUpdateFuture = original.ExpressRouteCircuitPeeringsCreateOrUpdateFuture
type ExpressRouteCircuitPeeringsDeleteFuture = original.ExpressRouteCircuitPeeringsDeleteFuture
type ExpressRouteCircuitPropertiesFormat = original.ExpressRouteCircuitPropertiesFormat
type ExpressRouteCircuitReference = original.ExpressRouteCircuitReference
type ExpressRouteCircuitRoutesTable = original.ExpressRouteCircuitRoutesTable
type ExpressRouteCircuitRoutesTableSummary = original.ExpressRouteCircuitRoutesTableSummary
type ExpressRouteCircuitsArpTableListResult = original.ExpressRouteCircuitsArpTableListResult
type ExpressRouteCircuitsCreateOrUpdateFuture = original.ExpressRouteCircuitsCreateOrUpdateFuture
type ExpressRouteCircuitsDeleteFuture = original.ExpressRouteCircuitsDeleteFuture
type ExpressRouteCircuitServiceProviderProperties = original.ExpressRouteCircuitServiceProviderProperties
type ExpressRouteCircuitSku = original.ExpressRouteCircuitSku
type ExpressRouteCircuitsListArpTableFuture = original.ExpressRouteCircuitsListArpTableFuture
type ExpressRouteCircuitsListRoutesTableFuture = original.ExpressRouteCircuitsListRoutesTableFuture
type ExpressRouteCircuitsListRoutesTableSummaryFuture = original.ExpressRouteCircuitsListRoutesTableSummaryFuture
type ExpressRouteCircuitsRoutesTableListResult = original.ExpressRouteCircuitsRoutesTableListResult
type ExpressRouteCircuitsRoutesTableSummaryListResult = original.ExpressRouteCircuitsRoutesTableSummaryListResult
type ExpressRouteCircuitStats = original.ExpressRouteCircuitStats
type ExpressRouteCircuitsUpdateTagsFuture = original.ExpressRouteCircuitsUpdateTagsFuture
type ExpressRouteCrossConnection = original.ExpressRouteCrossConnection
type ExpressRouteCrossConnectionListResult = original.ExpressRouteCrossConnectionListResult
type ExpressRouteCrossConnectionListResultIterator = original.ExpressRouteCrossConnectionListResultIterator
type ExpressRouteCrossConnectionListResultPage = original.ExpressRouteCrossConnectionListResultPage
type ExpressRouteCrossConnectionPeering = original.ExpressRouteCrossConnectionPeering
type ExpressRouteCrossConnectionPeeringList = original.ExpressRouteCrossConnectionPeeringList
type ExpressRouteCrossConnectionPeeringListIterator = original.ExpressRouteCrossConnectionPeeringListIterator
type ExpressRouteCrossConnectionPeeringListPage = original.ExpressRouteCrossConnectionPeeringListPage
type ExpressRouteCrossConnectionPeeringProperties = original.ExpressRouteCrossConnectionPeeringProperties
type ExpressRouteCrossConnectionPeeringsCreateOrUpdateFuture = original.ExpressRouteCrossConnectionPeeringsCreateOrUpdateFuture
type ExpressRouteCrossConnectionPeeringsDeleteFuture = original.ExpressRouteCrossConnectionPeeringsDeleteFuture
type ExpressRouteCrossConnectionProperties = original.ExpressRouteCrossConnectionProperties
type ExpressRouteCrossConnectionRoutesTableSummary = original.ExpressRouteCrossConnectionRoutesTableSummary
type ExpressRouteCrossConnectionsCreateOrUpdateFuture = original.ExpressRouteCrossConnectionsCreateOrUpdateFuture
type ExpressRouteCrossConnectionsListArpTableFuture = original.ExpressRouteCrossConnectionsListArpTableFuture
type ExpressRouteCrossConnectionsListRoutesTableFuture = original.ExpressRouteCrossConnectionsListRoutesTableFuture
type ExpressRouteCrossConnectionsListRoutesTableSummaryFuture = original.ExpressRouteCrossConnectionsListRoutesTableSummaryFuture
type ExpressRouteCrossConnectionsRoutesTableSummaryListResult = original.ExpressRouteCrossConnectionsRoutesTableSummaryListResult
type ExpressRouteCrossConnectionsUpdateTagsFuture = original.ExpressRouteCrossConnectionsUpdateTagsFuture
type ExpressRouteServiceProvider = original.ExpressRouteServiceProvider
type ExpressRouteServiceProviderBandwidthsOffered = original.ExpressRouteServiceProviderBandwidthsOffered
type ExpressRouteServiceProviderListResult = original.ExpressRouteServiceProviderListResult
type ExpressRouteServiceProviderListResultIterator = original.ExpressRouteServiceProviderListResultIterator
type ExpressRouteServiceProviderListResultPage = original.ExpressRouteServiceProviderListResultPage
type ExpressRouteServiceProviderPropertiesFormat = original.ExpressRouteServiceProviderPropertiesFormat
type FlowLogInformation = original.FlowLogInformation
type FlowLogProperties = original.FlowLogProperties
type FlowLogStatusParameters = original.FlowLogStatusParameters
type FrontendIPConfiguration = original.FrontendIPConfiguration
type FrontendIPConfigurationPropertiesFormat = original.FrontendIPConfigurationPropertiesFormat
type GatewayRoute = original.GatewayRoute
type GatewayRouteListResult = original.GatewayRouteListResult
type HTTPConfiguration = original.HTTPConfiguration
type HTTPHeader = original.HTTPHeader
type InboundNatPool = original.InboundNatPool
type InboundNatPoolPropertiesFormat = original.InboundNatPoolPropertiesFormat
type InboundNatRule = original.InboundNatRule
type InboundNatRuleListResult = original.InboundNatRuleListResult
type InboundNatRuleListResultIterator = original.InboundNatRuleListResultIterator
type InboundNatRuleListResultPage = original.InboundNatRuleListResultPage
type InboundNatRulePropertiesFormat = original.InboundNatRulePropertiesFormat
type InboundNatRulesCreateOrUpdateFuture = original.InboundNatRulesCreateOrUpdateFuture
type InboundNatRulesDeleteFuture = original.InboundNatRulesDeleteFuture
type Interface = original.Interface
type InterfaceAssociation = original.InterfaceAssociation
type InterfaceDNSSettings = original.InterfaceDNSSettings
type InterfaceIPConfiguration = original.InterfaceIPConfiguration
type InterfaceIPConfigurationListResult = original.InterfaceIPConfigurationListResult
type InterfaceIPConfigurationListResultIterator = original.InterfaceIPConfigurationListResultIterator
type InterfaceIPConfigurationListResultPage = original.InterfaceIPConfigurationListResultPage
type InterfaceIPConfigurationPropertiesFormat = original.InterfaceIPConfigurationPropertiesFormat
type InterfaceListResult = original.InterfaceListResult
type InterfaceListResultIterator = original.InterfaceListResultIterator
type InterfaceListResultPage = original.InterfaceListResultPage
type InterfaceLoadBalancerListResult = original.InterfaceLoadBalancerListResult
type InterfaceLoadBalancerListResultIterator = original.InterfaceLoadBalancerListResultIterator
type InterfaceLoadBalancerListResultPage = original.InterfaceLoadBalancerListResultPage
type InterfacePropertiesFormat = original.InterfacePropertiesFormat
type InterfacesCreateOrUpdateFuture = original.InterfacesCreateOrUpdateFuture
type InterfacesDeleteFuture = original.InterfacesDeleteFuture
type InterfacesGetEffectiveRouteTableFuture = original.InterfacesGetEffectiveRouteTableFuture
type InterfacesListEffectiveNetworkSecurityGroupsFuture = original.InterfacesListEffectiveNetworkSecurityGroupsFuture
type InterfacesUpdateTagsFuture = original.InterfacesUpdateTagsFuture
type IPAddressAvailabilityResult = original.IPAddressAvailabilityResult
type IPConfiguration = original.IPConfiguration
type IPConfigurationPropertiesFormat = original.IPConfigurationPropertiesFormat
type IpsecPolicy = original.IpsecPolicy
type IPTag = original.IPTag
type Ipv6ExpressRouteCircuitPeeringConfig = original.Ipv6ExpressRouteCircuitPeeringConfig
type LoadBalancer = original.LoadBalancer
type LoadBalancerBackendAddressPoolListResult = original.LoadBalancerBackendAddressPoolListResult
type LoadBalancerBackendAddressPoolListResultIterator = original.LoadBalancerBackendAddressPoolListResultIterator
type LoadBalancerBackendAddressPoolListResultPage = original.LoadBalancerBackendAddressPoolListResultPage
type LoadBalancerFrontendIPConfigurationListResult = original.LoadBalancerFrontendIPConfigurationListResult
type LoadBalancerFrontendIPConfigurationListResultIterator = original.LoadBalancerFrontendIPConfigurationListResultIterator
type LoadBalancerFrontendIPConfigurationListResultPage = original.LoadBalancerFrontendIPConfigurationListResultPage
type LoadBalancerListResult = original.LoadBalancerListResult
type LoadBalancerListResultIterator = original.LoadBalancerListResultIterator
type LoadBalancerListResultPage = original.LoadBalancerListResultPage
type LoadBalancerLoadBalancingRuleListResult = original.LoadBalancerLoadBalancingRuleListResult
type LoadBalancerLoadBalancingRuleListResultIterator = original.LoadBalancerLoadBalancingRuleListResultIterator
type LoadBalancerLoadBalancingRuleListResultPage = original.LoadBalancerLoadBalancingRuleListResultPage
type LoadBalancerProbeListResult = original.LoadBalancerProbeListResult
type LoadBalancerProbeListResultIterator = original.LoadBalancerProbeListResultIterator
type LoadBalancerProbeListResultPage = original.LoadBalancerProbeListResultPage
type LoadBalancerPropertiesFormat = original.LoadBalancerPropertiesFormat
type LoadBalancersCreateOrUpdateFuture = original.LoadBalancersCreateOrUpdateFuture
type LoadBalancersDeleteFuture = original.LoadBalancersDeleteFuture
type LoadBalancerSku = original.LoadBalancerSku
type LoadBalancersUpdateTagsFuture = original.LoadBalancersUpdateTagsFuture
type LoadBalancingRule = original.LoadBalancingRule
type LoadBalancingRulePropertiesFormat = original.LoadBalancingRulePropertiesFormat
type LocalNetworkGateway = original.LocalNetworkGateway
type LocalNetworkGatewayListResult = original.LocalNetworkGatewayListResult
type LocalNetworkGatewayListResultIterator = original.LocalNetworkGatewayListResultIterator
type LocalNetworkGatewayListResultPage = original.LocalNetworkGatewayListResultPage
type LocalNetworkGatewayPropertiesFormat = original.LocalNetworkGatewayPropertiesFormat
type LocalNetworkGatewaysCreateOrUpdateFuture = original.LocalNetworkGatewaysCreateOrUpdateFuture
type LocalNetworkGatewaysDeleteFuture = original.LocalNetworkGatewaysDeleteFuture
type LocalNetworkGatewaysUpdateTagsFuture = original.LocalNetworkGatewaysUpdateTagsFuture
type LogSpecification = original.LogSpecification
type MetricSpecification = original.MetricSpecification
type NextHopParameters = original.NextHopParameters
type NextHopResult = original.NextHopResult
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationPropertiesFormat = original.OperationPropertiesFormat
type OperationPropertiesFormatServiceSpecification = original.OperationPropertiesFormatServiceSpecification
type OutboundNatRule = original.OutboundNatRule
type OutboundNatRulePropertiesFormat = original.OutboundNatRulePropertiesFormat
type PacketCapture = original.PacketCapture
type PacketCaptureFilter = original.PacketCaptureFilter
type PacketCaptureListResult = original.PacketCaptureListResult
type PacketCaptureParameters = original.PacketCaptureParameters
type PacketCaptureQueryStatusResult = original.PacketCaptureQueryStatusResult
type PacketCaptureResult = original.PacketCaptureResult
type PacketCaptureResultProperties = original.PacketCaptureResultProperties
type PacketCapturesCreateFuture = original.PacketCapturesCreateFuture
type PacketCapturesDeleteFuture = original.PacketCapturesDeleteFuture
type PacketCapturesGetStatusFuture = original.PacketCapturesGetStatusFuture
type PacketCapturesStopFuture = original.PacketCapturesStopFuture
type PacketCaptureStorageLocation = original.PacketCaptureStorageLocation
type PatchRouteFilter = original.PatchRouteFilter
type PatchRouteFilterRule = original.PatchRouteFilterRule
type Probe = original.Probe
type ProbePropertiesFormat = original.ProbePropertiesFormat
type ProtocolConfiguration = original.ProtocolConfiguration
type PublicIPAddress = original.PublicIPAddress
type PublicIPAddressDNSSettings = original.PublicIPAddressDNSSettings
type PublicIPAddressesCreateOrUpdateFuture = original.PublicIPAddressesCreateOrUpdateFuture
type PublicIPAddressesDeleteFuture = original.PublicIPAddressesDeleteFuture
type PublicIPAddressesUpdateTagsFuture = original.PublicIPAddressesUpdateTagsFuture
type PublicIPAddressListResult = original.PublicIPAddressListResult
type PublicIPAddressListResultIterator = original.PublicIPAddressListResultIterator
type PublicIPAddressListResultPage = original.PublicIPAddressListResultPage
type PublicIPAddressPropertiesFormat = original.PublicIPAddressPropertiesFormat
type PublicIPAddressSku = original.PublicIPAddressSku
type QueryTroubleshootingParameters = original.QueryTroubleshootingParameters
type Resource = original.Resource
type ResourceNavigationLink = original.ResourceNavigationLink
type ResourceNavigationLinkFormat = original.ResourceNavigationLinkFormat
type RetentionPolicyParameters = original.RetentionPolicyParameters
type Route = original.Route
type RouteFilter = original.RouteFilter
type RouteFilterListResult = original.RouteFilterListResult
type RouteFilterListResultIterator = original.RouteFilterListResultIterator
type RouteFilterListResultPage = original.RouteFilterListResultPage
type RouteFilterPropertiesFormat = original.RouteFilterPropertiesFormat
type RouteFilterRule = original.RouteFilterRule
type RouteFilterRuleListResult = original.RouteFilterRuleListResult
type RouteFilterRuleListResultIterator = original.RouteFilterRuleListResultIterator
type RouteFilterRuleListResultPage = original.RouteFilterRuleListResultPage
type RouteFilterRulePropertiesFormat = original.RouteFilterRulePropertiesFormat
type RouteFilterRulesCreateOrUpdateFuture = original.RouteFilterRulesCreateOrUpdateFuture
type RouteFilterRulesDeleteFuture = original.RouteFilterRulesDeleteFuture
type RouteFilterRulesUpdateFuture = original.RouteFilterRulesUpdateFuture
type RouteFiltersCreateOrUpdateFuture = original.RouteFiltersCreateOrUpdateFuture
type RouteFiltersDeleteFuture = original.RouteFiltersDeleteFuture
type RouteFiltersUpdateFuture = original.RouteFiltersUpdateFuture
type RouteListResult = original.RouteListResult
type RouteListResultIterator = original.RouteListResultIterator
type RouteListResultPage = original.RouteListResultPage
type RoutePropertiesFormat = original.RoutePropertiesFormat
type RoutesCreateOrUpdateFuture = original.RoutesCreateOrUpdateFuture
type RoutesDeleteFuture = original.RoutesDeleteFuture
type RouteTable = original.RouteTable
type RouteTableListResult = original.RouteTableListResult
type RouteTableListResultIterator = original.RouteTableListResultIterator
type RouteTableListResultPage = original.RouteTableListResultPage
type RouteTablePropertiesFormat = original.RouteTablePropertiesFormat
type RouteTablesCreateOrUpdateFuture = original.RouteTablesCreateOrUpdateFuture
type RouteTablesDeleteFuture = original.RouteTablesDeleteFuture
type RouteTablesUpdateTagsFuture = original.RouteTablesUpdateTagsFuture
type SecurityGroup = original.SecurityGroup
type SecurityGroupListResult = original.SecurityGroupListResult
type SecurityGroupListResultIterator = original.SecurityGroupListResultIterator
type SecurityGroupListResultPage = original.SecurityGroupListResultPage
type SecurityGroupNetworkInterface = original.SecurityGroupNetworkInterface
type SecurityGroupPropertiesFormat = original.SecurityGroupPropertiesFormat
type SecurityGroupsCreateOrUpdateFuture = original.SecurityGroupsCreateOrUpdateFuture
type SecurityGroupsDeleteFuture = original.SecurityGroupsDeleteFuture
type SecurityGroupsUpdateTagsFuture = original.SecurityGroupsUpdateTagsFuture
type SecurityGroupViewParameters = original.SecurityGroupViewParameters
type SecurityGroupViewResult = original.SecurityGroupViewResult
type SecurityRule = original.SecurityRule
type SecurityRuleAssociations = original.SecurityRuleAssociations
type SecurityRuleListResult = original.SecurityRuleListResult
type SecurityRuleListResultIterator = original.SecurityRuleListResultIterator
type SecurityRuleListResultPage = original.SecurityRuleListResultPage
type SecurityRulePropertiesFormat = original.SecurityRulePropertiesFormat
type SecurityRulesCreateOrUpdateFuture = original.SecurityRulesCreateOrUpdateFuture
type SecurityRulesDeleteFuture = original.SecurityRulesDeleteFuture
type ServiceEndpointPropertiesFormat = original.ServiceEndpointPropertiesFormat
type String = original.String
type Subnet = original.Subnet
type SubnetAssociation = original.SubnetAssociation
type SubnetListResult = original.SubnetListResult
type SubnetListResultIterator = original.SubnetListResultIterator
type SubnetListResultPage = original.SubnetListResultPage
type SubnetPropertiesFormat = original.SubnetPropertiesFormat
type SubnetsCreateOrUpdateFuture = original.SubnetsCreateOrUpdateFuture
type SubnetsDeleteFuture = original.SubnetsDeleteFuture
type SubResource = original.SubResource
type TagsObject = original.TagsObject
type Topology = original.Topology
type TopologyAssociation = original.TopologyAssociation
type TopologyParameters = original.TopologyParameters
type TopologyResource = original.TopologyResource
type TrafficAnalyticsConfigurationProperties = original.TrafficAnalyticsConfigurationProperties
type TrafficAnalyticsProperties = original.TrafficAnalyticsProperties
type TroubleshootingDetails = original.TroubleshootingDetails
type TroubleshootingParameters = original.TroubleshootingParameters
type TroubleshootingProperties = original.TroubleshootingProperties
type TroubleshootingRecommendedActions = original.TroubleshootingRecommendedActions
type TroubleshootingResult = original.TroubleshootingResult
type TunnelConnectionHealth = original.TunnelConnectionHealth
type Usage = original.Usage
type UsageName = original.UsageName
type UsagesListResult = original.UsagesListResult
type UsagesListResultIterator = original.UsagesListResultIterator
type UsagesListResultPage = original.UsagesListResultPage
type VerificationIPFlowParameters = original.VerificationIPFlowParameters
type VerificationIPFlowResult = original.VerificationIPFlowResult
type VirtualNetwork = original.VirtualNetwork
type VirtualNetworkConnectionGatewayReference = original.VirtualNetworkConnectionGatewayReference
type VirtualNetworkGateway = original.VirtualNetworkGateway
type VirtualNetworkGatewayConnection = original.VirtualNetworkGatewayConnection
type VirtualNetworkGatewayConnectionListEntity = original.VirtualNetworkGatewayConnectionListEntity
type VirtualNetworkGatewayConnectionListEntityPropertiesFormat = original.VirtualNetworkGatewayConnectionListEntityPropertiesFormat
type VirtualNetworkGatewayConnectionListResult = original.VirtualNetworkGatewayConnectionListResult
type VirtualNetworkGatewayConnectionListResultIterator = original.VirtualNetworkGatewayConnectionListResultIterator
type VirtualNetworkGatewayConnectionListResultPage = original.VirtualNetworkGatewayConnectionListResultPage
type VirtualNetworkGatewayConnectionPropertiesFormat = original.VirtualNetworkGatewayConnectionPropertiesFormat
type VirtualNetworkGatewayConnectionsCreateOrUpdateFuture = original.VirtualNetworkGatewayConnectionsCreateOrUpdateFuture
type VirtualNetworkGatewayConnectionsDeleteFuture = original.VirtualNetworkGatewayConnectionsDeleteFuture
type VirtualNetworkGatewayConnectionsResetSharedKeyFuture = original.VirtualNetworkGatewayConnectionsResetSharedKeyFuture
type VirtualNetworkGatewayConnectionsSetSharedKeyFuture = original.VirtualNetworkGatewayConnectionsSetSharedKeyFuture
type VirtualNetworkGatewayConnectionsUpdateTagsFuture = original.VirtualNetworkGatewayConnectionsUpdateTagsFuture
type VirtualNetworkGatewayIPConfiguration = original.VirtualNetworkGatewayIPConfiguration
type VirtualNetworkGatewayIPConfigurationPropertiesFormat = original.VirtualNetworkGatewayIPConfigurationPropertiesFormat
type VirtualNetworkGatewayListConnectionsResult = original.VirtualNetworkGatewayListConnectionsResult
type VirtualNetworkGatewayListConnectionsResultIterator = original.VirtualNetworkGatewayListConnectionsResultIterator
type VirtualNetworkGatewayListConnectionsResultPage = original.VirtualNetworkGatewayListConnectionsResultPage
type VirtualNetworkGatewayListResult = original.VirtualNetworkGatewayListResult
type VirtualNetworkGatewayListResultIterator = original.VirtualNetworkGatewayListResultIterator
type VirtualNetworkGatewayListResultPage = original.VirtualNetworkGatewayListResultPage
type VirtualNetworkGatewayPropertiesFormat = original.VirtualNetworkGatewayPropertiesFormat
type VirtualNetworkGatewaysCreateOrUpdateFuture = original.VirtualNetworkGatewaysCreateOrUpdateFuture
type VirtualNetworkGatewaysDeleteFuture = original.VirtualNetworkGatewaysDeleteFuture
type VirtualNetworkGatewaysGeneratevpnclientpackageFuture = original.VirtualNetworkGatewaysGeneratevpnclientpackageFuture
type VirtualNetworkGatewaysGenerateVpnProfileFuture = original.VirtualNetworkGatewaysGenerateVpnProfileFuture
type VirtualNetworkGatewaysGetAdvertisedRoutesFuture = original.VirtualNetworkGatewaysGetAdvertisedRoutesFuture
type VirtualNetworkGatewaysGetBgpPeerStatusFuture = original.VirtualNetworkGatewaysGetBgpPeerStatusFuture
type VirtualNetworkGatewaysGetLearnedRoutesFuture = original.VirtualNetworkGatewaysGetLearnedRoutesFuture
type VirtualNetworkGatewaysGetVpnProfilePackageURLFuture = original.VirtualNetworkGatewaysGetVpnProfilePackageURLFuture
type VirtualNetworkGatewaySku = original.VirtualNetworkGatewaySku
type VirtualNetworkGatewaysResetFuture = original.VirtualNetworkGatewaysResetFuture
type VirtualNetworkGatewaysUpdateTagsFuture = original.VirtualNetworkGatewaysUpdateTagsFuture
type VirtualNetworkListResult = original.VirtualNetworkListResult
type VirtualNetworkListResultIterator = original.VirtualNetworkListResultIterator
type VirtualNetworkListResultPage = original.VirtualNetworkListResultPage
type VirtualNetworkListUsageResult = original.VirtualNetworkListUsageResult
type VirtualNetworkListUsageResultIterator = original.VirtualNetworkListUsageResultIterator
type VirtualNetworkListUsageResultPage = original.VirtualNetworkListUsageResultPage
type VirtualNetworkPeering = original.VirtualNetworkPeering
type VirtualNetworkPeeringListResult = original.VirtualNetworkPeeringListResult
type VirtualNetworkPeeringListResultIterator = original.VirtualNetworkPeeringListResultIterator
type VirtualNetworkPeeringListResultPage = original.VirtualNetworkPeeringListResultPage
type VirtualNetworkPeeringPropertiesFormat = original.VirtualNetworkPeeringPropertiesFormat
type VirtualNetworkPeeringsCreateOrUpdateFuture = original.VirtualNetworkPeeringsCreateOrUpdateFuture
type VirtualNetworkPeeringsDeleteFuture = original.VirtualNetworkPeeringsDeleteFuture
type VirtualNetworkPropertiesFormat = original.VirtualNetworkPropertiesFormat
type VirtualNetworksCreateOrUpdateFuture = original.VirtualNetworksCreateOrUpdateFuture
type VirtualNetworksDeleteFuture = original.VirtualNetworksDeleteFuture
type VirtualNetworksUpdateTagsFuture = original.VirtualNetworksUpdateTagsFuture
type VirtualNetworkUsage = original.VirtualNetworkUsage
type VirtualNetworkUsageName = original.VirtualNetworkUsageName
type VpnClientConfiguration = original.VpnClientConfiguration
type VpnClientIPsecParameters = original.VpnClientIPsecParameters
type VpnClientParameters = original.VpnClientParameters
type VpnClientRevokedCertificate = original.VpnClientRevokedCertificate
type VpnClientRevokedCertificatePropertiesFormat = original.VpnClientRevokedCertificatePropertiesFormat
type VpnClientRootCertificate = original.VpnClientRootCertificate
type VpnClientRootCertificatePropertiesFormat = original.VpnClientRootCertificatePropertiesFormat
type VpnDeviceScriptParameters = original.VpnDeviceScriptParameters
type Watcher = original.Watcher
type WatcherListResult = original.WatcherListResult
type WatcherPropertiesFormat = original.WatcherPropertiesFormat
type WatchersCheckConnectivityFuture = original.WatchersCheckConnectivityFuture
type WatchersDeleteFuture = original.WatchersDeleteFuture
type WatchersGetAzureReachabilityReportFuture = original.WatchersGetAzureReachabilityReportFuture
type WatchersGetFlowLogStatusFuture = original.WatchersGetFlowLogStatusFuture
type WatchersGetNextHopFuture = original.WatchersGetNextHopFuture
type WatchersGetTroubleshootingFuture = original.WatchersGetTroubleshootingFuture
type WatchersGetTroubleshootingResultFuture = original.WatchersGetTroubleshootingResultFuture
type WatchersGetVMSecurityRulesFuture = original.WatchersGetVMSecurityRulesFuture
type WatchersListAvailableProvidersFuture = original.WatchersListAvailableProvidersFuture
type WatchersSetFlowLogConfigurationFuture = original.WatchersSetFlowLogConfigurationFuture
type WatchersVerifyIPFlowFuture = original.WatchersVerifyIPFlowFuture
type OperationsClient = original.OperationsClient
type PacketCapturesClient = original.PacketCapturesClient
type PublicIPAddressesClient = original.PublicIPAddressesClient
type RouteFilterRulesClient = original.RouteFilterRulesClient
type RouteFiltersClient = original.RouteFiltersClient
type RoutesClient = original.RoutesClient
type RouteTablesClient = original.RouteTablesClient
type SecurityGroupsClient = original.SecurityGroupsClient
type SecurityRulesClient = original.SecurityRulesClient
type SubnetsClient = original.SubnetsClient
type UsagesClient = original.UsagesClient
type VirtualNetworkGatewayConnectionsClient = original.VirtualNetworkGatewayConnectionsClient
type VirtualNetworkGatewaysClient = original.VirtualNetworkGatewaysClient
type VirtualNetworkPeeringsClient = original.VirtualNetworkPeeringsClient
type VirtualNetworksClient = original.VirtualNetworksClient
type WatchersClient = original.WatchersClient

func NewApplicationGatewaysClient(subscriptionID string) ApplicationGatewaysClient {
	return original.NewApplicationGatewaysClient(subscriptionID)
}
func NewApplicationGatewaysClientWithBaseURI(baseURI string, subscriptionID string) ApplicationGatewaysClient {
	return original.NewApplicationGatewaysClientWithBaseURI(baseURI, subscriptionID)
}
func NewApplicationSecurityGroupsClient(subscriptionID string) ApplicationSecurityGroupsClient {
	return original.NewApplicationSecurityGroupsClient(subscriptionID)
}
func NewApplicationSecurityGroupsClientWithBaseURI(baseURI string, subscriptionID string) ApplicationSecurityGroupsClient {
	return original.NewApplicationSecurityGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAvailableEndpointServicesClient(subscriptionID string) AvailableEndpointServicesClient {
	return original.NewAvailableEndpointServicesClient(subscriptionID)
}
func NewAvailableEndpointServicesClientWithBaseURI(baseURI string, subscriptionID string) AvailableEndpointServicesClient {
	return original.NewAvailableEndpointServicesClientWithBaseURI(baseURI, subscriptionID)
}
func NewBgpServiceCommunitiesClient(subscriptionID string) BgpServiceCommunitiesClient {
	return original.NewBgpServiceCommunitiesClient(subscriptionID)
}
func NewBgpServiceCommunitiesClientWithBaseURI(baseURI string, subscriptionID string) BgpServiceCommunitiesClient {
	return original.NewBgpServiceCommunitiesClientWithBaseURI(baseURI, subscriptionID)
}
func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func NewConnectionMonitorsClient(subscriptionID string) ConnectionMonitorsClient {
	return original.NewConnectionMonitorsClient(subscriptionID)
}
func NewConnectionMonitorsClientWithBaseURI(baseURI string, subscriptionID string) ConnectionMonitorsClient {
	return original.NewConnectionMonitorsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDdosProtectionPlansClient(subscriptionID string) DdosProtectionPlansClient {
	return original.NewDdosProtectionPlansClient(subscriptionID)
}
func NewDdosProtectionPlansClientWithBaseURI(baseURI string, subscriptionID string) DdosProtectionPlansClient {
	return original.NewDdosProtectionPlansClientWithBaseURI(baseURI, subscriptionID)
}
func NewDefaultSecurityRulesClient(subscriptionID string) DefaultSecurityRulesClient {
	return original.NewDefaultSecurityRulesClient(subscriptionID)
}
func NewDefaultSecurityRulesClientWithBaseURI(baseURI string, subscriptionID string) DefaultSecurityRulesClient {
	return original.NewDefaultSecurityRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteCircuitAuthorizationsClient(subscriptionID string) ExpressRouteCircuitAuthorizationsClient {
	return original.NewExpressRouteCircuitAuthorizationsClient(subscriptionID)
}
func NewExpressRouteCircuitAuthorizationsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteCircuitAuthorizationsClient {
	return original.NewExpressRouteCircuitAuthorizationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteCircuitConnectionsClient(subscriptionID string) ExpressRouteCircuitConnectionsClient {
	return original.NewExpressRouteCircuitConnectionsClient(subscriptionID)
}
func NewExpressRouteCircuitConnectionsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteCircuitConnectionsClient {
	return original.NewExpressRouteCircuitConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteCircuitPeeringsClient(subscriptionID string) ExpressRouteCircuitPeeringsClient {
	return original.NewExpressRouteCircuitPeeringsClient(subscriptionID)
}
func NewExpressRouteCircuitPeeringsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteCircuitPeeringsClient {
	return original.NewExpressRouteCircuitPeeringsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteCircuitsClient(subscriptionID string) ExpressRouteCircuitsClient {
	return original.NewExpressRouteCircuitsClient(subscriptionID)
}
func NewExpressRouteCircuitsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteCircuitsClient {
	return original.NewExpressRouteCircuitsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteCrossConnectionPeeringsClient(subscriptionID string) ExpressRouteCrossConnectionPeeringsClient {
	return original.NewExpressRouteCrossConnectionPeeringsClient(subscriptionID)
}
func NewExpressRouteCrossConnectionPeeringsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteCrossConnectionPeeringsClient {
	return original.NewExpressRouteCrossConnectionPeeringsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteCrossConnectionsClient(subscriptionID string) ExpressRouteCrossConnectionsClient {
	return original.NewExpressRouteCrossConnectionsClient(subscriptionID)
}
func NewExpressRouteCrossConnectionsClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteCrossConnectionsClient {
	return original.NewExpressRouteCrossConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExpressRouteServiceProvidersClient(subscriptionID string) ExpressRouteServiceProvidersClient {
	return original.NewExpressRouteServiceProvidersClient(subscriptionID)
}
func NewExpressRouteServiceProvidersClientWithBaseURI(baseURI string, subscriptionID string) ExpressRouteServiceProvidersClient {
	return original.NewExpressRouteServiceProvidersClientWithBaseURI(baseURI, subscriptionID)
}
func NewInboundNatRulesClient(subscriptionID string) InboundNatRulesClient {
	return original.NewInboundNatRulesClient(subscriptionID)
}
func NewInboundNatRulesClientWithBaseURI(baseURI string, subscriptionID string) InboundNatRulesClient {
	return original.NewInboundNatRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewInterfaceIPConfigurationsClient(subscriptionID string) InterfaceIPConfigurationsClient {
	return original.NewInterfaceIPConfigurationsClient(subscriptionID)
}
func NewInterfaceIPConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) InterfaceIPConfigurationsClient {
	return original.NewInterfaceIPConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewInterfaceLoadBalancersClient(subscriptionID string) InterfaceLoadBalancersClient {
	return original.NewInterfaceLoadBalancersClient(subscriptionID)
}
func NewInterfaceLoadBalancersClientWithBaseURI(baseURI string, subscriptionID string) InterfaceLoadBalancersClient {
	return original.NewInterfaceLoadBalancersClientWithBaseURI(baseURI, subscriptionID)
}
func NewInterfacesClient(subscriptionID string) InterfacesClient {
	return original.NewInterfacesClient(subscriptionID)
}
func NewInterfacesClientWithBaseURI(baseURI string, subscriptionID string) InterfacesClient {
	return original.NewInterfacesClientWithBaseURI(baseURI, subscriptionID)
}
func NewLoadBalancerBackendAddressPoolsClient(subscriptionID string) LoadBalancerBackendAddressPoolsClient {
	return original.NewLoadBalancerBackendAddressPoolsClient(subscriptionID)
}
func NewLoadBalancerBackendAddressPoolsClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancerBackendAddressPoolsClient {
	return original.NewLoadBalancerBackendAddressPoolsClientWithBaseURI(baseURI, subscriptionID)
}
func NewLoadBalancerFrontendIPConfigurationsClient(subscriptionID string) LoadBalancerFrontendIPConfigurationsClient {
	return original.NewLoadBalancerFrontendIPConfigurationsClient(subscriptionID)
}
func NewLoadBalancerFrontendIPConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancerFrontendIPConfigurationsClient {
	return original.NewLoadBalancerFrontendIPConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewLoadBalancerLoadBalancingRulesClient(subscriptionID string) LoadBalancerLoadBalancingRulesClient {
	return original.NewLoadBalancerLoadBalancingRulesClient(subscriptionID)
}
func NewLoadBalancerLoadBalancingRulesClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancerLoadBalancingRulesClient {
	return original.NewLoadBalancerLoadBalancingRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewLoadBalancerNetworkInterfacesClient(subscriptionID string) LoadBalancerNetworkInterfacesClient {
	return original.NewLoadBalancerNetworkInterfacesClient(subscriptionID)
}
func NewLoadBalancerNetworkInterfacesClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancerNetworkInterfacesClient {
	return original.NewLoadBalancerNetworkInterfacesClientWithBaseURI(baseURI, subscriptionID)
}
func NewLoadBalancerProbesClient(subscriptionID string) LoadBalancerProbesClient {
	return original.NewLoadBalancerProbesClient(subscriptionID)
}
func NewLoadBalancerProbesClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancerProbesClient {
	return original.NewLoadBalancerProbesClientWithBaseURI(baseURI, subscriptionID)
}
func NewLoadBalancersClient(subscriptionID string) LoadBalancersClient {
	return original.NewLoadBalancersClient(subscriptionID)
}
func NewLoadBalancersClientWithBaseURI(baseURI string, subscriptionID string) LoadBalancersClient {
	return original.NewLoadBalancersClientWithBaseURI(baseURI, subscriptionID)
}
func NewLocalNetworkGatewaysClient(subscriptionID string) LocalNetworkGatewaysClient {
	return original.NewLocalNetworkGatewaysClient(subscriptionID)
}
func NewLocalNetworkGatewaysClientWithBaseURI(baseURI string, subscriptionID string) LocalNetworkGatewaysClient {
	return original.NewLocalNetworkGatewaysClientWithBaseURI(baseURI, subscriptionID)
}
func PossibleAccessValues() []Access {
	return original.PossibleAccessValues()
}
func PossibleApplicationGatewayBackendHealthServerHealthValues() []ApplicationGatewayBackendHealthServerHealth {
	return original.PossibleApplicationGatewayBackendHealthServerHealthValues()
}
func PossibleApplicationGatewayCookieBasedAffinityValues() []ApplicationGatewayCookieBasedAffinity {
	return original.PossibleApplicationGatewayCookieBasedAffinityValues()
}
func PossibleApplicationGatewayFirewallModeValues() []ApplicationGatewayFirewallMode {
	return original.PossibleApplicationGatewayFirewallModeValues()
}
func PossibleApplicationGatewayOperationalStateValues() []ApplicationGatewayOperationalState {
	return original.PossibleApplicationGatewayOperationalStateValues()
}
func PossibleApplicationGatewayProtocolValues() []ApplicationGatewayProtocol {
	return original.PossibleApplicationGatewayProtocolValues()
}
func PossibleApplicationGatewayRedirectTypeValues() []ApplicationGatewayRedirectType {
	return original.PossibleApplicationGatewayRedirectTypeValues()
}
func PossibleApplicationGatewayRequestRoutingRuleTypeValues() []ApplicationGatewayRequestRoutingRuleType {
	return original.PossibleApplicationGatewayRequestRoutingRuleTypeValues()
}
func PossibleApplicationGatewaySkuNameValues() []ApplicationGatewaySkuName {
	return original.PossibleApplicationGatewaySkuNameValues()
}
func PossibleApplicationGatewaySslCipherSuiteValues() []ApplicationGatewaySslCipherSuite {
	return original.PossibleApplicationGatewaySslCipherSuiteValues()
}
func PossibleApplicationGatewaySslPolicyNameValues() []ApplicationGatewaySslPolicyName {
	return original.PossibleApplicationGatewaySslPolicyNameValues()
}
func PossibleApplicationGatewaySslPolicyTypeValues() []ApplicationGatewaySslPolicyType {
	return original.PossibleApplicationGatewaySslPolicyTypeValues()
}
func PossibleApplicationGatewaySslProtocolValues() []ApplicationGatewaySslProtocol {
	return original.PossibleApplicationGatewaySslProtocolValues()
}
func PossibleApplicationGatewayTierValues() []ApplicationGatewayTier {
	return original.PossibleApplicationGatewayTierValues()
}
func PossibleAssociationTypeValues() []AssociationType {
	return original.PossibleAssociationTypeValues()
}
func PossibleAuthenticationMethodValues() []AuthenticationMethod {
	return original.PossibleAuthenticationMethodValues()
}
func PossibleAuthorizationUseStatusValues() []AuthorizationUseStatus {
	return original.PossibleAuthorizationUseStatusValues()
}
func PossibleBgpPeerStateValues() []BgpPeerState {
	return original.PossibleBgpPeerStateValues()
}
func PossibleCircuitConnectionStatusValues() []CircuitConnectionStatus {
	return original.PossibleCircuitConnectionStatusValues()
}
func PossibleConnectionMonitorSourceStatusValues() []ConnectionMonitorSourceStatus {
	return original.PossibleConnectionMonitorSourceStatusValues()
}
func PossibleConnectionStateValues() []ConnectionState {
	return original.PossibleConnectionStateValues()
}
func PossibleConnectionStatusValues() []ConnectionStatus {
	return original.PossibleConnectionStatusValues()
}
func PossibleDhGroupValues() []DhGroup {
	return original.PossibleDhGroupValues()
}
func PossibleDirectionValues() []Direction {
	return original.PossibleDirectionValues()
}
func PossibleEffectiveRouteSourceValues() []EffectiveRouteSource {
	return original.PossibleEffectiveRouteSourceValues()
}
func PossibleEffectiveRouteStateValues() []EffectiveRouteState {
	return original.PossibleEffectiveRouteStateValues()
}
func PossibleEffectiveSecurityRuleProtocolValues() []EffectiveSecurityRuleProtocol {
	return original.PossibleEffectiveSecurityRuleProtocolValues()
}
func PossibleEvaluationStateValues() []EvaluationState {
	return original.PossibleEvaluationStateValues()
}
func PossibleExpressRouteCircuitPeeringAdvertisedPublicPrefixStateValues() []ExpressRouteCircuitPeeringAdvertisedPublicPrefixState {
	return original.PossibleExpressRouteCircuitPeeringAdvertisedPublicPrefixStateValues()
}
func PossibleExpressRouteCircuitPeeringStateValues() []ExpressRouteCircuitPeeringState {
	return original.PossibleExpressRouteCircuitPeeringStateValues()
}
func PossibleExpressRouteCircuitSkuFamilyValues() []ExpressRouteCircuitSkuFamily {
	return original.PossibleExpressRouteCircuitSkuFamilyValues()
}
func PossibleExpressRouteCircuitSkuTierValues() []ExpressRouteCircuitSkuTier {
	return original.PossibleExpressRouteCircuitSkuTierValues()
}
func PossibleExpressRoutePeeringStateValues() []ExpressRoutePeeringState {
	return original.PossibleExpressRoutePeeringStateValues()
}
func PossibleExpressRoutePeeringTypeValues() []ExpressRoutePeeringType {
	return original.PossibleExpressRoutePeeringTypeValues()
}
func PossibleHTTPMethodValues() []HTTPMethod {
	return original.PossibleHTTPMethodValues()
}
func PossibleIkeEncryptionValues() []IkeEncryption {
	return original.PossibleIkeEncryptionValues()
}
func PossibleIkeIntegrityValues() []IkeIntegrity {
	return original.PossibleIkeIntegrityValues()
}
func PossibleIPAllocationMethodValues() []IPAllocationMethod {
	return original.PossibleIPAllocationMethodValues()
}
func PossibleIPFlowProtocolValues() []IPFlowProtocol {
	return original.PossibleIPFlowProtocolValues()
}
func PossibleIpsecEncryptionValues() []IpsecEncryption {
	return original.PossibleIpsecEncryptionValues()
}
func PossibleIpsecIntegrityValues() []IpsecIntegrity {
	return original.PossibleIpsecIntegrityValues()
}
func PossibleIPVersionValues() []IPVersion {
	return original.PossibleIPVersionValues()
}
func PossibleIssueTypeValues() []IssueType {
	return original.PossibleIssueTypeValues()
}
func PossibleLoadBalancerSkuNameValues() []LoadBalancerSkuName {
	return original.PossibleLoadBalancerSkuNameValues()
}
func PossibleLoadDistributionValues() []LoadDistribution {
	return original.PossibleLoadDistributionValues()
}
func PossibleNextHopTypeValues() []NextHopType {
	return original.PossibleNextHopTypeValues()
}
func PossibleOperationStatusValues() []OperationStatus {
	return original.PossibleOperationStatusValues()
}
func PossibleOriginValues() []Origin {
	return original.PossibleOriginValues()
}
func PossiblePcErrorValues() []PcError {
	return original.PossiblePcErrorValues()
}
func PossiblePcProtocolValues() []PcProtocol {
	return original.PossiblePcProtocolValues()
}
func PossiblePcStatusValues() []PcStatus {
	return original.PossiblePcStatusValues()
}
func PossiblePfsGroupValues() []PfsGroup {
	return original.PossiblePfsGroupValues()
}
func PossibleProbeProtocolValues() []ProbeProtocol {
	return original.PossibleProbeProtocolValues()
}
func PossibleProcessorArchitectureValues() []ProcessorArchitecture {
	return original.PossibleProcessorArchitectureValues()
}
func PossibleProtocolValues() []Protocol {
	return original.PossibleProtocolValues()
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func PossiblePublicIPAddressSkuNameValues() []PublicIPAddressSkuName {
	return original.PossiblePublicIPAddressSkuNameValues()
}
func PossibleRouteNextHopTypeValues() []RouteNextHopType {
	return original.PossibleRouteNextHopTypeValues()
}
func PossibleSecurityRuleAccessValues() []SecurityRuleAccess {
	return original.PossibleSecurityRuleAccessValues()
}
func PossibleSecurityRuleDirectionValues() []SecurityRuleDirection {
	return original.PossibleSecurityRuleDirectionValues()
}
func PossibleSecurityRuleProtocolValues() []SecurityRuleProtocol {
	return original.PossibleSecurityRuleProtocolValues()
}
func PossibleServiceProviderProvisioningStateValues() []ServiceProviderProvisioningState {
	return original.PossibleServiceProviderProvisioningStateValues()
}
func PossibleSeverityValues() []Severity {
	return original.PossibleSeverityValues()
}
func PossibleTransportProtocolValues() []TransportProtocol {
	return original.PossibleTransportProtocolValues()
}
func PossibleVirtualNetworkGatewayConnectionStatusValues() []VirtualNetworkGatewayConnectionStatus {
	return original.PossibleVirtualNetworkGatewayConnectionStatusValues()
}
func PossibleVirtualNetworkGatewayConnectionTypeValues() []VirtualNetworkGatewayConnectionType {
	return original.PossibleVirtualNetworkGatewayConnectionTypeValues()
}
func PossibleVirtualNetworkGatewaySkuNameValues() []VirtualNetworkGatewaySkuName {
	return original.PossibleVirtualNetworkGatewaySkuNameValues()
}
func PossibleVirtualNetworkGatewaySkuTierValues() []VirtualNetworkGatewaySkuTier {
	return original.PossibleVirtualNetworkGatewaySkuTierValues()
}
func PossibleVirtualNetworkGatewayTypeValues() []VirtualNetworkGatewayType {
	return original.PossibleVirtualNetworkGatewayTypeValues()
}
func PossibleVirtualNetworkPeeringStateValues() []VirtualNetworkPeeringState {
	return original.PossibleVirtualNetworkPeeringStateValues()
}
func PossibleVpnClientProtocolValues() []VpnClientProtocol {
	return original.PossibleVpnClientProtocolValues()
}
func PossibleVpnTypeValues() []VpnType {
	return original.PossibleVpnTypeValues()
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPacketCapturesClient(subscriptionID string) PacketCapturesClient {
	return original.NewPacketCapturesClient(subscriptionID)
}
func NewPacketCapturesClientWithBaseURI(baseURI string, subscriptionID string) PacketCapturesClient {
	return original.NewPacketCapturesClientWithBaseURI(baseURI, subscriptionID)
}
func NewPublicIPAddressesClient(subscriptionID string) PublicIPAddressesClient {
	return original.NewPublicIPAddressesClient(subscriptionID)
}
func NewPublicIPAddressesClientWithBaseURI(baseURI string, subscriptionID string) PublicIPAddressesClient {
	return original.NewPublicIPAddressesClientWithBaseURI(baseURI, subscriptionID)
}
func NewRouteFilterRulesClient(subscriptionID string) RouteFilterRulesClient {
	return original.NewRouteFilterRulesClient(subscriptionID)
}
func NewRouteFilterRulesClientWithBaseURI(baseURI string, subscriptionID string) RouteFilterRulesClient {
	return original.NewRouteFilterRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewRouteFiltersClient(subscriptionID string) RouteFiltersClient {
	return original.NewRouteFiltersClient(subscriptionID)
}
func NewRouteFiltersClientWithBaseURI(baseURI string, subscriptionID string) RouteFiltersClient {
	return original.NewRouteFiltersClientWithBaseURI(baseURI, subscriptionID)
}
func NewRoutesClient(subscriptionID string) RoutesClient {
	return original.NewRoutesClient(subscriptionID)
}
func NewRoutesClientWithBaseURI(baseURI string, subscriptionID string) RoutesClient {
	return original.NewRoutesClientWithBaseURI(baseURI, subscriptionID)
}
func NewRouteTablesClient(subscriptionID string) RouteTablesClient {
	return original.NewRouteTablesClient(subscriptionID)
}
func NewRouteTablesClientWithBaseURI(baseURI string, subscriptionID string) RouteTablesClient {
	return original.NewRouteTablesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSecurityGroupsClient(subscriptionID string) SecurityGroupsClient {
	return original.NewSecurityGroupsClient(subscriptionID)
}
func NewSecurityGroupsClientWithBaseURI(baseURI string, subscriptionID string) SecurityGroupsClient {
	return original.NewSecurityGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSecurityRulesClient(subscriptionID string) SecurityRulesClient {
	return original.NewSecurityRulesClient(subscriptionID)
}
func NewSecurityRulesClientWithBaseURI(baseURI string, subscriptionID string) SecurityRulesClient {
	return original.NewSecurityRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSubnetsClient(subscriptionID string) SubnetsClient {
	return original.NewSubnetsClient(subscriptionID)
}
func NewSubnetsClientWithBaseURI(baseURI string, subscriptionID string) SubnetsClient {
	return original.NewSubnetsClientWithBaseURI(baseURI, subscriptionID)
}
func NewUsagesClient(subscriptionID string) UsagesClient {
	return original.NewUsagesClient(subscriptionID)
}
func NewUsagesClientWithBaseURI(baseURI string, subscriptionID string) UsagesClient {
	return original.NewUsagesClientWithBaseURI(baseURI, subscriptionID)
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
func NewVirtualNetworkGatewayConnectionsClient(subscriptionID string) VirtualNetworkGatewayConnectionsClient {
	return original.NewVirtualNetworkGatewayConnectionsClient(subscriptionID)
}
func NewVirtualNetworkGatewayConnectionsClientWithBaseURI(baseURI string, subscriptionID string) VirtualNetworkGatewayConnectionsClient {
	return original.NewVirtualNetworkGatewayConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualNetworkGatewaysClient(subscriptionID string) VirtualNetworkGatewaysClient {
	return original.NewVirtualNetworkGatewaysClient(subscriptionID)
}
func NewVirtualNetworkGatewaysClientWithBaseURI(baseURI string, subscriptionID string) VirtualNetworkGatewaysClient {
	return original.NewVirtualNetworkGatewaysClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualNetworkPeeringsClient(subscriptionID string) VirtualNetworkPeeringsClient {
	return original.NewVirtualNetworkPeeringsClient(subscriptionID)
}
func NewVirtualNetworkPeeringsClientWithBaseURI(baseURI string, subscriptionID string) VirtualNetworkPeeringsClient {
	return original.NewVirtualNetworkPeeringsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualNetworksClient(subscriptionID string) VirtualNetworksClient {
	return original.NewVirtualNetworksClient(subscriptionID)
}
func NewVirtualNetworksClientWithBaseURI(baseURI string, subscriptionID string) VirtualNetworksClient {
	return original.NewVirtualNetworksClientWithBaseURI(baseURI, subscriptionID)
}
func NewWatchersClient(subscriptionID string) WatchersClient {
	return original.NewWatchersClient(subscriptionID)
}
func NewWatchersClientWithBaseURI(baseURI string, subscriptionID string) WatchersClient {
	return original.NewWatchersClientWithBaseURI(baseURI, subscriptionID)
}
