// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/sql/v1/cloud_sql_ssl_certs.proto

package sql

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type SqlSslCertsDeleteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	// Sha1 FingerPrint.
	Sha1Fingerprint string `protobuf:"bytes,3,opt,name=sha1_fingerprint,json=sha1Fingerprint,proto3" json:"sha1_fingerprint,omitempty"`
}

func (x *SqlSslCertsDeleteRequest) Reset() {
	*x = SqlSslCertsDeleteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlSslCertsDeleteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlSslCertsDeleteRequest) ProtoMessage() {}

func (x *SqlSslCertsDeleteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlSslCertsDeleteRequest.ProtoReflect.Descriptor instead.
func (*SqlSslCertsDeleteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_rawDescGZIP(), []int{0}
}

func (x *SqlSslCertsDeleteRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlSslCertsDeleteRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlSslCertsDeleteRequest) GetSha1Fingerprint() string {
	if x != nil {
		return x.Sha1Fingerprint
	}
	return ""
}

type SqlSslCertsGetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	// Sha1 FingerPrint.
	Sha1Fingerprint string `protobuf:"bytes,3,opt,name=sha1_fingerprint,json=sha1Fingerprint,proto3" json:"sha1_fingerprint,omitempty"`
}

func (x *SqlSslCertsGetRequest) Reset() {
	*x = SqlSslCertsGetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlSslCertsGetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlSslCertsGetRequest) ProtoMessage() {}

func (x *SqlSslCertsGetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlSslCertsGetRequest.ProtoReflect.Descriptor instead.
func (*SqlSslCertsGetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_rawDescGZIP(), []int{1}
}

func (x *SqlSslCertsGetRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlSslCertsGetRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlSslCertsGetRequest) GetSha1Fingerprint() string {
	if x != nil {
		return x.Sha1Fingerprint
	}
	return ""
}

type SqlSslCertsInsertRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string                 `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *SslCertsInsertRequest `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlSslCertsInsertRequest) Reset() {
	*x = SqlSslCertsInsertRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlSslCertsInsertRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlSslCertsInsertRequest) ProtoMessage() {}

func (x *SqlSslCertsInsertRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlSslCertsInsertRequest.ProtoReflect.Descriptor instead.
func (*SqlSslCertsInsertRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_rawDescGZIP(), []int{2}
}

func (x *SqlSslCertsInsertRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlSslCertsInsertRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlSslCertsInsertRequest) GetBody() *SslCertsInsertRequest {
	if x != nil {
		return x.Body
	}
	return nil
}

type SqlSslCertsListRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlSslCertsListRequest) Reset() {
	*x = SqlSslCertsListRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlSslCertsListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlSslCertsListRequest) ProtoMessage() {}

func (x *SqlSslCertsListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlSslCertsListRequest.ProtoReflect.Descriptor instead.
func (*SqlSslCertsListRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_rawDescGZIP(), []int{3}
}

func (x *SqlSslCertsListRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlSslCertsListRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

// SslCerts insert request.
type SslCertsInsertRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// User supplied name.  Must be a distinct name from the other certificates
	// for this instance.
	CommonName string `protobuf:"bytes,1,opt,name=common_name,json=commonName,proto3" json:"common_name,omitempty"`
}

func (x *SslCertsInsertRequest) Reset() {
	*x = SslCertsInsertRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SslCertsInsertRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SslCertsInsertRequest) ProtoMessage() {}

func (x *SslCertsInsertRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SslCertsInsertRequest.ProtoReflect.Descriptor instead.
func (*SslCertsInsertRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_rawDescGZIP(), []int{4}
}

func (x *SslCertsInsertRequest) GetCommonName() string {
	if x != nil {
		return x.CommonName
	}
	return ""
}

// SslCert insert response.
type SslCertsInsertResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always **sql#sslCertsInsert**.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The operation to track the ssl certs insert request.
	Operation *Operation `protobuf:"bytes,2,opt,name=operation,proto3" json:"operation,omitempty"`
	// The server Certificate Authority's certificate.  If this is missing you can
	// force a new one to be generated by calling resetSslConfig method on
	// instances resource.
	ServerCaCert *SslCert `protobuf:"bytes,3,opt,name=server_ca_cert,json=serverCaCert,proto3" json:"server_ca_cert,omitempty"`
	// The new client certificate and private key.
	ClientCert *SslCertDetail `protobuf:"bytes,4,opt,name=client_cert,json=clientCert,proto3" json:"client_cert,omitempty"`
}

func (x *SslCertsInsertResponse) Reset() {
	*x = SslCertsInsertResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SslCertsInsertResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SslCertsInsertResponse) ProtoMessage() {}

func (x *SslCertsInsertResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SslCertsInsertResponse.ProtoReflect.Descriptor instead.
func (*SslCertsInsertResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_rawDescGZIP(), []int{5}
}

func (x *SslCertsInsertResponse) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *SslCertsInsertResponse) GetOperation() *Operation {
	if x != nil {
		return x.Operation
	}
	return nil
}

func (x *SslCertsInsertResponse) GetServerCaCert() *SslCert {
	if x != nil {
		return x.ServerCaCert
	}
	return nil
}

func (x *SslCertsInsertResponse) GetClientCert() *SslCertDetail {
	if x != nil {
		return x.ClientCert
	}
	return nil
}

// SslCerts list response.
type SslCertsListResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always **sql#sslCertsList**.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// List of client certificates for the instance.
	Items []*SslCert `protobuf:"bytes,2,rep,name=items,proto3" json:"items,omitempty"`
}

func (x *SslCertsListResponse) Reset() {
	*x = SslCertsListResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SslCertsListResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SslCertsListResponse) ProtoMessage() {}

func (x *SslCertsListResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SslCertsListResponse.ProtoReflect.Descriptor instead.
func (*SslCertsListResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_rawDescGZIP(), []int{6}
}

func (x *SslCertsListResponse) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *SslCertsListResponse) GetItems() []*SslCert {
	if x != nil {
		return x.Items
	}
	return nil
}

var File_google_cloud_sql_v1_cloud_sql_ssl_certs_proto protoreflect.FileDescriptor

var file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x71, 0x6c, 0x5f,
	0x73, 0x73, 0x6c, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x71,
	0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x7b, 0x0a, 0x18, 0x53, 0x71,
	0x6c, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x29, 0x0a, 0x10,
	0x73, 0x68, 0x61, 0x31, 0x5f, 0x66, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x68, 0x61, 0x31, 0x46, 0x69, 0x6e, 0x67,
	0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x22, 0x78, 0x0a, 0x15, 0x53, 0x71, 0x6c, 0x53, 0x73,
	0x6c, 0x43, 0x65, 0x72, 0x74, 0x73, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x73, 0x68, 0x61, 0x31, 0x5f, 0x66,
	0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0f, 0x73, 0x68, 0x61, 0x31, 0x46, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e,
	0x74, 0x22, 0x90, 0x01, 0x0a, 0x18, 0x53, 0x71, 0x6c, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74,
	0x73, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a,
	0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x64, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74,
	0x73, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x04,
	0x62, 0x6f, 0x64, 0x79, 0x22, 0x4e, 0x0a, 0x16, 0x53, 0x71, 0x6c, 0x53, 0x73, 0x6c, 0x43, 0x65,
	0x72, 0x74, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a,
	0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x22, 0x38, 0x0a, 0x15, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x73,
	0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a,
	0x0b, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xf3,
	0x01, 0x0a, 0x16, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x73, 0x49, 0x6e, 0x73, 0x65, 0x72,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x3c, 0x0a,
	0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x0e, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72,
	0x74, 0x52, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x43, 0x65, 0x72, 0x74, 0x12,
	0x43, 0x0a, 0x0b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x73, 0x6c, 0x43, 0x65,
	0x72, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x43, 0x65, 0x72, 0x74, 0x22, 0x5e, 0x0a, 0x14, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x73,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64,
	0x12, 0x32, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x52, 0x05, 0x69,
	0x74, 0x65, 0x6d, 0x73, 0x32, 0xaa, 0x06, 0x0a, 0x12, 0x53, 0x71, 0x6c, 0x53, 0x73, 0x6c, 0x43,
	0x65, 0x72, 0x74, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xa8, 0x01, 0x0a, 0x06,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c,
	0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x2a, 0x47, 0x2f,
	0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f,
	0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x73, 0x73, 0x6c, 0x43, 0x65,
	0x72, 0x74, 0x73, 0x2f, 0x7b, 0x73, 0x68, 0x61, 0x31, 0x5f, 0x66, 0x69, 0x6e, 0x67, 0x65, 0x72,
	0x70, 0x72, 0x69, 0x6e, 0x74, 0x7d, 0x12, 0xa0, 0x01, 0x0a, 0x03, 0x47, 0x65, 0x74, 0x12, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x73,
	0x47, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x22, 0x4f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49,
	0x12, 0x47, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x73, 0x73,
	0x6c, 0x43, 0x65, 0x72, 0x74, 0x73, 0x2f, 0x7b, 0x73, 0x68, 0x61, 0x31, 0x5f, 0x66, 0x69, 0x6e,
	0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x7d, 0x12, 0xa8, 0x01, 0x0a, 0x06, 0x49, 0x6e,
	0x73, 0x65, 0x72, 0x74, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x53, 0x73,
	0x6c, 0x43, 0x65, 0x72, 0x74, 0x73, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72,
	0x74, 0x73, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x22, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x73, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x73, 0x3a, 0x04,
	0x62, 0x6f, 0x64, 0x79, 0x12, 0x9c, 0x01, 0x0a, 0x04, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x73, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x12, 0x34, 0x2f,
	0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f,
	0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x73, 0x73, 0x6c, 0x43, 0x65,
	0x72, 0x74, 0x73, 0x1a, 0x7c, 0xca, 0x41, 0x17, 0x73, 0x71, 0x6c, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x73, 0x71, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x42, 0x6a, 0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x42, 0x15, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x73, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x3b, 0x73, 0x71, 0x6c, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_rawDescOnce sync.Once
	file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_rawDescData = file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_rawDesc
)

func file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_rawDescGZIP() []byte {
	file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_rawDescOnce.Do(func() {
		file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_rawDescData)
	})
	return file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_rawDescData
}

var file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_goTypes = []interface{}{
	(*SqlSslCertsDeleteRequest)(nil), // 0: google.cloud.sql.v1.SqlSslCertsDeleteRequest
	(*SqlSslCertsGetRequest)(nil),    // 1: google.cloud.sql.v1.SqlSslCertsGetRequest
	(*SqlSslCertsInsertRequest)(nil), // 2: google.cloud.sql.v1.SqlSslCertsInsertRequest
	(*SqlSslCertsListRequest)(nil),   // 3: google.cloud.sql.v1.SqlSslCertsListRequest
	(*SslCertsInsertRequest)(nil),    // 4: google.cloud.sql.v1.SslCertsInsertRequest
	(*SslCertsInsertResponse)(nil),   // 5: google.cloud.sql.v1.SslCertsInsertResponse
	(*SslCertsListResponse)(nil),     // 6: google.cloud.sql.v1.SslCertsListResponse
	(*Operation)(nil),                // 7: google.cloud.sql.v1.Operation
	(*SslCert)(nil),                  // 8: google.cloud.sql.v1.SslCert
	(*SslCertDetail)(nil),            // 9: google.cloud.sql.v1.SslCertDetail
}
var file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_depIdxs = []int32{
	4, // 0: google.cloud.sql.v1.SqlSslCertsInsertRequest.body:type_name -> google.cloud.sql.v1.SslCertsInsertRequest
	7, // 1: google.cloud.sql.v1.SslCertsInsertResponse.operation:type_name -> google.cloud.sql.v1.Operation
	8, // 2: google.cloud.sql.v1.SslCertsInsertResponse.server_ca_cert:type_name -> google.cloud.sql.v1.SslCert
	9, // 3: google.cloud.sql.v1.SslCertsInsertResponse.client_cert:type_name -> google.cloud.sql.v1.SslCertDetail
	8, // 4: google.cloud.sql.v1.SslCertsListResponse.items:type_name -> google.cloud.sql.v1.SslCert
	0, // 5: google.cloud.sql.v1.SqlSslCertsService.Delete:input_type -> google.cloud.sql.v1.SqlSslCertsDeleteRequest
	1, // 6: google.cloud.sql.v1.SqlSslCertsService.Get:input_type -> google.cloud.sql.v1.SqlSslCertsGetRequest
	2, // 7: google.cloud.sql.v1.SqlSslCertsService.Insert:input_type -> google.cloud.sql.v1.SqlSslCertsInsertRequest
	3, // 8: google.cloud.sql.v1.SqlSslCertsService.List:input_type -> google.cloud.sql.v1.SqlSslCertsListRequest
	7, // 9: google.cloud.sql.v1.SqlSslCertsService.Delete:output_type -> google.cloud.sql.v1.Operation
	8, // 10: google.cloud.sql.v1.SqlSslCertsService.Get:output_type -> google.cloud.sql.v1.SslCert
	5, // 11: google.cloud.sql.v1.SqlSslCertsService.Insert:output_type -> google.cloud.sql.v1.SslCertsInsertResponse
	6, // 12: google.cloud.sql.v1.SqlSslCertsService.List:output_type -> google.cloud.sql.v1.SslCertsListResponse
	9, // [9:13] is the sub-list for method output_type
	5, // [5:9] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_init() }
func file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_init() {
	if File_google_cloud_sql_v1_cloud_sql_ssl_certs_proto != nil {
		return
	}
	file_google_cloud_sql_v1_cloud_sql_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlSslCertsDeleteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlSslCertsGetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlSslCertsInsertRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlSslCertsListRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SslCertsInsertRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SslCertsInsertResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SslCertsListResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_goTypes,
		DependencyIndexes: file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_depIdxs,
		MessageInfos:      file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_msgTypes,
	}.Build()
	File_google_cloud_sql_v1_cloud_sql_ssl_certs_proto = out.File
	file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_rawDesc = nil
	file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_goTypes = nil
	file_google_cloud_sql_v1_cloud_sql_ssl_certs_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SqlSslCertsServiceClient is the client API for SqlSslCertsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SqlSslCertsServiceClient interface {
	// Deletes the SSL certificate. For First Generation instances, the
	// certificate remains valid until the instance is restarted.
	Delete(ctx context.Context, in *SqlSslCertsDeleteRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves a particular SSL certificate.  Does not include the private key
	// (required for usage).  The private key must be saved from the response to
	// initial creation.
	Get(ctx context.Context, in *SqlSslCertsGetRequest, opts ...grpc.CallOption) (*SslCert, error)
	// Creates an SSL certificate and returns it along with the private key and
	// server certificate authority.  The new certificate will not be usable until
	// the instance is restarted.
	Insert(ctx context.Context, in *SqlSslCertsInsertRequest, opts ...grpc.CallOption) (*SslCertsInsertResponse, error)
	// Lists all of the current SSL certificates for the instance.
	List(ctx context.Context, in *SqlSslCertsListRequest, opts ...grpc.CallOption) (*SslCertsListResponse, error)
}

type sqlSslCertsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSqlSslCertsServiceClient(cc grpc.ClientConnInterface) SqlSslCertsServiceClient {
	return &sqlSslCertsServiceClient{cc}
}

func (c *sqlSslCertsServiceClient) Delete(ctx context.Context, in *SqlSslCertsDeleteRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlSslCertsService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlSslCertsServiceClient) Get(ctx context.Context, in *SqlSslCertsGetRequest, opts ...grpc.CallOption) (*SslCert, error) {
	out := new(SslCert)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlSslCertsService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlSslCertsServiceClient) Insert(ctx context.Context, in *SqlSslCertsInsertRequest, opts ...grpc.CallOption) (*SslCertsInsertResponse, error) {
	out := new(SslCertsInsertResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlSslCertsService/Insert", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlSslCertsServiceClient) List(ctx context.Context, in *SqlSslCertsListRequest, opts ...grpc.CallOption) (*SslCertsListResponse, error) {
	out := new(SslCertsListResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlSslCertsService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SqlSslCertsServiceServer is the server API for SqlSslCertsService service.
type SqlSslCertsServiceServer interface {
	// Deletes the SSL certificate. For First Generation instances, the
	// certificate remains valid until the instance is restarted.
	Delete(context.Context, *SqlSslCertsDeleteRequest) (*Operation, error)
	// Retrieves a particular SSL certificate.  Does not include the private key
	// (required for usage).  The private key must be saved from the response to
	// initial creation.
	Get(context.Context, *SqlSslCertsGetRequest) (*SslCert, error)
	// Creates an SSL certificate and returns it along with the private key and
	// server certificate authority.  The new certificate will not be usable until
	// the instance is restarted.
	Insert(context.Context, *SqlSslCertsInsertRequest) (*SslCertsInsertResponse, error)
	// Lists all of the current SSL certificates for the instance.
	List(context.Context, *SqlSslCertsListRequest) (*SslCertsListResponse, error)
}

// UnimplementedSqlSslCertsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSqlSslCertsServiceServer struct {
}

func (*UnimplementedSqlSslCertsServiceServer) Delete(context.Context, *SqlSslCertsDeleteRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedSqlSslCertsServiceServer) Get(context.Context, *SqlSslCertsGetRequest) (*SslCert, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedSqlSslCertsServiceServer) Insert(context.Context, *SqlSslCertsInsertRequest) (*SslCertsInsertResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (*UnimplementedSqlSslCertsServiceServer) List(context.Context, *SqlSslCertsListRequest) (*SslCertsListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}

func RegisterSqlSslCertsServiceServer(s *grpc.Server, srv SqlSslCertsServiceServer) {
	s.RegisterService(&_SqlSslCertsService_serviceDesc, srv)
}

func _SqlSslCertsService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlSslCertsDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlSslCertsServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlSslCertsService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlSslCertsServiceServer).Delete(ctx, req.(*SqlSslCertsDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlSslCertsService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlSslCertsGetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlSslCertsServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlSslCertsService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlSslCertsServiceServer).Get(ctx, req.(*SqlSslCertsGetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlSslCertsService_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlSslCertsInsertRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlSslCertsServiceServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlSslCertsService/Insert",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlSslCertsServiceServer).Insert(ctx, req.(*SqlSslCertsInsertRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlSslCertsService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlSslCertsListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlSslCertsServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlSslCertsService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlSslCertsServiceServer).List(ctx, req.(*SqlSslCertsListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SqlSslCertsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.sql.v1.SqlSslCertsService",
	HandlerType: (*SqlSslCertsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Delete",
			Handler:    _SqlSslCertsService_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _SqlSslCertsService_Get_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _SqlSslCertsService_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _SqlSslCertsService_List_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/sql/v1/cloud_sql_ssl_certs.proto",
}
