// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v2/services/ad_group_label_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v2/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [AdGroupLabelService.GetAdGroupLabel][google.ads.googleads.v2.services.AdGroupLabelService.GetAdGroupLabel].
type GetAdGroupLabelRequest struct {
	// The resource name of the ad group label to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAdGroupLabelRequest) Reset()         { *m = GetAdGroupLabelRequest{} }
func (m *GetAdGroupLabelRequest) String() string { return proto.CompactTextString(m) }
func (*GetAdGroupLabelRequest) ProtoMessage()    {}
func (*GetAdGroupLabelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8693fa91b2cc8640, []int{0}
}

func (m *GetAdGroupLabelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAdGroupLabelRequest.Unmarshal(m, b)
}
func (m *GetAdGroupLabelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAdGroupLabelRequest.Marshal(b, m, deterministic)
}
func (m *GetAdGroupLabelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAdGroupLabelRequest.Merge(m, src)
}
func (m *GetAdGroupLabelRequest) XXX_Size() int {
	return xxx_messageInfo_GetAdGroupLabelRequest.Size(m)
}
func (m *GetAdGroupLabelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAdGroupLabelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAdGroupLabelRequest proto.InternalMessageInfo

func (m *GetAdGroupLabelRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [AdGroupLabelService.MutateAdGroupLabels][google.ads.googleads.v2.services.AdGroupLabelService.MutateAdGroupLabels].
type MutateAdGroupLabelsRequest struct {
	// ID of the customer whose ad group labels are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The list of operations to perform on ad group labels.
	Operations []*AdGroupLabelOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, all operations will be carried
	// out in one transaction if and only if they are all valid.
	// Default is false.
	PartialFailure bool `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly         bool     `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateAdGroupLabelsRequest) Reset()         { *m = MutateAdGroupLabelsRequest{} }
func (m *MutateAdGroupLabelsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateAdGroupLabelsRequest) ProtoMessage()    {}
func (*MutateAdGroupLabelsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8693fa91b2cc8640, []int{1}
}

func (m *MutateAdGroupLabelsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdGroupLabelsRequest.Unmarshal(m, b)
}
func (m *MutateAdGroupLabelsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdGroupLabelsRequest.Marshal(b, m, deterministic)
}
func (m *MutateAdGroupLabelsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdGroupLabelsRequest.Merge(m, src)
}
func (m *MutateAdGroupLabelsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateAdGroupLabelsRequest.Size(m)
}
func (m *MutateAdGroupLabelsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdGroupLabelsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdGroupLabelsRequest proto.InternalMessageInfo

func (m *MutateAdGroupLabelsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateAdGroupLabelsRequest) GetOperations() []*AdGroupLabelOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *MutateAdGroupLabelsRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

func (m *MutateAdGroupLabelsRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// A single operation (create, remove) on an ad group label.
type AdGroupLabelOperation struct {
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*AdGroupLabelOperation_Create
	//	*AdGroupLabelOperation_Remove
	Operation            isAdGroupLabelOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *AdGroupLabelOperation) Reset()         { *m = AdGroupLabelOperation{} }
func (m *AdGroupLabelOperation) String() string { return proto.CompactTextString(m) }
func (*AdGroupLabelOperation) ProtoMessage()    {}
func (*AdGroupLabelOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_8693fa91b2cc8640, []int{2}
}

func (m *AdGroupLabelOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupLabelOperation.Unmarshal(m, b)
}
func (m *AdGroupLabelOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupLabelOperation.Marshal(b, m, deterministic)
}
func (m *AdGroupLabelOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupLabelOperation.Merge(m, src)
}
func (m *AdGroupLabelOperation) XXX_Size() int {
	return xxx_messageInfo_AdGroupLabelOperation.Size(m)
}
func (m *AdGroupLabelOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupLabelOperation.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupLabelOperation proto.InternalMessageInfo

type isAdGroupLabelOperation_Operation interface {
	isAdGroupLabelOperation_Operation()
}

type AdGroupLabelOperation_Create struct {
	Create *resources.AdGroupLabel `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type AdGroupLabelOperation_Remove struct {
	Remove string `protobuf:"bytes,2,opt,name=remove,proto3,oneof"`
}

func (*AdGroupLabelOperation_Create) isAdGroupLabelOperation_Operation() {}

func (*AdGroupLabelOperation_Remove) isAdGroupLabelOperation_Operation() {}

func (m *AdGroupLabelOperation) GetOperation() isAdGroupLabelOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *AdGroupLabelOperation) GetCreate() *resources.AdGroupLabel {
	if x, ok := m.GetOperation().(*AdGroupLabelOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *AdGroupLabelOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*AdGroupLabelOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AdGroupLabelOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AdGroupLabelOperation_Create)(nil),
		(*AdGroupLabelOperation_Remove)(nil),
	}
}

// Response message for an ad group labels mutate.
type MutateAdGroupLabelsResponse struct {
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors),
	// we return an RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,3,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	// All results for the mutate.
	Results              []*MutateAdGroupLabelResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *MutateAdGroupLabelsResponse) Reset()         { *m = MutateAdGroupLabelsResponse{} }
func (m *MutateAdGroupLabelsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateAdGroupLabelsResponse) ProtoMessage()    {}
func (*MutateAdGroupLabelsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8693fa91b2cc8640, []int{3}
}

func (m *MutateAdGroupLabelsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdGroupLabelsResponse.Unmarshal(m, b)
}
func (m *MutateAdGroupLabelsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdGroupLabelsResponse.Marshal(b, m, deterministic)
}
func (m *MutateAdGroupLabelsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdGroupLabelsResponse.Merge(m, src)
}
func (m *MutateAdGroupLabelsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateAdGroupLabelsResponse.Size(m)
}
func (m *MutateAdGroupLabelsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdGroupLabelsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdGroupLabelsResponse proto.InternalMessageInfo

func (m *MutateAdGroupLabelsResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

func (m *MutateAdGroupLabelsResponse) GetResults() []*MutateAdGroupLabelResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for an ad group label mutate.
type MutateAdGroupLabelResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateAdGroupLabelResult) Reset()         { *m = MutateAdGroupLabelResult{} }
func (m *MutateAdGroupLabelResult) String() string { return proto.CompactTextString(m) }
func (*MutateAdGroupLabelResult) ProtoMessage()    {}
func (*MutateAdGroupLabelResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_8693fa91b2cc8640, []int{4}
}

func (m *MutateAdGroupLabelResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdGroupLabelResult.Unmarshal(m, b)
}
func (m *MutateAdGroupLabelResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdGroupLabelResult.Marshal(b, m, deterministic)
}
func (m *MutateAdGroupLabelResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdGroupLabelResult.Merge(m, src)
}
func (m *MutateAdGroupLabelResult) XXX_Size() int {
	return xxx_messageInfo_MutateAdGroupLabelResult.Size(m)
}
func (m *MutateAdGroupLabelResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdGroupLabelResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdGroupLabelResult proto.InternalMessageInfo

func (m *MutateAdGroupLabelResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetAdGroupLabelRequest)(nil), "google.ads.googleads.v2.services.GetAdGroupLabelRequest")
	proto.RegisterType((*MutateAdGroupLabelsRequest)(nil), "google.ads.googleads.v2.services.MutateAdGroupLabelsRequest")
	proto.RegisterType((*AdGroupLabelOperation)(nil), "google.ads.googleads.v2.services.AdGroupLabelOperation")
	proto.RegisterType((*MutateAdGroupLabelsResponse)(nil), "google.ads.googleads.v2.services.MutateAdGroupLabelsResponse")
	proto.RegisterType((*MutateAdGroupLabelResult)(nil), "google.ads.googleads.v2.services.MutateAdGroupLabelResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v2/services/ad_group_label_service.proto", fileDescriptor_8693fa91b2cc8640)
}

var fileDescriptor_8693fa91b2cc8640 = []byte{
	// 668 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x54, 0x4f, 0x6b, 0xd4, 0x4e,
	0x18, 0xfe, 0x65, 0xf7, 0x47, 0xb5, 0xb3, 0xd5, 0xc2, 0x94, 0x6a, 0xd8, 0x0a, 0x2e, 0xb1, 0x60,
	0xd9, 0x43, 0x06, 0x23, 0x58, 0x89, 0x2e, 0x92, 0x82, 0xdd, 0x16, 0xd4, 0x96, 0x54, 0x2a, 0xc8,
	0x42, 0x98, 0x26, 0x63, 0x08, 0x24, 0x99, 0x38, 0x33, 0x59, 0x28, 0xa5, 0x17, 0x6f, 0x9e, 0xfd,
	0x06, 0x1e, 0xbd, 0x7b, 0x12, 0xfc, 0x00, 0xbd, 0x89, 0x5f, 0xa1, 0x27, 0xbf, 0x84, 0x92, 0x4c,
	0x66, 0x9b, 0xdd, 0xee, 0xb2, 0xda, 0xdb, 0x9b, 0xf7, 0xcf, 0xf3, 0xbc, 0xcf, 0xfb, 0xbe, 0x19,
	0xd0, 0x0b, 0x29, 0x0d, 0x63, 0x82, 0x70, 0xc0, 0x91, 0x34, 0x0b, 0x6b, 0x68, 0x21, 0x4e, 0xd8,
	0x30, 0xf2, 0x09, 0x47, 0x38, 0xf0, 0x42, 0x46, 0xf3, 0xcc, 0x8b, 0xf1, 0x11, 0x89, 0xbd, 0xca,
	0x6f, 0x66, 0x8c, 0x0a, 0x0a, 0x3b, 0xb2, 0xc6, 0xc4, 0x01, 0x37, 0x47, 0xe5, 0xe6, 0xd0, 0x32,
	0x55, 0x79, 0xfb, 0xd1, 0x2c, 0x02, 0x46, 0x38, 0xcd, 0xd9, 0x65, 0x06, 0x89, 0xdc, 0xbe, 0xa3,
	0xea, 0xb2, 0x08, 0xe1, 0x34, 0xa5, 0x02, 0x8b, 0x88, 0xa6, 0xbc, 0x8a, 0xde, 0xae, 0xa2, 0x2c,
	0xf3, 0x11, 0x17, 0x58, 0xe4, 0x93, 0x81, 0xa2, 0xcc, 0x8f, 0x23, 0x92, 0x0a, 0x19, 0x30, 0x7a,
	0xe0, 0x56, 0x9f, 0x08, 0x27, 0xe8, 0x17, 0x4c, 0x2f, 0x0a, 0x22, 0x97, 0xbc, 0xcf, 0x09, 0x17,
	0xf0, 0x1e, 0xb8, 0xa1, 0x7a, 0xf1, 0x52, 0x9c, 0x10, 0x5d, 0xeb, 0x68, 0x1b, 0x8b, 0xee, 0x92,
	0x72, 0xbe, 0xc2, 0x09, 0x31, 0xce, 0x35, 0xd0, 0x7e, 0x99, 0x0b, 0x2c, 0x48, 0x1d, 0x82, 0x2b,
	0x8c, 0xbb, 0xa0, 0xe5, 0xe7, 0x5c, 0xd0, 0x84, 0x30, 0x2f, 0x0a, 0x2a, 0x04, 0xa0, 0x5c, 0xbb,
	0x01, 0x7c, 0x03, 0x00, 0xcd, 0x08, 0x93, 0x22, 0xf4, 0x46, 0xa7, 0xb9, 0xd1, 0xb2, 0x36, 0xcd,
	0x79, 0xd3, 0x33, 0xeb, 0x64, 0x7b, 0xaa, 0xde, 0xad, 0x41, 0xc1, 0xfb, 0x60, 0x39, 0xc3, 0x4c,
	0x44, 0x38, 0xf6, 0xde, 0xe1, 0x28, 0xce, 0x19, 0xd1, 0x9b, 0x1d, 0x6d, 0xe3, 0xba, 0x7b, 0xb3,
	0x72, 0x6f, 0x4b, 0x6f, 0x21, 0x73, 0x88, 0xe3, 0x28, 0xc0, 0x82, 0x78, 0x34, 0x8d, 0x8f, 0xf5,
	0xff, 0xcb, 0xb4, 0x25, 0xe5, 0xdc, 0x4b, 0xe3, 0x63, 0xe3, 0xa3, 0x06, 0x56, 0xa7, 0x72, 0xc2,
	0x5d, 0xb0, 0xe0, 0x33, 0x82, 0x85, 0x1c, 0x4f, 0xcb, 0x42, 0x33, 0x9b, 0x1f, 0x2d, 0x76, 0xac,
	0xfb, 0x9d, 0xff, 0xdc, 0x0a, 0x00, 0xea, 0x60, 0x81, 0x91, 0x84, 0x0e, 0x89, 0xde, 0x28, 0xe6,
	0x54, 0x44, 0xe4, 0xf7, 0x56, 0x0b, 0x2c, 0x8e, 0xa4, 0x19, 0xdf, 0x34, 0xb0, 0x36, 0x75, 0xe4,
	0x3c, 0xa3, 0x29, 0x27, 0x70, 0x1b, 0xac, 0x4e, 0x28, 0xf7, 0x08, 0x63, 0x94, 0x95, 0xfa, 0x5b,
	0x16, 0x54, 0x0d, 0xb2, 0xcc, 0x37, 0x0f, 0xca, 0x1b, 0x71, 0x57, 0xc6, 0x67, 0xf2, 0xbc, 0x48,
	0x87, 0xaf, 0xc1, 0x35, 0x46, 0x78, 0x1e, 0x0b, 0xb5, 0x17, 0x7b, 0xfe, 0x5e, 0x2e, 0xf7, 0xe5,
	0x96, 0x10, 0xae, 0x82, 0x32, 0x9e, 0x01, 0x7d, 0x56, 0xd2, 0x5f, 0x5d, 0x9c, 0xf5, 0xbd, 0x09,
	0x56, 0xea, 0xb5, 0x07, 0x92, 0x1b, 0x7e, 0xd5, 0xc0, 0xf2, 0xc4, 0x25, 0xc3, 0xc7, 0xf3, 0x3b,
	0x9e, 0x7e, 0xfc, 0xed, 0x7f, 0x5d, 0xa3, 0xb1, 0xf9, 0xe1, 0xe7, 0xf9, 0xa7, 0xc6, 0x03, 0x88,
	0x8a, 0x7f, 0xf8, 0x64, 0x4c, 0x46, 0x4f, 0xdd, 0x3b, 0x47, 0x5d, 0x84, 0xeb, 0x3b, 0x43, 0xdd,
	0x53, 0xf8, 0x43, 0x03, 0x2b, 0x53, 0xd6, 0x09, 0x9f, 0x5e, 0x65, 0xda, 0xea, 0xc7, 0x6b, 0xf7,
	0xae, 0x58, 0x2d, 0x6f, 0xc8, 0xe8, 0x95, 0x6a, 0x36, 0x0d, 0xab, 0x50, 0x73, 0xd1, 0xfe, 0x49,
	0xed, 0x67, 0xee, 0x75, 0x4f, 0xc7, 0xc5, 0xd8, 0x49, 0x09, 0x68, 0x6b, 0xdd, 0xf6, 0xda, 0x99,
	0xa3, 0x5f, 0x90, 0x56, 0x56, 0x16, 0x71, 0xd3, 0xa7, 0xc9, 0xd6, 0x6f, 0x0d, 0xac, 0xfb, 0x34,
	0x99, 0xdb, 0xe0, 0x96, 0x3e, 0x65, 0xcd, 0xfb, 0xc5, 0xa3, 0xb5, 0xaf, 0xbd, 0xdd, 0xa9, 0xaa,
	0x43, 0x1a, 0xe3, 0x34, 0x34, 0x29, 0x0b, 0x51, 0x48, 0xd2, 0xf2, 0x49, 0x43, 0x17, 0x7c, 0xb3,
	0x9f, 0xef, 0x27, 0xca, 0xf8, 0xdc, 0x68, 0xf6, 0x1d, 0xe7, 0x4b, 0xa3, 0xd3, 0x97, 0x80, 0x4e,
	0xc0, 0x4d, 0x69, 0x16, 0xd6, 0xa1, 0x65, 0x56, 0xc4, 0xfc, 0x4c, 0xa5, 0x0c, 0x9c, 0x80, 0x0f,
	0x46, 0x29, 0x83, 0x43, 0x6b, 0xa0, 0x52, 0x7e, 0x35, 0xd6, 0xa5, 0xdf, 0xb6, 0x9d, 0x80, 0xdb,
	0xf6, 0x28, 0xc9, 0xb6, 0x0f, 0x2d, 0xdb, 0x56, 0x69, 0x47, 0x0b, 0x65, 0x9f, 0x0f, 0xff, 0x04,
	0x00, 0x00, 0xff, 0xff, 0xbe, 0x5a, 0xbc, 0x8c, 0x65, 0x06, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// AdGroupLabelServiceClient is the client API for AdGroupLabelService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AdGroupLabelServiceClient interface {
	// Returns the requested ad group label in full detail.
	GetAdGroupLabel(ctx context.Context, in *GetAdGroupLabelRequest, opts ...grpc.CallOption) (*resources.AdGroupLabel, error)
	// Creates and removes ad group labels.
	// Operation statuses are returned.
	MutateAdGroupLabels(ctx context.Context, in *MutateAdGroupLabelsRequest, opts ...grpc.CallOption) (*MutateAdGroupLabelsResponse, error)
}

type adGroupLabelServiceClient struct {
	cc *grpc.ClientConn
}

func NewAdGroupLabelServiceClient(cc *grpc.ClientConn) AdGroupLabelServiceClient {
	return &adGroupLabelServiceClient{cc}
}

func (c *adGroupLabelServiceClient) GetAdGroupLabel(ctx context.Context, in *GetAdGroupLabelRequest, opts ...grpc.CallOption) (*resources.AdGroupLabel, error) {
	out := new(resources.AdGroupLabel)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.AdGroupLabelService/GetAdGroupLabel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adGroupLabelServiceClient) MutateAdGroupLabels(ctx context.Context, in *MutateAdGroupLabelsRequest, opts ...grpc.CallOption) (*MutateAdGroupLabelsResponse, error) {
	out := new(MutateAdGroupLabelsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.AdGroupLabelService/MutateAdGroupLabels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AdGroupLabelServiceServer is the server API for AdGroupLabelService service.
type AdGroupLabelServiceServer interface {
	// Returns the requested ad group label in full detail.
	GetAdGroupLabel(context.Context, *GetAdGroupLabelRequest) (*resources.AdGroupLabel, error)
	// Creates and removes ad group labels.
	// Operation statuses are returned.
	MutateAdGroupLabels(context.Context, *MutateAdGroupLabelsRequest) (*MutateAdGroupLabelsResponse, error)
}

func RegisterAdGroupLabelServiceServer(s *grpc.Server, srv AdGroupLabelServiceServer) {
	s.RegisterService(&_AdGroupLabelService_serviceDesc, srv)
}

func _AdGroupLabelService_GetAdGroupLabel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAdGroupLabelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdGroupLabelServiceServer).GetAdGroupLabel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.AdGroupLabelService/GetAdGroupLabel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdGroupLabelServiceServer).GetAdGroupLabel(ctx, req.(*GetAdGroupLabelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdGroupLabelService_MutateAdGroupLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateAdGroupLabelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdGroupLabelServiceServer).MutateAdGroupLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.AdGroupLabelService/MutateAdGroupLabels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdGroupLabelServiceServer).MutateAdGroupLabels(ctx, req.(*MutateAdGroupLabelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AdGroupLabelService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v2.services.AdGroupLabelService",
	HandlerType: (*AdGroupLabelServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAdGroupLabel",
			Handler:    _AdGroupLabelService_GetAdGroupLabel_Handler,
		},
		{
			MethodName: "MutateAdGroupLabels",
			Handler:    _AdGroupLabelService_MutateAdGroupLabels_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v2/services/ad_group_label_service.proto",
}
