// DO NOT EDIT: This file is autogenerated via the builtin command.

package slack

import (
	flux "github.com/influxdata/flux"
	ast "github.com/influxdata/flux/ast"
)

func init() {
	flux.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Errors: nil,
		Loc:    nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 15,
					Line:   63,
				},
				File:   "slack.flux",
				Source: "package slack\n\nimport \"http\"\nimport \"json\"\n\nbuiltin validateColorString\n\noption defaultURL = \"https://slack.com/api/chat.postMessage\"\n\n// `message` sends a single message to a Slack channel. It will work either with the chat.postMessage API or with a slack webhook.\n// `url` - string - URL of the slack endpoint. Defaults to: \"https://slack.com/api/chat.postMessage\", if one uses the webhook api this must be acquired as part of the slack API setup. This URL will be secret. Don't worry about secrets for the initial implementation.\n// `token` - string - the api token string.  Defaults to: \"\", and can be ignored if one uses the webhook api URL.\n// `username` - string - Username posting the message.\n// `channel` - string - Name of channel in which to post the message. No default.\n// `workspace` - string - Name of the slack workspace to use if there are multiple. Defaults to empty string.\n// `text` - string - The text to display.\n// `iconEmoji` - string - Name of : enclose emoji to use as image of user when posting message, will not show as the avatar icon with a slack webhook.\n// `color` - string - Color to give message: one of good, warning, and danger, or any hex rgb color value ex. #439FE0.\nmessage = (url=defaultURL, token=\"\", username, channel, workspace, text, iconEmoji, color) => {\n    attachments = [{\n        color: validateColorString(color),\n        text: string(v: text),\n        mrkdwn_in: [\"text\"],\n    }]\n\n    data = {\n        username: username,\n        channel: channel,\n        workspace: workspace,\n        attachments: attachments,\n        as_user: false,\n        icon_emoji: iconEmoji,\n    }\n\n    headers = {\n        \"Authorization\": \"Bearer \" + token,\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v:data)\n    return http.post(headers: headers, url: url, data: enc)\n}\n\n// `endpoint` creates the endpoint for the Slack external service.\n// `url` - string - URL of the slack endpoint. Defaults to: \"https://slack.com/api/chat.postMessage\", if one uses the webhook api this must be acquired as part of the slack API setup, and this URL will be secret.\n// `token` - string - token for the slack endpoint.  This can be ignored if one uses the webhook url acquired as part of the slack API setup, but must be supplied if the chat.postMessage API is used.\n// The returned factory function accepts a `mapFn` parameter.\n// The `mapFn` must return an object with `username`, `channel`, `workspace`, `text`, `iconEmoji`, and `color` fields as defined in the `message` function arguments.\nendpoint = (url=defaultURL, token=\"\") =>\n    (mapFn) =>\n        (tables=<-) => tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    username: obj.username,\n                    channel: obj.channel,\n                    workspace: obj.workspace,\n                    text: obj.text,\n                    iconEmoji: obj.iconEmoji,\n                    color: obj.color,\n                ) / 100)}\n            })",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 28,
						Line:   6,
					},
					File:   "slack.flux",
					Source: "builtin validateColorString",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 28,
							Line:   6,
						},
						File:   "slack.flux",
						Source: "validateColorString",
						Start: ast.Position{
							Column: 9,
							Line:   6,
						},
					},
				},
				Name: "validateColorString",
			},
		}, &ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 61,
							Line:   8,
						},
						File:   "slack.flux",
						Source: "defaultURL = \"https://slack.com/api/chat.postMessage\"",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   8,
							},
							File:   "slack.flux",
							Source: "defaultURL",
							Start: ast.Position{
								Column: 8,
								Line:   8,
							},
						},
					},
					Name: "defaultURL",
				},
				Init: &ast.StringLiteral{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 61,
								Line:   8,
							},
							File:   "slack.flux",
							Source: "\"https://slack.com/api/chat.postMessage\"",
							Start: ast.Position{
								Column: 21,
								Line:   8,
							},
						},
					},
					Value: "https://slack.com/api/chat.postMessage",
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 61,
						Line:   8,
					},
					File:   "slack.flux",
					Source: "option defaultURL = \"https://slack.com/api/chat.postMessage\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   41,
					},
					File:   "slack.flux",
					Source: "message = (url=defaultURL, token=\"\", username, channel, workspace, text, iconEmoji, color) => {\n    attachments = [{\n        color: validateColorString(color),\n        text: string(v: text),\n        mrkdwn_in: [\"text\"],\n    }]\n\n    data = {\n        username: username,\n        channel: channel,\n        workspace: workspace,\n        attachments: attachments,\n        as_user: false,\n        icon_emoji: iconEmoji,\n    }\n\n    headers = {\n        \"Authorization\": \"Bearer \" + token,\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v:data)\n    return http.post(headers: headers, url: url, data: enc)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   19,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   19,
						},
						File:   "slack.flux",
						Source: "message",
						Start: ast.Position{
							Column: 1,
							Line:   19,
						},
					},
				},
				Name: "message",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   41,
						},
						File:   "slack.flux",
						Source: "(url=defaultURL, token=\"\", username, channel, workspace, text, iconEmoji, color) => {\n    attachments = [{\n        color: validateColorString(color),\n        text: string(v: text),\n        mrkdwn_in: [\"text\"],\n    }]\n\n    data = {\n        username: username,\n        channel: channel,\n        workspace: workspace,\n        attachments: attachments,\n        as_user: false,\n        icon_emoji: iconEmoji,\n    }\n\n    headers = {\n        \"Authorization\": \"Bearer \" + token,\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v:data)\n    return http.post(headers: headers, url: url, data: enc)\n}",
						Start: ast.Position{
							Column: 11,
							Line:   19,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   41,
							},
							File:   "slack.flux",
							Source: "{\n    attachments = [{\n        color: validateColorString(color),\n        text: string(v: text),\n        mrkdwn_in: [\"text\"],\n    }]\n\n    data = {\n        username: username,\n        channel: channel,\n        workspace: workspace,\n        attachments: attachments,\n        as_user: false,\n        icon_emoji: iconEmoji,\n    }\n\n    headers = {\n        \"Authorization\": \"Bearer \" + token,\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v:data)\n    return http.post(headers: headers, url: url, data: enc)\n}",
							Start: ast.Position{
								Column: 95,
								Line:   19,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 7,
									Line:   24,
								},
								File:   "slack.flux",
								Source: "attachments = [{\n        color: validateColorString(color),\n        text: string(v: text),\n        mrkdwn_in: [\"text\"],\n    }]",
								Start: ast.Position{
									Column: 5,
									Line:   20,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   20,
									},
									File:   "slack.flux",
									Source: "attachments",
									Start: ast.Position{
										Column: 5,
										Line:   20,
									},
								},
							},
							Name: "attachments",
						},
						Init: &ast.ArrayExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 7,
										Line:   24,
									},
									File:   "slack.flux",
									Source: "[{\n        color: validateColorString(color),\n        text: string(v: text),\n        mrkdwn_in: [\"text\"],\n    }]",
									Start: ast.Position{
										Column: 19,
										Line:   20,
									},
								},
							},
							Elements: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   24,
										},
										File:   "slack.flux",
										Source: "{\n        color: validateColorString(color),\n        text: string(v: text),\n        mrkdwn_in: [\"text\"],\n    }",
										Start: ast.Position{
											Column: 20,
											Line:   20,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   21,
											},
											File:   "slack.flux",
											Source: "color: validateColorString(color)",
											Start: ast.Position{
												Column: 9,
												Line:   21,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   21,
												},
												File:   "slack.flux",
												Source: "color",
												Start: ast.Position{
													Column: 9,
													Line:   21,
												},
											},
										},
										Name: "color",
									},
									Value: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   21,
													},
													File:   "slack.flux",
													Source: "color",
													Start: ast.Position{
														Column: 36,
														Line:   21,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   21,
														},
														File:   "slack.flux",
														Source: "color",
														Start: ast.Position{
															Column: 36,
															Line:   21,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   21,
															},
															File:   "slack.flux",
															Source: "color",
															Start: ast.Position{
																Column: 36,
																Line:   21,
															},
														},
													},
													Name: "color",
												},
												Value: nil,
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   21,
												},
												File:   "slack.flux",
												Source: "validateColorString(color)",
												Start: ast.Position{
													Column: 16,
													Line:   21,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   21,
													},
													File:   "slack.flux",
													Source: "validateColorString",
													Start: ast.Position{
														Column: 16,
														Line:   21,
													},
												},
											},
											Name: "validateColorString",
										},
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   22,
											},
											File:   "slack.flux",
											Source: "text: string(v: text)",
											Start: ast.Position{
												Column: 9,
												Line:   22,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   22,
												},
												File:   "slack.flux",
												Source: "text",
												Start: ast.Position{
													Column: 9,
													Line:   22,
												},
											},
										},
										Name: "text",
									},
									Value: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   22,
													},
													File:   "slack.flux",
													Source: "v: text",
													Start: ast.Position{
														Column: 22,
														Line:   22,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 29,
															Line:   22,
														},
														File:   "slack.flux",
														Source: "v: text",
														Start: ast.Position{
															Column: 22,
															Line:   22,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 23,
																Line:   22,
															},
															File:   "slack.flux",
															Source: "v",
															Start: ast.Position{
																Column: 22,
																Line:   22,
															},
														},
													},
													Name: "v",
												},
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 29,
																Line:   22,
															},
															File:   "slack.flux",
															Source: "text",
															Start: ast.Position{
																Column: 25,
																Line:   22,
															},
														},
													},
													Name: "text",
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   22,
												},
												File:   "slack.flux",
												Source: "string(v: text)",
												Start: ast.Position{
													Column: 15,
													Line:   22,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   22,
													},
													File:   "slack.flux",
													Source: "string",
													Start: ast.Position{
														Column: 15,
														Line:   22,
													},
												},
											},
											Name: "string",
										},
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   23,
											},
											File:   "slack.flux",
											Source: "mrkdwn_in: [\"text\"]",
											Start: ast.Position{
												Column: 9,
												Line:   23,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   23,
												},
												File:   "slack.flux",
												Source: "mrkdwn_in",
												Start: ast.Position{
													Column: 9,
													Line:   23,
												},
											},
										},
										Name: "mrkdwn_in",
									},
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   23,
												},
												File:   "slack.flux",
												Source: "[\"text\"]",
												Start: ast.Position{
													Column: 20,
													Line:   23,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   23,
													},
													File:   "slack.flux",
													Source: "\"text\"",
													Start: ast.Position{
														Column: 21,
														Line:   23,
													},
												},
											},
											Value: "text",
										}},
									},
								}},
								With: nil,
							}},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   33,
								},
								File:   "slack.flux",
								Source: "data = {\n        username: username,\n        channel: channel,\n        workspace: workspace,\n        attachments: attachments,\n        as_user: false,\n        icon_emoji: iconEmoji,\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   26,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   26,
									},
									File:   "slack.flux",
									Source: "data",
									Start: ast.Position{
										Column: 5,
										Line:   26,
									},
								},
							},
							Name: "data",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   33,
									},
									File:   "slack.flux",
									Source: "{\n        username: username,\n        channel: channel,\n        workspace: workspace,\n        attachments: attachments,\n        as_user: false,\n        icon_emoji: iconEmoji,\n    }",
									Start: ast.Position{
										Column: 12,
										Line:   26,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   27,
										},
										File:   "slack.flux",
										Source: "username: username",
										Start: ast.Position{
											Column: 9,
											Line:   27,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   27,
											},
											File:   "slack.flux",
											Source: "username",
											Start: ast.Position{
												Column: 9,
												Line:   27,
											},
										},
									},
									Name: "username",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   27,
											},
											File:   "slack.flux",
											Source: "username",
											Start: ast.Position{
												Column: 19,
												Line:   27,
											},
										},
									},
									Name: "username",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   28,
										},
										File:   "slack.flux",
										Source: "channel: channel",
										Start: ast.Position{
											Column: 9,
											Line:   28,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   28,
											},
											File:   "slack.flux",
											Source: "channel",
											Start: ast.Position{
												Column: 9,
												Line:   28,
											},
										},
									},
									Name: "channel",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   28,
											},
											File:   "slack.flux",
											Source: "channel",
											Start: ast.Position{
												Column: 18,
												Line:   28,
											},
										},
									},
									Name: "channel",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   29,
										},
										File:   "slack.flux",
										Source: "workspace: workspace",
										Start: ast.Position{
											Column: 9,
											Line:   29,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   29,
											},
											File:   "slack.flux",
											Source: "workspace",
											Start: ast.Position{
												Column: 9,
												Line:   29,
											},
										},
									},
									Name: "workspace",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   29,
											},
											File:   "slack.flux",
											Source: "workspace",
											Start: ast.Position{
												Column: 20,
												Line:   29,
											},
										},
									},
									Name: "workspace",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   30,
										},
										File:   "slack.flux",
										Source: "attachments: attachments",
										Start: ast.Position{
											Column: 9,
											Line:   30,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   30,
											},
											File:   "slack.flux",
											Source: "attachments",
											Start: ast.Position{
												Column: 9,
												Line:   30,
											},
										},
									},
									Name: "attachments",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   30,
											},
											File:   "slack.flux",
											Source: "attachments",
											Start: ast.Position{
												Column: 22,
												Line:   30,
											},
										},
									},
									Name: "attachments",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   31,
										},
										File:   "slack.flux",
										Source: "as_user: false",
										Start: ast.Position{
											Column: 9,
											Line:   31,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   31,
											},
											File:   "slack.flux",
											Source: "as_user",
											Start: ast.Position{
												Column: 9,
												Line:   31,
											},
										},
									},
									Name: "as_user",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   31,
											},
											File:   "slack.flux",
											Source: "false",
											Start: ast.Position{
												Column: 18,
												Line:   31,
											},
										},
									},
									Name: "false",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   32,
										},
										File:   "slack.flux",
										Source: "icon_emoji: iconEmoji",
										Start: ast.Position{
											Column: 9,
											Line:   32,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   32,
											},
											File:   "slack.flux",
											Source: "icon_emoji",
											Start: ast.Position{
												Column: 9,
												Line:   32,
											},
										},
									},
									Name: "icon_emoji",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   32,
											},
											File:   "slack.flux",
											Source: "iconEmoji",
											Start: ast.Position{
												Column: 21,
												Line:   32,
											},
										},
									},
									Name: "iconEmoji",
								},
							}},
							With: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   38,
								},
								File:   "slack.flux",
								Source: "headers = {\n        \"Authorization\": \"Bearer \" + token,\n        \"Content-Type\": \"application/json\",\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   35,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   35,
									},
									File:   "slack.flux",
									Source: "headers",
									Start: ast.Position{
										Column: 5,
										Line:   35,
									},
								},
							},
							Name: "headers",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   38,
									},
									File:   "slack.flux",
									Source: "{\n        \"Authorization\": \"Bearer \" + token,\n        \"Content-Type\": \"application/json\",\n    }",
									Start: ast.Position{
										Column: 15,
										Line:   35,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   36,
										},
										File:   "slack.flux",
										Source: "\"Authorization\": \"Bearer \" + token",
										Start: ast.Position{
											Column: 9,
											Line:   36,
										},
									},
								},
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   36,
											},
											File:   "slack.flux",
											Source: "\"Authorization\"",
											Start: ast.Position{
												Column: 9,
												Line:   36,
											},
										},
									},
									Value: "Authorization",
								},
								Value: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   36,
											},
											File:   "slack.flux",
											Source: "\"Bearer \" + token",
											Start: ast.Position{
												Column: 26,
												Line:   36,
											},
										},
									},
									Left: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   36,
												},
												File:   "slack.flux",
												Source: "\"Bearer \"",
												Start: ast.Position{
													Column: 26,
													Line:   36,
												},
											},
										},
										Value: "Bearer ",
									},
									Operator: 5,
									Right: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   36,
												},
												File:   "slack.flux",
												Source: "token",
												Start: ast.Position{
													Column: 38,
													Line:   36,
												},
											},
										},
										Name: "token",
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   37,
										},
										File:   "slack.flux",
										Source: "\"Content-Type\": \"application/json\"",
										Start: ast.Position{
											Column: 9,
											Line:   37,
										},
									},
								},
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   37,
											},
											File:   "slack.flux",
											Source: "\"Content-Type\"",
											Start: ast.Position{
												Column: 9,
												Line:   37,
											},
										},
									},
									Value: "Content-Type",
								},
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   37,
											},
											File:   "slack.flux",
											Source: "\"application/json\"",
											Start: ast.Position{
												Column: 25,
												Line:   37,
											},
										},
									},
									Value: "application/json",
								},
							}},
							With: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   39,
								},
								File:   "slack.flux",
								Source: "enc = json.encode(v:data)",
								Start: ast.Position{
									Column: 5,
									Line:   39,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   39,
									},
									File:   "slack.flux",
									Source: "enc",
									Start: ast.Position{
										Column: 5,
										Line:   39,
									},
								},
							},
							Name: "enc",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   39,
										},
										File:   "slack.flux",
										Source: "v:data",
										Start: ast.Position{
											Column: 23,
											Line:   39,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   39,
											},
											File:   "slack.flux",
											Source: "v:data",
											Start: ast.Position{
												Column: 23,
												Line:   39,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   39,
												},
												File:   "slack.flux",
												Source: "v",
												Start: ast.Position{
													Column: 23,
													Line:   39,
												},
											},
										},
										Name: "v",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   39,
												},
												File:   "slack.flux",
												Source: "data",
												Start: ast.Position{
													Column: 25,
													Line:   39,
												},
											},
										},
										Name: "data",
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   39,
									},
									File:   "slack.flux",
									Source: "json.encode(v:data)",
									Start: ast.Position{
										Column: 11,
										Line:   39,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   39,
										},
										File:   "slack.flux",
										Source: "json.encode",
										Start: ast.Position{
											Column: 11,
											Line:   39,
										},
									},
								},
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   39,
											},
											File:   "slack.flux",
											Source: "json",
											Start: ast.Position{
												Column: 11,
												Line:   39,
											},
										},
									},
									Name: "json",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   39,
											},
											File:   "slack.flux",
											Source: "encode",
											Start: ast.Position{
												Column: 16,
												Line:   39,
											},
										},
									},
									Name: "encode",
								},
							},
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   40,
										},
										File:   "slack.flux",
										Source: "headers: headers, url: url, data: enc",
										Start: ast.Position{
											Column: 22,
											Line:   40,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   40,
											},
											File:   "slack.flux",
											Source: "headers: headers",
											Start: ast.Position{
												Column: 22,
												Line:   40,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   40,
												},
												File:   "slack.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 22,
													Line:   40,
												},
											},
										},
										Name: "headers",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   40,
												},
												File:   "slack.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 31,
													Line:   40,
												},
											},
										},
										Name: "headers",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   40,
											},
											File:   "slack.flux",
											Source: "url: url",
											Start: ast.Position{
												Column: 40,
												Line:   40,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   40,
												},
												File:   "slack.flux",
												Source: "url",
												Start: ast.Position{
													Column: 40,
													Line:   40,
												},
											},
										},
										Name: "url",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   40,
												},
												File:   "slack.flux",
												Source: "url",
												Start: ast.Position{
													Column: 45,
													Line:   40,
												},
											},
										},
										Name: "url",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   40,
											},
											File:   "slack.flux",
											Source: "data: enc",
											Start: ast.Position{
												Column: 50,
												Line:   40,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   40,
												},
												File:   "slack.flux",
												Source: "data",
												Start: ast.Position{
													Column: 50,
													Line:   40,
												},
											},
										},
										Name: "data",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   40,
												},
												File:   "slack.flux",
												Source: "enc",
												Start: ast.Position{
													Column: 56,
													Line:   40,
												},
											},
										},
										Name: "enc",
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   40,
									},
									File:   "slack.flux",
									Source: "http.post(headers: headers, url: url, data: enc)",
									Start: ast.Position{
										Column: 12,
										Line:   40,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   40,
										},
										File:   "slack.flux",
										Source: "http.post",
										Start: ast.Position{
											Column: 12,
											Line:   40,
										},
									},
								},
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   40,
											},
											File:   "slack.flux",
											Source: "http",
											Start: ast.Position{
												Column: 12,
												Line:   40,
											},
										},
									},
									Name: "http",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   40,
											},
											File:   "slack.flux",
											Source: "post",
											Start: ast.Position{
												Column: 17,
												Line:   40,
											},
										},
									},
									Name: "post",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   40,
								},
								File:   "slack.flux",
								Source: "return http.post(headers: headers, url: url, data: enc)",
								Start: ast.Position{
									Column: 5,
									Line:   40,
								},
							},
						},
					}},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   19,
							},
							File:   "slack.flux",
							Source: "url=defaultURL",
							Start: ast.Position{
								Column: 12,
								Line:   19,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   19,
								},
								File:   "slack.flux",
								Source: "url",
								Start: ast.Position{
									Column: 12,
									Line:   19,
								},
							},
						},
						Name: "url",
					},
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   19,
								},
								File:   "slack.flux",
								Source: "defaultURL",
								Start: ast.Position{
									Column: 16,
									Line:   19,
								},
							},
						},
						Name: "defaultURL",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   19,
							},
							File:   "slack.flux",
							Source: "token=\"\"",
							Start: ast.Position{
								Column: 28,
								Line:   19,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   19,
								},
								File:   "slack.flux",
								Source: "token",
								Start: ast.Position{
									Column: 28,
									Line:   19,
								},
							},
						},
						Name: "token",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   19,
								},
								File:   "slack.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 34,
									Line:   19,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 46,
								Line:   19,
							},
							File:   "slack.flux",
							Source: "username",
							Start: ast.Position{
								Column: 38,
								Line:   19,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   19,
								},
								File:   "slack.flux",
								Source: "username",
								Start: ast.Position{
									Column: 38,
									Line:   19,
								},
							},
						},
						Name: "username",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   19,
							},
							File:   "slack.flux",
							Source: "channel",
							Start: ast.Position{
								Column: 48,
								Line:   19,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   19,
								},
								File:   "slack.flux",
								Source: "channel",
								Start: ast.Position{
									Column: 48,
									Line:   19,
								},
							},
						},
						Name: "channel",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 66,
								Line:   19,
							},
							File:   "slack.flux",
							Source: "workspace",
							Start: ast.Position{
								Column: 57,
								Line:   19,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   19,
								},
								File:   "slack.flux",
								Source: "workspace",
								Start: ast.Position{
									Column: 57,
									Line:   19,
								},
							},
						},
						Name: "workspace",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 72,
								Line:   19,
							},
							File:   "slack.flux",
							Source: "text",
							Start: ast.Position{
								Column: 68,
								Line:   19,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   19,
								},
								File:   "slack.flux",
								Source: "text",
								Start: ast.Position{
									Column: 68,
									Line:   19,
								},
							},
						},
						Name: "text",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 83,
								Line:   19,
							},
							File:   "slack.flux",
							Source: "iconEmoji",
							Start: ast.Position{
								Column: 74,
								Line:   19,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 83,
									Line:   19,
								},
								File:   "slack.flux",
								Source: "iconEmoji",
								Start: ast.Position{
									Column: 74,
									Line:   19,
								},
							},
						},
						Name: "iconEmoji",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 90,
								Line:   19,
							},
							File:   "slack.flux",
							Source: "color",
							Start: ast.Position{
								Column: 85,
								Line:   19,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 90,
									Line:   19,
								},
								File:   "slack.flux",
								Source: "color",
								Start: ast.Position{
									Column: 85,
									Line:   19,
								},
							},
						},
						Name: "color",
					},
					Value: nil,
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   63,
					},
					File:   "slack.flux",
					Source: "endpoint = (url=defaultURL, token=\"\") =>\n    (mapFn) =>\n        (tables=<-) => tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    username: obj.username,\n                    channel: obj.channel,\n                    workspace: obj.workspace,\n                    text: obj.text,\n                    iconEmoji: obj.iconEmoji,\n                    color: obj.color,\n                ) / 100)}\n            })",
					Start: ast.Position{
						Column: 1,
						Line:   48,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   48,
						},
						File:   "slack.flux",
						Source: "endpoint",
						Start: ast.Position{
							Column: 1,
							Line:   48,
						},
					},
				},
				Name: "endpoint",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   63,
						},
						File:   "slack.flux",
						Source: "(url=defaultURL, token=\"\") =>\n    (mapFn) =>\n        (tables=<-) => tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    username: obj.username,\n                    channel: obj.channel,\n                    workspace: obj.workspace,\n                    text: obj.text,\n                    iconEmoji: obj.iconEmoji,\n                    color: obj.color,\n                ) / 100)}\n            })",
						Start: ast.Position{
							Column: 12,
							Line:   48,
						},
					},
				},
				Body: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   63,
							},
							File:   "slack.flux",
							Source: "(mapFn) =>\n        (tables=<-) => tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    username: obj.username,\n                    channel: obj.channel,\n                    workspace: obj.workspace,\n                    text: obj.text,\n                    iconEmoji: obj.iconEmoji,\n                    color: obj.color,\n                ) / 100)}\n            })",
							Start: ast.Position{
								Column: 5,
								Line:   49,
							},
						},
					},
					Body: &ast.FunctionExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   63,
								},
								File:   "slack.flux",
								Source: "(tables=<-) => tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    username: obj.username,\n                    channel: obj.channel,\n                    workspace: obj.workspace,\n                    text: obj.text,\n                    iconEmoji: obj.iconEmoji,\n                    color: obj.color,\n                ) / 100)}\n            })",
								Start: ast.Position{
									Column: 9,
									Line:   50,
								},
							},
						},
						Body: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   50,
										},
										File:   "slack.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 24,
											Line:   50,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   63,
									},
									File:   "slack.flux",
									Source: "tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    username: obj.username,\n                    channel: obj.channel,\n                    workspace: obj.workspace,\n                    text: obj.text,\n                    iconEmoji: obj.iconEmoji,\n                    color: obj.color,\n                ) / 100)}\n            })",
									Start: ast.Position{
										Column: 24,
										Line:   50,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   63,
											},
											File:   "slack.flux",
											Source: "fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    username: obj.username,\n                    channel: obj.channel,\n                    workspace: obj.workspace,\n                    text: obj.text,\n                    iconEmoji: obj.iconEmoji,\n                    color: obj.color,\n                ) / 100)}\n            }",
											Start: ast.Position{
												Column: 20,
												Line:   51,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   63,
												},
												File:   "slack.flux",
												Source: "fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    username: obj.username,\n                    channel: obj.channel,\n                    workspace: obj.workspace,\n                    text: obj.text,\n                    iconEmoji: obj.iconEmoji,\n                    color: obj.color,\n                ) / 100)}\n            }",
												Start: ast.Position{
													Column: 20,
													Line:   51,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   51,
													},
													File:   "slack.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 20,
														Line:   51,
													},
												},
											},
											Name: "fn",
										},
										Value: &ast.FunctionExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   63,
													},
													File:   "slack.flux",
													Source: "(r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    username: obj.username,\n                    channel: obj.channel,\n                    workspace: obj.workspace,\n                    text: obj.text,\n                    iconEmoji: obj.iconEmoji,\n                    color: obj.color,\n                ) / 100)}\n            }",
													Start: ast.Position{
														Column: 24,
														Line:   51,
													},
												},
											},
											Body: &ast.Block{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   63,
														},
														File:   "slack.flux",
														Source: "{\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    username: obj.username,\n                    channel: obj.channel,\n                    workspace: obj.workspace,\n                    text: obj.text,\n                    iconEmoji: obj.iconEmoji,\n                    color: obj.color,\n                ) / 100)}\n            }",
														Start: ast.Position{
															Column: 31,
															Line:   51,
														},
													},
												},
												Body: []ast.Statement{&ast.VariableAssignment{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   52,
															},
															File:   "slack.flux",
															Source: "obj = mapFn(r: r)",
															Start: ast.Position{
																Column: 17,
																Line:   52,
															},
														},
													},
													ID: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 20,
																	Line:   52,
																},
																File:   "slack.flux",
																Source: "obj",
																Start: ast.Position{
																	Column: 17,
																	Line:   52,
																},
															},
														},
														Name: "obj",
													},
													Init: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 33,
																		Line:   52,
																	},
																	File:   "slack.flux",
																	Source: "r: r",
																	Start: ast.Position{
																		Column: 29,
																		Line:   52,
																	},
																},
															},
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 33,
																			Line:   52,
																		},
																		File:   "slack.flux",
																		Source: "r: r",
																		Start: ast.Position{
																			Column: 29,
																			Line:   52,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   52,
																			},
																			File:   "slack.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 29,
																				Line:   52,
																			},
																		},
																	},
																	Name: "r",
																},
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 33,
																				Line:   52,
																			},
																			File:   "slack.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 32,
																				Line:   52,
																			},
																		},
																	},
																	Name: "r",
																},
															}},
															With: nil,
														}},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   52,
																},
																File:   "slack.flux",
																Source: "mapFn(r: r)",
																Start: ast.Position{
																	Column: 23,
																	Line:   52,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 28,
																		Line:   52,
																	},
																	File:   "slack.flux",
																	Source: "mapFn",
																	Start: ast.Position{
																		Column: 23,
																		Line:   52,
																	},
																},
															},
															Name: "mapFn",
														},
													},
												}, &ast.ReturnStatement{
													Argument: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 26,
																	Line:   62,
																},
																File:   "slack.flux",
																Source: "{r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    username: obj.username,\n                    channel: obj.channel,\n                    workspace: obj.workspace,\n                    text: obj.text,\n                    iconEmoji: obj.iconEmoji,\n                    color: obj.color,\n                ) / 100)}",
																Start: ast.Position{
																	Column: 24,
																	Line:   53,
																},
															},
														},
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   62,
																	},
																	File:   "slack.flux",
																	Source: "_sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    username: obj.username,\n                    channel: obj.channel,\n                    workspace: obj.workspace,\n                    text: obj.text,\n                    iconEmoji: obj.iconEmoji,\n                    color: obj.color,\n                ) / 100)",
																	Start: ast.Position{
																		Column: 32,
																		Line:   53,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 37,
																			Line:   53,
																		},
																		File:   "slack.flux",
																		Source: "_sent",
																		Start: ast.Position{
																			Column: 32,
																			Line:   53,
																		},
																	},
																},
																Name: "_sent",
															},
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 24,
																				Line:   62,
																			},
																			File:   "slack.flux",
																			Source: "v: 2 == message(\n                    url: url,\n                    token: token,\n                    username: obj.username,\n                    channel: obj.channel,\n                    workspace: obj.workspace,\n                    text: obj.text,\n                    iconEmoji: obj.iconEmoji,\n                    color: obj.color,\n                ) / 100",
																			Start: ast.Position{
																				Column: 46,
																				Line:   53,
																			},
																		},
																	},
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 24,
																					Line:   62,
																				},
																				File:   "slack.flux",
																				Source: "v: 2 == message(\n                    url: url,\n                    token: token,\n                    username: obj.username,\n                    channel: obj.channel,\n                    workspace: obj.workspace,\n                    text: obj.text,\n                    iconEmoji: obj.iconEmoji,\n                    color: obj.color,\n                ) / 100",
																				Start: ast.Position{
																					Column: 46,
																					Line:   53,
																				},
																			},
																		},
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 47,
																						Line:   53,
																					},
																					File:   "slack.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 46,
																						Line:   53,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Value: &ast.BinaryExpression{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 24,
																						Line:   62,
																					},
																					File:   "slack.flux",
																					Source: "2 == message(\n                    url: url,\n                    token: token,\n                    username: obj.username,\n                    channel: obj.channel,\n                    workspace: obj.workspace,\n                    text: obj.text,\n                    iconEmoji: obj.iconEmoji,\n                    color: obj.color,\n                ) / 100",
																					Start: ast.Position{
																						Column: 49,
																						Line:   53,
																					},
																				},
																			},
																			Left: &ast.IntegerLiteral{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 50,
																							Line:   53,
																						},
																						File:   "slack.flux",
																						Source: "2",
																						Start: ast.Position{
																							Column: 49,
																							Line:   53,
																						},
																					},
																				},
																				Value: int64(2),
																			},
																			Operator: 17,
																			Right: &ast.BinaryExpression{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 24,
																							Line:   62,
																						},
																						File:   "slack.flux",
																						Source: "message(\n                    url: url,\n                    token: token,\n                    username: obj.username,\n                    channel: obj.channel,\n                    workspace: obj.workspace,\n                    text: obj.text,\n                    iconEmoji: obj.iconEmoji,\n                    color: obj.color,\n                ) / 100",
																						Start: ast.Position{
																							Column: 54,
																							Line:   53,
																						},
																					},
																				},
																				Left: &ast.CallExpression{
																					Arguments: []ast.Expression{&ast.ObjectExpression{
																						BaseNode: ast.BaseNode{
																							Errors: nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 37,
																									Line:   61,
																								},
																								File:   "slack.flux",
																								Source: "url: url,\n                    token: token,\n                    username: obj.username,\n                    channel: obj.channel,\n                    workspace: obj.workspace,\n                    text: obj.text,\n                    iconEmoji: obj.iconEmoji,\n                    color: obj.color",
																								Start: ast.Position{
																									Column: 21,
																									Line:   54,
																								},
																							},
																						},
																						Properties: []*ast.Property{&ast.Property{
																							BaseNode: ast.BaseNode{
																								Errors: nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 29,
																										Line:   54,
																									},
																									File:   "slack.flux",
																									Source: "url: url",
																									Start: ast.Position{
																										Column: 21,
																										Line:   54,
																									},
																								},
																							},
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 24,
																											Line:   54,
																										},
																										File:   "slack.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 21,
																											Line:   54,
																										},
																									},
																								},
																								Name: "url",
																							},
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 29,
																											Line:   54,
																										},
																										File:   "slack.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 26,
																											Line:   54,
																										},
																									},
																								},
																								Name: "url",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Errors: nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 33,
																										Line:   55,
																									},
																									File:   "slack.flux",
																									Source: "token: token",
																									Start: ast.Position{
																										Column: 21,
																										Line:   55,
																									},
																								},
																							},
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 26,
																											Line:   55,
																										},
																										File:   "slack.flux",
																										Source: "token",
																										Start: ast.Position{
																											Column: 21,
																											Line:   55,
																										},
																									},
																								},
																								Name: "token",
																							},
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   55,
																										},
																										File:   "slack.flux",
																										Source: "token",
																										Start: ast.Position{
																											Column: 28,
																											Line:   55,
																										},
																									},
																								},
																								Name: "token",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Errors: nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 43,
																										Line:   56,
																									},
																									File:   "slack.flux",
																									Source: "username: obj.username",
																									Start: ast.Position{
																										Column: 21,
																										Line:   56,
																									},
																								},
																							},
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 29,
																											Line:   56,
																										},
																										File:   "slack.flux",
																										Source: "username",
																										Start: ast.Position{
																											Column: 21,
																											Line:   56,
																										},
																									},
																								},
																								Name: "username",
																							},
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 43,
																											Line:   56,
																										},
																										File:   "slack.flux",
																										Source: "obj.username",
																										Start: ast.Position{
																											Column: 31,
																											Line:   56,
																										},
																									},
																								},
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 34,
																												Line:   56,
																											},
																											File:   "slack.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 31,
																												Line:   56,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 43,
																												Line:   56,
																											},
																											File:   "slack.flux",
																											Source: "username",
																											Start: ast.Position{
																												Column: 35,
																												Line:   56,
																											},
																										},
																									},
																									Name: "username",
																								},
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Errors: nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 41,
																										Line:   57,
																									},
																									File:   "slack.flux",
																									Source: "channel: obj.channel",
																									Start: ast.Position{
																										Column: 21,
																										Line:   57,
																									},
																								},
																							},
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 28,
																											Line:   57,
																										},
																										File:   "slack.flux",
																										Source: "channel",
																										Start: ast.Position{
																											Column: 21,
																											Line:   57,
																										},
																									},
																								},
																								Name: "channel",
																							},
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 41,
																											Line:   57,
																										},
																										File:   "slack.flux",
																										Source: "obj.channel",
																										Start: ast.Position{
																											Column: 30,
																											Line:   57,
																										},
																									},
																								},
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 33,
																												Line:   57,
																											},
																											File:   "slack.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 30,
																												Line:   57,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 41,
																												Line:   57,
																											},
																											File:   "slack.flux",
																											Source: "channel",
																											Start: ast.Position{
																												Column: 34,
																												Line:   57,
																											},
																										},
																									},
																									Name: "channel",
																								},
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Errors: nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 45,
																										Line:   58,
																									},
																									File:   "slack.flux",
																									Source: "workspace: obj.workspace",
																									Start: ast.Position{
																										Column: 21,
																										Line:   58,
																									},
																								},
																							},
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 30,
																											Line:   58,
																										},
																										File:   "slack.flux",
																										Source: "workspace",
																										Start: ast.Position{
																											Column: 21,
																											Line:   58,
																										},
																									},
																								},
																								Name: "workspace",
																							},
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 45,
																											Line:   58,
																										},
																										File:   "slack.flux",
																										Source: "obj.workspace",
																										Start: ast.Position{
																											Column: 32,
																											Line:   58,
																										},
																									},
																								},
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 35,
																												Line:   58,
																											},
																											File:   "slack.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 32,
																												Line:   58,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 45,
																												Line:   58,
																											},
																											File:   "slack.flux",
																											Source: "workspace",
																											Start: ast.Position{
																												Column: 36,
																												Line:   58,
																											},
																										},
																									},
																									Name: "workspace",
																								},
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Errors: nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 35,
																										Line:   59,
																									},
																									File:   "slack.flux",
																									Source: "text: obj.text",
																									Start: ast.Position{
																										Column: 21,
																										Line:   59,
																									},
																								},
																							},
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 25,
																											Line:   59,
																										},
																										File:   "slack.flux",
																										Source: "text",
																										Start: ast.Position{
																											Column: 21,
																											Line:   59,
																										},
																									},
																								},
																								Name: "text",
																							},
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 35,
																											Line:   59,
																										},
																										File:   "slack.flux",
																										Source: "obj.text",
																										Start: ast.Position{
																											Column: 27,
																											Line:   59,
																										},
																									},
																								},
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 30,
																												Line:   59,
																											},
																											File:   "slack.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 27,
																												Line:   59,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 35,
																												Line:   59,
																											},
																											File:   "slack.flux",
																											Source: "text",
																											Start: ast.Position{
																												Column: 31,
																												Line:   59,
																											},
																										},
																									},
																									Name: "text",
																								},
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Errors: nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 45,
																										Line:   60,
																									},
																									File:   "slack.flux",
																									Source: "iconEmoji: obj.iconEmoji",
																									Start: ast.Position{
																										Column: 21,
																										Line:   60,
																									},
																								},
																							},
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 30,
																											Line:   60,
																										},
																										File:   "slack.flux",
																										Source: "iconEmoji",
																										Start: ast.Position{
																											Column: 21,
																											Line:   60,
																										},
																									},
																								},
																								Name: "iconEmoji",
																							},
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 45,
																											Line:   60,
																										},
																										File:   "slack.flux",
																										Source: "obj.iconEmoji",
																										Start: ast.Position{
																											Column: 32,
																											Line:   60,
																										},
																									},
																								},
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 35,
																												Line:   60,
																											},
																											File:   "slack.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 32,
																												Line:   60,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 45,
																												Line:   60,
																											},
																											File:   "slack.flux",
																											Source: "iconEmoji",
																											Start: ast.Position{
																												Column: 36,
																												Line:   60,
																											},
																										},
																									},
																									Name: "iconEmoji",
																								},
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Errors: nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 37,
																										Line:   61,
																									},
																									File:   "slack.flux",
																									Source: "color: obj.color",
																									Start: ast.Position{
																										Column: 21,
																										Line:   61,
																									},
																								},
																							},
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 26,
																											Line:   61,
																										},
																										File:   "slack.flux",
																										Source: "color",
																										Start: ast.Position{
																											Column: 21,
																											Line:   61,
																										},
																									},
																								},
																								Name: "color",
																							},
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 37,
																											Line:   61,
																										},
																										File:   "slack.flux",
																										Source: "obj.color",
																										Start: ast.Position{
																											Column: 28,
																											Line:   61,
																										},
																									},
																								},
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 31,
																												Line:   61,
																											},
																											File:   "slack.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 28,
																												Line:   61,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 37,
																												Line:   61,
																											},
																											File:   "slack.flux",
																											Source: "color",
																											Start: ast.Position{
																												Column: 32,
																												Line:   61,
																											},
																										},
																									},
																									Name: "color",
																								},
																							},
																						}},
																						With: nil,
																					}},
																					BaseNode: ast.BaseNode{
																						Errors: nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 18,
																								Line:   62,
																							},
																							File:   "slack.flux",
																							Source: "message(\n                    url: url,\n                    token: token,\n                    username: obj.username,\n                    channel: obj.channel,\n                    workspace: obj.workspace,\n                    text: obj.text,\n                    iconEmoji: obj.iconEmoji,\n                    color: obj.color,\n                )",
																							Start: ast.Position{
																								Column: 54,
																								Line:   53,
																							},
																						},
																					},
																					Callee: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Errors: nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 61,
																									Line:   53,
																								},
																								File:   "slack.flux",
																								Source: "message",
																								Start: ast.Position{
																									Column: 54,
																									Line:   53,
																								},
																							},
																						},
																						Name: "message",
																					},
																				},
																				Operator: 2,
																				Right: &ast.IntegerLiteral{
																					BaseNode: ast.BaseNode{
																						Errors: nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 24,
																								Line:   62,
																							},
																							File:   "slack.flux",
																							Source: "100",
																							Start: ast.Position{
																								Column: 21,
																								Line:   62,
																							},
																						},
																					},
																					Value: int64(100),
																				},
																			},
																		},
																	}},
																	With: nil,
																}},
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 25,
																			Line:   62,
																		},
																		File:   "slack.flux",
																		Source: "string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    username: obj.username,\n                    channel: obj.channel,\n                    workspace: obj.workspace,\n                    text: obj.text,\n                    iconEmoji: obj.iconEmoji,\n                    color: obj.color,\n                ) / 100)",
																		Start: ast.Position{
																			Column: 39,
																			Line:   53,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 45,
																				Line:   53,
																			},
																			File:   "slack.flux",
																			Source: "string",
																			Start: ast.Position{
																				Column: 39,
																				Line:   53,
																			},
																		},
																	},
																	Name: "string",
																},
															},
														}},
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 26,
																		Line:   53,
																	},
																	File:   "slack.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 25,
																		Line:   53,
																	},
																},
															},
															Name: "r",
														},
													},
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   62,
															},
															File:   "slack.flux",
															Source: "return {r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    username: obj.username,\n                    channel: obj.channel,\n                    workspace: obj.workspace,\n                    text: obj.text,\n                    iconEmoji: obj.iconEmoji,\n                    color: obj.color,\n                ) / 100)}",
															Start: ast.Position{
																Column: 17,
																Line:   53,
															},
														},
													},
												}},
											},
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   51,
														},
														File:   "slack.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   51,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   51,
															},
															File:   "slack.flux",
															Source: "r",
															Start: ast.Position{
																Column: 25,
																Line:   51,
															},
														},
													},
													Name: "r",
												},
												Value: nil,
											}},
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   63,
										},
										File:   "slack.flux",
										Source: "map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    username: obj.username,\n                    channel: obj.channel,\n                    workspace: obj.workspace,\n                    text: obj.text,\n                    iconEmoji: obj.iconEmoji,\n                    color: obj.color,\n                ) / 100)}\n            })",
										Start: ast.Position{
											Column: 16,
											Line:   51,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   51,
											},
											File:   "slack.flux",
											Source: "map",
											Start: ast.Position{
												Column: 16,
												Line:   51,
											},
										},
									},
									Name: "map",
								},
							},
						},
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   50,
									},
									File:   "slack.flux",
									Source: "tables=<-",
									Start: ast.Position{
										Column: 10,
										Line:   50,
									},
								},
							},
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   50,
										},
										File:   "slack.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 10,
											Line:   50,
										},
									},
								},
								Name: "tables",
							},
							Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   50,
									},
									File:   "slack.flux",
									Source: "<-",
									Start: ast.Position{
										Column: 17,
										Line:   50,
									},
								},
							}},
						}},
					},
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   49,
								},
								File:   "slack.flux",
								Source: "mapFn",
								Start: ast.Position{
									Column: 6,
									Line:   49,
								},
							},
						},
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   49,
									},
									File:   "slack.flux",
									Source: "mapFn",
									Start: ast.Position{
										Column: 6,
										Line:   49,
									},
								},
							},
							Name: "mapFn",
						},
						Value: nil,
					}},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   48,
							},
							File:   "slack.flux",
							Source: "url=defaultURL",
							Start: ast.Position{
								Column: 13,
								Line:   48,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   48,
								},
								File:   "slack.flux",
								Source: "url",
								Start: ast.Position{
									Column: 13,
									Line:   48,
								},
							},
						},
						Name: "url",
					},
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   48,
								},
								File:   "slack.flux",
								Source: "defaultURL",
								Start: ast.Position{
									Column: 17,
									Line:   48,
								},
							},
						},
						Name: "defaultURL",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   48,
							},
							File:   "slack.flux",
							Source: "token=\"\"",
							Start: ast.Position{
								Column: 29,
								Line:   48,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   48,
								},
								File:   "slack.flux",
								Source: "token",
								Start: ast.Position{
									Column: 29,
									Line:   48,
								},
							},
						},
						Name: "token",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   48,
								},
								File:   "slack.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 35,
									Line:   48,
								},
							},
						},
						Value: "",
					},
				}},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   3,
					},
					File:   "slack.flux",
					Source: "import \"http\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   3,
						},
						File:   "slack.flux",
						Source: "\"http\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "http",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "slack.flux",
					Source: "import \"json\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "slack.flux",
						Source: "\"json\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "json",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "slack.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   1,
					},
					File:   "slack.flux",
					Source: "package slack",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   1,
						},
						File:   "slack.flux",
						Source: "slack",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "slack",
			},
		},
	}},
	Package: "slack",
	Path:    "slack",
}
