// This file is generated by rust-protobuf 3.1.0. Do not edit
// .proto file is parsed by protoc --rust-out=...
// @generated

// https://github.com/rust-lang/rust-clippy/issues/702
#![allow(unknown_lints)]
#![allow(clippy::all)]

#![allow(unused_attributes)]
#![cfg_attr(rustfmt, rustfmt::skip)]

#![allow(box_pointers)]
#![allow(dead_code)]
#![allow(missing_docs)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![allow(non_upper_case_globals)]
#![allow(trivial_casts)]
#![allow(unused_results)]
#![allow(unused_mut)]

//! Generated file from `scip.proto`

/// Generated files are compatible only with the same version
/// of protobuf runtime.
const _PROTOBUF_VERSION_CHECK: () = ::protobuf::VERSION_3_1_0;

///  Index represents a complete SCIP index for a workspace this is rooted at a
///  single directory. An Index message payload can have a large memory footprint
///  and it's therefore recommended to emit and consume an Index payload one field
///  value at a time. To permit streaming consumption of an Index payload, the
///  `metadata` field must appear at the start of the stream and must only appear
///  once in the stream. Other field values may appear in any order.
#[derive(PartialEq,Clone,Default,Debug)]
// @@protoc_insertion_point(message:scip.Index)
pub struct Index {
    // message fields
    ///  Metadata about this index.
    // @@protoc_insertion_point(field:scip.Index.metadata)
    pub metadata: ::protobuf::MessageField<Metadata>,
    ///  Documents that belong to this index.
    // @@protoc_insertion_point(field:scip.Index.documents)
    pub documents: ::std::vec::Vec<Document>,
    ///  (optional) Symbols that are referenced from this index but are defined in
    ///  an external package (a separate `Index` message). Leave this field empty
    ///  if you assume the external package will get indexed separately. If the
    ///  external package won't get indexed for some reason then you can use this
    ///  field to provide hover documentation for those external symbols.
    // @@protoc_insertion_point(field:scip.Index.external_symbols)
    pub external_symbols: ::std::vec::Vec<SymbolInformation>,
    // special fields
    // @@protoc_insertion_point(special_field:scip.Index.special_fields)
    pub special_fields: ::protobuf::SpecialFields,
}

impl<'a> ::std::default::Default for &'a Index {
    fn default() -> &'a Index {
        <Index as ::protobuf::Message>::default_instance()
    }
}

impl Index {
    pub fn new() -> Index {
        ::std::default::Default::default()
    }

    fn generated_message_descriptor_data() -> ::protobuf::reflect::GeneratedMessageDescriptorData {
        let mut fields = ::std::vec::Vec::with_capacity(3);
        let mut oneofs = ::std::vec::Vec::with_capacity(0);
        fields.push(::protobuf::reflect::rt::v2::make_message_field_accessor::<_, Metadata>(
            "metadata",
            |m: &Index| { &m.metadata },
            |m: &mut Index| { &mut m.metadata },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_vec_simpler_accessor::<_, _>(
            "documents",
            |m: &Index| { &m.documents },
            |m: &mut Index| { &mut m.documents },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_vec_simpler_accessor::<_, _>(
            "external_symbols",
            |m: &Index| { &m.external_symbols },
            |m: &mut Index| { &mut m.external_symbols },
        ));
        ::protobuf::reflect::GeneratedMessageDescriptorData::new_2::<Index>(
            "Index",
            fields,
            oneofs,
        )
    }
}

impl ::protobuf::Message for Index {
    const NAME: &'static str = "Index";

    fn is_initialized(&self) -> bool {
        true
    }

    fn merge_from(&mut self, is: &mut ::protobuf::CodedInputStream<'_>) -> ::protobuf::Result<()> {
        while let Some(tag) = is.read_raw_tag_or_eof()? {
            match tag {
                10 => {
                    ::protobuf::rt::read_singular_message_into_field(is, &mut self.metadata)?;
                },
                18 => {
                    self.documents.push(is.read_message()?);
                },
                26 => {
                    self.external_symbols.push(is.read_message()?);
                },
                tag => {
                    ::protobuf::rt::read_unknown_or_skip_group(tag, is, self.special_fields.mut_unknown_fields())?;
                },
            };
        }
        ::std::result::Result::Ok(())
    }

    // Compute sizes of nested messages
    #[allow(unused_variables)]
    fn compute_size(&self) -> u64 {
        let mut my_size = 0;
        if let Some(v) = self.metadata.as_ref() {
            let len = v.compute_size();
            my_size += 1 + ::protobuf::rt::compute_raw_varint64_size(len) + len;
        }
        for value in &self.documents {
            let len = value.compute_size();
            my_size += 1 + ::protobuf::rt::compute_raw_varint64_size(len) + len;
        };
        for value in &self.external_symbols {
            let len = value.compute_size();
            my_size += 1 + ::protobuf::rt::compute_raw_varint64_size(len) + len;
        };
        my_size += ::protobuf::rt::unknown_fields_size(self.special_fields.unknown_fields());
        self.special_fields.cached_size().set(my_size as u32);
        my_size
    }

    fn write_to_with_cached_sizes(&self, os: &mut ::protobuf::CodedOutputStream<'_>) -> ::protobuf::Result<()> {
        if let Some(v) = self.metadata.as_ref() {
            ::protobuf::rt::write_message_field_with_cached_size(1, v, os)?;
        }
        for v in &self.documents {
            ::protobuf::rt::write_message_field_with_cached_size(2, v, os)?;
        };
        for v in &self.external_symbols {
            ::protobuf::rt::write_message_field_with_cached_size(3, v, os)?;
        };
        os.write_unknown_fields(self.special_fields.unknown_fields())?;
        ::std::result::Result::Ok(())
    }

    fn special_fields(&self) -> &::protobuf::SpecialFields {
        &self.special_fields
    }

    fn mut_special_fields(&mut self) -> &mut ::protobuf::SpecialFields {
        &mut self.special_fields
    }

    fn new() -> Index {
        Index::new()
    }

    fn clear(&mut self) {
        self.metadata.clear();
        self.documents.clear();
        self.external_symbols.clear();
        self.special_fields.clear();
    }

    fn default_instance() -> &'static Index {
        static instance: Index = Index {
            metadata: ::protobuf::MessageField::none(),
            documents: ::std::vec::Vec::new(),
            external_symbols: ::std::vec::Vec::new(),
            special_fields: ::protobuf::SpecialFields::new(),
        };
        &instance
    }
}

impl ::protobuf::MessageFull for Index {
    fn descriptor() -> ::protobuf::reflect::MessageDescriptor {
        static descriptor: ::protobuf::rt::Lazy<::protobuf::reflect::MessageDescriptor> = ::protobuf::rt::Lazy::new();
        descriptor.get(|| file_descriptor().message_by_package_relative_name("Index").unwrap()).clone()
    }
}

impl ::std::fmt::Display for Index {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::protobuf::text_format::fmt(self, f)
    }
}

impl ::protobuf::reflect::ProtobufValue for Index {
    type RuntimeType = ::protobuf::reflect::rt::RuntimeTypeMessage<Self>;
}

#[derive(PartialEq,Clone,Default,Debug)]
// @@protoc_insertion_point(message:scip.Metadata)
pub struct Metadata {
    // message fields
    ///  Which version of this protocol was used to generate this index?
    // @@protoc_insertion_point(field:scip.Metadata.version)
    pub version: ::protobuf::EnumOrUnknown<ProtocolVersion>,
    ///  Information about the tool that produced this index.
    // @@protoc_insertion_point(field:scip.Metadata.tool_info)
    pub tool_info: ::protobuf::MessageField<ToolInfo>,
    ///  URI-encoded absolute path to the root directory of this index. All
    ///  documents in this index must appear in a subdirectory of this root
    ///  directory.
    // @@protoc_insertion_point(field:scip.Metadata.project_root)
    pub project_root: ::std::string::String,
    ///  Text encoding of the source files on disk that are referenced from
    ///  `Document.relative_path`.
    // @@protoc_insertion_point(field:scip.Metadata.text_document_encoding)
    pub text_document_encoding: ::protobuf::EnumOrUnknown<TextEncoding>,
    // special fields
    // @@protoc_insertion_point(special_field:scip.Metadata.special_fields)
    pub special_fields: ::protobuf::SpecialFields,
}

impl<'a> ::std::default::Default for &'a Metadata {
    fn default() -> &'a Metadata {
        <Metadata as ::protobuf::Message>::default_instance()
    }
}

impl Metadata {
    pub fn new() -> Metadata {
        ::std::default::Default::default()
    }

    fn generated_message_descriptor_data() -> ::protobuf::reflect::GeneratedMessageDescriptorData {
        let mut fields = ::std::vec::Vec::with_capacity(4);
        let mut oneofs = ::std::vec::Vec::with_capacity(0);
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "version",
            |m: &Metadata| { &m.version },
            |m: &mut Metadata| { &mut m.version },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_message_field_accessor::<_, ToolInfo>(
            "tool_info",
            |m: &Metadata| { &m.tool_info },
            |m: &mut Metadata| { &mut m.tool_info },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "project_root",
            |m: &Metadata| { &m.project_root },
            |m: &mut Metadata| { &mut m.project_root },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "text_document_encoding",
            |m: &Metadata| { &m.text_document_encoding },
            |m: &mut Metadata| { &mut m.text_document_encoding },
        ));
        ::protobuf::reflect::GeneratedMessageDescriptorData::new_2::<Metadata>(
            "Metadata",
            fields,
            oneofs,
        )
    }
}

impl ::protobuf::Message for Metadata {
    const NAME: &'static str = "Metadata";

    fn is_initialized(&self) -> bool {
        true
    }

    fn merge_from(&mut self, is: &mut ::protobuf::CodedInputStream<'_>) -> ::protobuf::Result<()> {
        while let Some(tag) = is.read_raw_tag_or_eof()? {
            match tag {
                8 => {
                    self.version = is.read_enum_or_unknown()?;
                },
                18 => {
                    ::protobuf::rt::read_singular_message_into_field(is, &mut self.tool_info)?;
                },
                26 => {
                    self.project_root = is.read_string()?;
                },
                32 => {
                    self.text_document_encoding = is.read_enum_or_unknown()?;
                },
                tag => {
                    ::protobuf::rt::read_unknown_or_skip_group(tag, is, self.special_fields.mut_unknown_fields())?;
                },
            };
        }
        ::std::result::Result::Ok(())
    }

    // Compute sizes of nested messages
    #[allow(unused_variables)]
    fn compute_size(&self) -> u64 {
        let mut my_size = 0;
        if self.version != ::protobuf::EnumOrUnknown::new(ProtocolVersion::UnspecifiedProtocolVersion) {
            my_size += ::protobuf::rt::int32_size(1, self.version.value());
        }
        if let Some(v) = self.tool_info.as_ref() {
            let len = v.compute_size();
            my_size += 1 + ::protobuf::rt::compute_raw_varint64_size(len) + len;
        }
        if !self.project_root.is_empty() {
            my_size += ::protobuf::rt::string_size(3, &self.project_root);
        }
        if self.text_document_encoding != ::protobuf::EnumOrUnknown::new(TextEncoding::UnspecifiedTextEncoding) {
            my_size += ::protobuf::rt::int32_size(4, self.text_document_encoding.value());
        }
        my_size += ::protobuf::rt::unknown_fields_size(self.special_fields.unknown_fields());
        self.special_fields.cached_size().set(my_size as u32);
        my_size
    }

    fn write_to_with_cached_sizes(&self, os: &mut ::protobuf::CodedOutputStream<'_>) -> ::protobuf::Result<()> {
        if self.version != ::protobuf::EnumOrUnknown::new(ProtocolVersion::UnspecifiedProtocolVersion) {
            os.write_enum(1, ::protobuf::EnumOrUnknown::value(&self.version))?;
        }
        if let Some(v) = self.tool_info.as_ref() {
            ::protobuf::rt::write_message_field_with_cached_size(2, v, os)?;
        }
        if !self.project_root.is_empty() {
            os.write_string(3, &self.project_root)?;
        }
        if self.text_document_encoding != ::protobuf::EnumOrUnknown::new(TextEncoding::UnspecifiedTextEncoding) {
            os.write_enum(4, ::protobuf::EnumOrUnknown::value(&self.text_document_encoding))?;
        }
        os.write_unknown_fields(self.special_fields.unknown_fields())?;
        ::std::result::Result::Ok(())
    }

    fn special_fields(&self) -> &::protobuf::SpecialFields {
        &self.special_fields
    }

    fn mut_special_fields(&mut self) -> &mut ::protobuf::SpecialFields {
        &mut self.special_fields
    }

    fn new() -> Metadata {
        Metadata::new()
    }

    fn clear(&mut self) {
        self.version = ::protobuf::EnumOrUnknown::new(ProtocolVersion::UnspecifiedProtocolVersion);
        self.tool_info.clear();
        self.project_root.clear();
        self.text_document_encoding = ::protobuf::EnumOrUnknown::new(TextEncoding::UnspecifiedTextEncoding);
        self.special_fields.clear();
    }

    fn default_instance() -> &'static Metadata {
        static instance: Metadata = Metadata {
            version: ::protobuf::EnumOrUnknown::from_i32(0),
            tool_info: ::protobuf::MessageField::none(),
            project_root: ::std::string::String::new(),
            text_document_encoding: ::protobuf::EnumOrUnknown::from_i32(0),
            special_fields: ::protobuf::SpecialFields::new(),
        };
        &instance
    }
}

impl ::protobuf::MessageFull for Metadata {
    fn descriptor() -> ::protobuf::reflect::MessageDescriptor {
        static descriptor: ::protobuf::rt::Lazy<::protobuf::reflect::MessageDescriptor> = ::protobuf::rt::Lazy::new();
        descriptor.get(|| file_descriptor().message_by_package_relative_name("Metadata").unwrap()).clone()
    }
}

impl ::std::fmt::Display for Metadata {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::protobuf::text_format::fmt(self, f)
    }
}

impl ::protobuf::reflect::ProtobufValue for Metadata {
    type RuntimeType = ::protobuf::reflect::rt::RuntimeTypeMessage<Self>;
}

#[derive(PartialEq,Clone,Default,Debug)]
// @@protoc_insertion_point(message:scip.ToolInfo)
pub struct ToolInfo {
    // message fields
    ///  Name of the indexer that produced this index.
    // @@protoc_insertion_point(field:scip.ToolInfo.name)
    pub name: ::std::string::String,
    ///  Version of the indexer that produced this index.
    // @@protoc_insertion_point(field:scip.ToolInfo.version)
    pub version: ::std::string::String,
    ///  Command-line arguments that were used to invoke this indexer.
    // @@protoc_insertion_point(field:scip.ToolInfo.arguments)
    pub arguments: ::std::vec::Vec<::std::string::String>,
    // special fields
    // @@protoc_insertion_point(special_field:scip.ToolInfo.special_fields)
    pub special_fields: ::protobuf::SpecialFields,
}

impl<'a> ::std::default::Default for &'a ToolInfo {
    fn default() -> &'a ToolInfo {
        <ToolInfo as ::protobuf::Message>::default_instance()
    }
}

impl ToolInfo {
    pub fn new() -> ToolInfo {
        ::std::default::Default::default()
    }

    fn generated_message_descriptor_data() -> ::protobuf::reflect::GeneratedMessageDescriptorData {
        let mut fields = ::std::vec::Vec::with_capacity(3);
        let mut oneofs = ::std::vec::Vec::with_capacity(0);
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "name",
            |m: &ToolInfo| { &m.name },
            |m: &mut ToolInfo| { &mut m.name },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "version",
            |m: &ToolInfo| { &m.version },
            |m: &mut ToolInfo| { &mut m.version },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_vec_simpler_accessor::<_, _>(
            "arguments",
            |m: &ToolInfo| { &m.arguments },
            |m: &mut ToolInfo| { &mut m.arguments },
        ));
        ::protobuf::reflect::GeneratedMessageDescriptorData::new_2::<ToolInfo>(
            "ToolInfo",
            fields,
            oneofs,
        )
    }
}

impl ::protobuf::Message for ToolInfo {
    const NAME: &'static str = "ToolInfo";

    fn is_initialized(&self) -> bool {
        true
    }

    fn merge_from(&mut self, is: &mut ::protobuf::CodedInputStream<'_>) -> ::protobuf::Result<()> {
        while let Some(tag) = is.read_raw_tag_or_eof()? {
            match tag {
                10 => {
                    self.name = is.read_string()?;
                },
                18 => {
                    self.version = is.read_string()?;
                },
                26 => {
                    self.arguments.push(is.read_string()?);
                },
                tag => {
                    ::protobuf::rt::read_unknown_or_skip_group(tag, is, self.special_fields.mut_unknown_fields())?;
                },
            };
        }
        ::std::result::Result::Ok(())
    }

    // Compute sizes of nested messages
    #[allow(unused_variables)]
    fn compute_size(&self) -> u64 {
        let mut my_size = 0;
        if !self.name.is_empty() {
            my_size += ::protobuf::rt::string_size(1, &self.name);
        }
        if !self.version.is_empty() {
            my_size += ::protobuf::rt::string_size(2, &self.version);
        }
        for value in &self.arguments {
            my_size += ::protobuf::rt::string_size(3, &value);
        };
        my_size += ::protobuf::rt::unknown_fields_size(self.special_fields.unknown_fields());
        self.special_fields.cached_size().set(my_size as u32);
        my_size
    }

    fn write_to_with_cached_sizes(&self, os: &mut ::protobuf::CodedOutputStream<'_>) -> ::protobuf::Result<()> {
        if !self.name.is_empty() {
            os.write_string(1, &self.name)?;
        }
        if !self.version.is_empty() {
            os.write_string(2, &self.version)?;
        }
        for v in &self.arguments {
            os.write_string(3, &v)?;
        };
        os.write_unknown_fields(self.special_fields.unknown_fields())?;
        ::std::result::Result::Ok(())
    }

    fn special_fields(&self) -> &::protobuf::SpecialFields {
        &self.special_fields
    }

    fn mut_special_fields(&mut self) -> &mut ::protobuf::SpecialFields {
        &mut self.special_fields
    }

    fn new() -> ToolInfo {
        ToolInfo::new()
    }

    fn clear(&mut self) {
        self.name.clear();
        self.version.clear();
        self.arguments.clear();
        self.special_fields.clear();
    }

    fn default_instance() -> &'static ToolInfo {
        static instance: ToolInfo = ToolInfo {
            name: ::std::string::String::new(),
            version: ::std::string::String::new(),
            arguments: ::std::vec::Vec::new(),
            special_fields: ::protobuf::SpecialFields::new(),
        };
        &instance
    }
}

impl ::protobuf::MessageFull for ToolInfo {
    fn descriptor() -> ::protobuf::reflect::MessageDescriptor {
        static descriptor: ::protobuf::rt::Lazy<::protobuf::reflect::MessageDescriptor> = ::protobuf::rt::Lazy::new();
        descriptor.get(|| file_descriptor().message_by_package_relative_name("ToolInfo").unwrap()).clone()
    }
}

impl ::std::fmt::Display for ToolInfo {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::protobuf::text_format::fmt(self, f)
    }
}

impl ::protobuf::reflect::ProtobufValue for ToolInfo {
    type RuntimeType = ::protobuf::reflect::rt::RuntimeTypeMessage<Self>;
}

///  Document defines the metadata about a source file on disk.
#[derive(PartialEq,Clone,Default,Debug)]
// @@protoc_insertion_point(message:scip.Document)
pub struct Document {
    // message fields
    ///  The string ID for the programming language this file is written in.
    ///  The `Language` enum contains the names of most common programming languages.
    ///  This field is typed as a string to permit any programming langauge, including
    ///  ones that are not specified by the `Language` enum.
    // @@protoc_insertion_point(field:scip.Document.language)
    pub language: ::std::string::String,
    // @@protoc_insertion_point(field:scip.Document.relative_path)
    pub relative_path: ::std::string::String,
    ///  Occurrences that appear in this file.
    // @@protoc_insertion_point(field:scip.Document.occurrences)
    pub occurrences: ::std::vec::Vec<Occurrence>,
    ///  Symbols that are "defined" within this document.
    ///
    ///  This should include symbols which technically do not have any definition,
    ///  but have a reference and are defined by some other symbol (see
    ///  Relationship.is_definition).
    // @@protoc_insertion_point(field:scip.Document.symbols)
    pub symbols: ::std::vec::Vec<SymbolInformation>,
    // special fields
    // @@protoc_insertion_point(special_field:scip.Document.special_fields)
    pub special_fields: ::protobuf::SpecialFields,
}

impl<'a> ::std::default::Default for &'a Document {
    fn default() -> &'a Document {
        <Document as ::protobuf::Message>::default_instance()
    }
}

impl Document {
    pub fn new() -> Document {
        ::std::default::Default::default()
    }

    fn generated_message_descriptor_data() -> ::protobuf::reflect::GeneratedMessageDescriptorData {
        let mut fields = ::std::vec::Vec::with_capacity(4);
        let mut oneofs = ::std::vec::Vec::with_capacity(0);
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "language",
            |m: &Document| { &m.language },
            |m: &mut Document| { &mut m.language },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "relative_path",
            |m: &Document| { &m.relative_path },
            |m: &mut Document| { &mut m.relative_path },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_vec_simpler_accessor::<_, _>(
            "occurrences",
            |m: &Document| { &m.occurrences },
            |m: &mut Document| { &mut m.occurrences },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_vec_simpler_accessor::<_, _>(
            "symbols",
            |m: &Document| { &m.symbols },
            |m: &mut Document| { &mut m.symbols },
        ));
        ::protobuf::reflect::GeneratedMessageDescriptorData::new_2::<Document>(
            "Document",
            fields,
            oneofs,
        )
    }
}

impl ::protobuf::Message for Document {
    const NAME: &'static str = "Document";

    fn is_initialized(&self) -> bool {
        true
    }

    fn merge_from(&mut self, is: &mut ::protobuf::CodedInputStream<'_>) -> ::protobuf::Result<()> {
        while let Some(tag) = is.read_raw_tag_or_eof()? {
            match tag {
                34 => {
                    self.language = is.read_string()?;
                },
                10 => {
                    self.relative_path = is.read_string()?;
                },
                18 => {
                    self.occurrences.push(is.read_message()?);
                },
                26 => {
                    self.symbols.push(is.read_message()?);
                },
                tag => {
                    ::protobuf::rt::read_unknown_or_skip_group(tag, is, self.special_fields.mut_unknown_fields())?;
                },
            };
        }
        ::std::result::Result::Ok(())
    }

    // Compute sizes of nested messages
    #[allow(unused_variables)]
    fn compute_size(&self) -> u64 {
        let mut my_size = 0;
        if !self.language.is_empty() {
            my_size += ::protobuf::rt::string_size(4, &self.language);
        }
        if !self.relative_path.is_empty() {
            my_size += ::protobuf::rt::string_size(1, &self.relative_path);
        }
        for value in &self.occurrences {
            let len = value.compute_size();
            my_size += 1 + ::protobuf::rt::compute_raw_varint64_size(len) + len;
        };
        for value in &self.symbols {
            let len = value.compute_size();
            my_size += 1 + ::protobuf::rt::compute_raw_varint64_size(len) + len;
        };
        my_size += ::protobuf::rt::unknown_fields_size(self.special_fields.unknown_fields());
        self.special_fields.cached_size().set(my_size as u32);
        my_size
    }

    fn write_to_with_cached_sizes(&self, os: &mut ::protobuf::CodedOutputStream<'_>) -> ::protobuf::Result<()> {
        if !self.language.is_empty() {
            os.write_string(4, &self.language)?;
        }
        if !self.relative_path.is_empty() {
            os.write_string(1, &self.relative_path)?;
        }
        for v in &self.occurrences {
            ::protobuf::rt::write_message_field_with_cached_size(2, v, os)?;
        };
        for v in &self.symbols {
            ::protobuf::rt::write_message_field_with_cached_size(3, v, os)?;
        };
        os.write_unknown_fields(self.special_fields.unknown_fields())?;
        ::std::result::Result::Ok(())
    }

    fn special_fields(&self) -> &::protobuf::SpecialFields {
        &self.special_fields
    }

    fn mut_special_fields(&mut self) -> &mut ::protobuf::SpecialFields {
        &mut self.special_fields
    }

    fn new() -> Document {
        Document::new()
    }

    fn clear(&mut self) {
        self.language.clear();
        self.relative_path.clear();
        self.occurrences.clear();
        self.symbols.clear();
        self.special_fields.clear();
    }

    fn default_instance() -> &'static Document {
        static instance: Document = Document {
            language: ::std::string::String::new(),
            relative_path: ::std::string::String::new(),
            occurrences: ::std::vec::Vec::new(),
            symbols: ::std::vec::Vec::new(),
            special_fields: ::protobuf::SpecialFields::new(),
        };
        &instance
    }
}

impl ::protobuf::MessageFull for Document {
    fn descriptor() -> ::protobuf::reflect::MessageDescriptor {
        static descriptor: ::protobuf::rt::Lazy<::protobuf::reflect::MessageDescriptor> = ::protobuf::rt::Lazy::new();
        descriptor.get(|| file_descriptor().message_by_package_relative_name("Document").unwrap()).clone()
    }
}

impl ::std::fmt::Display for Document {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::protobuf::text_format::fmt(self, f)
    }
}

impl ::protobuf::reflect::ProtobufValue for Document {
    type RuntimeType = ::protobuf::reflect::rt::RuntimeTypeMessage<Self>;
}

///  Symbol is similar to a URI, it identifies a class, method, or a local
///  variable. `SymbolInformation` contains rich metadata about symbols such as
///  the docstring.
///
///  Symbol has a standardized string representation, which can be used
///  interchangeably with `Symbol`. The syntax for Symbol is the following:
///  ```
///  # (<x>)+ stands for one or more repetitions of <x>
///  <symbol>               ::= <scheme> ' ' <package> ' ' (<descriptor>)+ | 'local ' <local-id>
///  <package>              ::= <manager> ' ' <package-name> ' ' <version>
///  <scheme>               ::= any UTF-8, escape spaces with double space.
///  <manager>              ::= same as above, use the placeholder '.' to indicate an empty value
///  <package-name>         ::= same as above
///  <version>              ::= same as above
///  <descriptor>           ::= <namespace> | <type> | <term> | <method> | <type-parameter> | <parameter> | <meta>
///  <namespace>            ::= <name> '/'
///  <type>                 ::= <name> '#'
///  <term>                 ::= <name> '.'
///  <meta>                 ::= <name> ':'
///  <method>               ::= <name> '(' <method-disambiguator> ').'
///  <type-parameter>       ::= '[' <name> ']'
///  <parameter>            ::= '(' <name> ')'
///  <name>                 ::= <identifier>
///  <method-disambiguator> ::= <simple-identifier>
///  <identifier>           ::= <simple-identifier> | <escaped-identifier>
///  <simple-identifier>    ::= (<identifier-character>)+
///  <identifier-character> ::= '_' | '+' | '-' | '$' | ASCII letter or digit
///  <escaped-identifier>   ::= '`' (<escaped-character>)+ '`'
///  <escaped-characters>   ::= any UTF-8 character, escape backticks with double backtick.
///  ```
///
///  The list of descriptors for a symbol should together form a fully
///  qualified name for the symbol. That is, it should serve as a unique
///  identifier across the package. Typically, it will include one descriptor
///  for every node in the AST (along the ancestry path) between the root of
///  the file and the node corresponding to the symbol.
#[derive(PartialEq,Clone,Default,Debug)]
// @@protoc_insertion_point(message:scip.Symbol)
pub struct Symbol {
    // message fields
    // @@protoc_insertion_point(field:scip.Symbol.scheme)
    pub scheme: ::std::string::String,
    // @@protoc_insertion_point(field:scip.Symbol.package)
    pub package: ::protobuf::MessageField<Package>,
    // @@protoc_insertion_point(field:scip.Symbol.descriptors)
    pub descriptors: ::std::vec::Vec<Descriptor>,
    // special fields
    // @@protoc_insertion_point(special_field:scip.Symbol.special_fields)
    pub special_fields: ::protobuf::SpecialFields,
}

impl<'a> ::std::default::Default for &'a Symbol {
    fn default() -> &'a Symbol {
        <Symbol as ::protobuf::Message>::default_instance()
    }
}

impl Symbol {
    pub fn new() -> Symbol {
        ::std::default::Default::default()
    }

    fn generated_message_descriptor_data() -> ::protobuf::reflect::GeneratedMessageDescriptorData {
        let mut fields = ::std::vec::Vec::with_capacity(3);
        let mut oneofs = ::std::vec::Vec::with_capacity(0);
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "scheme",
            |m: &Symbol| { &m.scheme },
            |m: &mut Symbol| { &mut m.scheme },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_message_field_accessor::<_, Package>(
            "package",
            |m: &Symbol| { &m.package },
            |m: &mut Symbol| { &mut m.package },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_vec_simpler_accessor::<_, _>(
            "descriptors",
            |m: &Symbol| { &m.descriptors },
            |m: &mut Symbol| { &mut m.descriptors },
        ));
        ::protobuf::reflect::GeneratedMessageDescriptorData::new_2::<Symbol>(
            "Symbol",
            fields,
            oneofs,
        )
    }
}

impl ::protobuf::Message for Symbol {
    const NAME: &'static str = "Symbol";

    fn is_initialized(&self) -> bool {
        true
    }

    fn merge_from(&mut self, is: &mut ::protobuf::CodedInputStream<'_>) -> ::protobuf::Result<()> {
        while let Some(tag) = is.read_raw_tag_or_eof()? {
            match tag {
                10 => {
                    self.scheme = is.read_string()?;
                },
                18 => {
                    ::protobuf::rt::read_singular_message_into_field(is, &mut self.package)?;
                },
                26 => {
                    self.descriptors.push(is.read_message()?);
                },
                tag => {
                    ::protobuf::rt::read_unknown_or_skip_group(tag, is, self.special_fields.mut_unknown_fields())?;
                },
            };
        }
        ::std::result::Result::Ok(())
    }

    // Compute sizes of nested messages
    #[allow(unused_variables)]
    fn compute_size(&self) -> u64 {
        let mut my_size = 0;
        if !self.scheme.is_empty() {
            my_size += ::protobuf::rt::string_size(1, &self.scheme);
        }
        if let Some(v) = self.package.as_ref() {
            let len = v.compute_size();
            my_size += 1 + ::protobuf::rt::compute_raw_varint64_size(len) + len;
        }
        for value in &self.descriptors {
            let len = value.compute_size();
            my_size += 1 + ::protobuf::rt::compute_raw_varint64_size(len) + len;
        };
        my_size += ::protobuf::rt::unknown_fields_size(self.special_fields.unknown_fields());
        self.special_fields.cached_size().set(my_size as u32);
        my_size
    }

    fn write_to_with_cached_sizes(&self, os: &mut ::protobuf::CodedOutputStream<'_>) -> ::protobuf::Result<()> {
        if !self.scheme.is_empty() {
            os.write_string(1, &self.scheme)?;
        }
        if let Some(v) = self.package.as_ref() {
            ::protobuf::rt::write_message_field_with_cached_size(2, v, os)?;
        }
        for v in &self.descriptors {
            ::protobuf::rt::write_message_field_with_cached_size(3, v, os)?;
        };
        os.write_unknown_fields(self.special_fields.unknown_fields())?;
        ::std::result::Result::Ok(())
    }

    fn special_fields(&self) -> &::protobuf::SpecialFields {
        &self.special_fields
    }

    fn mut_special_fields(&mut self) -> &mut ::protobuf::SpecialFields {
        &mut self.special_fields
    }

    fn new() -> Symbol {
        Symbol::new()
    }

    fn clear(&mut self) {
        self.scheme.clear();
        self.package.clear();
        self.descriptors.clear();
        self.special_fields.clear();
    }

    fn default_instance() -> &'static Symbol {
        static instance: Symbol = Symbol {
            scheme: ::std::string::String::new(),
            package: ::protobuf::MessageField::none(),
            descriptors: ::std::vec::Vec::new(),
            special_fields: ::protobuf::SpecialFields::new(),
        };
        &instance
    }
}

impl ::protobuf::MessageFull for Symbol {
    fn descriptor() -> ::protobuf::reflect::MessageDescriptor {
        static descriptor: ::protobuf::rt::Lazy<::protobuf::reflect::MessageDescriptor> = ::protobuf::rt::Lazy::new();
        descriptor.get(|| file_descriptor().message_by_package_relative_name("Symbol").unwrap()).clone()
    }
}

impl ::std::fmt::Display for Symbol {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::protobuf::text_format::fmt(self, f)
    }
}

impl ::protobuf::reflect::ProtobufValue for Symbol {
    type RuntimeType = ::protobuf::reflect::rt::RuntimeTypeMessage<Self>;
}

///  Unit of packaging and distribution.
///
///  NOTE: This corresponds to a module in Go and JVM languages.
#[derive(PartialEq,Clone,Default,Debug)]
// @@protoc_insertion_point(message:scip.Package)
pub struct Package {
    // message fields
    // @@protoc_insertion_point(field:scip.Package.manager)
    pub manager: ::std::string::String,
    // @@protoc_insertion_point(field:scip.Package.name)
    pub name: ::std::string::String,
    // @@protoc_insertion_point(field:scip.Package.version)
    pub version: ::std::string::String,
    // special fields
    // @@protoc_insertion_point(special_field:scip.Package.special_fields)
    pub special_fields: ::protobuf::SpecialFields,
}

impl<'a> ::std::default::Default for &'a Package {
    fn default() -> &'a Package {
        <Package as ::protobuf::Message>::default_instance()
    }
}

impl Package {
    pub fn new() -> Package {
        ::std::default::Default::default()
    }

    fn generated_message_descriptor_data() -> ::protobuf::reflect::GeneratedMessageDescriptorData {
        let mut fields = ::std::vec::Vec::with_capacity(3);
        let mut oneofs = ::std::vec::Vec::with_capacity(0);
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "manager",
            |m: &Package| { &m.manager },
            |m: &mut Package| { &mut m.manager },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "name",
            |m: &Package| { &m.name },
            |m: &mut Package| { &mut m.name },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "version",
            |m: &Package| { &m.version },
            |m: &mut Package| { &mut m.version },
        ));
        ::protobuf::reflect::GeneratedMessageDescriptorData::new_2::<Package>(
            "Package",
            fields,
            oneofs,
        )
    }
}

impl ::protobuf::Message for Package {
    const NAME: &'static str = "Package";

    fn is_initialized(&self) -> bool {
        true
    }

    fn merge_from(&mut self, is: &mut ::protobuf::CodedInputStream<'_>) -> ::protobuf::Result<()> {
        while let Some(tag) = is.read_raw_tag_or_eof()? {
            match tag {
                10 => {
                    self.manager = is.read_string()?;
                },
                18 => {
                    self.name = is.read_string()?;
                },
                26 => {
                    self.version = is.read_string()?;
                },
                tag => {
                    ::protobuf::rt::read_unknown_or_skip_group(tag, is, self.special_fields.mut_unknown_fields())?;
                },
            };
        }
        ::std::result::Result::Ok(())
    }

    // Compute sizes of nested messages
    #[allow(unused_variables)]
    fn compute_size(&self) -> u64 {
        let mut my_size = 0;
        if !self.manager.is_empty() {
            my_size += ::protobuf::rt::string_size(1, &self.manager);
        }
        if !self.name.is_empty() {
            my_size += ::protobuf::rt::string_size(2, &self.name);
        }
        if !self.version.is_empty() {
            my_size += ::protobuf::rt::string_size(3, &self.version);
        }
        my_size += ::protobuf::rt::unknown_fields_size(self.special_fields.unknown_fields());
        self.special_fields.cached_size().set(my_size as u32);
        my_size
    }

    fn write_to_with_cached_sizes(&self, os: &mut ::protobuf::CodedOutputStream<'_>) -> ::protobuf::Result<()> {
        if !self.manager.is_empty() {
            os.write_string(1, &self.manager)?;
        }
        if !self.name.is_empty() {
            os.write_string(2, &self.name)?;
        }
        if !self.version.is_empty() {
            os.write_string(3, &self.version)?;
        }
        os.write_unknown_fields(self.special_fields.unknown_fields())?;
        ::std::result::Result::Ok(())
    }

    fn special_fields(&self) -> &::protobuf::SpecialFields {
        &self.special_fields
    }

    fn mut_special_fields(&mut self) -> &mut ::protobuf::SpecialFields {
        &mut self.special_fields
    }

    fn new() -> Package {
        Package::new()
    }

    fn clear(&mut self) {
        self.manager.clear();
        self.name.clear();
        self.version.clear();
        self.special_fields.clear();
    }

    fn default_instance() -> &'static Package {
        static instance: Package = Package {
            manager: ::std::string::String::new(),
            name: ::std::string::String::new(),
            version: ::std::string::String::new(),
            special_fields: ::protobuf::SpecialFields::new(),
        };
        &instance
    }
}

impl ::protobuf::MessageFull for Package {
    fn descriptor() -> ::protobuf::reflect::MessageDescriptor {
        static descriptor: ::protobuf::rt::Lazy<::protobuf::reflect::MessageDescriptor> = ::protobuf::rt::Lazy::new();
        descriptor.get(|| file_descriptor().message_by_package_relative_name("Package").unwrap()).clone()
    }
}

impl ::std::fmt::Display for Package {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::protobuf::text_format::fmt(self, f)
    }
}

impl ::protobuf::reflect::ProtobufValue for Package {
    type RuntimeType = ::protobuf::reflect::rt::RuntimeTypeMessage<Self>;
}

#[derive(PartialEq,Clone,Default,Debug)]
// @@protoc_insertion_point(message:scip.Descriptor)
pub struct Descriptor {
    // message fields
    // @@protoc_insertion_point(field:scip.Descriptor.name)
    pub name: ::std::string::String,
    // @@protoc_insertion_point(field:scip.Descriptor.disambiguator)
    pub disambiguator: ::std::string::String,
    // @@protoc_insertion_point(field:scip.Descriptor.suffix)
    pub suffix: ::protobuf::EnumOrUnknown<descriptor::Suffix>,
    // special fields
    // @@protoc_insertion_point(special_field:scip.Descriptor.special_fields)
    pub special_fields: ::protobuf::SpecialFields,
}

impl<'a> ::std::default::Default for &'a Descriptor {
    fn default() -> &'a Descriptor {
        <Descriptor as ::protobuf::Message>::default_instance()
    }
}

impl Descriptor {
    pub fn new() -> Descriptor {
        ::std::default::Default::default()
    }

    fn generated_message_descriptor_data() -> ::protobuf::reflect::GeneratedMessageDescriptorData {
        let mut fields = ::std::vec::Vec::with_capacity(3);
        let mut oneofs = ::std::vec::Vec::with_capacity(0);
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "name",
            |m: &Descriptor| { &m.name },
            |m: &mut Descriptor| { &mut m.name },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "disambiguator",
            |m: &Descriptor| { &m.disambiguator },
            |m: &mut Descriptor| { &mut m.disambiguator },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "suffix",
            |m: &Descriptor| { &m.suffix },
            |m: &mut Descriptor| { &mut m.suffix },
        ));
        ::protobuf::reflect::GeneratedMessageDescriptorData::new_2::<Descriptor>(
            "Descriptor",
            fields,
            oneofs,
        )
    }
}

impl ::protobuf::Message for Descriptor {
    const NAME: &'static str = "Descriptor";

    fn is_initialized(&self) -> bool {
        true
    }

    fn merge_from(&mut self, is: &mut ::protobuf::CodedInputStream<'_>) -> ::protobuf::Result<()> {
        while let Some(tag) = is.read_raw_tag_or_eof()? {
            match tag {
                10 => {
                    self.name = is.read_string()?;
                },
                18 => {
                    self.disambiguator = is.read_string()?;
                },
                24 => {
                    self.suffix = is.read_enum_or_unknown()?;
                },
                tag => {
                    ::protobuf::rt::read_unknown_or_skip_group(tag, is, self.special_fields.mut_unknown_fields())?;
                },
            };
        }
        ::std::result::Result::Ok(())
    }

    // Compute sizes of nested messages
    #[allow(unused_variables)]
    fn compute_size(&self) -> u64 {
        let mut my_size = 0;
        if !self.name.is_empty() {
            my_size += ::protobuf::rt::string_size(1, &self.name);
        }
        if !self.disambiguator.is_empty() {
            my_size += ::protobuf::rt::string_size(2, &self.disambiguator);
        }
        if self.suffix != ::protobuf::EnumOrUnknown::new(descriptor::Suffix::UnspecifiedSuffix) {
            my_size += ::protobuf::rt::int32_size(3, self.suffix.value());
        }
        my_size += ::protobuf::rt::unknown_fields_size(self.special_fields.unknown_fields());
        self.special_fields.cached_size().set(my_size as u32);
        my_size
    }

    fn write_to_with_cached_sizes(&self, os: &mut ::protobuf::CodedOutputStream<'_>) -> ::protobuf::Result<()> {
        if !self.name.is_empty() {
            os.write_string(1, &self.name)?;
        }
        if !self.disambiguator.is_empty() {
            os.write_string(2, &self.disambiguator)?;
        }
        if self.suffix != ::protobuf::EnumOrUnknown::new(descriptor::Suffix::UnspecifiedSuffix) {
            os.write_enum(3, ::protobuf::EnumOrUnknown::value(&self.suffix))?;
        }
        os.write_unknown_fields(self.special_fields.unknown_fields())?;
        ::std::result::Result::Ok(())
    }

    fn special_fields(&self) -> &::protobuf::SpecialFields {
        &self.special_fields
    }

    fn mut_special_fields(&mut self) -> &mut ::protobuf::SpecialFields {
        &mut self.special_fields
    }

    fn new() -> Descriptor {
        Descriptor::new()
    }

    fn clear(&mut self) {
        self.name.clear();
        self.disambiguator.clear();
        self.suffix = ::protobuf::EnumOrUnknown::new(descriptor::Suffix::UnspecifiedSuffix);
        self.special_fields.clear();
    }

    fn default_instance() -> &'static Descriptor {
        static instance: Descriptor = Descriptor {
            name: ::std::string::String::new(),
            disambiguator: ::std::string::String::new(),
            suffix: ::protobuf::EnumOrUnknown::from_i32(0),
            special_fields: ::protobuf::SpecialFields::new(),
        };
        &instance
    }
}

impl ::protobuf::MessageFull for Descriptor {
    fn descriptor() -> ::protobuf::reflect::MessageDescriptor {
        static descriptor: ::protobuf::rt::Lazy<::protobuf::reflect::MessageDescriptor> = ::protobuf::rt::Lazy::new();
        descriptor.get(|| file_descriptor().message_by_package_relative_name("Descriptor").unwrap()).clone()
    }
}

impl ::std::fmt::Display for Descriptor {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::protobuf::text_format::fmt(self, f)
    }
}

impl ::protobuf::reflect::ProtobufValue for Descriptor {
    type RuntimeType = ::protobuf::reflect::rt::RuntimeTypeMessage<Self>;
}

/// Nested message and enums of message `Descriptor`
pub mod descriptor {
    // Note: you cannot use pattern matching for enums with allow_alias option
    #[derive(Clone,Copy,Eq,Debug)]
    // @@protoc_insertion_point(enum:scip.Descriptor.Suffix)
    pub enum Suffix {
        // @@protoc_insertion_point(enum_value:scip.Descriptor.Suffix.UnspecifiedSuffix)
        UnspecifiedSuffix, // 0
        // @@protoc_insertion_point(enum_value:scip.Descriptor.Suffix.Namespace)
        Namespace, // 1
        // @@protoc_insertion_point(enum_value:scip.Descriptor.Suffix.Package)
        Package, // 1
        // @@protoc_insertion_point(enum_value:scip.Descriptor.Suffix.Type)
        Type, // 2
        // @@protoc_insertion_point(enum_value:scip.Descriptor.Suffix.Term)
        Term, // 3
        // @@protoc_insertion_point(enum_value:scip.Descriptor.Suffix.Method)
        Method, // 4
        // @@protoc_insertion_point(enum_value:scip.Descriptor.Suffix.TypeParameter)
        TypeParameter, // 5
        // @@protoc_insertion_point(enum_value:scip.Descriptor.Suffix.Parameter)
        Parameter, // 6
        // @@protoc_insertion_point(enum_value:scip.Descriptor.Suffix.Macro)
        Macro, // 9
        // @@protoc_insertion_point(enum_value:scip.Descriptor.Suffix.Meta)
        Meta, // 7
        // @@protoc_insertion_point(enum_value:scip.Descriptor.Suffix.Local)
        Local, // 8
    }

    impl ::std::cmp::PartialEq for Suffix {
        fn eq(&self, other: &Self) -> bool {
            ::protobuf::Enum::value(self) == ::protobuf::Enum::value(other)
        }
    }

    impl ::std::hash::Hash for Suffix {
        fn hash<H : ::std::hash::Hasher>(&self, state: &mut H) {
            state.write_i32(::protobuf::Enum::value(self))
        }
    }

    impl ::protobuf::Enum for Suffix {
        const NAME: &'static str = "Suffix";

        fn value(&self) -> i32 {
            match *self {
                Suffix::UnspecifiedSuffix => 0,
                Suffix::Namespace => 1,
                Suffix::Package => 1,
                Suffix::Type => 2,
                Suffix::Term => 3,
                Suffix::Method => 4,
                Suffix::TypeParameter => 5,
                Suffix::Parameter => 6,
                Suffix::Macro => 9,
                Suffix::Meta => 7,
                Suffix::Local => 8,
            }
        }

        fn from_i32(value: i32) -> ::std::option::Option<Suffix> {
            match value {
                0 => ::std::option::Option::Some(Suffix::UnspecifiedSuffix),
                1 => ::std::option::Option::Some(Suffix::Namespace),
                2 => ::std::option::Option::Some(Suffix::Type),
                3 => ::std::option::Option::Some(Suffix::Term),
                4 => ::std::option::Option::Some(Suffix::Method),
                5 => ::std::option::Option::Some(Suffix::TypeParameter),
                6 => ::std::option::Option::Some(Suffix::Parameter),
                9 => ::std::option::Option::Some(Suffix::Macro),
                7 => ::std::option::Option::Some(Suffix::Meta),
                8 => ::std::option::Option::Some(Suffix::Local),
                _ => ::std::option::Option::None
            }
        }

        const VALUES: &'static [Suffix] = &[
            Suffix::UnspecifiedSuffix,
            Suffix::Namespace,
            Suffix::Package,
            Suffix::Type,
            Suffix::Term,
            Suffix::Method,
            Suffix::TypeParameter,
            Suffix::Parameter,
            Suffix::Macro,
            Suffix::Meta,
            Suffix::Local,
        ];
    }

    impl ::protobuf::EnumFull for Suffix {
        fn enum_descriptor() -> ::protobuf::reflect::EnumDescriptor {
            static descriptor: ::protobuf::rt::Lazy<::protobuf::reflect::EnumDescriptor> = ::protobuf::rt::Lazy::new();
            descriptor.get(|| super::file_descriptor().enum_by_package_relative_name("Descriptor.Suffix").unwrap()).clone()
        }

        fn descriptor(&self) -> ::protobuf::reflect::EnumValueDescriptor {
            let index = match self {
                Suffix::UnspecifiedSuffix => 0,
                Suffix::Namespace => 1,
                Suffix::Package => 2,
                Suffix::Type => 3,
                Suffix::Term => 4,
                Suffix::Method => 5,
                Suffix::TypeParameter => 6,
                Suffix::Parameter => 7,
                Suffix::Macro => 8,
                Suffix::Meta => 9,
                Suffix::Local => 10,
            };
            Self::enum_descriptor().value_by_index(index)
        }
    }

    impl ::std::default::Default for Suffix {
        fn default() -> Self {
            Suffix::UnspecifiedSuffix
        }
    }

    impl Suffix {
        pub(in super) fn generated_enum_descriptor_data() -> ::protobuf::reflect::GeneratedEnumDescriptorData {
            ::protobuf::reflect::GeneratedEnumDescriptorData::new::<Suffix>("Descriptor.Suffix")
        }
    }
}

///  SymbolInformation defines metadata about a symbol, such as the symbol's
///  docstring or what package it's defined it.
#[derive(PartialEq,Clone,Default,Debug)]
// @@protoc_insertion_point(message:scip.SymbolInformation)
pub struct SymbolInformation {
    // message fields
    ///  Identifier of this symbol, which can be referenced from `Occurence.symbol`.
    ///  The string must be formatted according to the grammar in `Symbol`.
    // @@protoc_insertion_point(field:scip.SymbolInformation.symbol)
    pub symbol: ::std::string::String,
    ///  (optional, but strongly recommended) The markdown-formatted documentation
    ///  for this symbol. This field is repeated to allow different kinds of
    ///  documentation.  For example, it's nice to include both the signature of a
    ///  method (parameters and return type) along with the accompanying docstring.
    // @@protoc_insertion_point(field:scip.SymbolInformation.documentation)
    pub documentation: ::std::vec::Vec<::std::string::String>,
    ///  (optional) Relationships to other symbols (e.g., implements, type definition).
    // @@protoc_insertion_point(field:scip.SymbolInformation.relationships)
    pub relationships: ::std::vec::Vec<Relationship>,
    // special fields
    // @@protoc_insertion_point(special_field:scip.SymbolInformation.special_fields)
    pub special_fields: ::protobuf::SpecialFields,
}

impl<'a> ::std::default::Default for &'a SymbolInformation {
    fn default() -> &'a SymbolInformation {
        <SymbolInformation as ::protobuf::Message>::default_instance()
    }
}

impl SymbolInformation {
    pub fn new() -> SymbolInformation {
        ::std::default::Default::default()
    }

    fn generated_message_descriptor_data() -> ::protobuf::reflect::GeneratedMessageDescriptorData {
        let mut fields = ::std::vec::Vec::with_capacity(3);
        let mut oneofs = ::std::vec::Vec::with_capacity(0);
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "symbol",
            |m: &SymbolInformation| { &m.symbol },
            |m: &mut SymbolInformation| { &mut m.symbol },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_vec_simpler_accessor::<_, _>(
            "documentation",
            |m: &SymbolInformation| { &m.documentation },
            |m: &mut SymbolInformation| { &mut m.documentation },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_vec_simpler_accessor::<_, _>(
            "relationships",
            |m: &SymbolInformation| { &m.relationships },
            |m: &mut SymbolInformation| { &mut m.relationships },
        ));
        ::protobuf::reflect::GeneratedMessageDescriptorData::new_2::<SymbolInformation>(
            "SymbolInformation",
            fields,
            oneofs,
        )
    }
}

impl ::protobuf::Message for SymbolInformation {
    const NAME: &'static str = "SymbolInformation";

    fn is_initialized(&self) -> bool {
        true
    }

    fn merge_from(&mut self, is: &mut ::protobuf::CodedInputStream<'_>) -> ::protobuf::Result<()> {
        while let Some(tag) = is.read_raw_tag_or_eof()? {
            match tag {
                10 => {
                    self.symbol = is.read_string()?;
                },
                26 => {
                    self.documentation.push(is.read_string()?);
                },
                34 => {
                    self.relationships.push(is.read_message()?);
                },
                tag => {
                    ::protobuf::rt::read_unknown_or_skip_group(tag, is, self.special_fields.mut_unknown_fields())?;
                },
            };
        }
        ::std::result::Result::Ok(())
    }

    // Compute sizes of nested messages
    #[allow(unused_variables)]
    fn compute_size(&self) -> u64 {
        let mut my_size = 0;
        if !self.symbol.is_empty() {
            my_size += ::protobuf::rt::string_size(1, &self.symbol);
        }
        for value in &self.documentation {
            my_size += ::protobuf::rt::string_size(3, &value);
        };
        for value in &self.relationships {
            let len = value.compute_size();
            my_size += 1 + ::protobuf::rt::compute_raw_varint64_size(len) + len;
        };
        my_size += ::protobuf::rt::unknown_fields_size(self.special_fields.unknown_fields());
        self.special_fields.cached_size().set(my_size as u32);
        my_size
    }

    fn write_to_with_cached_sizes(&self, os: &mut ::protobuf::CodedOutputStream<'_>) -> ::protobuf::Result<()> {
        if !self.symbol.is_empty() {
            os.write_string(1, &self.symbol)?;
        }
        for v in &self.documentation {
            os.write_string(3, &v)?;
        };
        for v in &self.relationships {
            ::protobuf::rt::write_message_field_with_cached_size(4, v, os)?;
        };
        os.write_unknown_fields(self.special_fields.unknown_fields())?;
        ::std::result::Result::Ok(())
    }

    fn special_fields(&self) -> &::protobuf::SpecialFields {
        &self.special_fields
    }

    fn mut_special_fields(&mut self) -> &mut ::protobuf::SpecialFields {
        &mut self.special_fields
    }

    fn new() -> SymbolInformation {
        SymbolInformation::new()
    }

    fn clear(&mut self) {
        self.symbol.clear();
        self.documentation.clear();
        self.relationships.clear();
        self.special_fields.clear();
    }

    fn default_instance() -> &'static SymbolInformation {
        static instance: SymbolInformation = SymbolInformation {
            symbol: ::std::string::String::new(),
            documentation: ::std::vec::Vec::new(),
            relationships: ::std::vec::Vec::new(),
            special_fields: ::protobuf::SpecialFields::new(),
        };
        &instance
    }
}

impl ::protobuf::MessageFull for SymbolInformation {
    fn descriptor() -> ::protobuf::reflect::MessageDescriptor {
        static descriptor: ::protobuf::rt::Lazy<::protobuf::reflect::MessageDescriptor> = ::protobuf::rt::Lazy::new();
        descriptor.get(|| file_descriptor().message_by_package_relative_name("SymbolInformation").unwrap()).clone()
    }
}

impl ::std::fmt::Display for SymbolInformation {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::protobuf::text_format::fmt(self, f)
    }
}

impl ::protobuf::reflect::ProtobufValue for SymbolInformation {
    type RuntimeType = ::protobuf::reflect::rt::RuntimeTypeMessage<Self>;
}

#[derive(PartialEq,Clone,Default,Debug)]
// @@protoc_insertion_point(message:scip.Relationship)
pub struct Relationship {
    // message fields
    // @@protoc_insertion_point(field:scip.Relationship.symbol)
    pub symbol: ::std::string::String,
    // @@protoc_insertion_point(field:scip.Relationship.is_reference)
    pub is_reference: bool,
    ///  Similar to `references_symbols` but for "Go to implementation".
    ///  It's common for the `implementation_symbols` and `references_symbols` fields
    ///  have the same values but that's not always the case.
    ///  In the TypeScript example above, observe that `implementation_symbols` has
    ///  the value `"Animal#"` for the "Dog#" symbol while `references_symbols` is
    ///  empty. When requesting "Find references" on the "Animal#" symbol we don't
    ///  want to include references to "Dog#" even if "Go to implementation" on the
    ///  "Animal#" symbol should navigate to the "Dog#" symbol.
    // @@protoc_insertion_point(field:scip.Relationship.is_implementation)
    pub is_implementation: bool,
    ///  Similar to `references_symbols` but for "Go to type definition".
    // @@protoc_insertion_point(field:scip.Relationship.is_type_definition)
    pub is_type_definition: bool,
    ///  Allows overriding the behavior of "Go to definition" and "Find references"
    ///  for symbols which do not have a definition of their own or could
    ///  potentially have multiple definitions.
    ///
    ///  For example, in a language with single inheritance and no field overriding,
    ///  inherited fields can reuse the same symbol as the ancestor which declares
    ///  the field. In such a situation, is_definition is not needed.
    ///
    ///  On the other hand, in languages with single inheritance and some form
    ///  of mixins, you can use is_definition to relate the symbol to the
    ///  matching symbol in ancestor classes, and is_reference to relate the
    ///  symbol to the matching symbol in mixins.
    ///
    ///  NOTE: At the moment, due to limitations of the SCIP to LSIF conversion,
    ///  only global symbols in an index are allowed to use is_definition.
    ///  The relationship may not get recorded if either symbol is local.
    // @@protoc_insertion_point(field:scip.Relationship.is_definition)
    pub is_definition: bool,
    // special fields
    // @@protoc_insertion_point(special_field:scip.Relationship.special_fields)
    pub special_fields: ::protobuf::SpecialFields,
}

impl<'a> ::std::default::Default for &'a Relationship {
    fn default() -> &'a Relationship {
        <Relationship as ::protobuf::Message>::default_instance()
    }
}

impl Relationship {
    pub fn new() -> Relationship {
        ::std::default::Default::default()
    }

    fn generated_message_descriptor_data() -> ::protobuf::reflect::GeneratedMessageDescriptorData {
        let mut fields = ::std::vec::Vec::with_capacity(5);
        let mut oneofs = ::std::vec::Vec::with_capacity(0);
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "symbol",
            |m: &Relationship| { &m.symbol },
            |m: &mut Relationship| { &mut m.symbol },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "is_reference",
            |m: &Relationship| { &m.is_reference },
            |m: &mut Relationship| { &mut m.is_reference },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "is_implementation",
            |m: &Relationship| { &m.is_implementation },
            |m: &mut Relationship| { &mut m.is_implementation },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "is_type_definition",
            |m: &Relationship| { &m.is_type_definition },
            |m: &mut Relationship| { &mut m.is_type_definition },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "is_definition",
            |m: &Relationship| { &m.is_definition },
            |m: &mut Relationship| { &mut m.is_definition },
        ));
        ::protobuf::reflect::GeneratedMessageDescriptorData::new_2::<Relationship>(
            "Relationship",
            fields,
            oneofs,
        )
    }
}

impl ::protobuf::Message for Relationship {
    const NAME: &'static str = "Relationship";

    fn is_initialized(&self) -> bool {
        true
    }

    fn merge_from(&mut self, is: &mut ::protobuf::CodedInputStream<'_>) -> ::protobuf::Result<()> {
        while let Some(tag) = is.read_raw_tag_or_eof()? {
            match tag {
                10 => {
                    self.symbol = is.read_string()?;
                },
                16 => {
                    self.is_reference = is.read_bool()?;
                },
                24 => {
                    self.is_implementation = is.read_bool()?;
                },
                32 => {
                    self.is_type_definition = is.read_bool()?;
                },
                40 => {
                    self.is_definition = is.read_bool()?;
                },
                tag => {
                    ::protobuf::rt::read_unknown_or_skip_group(tag, is, self.special_fields.mut_unknown_fields())?;
                },
            };
        }
        ::std::result::Result::Ok(())
    }

    // Compute sizes of nested messages
    #[allow(unused_variables)]
    fn compute_size(&self) -> u64 {
        let mut my_size = 0;
        if !self.symbol.is_empty() {
            my_size += ::protobuf::rt::string_size(1, &self.symbol);
        }
        if self.is_reference != false {
            my_size += 1 + 1;
        }
        if self.is_implementation != false {
            my_size += 1 + 1;
        }
        if self.is_type_definition != false {
            my_size += 1 + 1;
        }
        if self.is_definition != false {
            my_size += 1 + 1;
        }
        my_size += ::protobuf::rt::unknown_fields_size(self.special_fields.unknown_fields());
        self.special_fields.cached_size().set(my_size as u32);
        my_size
    }

    fn write_to_with_cached_sizes(&self, os: &mut ::protobuf::CodedOutputStream<'_>) -> ::protobuf::Result<()> {
        if !self.symbol.is_empty() {
            os.write_string(1, &self.symbol)?;
        }
        if self.is_reference != false {
            os.write_bool(2, self.is_reference)?;
        }
        if self.is_implementation != false {
            os.write_bool(3, self.is_implementation)?;
        }
        if self.is_type_definition != false {
            os.write_bool(4, self.is_type_definition)?;
        }
        if self.is_definition != false {
            os.write_bool(5, self.is_definition)?;
        }
        os.write_unknown_fields(self.special_fields.unknown_fields())?;
        ::std::result::Result::Ok(())
    }

    fn special_fields(&self) -> &::protobuf::SpecialFields {
        &self.special_fields
    }

    fn mut_special_fields(&mut self) -> &mut ::protobuf::SpecialFields {
        &mut self.special_fields
    }

    fn new() -> Relationship {
        Relationship::new()
    }

    fn clear(&mut self) {
        self.symbol.clear();
        self.is_reference = false;
        self.is_implementation = false;
        self.is_type_definition = false;
        self.is_definition = false;
        self.special_fields.clear();
    }

    fn default_instance() -> &'static Relationship {
        static instance: Relationship = Relationship {
            symbol: ::std::string::String::new(),
            is_reference: false,
            is_implementation: false,
            is_type_definition: false,
            is_definition: false,
            special_fields: ::protobuf::SpecialFields::new(),
        };
        &instance
    }
}

impl ::protobuf::MessageFull for Relationship {
    fn descriptor() -> ::protobuf::reflect::MessageDescriptor {
        static descriptor: ::protobuf::rt::Lazy<::protobuf::reflect::MessageDescriptor> = ::protobuf::rt::Lazy::new();
        descriptor.get(|| file_descriptor().message_by_package_relative_name("Relationship").unwrap()).clone()
    }
}

impl ::std::fmt::Display for Relationship {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::protobuf::text_format::fmt(self, f)
    }
}

impl ::protobuf::reflect::ProtobufValue for Relationship {
    type RuntimeType = ::protobuf::reflect::rt::RuntimeTypeMessage<Self>;
}

///  Occurrence associates a source position with a symbol and/or highlighting
///  information.
///
///  If possible, indexers should try to bundle logically related information
///  across occurrences into a single occurrence to reduce payload sizes.
#[derive(PartialEq,Clone,Default,Debug)]
// @@protoc_insertion_point(message:scip.Occurrence)
pub struct Occurrence {
    // message fields
    ///  Source position of this occurrence. Must be exactly three or four
    ///  elements:
    ///
    ///  - Four elements: `[startLine, startCharacter, endLine, endCharacter]`
    ///  - Three elements: `[startLine, startCharacter, endCharacter]`. The end line
    ///    is inferred to have the same value as the start line.
    ///
    ///  Line numbers and characters are always 0-based. Make sure to increment the
    ///  line/character values before displaying them in an editor-like UI because
    ///  editors conventionally use 1-based numbers.
    ///
    ///  Historical note: the original draft of this schema had a `Range` message
    ///  type with `start` and `end` fields of type `Position`, mirroring LSP.
    ///  Benchmarks revealed that this encoding was inefficient and that we could
    ///  reduce the total payload size of an index by 50% by using `repeated int32`
    ///  instead.  The `repeated int32` encoding is admittedly more embarrassing to
    ///  work with in some programming languages but we hope the performance
    ///  improvements make up for it.
    // @@protoc_insertion_point(field:scip.Occurrence.range)
    pub range: ::std::vec::Vec<i32>,
    ///  (optional) The symbol that appears at this position. See
    ///  `SymbolInformation.symbol` for how to format symbols as strings.
    // @@protoc_insertion_point(field:scip.Occurrence.symbol)
    pub symbol: ::std::string::String,
    ///  (optional) Bitset containing `SymbolRole`s in this occurrence.
    ///  See `SymbolRole`'s documentation for how to read and write this field.
    // @@protoc_insertion_point(field:scip.Occurrence.symbol_roles)
    pub symbol_roles: i32,
    ///  (optional) CommonMark-formatted documentation for this specific range. If
    ///  empty, the `Symbol.documentation` field is used instead. One example
    ///  where this field might be useful is when the symbol represents a generic
    ///  function (with abstract type parameters such as `List<T>`) and at this
    ///  occurrence we know the exact values (such as `List<String>`).
    ///
    ///  This field can also be used for dynamically or gradually typed languages,
    ///  which commonly allow for type-changing assignment.
    // @@protoc_insertion_point(field:scip.Occurrence.override_documentation)
    pub override_documentation: ::std::vec::Vec<::std::string::String>,
    ///  (optional) What syntax highlighting class should be used for this range?
    // @@protoc_insertion_point(field:scip.Occurrence.syntax_kind)
    pub syntax_kind: ::protobuf::EnumOrUnknown<SyntaxKind>,
    ///  (optional) Diagnostics that have been reported for this specific range.
    // @@protoc_insertion_point(field:scip.Occurrence.diagnostics)
    pub diagnostics: ::std::vec::Vec<Diagnostic>,
    // special fields
    // @@protoc_insertion_point(special_field:scip.Occurrence.special_fields)
    pub special_fields: ::protobuf::SpecialFields,
}

impl<'a> ::std::default::Default for &'a Occurrence {
    fn default() -> &'a Occurrence {
        <Occurrence as ::protobuf::Message>::default_instance()
    }
}

impl Occurrence {
    pub fn new() -> Occurrence {
        ::std::default::Default::default()
    }

    fn generated_message_descriptor_data() -> ::protobuf::reflect::GeneratedMessageDescriptorData {
        let mut fields = ::std::vec::Vec::with_capacity(6);
        let mut oneofs = ::std::vec::Vec::with_capacity(0);
        fields.push(::protobuf::reflect::rt::v2::make_vec_simpler_accessor::<_, _>(
            "range",
            |m: &Occurrence| { &m.range },
            |m: &mut Occurrence| { &mut m.range },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "symbol",
            |m: &Occurrence| { &m.symbol },
            |m: &mut Occurrence| { &mut m.symbol },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "symbol_roles",
            |m: &Occurrence| { &m.symbol_roles },
            |m: &mut Occurrence| { &mut m.symbol_roles },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_vec_simpler_accessor::<_, _>(
            "override_documentation",
            |m: &Occurrence| { &m.override_documentation },
            |m: &mut Occurrence| { &mut m.override_documentation },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "syntax_kind",
            |m: &Occurrence| { &m.syntax_kind },
            |m: &mut Occurrence| { &mut m.syntax_kind },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_vec_simpler_accessor::<_, _>(
            "diagnostics",
            |m: &Occurrence| { &m.diagnostics },
            |m: &mut Occurrence| { &mut m.diagnostics },
        ));
        ::protobuf::reflect::GeneratedMessageDescriptorData::new_2::<Occurrence>(
            "Occurrence",
            fields,
            oneofs,
        )
    }
}

impl ::protobuf::Message for Occurrence {
    const NAME: &'static str = "Occurrence";

    fn is_initialized(&self) -> bool {
        true
    }

    fn merge_from(&mut self, is: &mut ::protobuf::CodedInputStream<'_>) -> ::protobuf::Result<()> {
        while let Some(tag) = is.read_raw_tag_or_eof()? {
            match tag {
                10 => {
                    is.read_repeated_packed_int32_into(&mut self.range)?;
                },
                8 => {
                    self.range.push(is.read_int32()?);
                },
                18 => {
                    self.symbol = is.read_string()?;
                },
                24 => {
                    self.symbol_roles = is.read_int32()?;
                },
                34 => {
                    self.override_documentation.push(is.read_string()?);
                },
                40 => {
                    self.syntax_kind = is.read_enum_or_unknown()?;
                },
                50 => {
                    self.diagnostics.push(is.read_message()?);
                },
                tag => {
                    ::protobuf::rt::read_unknown_or_skip_group(tag, is, self.special_fields.mut_unknown_fields())?;
                },
            };
        }
        ::std::result::Result::Ok(())
    }

    // Compute sizes of nested messages
    #[allow(unused_variables)]
    fn compute_size(&self) -> u64 {
        let mut my_size = 0;
        for value in &self.range {
            my_size += ::protobuf::rt::int32_size(1, *value);
        };
        if !self.symbol.is_empty() {
            my_size += ::protobuf::rt::string_size(2, &self.symbol);
        }
        if self.symbol_roles != 0 {
            my_size += ::protobuf::rt::int32_size(3, self.symbol_roles);
        }
        for value in &self.override_documentation {
            my_size += ::protobuf::rt::string_size(4, &value);
        };
        if self.syntax_kind != ::protobuf::EnumOrUnknown::new(SyntaxKind::UnspecifiedSyntaxKind) {
            my_size += ::protobuf::rt::int32_size(5, self.syntax_kind.value());
        }
        for value in &self.diagnostics {
            let len = value.compute_size();
            my_size += 1 + ::protobuf::rt::compute_raw_varint64_size(len) + len;
        };
        my_size += ::protobuf::rt::unknown_fields_size(self.special_fields.unknown_fields());
        self.special_fields.cached_size().set(my_size as u32);
        my_size
    }

    fn write_to_with_cached_sizes(&self, os: &mut ::protobuf::CodedOutputStream<'_>) -> ::protobuf::Result<()> {
        for v in &self.range {
            os.write_int32(1, *v)?;
        };
        if !self.symbol.is_empty() {
            os.write_string(2, &self.symbol)?;
        }
        if self.symbol_roles != 0 {
            os.write_int32(3, self.symbol_roles)?;
        }
        for v in &self.override_documentation {
            os.write_string(4, &v)?;
        };
        if self.syntax_kind != ::protobuf::EnumOrUnknown::new(SyntaxKind::UnspecifiedSyntaxKind) {
            os.write_enum(5, ::protobuf::EnumOrUnknown::value(&self.syntax_kind))?;
        }
        for v in &self.diagnostics {
            ::protobuf::rt::write_message_field_with_cached_size(6, v, os)?;
        };
        os.write_unknown_fields(self.special_fields.unknown_fields())?;
        ::std::result::Result::Ok(())
    }

    fn special_fields(&self) -> &::protobuf::SpecialFields {
        &self.special_fields
    }

    fn mut_special_fields(&mut self) -> &mut ::protobuf::SpecialFields {
        &mut self.special_fields
    }

    fn new() -> Occurrence {
        Occurrence::new()
    }

    fn clear(&mut self) {
        self.range.clear();
        self.symbol.clear();
        self.symbol_roles = 0;
        self.override_documentation.clear();
        self.syntax_kind = ::protobuf::EnumOrUnknown::new(SyntaxKind::UnspecifiedSyntaxKind);
        self.diagnostics.clear();
        self.special_fields.clear();
    }

    fn default_instance() -> &'static Occurrence {
        static instance: Occurrence = Occurrence {
            range: ::std::vec::Vec::new(),
            symbol: ::std::string::String::new(),
            symbol_roles: 0,
            override_documentation: ::std::vec::Vec::new(),
            syntax_kind: ::protobuf::EnumOrUnknown::from_i32(0),
            diagnostics: ::std::vec::Vec::new(),
            special_fields: ::protobuf::SpecialFields::new(),
        };
        &instance
    }
}

impl ::protobuf::MessageFull for Occurrence {
    fn descriptor() -> ::protobuf::reflect::MessageDescriptor {
        static descriptor: ::protobuf::rt::Lazy<::protobuf::reflect::MessageDescriptor> = ::protobuf::rt::Lazy::new();
        descriptor.get(|| file_descriptor().message_by_package_relative_name("Occurrence").unwrap()).clone()
    }
}

impl ::std::fmt::Display for Occurrence {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::protobuf::text_format::fmt(self, f)
    }
}

impl ::protobuf::reflect::ProtobufValue for Occurrence {
    type RuntimeType = ::protobuf::reflect::rt::RuntimeTypeMessage<Self>;
}

///  Represents a diagnostic, such as a compiler error or warning, which should be
///  reported for a document.
#[derive(PartialEq,Clone,Default,Debug)]
// @@protoc_insertion_point(message:scip.Diagnostic)
pub struct Diagnostic {
    // message fields
    ///  Should this diagnostic be reported as an error, warning, info, or hint?
    // @@protoc_insertion_point(field:scip.Diagnostic.severity)
    pub severity: ::protobuf::EnumOrUnknown<Severity>,
    ///  (optional) Code of this diagnostic, which might appear in the user interface.
    // @@protoc_insertion_point(field:scip.Diagnostic.code)
    pub code: ::std::string::String,
    ///  Message of this diagnostic.
    // @@protoc_insertion_point(field:scip.Diagnostic.message)
    pub message: ::std::string::String,
    ///  (optional) Human-readable string describing the source of this diagnostic, e.g.
    ///  'typescript' or 'super lint'.
    // @@protoc_insertion_point(field:scip.Diagnostic.source)
    pub source: ::std::string::String,
    // @@protoc_insertion_point(field:scip.Diagnostic.tags)
    pub tags: ::std::vec::Vec<::protobuf::EnumOrUnknown<DiagnosticTag>>,
    // special fields
    // @@protoc_insertion_point(special_field:scip.Diagnostic.special_fields)
    pub special_fields: ::protobuf::SpecialFields,
}

impl<'a> ::std::default::Default for &'a Diagnostic {
    fn default() -> &'a Diagnostic {
        <Diagnostic as ::protobuf::Message>::default_instance()
    }
}

impl Diagnostic {
    pub fn new() -> Diagnostic {
        ::std::default::Default::default()
    }

    fn generated_message_descriptor_data() -> ::protobuf::reflect::GeneratedMessageDescriptorData {
        let mut fields = ::std::vec::Vec::with_capacity(5);
        let mut oneofs = ::std::vec::Vec::with_capacity(0);
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "severity",
            |m: &Diagnostic| { &m.severity },
            |m: &mut Diagnostic| { &mut m.severity },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "code",
            |m: &Diagnostic| { &m.code },
            |m: &mut Diagnostic| { &mut m.code },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "message",
            |m: &Diagnostic| { &m.message },
            |m: &mut Diagnostic| { &mut m.message },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_simpler_field_accessor::<_, _>(
            "source",
            |m: &Diagnostic| { &m.source },
            |m: &mut Diagnostic| { &mut m.source },
        ));
        fields.push(::protobuf::reflect::rt::v2::make_vec_simpler_accessor::<_, _>(
            "tags",
            |m: &Diagnostic| { &m.tags },
            |m: &mut Diagnostic| { &mut m.tags },
        ));
        ::protobuf::reflect::GeneratedMessageDescriptorData::new_2::<Diagnostic>(
            "Diagnostic",
            fields,
            oneofs,
        )
    }
}

impl ::protobuf::Message for Diagnostic {
    const NAME: &'static str = "Diagnostic";

    fn is_initialized(&self) -> bool {
        true
    }

    fn merge_from(&mut self, is: &mut ::protobuf::CodedInputStream<'_>) -> ::protobuf::Result<()> {
        while let Some(tag) = is.read_raw_tag_or_eof()? {
            match tag {
                8 => {
                    self.severity = is.read_enum_or_unknown()?;
                },
                18 => {
                    self.code = is.read_string()?;
                },
                26 => {
                    self.message = is.read_string()?;
                },
                34 => {
                    self.source = is.read_string()?;
                },
                40 => {
                    self.tags.push(is.read_enum_or_unknown()?);
                },
                42 => {
                    ::protobuf::rt::read_repeated_packed_enum_or_unknown_into(is, &mut self.tags)?
                },
                tag => {
                    ::protobuf::rt::read_unknown_or_skip_group(tag, is, self.special_fields.mut_unknown_fields())?;
                },
            };
        }
        ::std::result::Result::Ok(())
    }

    // Compute sizes of nested messages
    #[allow(unused_variables)]
    fn compute_size(&self) -> u64 {
        let mut my_size = 0;
        if self.severity != ::protobuf::EnumOrUnknown::new(Severity::UnspecifiedSeverity) {
            my_size += ::protobuf::rt::int32_size(1, self.severity.value());
        }
        if !self.code.is_empty() {
            my_size += ::protobuf::rt::string_size(2, &self.code);
        }
        if !self.message.is_empty() {
            my_size += ::protobuf::rt::string_size(3, &self.message);
        }
        if !self.source.is_empty() {
            my_size += ::protobuf::rt::string_size(4, &self.source);
        }
        for value in &self.tags {
            my_size += ::protobuf::rt::int32_size(5, value.value());
        };
        my_size += ::protobuf::rt::unknown_fields_size(self.special_fields.unknown_fields());
        self.special_fields.cached_size().set(my_size as u32);
        my_size
    }

    fn write_to_with_cached_sizes(&self, os: &mut ::protobuf::CodedOutputStream<'_>) -> ::protobuf::Result<()> {
        if self.severity != ::protobuf::EnumOrUnknown::new(Severity::UnspecifiedSeverity) {
            os.write_enum(1, ::protobuf::EnumOrUnknown::value(&self.severity))?;
        }
        if !self.code.is_empty() {
            os.write_string(2, &self.code)?;
        }
        if !self.message.is_empty() {
            os.write_string(3, &self.message)?;
        }
        if !self.source.is_empty() {
            os.write_string(4, &self.source)?;
        }
        for v in &self.tags {
            os.write_enum(5, ::protobuf::EnumOrUnknown::value(v))?;
        };
        os.write_unknown_fields(self.special_fields.unknown_fields())?;
        ::std::result::Result::Ok(())
    }

    fn special_fields(&self) -> &::protobuf::SpecialFields {
        &self.special_fields
    }

    fn mut_special_fields(&mut self) -> &mut ::protobuf::SpecialFields {
        &mut self.special_fields
    }

    fn new() -> Diagnostic {
        Diagnostic::new()
    }

    fn clear(&mut self) {
        self.severity = ::protobuf::EnumOrUnknown::new(Severity::UnspecifiedSeverity);
        self.code.clear();
        self.message.clear();
        self.source.clear();
        self.tags.clear();
        self.special_fields.clear();
    }

    fn default_instance() -> &'static Diagnostic {
        static instance: Diagnostic = Diagnostic {
            severity: ::protobuf::EnumOrUnknown::from_i32(0),
            code: ::std::string::String::new(),
            message: ::std::string::String::new(),
            source: ::std::string::String::new(),
            tags: ::std::vec::Vec::new(),
            special_fields: ::protobuf::SpecialFields::new(),
        };
        &instance
    }
}

impl ::protobuf::MessageFull for Diagnostic {
    fn descriptor() -> ::protobuf::reflect::MessageDescriptor {
        static descriptor: ::protobuf::rt::Lazy<::protobuf::reflect::MessageDescriptor> = ::protobuf::rt::Lazy::new();
        descriptor.get(|| file_descriptor().message_by_package_relative_name("Diagnostic").unwrap()).clone()
    }
}

impl ::std::fmt::Display for Diagnostic {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::protobuf::text_format::fmt(self, f)
    }
}

impl ::protobuf::reflect::ProtobufValue for Diagnostic {
    type RuntimeType = ::protobuf::reflect::rt::RuntimeTypeMessage<Self>;
}

#[derive(Clone,Copy,PartialEq,Eq,Debug,Hash)]
// @@protoc_insertion_point(enum:scip.ProtocolVersion)
pub enum ProtocolVersion {
    // @@protoc_insertion_point(enum_value:scip.ProtocolVersion.UnspecifiedProtocolVersion)
    UnspecifiedProtocolVersion = 0,
}

impl ::protobuf::Enum for ProtocolVersion {
    const NAME: &'static str = "ProtocolVersion";

    fn value(&self) -> i32 {
        *self as i32
    }

    fn from_i32(value: i32) -> ::std::option::Option<ProtocolVersion> {
        match value {
            0 => ::std::option::Option::Some(ProtocolVersion::UnspecifiedProtocolVersion),
            _ => ::std::option::Option::None
        }
    }

    const VALUES: &'static [ProtocolVersion] = &[
        ProtocolVersion::UnspecifiedProtocolVersion,
    ];
}

impl ::protobuf::EnumFull for ProtocolVersion {
    fn enum_descriptor() -> ::protobuf::reflect::EnumDescriptor {
        static descriptor: ::protobuf::rt::Lazy<::protobuf::reflect::EnumDescriptor> = ::protobuf::rt::Lazy::new();
        descriptor.get(|| file_descriptor().enum_by_package_relative_name("ProtocolVersion").unwrap()).clone()
    }

    fn descriptor(&self) -> ::protobuf::reflect::EnumValueDescriptor {
        let index = *self as usize;
        Self::enum_descriptor().value_by_index(index)
    }
}

impl ::std::default::Default for ProtocolVersion {
    fn default() -> Self {
        ProtocolVersion::UnspecifiedProtocolVersion
    }
}

impl ProtocolVersion {
    fn generated_enum_descriptor_data() -> ::protobuf::reflect::GeneratedEnumDescriptorData {
        ::protobuf::reflect::GeneratedEnumDescriptorData::new::<ProtocolVersion>("ProtocolVersion")
    }
}

#[derive(Clone,Copy,PartialEq,Eq,Debug,Hash)]
// @@protoc_insertion_point(enum:scip.TextEncoding)
pub enum TextEncoding {
    // @@protoc_insertion_point(enum_value:scip.TextEncoding.UnspecifiedTextEncoding)
    UnspecifiedTextEncoding = 0,
    // @@protoc_insertion_point(enum_value:scip.TextEncoding.UTF8)
    UTF8 = 1,
    // @@protoc_insertion_point(enum_value:scip.TextEncoding.UTF16)
    UTF16 = 2,
}

impl ::protobuf::Enum for TextEncoding {
    const NAME: &'static str = "TextEncoding";

    fn value(&self) -> i32 {
        *self as i32
    }

    fn from_i32(value: i32) -> ::std::option::Option<TextEncoding> {
        match value {
            0 => ::std::option::Option::Some(TextEncoding::UnspecifiedTextEncoding),
            1 => ::std::option::Option::Some(TextEncoding::UTF8),
            2 => ::std::option::Option::Some(TextEncoding::UTF16),
            _ => ::std::option::Option::None
        }
    }

    const VALUES: &'static [TextEncoding] = &[
        TextEncoding::UnspecifiedTextEncoding,
        TextEncoding::UTF8,
        TextEncoding::UTF16,
    ];
}

impl ::protobuf::EnumFull for TextEncoding {
    fn enum_descriptor() -> ::protobuf::reflect::EnumDescriptor {
        static descriptor: ::protobuf::rt::Lazy<::protobuf::reflect::EnumDescriptor> = ::protobuf::rt::Lazy::new();
        descriptor.get(|| file_descriptor().enum_by_package_relative_name("TextEncoding").unwrap()).clone()
    }

    fn descriptor(&self) -> ::protobuf::reflect::EnumValueDescriptor {
        let index = *self as usize;
        Self::enum_descriptor().value_by_index(index)
    }
}

impl ::std::default::Default for TextEncoding {
    fn default() -> Self {
        TextEncoding::UnspecifiedTextEncoding
    }
}

impl TextEncoding {
    fn generated_enum_descriptor_data() -> ::protobuf::reflect::GeneratedEnumDescriptorData {
        ::protobuf::reflect::GeneratedEnumDescriptorData::new::<TextEncoding>("TextEncoding")
    }
}

///  SymbolRole declares what "role" a symbol has in an occurrence.  A role is
///  encoded as a bitset where each bit represents a different role. For example,
///  to determine if the `Import` role is set, test whether the second bit of the
///  enum value is defined. In pseudocode, this can be implemented with the
///  logic: `const isImportRole = (role.value & SymbolRole.Import.value) > 0`.
#[derive(Clone,Copy,PartialEq,Eq,Debug,Hash)]
// @@protoc_insertion_point(enum:scip.SymbolRole)
pub enum SymbolRole {
    // @@protoc_insertion_point(enum_value:scip.SymbolRole.UnspecifiedSymbolRole)
    UnspecifiedSymbolRole = 0,
    // @@protoc_insertion_point(enum_value:scip.SymbolRole.Definition)
    Definition = 1,
    // @@protoc_insertion_point(enum_value:scip.SymbolRole.Import)
    Import = 2,
    // @@protoc_insertion_point(enum_value:scip.SymbolRole.WriteAccess)
    WriteAccess = 4,
    // @@protoc_insertion_point(enum_value:scip.SymbolRole.ReadAccess)
    ReadAccess = 8,
    // @@protoc_insertion_point(enum_value:scip.SymbolRole.Generated)
    Generated = 16,
    // @@protoc_insertion_point(enum_value:scip.SymbolRole.Test)
    Test = 32,
}

impl ::protobuf::Enum for SymbolRole {
    const NAME: &'static str = "SymbolRole";

    fn value(&self) -> i32 {
        *self as i32
    }

    fn from_i32(value: i32) -> ::std::option::Option<SymbolRole> {
        match value {
            0 => ::std::option::Option::Some(SymbolRole::UnspecifiedSymbolRole),
            1 => ::std::option::Option::Some(SymbolRole::Definition),
            2 => ::std::option::Option::Some(SymbolRole::Import),
            4 => ::std::option::Option::Some(SymbolRole::WriteAccess),
            8 => ::std::option::Option::Some(SymbolRole::ReadAccess),
            16 => ::std::option::Option::Some(SymbolRole::Generated),
            32 => ::std::option::Option::Some(SymbolRole::Test),
            _ => ::std::option::Option::None
        }
    }

    const VALUES: &'static [SymbolRole] = &[
        SymbolRole::UnspecifiedSymbolRole,
        SymbolRole::Definition,
        SymbolRole::Import,
        SymbolRole::WriteAccess,
        SymbolRole::ReadAccess,
        SymbolRole::Generated,
        SymbolRole::Test,
    ];
}

impl ::protobuf::EnumFull for SymbolRole {
    fn enum_descriptor() -> ::protobuf::reflect::EnumDescriptor {
        static descriptor: ::protobuf::rt::Lazy<::protobuf::reflect::EnumDescriptor> = ::protobuf::rt::Lazy::new();
        descriptor.get(|| file_descriptor().enum_by_package_relative_name("SymbolRole").unwrap()).clone()
    }

    fn descriptor(&self) -> ::protobuf::reflect::EnumValueDescriptor {
        let index = match self {
            SymbolRole::UnspecifiedSymbolRole => 0,
            SymbolRole::Definition => 1,
            SymbolRole::Import => 2,
            SymbolRole::WriteAccess => 3,
            SymbolRole::ReadAccess => 4,
            SymbolRole::Generated => 5,
            SymbolRole::Test => 6,
        };
        Self::enum_descriptor().value_by_index(index)
    }
}

impl ::std::default::Default for SymbolRole {
    fn default() -> Self {
        SymbolRole::UnspecifiedSymbolRole
    }
}

impl SymbolRole {
    fn generated_enum_descriptor_data() -> ::protobuf::reflect::GeneratedEnumDescriptorData {
        ::protobuf::reflect::GeneratedEnumDescriptorData::new::<SymbolRole>("SymbolRole")
    }
}

// Note: you cannot use pattern matching for enums with allow_alias option
#[derive(Clone,Copy,Eq,Debug)]
// @@protoc_insertion_point(enum:scip.SyntaxKind)
pub enum SyntaxKind {
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.UnspecifiedSyntaxKind)
    UnspecifiedSyntaxKind, // 0
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.Comment)
    Comment, // 1
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.PunctuationDelimiter)
    PunctuationDelimiter, // 2
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.PunctuationBracket)
    PunctuationBracket, // 3
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.Keyword)
    Keyword, // 4
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.IdentifierKeyword)
    IdentifierKeyword, // 4
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.IdentifierOperator)
    IdentifierOperator, // 5
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.Identifier)
    Identifier, // 6
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.IdentifierBuiltin)
    IdentifierBuiltin, // 7
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.IdentifierNull)
    IdentifierNull, // 8
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.IdentifierConstant)
    IdentifierConstant, // 9
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.IdentifierMutableGlobal)
    IdentifierMutableGlobal, // 10
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.IdentifierParameter)
    IdentifierParameter, // 11
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.IdentifierLocal)
    IdentifierLocal, // 12
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.IdentifierShadowed)
    IdentifierShadowed, // 13
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.IdentifierNamespace)
    IdentifierNamespace, // 14
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.IdentifierModule)
    IdentifierModule, // 14
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.IdentifierFunction)
    IdentifierFunction, // 15
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.IdentifierFunctionDefinition)
    IdentifierFunctionDefinition, // 16
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.IdentifierMacro)
    IdentifierMacro, // 17
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.IdentifierMacroDefinition)
    IdentifierMacroDefinition, // 18
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.IdentifierType)
    IdentifierType, // 19
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.IdentifierBuiltinType)
    IdentifierBuiltinType, // 20
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.IdentifierAttribute)
    IdentifierAttribute, // 21
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.RegexEscape)
    RegexEscape, // 22
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.RegexRepeated)
    RegexRepeated, // 23
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.RegexWildcard)
    RegexWildcard, // 24
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.RegexDelimiter)
    RegexDelimiter, // 25
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.RegexJoin)
    RegexJoin, // 26
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.StringLiteral)
    StringLiteral, // 27
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.StringLiteralEscape)
    StringLiteralEscape, // 28
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.StringLiteralSpecial)
    StringLiteralSpecial, // 29
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.StringLiteralKey)
    StringLiteralKey, // 30
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.CharacterLiteral)
    CharacterLiteral, // 31
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.NumericLiteral)
    NumericLiteral, // 32
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.BooleanLiteral)
    BooleanLiteral, // 33
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.Tag)
    Tag, // 34
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.TagAttribute)
    TagAttribute, // 35
    // @@protoc_insertion_point(enum_value:scip.SyntaxKind.TagDelimiter)
    TagDelimiter, // 36
}

impl ::std::cmp::PartialEq for SyntaxKind {
    fn eq(&self, other: &Self) -> bool {
        ::protobuf::Enum::value(self) == ::protobuf::Enum::value(other)
    }
}

impl ::std::hash::Hash for SyntaxKind {
    fn hash<H : ::std::hash::Hasher>(&self, state: &mut H) {
        state.write_i32(::protobuf::Enum::value(self))
    }
}

impl ::protobuf::Enum for SyntaxKind {
    const NAME: &'static str = "SyntaxKind";

    fn value(&self) -> i32 {
        match *self {
            SyntaxKind::UnspecifiedSyntaxKind => 0,
            SyntaxKind::Comment => 1,
            SyntaxKind::PunctuationDelimiter => 2,
            SyntaxKind::PunctuationBracket => 3,
            SyntaxKind::Keyword => 4,
            SyntaxKind::IdentifierKeyword => 4,
            SyntaxKind::IdentifierOperator => 5,
            SyntaxKind::Identifier => 6,
            SyntaxKind::IdentifierBuiltin => 7,
            SyntaxKind::IdentifierNull => 8,
            SyntaxKind::IdentifierConstant => 9,
            SyntaxKind::IdentifierMutableGlobal => 10,
            SyntaxKind::IdentifierParameter => 11,
            SyntaxKind::IdentifierLocal => 12,
            SyntaxKind::IdentifierShadowed => 13,
            SyntaxKind::IdentifierNamespace => 14,
            SyntaxKind::IdentifierModule => 14,
            SyntaxKind::IdentifierFunction => 15,
            SyntaxKind::IdentifierFunctionDefinition => 16,
            SyntaxKind::IdentifierMacro => 17,
            SyntaxKind::IdentifierMacroDefinition => 18,
            SyntaxKind::IdentifierType => 19,
            SyntaxKind::IdentifierBuiltinType => 20,
            SyntaxKind::IdentifierAttribute => 21,
            SyntaxKind::RegexEscape => 22,
            SyntaxKind::RegexRepeated => 23,
            SyntaxKind::RegexWildcard => 24,
            SyntaxKind::RegexDelimiter => 25,
            SyntaxKind::RegexJoin => 26,
            SyntaxKind::StringLiteral => 27,
            SyntaxKind::StringLiteralEscape => 28,
            SyntaxKind::StringLiteralSpecial => 29,
            SyntaxKind::StringLiteralKey => 30,
            SyntaxKind::CharacterLiteral => 31,
            SyntaxKind::NumericLiteral => 32,
            SyntaxKind::BooleanLiteral => 33,
            SyntaxKind::Tag => 34,
            SyntaxKind::TagAttribute => 35,
            SyntaxKind::TagDelimiter => 36,
        }
    }

    fn from_i32(value: i32) -> ::std::option::Option<SyntaxKind> {
        match value {
            0 => ::std::option::Option::Some(SyntaxKind::UnspecifiedSyntaxKind),
            1 => ::std::option::Option::Some(SyntaxKind::Comment),
            2 => ::std::option::Option::Some(SyntaxKind::PunctuationDelimiter),
            3 => ::std::option::Option::Some(SyntaxKind::PunctuationBracket),
            4 => ::std::option::Option::Some(SyntaxKind::Keyword),
            5 => ::std::option::Option::Some(SyntaxKind::IdentifierOperator),
            6 => ::std::option::Option::Some(SyntaxKind::Identifier),
            7 => ::std::option::Option::Some(SyntaxKind::IdentifierBuiltin),
            8 => ::std::option::Option::Some(SyntaxKind::IdentifierNull),
            9 => ::std::option::Option::Some(SyntaxKind::IdentifierConstant),
            10 => ::std::option::Option::Some(SyntaxKind::IdentifierMutableGlobal),
            11 => ::std::option::Option::Some(SyntaxKind::IdentifierParameter),
            12 => ::std::option::Option::Some(SyntaxKind::IdentifierLocal),
            13 => ::std::option::Option::Some(SyntaxKind::IdentifierShadowed),
            14 => ::std::option::Option::Some(SyntaxKind::IdentifierNamespace),
            15 => ::std::option::Option::Some(SyntaxKind::IdentifierFunction),
            16 => ::std::option::Option::Some(SyntaxKind::IdentifierFunctionDefinition),
            17 => ::std::option::Option::Some(SyntaxKind::IdentifierMacro),
            18 => ::std::option::Option::Some(SyntaxKind::IdentifierMacroDefinition),
            19 => ::std::option::Option::Some(SyntaxKind::IdentifierType),
            20 => ::std::option::Option::Some(SyntaxKind::IdentifierBuiltinType),
            21 => ::std::option::Option::Some(SyntaxKind::IdentifierAttribute),
            22 => ::std::option::Option::Some(SyntaxKind::RegexEscape),
            23 => ::std::option::Option::Some(SyntaxKind::RegexRepeated),
            24 => ::std::option::Option::Some(SyntaxKind::RegexWildcard),
            25 => ::std::option::Option::Some(SyntaxKind::RegexDelimiter),
            26 => ::std::option::Option::Some(SyntaxKind::RegexJoin),
            27 => ::std::option::Option::Some(SyntaxKind::StringLiteral),
            28 => ::std::option::Option::Some(SyntaxKind::StringLiteralEscape),
            29 => ::std::option::Option::Some(SyntaxKind::StringLiteralSpecial),
            30 => ::std::option::Option::Some(SyntaxKind::StringLiteralKey),
            31 => ::std::option::Option::Some(SyntaxKind::CharacterLiteral),
            32 => ::std::option::Option::Some(SyntaxKind::NumericLiteral),
            33 => ::std::option::Option::Some(SyntaxKind::BooleanLiteral),
            34 => ::std::option::Option::Some(SyntaxKind::Tag),
            35 => ::std::option::Option::Some(SyntaxKind::TagAttribute),
            36 => ::std::option::Option::Some(SyntaxKind::TagDelimiter),
            _ => ::std::option::Option::None
        }
    }

    const VALUES: &'static [SyntaxKind] = &[
        SyntaxKind::UnspecifiedSyntaxKind,
        SyntaxKind::Comment,
        SyntaxKind::PunctuationDelimiter,
        SyntaxKind::PunctuationBracket,
        SyntaxKind::Keyword,
        SyntaxKind::IdentifierKeyword,
        SyntaxKind::IdentifierOperator,
        SyntaxKind::Identifier,
        SyntaxKind::IdentifierBuiltin,
        SyntaxKind::IdentifierNull,
        SyntaxKind::IdentifierConstant,
        SyntaxKind::IdentifierMutableGlobal,
        SyntaxKind::IdentifierParameter,
        SyntaxKind::IdentifierLocal,
        SyntaxKind::IdentifierShadowed,
        SyntaxKind::IdentifierNamespace,
        SyntaxKind::IdentifierModule,
        SyntaxKind::IdentifierFunction,
        SyntaxKind::IdentifierFunctionDefinition,
        SyntaxKind::IdentifierMacro,
        SyntaxKind::IdentifierMacroDefinition,
        SyntaxKind::IdentifierType,
        SyntaxKind::IdentifierBuiltinType,
        SyntaxKind::IdentifierAttribute,
        SyntaxKind::RegexEscape,
        SyntaxKind::RegexRepeated,
        SyntaxKind::RegexWildcard,
        SyntaxKind::RegexDelimiter,
        SyntaxKind::RegexJoin,
        SyntaxKind::StringLiteral,
        SyntaxKind::StringLiteralEscape,
        SyntaxKind::StringLiteralSpecial,
        SyntaxKind::StringLiteralKey,
        SyntaxKind::CharacterLiteral,
        SyntaxKind::NumericLiteral,
        SyntaxKind::BooleanLiteral,
        SyntaxKind::Tag,
        SyntaxKind::TagAttribute,
        SyntaxKind::TagDelimiter,
    ];
}

impl ::protobuf::EnumFull for SyntaxKind {
    fn enum_descriptor() -> ::protobuf::reflect::EnumDescriptor {
        static descriptor: ::protobuf::rt::Lazy<::protobuf::reflect::EnumDescriptor> = ::protobuf::rt::Lazy::new();
        descriptor.get(|| file_descriptor().enum_by_package_relative_name("SyntaxKind").unwrap()).clone()
    }

    fn descriptor(&self) -> ::protobuf::reflect::EnumValueDescriptor {
        let index = match self {
            SyntaxKind::UnspecifiedSyntaxKind => 0,
            SyntaxKind::Comment => 1,
            SyntaxKind::PunctuationDelimiter => 2,
            SyntaxKind::PunctuationBracket => 3,
            SyntaxKind::Keyword => 4,
            SyntaxKind::IdentifierKeyword => 5,
            SyntaxKind::IdentifierOperator => 6,
            SyntaxKind::Identifier => 7,
            SyntaxKind::IdentifierBuiltin => 8,
            SyntaxKind::IdentifierNull => 9,
            SyntaxKind::IdentifierConstant => 10,
            SyntaxKind::IdentifierMutableGlobal => 11,
            SyntaxKind::IdentifierParameter => 12,
            SyntaxKind::IdentifierLocal => 13,
            SyntaxKind::IdentifierShadowed => 14,
            SyntaxKind::IdentifierNamespace => 15,
            SyntaxKind::IdentifierModule => 16,
            SyntaxKind::IdentifierFunction => 17,
            SyntaxKind::IdentifierFunctionDefinition => 18,
            SyntaxKind::IdentifierMacro => 19,
            SyntaxKind::IdentifierMacroDefinition => 20,
            SyntaxKind::IdentifierType => 21,
            SyntaxKind::IdentifierBuiltinType => 22,
            SyntaxKind::IdentifierAttribute => 23,
            SyntaxKind::RegexEscape => 24,
            SyntaxKind::RegexRepeated => 25,
            SyntaxKind::RegexWildcard => 26,
            SyntaxKind::RegexDelimiter => 27,
            SyntaxKind::RegexJoin => 28,
            SyntaxKind::StringLiteral => 29,
            SyntaxKind::StringLiteralEscape => 30,
            SyntaxKind::StringLiteralSpecial => 31,
            SyntaxKind::StringLiteralKey => 32,
            SyntaxKind::CharacterLiteral => 33,
            SyntaxKind::NumericLiteral => 34,
            SyntaxKind::BooleanLiteral => 35,
            SyntaxKind::Tag => 36,
            SyntaxKind::TagAttribute => 37,
            SyntaxKind::TagDelimiter => 38,
        };
        Self::enum_descriptor().value_by_index(index)
    }
}

impl ::std::default::Default for SyntaxKind {
    fn default() -> Self {
        SyntaxKind::UnspecifiedSyntaxKind
    }
}

impl SyntaxKind {
    fn generated_enum_descriptor_data() -> ::protobuf::reflect::GeneratedEnumDescriptorData {
        ::protobuf::reflect::GeneratedEnumDescriptorData::new::<SyntaxKind>("SyntaxKind")
    }
}

#[derive(Clone,Copy,PartialEq,Eq,Debug,Hash)]
// @@protoc_insertion_point(enum:scip.Severity)
pub enum Severity {
    // @@protoc_insertion_point(enum_value:scip.Severity.UnspecifiedSeverity)
    UnspecifiedSeverity = 0,
    // @@protoc_insertion_point(enum_value:scip.Severity.Error)
    Error = 1,
    // @@protoc_insertion_point(enum_value:scip.Severity.Warning)
    Warning = 2,
    // @@protoc_insertion_point(enum_value:scip.Severity.Information)
    Information = 3,
    // @@protoc_insertion_point(enum_value:scip.Severity.Hint)
    Hint = 4,
}

impl ::protobuf::Enum for Severity {
    const NAME: &'static str = "Severity";

    fn value(&self) -> i32 {
        *self as i32
    }

    fn from_i32(value: i32) -> ::std::option::Option<Severity> {
        match value {
            0 => ::std::option::Option::Some(Severity::UnspecifiedSeverity),
            1 => ::std::option::Option::Some(Severity::Error),
            2 => ::std::option::Option::Some(Severity::Warning),
            3 => ::std::option::Option::Some(Severity::Information),
            4 => ::std::option::Option::Some(Severity::Hint),
            _ => ::std::option::Option::None
        }
    }

    const VALUES: &'static [Severity] = &[
        Severity::UnspecifiedSeverity,
        Severity::Error,
        Severity::Warning,
        Severity::Information,
        Severity::Hint,
    ];
}

impl ::protobuf::EnumFull for Severity {
    fn enum_descriptor() -> ::protobuf::reflect::EnumDescriptor {
        static descriptor: ::protobuf::rt::Lazy<::protobuf::reflect::EnumDescriptor> = ::protobuf::rt::Lazy::new();
        descriptor.get(|| file_descriptor().enum_by_package_relative_name("Severity").unwrap()).clone()
    }

    fn descriptor(&self) -> ::protobuf::reflect::EnumValueDescriptor {
        let index = *self as usize;
        Self::enum_descriptor().value_by_index(index)
    }
}

impl ::std::default::Default for Severity {
    fn default() -> Self {
        Severity::UnspecifiedSeverity
    }
}

impl Severity {
    fn generated_enum_descriptor_data() -> ::protobuf::reflect::GeneratedEnumDescriptorData {
        ::protobuf::reflect::GeneratedEnumDescriptorData::new::<Severity>("Severity")
    }
}

#[derive(Clone,Copy,PartialEq,Eq,Debug,Hash)]
// @@protoc_insertion_point(enum:scip.DiagnosticTag)
pub enum DiagnosticTag {
    // @@protoc_insertion_point(enum_value:scip.DiagnosticTag.UnspecifiedDiagnosticTag)
    UnspecifiedDiagnosticTag = 0,
    // @@protoc_insertion_point(enum_value:scip.DiagnosticTag.Unnecessary)
    Unnecessary = 1,
    // @@protoc_insertion_point(enum_value:scip.DiagnosticTag.Deprecated)
    Deprecated = 2,
}

impl ::protobuf::Enum for DiagnosticTag {
    const NAME: &'static str = "DiagnosticTag";

    fn value(&self) -> i32 {
        *self as i32
    }

    fn from_i32(value: i32) -> ::std::option::Option<DiagnosticTag> {
        match value {
            0 => ::std::option::Option::Some(DiagnosticTag::UnspecifiedDiagnosticTag),
            1 => ::std::option::Option::Some(DiagnosticTag::Unnecessary),
            2 => ::std::option::Option::Some(DiagnosticTag::Deprecated),
            _ => ::std::option::Option::None
        }
    }

    const VALUES: &'static [DiagnosticTag] = &[
        DiagnosticTag::UnspecifiedDiagnosticTag,
        DiagnosticTag::Unnecessary,
        DiagnosticTag::Deprecated,
    ];
}

impl ::protobuf::EnumFull for DiagnosticTag {
    fn enum_descriptor() -> ::protobuf::reflect::EnumDescriptor {
        static descriptor: ::protobuf::rt::Lazy<::protobuf::reflect::EnumDescriptor> = ::protobuf::rt::Lazy::new();
        descriptor.get(|| file_descriptor().enum_by_package_relative_name("DiagnosticTag").unwrap()).clone()
    }

    fn descriptor(&self) -> ::protobuf::reflect::EnumValueDescriptor {
        let index = *self as usize;
        Self::enum_descriptor().value_by_index(index)
    }
}

impl ::std::default::Default for DiagnosticTag {
    fn default() -> Self {
        DiagnosticTag::UnspecifiedDiagnosticTag
    }
}

impl DiagnosticTag {
    fn generated_enum_descriptor_data() -> ::protobuf::reflect::GeneratedEnumDescriptorData {
        ::protobuf::reflect::GeneratedEnumDescriptorData::new::<DiagnosticTag>("DiagnosticTag")
    }
}

///  Language standardises names of common programming languages that can be used
///  for the `Document.language` field. The primary purpose of this enum is to
///  prevent a situation where we have a single programming language ends up with
///  multiple string representations. For example, the C++ language uses the name
///  "CPlusPlus" in this enum and other names such as "cpp" are incompatible.
///  Feel free to send a pull-request to add missing programming languages.
#[derive(Clone,Copy,PartialEq,Eq,Debug,Hash)]
// @@protoc_insertion_point(enum:scip.Language)
pub enum Language {
    // @@protoc_insertion_point(enum_value:scip.Language.UnspecifiedLanguage)
    UnspecifiedLanguage = 0,
    // @@protoc_insertion_point(enum_value:scip.Language.ABAP)
    ABAP = 60,
    // @@protoc_insertion_point(enum_value:scip.Language.APL)
    APL = 49,
    // @@protoc_insertion_point(enum_value:scip.Language.Ada)
    Ada = 39,
    // @@protoc_insertion_point(enum_value:scip.Language.Agda)
    Agda = 45,
    // @@protoc_insertion_point(enum_value:scip.Language.AsciiDoc)
    AsciiDoc = 86,
    // @@protoc_insertion_point(enum_value:scip.Language.Assembly)
    Assembly = 58,
    // @@protoc_insertion_point(enum_value:scip.Language.Awk)
    Awk = 66,
    // @@protoc_insertion_point(enum_value:scip.Language.Bat)
    Bat = 68,
    // @@protoc_insertion_point(enum_value:scip.Language.BibTeX)
    BibTeX = 81,
    // @@protoc_insertion_point(enum_value:scip.Language.C)
    C = 34,
    // @@protoc_insertion_point(enum_value:scip.Language.COBOL)
    COBOL = 59,
    // @@protoc_insertion_point(enum_value:scip.Language.CPP)
    CPP = 35,
    // @@protoc_insertion_point(enum_value:scip.Language.CSS)
    CSS = 26,
    // @@protoc_insertion_point(enum_value:scip.Language.CSharp)
    CSharp = 1,
    // @@protoc_insertion_point(enum_value:scip.Language.Clojure)
    Clojure = 8,
    // @@protoc_insertion_point(enum_value:scip.Language.Coffeescript)
    Coffeescript = 21,
    // @@protoc_insertion_point(enum_value:scip.Language.CommonLisp)
    CommonLisp = 9,
    // @@protoc_insertion_point(enum_value:scip.Language.Coq)
    Coq = 47,
    // @@protoc_insertion_point(enum_value:scip.Language.Dart)
    Dart = 3,
    // @@protoc_insertion_point(enum_value:scip.Language.Delphi)
    Delphi = 57,
    // @@protoc_insertion_point(enum_value:scip.Language.Diff)
    Diff = 88,
    // @@protoc_insertion_point(enum_value:scip.Language.Dockerfile)
    Dockerfile = 80,
    // @@protoc_insertion_point(enum_value:scip.Language.Dyalog)
    Dyalog = 50,
    // @@protoc_insertion_point(enum_value:scip.Language.Elixir)
    Elixir = 17,
    // @@protoc_insertion_point(enum_value:scip.Language.Erlang)
    Erlang = 18,
    // @@protoc_insertion_point(enum_value:scip.Language.FSharp)
    FSharp = 42,
    // @@protoc_insertion_point(enum_value:scip.Language.Fish)
    Fish = 65,
    // @@protoc_insertion_point(enum_value:scip.Language.Flow)
    Flow = 24,
    // @@protoc_insertion_point(enum_value:scip.Language.Fortran)
    Fortran = 56,
    // @@protoc_insertion_point(enum_value:scip.Language.Git_Commit)
    Git_Commit = 91,
    // @@protoc_insertion_point(enum_value:scip.Language.Git_Config)
    Git_Config = 89,
    // @@protoc_insertion_point(enum_value:scip.Language.Git_Rebase)
    Git_Rebase = 92,
    // @@protoc_insertion_point(enum_value:scip.Language.Go)
    Go = 33,
    // @@protoc_insertion_point(enum_value:scip.Language.Groovy)
    Groovy = 7,
    // @@protoc_insertion_point(enum_value:scip.Language.HTML)
    HTML = 30,
    // @@protoc_insertion_point(enum_value:scip.Language.Hack)
    Hack = 20,
    // @@protoc_insertion_point(enum_value:scip.Language.Handlebars)
    Handlebars = 90,
    // @@protoc_insertion_point(enum_value:scip.Language.Haskell)
    Haskell = 44,
    // @@protoc_insertion_point(enum_value:scip.Language.Idris)
    Idris = 46,
    // @@protoc_insertion_point(enum_value:scip.Language.Ini)
    Ini = 72,
    // @@protoc_insertion_point(enum_value:scip.Language.J)
    J = 51,
    // @@protoc_insertion_point(enum_value:scip.Language.JSON)
    JSON = 75,
    // @@protoc_insertion_point(enum_value:scip.Language.Java)
    Java = 6,
    // @@protoc_insertion_point(enum_value:scip.Language.JavaScript)
    JavaScript = 22,
    // @@protoc_insertion_point(enum_value:scip.Language.JavaScriptReact)
    JavaScriptReact = 93,
    // @@protoc_insertion_point(enum_value:scip.Language.Jsonnet)
    Jsonnet = 76,
    // @@protoc_insertion_point(enum_value:scip.Language.Julia)
    Julia = 55,
    // @@protoc_insertion_point(enum_value:scip.Language.Kotlin)
    Kotlin = 4,
    // @@protoc_insertion_point(enum_value:scip.Language.LaTeX)
    LaTeX = 83,
    // @@protoc_insertion_point(enum_value:scip.Language.Lean)
    Lean = 48,
    // @@protoc_insertion_point(enum_value:scip.Language.Less)
    Less = 27,
    // @@protoc_insertion_point(enum_value:scip.Language.Lua)
    Lua = 12,
    // @@protoc_insertion_point(enum_value:scip.Language.Makefile)
    Makefile = 79,
    // @@protoc_insertion_point(enum_value:scip.Language.Markdown)
    Markdown = 84,
    // @@protoc_insertion_point(enum_value:scip.Language.Matlab)
    Matlab = 52,
    // @@protoc_insertion_point(enum_value:scip.Language.Nix)
    Nix = 77,
    // @@protoc_insertion_point(enum_value:scip.Language.OCaml)
    OCaml = 41,
    // @@protoc_insertion_point(enum_value:scip.Language.Objective_C)
    Objective_C = 36,
    // @@protoc_insertion_point(enum_value:scip.Language.Objective_CPP)
    Objective_CPP = 37,
    // @@protoc_insertion_point(enum_value:scip.Language.PHP)
    PHP = 19,
    // @@protoc_insertion_point(enum_value:scip.Language.PLSQL)
    PLSQL = 70,
    // @@protoc_insertion_point(enum_value:scip.Language.Perl)
    Perl = 13,
    // @@protoc_insertion_point(enum_value:scip.Language.PowerShell)
    PowerShell = 67,
    // @@protoc_insertion_point(enum_value:scip.Language.Prolog)
    Prolog = 71,
    // @@protoc_insertion_point(enum_value:scip.Language.Python)
    Python = 15,
    // @@protoc_insertion_point(enum_value:scip.Language.R)
    R = 54,
    // @@protoc_insertion_point(enum_value:scip.Language.Racket)
    Racket = 11,
    // @@protoc_insertion_point(enum_value:scip.Language.Raku)
    Raku = 14,
    // @@protoc_insertion_point(enum_value:scip.Language.Razor)
    Razor = 62,
    // @@protoc_insertion_point(enum_value:scip.Language.ReST)
    ReST = 85,
    // @@protoc_insertion_point(enum_value:scip.Language.Ruby)
    Ruby = 16,
    // @@protoc_insertion_point(enum_value:scip.Language.Rust)
    Rust = 40,
    // @@protoc_insertion_point(enum_value:scip.Language.SAS)
    SAS = 61,
    // @@protoc_insertion_point(enum_value:scip.Language.SCSS)
    SCSS = 29,
    // @@protoc_insertion_point(enum_value:scip.Language.SML)
    SML = 43,
    // @@protoc_insertion_point(enum_value:scip.Language.SQL)
    SQL = 69,
    // @@protoc_insertion_point(enum_value:scip.Language.Sass)
    Sass = 28,
    // @@protoc_insertion_point(enum_value:scip.Language.Scala)
    Scala = 5,
    // @@protoc_insertion_point(enum_value:scip.Language.Scheme)
    Scheme = 10,
    // @@protoc_insertion_point(enum_value:scip.Language.ShellScript)
    ShellScript = 64,
    // @@protoc_insertion_point(enum_value:scip.Language.Skylark)
    Skylark = 78,
    // @@protoc_insertion_point(enum_value:scip.Language.Swift)
    Swift = 2,
    // @@protoc_insertion_point(enum_value:scip.Language.TOML)
    TOML = 73,
    // @@protoc_insertion_point(enum_value:scip.Language.TeX)
    TeX = 82,
    // @@protoc_insertion_point(enum_value:scip.Language.TypeScript)
    TypeScript = 23,
    // @@protoc_insertion_point(enum_value:scip.Language.TypeScriptReact)
    TypeScriptReact = 94,
    // @@protoc_insertion_point(enum_value:scip.Language.VisualBasic)
    VisualBasic = 63,
    // @@protoc_insertion_point(enum_value:scip.Language.Vue)
    Vue = 25,
    // @@protoc_insertion_point(enum_value:scip.Language.Wolfram)
    Wolfram = 53,
    // @@protoc_insertion_point(enum_value:scip.Language.XML)
    XML = 31,
    // @@protoc_insertion_point(enum_value:scip.Language.XSL)
    XSL = 32,
    // @@protoc_insertion_point(enum_value:scip.Language.YAML)
    YAML = 74,
    // @@protoc_insertion_point(enum_value:scip.Language.Zig)
    Zig = 38,
}

impl ::protobuf::Enum for Language {
    const NAME: &'static str = "Language";

    fn value(&self) -> i32 {
        *self as i32
    }

    fn from_i32(value: i32) -> ::std::option::Option<Language> {
        match value {
            0 => ::std::option::Option::Some(Language::UnspecifiedLanguage),
            60 => ::std::option::Option::Some(Language::ABAP),
            49 => ::std::option::Option::Some(Language::APL),
            39 => ::std::option::Option::Some(Language::Ada),
            45 => ::std::option::Option::Some(Language::Agda),
            86 => ::std::option::Option::Some(Language::AsciiDoc),
            58 => ::std::option::Option::Some(Language::Assembly),
            66 => ::std::option::Option::Some(Language::Awk),
            68 => ::std::option::Option::Some(Language::Bat),
            81 => ::std::option::Option::Some(Language::BibTeX),
            34 => ::std::option::Option::Some(Language::C),
            59 => ::std::option::Option::Some(Language::COBOL),
            35 => ::std::option::Option::Some(Language::CPP),
            26 => ::std::option::Option::Some(Language::CSS),
            1 => ::std::option::Option::Some(Language::CSharp),
            8 => ::std::option::Option::Some(Language::Clojure),
            21 => ::std::option::Option::Some(Language::Coffeescript),
            9 => ::std::option::Option::Some(Language::CommonLisp),
            47 => ::std::option::Option::Some(Language::Coq),
            3 => ::std::option::Option::Some(Language::Dart),
            57 => ::std::option::Option::Some(Language::Delphi),
            88 => ::std::option::Option::Some(Language::Diff),
            80 => ::std::option::Option::Some(Language::Dockerfile),
            50 => ::std::option::Option::Some(Language::Dyalog),
            17 => ::std::option::Option::Some(Language::Elixir),
            18 => ::std::option::Option::Some(Language::Erlang),
            42 => ::std::option::Option::Some(Language::FSharp),
            65 => ::std::option::Option::Some(Language::Fish),
            24 => ::std::option::Option::Some(Language::Flow),
            56 => ::std::option::Option::Some(Language::Fortran),
            91 => ::std::option::Option::Some(Language::Git_Commit),
            89 => ::std::option::Option::Some(Language::Git_Config),
            92 => ::std::option::Option::Some(Language::Git_Rebase),
            33 => ::std::option::Option::Some(Language::Go),
            7 => ::std::option::Option::Some(Language::Groovy),
            30 => ::std::option::Option::Some(Language::HTML),
            20 => ::std::option::Option::Some(Language::Hack),
            90 => ::std::option::Option::Some(Language::Handlebars),
            44 => ::std::option::Option::Some(Language::Haskell),
            46 => ::std::option::Option::Some(Language::Idris),
            72 => ::std::option::Option::Some(Language::Ini),
            51 => ::std::option::Option::Some(Language::J),
            75 => ::std::option::Option::Some(Language::JSON),
            6 => ::std::option::Option::Some(Language::Java),
            22 => ::std::option::Option::Some(Language::JavaScript),
            93 => ::std::option::Option::Some(Language::JavaScriptReact),
            76 => ::std::option::Option::Some(Language::Jsonnet),
            55 => ::std::option::Option::Some(Language::Julia),
            4 => ::std::option::Option::Some(Language::Kotlin),
            83 => ::std::option::Option::Some(Language::LaTeX),
            48 => ::std::option::Option::Some(Language::Lean),
            27 => ::std::option::Option::Some(Language::Less),
            12 => ::std::option::Option::Some(Language::Lua),
            79 => ::std::option::Option::Some(Language::Makefile),
            84 => ::std::option::Option::Some(Language::Markdown),
            52 => ::std::option::Option::Some(Language::Matlab),
            77 => ::std::option::Option::Some(Language::Nix),
            41 => ::std::option::Option::Some(Language::OCaml),
            36 => ::std::option::Option::Some(Language::Objective_C),
            37 => ::std::option::Option::Some(Language::Objective_CPP),
            19 => ::std::option::Option::Some(Language::PHP),
            70 => ::std::option::Option::Some(Language::PLSQL),
            13 => ::std::option::Option::Some(Language::Perl),
            67 => ::std::option::Option::Some(Language::PowerShell),
            71 => ::std::option::Option::Some(Language::Prolog),
            15 => ::std::option::Option::Some(Language::Python),
            54 => ::std::option::Option::Some(Language::R),
            11 => ::std::option::Option::Some(Language::Racket),
            14 => ::std::option::Option::Some(Language::Raku),
            62 => ::std::option::Option::Some(Language::Razor),
            85 => ::std::option::Option::Some(Language::ReST),
            16 => ::std::option::Option::Some(Language::Ruby),
            40 => ::std::option::Option::Some(Language::Rust),
            61 => ::std::option::Option::Some(Language::SAS),
            29 => ::std::option::Option::Some(Language::SCSS),
            43 => ::std::option::Option::Some(Language::SML),
            69 => ::std::option::Option::Some(Language::SQL),
            28 => ::std::option::Option::Some(Language::Sass),
            5 => ::std::option::Option::Some(Language::Scala),
            10 => ::std::option::Option::Some(Language::Scheme),
            64 => ::std::option::Option::Some(Language::ShellScript),
            78 => ::std::option::Option::Some(Language::Skylark),
            2 => ::std::option::Option::Some(Language::Swift),
            73 => ::std::option::Option::Some(Language::TOML),
            82 => ::std::option::Option::Some(Language::TeX),
            23 => ::std::option::Option::Some(Language::TypeScript),
            94 => ::std::option::Option::Some(Language::TypeScriptReact),
            63 => ::std::option::Option::Some(Language::VisualBasic),
            25 => ::std::option::Option::Some(Language::Vue),
            53 => ::std::option::Option::Some(Language::Wolfram),
            31 => ::std::option::Option::Some(Language::XML),
            32 => ::std::option::Option::Some(Language::XSL),
            74 => ::std::option::Option::Some(Language::YAML),
            38 => ::std::option::Option::Some(Language::Zig),
            _ => ::std::option::Option::None
        }
    }

    const VALUES: &'static [Language] = &[
        Language::UnspecifiedLanguage,
        Language::ABAP,
        Language::APL,
        Language::Ada,
        Language::Agda,
        Language::AsciiDoc,
        Language::Assembly,
        Language::Awk,
        Language::Bat,
        Language::BibTeX,
        Language::C,
        Language::COBOL,
        Language::CPP,
        Language::CSS,
        Language::CSharp,
        Language::Clojure,
        Language::Coffeescript,
        Language::CommonLisp,
        Language::Coq,
        Language::Dart,
        Language::Delphi,
        Language::Diff,
        Language::Dockerfile,
        Language::Dyalog,
        Language::Elixir,
        Language::Erlang,
        Language::FSharp,
        Language::Fish,
        Language::Flow,
        Language::Fortran,
        Language::Git_Commit,
        Language::Git_Config,
        Language::Git_Rebase,
        Language::Go,
        Language::Groovy,
        Language::HTML,
        Language::Hack,
        Language::Handlebars,
        Language::Haskell,
        Language::Idris,
        Language::Ini,
        Language::J,
        Language::JSON,
        Language::Java,
        Language::JavaScript,
        Language::JavaScriptReact,
        Language::Jsonnet,
        Language::Julia,
        Language::Kotlin,
        Language::LaTeX,
        Language::Lean,
        Language::Less,
        Language::Lua,
        Language::Makefile,
        Language::Markdown,
        Language::Matlab,
        Language::Nix,
        Language::OCaml,
        Language::Objective_C,
        Language::Objective_CPP,
        Language::PHP,
        Language::PLSQL,
        Language::Perl,
        Language::PowerShell,
        Language::Prolog,
        Language::Python,
        Language::R,
        Language::Racket,
        Language::Raku,
        Language::Razor,
        Language::ReST,
        Language::Ruby,
        Language::Rust,
        Language::SAS,
        Language::SCSS,
        Language::SML,
        Language::SQL,
        Language::Sass,
        Language::Scala,
        Language::Scheme,
        Language::ShellScript,
        Language::Skylark,
        Language::Swift,
        Language::TOML,
        Language::TeX,
        Language::TypeScript,
        Language::TypeScriptReact,
        Language::VisualBasic,
        Language::Vue,
        Language::Wolfram,
        Language::XML,
        Language::XSL,
        Language::YAML,
        Language::Zig,
    ];
}

impl ::protobuf::EnumFull for Language {
    fn enum_descriptor() -> ::protobuf::reflect::EnumDescriptor {
        static descriptor: ::protobuf::rt::Lazy<::protobuf::reflect::EnumDescriptor> = ::protobuf::rt::Lazy::new();
        descriptor.get(|| file_descriptor().enum_by_package_relative_name("Language").unwrap()).clone()
    }

    fn descriptor(&self) -> ::protobuf::reflect::EnumValueDescriptor {
        let index = match self {
            Language::UnspecifiedLanguage => 0,
            Language::ABAP => 1,
            Language::APL => 2,
            Language::Ada => 3,
            Language::Agda => 4,
            Language::AsciiDoc => 5,
            Language::Assembly => 6,
            Language::Awk => 7,
            Language::Bat => 8,
            Language::BibTeX => 9,
            Language::C => 10,
            Language::COBOL => 11,
            Language::CPP => 12,
            Language::CSS => 13,
            Language::CSharp => 14,
            Language::Clojure => 15,
            Language::Coffeescript => 16,
            Language::CommonLisp => 17,
            Language::Coq => 18,
            Language::Dart => 19,
            Language::Delphi => 20,
            Language::Diff => 21,
            Language::Dockerfile => 22,
            Language::Dyalog => 23,
            Language::Elixir => 24,
            Language::Erlang => 25,
            Language::FSharp => 26,
            Language::Fish => 27,
            Language::Flow => 28,
            Language::Fortran => 29,
            Language::Git_Commit => 30,
            Language::Git_Config => 31,
            Language::Git_Rebase => 32,
            Language::Go => 33,
            Language::Groovy => 34,
            Language::HTML => 35,
            Language::Hack => 36,
            Language::Handlebars => 37,
            Language::Haskell => 38,
            Language::Idris => 39,
            Language::Ini => 40,
            Language::J => 41,
            Language::JSON => 42,
            Language::Java => 43,
            Language::JavaScript => 44,
            Language::JavaScriptReact => 45,
            Language::Jsonnet => 46,
            Language::Julia => 47,
            Language::Kotlin => 48,
            Language::LaTeX => 49,
            Language::Lean => 50,
            Language::Less => 51,
            Language::Lua => 52,
            Language::Makefile => 53,
            Language::Markdown => 54,
            Language::Matlab => 55,
            Language::Nix => 56,
            Language::OCaml => 57,
            Language::Objective_C => 58,
            Language::Objective_CPP => 59,
            Language::PHP => 60,
            Language::PLSQL => 61,
            Language::Perl => 62,
            Language::PowerShell => 63,
            Language::Prolog => 64,
            Language::Python => 65,
            Language::R => 66,
            Language::Racket => 67,
            Language::Raku => 68,
            Language::Razor => 69,
            Language::ReST => 70,
            Language::Ruby => 71,
            Language::Rust => 72,
            Language::SAS => 73,
            Language::SCSS => 74,
            Language::SML => 75,
            Language::SQL => 76,
            Language::Sass => 77,
            Language::Scala => 78,
            Language::Scheme => 79,
            Language::ShellScript => 80,
            Language::Skylark => 81,
            Language::Swift => 82,
            Language::TOML => 83,
            Language::TeX => 84,
            Language::TypeScript => 85,
            Language::TypeScriptReact => 86,
            Language::VisualBasic => 87,
            Language::Vue => 88,
            Language::Wolfram => 89,
            Language::XML => 90,
            Language::XSL => 91,
            Language::YAML => 92,
            Language::Zig => 93,
        };
        Self::enum_descriptor().value_by_index(index)
    }
}

impl ::std::default::Default for Language {
    fn default() -> Self {
        Language::UnspecifiedLanguage
    }
}

impl Language {
    fn generated_enum_descriptor_data() -> ::protobuf::reflect::GeneratedEnumDescriptorData {
        ::protobuf::reflect::GeneratedEnumDescriptorData::new::<Language>("Language")
    }
}

static file_descriptor_proto_data: &'static [u8] = b"\
    \n\nscip.proto\x12\x04scip\"\xa5\x01\n\x05Index\x12*\n\x08metadata\x18\
    \x01\x20\x01(\x0b2\x0e.scip.MetadataR\x08metadata\x12,\n\tdocuments\x18\
    \x02\x20\x03(\x0b2\x0e.scip.DocumentR\tdocuments\x12B\n\x10external_symb\
    ols\x18\x03\x20\x03(\x0b2\x17.scip.SymbolInformationR\x0fexternalSymbols\
    \"\xd5\x01\n\x08Metadata\x12/\n\x07version\x18\x01\x20\x01(\x0e2\x15.sci\
    p.ProtocolVersionR\x07version\x12+\n\ttool_info\x18\x02\x20\x01(\x0b2\
    \x0e.scip.ToolInfoR\x08toolInfo\x12!\n\x0cproject_root\x18\x03\x20\x01(\
    \tR\x0bprojectRoot\x12H\n\x16text_document_encoding\x18\x04\x20\x01(\x0e\
    2\x12.scip.TextEncodingR\x14textDocumentEncoding\"V\n\x08ToolInfo\x12\
    \x12\n\x04name\x18\x01\x20\x01(\tR\x04name\x12\x18\n\x07version\x18\x02\
    \x20\x01(\tR\x07version\x12\x1c\n\targuments\x18\x03\x20\x03(\tR\targume\
    nts\"\xb2\x01\n\x08Document\x12\x1a\n\x08language\x18\x04\x20\x01(\tR\
    \x08language\x12#\n\rrelative_path\x18\x01\x20\x01(\tR\x0crelativePath\
    \x122\n\x0boccurrences\x18\x02\x20\x03(\x0b2\x10.scip.OccurrenceR\x0bocc\
    urrences\x121\n\x07symbols\x18\x03\x20\x03(\x0b2\x17.scip.SymbolInformat\
    ionR\x07symbols\"}\n\x06Symbol\x12\x16\n\x06scheme\x18\x01\x20\x01(\tR\
    \x06scheme\x12'\n\x07package\x18\x02\x20\x01(\x0b2\r.scip.PackageR\x07pa\
    ckage\x122\n\x0bdescriptors\x18\x03\x20\x03(\x0b2\x10.scip.DescriptorR\
    \x0bdescriptors\"Q\n\x07Package\x12\x18\n\x07manager\x18\x01\x20\x01(\tR\
    \x07manager\x12\x12\n\x04name\x18\x02\x20\x01(\tR\x04name\x12\x18\n\x07v\
    ersion\x18\x03\x20\x01(\tR\x07version\"\x9f\x02\n\nDescriptor\x12\x12\n\
    \x04name\x18\x01\x20\x01(\tR\x04name\x12$\n\rdisambiguator\x18\x02\x20\
    \x01(\tR\rdisambiguator\x12/\n\x06suffix\x18\x03\x20\x01(\x0e2\x17.scip.\
    Descriptor.SuffixR\x06suffix\"\xa5\x01\n\x06Suffix\x12\x15\n\x11Unspecif\
    iedSuffix\x10\0\x12\r\n\tNamespace\x10\x01\x12\x0f\n\x07Package\x10\x01\
    \x1a\x02\x08\x01\x12\x08\n\x04Type\x10\x02\x12\x08\n\x04Term\x10\x03\x12\
    \n\n\x06Method\x10\x04\x12\x11\n\rTypeParameter\x10\x05\x12\r\n\tParamet\
    er\x10\x06\x12\t\n\x05Macro\x10\t\x12\x08\n\x04Meta\x10\x07\x12\t\n\x05L\
    ocal\x10\x08\x1a\x02\x10\x01\"\x8b\x01\n\x11SymbolInformation\x12\x16\n\
    \x06symbol\x18\x01\x20\x01(\tR\x06symbol\x12$\n\rdocumentation\x18\x03\
    \x20\x03(\tR\rdocumentation\x128\n\rrelationships\x18\x04\x20\x03(\x0b2\
    \x12.scip.RelationshipR\rrelationships\"\xc9\x01\n\x0cRelationship\x12\
    \x16\n\x06symbol\x18\x01\x20\x01(\tR\x06symbol\x12!\n\x0cis_reference\
    \x18\x02\x20\x01(\x08R\x0bisReference\x12+\n\x11is_implementation\x18\
    \x03\x20\x01(\x08R\x10isImplementation\x12,\n\x12is_type_definition\x18\
    \x04\x20\x01(\x08R\x10isTypeDefinition\x12#\n\ris_definition\x18\x05\x20\
    \x01(\x08R\x0cisDefinition\"\xfb\x01\n\nOccurrence\x12\x14\n\x05range\
    \x18\x01\x20\x03(\x05R\x05range\x12\x16\n\x06symbol\x18\x02\x20\x01(\tR\
    \x06symbol\x12!\n\x0csymbol_roles\x18\x03\x20\x01(\x05R\x0bsymbolRoles\
    \x125\n\x16override_documentation\x18\x04\x20\x03(\tR\x15overrideDocumen\
    tation\x121\n\x0bsyntax_kind\x18\x05\x20\x01(\x0e2\x10.scip.SyntaxKindR\
    \nsyntaxKind\x122\n\x0bdiagnostics\x18\x06\x20\x03(\x0b2\x10.scip.Diagno\
    sticR\x0bdiagnostics\"\xa7\x01\n\nDiagnostic\x12*\n\x08severity\x18\x01\
    \x20\x01(\x0e2\x0e.scip.SeverityR\x08severity\x12\x12\n\x04code\x18\x02\
    \x20\x01(\tR\x04code\x12\x18\n\x07message\x18\x03\x20\x01(\tR\x07message\
    \x12\x16\n\x06source\x18\x04\x20\x01(\tR\x06source\x12'\n\x04tags\x18\
    \x05\x20\x03(\x0e2\x13.scip.DiagnosticTagR\x04tags*1\n\x0fProtocolVersio\
    n\x12\x1e\n\x1aUnspecifiedProtocolVersion\x10\0*@\n\x0cTextEncoding\x12\
    \x1b\n\x17UnspecifiedTextEncoding\x10\0\x12\x08\n\x04UTF8\x10\x01\x12\t\
    \n\x05UTF16\x10\x02*}\n\nSymbolRole\x12\x19\n\x15UnspecifiedSymbolRole\
    \x10\0\x12\x0e\n\nDefinition\x10\x01\x12\n\n\x06Import\x10\x02\x12\x0f\n\
    \x0bWriteAccess\x10\x04\x12\x0e\n\nReadAccess\x10\x08\x12\r\n\tGenerated\
    \x10\x10\x12\x08\n\x04Test\x10\x20*\xea\x06\n\nSyntaxKind\x12\x19\n\x15U\
    nspecifiedSyntaxKind\x10\0\x12\x0b\n\x07Comment\x10\x01\x12\x18\n\x14Pun\
    ctuationDelimiter\x10\x02\x12\x16\n\x12PunctuationBracket\x10\x03\x12\
    \x0b\n\x07Keyword\x10\x04\x12\x19\n\x11IdentifierKeyword\x10\x04\x1a\x02\
    \x08\x01\x12\x16\n\x12IdentifierOperator\x10\x05\x12\x0e\n\nIdentifier\
    \x10\x06\x12\x15\n\x11IdentifierBuiltin\x10\x07\x12\x12\n\x0eIdentifierN\
    ull\x10\x08\x12\x16\n\x12IdentifierConstant\x10\t\x12\x1b\n\x17Identifie\
    rMutableGlobal\x10\n\x12\x17\n\x13IdentifierParameter\x10\x0b\x12\x13\n\
    \x0fIdentifierLocal\x10\x0c\x12\x16\n\x12IdentifierShadowed\x10\r\x12\
    \x17\n\x13IdentifierNamespace\x10\x0e\x12\x18\n\x10IdentifierModule\x10\
    \x0e\x1a\x02\x08\x01\x12\x16\n\x12IdentifierFunction\x10\x0f\x12\x20\n\
    \x1cIdentifierFunctionDefinition\x10\x10\x12\x13\n\x0fIdentifierMacro\
    \x10\x11\x12\x1d\n\x19IdentifierMacroDefinition\x10\x12\x12\x12\n\x0eIde\
    ntifierType\x10\x13\x12\x19\n\x15IdentifierBuiltinType\x10\x14\x12\x17\n\
    \x13IdentifierAttribute\x10\x15\x12\x0f\n\x0bRegexEscape\x10\x16\x12\x11\
    \n\rRegexRepeated\x10\x17\x12\x11\n\rRegexWildcard\x10\x18\x12\x12\n\x0e\
    RegexDelimiter\x10\x19\x12\r\n\tRegexJoin\x10\x1a\x12\x11\n\rStringLiter\
    al\x10\x1b\x12\x17\n\x13StringLiteralEscape\x10\x1c\x12\x18\n\x14StringL\
    iteralSpecial\x10\x1d\x12\x14\n\x10StringLiteralKey\x10\x1e\x12\x14\n\
    \x10CharacterLiteral\x10\x1f\x12\x12\n\x0eNumericLiteral\x10\x20\x12\x12\
    \n\x0eBooleanLiteral\x10!\x12\x07\n\x03Tag\x10\"\x12\x10\n\x0cTagAttribu\
    te\x10#\x12\x10\n\x0cTagDelimiter\x10$\x1a\x02\x10\x01*V\n\x08Severity\
    \x12\x17\n\x13UnspecifiedSeverity\x10\0\x12\t\n\x05Error\x10\x01\x12\x0b\
    \n\x07Warning\x10\x02\x12\x0f\n\x0bInformation\x10\x03\x12\x08\n\x04Hint\
    \x10\x04*N\n\rDiagnosticTag\x12\x1c\n\x18UnspecifiedDiagnosticTag\x10\0\
    \x12\x0f\n\x0bUnnecessary\x10\x01\x12\x0e\n\nDeprecated\x10\x02*\xe0\x08\
    \n\x08Language\x12\x17\n\x13UnspecifiedLanguage\x10\0\x12\x08\n\x04ABAP\
    \x10<\x12\x07\n\x03APL\x101\x12\x07\n\x03Ada\x10'\x12\x08\n\x04Agda\x10-\
    \x12\x0c\n\x08AsciiDoc\x10V\x12\x0c\n\x08Assembly\x10:\x12\x07\n\x03Awk\
    \x10B\x12\x07\n\x03Bat\x10D\x12\n\n\x06BibTeX\x10Q\x12\x05\n\x01C\x10\"\
    \x12\t\n\x05COBOL\x10;\x12\x07\n\x03CPP\x10#\x12\x07\n\x03CSS\x10\x1a\
    \x12\n\n\x06CSharp\x10\x01\x12\x0b\n\x07Clojure\x10\x08\x12\x10\n\x0cCof\
    feescript\x10\x15\x12\x0e\n\nCommonLisp\x10\t\x12\x07\n\x03Coq\x10/\x12\
    \x08\n\x04Dart\x10\x03\x12\n\n\x06Delphi\x109\x12\x08\n\x04Diff\x10X\x12\
    \x0e\n\nDockerfile\x10P\x12\n\n\x06Dyalog\x102\x12\n\n\x06Elixir\x10\x11\
    \x12\n\n\x06Erlang\x10\x12\x12\n\n\x06FSharp\x10*\x12\x08\n\x04Fish\x10A\
    \x12\x08\n\x04Flow\x10\x18\x12\x0b\n\x07Fortran\x108\x12\x0e\n\nGit_Comm\
    it\x10[\x12\x0e\n\nGit_Config\x10Y\x12\x0e\n\nGit_Rebase\x10\\\x12\x06\n\
    \x02Go\x10!\x12\n\n\x06Groovy\x10\x07\x12\x08\n\x04HTML\x10\x1e\x12\x08\
    \n\x04Hack\x10\x14\x12\x0e\n\nHandlebars\x10Z\x12\x0b\n\x07Haskell\x10,\
    \x12\t\n\x05Idris\x10.\x12\x07\n\x03Ini\x10H\x12\x05\n\x01J\x103\x12\x08\
    \n\x04JSON\x10K\x12\x08\n\x04Java\x10\x06\x12\x0e\n\nJavaScript\x10\x16\
    \x12\x13\n\x0fJavaScriptReact\x10]\x12\x0b\n\x07Jsonnet\x10L\x12\t\n\x05\
    Julia\x107\x12\n\n\x06Kotlin\x10\x04\x12\t\n\x05LaTeX\x10S\x12\x08\n\x04\
    Lean\x100\x12\x08\n\x04Less\x10\x1b\x12\x07\n\x03Lua\x10\x0c\x12\x0c\n\
    \x08Makefile\x10O\x12\x0c\n\x08Markdown\x10T\x12\n\n\x06Matlab\x104\x12\
    \x07\n\x03Nix\x10M\x12\t\n\x05OCaml\x10)\x12\x0f\n\x0bObjective_C\x10$\
    \x12\x11\n\rObjective_CPP\x10%\x12\x07\n\x03PHP\x10\x13\x12\t\n\x05PLSQL\
    \x10F\x12\x08\n\x04Perl\x10\r\x12\x0e\n\nPowerShell\x10C\x12\n\n\x06Prol\
    og\x10G\x12\n\n\x06Python\x10\x0f\x12\x05\n\x01R\x106\x12\n\n\x06Racket\
    \x10\x0b\x12\x08\n\x04Raku\x10\x0e\x12\t\n\x05Razor\x10>\x12\x08\n\x04Re\
    ST\x10U\x12\x08\n\x04Ruby\x10\x10\x12\x08\n\x04Rust\x10(\x12\x07\n\x03SA\
    S\x10=\x12\x08\n\x04SCSS\x10\x1d\x12\x07\n\x03SML\x10+\x12\x07\n\x03SQL\
    \x10E\x12\x08\n\x04Sass\x10\x1c\x12\t\n\x05Scala\x10\x05\x12\n\n\x06Sche\
    me\x10\n\x12\x0f\n\x0bShellScript\x10@\x12\x0b\n\x07Skylark\x10N\x12\t\n\
    \x05Swift\x10\x02\x12\x08\n\x04TOML\x10I\x12\x07\n\x03TeX\x10R\x12\x0e\n\
    \nTypeScript\x10\x17\x12\x13\n\x0fTypeScriptReact\x10^\x12\x0f\n\x0bVisu\
    alBasic\x10?\x12\x07\n\x03Vue\x10\x19\x12\x0b\n\x07Wolfram\x105\x12\x07\
    \n\x03XML\x10\x1f\x12\x07\n\x03XSL\x10\x20\x12\x08\n\x04YAML\x10J\x12\
    \x07\n\x03Zig\x10&B/Z-github.com/sourcegraph/scip/bindings/go/scip/J\xf6\
    \xc0\x01\n\x07\x12\x05\n\0\xa2\x04\x01\n\x82\x04\n\x01\x0c\x12\x03\n\0\
    \x122\xf7\x03\x20An\x20index\x20contains\x20one\x20or\x20more\x20pieces\
    \x20of\x20information\x20about\x20a\x20given\x20piece\x20of\n\x20source\
    \x20code\x20or\x20software\x20artifact.\x20Complementary\x20information\
    \x20can\x20be\x20merged\n\x20together\x20from\x20multiple\x20sources\x20\
    to\x20provide\x20a\x20unified\x20code\x20intelligence\n\x20experience.\n\
    \n\x20Programs\x20producing\x20a\x20file\x20of\x20this\x20format\x20is\
    \x20an\x20\"indexer\"\x20and\x20may\x20operate\n\x20somewhere\x20on\x20t\
    he\x20spectrum\x20between\x20precision,\x20such\x20as\x20indexes\x20prod\
    uced\x20by\n\x20compiler-backed\x20indexers,\x20and\x20heurstics,\x20suc\
    h\x20as\x20indexes\x20produced\x20by\x20local\n\x20syntax-directed\x20an\
    alysis\x20for\x20scope\x20rules.\n\n\x08\n\x01\x02\x12\x03\x0c\0\r\n\x08\
    \n\x01\x08\x12\x03\x0e\0D\n\t\n\x02\x08\x0b\x12\x03\x0e\0D\n\xd0\x03\n\
    \x02\x04\0\x12\x04\x16\0!\x01\x1a\xc3\x03\x20Index\x20represents\x20a\
    \x20complete\x20SCIP\x20index\x20for\x20a\x20workspace\x20this\x20is\x20\
    rooted\x20at\x20a\n\x20single\x20directory.\x20An\x20Index\x20message\
    \x20payload\x20can\x20have\x20a\x20large\x20memory\x20footprint\n\x20and\
    \x20it's\x20therefore\x20recommended\x20to\x20emit\x20and\x20consume\x20\
    an\x20Index\x20payload\x20one\x20field\n\x20value\x20at\x20a\x20time.\
    \x20To\x20permit\x20streaming\x20consumption\x20of\x20an\x20Index\x20pay\
    load,\x20the\n\x20`metadata`\x20field\x20must\x20appear\x20at\x20the\x20\
    start\x20of\x20the\x20stream\x20and\x20must\x20only\x20appear\n\x20once\
    \x20in\x20the\x20stream.\x20Other\x20field\x20values\x20may\x20appear\
    \x20in\x20any\x20order.\n\n\n\n\x03\x04\0\x01\x12\x03\x16\x08\r\n)\n\x04\
    \x04\0\x02\0\x12\x03\x18\x02\x18\x1a\x1c\x20Metadata\x20about\x20this\
    \x20index.\n\n\x0c\n\x05\x04\0\x02\0\x06\x12\x03\x18\x02\n\n\x0c\n\x05\
    \x04\0\x02\0\x01\x12\x03\x18\x0b\x13\n\x0c\n\x05\x04\0\x02\0\x03\x12\x03\
    \x18\x16\x17\n3\n\x04\x04\0\x02\x01\x12\x03\x1a\x02\"\x1a&\x20Documents\
    \x20that\x20belong\x20to\x20this\x20index.\n\n\x0c\n\x05\x04\0\x02\x01\
    \x04\x12\x03\x1a\x02\n\n\x0c\n\x05\x04\0\x02\x01\x06\x12\x03\x1a\x0b\x13\
    \n\x0c\n\x05\x04\0\x02\x01\x01\x12\x03\x1a\x14\x1d\n\x0c\n\x05\x04\0\x02\
    \x01\x03\x12\x03\x1a\x20!\n\xf7\x02\n\x04\x04\0\x02\x02\x12\x03\x20\x022\
    \x1a\xe9\x02\x20(optional)\x20Symbols\x20that\x20are\x20referenced\x20fr\
    om\x20this\x20index\x20but\x20are\x20defined\x20in\n\x20an\x20external\
    \x20package\x20(a\x20separate\x20`Index`\x20message).\x20Leave\x20this\
    \x20field\x20empty\n\x20if\x20you\x20assume\x20the\x20external\x20packag\
    e\x20will\x20get\x20indexed\x20separately.\x20If\x20the\n\x20external\
    \x20package\x20won't\x20get\x20indexed\x20for\x20some\x20reason\x20then\
    \x20you\x20can\x20use\x20this\n\x20field\x20to\x20provide\x20hover\x20do\
    cumentation\x20for\x20those\x20external\x20symbols.\n\n\x0c\n\x05\x04\0\
    \x02\x02\x04\x12\x03\x20\x02\n\n\x0c\n\x05\x04\0\x02\x02\x06\x12\x03\x20\
    \x0b\x1c\n\x0c\n\x05\x04\0\x02\x02\x01\x12\x03\x20\x1d-\n\x0c\n\x05\x04\
    \0\x02\x02\x03\x12\x03\x2001\n\n\n\x02\x04\x01\x12\x04#\0/\x01\n\n\n\x03\
    \x04\x01\x01\x12\x03#\x08\x10\nN\n\x04\x04\x01\x02\0\x12\x03%\x02\x1e\
    \x1aA\x20Which\x20version\x20of\x20this\x20protocol\x20was\x20used\x20to\
    \x20generate\x20this\x20index?\n\n\x0c\n\x05\x04\x01\x02\0\x06\x12\x03%\
    \x02\x11\n\x0c\n\x05\x04\x01\x02\0\x01\x12\x03%\x12\x19\n\x0c\n\x05\x04\
    \x01\x02\0\x03\x12\x03%\x1c\x1d\nC\n\x04\x04\x01\x02\x01\x12\x03'\x02\
    \x19\x1a6\x20Information\x20about\x20the\x20tool\x20that\x20produced\x20\
    this\x20index.\n\n\x0c\n\x05\x04\x01\x02\x01\x06\x12\x03'\x02\n\n\x0c\n\
    \x05\x04\x01\x02\x01\x01\x12\x03'\x0b\x14\n\x0c\n\x05\x04\x01\x02\x01\
    \x03\x12\x03'\x17\x18\n\xa2\x01\n\x04\x04\x01\x02\x02\x12\x03+\x02\x1a\
    \x1a\x94\x01\x20URI-encoded\x20absolute\x20path\x20to\x20the\x20root\x20\
    directory\x20of\x20this\x20index.\x20All\n\x20documents\x20in\x20this\
    \x20index\x20must\x20appear\x20in\x20a\x20subdirectory\x20of\x20this\x20\
    root\n\x20directory.\n\n\x0c\n\x05\x04\x01\x02\x02\x05\x12\x03+\x02\x08\
    \n\x0c\n\x05\x04\x01\x02\x02\x01\x12\x03+\t\x15\n\x0c\n\x05\x04\x01\x02\
    \x02\x03\x12\x03+\x18\x19\nl\n\x04\x04\x01\x02\x03\x12\x03.\x02*\x1a_\
    \x20Text\x20encoding\x20of\x20the\x20source\x20files\x20on\x20disk\x20th\
    at\x20are\x20referenced\x20from\n\x20`Document.relative_path`.\n\n\x0c\n\
    \x05\x04\x01\x02\x03\x06\x12\x03.\x02\x0e\n\x0c\n\x05\x04\x01\x02\x03\
    \x01\x12\x03.\x0f%\n\x0c\n\x05\x04\x01\x02\x03\x03\x12\x03.()\n\n\n\x02\
    \x05\0\x12\x041\03\x01\n\n\n\x03\x05\0\x01\x12\x031\x05\x14\n\x0b\n\x04\
    \x05\0\x02\0\x12\x032\x02!\n\x0c\n\x05\x05\0\x02\0\x01\x12\x032\x02\x1c\
    \n\x0c\n\x05\x05\0\x02\0\x02\x12\x032\x1f\x20\n\n\n\x02\x05\x01\x12\x045\
    \09\x01\n\n\n\x03\x05\x01\x01\x12\x035\x05\x11\n\x0b\n\x04\x05\x01\x02\0\
    \x12\x036\x02\x1e\n\x0c\n\x05\x05\x01\x02\0\x01\x12\x036\x02\x19\n\x0c\n\
    \x05\x05\x01\x02\0\x02\x12\x036\x1c\x1d\n\x0b\n\x04\x05\x01\x02\x01\x12\
    \x037\x02\x0b\n\x0c\n\x05\x05\x01\x02\x01\x01\x12\x037\x02\x06\n\x0c\n\
    \x05\x05\x01\x02\x01\x02\x12\x037\t\n\n\x0b\n\x04\x05\x01\x02\x02\x12\
    \x038\x02\x0c\n\x0c\n\x05\x05\x01\x02\x02\x01\x12\x038\x02\x07\n\x0c\n\
    \x05\x05\x01\x02\x02\x02\x12\x038\n\x0b\n\n\n\x02\x04\x02\x12\x04;\0B\
    \x01\n\n\n\x03\x04\x02\x01\x12\x03;\x08\x10\n<\n\x04\x04\x02\x02\0\x12\
    \x03=\x02\x12\x1a/\x20Name\x20of\x20the\x20indexer\x20that\x20produced\
    \x20this\x20index.\n\n\x0c\n\x05\x04\x02\x02\0\x05\x12\x03=\x02\x08\n\
    \x0c\n\x05\x04\x02\x02\0\x01\x12\x03=\t\r\n\x0c\n\x05\x04\x02\x02\0\x03\
    \x12\x03=\x10\x11\n?\n\x04\x04\x02\x02\x01\x12\x03?\x02\x15\x1a2\x20Vers\
    ion\x20of\x20the\x20indexer\x20that\x20produced\x20this\x20index.\n\n\
    \x0c\n\x05\x04\x02\x02\x01\x05\x12\x03?\x02\x08\n\x0c\n\x05\x04\x02\x02\
    \x01\x01\x12\x03?\t\x10\n\x0c\n\x05\x04\x02\x02\x01\x03\x12\x03?\x13\x14\
    \nL\n\x04\x04\x02\x02\x02\x12\x03A\x02\x20\x1a?\x20Command-line\x20argum\
    ents\x20that\x20were\x20used\x20to\x20invoke\x20this\x20indexer.\n\n\x0c\
    \n\x05\x04\x02\x02\x02\x04\x12\x03A\x02\n\n\x0c\n\x05\x04\x02\x02\x02\
    \x05\x12\x03A\x0b\x11\n\x0c\n\x05\x04\x02\x02\x02\x01\x12\x03A\x12\x1b\n\
    \x0c\n\x05\x04\x02\x02\x02\x03\x12\x03A\x1e\x1f\nH\n\x02\x04\x03\x12\x04\
    E\0]\x01\x1a<\x20Document\x20defines\x20the\x20metadata\x20about\x20a\
    \x20source\x20file\x20on\x20disk.\n\n\n\n\x03\x04\x03\x01\x12\x03E\x08\
    \x10\n\xa5\x02\n\x04\x04\x03\x02\0\x12\x03J\x02\x16\x1a\x97\x02\x20The\
    \x20string\x20ID\x20for\x20the\x20programming\x20language\x20this\x20fil\
    e\x20is\x20written\x20in.\n\x20The\x20`Language`\x20enum\x20contains\x20\
    the\x20names\x20of\x20most\x20common\x20programming\x20languages.\n\x20T\
    his\x20field\x20is\x20typed\x20as\x20a\x20string\x20to\x20permit\x20any\
    \x20programming\x20langauge,\x20including\n\x20ones\x20that\x20are\x20no\
    t\x20specified\x20by\x20the\x20`Language`\x20enum.\n\n\x0c\n\x05\x04\x03\
    \x02\0\x05\x12\x03J\x02\x08\n\x0c\n\x05\x04\x03\x02\0\x01\x12\x03J\t\x11\
    \n\x0c\n\x05\x04\x03\x02\0\x03\x12\x03J\x14\x15\n\xb5\x03\n\x04\x04\x03\
    \x02\x01\x12\x03T\x02\x1b\x1a\xa7\x03\x20(Required)\x20Unique\x20path\
    \x20to\x20the\x20text\x20document.\n\n\x201.\x20The\x20path\x20must\x20b\
    e\x20relative\x20to\x20the\x20directory\x20supplied\x20in\x20the\x20asso\
    ciated\n\x20\x20\x20\x20`Metadata.project_root`.\n\x202.\x20The\x20path\
    \x20must\x20not\x20begin\x20with\x20a\x20leading\x20'/'.\n\x203.\x20The\
    \x20path\x20must\x20point\x20to\x20a\x20regular\x20file,\x20not\x20a\x20\
    symbolic\x20link.\n\x204.\x20The\x20path\x20must\x20use\x20'/'\x20as\x20\
    the\x20separator,\x20including\x20on\x20Windows.\n\x205.\x20The\x20path\
    \x20must\x20be\x20canonical;\x20it\x20cannot\x20include\x20empty\x20comp\
    onents\x20('//'),\n\x20\x20\x20\x20or\x20'.'\x20or\x20'..'.\n\n\x0c\n\
    \x05\x04\x03\x02\x01\x05\x12\x03T\x02\x08\n\x0c\n\x05\x04\x03\x02\x01\
    \x01\x12\x03T\t\x16\n\x0c\n\x05\x04\x03\x02\x01\x03\x12\x03T\x19\x1a\n4\
    \n\x04\x04\x03\x02\x02\x12\x03V\x02&\x1a'\x20Occurrences\x20that\x20appe\
    ar\x20in\x20this\x20file.\n\n\x0c\n\x05\x04\x03\x02\x02\x04\x12\x03V\x02\
    \n\n\x0c\n\x05\x04\x03\x02\x02\x06\x12\x03V\x0b\x15\n\x0c\n\x05\x04\x03\
    \x02\x02\x01\x12\x03V\x16!\n\x0c\n\x05\x04\x03\x02\x02\x03\x12\x03V$%\n\
    \xea\x01\n\x04\x04\x03\x02\x03\x12\x03\\\x02)\x1a\xdc\x01\x20Symbols\x20\
    that\x20are\x20\"defined\"\x20within\x20this\x20document.\n\n\x20This\
    \x20should\x20include\x20symbols\x20which\x20technically\x20do\x20not\
    \x20have\x20any\x20definition,\n\x20but\x20have\x20a\x20reference\x20and\
    \x20are\x20defined\x20by\x20some\x20other\x20symbol\x20(see\n\x20Relatio\
    nship.is_definition).\n\n\x0c\n\x05\x04\x03\x02\x03\x04\x12\x03\\\x02\n\
    \n\x0c\n\x05\x04\x03\x02\x03\x06\x12\x03\\\x0b\x1c\n\x0c\n\x05\x04\x03\
    \x02\x03\x01\x12\x03\\\x1d$\n\x0c\n\x05\x04\x03\x02\x03\x03\x12\x03\\'(\
    \n\xc2\x0f\n\x02\x04\x04\x12\x06\x84\x01\0\x88\x01\x01\x1a\xb3\x0f\x20Sy\
    mbol\x20is\x20similar\x20to\x20a\x20URI,\x20it\x20identifies\x20a\x20cla\
    ss,\x20method,\x20or\x20a\x20local\n\x20variable.\x20`SymbolInformation`\
    \x20contains\x20rich\x20metadata\x20about\x20symbols\x20such\x20as\n\x20\
    the\x20docstring.\n\n\x20Symbol\x20has\x20a\x20standardized\x20string\
    \x20representation,\x20which\x20can\x20be\x20used\n\x20interchangeably\
    \x20with\x20`Symbol`.\x20The\x20syntax\x20for\x20Symbol\x20is\x20the\x20\
    following:\n\x20```\n\x20#\x20(<x>)+\x20stands\x20for\x20one\x20or\x20mo\
    re\x20repetitions\x20of\x20<x>\n\x20<symbol>\x20\x20\x20\x20\x20\x20\x20\
    \x20\x20\x20\x20\x20\x20\x20\x20::=\x20<scheme>\x20'\x20'\x20<package>\
    \x20'\x20'\x20(<descriptor>)+\x20|\x20'local\x20'\x20<local-id>\n\x20<pa\
    ckage>\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20::=\x20<ma\
    nager>\x20'\x20'\x20<package-name>\x20'\x20'\x20<version>\n\x20<scheme>\
    \x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20::=\x20any\
    \x20UTF-8,\x20escape\x20spaces\x20with\x20double\x20space.\n\x20<manager\
    >\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20::=\x20same\x20\
    as\x20above,\x20use\x20the\x20placeholder\x20'.'\x20to\x20indicate\x20an\
    \x20empty\x20value\n\x20<package-name>\x20\x20\x20\x20\x20\x20\x20\x20\
    \x20::=\x20same\x20as\x20above\n\x20<version>\x20\x20\x20\x20\x20\x20\
    \x20\x20\x20\x20\x20\x20\x20\x20::=\x20same\x20as\x20above\n\x20<descrip\
    tor>\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20::=\x20<namespace>\x20|\
    \x20<type>\x20|\x20<term>\x20|\x20<method>\x20|\x20<type-parameter>\x20|\
    \x20<parameter>\x20|\x20<meta>\n\x20<namespace>\x20\x20\x20\x20\x20\x20\
    \x20\x20\x20\x20\x20\x20::=\x20<name>\x20'/'\n\x20<type>\x20\x20\x20\x20\
    \x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20::=\x20<name>\x20'#'\
    \n\x20<term>\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\
    \x20\x20::=\x20<name>\x20'.'\n\x20<meta>\x20\x20\x20\x20\x20\x20\x20\x20\
    \x20\x20\x20\x20\x20\x20\x20\x20\x20::=\x20<name>\x20':'\n\x20<method>\
    \x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20::=\x20<name\
    >\x20'('\x20<method-disambiguator>\x20').'\n\x20<type-parameter>\x20\x20\
    \x20\x20\x20\x20\x20::=\x20'['\x20<name>\x20']'\n\x20<parameter>\x20\x20\
    \x20\x20\x20\x20\x20\x20\x20\x20\x20\x20::=\x20'('\x20<name>\x20')'\n\
    \x20<name>\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\
    \x20\x20::=\x20<identifier>\n\x20<method-disambiguator>\x20::=\x20<simpl\
    e-identifier>\n\x20<identifier>\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\
    \x20::=\x20<simple-identifier>\x20|\x20<escaped-identifier>\n\x20<simple\
    -identifier>\x20\x20\x20\x20::=\x20(<identifier-character>)+\n\x20<ident\
    ifier-character>\x20::=\x20'_'\x20|\x20'+'\x20|\x20'-'\x20|\x20'$'\x20|\
    \x20ASCII\x20letter\x20or\x20digit\n\x20<escaped-identifier>\x20\x20\x20\
    ::=\x20'`'\x20(<escaped-character>)+\x20'`'\n\x20<escaped-characters>\
    \x20\x20\x20::=\x20any\x20UTF-8\x20character,\x20escape\x20backticks\x20\
    with\x20double\x20backtick.\n\x20```\n\n\x20The\x20list\x20of\x20descrip\
    tors\x20for\x20a\x20symbol\x20should\x20together\x20form\x20a\x20fully\n\
    \x20qualified\x20name\x20for\x20the\x20symbol.\x20That\x20is,\x20it\x20s\
    hould\x20serve\x20as\x20a\x20unique\n\x20identifier\x20across\x20the\x20\
    package.\x20Typically,\x20it\x20will\x20include\x20one\x20descriptor\n\
    \x20for\x20every\x20node\x20in\x20the\x20AST\x20(along\x20the\x20ancestr\
    y\x20path)\x20between\x20the\x20root\x20of\n\x20the\x20file\x20and\x20th\
    e\x20node\x20corresponding\x20to\x20the\x20symbol.\n\n\x0b\n\x03\x04\x04\
    \x01\x12\x04\x84\x01\x08\x0e\n\x0c\n\x04\x04\x04\x02\0\x12\x04\x85\x01\
    \x02\x14\n\r\n\x05\x04\x04\x02\0\x05\x12\x04\x85\x01\x02\x08\n\r\n\x05\
    \x04\x04\x02\0\x01\x12\x04\x85\x01\t\x0f\n\r\n\x05\x04\x04\x02\0\x03\x12\
    \x04\x85\x01\x12\x13\n\x0c\n\x04\x04\x04\x02\x01\x12\x04\x86\x01\x02\x16\
    \n\r\n\x05\x04\x04\x02\x01\x06\x12\x04\x86\x01\x02\t\n\r\n\x05\x04\x04\
    \x02\x01\x01\x12\x04\x86\x01\n\x11\n\r\n\x05\x04\x04\x02\x01\x03\x12\x04\
    \x86\x01\x14\x15\n\x0c\n\x04\x04\x04\x02\x02\x12\x04\x87\x01\x02&\n\r\n\
    \x05\x04\x04\x02\x02\x04\x12\x04\x87\x01\x02\n\n\r\n\x05\x04\x04\x02\x02\
    \x06\x12\x04\x87\x01\x0b\x15\n\r\n\x05\x04\x04\x02\x02\x01\x12\x04\x87\
    \x01\x16!\n\r\n\x05\x04\x04\x02\x02\x03\x12\x04\x87\x01$%\nq\n\x02\x04\
    \x05\x12\x06\x8d\x01\0\x91\x01\x01\x1ac\x20Unit\x20of\x20packaging\x20an\
    d\x20distribution.\n\n\x20NOTE:\x20This\x20corresponds\x20to\x20a\x20mod\
    ule\x20in\x20Go\x20and\x20JVM\x20languages.\n\n\x0b\n\x03\x04\x05\x01\
    \x12\x04\x8d\x01\x08\x0f\n\x0c\n\x04\x04\x05\x02\0\x12\x04\x8e\x01\x02\
    \x15\n\r\n\x05\x04\x05\x02\0\x05\x12\x04\x8e\x01\x02\x08\n\r\n\x05\x04\
    \x05\x02\0\x01\x12\x04\x8e\x01\t\x10\n\r\n\x05\x04\x05\x02\0\x03\x12\x04\
    \x8e\x01\x13\x14\n\x0c\n\x04\x04\x05\x02\x01\x12\x04\x8f\x01\x02\x12\n\r\
    \n\x05\x04\x05\x02\x01\x05\x12\x04\x8f\x01\x02\x08\n\r\n\x05\x04\x05\x02\
    \x01\x01\x12\x04\x8f\x01\t\r\n\r\n\x05\x04\x05\x02\x01\x03\x12\x04\x8f\
    \x01\x10\x11\n\x0c\n\x04\x04\x05\x02\x02\x12\x04\x90\x01\x02\x15\n\r\n\
    \x05\x04\x05\x02\x02\x05\x12\x04\x90\x01\x02\x08\n\r\n\x05\x04\x05\x02\
    \x02\x01\x12\x04\x90\x01\t\x10\n\r\n\x05\x04\x05\x02\x02\x03\x12\x04\x90\
    \x01\x13\x14\n\x0c\n\x02\x04\x06\x12\x06\x93\x01\0\xaa\x01\x01\n\x0b\n\
    \x03\x04\x06\x01\x12\x04\x93\x01\x08\x12\n\x0e\n\x04\x04\x06\x04\0\x12\
    \x06\x94\x01\x02\xa6\x01\x03\n\r\n\x05\x04\x06\x04\0\x01\x12\x04\x94\x01\
    \x07\r\n\r\n\x05\x04\x06\x04\0\x03\x12\x04\x95\x01\x04\x1e\n\x0e\n\x06\
    \x04\x06\x04\0\x03\x02\x12\x04\x95\x01\x04\x1e\n\x0e\n\x06\x04\x06\x04\0\
    \x02\0\x12\x04\x96\x01\x04\x1a\n\x0f\n\x07\x04\x06\x04\0\x02\0\x01\x12\
    \x04\x96\x01\x04\x15\n\x0f\n\x07\x04\x06\x04\0\x02\0\x02\x12\x04\x96\x01\
    \x18\x19\n}\n\x06\x04\x06\x04\0\x02\x01\x12\x04\x9a\x01\x04\x12\x1am\x20\
    Unit\x20of\x20code\x20abstraction\x20and/or\x20namespacing.\n\n\x20NOTE:\
    \x20This\x20corresponds\x20to\x20a\x20package\x20in\x20Go\x20and\x20JVM\
    \x20languages.\n\n\x0f\n\x07\x04\x06\x04\0\x02\x01\x01\x12\x04\x9a\x01\
    \x04\r\n\x0f\n\x07\x04\x06\x04\0\x02\x01\x02\x12\x04\x9a\x01\x10\x11\n(\
    \n\x06\x04\x06\x04\0\x02\x02\x12\x04\x9c\x01\x04\"\x1a\x18\x20Use\x20Nam\
    espace\x20instead.\n\n\x0f\n\x07\x04\x06\x04\0\x02\x02\x01\x12\x04\x9c\
    \x01\x04\x0b\n\x0f\n\x07\x04\x06\x04\0\x02\x02\x02\x12\x04\x9c\x01\x0e\
    \x0f\n\x0f\n\x07\x04\x06\x04\0\x02\x02\x03\x12\x04\x9c\x01\x10!\n\x10\n\
    \x08\x04\x06\x04\0\x02\x02\x03\x01\x12\x04\x9c\x01\x11\x20\n\x0e\n\x06\
    \x04\x06\x04\0\x02\x03\x12\x04\x9d\x01\x04\r\n\x0f\n\x07\x04\x06\x04\0\
    \x02\x03\x01\x12\x04\x9d\x01\x04\x08\n\x0f\n\x07\x04\x06\x04\0\x02\x03\
    \x02\x12\x04\x9d\x01\x0b\x0c\n\x0e\n\x06\x04\x06\x04\0\x02\x04\x12\x04\
    \x9e\x01\x04\r\n\x0f\n\x07\x04\x06\x04\0\x02\x04\x01\x12\x04\x9e\x01\x04\
    \x08\n\x0f\n\x07\x04\x06\x04\0\x02\x04\x02\x12\x04\x9e\x01\x0b\x0c\n\x0e\
    \n\x06\x04\x06\x04\0\x02\x05\x12\x04\x9f\x01\x04\x0f\n\x0f\n\x07\x04\x06\
    \x04\0\x02\x05\x01\x12\x04\x9f\x01\x04\n\n\x0f\n\x07\x04\x06\x04\0\x02\
    \x05\x02\x12\x04\x9f\x01\r\x0e\n\x0e\n\x06\x04\x06\x04\0\x02\x06\x12\x04\
    \xa0\x01\x04\x16\n\x0f\n\x07\x04\x06\x04\0\x02\x06\x01\x12\x04\xa0\x01\
    \x04\x11\n\x0f\n\x07\x04\x06\x04\0\x02\x06\x02\x12\x04\xa0\x01\x14\x15\n\
    \x0e\n\x06\x04\x06\x04\0\x02\x07\x12\x04\xa1\x01\x04\x12\n\x0f\n\x07\x04\
    \x06\x04\0\x02\x07\x01\x12\x04\xa1\x01\x04\r\n\x0f\n\x07\x04\x06\x04\0\
    \x02\x07\x02\x12\x04\xa1\x01\x10\x11\n\x0e\n\x06\x04\x06\x04\0\x02\x08\
    \x12\x04\xa2\x01\x04\x0e\n\x0f\n\x07\x04\x06\x04\0\x02\x08\x01\x12\x04\
    \xa2\x01\x04\t\n\x0f\n\x07\x04\x06\x04\0\x02\x08\x02\x12\x04\xa2\x01\x0c\
    \r\n.\n\x06\x04\x06\x04\0\x02\t\x12\x04\xa4\x01\x04\r\x1a\x1e\x20Can\x20\
    be\x20used\x20for\x20any\x20purpose.\n\n\x0f\n\x07\x04\x06\x04\0\x02\t\
    \x01\x12\x04\xa4\x01\x04\x08\n\x0f\n\x07\x04\x06\x04\0\x02\t\x02\x12\x04\
    \xa4\x01\x0b\x0c\n\x0e\n\x06\x04\x06\x04\0\x02\n\x12\x04\xa5\x01\x04\x0e\
    \n\x0f\n\x07\x04\x06\x04\0\x02\n\x01\x12\x04\xa5\x01\x04\t\n\x0f\n\x07\
    \x04\x06\x04\0\x02\n\x02\x12\x04\xa5\x01\x0c\r\n\x0c\n\x04\x04\x06\x02\0\
    \x12\x04\xa7\x01\x02\x12\n\r\n\x05\x04\x06\x02\0\x05\x12\x04\xa7\x01\x02\
    \x08\n\r\n\x05\x04\x06\x02\0\x01\x12\x04\xa7\x01\t\r\n\r\n\x05\x04\x06\
    \x02\0\x03\x12\x04\xa7\x01\x10\x11\n\x0c\n\x04\x04\x06\x02\x01\x12\x04\
    \xa8\x01\x02\x1b\n\r\n\x05\x04\x06\x02\x01\x05\x12\x04\xa8\x01\x02\x08\n\
    \r\n\x05\x04\x06\x02\x01\x01\x12\x04\xa8\x01\t\x16\n\r\n\x05\x04\x06\x02\
    \x01\x03\x12\x04\xa8\x01\x19\x1a\n\x0c\n\x04\x04\x06\x02\x02\x12\x04\xa9\
    \x01\x02\x14\n\r\n\x05\x04\x06\x02\x02\x06\x12\x04\xa9\x01\x02\x08\n\r\n\
    \x05\x04\x06\x02\x02\x01\x12\x04\xa9\x01\t\x0f\n\r\n\x05\x04\x06\x02\x02\
    \x03\x12\x04\xa9\x01\x12\x13\n\x83\x01\n\x02\x04\x07\x12\x06\xae\x01\0\
    \xb9\x01\x01\x1au\x20SymbolInformation\x20defines\x20metadata\x20about\
    \x20a\x20symbol,\x20such\x20as\x20the\x20symbol's\n\x20docstring\x20or\
    \x20what\x20package\x20it's\x20defined\x20it.\n\n\x0b\n\x03\x04\x07\x01\
    \x12\x04\xae\x01\x08\x19\n\xa0\x01\n\x04\x04\x07\x02\0\x12\x04\xb1\x01\
    \x02\x14\x1a\x91\x01\x20Identifier\x20of\x20this\x20symbol,\x20which\x20\
    can\x20be\x20referenced\x20from\x20`Occurence.symbol`.\n\x20The\x20strin\
    g\x20must\x20be\x20formatted\x20according\x20to\x20the\x20grammar\x20in\
    \x20`Symbol`.\n\n\r\n\x05\x04\x07\x02\0\x05\x12\x04\xb1\x01\x02\x08\n\r\
    \n\x05\x04\x07\x02\0\x01\x12\x04\xb1\x01\t\x0f\n\r\n\x05\x04\x07\x02\0\
    \x03\x12\x04\xb1\x01\x12\x13\n\xb6\x02\n\x04\x04\x07\x02\x01\x12\x04\xb6\
    \x01\x02$\x1a\xa7\x02\x20(optional,\x20but\x20strongly\x20recommended)\
    \x20The\x20markdown-formatted\x20documentation\n\x20for\x20this\x20symbo\
    l.\x20This\x20field\x20is\x20repeated\x20to\x20allow\x20different\x20kin\
    ds\x20of\n\x20documentation.\x20\x20For\x20example,\x20it's\x20nice\x20t\
    o\x20include\x20both\x20the\x20signature\x20of\x20a\n\x20method\x20(para\
    meters\x20and\x20return\x20type)\x20along\x20with\x20the\x20accompanying\
    \x20docstring.\n\n\r\n\x05\x04\x07\x02\x01\x04\x12\x04\xb6\x01\x02\n\n\r\
    \n\x05\x04\x07\x02\x01\x05\x12\x04\xb6\x01\x0b\x11\n\r\n\x05\x04\x07\x02\
    \x01\x01\x12\x04\xb6\x01\x12\x1f\n\r\n\x05\x04\x07\x02\x01\x03\x12\x04\
    \xb6\x01\"#\n^\n\x04\x04\x07\x02\x02\x12\x04\xb8\x01\x02*\x1aP\x20(optio\
    nal)\x20Relationships\x20to\x20other\x20symbols\x20(e.g.,\x20implements,\
    \x20type\x20definition).\n\n\r\n\x05\x04\x07\x02\x02\x04\x12\x04\xb8\x01\
    \x02\n\n\r\n\x05\x04\x07\x02\x02\x06\x12\x04\xb8\x01\x0b\x17\n\r\n\x05\
    \x04\x07\x02\x02\x01\x12\x04\xb8\x01\x18%\n\r\n\x05\x04\x07\x02\x02\x03\
    \x12\x04\xb8\x01()\n\x0c\n\x02\x04\x08\x12\x06\xbb\x01\0\xf3\x01\x01\n\
    \x0b\n\x03\x04\x08\x01\x12\x04\xbb\x01\x08\x14\n\x0c\n\x04\x04\x08\x02\0\
    \x12\x04\xbc\x01\x02\x14\n\r\n\x05\x04\x08\x02\0\x05\x12\x04\xbc\x01\x02\
    \x08\n\r\n\x05\x04\x08\x02\0\x01\x12\x04\xbc\x01\t\x0f\n\r\n\x05\x04\x08\
    \x02\0\x03\x12\x04\xbc\x01\x12\x13\n\x8f\x08\n\x04\x04\x08\x02\x01\x12\
    \x04\xd5\x01\x02\x18\x1a\x80\x08\x20When\x20resolving\x20\"Find\x20refer\
    ences\",\x20this\x20field\x20documents\x20what\x20other\x20symbols\n\x20\
    should\x20be\x20included\x20together\x20with\x20this\x20symbol.\x20For\
    \x20example,\x20consider\x20the\n\x20following\x20TypeScript\x20code\x20\
    that\x20defines\x20two\x20symbols\x20`Animal#sound()`\x20and\n\x20`Dog#s\
    ound()`:\n\x20```ts\n\x20interface\x20Animal\x20{\n\x20\x20\x20\x20\x20\
    \x20\x20\x20\x20\x20\x20^^^^^^\x20definition\x20Animal#\n\x20\x20\x20sou\
    nd():\x20string\n\x20\x20\x20^^^^^\x20definition\x20Animal#sound()\n\x20\
    }\n\x20class\x20Dog\x20implements\x20Animal\x20{\n\x20\x20\x20\x20\x20\
    \x20\x20^^^\x20definition\x20Dog#,\x20implementation_symbols\x20=\x20Ani\
    mal#\n\x20\x20\x20public\x20sound():\x20string\x20{\x20return\x20\"woof\
    \"\x20}\n\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20^^^^^\x20definition\x20\
    Dog#sound(),\x20references_symbols\x20=\x20Animal#sound(),\x20implementa\
    tion_symbols\x20=\x20Animal#sound()\n\x20}\n\x20const\x20animal:\x20Anim\
    al\x20=\x20new\x20Dog()\n\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\
    \x20\x20\x20\x20^^^^^^\x20reference\x20Animal#\n\x20console.log(animal.s\
    ound())\n\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\
    \x20\x20\x20\x20\x20^^^^^\x20reference\x20Animal#sound()\n\x20```\n\x20D\
    oing\x20\"Find\x20references\"\x20on\x20the\x20symbol\x20`Animal#sound()\
    `\x20should\x20return\n\x20references\x20to\x20the\x20`Dog#sound()`\x20m\
    ethod\x20as\x20well.\x20Vice-versa,\x20doing\x20\"Find\n\x20references\"\
    \x20on\x20the\x20`Dog#sound()`\x20method\x20should\x20include\x20referen\
    ces\x20to\x20the\n\x20`Animal#sound()`\x20method\x20as\x20well.\n\n\r\n\
    \x05\x04\x08\x02\x01\x05\x12\x04\xd5\x01\x02\x06\n\r\n\x05\x04\x08\x02\
    \x01\x01\x12\x04\xd5\x01\x07\x13\n\r\n\x05\x04\x08\x02\x01\x03\x12\x04\
    \xd5\x01\x16\x17\n\xba\x04\n\x04\x04\x08\x02\x02\x12\x04\xde\x01\x02\x1d\
    \x1a\xab\x04\x20Similar\x20to\x20`references_symbols`\x20but\x20for\x20\
    \"Go\x20to\x20implementation\".\n\x20It's\x20common\x20for\x20the\x20`im\
    plementation_symbols`\x20and\x20`references_symbols`\x20fields\n\x20have\
    \x20the\x20same\x20values\x20but\x20that's\x20not\x20always\x20the\x20ca\
    se.\n\x20In\x20the\x20TypeScript\x20example\x20above,\x20observe\x20that\
    \x20`implementation_symbols`\x20has\n\x20the\x20value\x20`\"Animal#\"`\
    \x20for\x20the\x20\"Dog#\"\x20symbol\x20while\x20`references_symbols`\
    \x20is\n\x20empty.\x20When\x20requesting\x20\"Find\x20references\"\x20on\
    \x20the\x20\"Animal#\"\x20symbol\x20we\x20don't\n\x20want\x20to\x20inclu\
    de\x20references\x20to\x20\"Dog#\"\x20even\x20if\x20\"Go\x20to\x20implem\
    entation\"\x20on\x20the\n\x20\"Animal#\"\x20symbol\x20should\x20navigate\
    \x20to\x20the\x20\"Dog#\"\x20symbol.\n\n\r\n\x05\x04\x08\x02\x02\x05\x12\
    \x04\xde\x01\x02\x06\n\r\n\x05\x04\x08\x02\x02\x01\x12\x04\xde\x01\x07\
    \x18\n\r\n\x05\x04\x08\x02\x02\x03\x12\x04\xde\x01\x1b\x1c\nP\n\x04\x04\
    \x08\x02\x03\x12\x04\xe0\x01\x02\x1e\x1aB\x20Similar\x20to\x20`reference\
    s_symbols`\x20but\x20for\x20\"Go\x20to\x20type\x20definition\".\n\n\r\n\
    \x05\x04\x08\x02\x03\x05\x12\x04\xe0\x01\x02\x06\n\r\n\x05\x04\x08\x02\
    \x03\x01\x12\x04\xe0\x01\x07\x19\n\r\n\x05\x04\x08\x02\x03\x03\x12\x04\
    \xe0\x01\x1c\x1d\n\xa7\x07\n\x04\x04\x08\x02\x04\x12\x04\xf1\x01\x02\x19\
    \x1a\xd5\x06\x20Allows\x20overriding\x20the\x20behavior\x20of\x20\"Go\
    \x20to\x20definition\"\x20and\x20\"Find\x20references\"\n\x20for\x20symb\
    ols\x20which\x20do\x20not\x20have\x20a\x20definition\x20of\x20their\x20o\
    wn\x20or\x20could\n\x20potentially\x20have\x20multiple\x20definitions.\n\
    \n\x20For\x20example,\x20in\x20a\x20language\x20with\x20single\x20inheri\
    tance\x20and\x20no\x20field\x20overriding,\n\x20inherited\x20fields\x20c\
    an\x20reuse\x20the\x20same\x20symbol\x20as\x20the\x20ancestor\x20which\
    \x20declares\n\x20the\x20field.\x20In\x20such\x20a\x20situation,\x20is_d\
    efinition\x20is\x20not\x20needed.\n\n\x20On\x20the\x20other\x20hand,\x20\
    in\x20languages\x20with\x20single\x20inheritance\x20and\x20some\x20form\
    \n\x20of\x20mixins,\x20you\x20can\x20use\x20is_definition\x20to\x20relat\
    e\x20the\x20symbol\x20to\x20the\n\x20matching\x20symbol\x20in\x20ancesto\
    r\x20classes,\x20and\x20is_reference\x20to\x20relate\x20the\n\x20symbol\
    \x20to\x20the\x20matching\x20symbol\x20in\x20mixins.\n\n\x20NOTE:\x20At\
    \x20the\x20moment,\x20due\x20to\x20limitations\x20of\x20the\x20SCIP\x20t\
    o\x20LSIF\x20conversion,\n\x20only\x20global\x20symbols\x20in\x20an\x20i\
    ndex\x20are\x20allowed\x20to\x20use\x20is_definition.\n\x20The\x20relati\
    onship\x20may\x20not\x20get\x20recorded\x20if\x20either\x20symbol\x20is\
    \x20local.\n\"A\x20Update\x20registerInverseRelationships\x20on\x20addin\
    g\x20a\x20new\x20field\x20here.\n\n\r\n\x05\x04\x08\x02\x04\x05\x12\x04\
    \xf1\x01\x02\x06\n\r\n\x05\x04\x08\x02\x04\x01\x12\x04\xf1\x01\x07\x14\n\
    \r\n\x05\x04\x08\x02\x04\x03\x12\x04\xf1\x01\x17\x18\n\x89\x03\n\x02\x05\
    \x02\x12\x06\xfa\x01\0\x8a\x02\x01\x1a\xfa\x02\x20SymbolRole\x20declares\
    \x20what\x20\"role\"\x20a\x20symbol\x20has\x20in\x20an\x20occurrence.\
    \x20\x20A\x20role\x20is\n\x20encoded\x20as\x20a\x20bitset\x20where\x20ea\
    ch\x20bit\x20represents\x20a\x20different\x20role.\x20For\x20example,\n\
    \x20to\x20determine\x20if\x20the\x20`Import`\x20role\x20is\x20set,\x20te\
    st\x20whether\x20the\x20second\x20bit\x20of\x20the\n\x20enum\x20value\
    \x20is\x20defined.\x20In\x20pseudocode,\x20this\x20can\x20be\x20implemen\
    ted\x20with\x20the\n\x20logic:\x20`const\x20isImportRole\x20=\x20(role.v\
    alue\x20&\x20SymbolRole.Import.value)\x20>\x200`.\n\n\x0b\n\x03\x05\x02\
    \x01\x12\x04\xfa\x01\x05\x0f\nv\n\x04\x05\x02\x02\0\x12\x04\xfd\x01\x02\
    \x1c\x1ah\x20This\x20case\x20is\x20not\x20meant\x20to\x20be\x20used;\x20\
    it\x20only\x20exists\x20to\x20avoid\x20an\x20error\n\x20from\x20the\x20P\
    rotobuf\x20code\x20generator.\n\n\r\n\x05\x05\x02\x02\0\x01\x12\x04\xfd\
    \x01\x02\x17\n\r\n\x05\x05\x02\x02\0\x02\x12\x04\xfd\x01\x1a\x1b\nT\n\
    \x04\x05\x02\x02\x01\x12\x04\xff\x01\x02\x13\x1aF\x20Is\x20the\x20symbol\
    \x20defined\x20here?\x20If\x20not,\x20then\x20this\x20is\x20a\x20symbol\
    \x20reference.\n\n\r\n\x05\x05\x02\x02\x01\x01\x12\x04\xff\x01\x02\x0c\n\
    \r\n\x05\x05\x02\x02\x01\x02\x12\x04\xff\x01\x0f\x12\n,\n\x04\x05\x02\
    \x02\x02\x12\x04\x81\x02\x02\x0f\x1a\x1e\x20Is\x20the\x20symbol\x20impor\
    ted\x20here?\n\n\r\n\x05\x05\x02\x02\x02\x01\x12\x04\x81\x02\x02\x08\n\r\
    \n\x05\x05\x02\x02\x02\x02\x12\x04\x81\x02\x0b\x0e\n+\n\x04\x05\x02\x02\
    \x03\x12\x04\x83\x02\x02\x14\x1a\x1d\x20Is\x20the\x20symbol\x20written\
    \x20here?\n\n\r\n\x05\x05\x02\x02\x03\x01\x12\x04\x83\x02\x02\r\n\r\n\
    \x05\x05\x02\x02\x03\x02\x12\x04\x83\x02\x10\x13\n(\n\x04\x05\x02\x02\
    \x04\x12\x04\x85\x02\x02\x13\x1a\x1a\x20Is\x20the\x20symbol\x20read\x20h\
    ere?\n\n\r\n\x05\x05\x02\x02\x04\x01\x12\x04\x85\x02\x02\x0c\n\r\n\x05\
    \x05\x02\x02\x04\x02\x12\x04\x85\x02\x0f\x12\n0\n\x04\x05\x02\x02\x05\
    \x12\x04\x87\x02\x02\x13\x1a\"\x20Is\x20the\x20symbol\x20in\x20generated\
    \x20code?\n\n\r\n\x05\x05\x02\x02\x05\x01\x12\x04\x87\x02\x02\x0b\n\r\n\
    \x05\x05\x02\x02\x05\x02\x12\x04\x87\x02\x0e\x12\n+\n\x04\x05\x02\x02\
    \x06\x12\x04\x89\x02\x02\x0e\x1a\x1d\x20Is\x20the\x20symbol\x20in\x20tes\
    t\x20code?\n\n\r\n\x05\x05\x02\x02\x06\x01\x12\x04\x89\x02\x02\x06\n\r\n\
    \x05\x05\x02\x02\x06\x02\x12\x04\x89\x02\t\r\n\x0c\n\x02\x05\x03\x12\x06\
    \x8c\x02\0\xe9\x02\x01\n\x0b\n\x03\x05\x03\x01\x12\x04\x8c\x02\x05\x0f\n\
    \x0b\n\x03\x05\x03\x03\x12\x04\x8d\x02\x02\x1c\n\x0c\n\x04\x05\x03\x03\
    \x02\x12\x04\x8d\x02\x02\x1c\n\x0c\n\x04\x05\x03\x02\0\x12\x04\x8f\x02\
    \x02\x1c\n\r\n\x05\x05\x03\x02\0\x01\x12\x04\x8f\x02\x02\x17\n\r\n\x05\
    \x05\x03\x02\0\x02\x12\x04\x8f\x02\x1a\x1b\n;\n\x04\x05\x03\x02\x01\x12\
    \x04\x92\x02\x02\x0e\x1a-\x20Comment,\x20including\x20comment\x20markers\
    \x20and\x20text\n\n\r\n\x05\x05\x03\x02\x01\x01\x12\x04\x92\x02\x02\t\n\
    \r\n\x05\x05\x03\x02\x01\x02\x12\x04\x92\x02\x0c\r\n\x1b\n\x04\x05\x03\
    \x02\x02\x12\x04\x95\x02\x02\x1b\x1a\r\x20`;`\x20`.`\x20`,`\n\n\r\n\x05\
    \x05\x03\x02\x02\x01\x12\x04\x95\x02\x02\x16\n\r\n\x05\x05\x03\x02\x02\
    \x02\x12\x04\x95\x02\x19\x1a\n2\n\x04\x05\x03\x02\x03\x12\x04\x97\x02\
    \x02\x19\x1a$\x20(),\x20{},\x20[]\x20when\x20used\x20syntactically\n\n\r\
    \n\x05\x05\x03\x02\x03\x01\x12\x04\x97\x02\x02\x14\n\r\n\x05\x05\x03\x02\
    \x03\x02\x12\x04\x97\x02\x17\x18\n5\n\x04\x05\x03\x02\x04\x12\x04\x9a\
    \x02\x02\x0e\x1a'\x20`if`,\x20`else`,\x20`return`,\x20`class`,\x20etc.\n\
    \n\r\n\x05\x05\x03\x02\x04\x01\x12\x04\x9a\x02\x02\t\n\r\n\x05\x05\x03\
    \x02\x04\x02\x12\x04\x9a\x02\x0c\r\n\x0c\n\x04\x05\x03\x02\x05\x12\x04\
    \x9b\x02\x02*\n\r\n\x05\x05\x03\x02\x05\x01\x12\x04\x9b\x02\x02\x13\n\r\
    \n\x05\x05\x03\x02\x05\x02\x12\x04\x9b\x02\x16\x17\n\r\n\x05\x05\x03\x02\
    \x05\x03\x12\x04\x9b\x02\x18)\n\x0e\n\x06\x05\x03\x02\x05\x03\x01\x12\
    \x04\x9b\x02\x19(\n\x1e\n\x04\x05\x03\x02\x06\x12\x04\x9e\x02\x02\x19\
    \x1a\x10\x20`+`,\x20`*`,\x20etc.\n\n\r\n\x05\x05\x03\x02\x06\x01\x12\x04\
    \x9e\x02\x02\x14\n\r\n\x05\x05\x03\x02\x06\x02\x12\x04\x9e\x02\x17\x18\n\
    X\n\x04\x05\x03\x02\x07\x12\x04\xa1\x02\x02\x11\x1aJ\x20non-specific\x20\
    catch-all\x20for\x20any\x20identifier\x20not\x20better\x20described\x20e\
    lsewhere\n\n\r\n\x05\x05\x03\x02\x07\x01\x12\x04\xa1\x02\x02\x0c\n\r\n\
    \x05\x05\x03\x02\x07\x02\x12\x04\xa1\x02\x0f\x10\nN\n\x04\x05\x03\x02\
    \x08\x12\x04\xa3\x02\x02\x18\x1a@\x20Identifiers\x20builtin\x20to\x20the\
    \x20language:\x20`min`,\x20`print`\x20in\x20Python.\n\n\r\n\x05\x05\x03\
    \x02\x08\x01\x12\x04\xa3\x02\x02\x13\n\r\n\x05\x05\x03\x02\x08\x02\x12\
    \x04\xa3\x02\x16\x17\n[\n\x04\x05\x03\x02\t\x12\x04\xa5\x02\x02\x15\x1aM\
    \x20Identifiers\x20representing\x20`null`-like\x20values:\x20`None`\x20i\
    n\x20Python,\x20`nil`\x20in\x20Go.\n\n\r\n\x05\x05\x03\x02\t\x01\x12\x04\
    \xa5\x02\x02\x10\n\r\n\x05\x05\x03\x02\t\x02\x12\x04\xa5\x02\x13\x14\n.\
    \n\x04\x05\x03\x02\n\x12\x04\xa7\x02\x02\x19\x1a\x20\x20`xyz`\x20in\x20`\
    const\x20xyz\x20=\x20\"hello\"`\n\n\r\n\x05\x05\x03\x02\n\x01\x12\x04\
    \xa7\x02\x02\x14\n\r\n\x05\x05\x03\x02\n\x02\x12\x04\xa7\x02\x17\x18\n'\
    \n\x04\x05\x03\x02\x0b\x12\x04\xa9\x02\x02\x1f\x1a\x19\x20`var\x20X\x20=\
    \x20\"hello\"`\x20in\x20Go\n\n\r\n\x05\x05\x03\x02\x0b\x01\x12\x04\xa9\
    \x02\x02\x19\n\r\n\x05\x05\x03\x02\x0b\x02\x12\x04\xa9\x02\x1c\x1e\n3\n\
    \x04\x05\x03\x02\x0c\x12\x04\xab\x02\x02\x1b\x1a%\x20Parameter\x20defini\
    tion\x20and\x20references\n\n\r\n\x05\x05\x03\x02\x0c\x01\x12\x04\xab\
    \x02\x02\x15\n\r\n\x05\x05\x03\x02\x0c\x02\x12\x04\xab\x02\x18\x1a\nX\n\
    \x04\x05\x03\x02\r\x12\x04\xad\x02\x02\x17\x1aJ\x20Identifiers\x20for\
    \x20variable\x20definitions\x20and\x20references\x20within\x20a\x20local\
    \x20scope\n\n\r\n\x05\x05\x03\x02\r\x01\x12\x04\xad\x02\x02\x11\n\r\n\
    \x05\x05\x03\x02\r\x02\x12\x04\xad\x02\x14\x16\nK\n\x04\x05\x03\x02\x0e\
    \x12\x04\xaf\x02\x02\x1a\x1a=\x20Identifiers\x20that\x20shadow\x20other\
    \x20identifiers\x20in\x20an\x20outer\x20scope\n\n\r\n\x05\x05\x03\x02\
    \x0e\x01\x12\x04\xaf\x02\x02\x14\n\r\n\x05\x05\x03\x02\x0e\x02\x12\x04\
    \xaf\x02\x17\x19\n\xcd\x01\n\x04\x05\x03\x02\x0f\x12\x04\xb4\x02\x02\x1b\
    \x1a\xbe\x01\x20Identifier\x20representing\x20a\x20unit\x20of\x20code\
    \x20abstraction\x20and/or\x20namespacing.\n\n\x20NOTE:\x20This\x20corres\
    ponds\x20to\x20a\x20package\x20in\x20Go\x20and\x20JVM\x20languages,\n\
    \x20and\x20a\x20module\x20in\x20languages\x20like\x20Python\x20and\x20Ja\
    vaScript.\n\n\r\n\x05\x05\x03\x02\x0f\x01\x12\x04\xb4\x02\x02\x15\n\r\n\
    \x05\x05\x03\x02\x0f\x02\x12\x04\xb4\x02\x18\x1a\n\x0c\n\x04\x05\x03\x02\
    \x10\x12\x04\xb5\x02\x02*\n\r\n\x05\x05\x03\x02\x10\x01\x12\x04\xb5\x02\
    \x02\x12\n\r\n\x05\x05\x03\x02\x10\x02\x12\x04\xb5\x02\x15\x17\n\r\n\x05\
    \x05\x03\x02\x10\x03\x12\x04\xb5\x02\x18)\n\x0e\n\x06\x05\x03\x02\x10\
    \x03\x01\x12\x04\xb5\x02\x19(\n4\n\x04\x05\x03\x02\x11\x12\x04\xb8\x02\
    \x02\x1a\x1a&\x20Function\x20references,\x20including\x20calls\n\n\r\n\
    \x05\x05\x03\x02\x11\x01\x12\x04\xb8\x02\x02\x14\n\r\n\x05\x05\x03\x02\
    \x11\x02\x12\x04\xb8\x02\x17\x19\n(\n\x04\x05\x03\x02\x12\x12\x04\xba\
    \x02\x02$\x1a\x1a\x20Function\x20definition\x20only\n\n\r\n\x05\x05\x03\
    \x02\x12\x01\x12\x04\xba\x02\x02\x1e\n\r\n\x05\x05\x03\x02\x12\x02\x12\
    \x04\xba\x02!#\n7\n\x04\x05\x03\x02\x13\x12\x04\xbd\x02\x02\x17\x1a)\x20\
    Macro\x20references,\x20including\x20invocations\n\n\r\n\x05\x05\x03\x02\
    \x13\x01\x12\x04\xbd\x02\x02\x11\n\r\n\x05\x05\x03\x02\x13\x02\x12\x04\
    \xbd\x02\x14\x16\n%\n\x04\x05\x03\x02\x14\x12\x04\xbf\x02\x02!\x1a\x17\
    \x20Macro\x20definition\x20only\n\n\r\n\x05\x05\x03\x02\x14\x01\x12\x04\
    \xbf\x02\x02\x1b\n\r\n\x05\x05\x03\x02\x14\x02\x12\x04\xbf\x02\x1e\x20\n\
    !\n\x04\x05\x03\x02\x15\x12\x04\xc2\x02\x02\x16\x1a\x13\x20non-builtin\
    \x20types\n\n\r\n\x05\x05\x03\x02\x15\x01\x12\x04\xc2\x02\x02\x10\n\r\n\
    \x05\x05\x03\x02\x15\x02\x12\x04\xc2\x02\x13\x15\nK\n\x04\x05\x03\x02\
    \x16\x12\x04\xc4\x02\x02\x1d\x1a=\x20builtin\x20types\x20only,\x20such\
    \x20as\x20`str`\x20for\x20Python\x20or\x20`int`\x20in\x20Go\n\n\r\n\x05\
    \x05\x03\x02\x16\x01\x12\x04\xc4\x02\x02\x17\n\r\n\x05\x05\x03\x02\x16\
    \x02\x12\x04\xc4\x02\x1a\x1c\n7\n\x04\x05\x03\x02\x17\x12\x04\xc7\x02\
    \x02\x1b\x1a)\x20Python\x20decorators,\x20c-like\x20__attribute__\n\n\r\
    \n\x05\x05\x03\x02\x17\x01\x12\x04\xc7\x02\x02\x15\n\r\n\x05\x05\x03\x02\
    \x17\x02\x12\x04\xc7\x02\x18\x1a\n\x14\n\x04\x05\x03\x02\x18\x12\x04\xca\
    \x02\x02\x13\x1a\x06\x20`\\b`\n\n\r\n\x05\x05\x03\x02\x18\x01\x12\x04\
    \xca\x02\x02\r\n\r\n\x05\x05\x03\x02\x18\x02\x12\x04\xca\x02\x10\x12\n\
    \x18\n\x04\x05\x03\x02\x19\x12\x04\xcc\x02\x02\x15\x1a\n\x20`*`,\x20`+`\
    \n\n\r\n\x05\x05\x03\x02\x19\x01\x12\x04\xcc\x02\x02\x0f\n\r\n\x05\x05\
    \x03\x02\x19\x02\x12\x04\xcc\x02\x12\x14\n\x13\n\x04\x05\x03\x02\x1a\x12\
    \x04\xce\x02\x02\x15\x1a\x05\x20`.`\n\n\r\n\x05\x05\x03\x02\x1a\x01\x12\
    \x04\xce\x02\x02\x0f\n\r\n\x05\x05\x03\x02\x1a\x02\x12\x04\xce\x02\x12\
    \x14\n\"\n\x04\x05\x03\x02\x1b\x12\x04\xd0\x02\x02\x16\x1a\x14\x20`(`,\
    \x20`)`,\x20`[`,\x20`]`\n\n\r\n\x05\x05\x03\x02\x1b\x01\x12\x04\xd0\x02\
    \x02\x10\n\r\n\x05\x05\x03\x02\x1b\x02\x12\x04\xd0\x02\x13\x15\n\x18\n\
    \x04\x05\x03\x02\x1c\x12\x04\xd2\x02\x02\x11\x1a\n\x20`|`,\x20`-`\n\n\r\
    \n\x05\x05\x03\x02\x1c\x01\x12\x04\xd2\x02\x02\x0b\n\r\n\x05\x05\x03\x02\
    \x1c\x02\x12\x04\xd2\x02\x0e\x10\n0\n\x04\x05\x03\x02\x1d\x12\x04\xd5\
    \x02\x02\x15\x1a\"\x20Literal\x20strings:\x20\"Hello,\x20world!\"\n\n\r\
    \n\x05\x05\x03\x02\x1d\x01\x12\x04\xd5\x02\x02\x0f\n\r\n\x05\x05\x03\x02\
    \x1d\x02\x12\x04\xd5\x02\x12\x14\n-\n\x04\x05\x03\x02\x1e\x12\x04\xd7\
    \x02\x02\x1b\x1a\x1f\x20non-regex\x20escapes:\x20\"\\t\",\x20\"\\n\"\n\n\
    \r\n\x05\x05\x03\x02\x1e\x01\x12\x04\xd7\x02\x02\x15\n\r\n\x05\x05\x03\
    \x02\x1e\x02\x12\x04\xd7\x02\x18\x1a\n_\n\x04\x05\x03\x02\x1f\x12\x04\
    \xd9\x02\x02\x1c\x1aQ\x20datetimes\x20within\x20strings,\x20special\x20w\
    ords\x20within\x20a\x20string,\x20`{}`\x20in\x20format\x20strings\n\n\r\
    \n\x05\x05\x03\x02\x1f\x01\x12\x04\xd9\x02\x02\x16\n\r\n\x05\x05\x03\x02\
    \x1f\x02\x12\x04\xd9\x02\x19\x1b\nG\n\x04\x05\x03\x02\x20\x12\x04\xdb\
    \x02\x02\x18\x1a9\x20\"key\"\x20in\x20{\x20\"key\":\x20\"value\"\x20},\
    \x20useful\x20for\x20example\x20in\x20JSON\n\n\r\n\x05\x05\x03\x02\x20\
    \x01\x12\x04\xdb\x02\x02\x12\n\r\n\x05\x05\x03\x02\x20\x02\x12\x04\xdb\
    \x02\x15\x17\nV\n\x04\x05\x03\x02!\x12\x04\xdd\x02\x02\x18\x1aH\x20'c'\
    \x20or\x20similar,\x20in\x20languages\x20that\x20differentiate\x20string\
    s\x20and\x20characters\n\n\r\n\x05\x05\x03\x02!\x01\x12\x04\xdd\x02\x02\
    \x12\n\r\n\x05\x05\x03\x02!\x02\x12\x04\xdd\x02\x15\x17\n9\n\x04\x05\x03\
    \x02\"\x12\x04\xdf\x02\x02\x16\x1a+\x20Literal\x20numbers,\x20both\x20fl\
    oats\x20and\x20integers\n\n\r\n\x05\x05\x03\x02\"\x01\x12\x04\xdf\x02\
    \x02\x10\n\r\n\x05\x05\x03\x02\"\x02\x12\x04\xdf\x02\x13\x15\n\x1f\n\x04\
    \x05\x03\x02#\x12\x04\xe1\x02\x02\x16\x1a\x11\x20`true`,\x20`false`\n\n\
    \r\n\x05\x05\x03\x02#\x01\x12\x04\xe1\x02\x02\x10\n\r\n\x05\x05\x03\x02#\
    \x02\x12\x04\xe1\x02\x13\x15\n&\n\x04\x05\x03\x02$\x12\x04\xe4\x02\x02\
    \x0b\x1a\x18\x20Used\x20for\x20XML-like\x20tags\n\n\r\n\x05\x05\x03\x02$\
    \x01\x12\x04\xe4\x02\x02\x05\n\r\n\x05\x05\x03\x02$\x02\x12\x04\xe4\x02\
    \x08\n\n/\n\x04\x05\x03\x02%\x12\x04\xe6\x02\x02\x14\x1a!\x20Attribute\
    \x20name\x20in\x20XML-like\x20tags\n\n\r\n\x05\x05\x03\x02%\x01\x12\x04\
    \xe6\x02\x02\x0e\n\r\n\x05\x05\x03\x02%\x02\x12\x04\xe6\x02\x11\x13\n,\n\
    \x04\x05\x03\x02&\x12\x04\xe8\x02\x02\x14\x1a\x1e\x20Delimiters\x20for\
    \x20XML-like\x20tags\n\n\r\n\x05\x05\x03\x02&\x01\x12\x04\xe8\x02\x02\
    \x0e\n\r\n\x05\x05\x03\x02&\x02\x12\x04\xe8\x02\x11\x13\n\xf9\x01\n\x02\
    \x04\t\x12\x06\xf0\x02\0\x97\x03\x01\x1a\xea\x01\x20Occurrence\x20associ\
    ates\x20a\x20source\x20position\x20with\x20a\x20symbol\x20and/or\x20high\
    lighting\n\x20information.\n\n\x20If\x20possible,\x20indexers\x20should\
    \x20try\x20to\x20bundle\x20logically\x20related\x20information\n\x20acro\
    ss\x20occurrences\x20into\x20a\x20single\x20occurrence\x20to\x20reduce\
    \x20payload\x20sizes.\n\n\x0b\n\x03\x04\t\x01\x12\x04\xf0\x02\x08\x12\n\
    \xc7\x07\n\x04\x04\t\x02\0\x12\x04\x83\x03\x02\x1b\x1a\xb8\x07\x20Source\
    \x20position\x20of\x20this\x20occurrence.\x20Must\x20be\x20exactly\x20th\
    ree\x20or\x20four\n\x20elements:\n\n\x20-\x20Four\x20elements:\x20`[star\
    tLine,\x20startCharacter,\x20endLine,\x20endCharacter]`\n\x20-\x20Three\
    \x20elements:\x20`[startLine,\x20startCharacter,\x20endCharacter]`.\x20T\
    he\x20end\x20line\n\x20\x20\x20is\x20inferred\x20to\x20have\x20the\x20sa\
    me\x20value\x20as\x20the\x20start\x20line.\n\n\x20Line\x20numbers\x20and\
    \x20characters\x20are\x20always\x200-based.\x20Make\x20sure\x20to\x20inc\
    rement\x20the\n\x20line/character\x20values\x20before\x20displaying\x20t\
    hem\x20in\x20an\x20editor-like\x20UI\x20because\n\x20editors\x20conventi\
    onally\x20use\x201-based\x20numbers.\n\n\x20Historical\x20note:\x20the\
    \x20original\x20draft\x20of\x20this\x20schema\x20had\x20a\x20`Range`\x20\
    message\n\x20type\x20with\x20`start`\x20and\x20`end`\x20fields\x20of\x20\
    type\x20`Position`,\x20mirroring\x20LSP.\n\x20Benchmarks\x20revealed\x20\
    that\x20this\x20encoding\x20was\x20inefficient\x20and\x20that\x20we\x20c\
    ould\n\x20reduce\x20the\x20total\x20payload\x20size\x20of\x20an\x20index\
    \x20by\x2050%\x20by\x20using\x20`repeated\x20int32`\n\x20instead.\x20\
    \x20The\x20`repeated\x20int32`\x20encoding\x20is\x20admittedly\x20more\
    \x20embarrassing\x20to\n\x20work\x20with\x20in\x20some\x20programming\
    \x20languages\x20but\x20we\x20hope\x20the\x20performance\n\x20improvemen\
    ts\x20make\x20up\x20for\x20it.\n\n\r\n\x05\x04\t\x02\0\x04\x12\x04\x83\
    \x03\x02\n\n\r\n\x05\x04\t\x02\0\x05\x12\x04\x83\x03\x0b\x10\n\r\n\x05\
    \x04\t\x02\0\x01\x12\x04\x83\x03\x11\x16\n\r\n\x05\x04\t\x02\0\x03\x12\
    \x04\x83\x03\x19\x1a\n\x8a\x01\n\x04\x04\t\x02\x01\x12\x04\x86\x03\x02\
    \x14\x1a|\x20(optional)\x20The\x20symbol\x20that\x20appears\x20at\x20thi\
    s\x20position.\x20See\n\x20`SymbolInformation.symbol`\x20for\x20how\x20t\
    o\x20format\x20symbols\x20as\x20strings.\n\n\r\n\x05\x04\t\x02\x01\x05\
    \x12\x04\x86\x03\x02\x08\n\r\n\x05\x04\t\x02\x01\x01\x12\x04\x86\x03\t\
    \x0f\n\r\n\x05\x04\t\x02\x01\x03\x12\x04\x86\x03\x12\x13\n\x97\x01\n\x04\
    \x04\t\x02\x02\x12\x04\x89\x03\x02\x19\x1a\x88\x01\x20(optional)\x20Bits\
    et\x20containing\x20`SymbolRole`s\x20in\x20this\x20occurrence.\n\x20See\
    \x20`SymbolRole`'s\x20documentation\x20for\x20how\x20to\x20read\x20and\
    \x20write\x20this\x20field.\n\n\r\n\x05\x04\t\x02\x02\x05\x12\x04\x89\
    \x03\x02\x07\n\r\n\x05\x04\t\x02\x02\x01\x12\x04\x89\x03\x08\x14\n\r\n\
    \x05\x04\t\x02\x02\x03\x12\x04\x89\x03\x17\x18\n\xf1\x03\n\x04\x04\t\x02\
    \x03\x12\x04\x92\x03\x02-\x1a\xe2\x03\x20(optional)\x20CommonMark-format\
    ted\x20documentation\x20for\x20this\x20specific\x20range.\x20If\n\x20emp\
    ty,\x20the\x20`Symbol.documentation`\x20field\x20is\x20used\x20instead.\
    \x20One\x20example\n\x20where\x20this\x20field\x20might\x20be\x20useful\
    \x20is\x20when\x20the\x20symbol\x20represents\x20a\x20generic\n\x20funct\
    ion\x20(with\x20abstract\x20type\x20parameters\x20such\x20as\x20`List<T>\
    `)\x20and\x20at\x20this\n\x20occurrence\x20we\x20know\x20the\x20exact\
    \x20values\x20(such\x20as\x20`List<String>`).\n\n\x20This\x20field\x20ca\
    n\x20also\x20be\x20used\x20for\x20dynamically\x20or\x20gradually\x20type\
    d\x20languages,\n\x20which\x20commonly\x20allow\x20for\x20type-changing\
    \x20assignment.\n\n\r\n\x05\x04\t\x02\x03\x04\x12\x04\x92\x03\x02\n\n\r\
    \n\x05\x04\t\x02\x03\x05\x12\x04\x92\x03\x0b\x11\n\r\n\x05\x04\t\x02\x03\
    \x01\x12\x04\x92\x03\x12(\n\r\n\x05\x04\t\x02\x03\x03\x12\x04\x92\x03+,\
    \nX\n\x04\x04\t\x02\x04\x12\x04\x94\x03\x02\x1d\x1aJ\x20(optional)\x20Wh\
    at\x20syntax\x20highlighting\x20class\x20should\x20be\x20used\x20for\x20\
    this\x20range?\n\n\r\n\x05\x04\t\x02\x04\x06\x12\x04\x94\x03\x02\x0c\n\r\
    \n\x05\x04\t\x02\x04\x01\x12\x04\x94\x03\r\x18\n\r\n\x05\x04\t\x02\x04\
    \x03\x12\x04\x94\x03\x1b\x1c\nW\n\x04\x04\t\x02\x05\x12\x04\x96\x03\x02&\
    \x1aI\x20(optional)\x20Diagnostics\x20that\x20have\x20been\x20reported\
    \x20for\x20this\x20specific\x20range.\n\n\r\n\x05\x04\t\x02\x05\x04\x12\
    \x04\x96\x03\x02\n\n\r\n\x05\x04\t\x02\x05\x06\x12\x04\x96\x03\x0b\x15\n\
    \r\n\x05\x04\t\x02\x05\x01\x12\x04\x96\x03\x16!\n\r\n\x05\x04\t\x02\x05\
    \x03\x12\x04\x96\x03$%\nw\n\x02\x04\n\x12\x06\x9b\x03\0\xa6\x03\x01\x1ai\
    \x20Represents\x20a\x20diagnostic,\x20such\x20as\x20a\x20compiler\x20err\
    or\x20or\x20warning,\x20which\x20should\x20be\n\x20reported\x20for\x20a\
    \x20document.\n\n\x0b\n\x03\x04\n\x01\x12\x04\x9b\x03\x08\x12\nW\n\x04\
    \x04\n\x02\0\x12\x04\x9d\x03\x02\x18\x1aI\x20Should\x20this\x20diagnosti\
    c\x20be\x20reported\x20as\x20an\x20error,\x20warning,\x20info,\x20or\x20\
    hint?\n\n\r\n\x05\x04\n\x02\0\x06\x12\x04\x9d\x03\x02\n\n\r\n\x05\x04\n\
    \x02\0\x01\x12\x04\x9d\x03\x0b\x13\n\r\n\x05\x04\n\x02\0\x03\x12\x04\x9d\
    \x03\x16\x17\n]\n\x04\x04\n\x02\x01\x12\x04\x9f\x03\x02\x12\x1aO\x20(opt\
    ional)\x20Code\x20of\x20this\x20diagnostic,\x20which\x20might\x20appear\
    \x20in\x20the\x20user\x20interface.\n\n\r\n\x05\x04\n\x02\x01\x05\x12\
    \x04\x9f\x03\x02\x08\n\r\n\x05\x04\n\x02\x01\x01\x12\x04\x9f\x03\t\r\n\r\
    \n\x05\x04\n\x02\x01\x03\x12\x04\x9f\x03\x10\x11\n+\n\x04\x04\n\x02\x02\
    \x12\x04\xa1\x03\x02\x15\x1a\x1d\x20Message\x20of\x20this\x20diagnostic.\
    \n\n\r\n\x05\x04\n\x02\x02\x05\x12\x04\xa1\x03\x02\x08\n\r\n\x05\x04\n\
    \x02\x02\x01\x12\x04\xa1\x03\t\x10\n\r\n\x05\x04\n\x02\x02\x03\x12\x04\
    \xa1\x03\x13\x14\n~\n\x04\x04\n\x02\x03\x12\x04\xa4\x03\x02\x14\x1ap\x20\
    (optional)\x20Human-readable\x20string\x20describing\x20the\x20source\
    \x20of\x20this\x20diagnostic,\x20e.g.\n\x20'typescript'\x20or\x20'super\
    \x20lint'.\n\n\r\n\x05\x04\n\x02\x03\x05\x12\x04\xa4\x03\x02\x08\n\r\n\
    \x05\x04\n\x02\x03\x01\x12\x04\xa4\x03\t\x0f\n\r\n\x05\x04\n\x02\x03\x03\
    \x12\x04\xa4\x03\x12\x13\n\x0c\n\x04\x04\n\x02\x04\x12\x04\xa5\x03\x02\"\
    \n\r\n\x05\x04\n\x02\x04\x04\x12\x04\xa5\x03\x02\n\n\r\n\x05\x04\n\x02\
    \x04\x06\x12\x04\xa5\x03\x0b\x18\n\r\n\x05\x04\n\x02\x04\x01\x12\x04\xa5\
    \x03\x19\x1d\n\r\n\x05\x04\n\x02\x04\x03\x12\x04\xa5\x03\x20!\n\x0c\n\
    \x02\x05\x04\x12\x06\xa8\x03\0\xae\x03\x01\n\x0b\n\x03\x05\x04\x01\x12\
    \x04\xa8\x03\x05\r\n\x0c\n\x04\x05\x04\x02\0\x12\x04\xa9\x03\x02\x1a\n\r\
    \n\x05\x05\x04\x02\0\x01\x12\x04\xa9\x03\x02\x15\n\r\n\x05\x05\x04\x02\0\
    \x02\x12\x04\xa9\x03\x18\x19\n\x0c\n\x04\x05\x04\x02\x01\x12\x04\xaa\x03\
    \x02\x0c\n\r\n\x05\x05\x04\x02\x01\x01\x12\x04\xaa\x03\x02\x07\n\r\n\x05\
    \x05\x04\x02\x01\x02\x12\x04\xaa\x03\n\x0b\n\x0c\n\x04\x05\x04\x02\x02\
    \x12\x04\xab\x03\x02\x0e\n\r\n\x05\x05\x04\x02\x02\x01\x12\x04\xab\x03\
    \x02\t\n\r\n\x05\x05\x04\x02\x02\x02\x12\x04\xab\x03\x0c\r\n\x0c\n\x04\
    \x05\x04\x02\x03\x12\x04\xac\x03\x02\x12\n\r\n\x05\x05\x04\x02\x03\x01\
    \x12\x04\xac\x03\x02\r\n\r\n\x05\x05\x04\x02\x03\x02\x12\x04\xac\x03\x10\
    \x11\n\x0c\n\x04\x05\x04\x02\x04\x12\x04\xad\x03\x02\x0b\n\r\n\x05\x05\
    \x04\x02\x04\x01\x12\x04\xad\x03\x02\x06\n\r\n\x05\x05\x04\x02\x04\x02\
    \x12\x04\xad\x03\t\n\n\x0c\n\x02\x05\x05\x12\x06\xb0\x03\0\xb4\x03\x01\n\
    \x0b\n\x03\x05\x05\x01\x12\x04\xb0\x03\x05\x12\n\x0c\n\x04\x05\x05\x02\0\
    \x12\x04\xb1\x03\x02\x1f\n\r\n\x05\x05\x05\x02\0\x01\x12\x04\xb1\x03\x02\
    \x1a\n\r\n\x05\x05\x05\x02\0\x02\x12\x04\xb1\x03\x1d\x1e\n\x0c\n\x04\x05\
    \x05\x02\x01\x12\x04\xb2\x03\x02\x12\n\r\n\x05\x05\x05\x02\x01\x01\x12\
    \x04\xb2\x03\x02\r\n\r\n\x05\x05\x05\x02\x01\x02\x12\x04\xb2\x03\x10\x11\
    \n\x0c\n\x04\x05\x05\x02\x02\x12\x04\xb3\x03\x02\x11\n\r\n\x05\x05\x05\
    \x02\x02\x01\x12\x04\xb3\x03\x02\x0c\n\r\n\x05\x05\x05\x02\x02\x02\x12\
    \x04\xb3\x03\x0f\x10\n\xd6\x03\n\x02\x05\x06\x12\x06\xbc\x03\0\xa2\x04\
    \x01\x1a\xc7\x03\x20Language\x20standardises\x20names\x20of\x20common\
    \x20programming\x20languages\x20that\x20can\x20be\x20used\n\x20for\x20th\
    e\x20`Document.language`\x20field.\x20The\x20primary\x20purpose\x20of\
    \x20this\x20enum\x20is\x20to\n\x20prevent\x20a\x20situation\x20where\x20\
    we\x20have\x20a\x20single\x20programming\x20language\x20ends\x20up\x20wi\
    th\n\x20multiple\x20string\x20representations.\x20For\x20example,\x20the\
    \x20C++\x20language\x20uses\x20the\x20name\n\x20\"CPlusPlus\"\x20in\x20t\
    his\x20enum\x20and\x20other\x20names\x20such\x20as\x20\"cpp\"\x20are\x20\
    incompatible.\n\x20Feel\x20free\x20to\x20send\x20a\x20pull-request\x20to\
    \x20add\x20missing\x20programming\x20languages.\n\n\x0b\n\x03\x05\x06\
    \x01\x12\x04\xbc\x03\x05\r\n\x0c\n\x04\x05\x06\x02\0\x12\x04\xbd\x03\x02\
    \x1a\n\r\n\x05\x05\x06\x02\0\x01\x12\x04\xbd\x03\x02\x15\n\r\n\x05\x05\
    \x06\x02\0\x02\x12\x04\xbd\x03\x18\x19\n\x0c\n\x04\x05\x06\x02\x01\x12\
    \x04\xbe\x03\x02\x0c\n\r\n\x05\x05\x06\x02\x01\x01\x12\x04\xbe\x03\x02\
    \x06\n\r\n\x05\x05\x06\x02\x01\x02\x12\x04\xbe\x03\t\x0b\n\x0c\n\x04\x05\
    \x06\x02\x02\x12\x04\xbf\x03\x02\x0b\n\r\n\x05\x05\x06\x02\x02\x01\x12\
    \x04\xbf\x03\x02\x05\n\r\n\x05\x05\x06\x02\x02\x02\x12\x04\xbf\x03\x08\n\
    \n\x0c\n\x04\x05\x06\x02\x03\x12\x04\xc0\x03\x02\x0b\n\r\n\x05\x05\x06\
    \x02\x03\x01\x12\x04\xc0\x03\x02\x05\n\r\n\x05\x05\x06\x02\x03\x02\x12\
    \x04\xc0\x03\x08\n\n\x0c\n\x04\x05\x06\x02\x04\x12\x04\xc1\x03\x02\x0c\n\
    \r\n\x05\x05\x06\x02\x04\x01\x12\x04\xc1\x03\x02\x06\n\r\n\x05\x05\x06\
    \x02\x04\x02\x12\x04\xc1\x03\t\x0b\n\x0c\n\x04\x05\x06\x02\x05\x12\x04\
    \xc2\x03\x02\x10\n\r\n\x05\x05\x06\x02\x05\x01\x12\x04\xc2\x03\x02\n\n\r\
    \n\x05\x05\x06\x02\x05\x02\x12\x04\xc2\x03\r\x0f\n\x0c\n\x04\x05\x06\x02\
    \x06\x12\x04\xc3\x03\x02\x10\n\r\n\x05\x05\x06\x02\x06\x01\x12\x04\xc3\
    \x03\x02\n\n\r\n\x05\x05\x06\x02\x06\x02\x12\x04\xc3\x03\r\x0f\n\x0c\n\
    \x04\x05\x06\x02\x07\x12\x04\xc4\x03\x02\x0b\n\r\n\x05\x05\x06\x02\x07\
    \x01\x12\x04\xc4\x03\x02\x05\n\r\n\x05\x05\x06\x02\x07\x02\x12\x04\xc4\
    \x03\x08\n\n\x0c\n\x04\x05\x06\x02\x08\x12\x04\xc5\x03\x02\x0b\n\r\n\x05\
    \x05\x06\x02\x08\x01\x12\x04\xc5\x03\x02\x05\n\r\n\x05\x05\x06\x02\x08\
    \x02\x12\x04\xc5\x03\x08\n\n\x0c\n\x04\x05\x06\x02\t\x12\x04\xc6\x03\x02\
    \x0e\n\r\n\x05\x05\x06\x02\t\x01\x12\x04\xc6\x03\x02\x08\n\r\n\x05\x05\
    \x06\x02\t\x02\x12\x04\xc6\x03\x0b\r\n\x0c\n\x04\x05\x06\x02\n\x12\x04\
    \xc7\x03\x02\t\n\r\n\x05\x05\x06\x02\n\x01\x12\x04\xc7\x03\x02\x03\n\r\n\
    \x05\x05\x06\x02\n\x02\x12\x04\xc7\x03\x06\x08\n\x0c\n\x04\x05\x06\x02\
    \x0b\x12\x04\xc8\x03\x02\r\n\r\n\x05\x05\x06\x02\x0b\x01\x12\x04\xc8\x03\
    \x02\x07\n\r\n\x05\x05\x06\x02\x0b\x02\x12\x04\xc8\x03\n\x0c\nH\n\x04\
    \x05\x06\x02\x0c\x12\x04\xc9\x03\x02\x0b\":\x20C++\x20(the\x20name\x20\"\
    CPP\"\x20was\x20chosen\x20for\x20consistency\x20with\x20LSP)\n\n\r\n\x05\
    \x05\x06\x02\x0c\x01\x12\x04\xc9\x03\x02\x05\n\r\n\x05\x05\x06\x02\x0c\
    \x02\x12\x04\xc9\x03\x08\n\n\x0c\n\x04\x05\x06\x02\r\x12\x04\xca\x03\x02\
    \x0b\n\r\n\x05\x05\x06\x02\r\x01\x12\x04\xca\x03\x02\x05\n\r\n\x05\x05\
    \x06\x02\r\x02\x12\x04\xca\x03\x08\n\n\x0c\n\x04\x05\x06\x02\x0e\x12\x04\
    \xcb\x03\x02\r\n\r\n\x05\x05\x06\x02\x0e\x01\x12\x04\xcb\x03\x02\x08\n\r\
    \n\x05\x05\x06\x02\x0e\x02\x12\x04\xcb\x03\x0b\x0c\n\x0c\n\x04\x05\x06\
    \x02\x0f\x12\x04\xcc\x03\x02\x0e\n\r\n\x05\x05\x06\x02\x0f\x01\x12\x04\
    \xcc\x03\x02\t\n\r\n\x05\x05\x06\x02\x0f\x02\x12\x04\xcc\x03\x0c\r\n\x0c\
    \n\x04\x05\x06\x02\x10\x12\x04\xcd\x03\x02\x14\n\r\n\x05\x05\x06\x02\x10\
    \x01\x12\x04\xcd\x03\x02\x0e\n\r\n\x05\x05\x06\x02\x10\x02\x12\x04\xcd\
    \x03\x11\x13\n\x0c\n\x04\x05\x06\x02\x11\x12\x04\xce\x03\x02\x11\n\r\n\
    \x05\x05\x06\x02\x11\x01\x12\x04\xce\x03\x02\x0c\n\r\n\x05\x05\x06\x02\
    \x11\x02\x12\x04\xce\x03\x0f\x10\n\x0c\n\x04\x05\x06\x02\x12\x12\x04\xcf\
    \x03\x02\x0b\n\r\n\x05\x05\x06\x02\x12\x01\x12\x04\xcf\x03\x02\x05\n\r\n\
    \x05\x05\x06\x02\x12\x02\x12\x04\xcf\x03\x08\n\n\x0c\n\x04\x05\x06\x02\
    \x13\x12\x04\xd0\x03\x02\x0b\n\r\n\x05\x05\x06\x02\x13\x01\x12\x04\xd0\
    \x03\x02\x06\n\r\n\x05\x05\x06\x02\x13\x02\x12\x04\xd0\x03\t\n\n\x0c\n\
    \x04\x05\x06\x02\x14\x12\x04\xd1\x03\x02\x0e\n\r\n\x05\x05\x06\x02\x14\
    \x01\x12\x04\xd1\x03\x02\x08\n\r\n\x05\x05\x06\x02\x14\x02\x12\x04\xd1\
    \x03\x0b\r\n\x0c\n\x04\x05\x06\x02\x15\x12\x04\xd2\x03\x02\x0c\n\r\n\x05\
    \x05\x06\x02\x15\x01\x12\x04\xd2\x03\x02\x06\n\r\n\x05\x05\x06\x02\x15\
    \x02\x12\x04\xd2\x03\t\x0b\n\x0c\n\x04\x05\x06\x02\x16\x12\x04\xd3\x03\
    \x02\x12\n\r\n\x05\x05\x06\x02\x16\x01\x12\x04\xd3\x03\x02\x0c\n\r\n\x05\
    \x05\x06\x02\x16\x02\x12\x04\xd3\x03\x0f\x11\n\x0c\n\x04\x05\x06\x02\x17\
    \x12\x04\xd4\x03\x02\x0e\n\r\n\x05\x05\x06\x02\x17\x01\x12\x04\xd4\x03\
    \x02\x08\n\r\n\x05\x05\x06\x02\x17\x02\x12\x04\xd4\x03\x0b\r\n\x0c\n\x04\
    \x05\x06\x02\x18\x12\x04\xd5\x03\x02\x0e\n\r\n\x05\x05\x06\x02\x18\x01\
    \x12\x04\xd5\x03\x02\x08\n\r\n\x05\x05\x06\x02\x18\x02\x12\x04\xd5\x03\
    \x0b\r\n\x0c\n\x04\x05\x06\x02\x19\x12\x04\xd6\x03\x02\x0e\n\r\n\x05\x05\
    \x06\x02\x19\x01\x12\x04\xd6\x03\x02\x08\n\r\n\x05\x05\x06\x02\x19\x02\
    \x12\x04\xd6\x03\x0b\r\n\x0c\n\x04\x05\x06\x02\x1a\x12\x04\xd7\x03\x02\
    \x0e\n\r\n\x05\x05\x06\x02\x1a\x01\x12\x04\xd7\x03\x02\x08\n\r\n\x05\x05\
    \x06\x02\x1a\x02\x12\x04\xd7\x03\x0b\r\n\x0c\n\x04\x05\x06\x02\x1b\x12\
    \x04\xd8\x03\x02\x0c\n\r\n\x05\x05\x06\x02\x1b\x01\x12\x04\xd8\x03\x02\
    \x06\n\r\n\x05\x05\x06\x02\x1b\x02\x12\x04\xd8\x03\t\x0b\n\x0c\n\x04\x05\
    \x06\x02\x1c\x12\x04\xd9\x03\x02\x0c\n\r\n\x05\x05\x06\x02\x1c\x01\x12\
    \x04\xd9\x03\x02\x06\n\r\n\x05\x05\x06\x02\x1c\x02\x12\x04\xd9\x03\t\x0b\
    \n\x0c\n\x04\x05\x06\x02\x1d\x12\x04\xda\x03\x02\x0f\n\r\n\x05\x05\x06\
    \x02\x1d\x01\x12\x04\xda\x03\x02\t\n\r\n\x05\x05\x06\x02\x1d\x02\x12\x04\
    \xda\x03\x0c\x0e\n\x0c\n\x04\x05\x06\x02\x1e\x12\x04\xdb\x03\x02\x12\n\r\
    \n\x05\x05\x06\x02\x1e\x01\x12\x04\xdb\x03\x02\x0c\n\r\n\x05\x05\x06\x02\
    \x1e\x02\x12\x04\xdb\x03\x0f\x11\n\x0c\n\x04\x05\x06\x02\x1f\x12\x04\xdc\
    \x03\x02\x12\n\r\n\x05\x05\x06\x02\x1f\x01\x12\x04\xdc\x03\x02\x0c\n\r\n\
    \x05\x05\x06\x02\x1f\x02\x12\x04\xdc\x03\x0f\x11\n\x0c\n\x04\x05\x06\x02\
    \x20\x12\x04\xdd\x03\x02\x12\n\r\n\x05\x05\x06\x02\x20\x01\x12\x04\xdd\
    \x03\x02\x0c\n\r\n\x05\x05\x06\x02\x20\x02\x12\x04\xdd\x03\x0f\x11\n\x0c\
    \n\x04\x05\x06\x02!\x12\x04\xde\x03\x02\n\n\r\n\x05\x05\x06\x02!\x01\x12\
    \x04\xde\x03\x02\x04\n\r\n\x05\x05\x06\x02!\x02\x12\x04\xde\x03\x07\t\n\
    \x0c\n\x04\x05\x06\x02\"\x12\x04\xdf\x03\x02\r\n\r\n\x05\x05\x06\x02\"\
    \x01\x12\x04\xdf\x03\x02\x08\n\r\n\x05\x05\x06\x02\"\x02\x12\x04\xdf\x03\
    \x0b\x0c\n\x0c\n\x04\x05\x06\x02#\x12\x04\xe0\x03\x02\x0c\n\r\n\x05\x05\
    \x06\x02#\x01\x12\x04\xe0\x03\x02\x06\n\r\n\x05\x05\x06\x02#\x02\x12\x04\
    \xe0\x03\t\x0b\n\x0c\n\x04\x05\x06\x02$\x12\x04\xe1\x03\x02\x0c\n\r\n\
    \x05\x05\x06\x02$\x01\x12\x04\xe1\x03\x02\x06\n\r\n\x05\x05\x06\x02$\x02\
    \x12\x04\xe1\x03\t\x0b\n\x0c\n\x04\x05\x06\x02%\x12\x04\xe2\x03\x02\x12\
    \n\r\n\x05\x05\x06\x02%\x01\x12\x04\xe2\x03\x02\x0c\n\r\n\x05\x05\x06\
    \x02%\x02\x12\x04\xe2\x03\x0f\x11\n\x0c\n\x04\x05\x06\x02&\x12\x04\xe3\
    \x03\x02\x0f\n\r\n\x05\x05\x06\x02&\x01\x12\x04\xe3\x03\x02\t\n\r\n\x05\
    \x05\x06\x02&\x02\x12\x04\xe3\x03\x0c\x0e\n\x0c\n\x04\x05\x06\x02'\x12\
    \x04\xe4\x03\x02\r\n\r\n\x05\x05\x06\x02'\x01\x12\x04\xe4\x03\x02\x07\n\
    \r\n\x05\x05\x06\x02'\x02\x12\x04\xe4\x03\n\x0c\n\x0c\n\x04\x05\x06\x02(\
    \x12\x04\xe5\x03\x02\x0b\n\r\n\x05\x05\x06\x02(\x01\x12\x04\xe5\x03\x02\
    \x05\n\r\n\x05\x05\x06\x02(\x02\x12\x04\xe5\x03\x08\n\n\x0c\n\x04\x05\
    \x06\x02)\x12\x04\xe6\x03\x02\t\n\r\n\x05\x05\x06\x02)\x01\x12\x04\xe6\
    \x03\x02\x03\n\r\n\x05\x05\x06\x02)\x02\x12\x04\xe6\x03\x06\x08\n\x0c\n\
    \x04\x05\x06\x02*\x12\x04\xe7\x03\x02\x0c\n\r\n\x05\x05\x06\x02*\x01\x12\
    \x04\xe7\x03\x02\x06\n\r\n\x05\x05\x06\x02*\x02\x12\x04\xe7\x03\t\x0b\n\
    \x0c\n\x04\x05\x06\x02+\x12\x04\xe8\x03\x02\x0b\n\r\n\x05\x05\x06\x02+\
    \x01\x12\x04\xe8\x03\x02\x06\n\r\n\x05\x05\x06\x02+\x02\x12\x04\xe8\x03\
    \t\n\n\x0c\n\x04\x05\x06\x02,\x12\x04\xe9\x03\x02\x12\n\r\n\x05\x05\x06\
    \x02,\x01\x12\x04\xe9\x03\x02\x0c\n\r\n\x05\x05\x06\x02,\x02\x12\x04\xe9\
    \x03\x0f\x11\n\x0c\n\x04\x05\x06\x02-\x12\x04\xea\x03\x02\x17\n\r\n\x05\
    \x05\x06\x02-\x01\x12\x04\xea\x03\x02\x11\n\r\n\x05\x05\x06\x02-\x02\x12\
    \x04\xea\x03\x14\x16\n\x0c\n\x04\x05\x06\x02.\x12\x04\xeb\x03\x02\x0f\n\
    \r\n\x05\x05\x06\x02.\x01\x12\x04\xeb\x03\x02\t\n\r\n\x05\x05\x06\x02.\
    \x02\x12\x04\xeb\x03\x0c\x0e\n\x0c\n\x04\x05\x06\x02/\x12\x04\xec\x03\
    \x02\x0e\n\r\n\x05\x05\x06\x02/\x01\x12\x04\xec\x03\x02\x07\n\r\n\x05\
    \x05\x06\x02/\x02\x12\x04\xec\x03\x0b\r\n\x0c\n\x04\x05\x06\x020\x12\x04\
    \xed\x03\x02\r\n\r\n\x05\x05\x06\x020\x01\x12\x04\xed\x03\x02\x08\n\r\n\
    \x05\x05\x06\x020\x02\x12\x04\xed\x03\x0b\x0c\n\x0c\n\x04\x05\x06\x021\
    \x12\x04\xee\x03\x02\r\n\r\n\x05\x05\x06\x021\x01\x12\x04\xee\x03\x02\
    \x07\n\r\n\x05\x05\x06\x021\x02\x12\x04\xee\x03\n\x0c\n\x0c\n\x04\x05\
    \x06\x022\x12\x04\xef\x03\x02\x0c\n\r\n\x05\x05\x06\x022\x01\x12\x04\xef\
    \x03\x02\x06\n\r\n\x05\x05\x06\x022\x02\x12\x04\xef\x03\t\x0b\n\x0c\n\
    \x04\x05\x06\x023\x12\x04\xf0\x03\x02\x0c\n\r\n\x05\x05\x06\x023\x01\x12\
    \x04\xf0\x03\x02\x06\n\r\n\x05\x05\x06\x023\x02\x12\x04\xf0\x03\t\x0b\n\
    \x0c\n\x04\x05\x06\x024\x12\x04\xf1\x03\x02\x0b\n\r\n\x05\x05\x06\x024\
    \x01\x12\x04\xf1\x03\x02\x05\n\r\n\x05\x05\x06\x024\x02\x12\x04\xf1\x03\
    \x08\n\n\x0c\n\x04\x05\x06\x025\x12\x04\xf2\x03\x02\x10\n\r\n\x05\x05\
    \x06\x025\x01\x12\x04\xf2\x03\x02\n\n\r\n\x05\x05\x06\x025\x02\x12\x04\
    \xf2\x03\r\x0f\n\x0c\n\x04\x05\x06\x026\x12\x04\xf3\x03\x02\x10\n\r\n\
    \x05\x05\x06\x026\x01\x12\x04\xf3\x03\x02\n\n\r\n\x05\x05\x06\x026\x02\
    \x12\x04\xf3\x03\r\x0f\n\x0c\n\x04\x05\x06\x027\x12\x04\xf4\x03\x02\x0e\
    \n\r\n\x05\x05\x06\x027\x01\x12\x04\xf4\x03\x02\x08\n\r\n\x05\x05\x06\
    \x027\x02\x12\x04\xf4\x03\x0b\r\n\x0c\n\x04\x05\x06\x028\x12\x04\xf5\x03\
    \x02\x0b\n\r\n\x05\x05\x06\x028\x01\x12\x04\xf5\x03\x02\x05\n\r\n\x05\
    \x05\x06\x028\x02\x12\x04\xf5\x03\x08\n\n\x0c\n\x04\x05\x06\x029\x12\x04\
    \xf6\x03\x02\r\n\r\n\x05\x05\x06\x029\x01\x12\x04\xf6\x03\x02\x07\n\r\n\
    \x05\x05\x06\x029\x02\x12\x04\xf6\x03\n\x0c\n\x0c\n\x04\x05\x06\x02:\x12\
    \x04\xf7\x03\x02\x13\n\r\n\x05\x05\x06\x02:\x01\x12\x04\xf7\x03\x02\r\n\
    \r\n\x05\x05\x06\x02:\x02\x12\x04\xf7\x03\x10\x12\n\x0c\n\x04\x05\x06\
    \x02;\x12\x04\xf8\x03\x02\x15\n\r\n\x05\x05\x06\x02;\x01\x12\x04\xf8\x03\
    \x02\x0f\n\r\n\x05\x05\x06\x02;\x02\x12\x04\xf8\x03\x12\x14\n\x0c\n\x04\
    \x05\x06\x02<\x12\x04\xf9\x03\x02\x0b\n\r\n\x05\x05\x06\x02<\x01\x12\x04\
    \xf9\x03\x02\x05\n\r\n\x05\x05\x06\x02<\x02\x12\x04\xf9\x03\x08\n\n\x0c\
    \n\x04\x05\x06\x02=\x12\x04\xfa\x03\x02\r\n\r\n\x05\x05\x06\x02=\x01\x12\
    \x04\xfa\x03\x02\x07\n\r\n\x05\x05\x06\x02=\x02\x12\x04\xfa\x03\n\x0c\n\
    \x0c\n\x04\x05\x06\x02>\x12\x04\xfb\x03\x02\x0c\n\r\n\x05\x05\x06\x02>\
    \x01\x12\x04\xfb\x03\x02\x06\n\r\n\x05\x05\x06\x02>\x02\x12\x04\xfb\x03\
    \t\x0b\n\x0c\n\x04\x05\x06\x02?\x12\x04\xfc\x03\x02\x12\n\r\n\x05\x05\
    \x06\x02?\x01\x12\x04\xfc\x03\x02\x0c\n\r\n\x05\x05\x06\x02?\x02\x12\x04\
    \xfc\x03\x0f\x11\n\x0c\n\x04\x05\x06\x02@\x12\x04\xfd\x03\x02\x0e\n\r\n\
    \x05\x05\x06\x02@\x01\x12\x04\xfd\x03\x02\x08\n\r\n\x05\x05\x06\x02@\x02\
    \x12\x04\xfd\x03\x0b\r\n\x0c\n\x04\x05\x06\x02A\x12\x04\xfe\x03\x02\x0e\
    \n\r\n\x05\x05\x06\x02A\x01\x12\x04\xfe\x03\x02\x08\n\r\n\x05\x05\x06\
    \x02A\x02\x12\x04\xfe\x03\x0b\r\n\x0c\n\x04\x05\x06\x02B\x12\x04\xff\x03\
    \x02\t\n\r\n\x05\x05\x06\x02B\x01\x12\x04\xff\x03\x02\x03\n\r\n\x05\x05\
    \x06\x02B\x02\x12\x04\xff\x03\x06\x08\n\x0c\n\x04\x05\x06\x02C\x12\x04\
    \x80\x04\x02\x0e\n\r\n\x05\x05\x06\x02C\x01\x12\x04\x80\x04\x02\x08\n\r\
    \n\x05\x05\x06\x02C\x02\x12\x04\x80\x04\x0b\r\n\x0c\n\x04\x05\x06\x02D\
    \x12\x04\x81\x04\x02\x0c\n\r\n\x05\x05\x06\x02D\x01\x12\x04\x81\x04\x02\
    \x06\n\r\n\x05\x05\x06\x02D\x02\x12\x04\x81\x04\t\x0b\n\x0c\n\x04\x05\
    \x06\x02E\x12\x04\x82\x04\x02\r\n\r\n\x05\x05\x06\x02E\x01\x12\x04\x82\
    \x04\x02\x07\n\r\n\x05\x05\x06\x02E\x02\x12\x04\x82\x04\n\x0c\n\x0c\n\
    \x04\x05\x06\x02F\x12\x04\x83\x04\x02\x0c\n\r\n\x05\x05\x06\x02F\x01\x12\
    \x04\x83\x04\x02\x06\n\r\n\x05\x05\x06\x02F\x02\x12\x04\x83\x04\t\x0b\n\
    \x0c\n\x04\x05\x06\x02G\x12\x04\x84\x04\x02\x0c\n\r\n\x05\x05\x06\x02G\
    \x01\x12\x04\x84\x04\x02\x06\n\r\n\x05\x05\x06\x02G\x02\x12\x04\x84\x04\
    \t\x0b\n\x0c\n\x04\x05\x06\x02H\x12\x04\x85\x04\x02\x0c\n\r\n\x05\x05\
    \x06\x02H\x01\x12\x04\x85\x04\x02\x06\n\r\n\x05\x05\x06\x02H\x02\x12\x04\
    \x85\x04\t\x0b\n\x0c\n\x04\x05\x06\x02I\x12\x04\x86\x04\x02\x0b\n\r\n\
    \x05\x05\x06\x02I\x01\x12\x04\x86\x04\x02\x05\n\r\n\x05\x05\x06\x02I\x02\
    \x12\x04\x86\x04\x08\n\n\x0c\n\x04\x05\x06\x02J\x12\x04\x87\x04\x02\x0c\
    \n\r\n\x05\x05\x06\x02J\x01\x12\x04\x87\x04\x02\x06\n\r\n\x05\x05\x06\
    \x02J\x02\x12\x04\x87\x04\t\x0b\n\x0c\n\x04\x05\x06\x02K\x12\x04\x88\x04\
    \x02\x0b\n\r\n\x05\x05\x06\x02K\x01\x12\x04\x88\x04\x02\x05\n\r\n\x05\
    \x05\x06\x02K\x02\x12\x04\x88\x04\x08\n\n\x0c\n\x04\x05\x06\x02L\x12\x04\
    \x89\x04\x02\x0b\n\r\n\x05\x05\x06\x02L\x01\x12\x04\x89\x04\x02\x05\n\r\
    \n\x05\x05\x06\x02L\x02\x12\x04\x89\x04\x08\n\n\x0c\n\x04\x05\x06\x02M\
    \x12\x04\x8a\x04\x02\x0c\n\r\n\x05\x05\x06\x02M\x01\x12\x04\x8a\x04\x02\
    \x06\n\r\n\x05\x05\x06\x02M\x02\x12\x04\x8a\x04\t\x0b\n\x0c\n\x04\x05\
    \x06\x02N\x12\x04\x8b\x04\x02\x0c\n\r\n\x05\x05\x06\x02N\x01\x12\x04\x8b\
    \x04\x02\x07\n\r\n\x05\x05\x06\x02N\x02\x12\x04\x8b\x04\n\x0b\n\x0c\n\
    \x04\x05\x06\x02O\x12\x04\x8c\x04\x02\x0e\n\r\n\x05\x05\x06\x02O\x01\x12\
    \x04\x8c\x04\x02\x08\n\r\n\x05\x05\x06\x02O\x02\x12\x04\x8c\x04\x0b\r\n\
    \x14\n\x04\x05\x06\x02P\x12\x04\x8d\x04\x02\x13\"\x06\x20Bash\n\n\r\n\
    \x05\x05\x06\x02P\x01\x12\x04\x8d\x04\x02\r\n\r\n\x05\x05\x06\x02P\x02\
    \x12\x04\x8d\x04\x10\x12\n\x0c\n\x04\x05\x06\x02Q\x12\x04\x8e\x04\x02\
    \x0f\n\r\n\x05\x05\x06\x02Q\x01\x12\x04\x8e\x04\x02\t\n\r\n\x05\x05\x06\
    \x02Q\x02\x12\x04\x8e\x04\x0c\x0e\n\x0c\n\x04\x05\x06\x02R\x12\x04\x8f\
    \x04\x02\x0c\n\r\n\x05\x05\x06\x02R\x01\x12\x04\x8f\x04\x02\x07\n\r\n\
    \x05\x05\x06\x02R\x02\x12\x04\x8f\x04\n\x0b\n\x0c\n\x04\x05\x06\x02S\x12\
    \x04\x90\x04\x02\x0c\n\r\n\x05\x05\x06\x02S\x01\x12\x04\x90\x04\x02\x06\
    \n\r\n\x05\x05\x06\x02S\x02\x12\x04\x90\x04\t\x0b\n\x0c\n\x04\x05\x06\
    \x02T\x12\x04\x91\x04\x02\x0b\n\r\n\x05\x05\x06\x02T\x01\x12\x04\x91\x04\
    \x02\x05\n\r\n\x05\x05\x06\x02T\x02\x12\x04\x91\x04\x08\n\n\x0c\n\x04\
    \x05\x06\x02U\x12\x04\x92\x04\x02\x12\n\r\n\x05\x05\x06\x02U\x01\x12\x04\
    \x92\x04\x02\x0c\n\r\n\x05\x05\x06\x02U\x02\x12\x04\x92\x04\x0f\x11\n\
    \x0c\n\x04\x05\x06\x02V\x12\x04\x93\x04\x02\x17\n\r\n\x05\x05\x06\x02V\
    \x01\x12\x04\x93\x04\x02\x11\n\r\n\x05\x05\x06\x02V\x02\x12\x04\x93\x04\
    \x14\x16\n\x0c\n\x04\x05\x06\x02W\x12\x04\x94\x04\x02\x13\n\r\n\x05\x05\
    \x06\x02W\x01\x12\x04\x94\x04\x02\r\n\r\n\x05\x05\x06\x02W\x02\x12\x04\
    \x94\x04\x10\x12\n\x0c\n\x04\x05\x06\x02X\x12\x04\x95\x04\x02\x0b\n\r\n\
    \x05\x05\x06\x02X\x01\x12\x04\x95\x04\x02\x05\n\r\n\x05\x05\x06\x02X\x02\
    \x12\x04\x95\x04\x08\n\n\x0c\n\x04\x05\x06\x02Y\x12\x04\x96\x04\x02\x0f\
    \n\r\n\x05\x05\x06\x02Y\x01\x12\x04\x96\x04\x02\t\n\r\n\x05\x05\x06\x02Y\
    \x02\x12\x04\x96\x04\x0c\x0e\n\x0c\n\x04\x05\x06\x02Z\x12\x04\x97\x04\
    \x02\x0b\n\r\n\x05\x05\x06\x02Z\x01\x12\x04\x97\x04\x02\x05\n\r\n\x05\
    \x05\x06\x02Z\x02\x12\x04\x97\x04\x08\n\n\x0c\n\x04\x05\x06\x02[\x12\x04\
    \x98\x04\x02\x0b\n\r\n\x05\x05\x06\x02[\x01\x12\x04\x98\x04\x02\x05\n\r\
    \n\x05\x05\x06\x02[\x02\x12\x04\x98\x04\x08\n\n\x0c\n\x04\x05\x06\x02\\\
    \x12\x04\x99\x04\x02\x0c\n\r\n\x05\x05\x06\x02\\\x01\x12\x04\x99\x04\x02\
    \x06\n\r\n\x05\x05\x06\x02\\\x02\x12\x04\x99\x04\t\x0b\n\x92\x03\n\x04\
    \x05\x06\x02]\x12\x04\x9a\x04\x02\x0b\"\x83\x03\x20NextLanguage\x20=\x20\
    95;\n\x20Steps\x20add\x20a\x20new\x20language:\n\x201.\x20Copy-paste\x20\
    the\x20\"NextLanguage\x20=\x20N\"\x20line\x20above\n\x202.\x20Increment\
    \x20\"NextLanguage\x20=\x20N\"\x20to\x20\"NextLanguage\x20=\x20N+1\"\n\
    \x203.\x20Replace\x20\"NextLanguage\x20=\x20N\"\x20with\x20the\x20name\
    \x20of\x20the\x20new\x20language.\n\x204.\x20Move\x20the\x20new\x20langu\
    age\x20to\x20the\x20correct\x20line\x20above\x20using\x20alphabetical\
    \x20order\n\x205.\x20(optional)\x20Add\x20a\x20brief\x20comment\x20behin\
    d\x20the\x20language\x20if\x20the\x20name\x20is\x20not\x20self-explanato\
    ry\n\n\r\n\x05\x05\x06\x02]\x01\x12\x04\x9a\x04\x02\x05\n\r\n\x05\x05\
    \x06\x02]\x02\x12\x04\x9a\x04\x08\nb\x06proto3\
";

/// `FileDescriptorProto` object which was a source for this generated file
fn file_descriptor_proto() -> &'static ::protobuf::descriptor::FileDescriptorProto {
    static file_descriptor_proto_lazy: ::protobuf::rt::Lazy<::protobuf::descriptor::FileDescriptorProto> = ::protobuf::rt::Lazy::new();
    file_descriptor_proto_lazy.get(|| {
        ::protobuf::Message::parse_from_bytes(file_descriptor_proto_data).unwrap()
    })
}

/// `FileDescriptor` object which allows dynamic access to files
pub fn file_descriptor() -> &'static ::protobuf::reflect::FileDescriptor {
    static generated_file_descriptor_lazy: ::protobuf::rt::Lazy<::protobuf::reflect::GeneratedFileDescriptor> = ::protobuf::rt::Lazy::new();
    static file_descriptor: ::protobuf::rt::Lazy<::protobuf::reflect::FileDescriptor> = ::protobuf::rt::Lazy::new();
    file_descriptor.get(|| {
        let generated_file_descriptor = generated_file_descriptor_lazy.get(|| {
            let mut deps = ::std::vec::Vec::with_capacity(0);
            let mut messages = ::std::vec::Vec::with_capacity(11);
            messages.push(Index::generated_message_descriptor_data());
            messages.push(Metadata::generated_message_descriptor_data());
            messages.push(ToolInfo::generated_message_descriptor_data());
            messages.push(Document::generated_message_descriptor_data());
            messages.push(Symbol::generated_message_descriptor_data());
            messages.push(Package::generated_message_descriptor_data());
            messages.push(Descriptor::generated_message_descriptor_data());
            messages.push(SymbolInformation::generated_message_descriptor_data());
            messages.push(Relationship::generated_message_descriptor_data());
            messages.push(Occurrence::generated_message_descriptor_data());
            messages.push(Diagnostic::generated_message_descriptor_data());
            let mut enums = ::std::vec::Vec::with_capacity(8);
            enums.push(ProtocolVersion::generated_enum_descriptor_data());
            enums.push(TextEncoding::generated_enum_descriptor_data());
            enums.push(SymbolRole::generated_enum_descriptor_data());
            enums.push(SyntaxKind::generated_enum_descriptor_data());
            enums.push(Severity::generated_enum_descriptor_data());
            enums.push(DiagnosticTag::generated_enum_descriptor_data());
            enums.push(Language::generated_enum_descriptor_data());
            enums.push(descriptor::Suffix::generated_enum_descriptor_data());
            ::protobuf::reflect::GeneratedFileDescriptor::new_generated(
                file_descriptor_proto(),
                deps,
                messages,
                enums,
            )
        });
        ::protobuf::reflect::FileDescriptor::new_generated_2(generated_file_descriptor)
    })
}
