# encoding: utf-8
import os
from waflib.TaskGen import feature, before_method, after_method, taskgen_method

@feature('intltool_po')
@before_method('apply_intltool_po')
def write_linguas_file (self):
    # Bug in Waf 2.0.19: apply_intltool_po (Waf Tools/intltool.py) tries to
    # remove process_source from task list (which seems to be superfluous),
    # but due to a bug in the meth list handling (which surfaces with python3),
    # the next task method will be skipped. Fix: replace the entry
    # 'process source' ẃith 'dummy'
    @taskgen_method
    def dummy(self):
        pass
    try:
        self.meths[self.meths.index('process_source')] = 'dummy'
    except ValueError:
        pass
    linguas = ''
    if 'LINGUAS' in self.bld.env:
        files = self.bld.env['LINGUAS']
        for f in files.split (' '):
            if os.path.exists (os.path.join(self.podir, f+'.po')):
                linguas += f + ' \n'
    else:
        files = os.listdir(self.podir)
        for f in files:
            if f.endswith ('.po'):
                linguas += '%s \n' % f[:-3]
    with open(os.path.join(self.podir, 'LINGUAS'), 'w') as f:
        f.write ('# This file is autogenerated. Do not edit.\n%s' % linguas)

@feature('intltool_po')
@after_method('apply_intltool_po')
def get_localedir(self):
    self.bld.define('LOCALEDIR', self.env.LOCALEDIR)

def configure(conf):
    env = conf.env
    if not env.LOCALEDIR:
        if env.DATAROOTDIR:
            env.LOCALEDIR=os.path.join(env.DATAROOTDIR,'locale')
        else:
            env.LOCALEDIR=os.path.join(env.PREFIX,'share','locale')
    conf.define('LOCALEDIR', env.LOCALEDIR)
