package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetDataLevelPermissionRuleConfig invokes the quickbi_public.SetDataLevelPermissionRuleConfig API synchronously
func (client *Client) SetDataLevelPermissionRuleConfig(request *SetDataLevelPermissionRuleConfigRequest) (response *SetDataLevelPermissionRuleConfigResponse, err error) {
	response = CreateSetDataLevelPermissionRuleConfigResponse()
	err = client.DoAction(request, response)
	return
}

// SetDataLevelPermissionRuleConfigWithChan invokes the quickbi_public.SetDataLevelPermissionRuleConfig API asynchronously
func (client *Client) SetDataLevelPermissionRuleConfigWithChan(request *SetDataLevelPermissionRuleConfigRequest) (<-chan *SetDataLevelPermissionRuleConfigResponse, <-chan error) {
	responseChan := make(chan *SetDataLevelPermissionRuleConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetDataLevelPermissionRuleConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetDataLevelPermissionRuleConfigWithCallback invokes the quickbi_public.SetDataLevelPermissionRuleConfig API asynchronously
func (client *Client) SetDataLevelPermissionRuleConfigWithCallback(request *SetDataLevelPermissionRuleConfigRequest, callback func(response *SetDataLevelPermissionRuleConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetDataLevelPermissionRuleConfigResponse
		var err error
		defer close(result)
		response, err = client.SetDataLevelPermissionRuleConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetDataLevelPermissionRuleConfigRequest is the request struct for api SetDataLevelPermissionRuleConfig
type SetDataLevelPermissionRuleConfigRequest struct {
	*requests.RpcRequest
	AccessPoint string `position:"Query" name:"AccessPoint"`
	SignType    string `position:"Query" name:"SignType"`
	RuleModel   string `position:"Query" name:"RuleModel"`
}

// SetDataLevelPermissionRuleConfigResponse is the response struct for api SetDataLevelPermissionRuleConfig
type SetDataLevelPermissionRuleConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateSetDataLevelPermissionRuleConfigRequest creates a request to invoke SetDataLevelPermissionRuleConfig API
func CreateSetDataLevelPermissionRuleConfigRequest() (request *SetDataLevelPermissionRuleConfigRequest) {
	request = &SetDataLevelPermissionRuleConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2020-11-11", "SetDataLevelPermissionRuleConfig", "quickbi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetDataLevelPermissionRuleConfigResponse creates a response to parse from SetDataLevelPermissionRuleConfig response
func CreateSetDataLevelPermissionRuleConfigResponse() (response *SetDataLevelPermissionRuleConfigResponse) {
	response = &SetDataLevelPermissionRuleConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
