package ocr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizeVideoCharacter invokes the ocr.RecognizeVideoCharacter API synchronously
func (client *Client) RecognizeVideoCharacter(request *RecognizeVideoCharacterRequest) (response *RecognizeVideoCharacterResponse, err error) {
	response = CreateRecognizeVideoCharacterResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizeVideoCharacterWithChan invokes the ocr.RecognizeVideoCharacter API asynchronously
func (client *Client) RecognizeVideoCharacterWithChan(request *RecognizeVideoCharacterRequest) (<-chan *RecognizeVideoCharacterResponse, <-chan error) {
	responseChan := make(chan *RecognizeVideoCharacterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizeVideoCharacter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizeVideoCharacterWithCallback invokes the ocr.RecognizeVideoCharacter API asynchronously
func (client *Client) RecognizeVideoCharacterWithCallback(request *RecognizeVideoCharacterRequest, callback func(response *RecognizeVideoCharacterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizeVideoCharacterResponse
		var err error
		defer close(result)
		response, err = client.RecognizeVideoCharacter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizeVideoCharacterRequest is the request struct for api RecognizeVideoCharacter
type RecognizeVideoCharacterRequest struct {
	*requests.RpcRequest
	FormatResultToJson requests.Boolean `position:"Query" name:"FormatResultToJson"`
	OssFile            string           `position:"Query" name:"OssFile"`
	RequestProxyBy     string           `position:"Query" name:"RequestProxyBy"`
	Async              requests.Boolean `position:"Body" name:"Async"`
	VideoURL           string           `position:"Body" name:"VideoURL"`
}

// RecognizeVideoCharacterResponse is the response struct for api RecognizeVideoCharacter
type RecognizeVideoCharacterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRecognizeVideoCharacterRequest creates a request to invoke RecognizeVideoCharacter API
func CreateRecognizeVideoCharacterRequest() (request *RecognizeVideoCharacterRequest) {
	request = &RecognizeVideoCharacterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ocr", "2019-12-30", "RecognizeVideoCharacter", "ocr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRecognizeVideoCharacterResponse creates a response to parse from RecognizeVideoCharacter response
func CreateRecognizeVideoCharacterResponse() (response *RecognizeVideoCharacterResponse) {
	response = &RecognizeVideoCharacterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
