package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitImageQualityJob invokes the mts.SubmitImageQualityJob API synchronously
func (client *Client) SubmitImageQualityJob(request *SubmitImageQualityJobRequest) (response *SubmitImageQualityJobResponse, err error) {
	response = CreateSubmitImageQualityJobResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitImageQualityJobWithChan invokes the mts.SubmitImageQualityJob API asynchronously
func (client *Client) SubmitImageQualityJobWithChan(request *SubmitImageQualityJobRequest) (<-chan *SubmitImageQualityJobResponse, <-chan error) {
	responseChan := make(chan *SubmitImageQualityJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitImageQualityJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitImageQualityJobWithCallback invokes the mts.SubmitImageQualityJob API asynchronously
func (client *Client) SubmitImageQualityJobWithCallback(request *SubmitImageQualityJobRequest, callback func(response *SubmitImageQualityJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitImageQualityJobResponse
		var err error
		defer close(result)
		response, err = client.SubmitImageQualityJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitImageQualityJobRequest is the request struct for api SubmitImageQualityJob
type SubmitImageQualityJobRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	UserData             string           `position:"Query" name:"UserData"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PipelineId           string           `position:"Query" name:"PipelineId"`
	Input                string           `position:"Query" name:"Input"`
}

// SubmitImageQualityJobResponse is the response struct for api SubmitImageQualityJob
type SubmitImageQualityJobResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	ImageQualityJob ImageQualityJob `json:"ImageQualityJob" xml:"ImageQualityJob"`
}

// CreateSubmitImageQualityJobRequest creates a request to invoke SubmitImageQualityJob API
func CreateSubmitImageQualityJobRequest() (request *SubmitImageQualityJobRequest) {
	request = &SubmitImageQualityJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "SubmitImageQualityJob", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitImageQualityJobResponse creates a response to parse from SubmitImageQualityJob response
func CreateSubmitImageQualityJobResponse() (response *SubmitImageQualityJobResponse) {
	response = &SubmitImageQualityJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
