package dm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SingleSendSms invokes the dm.SingleSendSms API synchronously
// api document: https://help.aliyun.com/api/dm/singlesendsms.html
func (client *Client) SingleSendSms(request *SingleSendSmsRequest) (response *SingleSendSmsResponse, err error) {
	response = CreateSingleSendSmsResponse()
	err = client.DoAction(request, response)
	return
}

// SingleSendSmsWithChan invokes the dm.SingleSendSms API asynchronously
// api document: https://help.aliyun.com/api/dm/singlesendsms.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SingleSendSmsWithChan(request *SingleSendSmsRequest) (<-chan *SingleSendSmsResponse, <-chan error) {
	responseChan := make(chan *SingleSendSmsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SingleSendSms(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SingleSendSmsWithCallback invokes the dm.SingleSendSms API asynchronously
// api document: https://help.aliyun.com/api/dm/singlesendsms.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SingleSendSmsWithCallback(request *SingleSendSmsRequest, callback func(response *SingleSendSmsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SingleSendSmsResponse
		var err error
		defer close(result)
		response, err = client.SingleSendSms(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SingleSendSmsRequest is the request struct for api SingleSendSms
type SingleSendSmsRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SignName             string           `position:"Query" name:"SignName"`
	TemplateCode         string           `position:"Query" name:"TemplateCode"`
	RecNum               string           `position:"Query" name:"RecNum"`
	ParamString          string           `position:"Query" name:"ParamString"`
	Version              string           `position:"Query" name:"Version"`
}

// SingleSendSmsResponse is the response struct for api SingleSendSms
type SingleSendSmsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSingleSendSmsRequest creates a request to invoke SingleSendSms API
func CreateSingleSendSmsRequest() (request *SingleSendSmsRequest) {
	request = &SingleSendSmsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dm", "2015-11-23", "SingleSendSms", "", "")
	return
}

// CreateSingleSendSmsResponse creates a response to parse from SingleSendSms response
func CreateSingleSendSmsResponse() (response *SingleSendSmsResponse) {
	response = &SingleSendSmsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
