//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
#[cfg(feature = "dispatch2")]
use dispatch2::*;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlevent?language=objc)
    pub unsafe trait MTLEvent: NSObjectProtocol {
        #[cfg(feature = "MTLDevice")]
        /// The device this event can be used with. Will be nil when the event is shared across devices (i.e. MTLSharedEvent).
        #[unsafe(method(device))]
        #[unsafe(method_family = none)]
        fn device(&self) -> Option<Retained<ProtocolObject<dyn MTLDevice>>>;

        /// A string to help identify this object.
        #[unsafe(method(label))]
        #[unsafe(method_family = none)]
        fn label(&self) -> Option<Retained<NSString>>;

        /// Setter for [`label`][Self::label].
        #[unsafe(method(setLabel:))]
        #[unsafe(method_family = none)]
        fn setLabel(&self, label: Option<&NSString>);
    }
);

extern_class!(
    /// This class provides a simple interface for handling the dispatching of MTLSharedEvent notifications from Metal.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlsharedeventlistener?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLSharedEventListener;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLSharedEventListener {}
);

impl MTLSharedEventListener {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "dispatch2")]
        #[unsafe(method(initWithDispatchQueue:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithDispatchQueue(
            this: Allocated<Self>,
            dispatch_queue: &DispatchQueue,
        ) -> Retained<Self>;

        #[cfg(feature = "dispatch2")]
        #[unsafe(method(dispatchQueue))]
        #[unsafe(method_family = none)]
        pub unsafe fn dispatchQueue(&self) -> Retained<DispatchQueue>;
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLSharedEventListener {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for MTLSharedEventListener {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlsharedeventnotificationblock?language=objc)
#[cfg(feature = "block2")]
pub type MTLSharedEventNotificationBlock =
    *mut block2::DynBlock<dyn Fn(NonNull<ProtocolObject<dyn MTLSharedEvent>>, u64)>;

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlsharedevent?language=objc)
    pub unsafe trait MTLSharedEvent: MTLEvent {
        #[cfg(feature = "block2")]
        #[unsafe(method(notifyListener:atValue:block:))]
        #[unsafe(method_family = none)]
        unsafe fn notifyListener_atValue_block(
            &self,
            listener: &MTLSharedEventListener,
            value: u64,
            block: MTLSharedEventNotificationBlock,
        );

        #[unsafe(method(newSharedEventHandle))]
        #[unsafe(method_family = new)]
        unsafe fn newSharedEventHandle(&self) -> Retained<MTLSharedEventHandle>;

        #[unsafe(method(waitUntilSignaledValue:timeoutMS:))]
        #[unsafe(method_family = none)]
        unsafe fn waitUntilSignaledValue_timeoutMS(&self, value: u64, milliseconds: u64) -> bool;

        #[unsafe(method(signaledValue))]
        #[unsafe(method_family = none)]
        unsafe fn signaledValue(&self) -> u64;

        /// Setter for [`signaledValue`][Self::signaledValue].
        #[unsafe(method(setSignaledValue:))]
        #[unsafe(method_family = none)]
        unsafe fn setSignaledValue(&self, signaled_value: u64);
    }
);

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlsharedeventhandle?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLSharedEventHandle;
);

extern_conformance!(
    unsafe impl NSCoding for MTLSharedEventHandle {}
);

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLSharedEventHandle {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for MTLSharedEventHandle {}
);

impl MTLSharedEventHandle {
    extern_methods!(
        #[unsafe(method(label))]
        #[unsafe(method_family = none)]
        pub fn label(&self) -> Option<Retained<NSString>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLSharedEventHandle {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
