package vulnerability

type Metadata struct {
	ID          string
	DataSource  string
	Namespace   string
	Severity    string
	URLs        []string
	Description string
	Cvss        []Cvss
}

type Cvss struct {
	Source         string
	Type           string
	Version        string
	Vector         string
	Metrics        CvssMetrics
	VendorMetadata interface{}
}

type CvssMetrics struct {
	BaseScore           float64
	ExploitabilityScore *float64
	ImpactScore         *float64
}

func NewCvssMetrics(baseScore, exploitabilityScore, impactScore float64) CvssMetrics {
	return CvssMetrics{
		BaseScore:           baseScore,
		ExploitabilityScore: &exploitabilityScore,
		ImpactScore:         &impactScore,
	}
}
