import React from 'react';
import { type RouterLinkComponent } from './router-link-provider';
import { type ColorMode, type Theme } from './theme-provider';
interface AppProviderProps {
    /**
     * Initial color mode.
     */
    defaultColorMode?: ColorMode;
    /**
     * Theme settings.
     */
    defaultTheme?: Partial<Theme>;
    /**
     * A configured router link component.
     */
    routerLinkComponent?: RouterLinkComponent<any>;
    /**
     * Disables theming functionality.
     * This is intended for use in apps with existing
     * theming configuration that want to incrementally
     * adopt AppProvider.
     *
     * @warning Use with caution. This prop will be removed in a future release.
     */
    UNSAFE_isThemingDisabled?: boolean;
    /**
     * App content.
     */
    children: React.ReactNode;
}
/**
 * __App provider__
 *
 * An app provider provides app level configuration such as global theming.
 *
 * Place it at the root of your application.
 */
declare function AppProvider({ children, defaultColorMode, defaultTheme, routerLinkComponent, UNSAFE_isThemingDisabled, }: AppProviderProps): React.JSX.Element;
export default AppProvider;
