/*
Convection Texture Tools
Copyright (c) 2018-2019 Eric Lasota

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject
to the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

-------------------------------------------------------------------------------------

Portions based on DirectX Texture Library (DirectXTex)

Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the MIT License.

http://go.microsoft.com/fwlink/?LinkId=248926
*/
#include "ConvectionKernels_Config.h"

#if !defined(CVTT_SINGLE_FILE) || defined(CVTT_SINGLE_FILE_IMPL)

#include "ConvectionKernels_BC7_Prio.h"

#define BC7_PARTITION_BITS  6
#define BC7_PARTITION_OFFSET_BITS  0

#define BC7_ROTATION_BITS   2
#define BC7_ROTATION_OFFSET_BITS    0

#define BC7_INDEX_MODE_BITS 1
#define BC7_INDEX_MODE_OFFSET_BITS (BC7_ROTATION_OFFSET_BITS + BC7_ROTATION_BITS)

#define BC7_MODE_BITS 3
#define BC7_MODE_OFFSET_BITS (BC7_PARTITION_OFFSET_BITS + BC7_PARTITION_BITS)
#define BC7_SEED_POINT_COUNT_BITS  2
#define BC7_SEED_POINT_COUNT_OFFSET_BITS  (BC7_MODE_BITS + BC7_MODE_OFFSET_BITS)



#define BC7_MODE_PRIO_DUAL_PLANE(subData)   \
    ( \
        ((subData / 10) << BC7_ROTATION_OFFSET_BITS) | \
        ((subData % 10) << BC7_INDEX_MODE_OFFSET_BITS) \
    )

#define BC7_MODE_PRIO_CODE(seedPointCount, mode, subData)   \
    (\
        ((seedPointCount - 1) << BC7_SEED_POINT_COUNT_OFFSET_BITS) |  \
        (mode << BC7_MODE_OFFSET_BITS) |   \
        ((mode == 4 || mode == 5) ? BC7_MODE_PRIO_DUAL_PLANE(subData) : (subData << BC7_PARTITION_OFFSET_BITS)) \
    )

namespace cvtt { namespace Tables { namespace BC7Prio {
    const uint16_t g_bc7PrioCodesRGBData[] =
    {
        BC7_MODE_PRIO_CODE(1, 1, 13),
        BC7_MODE_PRIO_CODE(1, 1, 0),
        BC7_MODE_PRIO_CODE(1, 0, 3),
        BC7_MODE_PRIO_CODE(1, 0, 1),
        BC7_MODE_PRIO_CODE(1, 6, 0),
        BC7_MODE_PRIO_CODE(1, 0, 9),
        BC7_MODE_PRIO_CODE(1, 1, 6),
        BC7_MODE_PRIO_CODE(1, 1, 1),
        BC7_MODE_PRIO_CODE(1, 1, 2),
        BC7_MODE_PRIO_CODE(1, 0, 15),
        BC7_MODE_PRIO_CODE(1, 1, 7),
        BC7_MODE_PRIO_CODE(1, 1, 16),
        BC7_MODE_PRIO_CODE(1, 1, 15),
        BC7_MODE_PRIO_CODE(1, 1, 14),
        BC7_MODE_PRIO_CODE(1, 0, 13),
        BC7_MODE_PRIO_CODE(1, 0, 14),
        BC7_MODE_PRIO_CODE(1, 0, 11),
        BC7_MODE_PRIO_CODE(1, 1, 22),
        BC7_MODE_PRIO_CODE(1, 0, 8),
        BC7_MODE_PRIO_CODE(1, 0, 10),
        BC7_MODE_PRIO_CODE(1, 1, 8),
        BC7_MODE_PRIO_CODE(1, 3, 13),
        BC7_MODE_PRIO_CODE(1, 1, 19),
        BC7_MODE_PRIO_CODE(1, 4, 31),
        BC7_MODE_PRIO_CODE(1, 1, 10),
        BC7_MODE_PRIO_CODE(1, 1, 23),
        BC7_MODE_PRIO_CODE(1, 1, 3),
        BC7_MODE_PRIO_CODE(2, 1, 13),
        BC7_MODE_PRIO_CODE(1, 1, 9),
        BC7_MODE_PRIO_CODE(2, 1, 0),
        BC7_MODE_PRIO_CODE(1, 1, 20),
        BC7_MODE_PRIO_CODE(1, 1, 21),
        BC7_MODE_PRIO_CODE(1, 4, 11),
        BC7_MODE_PRIO_CODE(1, 1, 29),
        BC7_MODE_PRIO_CODE(1, 1, 26),
        BC7_MODE_PRIO_CODE(1, 5, 30),
        BC7_MODE_PRIO_CODE(1, 0, 4),
        BC7_MODE_PRIO_CODE(2, 6, 0),
        BC7_MODE_PRIO_CODE(1, 0, 0),
        BC7_MODE_PRIO_CODE(2, 0, 10),
        BC7_MODE_PRIO_CODE(3, 6, 0),
        BC7_MODE_PRIO_CODE(1, 1, 11),
        BC7_MODE_PRIO_CODE(1, 4, 10),
        BC7_MODE_PRIO_CODE(2, 0, 8),
        BC7_MODE_PRIO_CODE(2, 0, 11),
        BC7_MODE_PRIO_CODE(2, 0, 13),
        BC7_MODE_PRIO_CODE(1, 1, 4),
        BC7_MODE_PRIO_CODE(3, 1, 13),
        BC7_MODE_PRIO_CODE(1, 1, 12),
        BC7_MODE_PRIO_CODE(1, 1, 18),
        BC7_MODE_PRIO_CODE(1, 3, 0),
        BC7_MODE_PRIO_CODE(1, 0, 5),
        BC7_MODE_PRIO_CODE(1, 1, 17),
        BC7_MODE_PRIO_CODE(1, 1, 25),
        BC7_MODE_PRIO_CODE(1, 0, 7),
        BC7_MODE_PRIO_CODE(3, 0, 10),
        BC7_MODE_PRIO_CODE(1, 1, 5),
        BC7_MODE_PRIO_CODE(2, 1, 10),
        BC7_MODE_PRIO_CODE(1, 1, 24),
        BC7_MODE_PRIO_CODE(3, 0, 8),
        BC7_MODE_PRIO_CODE(3, 1, 0),
        BC7_MODE_PRIO_CODE(2, 1, 15),
        BC7_MODE_PRIO_CODE(2, 1, 14),
        BC7_MODE_PRIO_CODE(3, 0, 13),
        BC7_MODE_PRIO_CODE(3, 0, 11),
        BC7_MODE_PRIO_CODE(2, 1, 16),
        BC7_MODE_PRIO_CODE(2, 0, 14),
        BC7_MODE_PRIO_CODE(2, 1, 3),
        BC7_MODE_PRIO_CODE(4, 0, 10),
        BC7_MODE_PRIO_CODE(2, 1, 1),
        BC7_MODE_PRIO_CODE(1, 0, 2),
        BC7_MODE_PRIO_CODE(2, 1, 2),
        BC7_MODE_PRIO_CODE(4, 0, 8),
        BC7_MODE_PRIO_CODE(1, 0, 12),
        BC7_MODE_PRIO_CODE(4, 1, 13),
        BC7_MODE_PRIO_CODE(1, 5, 10),
        BC7_MODE_PRIO_CODE(2, 0, 15),
        BC7_MODE_PRIO_CODE(1, 0, 6),
        BC7_MODE_PRIO_CODE(1, 1, 35),
        BC7_MODE_PRIO_CODE(2, 1, 23),
        BC7_MODE_PRIO_CODE(4, 0, 13),
        BC7_MODE_PRIO_CODE(4, 0, 11),
        BC7_MODE_PRIO_CODE(1, 2, 17),
        BC7_MODE_PRIO_CODE(2, 1, 6),
        BC7_MODE_PRIO_CODE(2, 1, 7),
        BC7_MODE_PRIO_CODE(4, 6, 0),
        BC7_MODE_PRIO_CODE(1, 2, 16),
        BC7_MODE_PRIO_CODE(2, 1, 19),
        BC7_MODE_PRIO_CODE(1, 1, 30),
        BC7_MODE_PRIO_CODE(2, 3, 13),
        BC7_MODE_PRIO_CODE(3, 0, 14),
        BC7_MODE_PRIO_CODE(2, 1, 29),
        BC7_MODE_PRIO_CODE(2, 1, 21),
        BC7_MODE_PRIO_CODE(4, 1, 0),
        BC7_MODE_PRIO_CODE(3, 0, 15),
        BC7_MODE_PRIO_CODE(2, 0, 3),
        BC7_MODE_PRIO_CODE(1, 1, 28),
        BC7_MODE_PRIO_CODE(1, 4, 30),
        BC7_MODE_PRIO_CODE(2, 0, 4),
        BC7_MODE_PRIO_CODE(1, 2, 63),
        BC7_MODE_PRIO_CODE(4, 0, 14),
        BC7_MODE_PRIO_CODE(2, 1, 26),
        BC7_MODE_PRIO_CODE(2, 0, 1),
        BC7_MODE_PRIO_CODE(3, 0, 3),
        BC7_MODE_PRIO_CODE(1, 1, 61),
        BC7_MODE_PRIO_CODE(2, 0, 7),
        BC7_MODE_PRIO_CODE(2, 0, 5),
        BC7_MODE_PRIO_CODE(3, 1, 10),
        BC7_MODE_PRIO_CODE(2, 4, 31),
        BC7_MODE_PRIO_CODE(2, 0, 9),
        BC7_MODE_PRIO_CODE(2, 1, 11),
        BC7_MODE_PRIO_CODE(4, 0, 15),
        BC7_MODE_PRIO_CODE(3, 1, 14),
        BC7_MODE_PRIO_CODE(2, 0, 0),
        BC7_MODE_PRIO_CODE(3, 1, 15),
        BC7_MODE_PRIO_CODE(2, 3, 0),
        BC7_MODE_PRIO_CODE(3, 0, 1),
        BC7_MODE_PRIO_CODE(1, 1, 60),
        BC7_MODE_PRIO_CODE(2, 1, 12),
        BC7_MODE_PRIO_CODE(3, 1, 1),
        BC7_MODE_PRIO_CODE(3, 0, 5),
        BC7_MODE_PRIO_CODE(1, 1, 27),
        BC7_MODE_PRIO_CODE(2, 1, 18),
        BC7_MODE_PRIO_CODE(3, 0, 9),
        BC7_MODE_PRIO_CODE(3, 1, 3),
        BC7_MODE_PRIO_CODE(2, 0, 2),
        BC7_MODE_PRIO_CODE(3, 1, 16),
        BC7_MODE_PRIO_CODE(3, 1, 2),
        BC7_MODE_PRIO_CODE(1, 1, 31),
        BC7_MODE_PRIO_CODE(3, 0, 7),
        BC7_MODE_PRIO_CODE(2, 1, 17),
        BC7_MODE_PRIO_CODE(1, 5, 20),
        BC7_MODE_PRIO_CODE(2, 1, 4),
        BC7_MODE_PRIO_CODE(1, 1, 62),
        BC7_MODE_PRIO_CODE(2, 0, 12),
        BC7_MODE_PRIO_CODE(3, 0, 4),
        BC7_MODE_PRIO_CODE(4, 0, 4),
        BC7_MODE_PRIO_CODE(1, 1, 33),
        BC7_MODE_PRIO_CODE(3, 1, 23),
        BC7_MODE_PRIO_CODE(2, 1, 5),
        BC7_MODE_PRIO_CODE(2, 0, 6),
        BC7_MODE_PRIO_CODE(2, 1, 24),
        BC7_MODE_PRIO_CODE(1, 1, 59),
        BC7_MODE_PRIO_CODE(1, 1, 63),
        BC7_MODE_PRIO_CODE(3, 0, 0),
        BC7_MODE_PRIO_CODE(1, 1, 52),
        BC7_MODE_PRIO_CODE(4, 0, 7),
        BC7_MODE_PRIO_CODE(2, 1, 22),
        BC7_MODE_PRIO_CODE(4, 0, 3),
        BC7_MODE_PRIO_CODE(1, 2, 10),
        BC7_MODE_PRIO_CODE(3, 1, 7),
        BC7_MODE_PRIO_CODE(4, 0, 9),
        BC7_MODE_PRIO_CODE(2, 1, 8),
        BC7_MODE_PRIO_CODE(4, 0, 1),
        BC7_MODE_PRIO_CODE(3, 0, 12),
        BC7_MODE_PRIO_CODE(4, 0, 5),
        BC7_MODE_PRIO_CODE(3, 1, 6),
        BC7_MODE_PRIO_CODE(4, 1, 14),
        BC7_MODE_PRIO_CODE(1, 3, 15),
        BC7_MODE_PRIO_CODE(1, 1, 56),
        BC7_MODE_PRIO_CODE(3, 0, 6),
        BC7_MODE_PRIO_CODE(3, 0, 2),
        BC7_MODE_PRIO_CODE(1, 1, 32),
        BC7_MODE_PRIO_CODE(4, 1, 10),
        BC7_MODE_PRIO_CODE(1, 2, 8),
        BC7_MODE_PRIO_CODE(2, 1, 9),
        BC7_MODE_PRIO_CODE(1, 2, 18),
        BC7_MODE_PRIO_CODE(4, 1, 15),
        BC7_MODE_PRIO_CODE(4, 0, 6),
        BC7_MODE_PRIO_CODE(3, 1, 29),
        BC7_MODE_PRIO_CODE(2, 1, 25),
        BC7_MODE_PRIO_CODE(3, 4, 31),
        BC7_MODE_PRIO_CODE(3, 3, 13),
        BC7_MODE_PRIO_CODE(4, 0, 0),
        BC7_MODE_PRIO_CODE(3, 1, 19),
        BC7_MODE_PRIO_CODE(4, 0, 12),
        BC7_MODE_PRIO_CODE(4, 1, 1),
        BC7_MODE_PRIO_CODE(4, 0, 2),
        BC7_MODE_PRIO_CODE(1, 3, 2),
        BC7_MODE_PRIO_CODE(1, 2, 13),
        BC7_MODE_PRIO_CODE(1, 1, 58),
        BC7_MODE_PRIO_CODE(1, 3, 14),
        BC7_MODE_PRIO_CODE(4, 1, 3),
        BC7_MODE_PRIO_CODE(3, 1, 21),
        BC7_MODE_PRIO_CODE(2, 2, 8),
        BC7_MODE_PRIO_CODE(1, 2, 19),
        BC7_MODE_PRIO_CODE(4, 1, 16),
        BC7_MODE_PRIO_CODE(4, 1, 2),
        BC7_MODE_PRIO_CODE(2, 2, 16),
        BC7_MODE_PRIO_CODE(2, 2, 10),
        BC7_MODE_PRIO_CODE(2, 1, 20),
        BC7_MODE_PRIO_CODE(1, 2, 11),
        BC7_MODE_PRIO_CODE(1, 1, 54),
        BC7_MODE_PRIO_CODE(1, 1, 47),
        BC7_MODE_PRIO_CODE(1, 3, 1),
        BC7_MODE_PRIO_CODE(1, 2, 21),
        BC7_MODE_PRIO_CODE(1, 2, 62),
        BC7_MODE_PRIO_CODE(2, 2, 11),
        BC7_MODE_PRIO_CODE(3, 1, 26),
        BC7_MODE_PRIO_CODE(1, 1, 53),
        BC7_MODE_PRIO_CODE(2, 1, 35),
        BC7_MODE_PRIO_CODE(2, 2, 13),
        BC7_MODE_PRIO_CODE(4, 1, 23),
        BC7_MODE_PRIO_CODE(4, 1, 6),
        BC7_MODE_PRIO_CODE(4, 1, 7),
        BC7_MODE_PRIO_CODE(1, 2, 25),
        BC7_MODE_PRIO_CODE(1, 1, 57),
        BC7_MODE_PRIO_CODE(2, 1, 60),
        BC7_MODE_PRIO_CODE(1, 2, 20),
        BC7_MODE_PRIO_CODE(3, 1, 8),
        BC7_MODE_PRIO_CODE(4, 1, 29),
        BC7_MODE_PRIO_CODE(4, 1, 19),
        BC7_MODE_PRIO_CODE(3, 2, 8),
        BC7_MODE_PRIO_CODE(2, 4, 11),
        BC7_MODE_PRIO_CODE(4, 1, 21),
        BC7_MODE_PRIO_CODE(3, 2, 10),
        BC7_MODE_PRIO_CODE(2, 1, 61),
        BC7_MODE_PRIO_CODE(2, 1, 30),
        BC7_MODE_PRIO_CODE(3, 1, 12),
        BC7_MODE_PRIO_CODE(3, 1, 11),
        BC7_MODE_PRIO_CODE(2, 1, 63),
        BC7_MODE_PRIO_CODE(2, 3, 1),
        BC7_MODE_PRIO_CODE(2, 1, 28),
        BC7_MODE_PRIO_CODE(2, 1, 62),
        BC7_MODE_PRIO_CODE(3, 2, 13),
        BC7_MODE_PRIO_CODE(2, 2, 63),
        BC7_MODE_PRIO_CODE(2, 1, 33),
        BC7_MODE_PRIO_CODE(2, 4, 10),
        BC7_MODE_PRIO_CODE(3, 1, 18),
        BC7_MODE_PRIO_CODE(2, 5, 30),
        BC7_MODE_PRIO_CODE(3, 1, 5),
        BC7_MODE_PRIO_CODE(2, 2, 17),
        BC7_MODE_PRIO_CODE(1, 1, 55),
        BC7_MODE_PRIO_CODE(3, 1, 17),
        BC7_MODE_PRIO_CODE(2, 3, 2),
        BC7_MODE_PRIO_CODE(1, 4, 21),
        BC7_MODE_PRIO_CODE(3, 2, 11),
        BC7_MODE_PRIO_CODE(4, 1, 11),
        BC7_MODE_PRIO_CODE(2, 1, 27),
        BC7_MODE_PRIO_CODE(1, 2, 59),
        BC7_MODE_PRIO_CODE(4, 1, 26),
        BC7_MODE_PRIO_CODE(3, 1, 9),
        BC7_MODE_PRIO_CODE(2, 3, 14),
        BC7_MODE_PRIO_CODE(3, 1, 4),
        BC7_MODE_PRIO_CODE(3, 1, 24),
        BC7_MODE_PRIO_CODE(3, 1, 25),
        BC7_MODE_PRIO_CODE(3, 3, 0),
        BC7_MODE_PRIO_CODE(3, 4, 11),
        BC7_MODE_PRIO_CODE(4, 1, 12),
        BC7_MODE_PRIO_CODE(2, 1, 32),
        BC7_MODE_PRIO_CODE(2, 3, 15),
        BC7_MODE_PRIO_CODE(4, 2, 10),
        BC7_MODE_PRIO_CODE(1, 2, 60),
        BC7_MODE_PRIO_CODE(1, 2, 32),
        BC7_MODE_PRIO_CODE(1, 1, 40),
        BC7_MODE_PRIO_CODE(4, 1, 18),
        BC7_MODE_PRIO_CODE(2, 1, 59),
        BC7_MODE_PRIO_CODE(4, 1, 5),
        BC7_MODE_PRIO_CODE(3, 1, 22),
        BC7_MODE_PRIO_CODE(3, 2, 16),
        BC7_MODE_PRIO_CODE(3, 1, 20),
        BC7_MODE_PRIO_CODE(4, 1, 4),
        BC7_MODE_PRIO_CODE(2, 1, 31),
        BC7_MODE_PRIO_CODE(4, 1, 17),
        BC7_MODE_PRIO_CODE(1, 2, 24),
        BC7_MODE_PRIO_CODE(4, 1, 24),
        BC7_MODE_PRIO_CODE(2, 1, 58),
        BC7_MODE_PRIO_CODE(4, 2, 8),
        BC7_MODE_PRIO_CODE(1, 2, 22),
        BC7_MODE_PRIO_CODE(1, 2, 23),
        BC7_MODE_PRIO_CODE(1, 3, 10),
        BC7_MODE_PRIO_CODE(1, 1, 41),
        BC7_MODE_PRIO_CODE(2, 2, 18),
        BC7_MODE_PRIO_CODE(4, 1, 25),
        BC7_MODE_PRIO_CODE(3, 1, 61),
        BC7_MODE_PRIO_CODE(1, 3, 29),
        BC7_MODE_PRIO_CODE(1, 2, 57),
        BC7_MODE_PRIO_CODE(2, 2, 19),
        BC7_MODE_PRIO_CODE(1, 2, 53),
        BC7_MODE_PRIO_CODE(1, 2, 55),
        BC7_MODE_PRIO_CODE(3, 2, 63),
        BC7_MODE_PRIO_CODE(3, 1, 60),
        BC7_MODE_PRIO_CODE(4, 1, 8),
        BC7_MODE_PRIO_CODE(2, 1, 56),
        BC7_MODE_PRIO_CODE(3, 1, 35),
        BC7_MODE_PRIO_CODE(4, 4, 31),
        BC7_MODE_PRIO_CODE(4, 1, 9),
        BC7_MODE_PRIO_CODE(1, 1, 46),
        BC7_MODE_PRIO_CODE(1, 2, 58),
        BC7_MODE_PRIO_CODE(2, 3, 29),
        BC7_MODE_PRIO_CODE(1, 1, 45),
        BC7_MODE_PRIO_CODE(4, 2, 13),
        BC7_MODE_PRIO_CODE(1, 1, 42),
        BC7_MODE_PRIO_CODE(1, 3, 3),
        BC7_MODE_PRIO_CODE(4, 2, 11),
        BC7_MODE_PRIO_CODE(3, 1, 63),
        BC7_MODE_PRIO_CODE(3, 1, 30),
        BC7_MODE_PRIO_CODE(1, 1, 36),
        BC7_MODE_PRIO_CODE(3, 1, 62),
        BC7_MODE_PRIO_CODE(1, 1, 43),
        BC7_MODE_PRIO_CODE(1, 3, 21),
        BC7_MODE_PRIO_CODE(3, 2, 17),
        BC7_MODE_PRIO_CODE(1, 2, 14),
        BC7_MODE_PRIO_CODE(1, 1, 48),
        BC7_MODE_PRIO_CODE(2, 1, 57),
        BC7_MODE_PRIO_CODE(2, 1, 52),
        BC7_MODE_PRIO_CODE(1, 2, 61),
        BC7_MODE_PRIO_CODE(3, 1, 33),
        BC7_MODE_PRIO_CODE(1, 1, 51),
        BC7_MODE_PRIO_CODE(4, 1, 20),
        BC7_MODE_PRIO_CODE(1, 3, 8),
        BC7_MODE_PRIO_CODE(4, 1, 22),
        BC7_MODE_PRIO_CODE(1, 3, 19),
        BC7_MODE_PRIO_CODE(1, 2, 36),
        BC7_MODE_PRIO_CODE(2, 5, 10),
        BC7_MODE_PRIO_CODE(3, 1, 28),
        BC7_MODE_PRIO_CODE(2, 2, 14),
        BC7_MODE_PRIO_CODE(1, 1, 49),
        BC7_MODE_PRIO_CODE(1, 2, 33),
        BC7_MODE_PRIO_CODE(1, 3, 9),
        BC7_MODE_PRIO_CODE(2, 2, 20),
        BC7_MODE_PRIO_CODE(1, 3, 26),
        BC7_MODE_PRIO_CODE(2, 1, 53),
        BC7_MODE_PRIO_CODE(4, 3, 13),
        BC7_MODE_PRIO_CODE(2, 2, 21),
        BC7_MODE_PRIO_CODE(3, 4, 10),
        BC7_MODE_PRIO_CODE(4, 1, 60),
        BC7_MODE_PRIO_CODE(2, 1, 54),
        BC7_MODE_PRIO_CODE(1, 2, 29),
        BC7_MODE_PRIO_CODE(2, 1, 47),
        BC7_MODE_PRIO_CODE(1, 2, 52),
        BC7_MODE_PRIO_CODE(3, 1, 32),
        BC7_MODE_PRIO_CODE(1, 2, 40),
        BC7_MODE_PRIO_CODE(1, 2, 31),
        BC7_MODE_PRIO_CODE(3, 1, 27),
        BC7_MODE_PRIO_CODE(3, 2, 18),
        BC7_MODE_PRIO_CODE(2, 3, 10),
        BC7_MODE_PRIO_CODE(2, 1, 55),
        BC7_MODE_PRIO_CODE(4, 1, 61),
        BC7_MODE_PRIO_CODE(3, 2, 14),
        BC7_MODE_PRIO_CODE(3, 1, 31),
        BC7_MODE_PRIO_CODE(1, 2, 34),
        BC7_MODE_PRIO_CODE(3, 2, 19),
        BC7_MODE_PRIO_CODE(2, 3, 21),
        BC7_MODE_PRIO_CODE(2, 4, 30),
        BC7_MODE_PRIO_CODE(1, 2, 15),
        BC7_MODE_PRIO_CODE(2, 3, 26),
        BC7_MODE_PRIO_CODE(1, 2, 28),
        BC7_MODE_PRIO_CODE(4, 2, 16),
        BC7_MODE_PRIO_CODE(2, 2, 15),
        BC7_MODE_PRIO_CODE(2, 1, 40),
        BC7_MODE_PRIO_CODE(2, 2, 22),
        BC7_MODE_PRIO_CODE(4, 1, 33),
        BC7_MODE_PRIO_CODE(1, 3, 7),
        BC7_MODE_PRIO_CODE(1, 1, 50),
        BC7_MODE_PRIO_CODE(2, 1, 41),
        BC7_MODE_PRIO_CODE(1, 2, 9),
        BC7_MODE_PRIO_CODE(1, 2, 39),
        BC7_MODE_PRIO_CODE(2, 2, 25),
        BC7_MODE_PRIO_CODE(1, 3, 6),
        BC7_MODE_PRIO_CODE(3, 2, 21),
        BC7_MODE_PRIO_CODE(1, 1, 37),
        BC7_MODE_PRIO_CODE(2, 2, 58),
        BC7_MODE_PRIO_CODE(3, 3, 29),
        BC7_MODE_PRIO_CODE(4, 1, 62),
        BC7_MODE_PRIO_CODE(1, 2, 35),
        BC7_MODE_PRIO_CODE(3, 1, 59),
        BC7_MODE_PRIO_CODE(4, 1, 28),
        BC7_MODE_PRIO_CODE(1, 3, 23),
        BC7_MODE_PRIO_CODE(4, 1, 30),
        BC7_MODE_PRIO_CODE(2, 1, 45),
        BC7_MODE_PRIO_CODE(1, 3, 16),
        BC7_MODE_PRIO_CODE(4, 1, 35),
        BC7_MODE_PRIO_CODE(2, 1, 46),
        BC7_MODE_PRIO_CODE(1, 2, 38),
        BC7_MODE_PRIO_CODE(4, 1, 63),
        BC7_MODE_PRIO_CODE(1, 3, 22),
        BC7_MODE_PRIO_CODE(1, 2, 30),
        BC7_MODE_PRIO_CODE(2, 2, 31),
        BC7_MODE_PRIO_CODE(1, 3, 20),
        BC7_MODE_PRIO_CODE(2, 2, 9),
        BC7_MODE_PRIO_CODE(2, 3, 3),
        BC7_MODE_PRIO_CODE(3, 2, 22),
        BC7_MODE_PRIO_CODE(2, 1, 42),
        BC7_MODE_PRIO_CODE(2, 2, 62),
        BC7_MODE_PRIO_CODE(3, 2, 20),
        BC7_MODE_PRIO_CODE(4, 1, 32),
        BC7_MODE_PRIO_CODE(2, 1, 43),
        BC7_MODE_PRIO_CODE(3, 1, 58),
        BC7_MODE_PRIO_CODE(2, 3, 19),
        BC7_MODE_PRIO_CODE(2, 2, 32),
        BC7_MODE_PRIO_CODE(2, 2, 57),
        BC7_MODE_PRIO_CODE(4, 1, 27),
        BC7_MODE_PRIO_CODE(2, 2, 34),
        BC7_MODE_PRIO_CODE(4, 1, 58),
        BC7_MODE_PRIO_CODE(1, 2, 12),
        BC7_MODE_PRIO_CODE(2, 2, 12),
        BC7_MODE_PRIO_CODE(1, 4, 20),
        BC7_MODE_PRIO_CODE(1, 2, 56),
        BC7_MODE_PRIO_CODE(2, 1, 48),
        BC7_MODE_PRIO_CODE(2, 1, 36),
        BC7_MODE_PRIO_CODE(4, 3, 0),
        BC7_MODE_PRIO_CODE(2, 2, 24),
        BC7_MODE_PRIO_CODE(3, 1, 40),
        BC7_MODE_PRIO_CODE(3, 2, 9),
        BC7_MODE_PRIO_CODE(3, 1, 56),
        BC7_MODE_PRIO_CODE(3, 2, 15),
        BC7_MODE_PRIO_CODE(2, 3, 7),
        BC7_MODE_PRIO_CODE(1, 2, 37),
        BC7_MODE_PRIO_CODE(2, 2, 35),
        BC7_MODE_PRIO_CODE(3, 1, 52),
        BC7_MODE_PRIO_CODE(2, 3, 6),
        BC7_MODE_PRIO_CODE(3, 1, 57),
        BC7_MODE_PRIO_CODE(4, 1, 31),
        BC7_MODE_PRIO_CODE(4, 4, 11),
        BC7_MODE_PRIO_CODE(1, 1, 44),
        BC7_MODE_PRIO_CODE(3, 3, 1),
        BC7_MODE_PRIO_CODE(1, 2, 54),
        BC7_MODE_PRIO_CODE(2, 1, 50),
        BC7_MODE_PRIO_CODE(3, 3, 15),
        BC7_MODE_PRIO_CODE(2, 1, 51),
        BC7_MODE_PRIO_CODE(1, 2, 27),
        BC7_MODE_PRIO_CODE(3, 4, 30),
        BC7_MODE_PRIO_CODE(3, 3, 14),
        BC7_MODE_PRIO_CODE(3, 2, 25),
        BC7_MODE_PRIO_CODE(2, 3, 9),
        BC7_MODE_PRIO_CODE(2, 2, 60),
        BC7_MODE_PRIO_CODE(2, 1, 49),
        BC7_MODE_PRIO_CODE(1, 2, 6),
        BC7_MODE_PRIO_CODE(2, 2, 23),
        BC7_MODE_PRIO_CODE(3, 2, 12),
        BC7_MODE_PRIO_CODE(3, 3, 2),
        BC7_MODE_PRIO_CODE(4, 2, 14),
        BC7_MODE_PRIO_CODE(2, 3, 16),
        BC7_MODE_PRIO_CODE(1, 2, 51),
        BC7_MODE_PRIO_CODE(1, 3, 11),
        BC7_MODE_PRIO_CODE(1, 2, 4),
        BC7_MODE_PRIO_CODE(4, 2, 17),
        BC7_MODE_PRIO_CODE(1, 3, 12),
        BC7_MODE_PRIO_CODE(3, 1, 43),
        BC7_MODE_PRIO_CODE(2, 4, 21),
        BC7_MODE_PRIO_CODE(4, 1, 56),
        BC7_MODE_PRIO_CODE(3, 1, 53),
        BC7_MODE_PRIO_CODE(3, 1, 47),
        BC7_MODE_PRIO_CODE(2, 2, 61),
        BC7_MODE_PRIO_CODE(2, 2, 55),
        BC7_MODE_PRIO_CODE(2, 3, 23),
        BC7_MODE_PRIO_CODE(3, 1, 42),
        BC7_MODE_PRIO_CODE(2, 3, 8),
        BC7_MODE_PRIO_CODE(3, 1, 55),
        BC7_MODE_PRIO_CODE(4, 1, 59),
        BC7_MODE_PRIO_CODE(3, 2, 60),
        BC7_MODE_PRIO_CODE(2, 3, 20),
        BC7_MODE_PRIO_CODE(3, 2, 57),
        BC7_MODE_PRIO_CODE(3, 1, 54),
        BC7_MODE_PRIO_CODE(3, 2, 35),
        BC7_MODE_PRIO_CODE(1, 1, 38),
        BC7_MODE_PRIO_CODE(1, 2, 5),
        BC7_MODE_PRIO_CODE(2, 2, 5),
        BC7_MODE_PRIO_CODE(2, 2, 6),
        BC7_MODE_PRIO_CODE(3, 2, 23),
        BC7_MODE_PRIO_CODE(2, 2, 59),
        BC7_MODE_PRIO_CODE(3, 2, 5),
        BC7_MODE_PRIO_CODE(4, 1, 42),
        BC7_MODE_PRIO_CODE(2, 1, 37),
        BC7_MODE_PRIO_CODE(3, 2, 59),
        BC7_MODE_PRIO_CODE(4, 2, 9),
        BC7_MODE_PRIO_CODE(2, 2, 4),
        BC7_MODE_PRIO_CODE(2, 2, 56),
        BC7_MODE_PRIO_CODE(1, 3, 33),
        BC7_MODE_PRIO_CODE(2, 3, 33),
        BC7_MODE_PRIO_CODE(2, 3, 22),
        BC7_MODE_PRIO_CODE(2, 3, 12),
        BC7_MODE_PRIO_CODE(4, 1, 40),
        BC7_MODE_PRIO_CODE(3, 2, 34),
        BC7_MODE_PRIO_CODE(3, 2, 56),
        BC7_MODE_PRIO_CODE(3, 3, 26),
        BC7_MODE_PRIO_CODE(1, 2, 7),
        BC7_MODE_PRIO_CODE(2, 2, 7),
        BC7_MODE_PRIO_CODE(3, 2, 7),
        BC7_MODE_PRIO_CODE(2, 2, 36),
        BC7_MODE_PRIO_CODE(3, 2, 36),
        BC7_MODE_PRIO_CODE(4, 1, 52),
        BC7_MODE_PRIO_CODE(2, 2, 33),
        BC7_MODE_PRIO_CODE(3, 1, 45),
        BC7_MODE_PRIO_CODE(1, 3, 4),
        BC7_MODE_PRIO_CODE(4, 2, 15),
        BC7_MODE_PRIO_CODE(3, 1, 41),
        BC7_MODE_PRIO_CODE(2, 2, 54),
        BC7_MODE_PRIO_CODE(3, 2, 4),
        BC7_MODE_PRIO_CODE(2, 5, 20),
        BC7_MODE_PRIO_CODE(3, 2, 62),
        BC7_MODE_PRIO_CODE(1, 3, 35),
        BC7_MODE_PRIO_CODE(4, 1, 41),
        BC7_MODE_PRIO_CODE(3, 2, 6),
        BC7_MODE_PRIO_CODE(2, 2, 52),
        BC7_MODE_PRIO_CODE(3, 1, 46),
        BC7_MODE_PRIO_CODE(1, 1, 39),
        BC7_MODE_PRIO_CODE(3, 2, 33),
        BC7_MODE_PRIO_CODE(1, 3, 5),
        BC7_MODE_PRIO_CODE(3, 1, 48),
        BC7_MODE_PRIO_CODE(3, 2, 24),
        BC7_MODE_PRIO_CODE(3, 2, 32),
        BC7_MODE_PRIO_CODE(3, 3, 33),
        BC7_MODE_PRIO_CODE(1, 3, 17),
        BC7_MODE_PRIO_CODE(4, 1, 57),
        BC7_MODE_PRIO_CODE(1, 3, 25),
        BC7_MODE_PRIO_CODE(2, 3, 11),
        BC7_MODE_PRIO_CODE(1, 3, 61),
        BC7_MODE_PRIO_CODE(4, 1, 43),
        BC7_MODE_PRIO_CODE(1, 3, 60),
        BC7_MODE_PRIO_CODE(2, 3, 60),
        BC7_MODE_PRIO_CODE(2, 2, 28),
        BC7_MODE_PRIO_CODE(3, 2, 28),
        BC7_MODE_PRIO_CODE(4, 1, 55),
        BC7_MODE_PRIO_CODE(2, 3, 5),
        BC7_MODE_PRIO_CODE(3, 1, 51),
        BC7_MODE_PRIO_CODE(4, 1, 53),
        BC7_MODE_PRIO_CODE(4, 1, 54),
        BC7_MODE_PRIO_CODE(1, 3, 32),
        BC7_MODE_PRIO_CODE(1, 3, 24),
        BC7_MODE_PRIO_CODE(4, 1, 47),
        BC7_MODE_PRIO_CODE(2, 2, 51),
        BC7_MODE_PRIO_CODE(4, 2, 12),
        BC7_MODE_PRIO_CODE(2, 3, 61),
        BC7_MODE_PRIO_CODE(3, 4, 21),
        BC7_MODE_PRIO_CODE(2, 3, 32),
        BC7_MODE_PRIO_CODE(3, 1, 36),
        BC7_MODE_PRIO_CODE(3, 1, 49),
        BC7_MODE_PRIO_CODE(1, 3, 18),
        BC7_MODE_PRIO_CODE(4, 3, 29),
        BC7_MODE_PRIO_CODE(4, 2, 63),
        BC7_MODE_PRIO_CODE(2, 2, 27),
        BC7_MODE_PRIO_CODE(2, 3, 17),
        BC7_MODE_PRIO_CODE(3, 1, 50),
        BC7_MODE_PRIO_CODE(3, 2, 61),
        BC7_MODE_PRIO_CODE(1, 3, 63),
        BC7_MODE_PRIO_CODE(2, 3, 63),
        BC7_MODE_PRIO_CODE(3, 2, 27),
        BC7_MODE_PRIO_CODE(4, 1, 46),
        BC7_MODE_PRIO_CODE(1, 2, 26),
        BC7_MODE_PRIO_CODE(2, 3, 4),
        BC7_MODE_PRIO_CODE(2, 3, 18),
        BC7_MODE_PRIO_CODE(4, 1, 45),
        BC7_MODE_PRIO_CODE(4, 1, 51),
        BC7_MODE_PRIO_CODE(1, 2, 1),
        BC7_MODE_PRIO_CODE(4, 2, 6),
        BC7_MODE_PRIO_CODE(1, 3, 62),
        BC7_MODE_PRIO_CODE(2, 3, 62),
        BC7_MODE_PRIO_CODE(2, 1, 44),
        BC7_MODE_PRIO_CODE(4, 1, 49),
        BC7_MODE_PRIO_CODE(3, 5, 30),
        BC7_MODE_PRIO_CODE(2, 3, 25),
        BC7_MODE_PRIO_CODE(1, 2, 49),
        BC7_MODE_PRIO_CODE(4, 1, 48),
        BC7_MODE_PRIO_CODE(3, 3, 3),
        BC7_MODE_PRIO_CODE(3, 1, 37),
        BC7_MODE_PRIO_CODE(1, 2, 0),
        BC7_MODE_PRIO_CODE(2, 2, 0),
        BC7_MODE_PRIO_CODE(2, 3, 35),
        BC7_MODE_PRIO_CODE(2, 3, 24),
        BC7_MODE_PRIO_CODE(2, 2, 53),
        BC7_MODE_PRIO_CODE(3, 2, 53),
        BC7_MODE_PRIO_CODE(4, 2, 59),
        BC7_MODE_PRIO_CODE(3, 3, 10),
        BC7_MODE_PRIO_CODE(1, 2, 3),
        BC7_MODE_PRIO_CODE(2, 2, 3),
        BC7_MODE_PRIO_CODE(3, 2, 3),
        BC7_MODE_PRIO_CODE(3, 3, 32),
        BC7_MODE_PRIO_CODE(1, 2, 46),
        BC7_MODE_PRIO_CODE(4, 2, 62),
        BC7_MODE_PRIO_CODE(4, 2, 60),
        BC7_MODE_PRIO_CODE(2, 2, 30),
        BC7_MODE_PRIO_CODE(1, 3, 47),
        BC7_MODE_PRIO_CODE(4, 2, 36),
        BC7_MODE_PRIO_CODE(2, 2, 1),
        BC7_MODE_PRIO_CODE(3, 2, 1),
        BC7_MODE_PRIO_CODE(3, 2, 58),
        BC7_MODE_PRIO_CODE(4, 1, 36),
        BC7_MODE_PRIO_CODE(3, 3, 16),
        BC7_MODE_PRIO_CODE(2, 3, 47),
        BC7_MODE_PRIO_CODE(2, 2, 39),
        BC7_MODE_PRIO_CODE(4, 1, 50),
        BC7_MODE_PRIO_CODE(4, 2, 21),
        BC7_MODE_PRIO_CODE(2, 1, 38),
        BC7_MODE_PRIO_CODE(4, 4, 21),
        BC7_MODE_PRIO_CODE(3, 3, 23),
        BC7_MODE_PRIO_CODE(1, 2, 43),
        BC7_MODE_PRIO_CODE(1, 2, 41),
        BC7_MODE_PRIO_CODE(2, 2, 41),
        BC7_MODE_PRIO_CODE(1, 3, 28),
        BC7_MODE_PRIO_CODE(4, 2, 35),
        BC7_MODE_PRIO_CODE(4, 3, 26),
        BC7_MODE_PRIO_CODE(1, 3, 59),
        BC7_MODE_PRIO_CODE(1, 1, 34),
        BC7_MODE_PRIO_CODE(2, 2, 29),
        BC7_MODE_PRIO_CODE(3, 2, 29),
        BC7_MODE_PRIO_CODE(3, 2, 52),
        BC7_MODE_PRIO_CODE(1, 3, 58),
        BC7_MODE_PRIO_CODE(4, 5, 30),
        BC7_MODE_PRIO_CODE(4, 3, 33),
        BC7_MODE_PRIO_CODE(3, 2, 30),
        BC7_MODE_PRIO_CODE(1, 2, 44),
        BC7_MODE_PRIO_CODE(1, 2, 2),
        BC7_MODE_PRIO_CODE(2, 2, 2),
        BC7_MODE_PRIO_CODE(3, 2, 2),
        BC7_MODE_PRIO_CODE(1, 2, 47),
        BC7_MODE_PRIO_CODE(2, 2, 47),
        BC7_MODE_PRIO_CODE(3, 3, 7),
        BC7_MODE_PRIO_CODE(2, 3, 58),
        BC7_MODE_PRIO_CODE(3, 2, 55),
        BC7_MODE_PRIO_CODE(4, 2, 4),
        BC7_MODE_PRIO_CODE(3, 2, 0),
        BC7_MODE_PRIO_CODE(1, 3, 31),
        BC7_MODE_PRIO_CODE(3, 2, 31),
        BC7_MODE_PRIO_CODE(3, 3, 12),
        BC7_MODE_PRIO_CODE(3, 2, 51),
        BC7_MODE_PRIO_CODE(2, 1, 39),
        BC7_MODE_PRIO_CODE(1, 3, 48),
        BC7_MODE_PRIO_CODE(1, 3, 27),
        BC7_MODE_PRIO_CODE(4, 2, 25),
        BC7_MODE_PRIO_CODE(4, 2, 22),
        BC7_MODE_PRIO_CODE(4, 2, 18),
        BC7_MODE_PRIO_CODE(2, 2, 44),
        BC7_MODE_PRIO_CODE(2, 3, 28),
        BC7_MODE_PRIO_CODE(3, 1, 44),
        BC7_MODE_PRIO_CODE(2, 1, 34),
        BC7_MODE_PRIO_CODE(3, 5, 10),
        BC7_MODE_PRIO_CODE(4, 4, 10),
        BC7_MODE_PRIO_CODE(3, 2, 54),
        BC7_MODE_PRIO_CODE(4, 2, 7),
        BC7_MODE_PRIO_CODE(4, 2, 20),
        BC7_MODE_PRIO_CODE(2, 2, 37),
        BC7_MODE_PRIO_CODE(3, 3, 6),
        BC7_MODE_PRIO_CODE(2, 2, 43),
        BC7_MODE_PRIO_CODE(2, 3, 59),
        BC7_MODE_PRIO_CODE(1, 3, 30),
        BC7_MODE_PRIO_CODE(4, 2, 5),
        BC7_MODE_PRIO_CODE(4, 2, 61),
        BC7_MODE_PRIO_CODE(4, 2, 19),
        BC7_MODE_PRIO_CODE(4, 2, 23),
        BC7_MODE_PRIO_CODE(3, 2, 39),
        BC7_MODE_PRIO_CODE(2, 3, 27),
        BC7_MODE_PRIO_CODE(1, 3, 57),
        BC7_MODE_PRIO_CODE(2, 3, 57),
        BC7_MODE_PRIO_CODE(3, 3, 21),
        BC7_MODE_PRIO_CODE(3, 3, 11),
        BC7_MODE_PRIO_CODE(3, 1, 39),
        BC7_MODE_PRIO_CODE(2, 3, 48),
        BC7_MODE_PRIO_CODE(4, 1, 37),
        BC7_MODE_PRIO_CODE(3, 3, 19),
        BC7_MODE_PRIO_CODE(3, 1, 38),
        BC7_MODE_PRIO_CODE(2, 2, 38),
        BC7_MODE_PRIO_CODE(2, 3, 31),
        BC7_MODE_PRIO_CODE(2, 2, 40),
        BC7_MODE_PRIO_CODE(3, 2, 40),
        BC7_MODE_PRIO_CODE(1, 3, 56),
        BC7_MODE_PRIO_CODE(4, 5, 10),
        BC7_MODE_PRIO_CODE(2, 3, 56),
        BC7_MODE_PRIO_CODE(4, 1, 38),
        BC7_MODE_PRIO_CODE(1, 3, 41),
        BC7_MODE_PRIO_CODE(1, 3, 50),
        BC7_MODE_PRIO_CODE(2, 3, 30),
        BC7_MODE_PRIO_CODE(3, 3, 8),
        BC7_MODE_PRIO_CODE(4, 2, 24),
        BC7_MODE_PRIO_CODE(3, 3, 9),
        BC7_MODE_PRIO_CODE(3, 1, 34),
        BC7_MODE_PRIO_CODE(4, 1, 34),
        BC7_MODE_PRIO_CODE(2, 3, 50),
        BC7_MODE_PRIO_CODE(1, 3, 43),
        BC7_MODE_PRIO_CODE(1, 3, 40),
        BC7_MODE_PRIO_CODE(1, 3, 51),
        BC7_MODE_PRIO_CODE(2, 3, 51),
        BC7_MODE_PRIO_CODE(1, 3, 45),
        BC7_MODE_PRIO_CODE(2, 3, 45),
        BC7_MODE_PRIO_CODE(2, 3, 40),
        BC7_MODE_PRIO_CODE(3, 3, 20),
        BC7_MODE_PRIO_CODE(2, 3, 41),
        BC7_MODE_PRIO_CODE(3, 2, 44),
        BC7_MODE_PRIO_CODE(2, 3, 43),
        BC7_MODE_PRIO_CODE(4, 2, 57),
        BC7_MODE_PRIO_CODE(2, 4, 20),
        BC7_MODE_PRIO_CODE(3, 3, 4),
        BC7_MODE_PRIO_CODE(3, 3, 61),
        BC7_MODE_PRIO_CODE(1, 3, 46),
        BC7_MODE_PRIO_CODE(2, 3, 46),
        BC7_MODE_PRIO_CODE(4, 3, 1),
        BC7_MODE_PRIO_CODE(3, 3, 22),
        BC7_MODE_PRIO_CODE(1, 3, 49),
        BC7_MODE_PRIO_CODE(2, 3, 49),
        BC7_MODE_PRIO_CODE(4, 3, 15),
        BC7_MODE_PRIO_CODE(3, 3, 5),
        BC7_MODE_PRIO_CODE(4, 1, 44),
        BC7_MODE_PRIO_CODE(4, 3, 14),
        BC7_MODE_PRIO_CODE(4, 3, 2),
        BC7_MODE_PRIO_CODE(3, 3, 60),
        BC7_MODE_PRIO_CODE(1, 3, 53),
        BC7_MODE_PRIO_CODE(2, 3, 53),
        BC7_MODE_PRIO_CODE(4, 3, 32),
        BC7_MODE_PRIO_CODE(3, 3, 24),
        BC7_MODE_PRIO_CODE(3, 3, 63),
        BC7_MODE_PRIO_CODE(3, 2, 37),
        BC7_MODE_PRIO_CODE(1, 3, 52),
        BC7_MODE_PRIO_CODE(2, 3, 52),
        BC7_MODE_PRIO_CODE(4, 4, 30),
        BC7_MODE_PRIO_CODE(4, 2, 34),
        BC7_MODE_PRIO_CODE(1, 3, 54),
        BC7_MODE_PRIO_CODE(3, 3, 62),
        BC7_MODE_PRIO_CODE(3, 3, 18),
        BC7_MODE_PRIO_CODE(3, 2, 41),
        BC7_MODE_PRIO_CODE(4, 2, 58),
        BC7_MODE_PRIO_CODE(1, 3, 42),
        BC7_MODE_PRIO_CODE(2, 3, 42),
        BC7_MODE_PRIO_CODE(4, 2, 0),
        BC7_MODE_PRIO_CODE(4, 2, 55),
        BC7_MODE_PRIO_CODE(2, 3, 54),
        BC7_MODE_PRIO_CODE(3, 2, 47),
        BC7_MODE_PRIO_CODE(4, 2, 53),
        BC7_MODE_PRIO_CODE(3, 3, 25),
        BC7_MODE_PRIO_CODE(3, 4, 20),
        BC7_MODE_PRIO_CODE(4, 2, 33),
        BC7_MODE_PRIO_CODE(1, 3, 55),
        BC7_MODE_PRIO_CODE(2, 3, 55),
        BC7_MODE_PRIO_CODE(4, 2, 32),
        BC7_MODE_PRIO_CODE(3, 2, 43),
        BC7_MODE_PRIO_CODE(3, 3, 17),
        BC7_MODE_PRIO_CODE(3, 5, 20),
        BC7_MODE_PRIO_CODE(4, 5, 20),
        BC7_MODE_PRIO_CODE(1, 3, 36),
        BC7_MODE_PRIO_CODE(2, 3, 36),
        BC7_MODE_PRIO_CODE(4, 2, 54),
        BC7_MODE_PRIO_CODE(2, 2, 49),
        BC7_MODE_PRIO_CODE(3, 2, 49),
        BC7_MODE_PRIO_CODE(4, 1, 39),
        BC7_MODE_PRIO_CODE(4, 2, 3),
        BC7_MODE_PRIO_CODE(3, 3, 35),
        BC7_MODE_PRIO_CODE(4, 2, 52),
        BC7_MODE_PRIO_CODE(4, 2, 1),
        BC7_MODE_PRIO_CODE(1, 2, 50),
        BC7_MODE_PRIO_CODE(4, 2, 49),
        BC7_MODE_PRIO_CODE(4, 3, 16),
        BC7_MODE_PRIO_CODE(2, 2, 50),
        BC7_MODE_PRIO_CODE(3, 2, 50),
        BC7_MODE_PRIO_CODE(4, 2, 31),
        BC7_MODE_PRIO_CODE(4, 3, 3),
        BC7_MODE_PRIO_CODE(1, 2, 48),
        BC7_MODE_PRIO_CODE(2, 2, 48),
        BC7_MODE_PRIO_CODE(3, 2, 48),
        BC7_MODE_PRIO_CODE(3, 3, 28),
        BC7_MODE_PRIO_CODE(4, 3, 9),
        BC7_MODE_PRIO_CODE(1, 3, 38),
        BC7_MODE_PRIO_CODE(4, 3, 10),
        BC7_MODE_PRIO_CODE(3, 3, 31),
        BC7_MODE_PRIO_CODE(4, 2, 51),
        BC7_MODE_PRIO_CODE(1, 3, 37),
        BC7_MODE_PRIO_CODE(2, 3, 37),
        BC7_MODE_PRIO_CODE(3, 3, 50),
        BC7_MODE_PRIO_CODE(2, 3, 38),
        BC7_MODE_PRIO_CODE(4, 3, 20),
        BC7_MODE_PRIO_CODE(3, 3, 41),
        BC7_MODE_PRIO_CODE(3, 3, 56),
        BC7_MODE_PRIO_CODE(4, 3, 6),
        BC7_MODE_PRIO_CODE(4, 3, 8),
        BC7_MODE_PRIO_CODE(4, 2, 37),
        BC7_MODE_PRIO_CODE(3, 3, 58),
        BC7_MODE_PRIO_CODE(3, 3, 59),
        BC7_MODE_PRIO_CODE(4, 2, 56),
        BC7_MODE_PRIO_CODE(1, 3, 39),
        BC7_MODE_PRIO_CODE(2, 3, 39),
        BC7_MODE_PRIO_CODE(4, 2, 43),
        BC7_MODE_PRIO_CODE(1, 3, 44),
        BC7_MODE_PRIO_CODE(2, 3, 44),
        BC7_MODE_PRIO_CODE(4, 3, 7),
        BC7_MODE_PRIO_CODE(3, 3, 27),
        BC7_MODE_PRIO_CODE(4, 3, 23),
        BC7_MODE_PRIO_CODE(3, 3, 45),
        BC7_MODE_PRIO_CODE(4, 3, 22),
        BC7_MODE_PRIO_CODE(3, 3, 30),
        BC7_MODE_PRIO_CODE(3, 3, 48),
        BC7_MODE_PRIO_CODE(3, 3, 51),
        BC7_MODE_PRIO_CODE(1, 2, 42),
        BC7_MODE_PRIO_CODE(2, 2, 42),
        BC7_MODE_PRIO_CODE(3, 2, 42),
        BC7_MODE_PRIO_CODE(4, 3, 19),
        BC7_MODE_PRIO_CODE(4, 3, 21),
        BC7_MODE_PRIO_CODE(2, 2, 46),
        BC7_MODE_PRIO_CODE(3, 3, 36),
        BC7_MODE_PRIO_CODE(4, 2, 28),
        BC7_MODE_PRIO_CODE(3, 3, 49),
        BC7_MODE_PRIO_CODE(3, 3, 53),
        BC7_MODE_PRIO_CODE(3, 3, 55),
        BC7_MODE_PRIO_CODE(2, 2, 26),
        BC7_MODE_PRIO_CODE(3, 2, 26),
        BC7_MODE_PRIO_CODE(4, 2, 30),
        BC7_MODE_PRIO_CODE(3, 3, 52),
        BC7_MODE_PRIO_CODE(4, 2, 41),
        BC7_MODE_PRIO_CODE(4, 2, 29),
        BC7_MODE_PRIO_CODE(1, 3, 34),
        BC7_MODE_PRIO_CODE(2, 3, 34),
        BC7_MODE_PRIO_CODE(4, 2, 44),
        BC7_MODE_PRIO_CODE(3, 3, 43),
        BC7_MODE_PRIO_CODE(4, 2, 47),
        BC7_MODE_PRIO_CODE(4, 3, 18),
        BC7_MODE_PRIO_CODE(4, 3, 17),
        BC7_MODE_PRIO_CODE(3, 3, 47),
        BC7_MODE_PRIO_CODE(4, 3, 11),
        BC7_MODE_PRIO_CODE(3, 3, 57),
        BC7_MODE_PRIO_CODE(3, 2, 38),
        BC7_MODE_PRIO_CODE(3, 3, 46),
        BC7_MODE_PRIO_CODE(4, 3, 25),
        BC7_MODE_PRIO_CODE(4, 3, 4),
        BC7_MODE_PRIO_CODE(3, 3, 42),
        BC7_MODE_PRIO_CODE(4, 3, 61),
        BC7_MODE_PRIO_CODE(4, 2, 48),
        BC7_MODE_PRIO_CODE(4, 3, 5),
        BC7_MODE_PRIO_CODE(3, 3, 54),
        BC7_MODE_PRIO_CODE(4, 4, 20),
        BC7_MODE_PRIO_CODE(4, 3, 24),
        BC7_MODE_PRIO_CODE(4, 3, 12),
        BC7_MODE_PRIO_CODE(4, 2, 40),
        BC7_MODE_PRIO_CODE(3, 3, 40),
        BC7_MODE_PRIO_CODE(3, 3, 44),
        BC7_MODE_PRIO_CODE(4, 3, 63),
        BC7_MODE_PRIO_CODE(4, 3, 50),
        BC7_MODE_PRIO_CODE(4, 2, 50),
        BC7_MODE_PRIO_CODE(4, 3, 60),
        BC7_MODE_PRIO_CODE(4, 2, 39),
        BC7_MODE_PRIO_CODE(4, 3, 62),
        BC7_MODE_PRIO_CODE(4, 3, 49),
        BC7_MODE_PRIO_CODE(4, 3, 58),
        BC7_MODE_PRIO_CODE(4, 3, 47),
        BC7_MODE_PRIO_CODE(4, 3, 56),
        BC7_MODE_PRIO_CODE(4, 2, 26),
        BC7_MODE_PRIO_CODE(4, 2, 27),
        BC7_MODE_PRIO_CODE(3, 3, 37),
        BC7_MODE_PRIO_CODE(4, 3, 57),
        BC7_MODE_PRIO_CODE(4, 3, 48),
        BC7_MODE_PRIO_CODE(4, 3, 31),
        BC7_MODE_PRIO_CODE(4, 3, 51),
        BC7_MODE_PRIO_CODE(4, 3, 28),
        BC7_MODE_PRIO_CODE(4, 3, 53),
        BC7_MODE_PRIO_CODE(3, 3, 39),
        BC7_MODE_PRIO_CODE(4, 3, 40),
        BC7_MODE_PRIO_CODE(4, 3, 27),
        BC7_MODE_PRIO_CODE(4, 2, 2),
        BC7_MODE_PRIO_CODE(3, 3, 34),
        BC7_MODE_PRIO_CODE(4, 2, 38),
        BC7_MODE_PRIO_CODE(4, 3, 54),
        BC7_MODE_PRIO_CODE(3, 3, 38),
        BC7_MODE_PRIO_CODE(4, 3, 52),
        BC7_MODE_PRIO_CODE(4, 3, 30),
        BC7_MODE_PRIO_CODE(4, 3, 59),
        BC7_MODE_PRIO_CODE(1, 2, 45),
        BC7_MODE_PRIO_CODE(4, 3, 45),
        BC7_MODE_PRIO_CODE(4, 2, 42),
        BC7_MODE_PRIO_CODE(4, 3, 35),
        BC7_MODE_PRIO_CODE(4, 3, 41),
        BC7_MODE_PRIO_CODE(3, 2, 46),
        BC7_MODE_PRIO_CODE(4, 2, 46),
        BC7_MODE_PRIO_CODE(4, 3, 46),
        BC7_MODE_PRIO_CODE(2, 2, 45),
        BC7_MODE_PRIO_CODE(4, 3, 43),
        BC7_MODE_PRIO_CODE(4, 3, 37),
        BC7_MODE_PRIO_CODE(4, 3, 38),
        BC7_MODE_PRIO_CODE(4, 3, 36),
        BC7_MODE_PRIO_CODE(4, 3, 42),
        BC7_MODE_PRIO_CODE(4, 3, 34),
        BC7_MODE_PRIO_CODE(4, 3, 39),
        BC7_MODE_PRIO_CODE(4, 3, 55),
        BC7_MODE_PRIO_CODE(4, 3, 44),
        BC7_MODE_PRIO_CODE(3, 2, 45),
        BC7_MODE_PRIO_CODE(1, 4, 0),
        BC7_MODE_PRIO_CODE(1, 4, 1),
        BC7_MODE_PRIO_CODE(1, 5, 0),
        BC7_MODE_PRIO_CODE(4, 2, 45),
        BC7_MODE_PRIO_CODE(2, 4, 0),
        BC7_MODE_PRIO_CODE(2, 4, 1),
        BC7_MODE_PRIO_CODE(2, 5, 0),
        BC7_MODE_PRIO_CODE(3, 4, 0),
        BC7_MODE_PRIO_CODE(3, 4, 1),
        BC7_MODE_PRIO_CODE(3, 5, 0),
        BC7_MODE_PRIO_CODE(4, 4, 0),
        BC7_MODE_PRIO_CODE(4, 4, 1),
        BC7_MODE_PRIO_CODE(4, 5, 0),
    };

    const uint16_t *g_bc7PrioCodesRGB = g_bc7PrioCodesRGBData;
    const int g_bc7NumPrioCodesRGB = sizeof(g_bc7PrioCodesRGBData) / sizeof(g_bc7PrioCodesRGBData[0]);

    const uint16_t g_bc7PrioCodesRGBAData[] =
    {
        BC7_MODE_PRIO_CODE(1, 4, 1),
        BC7_MODE_PRIO_CODE(1, 6, 0),
        BC7_MODE_PRIO_CODE(1, 4, 31),
        BC7_MODE_PRIO_CODE(1, 4, 11),
        BC7_MODE_PRIO_CODE(1, 4, 0),
        BC7_MODE_PRIO_CODE(1, 7, 13),
        BC7_MODE_PRIO_CODE(1, 5, 0),
        BC7_MODE_PRIO_CODE(1, 7, 0),
        BC7_MODE_PRIO_CODE(2, 4, 1),
        BC7_MODE_PRIO_CODE(3, 4, 1),
        BC7_MODE_PRIO_CODE(2, 4, 0),
        BC7_MODE_PRIO_CODE(2, 6, 0),
        BC7_MODE_PRIO_CODE(1, 7, 6),
        BC7_MODE_PRIO_CODE(1, 4, 10),
        BC7_MODE_PRIO_CODE(1, 7, 15),
        BC7_MODE_PRIO_CODE(1, 7, 14),
        BC7_MODE_PRIO_CODE(1, 4, 30),
        BC7_MODE_PRIO_CODE(1, 7, 7),
        BC7_MODE_PRIO_CODE(3, 6, 0),
        BC7_MODE_PRIO_CODE(1, 7, 19),
        BC7_MODE_PRIO_CODE(3, 4, 0),
        BC7_MODE_PRIO_CODE(2, 7, 13),
        BC7_MODE_PRIO_CODE(1, 5, 30),
        BC7_MODE_PRIO_CODE(1, 7, 2),
        BC7_MODE_PRIO_CODE(1, 7, 1),
        BC7_MODE_PRIO_CODE(1, 7, 21),
        BC7_MODE_PRIO_CODE(4, 4, 1),
        BC7_MODE_PRIO_CODE(1, 4, 21),
        BC7_MODE_PRIO_CODE(2, 4, 31),
        BC7_MODE_PRIO_CODE(1, 7, 10),
        BC7_MODE_PRIO_CODE(1, 7, 3),
        BC7_MODE_PRIO_CODE(4, 6, 0),
        BC7_MODE_PRIO_CODE(3, 7, 13),
        BC7_MODE_PRIO_CODE(1, 7, 16),
        BC7_MODE_PRIO_CODE(1, 7, 8),
        BC7_MODE_PRIO_CODE(2, 5, 0),
        BC7_MODE_PRIO_CODE(2, 7, 0),
        BC7_MODE_PRIO_CODE(1, 7, 23),
        BC7_MODE_PRIO_CODE(1, 7, 9),
        BC7_MODE_PRIO_CODE(2, 4, 11),
        BC7_MODE_PRIO_CODE(3, 4, 31),
        BC7_MODE_PRIO_CODE(1, 7, 20),
        BC7_MODE_PRIO_CODE(1, 7, 22),
        BC7_MODE_PRIO_CODE(4, 4, 0),
        BC7_MODE_PRIO_CODE(1, 5, 10),
        BC7_MODE_PRIO_CODE(4, 7, 13),
        BC7_MODE_PRIO_CODE(3, 7, 0),
        BC7_MODE_PRIO_CODE(1, 7, 12),
        BC7_MODE_PRIO_CODE(1, 7, 29),
        BC7_MODE_PRIO_CODE(3, 4, 11),
        BC7_MODE_PRIO_CODE(1, 7, 11),
        BC7_MODE_PRIO_CODE(1, 7, 18),
        BC7_MODE_PRIO_CODE(1, 7, 4),
        BC7_MODE_PRIO_CODE(2, 7, 15),
        BC7_MODE_PRIO_CODE(2, 7, 14),
        BC7_MODE_PRIO_CODE(1, 7, 5),
        BC7_MODE_PRIO_CODE(1, 7, 25),
        BC7_MODE_PRIO_CODE(1, 7, 17),
        BC7_MODE_PRIO_CODE(1, 7, 24),
        BC7_MODE_PRIO_CODE(1, 7, 26),
        BC7_MODE_PRIO_CODE(3, 5, 0),
        BC7_MODE_PRIO_CODE(2, 7, 2),
        BC7_MODE_PRIO_CODE(1, 5, 20),
        BC7_MODE_PRIO_CODE(2, 7, 1),
        BC7_MODE_PRIO_CODE(2, 7, 29),
        BC7_MODE_PRIO_CODE(2, 4, 10),
        BC7_MODE_PRIO_CODE(4, 7, 0),
        BC7_MODE_PRIO_CODE(2, 7, 6),
        BC7_MODE_PRIO_CODE(2, 7, 7),
        BC7_MODE_PRIO_CODE(3, 7, 14),
        BC7_MODE_PRIO_CODE(3, 7, 15),
        BC7_MODE_PRIO_CODE(4, 4, 31),
        BC7_MODE_PRIO_CODE(2, 7, 21),
        BC7_MODE_PRIO_CODE(2, 4, 30),
        BC7_MODE_PRIO_CODE(2, 4, 21),
        BC7_MODE_PRIO_CODE(3, 7, 29),
        BC7_MODE_PRIO_CODE(2, 7, 19),
        BC7_MODE_PRIO_CODE(2, 7, 10),
        BC7_MODE_PRIO_CODE(3, 7, 1),
        BC7_MODE_PRIO_CODE(4, 7, 29),
        BC7_MODE_PRIO_CODE(3, 7, 7),
        BC7_MODE_PRIO_CODE(1, 4, 20),
        BC7_MODE_PRIO_CODE(3, 7, 2),
        BC7_MODE_PRIO_CODE(2, 7, 16),
        BC7_MODE_PRIO_CODE(2, 7, 3),
        BC7_MODE_PRIO_CODE(2, 5, 30),
        BC7_MODE_PRIO_CODE(2, 7, 23),
        BC7_MODE_PRIO_CODE(3, 7, 6),
        BC7_MODE_PRIO_CODE(2, 7, 12),
        BC7_MODE_PRIO_CODE(1, 7, 61),
        BC7_MODE_PRIO_CODE(4, 4, 11),
        BC7_MODE_PRIO_CODE(3, 4, 10),
        BC7_MODE_PRIO_CODE(3, 7, 10),
        BC7_MODE_PRIO_CODE(2, 7, 8),
        BC7_MODE_PRIO_CODE(2, 7, 22),
        BC7_MODE_PRIO_CODE(2, 7, 26),
        BC7_MODE_PRIO_CODE(3, 4, 30),
        BC7_MODE_PRIO_CODE(2, 7, 9),
        BC7_MODE_PRIO_CODE(3, 7, 19),
        BC7_MODE_PRIO_CODE(2, 7, 25),
        BC7_MODE_PRIO_CODE(3, 4, 21),
        BC7_MODE_PRIO_CODE(2, 7, 24),
        BC7_MODE_PRIO_CODE(1, 7, 60),
        BC7_MODE_PRIO_CODE(2, 7, 11),
        BC7_MODE_PRIO_CODE(2, 7, 18),
        BC7_MODE_PRIO_CODE(2, 7, 17),
        BC7_MODE_PRIO_CODE(2, 7, 4),
        BC7_MODE_PRIO_CODE(2, 7, 5),
        BC7_MODE_PRIO_CODE(3, 7, 3),
        BC7_MODE_PRIO_CODE(3, 7, 16),
        BC7_MODE_PRIO_CODE(3, 7, 26),
        BC7_MODE_PRIO_CODE(3, 7, 21),
        BC7_MODE_PRIO_CODE(1, 7, 62),
        BC7_MODE_PRIO_CODE(2, 7, 20),
        BC7_MODE_PRIO_CODE(3, 7, 23),
        BC7_MODE_PRIO_CODE(1, 7, 33),
        BC7_MODE_PRIO_CODE(2, 7, 33),
        BC7_MODE_PRIO_CODE(3, 7, 33),
        BC7_MODE_PRIO_CODE(4, 7, 33),
        BC7_MODE_PRIO_CODE(3, 7, 11),
        BC7_MODE_PRIO_CODE(3, 7, 12),
        BC7_MODE_PRIO_CODE(4, 7, 26),
        BC7_MODE_PRIO_CODE(3, 7, 25),
        BC7_MODE_PRIO_CODE(1, 7, 63),
        BC7_MODE_PRIO_CODE(2, 5, 10),
        BC7_MODE_PRIO_CODE(3, 7, 8),
        BC7_MODE_PRIO_CODE(4, 5, 0),
        BC7_MODE_PRIO_CODE(3, 7, 24),
        BC7_MODE_PRIO_CODE(3, 7, 22),
        BC7_MODE_PRIO_CODE(3, 7, 9),
        BC7_MODE_PRIO_CODE(1, 7, 32),
        BC7_MODE_PRIO_CODE(2, 7, 61),
        BC7_MODE_PRIO_CODE(3, 7, 4),
        BC7_MODE_PRIO_CODE(3, 5, 30),
        BC7_MODE_PRIO_CODE(3, 7, 20),
        BC7_MODE_PRIO_CODE(1, 7, 35),
        BC7_MODE_PRIO_CODE(4, 7, 14),
        BC7_MODE_PRIO_CODE(3, 7, 5),
        BC7_MODE_PRIO_CODE(3, 7, 18),
        BC7_MODE_PRIO_CODE(1, 7, 30),
        BC7_MODE_PRIO_CODE(1, 7, 43),
        BC7_MODE_PRIO_CODE(4, 4, 21),
        BC7_MODE_PRIO_CODE(4, 7, 15),
        BC7_MODE_PRIO_CODE(3, 7, 17),
        BC7_MODE_PRIO_CODE(2, 7, 32),
        BC7_MODE_PRIO_CODE(3, 7, 32),
        BC7_MODE_PRIO_CODE(2, 5, 20),
        BC7_MODE_PRIO_CODE(4, 7, 1),
        BC7_MODE_PRIO_CODE(4, 7, 2),
        BC7_MODE_PRIO_CODE(1, 7, 28),
        BC7_MODE_PRIO_CODE(1, 7, 54),
        BC7_MODE_PRIO_CODE(4, 7, 32),
        BC7_MODE_PRIO_CODE(1, 7, 27),
        BC7_MODE_PRIO_CODE(4, 4, 10),
        BC7_MODE_PRIO_CODE(3, 5, 10),
        BC7_MODE_PRIO_CODE(2, 7, 60),
        BC7_MODE_PRIO_CODE(2, 4, 20),
        BC7_MODE_PRIO_CODE(2, 7, 63),
        BC7_MODE_PRIO_CODE(4, 4, 30),
        BC7_MODE_PRIO_CODE(2, 7, 62),
        BC7_MODE_PRIO_CODE(1, 7, 41),
        BC7_MODE_PRIO_CODE(1, 7, 58),
        BC7_MODE_PRIO_CODE(3, 7, 60),
        BC7_MODE_PRIO_CODE(1, 7, 40),
        BC7_MODE_PRIO_CODE(1, 7, 55),
        BC7_MODE_PRIO_CODE(2, 7, 35),
        BC7_MODE_PRIO_CODE(4, 7, 8),
        BC7_MODE_PRIO_CODE(4, 7, 6),
        BC7_MODE_PRIO_CODE(1, 7, 53),
        BC7_MODE_PRIO_CODE(4, 7, 9),
        BC7_MODE_PRIO_CODE(3, 7, 61),
        BC7_MODE_PRIO_CODE(3, 4, 20),
        BC7_MODE_PRIO_CODE(4, 7, 22),
        BC7_MODE_PRIO_CODE(4, 7, 20),
        BC7_MODE_PRIO_CODE(3, 7, 62),
        BC7_MODE_PRIO_CODE(4, 7, 7),
        BC7_MODE_PRIO_CODE(1, 7, 42),
        BC7_MODE_PRIO_CODE(1, 7, 52),
        BC7_MODE_PRIO_CODE(4, 5, 30),
        BC7_MODE_PRIO_CODE(1, 7, 56),
        BC7_MODE_PRIO_CODE(1, 7, 31),
        BC7_MODE_PRIO_CODE(3, 5, 20),
        BC7_MODE_PRIO_CODE(1, 7, 48),
        BC7_MODE_PRIO_CODE(2, 7, 28),
        BC7_MODE_PRIO_CODE(3, 7, 28),
        BC7_MODE_PRIO_CODE(4, 7, 19),
        BC7_MODE_PRIO_CODE(3, 7, 35),
        BC7_MODE_PRIO_CODE(1, 7, 59),
        BC7_MODE_PRIO_CODE(2, 7, 30),
        BC7_MODE_PRIO_CODE(3, 7, 63),
        BC7_MODE_PRIO_CODE(4, 7, 21),
        BC7_MODE_PRIO_CODE(4, 7, 10),
        BC7_MODE_PRIO_CODE(4, 7, 3),
        BC7_MODE_PRIO_CODE(1, 7, 47),
        BC7_MODE_PRIO_CODE(1, 7, 37),
        BC7_MODE_PRIO_CODE(4, 5, 10),
        BC7_MODE_PRIO_CODE(4, 7, 23),
        BC7_MODE_PRIO_CODE(1, 7, 57),
        BC7_MODE_PRIO_CODE(4, 7, 17),
        BC7_MODE_PRIO_CODE(1, 7, 45),
        BC7_MODE_PRIO_CODE(4, 7, 24),
        BC7_MODE_PRIO_CODE(4, 7, 60),
        BC7_MODE_PRIO_CODE(1, 7, 50),
        BC7_MODE_PRIO_CODE(2, 7, 41),
        BC7_MODE_PRIO_CODE(4, 7, 25),
        BC7_MODE_PRIO_CODE(3, 7, 30),
        BC7_MODE_PRIO_CODE(2, 7, 59),
        BC7_MODE_PRIO_CODE(2, 7, 55),
        BC7_MODE_PRIO_CODE(4, 7, 18),
        BC7_MODE_PRIO_CODE(4, 7, 12),
        BC7_MODE_PRIO_CODE(4, 7, 5),
        BC7_MODE_PRIO_CODE(3, 7, 59),
        BC7_MODE_PRIO_CODE(1, 7, 51),
        BC7_MODE_PRIO_CODE(4, 7, 16),
        BC7_MODE_PRIO_CODE(4, 7, 11),
        BC7_MODE_PRIO_CODE(2, 7, 58),
        BC7_MODE_PRIO_CODE(3, 7, 41),
        BC7_MODE_PRIO_CODE(4, 4, 20),
        BC7_MODE_PRIO_CODE(4, 7, 4),
        BC7_MODE_PRIO_CODE(1, 7, 49),
        BC7_MODE_PRIO_CODE(2, 7, 27),
        BC7_MODE_PRIO_CODE(3, 7, 27),
        BC7_MODE_PRIO_CODE(4, 7, 62),
        BC7_MODE_PRIO_CODE(3, 7, 58),
        BC7_MODE_PRIO_CODE(4, 5, 20),
        BC7_MODE_PRIO_CODE(2, 7, 53),
        BC7_MODE_PRIO_CODE(3, 7, 53),
        BC7_MODE_PRIO_CODE(2, 7, 40),
        BC7_MODE_PRIO_CODE(3, 7, 40),
        BC7_MODE_PRIO_CODE(2, 7, 31),
        BC7_MODE_PRIO_CODE(3, 7, 31),
        BC7_MODE_PRIO_CODE(4, 7, 61),
        BC7_MODE_PRIO_CODE(1, 7, 36),
        BC7_MODE_PRIO_CODE(4, 7, 63),
        BC7_MODE_PRIO_CODE(1, 7, 46),
        BC7_MODE_PRIO_CODE(3, 7, 55),
        BC7_MODE_PRIO_CODE(2, 7, 52),
        BC7_MODE_PRIO_CODE(2, 7, 56),
        BC7_MODE_PRIO_CODE(2, 7, 42),
        BC7_MODE_PRIO_CODE(2, 7, 37),
        BC7_MODE_PRIO_CODE(2, 7, 57),
        BC7_MODE_PRIO_CODE(3, 7, 57),
        BC7_MODE_PRIO_CODE(2, 7, 45),
        BC7_MODE_PRIO_CODE(4, 7, 57),
        BC7_MODE_PRIO_CODE(2, 7, 49),
        BC7_MODE_PRIO_CODE(3, 7, 42),
        BC7_MODE_PRIO_CODE(2, 7, 43),
        BC7_MODE_PRIO_CODE(3, 7, 43),
        BC7_MODE_PRIO_CODE(4, 7, 28),
        BC7_MODE_PRIO_CODE(2, 7, 48),
        BC7_MODE_PRIO_CODE(3, 7, 52),
        BC7_MODE_PRIO_CODE(3, 7, 49),
        BC7_MODE_PRIO_CODE(4, 7, 59),
        BC7_MODE_PRIO_CODE(4, 7, 40),
        BC7_MODE_PRIO_CODE(4, 7, 27),
        BC7_MODE_PRIO_CODE(3, 7, 45),
        BC7_MODE_PRIO_CODE(4, 7, 55),
        BC7_MODE_PRIO_CODE(3, 7, 56),
        BC7_MODE_PRIO_CODE(4, 7, 42),
        BC7_MODE_PRIO_CODE(2, 7, 54),
        BC7_MODE_PRIO_CODE(3, 7, 54),
        BC7_MODE_PRIO_CODE(4, 7, 54),
        BC7_MODE_PRIO_CODE(2, 7, 47),
        BC7_MODE_PRIO_CODE(3, 7, 47),
        BC7_MODE_PRIO_CODE(4, 7, 43),
        BC7_MODE_PRIO_CODE(4, 7, 31),
        BC7_MODE_PRIO_CODE(3, 7, 37),
        BC7_MODE_PRIO_CODE(3, 7, 48),
        BC7_MODE_PRIO_CODE(4, 7, 48),
        BC7_MODE_PRIO_CODE(4, 7, 45),
        BC7_MODE_PRIO_CODE(4, 7, 47),
        BC7_MODE_PRIO_CODE(2, 7, 36),
        BC7_MODE_PRIO_CODE(1, 7, 44),
        BC7_MODE_PRIO_CODE(4, 7, 35),
        BC7_MODE_PRIO_CODE(4, 7, 58),
        BC7_MODE_PRIO_CODE(3, 7, 36),
        BC7_MODE_PRIO_CODE(2, 7, 50),
        BC7_MODE_PRIO_CODE(3, 7, 50),
        BC7_MODE_PRIO_CODE(4, 7, 50),
        BC7_MODE_PRIO_CODE(4, 7, 52),
        BC7_MODE_PRIO_CODE(1, 7, 39),
        BC7_MODE_PRIO_CODE(1, 7, 34),
        BC7_MODE_PRIO_CODE(1, 7, 38),
        BC7_MODE_PRIO_CODE(2, 7, 38),
        BC7_MODE_PRIO_CODE(3, 7, 38),
        BC7_MODE_PRIO_CODE(4, 7, 30),
        BC7_MODE_PRIO_CODE(2, 7, 51),
        BC7_MODE_PRIO_CODE(4, 7, 41),
        BC7_MODE_PRIO_CODE(4, 7, 53),
        BC7_MODE_PRIO_CODE(2, 7, 46),
        BC7_MODE_PRIO_CODE(3, 7, 46),
        BC7_MODE_PRIO_CODE(4, 7, 49),
        BC7_MODE_PRIO_CODE(4, 7, 56),
        BC7_MODE_PRIO_CODE(4, 7, 37),
        BC7_MODE_PRIO_CODE(2, 7, 44),
        BC7_MODE_PRIO_CODE(3, 7, 44),
        BC7_MODE_PRIO_CODE(4, 7, 36),
        BC7_MODE_PRIO_CODE(2, 7, 39),
        BC7_MODE_PRIO_CODE(2, 7, 34),
        BC7_MODE_PRIO_CODE(4, 7, 38),
        BC7_MODE_PRIO_CODE(3, 7, 51),
        BC7_MODE_PRIO_CODE(4, 7, 51),
        BC7_MODE_PRIO_CODE(4, 7, 46),
        BC7_MODE_PRIO_CODE(4, 7, 44),
        BC7_MODE_PRIO_CODE(3, 7, 39),
        BC7_MODE_PRIO_CODE(3, 7, 34),
        BC7_MODE_PRIO_CODE(4, 7, 39),
        BC7_MODE_PRIO_CODE(4, 7, 34),
    };

    const uint16_t *g_bc7PrioCodesRGBA = g_bc7PrioCodesRGBAData;
    const int g_bc7NumPrioCodesRGBA = sizeof(g_bc7PrioCodesRGBAData) / sizeof(g_bc7PrioCodesRGBA[0]);

    int UnpackMode(uint16_t packed)
    {
        return static_cast<int>((packed >> BC7_MODE_OFFSET_BITS) & ((1 << BC7_MODE_BITS) - 1));
    }

    int UnpackSeedPointCount(uint16_t packed)
    {
        return static_cast<int>((packed >> BC7_SEED_POINT_COUNT_OFFSET_BITS) & ((1 << BC7_SEED_POINT_COUNT_BITS) - 1)) + 1;
    }

    int UnpackPartition(uint16_t packed)
    {
        return static_cast<int>((packed >> BC7_PARTITION_OFFSET_BITS) & ((1 << BC7_PARTITION_BITS) - 1));
    }

    int UnpackRotation(uint16_t packed)
    {
        return static_cast<int>((packed >> BC7_ROTATION_OFFSET_BITS) & ((1 << BC7_ROTATION_BITS) - 1));
    }

    int UnpackIndexSelector(uint16_t packed)
    {
        return static_cast<int>((packed >> BC7_INDEX_MODE_OFFSET_BITS) & ((1 << BC7_INDEX_MODE_BITS) - 1));
    }
}}}

#endif
