// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by aliasgen. DO NOT EDIT.

// Package documentai aliases all exported identifiers in package
// "cloud.google.com/go/documentai/apiv1beta3/documentaipb".
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb.
// Please read https://github.com/googleapis/google-cloud-go/blob/main/migration.md
// for more details.
package documentai

import (
	src "cloud.google.com/go/documentai/apiv1beta3/documentaipb"
	grpc "google.golang.org/grpc"
)

// Deprecated: Please use consts in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
const (
	BatchProcessMetadata_CANCELLED                                 = src.BatchProcessMetadata_CANCELLED
	BatchProcessMetadata_CANCELLING                                = src.BatchProcessMetadata_CANCELLING
	BatchProcessMetadata_FAILED                                    = src.BatchProcessMetadata_FAILED
	BatchProcessMetadata_RUNNING                                   = src.BatchProcessMetadata_RUNNING
	BatchProcessMetadata_STATE_UNSPECIFIED                         = src.BatchProcessMetadata_STATE_UNSPECIFIED
	BatchProcessMetadata_SUCCEEDED                                 = src.BatchProcessMetadata_SUCCEEDED
	BatchProcessMetadata_WAITING                                   = src.BatchProcessMetadata_WAITING
	CommonOperationMetadata_CANCELLED                              = src.CommonOperationMetadata_CANCELLED
	CommonOperationMetadata_CANCELLING                             = src.CommonOperationMetadata_CANCELLING
	CommonOperationMetadata_FAILED                                 = src.CommonOperationMetadata_FAILED
	CommonOperationMetadata_RUNNING                                = src.CommonOperationMetadata_RUNNING
	CommonOperationMetadata_STATE_UNSPECIFIED                      = src.CommonOperationMetadata_STATE_UNSPECIFIED
	CommonOperationMetadata_SUCCEEDED                              = src.CommonOperationMetadata_SUCCEEDED
	DocumentSchema_EntityType_Property_OCCURRENCE_TYPE_UNSPECIFIED = src.DocumentSchema_EntityType_Property_OCCURRENCE_TYPE_UNSPECIFIED
	DocumentSchema_EntityType_Property_OPTIONAL_MULTIPLE           = src.DocumentSchema_EntityType_Property_OPTIONAL_MULTIPLE
	DocumentSchema_EntityType_Property_OPTIONAL_ONCE               = src.DocumentSchema_EntityType_Property_OPTIONAL_ONCE
	DocumentSchema_EntityType_Property_REQUIRED_MULTIPLE           = src.DocumentSchema_EntityType_Property_REQUIRED_MULTIPLE
	DocumentSchema_EntityType_Property_REQUIRED_ONCE               = src.DocumentSchema_EntityType_Property_REQUIRED_ONCE
	Document_PageAnchor_PageRef_BLOCK                              = src.Document_PageAnchor_PageRef_BLOCK
	Document_PageAnchor_PageRef_FORM_FIELD                         = src.Document_PageAnchor_PageRef_FORM_FIELD
	Document_PageAnchor_PageRef_LAYOUT_TYPE_UNSPECIFIED            = src.Document_PageAnchor_PageRef_LAYOUT_TYPE_UNSPECIFIED
	Document_PageAnchor_PageRef_LINE                               = src.Document_PageAnchor_PageRef_LINE
	Document_PageAnchor_PageRef_PARAGRAPH                          = src.Document_PageAnchor_PageRef_PARAGRAPH
	Document_PageAnchor_PageRef_TABLE                              = src.Document_PageAnchor_PageRef_TABLE
	Document_PageAnchor_PageRef_TOKEN                              = src.Document_PageAnchor_PageRef_TOKEN
	Document_PageAnchor_PageRef_VISUAL_ELEMENT                     = src.Document_PageAnchor_PageRef_VISUAL_ELEMENT
	Document_Page_Layout_ORIENTATION_UNSPECIFIED                   = src.Document_Page_Layout_ORIENTATION_UNSPECIFIED
	Document_Page_Layout_PAGE_DOWN                                 = src.Document_Page_Layout_PAGE_DOWN
	Document_Page_Layout_PAGE_LEFT                                 = src.Document_Page_Layout_PAGE_LEFT
	Document_Page_Layout_PAGE_RIGHT                                = src.Document_Page_Layout_PAGE_RIGHT
	Document_Page_Layout_PAGE_UP                                   = src.Document_Page_Layout_PAGE_UP
	Document_Page_Token_DetectedBreak_HYPHEN                       = src.Document_Page_Token_DetectedBreak_HYPHEN
	Document_Page_Token_DetectedBreak_SPACE                        = src.Document_Page_Token_DetectedBreak_SPACE
	Document_Page_Token_DetectedBreak_TYPE_UNSPECIFIED             = src.Document_Page_Token_DetectedBreak_TYPE_UNSPECIFIED
	Document_Page_Token_DetectedBreak_WIDE_SPACE                   = src.Document_Page_Token_DetectedBreak_WIDE_SPACE
	Document_Provenance_ADD                                        = src.Document_Provenance_ADD
	Document_Provenance_EVAL_APPROVED                              = src.Document_Provenance_EVAL_APPROVED
	Document_Provenance_EVAL_REQUESTED                             = src.Document_Provenance_EVAL_REQUESTED
	Document_Provenance_EVAL_SKIPPED                               = src.Document_Provenance_EVAL_SKIPPED
	Document_Provenance_OPERATION_TYPE_UNSPECIFIED                 = src.Document_Provenance_OPERATION_TYPE_UNSPECIFIED
	Document_Provenance_REMOVE                                     = src.Document_Provenance_REMOVE
	Document_Provenance_REPLACE                                    = src.Document_Provenance_REPLACE
	HumanReviewStatus_ERROR                                        = src.HumanReviewStatus_ERROR
	HumanReviewStatus_IN_PROGRESS                                  = src.HumanReviewStatus_IN_PROGRESS
	HumanReviewStatus_SKIPPED                                      = src.HumanReviewStatus_SKIPPED
	HumanReviewStatus_STATE_UNSPECIFIED                            = src.HumanReviewStatus_STATE_UNSPECIFIED
	HumanReviewStatus_VALIDATION_PASSED                            = src.HumanReviewStatus_VALIDATION_PASSED
	ProcessorVersion_CREATING                                      = src.ProcessorVersion_CREATING
	ProcessorVersion_DELETING                                      = src.ProcessorVersion_DELETING
	ProcessorVersion_DEPLOYED                                      = src.ProcessorVersion_DEPLOYED
	ProcessorVersion_DEPLOYING                                     = src.ProcessorVersion_DEPLOYING
	ProcessorVersion_FAILED                                        = src.ProcessorVersion_FAILED
	ProcessorVersion_STATE_UNSPECIFIED                             = src.ProcessorVersion_STATE_UNSPECIFIED
	ProcessorVersion_UNDEPLOYED                                    = src.ProcessorVersion_UNDEPLOYED
	ProcessorVersion_UNDEPLOYING                                   = src.ProcessorVersion_UNDEPLOYING
	Processor_CREATING                                             = src.Processor_CREATING
	Processor_DELETING                                             = src.Processor_DELETING
	Processor_DISABLED                                             = src.Processor_DISABLED
	Processor_DISABLING                                            = src.Processor_DISABLING
	Processor_ENABLED                                              = src.Processor_ENABLED
	Processor_ENABLING                                             = src.Processor_ENABLING
	Processor_FAILED                                               = src.Processor_FAILED
	Processor_STATE_UNSPECIFIED                                    = src.Processor_STATE_UNSPECIFIED
	ReviewDocumentOperationMetadata_CANCELLED                      = src.ReviewDocumentOperationMetadata_CANCELLED
	ReviewDocumentOperationMetadata_CANCELLING                     = src.ReviewDocumentOperationMetadata_CANCELLING
	ReviewDocumentOperationMetadata_FAILED                         = src.ReviewDocumentOperationMetadata_FAILED
	ReviewDocumentOperationMetadata_RUNNING                        = src.ReviewDocumentOperationMetadata_RUNNING
	ReviewDocumentOperationMetadata_STATE_UNSPECIFIED              = src.ReviewDocumentOperationMetadata_STATE_UNSPECIFIED
	ReviewDocumentOperationMetadata_SUCCEEDED                      = src.ReviewDocumentOperationMetadata_SUCCEEDED
	ReviewDocumentRequest_DEFAULT                                  = src.ReviewDocumentRequest_DEFAULT
	ReviewDocumentRequest_URGENT                                   = src.ReviewDocumentRequest_URGENT
	ReviewDocumentResponse_REJECTED                                = src.ReviewDocumentResponse_REJECTED
	ReviewDocumentResponse_STATE_UNSPECIFIED                       = src.ReviewDocumentResponse_STATE_UNSPECIFIED
	ReviewDocumentResponse_SUCCEEDED                               = src.ReviewDocumentResponse_SUCCEEDED
)

// Deprecated: Please use vars in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
var (
	BatchProcessMetadata_State_name                                       = src.BatchProcessMetadata_State_name
	BatchProcessMetadata_State_value                                      = src.BatchProcessMetadata_State_value
	CommonOperationMetadata_State_name                                    = src.CommonOperationMetadata_State_name
	CommonOperationMetadata_State_value                                   = src.CommonOperationMetadata_State_value
	DocumentSchema_EntityType_Property_OccurrenceType_name                = src.DocumentSchema_EntityType_Property_OccurrenceType_name
	DocumentSchema_EntityType_Property_OccurrenceType_value               = src.DocumentSchema_EntityType_Property_OccurrenceType_value
	Document_PageAnchor_PageRef_LayoutType_name                           = src.Document_PageAnchor_PageRef_LayoutType_name
	Document_PageAnchor_PageRef_LayoutType_value                          = src.Document_PageAnchor_PageRef_LayoutType_value
	Document_Page_Layout_Orientation_name                                 = src.Document_Page_Layout_Orientation_name
	Document_Page_Layout_Orientation_value                                = src.Document_Page_Layout_Orientation_value
	Document_Page_Token_DetectedBreak_Type_name                           = src.Document_Page_Token_DetectedBreak_Type_name
	Document_Page_Token_DetectedBreak_Type_value                          = src.Document_Page_Token_DetectedBreak_Type_value
	Document_Provenance_OperationType_name                                = src.Document_Provenance_OperationType_name
	Document_Provenance_OperationType_value                               = src.Document_Provenance_OperationType_value
	File_google_cloud_documentai_v1beta3_barcode_proto                    = src.File_google_cloud_documentai_v1beta3_barcode_proto
	File_google_cloud_documentai_v1beta3_document_io_proto                = src.File_google_cloud_documentai_v1beta3_document_io_proto
	File_google_cloud_documentai_v1beta3_document_processor_service_proto = src.File_google_cloud_documentai_v1beta3_document_processor_service_proto
	File_google_cloud_documentai_v1beta3_document_proto                   = src.File_google_cloud_documentai_v1beta3_document_proto
	File_google_cloud_documentai_v1beta3_document_schema_proto            = src.File_google_cloud_documentai_v1beta3_document_schema_proto
	File_google_cloud_documentai_v1beta3_geometry_proto                   = src.File_google_cloud_documentai_v1beta3_geometry_proto
	File_google_cloud_documentai_v1beta3_operation_metadata_proto         = src.File_google_cloud_documentai_v1beta3_operation_metadata_proto
	File_google_cloud_documentai_v1beta3_processor_proto                  = src.File_google_cloud_documentai_v1beta3_processor_proto
	File_google_cloud_documentai_v1beta3_processor_type_proto             = src.File_google_cloud_documentai_v1beta3_processor_type_proto
	HumanReviewStatus_State_name                                          = src.HumanReviewStatus_State_name
	HumanReviewStatus_State_value                                         = src.HumanReviewStatus_State_value
	ProcessorVersion_State_name                                           = src.ProcessorVersion_State_name
	ProcessorVersion_State_value                                          = src.ProcessorVersion_State_value
	Processor_State_name                                                  = src.Processor_State_name
	Processor_State_value                                                 = src.Processor_State_value
	ReviewDocumentOperationMetadata_State_name                            = src.ReviewDocumentOperationMetadata_State_name
	ReviewDocumentOperationMetadata_State_value                           = src.ReviewDocumentOperationMetadata_State_value
	ReviewDocumentRequest_Priority_name                                   = src.ReviewDocumentRequest_Priority_name
	ReviewDocumentRequest_Priority_value                                  = src.ReviewDocumentRequest_Priority_value
	ReviewDocumentResponse_State_name                                     = src.ReviewDocumentResponse_State_name
	ReviewDocumentResponse_State_value                                    = src.ReviewDocumentResponse_State_value
)

// Encodes the detailed information of a barcode.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Barcode = src.Barcode

// The common config to specify a set of documents used as input.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type BatchDocumentsInputConfig = src.BatchDocumentsInputConfig
type BatchDocumentsInputConfig_GcsDocuments = src.BatchDocumentsInputConfig_GcsDocuments
type BatchDocumentsInputConfig_GcsPrefix = src.BatchDocumentsInputConfig_GcsPrefix

// The long running operation metadata for batch process method.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type BatchProcessMetadata = src.BatchProcessMetadata

// The status of a each individual document in the batch process.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type BatchProcessMetadata_IndividualProcessStatus = src.BatchProcessMetadata_IndividualProcessStatus

// Possible states of the batch processing operation.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type BatchProcessMetadata_State = src.BatchProcessMetadata_State

// Request message for batch process document method.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type BatchProcessRequest = src.BatchProcessRequest

// The message for input config in batch process. Deprecated: Do not use.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type BatchProcessRequest_BatchInputConfig = src.BatchProcessRequest_BatchInputConfig

// The message for output config in batch process. Deprecated: Do not use.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type BatchProcessRequest_BatchOutputConfig = src.BatchProcessRequest_BatchOutputConfig

// Response message for batch process document method.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type BatchProcessResponse = src.BatchProcessResponse

// A bounding polygon for the detected image annotation.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type BoundingPoly = src.BoundingPoly

// The common metadata for long running operations.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type CommonOperationMetadata = src.CommonOperationMetadata

// State of the longrunning operation.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type CommonOperationMetadata_State = src.CommonOperationMetadata_State

// Request message for create a processor. Notice this request is sent to a
// regionalized backend service, and if the processor type is not available on
// that region, the creation will fail.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type CreateProcessorRequest = src.CreateProcessorRequest

// The long running operation metadata for delete processor method.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type DeleteProcessorMetadata = src.DeleteProcessorMetadata

// Request message for the delete processor method.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type DeleteProcessorRequest = src.DeleteProcessorRequest

// The long running operation metadata for delete processor version method.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type DeleteProcessorVersionMetadata = src.DeleteProcessorVersionMetadata

// Request message for the delete processor version method.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type DeleteProcessorVersionRequest = src.DeleteProcessorVersionRequest

// The long running operation metadata for deploy processor version method.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type DeployProcessorVersionMetadata = src.DeployProcessorVersionMetadata

// Request message for the deploy processor version method.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type DeployProcessorVersionRequest = src.DeployProcessorVersionRequest

// Response message for the deploy processor version method.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type DeployProcessorVersionResponse = src.DeployProcessorVersionResponse

// The long running operation metadata for disable processor method.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type DisableProcessorMetadata = src.DisableProcessorMetadata

// Request message for the disable processor method.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type DisableProcessorRequest = src.DisableProcessorRequest

// Response message for the disable processor method. Intentionally empty
// proto for adding fields in future.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type DisableProcessorResponse = src.DisableProcessorResponse

// Document represents the canonical document resource in Document AI. It is
// an interchange format that provides insights into documents and allows for
// collaboration between users and Document AI to iterate and optimize for
// quality.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document = src.Document

// Config that controls the output of documents. All documents will be written
// as a JSON file.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type DocumentOutputConfig = src.DocumentOutputConfig

// The configuration used when outputting documents.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type DocumentOutputConfig_GcsOutputConfig = src.DocumentOutputConfig_GcsOutputConfig
type DocumentOutputConfig_GcsOutputConfig_ = src.DocumentOutputConfig_GcsOutputConfig_

// DocumentProcessorServiceClient is the client API for
// DocumentProcessorService service. For semantics around ctx use and
// closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type DocumentProcessorServiceClient = src.DocumentProcessorServiceClient

// DocumentProcessorServiceServer is the server API for
// DocumentProcessorService service.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type DocumentProcessorServiceServer = src.DocumentProcessorServiceServer

// The schema defines the output of the processed document by a processor.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type DocumentSchema = src.DocumentSchema

// EntityType is the wrapper of a label of the corresponding model with
// detailed attributes and limitations for entity-based processors. Multiple
// types can also compose a dependency tree to represent nested types.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type DocumentSchema_EntityType = src.DocumentSchema_EntityType

// Defines the a list of enum values.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type DocumentSchema_EntityType_EnumValues = src.DocumentSchema_EntityType_EnumValues
type DocumentSchema_EntityType_EnumValues_ = src.DocumentSchema_EntityType_EnumValues_

// Defines properties that can be part of the entity type.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type DocumentSchema_EntityType_Property = src.DocumentSchema_EntityType_Property

// Types of occurrences of the entity type in the document. Note: this
// represents the number of instances of an entity types, not number of
// mentions of a given entity instance.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type DocumentSchema_EntityType_Property_OccurrenceType = src.DocumentSchema_EntityType_Property_OccurrenceType

// Metadata for global schema behavior.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type DocumentSchema_Metadata = src.DocumentSchema_Metadata
type Document_Content = src.Document_Content

// An entity that could be a phrase in the text or a property that belongs to
// the document. It is a known entity type, such as a person, an organization,
// or location.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Entity = src.Document_Entity

// Relationship between
// [Entities][google.cloud.documentai.v1beta3.Document.Entity].
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_EntityRelation = src.Document_EntityRelation

// Parsed and normalized entity value.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Entity_NormalizedValue = src.Document_Entity_NormalizedValue
type Document_Entity_NormalizedValue_AddressValue = src.Document_Entity_NormalizedValue_AddressValue
type Document_Entity_NormalizedValue_BooleanValue = src.Document_Entity_NormalizedValue_BooleanValue
type Document_Entity_NormalizedValue_DateValue = src.Document_Entity_NormalizedValue_DateValue
type Document_Entity_NormalizedValue_DatetimeValue = src.Document_Entity_NormalizedValue_DatetimeValue
type Document_Entity_NormalizedValue_FloatValue = src.Document_Entity_NormalizedValue_FloatValue
type Document_Entity_NormalizedValue_IntegerValue = src.Document_Entity_NormalizedValue_IntegerValue
type Document_Entity_NormalizedValue_MoneyValue = src.Document_Entity_NormalizedValue_MoneyValue

// A page in a [Document][google.cloud.documentai.v1beta3.Document].
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Page = src.Document_Page

// Referencing the visual context of the entity in the
// [Document.pages][google.cloud.documentai.v1beta3.Document.pages]. Page
// anchors can be cross-page, consist of multiple bounding polygons and
// optionally reference specific layout element types.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_PageAnchor = src.Document_PageAnchor

// Represents a weak reference to a page element within a document.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_PageAnchor_PageRef = src.Document_PageAnchor_PageRef

// The type of layout that is being referenced.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_PageAnchor_PageRef_LayoutType = src.Document_PageAnchor_PageRef_LayoutType

// A block has a set of lines (collected into paragraphs) that have a common
// line-spacing and orientation.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Page_Block = src.Document_Page_Block

// A detected barcode.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Page_DetectedBarcode = src.Document_Page_DetectedBarcode

// Detected language for a structural component.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Page_DetectedLanguage = src.Document_Page_DetectedLanguage

// Dimension for the page.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Page_Dimension = src.Document_Page_Dimension

// A form field detected on the page.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Page_FormField = src.Document_Page_FormField

// Rendered image contents for this page.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Page_Image = src.Document_Page_Image

// Visual element describing a layout unit on a page.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Page_Layout = src.Document_Page_Layout

// Detected human reading orientation.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Page_Layout_Orientation = src.Document_Page_Layout_Orientation

// A collection of tokens that a human would perceive as a line. Does not
// cross column boundaries, can be horizontal, vertical, etc.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Page_Line = src.Document_Page_Line

// Representation for transformation matrix, intended to be compatible and
// used with OpenCV format for image manipulation.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Page_Matrix = src.Document_Page_Matrix

// A collection of lines that a human would perceive as a paragraph.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Page_Paragraph = src.Document_Page_Paragraph

// A detected symbol.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Page_Symbol = src.Document_Page_Symbol

// A table representation similar to HTML table structure.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Page_Table = src.Document_Page_Table

// A cell representation inside the table.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Page_Table_TableCell = src.Document_Page_Table_TableCell

// A row of table cells.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Page_Table_TableRow = src.Document_Page_Table_TableRow

// A detected token.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Page_Token = src.Document_Page_Token

// Detected break at the end of a
// [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Page_Token_DetectedBreak = src.Document_Page_Token_DetectedBreak

// Enum to denote the type of break found.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Page_Token_DetectedBreak_Type = src.Document_Page_Token_DetectedBreak_Type

// Detected non-text visual elements e.g. checkbox, signature etc. on the
// page.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Page_VisualElement = src.Document_Page_VisualElement

// Structure to identify provenance relationships between annotations in
// different revisions.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Provenance = src.Document_Provenance

// If a processor or agent does an explicit operation on existing elements.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Provenance_OperationType = src.Document_Provenance_OperationType

// The parent element the current element is based on. Used for
// referencing/aligning, removal and replacement operations.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Provenance_Parent = src.Document_Provenance_Parent

// Contains past or forward revisions of this document.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Revision = src.Document_Revision
type Document_Revision_Agent = src.Document_Revision_Agent

// Human Review information of the document.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Revision_HumanReview = src.Document_Revision_HumanReview
type Document_Revision_Processor = src.Document_Revision_Processor

// For a large document, sharding may be performed to produce several document
// shards. Each document shard contains this field to detail which shard it is.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_ShardInfo = src.Document_ShardInfo

// Annotation for common text style attributes. This adheres to CSS
// conventions as much as possible.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Style = src.Document_Style

// Font size with unit.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_Style_FontSize = src.Document_Style_FontSize

// Text reference indexing into the
// [Document.text][google.cloud.documentai.v1beta3.Document.text].
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_TextAnchor = src.Document_TextAnchor

// A text segment in the
// [Document.text][google.cloud.documentai.v1beta3.Document.text]. The indices
// may be out of bounds which indicate that the text extends into another
// document shard for large sharded documents. See
// [ShardInfo.text_offset][google.cloud.documentai.v1beta3.Document.ShardInfo.text_offset]
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_TextAnchor_TextSegment = src.Document_TextAnchor_TextSegment

// This message is used for text changes aka. OCR corrections.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Document_TextChange = src.Document_TextChange
type Document_Uri = src.Document_Uri

// The long running operation metadata for enable processor method.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type EnableProcessorMetadata = src.EnableProcessorMetadata

// Request message for the enable processor method.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type EnableProcessorRequest = src.EnableProcessorRequest

// Response message for the enable processor method. Intentionally empty proto
// for adding fields in future.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type EnableProcessorResponse = src.EnableProcessorResponse

// Request message for fetch processor types.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type FetchProcessorTypesRequest = src.FetchProcessorTypesRequest

// Response message for fetch processor types.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type FetchProcessorTypesResponse = src.FetchProcessorTypesResponse

// Specifies a document stored on Cloud Storage.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type GcsDocument = src.GcsDocument

// Specifies a set of documents on Cloud Storage.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type GcsDocuments = src.GcsDocuments

// Specifies all documents on Cloud Storage with a common prefix.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type GcsPrefix = src.GcsPrefix

// Request message for get processor.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type GetProcessorRequest = src.GetProcessorRequest

// Request message for get processor version.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type GetProcessorVersionRequest = src.GetProcessorVersionRequest

// The status of human review on a processed document.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type HumanReviewStatus = src.HumanReviewStatus

// The final state of human review on a processed document.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type HumanReviewStatus_State = src.HumanReviewStatus_State

// Request message for list processor types.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type ListProcessorTypesRequest = src.ListProcessorTypesRequest

// Response message for list processor types.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type ListProcessorTypesResponse = src.ListProcessorTypesResponse

// Request message for list all processor versions belongs to a processor.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type ListProcessorVersionsRequest = src.ListProcessorVersionsRequest

// Response message for list processors.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type ListProcessorVersionsResponse = src.ListProcessorVersionsResponse

// Request message for list all processors belongs to a project.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type ListProcessorsRequest = src.ListProcessorsRequest

// Response message for list processors.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type ListProcessorsResponse = src.ListProcessorsResponse

// A vertex represents a 2D point in the image. NOTE: the normalized vertex
// coordinates are relative to the original image and range from 0 to 1.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type NormalizedVertex = src.NormalizedVertex

// Request message for the process document method.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type ProcessRequest = src.ProcessRequest
type ProcessRequest_InlineDocument = src.ProcessRequest_InlineDocument
type ProcessRequest_RawDocument = src.ProcessRequest_RawDocument

// Response message for the process document method.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type ProcessResponse = src.ProcessResponse

// The first-class citizen for Document AI. Each processor defines how to
// extract structural information from a document.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Processor = src.Processor

// A processor type is responsible for performing a certain document
// understanding task on a certain type of document.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type ProcessorType = src.ProcessorType

// The location information about where the processor is available.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type ProcessorType_LocationInfo = src.ProcessorType_LocationInfo

// A processor version is an implementation of a processor. Each processor can
// have multiple versions, pre-trained by Google internally or up-trained by
// the customer. At a time, a processor can only have one default version
// version. So the processor's behavior (when processing documents) is defined
// by a default version
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type ProcessorVersion = src.ProcessorVersion

// Information about the upcoming deprecation of this processor version.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type ProcessorVersion_DeprecationInfo = src.ProcessorVersion_DeprecationInfo

// The possible states of the processor version.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type ProcessorVersion_State = src.ProcessorVersion_State

// The possible states of the processor.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Processor_State = src.Processor_State

// Payload message of raw document content (bytes).
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type RawDocument = src.RawDocument

// The long running operation metadata for review document method.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type ReviewDocumentOperationMetadata = src.ReviewDocumentOperationMetadata

// State of the longrunning operation.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type ReviewDocumentOperationMetadata_State = src.ReviewDocumentOperationMetadata_State

// Request message for review document method.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type ReviewDocumentRequest = src.ReviewDocumentRequest
type ReviewDocumentRequest_InlineDocument = src.ReviewDocumentRequest_InlineDocument

// The priority level of the human review task.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type ReviewDocumentRequest_Priority = src.ReviewDocumentRequest_Priority

// Response message for review document method.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type ReviewDocumentResponse = src.ReviewDocumentResponse

// Possible states of the review operation.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type ReviewDocumentResponse_State = src.ReviewDocumentResponse_State

// The long running operation metadata for set default processor version
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type SetDefaultProcessorVersionMetadata = src.SetDefaultProcessorVersionMetadata

// Request message for the set default processor version method.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type SetDefaultProcessorVersionRequest = src.SetDefaultProcessorVersionRequest

// Response message for set default processor version method.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type SetDefaultProcessorVersionResponse = src.SetDefaultProcessorVersionResponse

// The long running operation metadata for the undeploy processor version
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type UndeployProcessorVersionMetadata = src.UndeployProcessorVersionMetadata

// Request message for the undeploy processor version method.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type UndeployProcessorVersionRequest = src.UndeployProcessorVersionRequest

// Response message for the undeploy processor version method.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type UndeployProcessorVersionResponse = src.UndeployProcessorVersionResponse

// UnimplementedDocumentProcessorServiceServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type UnimplementedDocumentProcessorServiceServer = src.UnimplementedDocumentProcessorServiceServer

// A vertex represents a 2D point in the image. NOTE: the vertex coordinates
// are in the same scale as the original image.
//
// Deprecated: Please use types in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
type Vertex = src.Vertex

// Deprecated: Please use funcs in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
func NewDocumentProcessorServiceClient(cc grpc.ClientConnInterface) DocumentProcessorServiceClient {
	return src.NewDocumentProcessorServiceClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/documentai/apiv1beta3/documentaipb
func RegisterDocumentProcessorServiceServer(s *grpc.Server, srv DocumentProcessorServiceServer) {
	src.RegisterDocumentProcessorServiceServer(s, srv)
}
