// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticbeanstalk

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opAbortEnvironmentUpdate = "AbortEnvironmentUpdate"

// AbortEnvironmentUpdateRequest generates a "aws/request.Request" representing the
// client's request for the AbortEnvironmentUpdate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AbortEnvironmentUpdate for more information on using the AbortEnvironmentUpdate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AbortEnvironmentUpdateRequest method.
//    req, resp := client.AbortEnvironmentUpdateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/AbortEnvironmentUpdate
func (c *ElasticBeanstalk) AbortEnvironmentUpdateRequest(input *AbortEnvironmentUpdateInput) (req *request.Request, output *AbortEnvironmentUpdateOutput) {
	op := &request.Operation{
		Name:       opAbortEnvironmentUpdate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AbortEnvironmentUpdateInput{}
	}

	output = &AbortEnvironmentUpdateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AbortEnvironmentUpdate API operation for AWS Elastic Beanstalk.
//
// Cancels in-progress environment configuration update or application version
// deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation AbortEnvironmentUpdate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInsufficientPrivilegesException "InsufficientPrivilegesException"
//   The specified account does not have sufficient privileges for one or more
//   AWS services.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/AbortEnvironmentUpdate
func (c *ElasticBeanstalk) AbortEnvironmentUpdate(input *AbortEnvironmentUpdateInput) (*AbortEnvironmentUpdateOutput, error) {
	req, out := c.AbortEnvironmentUpdateRequest(input)
	return out, req.Send()
}

// AbortEnvironmentUpdateWithContext is the same as AbortEnvironmentUpdate with the addition of
// the ability to pass a context and additional request options.
//
// See AbortEnvironmentUpdate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) AbortEnvironmentUpdateWithContext(ctx aws.Context, input *AbortEnvironmentUpdateInput, opts ...request.Option) (*AbortEnvironmentUpdateOutput, error) {
	req, out := c.AbortEnvironmentUpdateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opApplyEnvironmentManagedAction = "ApplyEnvironmentManagedAction"

// ApplyEnvironmentManagedActionRequest generates a "aws/request.Request" representing the
// client's request for the ApplyEnvironmentManagedAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ApplyEnvironmentManagedAction for more information on using the ApplyEnvironmentManagedAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ApplyEnvironmentManagedActionRequest method.
//    req, resp := client.ApplyEnvironmentManagedActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ApplyEnvironmentManagedAction
func (c *ElasticBeanstalk) ApplyEnvironmentManagedActionRequest(input *ApplyEnvironmentManagedActionInput) (req *request.Request, output *ApplyEnvironmentManagedActionOutput) {
	op := &request.Operation{
		Name:       opApplyEnvironmentManagedAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ApplyEnvironmentManagedActionInput{}
	}

	output = &ApplyEnvironmentManagedActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ApplyEnvironmentManagedAction API operation for AWS Elastic Beanstalk.
//
// Applies a scheduled managed action immediately. A managed action can be applied
// only if its status is Scheduled. Get the status and action ID of a managed
// action with DescribeEnvironmentManagedActions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation ApplyEnvironmentManagedAction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ElasticBeanstalkServiceException"
//   A generic service exception has occurred.
//
//   * ErrCodeManagedActionInvalidStateException "ManagedActionInvalidStateException"
//   Cannot modify the managed action in its current state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ApplyEnvironmentManagedAction
func (c *ElasticBeanstalk) ApplyEnvironmentManagedAction(input *ApplyEnvironmentManagedActionInput) (*ApplyEnvironmentManagedActionOutput, error) {
	req, out := c.ApplyEnvironmentManagedActionRequest(input)
	return out, req.Send()
}

// ApplyEnvironmentManagedActionWithContext is the same as ApplyEnvironmentManagedAction with the addition of
// the ability to pass a context and additional request options.
//
// See ApplyEnvironmentManagedAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) ApplyEnvironmentManagedActionWithContext(ctx aws.Context, input *ApplyEnvironmentManagedActionInput, opts ...request.Option) (*ApplyEnvironmentManagedActionOutput, error) {
	req, out := c.ApplyEnvironmentManagedActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateEnvironmentOperationsRole = "AssociateEnvironmentOperationsRole"

// AssociateEnvironmentOperationsRoleRequest generates a "aws/request.Request" representing the
// client's request for the AssociateEnvironmentOperationsRole operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateEnvironmentOperationsRole for more information on using the AssociateEnvironmentOperationsRole
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateEnvironmentOperationsRoleRequest method.
//    req, resp := client.AssociateEnvironmentOperationsRoleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/AssociateEnvironmentOperationsRole
func (c *ElasticBeanstalk) AssociateEnvironmentOperationsRoleRequest(input *AssociateEnvironmentOperationsRoleInput) (req *request.Request, output *AssociateEnvironmentOperationsRoleOutput) {
	op := &request.Operation{
		Name:       opAssociateEnvironmentOperationsRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateEnvironmentOperationsRoleInput{}
	}

	output = &AssociateEnvironmentOperationsRoleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateEnvironmentOperationsRole API operation for AWS Elastic Beanstalk.
//
// Add or change the operations role used by an environment. After this call
// is made, Elastic Beanstalk uses the associated operations role for permissions
// to downstream services during subsequent calls acting on this environment.
// For more information, see Operations roles (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html)
// in the AWS Elastic Beanstalk Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation AssociateEnvironmentOperationsRole for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInsufficientPrivilegesException "InsufficientPrivilegesException"
//   The specified account does not have sufficient privileges for one or more
//   AWS services.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/AssociateEnvironmentOperationsRole
func (c *ElasticBeanstalk) AssociateEnvironmentOperationsRole(input *AssociateEnvironmentOperationsRoleInput) (*AssociateEnvironmentOperationsRoleOutput, error) {
	req, out := c.AssociateEnvironmentOperationsRoleRequest(input)
	return out, req.Send()
}

// AssociateEnvironmentOperationsRoleWithContext is the same as AssociateEnvironmentOperationsRole with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateEnvironmentOperationsRole for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) AssociateEnvironmentOperationsRoleWithContext(ctx aws.Context, input *AssociateEnvironmentOperationsRoleInput, opts ...request.Option) (*AssociateEnvironmentOperationsRoleOutput, error) {
	req, out := c.AssociateEnvironmentOperationsRoleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCheckDNSAvailability = "CheckDNSAvailability"

// CheckDNSAvailabilityRequest generates a "aws/request.Request" representing the
// client's request for the CheckDNSAvailability operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CheckDNSAvailability for more information on using the CheckDNSAvailability
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CheckDNSAvailabilityRequest method.
//    req, resp := client.CheckDNSAvailabilityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CheckDNSAvailability
func (c *ElasticBeanstalk) CheckDNSAvailabilityRequest(input *CheckDNSAvailabilityInput) (req *request.Request, output *CheckDNSAvailabilityOutput) {
	op := &request.Operation{
		Name:       opCheckDNSAvailability,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CheckDNSAvailabilityInput{}
	}

	output = &CheckDNSAvailabilityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CheckDNSAvailability API operation for AWS Elastic Beanstalk.
//
// Checks if the specified CNAME is available.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation CheckDNSAvailability for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CheckDNSAvailability
func (c *ElasticBeanstalk) CheckDNSAvailability(input *CheckDNSAvailabilityInput) (*CheckDNSAvailabilityOutput, error) {
	req, out := c.CheckDNSAvailabilityRequest(input)
	return out, req.Send()
}

// CheckDNSAvailabilityWithContext is the same as CheckDNSAvailability with the addition of
// the ability to pass a context and additional request options.
//
// See CheckDNSAvailability for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) CheckDNSAvailabilityWithContext(ctx aws.Context, input *CheckDNSAvailabilityInput, opts ...request.Option) (*CheckDNSAvailabilityOutput, error) {
	req, out := c.CheckDNSAvailabilityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opComposeEnvironments = "ComposeEnvironments"

// ComposeEnvironmentsRequest generates a "aws/request.Request" representing the
// client's request for the ComposeEnvironments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ComposeEnvironments for more information on using the ComposeEnvironments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ComposeEnvironmentsRequest method.
//    req, resp := client.ComposeEnvironmentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ComposeEnvironments
func (c *ElasticBeanstalk) ComposeEnvironmentsRequest(input *ComposeEnvironmentsInput) (req *request.Request, output *EnvironmentDescriptionsMessage) {
	op := &request.Operation{
		Name:       opComposeEnvironments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ComposeEnvironmentsInput{}
	}

	output = &EnvironmentDescriptionsMessage{}
	req = c.newRequest(op, input, output)
	return
}

// ComposeEnvironments API operation for AWS Elastic Beanstalk.
//
// Create or update a group of environments that each run a separate component
// of a single application. Takes a list of version labels that specify application
// source bundles for each of the environments to create or update. The name
// of each environment and other required information must be included in the
// source bundles in an environment manifest named env.yaml. See Compose Environments
// (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-mgmt-compose.html)
// for details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation ComposeEnvironments for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTooManyEnvironmentsException "TooManyEnvironmentsException"
//   The specified account has reached its limit of environments.
//
//   * ErrCodeInsufficientPrivilegesException "InsufficientPrivilegesException"
//   The specified account does not have sufficient privileges for one or more
//   AWS services.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ComposeEnvironments
func (c *ElasticBeanstalk) ComposeEnvironments(input *ComposeEnvironmentsInput) (*EnvironmentDescriptionsMessage, error) {
	req, out := c.ComposeEnvironmentsRequest(input)
	return out, req.Send()
}

// ComposeEnvironmentsWithContext is the same as ComposeEnvironments with the addition of
// the ability to pass a context and additional request options.
//
// See ComposeEnvironments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) ComposeEnvironmentsWithContext(ctx aws.Context, input *ComposeEnvironmentsInput, opts ...request.Option) (*EnvironmentDescriptionsMessage, error) {
	req, out := c.ComposeEnvironmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateApplication = "CreateApplication"

// CreateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the CreateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApplication for more information on using the CreateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateApplicationRequest method.
//    req, resp := client.CreateApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateApplication
func (c *ElasticBeanstalk) CreateApplicationRequest(input *CreateApplicationInput) (req *request.Request, output *ApplicationDescriptionMessage) {
	op := &request.Operation{
		Name:       opCreateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateApplicationInput{}
	}

	output = &ApplicationDescriptionMessage{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApplication API operation for AWS Elastic Beanstalk.
//
// Creates an application that has one configuration template named default
// and no application versions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation CreateApplication for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTooManyApplicationsException "TooManyApplicationsException"
//   The specified account has reached its limit of applications.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateApplication
func (c *ElasticBeanstalk) CreateApplication(input *CreateApplicationInput) (*ApplicationDescriptionMessage, error) {
	req, out := c.CreateApplicationRequest(input)
	return out, req.Send()
}

// CreateApplicationWithContext is the same as CreateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) CreateApplicationWithContext(ctx aws.Context, input *CreateApplicationInput, opts ...request.Option) (*ApplicationDescriptionMessage, error) {
	req, out := c.CreateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateApplicationVersion = "CreateApplicationVersion"

// CreateApplicationVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateApplicationVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApplicationVersion for more information on using the CreateApplicationVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateApplicationVersionRequest method.
//    req, resp := client.CreateApplicationVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateApplicationVersion
func (c *ElasticBeanstalk) CreateApplicationVersionRequest(input *CreateApplicationVersionInput) (req *request.Request, output *ApplicationVersionDescriptionMessage) {
	op := &request.Operation{
		Name:       opCreateApplicationVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateApplicationVersionInput{}
	}

	output = &ApplicationVersionDescriptionMessage{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApplicationVersion API operation for AWS Elastic Beanstalk.
//
// Creates an application version for the specified application. You can create
// an application version from a source bundle in Amazon S3, a commit in AWS
// CodeCommit, or the output of an AWS CodeBuild build as follows:
//
// Specify a commit in an AWS CodeCommit repository with SourceBuildInformation.
//
// Specify a build in an AWS CodeBuild with SourceBuildInformation and BuildConfiguration.
//
// Specify a source bundle in S3 with SourceBundle
//
// Omit both SourceBuildInformation and SourceBundle to use the default sample
// application.
//
// After you create an application version with a specified Amazon S3 bucket
// and key location, you can't change that Amazon S3 location. If you change
// the Amazon S3 location, you receive an exception when you attempt to launch
// an environment from the application version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation CreateApplicationVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTooManyApplicationsException "TooManyApplicationsException"
//   The specified account has reached its limit of applications.
//
//   * ErrCodeTooManyApplicationVersionsException "TooManyApplicationVersionsException"
//   The specified account has reached its limit of application versions.
//
//   * ErrCodeInsufficientPrivilegesException "InsufficientPrivilegesException"
//   The specified account does not have sufficient privileges for one or more
//   AWS services.
//
//   * ErrCodeS3LocationNotInServiceRegionException "S3LocationNotInServiceRegionException"
//   The specified S3 bucket does not belong to the S3 region in which the service
//   is running. The following regions are supported:
//
//      * IAD/us-east-1
//
//      * PDX/us-west-2
//
//      * DUB/eu-west-1
//
//   * ErrCodeCodeBuildNotInServiceRegionException "CodeBuildNotInServiceRegionException"
//   AWS CodeBuild is not available in the specified region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateApplicationVersion
func (c *ElasticBeanstalk) CreateApplicationVersion(input *CreateApplicationVersionInput) (*ApplicationVersionDescriptionMessage, error) {
	req, out := c.CreateApplicationVersionRequest(input)
	return out, req.Send()
}

// CreateApplicationVersionWithContext is the same as CreateApplicationVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApplicationVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) CreateApplicationVersionWithContext(ctx aws.Context, input *CreateApplicationVersionInput, opts ...request.Option) (*ApplicationVersionDescriptionMessage, error) {
	req, out := c.CreateApplicationVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConfigurationTemplate = "CreateConfigurationTemplate"

// CreateConfigurationTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateConfigurationTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConfigurationTemplate for more information on using the CreateConfigurationTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateConfigurationTemplateRequest method.
//    req, resp := client.CreateConfigurationTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateConfigurationTemplate
func (c *ElasticBeanstalk) CreateConfigurationTemplateRequest(input *CreateConfigurationTemplateInput) (req *request.Request, output *ConfigurationSettingsDescription) {
	op := &request.Operation{
		Name:       opCreateConfigurationTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConfigurationTemplateInput{}
	}

	output = &ConfigurationSettingsDescription{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConfigurationTemplate API operation for AWS Elastic Beanstalk.
//
// Creates an AWS Elastic Beanstalk configuration template, associated with
// a specific Elastic Beanstalk application. You define application configuration
// settings in a configuration template. You can then use the configuration
// template to deploy different versions of the application with the same configuration
// settings.
//
// Templates aren't associated with any environment. The EnvironmentName response
// element is always null.
//
// Related Topics
//
//    * DescribeConfigurationOptions
//
//    * DescribeConfigurationSettings
//
//    * ListAvailableSolutionStacks
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation CreateConfigurationTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInsufficientPrivilegesException "InsufficientPrivilegesException"
//   The specified account does not have sufficient privileges for one or more
//   AWS services.
//
//   * ErrCodeTooManyBucketsException "TooManyBucketsException"
//   The specified account has reached its limit of Amazon S3 buckets.
//
//   * ErrCodeTooManyConfigurationTemplatesException "TooManyConfigurationTemplatesException"
//   The specified account has reached its limit of configuration templates.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateConfigurationTemplate
func (c *ElasticBeanstalk) CreateConfigurationTemplate(input *CreateConfigurationTemplateInput) (*ConfigurationSettingsDescription, error) {
	req, out := c.CreateConfigurationTemplateRequest(input)
	return out, req.Send()
}

// CreateConfigurationTemplateWithContext is the same as CreateConfigurationTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConfigurationTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) CreateConfigurationTemplateWithContext(ctx aws.Context, input *CreateConfigurationTemplateInput, opts ...request.Option) (*ConfigurationSettingsDescription, error) {
	req, out := c.CreateConfigurationTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEnvironment = "CreateEnvironment"

// CreateEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEnvironment for more information on using the CreateEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEnvironmentRequest method.
//    req, resp := client.CreateEnvironmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateEnvironment
func (c *ElasticBeanstalk) CreateEnvironmentRequest(input *CreateEnvironmentInput) (req *request.Request, output *EnvironmentDescription) {
	op := &request.Operation{
		Name:       opCreateEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEnvironmentInput{}
	}

	output = &EnvironmentDescription{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEnvironment API operation for AWS Elastic Beanstalk.
//
// Launches an AWS Elastic Beanstalk environment for the specified application
// using the specified configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation CreateEnvironment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTooManyEnvironmentsException "TooManyEnvironmentsException"
//   The specified account has reached its limit of environments.
//
//   * ErrCodeInsufficientPrivilegesException "InsufficientPrivilegesException"
//   The specified account does not have sufficient privileges for one or more
//   AWS services.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateEnvironment
func (c *ElasticBeanstalk) CreateEnvironment(input *CreateEnvironmentInput) (*EnvironmentDescription, error) {
	req, out := c.CreateEnvironmentRequest(input)
	return out, req.Send()
}

// CreateEnvironmentWithContext is the same as CreateEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) CreateEnvironmentWithContext(ctx aws.Context, input *CreateEnvironmentInput, opts ...request.Option) (*EnvironmentDescription, error) {
	req, out := c.CreateEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePlatformVersion = "CreatePlatformVersion"

// CreatePlatformVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreatePlatformVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePlatformVersion for more information on using the CreatePlatformVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePlatformVersionRequest method.
//    req, resp := client.CreatePlatformVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreatePlatformVersion
func (c *ElasticBeanstalk) CreatePlatformVersionRequest(input *CreatePlatformVersionInput) (req *request.Request, output *CreatePlatformVersionOutput) {
	op := &request.Operation{
		Name:       opCreatePlatformVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePlatformVersionInput{}
	}

	output = &CreatePlatformVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePlatformVersion API operation for AWS Elastic Beanstalk.
//
// Create a new version of your custom platform.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation CreatePlatformVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInsufficientPrivilegesException "InsufficientPrivilegesException"
//   The specified account does not have sufficient privileges for one or more
//   AWS services.
//
//   * ErrCodeServiceException "ElasticBeanstalkServiceException"
//   A generic service exception has occurred.
//
//   * ErrCodeTooManyPlatformsException "TooManyPlatformsException"
//   You have exceeded the maximum number of allowed platforms associated with
//   the account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreatePlatformVersion
func (c *ElasticBeanstalk) CreatePlatformVersion(input *CreatePlatformVersionInput) (*CreatePlatformVersionOutput, error) {
	req, out := c.CreatePlatformVersionRequest(input)
	return out, req.Send()
}

// CreatePlatformVersionWithContext is the same as CreatePlatformVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePlatformVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) CreatePlatformVersionWithContext(ctx aws.Context, input *CreatePlatformVersionInput, opts ...request.Option) (*CreatePlatformVersionOutput, error) {
	req, out := c.CreatePlatformVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStorageLocation = "CreateStorageLocation"

// CreateStorageLocationRequest generates a "aws/request.Request" representing the
// client's request for the CreateStorageLocation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStorageLocation for more information on using the CreateStorageLocation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateStorageLocationRequest method.
//    req, resp := client.CreateStorageLocationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateStorageLocation
func (c *ElasticBeanstalk) CreateStorageLocationRequest(input *CreateStorageLocationInput) (req *request.Request, output *CreateStorageLocationOutput) {
	op := &request.Operation{
		Name:       opCreateStorageLocation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStorageLocationInput{}
	}

	output = &CreateStorageLocationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStorageLocation API operation for AWS Elastic Beanstalk.
//
// Creates a bucket in Amazon S3 to store application versions, logs, and other
// files used by Elastic Beanstalk environments. The Elastic Beanstalk console
// and EB CLI call this API the first time you create an environment in a region.
// If the storage location already exists, CreateStorageLocation still returns
// the bucket name but does not create a new bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation CreateStorageLocation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTooManyBucketsException "TooManyBucketsException"
//   The specified account has reached its limit of Amazon S3 buckets.
//
//   * ErrCodeS3SubscriptionRequiredException "S3SubscriptionRequiredException"
//   The specified account does not have a subscription to Amazon S3.
//
//   * ErrCodeInsufficientPrivilegesException "InsufficientPrivilegesException"
//   The specified account does not have sufficient privileges for one or more
//   AWS services.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateStorageLocation
func (c *ElasticBeanstalk) CreateStorageLocation(input *CreateStorageLocationInput) (*CreateStorageLocationOutput, error) {
	req, out := c.CreateStorageLocationRequest(input)
	return out, req.Send()
}

// CreateStorageLocationWithContext is the same as CreateStorageLocation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStorageLocation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) CreateStorageLocationWithContext(ctx aws.Context, input *CreateStorageLocationInput, opts ...request.Option) (*CreateStorageLocationOutput, error) {
	req, out := c.CreateStorageLocationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplication = "DeleteApplication"

// DeleteApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplication for more information on using the DeleteApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApplicationRequest method.
//    req, resp := client.DeleteApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteApplication
func (c *ElasticBeanstalk) DeleteApplicationRequest(input *DeleteApplicationInput) (req *request.Request, output *DeleteApplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationInput{}
	}

	output = &DeleteApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApplication API operation for AWS Elastic Beanstalk.
//
// Deletes the specified application along with all associated versions and
// configurations. The application versions will not be deleted from your Amazon
// S3 bucket.
//
// You cannot delete an application that has a running environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation DeleteApplication for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeOperationInProgressException "OperationInProgressFailure"
//   Unable to perform the specified operation because another operation that
//   effects an element in this activity is already in progress.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteApplication
func (c *ElasticBeanstalk) DeleteApplication(input *DeleteApplicationInput) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	return out, req.Send()
}

// DeleteApplicationWithContext is the same as DeleteApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) DeleteApplicationWithContext(ctx aws.Context, input *DeleteApplicationInput, opts ...request.Option) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplicationVersion = "DeleteApplicationVersion"

// DeleteApplicationVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplicationVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplicationVersion for more information on using the DeleteApplicationVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApplicationVersionRequest method.
//    req, resp := client.DeleteApplicationVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteApplicationVersion
func (c *ElasticBeanstalk) DeleteApplicationVersionRequest(input *DeleteApplicationVersionInput) (req *request.Request, output *DeleteApplicationVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteApplicationVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationVersionInput{}
	}

	output = &DeleteApplicationVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApplicationVersion API operation for AWS Elastic Beanstalk.
//
// Deletes the specified version from the specified application.
//
// You cannot delete an application version that is associated with a running
// environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation DeleteApplicationVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSourceBundleDeletionException "SourceBundleDeletionFailure"
//   Unable to delete the Amazon S3 source bundle associated with the application
//   version. The application version was deleted successfully.
//
//   * ErrCodeInsufficientPrivilegesException "InsufficientPrivilegesException"
//   The specified account does not have sufficient privileges for one or more
//   AWS services.
//
//   * ErrCodeOperationInProgressException "OperationInProgressFailure"
//   Unable to perform the specified operation because another operation that
//   effects an element in this activity is already in progress.
//
//   * ErrCodeS3LocationNotInServiceRegionException "S3LocationNotInServiceRegionException"
//   The specified S3 bucket does not belong to the S3 region in which the service
//   is running. The following regions are supported:
//
//      * IAD/us-east-1
//
//      * PDX/us-west-2
//
//      * DUB/eu-west-1
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteApplicationVersion
func (c *ElasticBeanstalk) DeleteApplicationVersion(input *DeleteApplicationVersionInput) (*DeleteApplicationVersionOutput, error) {
	req, out := c.DeleteApplicationVersionRequest(input)
	return out, req.Send()
}

// DeleteApplicationVersionWithContext is the same as DeleteApplicationVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplicationVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) DeleteApplicationVersionWithContext(ctx aws.Context, input *DeleteApplicationVersionInput, opts ...request.Option) (*DeleteApplicationVersionOutput, error) {
	req, out := c.DeleteApplicationVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfigurationTemplate = "DeleteConfigurationTemplate"

// DeleteConfigurationTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfigurationTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfigurationTemplate for more information on using the DeleteConfigurationTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConfigurationTemplateRequest method.
//    req, resp := client.DeleteConfigurationTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteConfigurationTemplate
func (c *ElasticBeanstalk) DeleteConfigurationTemplateRequest(input *DeleteConfigurationTemplateInput) (req *request.Request, output *DeleteConfigurationTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteConfigurationTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConfigurationTemplateInput{}
	}

	output = &DeleteConfigurationTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfigurationTemplate API operation for AWS Elastic Beanstalk.
//
// Deletes the specified configuration template.
//
// When you launch an environment using a configuration template, the environment
// gets a copy of the template. You can delete or modify the environment's copy
// of the template without affecting the running environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation DeleteConfigurationTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeOperationInProgressException "OperationInProgressFailure"
//   Unable to perform the specified operation because another operation that
//   effects an element in this activity is already in progress.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteConfigurationTemplate
func (c *ElasticBeanstalk) DeleteConfigurationTemplate(input *DeleteConfigurationTemplateInput) (*DeleteConfigurationTemplateOutput, error) {
	req, out := c.DeleteConfigurationTemplateRequest(input)
	return out, req.Send()
}

// DeleteConfigurationTemplateWithContext is the same as DeleteConfigurationTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfigurationTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) DeleteConfigurationTemplateWithContext(ctx aws.Context, input *DeleteConfigurationTemplateInput, opts ...request.Option) (*DeleteConfigurationTemplateOutput, error) {
	req, out := c.DeleteConfigurationTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEnvironmentConfiguration = "DeleteEnvironmentConfiguration"

// DeleteEnvironmentConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEnvironmentConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEnvironmentConfiguration for more information on using the DeleteEnvironmentConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEnvironmentConfigurationRequest method.
//    req, resp := client.DeleteEnvironmentConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteEnvironmentConfiguration
func (c *ElasticBeanstalk) DeleteEnvironmentConfigurationRequest(input *DeleteEnvironmentConfigurationInput) (req *request.Request, output *DeleteEnvironmentConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteEnvironmentConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEnvironmentConfigurationInput{}
	}

	output = &DeleteEnvironmentConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEnvironmentConfiguration API operation for AWS Elastic Beanstalk.
//
// Deletes the draft configuration associated with the running environment.
//
// Updating a running environment with any configuration changes creates a draft
// configuration set. You can get the draft configuration using DescribeConfigurationSettings
// while the update is in progress or if the update fails. The DeploymentStatus
// for the draft configuration indicates whether the deployment is in process
// or has failed. The draft configuration remains in existence until it is deleted
// with this action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation DeleteEnvironmentConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteEnvironmentConfiguration
func (c *ElasticBeanstalk) DeleteEnvironmentConfiguration(input *DeleteEnvironmentConfigurationInput) (*DeleteEnvironmentConfigurationOutput, error) {
	req, out := c.DeleteEnvironmentConfigurationRequest(input)
	return out, req.Send()
}

// DeleteEnvironmentConfigurationWithContext is the same as DeleteEnvironmentConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEnvironmentConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) DeleteEnvironmentConfigurationWithContext(ctx aws.Context, input *DeleteEnvironmentConfigurationInput, opts ...request.Option) (*DeleteEnvironmentConfigurationOutput, error) {
	req, out := c.DeleteEnvironmentConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePlatformVersion = "DeletePlatformVersion"

// DeletePlatformVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeletePlatformVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePlatformVersion for more information on using the DeletePlatformVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePlatformVersionRequest method.
//    req, resp := client.DeletePlatformVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeletePlatformVersion
func (c *ElasticBeanstalk) DeletePlatformVersionRequest(input *DeletePlatformVersionInput) (req *request.Request, output *DeletePlatformVersionOutput) {
	op := &request.Operation{
		Name:       opDeletePlatformVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePlatformVersionInput{}
	}

	output = &DeletePlatformVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePlatformVersion API operation for AWS Elastic Beanstalk.
//
// Deletes the specified version of a custom platform.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation DeletePlatformVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeOperationInProgressException "OperationInProgressFailure"
//   Unable to perform the specified operation because another operation that
//   effects an element in this activity is already in progress.
//
//   * ErrCodeInsufficientPrivilegesException "InsufficientPrivilegesException"
//   The specified account does not have sufficient privileges for one or more
//   AWS services.
//
//   * ErrCodeServiceException "ElasticBeanstalkServiceException"
//   A generic service exception has occurred.
//
//   * ErrCodePlatformVersionStillReferencedException "PlatformVersionStillReferencedException"
//   You cannot delete the platform version because there are still environments
//   running on it.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeletePlatformVersion
func (c *ElasticBeanstalk) DeletePlatformVersion(input *DeletePlatformVersionInput) (*DeletePlatformVersionOutput, error) {
	req, out := c.DeletePlatformVersionRequest(input)
	return out, req.Send()
}

// DeletePlatformVersionWithContext is the same as DeletePlatformVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePlatformVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) DeletePlatformVersionWithContext(ctx aws.Context, input *DeletePlatformVersionInput, opts ...request.Option) (*DeletePlatformVersionOutput, error) {
	req, out := c.DeletePlatformVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountAttributes = "DescribeAccountAttributes"

// DescribeAccountAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountAttributes for more information on using the DescribeAccountAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountAttributesRequest method.
//    req, resp := client.DescribeAccountAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeAccountAttributes
func (c *ElasticBeanstalk) DescribeAccountAttributesRequest(input *DescribeAccountAttributesInput) (req *request.Request, output *DescribeAccountAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountAttributesInput{}
	}

	output = &DescribeAccountAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountAttributes API operation for AWS Elastic Beanstalk.
//
// Returns attributes related to AWS Elastic Beanstalk that are associated with
// the calling AWS account.
//
// The result currently has one set of attributes—resource quotas.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation DescribeAccountAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInsufficientPrivilegesException "InsufficientPrivilegesException"
//   The specified account does not have sufficient privileges for one or more
//   AWS services.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeAccountAttributes
func (c *ElasticBeanstalk) DescribeAccountAttributes(input *DescribeAccountAttributesInput) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	return out, req.Send()
}

// DescribeAccountAttributesWithContext is the same as DescribeAccountAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) DescribeAccountAttributesWithContext(ctx aws.Context, input *DescribeAccountAttributesInput, opts ...request.Option) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeApplicationVersions = "DescribeApplicationVersions"

// DescribeApplicationVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeApplicationVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeApplicationVersions for more information on using the DescribeApplicationVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeApplicationVersionsRequest method.
//    req, resp := client.DescribeApplicationVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeApplicationVersions
func (c *ElasticBeanstalk) DescribeApplicationVersionsRequest(input *DescribeApplicationVersionsInput) (req *request.Request, output *DescribeApplicationVersionsOutput) {
	op := &request.Operation{
		Name:       opDescribeApplicationVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeApplicationVersionsInput{}
	}

	output = &DescribeApplicationVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeApplicationVersions API operation for AWS Elastic Beanstalk.
//
// Retrieve a list of application versions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation DescribeApplicationVersions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeApplicationVersions
func (c *ElasticBeanstalk) DescribeApplicationVersions(input *DescribeApplicationVersionsInput) (*DescribeApplicationVersionsOutput, error) {
	req, out := c.DescribeApplicationVersionsRequest(input)
	return out, req.Send()
}

// DescribeApplicationVersionsWithContext is the same as DescribeApplicationVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeApplicationVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) DescribeApplicationVersionsWithContext(ctx aws.Context, input *DescribeApplicationVersionsInput, opts ...request.Option) (*DescribeApplicationVersionsOutput, error) {
	req, out := c.DescribeApplicationVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeApplications = "DescribeApplications"

// DescribeApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeApplications for more information on using the DescribeApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeApplicationsRequest method.
//    req, resp := client.DescribeApplicationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeApplications
func (c *ElasticBeanstalk) DescribeApplicationsRequest(input *DescribeApplicationsInput) (req *request.Request, output *DescribeApplicationsOutput) {
	op := &request.Operation{
		Name:       opDescribeApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeApplicationsInput{}
	}

	output = &DescribeApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeApplications API operation for AWS Elastic Beanstalk.
//
// Returns the descriptions of existing applications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation DescribeApplications for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeApplications
func (c *ElasticBeanstalk) DescribeApplications(input *DescribeApplicationsInput) (*DescribeApplicationsOutput, error) {
	req, out := c.DescribeApplicationsRequest(input)
	return out, req.Send()
}

// DescribeApplicationsWithContext is the same as DescribeApplications with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) DescribeApplicationsWithContext(ctx aws.Context, input *DescribeApplicationsInput, opts ...request.Option) (*DescribeApplicationsOutput, error) {
	req, out := c.DescribeApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConfigurationOptions = "DescribeConfigurationOptions"

// DescribeConfigurationOptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigurationOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigurationOptions for more information on using the DescribeConfigurationOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigurationOptionsRequest method.
//    req, resp := client.DescribeConfigurationOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeConfigurationOptions
func (c *ElasticBeanstalk) DescribeConfigurationOptionsRequest(input *DescribeConfigurationOptionsInput) (req *request.Request, output *DescribeConfigurationOptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigurationOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigurationOptionsInput{}
	}

	output = &DescribeConfigurationOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigurationOptions API operation for AWS Elastic Beanstalk.
//
// Describes the configuration options that are used in a particular configuration
// template or environment, or that a specified solution stack defines. The
// description includes the values the options, their default values, and an
// indication of the required action on a running environment if an option value
// is changed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation DescribeConfigurationOptions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTooManyBucketsException "TooManyBucketsException"
//   The specified account has reached its limit of Amazon S3 buckets.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeConfigurationOptions
func (c *ElasticBeanstalk) DescribeConfigurationOptions(input *DescribeConfigurationOptionsInput) (*DescribeConfigurationOptionsOutput, error) {
	req, out := c.DescribeConfigurationOptionsRequest(input)
	return out, req.Send()
}

// DescribeConfigurationOptionsWithContext is the same as DescribeConfigurationOptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigurationOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) DescribeConfigurationOptionsWithContext(ctx aws.Context, input *DescribeConfigurationOptionsInput, opts ...request.Option) (*DescribeConfigurationOptionsOutput, error) {
	req, out := c.DescribeConfigurationOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConfigurationSettings = "DescribeConfigurationSettings"

// DescribeConfigurationSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigurationSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigurationSettings for more information on using the DescribeConfigurationSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigurationSettingsRequest method.
//    req, resp := client.DescribeConfigurationSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeConfigurationSettings
func (c *ElasticBeanstalk) DescribeConfigurationSettingsRequest(input *DescribeConfigurationSettingsInput) (req *request.Request, output *DescribeConfigurationSettingsOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigurationSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigurationSettingsInput{}
	}

	output = &DescribeConfigurationSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigurationSettings API operation for AWS Elastic Beanstalk.
//
// Returns a description of the settings for the specified configuration set,
// that is, either a configuration template or the configuration set associated
// with a running environment.
//
// When describing the settings for the configuration set associated with a
// running environment, it is possible to receive two sets of setting descriptions.
// One is the deployed configuration set, and the other is a draft configuration
// of an environment that is either in the process of deployment or that failed
// to deploy.
//
// Related Topics
//
//    * DeleteEnvironmentConfiguration
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation DescribeConfigurationSettings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTooManyBucketsException "TooManyBucketsException"
//   The specified account has reached its limit of Amazon S3 buckets.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeConfigurationSettings
func (c *ElasticBeanstalk) DescribeConfigurationSettings(input *DescribeConfigurationSettingsInput) (*DescribeConfigurationSettingsOutput, error) {
	req, out := c.DescribeConfigurationSettingsRequest(input)
	return out, req.Send()
}

// DescribeConfigurationSettingsWithContext is the same as DescribeConfigurationSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigurationSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) DescribeConfigurationSettingsWithContext(ctx aws.Context, input *DescribeConfigurationSettingsInput, opts ...request.Option) (*DescribeConfigurationSettingsOutput, error) {
	req, out := c.DescribeConfigurationSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEnvironmentHealth = "DescribeEnvironmentHealth"

// DescribeEnvironmentHealthRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEnvironmentHealth operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEnvironmentHealth for more information on using the DescribeEnvironmentHealth
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEnvironmentHealthRequest method.
//    req, resp := client.DescribeEnvironmentHealthRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentHealth
func (c *ElasticBeanstalk) DescribeEnvironmentHealthRequest(input *DescribeEnvironmentHealthInput) (req *request.Request, output *DescribeEnvironmentHealthOutput) {
	op := &request.Operation{
		Name:       opDescribeEnvironmentHealth,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEnvironmentHealthInput{}
	}

	output = &DescribeEnvironmentHealthOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEnvironmentHealth API operation for AWS Elastic Beanstalk.
//
// Returns information about the overall health of the specified environment.
// The DescribeEnvironmentHealth operation is only available with AWS Elastic
// Beanstalk Enhanced Health.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation DescribeEnvironmentHealth for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more input parameters is not valid. Please correct the input parameters
//   and try the operation again.
//
//   * ErrCodeServiceException "ElasticBeanstalkServiceException"
//   A generic service exception has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentHealth
func (c *ElasticBeanstalk) DescribeEnvironmentHealth(input *DescribeEnvironmentHealthInput) (*DescribeEnvironmentHealthOutput, error) {
	req, out := c.DescribeEnvironmentHealthRequest(input)
	return out, req.Send()
}

// DescribeEnvironmentHealthWithContext is the same as DescribeEnvironmentHealth with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEnvironmentHealth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) DescribeEnvironmentHealthWithContext(ctx aws.Context, input *DescribeEnvironmentHealthInput, opts ...request.Option) (*DescribeEnvironmentHealthOutput, error) {
	req, out := c.DescribeEnvironmentHealthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEnvironmentManagedActionHistory = "DescribeEnvironmentManagedActionHistory"

// DescribeEnvironmentManagedActionHistoryRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEnvironmentManagedActionHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEnvironmentManagedActionHistory for more information on using the DescribeEnvironmentManagedActionHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEnvironmentManagedActionHistoryRequest method.
//    req, resp := client.DescribeEnvironmentManagedActionHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentManagedActionHistory
func (c *ElasticBeanstalk) DescribeEnvironmentManagedActionHistoryRequest(input *DescribeEnvironmentManagedActionHistoryInput) (req *request.Request, output *DescribeEnvironmentManagedActionHistoryOutput) {
	op := &request.Operation{
		Name:       opDescribeEnvironmentManagedActionHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEnvironmentManagedActionHistoryInput{}
	}

	output = &DescribeEnvironmentManagedActionHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEnvironmentManagedActionHistory API operation for AWS Elastic Beanstalk.
//
// Lists an environment's completed and failed managed actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation DescribeEnvironmentManagedActionHistory for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ElasticBeanstalkServiceException"
//   A generic service exception has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentManagedActionHistory
func (c *ElasticBeanstalk) DescribeEnvironmentManagedActionHistory(input *DescribeEnvironmentManagedActionHistoryInput) (*DescribeEnvironmentManagedActionHistoryOutput, error) {
	req, out := c.DescribeEnvironmentManagedActionHistoryRequest(input)
	return out, req.Send()
}

// DescribeEnvironmentManagedActionHistoryWithContext is the same as DescribeEnvironmentManagedActionHistory with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEnvironmentManagedActionHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) DescribeEnvironmentManagedActionHistoryWithContext(ctx aws.Context, input *DescribeEnvironmentManagedActionHistoryInput, opts ...request.Option) (*DescribeEnvironmentManagedActionHistoryOutput, error) {
	req, out := c.DescribeEnvironmentManagedActionHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEnvironmentManagedActionHistoryPages iterates over the pages of a DescribeEnvironmentManagedActionHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEnvironmentManagedActionHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEnvironmentManagedActionHistory operation.
//    pageNum := 0
//    err := client.DescribeEnvironmentManagedActionHistoryPages(params,
//        func(page *elasticbeanstalk.DescribeEnvironmentManagedActionHistoryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElasticBeanstalk) DescribeEnvironmentManagedActionHistoryPages(input *DescribeEnvironmentManagedActionHistoryInput, fn func(*DescribeEnvironmentManagedActionHistoryOutput, bool) bool) error {
	return c.DescribeEnvironmentManagedActionHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEnvironmentManagedActionHistoryPagesWithContext same as DescribeEnvironmentManagedActionHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) DescribeEnvironmentManagedActionHistoryPagesWithContext(ctx aws.Context, input *DescribeEnvironmentManagedActionHistoryInput, fn func(*DescribeEnvironmentManagedActionHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEnvironmentManagedActionHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEnvironmentManagedActionHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEnvironmentManagedActionHistoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeEnvironmentManagedActions = "DescribeEnvironmentManagedActions"

// DescribeEnvironmentManagedActionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEnvironmentManagedActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEnvironmentManagedActions for more information on using the DescribeEnvironmentManagedActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEnvironmentManagedActionsRequest method.
//    req, resp := client.DescribeEnvironmentManagedActionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentManagedActions
func (c *ElasticBeanstalk) DescribeEnvironmentManagedActionsRequest(input *DescribeEnvironmentManagedActionsInput) (req *request.Request, output *DescribeEnvironmentManagedActionsOutput) {
	op := &request.Operation{
		Name:       opDescribeEnvironmentManagedActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEnvironmentManagedActionsInput{}
	}

	output = &DescribeEnvironmentManagedActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEnvironmentManagedActions API operation for AWS Elastic Beanstalk.
//
// Lists an environment's upcoming and in-progress managed actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation DescribeEnvironmentManagedActions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ElasticBeanstalkServiceException"
//   A generic service exception has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentManagedActions
func (c *ElasticBeanstalk) DescribeEnvironmentManagedActions(input *DescribeEnvironmentManagedActionsInput) (*DescribeEnvironmentManagedActionsOutput, error) {
	req, out := c.DescribeEnvironmentManagedActionsRequest(input)
	return out, req.Send()
}

// DescribeEnvironmentManagedActionsWithContext is the same as DescribeEnvironmentManagedActions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEnvironmentManagedActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) DescribeEnvironmentManagedActionsWithContext(ctx aws.Context, input *DescribeEnvironmentManagedActionsInput, opts ...request.Option) (*DescribeEnvironmentManagedActionsOutput, error) {
	req, out := c.DescribeEnvironmentManagedActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEnvironmentResources = "DescribeEnvironmentResources"

// DescribeEnvironmentResourcesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEnvironmentResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEnvironmentResources for more information on using the DescribeEnvironmentResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEnvironmentResourcesRequest method.
//    req, resp := client.DescribeEnvironmentResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentResources
func (c *ElasticBeanstalk) DescribeEnvironmentResourcesRequest(input *DescribeEnvironmentResourcesInput) (req *request.Request, output *DescribeEnvironmentResourcesOutput) {
	op := &request.Operation{
		Name:       opDescribeEnvironmentResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEnvironmentResourcesInput{}
	}

	output = &DescribeEnvironmentResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEnvironmentResources API operation for AWS Elastic Beanstalk.
//
// Returns AWS resources for this environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation DescribeEnvironmentResources for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInsufficientPrivilegesException "InsufficientPrivilegesException"
//   The specified account does not have sufficient privileges for one or more
//   AWS services.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentResources
func (c *ElasticBeanstalk) DescribeEnvironmentResources(input *DescribeEnvironmentResourcesInput) (*DescribeEnvironmentResourcesOutput, error) {
	req, out := c.DescribeEnvironmentResourcesRequest(input)
	return out, req.Send()
}

// DescribeEnvironmentResourcesWithContext is the same as DescribeEnvironmentResources with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEnvironmentResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) DescribeEnvironmentResourcesWithContext(ctx aws.Context, input *DescribeEnvironmentResourcesInput, opts ...request.Option) (*DescribeEnvironmentResourcesOutput, error) {
	req, out := c.DescribeEnvironmentResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEnvironments = "DescribeEnvironments"

// DescribeEnvironmentsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEnvironments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEnvironments for more information on using the DescribeEnvironments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEnvironmentsRequest method.
//    req, resp := client.DescribeEnvironmentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironments
func (c *ElasticBeanstalk) DescribeEnvironmentsRequest(input *DescribeEnvironmentsInput) (req *request.Request, output *EnvironmentDescriptionsMessage) {
	op := &request.Operation{
		Name:       opDescribeEnvironments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEnvironmentsInput{}
	}

	output = &EnvironmentDescriptionsMessage{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEnvironments API operation for AWS Elastic Beanstalk.
//
// Returns descriptions for existing environments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation DescribeEnvironments for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironments
func (c *ElasticBeanstalk) DescribeEnvironments(input *DescribeEnvironmentsInput) (*EnvironmentDescriptionsMessage, error) {
	req, out := c.DescribeEnvironmentsRequest(input)
	return out, req.Send()
}

// DescribeEnvironmentsWithContext is the same as DescribeEnvironments with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEnvironments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) DescribeEnvironmentsWithContext(ctx aws.Context, input *DescribeEnvironmentsInput, opts ...request.Option) (*EnvironmentDescriptionsMessage, error) {
	req, out := c.DescribeEnvironmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEvents = "DescribeEvents"

// DescribeEventsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEvents for more information on using the DescribeEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventsRequest method.
//    req, resp := client.DescribeEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEvents
func (c *ElasticBeanstalk) DescribeEventsRequest(input *DescribeEventsInput) (req *request.Request, output *DescribeEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventsInput{}
	}

	output = &DescribeEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEvents API operation for AWS Elastic Beanstalk.
//
// Returns list of event descriptions matching criteria up to the last 6 weeks.
//
// This action returns the most recent 1,000 events from the specified NextToken.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation DescribeEvents for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEvents
func (c *ElasticBeanstalk) DescribeEvents(input *DescribeEventsInput) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	return out, req.Send()
}

// DescribeEventsWithContext is the same as DescribeEvents with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) DescribeEventsWithContext(ctx aws.Context, input *DescribeEventsInput, opts ...request.Option) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEventsPages iterates over the pages of a DescribeEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEvents operation.
//    pageNum := 0
//    err := client.DescribeEventsPages(params,
//        func(page *elasticbeanstalk.DescribeEventsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElasticBeanstalk) DescribeEventsPages(input *DescribeEventsInput, fn func(*DescribeEventsOutput, bool) bool) error {
	return c.DescribeEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEventsPagesWithContext same as DescribeEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) DescribeEventsPagesWithContext(ctx aws.Context, input *DescribeEventsInput, fn func(*DescribeEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEventsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeInstancesHealth = "DescribeInstancesHealth"

// DescribeInstancesHealthRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstancesHealth operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstancesHealth for more information on using the DescribeInstancesHealth
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInstancesHealthRequest method.
//    req, resp := client.DescribeInstancesHealthRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeInstancesHealth
func (c *ElasticBeanstalk) DescribeInstancesHealthRequest(input *DescribeInstancesHealthInput) (req *request.Request, output *DescribeInstancesHealthOutput) {
	op := &request.Operation{
		Name:       opDescribeInstancesHealth,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstancesHealthInput{}
	}

	output = &DescribeInstancesHealthOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstancesHealth API operation for AWS Elastic Beanstalk.
//
// Retrieves detailed information about the health of instances in your AWS
// Elastic Beanstalk. This operation requires enhanced health reporting (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation DescribeInstancesHealth for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more input parameters is not valid. Please correct the input parameters
//   and try the operation again.
//
//   * ErrCodeServiceException "ElasticBeanstalkServiceException"
//   A generic service exception has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeInstancesHealth
func (c *ElasticBeanstalk) DescribeInstancesHealth(input *DescribeInstancesHealthInput) (*DescribeInstancesHealthOutput, error) {
	req, out := c.DescribeInstancesHealthRequest(input)
	return out, req.Send()
}

// DescribeInstancesHealthWithContext is the same as DescribeInstancesHealth with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstancesHealth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) DescribeInstancesHealthWithContext(ctx aws.Context, input *DescribeInstancesHealthInput, opts ...request.Option) (*DescribeInstancesHealthOutput, error) {
	req, out := c.DescribeInstancesHealthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePlatformVersion = "DescribePlatformVersion"

// DescribePlatformVersionRequest generates a "aws/request.Request" representing the
// client's request for the DescribePlatformVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePlatformVersion for more information on using the DescribePlatformVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePlatformVersionRequest method.
//    req, resp := client.DescribePlatformVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribePlatformVersion
func (c *ElasticBeanstalk) DescribePlatformVersionRequest(input *DescribePlatformVersionInput) (req *request.Request, output *DescribePlatformVersionOutput) {
	op := &request.Operation{
		Name:       opDescribePlatformVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePlatformVersionInput{}
	}

	output = &DescribePlatformVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePlatformVersion API operation for AWS Elastic Beanstalk.
//
// Describes a platform version. Provides full details. Compare to ListPlatformVersions,
// which provides summary information about a list of platform versions.
//
// For definitions of platform version and other platform-related terms, see
// AWS Elastic Beanstalk Platforms Glossary (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation DescribePlatformVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInsufficientPrivilegesException "InsufficientPrivilegesException"
//   The specified account does not have sufficient privileges for one or more
//   AWS services.
//
//   * ErrCodeServiceException "ElasticBeanstalkServiceException"
//   A generic service exception has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribePlatformVersion
func (c *ElasticBeanstalk) DescribePlatformVersion(input *DescribePlatformVersionInput) (*DescribePlatformVersionOutput, error) {
	req, out := c.DescribePlatformVersionRequest(input)
	return out, req.Send()
}

// DescribePlatformVersionWithContext is the same as DescribePlatformVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePlatformVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) DescribePlatformVersionWithContext(ctx aws.Context, input *DescribePlatformVersionInput, opts ...request.Option) (*DescribePlatformVersionOutput, error) {
	req, out := c.DescribePlatformVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateEnvironmentOperationsRole = "DisassociateEnvironmentOperationsRole"

// DisassociateEnvironmentOperationsRoleRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateEnvironmentOperationsRole operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateEnvironmentOperationsRole for more information on using the DisassociateEnvironmentOperationsRole
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateEnvironmentOperationsRoleRequest method.
//    req, resp := client.DisassociateEnvironmentOperationsRoleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DisassociateEnvironmentOperationsRole
func (c *ElasticBeanstalk) DisassociateEnvironmentOperationsRoleRequest(input *DisassociateEnvironmentOperationsRoleInput) (req *request.Request, output *DisassociateEnvironmentOperationsRoleOutput) {
	op := &request.Operation{
		Name:       opDisassociateEnvironmentOperationsRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateEnvironmentOperationsRoleInput{}
	}

	output = &DisassociateEnvironmentOperationsRoleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateEnvironmentOperationsRole API operation for AWS Elastic Beanstalk.
//
// Disassociate the operations role from an environment. After this call is
// made, Elastic Beanstalk uses the caller's permissions for permissions to
// downstream services during subsequent calls acting on this environment. For
// more information, see Operations roles (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html)
// in the AWS Elastic Beanstalk Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation DisassociateEnvironmentOperationsRole for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInsufficientPrivilegesException "InsufficientPrivilegesException"
//   The specified account does not have sufficient privileges for one or more
//   AWS services.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DisassociateEnvironmentOperationsRole
func (c *ElasticBeanstalk) DisassociateEnvironmentOperationsRole(input *DisassociateEnvironmentOperationsRoleInput) (*DisassociateEnvironmentOperationsRoleOutput, error) {
	req, out := c.DisassociateEnvironmentOperationsRoleRequest(input)
	return out, req.Send()
}

// DisassociateEnvironmentOperationsRoleWithContext is the same as DisassociateEnvironmentOperationsRole with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateEnvironmentOperationsRole for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) DisassociateEnvironmentOperationsRoleWithContext(ctx aws.Context, input *DisassociateEnvironmentOperationsRoleInput, opts ...request.Option) (*DisassociateEnvironmentOperationsRoleOutput, error) {
	req, out := c.DisassociateEnvironmentOperationsRoleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAvailableSolutionStacks = "ListAvailableSolutionStacks"

// ListAvailableSolutionStacksRequest generates a "aws/request.Request" representing the
// client's request for the ListAvailableSolutionStacks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAvailableSolutionStacks for more information on using the ListAvailableSolutionStacks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAvailableSolutionStacksRequest method.
//    req, resp := client.ListAvailableSolutionStacksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListAvailableSolutionStacks
func (c *ElasticBeanstalk) ListAvailableSolutionStacksRequest(input *ListAvailableSolutionStacksInput) (req *request.Request, output *ListAvailableSolutionStacksOutput) {
	op := &request.Operation{
		Name:       opListAvailableSolutionStacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAvailableSolutionStacksInput{}
	}

	output = &ListAvailableSolutionStacksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAvailableSolutionStacks API operation for AWS Elastic Beanstalk.
//
// Returns a list of the available solution stack names, with the public version
// first and then in reverse chronological order.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation ListAvailableSolutionStacks for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListAvailableSolutionStacks
func (c *ElasticBeanstalk) ListAvailableSolutionStacks(input *ListAvailableSolutionStacksInput) (*ListAvailableSolutionStacksOutput, error) {
	req, out := c.ListAvailableSolutionStacksRequest(input)
	return out, req.Send()
}

// ListAvailableSolutionStacksWithContext is the same as ListAvailableSolutionStacks with the addition of
// the ability to pass a context and additional request options.
//
// See ListAvailableSolutionStacks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) ListAvailableSolutionStacksWithContext(ctx aws.Context, input *ListAvailableSolutionStacksInput, opts ...request.Option) (*ListAvailableSolutionStacksOutput, error) {
	req, out := c.ListAvailableSolutionStacksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPlatformBranches = "ListPlatformBranches"

// ListPlatformBranchesRequest generates a "aws/request.Request" representing the
// client's request for the ListPlatformBranches operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPlatformBranches for more information on using the ListPlatformBranches
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPlatformBranchesRequest method.
//    req, resp := client.ListPlatformBranchesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformBranches
func (c *ElasticBeanstalk) ListPlatformBranchesRequest(input *ListPlatformBranchesInput) (req *request.Request, output *ListPlatformBranchesOutput) {
	op := &request.Operation{
		Name:       opListPlatformBranches,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPlatformBranchesInput{}
	}

	output = &ListPlatformBranchesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPlatformBranches API operation for AWS Elastic Beanstalk.
//
// Lists the platform branches available for your account in an AWS Region.
// Provides summary information about each platform branch.
//
// For definitions of platform branch and other platform-related terms, see
// AWS Elastic Beanstalk Platforms Glossary (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation ListPlatformBranches for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformBranches
func (c *ElasticBeanstalk) ListPlatformBranches(input *ListPlatformBranchesInput) (*ListPlatformBranchesOutput, error) {
	req, out := c.ListPlatformBranchesRequest(input)
	return out, req.Send()
}

// ListPlatformBranchesWithContext is the same as ListPlatformBranches with the addition of
// the ability to pass a context and additional request options.
//
// See ListPlatformBranches for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) ListPlatformBranchesWithContext(ctx aws.Context, input *ListPlatformBranchesInput, opts ...request.Option) (*ListPlatformBranchesOutput, error) {
	req, out := c.ListPlatformBranchesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPlatformBranchesPages iterates over the pages of a ListPlatformBranches operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPlatformBranches method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPlatformBranches operation.
//    pageNum := 0
//    err := client.ListPlatformBranchesPages(params,
//        func(page *elasticbeanstalk.ListPlatformBranchesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElasticBeanstalk) ListPlatformBranchesPages(input *ListPlatformBranchesInput, fn func(*ListPlatformBranchesOutput, bool) bool) error {
	return c.ListPlatformBranchesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPlatformBranchesPagesWithContext same as ListPlatformBranchesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) ListPlatformBranchesPagesWithContext(ctx aws.Context, input *ListPlatformBranchesInput, fn func(*ListPlatformBranchesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPlatformBranchesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPlatformBranchesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPlatformBranchesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPlatformVersions = "ListPlatformVersions"

// ListPlatformVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListPlatformVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPlatformVersions for more information on using the ListPlatformVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPlatformVersionsRequest method.
//    req, resp := client.ListPlatformVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformVersions
func (c *ElasticBeanstalk) ListPlatformVersionsRequest(input *ListPlatformVersionsInput) (req *request.Request, output *ListPlatformVersionsOutput) {
	op := &request.Operation{
		Name:       opListPlatformVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPlatformVersionsInput{}
	}

	output = &ListPlatformVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPlatformVersions API operation for AWS Elastic Beanstalk.
//
// Lists the platform versions available for your account in an AWS Region.
// Provides summary information about each platform version. Compare to DescribePlatformVersion,
// which provides full details about a single platform version.
//
// For definitions of platform version and other platform-related terms, see
// AWS Elastic Beanstalk Platforms Glossary (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation ListPlatformVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInsufficientPrivilegesException "InsufficientPrivilegesException"
//   The specified account does not have sufficient privileges for one or more
//   AWS services.
//
//   * ErrCodeServiceException "ElasticBeanstalkServiceException"
//   A generic service exception has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformVersions
func (c *ElasticBeanstalk) ListPlatformVersions(input *ListPlatformVersionsInput) (*ListPlatformVersionsOutput, error) {
	req, out := c.ListPlatformVersionsRequest(input)
	return out, req.Send()
}

// ListPlatformVersionsWithContext is the same as ListPlatformVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListPlatformVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) ListPlatformVersionsWithContext(ctx aws.Context, input *ListPlatformVersionsInput, opts ...request.Option) (*ListPlatformVersionsOutput, error) {
	req, out := c.ListPlatformVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPlatformVersionsPages iterates over the pages of a ListPlatformVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPlatformVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPlatformVersions operation.
//    pageNum := 0
//    err := client.ListPlatformVersionsPages(params,
//        func(page *elasticbeanstalk.ListPlatformVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElasticBeanstalk) ListPlatformVersionsPages(input *ListPlatformVersionsInput, fn func(*ListPlatformVersionsOutput, bool) bool) error {
	return c.ListPlatformVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPlatformVersionsPagesWithContext same as ListPlatformVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) ListPlatformVersionsPagesWithContext(ctx aws.Context, input *ListPlatformVersionsInput, fn func(*ListPlatformVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPlatformVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPlatformVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPlatformVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListTagsForResource
func (c *ElasticBeanstalk) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Elastic Beanstalk.
//
// Return the tags applied to an AWS Elastic Beanstalk resource. The response
// contains a list of tag key-value pairs.
//
// Elastic Beanstalk supports tagging of all of its resources. For details about
// resource tagging, see Tagging Application Resources (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInsufficientPrivilegesException "InsufficientPrivilegesException"
//   The specified account does not have sufficient privileges for one or more
//   AWS services.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource doesn't exist for the specified Amazon Resource Name (ARN).
//
//   * ErrCodeResourceTypeNotSupportedException "ResourceTypeNotSupportedException"
//   The type of the specified Amazon Resource Name (ARN) isn't supported for
//   this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListTagsForResource
func (c *ElasticBeanstalk) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebuildEnvironment = "RebuildEnvironment"

// RebuildEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the RebuildEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebuildEnvironment for more information on using the RebuildEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RebuildEnvironmentRequest method.
//    req, resp := client.RebuildEnvironmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RebuildEnvironment
func (c *ElasticBeanstalk) RebuildEnvironmentRequest(input *RebuildEnvironmentInput) (req *request.Request, output *RebuildEnvironmentOutput) {
	op := &request.Operation{
		Name:       opRebuildEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebuildEnvironmentInput{}
	}

	output = &RebuildEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RebuildEnvironment API operation for AWS Elastic Beanstalk.
//
// Deletes and recreates all of the AWS resources (for example: the Auto Scaling
// group, load balancer, etc.) for a specified environment and forces a restart.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation RebuildEnvironment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInsufficientPrivilegesException "InsufficientPrivilegesException"
//   The specified account does not have sufficient privileges for one or more
//   AWS services.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RebuildEnvironment
func (c *ElasticBeanstalk) RebuildEnvironment(input *RebuildEnvironmentInput) (*RebuildEnvironmentOutput, error) {
	req, out := c.RebuildEnvironmentRequest(input)
	return out, req.Send()
}

// RebuildEnvironmentWithContext is the same as RebuildEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See RebuildEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) RebuildEnvironmentWithContext(ctx aws.Context, input *RebuildEnvironmentInput, opts ...request.Option) (*RebuildEnvironmentOutput, error) {
	req, out := c.RebuildEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRequestEnvironmentInfo = "RequestEnvironmentInfo"

// RequestEnvironmentInfoRequest generates a "aws/request.Request" representing the
// client's request for the RequestEnvironmentInfo operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RequestEnvironmentInfo for more information on using the RequestEnvironmentInfo
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RequestEnvironmentInfoRequest method.
//    req, resp := client.RequestEnvironmentInfoRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RequestEnvironmentInfo
func (c *ElasticBeanstalk) RequestEnvironmentInfoRequest(input *RequestEnvironmentInfoInput) (req *request.Request, output *RequestEnvironmentInfoOutput) {
	op := &request.Operation{
		Name:       opRequestEnvironmentInfo,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RequestEnvironmentInfoInput{}
	}

	output = &RequestEnvironmentInfoOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RequestEnvironmentInfo API operation for AWS Elastic Beanstalk.
//
// Initiates a request to compile the specified type of information of the deployed
// environment.
//
// Setting the InfoType to tail compiles the last lines from the application
// server log files of every Amazon EC2 instance in your environment.
//
// Setting the InfoType to bundle compresses the application server log files
// for every Amazon EC2 instance into a .zip file. Legacy and .NET containers
// do not support bundle logs.
//
// Use RetrieveEnvironmentInfo to obtain the set of logs.
//
// Related Topics
//
//    * RetrieveEnvironmentInfo
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation RequestEnvironmentInfo for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RequestEnvironmentInfo
func (c *ElasticBeanstalk) RequestEnvironmentInfo(input *RequestEnvironmentInfoInput) (*RequestEnvironmentInfoOutput, error) {
	req, out := c.RequestEnvironmentInfoRequest(input)
	return out, req.Send()
}

// RequestEnvironmentInfoWithContext is the same as RequestEnvironmentInfo with the addition of
// the ability to pass a context and additional request options.
//
// See RequestEnvironmentInfo for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) RequestEnvironmentInfoWithContext(ctx aws.Context, input *RequestEnvironmentInfoInput, opts ...request.Option) (*RequestEnvironmentInfoOutput, error) {
	req, out := c.RequestEnvironmentInfoRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestartAppServer = "RestartAppServer"

// RestartAppServerRequest generates a "aws/request.Request" representing the
// client's request for the RestartAppServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestartAppServer for more information on using the RestartAppServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestartAppServerRequest method.
//    req, resp := client.RestartAppServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RestartAppServer
func (c *ElasticBeanstalk) RestartAppServerRequest(input *RestartAppServerInput) (req *request.Request, output *RestartAppServerOutput) {
	op := &request.Operation{
		Name:       opRestartAppServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestartAppServerInput{}
	}

	output = &RestartAppServerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RestartAppServer API operation for AWS Elastic Beanstalk.
//
// Causes the environment to restart the application container server running
// on each Amazon EC2 instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation RestartAppServer for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RestartAppServer
func (c *ElasticBeanstalk) RestartAppServer(input *RestartAppServerInput) (*RestartAppServerOutput, error) {
	req, out := c.RestartAppServerRequest(input)
	return out, req.Send()
}

// RestartAppServerWithContext is the same as RestartAppServer with the addition of
// the ability to pass a context and additional request options.
//
// See RestartAppServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) RestartAppServerWithContext(ctx aws.Context, input *RestartAppServerInput, opts ...request.Option) (*RestartAppServerOutput, error) {
	req, out := c.RestartAppServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRetrieveEnvironmentInfo = "RetrieveEnvironmentInfo"

// RetrieveEnvironmentInfoRequest generates a "aws/request.Request" representing the
// client's request for the RetrieveEnvironmentInfo operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RetrieveEnvironmentInfo for more information on using the RetrieveEnvironmentInfo
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RetrieveEnvironmentInfoRequest method.
//    req, resp := client.RetrieveEnvironmentInfoRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RetrieveEnvironmentInfo
func (c *ElasticBeanstalk) RetrieveEnvironmentInfoRequest(input *RetrieveEnvironmentInfoInput) (req *request.Request, output *RetrieveEnvironmentInfoOutput) {
	op := &request.Operation{
		Name:       opRetrieveEnvironmentInfo,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RetrieveEnvironmentInfoInput{}
	}

	output = &RetrieveEnvironmentInfoOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RetrieveEnvironmentInfo API operation for AWS Elastic Beanstalk.
//
// Retrieves the compiled information from a RequestEnvironmentInfo request.
//
// Related Topics
//
//    * RequestEnvironmentInfo
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation RetrieveEnvironmentInfo for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RetrieveEnvironmentInfo
func (c *ElasticBeanstalk) RetrieveEnvironmentInfo(input *RetrieveEnvironmentInfoInput) (*RetrieveEnvironmentInfoOutput, error) {
	req, out := c.RetrieveEnvironmentInfoRequest(input)
	return out, req.Send()
}

// RetrieveEnvironmentInfoWithContext is the same as RetrieveEnvironmentInfo with the addition of
// the ability to pass a context and additional request options.
//
// See RetrieveEnvironmentInfo for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) RetrieveEnvironmentInfoWithContext(ctx aws.Context, input *RetrieveEnvironmentInfoInput, opts ...request.Option) (*RetrieveEnvironmentInfoOutput, error) {
	req, out := c.RetrieveEnvironmentInfoRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSwapEnvironmentCNAMEs = "SwapEnvironmentCNAMEs"

// SwapEnvironmentCNAMEsRequest generates a "aws/request.Request" representing the
// client's request for the SwapEnvironmentCNAMEs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SwapEnvironmentCNAMEs for more information on using the SwapEnvironmentCNAMEs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SwapEnvironmentCNAMEsRequest method.
//    req, resp := client.SwapEnvironmentCNAMEsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/SwapEnvironmentCNAMEs
func (c *ElasticBeanstalk) SwapEnvironmentCNAMEsRequest(input *SwapEnvironmentCNAMEsInput) (req *request.Request, output *SwapEnvironmentCNAMEsOutput) {
	op := &request.Operation{
		Name:       opSwapEnvironmentCNAMEs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SwapEnvironmentCNAMEsInput{}
	}

	output = &SwapEnvironmentCNAMEsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SwapEnvironmentCNAMEs API operation for AWS Elastic Beanstalk.
//
// Swaps the CNAMEs of two environments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation SwapEnvironmentCNAMEs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/SwapEnvironmentCNAMEs
func (c *ElasticBeanstalk) SwapEnvironmentCNAMEs(input *SwapEnvironmentCNAMEsInput) (*SwapEnvironmentCNAMEsOutput, error) {
	req, out := c.SwapEnvironmentCNAMEsRequest(input)
	return out, req.Send()
}

// SwapEnvironmentCNAMEsWithContext is the same as SwapEnvironmentCNAMEs with the addition of
// the ability to pass a context and additional request options.
//
// See SwapEnvironmentCNAMEs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) SwapEnvironmentCNAMEsWithContext(ctx aws.Context, input *SwapEnvironmentCNAMEsInput, opts ...request.Option) (*SwapEnvironmentCNAMEsOutput, error) {
	req, out := c.SwapEnvironmentCNAMEsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTerminateEnvironment = "TerminateEnvironment"

// TerminateEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the TerminateEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TerminateEnvironment for more information on using the TerminateEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TerminateEnvironmentRequest method.
//    req, resp := client.TerminateEnvironmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/TerminateEnvironment
func (c *ElasticBeanstalk) TerminateEnvironmentRequest(input *TerminateEnvironmentInput) (req *request.Request, output *EnvironmentDescription) {
	op := &request.Operation{
		Name:       opTerminateEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateEnvironmentInput{}
	}

	output = &EnvironmentDescription{}
	req = c.newRequest(op, input, output)
	return
}

// TerminateEnvironment API operation for AWS Elastic Beanstalk.
//
// Terminates the specified environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation TerminateEnvironment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInsufficientPrivilegesException "InsufficientPrivilegesException"
//   The specified account does not have sufficient privileges for one or more
//   AWS services.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/TerminateEnvironment
func (c *ElasticBeanstalk) TerminateEnvironment(input *TerminateEnvironmentInput) (*EnvironmentDescription, error) {
	req, out := c.TerminateEnvironmentRequest(input)
	return out, req.Send()
}

// TerminateEnvironmentWithContext is the same as TerminateEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See TerminateEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) TerminateEnvironmentWithContext(ctx aws.Context, input *TerminateEnvironmentInput, opts ...request.Option) (*EnvironmentDescription, error) {
	req, out := c.TerminateEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApplication = "UpdateApplication"

// UpdateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApplication for more information on using the UpdateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApplicationRequest method.
//    req, resp := client.UpdateApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateApplication
func (c *ElasticBeanstalk) UpdateApplicationRequest(input *UpdateApplicationInput) (req *request.Request, output *ApplicationDescriptionMessage) {
	op := &request.Operation{
		Name:       opUpdateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateApplicationInput{}
	}

	output = &ApplicationDescriptionMessage{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApplication API operation for AWS Elastic Beanstalk.
//
// Updates the specified application to have the specified properties.
//
// If a property (for example, description) is not provided, the value remains
// unchanged. To clear these properties, specify an empty string.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation UpdateApplication for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateApplication
func (c *ElasticBeanstalk) UpdateApplication(input *UpdateApplicationInput) (*ApplicationDescriptionMessage, error) {
	req, out := c.UpdateApplicationRequest(input)
	return out, req.Send()
}

// UpdateApplicationWithContext is the same as UpdateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) UpdateApplicationWithContext(ctx aws.Context, input *UpdateApplicationInput, opts ...request.Option) (*ApplicationDescriptionMessage, error) {
	req, out := c.UpdateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApplicationResourceLifecycle = "UpdateApplicationResourceLifecycle"

// UpdateApplicationResourceLifecycleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplicationResourceLifecycle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApplicationResourceLifecycle for more information on using the UpdateApplicationResourceLifecycle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApplicationResourceLifecycleRequest method.
//    req, resp := client.UpdateApplicationResourceLifecycleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateApplicationResourceLifecycle
func (c *ElasticBeanstalk) UpdateApplicationResourceLifecycleRequest(input *UpdateApplicationResourceLifecycleInput) (req *request.Request, output *UpdateApplicationResourceLifecycleOutput) {
	op := &request.Operation{
		Name:       opUpdateApplicationResourceLifecycle,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateApplicationResourceLifecycleInput{}
	}

	output = &UpdateApplicationResourceLifecycleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApplicationResourceLifecycle API operation for AWS Elastic Beanstalk.
//
// Modifies lifecycle settings for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation UpdateApplicationResourceLifecycle for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInsufficientPrivilegesException "InsufficientPrivilegesException"
//   The specified account does not have sufficient privileges for one or more
//   AWS services.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateApplicationResourceLifecycle
func (c *ElasticBeanstalk) UpdateApplicationResourceLifecycle(input *UpdateApplicationResourceLifecycleInput) (*UpdateApplicationResourceLifecycleOutput, error) {
	req, out := c.UpdateApplicationResourceLifecycleRequest(input)
	return out, req.Send()
}

// UpdateApplicationResourceLifecycleWithContext is the same as UpdateApplicationResourceLifecycle with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplicationResourceLifecycle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) UpdateApplicationResourceLifecycleWithContext(ctx aws.Context, input *UpdateApplicationResourceLifecycleInput, opts ...request.Option) (*UpdateApplicationResourceLifecycleOutput, error) {
	req, out := c.UpdateApplicationResourceLifecycleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApplicationVersion = "UpdateApplicationVersion"

// UpdateApplicationVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplicationVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApplicationVersion for more information on using the UpdateApplicationVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApplicationVersionRequest method.
//    req, resp := client.UpdateApplicationVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateApplicationVersion
func (c *ElasticBeanstalk) UpdateApplicationVersionRequest(input *UpdateApplicationVersionInput) (req *request.Request, output *ApplicationVersionDescriptionMessage) {
	op := &request.Operation{
		Name:       opUpdateApplicationVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateApplicationVersionInput{}
	}

	output = &ApplicationVersionDescriptionMessage{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApplicationVersion API operation for AWS Elastic Beanstalk.
//
// Updates the specified application version to have the specified properties.
//
// If a property (for example, description) is not provided, the value remains
// unchanged. To clear properties, specify an empty string.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation UpdateApplicationVersion for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateApplicationVersion
func (c *ElasticBeanstalk) UpdateApplicationVersion(input *UpdateApplicationVersionInput) (*ApplicationVersionDescriptionMessage, error) {
	req, out := c.UpdateApplicationVersionRequest(input)
	return out, req.Send()
}

// UpdateApplicationVersionWithContext is the same as UpdateApplicationVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplicationVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) UpdateApplicationVersionWithContext(ctx aws.Context, input *UpdateApplicationVersionInput, opts ...request.Option) (*ApplicationVersionDescriptionMessage, error) {
	req, out := c.UpdateApplicationVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConfigurationTemplate = "UpdateConfigurationTemplate"

// UpdateConfigurationTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConfigurationTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConfigurationTemplate for more information on using the UpdateConfigurationTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateConfigurationTemplateRequest method.
//    req, resp := client.UpdateConfigurationTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateConfigurationTemplate
func (c *ElasticBeanstalk) UpdateConfigurationTemplateRequest(input *UpdateConfigurationTemplateInput) (req *request.Request, output *ConfigurationSettingsDescription) {
	op := &request.Operation{
		Name:       opUpdateConfigurationTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateConfigurationTemplateInput{}
	}

	output = &ConfigurationSettingsDescription{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateConfigurationTemplate API operation for AWS Elastic Beanstalk.
//
// Updates the specified configuration template to have the specified properties
// or configuration option values.
//
// If a property (for example, ApplicationName) is not provided, its value remains
// unchanged. To clear such properties, specify an empty string.
//
// Related Topics
//
//    * DescribeConfigurationOptions
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation UpdateConfigurationTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInsufficientPrivilegesException "InsufficientPrivilegesException"
//   The specified account does not have sufficient privileges for one or more
//   AWS services.
//
//   * ErrCodeTooManyBucketsException "TooManyBucketsException"
//   The specified account has reached its limit of Amazon S3 buckets.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateConfigurationTemplate
func (c *ElasticBeanstalk) UpdateConfigurationTemplate(input *UpdateConfigurationTemplateInput) (*ConfigurationSettingsDescription, error) {
	req, out := c.UpdateConfigurationTemplateRequest(input)
	return out, req.Send()
}

// UpdateConfigurationTemplateWithContext is the same as UpdateConfigurationTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConfigurationTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) UpdateConfigurationTemplateWithContext(ctx aws.Context, input *UpdateConfigurationTemplateInput, opts ...request.Option) (*ConfigurationSettingsDescription, error) {
	req, out := c.UpdateConfigurationTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEnvironment = "UpdateEnvironment"

// UpdateEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEnvironment for more information on using the UpdateEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEnvironmentRequest method.
//    req, resp := client.UpdateEnvironmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateEnvironment
func (c *ElasticBeanstalk) UpdateEnvironmentRequest(input *UpdateEnvironmentInput) (req *request.Request, output *EnvironmentDescription) {
	op := &request.Operation{
		Name:       opUpdateEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEnvironmentInput{}
	}

	output = &EnvironmentDescription{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEnvironment API operation for AWS Elastic Beanstalk.
//
// Updates the environment description, deploys a new application version, updates
// the configuration settings to an entirely new configuration template, or
// updates select configuration option values in the running environment.
//
// Attempting to update both the release and configuration is not allowed and
// AWS Elastic Beanstalk returns an InvalidParameterCombination error.
//
// When updating the configuration settings to a new template or individual
// settings, a draft configuration is created and DescribeConfigurationSettings
// for this environment returns two setting descriptions with different DeploymentStatus
// values.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation UpdateEnvironment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInsufficientPrivilegesException "InsufficientPrivilegesException"
//   The specified account does not have sufficient privileges for one or more
//   AWS services.
//
//   * ErrCodeTooManyBucketsException "TooManyBucketsException"
//   The specified account has reached its limit of Amazon S3 buckets.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateEnvironment
func (c *ElasticBeanstalk) UpdateEnvironment(input *UpdateEnvironmentInput) (*EnvironmentDescription, error) {
	req, out := c.UpdateEnvironmentRequest(input)
	return out, req.Send()
}

// UpdateEnvironmentWithContext is the same as UpdateEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) UpdateEnvironmentWithContext(ctx aws.Context, input *UpdateEnvironmentInput, opts ...request.Option) (*EnvironmentDescription, error) {
	req, out := c.UpdateEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTagsForResource = "UpdateTagsForResource"

// UpdateTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTagsForResource for more information on using the UpdateTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTagsForResourceRequest method.
//    req, resp := client.UpdateTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateTagsForResource
func (c *ElasticBeanstalk) UpdateTagsForResourceRequest(input *UpdateTagsForResourceInput) (req *request.Request, output *UpdateTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opUpdateTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTagsForResourceInput{}
	}

	output = &UpdateTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateTagsForResource API operation for AWS Elastic Beanstalk.
//
// Update the list of tags applied to an AWS Elastic Beanstalk resource. Two
// lists can be passed: TagsToAdd for tags to add or update, and TagsToRemove.
//
// Elastic Beanstalk supports tagging of all of its resources. For details about
// resource tagging, see Tagging Application Resources (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html).
//
// If you create a custom IAM user policy to control permission to this operation,
// specify one of the following two virtual actions (or both) instead of the
// API operation name:
//
// elasticbeanstalk:AddTags
//
// Controls permission to call UpdateTagsForResource and pass a list of tags
// to add in the TagsToAdd parameter.
//
// elasticbeanstalk:RemoveTags
//
// Controls permission to call UpdateTagsForResource and pass a list of tag
// keys to remove in the TagsToRemove parameter.
//
// For details about creating a custom user policy, see Creating a Custom User
// Policy (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.managed-policies.html#AWSHowTo.iam.policies).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation UpdateTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInsufficientPrivilegesException "InsufficientPrivilegesException"
//   The specified account does not have sufficient privileges for one or more
//   AWS services.
//
//   * ErrCodeOperationInProgressException "OperationInProgressFailure"
//   Unable to perform the specified operation because another operation that
//   effects an element in this activity is already in progress.
//
//   * ErrCodeTooManyTagsException "TooManyTagsException"
//   The number of tags in the resource would exceed the number of tags that each
//   resource can have.
//
//   To calculate this, the operation considers both the number of tags the resource
//   already has and the tags this operation would add if it succeeded.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A resource doesn't exist for the specified Amazon Resource Name (ARN).
//
//   * ErrCodeResourceTypeNotSupportedException "ResourceTypeNotSupportedException"
//   The type of the specified Amazon Resource Name (ARN) isn't supported for
//   this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateTagsForResource
func (c *ElasticBeanstalk) UpdateTagsForResource(input *UpdateTagsForResourceInput) (*UpdateTagsForResourceOutput, error) {
	req, out := c.UpdateTagsForResourceRequest(input)
	return out, req.Send()
}

// UpdateTagsForResourceWithContext is the same as UpdateTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) UpdateTagsForResourceWithContext(ctx aws.Context, input *UpdateTagsForResourceInput, opts ...request.Option) (*UpdateTagsForResourceOutput, error) {
	req, out := c.UpdateTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opValidateConfigurationSettings = "ValidateConfigurationSettings"

// ValidateConfigurationSettingsRequest generates a "aws/request.Request" representing the
// client's request for the ValidateConfigurationSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ValidateConfigurationSettings for more information on using the ValidateConfigurationSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ValidateConfigurationSettingsRequest method.
//    req, resp := client.ValidateConfigurationSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ValidateConfigurationSettings
func (c *ElasticBeanstalk) ValidateConfigurationSettingsRequest(input *ValidateConfigurationSettingsInput) (req *request.Request, output *ValidateConfigurationSettingsOutput) {
	op := &request.Operation{
		Name:       opValidateConfigurationSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ValidateConfigurationSettingsInput{}
	}

	output = &ValidateConfigurationSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ValidateConfigurationSettings API operation for AWS Elastic Beanstalk.
//
// Takes a set of configuration settings and either a configuration template
// or environment, and determines whether those values are valid.
//
// This action returns a list of messages indicating any errors or warnings
// associated with the selection of option values.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elastic Beanstalk's
// API operation ValidateConfigurationSettings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInsufficientPrivilegesException "InsufficientPrivilegesException"
//   The specified account does not have sufficient privileges for one or more
//   AWS services.
//
//   * ErrCodeTooManyBucketsException "TooManyBucketsException"
//   The specified account has reached its limit of Amazon S3 buckets.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ValidateConfigurationSettings
func (c *ElasticBeanstalk) ValidateConfigurationSettings(input *ValidateConfigurationSettingsInput) (*ValidateConfigurationSettingsOutput, error) {
	req, out := c.ValidateConfigurationSettingsRequest(input)
	return out, req.Send()
}

// ValidateConfigurationSettingsWithContext is the same as ValidateConfigurationSettings with the addition of
// the ability to pass a context and additional request options.
//
// See ValidateConfigurationSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticBeanstalk) ValidateConfigurationSettingsWithContext(ctx aws.Context, input *ValidateConfigurationSettingsInput, opts ...request.Option) (*ValidateConfigurationSettingsOutput, error) {
	req, out := c.ValidateConfigurationSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AbortEnvironmentUpdateInput struct {
	_ struct{} `type:"structure"`

	// This specifies the ID of the environment with the in-progress update that
	// you want to cancel.
	EnvironmentId *string `type:"string"`

	// This specifies the name of the environment with the in-progress update that
	// you want to cancel.
	EnvironmentName *string `min:"4" type:"string"`
}

// String returns the string representation
func (s AbortEnvironmentUpdateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortEnvironmentUpdateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AbortEnvironmentUpdateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AbortEnvironmentUpdateInput"}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *AbortEnvironmentUpdateInput) SetEnvironmentId(v string) *AbortEnvironmentUpdateInput {
	s.EnvironmentId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *AbortEnvironmentUpdateInput) SetEnvironmentName(v string) *AbortEnvironmentUpdateInput {
	s.EnvironmentName = &v
	return s
}

type AbortEnvironmentUpdateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AbortEnvironmentUpdateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortEnvironmentUpdateOutput) GoString() string {
	return s.String()
}

// Describes the properties of an application.
type ApplicationDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the application.
	ApplicationArn *string `type:"string"`

	// The name of the application.
	ApplicationName *string `min:"1" type:"string"`

	// The names of the configuration templates associated with this application.
	ConfigurationTemplates []*string `type:"list"`

	// The date when the application was created.
	DateCreated *time.Time `type:"timestamp"`

	// The date when the application was last modified.
	DateUpdated *time.Time `type:"timestamp"`

	// User-defined description of the application.
	Description *string `type:"string"`

	// The lifecycle settings for the application.
	ResourceLifecycleConfig *ApplicationResourceLifecycleConfig `type:"structure"`

	// The names of the versions for this application.
	Versions []*string `type:"list"`
}

// String returns the string representation
func (s ApplicationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationDescription) GoString() string {
	return s.String()
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *ApplicationDescription) SetApplicationArn(v string) *ApplicationDescription {
	s.ApplicationArn = &v
	return s
}

// SetApplicationName sets the ApplicationName field's value.
func (s *ApplicationDescription) SetApplicationName(v string) *ApplicationDescription {
	s.ApplicationName = &v
	return s
}

// SetConfigurationTemplates sets the ConfigurationTemplates field's value.
func (s *ApplicationDescription) SetConfigurationTemplates(v []*string) *ApplicationDescription {
	s.ConfigurationTemplates = v
	return s
}

// SetDateCreated sets the DateCreated field's value.
func (s *ApplicationDescription) SetDateCreated(v time.Time) *ApplicationDescription {
	s.DateCreated = &v
	return s
}

// SetDateUpdated sets the DateUpdated field's value.
func (s *ApplicationDescription) SetDateUpdated(v time.Time) *ApplicationDescription {
	s.DateUpdated = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ApplicationDescription) SetDescription(v string) *ApplicationDescription {
	s.Description = &v
	return s
}

// SetResourceLifecycleConfig sets the ResourceLifecycleConfig field's value.
func (s *ApplicationDescription) SetResourceLifecycleConfig(v *ApplicationResourceLifecycleConfig) *ApplicationDescription {
	s.ResourceLifecycleConfig = v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ApplicationDescription) SetVersions(v []*string) *ApplicationDescription {
	s.Versions = v
	return s
}

// Result message containing a single description of an application.
type ApplicationDescriptionMessage struct {
	_ struct{} `type:"structure"`

	// The ApplicationDescription of the application.
	Application *ApplicationDescription `type:"structure"`
}

// String returns the string representation
func (s ApplicationDescriptionMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationDescriptionMessage) GoString() string {
	return s.String()
}

// SetApplication sets the Application field's value.
func (s *ApplicationDescriptionMessage) SetApplication(v *ApplicationDescription) *ApplicationDescriptionMessage {
	s.Application = v
	return s
}

// Application request metrics for an AWS Elastic Beanstalk environment.
type ApplicationMetrics struct {
	_ struct{} `type:"structure"`

	// The amount of time that the metrics cover (usually 10 seconds). For example,
	// you might have 5 requests (request_count) within the most recent time slice
	// of 10 seconds (duration).
	Duration *int64 `type:"integer"`

	// Represents the average latency for the slowest X percent of requests over
	// the last 10 seconds. Latencies are in seconds with one millisecond resolution.
	Latency *Latency `type:"structure"`

	// Average number of requests handled by the web server per second over the
	// last 10 seconds.
	RequestCount *int64 `type:"integer"`

	// Represents the percentage of requests over the last 10 seconds that resulted
	// in each type of status code response.
	StatusCodes *StatusCodes `type:"structure"`
}

// String returns the string representation
func (s ApplicationMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationMetrics) GoString() string {
	return s.String()
}

// SetDuration sets the Duration field's value.
func (s *ApplicationMetrics) SetDuration(v int64) *ApplicationMetrics {
	s.Duration = &v
	return s
}

// SetLatency sets the Latency field's value.
func (s *ApplicationMetrics) SetLatency(v *Latency) *ApplicationMetrics {
	s.Latency = v
	return s
}

// SetRequestCount sets the RequestCount field's value.
func (s *ApplicationMetrics) SetRequestCount(v int64) *ApplicationMetrics {
	s.RequestCount = &v
	return s
}

// SetStatusCodes sets the StatusCodes field's value.
func (s *ApplicationMetrics) SetStatusCodes(v *StatusCodes) *ApplicationMetrics {
	s.StatusCodes = v
	return s
}

// The resource lifecycle configuration for an application. Defines lifecycle
// settings for resources that belong to the application, and the service role
// that AWS Elastic Beanstalk assumes in order to apply lifecycle settings.
// The version lifecycle configuration defines lifecycle settings for application
// versions.
type ApplicationResourceLifecycleConfig struct {
	_ struct{} `type:"structure"`

	// The ARN of an IAM service role that Elastic Beanstalk has permission to assume.
	//
	// The ServiceRole property is required the first time that you provide a VersionLifecycleConfig
	// for the application in one of the supporting calls (CreateApplication or
	// UpdateApplicationResourceLifecycle). After you provide it once, in either
	// one of the calls, Elastic Beanstalk persists the Service Role with the application,
	// and you don't need to specify it again in subsequent UpdateApplicationResourceLifecycle
	// calls. You can, however, specify it in subsequent calls to change the Service
	// Role to another value.
	ServiceRole *string `type:"string"`

	// Defines lifecycle settings for application versions.
	VersionLifecycleConfig *ApplicationVersionLifecycleConfig `type:"structure"`
}

// String returns the string representation
func (s ApplicationResourceLifecycleConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationResourceLifecycleConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationResourceLifecycleConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplicationResourceLifecycleConfig"}
	if s.VersionLifecycleConfig != nil {
		if err := s.VersionLifecycleConfig.Validate(); err != nil {
			invalidParams.AddNested("VersionLifecycleConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceRole sets the ServiceRole field's value.
func (s *ApplicationResourceLifecycleConfig) SetServiceRole(v string) *ApplicationResourceLifecycleConfig {
	s.ServiceRole = &v
	return s
}

// SetVersionLifecycleConfig sets the VersionLifecycleConfig field's value.
func (s *ApplicationResourceLifecycleConfig) SetVersionLifecycleConfig(v *ApplicationVersionLifecycleConfig) *ApplicationResourceLifecycleConfig {
	s.VersionLifecycleConfig = v
	return s
}

// Describes the properties of an application version.
type ApplicationVersionDescription struct {
	_ struct{} `type:"structure"`

	// The name of the application to which the application version belongs.
	ApplicationName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the application version.
	ApplicationVersionArn *string `type:"string"`

	// Reference to the artifact from the AWS CodeBuild build.
	BuildArn *string `type:"string"`

	// The creation date of the application version.
	DateCreated *time.Time `type:"timestamp"`

	// The last modified date of the application version.
	DateUpdated *time.Time `type:"timestamp"`

	// The description of the application version.
	Description *string `type:"string"`

	// If the version's source code was retrieved from AWS CodeCommit, the location
	// of the source code for the application version.
	SourceBuildInformation *SourceBuildInformation `type:"structure"`

	// The storage location of the application version's source bundle in Amazon
	// S3.
	SourceBundle *S3Location `type:"structure"`

	// The processing status of the application version. Reflects the state of the
	// application version during its creation. Many of the values are only applicable
	// if you specified True for the Process parameter of the CreateApplicationVersion
	// action. The following list describes the possible values.
	//
	//    * Unprocessed – Application version wasn't pre-processed or validated.
	//    Elastic Beanstalk will validate configuration files during deployment
	//    of the application version to an environment.
	//
	//    * Processing – Elastic Beanstalk is currently processing the application
	//    version.
	//
	//    * Building – Application version is currently undergoing an AWS CodeBuild
	//    build.
	//
	//    * Processed – Elastic Beanstalk was successfully pre-processed and validated.
	//
	//    * Failed – Either the AWS CodeBuild build failed or configuration files
	//    didn't pass validation. This application version isn't usable.
	Status *string `type:"string" enum:"ApplicationVersionStatus"`

	// A unique identifier for the application version.
	VersionLabel *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ApplicationVersionDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationVersionDescription) GoString() string {
	return s.String()
}

// SetApplicationName sets the ApplicationName field's value.
func (s *ApplicationVersionDescription) SetApplicationName(v string) *ApplicationVersionDescription {
	s.ApplicationName = &v
	return s
}

// SetApplicationVersionArn sets the ApplicationVersionArn field's value.
func (s *ApplicationVersionDescription) SetApplicationVersionArn(v string) *ApplicationVersionDescription {
	s.ApplicationVersionArn = &v
	return s
}

// SetBuildArn sets the BuildArn field's value.
func (s *ApplicationVersionDescription) SetBuildArn(v string) *ApplicationVersionDescription {
	s.BuildArn = &v
	return s
}

// SetDateCreated sets the DateCreated field's value.
func (s *ApplicationVersionDescription) SetDateCreated(v time.Time) *ApplicationVersionDescription {
	s.DateCreated = &v
	return s
}

// SetDateUpdated sets the DateUpdated field's value.
func (s *ApplicationVersionDescription) SetDateUpdated(v time.Time) *ApplicationVersionDescription {
	s.DateUpdated = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ApplicationVersionDescription) SetDescription(v string) *ApplicationVersionDescription {
	s.Description = &v
	return s
}

// SetSourceBuildInformation sets the SourceBuildInformation field's value.
func (s *ApplicationVersionDescription) SetSourceBuildInformation(v *SourceBuildInformation) *ApplicationVersionDescription {
	s.SourceBuildInformation = v
	return s
}

// SetSourceBundle sets the SourceBundle field's value.
func (s *ApplicationVersionDescription) SetSourceBundle(v *S3Location) *ApplicationVersionDescription {
	s.SourceBundle = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ApplicationVersionDescription) SetStatus(v string) *ApplicationVersionDescription {
	s.Status = &v
	return s
}

// SetVersionLabel sets the VersionLabel field's value.
func (s *ApplicationVersionDescription) SetVersionLabel(v string) *ApplicationVersionDescription {
	s.VersionLabel = &v
	return s
}

// Result message wrapping a single description of an application version.
type ApplicationVersionDescriptionMessage struct {
	_ struct{} `type:"structure"`

	// The ApplicationVersionDescription of the application version.
	ApplicationVersion *ApplicationVersionDescription `type:"structure"`
}

// String returns the string representation
func (s ApplicationVersionDescriptionMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationVersionDescriptionMessage) GoString() string {
	return s.String()
}

// SetApplicationVersion sets the ApplicationVersion field's value.
func (s *ApplicationVersionDescriptionMessage) SetApplicationVersion(v *ApplicationVersionDescription) *ApplicationVersionDescriptionMessage {
	s.ApplicationVersion = v
	return s
}

// The application version lifecycle settings for an application. Defines the
// rules that Elastic Beanstalk applies to an application's versions in order
// to avoid hitting the per-region limit for application versions.
//
// When Elastic Beanstalk deletes an application version from its database,
// you can no longer deploy that version to an environment. The source bundle
// remains in S3 unless you configure the rule to delete it.
type ApplicationVersionLifecycleConfig struct {
	_ struct{} `type:"structure"`

	// Specify a max age rule to restrict the length of time that application versions
	// are retained for an application.
	MaxAgeRule *MaxAgeRule `type:"structure"`

	// Specify a max count rule to restrict the number of application versions that
	// are retained for an application.
	MaxCountRule *MaxCountRule `type:"structure"`
}

// String returns the string representation
func (s ApplicationVersionLifecycleConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationVersionLifecycleConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationVersionLifecycleConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplicationVersionLifecycleConfig"}
	if s.MaxAgeRule != nil {
		if err := s.MaxAgeRule.Validate(); err != nil {
			invalidParams.AddNested("MaxAgeRule", err.(request.ErrInvalidParams))
		}
	}
	if s.MaxCountRule != nil {
		if err := s.MaxCountRule.Validate(); err != nil {
			invalidParams.AddNested("MaxCountRule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxAgeRule sets the MaxAgeRule field's value.
func (s *ApplicationVersionLifecycleConfig) SetMaxAgeRule(v *MaxAgeRule) *ApplicationVersionLifecycleConfig {
	s.MaxAgeRule = v
	return s
}

// SetMaxCountRule sets the MaxCountRule field's value.
func (s *ApplicationVersionLifecycleConfig) SetMaxCountRule(v *MaxCountRule) *ApplicationVersionLifecycleConfig {
	s.MaxCountRule = v
	return s
}

// Request to execute a scheduled managed action immediately.
type ApplyEnvironmentManagedActionInput struct {
	_ struct{} `type:"structure"`

	// The action ID of the scheduled managed action to execute.
	//
	// ActionId is a required field
	ActionId *string `type:"string" required:"true"`

	// The environment ID of the target environment.
	EnvironmentId *string `type:"string"`

	// The name of the target environment.
	EnvironmentName *string `type:"string"`
}

// String returns the string representation
func (s ApplyEnvironmentManagedActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplyEnvironmentManagedActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplyEnvironmentManagedActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplyEnvironmentManagedActionInput"}
	if s.ActionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionId sets the ActionId field's value.
func (s *ApplyEnvironmentManagedActionInput) SetActionId(v string) *ApplyEnvironmentManagedActionInput {
	s.ActionId = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *ApplyEnvironmentManagedActionInput) SetEnvironmentId(v string) *ApplyEnvironmentManagedActionInput {
	s.EnvironmentId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *ApplyEnvironmentManagedActionInput) SetEnvironmentName(v string) *ApplyEnvironmentManagedActionInput {
	s.EnvironmentName = &v
	return s
}

// The result message containing information about the managed action.
type ApplyEnvironmentManagedActionOutput struct {
	_ struct{} `type:"structure"`

	// A description of the managed action.
	ActionDescription *string `type:"string"`

	// The action ID of the managed action.
	ActionId *string `type:"string"`

	// The type of managed action.
	ActionType *string `type:"string" enum:"ActionType"`

	// The status of the managed action.
	Status *string `type:"string"`
}

// String returns the string representation
func (s ApplyEnvironmentManagedActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplyEnvironmentManagedActionOutput) GoString() string {
	return s.String()
}

// SetActionDescription sets the ActionDescription field's value.
func (s *ApplyEnvironmentManagedActionOutput) SetActionDescription(v string) *ApplyEnvironmentManagedActionOutput {
	s.ActionDescription = &v
	return s
}

// SetActionId sets the ActionId field's value.
func (s *ApplyEnvironmentManagedActionOutput) SetActionId(v string) *ApplyEnvironmentManagedActionOutput {
	s.ActionId = &v
	return s
}

// SetActionType sets the ActionType field's value.
func (s *ApplyEnvironmentManagedActionOutput) SetActionType(v string) *ApplyEnvironmentManagedActionOutput {
	s.ActionType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ApplyEnvironmentManagedActionOutput) SetStatus(v string) *ApplyEnvironmentManagedActionOutput {
	s.Status = &v
	return s
}

// Request to add or change the operations role used by an environment.
type AssociateEnvironmentOperationsRoleInput struct {
	_ struct{} `type:"structure"`

	// The name of the environment to which to set the operations role.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `min:"4" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of an existing IAM role to be used as the
	// environment's operations role.
	//
	// OperationsRole is a required field
	OperationsRole *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateEnvironmentOperationsRoleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateEnvironmentOperationsRoleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateEnvironmentOperationsRoleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateEnvironmentOperationsRoleInput"}
	if s.EnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentName"))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 4))
	}
	if s.OperationsRole == nil {
		invalidParams.Add(request.NewErrParamRequired("OperationsRole"))
	}
	if s.OperationsRole != nil && len(*s.OperationsRole) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OperationsRole", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *AssociateEnvironmentOperationsRoleInput) SetEnvironmentName(v string) *AssociateEnvironmentOperationsRoleInput {
	s.EnvironmentName = &v
	return s
}

// SetOperationsRole sets the OperationsRole field's value.
func (s *AssociateEnvironmentOperationsRoleInput) SetOperationsRole(v string) *AssociateEnvironmentOperationsRoleInput {
	s.OperationsRole = &v
	return s
}

type AssociateEnvironmentOperationsRoleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateEnvironmentOperationsRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateEnvironmentOperationsRoleOutput) GoString() string {
	return s.String()
}

// Describes an Auto Scaling launch configuration.
type AutoScalingGroup struct {
	_ struct{} `type:"structure"`

	// The name of the AutoScalingGroup .
	Name *string `type:"string"`
}

// String returns the string representation
func (s AutoScalingGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoScalingGroup) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AutoScalingGroup) SetName(v string) *AutoScalingGroup {
	s.Name = &v
	return s
}

// Settings for an AWS CodeBuild build.
type BuildConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the artifact of the CodeBuild build. If provided, Elastic Beanstalk
	// stores the build artifact in the S3 location S3-bucket/resources/application-name/codebuild/codebuild-version-label-artifact-name.zip.
	// If not provided, Elastic Beanstalk stores the build artifact in the S3 location
	// S3-bucket/resources/application-name/codebuild/codebuild-version-label.zip.
	ArtifactName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that enables AWS CodeBuild to interact with dependent AWS services
	// on behalf of the AWS account.
	//
	// CodeBuildServiceRole is a required field
	CodeBuildServiceRole *string `type:"string" required:"true"`

	// Information about the compute resources the build project will use.
	//
	//    * BUILD_GENERAL1_SMALL: Use up to 3 GB memory and 2 vCPUs for builds
	//
	//    * BUILD_GENERAL1_MEDIUM: Use up to 7 GB memory and 4 vCPUs for builds
	//
	//    * BUILD_GENERAL1_LARGE: Use up to 15 GB memory and 8 vCPUs for builds
	ComputeType *string `type:"string" enum:"ComputeType"`

	// The ID of the Docker image to use for this build project.
	//
	// Image is a required field
	Image *string `type:"string" required:"true"`

	// How long in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until
	// timing out any related build that does not get marked as completed. The default
	// is 60 minutes.
	TimeoutInMinutes *int64 `type:"integer"`
}

// String returns the string representation
func (s BuildConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BuildConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BuildConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BuildConfiguration"}
	if s.CodeBuildServiceRole == nil {
		invalidParams.Add(request.NewErrParamRequired("CodeBuildServiceRole"))
	}
	if s.Image == nil {
		invalidParams.Add(request.NewErrParamRequired("Image"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArtifactName sets the ArtifactName field's value.
func (s *BuildConfiguration) SetArtifactName(v string) *BuildConfiguration {
	s.ArtifactName = &v
	return s
}

// SetCodeBuildServiceRole sets the CodeBuildServiceRole field's value.
func (s *BuildConfiguration) SetCodeBuildServiceRole(v string) *BuildConfiguration {
	s.CodeBuildServiceRole = &v
	return s
}

// SetComputeType sets the ComputeType field's value.
func (s *BuildConfiguration) SetComputeType(v string) *BuildConfiguration {
	s.ComputeType = &v
	return s
}

// SetImage sets the Image field's value.
func (s *BuildConfiguration) SetImage(v string) *BuildConfiguration {
	s.Image = &v
	return s
}

// SetTimeoutInMinutes sets the TimeoutInMinutes field's value.
func (s *BuildConfiguration) SetTimeoutInMinutes(v int64) *BuildConfiguration {
	s.TimeoutInMinutes = &v
	return s
}

// The builder used to build the custom platform.
type Builder struct {
	_ struct{} `type:"structure"`

	// The ARN of the builder.
	ARN *string `type:"string"`
}

// String returns the string representation
func (s Builder) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Builder) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *Builder) SetARN(v string) *Builder {
	s.ARN = &v
	return s
}

// CPU utilization metrics for an instance.
type CPUUtilization struct {
	_ struct{} `type:"structure"`

	// Available on Linux environments only.
	//
	// Percentage of time that the CPU has spent in the I/O Wait state over the
	// last 10 seconds.
	IOWait *float64 `type:"double"`

	// Available on Linux environments only.
	//
	// Percentage of time that the CPU has spent in the IRQ state over the last
	// 10 seconds.
	IRQ *float64 `type:"double"`

	// Percentage of time that the CPU has spent in the Idle state over the last
	// 10 seconds.
	Idle *float64 `type:"double"`

	// Available on Linux environments only.
	//
	// Percentage of time that the CPU has spent in the Nice state over the last
	// 10 seconds.
	Nice *float64 `type:"double"`

	// Available on Windows environments only.
	//
	// Percentage of time that the CPU has spent in the Privileged state over the
	// last 10 seconds.
	Privileged *float64 `type:"double"`

	// Available on Linux environments only.
	//
	// Percentage of time that the CPU has spent in the SoftIRQ state over the last
	// 10 seconds.
	SoftIRQ *float64 `type:"double"`

	// Available on Linux environments only.
	//
	// Percentage of time that the CPU has spent in the System state over the last
	// 10 seconds.
	System *float64 `type:"double"`

	// Percentage of time that the CPU has spent in the User state over the last
	// 10 seconds.
	User *float64 `type:"double"`
}

// String returns the string representation
func (s CPUUtilization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CPUUtilization) GoString() string {
	return s.String()
}

// SetIOWait sets the IOWait field's value.
func (s *CPUUtilization) SetIOWait(v float64) *CPUUtilization {
	s.IOWait = &v
	return s
}

// SetIRQ sets the IRQ field's value.
func (s *CPUUtilization) SetIRQ(v float64) *CPUUtilization {
	s.IRQ = &v
	return s
}

// SetIdle sets the Idle field's value.
func (s *CPUUtilization) SetIdle(v float64) *CPUUtilization {
	s.Idle = &v
	return s
}

// SetNice sets the Nice field's value.
func (s *CPUUtilization) SetNice(v float64) *CPUUtilization {
	s.Nice = &v
	return s
}

// SetPrivileged sets the Privileged field's value.
func (s *CPUUtilization) SetPrivileged(v float64) *CPUUtilization {
	s.Privileged = &v
	return s
}

// SetSoftIRQ sets the SoftIRQ field's value.
func (s *CPUUtilization) SetSoftIRQ(v float64) *CPUUtilization {
	s.SoftIRQ = &v
	return s
}

// SetSystem sets the System field's value.
func (s *CPUUtilization) SetSystem(v float64) *CPUUtilization {
	s.System = &v
	return s
}

// SetUser sets the User field's value.
func (s *CPUUtilization) SetUser(v float64) *CPUUtilization {
	s.User = &v
	return s
}

// Results message indicating whether a CNAME is available.
type CheckDNSAvailabilityInput struct {
	_ struct{} `type:"structure"`

	// The prefix used when this CNAME is reserved.
	//
	// CNAMEPrefix is a required field
	CNAMEPrefix *string `min:"4" type:"string" required:"true"`
}

// String returns the string representation
func (s CheckDNSAvailabilityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CheckDNSAvailabilityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CheckDNSAvailabilityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CheckDNSAvailabilityInput"}
	if s.CNAMEPrefix == nil {
		invalidParams.Add(request.NewErrParamRequired("CNAMEPrefix"))
	}
	if s.CNAMEPrefix != nil && len(*s.CNAMEPrefix) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("CNAMEPrefix", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCNAMEPrefix sets the CNAMEPrefix field's value.
func (s *CheckDNSAvailabilityInput) SetCNAMEPrefix(v string) *CheckDNSAvailabilityInput {
	s.CNAMEPrefix = &v
	return s
}

// Indicates if the specified CNAME is available.
type CheckDNSAvailabilityOutput struct {
	_ struct{} `type:"structure"`

	// Indicates if the specified CNAME is available:
	//
	//    * true : The CNAME is available.
	//
	//    * false : The CNAME is not available.
	Available *bool `type:"boolean"`

	// The fully qualified CNAME to reserve when CreateEnvironment is called with
	// the provided prefix.
	FullyQualifiedCNAME *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CheckDNSAvailabilityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CheckDNSAvailabilityOutput) GoString() string {
	return s.String()
}

// SetAvailable sets the Available field's value.
func (s *CheckDNSAvailabilityOutput) SetAvailable(v bool) *CheckDNSAvailabilityOutput {
	s.Available = &v
	return s
}

// SetFullyQualifiedCNAME sets the FullyQualifiedCNAME field's value.
func (s *CheckDNSAvailabilityOutput) SetFullyQualifiedCNAME(v string) *CheckDNSAvailabilityOutput {
	s.FullyQualifiedCNAME = &v
	return s
}

// Request to create or update a group of environments.
type ComposeEnvironmentsInput struct {
	_ struct{} `type:"structure"`

	// The name of the application to which the specified source bundles belong.
	ApplicationName *string `min:"1" type:"string"`

	// The name of the group to which the target environments belong. Specify a
	// group name only if the environment name defined in each target environment's
	// manifest ends with a + (plus) character. See Environment Manifest (env.yaml)
	// (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html)
	// for details.
	GroupName *string `min:"1" type:"string"`

	// A list of version labels, specifying one or more application source bundles
	// that belong to the target application. Each source bundle must include an
	// environment manifest that specifies the name of the environment and the name
	// of the solution stack to use, and optionally can specify environment links
	// to create.
	VersionLabels []*string `type:"list"`
}

// String returns the string representation
func (s ComposeEnvironmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComposeEnvironmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComposeEnvironmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComposeEnvironmentsInput"}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *ComposeEnvironmentsInput) SetApplicationName(v string) *ComposeEnvironmentsInput {
	s.ApplicationName = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *ComposeEnvironmentsInput) SetGroupName(v string) *ComposeEnvironmentsInput {
	s.GroupName = &v
	return s
}

// SetVersionLabels sets the VersionLabels field's value.
func (s *ComposeEnvironmentsInput) SetVersionLabels(v []*string) *ComposeEnvironmentsInput {
	s.VersionLabels = v
	return s
}

// Describes the possible values for a configuration option.
type ConfigurationOptionDescription struct {
	_ struct{} `type:"structure"`

	// An indication of which action is required if the value for this configuration
	// option changes:
	//
	//    * NoInterruption : There is no interruption to the environment or application
	//    availability.
	//
	//    * RestartEnvironment : The environment is entirely restarted, all AWS
	//    resources are deleted and recreated, and the environment is unavailable
	//    during the process.
	//
	//    * RestartApplicationServer : The environment is available the entire time.
	//    However, a short application outage occurs when the application servers
	//    on the running Amazon EC2 instances are restarted.
	ChangeSeverity *string `type:"string"`

	// The default value for this configuration option.
	DefaultValue *string `type:"string"`

	// If specified, the configuration option must be a string value no longer than
	// this value.
	MaxLength *int64 `type:"integer"`

	// If specified, the configuration option must be a numeric value less than
	// this value.
	MaxValue *int64 `type:"integer"`

	// If specified, the configuration option must be a numeric value greater than
	// this value.
	MinValue *int64 `type:"integer"`

	// The name of the configuration option.
	Name *string `type:"string"`

	// A unique namespace identifying the option's associated AWS resource.
	Namespace *string `type:"string"`

	// If specified, the configuration option must be a string value that satisfies
	// this regular expression.
	Regex *OptionRestrictionRegex `type:"structure"`

	// An indication of whether the user defined this configuration option:
	//
	//    * true : This configuration option was defined by the user. It is a valid
	//    choice for specifying if this as an Option to Remove when updating configuration
	//    settings.
	//
	//    * false : This configuration was not defined by the user.
	//
	// Constraint: You can remove only UserDefined options from a configuration.
	//
	// Valid Values: true | false
	UserDefined *bool `type:"boolean"`

	// If specified, values for the configuration option are selected from this
	// list.
	ValueOptions []*string `type:"list"`

	// An indication of which type of values this option has and whether it is allowable
	// to select one or more than one of the possible values:
	//
	//    * Scalar : Values for this option are a single selection from the possible
	//    values, or an unformatted string, or numeric value governed by the MIN/MAX/Regex
	//    constraints.
	//
	//    * List : Values for this option are multiple selections from the possible
	//    values.
	//
	//    * Boolean : Values for this option are either true or false .
	//
	//    * Json : Values for this option are a JSON representation of a ConfigDocument.
	ValueType *string `type:"string" enum:"ConfigurationOptionValueType"`
}

// String returns the string representation
func (s ConfigurationOptionDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigurationOptionDescription) GoString() string {
	return s.String()
}

// SetChangeSeverity sets the ChangeSeverity field's value.
func (s *ConfigurationOptionDescription) SetChangeSeverity(v string) *ConfigurationOptionDescription {
	s.ChangeSeverity = &v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *ConfigurationOptionDescription) SetDefaultValue(v string) *ConfigurationOptionDescription {
	s.DefaultValue = &v
	return s
}

// SetMaxLength sets the MaxLength field's value.
func (s *ConfigurationOptionDescription) SetMaxLength(v int64) *ConfigurationOptionDescription {
	s.MaxLength = &v
	return s
}

// SetMaxValue sets the MaxValue field's value.
func (s *ConfigurationOptionDescription) SetMaxValue(v int64) *ConfigurationOptionDescription {
	s.MaxValue = &v
	return s
}

// SetMinValue sets the MinValue field's value.
func (s *ConfigurationOptionDescription) SetMinValue(v int64) *ConfigurationOptionDescription {
	s.MinValue = &v
	return s
}

// SetName sets the Name field's value.
func (s *ConfigurationOptionDescription) SetName(v string) *ConfigurationOptionDescription {
	s.Name = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ConfigurationOptionDescription) SetNamespace(v string) *ConfigurationOptionDescription {
	s.Namespace = &v
	return s
}

// SetRegex sets the Regex field's value.
func (s *ConfigurationOptionDescription) SetRegex(v *OptionRestrictionRegex) *ConfigurationOptionDescription {
	s.Regex = v
	return s
}

// SetUserDefined sets the UserDefined field's value.
func (s *ConfigurationOptionDescription) SetUserDefined(v bool) *ConfigurationOptionDescription {
	s.UserDefined = &v
	return s
}

// SetValueOptions sets the ValueOptions field's value.
func (s *ConfigurationOptionDescription) SetValueOptions(v []*string) *ConfigurationOptionDescription {
	s.ValueOptions = v
	return s
}

// SetValueType sets the ValueType field's value.
func (s *ConfigurationOptionDescription) SetValueType(v string) *ConfigurationOptionDescription {
	s.ValueType = &v
	return s
}

// A specification identifying an individual configuration option along with
// its current value. For a list of possible namespaces and option values, see
// Option Values (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html)
// in the AWS Elastic Beanstalk Developer Guide.
type ConfigurationOptionSetting struct {
	_ struct{} `type:"structure"`

	// A unique namespace that identifies the option's associated AWS resource.
	Namespace *string `type:"string"`

	// The name of the configuration option.
	OptionName *string `type:"string"`

	// A unique resource name for the option setting. Use it for a time–based
	// scaling configuration option.
	ResourceName *string `min:"1" type:"string"`

	// The current value for the configuration option.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ConfigurationOptionSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigurationOptionSetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigurationOptionSetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigurationOptionSetting"}
	if s.ResourceName != nil && len(*s.ResourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNamespace sets the Namespace field's value.
func (s *ConfigurationOptionSetting) SetNamespace(v string) *ConfigurationOptionSetting {
	s.Namespace = &v
	return s
}

// SetOptionName sets the OptionName field's value.
func (s *ConfigurationOptionSetting) SetOptionName(v string) *ConfigurationOptionSetting {
	s.OptionName = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *ConfigurationOptionSetting) SetResourceName(v string) *ConfigurationOptionSetting {
	s.ResourceName = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ConfigurationOptionSetting) SetValue(v string) *ConfigurationOptionSetting {
	s.Value = &v
	return s
}

// Describes the settings for a configuration set.
type ConfigurationSettingsDescription struct {
	_ struct{} `type:"structure"`

	// The name of the application associated with this configuration set.
	ApplicationName *string `min:"1" type:"string"`

	// The date (in UTC time) when this configuration set was created.
	DateCreated *time.Time `type:"timestamp"`

	// The date (in UTC time) when this configuration set was last modified.
	DateUpdated *time.Time `type:"timestamp"`

	// If this configuration set is associated with an environment, the DeploymentStatus
	// parameter indicates the deployment status of this configuration set:
	//
	//    * null: This configuration is not associated with a running environment.
	//
	//    * pending: This is a draft configuration that is not deployed to the associated
	//    environment but is in the process of deploying.
	//
	//    * deployed: This is the configuration that is currently deployed to the
	//    associated running environment.
	//
	//    * failed: This is a draft configuration that failed to successfully deploy.
	DeploymentStatus *string `type:"string" enum:"ConfigurationDeploymentStatus"`

	// Describes this configuration set.
	Description *string `type:"string"`

	// If not null, the name of the environment for this configuration set.
	EnvironmentName *string `min:"4" type:"string"`

	// A list of the configuration options and their values in this configuration
	// set.
	OptionSettings []*ConfigurationOptionSetting `type:"list"`

	// The ARN of the platform version.
	PlatformArn *string `type:"string"`

	// The name of the solution stack this configuration set uses.
	SolutionStackName *string `type:"string"`

	// If not null, the name of the configuration template for this configuration
	// set.
	TemplateName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ConfigurationSettingsDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigurationSettingsDescription) GoString() string {
	return s.String()
}

// SetApplicationName sets the ApplicationName field's value.
func (s *ConfigurationSettingsDescription) SetApplicationName(v string) *ConfigurationSettingsDescription {
	s.ApplicationName = &v
	return s
}

// SetDateCreated sets the DateCreated field's value.
func (s *ConfigurationSettingsDescription) SetDateCreated(v time.Time) *ConfigurationSettingsDescription {
	s.DateCreated = &v
	return s
}

// SetDateUpdated sets the DateUpdated field's value.
func (s *ConfigurationSettingsDescription) SetDateUpdated(v time.Time) *ConfigurationSettingsDescription {
	s.DateUpdated = &v
	return s
}

// SetDeploymentStatus sets the DeploymentStatus field's value.
func (s *ConfigurationSettingsDescription) SetDeploymentStatus(v string) *ConfigurationSettingsDescription {
	s.DeploymentStatus = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ConfigurationSettingsDescription) SetDescription(v string) *ConfigurationSettingsDescription {
	s.Description = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *ConfigurationSettingsDescription) SetEnvironmentName(v string) *ConfigurationSettingsDescription {
	s.EnvironmentName = &v
	return s
}

// SetOptionSettings sets the OptionSettings field's value.
func (s *ConfigurationSettingsDescription) SetOptionSettings(v []*ConfigurationOptionSetting) *ConfigurationSettingsDescription {
	s.OptionSettings = v
	return s
}

// SetPlatformArn sets the PlatformArn field's value.
func (s *ConfigurationSettingsDescription) SetPlatformArn(v string) *ConfigurationSettingsDescription {
	s.PlatformArn = &v
	return s
}

// SetSolutionStackName sets the SolutionStackName field's value.
func (s *ConfigurationSettingsDescription) SetSolutionStackName(v string) *ConfigurationSettingsDescription {
	s.SolutionStackName = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *ConfigurationSettingsDescription) SetTemplateName(v string) *ConfigurationSettingsDescription {
	s.TemplateName = &v
	return s
}

// Request to create an application.
type CreateApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name of the application. Must be unique within your account.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Your description of the application.
	Description *string `type:"string"`

	// Specifies an application resource lifecycle configuration to prevent your
	// application from accumulating too many versions.
	ResourceLifecycleConfig *ApplicationResourceLifecycleConfig `type:"structure"`

	// Specifies the tags applied to the application.
	//
	// Elastic Beanstalk applies these tags only to the application. Environments
	// that you create in the application don't inherit the tags.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.ResourceLifecycleConfig != nil {
		if err := s.ResourceLifecycleConfig.Validate(); err != nil {
			invalidParams.AddNested("ResourceLifecycleConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *CreateApplicationInput) SetApplicationName(v string) *CreateApplicationInput {
	s.ApplicationName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateApplicationInput) SetDescription(v string) *CreateApplicationInput {
	s.Description = &v
	return s
}

// SetResourceLifecycleConfig sets the ResourceLifecycleConfig field's value.
func (s *CreateApplicationInput) SetResourceLifecycleConfig(v *ApplicationResourceLifecycleConfig) *CreateApplicationInput {
	s.ResourceLifecycleConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateApplicationInput) SetTags(v []*Tag) *CreateApplicationInput {
	s.Tags = v
	return s
}

type CreateApplicationVersionInput struct {
	_ struct{} `type:"structure"`

	// The name of the application. If no application is found with this name, and
	// AutoCreateApplication is false, returns an InvalidParameterValue error.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Set to true to create an application with the specified name if it doesn't
	// already exist.
	AutoCreateApplication *bool `type:"boolean"`

	// Settings for an AWS CodeBuild build.
	BuildConfiguration *BuildConfiguration `type:"structure"`

	// A description of this application version.
	Description *string `type:"string"`

	// Pre-processes and validates the environment manifest (env.yaml) and configuration
	// files (*.config files in the .ebextensions folder) in the source bundle.
	// Validating configuration files can identify issues prior to deploying the
	// application version to an environment.
	//
	// You must turn processing on for application versions that you create using
	// AWS CodeBuild or AWS CodeCommit. For application versions built from a source
	// bundle in Amazon S3, processing is optional.
	//
	// The Process option validates Elastic Beanstalk configuration files. It doesn't
	// validate your application's configuration files, like proxy server or Docker
	// configuration.
	Process *bool `type:"boolean"`

	// Specify a commit in an AWS CodeCommit Git repository to use as the source
	// code for the application version.
	SourceBuildInformation *SourceBuildInformation `type:"structure"`

	// The Amazon S3 bucket and key that identify the location of the source bundle
	// for this version.
	//
	// The Amazon S3 bucket must be in the same region as the environment.
	//
	// Specify a source bundle in S3 or a commit in an AWS CodeCommit repository
	// (with SourceBuildInformation), but not both. If neither SourceBundle nor
	// SourceBuildInformation are provided, Elastic Beanstalk uses a sample application.
	SourceBundle *S3Location `type:"structure"`

	// Specifies the tags applied to the application version.
	//
	// Elastic Beanstalk applies these tags only to the application version. Environments
	// that use the application version don't inherit the tags.
	Tags []*Tag `type:"list"`

	// A label identifying this version.
	//
	// Constraint: Must be unique per application. If an application version already
	// exists with this label for the specified application, AWS Elastic Beanstalk
	// returns an InvalidParameterValue error.
	//
	// VersionLabel is a required field
	VersionLabel *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateApplicationVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationVersionInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.VersionLabel == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionLabel"))
	}
	if s.VersionLabel != nil && len(*s.VersionLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionLabel", 1))
	}
	if s.BuildConfiguration != nil {
		if err := s.BuildConfiguration.Validate(); err != nil {
			invalidParams.AddNested("BuildConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SourceBuildInformation != nil {
		if err := s.SourceBuildInformation.Validate(); err != nil {
			invalidParams.AddNested("SourceBuildInformation", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *CreateApplicationVersionInput) SetApplicationName(v string) *CreateApplicationVersionInput {
	s.ApplicationName = &v
	return s
}

// SetAutoCreateApplication sets the AutoCreateApplication field's value.
func (s *CreateApplicationVersionInput) SetAutoCreateApplication(v bool) *CreateApplicationVersionInput {
	s.AutoCreateApplication = &v
	return s
}

// SetBuildConfiguration sets the BuildConfiguration field's value.
func (s *CreateApplicationVersionInput) SetBuildConfiguration(v *BuildConfiguration) *CreateApplicationVersionInput {
	s.BuildConfiguration = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateApplicationVersionInput) SetDescription(v string) *CreateApplicationVersionInput {
	s.Description = &v
	return s
}

// SetProcess sets the Process field's value.
func (s *CreateApplicationVersionInput) SetProcess(v bool) *CreateApplicationVersionInput {
	s.Process = &v
	return s
}

// SetSourceBuildInformation sets the SourceBuildInformation field's value.
func (s *CreateApplicationVersionInput) SetSourceBuildInformation(v *SourceBuildInformation) *CreateApplicationVersionInput {
	s.SourceBuildInformation = v
	return s
}

// SetSourceBundle sets the SourceBundle field's value.
func (s *CreateApplicationVersionInput) SetSourceBundle(v *S3Location) *CreateApplicationVersionInput {
	s.SourceBundle = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateApplicationVersionInput) SetTags(v []*Tag) *CreateApplicationVersionInput {
	s.Tags = v
	return s
}

// SetVersionLabel sets the VersionLabel field's value.
func (s *CreateApplicationVersionInput) SetVersionLabel(v string) *CreateApplicationVersionInput {
	s.VersionLabel = &v
	return s
}

// Request to create a configuration template.
type CreateConfigurationTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the Elastic Beanstalk application to associate with this configuration
	// template.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// An optional description for this configuration.
	Description *string `type:"string"`

	// The ID of an environment whose settings you want to use to create the configuration
	// template. You must specify EnvironmentId if you don't specify PlatformArn,
	// SolutionStackName, or SourceConfiguration.
	EnvironmentId *string `type:"string"`

	// Option values for the Elastic Beanstalk configuration, such as the instance
	// type. If specified, these values override the values obtained from the solution
	// stack or the source configuration template. For a complete list of Elastic
	// Beanstalk configuration options, see Option Values (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html)
	// in the AWS Elastic Beanstalk Developer Guide.
	OptionSettings []*ConfigurationOptionSetting `type:"list"`

	// The Amazon Resource Name (ARN) of the custom platform. For more information,
	// see Custom Platforms (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html)
	// in the AWS Elastic Beanstalk Developer Guide.
	//
	// If you specify PlatformArn, then don't specify SolutionStackName.
	PlatformArn *string `type:"string"`

	// The name of an Elastic Beanstalk solution stack (platform version) that this
	// configuration uses. For example, 64bit Amazon Linux 2013.09 running Tomcat
	// 7 Java 7. A solution stack specifies the operating system, runtime, and application
	// server for a configuration template. It also determines the set of configuration
	// options as well as the possible and default values. For more information,
	// see Supported Platforms (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html)
	// in the AWS Elastic Beanstalk Developer Guide.
	//
	// You must specify SolutionStackName if you don't specify PlatformArn, EnvironmentId,
	// or SourceConfiguration.
	//
	// Use the ListAvailableSolutionStacks (https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListAvailableSolutionStacks.html)
	// API to obtain a list of available solution stacks.
	SolutionStackName *string `type:"string"`

	// An Elastic Beanstalk configuration template to base this one on. If specified,
	// Elastic Beanstalk uses the configuration values from the specified configuration
	// template to create a new configuration.
	//
	// Values specified in OptionSettings override any values obtained from the
	// SourceConfiguration.
	//
	// You must specify SourceConfiguration if you don't specify PlatformArn, EnvironmentId,
	// or SolutionStackName.
	//
	// Constraint: If both solution stack name and source configuration are specified,
	// the solution stack of the source configuration template must match the specified
	// solution stack name.
	SourceConfiguration *SourceConfiguration `type:"structure"`

	// Specifies the tags applied to the configuration template.
	Tags []*Tag `type:"list"`

	// The name of the configuration template.
	//
	// Constraint: This name must be unique per application.
	//
	// TemplateName is a required field
	TemplateName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateConfigurationTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConfigurationTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfigurationTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConfigurationTemplateInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}
	if s.OptionSettings != nil {
		for i, v := range s.OptionSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OptionSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SourceConfiguration != nil {
		if err := s.SourceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SourceConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *CreateConfigurationTemplateInput) SetApplicationName(v string) *CreateConfigurationTemplateInput {
	s.ApplicationName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateConfigurationTemplateInput) SetDescription(v string) *CreateConfigurationTemplateInput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateConfigurationTemplateInput) SetEnvironmentId(v string) *CreateConfigurationTemplateInput {
	s.EnvironmentId = &v
	return s
}

// SetOptionSettings sets the OptionSettings field's value.
func (s *CreateConfigurationTemplateInput) SetOptionSettings(v []*ConfigurationOptionSetting) *CreateConfigurationTemplateInput {
	s.OptionSettings = v
	return s
}

// SetPlatformArn sets the PlatformArn field's value.
func (s *CreateConfigurationTemplateInput) SetPlatformArn(v string) *CreateConfigurationTemplateInput {
	s.PlatformArn = &v
	return s
}

// SetSolutionStackName sets the SolutionStackName field's value.
func (s *CreateConfigurationTemplateInput) SetSolutionStackName(v string) *CreateConfigurationTemplateInput {
	s.SolutionStackName = &v
	return s
}

// SetSourceConfiguration sets the SourceConfiguration field's value.
func (s *CreateConfigurationTemplateInput) SetSourceConfiguration(v *SourceConfiguration) *CreateConfigurationTemplateInput {
	s.SourceConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateConfigurationTemplateInput) SetTags(v []*Tag) *CreateConfigurationTemplateInput {
	s.Tags = v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *CreateConfigurationTemplateInput) SetTemplateName(v string) *CreateConfigurationTemplateInput {
	s.TemplateName = &v
	return s
}

type CreateEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The name of the application that is associated with this environment.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// If specified, the environment attempts to use this value as the prefix for
	// the CNAME in your Elastic Beanstalk environment URL. If not specified, the
	// CNAME is generated automatically by appending a random alphanumeric string
	// to the environment name.
	CNAMEPrefix *string `min:"4" type:"string"`

	// Your description for this environment.
	Description *string `type:"string"`

	// A unique name for the environment.
	//
	// Constraint: Must be from 4 to 40 characters in length. The name can contain
	// only letters, numbers, and hyphens. It can't start or end with a hyphen.
	// This name must be unique within a region in your account. If the specified
	// name already exists in the region, Elastic Beanstalk returns an InvalidParameterValue
	// error.
	//
	// If you don't specify the CNAMEPrefix parameter, the environment name becomes
	// part of the CNAME, and therefore part of the visible URL for your application.
	EnvironmentName *string `min:"4" type:"string"`

	// The name of the group to which the target environment belongs. Specify a
	// group name only if the environment's name is specified in an environment
	// manifest and not with the environment name parameter. See Environment Manifest
	// (env.yaml) (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html)
	// for details.
	GroupName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of an existing IAM role to be used as the
	// environment's operations role. If specified, Elastic Beanstalk uses the operations
	// role for permissions to downstream services during this call and during subsequent
	// calls acting on this environment. To specify an operations role, you must
	// have the iam:PassRole permission for the role. For more information, see
	// Operations roles (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html)
	// in the AWS Elastic Beanstalk Developer Guide.
	OperationsRole *string `min:"1" type:"string"`

	// If specified, AWS Elastic Beanstalk sets the specified configuration options
	// to the requested value in the configuration set for the new environment.
	// These override the values obtained from the solution stack or the configuration
	// template.
	OptionSettings []*ConfigurationOptionSetting `type:"list"`

	// A list of custom user-defined configuration options to remove from the configuration
	// set for this new environment.
	OptionsToRemove []*OptionSpecification `type:"list"`

	// The Amazon Resource Name (ARN) of the custom platform to use with the environment.
	// For more information, see Custom Platforms (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html)
	// in the AWS Elastic Beanstalk Developer Guide.
	//
	// If you specify PlatformArn, don't specify SolutionStackName.
	PlatformArn *string `type:"string"`

	// The name of an Elastic Beanstalk solution stack (platform version) to use
	// with the environment. If specified, Elastic Beanstalk sets the configuration
	// values to the default values associated with the specified solution stack.
	// For a list of current solution stacks, see Elastic Beanstalk Supported Platforms
	// (https://docs.aws.amazon.com/elasticbeanstalk/latest/platforms/platforms-supported.html)
	// in the AWS Elastic Beanstalk Platforms guide.
	//
	// If you specify SolutionStackName, don't specify PlatformArn or TemplateName.
	SolutionStackName *string `type:"string"`

	// Specifies the tags applied to resources in the environment.
	Tags []*Tag `type:"list"`

	// The name of the Elastic Beanstalk configuration template to use with the
	// environment.
	//
	// If you specify TemplateName, then don't specify SolutionStackName.
	TemplateName *string `min:"1" type:"string"`

	// Specifies the tier to use in creating this environment. The environment tier
	// that you choose determines whether Elastic Beanstalk provisions resources
	// to support a web application that handles HTTP(S) requests or a web application
	// that handles background-processing tasks.
	Tier *EnvironmentTier `type:"structure"`

	// The name of the application version to deploy.
	//
	// Default: If not specified, Elastic Beanstalk attempts to deploy the sample
	// application.
	VersionLabel *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEnvironmentInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.CNAMEPrefix != nil && len(*s.CNAMEPrefix) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("CNAMEPrefix", 4))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 4))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.OperationsRole != nil && len(*s.OperationsRole) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OperationsRole", 1))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}
	if s.VersionLabel != nil && len(*s.VersionLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionLabel", 1))
	}
	if s.OptionSettings != nil {
		for i, v := range s.OptionSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OptionSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OptionsToRemove != nil {
		for i, v := range s.OptionsToRemove {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OptionsToRemove", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *CreateEnvironmentInput) SetApplicationName(v string) *CreateEnvironmentInput {
	s.ApplicationName = &v
	return s
}

// SetCNAMEPrefix sets the CNAMEPrefix field's value.
func (s *CreateEnvironmentInput) SetCNAMEPrefix(v string) *CreateEnvironmentInput {
	s.CNAMEPrefix = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateEnvironmentInput) SetDescription(v string) *CreateEnvironmentInput {
	s.Description = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *CreateEnvironmentInput) SetEnvironmentName(v string) *CreateEnvironmentInput {
	s.EnvironmentName = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *CreateEnvironmentInput) SetGroupName(v string) *CreateEnvironmentInput {
	s.GroupName = &v
	return s
}

// SetOperationsRole sets the OperationsRole field's value.
func (s *CreateEnvironmentInput) SetOperationsRole(v string) *CreateEnvironmentInput {
	s.OperationsRole = &v
	return s
}

// SetOptionSettings sets the OptionSettings field's value.
func (s *CreateEnvironmentInput) SetOptionSettings(v []*ConfigurationOptionSetting) *CreateEnvironmentInput {
	s.OptionSettings = v
	return s
}

// SetOptionsToRemove sets the OptionsToRemove field's value.
func (s *CreateEnvironmentInput) SetOptionsToRemove(v []*OptionSpecification) *CreateEnvironmentInput {
	s.OptionsToRemove = v
	return s
}

// SetPlatformArn sets the PlatformArn field's value.
func (s *CreateEnvironmentInput) SetPlatformArn(v string) *CreateEnvironmentInput {
	s.PlatformArn = &v
	return s
}

// SetSolutionStackName sets the SolutionStackName field's value.
func (s *CreateEnvironmentInput) SetSolutionStackName(v string) *CreateEnvironmentInput {
	s.SolutionStackName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEnvironmentInput) SetTags(v []*Tag) *CreateEnvironmentInput {
	s.Tags = v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *CreateEnvironmentInput) SetTemplateName(v string) *CreateEnvironmentInput {
	s.TemplateName = &v
	return s
}

// SetTier sets the Tier field's value.
func (s *CreateEnvironmentInput) SetTier(v *EnvironmentTier) *CreateEnvironmentInput {
	s.Tier = v
	return s
}

// SetVersionLabel sets the VersionLabel field's value.
func (s *CreateEnvironmentInput) SetVersionLabel(v string) *CreateEnvironmentInput {
	s.VersionLabel = &v
	return s
}

// Request to create a new platform version.
type CreatePlatformVersionInput struct {
	_ struct{} `type:"structure"`

	// The name of the builder environment.
	EnvironmentName *string `min:"4" type:"string"`

	// The configuration option settings to apply to the builder environment.
	OptionSettings []*ConfigurationOptionSetting `type:"list"`

	// The location of the platform definition archive in Amazon S3.
	//
	// PlatformDefinitionBundle is a required field
	PlatformDefinitionBundle *S3Location `type:"structure" required:"true"`

	// The name of your custom platform.
	//
	// PlatformName is a required field
	PlatformName *string `type:"string" required:"true"`

	// The number, such as 1.0.2, for the new platform version.
	//
	// PlatformVersion is a required field
	PlatformVersion *string `type:"string" required:"true"`

	// Specifies the tags applied to the new platform version.
	//
	// Elastic Beanstalk applies these tags only to the platform version. Environments
	// that you create using the platform version don't inherit the tags.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreatePlatformVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlatformVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePlatformVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePlatformVersionInput"}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 4))
	}
	if s.PlatformDefinitionBundle == nil {
		invalidParams.Add(request.NewErrParamRequired("PlatformDefinitionBundle"))
	}
	if s.PlatformName == nil {
		invalidParams.Add(request.NewErrParamRequired("PlatformName"))
	}
	if s.PlatformVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("PlatformVersion"))
	}
	if s.OptionSettings != nil {
		for i, v := range s.OptionSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OptionSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *CreatePlatformVersionInput) SetEnvironmentName(v string) *CreatePlatformVersionInput {
	s.EnvironmentName = &v
	return s
}

// SetOptionSettings sets the OptionSettings field's value.
func (s *CreatePlatformVersionInput) SetOptionSettings(v []*ConfigurationOptionSetting) *CreatePlatformVersionInput {
	s.OptionSettings = v
	return s
}

// SetPlatformDefinitionBundle sets the PlatformDefinitionBundle field's value.
func (s *CreatePlatformVersionInput) SetPlatformDefinitionBundle(v *S3Location) *CreatePlatformVersionInput {
	s.PlatformDefinitionBundle = v
	return s
}

// SetPlatformName sets the PlatformName field's value.
func (s *CreatePlatformVersionInput) SetPlatformName(v string) *CreatePlatformVersionInput {
	s.PlatformName = &v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *CreatePlatformVersionInput) SetPlatformVersion(v string) *CreatePlatformVersionInput {
	s.PlatformVersion = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePlatformVersionInput) SetTags(v []*Tag) *CreatePlatformVersionInput {
	s.Tags = v
	return s
}

type CreatePlatformVersionOutput struct {
	_ struct{} `type:"structure"`

	// The builder used to create the custom platform.
	Builder *Builder `type:"structure"`

	// Detailed information about the new version of the custom platform.
	PlatformSummary *PlatformSummary `type:"structure"`
}

// String returns the string representation
func (s CreatePlatformVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlatformVersionOutput) GoString() string {
	return s.String()
}

// SetBuilder sets the Builder field's value.
func (s *CreatePlatformVersionOutput) SetBuilder(v *Builder) *CreatePlatformVersionOutput {
	s.Builder = v
	return s
}

// SetPlatformSummary sets the PlatformSummary field's value.
func (s *CreatePlatformVersionOutput) SetPlatformSummary(v *PlatformSummary) *CreatePlatformVersionOutput {
	s.PlatformSummary = v
	return s
}

type CreateStorageLocationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateStorageLocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStorageLocationInput) GoString() string {
	return s.String()
}

// Results of a CreateStorageLocationResult call.
type CreateStorageLocationOutput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket created.
	S3Bucket *string `type:"string"`
}

// String returns the string representation
func (s CreateStorageLocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStorageLocationOutput) GoString() string {
	return s.String()
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *CreateStorageLocationOutput) SetS3Bucket(v string) *CreateStorageLocationOutput {
	s.S3Bucket = &v
	return s
}

// A custom AMI available to platforms.
type CustomAmi struct {
	_ struct{} `type:"structure"`

	// THe ID of the image used to create the custom AMI.
	ImageId *string `type:"string"`

	// The type of virtualization used to create the custom AMI.
	VirtualizationType *string `type:"string"`
}

// String returns the string representation
func (s CustomAmi) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomAmi) GoString() string {
	return s.String()
}

// SetImageId sets the ImageId field's value.
func (s *CustomAmi) SetImageId(v string) *CustomAmi {
	s.ImageId = &v
	return s
}

// SetVirtualizationType sets the VirtualizationType field's value.
func (s *CustomAmi) SetVirtualizationType(v string) *CustomAmi {
	s.VirtualizationType = &v
	return s
}

// Request to delete an application.
type DeleteApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name of the application to delete.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// When set to true, running environments will be terminated before deleting
	// the application.
	TerminateEnvByForce *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DeleteApplicationInput) SetApplicationName(v string) *DeleteApplicationInput {
	s.ApplicationName = &v
	return s
}

// SetTerminateEnvByForce sets the TerminateEnvByForce field's value.
func (s *DeleteApplicationInput) SetTerminateEnvByForce(v bool) *DeleteApplicationInput {
	s.TerminateEnvByForce = &v
	return s
}

type DeleteApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationOutput) GoString() string {
	return s.String()
}

// Request to delete an application version.
type DeleteApplicationVersionInput struct {
	_ struct{} `type:"structure"`

	// The name of the application to which the version belongs.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Set to true to delete the source bundle from your storage bucket. Otherwise,
	// the application version is deleted only from Elastic Beanstalk and the source
	// bundle remains in Amazon S3.
	DeleteSourceBundle *bool `type:"boolean"`

	// The label of the version to delete.
	//
	// VersionLabel is a required field
	VersionLabel *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApplicationVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationVersionInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.VersionLabel == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionLabel"))
	}
	if s.VersionLabel != nil && len(*s.VersionLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionLabel", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DeleteApplicationVersionInput) SetApplicationName(v string) *DeleteApplicationVersionInput {
	s.ApplicationName = &v
	return s
}

// SetDeleteSourceBundle sets the DeleteSourceBundle field's value.
func (s *DeleteApplicationVersionInput) SetDeleteSourceBundle(v bool) *DeleteApplicationVersionInput {
	s.DeleteSourceBundle = &v
	return s
}

// SetVersionLabel sets the VersionLabel field's value.
func (s *DeleteApplicationVersionInput) SetVersionLabel(v string) *DeleteApplicationVersionInput {
	s.VersionLabel = &v
	return s
}

type DeleteApplicationVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteApplicationVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationVersionOutput) GoString() string {
	return s.String()
}

// Request to delete a configuration template.
type DeleteConfigurationTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the application to delete the configuration template from.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The name of the configuration template to delete.
	//
	// TemplateName is a required field
	TemplateName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConfigurationTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigurationTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigurationTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfigurationTemplateInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DeleteConfigurationTemplateInput) SetApplicationName(v string) *DeleteConfigurationTemplateInput {
	s.ApplicationName = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *DeleteConfigurationTemplateInput) SetTemplateName(v string) *DeleteConfigurationTemplateInput {
	s.TemplateName = &v
	return s
}

type DeleteConfigurationTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteConfigurationTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigurationTemplateOutput) GoString() string {
	return s.String()
}

// Request to delete a draft environment configuration.
type DeleteEnvironmentConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the application the environment is associated with.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The name of the environment to delete the draft configuration from.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `min:"4" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEnvironmentConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEnvironmentConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEnvironmentConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEnvironmentConfigurationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.EnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentName"))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DeleteEnvironmentConfigurationInput) SetApplicationName(v string) *DeleteEnvironmentConfigurationInput {
	s.ApplicationName = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *DeleteEnvironmentConfigurationInput) SetEnvironmentName(v string) *DeleteEnvironmentConfigurationInput {
	s.EnvironmentName = &v
	return s
}

type DeleteEnvironmentConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEnvironmentConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEnvironmentConfigurationOutput) GoString() string {
	return s.String()
}

type DeletePlatformVersionInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the version of the custom platform.
	PlatformArn *string `type:"string"`
}

// String returns the string representation
func (s DeletePlatformVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePlatformVersionInput) GoString() string {
	return s.String()
}

// SetPlatformArn sets the PlatformArn field's value.
func (s *DeletePlatformVersionInput) SetPlatformArn(v string) *DeletePlatformVersionInput {
	s.PlatformArn = &v
	return s
}

type DeletePlatformVersionOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about the version of the custom platform.
	PlatformSummary *PlatformSummary `type:"structure"`
}

// String returns the string representation
func (s DeletePlatformVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePlatformVersionOutput) GoString() string {
	return s.String()
}

// SetPlatformSummary sets the PlatformSummary field's value.
func (s *DeletePlatformVersionOutput) SetPlatformSummary(v *PlatformSummary) *DeletePlatformVersionOutput {
	s.PlatformSummary = v
	return s
}

// Information about an application version deployment.
type Deployment struct {
	_ struct{} `type:"structure"`

	// The ID of the deployment. This number increases by one each time that you
	// deploy source code or change instance configuration settings.
	DeploymentId *int64 `type:"long"`

	// For in-progress deployments, the time that the deployment started.
	//
	// For completed deployments, the time that the deployment ended.
	DeploymentTime *time.Time `type:"timestamp"`

	// The status of the deployment:
	//
	//    * In Progress : The deployment is in progress.
	//
	//    * Deployed : The deployment succeeded.
	//
	//    * Failed : The deployment failed.
	Status *string `type:"string"`

	// The version label of the application version in the deployment.
	VersionLabel *string `type:"string"`
}

// String returns the string representation
func (s Deployment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Deployment) GoString() string {
	return s.String()
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *Deployment) SetDeploymentId(v int64) *Deployment {
	s.DeploymentId = &v
	return s
}

// SetDeploymentTime sets the DeploymentTime field's value.
func (s *Deployment) SetDeploymentTime(v time.Time) *Deployment {
	s.DeploymentTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Deployment) SetStatus(v string) *Deployment {
	s.Status = &v
	return s
}

// SetVersionLabel sets the VersionLabel field's value.
func (s *Deployment) SetVersionLabel(v string) *Deployment {
	s.VersionLabel = &v
	return s
}

type DescribeAccountAttributesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeAccountAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAttributesInput) GoString() string {
	return s.String()
}

type DescribeAccountAttributesOutput struct {
	_ struct{} `type:"structure"`

	// The Elastic Beanstalk resource quotas associated with the calling AWS account.
	ResourceQuotas *ResourceQuotas `type:"structure"`
}

// String returns the string representation
func (s DescribeAccountAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAttributesOutput) GoString() string {
	return s.String()
}

// SetResourceQuotas sets the ResourceQuotas field's value.
func (s *DescribeAccountAttributesOutput) SetResourceQuotas(v *ResourceQuotas) *DescribeAccountAttributesOutput {
	s.ResourceQuotas = v
	return s
}

// Request to describe application versions.
type DescribeApplicationVersionsInput struct {
	_ struct{} `type:"structure"`

	// Specify an application name to show only application versions for that application.
	ApplicationName *string `min:"1" type:"string"`

	// For a paginated request. Specify a maximum number of application versions
	// to include in each response.
	//
	// If no MaxRecords is specified, all available application versions are retrieved
	// in a single response.
	MaxRecords *int64 `min:"1" type:"integer"`

	// For a paginated request. Specify a token from a previous response page to
	// retrieve the next response page. All other parameter values must be identical
	// to the ones specified in the initial request.
	//
	// If no NextToken is specified, the first page is retrieved.
	NextToken *string `type:"string"`

	// Specify a version label to show a specific application version.
	VersionLabels []*string `type:"list"`
}

// String returns the string representation
func (s DescribeApplicationVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeApplicationVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeApplicationVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeApplicationVersionsInput"}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.MaxRecords != nil && *s.MaxRecords < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRecords", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DescribeApplicationVersionsInput) SetApplicationName(v string) *DescribeApplicationVersionsInput {
	s.ApplicationName = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeApplicationVersionsInput) SetMaxRecords(v int64) *DescribeApplicationVersionsInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeApplicationVersionsInput) SetNextToken(v string) *DescribeApplicationVersionsInput {
	s.NextToken = &v
	return s
}

// SetVersionLabels sets the VersionLabels field's value.
func (s *DescribeApplicationVersionsInput) SetVersionLabels(v []*string) *DescribeApplicationVersionsInput {
	s.VersionLabels = v
	return s
}

// Result message wrapping a list of application version descriptions.
type DescribeApplicationVersionsOutput struct {
	_ struct{} `type:"structure"`

	// List of ApplicationVersionDescription objects sorted in order of creation.
	ApplicationVersions []*ApplicationVersionDescription `type:"list"`

	// In a paginated request, the token that you can pass in a subsequent request
	// to get the next response page.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeApplicationVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeApplicationVersionsOutput) GoString() string {
	return s.String()
}

// SetApplicationVersions sets the ApplicationVersions field's value.
func (s *DescribeApplicationVersionsOutput) SetApplicationVersions(v []*ApplicationVersionDescription) *DescribeApplicationVersionsOutput {
	s.ApplicationVersions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeApplicationVersionsOutput) SetNextToken(v string) *DescribeApplicationVersionsOutput {
	s.NextToken = &v
	return s
}

// Request to describe one or more applications.
type DescribeApplicationsInput struct {
	_ struct{} `type:"structure"`

	// If specified, AWS Elastic Beanstalk restricts the returned descriptions to
	// only include those with the specified names.
	ApplicationNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeApplicationsInput) GoString() string {
	return s.String()
}

// SetApplicationNames sets the ApplicationNames field's value.
func (s *DescribeApplicationsInput) SetApplicationNames(v []*string) *DescribeApplicationsInput {
	s.ApplicationNames = v
	return s
}

// Result message containing a list of application descriptions.
type DescribeApplicationsOutput struct {
	_ struct{} `type:"structure"`

	// This parameter contains a list of ApplicationDescription.
	Applications []*ApplicationDescription `type:"list"`
}

// String returns the string representation
func (s DescribeApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeApplicationsOutput) GoString() string {
	return s.String()
}

// SetApplications sets the Applications field's value.
func (s *DescribeApplicationsOutput) SetApplications(v []*ApplicationDescription) *DescribeApplicationsOutput {
	s.Applications = v
	return s
}

// Result message containing a list of application version descriptions.
type DescribeConfigurationOptionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the application associated with the configuration template or
	// environment. Only needed if you want to describe the configuration options
	// associated with either the configuration template or environment.
	ApplicationName *string `min:"1" type:"string"`

	// The name of the environment whose configuration options you want to describe.
	EnvironmentName *string `min:"4" type:"string"`

	// If specified, restricts the descriptions to only the specified options.
	Options []*OptionSpecification `type:"list"`

	// The ARN of the custom platform.
	PlatformArn *string `type:"string"`

	// The name of the solution stack whose configuration options you want to describe.
	SolutionStackName *string `type:"string"`

	// The name of the configuration template whose configuration options you want
	// to describe.
	TemplateName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeConfigurationOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConfigurationOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConfigurationOptionsInput"}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 4))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}
	if s.Options != nil {
		for i, v := range s.Options {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Options", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DescribeConfigurationOptionsInput) SetApplicationName(v string) *DescribeConfigurationOptionsInput {
	s.ApplicationName = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *DescribeConfigurationOptionsInput) SetEnvironmentName(v string) *DescribeConfigurationOptionsInput {
	s.EnvironmentName = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *DescribeConfigurationOptionsInput) SetOptions(v []*OptionSpecification) *DescribeConfigurationOptionsInput {
	s.Options = v
	return s
}

// SetPlatformArn sets the PlatformArn field's value.
func (s *DescribeConfigurationOptionsInput) SetPlatformArn(v string) *DescribeConfigurationOptionsInput {
	s.PlatformArn = &v
	return s
}

// SetSolutionStackName sets the SolutionStackName field's value.
func (s *DescribeConfigurationOptionsInput) SetSolutionStackName(v string) *DescribeConfigurationOptionsInput {
	s.SolutionStackName = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *DescribeConfigurationOptionsInput) SetTemplateName(v string) *DescribeConfigurationOptionsInput {
	s.TemplateName = &v
	return s
}

// Describes the settings for a specified configuration set.
type DescribeConfigurationOptionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of ConfigurationOptionDescription.
	Options []*ConfigurationOptionDescription `type:"list"`

	// The ARN of the platform version.
	PlatformArn *string `type:"string"`

	// The name of the solution stack these configuration options belong to.
	SolutionStackName *string `type:"string"`
}

// String returns the string representation
func (s DescribeConfigurationOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationOptionsOutput) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *DescribeConfigurationOptionsOutput) SetOptions(v []*ConfigurationOptionDescription) *DescribeConfigurationOptionsOutput {
	s.Options = v
	return s
}

// SetPlatformArn sets the PlatformArn field's value.
func (s *DescribeConfigurationOptionsOutput) SetPlatformArn(v string) *DescribeConfigurationOptionsOutput {
	s.PlatformArn = &v
	return s
}

// SetSolutionStackName sets the SolutionStackName field's value.
func (s *DescribeConfigurationOptionsOutput) SetSolutionStackName(v string) *DescribeConfigurationOptionsOutput {
	s.SolutionStackName = &v
	return s
}

// Result message containing all of the configuration settings for a specified
// solution stack or configuration template.
type DescribeConfigurationSettingsInput struct {
	_ struct{} `type:"structure"`

	// The application for the environment or configuration template.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The name of the environment to describe.
	//
	// Condition: You must specify either this or a TemplateName, but not both.
	// If you specify both, AWS Elastic Beanstalk returns an InvalidParameterCombination
	// error. If you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentName *string `min:"4" type:"string"`

	// The name of the configuration template to describe.
	//
	// Conditional: You must specify either this parameter or an EnvironmentName,
	// but not both. If you specify both, AWS Elastic Beanstalk returns an InvalidParameterCombination
	// error. If you do not specify either, AWS Elastic Beanstalk returns a MissingRequiredParameter
	// error.
	TemplateName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeConfigurationSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConfigurationSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConfigurationSettingsInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 4))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DescribeConfigurationSettingsInput) SetApplicationName(v string) *DescribeConfigurationSettingsInput {
	s.ApplicationName = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *DescribeConfigurationSettingsInput) SetEnvironmentName(v string) *DescribeConfigurationSettingsInput {
	s.EnvironmentName = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *DescribeConfigurationSettingsInput) SetTemplateName(v string) *DescribeConfigurationSettingsInput {
	s.TemplateName = &v
	return s
}

// The results from a request to change the configuration settings of an environment.
type DescribeConfigurationSettingsOutput struct {
	_ struct{} `type:"structure"`

	// A list of ConfigurationSettingsDescription.
	ConfigurationSettings []*ConfigurationSettingsDescription `type:"list"`
}

// String returns the string representation
func (s DescribeConfigurationSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationSettingsOutput) GoString() string {
	return s.String()
}

// SetConfigurationSettings sets the ConfigurationSettings field's value.
func (s *DescribeConfigurationSettingsOutput) SetConfigurationSettings(v []*ConfigurationSettingsDescription) *DescribeConfigurationSettingsOutput {
	s.ConfigurationSettings = v
	return s
}

// See the example below to learn how to create a request body.
type DescribeEnvironmentHealthInput struct {
	_ struct{} `type:"structure"`

	// Specify the response elements to return. To retrieve all attributes, set
	// to All. If no attribute names are specified, returns the name of the environment.
	AttributeNames []*string `type:"list"`

	// Specify the environment by ID.
	//
	// You must specify either this or an EnvironmentName, or both.
	EnvironmentId *string `type:"string"`

	// Specify the environment by name.
	//
	// You must specify either this or an EnvironmentName, or both.
	EnvironmentName *string `min:"4" type:"string"`
}

// String returns the string representation
func (s DescribeEnvironmentHealthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEnvironmentHealthInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEnvironmentHealthInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEnvironmentHealthInput"}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeNames sets the AttributeNames field's value.
func (s *DescribeEnvironmentHealthInput) SetAttributeNames(v []*string) *DescribeEnvironmentHealthInput {
	s.AttributeNames = v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DescribeEnvironmentHealthInput) SetEnvironmentId(v string) *DescribeEnvironmentHealthInput {
	s.EnvironmentId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *DescribeEnvironmentHealthInput) SetEnvironmentName(v string) *DescribeEnvironmentHealthInput {
	s.EnvironmentName = &v
	return s
}

// Health details for an AWS Elastic Beanstalk environment.
type DescribeEnvironmentHealthOutput struct {
	_ struct{} `type:"structure"`

	// Application request metrics for the environment.
	ApplicationMetrics *ApplicationMetrics `type:"structure"`

	// Descriptions of the data that contributed to the environment's current health
	// status.
	Causes []*string `type:"list"`

	// The health color (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html)
	// of the environment.
	Color *string `type:"string"`

	// The environment's name.
	EnvironmentName *string `min:"4" type:"string"`

	// The health status (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html)
	// of the environment. For example, Ok.
	HealthStatus *string `type:"string"`

	// Summary health information for the instances in the environment.
	InstancesHealth *InstanceHealthSummary `type:"structure"`

	// The date and time that the health information was retrieved.
	RefreshedAt *time.Time `type:"timestamp"`

	// The environment's operational status. Ready, Launching, Updating, Terminating,
	// or Terminated.
	Status *string `type:"string" enum:"EnvironmentHealth"`
}

// String returns the string representation
func (s DescribeEnvironmentHealthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEnvironmentHealthOutput) GoString() string {
	return s.String()
}

// SetApplicationMetrics sets the ApplicationMetrics field's value.
func (s *DescribeEnvironmentHealthOutput) SetApplicationMetrics(v *ApplicationMetrics) *DescribeEnvironmentHealthOutput {
	s.ApplicationMetrics = v
	return s
}

// SetCauses sets the Causes field's value.
func (s *DescribeEnvironmentHealthOutput) SetCauses(v []*string) *DescribeEnvironmentHealthOutput {
	s.Causes = v
	return s
}

// SetColor sets the Color field's value.
func (s *DescribeEnvironmentHealthOutput) SetColor(v string) *DescribeEnvironmentHealthOutput {
	s.Color = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *DescribeEnvironmentHealthOutput) SetEnvironmentName(v string) *DescribeEnvironmentHealthOutput {
	s.EnvironmentName = &v
	return s
}

// SetHealthStatus sets the HealthStatus field's value.
func (s *DescribeEnvironmentHealthOutput) SetHealthStatus(v string) *DescribeEnvironmentHealthOutput {
	s.HealthStatus = &v
	return s
}

// SetInstancesHealth sets the InstancesHealth field's value.
func (s *DescribeEnvironmentHealthOutput) SetInstancesHealth(v *InstanceHealthSummary) *DescribeEnvironmentHealthOutput {
	s.InstancesHealth = v
	return s
}

// SetRefreshedAt sets the RefreshedAt field's value.
func (s *DescribeEnvironmentHealthOutput) SetRefreshedAt(v time.Time) *DescribeEnvironmentHealthOutput {
	s.RefreshedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeEnvironmentHealthOutput) SetStatus(v string) *DescribeEnvironmentHealthOutput {
	s.Status = &v
	return s
}

// Request to list completed and failed managed actions.
type DescribeEnvironmentManagedActionHistoryInput struct {
	_ struct{} `type:"structure"`

	// The environment ID of the target environment.
	EnvironmentId *string `type:"string"`

	// The name of the target environment.
	EnvironmentName *string `min:"4" type:"string"`

	// The maximum number of items to return for a single request.
	MaxItems *int64 `type:"integer"`

	// The pagination token returned by a previous request.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeEnvironmentManagedActionHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEnvironmentManagedActionHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEnvironmentManagedActionHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEnvironmentManagedActionHistoryInput"}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DescribeEnvironmentManagedActionHistoryInput) SetEnvironmentId(v string) *DescribeEnvironmentManagedActionHistoryInput {
	s.EnvironmentId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *DescribeEnvironmentManagedActionHistoryInput) SetEnvironmentName(v string) *DescribeEnvironmentManagedActionHistoryInput {
	s.EnvironmentName = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *DescribeEnvironmentManagedActionHistoryInput) SetMaxItems(v int64) *DescribeEnvironmentManagedActionHistoryInput {
	s.MaxItems = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEnvironmentManagedActionHistoryInput) SetNextToken(v string) *DescribeEnvironmentManagedActionHistoryInput {
	s.NextToken = &v
	return s
}

// A result message containing a list of completed and failed managed actions.
type DescribeEnvironmentManagedActionHistoryOutput struct {
	_ struct{} `type:"structure"`

	// A list of completed and failed managed actions.
	ManagedActionHistoryItems []*ManagedActionHistoryItem `min:"1" type:"list"`

	// A pagination token that you pass to DescribeEnvironmentManagedActionHistory
	// to get the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeEnvironmentManagedActionHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEnvironmentManagedActionHistoryOutput) GoString() string {
	return s.String()
}

// SetManagedActionHistoryItems sets the ManagedActionHistoryItems field's value.
func (s *DescribeEnvironmentManagedActionHistoryOutput) SetManagedActionHistoryItems(v []*ManagedActionHistoryItem) *DescribeEnvironmentManagedActionHistoryOutput {
	s.ManagedActionHistoryItems = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEnvironmentManagedActionHistoryOutput) SetNextToken(v string) *DescribeEnvironmentManagedActionHistoryOutput {
	s.NextToken = &v
	return s
}

// Request to list an environment's upcoming and in-progress managed actions.
type DescribeEnvironmentManagedActionsInput struct {
	_ struct{} `type:"structure"`

	// The environment ID of the target environment.
	EnvironmentId *string `type:"string"`

	// The name of the target environment.
	EnvironmentName *string `type:"string"`

	// To show only actions with a particular status, specify a status.
	Status *string `type:"string" enum:"ActionStatus"`
}

// String returns the string representation
func (s DescribeEnvironmentManagedActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEnvironmentManagedActionsInput) GoString() string {
	return s.String()
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DescribeEnvironmentManagedActionsInput) SetEnvironmentId(v string) *DescribeEnvironmentManagedActionsInput {
	s.EnvironmentId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *DescribeEnvironmentManagedActionsInput) SetEnvironmentName(v string) *DescribeEnvironmentManagedActionsInput {
	s.EnvironmentName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeEnvironmentManagedActionsInput) SetStatus(v string) *DescribeEnvironmentManagedActionsInput {
	s.Status = &v
	return s
}

// The result message containing a list of managed actions.
type DescribeEnvironmentManagedActionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of upcoming and in-progress managed actions.
	ManagedActions []*ManagedAction `min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeEnvironmentManagedActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEnvironmentManagedActionsOutput) GoString() string {
	return s.String()
}

// SetManagedActions sets the ManagedActions field's value.
func (s *DescribeEnvironmentManagedActionsOutput) SetManagedActions(v []*ManagedAction) *DescribeEnvironmentManagedActionsOutput {
	s.ManagedActions = v
	return s
}

// Request to describe the resources in an environment.
type DescribeEnvironmentResourcesInput struct {
	_ struct{} `type:"structure"`

	// The ID of the environment to retrieve AWS resource usage data.
	//
	// Condition: You must specify either this or an EnvironmentName, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentId *string `type:"string"`

	// The name of the environment to retrieve AWS resource usage data.
	//
	// Condition: You must specify either this or an EnvironmentId, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentName *string `min:"4" type:"string"`
}

// String returns the string representation
func (s DescribeEnvironmentResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEnvironmentResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEnvironmentResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEnvironmentResourcesInput"}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DescribeEnvironmentResourcesInput) SetEnvironmentId(v string) *DescribeEnvironmentResourcesInput {
	s.EnvironmentId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *DescribeEnvironmentResourcesInput) SetEnvironmentName(v string) *DescribeEnvironmentResourcesInput {
	s.EnvironmentName = &v
	return s
}

// Result message containing a list of environment resource descriptions.
type DescribeEnvironmentResourcesOutput struct {
	_ struct{} `type:"structure"`

	// A list of EnvironmentResourceDescription.
	EnvironmentResources *EnvironmentResourceDescription `type:"structure"`
}

// String returns the string representation
func (s DescribeEnvironmentResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEnvironmentResourcesOutput) GoString() string {
	return s.String()
}

// SetEnvironmentResources sets the EnvironmentResources field's value.
func (s *DescribeEnvironmentResourcesOutput) SetEnvironmentResources(v *EnvironmentResourceDescription) *DescribeEnvironmentResourcesOutput {
	s.EnvironmentResources = v
	return s
}

// Request to describe one or more environments.
type DescribeEnvironmentsInput struct {
	_ struct{} `type:"structure"`

	// If specified, AWS Elastic Beanstalk restricts the returned descriptions to
	// include only those that are associated with this application.
	ApplicationName *string `min:"1" type:"string"`

	// If specified, AWS Elastic Beanstalk restricts the returned descriptions to
	// include only those that have the specified IDs.
	EnvironmentIds []*string `type:"list"`

	// If specified, AWS Elastic Beanstalk restricts the returned descriptions to
	// include only those that have the specified names.
	EnvironmentNames []*string `type:"list"`

	// Indicates whether to include deleted environments:
	//
	// true: Environments that have been deleted after IncludedDeletedBackTo are
	// displayed.
	//
	// false: Do not include deleted environments.
	IncludeDeleted *bool `type:"boolean"`

	// If specified when IncludeDeleted is set to true, then environments deleted
	// after this date are displayed.
	IncludedDeletedBackTo *time.Time `type:"timestamp"`

	// For a paginated request. Specify a maximum number of environments to include
	// in each response.
	//
	// If no MaxRecords is specified, all available environments are retrieved in
	// a single response.
	MaxRecords *int64 `min:"1" type:"integer"`

	// For a paginated request. Specify a token from a previous response page to
	// retrieve the next response page. All other parameter values must be identical
	// to the ones specified in the initial request.
	//
	// If no NextToken is specified, the first page is retrieved.
	NextToken *string `type:"string"`

	// If specified, AWS Elastic Beanstalk restricts the returned descriptions to
	// include only those that are associated with this application version.
	VersionLabel *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeEnvironmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEnvironmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEnvironmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEnvironmentsInput"}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.MaxRecords != nil && *s.MaxRecords < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRecords", 1))
	}
	if s.VersionLabel != nil && len(*s.VersionLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionLabel", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DescribeEnvironmentsInput) SetApplicationName(v string) *DescribeEnvironmentsInput {
	s.ApplicationName = &v
	return s
}

// SetEnvironmentIds sets the EnvironmentIds field's value.
func (s *DescribeEnvironmentsInput) SetEnvironmentIds(v []*string) *DescribeEnvironmentsInput {
	s.EnvironmentIds = v
	return s
}

// SetEnvironmentNames sets the EnvironmentNames field's value.
func (s *DescribeEnvironmentsInput) SetEnvironmentNames(v []*string) *DescribeEnvironmentsInput {
	s.EnvironmentNames = v
	return s
}

// SetIncludeDeleted sets the IncludeDeleted field's value.
func (s *DescribeEnvironmentsInput) SetIncludeDeleted(v bool) *DescribeEnvironmentsInput {
	s.IncludeDeleted = &v
	return s
}

// SetIncludedDeletedBackTo sets the IncludedDeletedBackTo field's value.
func (s *DescribeEnvironmentsInput) SetIncludedDeletedBackTo(v time.Time) *DescribeEnvironmentsInput {
	s.IncludedDeletedBackTo = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEnvironmentsInput) SetMaxRecords(v int64) *DescribeEnvironmentsInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEnvironmentsInput) SetNextToken(v string) *DescribeEnvironmentsInput {
	s.NextToken = &v
	return s
}

// SetVersionLabel sets the VersionLabel field's value.
func (s *DescribeEnvironmentsInput) SetVersionLabel(v string) *DescribeEnvironmentsInput {
	s.VersionLabel = &v
	return s
}

// Request to retrieve a list of events for an environment.
type DescribeEventsInput struct {
	_ struct{} `type:"structure"`

	// If specified, AWS Elastic Beanstalk restricts the returned descriptions to
	// include only those associated with this application.
	ApplicationName *string `min:"1" type:"string"`

	// If specified, AWS Elastic Beanstalk restricts the returned descriptions to
	// those that occur up to, but not including, the EndTime.
	EndTime *time.Time `type:"timestamp"`

	// If specified, AWS Elastic Beanstalk restricts the returned descriptions to
	// those associated with this environment.
	EnvironmentId *string `type:"string"`

	// If specified, AWS Elastic Beanstalk restricts the returned descriptions to
	// those associated with this environment.
	EnvironmentName *string `min:"4" type:"string"`

	// Specifies the maximum number of events that can be returned, beginning with
	// the most recent event.
	MaxRecords *int64 `min:"1" type:"integer"`

	// Pagination token. If specified, the events return the next batch of results.
	NextToken *string `type:"string"`

	// The ARN of a custom platform version. If specified, AWS Elastic Beanstalk
	// restricts the returned descriptions to those associated with this custom
	// platform version.
	PlatformArn *string `type:"string"`

	// If specified, AWS Elastic Beanstalk restricts the described events to include
	// only those associated with this request ID.
	RequestId *string `type:"string"`

	// If specified, limits the events returned from this call to include only those
	// with the specified severity or higher.
	Severity *string `type:"string" enum:"EventSeverity"`

	// If specified, AWS Elastic Beanstalk restricts the returned descriptions to
	// those that occur on or after this time.
	StartTime *time.Time `type:"timestamp"`

	// If specified, AWS Elastic Beanstalk restricts the returned descriptions to
	// those that are associated with this environment configuration.
	TemplateName *string `min:"1" type:"string"`

	// If specified, AWS Elastic Beanstalk restricts the returned descriptions to
	// those associated with this application version.
	VersionLabel *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventsInput"}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 4))
	}
	if s.MaxRecords != nil && *s.MaxRecords < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRecords", 1))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}
	if s.VersionLabel != nil && len(*s.VersionLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionLabel", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DescribeEventsInput) SetApplicationName(v string) *DescribeEventsInput {
	s.ApplicationName = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeEventsInput) SetEndTime(v time.Time) *DescribeEventsInput {
	s.EndTime = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DescribeEventsInput) SetEnvironmentId(v string) *DescribeEventsInput {
	s.EnvironmentId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *DescribeEventsInput) SetEnvironmentName(v string) *DescribeEventsInput {
	s.EnvironmentName = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEventsInput) SetMaxRecords(v int64) *DescribeEventsInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEventsInput) SetNextToken(v string) *DescribeEventsInput {
	s.NextToken = &v
	return s
}

// SetPlatformArn sets the PlatformArn field's value.
func (s *DescribeEventsInput) SetPlatformArn(v string) *DescribeEventsInput {
	s.PlatformArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeEventsInput) SetRequestId(v string) *DescribeEventsInput {
	s.RequestId = &v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *DescribeEventsInput) SetSeverity(v string) *DescribeEventsInput {
	s.Severity = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeEventsInput) SetStartTime(v time.Time) *DescribeEventsInput {
	s.StartTime = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *DescribeEventsInput) SetTemplateName(v string) *DescribeEventsInput {
	s.TemplateName = &v
	return s
}

// SetVersionLabel sets the VersionLabel field's value.
func (s *DescribeEventsInput) SetVersionLabel(v string) *DescribeEventsInput {
	s.VersionLabel = &v
	return s
}

// Result message wrapping a list of event descriptions.
type DescribeEventsOutput struct {
	_ struct{} `type:"structure"`

	// A list of EventDescription.
	Events []*EventDescription `type:"list"`

	// If returned, this indicates that there are more results to obtain. Use this
	// token in the next DescribeEvents call to get the next batch of events.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *DescribeEventsOutput) SetEvents(v []*EventDescription) *DescribeEventsOutput {
	s.Events = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEventsOutput) SetNextToken(v string) *DescribeEventsOutput {
	s.NextToken = &v
	return s
}

// Parameters for a call to DescribeInstancesHealth.
type DescribeInstancesHealthInput struct {
	_ struct{} `type:"structure"`

	// Specifies the response elements you wish to receive. To retrieve all attributes,
	// set to All. If no attribute names are specified, returns a list of instances.
	AttributeNames []*string `type:"list"`

	// Specify the AWS Elastic Beanstalk environment by ID.
	EnvironmentId *string `type:"string"`

	// Specify the AWS Elastic Beanstalk environment by name.
	EnvironmentName *string `min:"4" type:"string"`

	// Specify the pagination token returned by a previous call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeInstancesHealthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstancesHealthInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstancesHealthInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInstancesHealthInput"}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 4))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeNames sets the AttributeNames field's value.
func (s *DescribeInstancesHealthInput) SetAttributeNames(v []*string) *DescribeInstancesHealthInput {
	s.AttributeNames = v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DescribeInstancesHealthInput) SetEnvironmentId(v string) *DescribeInstancesHealthInput {
	s.EnvironmentId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *DescribeInstancesHealthInput) SetEnvironmentName(v string) *DescribeInstancesHealthInput {
	s.EnvironmentName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInstancesHealthInput) SetNextToken(v string) *DescribeInstancesHealthInput {
	s.NextToken = &v
	return s
}

// Detailed health information about the Amazon EC2 instances in an AWS Elastic
// Beanstalk environment.
type DescribeInstancesHealthOutput struct {
	_ struct{} `type:"structure"`

	// Detailed health information about each instance.
	//
	// The output differs slightly between Linux and Windows environments. There
	// is a difference in the members that are supported under the <CPUUtilization>
	// type.
	InstanceHealthList []*SingleInstanceHealth `type:"list"`

	// Pagination token for the next page of results, if available.
	NextToken *string `min:"1" type:"string"`

	// The date and time that the health information was retrieved.
	RefreshedAt *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DescribeInstancesHealthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstancesHealthOutput) GoString() string {
	return s.String()
}

// SetInstanceHealthList sets the InstanceHealthList field's value.
func (s *DescribeInstancesHealthOutput) SetInstanceHealthList(v []*SingleInstanceHealth) *DescribeInstancesHealthOutput {
	s.InstanceHealthList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInstancesHealthOutput) SetNextToken(v string) *DescribeInstancesHealthOutput {
	s.NextToken = &v
	return s
}

// SetRefreshedAt sets the RefreshedAt field's value.
func (s *DescribeInstancesHealthOutput) SetRefreshedAt(v time.Time) *DescribeInstancesHealthOutput {
	s.RefreshedAt = &v
	return s
}

type DescribePlatformVersionInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the platform version.
	PlatformArn *string `type:"string"`
}

// String returns the string representation
func (s DescribePlatformVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePlatformVersionInput) GoString() string {
	return s.String()
}

// SetPlatformArn sets the PlatformArn field's value.
func (s *DescribePlatformVersionInput) SetPlatformArn(v string) *DescribePlatformVersionInput {
	s.PlatformArn = &v
	return s
}

type DescribePlatformVersionOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about the platform version.
	PlatformDescription *PlatformDescription `type:"structure"`
}

// String returns the string representation
func (s DescribePlatformVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePlatformVersionOutput) GoString() string {
	return s.String()
}

// SetPlatformDescription sets the PlatformDescription field's value.
func (s *DescribePlatformVersionOutput) SetPlatformDescription(v *PlatformDescription) *DescribePlatformVersionOutput {
	s.PlatformDescription = v
	return s
}

// Request to disassociate the operations role from an environment.
type DisassociateEnvironmentOperationsRoleInput struct {
	_ struct{} `type:"structure"`

	// The name of the environment from which to disassociate the operations role.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `min:"4" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateEnvironmentOperationsRoleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateEnvironmentOperationsRoleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateEnvironmentOperationsRoleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateEnvironmentOperationsRoleInput"}
	if s.EnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentName"))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *DisassociateEnvironmentOperationsRoleInput) SetEnvironmentName(v string) *DisassociateEnvironmentOperationsRoleInput {
	s.EnvironmentName = &v
	return s
}

type DisassociateEnvironmentOperationsRoleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateEnvironmentOperationsRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateEnvironmentOperationsRoleOutput) GoString() string {
	return s.String()
}

// Describes the properties of an environment.
type EnvironmentDescription struct {
	_ struct{} `type:"structure"`

	// Indicates if there is an in-progress environment configuration update or
	// application version deployment that you can cancel.
	//
	// true: There is an update in progress.
	//
	// false: There are no updates currently in progress.
	AbortableOperationInProgress *bool `type:"boolean"`

	// The name of the application associated with this environment.
	ApplicationName *string `min:"1" type:"string"`

	// The URL to the CNAME for this environment.
	CNAME *string `min:"1" type:"string"`

	// The creation date for this environment.
	DateCreated *time.Time `type:"timestamp"`

	// The last modified date for this environment.
	DateUpdated *time.Time `type:"timestamp"`

	// Describes this environment.
	Description *string `type:"string"`

	// For load-balanced, autoscaling environments, the URL to the LoadBalancer.
	// For single-instance environments, the IP address of the instance.
	EndpointURL *string `type:"string"`

	// The environment's Amazon Resource Name (ARN), which can be used in other
	// API requests that require an ARN.
	EnvironmentArn *string `type:"string"`

	// The ID of this environment.
	EnvironmentId *string `type:"string"`

	// A list of links to other environments in the same group.
	EnvironmentLinks []*EnvironmentLink `type:"list"`

	// The name of this environment.
	EnvironmentName *string `min:"4" type:"string"`

	// Describes the health status of the environment. AWS Elastic Beanstalk indicates
	// the failure levels for a running environment:
	//
	//    * Red: Indicates the environment is not responsive. Occurs when three
	//    or more consecutive failures occur for an environment.
	//
	//    * Yellow: Indicates that something is wrong. Occurs when two consecutive
	//    failures occur for an environment.
	//
	//    * Green: Indicates the environment is healthy and fully functional.
	//
	//    * Grey: Default health for a new environment. The environment is not fully
	//    launched and health checks have not started or health checks are suspended
	//    during an UpdateEnvironment or RestartEnvironment request.
	//
	// Default: Grey
	Health *string `type:"string" enum:"EnvironmentHealth"`

	// Returns the health status of the application running in your environment.
	// For more information, see Health Colors and Statuses (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html).
	HealthStatus *string `type:"string" enum:"EnvironmentHealthStatus"`

	// The Amazon Resource Name (ARN) of the environment's operations role. For
	// more information, see Operations roles (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html)
	// in the AWS Elastic Beanstalk Developer Guide.
	OperationsRole *string `min:"1" type:"string"`

	// The ARN of the platform version.
	PlatformArn *string `type:"string"`

	// The description of the AWS resources used by this environment.
	Resources *EnvironmentResourcesDescription `type:"structure"`

	// The name of the SolutionStack deployed with this environment.
	SolutionStackName *string `type:"string"`

	// The current operational status of the environment:
	//
	//    * Launching: Environment is in the process of initial deployment.
	//
	//    * Updating: Environment is in the process of updating its configuration
	//    settings or application version.
	//
	//    * Ready: Environment is available to have an action performed on it, such
	//    as update or terminate.
	//
	//    * Terminating: Environment is in the shut-down process.
	//
	//    * Terminated: Environment is not running.
	Status *string `type:"string" enum:"EnvironmentStatus"`

	// The name of the configuration template used to originally launch this environment.
	TemplateName *string `min:"1" type:"string"`

	// Describes the current tier of this environment.
	Tier *EnvironmentTier `type:"structure"`

	// The application version deployed in this environment.
	VersionLabel *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EnvironmentDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentDescription) GoString() string {
	return s.String()
}

// SetAbortableOperationInProgress sets the AbortableOperationInProgress field's value.
func (s *EnvironmentDescription) SetAbortableOperationInProgress(v bool) *EnvironmentDescription {
	s.AbortableOperationInProgress = &v
	return s
}

// SetApplicationName sets the ApplicationName field's value.
func (s *EnvironmentDescription) SetApplicationName(v string) *EnvironmentDescription {
	s.ApplicationName = &v
	return s
}

// SetCNAME sets the CNAME field's value.
func (s *EnvironmentDescription) SetCNAME(v string) *EnvironmentDescription {
	s.CNAME = &v
	return s
}

// SetDateCreated sets the DateCreated field's value.
func (s *EnvironmentDescription) SetDateCreated(v time.Time) *EnvironmentDescription {
	s.DateCreated = &v
	return s
}

// SetDateUpdated sets the DateUpdated field's value.
func (s *EnvironmentDescription) SetDateUpdated(v time.Time) *EnvironmentDescription {
	s.DateUpdated = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *EnvironmentDescription) SetDescription(v string) *EnvironmentDescription {
	s.Description = &v
	return s
}

// SetEndpointURL sets the EndpointURL field's value.
func (s *EnvironmentDescription) SetEndpointURL(v string) *EnvironmentDescription {
	s.EndpointURL = &v
	return s
}

// SetEnvironmentArn sets the EnvironmentArn field's value.
func (s *EnvironmentDescription) SetEnvironmentArn(v string) *EnvironmentDescription {
	s.EnvironmentArn = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *EnvironmentDescription) SetEnvironmentId(v string) *EnvironmentDescription {
	s.EnvironmentId = &v
	return s
}

// SetEnvironmentLinks sets the EnvironmentLinks field's value.
func (s *EnvironmentDescription) SetEnvironmentLinks(v []*EnvironmentLink) *EnvironmentDescription {
	s.EnvironmentLinks = v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *EnvironmentDescription) SetEnvironmentName(v string) *EnvironmentDescription {
	s.EnvironmentName = &v
	return s
}

// SetHealth sets the Health field's value.
func (s *EnvironmentDescription) SetHealth(v string) *EnvironmentDescription {
	s.Health = &v
	return s
}

// SetHealthStatus sets the HealthStatus field's value.
func (s *EnvironmentDescription) SetHealthStatus(v string) *EnvironmentDescription {
	s.HealthStatus = &v
	return s
}

// SetOperationsRole sets the OperationsRole field's value.
func (s *EnvironmentDescription) SetOperationsRole(v string) *EnvironmentDescription {
	s.OperationsRole = &v
	return s
}

// SetPlatformArn sets the PlatformArn field's value.
func (s *EnvironmentDescription) SetPlatformArn(v string) *EnvironmentDescription {
	s.PlatformArn = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *EnvironmentDescription) SetResources(v *EnvironmentResourcesDescription) *EnvironmentDescription {
	s.Resources = v
	return s
}

// SetSolutionStackName sets the SolutionStackName field's value.
func (s *EnvironmentDescription) SetSolutionStackName(v string) *EnvironmentDescription {
	s.SolutionStackName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EnvironmentDescription) SetStatus(v string) *EnvironmentDescription {
	s.Status = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *EnvironmentDescription) SetTemplateName(v string) *EnvironmentDescription {
	s.TemplateName = &v
	return s
}

// SetTier sets the Tier field's value.
func (s *EnvironmentDescription) SetTier(v *EnvironmentTier) *EnvironmentDescription {
	s.Tier = v
	return s
}

// SetVersionLabel sets the VersionLabel field's value.
func (s *EnvironmentDescription) SetVersionLabel(v string) *EnvironmentDescription {
	s.VersionLabel = &v
	return s
}

// Result message containing a list of environment descriptions.
type EnvironmentDescriptionsMessage struct {
	_ struct{} `type:"structure"`

	// Returns an EnvironmentDescription list.
	Environments []*EnvironmentDescription `type:"list"`

	// In a paginated request, the token that you can pass in a subsequent request
	// to get the next response page.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s EnvironmentDescriptionsMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentDescriptionsMessage) GoString() string {
	return s.String()
}

// SetEnvironments sets the Environments field's value.
func (s *EnvironmentDescriptionsMessage) SetEnvironments(v []*EnvironmentDescription) *EnvironmentDescriptionsMessage {
	s.Environments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *EnvironmentDescriptionsMessage) SetNextToken(v string) *EnvironmentDescriptionsMessage {
	s.NextToken = &v
	return s
}

// The information retrieved from the Amazon EC2 instances.
type EnvironmentInfoDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon EC2 Instance ID for this information.
	Ec2InstanceId *string `type:"string"`

	// The type of information retrieved.
	InfoType *string `type:"string" enum:"EnvironmentInfoType"`

	// The retrieved information. Currently contains a presigned Amazon S3 URL.
	// The files are deleted after 15 minutes.
	//
	// Anyone in possession of this URL can access the files before they are deleted.
	// Make the URL available only to trusted parties.
	Message *string `type:"string"`

	// The time stamp when this information was retrieved.
	SampleTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s EnvironmentInfoDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentInfoDescription) GoString() string {
	return s.String()
}

// SetEc2InstanceId sets the Ec2InstanceId field's value.
func (s *EnvironmentInfoDescription) SetEc2InstanceId(v string) *EnvironmentInfoDescription {
	s.Ec2InstanceId = &v
	return s
}

// SetInfoType sets the InfoType field's value.
func (s *EnvironmentInfoDescription) SetInfoType(v string) *EnvironmentInfoDescription {
	s.InfoType = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *EnvironmentInfoDescription) SetMessage(v string) *EnvironmentInfoDescription {
	s.Message = &v
	return s
}

// SetSampleTimestamp sets the SampleTimestamp field's value.
func (s *EnvironmentInfoDescription) SetSampleTimestamp(v time.Time) *EnvironmentInfoDescription {
	s.SampleTimestamp = &v
	return s
}

// A link to another environment, defined in the environment's manifest. Links
// provide connection information in system properties that can be used to connect
// to another environment in the same group. See Environment Manifest (env.yaml)
// (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html)
// for details.
type EnvironmentLink struct {
	_ struct{} `type:"structure"`

	// The name of the linked environment (the dependency).
	EnvironmentName *string `type:"string"`

	// The name of the link.
	LinkName *string `type:"string"`
}

// String returns the string representation
func (s EnvironmentLink) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentLink) GoString() string {
	return s.String()
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *EnvironmentLink) SetEnvironmentName(v string) *EnvironmentLink {
	s.EnvironmentName = &v
	return s
}

// SetLinkName sets the LinkName field's value.
func (s *EnvironmentLink) SetLinkName(v string) *EnvironmentLink {
	s.LinkName = &v
	return s
}

// Describes the AWS resources in use by this environment. This data is live.
type EnvironmentResourceDescription struct {
	_ struct{} `type:"structure"`

	// The AutoScalingGroups used by this environment.
	AutoScalingGroups []*AutoScalingGroup `type:"list"`

	// The name of the environment.
	EnvironmentName *string `min:"4" type:"string"`

	// The Amazon EC2 instances used by this environment.
	Instances []*Instance `type:"list"`

	// The Auto Scaling launch configurations in use by this environment.
	LaunchConfigurations []*LaunchConfiguration `type:"list"`

	// The Amazon EC2 launch templates in use by this environment.
	LaunchTemplates []*LaunchTemplate `type:"list"`

	// The LoadBalancers in use by this environment.
	LoadBalancers []*LoadBalancer `type:"list"`

	// The queues used by this environment.
	Queues []*Queue `type:"list"`

	// The AutoScaling triggers in use by this environment.
	Triggers []*Trigger `type:"list"`
}

// String returns the string representation
func (s EnvironmentResourceDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentResourceDescription) GoString() string {
	return s.String()
}

// SetAutoScalingGroups sets the AutoScalingGroups field's value.
func (s *EnvironmentResourceDescription) SetAutoScalingGroups(v []*AutoScalingGroup) *EnvironmentResourceDescription {
	s.AutoScalingGroups = v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *EnvironmentResourceDescription) SetEnvironmentName(v string) *EnvironmentResourceDescription {
	s.EnvironmentName = &v
	return s
}

// SetInstances sets the Instances field's value.
func (s *EnvironmentResourceDescription) SetInstances(v []*Instance) *EnvironmentResourceDescription {
	s.Instances = v
	return s
}

// SetLaunchConfigurations sets the LaunchConfigurations field's value.
func (s *EnvironmentResourceDescription) SetLaunchConfigurations(v []*LaunchConfiguration) *EnvironmentResourceDescription {
	s.LaunchConfigurations = v
	return s
}

// SetLaunchTemplates sets the LaunchTemplates field's value.
func (s *EnvironmentResourceDescription) SetLaunchTemplates(v []*LaunchTemplate) *EnvironmentResourceDescription {
	s.LaunchTemplates = v
	return s
}

// SetLoadBalancers sets the LoadBalancers field's value.
func (s *EnvironmentResourceDescription) SetLoadBalancers(v []*LoadBalancer) *EnvironmentResourceDescription {
	s.LoadBalancers = v
	return s
}

// SetQueues sets the Queues field's value.
func (s *EnvironmentResourceDescription) SetQueues(v []*Queue) *EnvironmentResourceDescription {
	s.Queues = v
	return s
}

// SetTriggers sets the Triggers field's value.
func (s *EnvironmentResourceDescription) SetTriggers(v []*Trigger) *EnvironmentResourceDescription {
	s.Triggers = v
	return s
}

// Describes the AWS resources in use by this environment. This data is not
// live data.
type EnvironmentResourcesDescription struct {
	_ struct{} `type:"structure"`

	// Describes the LoadBalancer.
	LoadBalancer *LoadBalancerDescription `type:"structure"`
}

// String returns the string representation
func (s EnvironmentResourcesDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentResourcesDescription) GoString() string {
	return s.String()
}

// SetLoadBalancer sets the LoadBalancer field's value.
func (s *EnvironmentResourcesDescription) SetLoadBalancer(v *LoadBalancerDescription) *EnvironmentResourcesDescription {
	s.LoadBalancer = v
	return s
}

// Describes the properties of an environment tier
type EnvironmentTier struct {
	_ struct{} `type:"structure"`

	// The name of this environment tier.
	//
	// Valid values:
	//
	//    * For Web server tier – WebServer
	//
	//    * For Worker tier – Worker
	Name *string `type:"string"`

	// The type of this environment tier.
	//
	// Valid values:
	//
	//    * For Web server tier – Standard
	//
	//    * For Worker tier – SQS/HTTP
	Type *string `type:"string"`

	// The version of this environment tier. When you don't set a value to it, Elastic
	// Beanstalk uses the latest compatible worker tier version.
	//
	// This member is deprecated. Any specific version that you set may become out
	// of date. We recommend leaving it unspecified.
	Version *string `type:"string"`
}

// String returns the string representation
func (s EnvironmentTier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentTier) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *EnvironmentTier) SetName(v string) *EnvironmentTier {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *EnvironmentTier) SetType(v string) *EnvironmentTier {
	s.Type = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *EnvironmentTier) SetVersion(v string) *EnvironmentTier {
	s.Version = &v
	return s
}

// Describes an event.
type EventDescription struct {
	_ struct{} `type:"structure"`

	// The application associated with the event.
	ApplicationName *string `min:"1" type:"string"`

	// The name of the environment associated with this event.
	EnvironmentName *string `min:"4" type:"string"`

	// The date when the event occurred.
	EventDate *time.Time `type:"timestamp"`

	// The event message.
	Message *string `type:"string"`

	// The ARN of the platform version.
	PlatformArn *string `type:"string"`

	// The web service request ID for the activity of this event.
	RequestId *string `type:"string"`

	// The severity level of this event.
	Severity *string `type:"string" enum:"EventSeverity"`

	// The name of the configuration associated with this event.
	TemplateName *string `min:"1" type:"string"`

	// The release label for the application version associated with this event.
	VersionLabel *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EventDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventDescription) GoString() string {
	return s.String()
}

// SetApplicationName sets the ApplicationName field's value.
func (s *EventDescription) SetApplicationName(v string) *EventDescription {
	s.ApplicationName = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *EventDescription) SetEnvironmentName(v string) *EventDescription {
	s.EnvironmentName = &v
	return s
}

// SetEventDate sets the EventDate field's value.
func (s *EventDescription) SetEventDate(v time.Time) *EventDescription {
	s.EventDate = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *EventDescription) SetMessage(v string) *EventDescription {
	s.Message = &v
	return s
}

// SetPlatformArn sets the PlatformArn field's value.
func (s *EventDescription) SetPlatformArn(v string) *EventDescription {
	s.PlatformArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *EventDescription) SetRequestId(v string) *EventDescription {
	s.RequestId = &v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *EventDescription) SetSeverity(v string) *EventDescription {
	s.Severity = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *EventDescription) SetTemplateName(v string) *EventDescription {
	s.TemplateName = &v
	return s
}

// SetVersionLabel sets the VersionLabel field's value.
func (s *EventDescription) SetVersionLabel(v string) *EventDescription {
	s.VersionLabel = &v
	return s
}

// The description of an Amazon EC2 instance.
type Instance struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon EC2 instance.
	Id *string `type:"string"`
}

// String returns the string representation
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Instance) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *Instance) SetId(v string) *Instance {
	s.Id = &v
	return s
}

// Represents summary information about the health of an instance. For more
// information, see Health Colors and Statuses (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html).
type InstanceHealthSummary struct {
	_ struct{} `type:"structure"`

	// Red. The health agent is reporting a high number of request failures or other
	// issues for an instance or environment.
	Degraded *int64 `type:"integer"`

	// Green. An operation is in progress on an instance.
	Info *int64 `type:"integer"`

	// Grey. AWS Elastic Beanstalk and the health agent are reporting no data on
	// an instance.
	NoData *int64 `type:"integer"`

	// Green. An instance is passing health checks and the health agent is not reporting
	// any problems.
	Ok *int64 `type:"integer"`

	// Grey. An operation is in progress on an instance within the command timeout.
	Pending *int64 `type:"integer"`

	// Red. The health agent is reporting a very high number of request failures
	// or other issues for an instance or environment.
	Severe *int64 `type:"integer"`

	// Grey. AWS Elastic Beanstalk and the health agent are reporting an insufficient
	// amount of data on an instance.
	Unknown *int64 `type:"integer"`

	// Yellow. The health agent is reporting a moderate number of request failures
	// or other issues for an instance or environment.
	Warning *int64 `type:"integer"`
}

// String returns the string representation
func (s InstanceHealthSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceHealthSummary) GoString() string {
	return s.String()
}

// SetDegraded sets the Degraded field's value.
func (s *InstanceHealthSummary) SetDegraded(v int64) *InstanceHealthSummary {
	s.Degraded = &v
	return s
}

// SetInfo sets the Info field's value.
func (s *InstanceHealthSummary) SetInfo(v int64) *InstanceHealthSummary {
	s.Info = &v
	return s
}

// SetNoData sets the NoData field's value.
func (s *InstanceHealthSummary) SetNoData(v int64) *InstanceHealthSummary {
	s.NoData = &v
	return s
}

// SetOk sets the Ok field's value.
func (s *InstanceHealthSummary) SetOk(v int64) *InstanceHealthSummary {
	s.Ok = &v
	return s
}

// SetPending sets the Pending field's value.
func (s *InstanceHealthSummary) SetPending(v int64) *InstanceHealthSummary {
	s.Pending = &v
	return s
}

// SetSevere sets the Severe field's value.
func (s *InstanceHealthSummary) SetSevere(v int64) *InstanceHealthSummary {
	s.Severe = &v
	return s
}

// SetUnknown sets the Unknown field's value.
func (s *InstanceHealthSummary) SetUnknown(v int64) *InstanceHealthSummary {
	s.Unknown = &v
	return s
}

// SetWarning sets the Warning field's value.
func (s *InstanceHealthSummary) SetWarning(v int64) *InstanceHealthSummary {
	s.Warning = &v
	return s
}

// Represents the average latency for the slowest X percent of requests over
// the last 10 seconds.
type Latency struct {
	_ struct{} `type:"structure"`

	// The average latency for the slowest 90 percent of requests over the last
	// 10 seconds.
	P10 *float64 `type:"double"`

	// The average latency for the slowest 50 percent of requests over the last
	// 10 seconds.
	P50 *float64 `type:"double"`

	// The average latency for the slowest 25 percent of requests over the last
	// 10 seconds.
	P75 *float64 `type:"double"`

	// The average latency for the slowest 15 percent of requests over the last
	// 10 seconds.
	P85 *float64 `type:"double"`

	// The average latency for the slowest 10 percent of requests over the last
	// 10 seconds.
	P90 *float64 `type:"double"`

	// The average latency for the slowest 5 percent of requests over the last 10
	// seconds.
	P95 *float64 `type:"double"`

	// The average latency for the slowest 1 percent of requests over the last 10
	// seconds.
	P99 *float64 `type:"double"`

	// The average latency for the slowest 0.1 percent of requests over the last
	// 10 seconds.
	P999 *float64 `type:"double"`
}

// String returns the string representation
func (s Latency) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Latency) GoString() string {
	return s.String()
}

// SetP10 sets the P10 field's value.
func (s *Latency) SetP10(v float64) *Latency {
	s.P10 = &v
	return s
}

// SetP50 sets the P50 field's value.
func (s *Latency) SetP50(v float64) *Latency {
	s.P50 = &v
	return s
}

// SetP75 sets the P75 field's value.
func (s *Latency) SetP75(v float64) *Latency {
	s.P75 = &v
	return s
}

// SetP85 sets the P85 field's value.
func (s *Latency) SetP85(v float64) *Latency {
	s.P85 = &v
	return s
}

// SetP90 sets the P90 field's value.
func (s *Latency) SetP90(v float64) *Latency {
	s.P90 = &v
	return s
}

// SetP95 sets the P95 field's value.
func (s *Latency) SetP95(v float64) *Latency {
	s.P95 = &v
	return s
}

// SetP99 sets the P99 field's value.
func (s *Latency) SetP99(v float64) *Latency {
	s.P99 = &v
	return s
}

// SetP999 sets the P999 field's value.
func (s *Latency) SetP999(v float64) *Latency {
	s.P999 = &v
	return s
}

// Describes an Auto Scaling launch configuration.
type LaunchConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the launch configuration.
	Name *string `type:"string"`
}

// String returns the string representation
func (s LaunchConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LaunchConfiguration) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *LaunchConfiguration) SetName(v string) *LaunchConfiguration {
	s.Name = &v
	return s
}

// Describes an Amazon EC2 launch template.
type LaunchTemplate struct {
	_ struct{} `type:"structure"`

	// The ID of the launch template.
	Id *string `type:"string"`
}

// String returns the string representation
func (s LaunchTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LaunchTemplate) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *LaunchTemplate) SetId(v string) *LaunchTemplate {
	s.Id = &v
	return s
}

type ListAvailableSolutionStacksInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ListAvailableSolutionStacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAvailableSolutionStacksInput) GoString() string {
	return s.String()
}

// A list of available AWS Elastic Beanstalk solution stacks.
type ListAvailableSolutionStacksOutput struct {
	_ struct{} `type:"structure"`

	// A list of available solution stacks and their SolutionStackDescription.
	SolutionStackDetails []*SolutionStackDescription `type:"list"`

	// A list of available solution stacks.
	SolutionStacks []*string `type:"list"`
}

// String returns the string representation
func (s ListAvailableSolutionStacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAvailableSolutionStacksOutput) GoString() string {
	return s.String()
}

// SetSolutionStackDetails sets the SolutionStackDetails field's value.
func (s *ListAvailableSolutionStacksOutput) SetSolutionStackDetails(v []*SolutionStackDescription) *ListAvailableSolutionStacksOutput {
	s.SolutionStackDetails = v
	return s
}

// SetSolutionStacks sets the SolutionStacks field's value.
func (s *ListAvailableSolutionStacksOutput) SetSolutionStacks(v []*string) *ListAvailableSolutionStacksOutput {
	s.SolutionStacks = v
	return s
}

type ListPlatformBranchesInput struct {
	_ struct{} `type:"structure"`

	// Criteria for restricting the resulting list of platform branches. The filter
	// is evaluated as a logical conjunction (AND) of the separate SearchFilter
	// terms.
	//
	// The following list shows valid attribute values for each of the SearchFilter
	// terms. Most operators take a single value. The in and not_in operators can
	// take multiple values.
	//
	//    * Attribute = BranchName: Operator: = | != | begins_with | ends_with |
	//    contains | in | not_in
	//
	//    * Attribute = LifecycleState: Operator: = | != | in | not_in Values: beta
	//    | supported | deprecated | retired
	//
	//    * Attribute = PlatformName: Operator: = | != | begins_with | ends_with
	//    | contains | in | not_in
	//
	//    * Attribute = TierType: Operator: = | != Values: WebServer/Standard |
	//    Worker/SQS/HTTP
	//
	// Array size: limited to 10 SearchFilter objects.
	//
	// Within each SearchFilter item, the Values array is limited to 10 items.
	Filters []*SearchFilter `type:"list"`

	// The maximum number of platform branch values returned in one call.
	MaxRecords *int64 `min:"1" type:"integer"`

	// For a paginated request. Specify a token from a previous response page to
	// retrieve the next response page. All other parameter values must be identical
	// to the ones specified in the initial request.
	//
	// If no NextToken is specified, the first page is retrieved.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListPlatformBranchesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPlatformBranchesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPlatformBranchesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPlatformBranchesInput"}
	if s.MaxRecords != nil && *s.MaxRecords < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRecords", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListPlatformBranchesInput) SetFilters(v []*SearchFilter) *ListPlatformBranchesInput {
	s.Filters = v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *ListPlatformBranchesInput) SetMaxRecords(v int64) *ListPlatformBranchesInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPlatformBranchesInput) SetNextToken(v string) *ListPlatformBranchesInput {
	s.NextToken = &v
	return s
}

type ListPlatformBranchesOutput struct {
	_ struct{} `type:"structure"`

	// In a paginated request, if this value isn't null, it's the token that you
	// can pass in a subsequent request to get the next response page.
	NextToken *string `type:"string"`

	// Summary information about the platform branches.
	PlatformBranchSummaryList []*PlatformBranchSummary `type:"list"`
}

// String returns the string representation
func (s ListPlatformBranchesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPlatformBranchesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPlatformBranchesOutput) SetNextToken(v string) *ListPlatformBranchesOutput {
	s.NextToken = &v
	return s
}

// SetPlatformBranchSummaryList sets the PlatformBranchSummaryList field's value.
func (s *ListPlatformBranchesOutput) SetPlatformBranchSummaryList(v []*PlatformBranchSummary) *ListPlatformBranchesOutput {
	s.PlatformBranchSummaryList = v
	return s
}

type ListPlatformVersionsInput struct {
	_ struct{} `type:"structure"`

	// Criteria for restricting the resulting list of platform versions. The filter
	// is interpreted as a logical conjunction (AND) of the separate PlatformFilter
	// terms.
	Filters []*PlatformFilter `type:"list"`

	// The maximum number of platform version values returned in one call.
	MaxRecords *int64 `min:"1" type:"integer"`

	// For a paginated request. Specify a token from a previous response page to
	// retrieve the next response page. All other parameter values must be identical
	// to the ones specified in the initial request.
	//
	// If no NextToken is specified, the first page is retrieved.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListPlatformVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPlatformVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPlatformVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPlatformVersionsInput"}
	if s.MaxRecords != nil && *s.MaxRecords < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRecords", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListPlatformVersionsInput) SetFilters(v []*PlatformFilter) *ListPlatformVersionsInput {
	s.Filters = v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *ListPlatformVersionsInput) SetMaxRecords(v int64) *ListPlatformVersionsInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPlatformVersionsInput) SetNextToken(v string) *ListPlatformVersionsInput {
	s.NextToken = &v
	return s
}

type ListPlatformVersionsOutput struct {
	_ struct{} `type:"structure"`

	// In a paginated request, if this value isn't null, it's the token that you
	// can pass in a subsequent request to get the next response page.
	NextToken *string `type:"string"`

	// Summary information about the platform versions.
	PlatformSummaryList []*PlatformSummary `type:"list"`
}

// String returns the string representation
func (s ListPlatformVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPlatformVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPlatformVersionsOutput) SetNextToken(v string) *ListPlatformVersionsOutput {
	s.NextToken = &v
	return s
}

// SetPlatformSummaryList sets the PlatformSummaryList field's value.
func (s *ListPlatformVersionsOutput) SetPlatformSummaryList(v []*PlatformSummary) *ListPlatformVersionsOutput {
	s.PlatformSummaryList = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resouce for which a tag list is requested.
	//
	// Must be the ARN of an Elastic Beanstalk resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource for which a tag list was requested.
	ResourceArn *string `type:"string"`

	// A list of tag key-value pairs.
	ResourceTags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceOutput) SetResourceArn(v string) *ListTagsForResourceOutput {
	s.ResourceArn = &v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *ListTagsForResourceOutput) SetResourceTags(v []*Tag) *ListTagsForResourceOutput {
	s.ResourceTags = v
	return s
}

// Describes the properties of a Listener for the LoadBalancer.
type Listener struct {
	_ struct{} `type:"structure"`

	// The port that is used by the Listener.
	Port *int64 `type:"integer"`

	// The protocol that is used by the Listener.
	Protocol *string `type:"string"`
}

// String returns the string representation
func (s Listener) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Listener) GoString() string {
	return s.String()
}

// SetPort sets the Port field's value.
func (s *Listener) SetPort(v int64) *Listener {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *Listener) SetProtocol(v string) *Listener {
	s.Protocol = &v
	return s
}

// Describes a LoadBalancer.
type LoadBalancer struct {
	_ struct{} `type:"structure"`

	// The name of the LoadBalancer.
	Name *string `type:"string"`
}

// String returns the string representation
func (s LoadBalancer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoadBalancer) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *LoadBalancer) SetName(v string) *LoadBalancer {
	s.Name = &v
	return s
}

// Describes the details of a LoadBalancer.
type LoadBalancerDescription struct {
	_ struct{} `type:"structure"`

	// The domain name of the LoadBalancer.
	Domain *string `type:"string"`

	// A list of Listeners used by the LoadBalancer.
	Listeners []*Listener `type:"list"`

	// The name of the LoadBalancer.
	LoadBalancerName *string `type:"string"`
}

// String returns the string representation
func (s LoadBalancerDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoadBalancerDescription) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *LoadBalancerDescription) SetDomain(v string) *LoadBalancerDescription {
	s.Domain = &v
	return s
}

// SetListeners sets the Listeners field's value.
func (s *LoadBalancerDescription) SetListeners(v []*Listener) *LoadBalancerDescription {
	s.Listeners = v
	return s
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *LoadBalancerDescription) SetLoadBalancerName(v string) *LoadBalancerDescription {
	s.LoadBalancerName = &v
	return s
}

// The record of an upcoming or in-progress managed action.
type ManagedAction struct {
	_ struct{} `type:"structure"`

	// A description of the managed action.
	ActionDescription *string `type:"string"`

	// A unique identifier for the managed action.
	ActionId *string `type:"string"`

	// The type of managed action.
	ActionType *string `type:"string" enum:"ActionType"`

	// The status of the managed action. If the action is Scheduled, you can apply
	// it immediately with ApplyEnvironmentManagedAction.
	Status *string `type:"string" enum:"ActionStatus"`

	// The start time of the maintenance window in which the managed action will
	// execute.
	WindowStartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ManagedAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ManagedAction) GoString() string {
	return s.String()
}

// SetActionDescription sets the ActionDescription field's value.
func (s *ManagedAction) SetActionDescription(v string) *ManagedAction {
	s.ActionDescription = &v
	return s
}

// SetActionId sets the ActionId field's value.
func (s *ManagedAction) SetActionId(v string) *ManagedAction {
	s.ActionId = &v
	return s
}

// SetActionType sets the ActionType field's value.
func (s *ManagedAction) SetActionType(v string) *ManagedAction {
	s.ActionType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ManagedAction) SetStatus(v string) *ManagedAction {
	s.Status = &v
	return s
}

// SetWindowStartTime sets the WindowStartTime field's value.
func (s *ManagedAction) SetWindowStartTime(v time.Time) *ManagedAction {
	s.WindowStartTime = &v
	return s
}

// The record of a completed or failed managed action.
type ManagedActionHistoryItem struct {
	_ struct{} `type:"structure"`

	// A description of the managed action.
	ActionDescription *string `type:"string"`

	// A unique identifier for the managed action.
	ActionId *string `type:"string"`

	// The type of the managed action.
	ActionType *string `type:"string" enum:"ActionType"`

	// The date and time that the action started executing.
	ExecutedTime *time.Time `type:"timestamp"`

	// If the action failed, a description of the failure.
	FailureDescription *string `type:"string"`

	// If the action failed, the type of failure.
	FailureType *string `type:"string" enum:"FailureType"`

	// The date and time that the action finished executing.
	FinishedTime *time.Time `type:"timestamp"`

	// The status of the action.
	Status *string `type:"string" enum:"ActionHistoryStatus"`
}

// String returns the string representation
func (s ManagedActionHistoryItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ManagedActionHistoryItem) GoString() string {
	return s.String()
}

// SetActionDescription sets the ActionDescription field's value.
func (s *ManagedActionHistoryItem) SetActionDescription(v string) *ManagedActionHistoryItem {
	s.ActionDescription = &v
	return s
}

// SetActionId sets the ActionId field's value.
func (s *ManagedActionHistoryItem) SetActionId(v string) *ManagedActionHistoryItem {
	s.ActionId = &v
	return s
}

// SetActionType sets the ActionType field's value.
func (s *ManagedActionHistoryItem) SetActionType(v string) *ManagedActionHistoryItem {
	s.ActionType = &v
	return s
}

// SetExecutedTime sets the ExecutedTime field's value.
func (s *ManagedActionHistoryItem) SetExecutedTime(v time.Time) *ManagedActionHistoryItem {
	s.ExecutedTime = &v
	return s
}

// SetFailureDescription sets the FailureDescription field's value.
func (s *ManagedActionHistoryItem) SetFailureDescription(v string) *ManagedActionHistoryItem {
	s.FailureDescription = &v
	return s
}

// SetFailureType sets the FailureType field's value.
func (s *ManagedActionHistoryItem) SetFailureType(v string) *ManagedActionHistoryItem {
	s.FailureType = &v
	return s
}

// SetFinishedTime sets the FinishedTime field's value.
func (s *ManagedActionHistoryItem) SetFinishedTime(v time.Time) *ManagedActionHistoryItem {
	s.FinishedTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ManagedActionHistoryItem) SetStatus(v string) *ManagedActionHistoryItem {
	s.Status = &v
	return s
}

// A lifecycle rule that deletes application versions after the specified number
// of days.
type MaxAgeRule struct {
	_ struct{} `type:"structure"`

	// Set to true to delete a version's source bundle from Amazon S3 when Elastic
	// Beanstalk deletes the application version.
	DeleteSourceFromS3 *bool `type:"boolean"`

	// Specify true to apply the rule, or false to disable it.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// Specify the number of days to retain an application versions.
	MaxAgeInDays *int64 `type:"integer"`
}

// String returns the string representation
func (s MaxAgeRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaxAgeRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MaxAgeRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MaxAgeRule"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeleteSourceFromS3 sets the DeleteSourceFromS3 field's value.
func (s *MaxAgeRule) SetDeleteSourceFromS3(v bool) *MaxAgeRule {
	s.DeleteSourceFromS3 = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *MaxAgeRule) SetEnabled(v bool) *MaxAgeRule {
	s.Enabled = &v
	return s
}

// SetMaxAgeInDays sets the MaxAgeInDays field's value.
func (s *MaxAgeRule) SetMaxAgeInDays(v int64) *MaxAgeRule {
	s.MaxAgeInDays = &v
	return s
}

// A lifecycle rule that deletes the oldest application version when the maximum
// count is exceeded.
type MaxCountRule struct {
	_ struct{} `type:"structure"`

	// Set to true to delete a version's source bundle from Amazon S3 when Elastic
	// Beanstalk deletes the application version.
	DeleteSourceFromS3 *bool `type:"boolean"`

	// Specify true to apply the rule, or false to disable it.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// Specify the maximum number of application versions to retain.
	MaxCount *int64 `type:"integer"`
}

// String returns the string representation
func (s MaxCountRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaxCountRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MaxCountRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MaxCountRule"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeleteSourceFromS3 sets the DeleteSourceFromS3 field's value.
func (s *MaxCountRule) SetDeleteSourceFromS3(v bool) *MaxCountRule {
	s.DeleteSourceFromS3 = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *MaxCountRule) SetEnabled(v bool) *MaxCountRule {
	s.Enabled = &v
	return s
}

// SetMaxCount sets the MaxCount field's value.
func (s *MaxCountRule) SetMaxCount(v int64) *MaxCountRule {
	s.MaxCount = &v
	return s
}

// A regular expression representing a restriction on a string configuration
// option value.
type OptionRestrictionRegex struct {
	_ struct{} `type:"structure"`

	// A unique name representing this regular expression.
	Label *string `type:"string"`

	// The regular expression pattern that a string configuration option value with
	// this restriction must match.
	Pattern *string `type:"string"`
}

// String returns the string representation
func (s OptionRestrictionRegex) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionRestrictionRegex) GoString() string {
	return s.String()
}

// SetLabel sets the Label field's value.
func (s *OptionRestrictionRegex) SetLabel(v string) *OptionRestrictionRegex {
	s.Label = &v
	return s
}

// SetPattern sets the Pattern field's value.
func (s *OptionRestrictionRegex) SetPattern(v string) *OptionRestrictionRegex {
	s.Pattern = &v
	return s
}

// A specification identifying an individual configuration option.
type OptionSpecification struct {
	_ struct{} `type:"structure"`

	// A unique namespace identifying the option's associated AWS resource.
	Namespace *string `type:"string"`

	// The name of the configuration option.
	OptionName *string `type:"string"`

	// A unique resource name for a time-based scaling configuration option.
	ResourceName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s OptionSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OptionSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OptionSpecification"}
	if s.ResourceName != nil && len(*s.ResourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNamespace sets the Namespace field's value.
func (s *OptionSpecification) SetNamespace(v string) *OptionSpecification {
	s.Namespace = &v
	return s
}

// SetOptionName sets the OptionName field's value.
func (s *OptionSpecification) SetOptionName(v string) *OptionSpecification {
	s.OptionName = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *OptionSpecification) SetResourceName(v string) *OptionSpecification {
	s.ResourceName = &v
	return s
}

// Summary information about a platform branch.
type PlatformBranchSummary struct {
	_ struct{} `type:"structure"`

	// The name of the platform branch.
	BranchName *string `type:"string"`

	// An ordinal number that designates the order in which platform branches have
	// been added to a platform. This can be helpful, for example, if your code
	// calls the ListPlatformBranches action and then displays a list of platform
	// branches.
	//
	// A larger BranchOrder value designates a newer platform branch within the
	// platform.
	BranchOrder *int64 `type:"integer"`

	// The support life cycle state of the platform branch.
	//
	// Possible values: beta | supported | deprecated | retired
	LifecycleState *string `type:"string"`

	// The name of the platform to which this platform branch belongs.
	PlatformName *string `type:"string"`

	// The environment tiers that platform versions in this branch support.
	//
	// Possible values: WebServer/Standard | Worker/SQS/HTTP
	SupportedTierList []*string `type:"list"`
}

// String returns the string representation
func (s PlatformBranchSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlatformBranchSummary) GoString() string {
	return s.String()
}

// SetBranchName sets the BranchName field's value.
func (s *PlatformBranchSummary) SetBranchName(v string) *PlatformBranchSummary {
	s.BranchName = &v
	return s
}

// SetBranchOrder sets the BranchOrder field's value.
func (s *PlatformBranchSummary) SetBranchOrder(v int64) *PlatformBranchSummary {
	s.BranchOrder = &v
	return s
}

// SetLifecycleState sets the LifecycleState field's value.
func (s *PlatformBranchSummary) SetLifecycleState(v string) *PlatformBranchSummary {
	s.LifecycleState = &v
	return s
}

// SetPlatformName sets the PlatformName field's value.
func (s *PlatformBranchSummary) SetPlatformName(v string) *PlatformBranchSummary {
	s.PlatformName = &v
	return s
}

// SetSupportedTierList sets the SupportedTierList field's value.
func (s *PlatformBranchSummary) SetSupportedTierList(v []*string) *PlatformBranchSummary {
	s.SupportedTierList = v
	return s
}

// Detailed information about a platform version.
type PlatformDescription struct {
	_ struct{} `type:"structure"`

	// The custom AMIs supported by the platform version.
	CustomAmiList []*CustomAmi `type:"list"`

	// The date when the platform version was created.
	DateCreated *time.Time `type:"timestamp"`

	// The date when the platform version was last updated.
	DateUpdated *time.Time `type:"timestamp"`

	// The description of the platform version.
	Description *string `type:"string"`

	// The frameworks supported by the platform version.
	Frameworks []*PlatformFramework `type:"list"`

	// Information about the maintainer of the platform version.
	Maintainer *string `type:"string"`

	// The operating system used by the platform version.
	OperatingSystemName *string `type:"string"`

	// The version of the operating system used by the platform version.
	OperatingSystemVersion *string `type:"string"`

	// The ARN of the platform version.
	PlatformArn *string `type:"string"`

	// The state of the platform version's branch in its lifecycle.
	//
	// Possible values: Beta | Supported | Deprecated | Retired
	PlatformBranchLifecycleState *string `type:"string"`

	// The platform branch to which the platform version belongs.
	PlatformBranchName *string `type:"string"`

	// The category of the platform version.
	PlatformCategory *string `type:"string"`

	// The state of the platform version in its lifecycle.
	//
	// Possible values: Recommended | null
	//
	// If a null value is returned, the platform version isn't the recommended one
	// for its branch. Each platform branch has a single recommended platform version,
	// typically the most recent one.
	PlatformLifecycleState *string `type:"string"`

	// The name of the platform version.
	PlatformName *string `type:"string"`

	// The AWS account ID of the person who created the platform version.
	PlatformOwner *string `type:"string"`

	// The status of the platform version.
	PlatformStatus *string `type:"string" enum:"PlatformStatus"`

	// The version of the platform version.
	PlatformVersion *string `type:"string"`

	// The programming languages supported by the platform version.
	ProgrammingLanguages []*PlatformProgrammingLanguage `type:"list"`

	// The name of the solution stack used by the platform version.
	SolutionStackName *string `type:"string"`

	// The additions supported by the platform version.
	SupportedAddonList []*string `type:"list"`

	// The tiers supported by the platform version.
	SupportedTierList []*string `type:"list"`
}

// String returns the string representation
func (s PlatformDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlatformDescription) GoString() string {
	return s.String()
}

// SetCustomAmiList sets the CustomAmiList field's value.
func (s *PlatformDescription) SetCustomAmiList(v []*CustomAmi) *PlatformDescription {
	s.CustomAmiList = v
	return s
}

// SetDateCreated sets the DateCreated field's value.
func (s *PlatformDescription) SetDateCreated(v time.Time) *PlatformDescription {
	s.DateCreated = &v
	return s
}

// SetDateUpdated sets the DateUpdated field's value.
func (s *PlatformDescription) SetDateUpdated(v time.Time) *PlatformDescription {
	s.DateUpdated = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PlatformDescription) SetDescription(v string) *PlatformDescription {
	s.Description = &v
	return s
}

// SetFrameworks sets the Frameworks field's value.
func (s *PlatformDescription) SetFrameworks(v []*PlatformFramework) *PlatformDescription {
	s.Frameworks = v
	return s
}

// SetMaintainer sets the Maintainer field's value.
func (s *PlatformDescription) SetMaintainer(v string) *PlatformDescription {
	s.Maintainer = &v
	return s
}

// SetOperatingSystemName sets the OperatingSystemName field's value.
func (s *PlatformDescription) SetOperatingSystemName(v string) *PlatformDescription {
	s.OperatingSystemName = &v
	return s
}

// SetOperatingSystemVersion sets the OperatingSystemVersion field's value.
func (s *PlatformDescription) SetOperatingSystemVersion(v string) *PlatformDescription {
	s.OperatingSystemVersion = &v
	return s
}

// SetPlatformArn sets the PlatformArn field's value.
func (s *PlatformDescription) SetPlatformArn(v string) *PlatformDescription {
	s.PlatformArn = &v
	return s
}

// SetPlatformBranchLifecycleState sets the PlatformBranchLifecycleState field's value.
func (s *PlatformDescription) SetPlatformBranchLifecycleState(v string) *PlatformDescription {
	s.PlatformBranchLifecycleState = &v
	return s
}

// SetPlatformBranchName sets the PlatformBranchName field's value.
func (s *PlatformDescription) SetPlatformBranchName(v string) *PlatformDescription {
	s.PlatformBranchName = &v
	return s
}

// SetPlatformCategory sets the PlatformCategory field's value.
func (s *PlatformDescription) SetPlatformCategory(v string) *PlatformDescription {
	s.PlatformCategory = &v
	return s
}

// SetPlatformLifecycleState sets the PlatformLifecycleState field's value.
func (s *PlatformDescription) SetPlatformLifecycleState(v string) *PlatformDescription {
	s.PlatformLifecycleState = &v
	return s
}

// SetPlatformName sets the PlatformName field's value.
func (s *PlatformDescription) SetPlatformName(v string) *PlatformDescription {
	s.PlatformName = &v
	return s
}

// SetPlatformOwner sets the PlatformOwner field's value.
func (s *PlatformDescription) SetPlatformOwner(v string) *PlatformDescription {
	s.PlatformOwner = &v
	return s
}

// SetPlatformStatus sets the PlatformStatus field's value.
func (s *PlatformDescription) SetPlatformStatus(v string) *PlatformDescription {
	s.PlatformStatus = &v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *PlatformDescription) SetPlatformVersion(v string) *PlatformDescription {
	s.PlatformVersion = &v
	return s
}

// SetProgrammingLanguages sets the ProgrammingLanguages field's value.
func (s *PlatformDescription) SetProgrammingLanguages(v []*PlatformProgrammingLanguage) *PlatformDescription {
	s.ProgrammingLanguages = v
	return s
}

// SetSolutionStackName sets the SolutionStackName field's value.
func (s *PlatformDescription) SetSolutionStackName(v string) *PlatformDescription {
	s.SolutionStackName = &v
	return s
}

// SetSupportedAddonList sets the SupportedAddonList field's value.
func (s *PlatformDescription) SetSupportedAddonList(v []*string) *PlatformDescription {
	s.SupportedAddonList = v
	return s
}

// SetSupportedTierList sets the SupportedTierList field's value.
func (s *PlatformDescription) SetSupportedTierList(v []*string) *PlatformDescription {
	s.SupportedTierList = v
	return s
}

// Describes criteria to restrict the results when listing platform versions.
//
// The filter is evaluated as follows: Type Operator Values[1]
type PlatformFilter struct {
	_ struct{} `type:"structure"`

	// The operator to apply to the Type with each of the Values.
	//
	// Valid values: = | != | < | <= | > | >= | contains | begins_with | ends_with
	Operator *string `type:"string"`

	// The platform version attribute to which the filter values are applied.
	//
	// Valid values: PlatformName | PlatformVersion | PlatformStatus | PlatformBranchName
	// | PlatformLifecycleState | PlatformOwner | SupportedTier | SupportedAddon
	// | ProgrammingLanguageName | OperatingSystemName
	Type *string `type:"string"`

	// The list of values applied to the filtering platform version attribute. Only
	// one value is supported for all current operators.
	//
	// The following list shows valid filter values for some filter attributes.
	//
	//    * PlatformStatus: Creating | Failed | Ready | Deleting | Deleted
	//
	//    * PlatformLifecycleState: recommended
	//
	//    * SupportedTier: WebServer/Standard | Worker/SQS/HTTP
	//
	//    * SupportedAddon: Log/S3 | Monitoring/Healthd | WorkerDaemon/SQSD
	Values []*string `type:"list"`
}

// String returns the string representation
func (s PlatformFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlatformFilter) GoString() string {
	return s.String()
}

// SetOperator sets the Operator field's value.
func (s *PlatformFilter) SetOperator(v string) *PlatformFilter {
	s.Operator = &v
	return s
}

// SetType sets the Type field's value.
func (s *PlatformFilter) SetType(v string) *PlatformFilter {
	s.Type = &v
	return s
}

// SetValues sets the Values field's value.
func (s *PlatformFilter) SetValues(v []*string) *PlatformFilter {
	s.Values = v
	return s
}

// A framework supported by the platform.
type PlatformFramework struct {
	_ struct{} `type:"structure"`

	// The name of the framework.
	Name *string `type:"string"`

	// The version of the framework.
	Version *string `type:"string"`
}

// String returns the string representation
func (s PlatformFramework) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlatformFramework) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *PlatformFramework) SetName(v string) *PlatformFramework {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *PlatformFramework) SetVersion(v string) *PlatformFramework {
	s.Version = &v
	return s
}

// A programming language supported by the platform.
type PlatformProgrammingLanguage struct {
	_ struct{} `type:"structure"`

	// The name of the programming language.
	Name *string `type:"string"`

	// The version of the programming language.
	Version *string `type:"string"`
}

// String returns the string representation
func (s PlatformProgrammingLanguage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlatformProgrammingLanguage) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *PlatformProgrammingLanguage) SetName(v string) *PlatformProgrammingLanguage {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *PlatformProgrammingLanguage) SetVersion(v string) *PlatformProgrammingLanguage {
	s.Version = &v
	return s
}

// Summary information about a platform version.
type PlatformSummary struct {
	_ struct{} `type:"structure"`

	// The operating system used by the platform version.
	OperatingSystemName *string `type:"string"`

	// The version of the operating system used by the platform version.
	OperatingSystemVersion *string `type:"string"`

	// The ARN of the platform version.
	PlatformArn *string `type:"string"`

	// The state of the platform version's branch in its lifecycle.
	//
	// Possible values: beta | supported | deprecated | retired
	PlatformBranchLifecycleState *string `type:"string"`

	// The platform branch to which the platform version belongs.
	PlatformBranchName *string `type:"string"`

	// The category of platform version.
	PlatformCategory *string `type:"string"`

	// The state of the platform version in its lifecycle.
	//
	// Possible values: recommended | empty
	//
	// If an empty value is returned, the platform version is supported but isn't
	// the recommended one for its branch.
	PlatformLifecycleState *string `type:"string"`

	// The AWS account ID of the person who created the platform version.
	PlatformOwner *string `type:"string"`

	// The status of the platform version. You can create an environment from the
	// platform version once it is ready.
	PlatformStatus *string `type:"string" enum:"PlatformStatus"`

	// The version string of the platform version.
	PlatformVersion *string `type:"string"`

	// The additions associated with the platform version.
	SupportedAddonList []*string `type:"list"`

	// The tiers in which the platform version runs.
	SupportedTierList []*string `type:"list"`
}

// String returns the string representation
func (s PlatformSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlatformSummary) GoString() string {
	return s.String()
}

// SetOperatingSystemName sets the OperatingSystemName field's value.
func (s *PlatformSummary) SetOperatingSystemName(v string) *PlatformSummary {
	s.OperatingSystemName = &v
	return s
}

// SetOperatingSystemVersion sets the OperatingSystemVersion field's value.
func (s *PlatformSummary) SetOperatingSystemVersion(v string) *PlatformSummary {
	s.OperatingSystemVersion = &v
	return s
}

// SetPlatformArn sets the PlatformArn field's value.
func (s *PlatformSummary) SetPlatformArn(v string) *PlatformSummary {
	s.PlatformArn = &v
	return s
}

// SetPlatformBranchLifecycleState sets the PlatformBranchLifecycleState field's value.
func (s *PlatformSummary) SetPlatformBranchLifecycleState(v string) *PlatformSummary {
	s.PlatformBranchLifecycleState = &v
	return s
}

// SetPlatformBranchName sets the PlatformBranchName field's value.
func (s *PlatformSummary) SetPlatformBranchName(v string) *PlatformSummary {
	s.PlatformBranchName = &v
	return s
}

// SetPlatformCategory sets the PlatformCategory field's value.
func (s *PlatformSummary) SetPlatformCategory(v string) *PlatformSummary {
	s.PlatformCategory = &v
	return s
}

// SetPlatformLifecycleState sets the PlatformLifecycleState field's value.
func (s *PlatformSummary) SetPlatformLifecycleState(v string) *PlatformSummary {
	s.PlatformLifecycleState = &v
	return s
}

// SetPlatformOwner sets the PlatformOwner field's value.
func (s *PlatformSummary) SetPlatformOwner(v string) *PlatformSummary {
	s.PlatformOwner = &v
	return s
}

// SetPlatformStatus sets the PlatformStatus field's value.
func (s *PlatformSummary) SetPlatformStatus(v string) *PlatformSummary {
	s.PlatformStatus = &v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *PlatformSummary) SetPlatformVersion(v string) *PlatformSummary {
	s.PlatformVersion = &v
	return s
}

// SetSupportedAddonList sets the SupportedAddonList field's value.
func (s *PlatformSummary) SetSupportedAddonList(v []*string) *PlatformSummary {
	s.SupportedAddonList = v
	return s
}

// SetSupportedTierList sets the SupportedTierList field's value.
func (s *PlatformSummary) SetSupportedTierList(v []*string) *PlatformSummary {
	s.SupportedTierList = v
	return s
}

// Describes a queue.
type Queue struct {
	_ struct{} `type:"structure"`

	// The name of the queue.
	Name *string `type:"string"`

	// The URL of the queue.
	URL *string `type:"string"`
}

// String returns the string representation
func (s Queue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Queue) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Queue) SetName(v string) *Queue {
	s.Name = &v
	return s
}

// SetURL sets the URL field's value.
func (s *Queue) SetURL(v string) *Queue {
	s.URL = &v
	return s
}

type RebuildEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The ID of the environment to rebuild.
	//
	// Condition: You must specify either this or an EnvironmentName, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentId *string `type:"string"`

	// The name of the environment to rebuild.
	//
	// Condition: You must specify either this or an EnvironmentId, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentName *string `min:"4" type:"string"`
}

// String returns the string representation
func (s RebuildEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebuildEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebuildEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebuildEnvironmentInput"}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *RebuildEnvironmentInput) SetEnvironmentId(v string) *RebuildEnvironmentInput {
	s.EnvironmentId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *RebuildEnvironmentInput) SetEnvironmentName(v string) *RebuildEnvironmentInput {
	s.EnvironmentName = &v
	return s
}

type RebuildEnvironmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RebuildEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebuildEnvironmentOutput) GoString() string {
	return s.String()
}

// Request to retrieve logs from an environment and store them in your Elastic
// Beanstalk storage bucket.
type RequestEnvironmentInfoInput struct {
	_ struct{} `type:"structure"`

	// The ID of the environment of the requested data.
	//
	// If no such environment is found, RequestEnvironmentInfo returns an InvalidParameterValue
	// error.
	//
	// Condition: You must specify either this or an EnvironmentName, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentId *string `type:"string"`

	// The name of the environment of the requested data.
	//
	// If no such environment is found, RequestEnvironmentInfo returns an InvalidParameterValue
	// error.
	//
	// Condition: You must specify either this or an EnvironmentId, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentName *string `min:"4" type:"string"`

	// The type of information to request.
	//
	// InfoType is a required field
	InfoType *string `type:"string" required:"true" enum:"EnvironmentInfoType"`
}

// String returns the string representation
func (s RequestEnvironmentInfoInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestEnvironmentInfoInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequestEnvironmentInfoInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RequestEnvironmentInfoInput"}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 4))
	}
	if s.InfoType == nil {
		invalidParams.Add(request.NewErrParamRequired("InfoType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *RequestEnvironmentInfoInput) SetEnvironmentId(v string) *RequestEnvironmentInfoInput {
	s.EnvironmentId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *RequestEnvironmentInfoInput) SetEnvironmentName(v string) *RequestEnvironmentInfoInput {
	s.EnvironmentName = &v
	return s
}

// SetInfoType sets the InfoType field's value.
func (s *RequestEnvironmentInfoInput) SetInfoType(v string) *RequestEnvironmentInfoInput {
	s.InfoType = &v
	return s
}

type RequestEnvironmentInfoOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RequestEnvironmentInfoOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestEnvironmentInfoOutput) GoString() string {
	return s.String()
}

// The AWS Elastic Beanstalk quota information for a single resource type in
// an AWS account. It reflects the resource's limits for this account.
type ResourceQuota struct {
	_ struct{} `type:"structure"`

	// The maximum number of instances of this Elastic Beanstalk resource type that
	// an AWS account can use.
	Maximum *int64 `type:"integer"`
}

// String returns the string representation
func (s ResourceQuota) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceQuota) GoString() string {
	return s.String()
}

// SetMaximum sets the Maximum field's value.
func (s *ResourceQuota) SetMaximum(v int64) *ResourceQuota {
	s.Maximum = &v
	return s
}

// A set of per-resource AWS Elastic Beanstalk quotas associated with an AWS
// account. They reflect Elastic Beanstalk resource limits for this account.
type ResourceQuotas struct {
	_ struct{} `type:"structure"`

	// The quota for applications in the AWS account.
	ApplicationQuota *ResourceQuota `type:"structure"`

	// The quota for application versions in the AWS account.
	ApplicationVersionQuota *ResourceQuota `type:"structure"`

	// The quota for configuration templates in the AWS account.
	ConfigurationTemplateQuota *ResourceQuota `type:"structure"`

	// The quota for custom platforms in the AWS account.
	CustomPlatformQuota *ResourceQuota `type:"structure"`

	// The quota for environments in the AWS account.
	EnvironmentQuota *ResourceQuota `type:"structure"`
}

// String returns the string representation
func (s ResourceQuotas) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceQuotas) GoString() string {
	return s.String()
}

// SetApplicationQuota sets the ApplicationQuota field's value.
func (s *ResourceQuotas) SetApplicationQuota(v *ResourceQuota) *ResourceQuotas {
	s.ApplicationQuota = v
	return s
}

// SetApplicationVersionQuota sets the ApplicationVersionQuota field's value.
func (s *ResourceQuotas) SetApplicationVersionQuota(v *ResourceQuota) *ResourceQuotas {
	s.ApplicationVersionQuota = v
	return s
}

// SetConfigurationTemplateQuota sets the ConfigurationTemplateQuota field's value.
func (s *ResourceQuotas) SetConfigurationTemplateQuota(v *ResourceQuota) *ResourceQuotas {
	s.ConfigurationTemplateQuota = v
	return s
}

// SetCustomPlatformQuota sets the CustomPlatformQuota field's value.
func (s *ResourceQuotas) SetCustomPlatformQuota(v *ResourceQuota) *ResourceQuotas {
	s.CustomPlatformQuota = v
	return s
}

// SetEnvironmentQuota sets the EnvironmentQuota field's value.
func (s *ResourceQuotas) SetEnvironmentQuota(v *ResourceQuota) *ResourceQuotas {
	s.EnvironmentQuota = v
	return s
}

type RestartAppServerInput struct {
	_ struct{} `type:"structure"`

	// The ID of the environment to restart the server for.
	//
	// Condition: You must specify either this or an EnvironmentName, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentId *string `type:"string"`

	// The name of the environment to restart the server for.
	//
	// Condition: You must specify either this or an EnvironmentId, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentName *string `min:"4" type:"string"`
}

// String returns the string representation
func (s RestartAppServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestartAppServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestartAppServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestartAppServerInput"}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *RestartAppServerInput) SetEnvironmentId(v string) *RestartAppServerInput {
	s.EnvironmentId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *RestartAppServerInput) SetEnvironmentName(v string) *RestartAppServerInput {
	s.EnvironmentName = &v
	return s
}

type RestartAppServerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RestartAppServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestartAppServerOutput) GoString() string {
	return s.String()
}

// Request to download logs retrieved with RequestEnvironmentInfo.
type RetrieveEnvironmentInfoInput struct {
	_ struct{} `type:"structure"`

	// The ID of the data's environment.
	//
	// If no such environment is found, returns an InvalidParameterValue error.
	//
	// Condition: You must specify either this or an EnvironmentName, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentId *string `type:"string"`

	// The name of the data's environment.
	//
	// If no such environment is found, returns an InvalidParameterValue error.
	//
	// Condition: You must specify either this or an EnvironmentId, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentName *string `min:"4" type:"string"`

	// The type of information to retrieve.
	//
	// InfoType is a required field
	InfoType *string `type:"string" required:"true" enum:"EnvironmentInfoType"`
}

// String returns the string representation
func (s RetrieveEnvironmentInfoInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetrieveEnvironmentInfoInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrieveEnvironmentInfoInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetrieveEnvironmentInfoInput"}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 4))
	}
	if s.InfoType == nil {
		invalidParams.Add(request.NewErrParamRequired("InfoType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *RetrieveEnvironmentInfoInput) SetEnvironmentId(v string) *RetrieveEnvironmentInfoInput {
	s.EnvironmentId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *RetrieveEnvironmentInfoInput) SetEnvironmentName(v string) *RetrieveEnvironmentInfoInput {
	s.EnvironmentName = &v
	return s
}

// SetInfoType sets the InfoType field's value.
func (s *RetrieveEnvironmentInfoInput) SetInfoType(v string) *RetrieveEnvironmentInfoInput {
	s.InfoType = &v
	return s
}

// Result message containing a description of the requested environment info.
type RetrieveEnvironmentInfoOutput struct {
	_ struct{} `type:"structure"`

	// The EnvironmentInfoDescription of the environment.
	EnvironmentInfo []*EnvironmentInfoDescription `type:"list"`
}

// String returns the string representation
func (s RetrieveEnvironmentInfoOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetrieveEnvironmentInfoOutput) GoString() string {
	return s.String()
}

// SetEnvironmentInfo sets the EnvironmentInfo field's value.
func (s *RetrieveEnvironmentInfoOutput) SetEnvironmentInfo(v []*EnvironmentInfoDescription) *RetrieveEnvironmentInfoOutput {
	s.EnvironmentInfo = v
	return s
}

// The bucket and key of an item stored in Amazon S3.
type S3Location struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket where the data is located.
	S3Bucket *string `type:"string"`

	// The Amazon S3 key where the data is located.
	S3Key *string `type:"string"`
}

// String returns the string representation
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Location) GoString() string {
	return s.String()
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *S3Location) SetS3Bucket(v string) *S3Location {
	s.S3Bucket = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *S3Location) SetS3Key(v string) *S3Location {
	s.S3Key = &v
	return s
}

// Describes criteria to restrict a list of results.
//
// For operators that apply a single value to the attribute, the filter is evaluated
// as follows: Attribute Operator Values[1]
//
// Some operators, e.g. in, can apply multiple values. In this case, the filter
// is evaluated as a logical union (OR) of applications of the operator to the
// attribute with each one of the values: (Attribute Operator Values[1]) OR
// (Attribute Operator Values[2]) OR ...
//
// The valid values for attributes of SearchFilter depend on the API action.
// For valid values, see the reference page for the API action you're calling
// that takes a SearchFilter parameter.
type SearchFilter struct {
	_ struct{} `type:"structure"`

	// The result attribute to which the filter values are applied. Valid values
	// vary by API action.
	Attribute *string `type:"string"`

	// The operator to apply to the Attribute with each of the Values. Valid values
	// vary by Attribute.
	Operator *string `type:"string"`

	// The list of values applied to the Attribute and Operator attributes. Number
	// of values and valid values vary by Attribute.
	Values []*string `type:"list"`
}

// String returns the string representation
func (s SearchFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchFilter) GoString() string {
	return s.String()
}

// SetAttribute sets the Attribute field's value.
func (s *SearchFilter) SetAttribute(v string) *SearchFilter {
	s.Attribute = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *SearchFilter) SetOperator(v string) *SearchFilter {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *SearchFilter) SetValues(v []*string) *SearchFilter {
	s.Values = v
	return s
}

// Detailed health information about an Amazon EC2 instance in your Elastic
// Beanstalk environment.
type SingleInstanceHealth struct {
	_ struct{} `type:"structure"`

	// Request metrics from your application.
	ApplicationMetrics *ApplicationMetrics `type:"structure"`

	// The availability zone in which the instance runs.
	AvailabilityZone *string `type:"string"`

	// Represents the causes, which provide more information about the current health
	// status.
	Causes []*string `type:"list"`

	// Represents the color indicator that gives you information about the health
	// of the EC2 instance. For more information, see Health Colors and Statuses
	// (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html).
	Color *string `type:"string"`

	// Information about the most recent deployment to an instance.
	Deployment *Deployment `type:"structure"`

	// Returns the health status of the specified instance. For more information,
	// see Health Colors and Statuses (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html).
	HealthStatus *string `type:"string"`

	// The ID of the Amazon EC2 instance.
	InstanceId *string `min:"1" type:"string"`

	// The instance's type.
	InstanceType *string `type:"string"`

	// The time at which the EC2 instance was launched.
	LaunchedAt *time.Time `type:"timestamp"`

	// Operating system metrics from the instance.
	System *SystemStatus `type:"structure"`
}

// String returns the string representation
func (s SingleInstanceHealth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SingleInstanceHealth) GoString() string {
	return s.String()
}

// SetApplicationMetrics sets the ApplicationMetrics field's value.
func (s *SingleInstanceHealth) SetApplicationMetrics(v *ApplicationMetrics) *SingleInstanceHealth {
	s.ApplicationMetrics = v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *SingleInstanceHealth) SetAvailabilityZone(v string) *SingleInstanceHealth {
	s.AvailabilityZone = &v
	return s
}

// SetCauses sets the Causes field's value.
func (s *SingleInstanceHealth) SetCauses(v []*string) *SingleInstanceHealth {
	s.Causes = v
	return s
}

// SetColor sets the Color field's value.
func (s *SingleInstanceHealth) SetColor(v string) *SingleInstanceHealth {
	s.Color = &v
	return s
}

// SetDeployment sets the Deployment field's value.
func (s *SingleInstanceHealth) SetDeployment(v *Deployment) *SingleInstanceHealth {
	s.Deployment = v
	return s
}

// SetHealthStatus sets the HealthStatus field's value.
func (s *SingleInstanceHealth) SetHealthStatus(v string) *SingleInstanceHealth {
	s.HealthStatus = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *SingleInstanceHealth) SetInstanceId(v string) *SingleInstanceHealth {
	s.InstanceId = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *SingleInstanceHealth) SetInstanceType(v string) *SingleInstanceHealth {
	s.InstanceType = &v
	return s
}

// SetLaunchedAt sets the LaunchedAt field's value.
func (s *SingleInstanceHealth) SetLaunchedAt(v time.Time) *SingleInstanceHealth {
	s.LaunchedAt = &v
	return s
}

// SetSystem sets the System field's value.
func (s *SingleInstanceHealth) SetSystem(v *SystemStatus) *SingleInstanceHealth {
	s.System = v
	return s
}

// Describes the solution stack.
type SolutionStackDescription struct {
	_ struct{} `type:"structure"`

	// The permitted file types allowed for a solution stack.
	PermittedFileTypes []*string `type:"list"`

	// The name of the solution stack.
	SolutionStackName *string `type:"string"`
}

// String returns the string representation
func (s SolutionStackDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SolutionStackDescription) GoString() string {
	return s.String()
}

// SetPermittedFileTypes sets the PermittedFileTypes field's value.
func (s *SolutionStackDescription) SetPermittedFileTypes(v []*string) *SolutionStackDescription {
	s.PermittedFileTypes = v
	return s
}

// SetSolutionStackName sets the SolutionStackName field's value.
func (s *SolutionStackDescription) SetSolutionStackName(v string) *SolutionStackDescription {
	s.SolutionStackName = &v
	return s
}

// Location of the source code for an application version.
type SourceBuildInformation struct {
	_ struct{} `type:"structure"`

	// The location of the source code, as a formatted string, depending on the
	// value of SourceRepository
	//
	//    * For CodeCommit, the format is the repository name and commit ID, separated
	//    by a forward slash. For example, my-git-repo/265cfa0cf6af46153527f55d6503ec030551f57a.
	//
	//    * For S3, the format is the S3 bucket name and object key, separated by
	//    a forward slash. For example, my-s3-bucket/Folders/my-source-file.
	//
	// SourceLocation is a required field
	SourceLocation *string `min:"3" type:"string" required:"true"`

	// Location where the repository is stored.
	//
	//    * CodeCommit
	//
	//    * S3
	//
	// SourceRepository is a required field
	SourceRepository *string `type:"string" required:"true" enum:"SourceRepository"`

	// The type of repository.
	//
	//    * Git
	//
	//    * Zip
	//
	// SourceType is a required field
	SourceType *string `type:"string" required:"true" enum:"SourceType"`
}

// String returns the string representation
func (s SourceBuildInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceBuildInformation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceBuildInformation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceBuildInformation"}
	if s.SourceLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceLocation"))
	}
	if s.SourceLocation != nil && len(*s.SourceLocation) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("SourceLocation", 3))
	}
	if s.SourceRepository == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceRepository"))
	}
	if s.SourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceLocation sets the SourceLocation field's value.
func (s *SourceBuildInformation) SetSourceLocation(v string) *SourceBuildInformation {
	s.SourceLocation = &v
	return s
}

// SetSourceRepository sets the SourceRepository field's value.
func (s *SourceBuildInformation) SetSourceRepository(v string) *SourceBuildInformation {
	s.SourceRepository = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *SourceBuildInformation) SetSourceType(v string) *SourceBuildInformation {
	s.SourceType = &v
	return s
}

// A specification for an environment configuration.
type SourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the application associated with the configuration.
	ApplicationName *string `min:"1" type:"string"`

	// The name of the configuration template.
	TemplateName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceConfiguration"}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *SourceConfiguration) SetApplicationName(v string) *SourceConfiguration {
	s.ApplicationName = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *SourceConfiguration) SetTemplateName(v string) *SourceConfiguration {
	s.TemplateName = &v
	return s
}

// Represents the percentage of requests over the last 10 seconds that resulted
// in each type of status code response. For more information, see Status Code
// Definitions (http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html).
type StatusCodes struct {
	_ struct{} `type:"structure"`

	// The percentage of requests over the last 10 seconds that resulted in a 2xx
	// (200, 201, etc.) status code.
	Status2xx *int64 `type:"integer"`

	// The percentage of requests over the last 10 seconds that resulted in a 3xx
	// (300, 301, etc.) status code.
	Status3xx *int64 `type:"integer"`

	// The percentage of requests over the last 10 seconds that resulted in a 4xx
	// (400, 401, etc.) status code.
	Status4xx *int64 `type:"integer"`

	// The percentage of requests over the last 10 seconds that resulted in a 5xx
	// (500, 501, etc.) status code.
	Status5xx *int64 `type:"integer"`
}

// String returns the string representation
func (s StatusCodes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusCodes) GoString() string {
	return s.String()
}

// SetStatus2xx sets the Status2xx field's value.
func (s *StatusCodes) SetStatus2xx(v int64) *StatusCodes {
	s.Status2xx = &v
	return s
}

// SetStatus3xx sets the Status3xx field's value.
func (s *StatusCodes) SetStatus3xx(v int64) *StatusCodes {
	s.Status3xx = &v
	return s
}

// SetStatus4xx sets the Status4xx field's value.
func (s *StatusCodes) SetStatus4xx(v int64) *StatusCodes {
	s.Status4xx = &v
	return s
}

// SetStatus5xx sets the Status5xx field's value.
func (s *StatusCodes) SetStatus5xx(v int64) *StatusCodes {
	s.Status5xx = &v
	return s
}

// Swaps the CNAMEs of two environments.
type SwapEnvironmentCNAMEsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the destination environment.
	//
	// Condition: You must specify at least the DestinationEnvironmentID or the
	// DestinationEnvironmentName. You may also specify both. You must specify the
	// SourceEnvironmentId with the DestinationEnvironmentId.
	DestinationEnvironmentId *string `type:"string"`

	// The name of the destination environment.
	//
	// Condition: You must specify at least the DestinationEnvironmentID or the
	// DestinationEnvironmentName. You may also specify both. You must specify the
	// SourceEnvironmentName with the DestinationEnvironmentName.
	DestinationEnvironmentName *string `min:"4" type:"string"`

	// The ID of the source environment.
	//
	// Condition: You must specify at least the SourceEnvironmentID or the SourceEnvironmentName.
	// You may also specify both. If you specify the SourceEnvironmentId, you must
	// specify the DestinationEnvironmentId.
	SourceEnvironmentId *string `type:"string"`

	// The name of the source environment.
	//
	// Condition: You must specify at least the SourceEnvironmentID or the SourceEnvironmentName.
	// You may also specify both. If you specify the SourceEnvironmentName, you
	// must specify the DestinationEnvironmentName.
	SourceEnvironmentName *string `min:"4" type:"string"`
}

// String returns the string representation
func (s SwapEnvironmentCNAMEsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SwapEnvironmentCNAMEsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SwapEnvironmentCNAMEsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SwapEnvironmentCNAMEsInput"}
	if s.DestinationEnvironmentName != nil && len(*s.DestinationEnvironmentName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationEnvironmentName", 4))
	}
	if s.SourceEnvironmentName != nil && len(*s.SourceEnvironmentName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("SourceEnvironmentName", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationEnvironmentId sets the DestinationEnvironmentId field's value.
func (s *SwapEnvironmentCNAMEsInput) SetDestinationEnvironmentId(v string) *SwapEnvironmentCNAMEsInput {
	s.DestinationEnvironmentId = &v
	return s
}

// SetDestinationEnvironmentName sets the DestinationEnvironmentName field's value.
func (s *SwapEnvironmentCNAMEsInput) SetDestinationEnvironmentName(v string) *SwapEnvironmentCNAMEsInput {
	s.DestinationEnvironmentName = &v
	return s
}

// SetSourceEnvironmentId sets the SourceEnvironmentId field's value.
func (s *SwapEnvironmentCNAMEsInput) SetSourceEnvironmentId(v string) *SwapEnvironmentCNAMEsInput {
	s.SourceEnvironmentId = &v
	return s
}

// SetSourceEnvironmentName sets the SourceEnvironmentName field's value.
func (s *SwapEnvironmentCNAMEsInput) SetSourceEnvironmentName(v string) *SwapEnvironmentCNAMEsInput {
	s.SourceEnvironmentName = &v
	return s
}

type SwapEnvironmentCNAMEsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SwapEnvironmentCNAMEsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SwapEnvironmentCNAMEsOutput) GoString() string {
	return s.String()
}

// CPU utilization and load average metrics for an Amazon EC2 instance.
type SystemStatus struct {
	_ struct{} `type:"structure"`

	// CPU utilization metrics for the instance.
	CPUUtilization *CPUUtilization `type:"structure"`

	// Load average in the last 1-minute, 5-minute, and 15-minute periods. For more
	// information, see Operating System Metrics (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-metrics.html#health-enhanced-metrics-os).
	LoadAverage []*float64 `type:"list"`
}

// String returns the string representation
func (s SystemStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SystemStatus) GoString() string {
	return s.String()
}

// SetCPUUtilization sets the CPUUtilization field's value.
func (s *SystemStatus) SetCPUUtilization(v *CPUUtilization) *SystemStatus {
	s.CPUUtilization = v
	return s
}

// SetLoadAverage sets the LoadAverage field's value.
func (s *SystemStatus) SetLoadAverage(v []*float64) *SystemStatus {
	s.LoadAverage = v
	return s
}

// Describes a tag applied to a resource in an environment.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	Key *string `min:"1" type:"string"`

	// The value of the tag.
	Value *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Request to terminate an environment.
type TerminateEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The ID of the environment to terminate.
	//
	// Condition: You must specify either this or an EnvironmentName, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentId *string `type:"string"`

	// The name of the environment to terminate.
	//
	// Condition: You must specify either this or an EnvironmentId, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentName *string `min:"4" type:"string"`

	// Terminates the target environment even if another environment in the same
	// group is dependent on it.
	ForceTerminate *bool `type:"boolean"`

	// Indicates whether the associated AWS resources should shut down when the
	// environment is terminated:
	//
	//    * true: The specified environment as well as the associated AWS resources,
	//    such as Auto Scaling group and LoadBalancer, are terminated.
	//
	//    * false: AWS Elastic Beanstalk resource management is removed from the
	//    environment, but the AWS resources continue to operate.
	//
	// For more information, see the AWS Elastic Beanstalk User Guide. (https://docs.aws.amazon.com/elasticbeanstalk/latest/ug/)
	//
	// Default: true
	//
	// Valid Values: true | false
	TerminateResources *bool `type:"boolean"`
}

// String returns the string representation
func (s TerminateEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminateEnvironmentInput"}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *TerminateEnvironmentInput) SetEnvironmentId(v string) *TerminateEnvironmentInput {
	s.EnvironmentId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *TerminateEnvironmentInput) SetEnvironmentName(v string) *TerminateEnvironmentInput {
	s.EnvironmentName = &v
	return s
}

// SetForceTerminate sets the ForceTerminate field's value.
func (s *TerminateEnvironmentInput) SetForceTerminate(v bool) *TerminateEnvironmentInput {
	s.ForceTerminate = &v
	return s
}

// SetTerminateResources sets the TerminateResources field's value.
func (s *TerminateEnvironmentInput) SetTerminateResources(v bool) *TerminateEnvironmentInput {
	s.TerminateResources = &v
	return s
}

// Describes a trigger.
type Trigger struct {
	_ struct{} `type:"structure"`

	// The name of the trigger.
	Name *string `type:"string"`
}

// String returns the string representation
func (s Trigger) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Trigger) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Trigger) SetName(v string) *Trigger {
	s.Name = &v
	return s
}

// Request to update an application.
type UpdateApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name of the application to update. If no such application is found, UpdateApplication
	// returns an InvalidParameterValue error.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// A new description for the application.
	//
	// Default: If not specified, AWS Elastic Beanstalk does not update the description.
	Description *string `type:"string"`
}

// String returns the string representation
func (s UpdateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *UpdateApplicationInput) SetApplicationName(v string) *UpdateApplicationInput {
	s.ApplicationName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateApplicationInput) SetDescription(v string) *UpdateApplicationInput {
	s.Description = &v
	return s
}

type UpdateApplicationResourceLifecycleInput struct {
	_ struct{} `type:"structure"`

	// The name of the application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The lifecycle configuration.
	//
	// ResourceLifecycleConfig is a required field
	ResourceLifecycleConfig *ApplicationResourceLifecycleConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateApplicationResourceLifecycleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationResourceLifecycleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationResourceLifecycleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationResourceLifecycleInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.ResourceLifecycleConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceLifecycleConfig"))
	}
	if s.ResourceLifecycleConfig != nil {
		if err := s.ResourceLifecycleConfig.Validate(); err != nil {
			invalidParams.AddNested("ResourceLifecycleConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *UpdateApplicationResourceLifecycleInput) SetApplicationName(v string) *UpdateApplicationResourceLifecycleInput {
	s.ApplicationName = &v
	return s
}

// SetResourceLifecycleConfig sets the ResourceLifecycleConfig field's value.
func (s *UpdateApplicationResourceLifecycleInput) SetResourceLifecycleConfig(v *ApplicationResourceLifecycleConfig) *UpdateApplicationResourceLifecycleInput {
	s.ResourceLifecycleConfig = v
	return s
}

type UpdateApplicationResourceLifecycleOutput struct {
	_ struct{} `type:"structure"`

	// The name of the application.
	ApplicationName *string `min:"1" type:"string"`

	// The lifecycle configuration.
	ResourceLifecycleConfig *ApplicationResourceLifecycleConfig `type:"structure"`
}

// String returns the string representation
func (s UpdateApplicationResourceLifecycleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationResourceLifecycleOutput) GoString() string {
	return s.String()
}

// SetApplicationName sets the ApplicationName field's value.
func (s *UpdateApplicationResourceLifecycleOutput) SetApplicationName(v string) *UpdateApplicationResourceLifecycleOutput {
	s.ApplicationName = &v
	return s
}

// SetResourceLifecycleConfig sets the ResourceLifecycleConfig field's value.
func (s *UpdateApplicationResourceLifecycleOutput) SetResourceLifecycleConfig(v *ApplicationResourceLifecycleConfig) *UpdateApplicationResourceLifecycleOutput {
	s.ResourceLifecycleConfig = v
	return s
}

type UpdateApplicationVersionInput struct {
	_ struct{} `type:"structure"`

	// The name of the application associated with this version.
	//
	// If no application is found with this name, UpdateApplication returns an InvalidParameterValue
	// error.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// A new description for this version.
	Description *string `type:"string"`

	// The name of the version to update.
	//
	// If no application version is found with this label, UpdateApplication returns
	// an InvalidParameterValue error.
	//
	// VersionLabel is a required field
	VersionLabel *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateApplicationVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationVersionInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.VersionLabel == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionLabel"))
	}
	if s.VersionLabel != nil && len(*s.VersionLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionLabel", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *UpdateApplicationVersionInput) SetApplicationName(v string) *UpdateApplicationVersionInput {
	s.ApplicationName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateApplicationVersionInput) SetDescription(v string) *UpdateApplicationVersionInput {
	s.Description = &v
	return s
}

// SetVersionLabel sets the VersionLabel field's value.
func (s *UpdateApplicationVersionInput) SetVersionLabel(v string) *UpdateApplicationVersionInput {
	s.VersionLabel = &v
	return s
}

// The result message containing the options for the specified solution stack.
type UpdateConfigurationTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the application associated with the configuration template to
	// update.
	//
	// If no application is found with this name, UpdateConfigurationTemplate returns
	// an InvalidParameterValue error.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// A new description for the configuration.
	Description *string `type:"string"`

	// A list of configuration option settings to update with the new specified
	// option value.
	OptionSettings []*ConfigurationOptionSetting `type:"list"`

	// A list of configuration options to remove from the configuration set.
	//
	// Constraint: You can remove only UserDefined configuration options.
	OptionsToRemove []*OptionSpecification `type:"list"`

	// The name of the configuration template to update.
	//
	// If no configuration template is found with this name, UpdateConfigurationTemplate
	// returns an InvalidParameterValue error.
	//
	// TemplateName is a required field
	TemplateName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateConfigurationTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConfigurationTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConfigurationTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConfigurationTemplateInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}
	if s.OptionSettings != nil {
		for i, v := range s.OptionSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OptionSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OptionsToRemove != nil {
		for i, v := range s.OptionsToRemove {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OptionsToRemove", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *UpdateConfigurationTemplateInput) SetApplicationName(v string) *UpdateConfigurationTemplateInput {
	s.ApplicationName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateConfigurationTemplateInput) SetDescription(v string) *UpdateConfigurationTemplateInput {
	s.Description = &v
	return s
}

// SetOptionSettings sets the OptionSettings field's value.
func (s *UpdateConfigurationTemplateInput) SetOptionSettings(v []*ConfigurationOptionSetting) *UpdateConfigurationTemplateInput {
	s.OptionSettings = v
	return s
}

// SetOptionsToRemove sets the OptionsToRemove field's value.
func (s *UpdateConfigurationTemplateInput) SetOptionsToRemove(v []*OptionSpecification) *UpdateConfigurationTemplateInput {
	s.OptionsToRemove = v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *UpdateConfigurationTemplateInput) SetTemplateName(v string) *UpdateConfigurationTemplateInput {
	s.TemplateName = &v
	return s
}

// Request to update an environment.
type UpdateEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The name of the application with which the environment is associated.
	ApplicationName *string `min:"1" type:"string"`

	// If this parameter is specified, AWS Elastic Beanstalk updates the description
	// of this environment.
	Description *string `type:"string"`

	// The ID of the environment to update.
	//
	// If no environment with this ID exists, AWS Elastic Beanstalk returns an InvalidParameterValue
	// error.
	//
	// Condition: You must specify either this or an EnvironmentName, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentId *string `type:"string"`

	// The name of the environment to update. If no environment with this name exists,
	// AWS Elastic Beanstalk returns an InvalidParameterValue error.
	//
	// Condition: You must specify either this or an EnvironmentId, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentName *string `min:"4" type:"string"`

	// The name of the group to which the target environment belongs. Specify a
	// group name only if the environment's name is specified in an environment
	// manifest and not with the environment name or environment ID parameters.
	// See Environment Manifest (env.yaml) (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html)
	// for details.
	GroupName *string `min:"1" type:"string"`

	// If specified, AWS Elastic Beanstalk updates the configuration set associated
	// with the running environment and sets the specified configuration options
	// to the requested value.
	OptionSettings []*ConfigurationOptionSetting `type:"list"`

	// A list of custom user-defined configuration options to remove from the configuration
	// set for this environment.
	OptionsToRemove []*OptionSpecification `type:"list"`

	// The ARN of the platform, if used.
	PlatformArn *string `type:"string"`

	// This specifies the platform version that the environment will run after the
	// environment is updated.
	SolutionStackName *string `type:"string"`

	// If this parameter is specified, AWS Elastic Beanstalk deploys this configuration
	// template to the environment. If no such configuration template is found,
	// AWS Elastic Beanstalk returns an InvalidParameterValue error.
	TemplateName *string `min:"1" type:"string"`

	// This specifies the tier to use to update the environment.
	//
	// Condition: At this time, if you change the tier version, name, or type, AWS
	// Elastic Beanstalk returns InvalidParameterValue error.
	Tier *EnvironmentTier `type:"structure"`

	// If this parameter is specified, AWS Elastic Beanstalk deploys the named application
	// version to the environment. If no such application version is found, returns
	// an InvalidParameterValue error.
	VersionLabel *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEnvironmentInput"}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 4))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}
	if s.VersionLabel != nil && len(*s.VersionLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionLabel", 1))
	}
	if s.OptionSettings != nil {
		for i, v := range s.OptionSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OptionSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OptionsToRemove != nil {
		for i, v := range s.OptionsToRemove {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OptionsToRemove", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *UpdateEnvironmentInput) SetApplicationName(v string) *UpdateEnvironmentInput {
	s.ApplicationName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateEnvironmentInput) SetDescription(v string) *UpdateEnvironmentInput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *UpdateEnvironmentInput) SetEnvironmentId(v string) *UpdateEnvironmentInput {
	s.EnvironmentId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *UpdateEnvironmentInput) SetEnvironmentName(v string) *UpdateEnvironmentInput {
	s.EnvironmentName = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *UpdateEnvironmentInput) SetGroupName(v string) *UpdateEnvironmentInput {
	s.GroupName = &v
	return s
}

// SetOptionSettings sets the OptionSettings field's value.
func (s *UpdateEnvironmentInput) SetOptionSettings(v []*ConfigurationOptionSetting) *UpdateEnvironmentInput {
	s.OptionSettings = v
	return s
}

// SetOptionsToRemove sets the OptionsToRemove field's value.
func (s *UpdateEnvironmentInput) SetOptionsToRemove(v []*OptionSpecification) *UpdateEnvironmentInput {
	s.OptionsToRemove = v
	return s
}

// SetPlatformArn sets the PlatformArn field's value.
func (s *UpdateEnvironmentInput) SetPlatformArn(v string) *UpdateEnvironmentInput {
	s.PlatformArn = &v
	return s
}

// SetSolutionStackName sets the SolutionStackName field's value.
func (s *UpdateEnvironmentInput) SetSolutionStackName(v string) *UpdateEnvironmentInput {
	s.SolutionStackName = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *UpdateEnvironmentInput) SetTemplateName(v string) *UpdateEnvironmentInput {
	s.TemplateName = &v
	return s
}

// SetTier sets the Tier field's value.
func (s *UpdateEnvironmentInput) SetTier(v *EnvironmentTier) *UpdateEnvironmentInput {
	s.Tier = v
	return s
}

// SetVersionLabel sets the VersionLabel field's value.
func (s *UpdateEnvironmentInput) SetVersionLabel(v string) *UpdateEnvironmentInput {
	s.VersionLabel = &v
	return s
}

type UpdateTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resouce to be updated.
	//
	// Must be the ARN of an Elastic Beanstalk resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// A list of tags to add or update. If a key of an existing tag is added, the
	// tag's value is updated.
	//
	// Specify at least one of these parameters: TagsToAdd, TagsToRemove.
	TagsToAdd []*Tag `type:"list"`

	// A list of tag keys to remove. If a tag key doesn't exist, it is silently
	// ignored.
	//
	// Specify at least one of these parameters: TagsToAdd, TagsToRemove.
	TagsToRemove []*string `type:"list"`
}

// String returns the string representation
func (s UpdateTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagsToAdd != nil {
		for i, v := range s.TagsToAdd {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagsToAdd", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UpdateTagsForResourceInput) SetResourceArn(v string) *UpdateTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagsToAdd sets the TagsToAdd field's value.
func (s *UpdateTagsForResourceInput) SetTagsToAdd(v []*Tag) *UpdateTagsForResourceInput {
	s.TagsToAdd = v
	return s
}

// SetTagsToRemove sets the TagsToRemove field's value.
func (s *UpdateTagsForResourceInput) SetTagsToRemove(v []*string) *UpdateTagsForResourceInput {
	s.TagsToRemove = v
	return s
}

type UpdateTagsForResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTagsForResourceOutput) GoString() string {
	return s.String()
}

// A list of validation messages for a specified configuration template.
type ValidateConfigurationSettingsInput struct {
	_ struct{} `type:"structure"`

	// The name of the application that the configuration template or environment
	// belongs to.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The name of the environment to validate the settings against.
	//
	// Condition: You cannot specify both this and a configuration template name.
	EnvironmentName *string `min:"4" type:"string"`

	// A list of the options and desired values to evaluate.
	//
	// OptionSettings is a required field
	OptionSettings []*ConfigurationOptionSetting `type:"list" required:"true"`

	// The name of the configuration template to validate the settings against.
	//
	// Condition: You cannot specify both this and an environment name.
	TemplateName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ValidateConfigurationSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidateConfigurationSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ValidateConfigurationSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ValidateConfigurationSettingsInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 4))
	}
	if s.OptionSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("OptionSettings"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}
	if s.OptionSettings != nil {
		for i, v := range s.OptionSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OptionSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *ValidateConfigurationSettingsInput) SetApplicationName(v string) *ValidateConfigurationSettingsInput {
	s.ApplicationName = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *ValidateConfigurationSettingsInput) SetEnvironmentName(v string) *ValidateConfigurationSettingsInput {
	s.EnvironmentName = &v
	return s
}

// SetOptionSettings sets the OptionSettings field's value.
func (s *ValidateConfigurationSettingsInput) SetOptionSettings(v []*ConfigurationOptionSetting) *ValidateConfigurationSettingsInput {
	s.OptionSettings = v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *ValidateConfigurationSettingsInput) SetTemplateName(v string) *ValidateConfigurationSettingsInput {
	s.TemplateName = &v
	return s
}

// Provides a list of validation messages.
type ValidateConfigurationSettingsOutput struct {
	_ struct{} `type:"structure"`

	// A list of ValidationMessage.
	Messages []*ValidationMessage `type:"list"`
}

// String returns the string representation
func (s ValidateConfigurationSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidateConfigurationSettingsOutput) GoString() string {
	return s.String()
}

// SetMessages sets the Messages field's value.
func (s *ValidateConfigurationSettingsOutput) SetMessages(v []*ValidationMessage) *ValidateConfigurationSettingsOutput {
	s.Messages = v
	return s
}

// An error or warning for a desired configuration option value.
type ValidationMessage struct {
	_ struct{} `type:"structure"`

	// A message describing the error or warning.
	Message *string `type:"string"`

	// The namespace to which the option belongs.
	Namespace *string `type:"string"`

	// The name of the option.
	OptionName *string `type:"string"`

	// An indication of the severity of this message:
	//
	//    * error: This message indicates that this is not a valid setting for an
	//    option.
	//
	//    * warning: This message is providing information you should take into
	//    account.
	Severity *string `type:"string" enum:"ValidationSeverity"`
}

// String returns the string representation
func (s ValidationMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationMessage) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationMessage) SetMessage(v string) *ValidationMessage {
	s.Message = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ValidationMessage) SetNamespace(v string) *ValidationMessage {
	s.Namespace = &v
	return s
}

// SetOptionName sets the OptionName field's value.
func (s *ValidationMessage) SetOptionName(v string) *ValidationMessage {
	s.OptionName = &v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ValidationMessage) SetSeverity(v string) *ValidationMessage {
	s.Severity = &v
	return s
}

const (
	// ActionHistoryStatusCompleted is a ActionHistoryStatus enum value
	ActionHistoryStatusCompleted = "Completed"

	// ActionHistoryStatusFailed is a ActionHistoryStatus enum value
	ActionHistoryStatusFailed = "Failed"

	// ActionHistoryStatusUnknown is a ActionHistoryStatus enum value
	ActionHistoryStatusUnknown = "Unknown"
)

const (
	// ActionStatusScheduled is a ActionStatus enum value
	ActionStatusScheduled = "Scheduled"

	// ActionStatusPending is a ActionStatus enum value
	ActionStatusPending = "Pending"

	// ActionStatusRunning is a ActionStatus enum value
	ActionStatusRunning = "Running"

	// ActionStatusUnknown is a ActionStatus enum value
	ActionStatusUnknown = "Unknown"
)

const (
	// ActionTypeInstanceRefresh is a ActionType enum value
	ActionTypeInstanceRefresh = "InstanceRefresh"

	// ActionTypePlatformUpdate is a ActionType enum value
	ActionTypePlatformUpdate = "PlatformUpdate"

	// ActionTypeUnknown is a ActionType enum value
	ActionTypeUnknown = "Unknown"
)

const (
	// ApplicationVersionStatusProcessed is a ApplicationVersionStatus enum value
	ApplicationVersionStatusProcessed = "Processed"

	// ApplicationVersionStatusUnprocessed is a ApplicationVersionStatus enum value
	ApplicationVersionStatusUnprocessed = "Unprocessed"

	// ApplicationVersionStatusFailed is a ApplicationVersionStatus enum value
	ApplicationVersionStatusFailed = "Failed"

	// ApplicationVersionStatusProcessing is a ApplicationVersionStatus enum value
	ApplicationVersionStatusProcessing = "Processing"

	// ApplicationVersionStatusBuilding is a ApplicationVersionStatus enum value
	ApplicationVersionStatusBuilding = "Building"
)

const (
	// ComputeTypeBuildGeneral1Small is a ComputeType enum value
	ComputeTypeBuildGeneral1Small = "BUILD_GENERAL1_SMALL"

	// ComputeTypeBuildGeneral1Medium is a ComputeType enum value
	ComputeTypeBuildGeneral1Medium = "BUILD_GENERAL1_MEDIUM"

	// ComputeTypeBuildGeneral1Large is a ComputeType enum value
	ComputeTypeBuildGeneral1Large = "BUILD_GENERAL1_LARGE"
)

const (
	// ConfigurationDeploymentStatusDeployed is a ConfigurationDeploymentStatus enum value
	ConfigurationDeploymentStatusDeployed = "deployed"

	// ConfigurationDeploymentStatusPending is a ConfigurationDeploymentStatus enum value
	ConfigurationDeploymentStatusPending = "pending"

	// ConfigurationDeploymentStatusFailed is a ConfigurationDeploymentStatus enum value
	ConfigurationDeploymentStatusFailed = "failed"
)

const (
	// ConfigurationOptionValueTypeScalar is a ConfigurationOptionValueType enum value
	ConfigurationOptionValueTypeScalar = "Scalar"

	// ConfigurationOptionValueTypeList is a ConfigurationOptionValueType enum value
	ConfigurationOptionValueTypeList = "List"
)

const (
	// EnvironmentHealthGreen is a EnvironmentHealth enum value
	EnvironmentHealthGreen = "Green"

	// EnvironmentHealthYellow is a EnvironmentHealth enum value
	EnvironmentHealthYellow = "Yellow"

	// EnvironmentHealthRed is a EnvironmentHealth enum value
	EnvironmentHealthRed = "Red"

	// EnvironmentHealthGrey is a EnvironmentHealth enum value
	EnvironmentHealthGrey = "Grey"
)

const (
	// EnvironmentHealthAttributeStatus is a EnvironmentHealthAttribute enum value
	EnvironmentHealthAttributeStatus = "Status"

	// EnvironmentHealthAttributeColor is a EnvironmentHealthAttribute enum value
	EnvironmentHealthAttributeColor = "Color"

	// EnvironmentHealthAttributeCauses is a EnvironmentHealthAttribute enum value
	EnvironmentHealthAttributeCauses = "Causes"

	// EnvironmentHealthAttributeApplicationMetrics is a EnvironmentHealthAttribute enum value
	EnvironmentHealthAttributeApplicationMetrics = "ApplicationMetrics"

	// EnvironmentHealthAttributeInstancesHealth is a EnvironmentHealthAttribute enum value
	EnvironmentHealthAttributeInstancesHealth = "InstancesHealth"

	// EnvironmentHealthAttributeAll is a EnvironmentHealthAttribute enum value
	EnvironmentHealthAttributeAll = "All"

	// EnvironmentHealthAttributeHealthStatus is a EnvironmentHealthAttribute enum value
	EnvironmentHealthAttributeHealthStatus = "HealthStatus"

	// EnvironmentHealthAttributeRefreshedAt is a EnvironmentHealthAttribute enum value
	EnvironmentHealthAttributeRefreshedAt = "RefreshedAt"
)

const (
	// EnvironmentHealthStatusNoData is a EnvironmentHealthStatus enum value
	EnvironmentHealthStatusNoData = "NoData"

	// EnvironmentHealthStatusUnknown is a EnvironmentHealthStatus enum value
	EnvironmentHealthStatusUnknown = "Unknown"

	// EnvironmentHealthStatusPending is a EnvironmentHealthStatus enum value
	EnvironmentHealthStatusPending = "Pending"

	// EnvironmentHealthStatusOk is a EnvironmentHealthStatus enum value
	EnvironmentHealthStatusOk = "Ok"

	// EnvironmentHealthStatusInfo is a EnvironmentHealthStatus enum value
	EnvironmentHealthStatusInfo = "Info"

	// EnvironmentHealthStatusWarning is a EnvironmentHealthStatus enum value
	EnvironmentHealthStatusWarning = "Warning"

	// EnvironmentHealthStatusDegraded is a EnvironmentHealthStatus enum value
	EnvironmentHealthStatusDegraded = "Degraded"

	// EnvironmentHealthStatusSevere is a EnvironmentHealthStatus enum value
	EnvironmentHealthStatusSevere = "Severe"

	// EnvironmentHealthStatusSuspended is a EnvironmentHealthStatus enum value
	EnvironmentHealthStatusSuspended = "Suspended"
)

const (
	// EnvironmentInfoTypeTail is a EnvironmentInfoType enum value
	EnvironmentInfoTypeTail = "tail"

	// EnvironmentInfoTypeBundle is a EnvironmentInfoType enum value
	EnvironmentInfoTypeBundle = "bundle"
)

const (
	// EnvironmentStatusLaunching is a EnvironmentStatus enum value
	EnvironmentStatusLaunching = "Launching"

	// EnvironmentStatusUpdating is a EnvironmentStatus enum value
	EnvironmentStatusUpdating = "Updating"

	// EnvironmentStatusReady is a EnvironmentStatus enum value
	EnvironmentStatusReady = "Ready"

	// EnvironmentStatusTerminating is a EnvironmentStatus enum value
	EnvironmentStatusTerminating = "Terminating"

	// EnvironmentStatusTerminated is a EnvironmentStatus enum value
	EnvironmentStatusTerminated = "Terminated"
)

const (
	// EventSeverityTrace is a EventSeverity enum value
	EventSeverityTrace = "TRACE"

	// EventSeverityDebug is a EventSeverity enum value
	EventSeverityDebug = "DEBUG"

	// EventSeverityInfo is a EventSeverity enum value
	EventSeverityInfo = "INFO"

	// EventSeverityWarn is a EventSeverity enum value
	EventSeverityWarn = "WARN"

	// EventSeverityError is a EventSeverity enum value
	EventSeverityError = "ERROR"

	// EventSeverityFatal is a EventSeverity enum value
	EventSeverityFatal = "FATAL"
)

const (
	// FailureTypeUpdateCancelled is a FailureType enum value
	FailureTypeUpdateCancelled = "UpdateCancelled"

	// FailureTypeCancellationFailed is a FailureType enum value
	FailureTypeCancellationFailed = "CancellationFailed"

	// FailureTypeRollbackFailed is a FailureType enum value
	FailureTypeRollbackFailed = "RollbackFailed"

	// FailureTypeRollbackSuccessful is a FailureType enum value
	FailureTypeRollbackSuccessful = "RollbackSuccessful"

	// FailureTypeInternalFailure is a FailureType enum value
	FailureTypeInternalFailure = "InternalFailure"

	// FailureTypeInvalidEnvironmentState is a FailureType enum value
	FailureTypeInvalidEnvironmentState = "InvalidEnvironmentState"

	// FailureTypePermissionsError is a FailureType enum value
	FailureTypePermissionsError = "PermissionsError"
)

const (
	// InstancesHealthAttributeHealthStatus is a InstancesHealthAttribute enum value
	InstancesHealthAttributeHealthStatus = "HealthStatus"

	// InstancesHealthAttributeColor is a InstancesHealthAttribute enum value
	InstancesHealthAttributeColor = "Color"

	// InstancesHealthAttributeCauses is a InstancesHealthAttribute enum value
	InstancesHealthAttributeCauses = "Causes"

	// InstancesHealthAttributeApplicationMetrics is a InstancesHealthAttribute enum value
	InstancesHealthAttributeApplicationMetrics = "ApplicationMetrics"

	// InstancesHealthAttributeRefreshedAt is a InstancesHealthAttribute enum value
	InstancesHealthAttributeRefreshedAt = "RefreshedAt"

	// InstancesHealthAttributeLaunchedAt is a InstancesHealthAttribute enum value
	InstancesHealthAttributeLaunchedAt = "LaunchedAt"

	// InstancesHealthAttributeSystem is a InstancesHealthAttribute enum value
	InstancesHealthAttributeSystem = "System"

	// InstancesHealthAttributeDeployment is a InstancesHealthAttribute enum value
	InstancesHealthAttributeDeployment = "Deployment"

	// InstancesHealthAttributeAvailabilityZone is a InstancesHealthAttribute enum value
	InstancesHealthAttributeAvailabilityZone = "AvailabilityZone"

	// InstancesHealthAttributeInstanceType is a InstancesHealthAttribute enum value
	InstancesHealthAttributeInstanceType = "InstanceType"

	// InstancesHealthAttributeAll is a InstancesHealthAttribute enum value
	InstancesHealthAttributeAll = "All"
)

const (
	// PlatformStatusCreating is a PlatformStatus enum value
	PlatformStatusCreating = "Creating"

	// PlatformStatusFailed is a PlatformStatus enum value
	PlatformStatusFailed = "Failed"

	// PlatformStatusReady is a PlatformStatus enum value
	PlatformStatusReady = "Ready"

	// PlatformStatusDeleting is a PlatformStatus enum value
	PlatformStatusDeleting = "Deleting"

	// PlatformStatusDeleted is a PlatformStatus enum value
	PlatformStatusDeleted = "Deleted"
)

const (
	// SourceRepositoryCodeCommit is a SourceRepository enum value
	SourceRepositoryCodeCommit = "CodeCommit"

	// SourceRepositoryS3 is a SourceRepository enum value
	SourceRepositoryS3 = "S3"
)

const (
	// SourceTypeGit is a SourceType enum value
	SourceTypeGit = "Git"

	// SourceTypeZip is a SourceType enum value
	SourceTypeZip = "Zip"
)

const (
	// ValidationSeverityError is a ValidationSeverity enum value
	ValidationSeverityError = "error"

	// ValidationSeverityWarning is a ValidationSeverity enum value
	ValidationSeverityWarning = "warning"
)
