// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package inspector2iface provides an interface to enable mocking the Inspector2 service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package inspector2iface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/inspector2"
)

// Inspector2API provides an interface to enable mocking the
// inspector2.Inspector2 service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Inspector2.
//    func myFunc(svc inspector2iface.Inspector2API) bool {
//        // Make svc.AssociateMember request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := inspector2.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockInspector2Client struct {
//        inspector2iface.Inspector2API
//    }
//    func (m *mockInspector2Client) AssociateMember(input *inspector2.AssociateMemberInput) (*inspector2.AssociateMemberOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockInspector2Client{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type Inspector2API interface {
	AssociateMember(*inspector2.AssociateMemberInput) (*inspector2.AssociateMemberOutput, error)
	AssociateMemberWithContext(aws.Context, *inspector2.AssociateMemberInput, ...request.Option) (*inspector2.AssociateMemberOutput, error)
	AssociateMemberRequest(*inspector2.AssociateMemberInput) (*request.Request, *inspector2.AssociateMemberOutput)

	BatchGetAccountStatus(*inspector2.BatchGetAccountStatusInput) (*inspector2.BatchGetAccountStatusOutput, error)
	BatchGetAccountStatusWithContext(aws.Context, *inspector2.BatchGetAccountStatusInput, ...request.Option) (*inspector2.BatchGetAccountStatusOutput, error)
	BatchGetAccountStatusRequest(*inspector2.BatchGetAccountStatusInput) (*request.Request, *inspector2.BatchGetAccountStatusOutput)

	BatchGetFreeTrialInfo(*inspector2.BatchGetFreeTrialInfoInput) (*inspector2.BatchGetFreeTrialInfoOutput, error)
	BatchGetFreeTrialInfoWithContext(aws.Context, *inspector2.BatchGetFreeTrialInfoInput, ...request.Option) (*inspector2.BatchGetFreeTrialInfoOutput, error)
	BatchGetFreeTrialInfoRequest(*inspector2.BatchGetFreeTrialInfoInput) (*request.Request, *inspector2.BatchGetFreeTrialInfoOutput)

	CancelFindingsReport(*inspector2.CancelFindingsReportInput) (*inspector2.CancelFindingsReportOutput, error)
	CancelFindingsReportWithContext(aws.Context, *inspector2.CancelFindingsReportInput, ...request.Option) (*inspector2.CancelFindingsReportOutput, error)
	CancelFindingsReportRequest(*inspector2.CancelFindingsReportInput) (*request.Request, *inspector2.CancelFindingsReportOutput)

	CreateFilter(*inspector2.CreateFilterInput) (*inspector2.CreateFilterOutput, error)
	CreateFilterWithContext(aws.Context, *inspector2.CreateFilterInput, ...request.Option) (*inspector2.CreateFilterOutput, error)
	CreateFilterRequest(*inspector2.CreateFilterInput) (*request.Request, *inspector2.CreateFilterOutput)

	CreateFindingsReport(*inspector2.CreateFindingsReportInput) (*inspector2.CreateFindingsReportOutput, error)
	CreateFindingsReportWithContext(aws.Context, *inspector2.CreateFindingsReportInput, ...request.Option) (*inspector2.CreateFindingsReportOutput, error)
	CreateFindingsReportRequest(*inspector2.CreateFindingsReportInput) (*request.Request, *inspector2.CreateFindingsReportOutput)

	DeleteFilter(*inspector2.DeleteFilterInput) (*inspector2.DeleteFilterOutput, error)
	DeleteFilterWithContext(aws.Context, *inspector2.DeleteFilterInput, ...request.Option) (*inspector2.DeleteFilterOutput, error)
	DeleteFilterRequest(*inspector2.DeleteFilterInput) (*request.Request, *inspector2.DeleteFilterOutput)

	DescribeOrganizationConfiguration(*inspector2.DescribeOrganizationConfigurationInput) (*inspector2.DescribeOrganizationConfigurationOutput, error)
	DescribeOrganizationConfigurationWithContext(aws.Context, *inspector2.DescribeOrganizationConfigurationInput, ...request.Option) (*inspector2.DescribeOrganizationConfigurationOutput, error)
	DescribeOrganizationConfigurationRequest(*inspector2.DescribeOrganizationConfigurationInput) (*request.Request, *inspector2.DescribeOrganizationConfigurationOutput)

	Disable(*inspector2.DisableInput) (*inspector2.DisableOutput, error)
	DisableWithContext(aws.Context, *inspector2.DisableInput, ...request.Option) (*inspector2.DisableOutput, error)
	DisableRequest(*inspector2.DisableInput) (*request.Request, *inspector2.DisableOutput)

	DisableDelegatedAdminAccount(*inspector2.DisableDelegatedAdminAccountInput) (*inspector2.DisableDelegatedAdminAccountOutput, error)
	DisableDelegatedAdminAccountWithContext(aws.Context, *inspector2.DisableDelegatedAdminAccountInput, ...request.Option) (*inspector2.DisableDelegatedAdminAccountOutput, error)
	DisableDelegatedAdminAccountRequest(*inspector2.DisableDelegatedAdminAccountInput) (*request.Request, *inspector2.DisableDelegatedAdminAccountOutput)

	DisassociateMember(*inspector2.DisassociateMemberInput) (*inspector2.DisassociateMemberOutput, error)
	DisassociateMemberWithContext(aws.Context, *inspector2.DisassociateMemberInput, ...request.Option) (*inspector2.DisassociateMemberOutput, error)
	DisassociateMemberRequest(*inspector2.DisassociateMemberInput) (*request.Request, *inspector2.DisassociateMemberOutput)

	Enable(*inspector2.EnableInput) (*inspector2.EnableOutput, error)
	EnableWithContext(aws.Context, *inspector2.EnableInput, ...request.Option) (*inspector2.EnableOutput, error)
	EnableRequest(*inspector2.EnableInput) (*request.Request, *inspector2.EnableOutput)

	EnableDelegatedAdminAccount(*inspector2.EnableDelegatedAdminAccountInput) (*inspector2.EnableDelegatedAdminAccountOutput, error)
	EnableDelegatedAdminAccountWithContext(aws.Context, *inspector2.EnableDelegatedAdminAccountInput, ...request.Option) (*inspector2.EnableDelegatedAdminAccountOutput, error)
	EnableDelegatedAdminAccountRequest(*inspector2.EnableDelegatedAdminAccountInput) (*request.Request, *inspector2.EnableDelegatedAdminAccountOutput)

	GetDelegatedAdminAccount(*inspector2.GetDelegatedAdminAccountInput) (*inspector2.GetDelegatedAdminAccountOutput, error)
	GetDelegatedAdminAccountWithContext(aws.Context, *inspector2.GetDelegatedAdminAccountInput, ...request.Option) (*inspector2.GetDelegatedAdminAccountOutput, error)
	GetDelegatedAdminAccountRequest(*inspector2.GetDelegatedAdminAccountInput) (*request.Request, *inspector2.GetDelegatedAdminAccountOutput)

	GetFindingsReportStatus(*inspector2.GetFindingsReportStatusInput) (*inspector2.GetFindingsReportStatusOutput, error)
	GetFindingsReportStatusWithContext(aws.Context, *inspector2.GetFindingsReportStatusInput, ...request.Option) (*inspector2.GetFindingsReportStatusOutput, error)
	GetFindingsReportStatusRequest(*inspector2.GetFindingsReportStatusInput) (*request.Request, *inspector2.GetFindingsReportStatusOutput)

	GetMember(*inspector2.GetMemberInput) (*inspector2.GetMemberOutput, error)
	GetMemberWithContext(aws.Context, *inspector2.GetMemberInput, ...request.Option) (*inspector2.GetMemberOutput, error)
	GetMemberRequest(*inspector2.GetMemberInput) (*request.Request, *inspector2.GetMemberOutput)

	ListAccountPermissions(*inspector2.ListAccountPermissionsInput) (*inspector2.ListAccountPermissionsOutput, error)
	ListAccountPermissionsWithContext(aws.Context, *inspector2.ListAccountPermissionsInput, ...request.Option) (*inspector2.ListAccountPermissionsOutput, error)
	ListAccountPermissionsRequest(*inspector2.ListAccountPermissionsInput) (*request.Request, *inspector2.ListAccountPermissionsOutput)

	ListAccountPermissionsPages(*inspector2.ListAccountPermissionsInput, func(*inspector2.ListAccountPermissionsOutput, bool) bool) error
	ListAccountPermissionsPagesWithContext(aws.Context, *inspector2.ListAccountPermissionsInput, func(*inspector2.ListAccountPermissionsOutput, bool) bool, ...request.Option) error

	ListCoverage(*inspector2.ListCoverageInput) (*inspector2.ListCoverageOutput, error)
	ListCoverageWithContext(aws.Context, *inspector2.ListCoverageInput, ...request.Option) (*inspector2.ListCoverageOutput, error)
	ListCoverageRequest(*inspector2.ListCoverageInput) (*request.Request, *inspector2.ListCoverageOutput)

	ListCoveragePages(*inspector2.ListCoverageInput, func(*inspector2.ListCoverageOutput, bool) bool) error
	ListCoveragePagesWithContext(aws.Context, *inspector2.ListCoverageInput, func(*inspector2.ListCoverageOutput, bool) bool, ...request.Option) error

	ListCoverageStatistics(*inspector2.ListCoverageStatisticsInput) (*inspector2.ListCoverageStatisticsOutput, error)
	ListCoverageStatisticsWithContext(aws.Context, *inspector2.ListCoverageStatisticsInput, ...request.Option) (*inspector2.ListCoverageStatisticsOutput, error)
	ListCoverageStatisticsRequest(*inspector2.ListCoverageStatisticsInput) (*request.Request, *inspector2.ListCoverageStatisticsOutput)

	ListCoverageStatisticsPages(*inspector2.ListCoverageStatisticsInput, func(*inspector2.ListCoverageStatisticsOutput, bool) bool) error
	ListCoverageStatisticsPagesWithContext(aws.Context, *inspector2.ListCoverageStatisticsInput, func(*inspector2.ListCoverageStatisticsOutput, bool) bool, ...request.Option) error

	ListDelegatedAdminAccounts(*inspector2.ListDelegatedAdminAccountsInput) (*inspector2.ListDelegatedAdminAccountsOutput, error)
	ListDelegatedAdminAccountsWithContext(aws.Context, *inspector2.ListDelegatedAdminAccountsInput, ...request.Option) (*inspector2.ListDelegatedAdminAccountsOutput, error)
	ListDelegatedAdminAccountsRequest(*inspector2.ListDelegatedAdminAccountsInput) (*request.Request, *inspector2.ListDelegatedAdminAccountsOutput)

	ListDelegatedAdminAccountsPages(*inspector2.ListDelegatedAdminAccountsInput, func(*inspector2.ListDelegatedAdminAccountsOutput, bool) bool) error
	ListDelegatedAdminAccountsPagesWithContext(aws.Context, *inspector2.ListDelegatedAdminAccountsInput, func(*inspector2.ListDelegatedAdminAccountsOutput, bool) bool, ...request.Option) error

	ListFilters(*inspector2.ListFiltersInput) (*inspector2.ListFiltersOutput, error)
	ListFiltersWithContext(aws.Context, *inspector2.ListFiltersInput, ...request.Option) (*inspector2.ListFiltersOutput, error)
	ListFiltersRequest(*inspector2.ListFiltersInput) (*request.Request, *inspector2.ListFiltersOutput)

	ListFiltersPages(*inspector2.ListFiltersInput, func(*inspector2.ListFiltersOutput, bool) bool) error
	ListFiltersPagesWithContext(aws.Context, *inspector2.ListFiltersInput, func(*inspector2.ListFiltersOutput, bool) bool, ...request.Option) error

	ListFindingAggregations(*inspector2.ListFindingAggregationsInput) (*inspector2.ListFindingAggregationsOutput, error)
	ListFindingAggregationsWithContext(aws.Context, *inspector2.ListFindingAggregationsInput, ...request.Option) (*inspector2.ListFindingAggregationsOutput, error)
	ListFindingAggregationsRequest(*inspector2.ListFindingAggregationsInput) (*request.Request, *inspector2.ListFindingAggregationsOutput)

	ListFindingAggregationsPages(*inspector2.ListFindingAggregationsInput, func(*inspector2.ListFindingAggregationsOutput, bool) bool) error
	ListFindingAggregationsPagesWithContext(aws.Context, *inspector2.ListFindingAggregationsInput, func(*inspector2.ListFindingAggregationsOutput, bool) bool, ...request.Option) error

	ListFindings(*inspector2.ListFindingsInput) (*inspector2.ListFindingsOutput, error)
	ListFindingsWithContext(aws.Context, *inspector2.ListFindingsInput, ...request.Option) (*inspector2.ListFindingsOutput, error)
	ListFindingsRequest(*inspector2.ListFindingsInput) (*request.Request, *inspector2.ListFindingsOutput)

	ListFindingsPages(*inspector2.ListFindingsInput, func(*inspector2.ListFindingsOutput, bool) bool) error
	ListFindingsPagesWithContext(aws.Context, *inspector2.ListFindingsInput, func(*inspector2.ListFindingsOutput, bool) bool, ...request.Option) error

	ListMembers(*inspector2.ListMembersInput) (*inspector2.ListMembersOutput, error)
	ListMembersWithContext(aws.Context, *inspector2.ListMembersInput, ...request.Option) (*inspector2.ListMembersOutput, error)
	ListMembersRequest(*inspector2.ListMembersInput) (*request.Request, *inspector2.ListMembersOutput)

	ListMembersPages(*inspector2.ListMembersInput, func(*inspector2.ListMembersOutput, bool) bool) error
	ListMembersPagesWithContext(aws.Context, *inspector2.ListMembersInput, func(*inspector2.ListMembersOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*inspector2.ListTagsForResourceInput) (*inspector2.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *inspector2.ListTagsForResourceInput, ...request.Option) (*inspector2.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*inspector2.ListTagsForResourceInput) (*request.Request, *inspector2.ListTagsForResourceOutput)

	ListUsageTotals(*inspector2.ListUsageTotalsInput) (*inspector2.ListUsageTotalsOutput, error)
	ListUsageTotalsWithContext(aws.Context, *inspector2.ListUsageTotalsInput, ...request.Option) (*inspector2.ListUsageTotalsOutput, error)
	ListUsageTotalsRequest(*inspector2.ListUsageTotalsInput) (*request.Request, *inspector2.ListUsageTotalsOutput)

	ListUsageTotalsPages(*inspector2.ListUsageTotalsInput, func(*inspector2.ListUsageTotalsOutput, bool) bool) error
	ListUsageTotalsPagesWithContext(aws.Context, *inspector2.ListUsageTotalsInput, func(*inspector2.ListUsageTotalsOutput, bool) bool, ...request.Option) error

	TagResource(*inspector2.TagResourceInput) (*inspector2.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *inspector2.TagResourceInput, ...request.Option) (*inspector2.TagResourceOutput, error)
	TagResourceRequest(*inspector2.TagResourceInput) (*request.Request, *inspector2.TagResourceOutput)

	UntagResource(*inspector2.UntagResourceInput) (*inspector2.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *inspector2.UntagResourceInput, ...request.Option) (*inspector2.UntagResourceOutput, error)
	UntagResourceRequest(*inspector2.UntagResourceInput) (*request.Request, *inspector2.UntagResourceOutput)

	UpdateFilter(*inspector2.UpdateFilterInput) (*inspector2.UpdateFilterOutput, error)
	UpdateFilterWithContext(aws.Context, *inspector2.UpdateFilterInput, ...request.Option) (*inspector2.UpdateFilterOutput, error)
	UpdateFilterRequest(*inspector2.UpdateFilterInput) (*request.Request, *inspector2.UpdateFilterOutput)

	UpdateOrganizationConfiguration(*inspector2.UpdateOrganizationConfigurationInput) (*inspector2.UpdateOrganizationConfigurationOutput, error)
	UpdateOrganizationConfigurationWithContext(aws.Context, *inspector2.UpdateOrganizationConfigurationInput, ...request.Option) (*inspector2.UpdateOrganizationConfigurationOutput, error)
	UpdateOrganizationConfigurationRequest(*inspector2.UpdateOrganizationConfigurationInput) (*request.Request, *inspector2.UpdateOrganizationConfigurationOutput)
}

var _ Inspector2API = (*inspector2.Inspector2)(nil)
