// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opApproveSkill = "ApproveSkill"

// ApproveSkillRequest generates a "aws/request.Request" representing the
// client's request for the ApproveSkill operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ApproveSkill for more information on using the ApproveSkill
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ApproveSkillRequest method.
//    req, resp := client.ApproveSkillRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ApproveSkill
func (c *AlexaForBusiness) ApproveSkillRequest(input *ApproveSkillInput) (req *request.Request, output *ApproveSkillOutput) {
	op := &request.Operation{
		Name:       opApproveSkill,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ApproveSkillInput{}
	}

	output = &ApproveSkillOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ApproveSkill API operation for Alexa For Business.
//
// Associates a skill with the organization under the customer's AWS account.
// If a skill is private, the user implicitly accepts access to this skill during
// enablement.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation ApproveSkill for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You are performing an action that would put you beyond your account's limits.
//
//   * NotFoundException
//   The resource is not found.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ApproveSkill
func (c *AlexaForBusiness) ApproveSkill(input *ApproveSkillInput) (*ApproveSkillOutput, error) {
	req, out := c.ApproveSkillRequest(input)
	return out, req.Send()
}

// ApproveSkillWithContext is the same as ApproveSkill with the addition of
// the ability to pass a context and additional request options.
//
// See ApproveSkill for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ApproveSkillWithContext(ctx aws.Context, input *ApproveSkillInput, opts ...request.Option) (*ApproveSkillOutput, error) {
	req, out := c.ApproveSkillRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateContactWithAddressBook = "AssociateContactWithAddressBook"

// AssociateContactWithAddressBookRequest generates a "aws/request.Request" representing the
// client's request for the AssociateContactWithAddressBook operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateContactWithAddressBook for more information on using the AssociateContactWithAddressBook
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateContactWithAddressBookRequest method.
//    req, resp := client.AssociateContactWithAddressBookRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateContactWithAddressBook
func (c *AlexaForBusiness) AssociateContactWithAddressBookRequest(input *AssociateContactWithAddressBookInput) (req *request.Request, output *AssociateContactWithAddressBookOutput) {
	op := &request.Operation{
		Name:       opAssociateContactWithAddressBook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateContactWithAddressBookInput{}
	}

	output = &AssociateContactWithAddressBookOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateContactWithAddressBook API operation for Alexa For Business.
//
// Associates a contact with a given address book.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation AssociateContactWithAddressBook for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You are performing an action that would put you beyond your account's limits.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateContactWithAddressBook
func (c *AlexaForBusiness) AssociateContactWithAddressBook(input *AssociateContactWithAddressBookInput) (*AssociateContactWithAddressBookOutput, error) {
	req, out := c.AssociateContactWithAddressBookRequest(input)
	return out, req.Send()
}

// AssociateContactWithAddressBookWithContext is the same as AssociateContactWithAddressBook with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateContactWithAddressBook for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) AssociateContactWithAddressBookWithContext(ctx aws.Context, input *AssociateContactWithAddressBookInput, opts ...request.Option) (*AssociateContactWithAddressBookOutput, error) {
	req, out := c.AssociateContactWithAddressBookRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateDeviceWithNetworkProfile = "AssociateDeviceWithNetworkProfile"

// AssociateDeviceWithNetworkProfileRequest generates a "aws/request.Request" representing the
// client's request for the AssociateDeviceWithNetworkProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateDeviceWithNetworkProfile for more information on using the AssociateDeviceWithNetworkProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateDeviceWithNetworkProfileRequest method.
//    req, resp := client.AssociateDeviceWithNetworkProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateDeviceWithNetworkProfile
func (c *AlexaForBusiness) AssociateDeviceWithNetworkProfileRequest(input *AssociateDeviceWithNetworkProfileInput) (req *request.Request, output *AssociateDeviceWithNetworkProfileOutput) {
	op := &request.Operation{
		Name:       opAssociateDeviceWithNetworkProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateDeviceWithNetworkProfileInput{}
	}

	output = &AssociateDeviceWithNetworkProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateDeviceWithNetworkProfile API operation for Alexa For Business.
//
// Associates a device with the specified network profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation AssociateDeviceWithNetworkProfile for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
//   * DeviceNotRegisteredException
//   The request failed because this device is no longer registered and therefore
//   no longer managed by this account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateDeviceWithNetworkProfile
func (c *AlexaForBusiness) AssociateDeviceWithNetworkProfile(input *AssociateDeviceWithNetworkProfileInput) (*AssociateDeviceWithNetworkProfileOutput, error) {
	req, out := c.AssociateDeviceWithNetworkProfileRequest(input)
	return out, req.Send()
}

// AssociateDeviceWithNetworkProfileWithContext is the same as AssociateDeviceWithNetworkProfile with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateDeviceWithNetworkProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) AssociateDeviceWithNetworkProfileWithContext(ctx aws.Context, input *AssociateDeviceWithNetworkProfileInput, opts ...request.Option) (*AssociateDeviceWithNetworkProfileOutput, error) {
	req, out := c.AssociateDeviceWithNetworkProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateDeviceWithRoom = "AssociateDeviceWithRoom"

// AssociateDeviceWithRoomRequest generates a "aws/request.Request" representing the
// client's request for the AssociateDeviceWithRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateDeviceWithRoom for more information on using the AssociateDeviceWithRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateDeviceWithRoomRequest method.
//    req, resp := client.AssociateDeviceWithRoomRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateDeviceWithRoom
func (c *AlexaForBusiness) AssociateDeviceWithRoomRequest(input *AssociateDeviceWithRoomInput) (req *request.Request, output *AssociateDeviceWithRoomOutput) {
	op := &request.Operation{
		Name:       opAssociateDeviceWithRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateDeviceWithRoomInput{}
	}

	output = &AssociateDeviceWithRoomOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateDeviceWithRoom API operation for Alexa For Business.
//
// Associates a device with a given room. This applies all the settings from
// the room profile to the device, and all the skills in any skill groups added
// to that room. This operation requires the device to be online, or else a
// manual sync is required.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation AssociateDeviceWithRoom for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You are performing an action that would put you beyond your account's limits.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
//   * DeviceNotRegisteredException
//   The request failed because this device is no longer registered and therefore
//   no longer managed by this account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateDeviceWithRoom
func (c *AlexaForBusiness) AssociateDeviceWithRoom(input *AssociateDeviceWithRoomInput) (*AssociateDeviceWithRoomOutput, error) {
	req, out := c.AssociateDeviceWithRoomRequest(input)
	return out, req.Send()
}

// AssociateDeviceWithRoomWithContext is the same as AssociateDeviceWithRoom with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateDeviceWithRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) AssociateDeviceWithRoomWithContext(ctx aws.Context, input *AssociateDeviceWithRoomInput, opts ...request.Option) (*AssociateDeviceWithRoomOutput, error) {
	req, out := c.AssociateDeviceWithRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateSkillGroupWithRoom = "AssociateSkillGroupWithRoom"

// AssociateSkillGroupWithRoomRequest generates a "aws/request.Request" representing the
// client's request for the AssociateSkillGroupWithRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateSkillGroupWithRoom for more information on using the AssociateSkillGroupWithRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateSkillGroupWithRoomRequest method.
//    req, resp := client.AssociateSkillGroupWithRoomRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillGroupWithRoom
func (c *AlexaForBusiness) AssociateSkillGroupWithRoomRequest(input *AssociateSkillGroupWithRoomInput) (req *request.Request, output *AssociateSkillGroupWithRoomOutput) {
	op := &request.Operation{
		Name:       opAssociateSkillGroupWithRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateSkillGroupWithRoomInput{}
	}

	output = &AssociateSkillGroupWithRoomOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateSkillGroupWithRoom API operation for Alexa For Business.
//
// Associates a skill group with a given room. This enables all skills in the
// associated skill group on all devices in the room.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation AssociateSkillGroupWithRoom for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillGroupWithRoom
func (c *AlexaForBusiness) AssociateSkillGroupWithRoom(input *AssociateSkillGroupWithRoomInput) (*AssociateSkillGroupWithRoomOutput, error) {
	req, out := c.AssociateSkillGroupWithRoomRequest(input)
	return out, req.Send()
}

// AssociateSkillGroupWithRoomWithContext is the same as AssociateSkillGroupWithRoom with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateSkillGroupWithRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) AssociateSkillGroupWithRoomWithContext(ctx aws.Context, input *AssociateSkillGroupWithRoomInput, opts ...request.Option) (*AssociateSkillGroupWithRoomOutput, error) {
	req, out := c.AssociateSkillGroupWithRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateSkillWithSkillGroup = "AssociateSkillWithSkillGroup"

// AssociateSkillWithSkillGroupRequest generates a "aws/request.Request" representing the
// client's request for the AssociateSkillWithSkillGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateSkillWithSkillGroup for more information on using the AssociateSkillWithSkillGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateSkillWithSkillGroupRequest method.
//    req, resp := client.AssociateSkillWithSkillGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillWithSkillGroup
func (c *AlexaForBusiness) AssociateSkillWithSkillGroupRequest(input *AssociateSkillWithSkillGroupInput) (req *request.Request, output *AssociateSkillWithSkillGroupOutput) {
	op := &request.Operation{
		Name:       opAssociateSkillWithSkillGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateSkillWithSkillGroupInput{}
	}

	output = &AssociateSkillWithSkillGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateSkillWithSkillGroup API operation for Alexa For Business.
//
// Associates a skill with a skill group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation AssociateSkillWithSkillGroup for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
//   * NotFoundException
//   The resource is not found.
//
//   * SkillNotLinkedException
//   The skill must be linked to a third-party account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillWithSkillGroup
func (c *AlexaForBusiness) AssociateSkillWithSkillGroup(input *AssociateSkillWithSkillGroupInput) (*AssociateSkillWithSkillGroupOutput, error) {
	req, out := c.AssociateSkillWithSkillGroupRequest(input)
	return out, req.Send()
}

// AssociateSkillWithSkillGroupWithContext is the same as AssociateSkillWithSkillGroup with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateSkillWithSkillGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) AssociateSkillWithSkillGroupWithContext(ctx aws.Context, input *AssociateSkillWithSkillGroupInput, opts ...request.Option) (*AssociateSkillWithSkillGroupOutput, error) {
	req, out := c.AssociateSkillWithSkillGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateSkillWithUsers = "AssociateSkillWithUsers"

// AssociateSkillWithUsersRequest generates a "aws/request.Request" representing the
// client's request for the AssociateSkillWithUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateSkillWithUsers for more information on using the AssociateSkillWithUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateSkillWithUsersRequest method.
//    req, resp := client.AssociateSkillWithUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillWithUsers
func (c *AlexaForBusiness) AssociateSkillWithUsersRequest(input *AssociateSkillWithUsersInput) (req *request.Request, output *AssociateSkillWithUsersOutput) {
	op := &request.Operation{
		Name:       opAssociateSkillWithUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateSkillWithUsersInput{}
	}

	output = &AssociateSkillWithUsersOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateSkillWithUsers API operation for Alexa For Business.
//
// Makes a private skill available for enrolled users to enable on their devices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation AssociateSkillWithUsers for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillWithUsers
func (c *AlexaForBusiness) AssociateSkillWithUsers(input *AssociateSkillWithUsersInput) (*AssociateSkillWithUsersOutput, error) {
	req, out := c.AssociateSkillWithUsersRequest(input)
	return out, req.Send()
}

// AssociateSkillWithUsersWithContext is the same as AssociateSkillWithUsers with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateSkillWithUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) AssociateSkillWithUsersWithContext(ctx aws.Context, input *AssociateSkillWithUsersInput, opts ...request.Option) (*AssociateSkillWithUsersOutput, error) {
	req, out := c.AssociateSkillWithUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAddressBook = "CreateAddressBook"

// CreateAddressBookRequest generates a "aws/request.Request" representing the
// client's request for the CreateAddressBook operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAddressBook for more information on using the CreateAddressBook
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAddressBookRequest method.
//    req, resp := client.CreateAddressBookRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateAddressBook
func (c *AlexaForBusiness) CreateAddressBookRequest(input *CreateAddressBookInput) (req *request.Request, output *CreateAddressBookOutput) {
	op := &request.Operation{
		Name:       opCreateAddressBook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAddressBookInput{}
	}

	output = &CreateAddressBookOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAddressBook API operation for Alexa For Business.
//
// Creates an address book with the specified details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation CreateAddressBook for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   The resource being created already exists.
//
//   * LimitExceededException
//   You are performing an action that would put you beyond your account's limits.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateAddressBook
func (c *AlexaForBusiness) CreateAddressBook(input *CreateAddressBookInput) (*CreateAddressBookOutput, error) {
	req, out := c.CreateAddressBookRequest(input)
	return out, req.Send()
}

// CreateAddressBookWithContext is the same as CreateAddressBook with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAddressBook for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) CreateAddressBookWithContext(ctx aws.Context, input *CreateAddressBookInput, opts ...request.Option) (*CreateAddressBookOutput, error) {
	req, out := c.CreateAddressBookRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBusinessReportSchedule = "CreateBusinessReportSchedule"

// CreateBusinessReportScheduleRequest generates a "aws/request.Request" representing the
// client's request for the CreateBusinessReportSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBusinessReportSchedule for more information on using the CreateBusinessReportSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBusinessReportScheduleRequest method.
//    req, resp := client.CreateBusinessReportScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateBusinessReportSchedule
func (c *AlexaForBusiness) CreateBusinessReportScheduleRequest(input *CreateBusinessReportScheduleInput) (req *request.Request, output *CreateBusinessReportScheduleOutput) {
	op := &request.Operation{
		Name:       opCreateBusinessReportSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBusinessReportScheduleInput{}
	}

	output = &CreateBusinessReportScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBusinessReportSchedule API operation for Alexa For Business.
//
// Creates a recurring schedule for usage reports to deliver to the specified
// S3 location with a specified daily or weekly interval.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation CreateBusinessReportSchedule for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   The resource being created already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateBusinessReportSchedule
func (c *AlexaForBusiness) CreateBusinessReportSchedule(input *CreateBusinessReportScheduleInput) (*CreateBusinessReportScheduleOutput, error) {
	req, out := c.CreateBusinessReportScheduleRequest(input)
	return out, req.Send()
}

// CreateBusinessReportScheduleWithContext is the same as CreateBusinessReportSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBusinessReportSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) CreateBusinessReportScheduleWithContext(ctx aws.Context, input *CreateBusinessReportScheduleInput, opts ...request.Option) (*CreateBusinessReportScheduleOutput, error) {
	req, out := c.CreateBusinessReportScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConferenceProvider = "CreateConferenceProvider"

// CreateConferenceProviderRequest generates a "aws/request.Request" representing the
// client's request for the CreateConferenceProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConferenceProvider for more information on using the CreateConferenceProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateConferenceProviderRequest method.
//    req, resp := client.CreateConferenceProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateConferenceProvider
func (c *AlexaForBusiness) CreateConferenceProviderRequest(input *CreateConferenceProviderInput) (req *request.Request, output *CreateConferenceProviderOutput) {
	op := &request.Operation{
		Name:       opCreateConferenceProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConferenceProviderInput{}
	}

	output = &CreateConferenceProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConferenceProvider API operation for Alexa For Business.
//
// Adds a new conference provider under the user's AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation CreateConferenceProvider for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   The resource being created already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateConferenceProvider
func (c *AlexaForBusiness) CreateConferenceProvider(input *CreateConferenceProviderInput) (*CreateConferenceProviderOutput, error) {
	req, out := c.CreateConferenceProviderRequest(input)
	return out, req.Send()
}

// CreateConferenceProviderWithContext is the same as CreateConferenceProvider with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConferenceProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) CreateConferenceProviderWithContext(ctx aws.Context, input *CreateConferenceProviderInput, opts ...request.Option) (*CreateConferenceProviderOutput, error) {
	req, out := c.CreateConferenceProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateContact = "CreateContact"

// CreateContactRequest generates a "aws/request.Request" representing the
// client's request for the CreateContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateContact for more information on using the CreateContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateContactRequest method.
//    req, resp := client.CreateContactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateContact
func (c *AlexaForBusiness) CreateContactRequest(input *CreateContactInput) (req *request.Request, output *CreateContactOutput) {
	op := &request.Operation{
		Name:       opCreateContact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateContactInput{}
	}

	output = &CreateContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateContact API operation for Alexa For Business.
//
// Creates a contact with the specified details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation CreateContact for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   The resource being created already exists.
//
//   * LimitExceededException
//   You are performing an action that would put you beyond your account's limits.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateContact
func (c *AlexaForBusiness) CreateContact(input *CreateContactInput) (*CreateContactOutput, error) {
	req, out := c.CreateContactRequest(input)
	return out, req.Send()
}

// CreateContactWithContext is the same as CreateContact with the addition of
// the ability to pass a context and additional request options.
//
// See CreateContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) CreateContactWithContext(ctx aws.Context, input *CreateContactInput, opts ...request.Option) (*CreateContactOutput, error) {
	req, out := c.CreateContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGatewayGroup = "CreateGatewayGroup"

// CreateGatewayGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateGatewayGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGatewayGroup for more information on using the CreateGatewayGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGatewayGroupRequest method.
//    req, resp := client.CreateGatewayGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateGatewayGroup
func (c *AlexaForBusiness) CreateGatewayGroupRequest(input *CreateGatewayGroupInput) (req *request.Request, output *CreateGatewayGroupOutput) {
	op := &request.Operation{
		Name:       opCreateGatewayGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGatewayGroupInput{}
	}

	output = &CreateGatewayGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGatewayGroup API operation for Alexa For Business.
//
// Creates a gateway group with the specified details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation CreateGatewayGroup for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   The resource being created already exists.
//
//   * LimitExceededException
//   You are performing an action that would put you beyond your account's limits.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateGatewayGroup
func (c *AlexaForBusiness) CreateGatewayGroup(input *CreateGatewayGroupInput) (*CreateGatewayGroupOutput, error) {
	req, out := c.CreateGatewayGroupRequest(input)
	return out, req.Send()
}

// CreateGatewayGroupWithContext is the same as CreateGatewayGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGatewayGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) CreateGatewayGroupWithContext(ctx aws.Context, input *CreateGatewayGroupInput, opts ...request.Option) (*CreateGatewayGroupOutput, error) {
	req, out := c.CreateGatewayGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNetworkProfile = "CreateNetworkProfile"

// CreateNetworkProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateNetworkProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNetworkProfile for more information on using the CreateNetworkProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNetworkProfileRequest method.
//    req, resp := client.CreateNetworkProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateNetworkProfile
func (c *AlexaForBusiness) CreateNetworkProfileRequest(input *CreateNetworkProfileInput) (req *request.Request, output *CreateNetworkProfileOutput) {
	op := &request.Operation{
		Name:       opCreateNetworkProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNetworkProfileInput{}
	}

	output = &CreateNetworkProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNetworkProfile API operation for Alexa For Business.
//
// Creates a network profile with the specified details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation CreateNetworkProfile for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   The resource being created already exists.
//
//   * LimitExceededException
//   You are performing an action that would put you beyond your account's limits.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
//   * InvalidCertificateAuthorityException
//   The Certificate Authority can't issue or revoke a certificate.
//
//   * InvalidServiceLinkedRoleStateException
//   The service linked role is locked for deletion.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateNetworkProfile
func (c *AlexaForBusiness) CreateNetworkProfile(input *CreateNetworkProfileInput) (*CreateNetworkProfileOutput, error) {
	req, out := c.CreateNetworkProfileRequest(input)
	return out, req.Send()
}

// CreateNetworkProfileWithContext is the same as CreateNetworkProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNetworkProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) CreateNetworkProfileWithContext(ctx aws.Context, input *CreateNetworkProfileInput, opts ...request.Option) (*CreateNetworkProfileOutput, error) {
	req, out := c.CreateNetworkProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProfile = "CreateProfile"

// CreateProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProfile for more information on using the CreateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateProfileRequest method.
//    req, resp := client.CreateProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateProfile
func (c *AlexaForBusiness) CreateProfileRequest(input *CreateProfileInput) (req *request.Request, output *CreateProfileOutput) {
	op := &request.Operation{
		Name:       opCreateProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateProfileInput{}
	}

	output = &CreateProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProfile API operation for Alexa For Business.
//
// Creates a new room profile with the specified details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation CreateProfile for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You are performing an action that would put you beyond your account's limits.
//
//   * AlreadyExistsException
//   The resource being created already exists.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateProfile
func (c *AlexaForBusiness) CreateProfile(input *CreateProfileInput) (*CreateProfileOutput, error) {
	req, out := c.CreateProfileRequest(input)
	return out, req.Send()
}

// CreateProfileWithContext is the same as CreateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) CreateProfileWithContext(ctx aws.Context, input *CreateProfileInput, opts ...request.Option) (*CreateProfileOutput, error) {
	req, out := c.CreateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRoom = "CreateRoom"

// CreateRoomRequest generates a "aws/request.Request" representing the
// client's request for the CreateRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRoom for more information on using the CreateRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRoomRequest method.
//    req, resp := client.CreateRoomRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateRoom
func (c *AlexaForBusiness) CreateRoomRequest(input *CreateRoomInput) (req *request.Request, output *CreateRoomOutput) {
	op := &request.Operation{
		Name:       opCreateRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRoomInput{}
	}

	output = &CreateRoomOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRoom API operation for Alexa For Business.
//
// Creates a room with the specified details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation CreateRoom for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   The resource being created already exists.
//
//   * LimitExceededException
//   You are performing an action that would put you beyond your account's limits.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateRoom
func (c *AlexaForBusiness) CreateRoom(input *CreateRoomInput) (*CreateRoomOutput, error) {
	req, out := c.CreateRoomRequest(input)
	return out, req.Send()
}

// CreateRoomWithContext is the same as CreateRoom with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) CreateRoomWithContext(ctx aws.Context, input *CreateRoomInput, opts ...request.Option) (*CreateRoomOutput, error) {
	req, out := c.CreateRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSkillGroup = "CreateSkillGroup"

// CreateSkillGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateSkillGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSkillGroup for more information on using the CreateSkillGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSkillGroupRequest method.
//    req, resp := client.CreateSkillGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateSkillGroup
func (c *AlexaForBusiness) CreateSkillGroupRequest(input *CreateSkillGroupInput) (req *request.Request, output *CreateSkillGroupOutput) {
	op := &request.Operation{
		Name:       opCreateSkillGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSkillGroupInput{}
	}

	output = &CreateSkillGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSkillGroup API operation for Alexa For Business.
//
// Creates a skill group with a specified name and description.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation CreateSkillGroup for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   The resource being created already exists.
//
//   * LimitExceededException
//   You are performing an action that would put you beyond your account's limits.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateSkillGroup
func (c *AlexaForBusiness) CreateSkillGroup(input *CreateSkillGroupInput) (*CreateSkillGroupOutput, error) {
	req, out := c.CreateSkillGroupRequest(input)
	return out, req.Send()
}

// CreateSkillGroupWithContext is the same as CreateSkillGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSkillGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) CreateSkillGroupWithContext(ctx aws.Context, input *CreateSkillGroupInput, opts ...request.Option) (*CreateSkillGroupOutput, error) {
	req, out := c.CreateSkillGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUser = "CreateUser"

// CreateUserRequest generates a "aws/request.Request" representing the
// client's request for the CreateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUser for more information on using the CreateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserRequest method.
//    req, resp := client.CreateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateUser
func (c *AlexaForBusiness) CreateUserRequest(input *CreateUserInput) (req *request.Request, output *CreateUserOutput) {
	op := &request.Operation{
		Name:       opCreateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserInput{}
	}

	output = &CreateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUser API operation for Alexa For Business.
//
// Creates a user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation CreateUser for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The resource in the request is already in use.
//
//   * LimitExceededException
//   You are performing an action that would put you beyond your account's limits.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateUser
func (c *AlexaForBusiness) CreateUser(input *CreateUserInput) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	return out, req.Send()
}

// CreateUserWithContext is the same as CreateUser with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) CreateUserWithContext(ctx aws.Context, input *CreateUserInput, opts ...request.Option) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAddressBook = "DeleteAddressBook"

// DeleteAddressBookRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAddressBook operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAddressBook for more information on using the DeleteAddressBook
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAddressBookRequest method.
//    req, resp := client.DeleteAddressBookRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteAddressBook
func (c *AlexaForBusiness) DeleteAddressBookRequest(input *DeleteAddressBookInput) (req *request.Request, output *DeleteAddressBookOutput) {
	op := &request.Operation{
		Name:       opDeleteAddressBook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAddressBookInput{}
	}

	output = &DeleteAddressBookOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAddressBook API operation for Alexa For Business.
//
// Deletes an address book by the address book ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DeleteAddressBook for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteAddressBook
func (c *AlexaForBusiness) DeleteAddressBook(input *DeleteAddressBookInput) (*DeleteAddressBookOutput, error) {
	req, out := c.DeleteAddressBookRequest(input)
	return out, req.Send()
}

// DeleteAddressBookWithContext is the same as DeleteAddressBook with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAddressBook for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DeleteAddressBookWithContext(ctx aws.Context, input *DeleteAddressBookInput, opts ...request.Option) (*DeleteAddressBookOutput, error) {
	req, out := c.DeleteAddressBookRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBusinessReportSchedule = "DeleteBusinessReportSchedule"

// DeleteBusinessReportScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBusinessReportSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBusinessReportSchedule for more information on using the DeleteBusinessReportSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBusinessReportScheduleRequest method.
//    req, resp := client.DeleteBusinessReportScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteBusinessReportSchedule
func (c *AlexaForBusiness) DeleteBusinessReportScheduleRequest(input *DeleteBusinessReportScheduleInput) (req *request.Request, output *DeleteBusinessReportScheduleOutput) {
	op := &request.Operation{
		Name:       opDeleteBusinessReportSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBusinessReportScheduleInput{}
	}

	output = &DeleteBusinessReportScheduleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBusinessReportSchedule API operation for Alexa For Business.
//
// Deletes the recurring report delivery schedule with the specified schedule
// ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DeleteBusinessReportSchedule for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteBusinessReportSchedule
func (c *AlexaForBusiness) DeleteBusinessReportSchedule(input *DeleteBusinessReportScheduleInput) (*DeleteBusinessReportScheduleOutput, error) {
	req, out := c.DeleteBusinessReportScheduleRequest(input)
	return out, req.Send()
}

// DeleteBusinessReportScheduleWithContext is the same as DeleteBusinessReportSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBusinessReportSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DeleteBusinessReportScheduleWithContext(ctx aws.Context, input *DeleteBusinessReportScheduleInput, opts ...request.Option) (*DeleteBusinessReportScheduleOutput, error) {
	req, out := c.DeleteBusinessReportScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConferenceProvider = "DeleteConferenceProvider"

// DeleteConferenceProviderRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConferenceProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConferenceProvider for more information on using the DeleteConferenceProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConferenceProviderRequest method.
//    req, resp := client.DeleteConferenceProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteConferenceProvider
func (c *AlexaForBusiness) DeleteConferenceProviderRequest(input *DeleteConferenceProviderInput) (req *request.Request, output *DeleteConferenceProviderOutput) {
	op := &request.Operation{
		Name:       opDeleteConferenceProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConferenceProviderInput{}
	}

	output = &DeleteConferenceProviderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConferenceProvider API operation for Alexa For Business.
//
// Deletes a conference provider.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DeleteConferenceProvider for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteConferenceProvider
func (c *AlexaForBusiness) DeleteConferenceProvider(input *DeleteConferenceProviderInput) (*DeleteConferenceProviderOutput, error) {
	req, out := c.DeleteConferenceProviderRequest(input)
	return out, req.Send()
}

// DeleteConferenceProviderWithContext is the same as DeleteConferenceProvider with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConferenceProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DeleteConferenceProviderWithContext(ctx aws.Context, input *DeleteConferenceProviderInput, opts ...request.Option) (*DeleteConferenceProviderOutput, error) {
	req, out := c.DeleteConferenceProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteContact = "DeleteContact"

// DeleteContactRequest generates a "aws/request.Request" representing the
// client's request for the DeleteContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteContact for more information on using the DeleteContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteContactRequest method.
//    req, resp := client.DeleteContactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteContact
func (c *AlexaForBusiness) DeleteContactRequest(input *DeleteContactInput) (req *request.Request, output *DeleteContactOutput) {
	op := &request.Operation{
		Name:       opDeleteContact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteContactInput{}
	}

	output = &DeleteContactOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteContact API operation for Alexa For Business.
//
// Deletes a contact by the contact ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DeleteContact for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteContact
func (c *AlexaForBusiness) DeleteContact(input *DeleteContactInput) (*DeleteContactOutput, error) {
	req, out := c.DeleteContactRequest(input)
	return out, req.Send()
}

// DeleteContactWithContext is the same as DeleteContact with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DeleteContactWithContext(ctx aws.Context, input *DeleteContactInput, opts ...request.Option) (*DeleteContactOutput, error) {
	req, out := c.DeleteContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDevice = "DeleteDevice"

// DeleteDeviceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDevice for more information on using the DeleteDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDeviceRequest method.
//    req, resp := client.DeleteDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteDevice
func (c *AlexaForBusiness) DeleteDeviceRequest(input *DeleteDeviceInput) (req *request.Request, output *DeleteDeviceOutput) {
	op := &request.Operation{
		Name:       opDeleteDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDeviceInput{}
	}

	output = &DeleteDeviceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDevice API operation for Alexa For Business.
//
// Removes a device from Alexa For Business.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DeleteDevice for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
//   * InvalidCertificateAuthorityException
//   The Certificate Authority can't issue or revoke a certificate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteDevice
func (c *AlexaForBusiness) DeleteDevice(input *DeleteDeviceInput) (*DeleteDeviceOutput, error) {
	req, out := c.DeleteDeviceRequest(input)
	return out, req.Send()
}

// DeleteDeviceWithContext is the same as DeleteDevice with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DeleteDeviceWithContext(ctx aws.Context, input *DeleteDeviceInput, opts ...request.Option) (*DeleteDeviceOutput, error) {
	req, out := c.DeleteDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDeviceUsageData = "DeleteDeviceUsageData"

// DeleteDeviceUsageDataRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDeviceUsageData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDeviceUsageData for more information on using the DeleteDeviceUsageData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDeviceUsageDataRequest method.
//    req, resp := client.DeleteDeviceUsageDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteDeviceUsageData
func (c *AlexaForBusiness) DeleteDeviceUsageDataRequest(input *DeleteDeviceUsageDataInput) (req *request.Request, output *DeleteDeviceUsageDataOutput) {
	op := &request.Operation{
		Name:       opDeleteDeviceUsageData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDeviceUsageDataInput{}
	}

	output = &DeleteDeviceUsageDataOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDeviceUsageData API operation for Alexa For Business.
//
// When this action is called for a specified shared device, it allows authorized
// users to delete the device's entire previous history of voice input data
// and associated response data. This action can be called once every 24 hours
// for a specific shared device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DeleteDeviceUsageData for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
//   * DeviceNotRegisteredException
//   The request failed because this device is no longer registered and therefore
//   no longer managed by this account.
//
//   * LimitExceededException
//   You are performing an action that would put you beyond your account's limits.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteDeviceUsageData
func (c *AlexaForBusiness) DeleteDeviceUsageData(input *DeleteDeviceUsageDataInput) (*DeleteDeviceUsageDataOutput, error) {
	req, out := c.DeleteDeviceUsageDataRequest(input)
	return out, req.Send()
}

// DeleteDeviceUsageDataWithContext is the same as DeleteDeviceUsageData with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDeviceUsageData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DeleteDeviceUsageDataWithContext(ctx aws.Context, input *DeleteDeviceUsageDataInput, opts ...request.Option) (*DeleteDeviceUsageDataOutput, error) {
	req, out := c.DeleteDeviceUsageDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGatewayGroup = "DeleteGatewayGroup"

// DeleteGatewayGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGatewayGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGatewayGroup for more information on using the DeleteGatewayGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGatewayGroupRequest method.
//    req, resp := client.DeleteGatewayGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteGatewayGroup
func (c *AlexaForBusiness) DeleteGatewayGroupRequest(input *DeleteGatewayGroupInput) (req *request.Request, output *DeleteGatewayGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteGatewayGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGatewayGroupInput{}
	}

	output = &DeleteGatewayGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteGatewayGroup API operation for Alexa For Business.
//
// Deletes a gateway group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DeleteGatewayGroup for usage and error information.
//
// Returned Error Types:
//   * ResourceAssociatedException
//   Another resource is associated with the resource in the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteGatewayGroup
func (c *AlexaForBusiness) DeleteGatewayGroup(input *DeleteGatewayGroupInput) (*DeleteGatewayGroupOutput, error) {
	req, out := c.DeleteGatewayGroupRequest(input)
	return out, req.Send()
}

// DeleteGatewayGroupWithContext is the same as DeleteGatewayGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGatewayGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DeleteGatewayGroupWithContext(ctx aws.Context, input *DeleteGatewayGroupInput, opts ...request.Option) (*DeleteGatewayGroupOutput, error) {
	req, out := c.DeleteGatewayGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNetworkProfile = "DeleteNetworkProfile"

// DeleteNetworkProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNetworkProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNetworkProfile for more information on using the DeleteNetworkProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNetworkProfileRequest method.
//    req, resp := client.DeleteNetworkProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteNetworkProfile
func (c *AlexaForBusiness) DeleteNetworkProfileRequest(input *DeleteNetworkProfileInput) (req *request.Request, output *DeleteNetworkProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteNetworkProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNetworkProfileInput{}
	}

	output = &DeleteNetworkProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNetworkProfile API operation for Alexa For Business.
//
// Deletes a network profile by the network profile ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DeleteNetworkProfile for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The resource in the request is already in use.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteNetworkProfile
func (c *AlexaForBusiness) DeleteNetworkProfile(input *DeleteNetworkProfileInput) (*DeleteNetworkProfileOutput, error) {
	req, out := c.DeleteNetworkProfileRequest(input)
	return out, req.Send()
}

// DeleteNetworkProfileWithContext is the same as DeleteNetworkProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNetworkProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DeleteNetworkProfileWithContext(ctx aws.Context, input *DeleteNetworkProfileInput, opts ...request.Option) (*DeleteNetworkProfileOutput, error) {
	req, out := c.DeleteNetworkProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProfile = "DeleteProfile"

// DeleteProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProfile for more information on using the DeleteProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteProfileRequest method.
//    req, resp := client.DeleteProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteProfile
func (c *AlexaForBusiness) DeleteProfileRequest(input *DeleteProfileInput) (req *request.Request, output *DeleteProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteProfileInput{}
	}

	output = &DeleteProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteProfile API operation for Alexa For Business.
//
// Deletes a room profile by the profile ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DeleteProfile for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteProfile
func (c *AlexaForBusiness) DeleteProfile(input *DeleteProfileInput) (*DeleteProfileOutput, error) {
	req, out := c.DeleteProfileRequest(input)
	return out, req.Send()
}

// DeleteProfileWithContext is the same as DeleteProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DeleteProfileWithContext(ctx aws.Context, input *DeleteProfileInput, opts ...request.Option) (*DeleteProfileOutput, error) {
	req, out := c.DeleteProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRoom = "DeleteRoom"

// DeleteRoomRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRoom for more information on using the DeleteRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRoomRequest method.
//    req, resp := client.DeleteRoomRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoom
func (c *AlexaForBusiness) DeleteRoomRequest(input *DeleteRoomInput) (req *request.Request, output *DeleteRoomOutput) {
	op := &request.Operation{
		Name:       opDeleteRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRoomInput{}
	}

	output = &DeleteRoomOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRoom API operation for Alexa For Business.
//
// Deletes a room by the room ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DeleteRoom for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoom
func (c *AlexaForBusiness) DeleteRoom(input *DeleteRoomInput) (*DeleteRoomOutput, error) {
	req, out := c.DeleteRoomRequest(input)
	return out, req.Send()
}

// DeleteRoomWithContext is the same as DeleteRoom with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DeleteRoomWithContext(ctx aws.Context, input *DeleteRoomInput, opts ...request.Option) (*DeleteRoomOutput, error) {
	req, out := c.DeleteRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRoomSkillParameter = "DeleteRoomSkillParameter"

// DeleteRoomSkillParameterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRoomSkillParameter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRoomSkillParameter for more information on using the DeleteRoomSkillParameter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRoomSkillParameterRequest method.
//    req, resp := client.DeleteRoomSkillParameterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoomSkillParameter
func (c *AlexaForBusiness) DeleteRoomSkillParameterRequest(input *DeleteRoomSkillParameterInput) (req *request.Request, output *DeleteRoomSkillParameterOutput) {
	op := &request.Operation{
		Name:       opDeleteRoomSkillParameter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRoomSkillParameterInput{}
	}

	output = &DeleteRoomSkillParameterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRoomSkillParameter API operation for Alexa For Business.
//
// Deletes room skill parameter details by room, skill, and parameter key ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DeleteRoomSkillParameter for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoomSkillParameter
func (c *AlexaForBusiness) DeleteRoomSkillParameter(input *DeleteRoomSkillParameterInput) (*DeleteRoomSkillParameterOutput, error) {
	req, out := c.DeleteRoomSkillParameterRequest(input)
	return out, req.Send()
}

// DeleteRoomSkillParameterWithContext is the same as DeleteRoomSkillParameter with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRoomSkillParameter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DeleteRoomSkillParameterWithContext(ctx aws.Context, input *DeleteRoomSkillParameterInput, opts ...request.Option) (*DeleteRoomSkillParameterOutput, error) {
	req, out := c.DeleteRoomSkillParameterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSkillAuthorization = "DeleteSkillAuthorization"

// DeleteSkillAuthorizationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSkillAuthorization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSkillAuthorization for more information on using the DeleteSkillAuthorization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSkillAuthorizationRequest method.
//    req, resp := client.DeleteSkillAuthorizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillAuthorization
func (c *AlexaForBusiness) DeleteSkillAuthorizationRequest(input *DeleteSkillAuthorizationInput) (req *request.Request, output *DeleteSkillAuthorizationOutput) {
	op := &request.Operation{
		Name:       opDeleteSkillAuthorization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSkillAuthorizationInput{}
	}

	output = &DeleteSkillAuthorizationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSkillAuthorization API operation for Alexa For Business.
//
// Unlinks a third-party account from a skill.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DeleteSkillAuthorization for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillAuthorization
func (c *AlexaForBusiness) DeleteSkillAuthorization(input *DeleteSkillAuthorizationInput) (*DeleteSkillAuthorizationOutput, error) {
	req, out := c.DeleteSkillAuthorizationRequest(input)
	return out, req.Send()
}

// DeleteSkillAuthorizationWithContext is the same as DeleteSkillAuthorization with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSkillAuthorization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DeleteSkillAuthorizationWithContext(ctx aws.Context, input *DeleteSkillAuthorizationInput, opts ...request.Option) (*DeleteSkillAuthorizationOutput, error) {
	req, out := c.DeleteSkillAuthorizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSkillGroup = "DeleteSkillGroup"

// DeleteSkillGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSkillGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSkillGroup for more information on using the DeleteSkillGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSkillGroupRequest method.
//    req, resp := client.DeleteSkillGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillGroup
func (c *AlexaForBusiness) DeleteSkillGroupRequest(input *DeleteSkillGroupInput) (req *request.Request, output *DeleteSkillGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteSkillGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSkillGroupInput{}
	}

	output = &DeleteSkillGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSkillGroup API operation for Alexa For Business.
//
// Deletes a skill group by skill group ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DeleteSkillGroup for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillGroup
func (c *AlexaForBusiness) DeleteSkillGroup(input *DeleteSkillGroupInput) (*DeleteSkillGroupOutput, error) {
	req, out := c.DeleteSkillGroupRequest(input)
	return out, req.Send()
}

// DeleteSkillGroupWithContext is the same as DeleteSkillGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSkillGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DeleteSkillGroupWithContext(ctx aws.Context, input *DeleteSkillGroupInput, opts ...request.Option) (*DeleteSkillGroupOutput, error) {
	req, out := c.DeleteSkillGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUser for more information on using the DeleteUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserRequest method.
//    req, resp := client.DeleteUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteUser
func (c *AlexaForBusiness) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	output = &DeleteUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUser API operation for Alexa For Business.
//
// Deletes a specified user by user ARN and enrollment ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DeleteUser for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteUser
func (c *AlexaForBusiness) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	return out, req.Send()
}

// DeleteUserWithContext is the same as DeleteUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DeleteUserWithContext(ctx aws.Context, input *DeleteUserInput, opts ...request.Option) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateContactFromAddressBook = "DisassociateContactFromAddressBook"

// DisassociateContactFromAddressBookRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateContactFromAddressBook operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateContactFromAddressBook for more information on using the DisassociateContactFromAddressBook
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateContactFromAddressBookRequest method.
//    req, resp := client.DisassociateContactFromAddressBookRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateContactFromAddressBook
func (c *AlexaForBusiness) DisassociateContactFromAddressBookRequest(input *DisassociateContactFromAddressBookInput) (req *request.Request, output *DisassociateContactFromAddressBookOutput) {
	op := &request.Operation{
		Name:       opDisassociateContactFromAddressBook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateContactFromAddressBookInput{}
	}

	output = &DisassociateContactFromAddressBookOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateContactFromAddressBook API operation for Alexa For Business.
//
// Disassociates a contact from a given address book.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DisassociateContactFromAddressBook for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateContactFromAddressBook
func (c *AlexaForBusiness) DisassociateContactFromAddressBook(input *DisassociateContactFromAddressBookInput) (*DisassociateContactFromAddressBookOutput, error) {
	req, out := c.DisassociateContactFromAddressBookRequest(input)
	return out, req.Send()
}

// DisassociateContactFromAddressBookWithContext is the same as DisassociateContactFromAddressBook with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateContactFromAddressBook for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DisassociateContactFromAddressBookWithContext(ctx aws.Context, input *DisassociateContactFromAddressBookInput, opts ...request.Option) (*DisassociateContactFromAddressBookOutput, error) {
	req, out := c.DisassociateContactFromAddressBookRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateDeviceFromRoom = "DisassociateDeviceFromRoom"

// DisassociateDeviceFromRoomRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateDeviceFromRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateDeviceFromRoom for more information on using the DisassociateDeviceFromRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateDeviceFromRoomRequest method.
//    req, resp := client.DisassociateDeviceFromRoomRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateDeviceFromRoom
func (c *AlexaForBusiness) DisassociateDeviceFromRoomRequest(input *DisassociateDeviceFromRoomInput) (req *request.Request, output *DisassociateDeviceFromRoomOutput) {
	op := &request.Operation{
		Name:       opDisassociateDeviceFromRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateDeviceFromRoomInput{}
	}

	output = &DisassociateDeviceFromRoomOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateDeviceFromRoom API operation for Alexa For Business.
//
// Disassociates a device from its current room. The device continues to be
// connected to the Wi-Fi network and is still registered to the account. The
// device settings and skills are removed from the room.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DisassociateDeviceFromRoom for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
//   * DeviceNotRegisteredException
//   The request failed because this device is no longer registered and therefore
//   no longer managed by this account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateDeviceFromRoom
func (c *AlexaForBusiness) DisassociateDeviceFromRoom(input *DisassociateDeviceFromRoomInput) (*DisassociateDeviceFromRoomOutput, error) {
	req, out := c.DisassociateDeviceFromRoomRequest(input)
	return out, req.Send()
}

// DisassociateDeviceFromRoomWithContext is the same as DisassociateDeviceFromRoom with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateDeviceFromRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DisassociateDeviceFromRoomWithContext(ctx aws.Context, input *DisassociateDeviceFromRoomInput, opts ...request.Option) (*DisassociateDeviceFromRoomOutput, error) {
	req, out := c.DisassociateDeviceFromRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateSkillFromSkillGroup = "DisassociateSkillFromSkillGroup"

// DisassociateSkillFromSkillGroupRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateSkillFromSkillGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateSkillFromSkillGroup for more information on using the DisassociateSkillFromSkillGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateSkillFromSkillGroupRequest method.
//    req, resp := client.DisassociateSkillFromSkillGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillFromSkillGroup
func (c *AlexaForBusiness) DisassociateSkillFromSkillGroupRequest(input *DisassociateSkillFromSkillGroupInput) (req *request.Request, output *DisassociateSkillFromSkillGroupOutput) {
	op := &request.Operation{
		Name:       opDisassociateSkillFromSkillGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateSkillFromSkillGroupInput{}
	}

	output = &DisassociateSkillFromSkillGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateSkillFromSkillGroup API operation for Alexa For Business.
//
// Disassociates a skill from a skill group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DisassociateSkillFromSkillGroup for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillFromSkillGroup
func (c *AlexaForBusiness) DisassociateSkillFromSkillGroup(input *DisassociateSkillFromSkillGroupInput) (*DisassociateSkillFromSkillGroupOutput, error) {
	req, out := c.DisassociateSkillFromSkillGroupRequest(input)
	return out, req.Send()
}

// DisassociateSkillFromSkillGroupWithContext is the same as DisassociateSkillFromSkillGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateSkillFromSkillGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DisassociateSkillFromSkillGroupWithContext(ctx aws.Context, input *DisassociateSkillFromSkillGroupInput, opts ...request.Option) (*DisassociateSkillFromSkillGroupOutput, error) {
	req, out := c.DisassociateSkillFromSkillGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateSkillFromUsers = "DisassociateSkillFromUsers"

// DisassociateSkillFromUsersRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateSkillFromUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateSkillFromUsers for more information on using the DisassociateSkillFromUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateSkillFromUsersRequest method.
//    req, resp := client.DisassociateSkillFromUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillFromUsers
func (c *AlexaForBusiness) DisassociateSkillFromUsersRequest(input *DisassociateSkillFromUsersInput) (req *request.Request, output *DisassociateSkillFromUsersOutput) {
	op := &request.Operation{
		Name:       opDisassociateSkillFromUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateSkillFromUsersInput{}
	}

	output = &DisassociateSkillFromUsersOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateSkillFromUsers API operation for Alexa For Business.
//
// Makes a private skill unavailable for enrolled users and prevents them from
// enabling it on their devices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DisassociateSkillFromUsers for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillFromUsers
func (c *AlexaForBusiness) DisassociateSkillFromUsers(input *DisassociateSkillFromUsersInput) (*DisassociateSkillFromUsersOutput, error) {
	req, out := c.DisassociateSkillFromUsersRequest(input)
	return out, req.Send()
}

// DisassociateSkillFromUsersWithContext is the same as DisassociateSkillFromUsers with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateSkillFromUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DisassociateSkillFromUsersWithContext(ctx aws.Context, input *DisassociateSkillFromUsersInput, opts ...request.Option) (*DisassociateSkillFromUsersOutput, error) {
	req, out := c.DisassociateSkillFromUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateSkillGroupFromRoom = "DisassociateSkillGroupFromRoom"

// DisassociateSkillGroupFromRoomRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateSkillGroupFromRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateSkillGroupFromRoom for more information on using the DisassociateSkillGroupFromRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateSkillGroupFromRoomRequest method.
//    req, resp := client.DisassociateSkillGroupFromRoomRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillGroupFromRoom
func (c *AlexaForBusiness) DisassociateSkillGroupFromRoomRequest(input *DisassociateSkillGroupFromRoomInput) (req *request.Request, output *DisassociateSkillGroupFromRoomOutput) {
	op := &request.Operation{
		Name:       opDisassociateSkillGroupFromRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateSkillGroupFromRoomInput{}
	}

	output = &DisassociateSkillGroupFromRoomOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateSkillGroupFromRoom API operation for Alexa For Business.
//
// Disassociates a skill group from a specified room. This disables all skills
// in the skill group on all devices in the room.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation DisassociateSkillGroupFromRoom for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillGroupFromRoom
func (c *AlexaForBusiness) DisassociateSkillGroupFromRoom(input *DisassociateSkillGroupFromRoomInput) (*DisassociateSkillGroupFromRoomOutput, error) {
	req, out := c.DisassociateSkillGroupFromRoomRequest(input)
	return out, req.Send()
}

// DisassociateSkillGroupFromRoomWithContext is the same as DisassociateSkillGroupFromRoom with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateSkillGroupFromRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) DisassociateSkillGroupFromRoomWithContext(ctx aws.Context, input *DisassociateSkillGroupFromRoomInput, opts ...request.Option) (*DisassociateSkillGroupFromRoomOutput, error) {
	req, out := c.DisassociateSkillGroupFromRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opForgetSmartHomeAppliances = "ForgetSmartHomeAppliances"

// ForgetSmartHomeAppliancesRequest generates a "aws/request.Request" representing the
// client's request for the ForgetSmartHomeAppliances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ForgetSmartHomeAppliances for more information on using the ForgetSmartHomeAppliances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ForgetSmartHomeAppliancesRequest method.
//    req, resp := client.ForgetSmartHomeAppliancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ForgetSmartHomeAppliances
func (c *AlexaForBusiness) ForgetSmartHomeAppliancesRequest(input *ForgetSmartHomeAppliancesInput) (req *request.Request, output *ForgetSmartHomeAppliancesOutput) {
	op := &request.Operation{
		Name:       opForgetSmartHomeAppliances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ForgetSmartHomeAppliancesInput{}
	}

	output = &ForgetSmartHomeAppliancesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ForgetSmartHomeAppliances API operation for Alexa For Business.
//
// Forgets smart home appliances associated to a room.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation ForgetSmartHomeAppliances for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ForgetSmartHomeAppliances
func (c *AlexaForBusiness) ForgetSmartHomeAppliances(input *ForgetSmartHomeAppliancesInput) (*ForgetSmartHomeAppliancesOutput, error) {
	req, out := c.ForgetSmartHomeAppliancesRequest(input)
	return out, req.Send()
}

// ForgetSmartHomeAppliancesWithContext is the same as ForgetSmartHomeAppliances with the addition of
// the ability to pass a context and additional request options.
//
// See ForgetSmartHomeAppliances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ForgetSmartHomeAppliancesWithContext(ctx aws.Context, input *ForgetSmartHomeAppliancesInput, opts ...request.Option) (*ForgetSmartHomeAppliancesOutput, error) {
	req, out := c.ForgetSmartHomeAppliancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAddressBook = "GetAddressBook"

// GetAddressBookRequest generates a "aws/request.Request" representing the
// client's request for the GetAddressBook operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAddressBook for more information on using the GetAddressBook
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAddressBookRequest method.
//    req, resp := client.GetAddressBookRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetAddressBook
func (c *AlexaForBusiness) GetAddressBookRequest(input *GetAddressBookInput) (req *request.Request, output *GetAddressBookOutput) {
	op := &request.Operation{
		Name:       opGetAddressBook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAddressBookInput{}
	}

	output = &GetAddressBookOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAddressBook API operation for Alexa For Business.
//
// Gets address the book details by the address book ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation GetAddressBook for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetAddressBook
func (c *AlexaForBusiness) GetAddressBook(input *GetAddressBookInput) (*GetAddressBookOutput, error) {
	req, out := c.GetAddressBookRequest(input)
	return out, req.Send()
}

// GetAddressBookWithContext is the same as GetAddressBook with the addition of
// the ability to pass a context and additional request options.
//
// See GetAddressBook for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) GetAddressBookWithContext(ctx aws.Context, input *GetAddressBookInput, opts ...request.Option) (*GetAddressBookOutput, error) {
	req, out := c.GetAddressBookRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConferencePreference = "GetConferencePreference"

// GetConferencePreferenceRequest generates a "aws/request.Request" representing the
// client's request for the GetConferencePreference operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConferencePreference for more information on using the GetConferencePreference
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetConferencePreferenceRequest method.
//    req, resp := client.GetConferencePreferenceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetConferencePreference
func (c *AlexaForBusiness) GetConferencePreferenceRequest(input *GetConferencePreferenceInput) (req *request.Request, output *GetConferencePreferenceOutput) {
	op := &request.Operation{
		Name:       opGetConferencePreference,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetConferencePreferenceInput{}
	}

	output = &GetConferencePreferenceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConferencePreference API operation for Alexa For Business.
//
// Retrieves the existing conference preferences.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation GetConferencePreference for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetConferencePreference
func (c *AlexaForBusiness) GetConferencePreference(input *GetConferencePreferenceInput) (*GetConferencePreferenceOutput, error) {
	req, out := c.GetConferencePreferenceRequest(input)
	return out, req.Send()
}

// GetConferencePreferenceWithContext is the same as GetConferencePreference with the addition of
// the ability to pass a context and additional request options.
//
// See GetConferencePreference for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) GetConferencePreferenceWithContext(ctx aws.Context, input *GetConferencePreferenceInput, opts ...request.Option) (*GetConferencePreferenceOutput, error) {
	req, out := c.GetConferencePreferenceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConferenceProvider = "GetConferenceProvider"

// GetConferenceProviderRequest generates a "aws/request.Request" representing the
// client's request for the GetConferenceProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConferenceProvider for more information on using the GetConferenceProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetConferenceProviderRequest method.
//    req, resp := client.GetConferenceProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetConferenceProvider
func (c *AlexaForBusiness) GetConferenceProviderRequest(input *GetConferenceProviderInput) (req *request.Request, output *GetConferenceProviderOutput) {
	op := &request.Operation{
		Name:       opGetConferenceProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetConferenceProviderInput{}
	}

	output = &GetConferenceProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConferenceProvider API operation for Alexa For Business.
//
// Gets details about a specific conference provider.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation GetConferenceProvider for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetConferenceProvider
func (c *AlexaForBusiness) GetConferenceProvider(input *GetConferenceProviderInput) (*GetConferenceProviderOutput, error) {
	req, out := c.GetConferenceProviderRequest(input)
	return out, req.Send()
}

// GetConferenceProviderWithContext is the same as GetConferenceProvider with the addition of
// the ability to pass a context and additional request options.
//
// See GetConferenceProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) GetConferenceProviderWithContext(ctx aws.Context, input *GetConferenceProviderInput, opts ...request.Option) (*GetConferenceProviderOutput, error) {
	req, out := c.GetConferenceProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetContact = "GetContact"

// GetContactRequest generates a "aws/request.Request" representing the
// client's request for the GetContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetContact for more information on using the GetContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetContactRequest method.
//    req, resp := client.GetContactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetContact
func (c *AlexaForBusiness) GetContactRequest(input *GetContactInput) (req *request.Request, output *GetContactOutput) {
	op := &request.Operation{
		Name:       opGetContact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContactInput{}
	}

	output = &GetContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetContact API operation for Alexa For Business.
//
// Gets the contact details by the contact ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation GetContact for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetContact
func (c *AlexaForBusiness) GetContact(input *GetContactInput) (*GetContactOutput, error) {
	req, out := c.GetContactRequest(input)
	return out, req.Send()
}

// GetContactWithContext is the same as GetContact with the addition of
// the ability to pass a context and additional request options.
//
// See GetContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) GetContactWithContext(ctx aws.Context, input *GetContactInput, opts ...request.Option) (*GetContactOutput, error) {
	req, out := c.GetContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDevice = "GetDevice"

// GetDeviceRequest generates a "aws/request.Request" representing the
// client's request for the GetDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDevice for more information on using the GetDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeviceRequest method.
//    req, resp := client.GetDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetDevice
func (c *AlexaForBusiness) GetDeviceRequest(input *GetDeviceInput) (req *request.Request, output *GetDeviceOutput) {
	op := &request.Operation{
		Name:       opGetDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeviceInput{}
	}

	output = &GetDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDevice API operation for Alexa For Business.
//
// Gets the details of a device by device ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation GetDevice for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetDevice
func (c *AlexaForBusiness) GetDevice(input *GetDeviceInput) (*GetDeviceOutput, error) {
	req, out := c.GetDeviceRequest(input)
	return out, req.Send()
}

// GetDeviceWithContext is the same as GetDevice with the addition of
// the ability to pass a context and additional request options.
//
// See GetDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) GetDeviceWithContext(ctx aws.Context, input *GetDeviceInput, opts ...request.Option) (*GetDeviceOutput, error) {
	req, out := c.GetDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGateway = "GetGateway"

// GetGatewayRequest generates a "aws/request.Request" representing the
// client's request for the GetGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGateway for more information on using the GetGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGatewayRequest method.
//    req, resp := client.GetGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetGateway
func (c *AlexaForBusiness) GetGatewayRequest(input *GetGatewayInput) (req *request.Request, output *GetGatewayOutput) {
	op := &request.Operation{
		Name:       opGetGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetGatewayInput{}
	}

	output = &GetGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGateway API operation for Alexa For Business.
//
// Retrieves the details of a gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation GetGateway for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetGateway
func (c *AlexaForBusiness) GetGateway(input *GetGatewayInput) (*GetGatewayOutput, error) {
	req, out := c.GetGatewayRequest(input)
	return out, req.Send()
}

// GetGatewayWithContext is the same as GetGateway with the addition of
// the ability to pass a context and additional request options.
//
// See GetGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) GetGatewayWithContext(ctx aws.Context, input *GetGatewayInput, opts ...request.Option) (*GetGatewayOutput, error) {
	req, out := c.GetGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGatewayGroup = "GetGatewayGroup"

// GetGatewayGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetGatewayGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGatewayGroup for more information on using the GetGatewayGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGatewayGroupRequest method.
//    req, resp := client.GetGatewayGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetGatewayGroup
func (c *AlexaForBusiness) GetGatewayGroupRequest(input *GetGatewayGroupInput) (req *request.Request, output *GetGatewayGroupOutput) {
	op := &request.Operation{
		Name:       opGetGatewayGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetGatewayGroupInput{}
	}

	output = &GetGatewayGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGatewayGroup API operation for Alexa For Business.
//
// Retrieves the details of a gateway group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation GetGatewayGroup for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetGatewayGroup
func (c *AlexaForBusiness) GetGatewayGroup(input *GetGatewayGroupInput) (*GetGatewayGroupOutput, error) {
	req, out := c.GetGatewayGroupRequest(input)
	return out, req.Send()
}

// GetGatewayGroupWithContext is the same as GetGatewayGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetGatewayGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) GetGatewayGroupWithContext(ctx aws.Context, input *GetGatewayGroupInput, opts ...request.Option) (*GetGatewayGroupOutput, error) {
	req, out := c.GetGatewayGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInvitationConfiguration = "GetInvitationConfiguration"

// GetInvitationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetInvitationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInvitationConfiguration for more information on using the GetInvitationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInvitationConfigurationRequest method.
//    req, resp := client.GetInvitationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetInvitationConfiguration
func (c *AlexaForBusiness) GetInvitationConfigurationRequest(input *GetInvitationConfigurationInput) (req *request.Request, output *GetInvitationConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetInvitationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInvitationConfigurationInput{}
	}

	output = &GetInvitationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInvitationConfiguration API operation for Alexa For Business.
//
// Retrieves the configured values for the user enrollment invitation email
// template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation GetInvitationConfiguration for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetInvitationConfiguration
func (c *AlexaForBusiness) GetInvitationConfiguration(input *GetInvitationConfigurationInput) (*GetInvitationConfigurationOutput, error) {
	req, out := c.GetInvitationConfigurationRequest(input)
	return out, req.Send()
}

// GetInvitationConfigurationWithContext is the same as GetInvitationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetInvitationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) GetInvitationConfigurationWithContext(ctx aws.Context, input *GetInvitationConfigurationInput, opts ...request.Option) (*GetInvitationConfigurationOutput, error) {
	req, out := c.GetInvitationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetNetworkProfile = "GetNetworkProfile"

// GetNetworkProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetNetworkProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetNetworkProfile for more information on using the GetNetworkProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetNetworkProfileRequest method.
//    req, resp := client.GetNetworkProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetNetworkProfile
func (c *AlexaForBusiness) GetNetworkProfileRequest(input *GetNetworkProfileInput) (req *request.Request, output *GetNetworkProfileOutput) {
	op := &request.Operation{
		Name:       opGetNetworkProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetNetworkProfileInput{}
	}

	output = &GetNetworkProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetNetworkProfile API operation for Alexa For Business.
//
// Gets the network profile details by the network profile ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation GetNetworkProfile for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
//   * InvalidSecretsManagerResourceException
//   A password in SecretsManager is in an invalid state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetNetworkProfile
func (c *AlexaForBusiness) GetNetworkProfile(input *GetNetworkProfileInput) (*GetNetworkProfileOutput, error) {
	req, out := c.GetNetworkProfileRequest(input)
	return out, req.Send()
}

// GetNetworkProfileWithContext is the same as GetNetworkProfile with the addition of
// the ability to pass a context and additional request options.
//
// See GetNetworkProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) GetNetworkProfileWithContext(ctx aws.Context, input *GetNetworkProfileInput, opts ...request.Option) (*GetNetworkProfileOutput, error) {
	req, out := c.GetNetworkProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProfile = "GetProfile"

// GetProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProfile for more information on using the GetProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetProfileRequest method.
//    req, resp := client.GetProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetProfile
func (c *AlexaForBusiness) GetProfileRequest(input *GetProfileInput) (req *request.Request, output *GetProfileOutput) {
	op := &request.Operation{
		Name:       opGetProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetProfileInput{}
	}

	output = &GetProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProfile API operation for Alexa For Business.
//
// Gets the details of a room profile by profile ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation GetProfile for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetProfile
func (c *AlexaForBusiness) GetProfile(input *GetProfileInput) (*GetProfileOutput, error) {
	req, out := c.GetProfileRequest(input)
	return out, req.Send()
}

// GetProfileWithContext is the same as GetProfile with the addition of
// the ability to pass a context and additional request options.
//
// See GetProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) GetProfileWithContext(ctx aws.Context, input *GetProfileInput, opts ...request.Option) (*GetProfileOutput, error) {
	req, out := c.GetProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRoom = "GetRoom"

// GetRoomRequest generates a "aws/request.Request" representing the
// client's request for the GetRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRoom for more information on using the GetRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRoomRequest method.
//    req, resp := client.GetRoomRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoom
func (c *AlexaForBusiness) GetRoomRequest(input *GetRoomInput) (req *request.Request, output *GetRoomOutput) {
	op := &request.Operation{
		Name:       opGetRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRoomInput{}
	}

	output = &GetRoomOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRoom API operation for Alexa For Business.
//
// Gets room details by room ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation GetRoom for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoom
func (c *AlexaForBusiness) GetRoom(input *GetRoomInput) (*GetRoomOutput, error) {
	req, out := c.GetRoomRequest(input)
	return out, req.Send()
}

// GetRoomWithContext is the same as GetRoom with the addition of
// the ability to pass a context and additional request options.
//
// See GetRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) GetRoomWithContext(ctx aws.Context, input *GetRoomInput, opts ...request.Option) (*GetRoomOutput, error) {
	req, out := c.GetRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRoomSkillParameter = "GetRoomSkillParameter"

// GetRoomSkillParameterRequest generates a "aws/request.Request" representing the
// client's request for the GetRoomSkillParameter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRoomSkillParameter for more information on using the GetRoomSkillParameter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRoomSkillParameterRequest method.
//    req, resp := client.GetRoomSkillParameterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoomSkillParameter
func (c *AlexaForBusiness) GetRoomSkillParameterRequest(input *GetRoomSkillParameterInput) (req *request.Request, output *GetRoomSkillParameterOutput) {
	op := &request.Operation{
		Name:       opGetRoomSkillParameter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRoomSkillParameterInput{}
	}

	output = &GetRoomSkillParameterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRoomSkillParameter API operation for Alexa For Business.
//
// Gets room skill parameter details by room, skill, and parameter key ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation GetRoomSkillParameter for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoomSkillParameter
func (c *AlexaForBusiness) GetRoomSkillParameter(input *GetRoomSkillParameterInput) (*GetRoomSkillParameterOutput, error) {
	req, out := c.GetRoomSkillParameterRequest(input)
	return out, req.Send()
}

// GetRoomSkillParameterWithContext is the same as GetRoomSkillParameter with the addition of
// the ability to pass a context and additional request options.
//
// See GetRoomSkillParameter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) GetRoomSkillParameterWithContext(ctx aws.Context, input *GetRoomSkillParameterInput, opts ...request.Option) (*GetRoomSkillParameterOutput, error) {
	req, out := c.GetRoomSkillParameterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSkillGroup = "GetSkillGroup"

// GetSkillGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetSkillGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSkillGroup for more information on using the GetSkillGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSkillGroupRequest method.
//    req, resp := client.GetSkillGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetSkillGroup
func (c *AlexaForBusiness) GetSkillGroupRequest(input *GetSkillGroupInput) (req *request.Request, output *GetSkillGroupOutput) {
	op := &request.Operation{
		Name:       opGetSkillGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSkillGroupInput{}
	}

	output = &GetSkillGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSkillGroup API operation for Alexa For Business.
//
// Gets skill group details by skill group ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation GetSkillGroup for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetSkillGroup
func (c *AlexaForBusiness) GetSkillGroup(input *GetSkillGroupInput) (*GetSkillGroupOutput, error) {
	req, out := c.GetSkillGroupRequest(input)
	return out, req.Send()
}

// GetSkillGroupWithContext is the same as GetSkillGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetSkillGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) GetSkillGroupWithContext(ctx aws.Context, input *GetSkillGroupInput, opts ...request.Option) (*GetSkillGroupOutput, error) {
	req, out := c.GetSkillGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBusinessReportSchedules = "ListBusinessReportSchedules"

// ListBusinessReportSchedulesRequest generates a "aws/request.Request" representing the
// client's request for the ListBusinessReportSchedules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBusinessReportSchedules for more information on using the ListBusinessReportSchedules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListBusinessReportSchedulesRequest method.
//    req, resp := client.ListBusinessReportSchedulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListBusinessReportSchedules
func (c *AlexaForBusiness) ListBusinessReportSchedulesRequest(input *ListBusinessReportSchedulesInput) (req *request.Request, output *ListBusinessReportSchedulesOutput) {
	op := &request.Operation{
		Name:       opListBusinessReportSchedules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBusinessReportSchedulesInput{}
	}

	output = &ListBusinessReportSchedulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBusinessReportSchedules API operation for Alexa For Business.
//
// Lists the details of the schedules that a user configured. A download URL
// of the report associated with each schedule is returned every time this action
// is called. A new download URL is returned each time, and is valid for 24
// hours.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation ListBusinessReportSchedules for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListBusinessReportSchedules
func (c *AlexaForBusiness) ListBusinessReportSchedules(input *ListBusinessReportSchedulesInput) (*ListBusinessReportSchedulesOutput, error) {
	req, out := c.ListBusinessReportSchedulesRequest(input)
	return out, req.Send()
}

// ListBusinessReportSchedulesWithContext is the same as ListBusinessReportSchedules with the addition of
// the ability to pass a context and additional request options.
//
// See ListBusinessReportSchedules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ListBusinessReportSchedulesWithContext(ctx aws.Context, input *ListBusinessReportSchedulesInput, opts ...request.Option) (*ListBusinessReportSchedulesOutput, error) {
	req, out := c.ListBusinessReportSchedulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBusinessReportSchedulesPages iterates over the pages of a ListBusinessReportSchedules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBusinessReportSchedules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListBusinessReportSchedules operation.
//    pageNum := 0
//    err := client.ListBusinessReportSchedulesPages(params,
//        func(page *alexaforbusiness.ListBusinessReportSchedulesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) ListBusinessReportSchedulesPages(input *ListBusinessReportSchedulesInput, fn func(*ListBusinessReportSchedulesOutput, bool) bool) error {
	return c.ListBusinessReportSchedulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBusinessReportSchedulesPagesWithContext same as ListBusinessReportSchedulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ListBusinessReportSchedulesPagesWithContext(ctx aws.Context, input *ListBusinessReportSchedulesInput, fn func(*ListBusinessReportSchedulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBusinessReportSchedulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBusinessReportSchedulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBusinessReportSchedulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListConferenceProviders = "ListConferenceProviders"

// ListConferenceProvidersRequest generates a "aws/request.Request" representing the
// client's request for the ListConferenceProviders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConferenceProviders for more information on using the ListConferenceProviders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListConferenceProvidersRequest method.
//    req, resp := client.ListConferenceProvidersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListConferenceProviders
func (c *AlexaForBusiness) ListConferenceProvidersRequest(input *ListConferenceProvidersInput) (req *request.Request, output *ListConferenceProvidersOutput) {
	op := &request.Operation{
		Name:       opListConferenceProviders,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListConferenceProvidersInput{}
	}

	output = &ListConferenceProvidersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConferenceProviders API operation for Alexa For Business.
//
// Lists conference providers under a specific AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation ListConferenceProviders for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListConferenceProviders
func (c *AlexaForBusiness) ListConferenceProviders(input *ListConferenceProvidersInput) (*ListConferenceProvidersOutput, error) {
	req, out := c.ListConferenceProvidersRequest(input)
	return out, req.Send()
}

// ListConferenceProvidersWithContext is the same as ListConferenceProviders with the addition of
// the ability to pass a context and additional request options.
//
// See ListConferenceProviders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ListConferenceProvidersWithContext(ctx aws.Context, input *ListConferenceProvidersInput, opts ...request.Option) (*ListConferenceProvidersOutput, error) {
	req, out := c.ListConferenceProvidersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListConferenceProvidersPages iterates over the pages of a ListConferenceProviders operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListConferenceProviders method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListConferenceProviders operation.
//    pageNum := 0
//    err := client.ListConferenceProvidersPages(params,
//        func(page *alexaforbusiness.ListConferenceProvidersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) ListConferenceProvidersPages(input *ListConferenceProvidersInput, fn func(*ListConferenceProvidersOutput, bool) bool) error {
	return c.ListConferenceProvidersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListConferenceProvidersPagesWithContext same as ListConferenceProvidersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ListConferenceProvidersPagesWithContext(ctx aws.Context, input *ListConferenceProvidersInput, fn func(*ListConferenceProvidersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListConferenceProvidersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListConferenceProvidersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListConferenceProvidersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDeviceEvents = "ListDeviceEvents"

// ListDeviceEventsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeviceEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeviceEvents for more information on using the ListDeviceEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDeviceEventsRequest method.
//    req, resp := client.ListDeviceEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListDeviceEvents
func (c *AlexaForBusiness) ListDeviceEventsRequest(input *ListDeviceEventsInput) (req *request.Request, output *ListDeviceEventsOutput) {
	op := &request.Operation{
		Name:       opListDeviceEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeviceEventsInput{}
	}

	output = &ListDeviceEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeviceEvents API operation for Alexa For Business.
//
// Lists the device event history, including device connection status, for up
// to 30 days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation ListDeviceEvents for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListDeviceEvents
func (c *AlexaForBusiness) ListDeviceEvents(input *ListDeviceEventsInput) (*ListDeviceEventsOutput, error) {
	req, out := c.ListDeviceEventsRequest(input)
	return out, req.Send()
}

// ListDeviceEventsWithContext is the same as ListDeviceEvents with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeviceEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ListDeviceEventsWithContext(ctx aws.Context, input *ListDeviceEventsInput, opts ...request.Option) (*ListDeviceEventsOutput, error) {
	req, out := c.ListDeviceEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDeviceEventsPages iterates over the pages of a ListDeviceEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDeviceEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDeviceEvents operation.
//    pageNum := 0
//    err := client.ListDeviceEventsPages(params,
//        func(page *alexaforbusiness.ListDeviceEventsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) ListDeviceEventsPages(input *ListDeviceEventsInput, fn func(*ListDeviceEventsOutput, bool) bool) error {
	return c.ListDeviceEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDeviceEventsPagesWithContext same as ListDeviceEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ListDeviceEventsPagesWithContext(ctx aws.Context, input *ListDeviceEventsInput, fn func(*ListDeviceEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDeviceEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDeviceEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDeviceEventsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGatewayGroups = "ListGatewayGroups"

// ListGatewayGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListGatewayGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGatewayGroups for more information on using the ListGatewayGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGatewayGroupsRequest method.
//    req, resp := client.ListGatewayGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGatewayGroups
func (c *AlexaForBusiness) ListGatewayGroupsRequest(input *ListGatewayGroupsInput) (req *request.Request, output *ListGatewayGroupsOutput) {
	op := &request.Operation{
		Name:       opListGatewayGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGatewayGroupsInput{}
	}

	output = &ListGatewayGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGatewayGroups API operation for Alexa For Business.
//
// Retrieves a list of gateway group summaries. Use GetGatewayGroup to retrieve
// details of a specific gateway group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation ListGatewayGroups for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGatewayGroups
func (c *AlexaForBusiness) ListGatewayGroups(input *ListGatewayGroupsInput) (*ListGatewayGroupsOutput, error) {
	req, out := c.ListGatewayGroupsRequest(input)
	return out, req.Send()
}

// ListGatewayGroupsWithContext is the same as ListGatewayGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListGatewayGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ListGatewayGroupsWithContext(ctx aws.Context, input *ListGatewayGroupsInput, opts ...request.Option) (*ListGatewayGroupsOutput, error) {
	req, out := c.ListGatewayGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGatewayGroupsPages iterates over the pages of a ListGatewayGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGatewayGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListGatewayGroups operation.
//    pageNum := 0
//    err := client.ListGatewayGroupsPages(params,
//        func(page *alexaforbusiness.ListGatewayGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) ListGatewayGroupsPages(input *ListGatewayGroupsInput, fn func(*ListGatewayGroupsOutput, bool) bool) error {
	return c.ListGatewayGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGatewayGroupsPagesWithContext same as ListGatewayGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ListGatewayGroupsPagesWithContext(ctx aws.Context, input *ListGatewayGroupsInput, fn func(*ListGatewayGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGatewayGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGatewayGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGatewayGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGateways = "ListGateways"

// ListGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the ListGateways operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGateways for more information on using the ListGateways
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGatewaysRequest method.
//    req, resp := client.ListGatewaysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGateways
func (c *AlexaForBusiness) ListGatewaysRequest(input *ListGatewaysInput) (req *request.Request, output *ListGatewaysOutput) {
	op := &request.Operation{
		Name:       opListGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGatewaysInput{}
	}

	output = &ListGatewaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGateways API operation for Alexa For Business.
//
// Retrieves a list of gateway summaries. Use GetGateway to retrieve details
// of a specific gateway. An optional gateway group ARN can be provided to only
// retrieve gateway summaries of gateways that are associated with that gateway
// group ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation ListGateways for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGateways
func (c *AlexaForBusiness) ListGateways(input *ListGatewaysInput) (*ListGatewaysOutput, error) {
	req, out := c.ListGatewaysRequest(input)
	return out, req.Send()
}

// ListGatewaysWithContext is the same as ListGateways with the addition of
// the ability to pass a context and additional request options.
//
// See ListGateways for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ListGatewaysWithContext(ctx aws.Context, input *ListGatewaysInput, opts ...request.Option) (*ListGatewaysOutput, error) {
	req, out := c.ListGatewaysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGatewaysPages iterates over the pages of a ListGateways operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGateways method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListGateways operation.
//    pageNum := 0
//    err := client.ListGatewaysPages(params,
//        func(page *alexaforbusiness.ListGatewaysOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) ListGatewaysPages(input *ListGatewaysInput, fn func(*ListGatewaysOutput, bool) bool) error {
	return c.ListGatewaysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGatewaysPagesWithContext same as ListGatewaysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ListGatewaysPagesWithContext(ctx aws.Context, input *ListGatewaysInput, fn func(*ListGatewaysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGatewaysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGatewaysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGatewaysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSkills = "ListSkills"

// ListSkillsRequest generates a "aws/request.Request" representing the
// client's request for the ListSkills operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSkills for more information on using the ListSkills
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSkillsRequest method.
//    req, resp := client.ListSkillsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkills
func (c *AlexaForBusiness) ListSkillsRequest(input *ListSkillsInput) (req *request.Request, output *ListSkillsOutput) {
	op := &request.Operation{
		Name:       opListSkills,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSkillsInput{}
	}

	output = &ListSkillsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSkills API operation for Alexa For Business.
//
// Lists all enabled skills in a specific skill group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation ListSkills for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkills
func (c *AlexaForBusiness) ListSkills(input *ListSkillsInput) (*ListSkillsOutput, error) {
	req, out := c.ListSkillsRequest(input)
	return out, req.Send()
}

// ListSkillsWithContext is the same as ListSkills with the addition of
// the ability to pass a context and additional request options.
//
// See ListSkills for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ListSkillsWithContext(ctx aws.Context, input *ListSkillsInput, opts ...request.Option) (*ListSkillsOutput, error) {
	req, out := c.ListSkillsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSkillsPages iterates over the pages of a ListSkills operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSkills method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSkills operation.
//    pageNum := 0
//    err := client.ListSkillsPages(params,
//        func(page *alexaforbusiness.ListSkillsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) ListSkillsPages(input *ListSkillsInput, fn func(*ListSkillsOutput, bool) bool) error {
	return c.ListSkillsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSkillsPagesWithContext same as ListSkillsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ListSkillsPagesWithContext(ctx aws.Context, input *ListSkillsInput, fn func(*ListSkillsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSkillsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSkillsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSkillsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSkillsStoreCategories = "ListSkillsStoreCategories"

// ListSkillsStoreCategoriesRequest generates a "aws/request.Request" representing the
// client's request for the ListSkillsStoreCategories operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSkillsStoreCategories for more information on using the ListSkillsStoreCategories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSkillsStoreCategoriesRequest method.
//    req, resp := client.ListSkillsStoreCategoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreCategories
func (c *AlexaForBusiness) ListSkillsStoreCategoriesRequest(input *ListSkillsStoreCategoriesInput) (req *request.Request, output *ListSkillsStoreCategoriesOutput) {
	op := &request.Operation{
		Name:       opListSkillsStoreCategories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSkillsStoreCategoriesInput{}
	}

	output = &ListSkillsStoreCategoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSkillsStoreCategories API operation for Alexa For Business.
//
// Lists all categories in the Alexa skill store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation ListSkillsStoreCategories for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreCategories
func (c *AlexaForBusiness) ListSkillsStoreCategories(input *ListSkillsStoreCategoriesInput) (*ListSkillsStoreCategoriesOutput, error) {
	req, out := c.ListSkillsStoreCategoriesRequest(input)
	return out, req.Send()
}

// ListSkillsStoreCategoriesWithContext is the same as ListSkillsStoreCategories with the addition of
// the ability to pass a context and additional request options.
//
// See ListSkillsStoreCategories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ListSkillsStoreCategoriesWithContext(ctx aws.Context, input *ListSkillsStoreCategoriesInput, opts ...request.Option) (*ListSkillsStoreCategoriesOutput, error) {
	req, out := c.ListSkillsStoreCategoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSkillsStoreCategoriesPages iterates over the pages of a ListSkillsStoreCategories operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSkillsStoreCategories method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSkillsStoreCategories operation.
//    pageNum := 0
//    err := client.ListSkillsStoreCategoriesPages(params,
//        func(page *alexaforbusiness.ListSkillsStoreCategoriesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) ListSkillsStoreCategoriesPages(input *ListSkillsStoreCategoriesInput, fn func(*ListSkillsStoreCategoriesOutput, bool) bool) error {
	return c.ListSkillsStoreCategoriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSkillsStoreCategoriesPagesWithContext same as ListSkillsStoreCategoriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ListSkillsStoreCategoriesPagesWithContext(ctx aws.Context, input *ListSkillsStoreCategoriesInput, fn func(*ListSkillsStoreCategoriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSkillsStoreCategoriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSkillsStoreCategoriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSkillsStoreCategoriesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSkillsStoreSkillsByCategory = "ListSkillsStoreSkillsByCategory"

// ListSkillsStoreSkillsByCategoryRequest generates a "aws/request.Request" representing the
// client's request for the ListSkillsStoreSkillsByCategory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSkillsStoreSkillsByCategory for more information on using the ListSkillsStoreSkillsByCategory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSkillsStoreSkillsByCategoryRequest method.
//    req, resp := client.ListSkillsStoreSkillsByCategoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreSkillsByCategory
func (c *AlexaForBusiness) ListSkillsStoreSkillsByCategoryRequest(input *ListSkillsStoreSkillsByCategoryInput) (req *request.Request, output *ListSkillsStoreSkillsByCategoryOutput) {
	op := &request.Operation{
		Name:       opListSkillsStoreSkillsByCategory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSkillsStoreSkillsByCategoryInput{}
	}

	output = &ListSkillsStoreSkillsByCategoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSkillsStoreSkillsByCategory API operation for Alexa For Business.
//
// Lists all skills in the Alexa skill store by category.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation ListSkillsStoreSkillsByCategory for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreSkillsByCategory
func (c *AlexaForBusiness) ListSkillsStoreSkillsByCategory(input *ListSkillsStoreSkillsByCategoryInput) (*ListSkillsStoreSkillsByCategoryOutput, error) {
	req, out := c.ListSkillsStoreSkillsByCategoryRequest(input)
	return out, req.Send()
}

// ListSkillsStoreSkillsByCategoryWithContext is the same as ListSkillsStoreSkillsByCategory with the addition of
// the ability to pass a context and additional request options.
//
// See ListSkillsStoreSkillsByCategory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ListSkillsStoreSkillsByCategoryWithContext(ctx aws.Context, input *ListSkillsStoreSkillsByCategoryInput, opts ...request.Option) (*ListSkillsStoreSkillsByCategoryOutput, error) {
	req, out := c.ListSkillsStoreSkillsByCategoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSkillsStoreSkillsByCategoryPages iterates over the pages of a ListSkillsStoreSkillsByCategory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSkillsStoreSkillsByCategory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSkillsStoreSkillsByCategory operation.
//    pageNum := 0
//    err := client.ListSkillsStoreSkillsByCategoryPages(params,
//        func(page *alexaforbusiness.ListSkillsStoreSkillsByCategoryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) ListSkillsStoreSkillsByCategoryPages(input *ListSkillsStoreSkillsByCategoryInput, fn func(*ListSkillsStoreSkillsByCategoryOutput, bool) bool) error {
	return c.ListSkillsStoreSkillsByCategoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSkillsStoreSkillsByCategoryPagesWithContext same as ListSkillsStoreSkillsByCategoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ListSkillsStoreSkillsByCategoryPagesWithContext(ctx aws.Context, input *ListSkillsStoreSkillsByCategoryInput, fn func(*ListSkillsStoreSkillsByCategoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSkillsStoreSkillsByCategoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSkillsStoreSkillsByCategoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSkillsStoreSkillsByCategoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSmartHomeAppliances = "ListSmartHomeAppliances"

// ListSmartHomeAppliancesRequest generates a "aws/request.Request" representing the
// client's request for the ListSmartHomeAppliances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSmartHomeAppliances for more information on using the ListSmartHomeAppliances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSmartHomeAppliancesRequest method.
//    req, resp := client.ListSmartHomeAppliancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSmartHomeAppliances
func (c *AlexaForBusiness) ListSmartHomeAppliancesRequest(input *ListSmartHomeAppliancesInput) (req *request.Request, output *ListSmartHomeAppliancesOutput) {
	op := &request.Operation{
		Name:       opListSmartHomeAppliances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSmartHomeAppliancesInput{}
	}

	output = &ListSmartHomeAppliancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSmartHomeAppliances API operation for Alexa For Business.
//
// Lists all of the smart home appliances associated with a room.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation ListSmartHomeAppliances for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSmartHomeAppliances
func (c *AlexaForBusiness) ListSmartHomeAppliances(input *ListSmartHomeAppliancesInput) (*ListSmartHomeAppliancesOutput, error) {
	req, out := c.ListSmartHomeAppliancesRequest(input)
	return out, req.Send()
}

// ListSmartHomeAppliancesWithContext is the same as ListSmartHomeAppliances with the addition of
// the ability to pass a context and additional request options.
//
// See ListSmartHomeAppliances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ListSmartHomeAppliancesWithContext(ctx aws.Context, input *ListSmartHomeAppliancesInput, opts ...request.Option) (*ListSmartHomeAppliancesOutput, error) {
	req, out := c.ListSmartHomeAppliancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSmartHomeAppliancesPages iterates over the pages of a ListSmartHomeAppliances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSmartHomeAppliances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSmartHomeAppliances operation.
//    pageNum := 0
//    err := client.ListSmartHomeAppliancesPages(params,
//        func(page *alexaforbusiness.ListSmartHomeAppliancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) ListSmartHomeAppliancesPages(input *ListSmartHomeAppliancesInput, fn func(*ListSmartHomeAppliancesOutput, bool) bool) error {
	return c.ListSmartHomeAppliancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSmartHomeAppliancesPagesWithContext same as ListSmartHomeAppliancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ListSmartHomeAppliancesPagesWithContext(ctx aws.Context, input *ListSmartHomeAppliancesInput, fn func(*ListSmartHomeAppliancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSmartHomeAppliancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSmartHomeAppliancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSmartHomeAppliancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTags = "ListTags"

// ListTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTags for more information on using the ListTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsRequest method.
//    req, resp := client.ListTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListTags
func (c *AlexaForBusiness) ListTagsRequest(input *ListTagsInput) (req *request.Request, output *ListTagsOutput) {
	op := &request.Operation{
		Name:       opListTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	output = &ListTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTags API operation for Alexa For Business.
//
// Lists all tags for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation ListTags for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListTags
func (c *AlexaForBusiness) ListTags(input *ListTagsInput) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	return out, req.Send()
}

// ListTagsWithContext is the same as ListTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ListTagsWithContext(ctx aws.Context, input *ListTagsInput, opts ...request.Option) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsPages iterates over the pages of a ListTags operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTags method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTags operation.
//    pageNum := 0
//    err := client.ListTagsPages(params,
//        func(page *alexaforbusiness.ListTagsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) ListTagsPages(input *ListTagsInput, fn func(*ListTagsOutput, bool) bool) error {
	return c.ListTagsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsPagesWithContext same as ListTagsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ListTagsPagesWithContext(ctx aws.Context, input *ListTagsInput, fn func(*ListTagsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutConferencePreference = "PutConferencePreference"

// PutConferencePreferenceRequest generates a "aws/request.Request" representing the
// client's request for the PutConferencePreference operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutConferencePreference for more information on using the PutConferencePreference
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutConferencePreferenceRequest method.
//    req, resp := client.PutConferencePreferenceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutConferencePreference
func (c *AlexaForBusiness) PutConferencePreferenceRequest(input *PutConferencePreferenceInput) (req *request.Request, output *PutConferencePreferenceOutput) {
	op := &request.Operation{
		Name:       opPutConferencePreference,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutConferencePreferenceInput{}
	}

	output = &PutConferencePreferenceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutConferencePreference API operation for Alexa For Business.
//
// Sets the conference preferences on a specific conference provider at the
// account level.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation PutConferencePreference for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutConferencePreference
func (c *AlexaForBusiness) PutConferencePreference(input *PutConferencePreferenceInput) (*PutConferencePreferenceOutput, error) {
	req, out := c.PutConferencePreferenceRequest(input)
	return out, req.Send()
}

// PutConferencePreferenceWithContext is the same as PutConferencePreference with the addition of
// the ability to pass a context and additional request options.
//
// See PutConferencePreference for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) PutConferencePreferenceWithContext(ctx aws.Context, input *PutConferencePreferenceInput, opts ...request.Option) (*PutConferencePreferenceOutput, error) {
	req, out := c.PutConferencePreferenceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutInvitationConfiguration = "PutInvitationConfiguration"

// PutInvitationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutInvitationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutInvitationConfiguration for more information on using the PutInvitationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutInvitationConfigurationRequest method.
//    req, resp := client.PutInvitationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutInvitationConfiguration
func (c *AlexaForBusiness) PutInvitationConfigurationRequest(input *PutInvitationConfigurationInput) (req *request.Request, output *PutInvitationConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutInvitationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutInvitationConfigurationInput{}
	}

	output = &PutInvitationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutInvitationConfiguration API operation for Alexa For Business.
//
// Configures the email template for the user enrollment invitation with the
// specified attributes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation PutInvitationConfiguration for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutInvitationConfiguration
func (c *AlexaForBusiness) PutInvitationConfiguration(input *PutInvitationConfigurationInput) (*PutInvitationConfigurationOutput, error) {
	req, out := c.PutInvitationConfigurationRequest(input)
	return out, req.Send()
}

// PutInvitationConfigurationWithContext is the same as PutInvitationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutInvitationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) PutInvitationConfigurationWithContext(ctx aws.Context, input *PutInvitationConfigurationInput, opts ...request.Option) (*PutInvitationConfigurationOutput, error) {
	req, out := c.PutInvitationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRoomSkillParameter = "PutRoomSkillParameter"

// PutRoomSkillParameterRequest generates a "aws/request.Request" representing the
// client's request for the PutRoomSkillParameter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRoomSkillParameter for more information on using the PutRoomSkillParameter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutRoomSkillParameterRequest method.
//    req, resp := client.PutRoomSkillParameterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutRoomSkillParameter
func (c *AlexaForBusiness) PutRoomSkillParameterRequest(input *PutRoomSkillParameterInput) (req *request.Request, output *PutRoomSkillParameterOutput) {
	op := &request.Operation{
		Name:       opPutRoomSkillParameter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRoomSkillParameterInput{}
	}

	output = &PutRoomSkillParameterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutRoomSkillParameter API operation for Alexa For Business.
//
// Updates room skill parameter details by room, skill, and parameter key ID.
// Not all skills have a room skill parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation PutRoomSkillParameter for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutRoomSkillParameter
func (c *AlexaForBusiness) PutRoomSkillParameter(input *PutRoomSkillParameterInput) (*PutRoomSkillParameterOutput, error) {
	req, out := c.PutRoomSkillParameterRequest(input)
	return out, req.Send()
}

// PutRoomSkillParameterWithContext is the same as PutRoomSkillParameter with the addition of
// the ability to pass a context and additional request options.
//
// See PutRoomSkillParameter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) PutRoomSkillParameterWithContext(ctx aws.Context, input *PutRoomSkillParameterInput, opts ...request.Option) (*PutRoomSkillParameterOutput, error) {
	req, out := c.PutRoomSkillParameterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutSkillAuthorization = "PutSkillAuthorization"

// PutSkillAuthorizationRequest generates a "aws/request.Request" representing the
// client's request for the PutSkillAuthorization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutSkillAuthorization for more information on using the PutSkillAuthorization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutSkillAuthorizationRequest method.
//    req, resp := client.PutSkillAuthorizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutSkillAuthorization
func (c *AlexaForBusiness) PutSkillAuthorizationRequest(input *PutSkillAuthorizationInput) (req *request.Request, output *PutSkillAuthorizationOutput) {
	op := &request.Operation{
		Name:       opPutSkillAuthorization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutSkillAuthorizationInput{}
	}

	output = &PutSkillAuthorizationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutSkillAuthorization API operation for Alexa For Business.
//
// Links a user's account to a third-party skill provider. If this API operation
// is called by an assumed IAM role, the skill being linked must be a private
// skill. Also, the skill must be owned by the AWS account that assumed the
// IAM role.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation PutSkillAuthorization for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   The caller has no permissions to operate on the resource involved in the
//   API call.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutSkillAuthorization
func (c *AlexaForBusiness) PutSkillAuthorization(input *PutSkillAuthorizationInput) (*PutSkillAuthorizationOutput, error) {
	req, out := c.PutSkillAuthorizationRequest(input)
	return out, req.Send()
}

// PutSkillAuthorizationWithContext is the same as PutSkillAuthorization with the addition of
// the ability to pass a context and additional request options.
//
// See PutSkillAuthorization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) PutSkillAuthorizationWithContext(ctx aws.Context, input *PutSkillAuthorizationInput, opts ...request.Option) (*PutSkillAuthorizationOutput, error) {
	req, out := c.PutSkillAuthorizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterAVSDevice = "RegisterAVSDevice"

// RegisterAVSDeviceRequest generates a "aws/request.Request" representing the
// client's request for the RegisterAVSDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterAVSDevice for more information on using the RegisterAVSDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterAVSDeviceRequest method.
//    req, resp := client.RegisterAVSDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RegisterAVSDevice
func (c *AlexaForBusiness) RegisterAVSDeviceRequest(input *RegisterAVSDeviceInput) (req *request.Request, output *RegisterAVSDeviceOutput) {
	op := &request.Operation{
		Name:       opRegisterAVSDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterAVSDeviceInput{}
	}

	output = &RegisterAVSDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterAVSDevice API operation for Alexa For Business.
//
// Registers an Alexa-enabled device built by an Original Equipment Manufacturer
// (OEM) using Alexa Voice Service (AVS).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation RegisterAVSDevice for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You are performing an action that would put you beyond your account's limits.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
//   * NotFoundException
//   The resource is not found.
//
//   * InvalidDeviceException
//   The device is in an invalid state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RegisterAVSDevice
func (c *AlexaForBusiness) RegisterAVSDevice(input *RegisterAVSDeviceInput) (*RegisterAVSDeviceOutput, error) {
	req, out := c.RegisterAVSDeviceRequest(input)
	return out, req.Send()
}

// RegisterAVSDeviceWithContext is the same as RegisterAVSDevice with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterAVSDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) RegisterAVSDeviceWithContext(ctx aws.Context, input *RegisterAVSDeviceInput, opts ...request.Option) (*RegisterAVSDeviceOutput, error) {
	req, out := c.RegisterAVSDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRejectSkill = "RejectSkill"

// RejectSkillRequest generates a "aws/request.Request" representing the
// client's request for the RejectSkill operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RejectSkill for more information on using the RejectSkill
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RejectSkillRequest method.
//    req, resp := client.RejectSkillRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RejectSkill
func (c *AlexaForBusiness) RejectSkillRequest(input *RejectSkillInput) (req *request.Request, output *RejectSkillOutput) {
	op := &request.Operation{
		Name:       opRejectSkill,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RejectSkillInput{}
	}

	output = &RejectSkillOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RejectSkill API operation for Alexa For Business.
//
// Disassociates a skill from the organization under a user's AWS account. If
// the skill is a private skill, it moves to an AcceptStatus of PENDING. Any
// private or public skill that is rejected can be added later by calling the
// ApproveSkill API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation RejectSkill for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RejectSkill
func (c *AlexaForBusiness) RejectSkill(input *RejectSkillInput) (*RejectSkillOutput, error) {
	req, out := c.RejectSkillRequest(input)
	return out, req.Send()
}

// RejectSkillWithContext is the same as RejectSkill with the addition of
// the ability to pass a context and additional request options.
//
// See RejectSkill for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) RejectSkillWithContext(ctx aws.Context, input *RejectSkillInput, opts ...request.Option) (*RejectSkillOutput, error) {
	req, out := c.RejectSkillRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResolveRoom = "ResolveRoom"

// ResolveRoomRequest generates a "aws/request.Request" representing the
// client's request for the ResolveRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResolveRoom for more information on using the ResolveRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResolveRoomRequest method.
//    req, resp := client.ResolveRoomRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ResolveRoom
func (c *AlexaForBusiness) ResolveRoomRequest(input *ResolveRoomInput) (req *request.Request, output *ResolveRoomOutput) {
	op := &request.Operation{
		Name:       opResolveRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResolveRoomInput{}
	}

	output = &ResolveRoomOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResolveRoom API operation for Alexa For Business.
//
// Determines the details for the room from which a skill request was invoked.
// This operation is used by skill developers.
//
// To query ResolveRoom from an Alexa skill, the skill ID needs to be authorized.
// When the skill is using an AWS Lambda function, the skill is automatically
// authorized when you publish your skill as a private skill to your AWS account.
// Skills that are hosted using a custom web service must be manually authorized.
// To get your skill authorized, contact AWS Support with your AWS account ID
// that queries the ResolveRoom API and skill ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation ResolveRoom for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ResolveRoom
func (c *AlexaForBusiness) ResolveRoom(input *ResolveRoomInput) (*ResolveRoomOutput, error) {
	req, out := c.ResolveRoomRequest(input)
	return out, req.Send()
}

// ResolveRoomWithContext is the same as ResolveRoom with the addition of
// the ability to pass a context and additional request options.
//
// See ResolveRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) ResolveRoomWithContext(ctx aws.Context, input *ResolveRoomInput, opts ...request.Option) (*ResolveRoomOutput, error) {
	req, out := c.ResolveRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokeInvitation = "RevokeInvitation"

// RevokeInvitationRequest generates a "aws/request.Request" representing the
// client's request for the RevokeInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokeInvitation for more information on using the RevokeInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RevokeInvitationRequest method.
//    req, resp := client.RevokeInvitationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RevokeInvitation
func (c *AlexaForBusiness) RevokeInvitationRequest(input *RevokeInvitationInput) (req *request.Request, output *RevokeInvitationOutput) {
	op := &request.Operation{
		Name:       opRevokeInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeInvitationInput{}
	}

	output = &RevokeInvitationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RevokeInvitation API operation for Alexa For Business.
//
// Revokes an invitation and invalidates the enrollment URL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation RevokeInvitation for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RevokeInvitation
func (c *AlexaForBusiness) RevokeInvitation(input *RevokeInvitationInput) (*RevokeInvitationOutput, error) {
	req, out := c.RevokeInvitationRequest(input)
	return out, req.Send()
}

// RevokeInvitationWithContext is the same as RevokeInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See RevokeInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) RevokeInvitationWithContext(ctx aws.Context, input *RevokeInvitationInput, opts ...request.Option) (*RevokeInvitationOutput, error) {
	req, out := c.RevokeInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchAddressBooks = "SearchAddressBooks"

// SearchAddressBooksRequest generates a "aws/request.Request" representing the
// client's request for the SearchAddressBooks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchAddressBooks for more information on using the SearchAddressBooks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchAddressBooksRequest method.
//    req, resp := client.SearchAddressBooksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchAddressBooks
func (c *AlexaForBusiness) SearchAddressBooksRequest(input *SearchAddressBooksInput) (req *request.Request, output *SearchAddressBooksOutput) {
	op := &request.Operation{
		Name:       opSearchAddressBooks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchAddressBooksInput{}
	}

	output = &SearchAddressBooksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchAddressBooks API operation for Alexa For Business.
//
// Searches address books and lists the ones that meet a set of filter and sort
// criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation SearchAddressBooks for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchAddressBooks
func (c *AlexaForBusiness) SearchAddressBooks(input *SearchAddressBooksInput) (*SearchAddressBooksOutput, error) {
	req, out := c.SearchAddressBooksRequest(input)
	return out, req.Send()
}

// SearchAddressBooksWithContext is the same as SearchAddressBooks with the addition of
// the ability to pass a context and additional request options.
//
// See SearchAddressBooks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchAddressBooksWithContext(ctx aws.Context, input *SearchAddressBooksInput, opts ...request.Option) (*SearchAddressBooksOutput, error) {
	req, out := c.SearchAddressBooksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchAddressBooksPages iterates over the pages of a SearchAddressBooks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchAddressBooks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchAddressBooks operation.
//    pageNum := 0
//    err := client.SearchAddressBooksPages(params,
//        func(page *alexaforbusiness.SearchAddressBooksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) SearchAddressBooksPages(input *SearchAddressBooksInput, fn func(*SearchAddressBooksOutput, bool) bool) error {
	return c.SearchAddressBooksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchAddressBooksPagesWithContext same as SearchAddressBooksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchAddressBooksPagesWithContext(ctx aws.Context, input *SearchAddressBooksInput, fn func(*SearchAddressBooksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchAddressBooksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchAddressBooksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchAddressBooksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchContacts = "SearchContacts"

// SearchContactsRequest generates a "aws/request.Request" representing the
// client's request for the SearchContacts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchContacts for more information on using the SearchContacts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchContactsRequest method.
//    req, resp := client.SearchContactsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchContacts
func (c *AlexaForBusiness) SearchContactsRequest(input *SearchContactsInput) (req *request.Request, output *SearchContactsOutput) {
	op := &request.Operation{
		Name:       opSearchContacts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchContactsInput{}
	}

	output = &SearchContactsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchContacts API operation for Alexa For Business.
//
// Searches contacts and lists the ones that meet a set of filter and sort criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation SearchContacts for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchContacts
func (c *AlexaForBusiness) SearchContacts(input *SearchContactsInput) (*SearchContactsOutput, error) {
	req, out := c.SearchContactsRequest(input)
	return out, req.Send()
}

// SearchContactsWithContext is the same as SearchContacts with the addition of
// the ability to pass a context and additional request options.
//
// See SearchContacts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchContactsWithContext(ctx aws.Context, input *SearchContactsInput, opts ...request.Option) (*SearchContactsOutput, error) {
	req, out := c.SearchContactsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchContactsPages iterates over the pages of a SearchContacts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchContacts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchContacts operation.
//    pageNum := 0
//    err := client.SearchContactsPages(params,
//        func(page *alexaforbusiness.SearchContactsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) SearchContactsPages(input *SearchContactsInput, fn func(*SearchContactsOutput, bool) bool) error {
	return c.SearchContactsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchContactsPagesWithContext same as SearchContactsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchContactsPagesWithContext(ctx aws.Context, input *SearchContactsInput, fn func(*SearchContactsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchContactsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchContactsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchContactsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchDevices = "SearchDevices"

// SearchDevicesRequest generates a "aws/request.Request" representing the
// client's request for the SearchDevices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchDevices for more information on using the SearchDevices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchDevicesRequest method.
//    req, resp := client.SearchDevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchDevices
func (c *AlexaForBusiness) SearchDevicesRequest(input *SearchDevicesInput) (req *request.Request, output *SearchDevicesOutput) {
	op := &request.Operation{
		Name:       opSearchDevices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchDevicesInput{}
	}

	output = &SearchDevicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchDevices API operation for Alexa For Business.
//
// Searches devices and lists the ones that meet a set of filter criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation SearchDevices for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchDevices
func (c *AlexaForBusiness) SearchDevices(input *SearchDevicesInput) (*SearchDevicesOutput, error) {
	req, out := c.SearchDevicesRequest(input)
	return out, req.Send()
}

// SearchDevicesWithContext is the same as SearchDevices with the addition of
// the ability to pass a context and additional request options.
//
// See SearchDevices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchDevicesWithContext(ctx aws.Context, input *SearchDevicesInput, opts ...request.Option) (*SearchDevicesOutput, error) {
	req, out := c.SearchDevicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchDevicesPages iterates over the pages of a SearchDevices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchDevices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchDevices operation.
//    pageNum := 0
//    err := client.SearchDevicesPages(params,
//        func(page *alexaforbusiness.SearchDevicesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) SearchDevicesPages(input *SearchDevicesInput, fn func(*SearchDevicesOutput, bool) bool) error {
	return c.SearchDevicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchDevicesPagesWithContext same as SearchDevicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchDevicesPagesWithContext(ctx aws.Context, input *SearchDevicesInput, fn func(*SearchDevicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchDevicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchDevicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchDevicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchNetworkProfiles = "SearchNetworkProfiles"

// SearchNetworkProfilesRequest generates a "aws/request.Request" representing the
// client's request for the SearchNetworkProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchNetworkProfiles for more information on using the SearchNetworkProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchNetworkProfilesRequest method.
//    req, resp := client.SearchNetworkProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchNetworkProfiles
func (c *AlexaForBusiness) SearchNetworkProfilesRequest(input *SearchNetworkProfilesInput) (req *request.Request, output *SearchNetworkProfilesOutput) {
	op := &request.Operation{
		Name:       opSearchNetworkProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchNetworkProfilesInput{}
	}

	output = &SearchNetworkProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchNetworkProfiles API operation for Alexa For Business.
//
// Searches network profiles and lists the ones that meet a set of filter and
// sort criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation SearchNetworkProfiles for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchNetworkProfiles
func (c *AlexaForBusiness) SearchNetworkProfiles(input *SearchNetworkProfilesInput) (*SearchNetworkProfilesOutput, error) {
	req, out := c.SearchNetworkProfilesRequest(input)
	return out, req.Send()
}

// SearchNetworkProfilesWithContext is the same as SearchNetworkProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See SearchNetworkProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchNetworkProfilesWithContext(ctx aws.Context, input *SearchNetworkProfilesInput, opts ...request.Option) (*SearchNetworkProfilesOutput, error) {
	req, out := c.SearchNetworkProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchNetworkProfilesPages iterates over the pages of a SearchNetworkProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchNetworkProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchNetworkProfiles operation.
//    pageNum := 0
//    err := client.SearchNetworkProfilesPages(params,
//        func(page *alexaforbusiness.SearchNetworkProfilesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) SearchNetworkProfilesPages(input *SearchNetworkProfilesInput, fn func(*SearchNetworkProfilesOutput, bool) bool) error {
	return c.SearchNetworkProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchNetworkProfilesPagesWithContext same as SearchNetworkProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchNetworkProfilesPagesWithContext(ctx aws.Context, input *SearchNetworkProfilesInput, fn func(*SearchNetworkProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchNetworkProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchNetworkProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchNetworkProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchProfiles = "SearchProfiles"

// SearchProfilesRequest generates a "aws/request.Request" representing the
// client's request for the SearchProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchProfiles for more information on using the SearchProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchProfilesRequest method.
//    req, resp := client.SearchProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchProfiles
func (c *AlexaForBusiness) SearchProfilesRequest(input *SearchProfilesInput) (req *request.Request, output *SearchProfilesOutput) {
	op := &request.Operation{
		Name:       opSearchProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchProfilesInput{}
	}

	output = &SearchProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchProfiles API operation for Alexa For Business.
//
// Searches room profiles and lists the ones that meet a set of filter criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation SearchProfiles for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchProfiles
func (c *AlexaForBusiness) SearchProfiles(input *SearchProfilesInput) (*SearchProfilesOutput, error) {
	req, out := c.SearchProfilesRequest(input)
	return out, req.Send()
}

// SearchProfilesWithContext is the same as SearchProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See SearchProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchProfilesWithContext(ctx aws.Context, input *SearchProfilesInput, opts ...request.Option) (*SearchProfilesOutput, error) {
	req, out := c.SearchProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchProfilesPages iterates over the pages of a SearchProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchProfiles operation.
//    pageNum := 0
//    err := client.SearchProfilesPages(params,
//        func(page *alexaforbusiness.SearchProfilesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) SearchProfilesPages(input *SearchProfilesInput, fn func(*SearchProfilesOutput, bool) bool) error {
	return c.SearchProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchProfilesPagesWithContext same as SearchProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchProfilesPagesWithContext(ctx aws.Context, input *SearchProfilesInput, fn func(*SearchProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchRooms = "SearchRooms"

// SearchRoomsRequest generates a "aws/request.Request" representing the
// client's request for the SearchRooms operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchRooms for more information on using the SearchRooms
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchRoomsRequest method.
//    req, resp := client.SearchRoomsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchRooms
func (c *AlexaForBusiness) SearchRoomsRequest(input *SearchRoomsInput) (req *request.Request, output *SearchRoomsOutput) {
	op := &request.Operation{
		Name:       opSearchRooms,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchRoomsInput{}
	}

	output = &SearchRoomsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchRooms API operation for Alexa For Business.
//
// Searches rooms and lists the ones that meet a set of filter and sort criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation SearchRooms for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchRooms
func (c *AlexaForBusiness) SearchRooms(input *SearchRoomsInput) (*SearchRoomsOutput, error) {
	req, out := c.SearchRoomsRequest(input)
	return out, req.Send()
}

// SearchRoomsWithContext is the same as SearchRooms with the addition of
// the ability to pass a context and additional request options.
//
// See SearchRooms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchRoomsWithContext(ctx aws.Context, input *SearchRoomsInput, opts ...request.Option) (*SearchRoomsOutput, error) {
	req, out := c.SearchRoomsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchRoomsPages iterates over the pages of a SearchRooms operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchRooms method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchRooms operation.
//    pageNum := 0
//    err := client.SearchRoomsPages(params,
//        func(page *alexaforbusiness.SearchRoomsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) SearchRoomsPages(input *SearchRoomsInput, fn func(*SearchRoomsOutput, bool) bool) error {
	return c.SearchRoomsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchRoomsPagesWithContext same as SearchRoomsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchRoomsPagesWithContext(ctx aws.Context, input *SearchRoomsInput, fn func(*SearchRoomsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchRoomsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchRoomsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchRoomsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchSkillGroups = "SearchSkillGroups"

// SearchSkillGroupsRequest generates a "aws/request.Request" representing the
// client's request for the SearchSkillGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchSkillGroups for more information on using the SearchSkillGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchSkillGroupsRequest method.
//    req, resp := client.SearchSkillGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchSkillGroups
func (c *AlexaForBusiness) SearchSkillGroupsRequest(input *SearchSkillGroupsInput) (req *request.Request, output *SearchSkillGroupsOutput) {
	op := &request.Operation{
		Name:       opSearchSkillGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchSkillGroupsInput{}
	}

	output = &SearchSkillGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchSkillGroups API operation for Alexa For Business.
//
// Searches skill groups and lists the ones that meet a set of filter and sort
// criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation SearchSkillGroups for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchSkillGroups
func (c *AlexaForBusiness) SearchSkillGroups(input *SearchSkillGroupsInput) (*SearchSkillGroupsOutput, error) {
	req, out := c.SearchSkillGroupsRequest(input)
	return out, req.Send()
}

// SearchSkillGroupsWithContext is the same as SearchSkillGroups with the addition of
// the ability to pass a context and additional request options.
//
// See SearchSkillGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchSkillGroupsWithContext(ctx aws.Context, input *SearchSkillGroupsInput, opts ...request.Option) (*SearchSkillGroupsOutput, error) {
	req, out := c.SearchSkillGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchSkillGroupsPages iterates over the pages of a SearchSkillGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchSkillGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchSkillGroups operation.
//    pageNum := 0
//    err := client.SearchSkillGroupsPages(params,
//        func(page *alexaforbusiness.SearchSkillGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) SearchSkillGroupsPages(input *SearchSkillGroupsInput, fn func(*SearchSkillGroupsOutput, bool) bool) error {
	return c.SearchSkillGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchSkillGroupsPagesWithContext same as SearchSkillGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchSkillGroupsPagesWithContext(ctx aws.Context, input *SearchSkillGroupsInput, fn func(*SearchSkillGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchSkillGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchSkillGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchSkillGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchUsers = "SearchUsers"

// SearchUsersRequest generates a "aws/request.Request" representing the
// client's request for the SearchUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchUsers for more information on using the SearchUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchUsersRequest method.
//    req, resp := client.SearchUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchUsers
func (c *AlexaForBusiness) SearchUsersRequest(input *SearchUsersInput) (req *request.Request, output *SearchUsersOutput) {
	op := &request.Operation{
		Name:       opSearchUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchUsersInput{}
	}

	output = &SearchUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchUsers API operation for Alexa For Business.
//
// Searches users and lists the ones that meet a set of filter and sort criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation SearchUsers for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchUsers
func (c *AlexaForBusiness) SearchUsers(input *SearchUsersInput) (*SearchUsersOutput, error) {
	req, out := c.SearchUsersRequest(input)
	return out, req.Send()
}

// SearchUsersWithContext is the same as SearchUsers with the addition of
// the ability to pass a context and additional request options.
//
// See SearchUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchUsersWithContext(ctx aws.Context, input *SearchUsersInput, opts ...request.Option) (*SearchUsersOutput, error) {
	req, out := c.SearchUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchUsersPages iterates over the pages of a SearchUsers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchUsers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchUsers operation.
//    pageNum := 0
//    err := client.SearchUsersPages(params,
//        func(page *alexaforbusiness.SearchUsersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AlexaForBusiness) SearchUsersPages(input *SearchUsersInput, fn func(*SearchUsersOutput, bool) bool) error {
	return c.SearchUsersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchUsersPagesWithContext same as SearchUsersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SearchUsersPagesWithContext(ctx aws.Context, input *SearchUsersInput, fn func(*SearchUsersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchUsersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchUsersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchUsersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSendAnnouncement = "SendAnnouncement"

// SendAnnouncementRequest generates a "aws/request.Request" representing the
// client's request for the SendAnnouncement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendAnnouncement for more information on using the SendAnnouncement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendAnnouncementRequest method.
//    req, resp := client.SendAnnouncementRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SendAnnouncement
func (c *AlexaForBusiness) SendAnnouncementRequest(input *SendAnnouncementInput) (req *request.Request, output *SendAnnouncementOutput) {
	op := &request.Operation{
		Name:       opSendAnnouncement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendAnnouncementInput{}
	}

	output = &SendAnnouncementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendAnnouncement API operation for Alexa For Business.
//
// Triggers an asynchronous flow to send text, SSML, or audio announcements
// to rooms that are identified by a search or filter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation SendAnnouncement for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   You are performing an action that would put you beyond your account's limits.
//
//   * AlreadyExistsException
//   The resource being created already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SendAnnouncement
func (c *AlexaForBusiness) SendAnnouncement(input *SendAnnouncementInput) (*SendAnnouncementOutput, error) {
	req, out := c.SendAnnouncementRequest(input)
	return out, req.Send()
}

// SendAnnouncementWithContext is the same as SendAnnouncement with the addition of
// the ability to pass a context and additional request options.
//
// See SendAnnouncement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SendAnnouncementWithContext(ctx aws.Context, input *SendAnnouncementInput, opts ...request.Option) (*SendAnnouncementOutput, error) {
	req, out := c.SendAnnouncementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendInvitation = "SendInvitation"

// SendInvitationRequest generates a "aws/request.Request" representing the
// client's request for the SendInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendInvitation for more information on using the SendInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendInvitationRequest method.
//    req, resp := client.SendInvitationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SendInvitation
func (c *AlexaForBusiness) SendInvitationRequest(input *SendInvitationInput) (req *request.Request, output *SendInvitationOutput) {
	op := &request.Operation{
		Name:       opSendInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendInvitationInput{}
	}

	output = &SendInvitationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SendInvitation API operation for Alexa For Business.
//
// Sends an enrollment invitation email with a URL to a user. The URL is valid
// for 30 days or until you call this operation again, whichever comes first.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation SendInvitation for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
//   * InvalidUserStatusException
//   The attempt to update a user is invalid due to the user's current status.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SendInvitation
func (c *AlexaForBusiness) SendInvitation(input *SendInvitationInput) (*SendInvitationOutput, error) {
	req, out := c.SendInvitationRequest(input)
	return out, req.Send()
}

// SendInvitationWithContext is the same as SendInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See SendInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) SendInvitationWithContext(ctx aws.Context, input *SendInvitationInput, opts ...request.Option) (*SendInvitationOutput, error) {
	req, out := c.SendInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDeviceSync = "StartDeviceSync"

// StartDeviceSyncRequest generates a "aws/request.Request" representing the
// client's request for the StartDeviceSync operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDeviceSync for more information on using the StartDeviceSync
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartDeviceSyncRequest method.
//    req, resp := client.StartDeviceSyncRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/StartDeviceSync
func (c *AlexaForBusiness) StartDeviceSyncRequest(input *StartDeviceSyncInput) (req *request.Request, output *StartDeviceSyncOutput) {
	op := &request.Operation{
		Name:       opStartDeviceSync,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDeviceSyncInput{}
	}

	output = &StartDeviceSyncOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartDeviceSync API operation for Alexa For Business.
//
// Resets a device and its account to the known default settings. This clears
// all information and settings set by previous users in the following ways:
//
//    * Bluetooth - This unpairs all bluetooth devices paired with your echo
//    device.
//
//    * Volume - This resets the echo device's volume to the default value.
//
//    * Notifications - This clears all notifications from your echo device.
//
//    * Lists - This clears all to-do items from your echo device.
//
//    * Settings - This internally syncs the room's profile (if the device is
//    assigned to a room), contacts, address books, delegation access for account
//    linking, and communications (if enabled on the room profile).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation StartDeviceSync for usage and error information.
//
// Returned Error Types:
//   * DeviceNotRegisteredException
//   The request failed because this device is no longer registered and therefore
//   no longer managed by this account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/StartDeviceSync
func (c *AlexaForBusiness) StartDeviceSync(input *StartDeviceSyncInput) (*StartDeviceSyncOutput, error) {
	req, out := c.StartDeviceSyncRequest(input)
	return out, req.Send()
}

// StartDeviceSyncWithContext is the same as StartDeviceSync with the addition of
// the ability to pass a context and additional request options.
//
// See StartDeviceSync for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) StartDeviceSyncWithContext(ctx aws.Context, input *StartDeviceSyncInput, opts ...request.Option) (*StartDeviceSyncOutput, error) {
	req, out := c.StartDeviceSyncRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartSmartHomeApplianceDiscovery = "StartSmartHomeApplianceDiscovery"

// StartSmartHomeApplianceDiscoveryRequest generates a "aws/request.Request" representing the
// client's request for the StartSmartHomeApplianceDiscovery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartSmartHomeApplianceDiscovery for more information on using the StartSmartHomeApplianceDiscovery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartSmartHomeApplianceDiscoveryRequest method.
//    req, resp := client.StartSmartHomeApplianceDiscoveryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/StartSmartHomeApplianceDiscovery
func (c *AlexaForBusiness) StartSmartHomeApplianceDiscoveryRequest(input *StartSmartHomeApplianceDiscoveryInput) (req *request.Request, output *StartSmartHomeApplianceDiscoveryOutput) {
	op := &request.Operation{
		Name:       opStartSmartHomeApplianceDiscovery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartSmartHomeApplianceDiscoveryInput{}
	}

	output = &StartSmartHomeApplianceDiscoveryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartSmartHomeApplianceDiscovery API operation for Alexa For Business.
//
// Initiates the discovery of any smart home appliances associated with the
// room.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation StartSmartHomeApplianceDiscovery for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/StartSmartHomeApplianceDiscovery
func (c *AlexaForBusiness) StartSmartHomeApplianceDiscovery(input *StartSmartHomeApplianceDiscoveryInput) (*StartSmartHomeApplianceDiscoveryOutput, error) {
	req, out := c.StartSmartHomeApplianceDiscoveryRequest(input)
	return out, req.Send()
}

// StartSmartHomeApplianceDiscoveryWithContext is the same as StartSmartHomeApplianceDiscovery with the addition of
// the ability to pass a context and additional request options.
//
// See StartSmartHomeApplianceDiscovery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) StartSmartHomeApplianceDiscoveryWithContext(ctx aws.Context, input *StartSmartHomeApplianceDiscoveryInput, opts ...request.Option) (*StartSmartHomeApplianceDiscoveryOutput, error) {
	req, out := c.StartSmartHomeApplianceDiscoveryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/TagResource
func (c *AlexaForBusiness) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Alexa For Business.
//
// Adds metadata tags to a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/TagResource
func (c *AlexaForBusiness) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UntagResource
func (c *AlexaForBusiness) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Alexa For Business.
//
// Removes metadata tags from a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UntagResource
func (c *AlexaForBusiness) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAddressBook = "UpdateAddressBook"

// UpdateAddressBookRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAddressBook operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAddressBook for more information on using the UpdateAddressBook
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAddressBookRequest method.
//    req, resp := client.UpdateAddressBookRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateAddressBook
func (c *AlexaForBusiness) UpdateAddressBookRequest(input *UpdateAddressBookInput) (req *request.Request, output *UpdateAddressBookOutput) {
	op := &request.Operation{
		Name:       opUpdateAddressBook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAddressBookInput{}
	}

	output = &UpdateAddressBookOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateAddressBook API operation for Alexa For Business.
//
// Updates address book details by the address book ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation UpdateAddressBook for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
//   * NameInUseException
//   The name sent in the request is already in use.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateAddressBook
func (c *AlexaForBusiness) UpdateAddressBook(input *UpdateAddressBookInput) (*UpdateAddressBookOutput, error) {
	req, out := c.UpdateAddressBookRequest(input)
	return out, req.Send()
}

// UpdateAddressBookWithContext is the same as UpdateAddressBook with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAddressBook for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) UpdateAddressBookWithContext(ctx aws.Context, input *UpdateAddressBookInput, opts ...request.Option) (*UpdateAddressBookOutput, error) {
	req, out := c.UpdateAddressBookRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBusinessReportSchedule = "UpdateBusinessReportSchedule"

// UpdateBusinessReportScheduleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBusinessReportSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBusinessReportSchedule for more information on using the UpdateBusinessReportSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBusinessReportScheduleRequest method.
//    req, resp := client.UpdateBusinessReportScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateBusinessReportSchedule
func (c *AlexaForBusiness) UpdateBusinessReportScheduleRequest(input *UpdateBusinessReportScheduleInput) (req *request.Request, output *UpdateBusinessReportScheduleOutput) {
	op := &request.Operation{
		Name:       opUpdateBusinessReportSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateBusinessReportScheduleInput{}
	}

	output = &UpdateBusinessReportScheduleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateBusinessReportSchedule API operation for Alexa For Business.
//
// Updates the configuration of the report delivery schedule with the specified
// schedule ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation UpdateBusinessReportSchedule for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateBusinessReportSchedule
func (c *AlexaForBusiness) UpdateBusinessReportSchedule(input *UpdateBusinessReportScheduleInput) (*UpdateBusinessReportScheduleOutput, error) {
	req, out := c.UpdateBusinessReportScheduleRequest(input)
	return out, req.Send()
}

// UpdateBusinessReportScheduleWithContext is the same as UpdateBusinessReportSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBusinessReportSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) UpdateBusinessReportScheduleWithContext(ctx aws.Context, input *UpdateBusinessReportScheduleInput, opts ...request.Option) (*UpdateBusinessReportScheduleOutput, error) {
	req, out := c.UpdateBusinessReportScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConferenceProvider = "UpdateConferenceProvider"

// UpdateConferenceProviderRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConferenceProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConferenceProvider for more information on using the UpdateConferenceProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateConferenceProviderRequest method.
//    req, resp := client.UpdateConferenceProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateConferenceProvider
func (c *AlexaForBusiness) UpdateConferenceProviderRequest(input *UpdateConferenceProviderInput) (req *request.Request, output *UpdateConferenceProviderOutput) {
	op := &request.Operation{
		Name:       opUpdateConferenceProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateConferenceProviderInput{}
	}

	output = &UpdateConferenceProviderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateConferenceProvider API operation for Alexa For Business.
//
// Updates an existing conference provider's settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation UpdateConferenceProvider for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateConferenceProvider
func (c *AlexaForBusiness) UpdateConferenceProvider(input *UpdateConferenceProviderInput) (*UpdateConferenceProviderOutput, error) {
	req, out := c.UpdateConferenceProviderRequest(input)
	return out, req.Send()
}

// UpdateConferenceProviderWithContext is the same as UpdateConferenceProvider with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConferenceProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) UpdateConferenceProviderWithContext(ctx aws.Context, input *UpdateConferenceProviderInput, opts ...request.Option) (*UpdateConferenceProviderOutput, error) {
	req, out := c.UpdateConferenceProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateContact = "UpdateContact"

// UpdateContactRequest generates a "aws/request.Request" representing the
// client's request for the UpdateContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateContact for more information on using the UpdateContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateContactRequest method.
//    req, resp := client.UpdateContactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateContact
func (c *AlexaForBusiness) UpdateContactRequest(input *UpdateContactInput) (req *request.Request, output *UpdateContactOutput) {
	op := &request.Operation{
		Name:       opUpdateContact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateContactInput{}
	}

	output = &UpdateContactOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateContact API operation for Alexa For Business.
//
// Updates the contact details by the contact ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation UpdateContact for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateContact
func (c *AlexaForBusiness) UpdateContact(input *UpdateContactInput) (*UpdateContactOutput, error) {
	req, out := c.UpdateContactRequest(input)
	return out, req.Send()
}

// UpdateContactWithContext is the same as UpdateContact with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) UpdateContactWithContext(ctx aws.Context, input *UpdateContactInput, opts ...request.Option) (*UpdateContactOutput, error) {
	req, out := c.UpdateContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDevice = "UpdateDevice"

// UpdateDeviceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDevice for more information on using the UpdateDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDeviceRequest method.
//    req, resp := client.UpdateDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateDevice
func (c *AlexaForBusiness) UpdateDeviceRequest(input *UpdateDeviceInput) (req *request.Request, output *UpdateDeviceOutput) {
	op := &request.Operation{
		Name:       opUpdateDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDeviceInput{}
	}

	output = &UpdateDeviceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDevice API operation for Alexa For Business.
//
// Updates the device name by device ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation UpdateDevice for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
//   * DeviceNotRegisteredException
//   The request failed because this device is no longer registered and therefore
//   no longer managed by this account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateDevice
func (c *AlexaForBusiness) UpdateDevice(input *UpdateDeviceInput) (*UpdateDeviceOutput, error) {
	req, out := c.UpdateDeviceRequest(input)
	return out, req.Send()
}

// UpdateDeviceWithContext is the same as UpdateDevice with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) UpdateDeviceWithContext(ctx aws.Context, input *UpdateDeviceInput, opts ...request.Option) (*UpdateDeviceOutput, error) {
	req, out := c.UpdateDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGateway = "UpdateGateway"

// UpdateGatewayRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGateway for more information on using the UpdateGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGatewayRequest method.
//    req, resp := client.UpdateGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateGateway
func (c *AlexaForBusiness) UpdateGatewayRequest(input *UpdateGatewayInput) (req *request.Request, output *UpdateGatewayOutput) {
	op := &request.Operation{
		Name:       opUpdateGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGatewayInput{}
	}

	output = &UpdateGatewayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateGateway API operation for Alexa For Business.
//
// Updates the details of a gateway. If any optional field is not provided,
// the existing corresponding value is left unmodified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation UpdateGateway for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
//   * NameInUseException
//   The name sent in the request is already in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateGateway
func (c *AlexaForBusiness) UpdateGateway(input *UpdateGatewayInput) (*UpdateGatewayOutput, error) {
	req, out := c.UpdateGatewayRequest(input)
	return out, req.Send()
}

// UpdateGatewayWithContext is the same as UpdateGateway with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) UpdateGatewayWithContext(ctx aws.Context, input *UpdateGatewayInput, opts ...request.Option) (*UpdateGatewayOutput, error) {
	req, out := c.UpdateGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGatewayGroup = "UpdateGatewayGroup"

// UpdateGatewayGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGatewayGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGatewayGroup for more information on using the UpdateGatewayGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGatewayGroupRequest method.
//    req, resp := client.UpdateGatewayGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateGatewayGroup
func (c *AlexaForBusiness) UpdateGatewayGroupRequest(input *UpdateGatewayGroupInput) (req *request.Request, output *UpdateGatewayGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateGatewayGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGatewayGroupInput{}
	}

	output = &UpdateGatewayGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateGatewayGroup API operation for Alexa For Business.
//
// Updates the details of a gateway group. If any optional field is not provided,
// the existing corresponding value is left unmodified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation UpdateGatewayGroup for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
//   * NameInUseException
//   The name sent in the request is already in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateGatewayGroup
func (c *AlexaForBusiness) UpdateGatewayGroup(input *UpdateGatewayGroupInput) (*UpdateGatewayGroupOutput, error) {
	req, out := c.UpdateGatewayGroupRequest(input)
	return out, req.Send()
}

// UpdateGatewayGroupWithContext is the same as UpdateGatewayGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGatewayGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) UpdateGatewayGroupWithContext(ctx aws.Context, input *UpdateGatewayGroupInput, opts ...request.Option) (*UpdateGatewayGroupOutput, error) {
	req, out := c.UpdateGatewayGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNetworkProfile = "UpdateNetworkProfile"

// UpdateNetworkProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateNetworkProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateNetworkProfile for more information on using the UpdateNetworkProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateNetworkProfileRequest method.
//    req, resp := client.UpdateNetworkProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateNetworkProfile
func (c *AlexaForBusiness) UpdateNetworkProfileRequest(input *UpdateNetworkProfileInput) (req *request.Request, output *UpdateNetworkProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateNetworkProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateNetworkProfileInput{}
	}

	output = &UpdateNetworkProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateNetworkProfile API operation for Alexa For Business.
//
// Updates a network profile by the network profile ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation UpdateNetworkProfile for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
//   * NameInUseException
//   The name sent in the request is already in use.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
//   * InvalidCertificateAuthorityException
//   The Certificate Authority can't issue or revoke a certificate.
//
//   * InvalidSecretsManagerResourceException
//   A password in SecretsManager is in an invalid state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateNetworkProfile
func (c *AlexaForBusiness) UpdateNetworkProfile(input *UpdateNetworkProfileInput) (*UpdateNetworkProfileOutput, error) {
	req, out := c.UpdateNetworkProfileRequest(input)
	return out, req.Send()
}

// UpdateNetworkProfileWithContext is the same as UpdateNetworkProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNetworkProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) UpdateNetworkProfileWithContext(ctx aws.Context, input *UpdateNetworkProfileInput, opts ...request.Option) (*UpdateNetworkProfileOutput, error) {
	req, out := c.UpdateNetworkProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProfile = "UpdateProfile"

// UpdateProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProfile for more information on using the UpdateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateProfileRequest method.
//    req, resp := client.UpdateProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateProfile
func (c *AlexaForBusiness) UpdateProfileRequest(input *UpdateProfileInput) (req *request.Request, output *UpdateProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateProfileInput{}
	}

	output = &UpdateProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateProfile API operation for Alexa For Business.
//
// Updates an existing room profile by room profile ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation UpdateProfile for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
//   * NameInUseException
//   The name sent in the request is already in use.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateProfile
func (c *AlexaForBusiness) UpdateProfile(input *UpdateProfileInput) (*UpdateProfileOutput, error) {
	req, out := c.UpdateProfileRequest(input)
	return out, req.Send()
}

// UpdateProfileWithContext is the same as UpdateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) UpdateProfileWithContext(ctx aws.Context, input *UpdateProfileInput, opts ...request.Option) (*UpdateProfileOutput, error) {
	req, out := c.UpdateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRoom = "UpdateRoom"

// UpdateRoomRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRoom for more information on using the UpdateRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRoomRequest method.
//    req, resp := client.UpdateRoomRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateRoom
func (c *AlexaForBusiness) UpdateRoomRequest(input *UpdateRoomInput) (req *request.Request, output *UpdateRoomOutput) {
	op := &request.Operation{
		Name:       opUpdateRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRoomInput{}
	}

	output = &UpdateRoomOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRoom API operation for Alexa For Business.
//
// Updates room details by room ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation UpdateRoom for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
//   * NameInUseException
//   The name sent in the request is already in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateRoom
func (c *AlexaForBusiness) UpdateRoom(input *UpdateRoomInput) (*UpdateRoomOutput, error) {
	req, out := c.UpdateRoomRequest(input)
	return out, req.Send()
}

// UpdateRoomWithContext is the same as UpdateRoom with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) UpdateRoomWithContext(ctx aws.Context, input *UpdateRoomInput, opts ...request.Option) (*UpdateRoomOutput, error) {
	req, out := c.UpdateRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSkillGroup = "UpdateSkillGroup"

// UpdateSkillGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSkillGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSkillGroup for more information on using the UpdateSkillGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSkillGroupRequest method.
//    req, resp := client.UpdateSkillGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateSkillGroup
func (c *AlexaForBusiness) UpdateSkillGroupRequest(input *UpdateSkillGroupInput) (req *request.Request, output *UpdateSkillGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateSkillGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSkillGroupInput{}
	}

	output = &UpdateSkillGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateSkillGroup API operation for Alexa For Business.
//
// Updates skill group details by skill group ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Alexa For Business's
// API operation UpdateSkillGroup for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource is not found.
//
//   * NameInUseException
//   The name sent in the request is already in use.
//
//   * ConcurrentModificationException
//   There is a concurrent modification of resources.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateSkillGroup
func (c *AlexaForBusiness) UpdateSkillGroup(input *UpdateSkillGroupInput) (*UpdateSkillGroupOutput, error) {
	req, out := c.UpdateSkillGroupRequest(input)
	return out, req.Send()
}

// UpdateSkillGroupWithContext is the same as UpdateSkillGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSkillGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AlexaForBusiness) UpdateSkillGroupWithContext(ctx aws.Context, input *UpdateSkillGroupInput, opts ...request.Option) (*UpdateSkillGroupOutput, error) {
	req, out := c.UpdateSkillGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An address book with attributes.
type AddressBook struct {
	_ struct{} `type:"structure"`

	// The ARN of the address book.
	AddressBookArn *string `type:"string"`

	// The description of the address book.
	Description *string `min:"1" type:"string"`

	// The name of the address book.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddressBook) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddressBook) GoString() string {
	return s.String()
}

// SetAddressBookArn sets the AddressBookArn field's value.
func (s *AddressBook) SetAddressBookArn(v string) *AddressBook {
	s.AddressBookArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AddressBook) SetDescription(v string) *AddressBook {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *AddressBook) SetName(v string) *AddressBook {
	s.Name = &v
	return s
}

// Information related to an address book.
type AddressBookData struct {
	_ struct{} `type:"structure"`

	// The ARN of the address book.
	AddressBookArn *string `type:"string"`

	// The description of the address book.
	Description *string `min:"1" type:"string"`

	// The name of the address book.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddressBookData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddressBookData) GoString() string {
	return s.String()
}

// SetAddressBookArn sets the AddressBookArn field's value.
func (s *AddressBookData) SetAddressBookArn(v string) *AddressBookData {
	s.AddressBookArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AddressBookData) SetDescription(v string) *AddressBookData {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *AddressBookData) SetName(v string) *AddressBookData {
	s.Name = &v
	return s
}

// The resource being created already exists.
type AlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &AlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AlreadyExistsException) Code() string {
	return "AlreadyExistsException"
}

// Message returns the exception's message.
func (s *AlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AlreadyExistsException) OrigErr() error {
	return nil
}

func (s *AlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ApproveSkillInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the skill.
	//
	// SkillId is a required field
	SkillId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApproveSkillInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApproveSkillInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApproveSkillInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApproveSkillInput"}
	if s.SkillId == nil {
		invalidParams.Add(request.NewErrParamRequired("SkillId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSkillId sets the SkillId field's value.
func (s *ApproveSkillInput) SetSkillId(v string) *ApproveSkillInput {
	s.SkillId = &v
	return s
}

type ApproveSkillOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApproveSkillOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApproveSkillOutput) GoString() string {
	return s.String()
}

type AssociateContactWithAddressBookInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the address book with which to associate the contact.
	//
	// AddressBookArn is a required field
	AddressBookArn *string `type:"string" required:"true"`

	// The ARN of the contact to associate with an address book.
	//
	// ContactArn is a required field
	ContactArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateContactWithAddressBookInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateContactWithAddressBookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateContactWithAddressBookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateContactWithAddressBookInput"}
	if s.AddressBookArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AddressBookArn"))
	}
	if s.ContactArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressBookArn sets the AddressBookArn field's value.
func (s *AssociateContactWithAddressBookInput) SetAddressBookArn(v string) *AssociateContactWithAddressBookInput {
	s.AddressBookArn = &v
	return s
}

// SetContactArn sets the ContactArn field's value.
func (s *AssociateContactWithAddressBookInput) SetContactArn(v string) *AssociateContactWithAddressBookInput {
	s.ContactArn = &v
	return s
}

type AssociateContactWithAddressBookOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateContactWithAddressBookOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateContactWithAddressBookOutput) GoString() string {
	return s.String()
}

type AssociateDeviceWithNetworkProfileInput struct {
	_ struct{} `type:"structure"`

	// The device ARN.
	//
	// DeviceArn is a required field
	DeviceArn *string `type:"string" required:"true"`

	// The ARN of the network profile to associate with a device.
	//
	// NetworkProfileArn is a required field
	NetworkProfileArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateDeviceWithNetworkProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateDeviceWithNetworkProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateDeviceWithNetworkProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateDeviceWithNetworkProfileInput"}
	if s.DeviceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceArn"))
	}
	if s.NetworkProfileArn == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkProfileArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *AssociateDeviceWithNetworkProfileInput) SetDeviceArn(v string) *AssociateDeviceWithNetworkProfileInput {
	s.DeviceArn = &v
	return s
}

// SetNetworkProfileArn sets the NetworkProfileArn field's value.
func (s *AssociateDeviceWithNetworkProfileInput) SetNetworkProfileArn(v string) *AssociateDeviceWithNetworkProfileInput {
	s.NetworkProfileArn = &v
	return s
}

type AssociateDeviceWithNetworkProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateDeviceWithNetworkProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateDeviceWithNetworkProfileOutput) GoString() string {
	return s.String()
}

type AssociateDeviceWithRoomInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the device to associate to a room. Required.
	DeviceArn *string `type:"string"`

	// The ARN of the room with which to associate the device. Required.
	RoomArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateDeviceWithRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateDeviceWithRoomInput) GoString() string {
	return s.String()
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *AssociateDeviceWithRoomInput) SetDeviceArn(v string) *AssociateDeviceWithRoomInput {
	s.DeviceArn = &v
	return s
}

// SetRoomArn sets the RoomArn field's value.
func (s *AssociateDeviceWithRoomInput) SetRoomArn(v string) *AssociateDeviceWithRoomInput {
	s.RoomArn = &v
	return s
}

type AssociateDeviceWithRoomOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateDeviceWithRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateDeviceWithRoomOutput) GoString() string {
	return s.String()
}

type AssociateSkillGroupWithRoomInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the room with which to associate the skill group. Required.
	RoomArn *string `type:"string"`

	// The ARN of the skill group to associate with a room. Required.
	SkillGroupArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSkillGroupWithRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSkillGroupWithRoomInput) GoString() string {
	return s.String()
}

// SetRoomArn sets the RoomArn field's value.
func (s *AssociateSkillGroupWithRoomInput) SetRoomArn(v string) *AssociateSkillGroupWithRoomInput {
	s.RoomArn = &v
	return s
}

// SetSkillGroupArn sets the SkillGroupArn field's value.
func (s *AssociateSkillGroupWithRoomInput) SetSkillGroupArn(v string) *AssociateSkillGroupWithRoomInput {
	s.SkillGroupArn = &v
	return s
}

type AssociateSkillGroupWithRoomOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSkillGroupWithRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSkillGroupWithRoomOutput) GoString() string {
	return s.String()
}

type AssociateSkillWithSkillGroupInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the skill group to associate the skill to. Required.
	SkillGroupArn *string `type:"string"`

	// The unique identifier of the skill.
	//
	// SkillId is a required field
	SkillId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSkillWithSkillGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSkillWithSkillGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateSkillWithSkillGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateSkillWithSkillGroupInput"}
	if s.SkillId == nil {
		invalidParams.Add(request.NewErrParamRequired("SkillId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSkillGroupArn sets the SkillGroupArn field's value.
func (s *AssociateSkillWithSkillGroupInput) SetSkillGroupArn(v string) *AssociateSkillWithSkillGroupInput {
	s.SkillGroupArn = &v
	return s
}

// SetSkillId sets the SkillId field's value.
func (s *AssociateSkillWithSkillGroupInput) SetSkillId(v string) *AssociateSkillWithSkillGroupInput {
	s.SkillId = &v
	return s
}

type AssociateSkillWithSkillGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSkillWithSkillGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSkillWithSkillGroupOutput) GoString() string {
	return s.String()
}

type AssociateSkillWithUsersInput struct {
	_ struct{} `type:"structure"`

	// The private skill ID you want to make available to enrolled users.
	//
	// SkillId is a required field
	SkillId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSkillWithUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSkillWithUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateSkillWithUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateSkillWithUsersInput"}
	if s.SkillId == nil {
		invalidParams.Add(request.NewErrParamRequired("SkillId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSkillId sets the SkillId field's value.
func (s *AssociateSkillWithUsersInput) SetSkillId(v string) *AssociateSkillWithUsersInput {
	s.SkillId = &v
	return s
}

type AssociateSkillWithUsersOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSkillWithUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSkillWithUsersOutput) GoString() string {
	return s.String()
}

// The audio message. There is a 1 MB limit on the audio file input and the
// only supported format is MP3. To convert your MP3 audio files to an Alexa-friendly,
//
// required codec version (MPEG version 2) and bit rate (48 kbps), you might
// use converter software. One option for this is a command-line tool, FFmpeg.
// For more information, see FFmpeg (https://www.ffmpeg.org/). The following
// command converts the provided <input-file> to an MP3 file that is played
// in the announcement:
//
// ffmpeg -i <input-file> -ac 2 -codec:a libmp3lame -b:a 48k -ar 16000 <output-file.mp3>
type Audio struct {
	_ struct{} `type:"structure"`

	// The locale of the audio message. Currently, en-US is supported.
	//
	// Locale is a required field
	Locale *string `type:"string" required:"true" enum:"Locale"`

	// The location of the audio file. Currently, S3 URLs are supported. Only S3
	// locations comprised of safe characters are valid. For more information, see
	// Safe Characters (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#Safe%20Characters).
	//
	// Location is a required field
	Location *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Audio) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Audio) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Audio) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Audio"}
	if s.Locale == nil {
		invalidParams.Add(request.NewErrParamRequired("Locale"))
	}
	if s.Location == nil {
		invalidParams.Add(request.NewErrParamRequired("Location"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocale sets the Locale field's value.
func (s *Audio) SetLocale(v string) *Audio {
	s.Locale = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *Audio) SetLocation(v string) *Audio {
	s.Location = &v
	return s
}

// Usage report with specified parameters.
type BusinessReport struct {
	_ struct{} `type:"structure"`

	// The time of report delivery.
	DeliveryTime *time.Time `type:"timestamp"`

	// The download link where a user can download the report.
	DownloadUrl *string `type:"string"`

	// The failure code.
	FailureCode *string `type:"string" enum:"BusinessReportFailureCode"`

	// The S3 location of the output reports.
	S3Location *BusinessReportS3Location `type:"structure"`

	// The status of the report generation execution (RUNNING, SUCCEEDED, or FAILED).
	Status *string `type:"string" enum:"BusinessReportStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BusinessReport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BusinessReport) GoString() string {
	return s.String()
}

// SetDeliveryTime sets the DeliveryTime field's value.
func (s *BusinessReport) SetDeliveryTime(v time.Time) *BusinessReport {
	s.DeliveryTime = &v
	return s
}

// SetDownloadUrl sets the DownloadUrl field's value.
func (s *BusinessReport) SetDownloadUrl(v string) *BusinessReport {
	s.DownloadUrl = &v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *BusinessReport) SetFailureCode(v string) *BusinessReport {
	s.FailureCode = &v
	return s
}

// SetS3Location sets the S3Location field's value.
func (s *BusinessReport) SetS3Location(v *BusinessReportS3Location) *BusinessReport {
	s.S3Location = v
	return s
}

// SetStatus sets the Status field's value.
func (s *BusinessReport) SetStatus(v string) *BusinessReport {
	s.Status = &v
	return s
}

// The content range of the report.
type BusinessReportContentRange struct {
	_ struct{} `type:"structure"`

	// The interval of the content range.
	//
	// Interval is a required field
	Interval *string `type:"string" required:"true" enum:"BusinessReportInterval"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BusinessReportContentRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BusinessReportContentRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BusinessReportContentRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BusinessReportContentRange"}
	if s.Interval == nil {
		invalidParams.Add(request.NewErrParamRequired("Interval"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInterval sets the Interval field's value.
func (s *BusinessReportContentRange) SetInterval(v string) *BusinessReportContentRange {
	s.Interval = &v
	return s
}

// The recurrence of the reports.
type BusinessReportRecurrence struct {
	_ struct{} `type:"structure"`

	// The start date.
	StartDate *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BusinessReportRecurrence) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BusinessReportRecurrence) GoString() string {
	return s.String()
}

// SetStartDate sets the StartDate field's value.
func (s *BusinessReportRecurrence) SetStartDate(v string) *BusinessReportRecurrence {
	s.StartDate = &v
	return s
}

// The S3 location of the output reports.
type BusinessReportS3Location struct {
	_ struct{} `type:"structure"`

	// The S3 bucket name of the output reports.
	BucketName *string `type:"string"`

	// The path of the business report.
	Path *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BusinessReportS3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BusinessReportS3Location) GoString() string {
	return s.String()
}

// SetBucketName sets the BucketName field's value.
func (s *BusinessReportS3Location) SetBucketName(v string) *BusinessReportS3Location {
	s.BucketName = &v
	return s
}

// SetPath sets the Path field's value.
func (s *BusinessReportS3Location) SetPath(v string) *BusinessReportS3Location {
	s.Path = &v
	return s
}

// The schedule of the usage report.
type BusinessReportSchedule struct {
	_ struct{} `type:"structure"`

	// The content range of the reports.
	ContentRange *BusinessReportContentRange `type:"structure"`

	// The format of the generated report (individual CSV files or zipped files
	// of individual files).
	Format *string `type:"string" enum:"BusinessReportFormat"`

	// The details of the last business report delivery for a specified time interval.
	LastBusinessReport *BusinessReport `type:"structure"`

	// The recurrence of the reports.
	Recurrence *BusinessReportRecurrence `type:"structure"`

	// The S3 bucket name of the output reports.
	S3BucketName *string `type:"string"`

	// The S3 key where the report is delivered.
	S3KeyPrefix *string `type:"string"`

	// The ARN of the business report schedule.
	ScheduleArn *string `type:"string"`

	// The name identifier of the schedule.
	ScheduleName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BusinessReportSchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BusinessReportSchedule) GoString() string {
	return s.String()
}

// SetContentRange sets the ContentRange field's value.
func (s *BusinessReportSchedule) SetContentRange(v *BusinessReportContentRange) *BusinessReportSchedule {
	s.ContentRange = v
	return s
}

// SetFormat sets the Format field's value.
func (s *BusinessReportSchedule) SetFormat(v string) *BusinessReportSchedule {
	s.Format = &v
	return s
}

// SetLastBusinessReport sets the LastBusinessReport field's value.
func (s *BusinessReportSchedule) SetLastBusinessReport(v *BusinessReport) *BusinessReportSchedule {
	s.LastBusinessReport = v
	return s
}

// SetRecurrence sets the Recurrence field's value.
func (s *BusinessReportSchedule) SetRecurrence(v *BusinessReportRecurrence) *BusinessReportSchedule {
	s.Recurrence = v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *BusinessReportSchedule) SetS3BucketName(v string) *BusinessReportSchedule {
	s.S3BucketName = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *BusinessReportSchedule) SetS3KeyPrefix(v string) *BusinessReportSchedule {
	s.S3KeyPrefix = &v
	return s
}

// SetScheduleArn sets the ScheduleArn field's value.
func (s *BusinessReportSchedule) SetScheduleArn(v string) *BusinessReportSchedule {
	s.ScheduleArn = &v
	return s
}

// SetScheduleName sets the ScheduleName field's value.
func (s *BusinessReportSchedule) SetScheduleName(v string) *BusinessReportSchedule {
	s.ScheduleName = &v
	return s
}

// The skill store category that is shown. Alexa skills are assigned a specific
// skill category during creation, such as News, Social, and Sports.
type Category struct {
	_ struct{} `type:"structure"`

	// The ID of the skill store category.
	CategoryId *int64 `min:"1" type:"long"`

	// The name of the skill store category.
	CategoryName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Category) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Category) GoString() string {
	return s.String()
}

// SetCategoryId sets the CategoryId field's value.
func (s *Category) SetCategoryId(v int64) *Category {
	s.CategoryId = &v
	return s
}

// SetCategoryName sets the CategoryName field's value.
func (s *Category) SetCategoryName(v string) *Category {
	s.CategoryName = &v
	return s
}

// There is a concurrent modification of resources.
type ConcurrentModificationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s *ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentModificationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentModificationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The default conference provider that is used if no other scheduled meetings
// are detected.
type ConferencePreference struct {
	_ struct{} `type:"structure"`

	// The ARN of the default conference provider.
	DefaultConferenceProviderArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConferencePreference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConferencePreference) GoString() string {
	return s.String()
}

// SetDefaultConferenceProviderArn sets the DefaultConferenceProviderArn field's value.
func (s *ConferencePreference) SetDefaultConferenceProviderArn(v string) *ConferencePreference {
	s.DefaultConferenceProviderArn = &v
	return s
}

// An entity that provides a conferencing solution. Alexa for Business acts
// as the voice interface and mediator that connects users to their preferred
// conference provider. Examples of conference providers include Amazon Chime,
// Zoom, Cisco, and Polycom.
type ConferenceProvider struct {
	_ struct{} `type:"structure"`

	// The ARN of the newly created conference provider.
	Arn *string `type:"string"`

	// The IP endpoint and protocol for calling.
	IPDialIn *IPDialIn `type:"structure"`

	// The meeting settings for the conference provider.
	MeetingSetting *MeetingSetting `type:"structure"`

	// The name of the conference provider.
	Name *string `min:"1" type:"string"`

	// The information for PSTN conferencing.
	PSTNDialIn *PSTNDialIn `type:"structure"`

	// The type of conference providers.
	Type *string `type:"string" enum:"ConferenceProviderType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConferenceProvider) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConferenceProvider) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ConferenceProvider) SetArn(v string) *ConferenceProvider {
	s.Arn = &v
	return s
}

// SetIPDialIn sets the IPDialIn field's value.
func (s *ConferenceProvider) SetIPDialIn(v *IPDialIn) *ConferenceProvider {
	s.IPDialIn = v
	return s
}

// SetMeetingSetting sets the MeetingSetting field's value.
func (s *ConferenceProvider) SetMeetingSetting(v *MeetingSetting) *ConferenceProvider {
	s.MeetingSetting = v
	return s
}

// SetName sets the Name field's value.
func (s *ConferenceProvider) SetName(v string) *ConferenceProvider {
	s.Name = &v
	return s
}

// SetPSTNDialIn sets the PSTNDialIn field's value.
func (s *ConferenceProvider) SetPSTNDialIn(v *PSTNDialIn) *ConferenceProvider {
	s.PSTNDialIn = v
	return s
}

// SetType sets the Type field's value.
func (s *ConferenceProvider) SetType(v string) *ConferenceProvider {
	s.Type = &v
	return s
}

// A contact with attributes.
type Contact struct {
	_ struct{} `type:"structure"`

	// The ARN of the contact.
	ContactArn *string `type:"string"`

	// The name of the contact to display on the console.
	DisplayName *string `min:"1" type:"string"`

	// The first name of the contact, used to call the contact on the device.
	FirstName *string `min:"1" type:"string"`

	// The last name of the contact, used to call the contact on the device.
	LastName *string `min:"1" type:"string"`

	// The phone number of the contact. The phone number type defaults to WORK.
	// You can either specify PhoneNumber or PhoneNumbers. We recommend that you
	// use PhoneNumbers, which lets you specify the phone number type and multiple
	// numbers.
	//
	// PhoneNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Contact's
	// String and GoString methods.
	PhoneNumber *string `type:"string" sensitive:"true"`

	// The list of phone numbers for the contact.
	PhoneNumbers []*PhoneNumber `type:"list"`

	// The list of SIP addresses for the contact.
	SipAddresses []*SipAddress `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Contact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Contact) GoString() string {
	return s.String()
}

// SetContactArn sets the ContactArn field's value.
func (s *Contact) SetContactArn(v string) *Contact {
	s.ContactArn = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Contact) SetDisplayName(v string) *Contact {
	s.DisplayName = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *Contact) SetFirstName(v string) *Contact {
	s.FirstName = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *Contact) SetLastName(v string) *Contact {
	s.LastName = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *Contact) SetPhoneNumber(v string) *Contact {
	s.PhoneNumber = &v
	return s
}

// SetPhoneNumbers sets the PhoneNumbers field's value.
func (s *Contact) SetPhoneNumbers(v []*PhoneNumber) *Contact {
	s.PhoneNumbers = v
	return s
}

// SetSipAddresses sets the SipAddresses field's value.
func (s *Contact) SetSipAddresses(v []*SipAddress) *Contact {
	s.SipAddresses = v
	return s
}

// Information related to a contact.
type ContactData struct {
	_ struct{} `type:"structure"`

	// The ARN of the contact.
	ContactArn *string `type:"string"`

	// The name of the contact to display on the console.
	DisplayName *string `min:"1" type:"string"`

	// The first name of the contact, used to call the contact on the device.
	FirstName *string `min:"1" type:"string"`

	// The last name of the contact, used to call the contact on the device.
	LastName *string `min:"1" type:"string"`

	// The phone number of the contact. The phone number type defaults to WORK.
	// You can specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers,
	// which lets you specify the phone number type and multiple numbers.
	//
	// PhoneNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ContactData's
	// String and GoString methods.
	PhoneNumber *string `type:"string" sensitive:"true"`

	// The list of phone numbers for the contact.
	PhoneNumbers []*PhoneNumber `type:"list"`

	// The list of SIP addresses for the contact.
	SipAddresses []*SipAddress `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactData) GoString() string {
	return s.String()
}

// SetContactArn sets the ContactArn field's value.
func (s *ContactData) SetContactArn(v string) *ContactData {
	s.ContactArn = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *ContactData) SetDisplayName(v string) *ContactData {
	s.DisplayName = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *ContactData) SetFirstName(v string) *ContactData {
	s.FirstName = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *ContactData) SetLastName(v string) *ContactData {
	s.LastName = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *ContactData) SetPhoneNumber(v string) *ContactData {
	s.PhoneNumber = &v
	return s
}

// SetPhoneNumbers sets the PhoneNumbers field's value.
func (s *ContactData) SetPhoneNumbers(v []*PhoneNumber) *ContactData {
	s.PhoneNumbers = v
	return s
}

// SetSipAddresses sets the SipAddresses field's value.
func (s *ContactData) SetSipAddresses(v []*SipAddress) *ContactData {
	s.SipAddresses = v
	return s
}

// The content definition. This can contain only one text, SSML, or audio list
// object.
type Content struct {
	_ struct{} `type:"structure"`

	// The list of audio messages.
	AudioList []*Audio `type:"list"`

	// The list of SSML messages.
	SsmlList []*Ssml `type:"list"`

	// The list of text messages.
	TextList []*Text `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Content) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Content) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Content) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Content"}
	if s.AudioList != nil {
		for i, v := range s.AudioList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AudioList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SsmlList != nil {
		for i, v := range s.SsmlList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SsmlList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TextList != nil {
		for i, v := range s.TextList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TextList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioList sets the AudioList field's value.
func (s *Content) SetAudioList(v []*Audio) *Content {
	s.AudioList = v
	return s
}

// SetSsmlList sets the SsmlList field's value.
func (s *Content) SetSsmlList(v []*Ssml) *Content {
	s.SsmlList = v
	return s
}

// SetTextList sets the TextList field's value.
func (s *Content) SetTextList(v []*Text) *Content {
	s.TextList = v
	return s
}

type CreateAddressBookInput struct {
	_ struct{} `type:"structure"`

	// A unique, user-specified identifier for the request that ensures idempotency.
	ClientRequestToken *string `min:"10" type:"string" idempotencyToken:"true"`

	// The description of the address book.
	Description *string `min:"1" type:"string"`

	// The name of the address book.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The tags to be added to the specified resource. Do not provide system tags.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAddressBookInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAddressBookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAddressBookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAddressBookInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 10))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateAddressBookInput) SetClientRequestToken(v string) *CreateAddressBookInput {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAddressBookInput) SetDescription(v string) *CreateAddressBookInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAddressBookInput) SetName(v string) *CreateAddressBookInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAddressBookInput) SetTags(v []*Tag) *CreateAddressBookInput {
	s.Tags = v
	return s
}

type CreateAddressBookOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the newly created address book.
	AddressBookArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAddressBookOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAddressBookOutput) GoString() string {
	return s.String()
}

// SetAddressBookArn sets the AddressBookArn field's value.
func (s *CreateAddressBookOutput) SetAddressBookArn(v string) *CreateAddressBookOutput {
	s.AddressBookArn = &v
	return s
}

type CreateBusinessReportScheduleInput struct {
	_ struct{} `type:"structure"`

	// The client request token.
	ClientRequestToken *string `min:"10" type:"string" idempotencyToken:"true"`

	// The content range of the reports.
	//
	// ContentRange is a required field
	ContentRange *BusinessReportContentRange `type:"structure" required:"true"`

	// The format of the generated report (individual CSV files or zipped files
	// of individual files).
	//
	// Format is a required field
	Format *string `type:"string" required:"true" enum:"BusinessReportFormat"`

	// The recurrence of the reports. If this isn't specified, the report will only
	// be delivered one time when the API is called.
	Recurrence *BusinessReportRecurrence `type:"structure"`

	// The S3 bucket name of the output reports. If this isn't specified, the report
	// can be retrieved from a download link by calling ListBusinessReportSchedule.
	S3BucketName *string `type:"string"`

	// The S3 key where the report is delivered.
	S3KeyPrefix *string `type:"string"`

	// The name identifier of the schedule.
	ScheduleName *string `type:"string"`

	// The tags for the business report schedule.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBusinessReportScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBusinessReportScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBusinessReportScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBusinessReportScheduleInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 10))
	}
	if s.ContentRange == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentRange"))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.ContentRange != nil {
		if err := s.ContentRange.Validate(); err != nil {
			invalidParams.AddNested("ContentRange", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateBusinessReportScheduleInput) SetClientRequestToken(v string) *CreateBusinessReportScheduleInput {
	s.ClientRequestToken = &v
	return s
}

// SetContentRange sets the ContentRange field's value.
func (s *CreateBusinessReportScheduleInput) SetContentRange(v *BusinessReportContentRange) *CreateBusinessReportScheduleInput {
	s.ContentRange = v
	return s
}

// SetFormat sets the Format field's value.
func (s *CreateBusinessReportScheduleInput) SetFormat(v string) *CreateBusinessReportScheduleInput {
	s.Format = &v
	return s
}

// SetRecurrence sets the Recurrence field's value.
func (s *CreateBusinessReportScheduleInput) SetRecurrence(v *BusinessReportRecurrence) *CreateBusinessReportScheduleInput {
	s.Recurrence = v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *CreateBusinessReportScheduleInput) SetS3BucketName(v string) *CreateBusinessReportScheduleInput {
	s.S3BucketName = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *CreateBusinessReportScheduleInput) SetS3KeyPrefix(v string) *CreateBusinessReportScheduleInput {
	s.S3KeyPrefix = &v
	return s
}

// SetScheduleName sets the ScheduleName field's value.
func (s *CreateBusinessReportScheduleInput) SetScheduleName(v string) *CreateBusinessReportScheduleInput {
	s.ScheduleName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateBusinessReportScheduleInput) SetTags(v []*Tag) *CreateBusinessReportScheduleInput {
	s.Tags = v
	return s
}

type CreateBusinessReportScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the business report schedule.
	ScheduleArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBusinessReportScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBusinessReportScheduleOutput) GoString() string {
	return s.String()
}

// SetScheduleArn sets the ScheduleArn field's value.
func (s *CreateBusinessReportScheduleOutput) SetScheduleArn(v string) *CreateBusinessReportScheduleOutput {
	s.ScheduleArn = &v
	return s
}

type CreateConferenceProviderInput struct {
	_ struct{} `type:"structure"`

	// The request token of the client.
	ClientRequestToken *string `min:"10" type:"string" idempotencyToken:"true"`

	// The name of the conference provider.
	//
	// ConferenceProviderName is a required field
	ConferenceProviderName *string `min:"1" type:"string" required:"true"`

	// Represents a type within a list of predefined types.
	//
	// ConferenceProviderType is a required field
	ConferenceProviderType *string `type:"string" required:"true" enum:"ConferenceProviderType"`

	// The IP endpoint and protocol for calling.
	IPDialIn *IPDialIn `type:"structure"`

	// The meeting settings for the conference provider.
	//
	// MeetingSetting is a required field
	MeetingSetting *MeetingSetting `type:"structure" required:"true"`

	// The information for PSTN conferencing.
	PSTNDialIn *PSTNDialIn `type:"structure"`

	// The tags to be added to the specified resource. Do not provide system tags.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConferenceProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConferenceProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConferenceProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConferenceProviderInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 10))
	}
	if s.ConferenceProviderName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConferenceProviderName"))
	}
	if s.ConferenceProviderName != nil && len(*s.ConferenceProviderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConferenceProviderName", 1))
	}
	if s.ConferenceProviderType == nil {
		invalidParams.Add(request.NewErrParamRequired("ConferenceProviderType"))
	}
	if s.MeetingSetting == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingSetting"))
	}
	if s.IPDialIn != nil {
		if err := s.IPDialIn.Validate(); err != nil {
			invalidParams.AddNested("IPDialIn", err.(request.ErrInvalidParams))
		}
	}
	if s.MeetingSetting != nil {
		if err := s.MeetingSetting.Validate(); err != nil {
			invalidParams.AddNested("MeetingSetting", err.(request.ErrInvalidParams))
		}
	}
	if s.PSTNDialIn != nil {
		if err := s.PSTNDialIn.Validate(); err != nil {
			invalidParams.AddNested("PSTNDialIn", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateConferenceProviderInput) SetClientRequestToken(v string) *CreateConferenceProviderInput {
	s.ClientRequestToken = &v
	return s
}

// SetConferenceProviderName sets the ConferenceProviderName field's value.
func (s *CreateConferenceProviderInput) SetConferenceProviderName(v string) *CreateConferenceProviderInput {
	s.ConferenceProviderName = &v
	return s
}

// SetConferenceProviderType sets the ConferenceProviderType field's value.
func (s *CreateConferenceProviderInput) SetConferenceProviderType(v string) *CreateConferenceProviderInput {
	s.ConferenceProviderType = &v
	return s
}

// SetIPDialIn sets the IPDialIn field's value.
func (s *CreateConferenceProviderInput) SetIPDialIn(v *IPDialIn) *CreateConferenceProviderInput {
	s.IPDialIn = v
	return s
}

// SetMeetingSetting sets the MeetingSetting field's value.
func (s *CreateConferenceProviderInput) SetMeetingSetting(v *MeetingSetting) *CreateConferenceProviderInput {
	s.MeetingSetting = v
	return s
}

// SetPSTNDialIn sets the PSTNDialIn field's value.
func (s *CreateConferenceProviderInput) SetPSTNDialIn(v *PSTNDialIn) *CreateConferenceProviderInput {
	s.PSTNDialIn = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateConferenceProviderInput) SetTags(v []*Tag) *CreateConferenceProviderInput {
	s.Tags = v
	return s
}

type CreateConferenceProviderOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the newly-created conference provider.
	ConferenceProviderArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConferenceProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConferenceProviderOutput) GoString() string {
	return s.String()
}

// SetConferenceProviderArn sets the ConferenceProviderArn field's value.
func (s *CreateConferenceProviderOutput) SetConferenceProviderArn(v string) *CreateConferenceProviderOutput {
	s.ConferenceProviderArn = &v
	return s
}

type CreateContactInput struct {
	_ struct{} `type:"structure"`

	// A unique, user-specified identifier for this request that ensures idempotency.
	ClientRequestToken *string `min:"10" type:"string" idempotencyToken:"true"`

	// The name of the contact to display on the console.
	DisplayName *string `min:"1" type:"string"`

	// The first name of the contact that is used to call the contact on the device.
	//
	// FirstName is a required field
	FirstName *string `min:"1" type:"string" required:"true"`

	// The last name of the contact that is used to call the contact on the device.
	LastName *string `min:"1" type:"string"`

	// The phone number of the contact in E.164 format. The phone number type defaults
	// to WORK. You can specify PhoneNumber or PhoneNumbers. We recommend that you
	// use PhoneNumbers, which lets you specify the phone number type and multiple
	// numbers.
	//
	// PhoneNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateContactInput's
	// String and GoString methods.
	PhoneNumber *string `type:"string" sensitive:"true"`

	// The list of phone numbers for the contact.
	PhoneNumbers []*PhoneNumber `type:"list"`

	// The list of SIP addresses for the contact.
	SipAddresses []*SipAddress `type:"list"`

	// The tags to be added to the specified resource. Do not provide system tags.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateContactInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 10))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.FirstName == nil {
		invalidParams.Add(request.NewErrParamRequired("FirstName"))
	}
	if s.FirstName != nil && len(*s.FirstName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirstName", 1))
	}
	if s.LastName != nil && len(*s.LastName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LastName", 1))
	}
	if s.PhoneNumbers != nil {
		for i, v := range s.PhoneNumbers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PhoneNumbers", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SipAddresses != nil {
		for i, v := range s.SipAddresses {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SipAddresses", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateContactInput) SetClientRequestToken(v string) *CreateContactInput {
	s.ClientRequestToken = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateContactInput) SetDisplayName(v string) *CreateContactInput {
	s.DisplayName = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *CreateContactInput) SetFirstName(v string) *CreateContactInput {
	s.FirstName = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *CreateContactInput) SetLastName(v string) *CreateContactInput {
	s.LastName = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *CreateContactInput) SetPhoneNumber(v string) *CreateContactInput {
	s.PhoneNumber = &v
	return s
}

// SetPhoneNumbers sets the PhoneNumbers field's value.
func (s *CreateContactInput) SetPhoneNumbers(v []*PhoneNumber) *CreateContactInput {
	s.PhoneNumbers = v
	return s
}

// SetSipAddresses sets the SipAddresses field's value.
func (s *CreateContactInput) SetSipAddresses(v []*SipAddress) *CreateContactInput {
	s.SipAddresses = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateContactInput) SetTags(v []*Tag) *CreateContactInput {
	s.Tags = v
	return s
}

type CreateContactOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the newly created address book.
	ContactArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactOutput) GoString() string {
	return s.String()
}

// SetContactArn sets the ContactArn field's value.
func (s *CreateContactOutput) SetContactArn(v string) *CreateContactOutput {
	s.ContactArn = &v
	return s
}

// Creates settings for the end of meeting reminder feature that are applied
// to a room profile. The end of meeting reminder enables Alexa to remind users
// when a meeting is ending.
type CreateEndOfMeetingReminder struct {
	_ struct{} `type:"structure"`

	// Whether an end of meeting reminder is enabled or not.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// A range of 3 to 15 minutes that determines when the reminder begins.
	//
	// ReminderAtMinutes is a required field
	ReminderAtMinutes []*int64 `min:"1" type:"list" required:"true"`

	// The type of sound that users hear during the end of meeting reminder.
	//
	// ReminderType is a required field
	ReminderType *string `type:"string" required:"true" enum:"EndOfMeetingReminderType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndOfMeetingReminder) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndOfMeetingReminder) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEndOfMeetingReminder) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEndOfMeetingReminder"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.ReminderAtMinutes == nil {
		invalidParams.Add(request.NewErrParamRequired("ReminderAtMinutes"))
	}
	if s.ReminderAtMinutes != nil && len(s.ReminderAtMinutes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReminderAtMinutes", 1))
	}
	if s.ReminderType == nil {
		invalidParams.Add(request.NewErrParamRequired("ReminderType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *CreateEndOfMeetingReminder) SetEnabled(v bool) *CreateEndOfMeetingReminder {
	s.Enabled = &v
	return s
}

// SetReminderAtMinutes sets the ReminderAtMinutes field's value.
func (s *CreateEndOfMeetingReminder) SetReminderAtMinutes(v []*int64) *CreateEndOfMeetingReminder {
	s.ReminderAtMinutes = v
	return s
}

// SetReminderType sets the ReminderType field's value.
func (s *CreateEndOfMeetingReminder) SetReminderType(v string) *CreateEndOfMeetingReminder {
	s.ReminderType = &v
	return s
}

type CreateGatewayGroupInput struct {
	_ struct{} `type:"structure"`

	// A unique, user-specified identifier for the request that ensures idempotency.
	ClientRequestToken *string `min:"10" type:"string" idempotencyToken:"true"`

	// The description of the gateway group.
	Description *string `type:"string"`

	// The name of the gateway group.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The tags to be added to the specified resource. Do not provide system tags.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGatewayGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGatewayGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGatewayGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGatewayGroupInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 10))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateGatewayGroupInput) SetClientRequestToken(v string) *CreateGatewayGroupInput {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateGatewayGroupInput) SetDescription(v string) *CreateGatewayGroupInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateGatewayGroupInput) SetName(v string) *CreateGatewayGroupInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateGatewayGroupInput) SetTags(v []*Tag) *CreateGatewayGroupInput {
	s.Tags = v
	return s
}

type CreateGatewayGroupOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the created gateway group.
	GatewayGroupArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGatewayGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGatewayGroupOutput) GoString() string {
	return s.String()
}

// SetGatewayGroupArn sets the GatewayGroupArn field's value.
func (s *CreateGatewayGroupOutput) SetGatewayGroupArn(v string) *CreateGatewayGroupOutput {
	s.GatewayGroupArn = &v
	return s
}

// Creates settings for the instant booking feature that are applied to a room
// profile. When users start their meeting with Alexa, Alexa automatically books
// the room for the configured duration if the room is available.
type CreateInstantBooking struct {
	_ struct{} `type:"structure"`

	// Duration between 15 and 240 minutes at increments of 15 that determines how
	// long to book an available room when a meeting is started with Alexa.
	//
	// DurationInMinutes is a required field
	DurationInMinutes *int64 `type:"integer" required:"true"`

	// Whether instant booking is enabled or not.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInstantBooking) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInstantBooking) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstantBooking) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInstantBooking"}
	if s.DurationInMinutes == nil {
		invalidParams.Add(request.NewErrParamRequired("DurationInMinutes"))
	}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDurationInMinutes sets the DurationInMinutes field's value.
func (s *CreateInstantBooking) SetDurationInMinutes(v int64) *CreateInstantBooking {
	s.DurationInMinutes = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *CreateInstantBooking) SetEnabled(v bool) *CreateInstantBooking {
	s.Enabled = &v
	return s
}

// Creates meeting room settings of a room profile.
type CreateMeetingRoomConfiguration struct {
	_ struct{} `type:"structure"`

	// Creates settings for the end of meeting reminder feature that are applied
	// to a room profile. The end of meeting reminder enables Alexa to remind users
	// when a meeting is ending.
	EndOfMeetingReminder *CreateEndOfMeetingReminder `type:"structure"`

	// Settings to automatically book a room for a configured duration if it's free
	// when joining a meeting with Alexa.
	InstantBooking *CreateInstantBooking `type:"structure"`

	// Settings for requiring a check in when a room is reserved. Alexa can cancel
	// a room reservation if it's not checked into to make the room available for
	// others. Users can check in by joining the meeting with Alexa or an AVS device,
	// or by saying “Alexa, check in.”
	RequireCheckIn *CreateRequireCheckIn `type:"structure"`

	// Whether room utilization metrics are enabled or not.
	RoomUtilizationMetricsEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMeetingRoomConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMeetingRoomConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMeetingRoomConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMeetingRoomConfiguration"}
	if s.EndOfMeetingReminder != nil {
		if err := s.EndOfMeetingReminder.Validate(); err != nil {
			invalidParams.AddNested("EndOfMeetingReminder", err.(request.ErrInvalidParams))
		}
	}
	if s.InstantBooking != nil {
		if err := s.InstantBooking.Validate(); err != nil {
			invalidParams.AddNested("InstantBooking", err.(request.ErrInvalidParams))
		}
	}
	if s.RequireCheckIn != nil {
		if err := s.RequireCheckIn.Validate(); err != nil {
			invalidParams.AddNested("RequireCheckIn", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndOfMeetingReminder sets the EndOfMeetingReminder field's value.
func (s *CreateMeetingRoomConfiguration) SetEndOfMeetingReminder(v *CreateEndOfMeetingReminder) *CreateMeetingRoomConfiguration {
	s.EndOfMeetingReminder = v
	return s
}

// SetInstantBooking sets the InstantBooking field's value.
func (s *CreateMeetingRoomConfiguration) SetInstantBooking(v *CreateInstantBooking) *CreateMeetingRoomConfiguration {
	s.InstantBooking = v
	return s
}

// SetRequireCheckIn sets the RequireCheckIn field's value.
func (s *CreateMeetingRoomConfiguration) SetRequireCheckIn(v *CreateRequireCheckIn) *CreateMeetingRoomConfiguration {
	s.RequireCheckIn = v
	return s
}

// SetRoomUtilizationMetricsEnabled sets the RoomUtilizationMetricsEnabled field's value.
func (s *CreateMeetingRoomConfiguration) SetRoomUtilizationMetricsEnabled(v bool) *CreateMeetingRoomConfiguration {
	s.RoomUtilizationMetricsEnabled = &v
	return s
}

type CreateNetworkProfileInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the Private Certificate Authority (PCA) created in AWS Certificate
	// Manager (ACM). This is used to issue certificates to the devices.
	CertificateAuthorityArn *string `type:"string"`

	// A unique, user-specified identifier for the request that ensures idempotency.
	ClientRequestToken *string `min:"10" type:"string" idempotencyToken:"true"`

	// The current password of the Wi-Fi network.
	//
	// CurrentPassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateNetworkProfileInput's
	// String and GoString methods.
	CurrentPassword *string `min:"5" type:"string" sensitive:"true"`

	// Detailed information about a device's network profile.
	Description *string `type:"string"`

	// The authentication standard that is used in the EAP framework. Currently,
	// EAP_TLS is supported.
	EapMethod *string `type:"string" enum:"NetworkEapMethod"`

	// The name of the network profile associated with a device.
	//
	// NetworkProfileName is a required field
	NetworkProfileName *string `min:"1" type:"string" required:"true"`

	// The next, or subsequent, password of the Wi-Fi network. This password is
	// asynchronously transmitted to the device and is used when the password of
	// the network changes to NextPassword.
	//
	// NextPassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateNetworkProfileInput's
	// String and GoString methods.
	NextPassword *string `type:"string" sensitive:"true"`

	// The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK,
	// WPA_PSK, WEP, or OPEN.
	//
	// SecurityType is a required field
	SecurityType *string `type:"string" required:"true" enum:"NetworkSecurityType"`

	// The SSID of the Wi-Fi network.
	//
	// Ssid is a required field
	Ssid *string `min:"1" type:"string" required:"true"`

	// The tags to be added to the specified resource. Do not provide system tags.
	Tags []*Tag `type:"list"`

	// The root certificates of your authentication server that is installed on
	// your devices and used to trust your authentication server during EAP negotiation.
	TrustAnchors []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNetworkProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNetworkProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNetworkProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNetworkProfileInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 10))
	}
	if s.CurrentPassword != nil && len(*s.CurrentPassword) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CurrentPassword", 5))
	}
	if s.NetworkProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkProfileName"))
	}
	if s.NetworkProfileName != nil && len(*s.NetworkProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkProfileName", 1))
	}
	if s.SecurityType == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityType"))
	}
	if s.Ssid == nil {
		invalidParams.Add(request.NewErrParamRequired("Ssid"))
	}
	if s.Ssid != nil && len(*s.Ssid) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ssid", 1))
	}
	if s.TrustAnchors != nil && len(s.TrustAnchors) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrustAnchors", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *CreateNetworkProfileInput) SetCertificateAuthorityArn(v string) *CreateNetworkProfileInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateNetworkProfileInput) SetClientRequestToken(v string) *CreateNetworkProfileInput {
	s.ClientRequestToken = &v
	return s
}

// SetCurrentPassword sets the CurrentPassword field's value.
func (s *CreateNetworkProfileInput) SetCurrentPassword(v string) *CreateNetworkProfileInput {
	s.CurrentPassword = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateNetworkProfileInput) SetDescription(v string) *CreateNetworkProfileInput {
	s.Description = &v
	return s
}

// SetEapMethod sets the EapMethod field's value.
func (s *CreateNetworkProfileInput) SetEapMethod(v string) *CreateNetworkProfileInput {
	s.EapMethod = &v
	return s
}

// SetNetworkProfileName sets the NetworkProfileName field's value.
func (s *CreateNetworkProfileInput) SetNetworkProfileName(v string) *CreateNetworkProfileInput {
	s.NetworkProfileName = &v
	return s
}

// SetNextPassword sets the NextPassword field's value.
func (s *CreateNetworkProfileInput) SetNextPassword(v string) *CreateNetworkProfileInput {
	s.NextPassword = &v
	return s
}

// SetSecurityType sets the SecurityType field's value.
func (s *CreateNetworkProfileInput) SetSecurityType(v string) *CreateNetworkProfileInput {
	s.SecurityType = &v
	return s
}

// SetSsid sets the Ssid field's value.
func (s *CreateNetworkProfileInput) SetSsid(v string) *CreateNetworkProfileInput {
	s.Ssid = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateNetworkProfileInput) SetTags(v []*Tag) *CreateNetworkProfileInput {
	s.Tags = v
	return s
}

// SetTrustAnchors sets the TrustAnchors field's value.
func (s *CreateNetworkProfileInput) SetTrustAnchors(v []*string) *CreateNetworkProfileInput {
	s.TrustAnchors = v
	return s
}

type CreateNetworkProfileOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the network profile associated with a device.
	NetworkProfileArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNetworkProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNetworkProfileOutput) GoString() string {
	return s.String()
}

// SetNetworkProfileArn sets the NetworkProfileArn field's value.
func (s *CreateNetworkProfileOutput) SetNetworkProfileArn(v string) *CreateNetworkProfileOutput {
	s.NetworkProfileArn = &v
	return s
}

type CreateProfileInput struct {
	_ struct{} `type:"structure"`

	// The valid address for the room.
	//
	// Address is a required field
	Address *string `min:"1" type:"string" required:"true"`

	// The user-specified token that is used during the creation of a profile.
	ClientRequestToken *string `min:"10" type:"string" idempotencyToken:"true"`

	// Whether data retention of the profile is enabled.
	DataRetentionOptIn *bool `type:"boolean"`

	// The distance unit to be used by devices in the profile.
	//
	// DistanceUnit is a required field
	DistanceUnit *string `type:"string" required:"true" enum:"DistanceUnit"`

	// The locale of the room profile. (This is currently only available to a limited
	// preview audience.)
	Locale *string `min:"1" type:"string"`

	// The maximum volume limit for a room profile.
	MaxVolumeLimit *int64 `type:"integer"`

	// The meeting room settings of a room profile.
	MeetingRoomConfiguration *CreateMeetingRoomConfiguration `type:"structure"`

	// Whether PSTN calling is enabled.
	PSTNEnabled *bool `type:"boolean"`

	// The name of a room profile.
	//
	// ProfileName is a required field
	ProfileName *string `min:"1" type:"string" required:"true"`

	// Whether room profile setup is enabled.
	SetupModeDisabled *bool `type:"boolean"`

	// The tags for the profile.
	Tags []*Tag `type:"list"`

	// The temperature unit to be used by devices in the profile.
	//
	// TemperatureUnit is a required field
	TemperatureUnit *string `type:"string" required:"true" enum:"TemperatureUnit"`

	// The time zone used by a room profile.
	//
	// Timezone is a required field
	Timezone *string `min:"1" type:"string" required:"true"`

	// A wake word for Alexa, Echo, Amazon, or a computer.
	//
	// WakeWord is a required field
	WakeWord *string `type:"string" required:"true" enum:"WakeWord"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProfileInput"}
	if s.Address == nil {
		invalidParams.Add(request.NewErrParamRequired("Address"))
	}
	if s.Address != nil && len(*s.Address) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Address", 1))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 10))
	}
	if s.DistanceUnit == nil {
		invalidParams.Add(request.NewErrParamRequired("DistanceUnit"))
	}
	if s.Locale != nil && len(*s.Locale) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Locale", 1))
	}
	if s.ProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileName"))
	}
	if s.ProfileName != nil && len(*s.ProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileName", 1))
	}
	if s.TemperatureUnit == nil {
		invalidParams.Add(request.NewErrParamRequired("TemperatureUnit"))
	}
	if s.Timezone == nil {
		invalidParams.Add(request.NewErrParamRequired("Timezone"))
	}
	if s.Timezone != nil && len(*s.Timezone) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Timezone", 1))
	}
	if s.WakeWord == nil {
		invalidParams.Add(request.NewErrParamRequired("WakeWord"))
	}
	if s.MeetingRoomConfiguration != nil {
		if err := s.MeetingRoomConfiguration.Validate(); err != nil {
			invalidParams.AddNested("MeetingRoomConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddress sets the Address field's value.
func (s *CreateProfileInput) SetAddress(v string) *CreateProfileInput {
	s.Address = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateProfileInput) SetClientRequestToken(v string) *CreateProfileInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataRetentionOptIn sets the DataRetentionOptIn field's value.
func (s *CreateProfileInput) SetDataRetentionOptIn(v bool) *CreateProfileInput {
	s.DataRetentionOptIn = &v
	return s
}

// SetDistanceUnit sets the DistanceUnit field's value.
func (s *CreateProfileInput) SetDistanceUnit(v string) *CreateProfileInput {
	s.DistanceUnit = &v
	return s
}

// SetLocale sets the Locale field's value.
func (s *CreateProfileInput) SetLocale(v string) *CreateProfileInput {
	s.Locale = &v
	return s
}

// SetMaxVolumeLimit sets the MaxVolumeLimit field's value.
func (s *CreateProfileInput) SetMaxVolumeLimit(v int64) *CreateProfileInput {
	s.MaxVolumeLimit = &v
	return s
}

// SetMeetingRoomConfiguration sets the MeetingRoomConfiguration field's value.
func (s *CreateProfileInput) SetMeetingRoomConfiguration(v *CreateMeetingRoomConfiguration) *CreateProfileInput {
	s.MeetingRoomConfiguration = v
	return s
}

// SetPSTNEnabled sets the PSTNEnabled field's value.
func (s *CreateProfileInput) SetPSTNEnabled(v bool) *CreateProfileInput {
	s.PSTNEnabled = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *CreateProfileInput) SetProfileName(v string) *CreateProfileInput {
	s.ProfileName = &v
	return s
}

// SetSetupModeDisabled sets the SetupModeDisabled field's value.
func (s *CreateProfileInput) SetSetupModeDisabled(v bool) *CreateProfileInput {
	s.SetupModeDisabled = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateProfileInput) SetTags(v []*Tag) *CreateProfileInput {
	s.Tags = v
	return s
}

// SetTemperatureUnit sets the TemperatureUnit field's value.
func (s *CreateProfileInput) SetTemperatureUnit(v string) *CreateProfileInput {
	s.TemperatureUnit = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *CreateProfileInput) SetTimezone(v string) *CreateProfileInput {
	s.Timezone = &v
	return s
}

// SetWakeWord sets the WakeWord field's value.
func (s *CreateProfileInput) SetWakeWord(v string) *CreateProfileInput {
	s.WakeWord = &v
	return s
}

type CreateProfileOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the newly created room profile in the response.
	ProfileArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileOutput) GoString() string {
	return s.String()
}

// SetProfileArn sets the ProfileArn field's value.
func (s *CreateProfileOutput) SetProfileArn(v string) *CreateProfileOutput {
	s.ProfileArn = &v
	return s
}

// Creates settings for the require check in feature that are applied to a room
// profile. Require check in allows a meeting room’s Alexa or AVS device to
// prompt the user to check in; otherwise, the room will be released.
type CreateRequireCheckIn struct {
	_ struct{} `type:"structure"`

	// Whether require check in is enabled or not.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// Duration between 5 and 20 minutes to determine when to release the room if
	// it's not checked into.
	//
	// ReleaseAfterMinutes is a required field
	ReleaseAfterMinutes *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRequireCheckIn) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRequireCheckIn) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRequireCheckIn) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRequireCheckIn"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.ReleaseAfterMinutes == nil {
		invalidParams.Add(request.NewErrParamRequired("ReleaseAfterMinutes"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *CreateRequireCheckIn) SetEnabled(v bool) *CreateRequireCheckIn {
	s.Enabled = &v
	return s
}

// SetReleaseAfterMinutes sets the ReleaseAfterMinutes field's value.
func (s *CreateRequireCheckIn) SetReleaseAfterMinutes(v int64) *CreateRequireCheckIn {
	s.ReleaseAfterMinutes = &v
	return s
}

type CreateRoomInput struct {
	_ struct{} `type:"structure"`

	// A unique, user-specified identifier for this request that ensures idempotency.
	ClientRequestToken *string `min:"10" type:"string" idempotencyToken:"true"`

	// The description for the room.
	Description *string `min:"1" type:"string"`

	// The profile ARN for the room. This is required.
	ProfileArn *string `type:"string"`

	// The calendar ARN for the room.
	ProviderCalendarId *string `type:"string"`

	// The name for the room.
	//
	// RoomName is a required field
	RoomName *string `min:"1" type:"string" required:"true"`

	// The tags for the room.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRoomInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRoomInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRoomInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 10))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.RoomName == nil {
		invalidParams.Add(request.NewErrParamRequired("RoomName"))
	}
	if s.RoomName != nil && len(*s.RoomName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoomName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateRoomInput) SetClientRequestToken(v string) *CreateRoomInput {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateRoomInput) SetDescription(v string) *CreateRoomInput {
	s.Description = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *CreateRoomInput) SetProfileArn(v string) *CreateRoomInput {
	s.ProfileArn = &v
	return s
}

// SetProviderCalendarId sets the ProviderCalendarId field's value.
func (s *CreateRoomInput) SetProviderCalendarId(v string) *CreateRoomInput {
	s.ProviderCalendarId = &v
	return s
}

// SetRoomName sets the RoomName field's value.
func (s *CreateRoomInput) SetRoomName(v string) *CreateRoomInput {
	s.RoomName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRoomInput) SetTags(v []*Tag) *CreateRoomInput {
	s.Tags = v
	return s
}

type CreateRoomOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the newly created room in the response.
	RoomArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRoomOutput) GoString() string {
	return s.String()
}

// SetRoomArn sets the RoomArn field's value.
func (s *CreateRoomOutput) SetRoomArn(v string) *CreateRoomOutput {
	s.RoomArn = &v
	return s
}

type CreateSkillGroupInput struct {
	_ struct{} `type:"structure"`

	// A unique, user-specified identifier for this request that ensures idempotency.
	ClientRequestToken *string `min:"10" type:"string" idempotencyToken:"true"`

	// The description for the skill group.
	Description *string `min:"1" type:"string"`

	// The name for the skill group.
	//
	// SkillGroupName is a required field
	SkillGroupName *string `min:"1" type:"string" required:"true"`

	// The tags for the skill group.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSkillGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSkillGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSkillGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSkillGroupInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 10))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.SkillGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("SkillGroupName"))
	}
	if s.SkillGroupName != nil && len(*s.SkillGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SkillGroupName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateSkillGroupInput) SetClientRequestToken(v string) *CreateSkillGroupInput {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSkillGroupInput) SetDescription(v string) *CreateSkillGroupInput {
	s.Description = &v
	return s
}

// SetSkillGroupName sets the SkillGroupName field's value.
func (s *CreateSkillGroupInput) SetSkillGroupName(v string) *CreateSkillGroupInput {
	s.SkillGroupName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSkillGroupInput) SetTags(v []*Tag) *CreateSkillGroupInput {
	s.Tags = v
	return s
}

type CreateSkillGroupOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the newly created skill group in the response.
	SkillGroupArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSkillGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSkillGroupOutput) GoString() string {
	return s.String()
}

// SetSkillGroupArn sets the SkillGroupArn field's value.
func (s *CreateSkillGroupOutput) SetSkillGroupArn(v string) *CreateSkillGroupOutput {
	s.SkillGroupArn = &v
	return s
}

type CreateUserInput struct {
	_ struct{} `type:"structure"`

	// A unique, user-specified identifier for this request that ensures idempotency.
	ClientRequestToken *string `min:"10" type:"string" idempotencyToken:"true"`

	// The email address for the user.
	Email *string `min:"1" type:"string"`

	// The first name for the user.
	FirstName *string `type:"string"`

	// The last name for the user.
	LastName *string `type:"string"`

	// The tags for the user.
	Tags []*Tag `type:"list"`

	// The ARN for the user.
	//
	// UserId is a required field
	UserId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 10))
	}
	if s.Email != nil && len(*s.Email) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Email", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateUserInput) SetClientRequestToken(v string) *CreateUserInput {
	s.ClientRequestToken = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *CreateUserInput) SetEmail(v string) *CreateUserInput {
	s.Email = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *CreateUserInput) SetFirstName(v string) *CreateUserInput {
	s.FirstName = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *CreateUserInput) SetLastName(v string) *CreateUserInput {
	s.LastName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateUserInput) SetTags(v []*Tag) *CreateUserInput {
	s.Tags = v
	return s
}

// SetUserId sets the UserId field's value.
func (s *CreateUserInput) SetUserId(v string) *CreateUserInput {
	s.UserId = &v
	return s
}

type CreateUserOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the newly created user in the response.
	UserArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserOutput) GoString() string {
	return s.String()
}

// SetUserArn sets the UserArn field's value.
func (s *CreateUserOutput) SetUserArn(v string) *CreateUserOutput {
	s.UserArn = &v
	return s
}

type DeleteAddressBookInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the address book to delete.
	//
	// AddressBookArn is a required field
	AddressBookArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAddressBookInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAddressBookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAddressBookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAddressBookInput"}
	if s.AddressBookArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AddressBookArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressBookArn sets the AddressBookArn field's value.
func (s *DeleteAddressBookInput) SetAddressBookArn(v string) *DeleteAddressBookInput {
	s.AddressBookArn = &v
	return s
}

type DeleteAddressBookOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAddressBookOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAddressBookOutput) GoString() string {
	return s.String()
}

type DeleteBusinessReportScheduleInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the business report schedule.
	//
	// ScheduleArn is a required field
	ScheduleArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBusinessReportScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBusinessReportScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBusinessReportScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBusinessReportScheduleInput"}
	if s.ScheduleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScheduleArn sets the ScheduleArn field's value.
func (s *DeleteBusinessReportScheduleInput) SetScheduleArn(v string) *DeleteBusinessReportScheduleInput {
	s.ScheduleArn = &v
	return s
}

type DeleteBusinessReportScheduleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBusinessReportScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBusinessReportScheduleOutput) GoString() string {
	return s.String()
}

type DeleteConferenceProviderInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the conference provider.
	//
	// ConferenceProviderArn is a required field
	ConferenceProviderArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConferenceProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConferenceProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConferenceProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConferenceProviderInput"}
	if s.ConferenceProviderArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConferenceProviderArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConferenceProviderArn sets the ConferenceProviderArn field's value.
func (s *DeleteConferenceProviderInput) SetConferenceProviderArn(v string) *DeleteConferenceProviderInput {
	s.ConferenceProviderArn = &v
	return s
}

type DeleteConferenceProviderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConferenceProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConferenceProviderOutput) GoString() string {
	return s.String()
}

type DeleteContactInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the contact to delete.
	//
	// ContactArn is a required field
	ContactArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteContactInput"}
	if s.ContactArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactArn sets the ContactArn field's value.
func (s *DeleteContactInput) SetContactArn(v string) *DeleteContactInput {
	s.ContactArn = &v
	return s
}

type DeleteContactOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContactOutput) GoString() string {
	return s.String()
}

type DeleteDeviceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the device for which to request details.
	//
	// DeviceArn is a required field
	DeviceArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDeviceInput"}
	if s.DeviceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *DeleteDeviceInput) SetDeviceArn(v string) *DeleteDeviceInput {
	s.DeviceArn = &v
	return s
}

type DeleteDeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeviceOutput) GoString() string {
	return s.String()
}

type DeleteDeviceUsageDataInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the device.
	//
	// DeviceArn is a required field
	DeviceArn *string `type:"string" required:"true"`

	// The type of usage data to delete.
	//
	// DeviceUsageType is a required field
	DeviceUsageType *string `type:"string" required:"true" enum:"DeviceUsageType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeviceUsageDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeviceUsageDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeviceUsageDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDeviceUsageDataInput"}
	if s.DeviceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceArn"))
	}
	if s.DeviceUsageType == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceUsageType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *DeleteDeviceUsageDataInput) SetDeviceArn(v string) *DeleteDeviceUsageDataInput {
	s.DeviceArn = &v
	return s
}

// SetDeviceUsageType sets the DeviceUsageType field's value.
func (s *DeleteDeviceUsageDataInput) SetDeviceUsageType(v string) *DeleteDeviceUsageDataInput {
	s.DeviceUsageType = &v
	return s
}

type DeleteDeviceUsageDataOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeviceUsageDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeviceUsageDataOutput) GoString() string {
	return s.String()
}

type DeleteGatewayGroupInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the gateway group to delete.
	//
	// GatewayGroupArn is a required field
	GatewayGroupArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGatewayGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGatewayGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGatewayGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGatewayGroupInput"}
	if s.GatewayGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayGroupArn sets the GatewayGroupArn field's value.
func (s *DeleteGatewayGroupInput) SetGatewayGroupArn(v string) *DeleteGatewayGroupInput {
	s.GatewayGroupArn = &v
	return s
}

type DeleteGatewayGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGatewayGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGatewayGroupOutput) GoString() string {
	return s.String()
}

type DeleteNetworkProfileInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the network profile associated with a device.
	//
	// NetworkProfileArn is a required field
	NetworkProfileArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNetworkProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNetworkProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNetworkProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNetworkProfileInput"}
	if s.NetworkProfileArn == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkProfileArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNetworkProfileArn sets the NetworkProfileArn field's value.
func (s *DeleteNetworkProfileInput) SetNetworkProfileArn(v string) *DeleteNetworkProfileInput {
	s.NetworkProfileArn = &v
	return s
}

type DeleteNetworkProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNetworkProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNetworkProfileOutput) GoString() string {
	return s.String()
}

type DeleteProfileInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the room profile to delete. Required.
	ProfileArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileInput) GoString() string {
	return s.String()
}

// SetProfileArn sets the ProfileArn field's value.
func (s *DeleteProfileInput) SetProfileArn(v string) *DeleteProfileInput {
	s.ProfileArn = &v
	return s
}

type DeleteProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileOutput) GoString() string {
	return s.String()
}

type DeleteRoomInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the room to delete. Required.
	RoomArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRoomInput) GoString() string {
	return s.String()
}

// SetRoomArn sets the RoomArn field's value.
func (s *DeleteRoomInput) SetRoomArn(v string) *DeleteRoomInput {
	s.RoomArn = &v
	return s
}

type DeleteRoomOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRoomOutput) GoString() string {
	return s.String()
}

type DeleteRoomSkillParameterInput struct {
	_ struct{} `type:"structure"`

	// The room skill parameter key for which to remove details.
	//
	// ParameterKey is a required field
	ParameterKey *string `min:"1" type:"string" required:"true"`

	// The ARN of the room from which to remove the room skill parameter details.
	RoomArn *string `type:"string"`

	// The ID of the skill from which to remove the room skill parameter details.
	//
	// SkillId is a required field
	SkillId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRoomSkillParameterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRoomSkillParameterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRoomSkillParameterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRoomSkillParameterInput"}
	if s.ParameterKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterKey"))
	}
	if s.ParameterKey != nil && len(*s.ParameterKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParameterKey", 1))
	}
	if s.SkillId == nil {
		invalidParams.Add(request.NewErrParamRequired("SkillId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameterKey sets the ParameterKey field's value.
func (s *DeleteRoomSkillParameterInput) SetParameterKey(v string) *DeleteRoomSkillParameterInput {
	s.ParameterKey = &v
	return s
}

// SetRoomArn sets the RoomArn field's value.
func (s *DeleteRoomSkillParameterInput) SetRoomArn(v string) *DeleteRoomSkillParameterInput {
	s.RoomArn = &v
	return s
}

// SetSkillId sets the SkillId field's value.
func (s *DeleteRoomSkillParameterInput) SetSkillId(v string) *DeleteRoomSkillParameterInput {
	s.SkillId = &v
	return s
}

type DeleteRoomSkillParameterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRoomSkillParameterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRoomSkillParameterOutput) GoString() string {
	return s.String()
}

type DeleteSkillAuthorizationInput struct {
	_ struct{} `type:"structure"`

	// The room that the skill is authorized for.
	RoomArn *string `type:"string"`

	// The unique identifier of a skill.
	//
	// SkillId is a required field
	SkillId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSkillAuthorizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSkillAuthorizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSkillAuthorizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSkillAuthorizationInput"}
	if s.SkillId == nil {
		invalidParams.Add(request.NewErrParamRequired("SkillId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoomArn sets the RoomArn field's value.
func (s *DeleteSkillAuthorizationInput) SetRoomArn(v string) *DeleteSkillAuthorizationInput {
	s.RoomArn = &v
	return s
}

// SetSkillId sets the SkillId field's value.
func (s *DeleteSkillAuthorizationInput) SetSkillId(v string) *DeleteSkillAuthorizationInput {
	s.SkillId = &v
	return s
}

type DeleteSkillAuthorizationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSkillAuthorizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSkillAuthorizationOutput) GoString() string {
	return s.String()
}

type DeleteSkillGroupInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the skill group to delete. Required.
	SkillGroupArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSkillGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSkillGroupInput) GoString() string {
	return s.String()
}

// SetSkillGroupArn sets the SkillGroupArn field's value.
func (s *DeleteSkillGroupInput) SetSkillGroupArn(v string) *DeleteSkillGroupInput {
	s.SkillGroupArn = &v
	return s
}

type DeleteSkillGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSkillGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSkillGroupOutput) GoString() string {
	return s.String()
}

type DeleteUserInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the user's enrollment in the organization. Required.
	//
	// EnrollmentId is a required field
	EnrollmentId *string `type:"string" required:"true"`

	// The ARN of the user to delete in the organization. Required.
	UserArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserInput"}
	if s.EnrollmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnrollmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnrollmentId sets the EnrollmentId field's value.
func (s *DeleteUserInput) SetEnrollmentId(v string) *DeleteUserInput {
	s.EnrollmentId = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *DeleteUserInput) SetUserArn(v string) *DeleteUserInput {
	s.UserArn = &v
	return s
}

type DeleteUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserOutput) GoString() string {
	return s.String()
}

// The details about the developer that published the skill.
type DeveloperInfo struct {
	_ struct{} `type:"structure"`

	// The name of the developer.
	DeveloperName *string `type:"string"`

	// The email of the developer.
	Email *string `min:"1" type:"string"`

	// The URL of the privacy policy.
	PrivacyPolicy *string `type:"string"`

	// The website of the developer.
	Url *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeveloperInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeveloperInfo) GoString() string {
	return s.String()
}

// SetDeveloperName sets the DeveloperName field's value.
func (s *DeveloperInfo) SetDeveloperName(v string) *DeveloperInfo {
	s.DeveloperName = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *DeveloperInfo) SetEmail(v string) *DeveloperInfo {
	s.Email = &v
	return s
}

// SetPrivacyPolicy sets the PrivacyPolicy field's value.
func (s *DeveloperInfo) SetPrivacyPolicy(v string) *DeveloperInfo {
	s.PrivacyPolicy = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *DeveloperInfo) SetUrl(v string) *DeveloperInfo {
	s.Url = &v
	return s
}

// A device with attributes.
type Device struct {
	_ struct{} `type:"structure"`

	// The ARN of a device.
	DeviceArn *string `type:"string"`

	// The name of a device.
	DeviceName *string `min:"2" type:"string"`

	// The serial number of a device.
	DeviceSerialNumber *string `type:"string"`

	// The status of a device. If the status is not READY, check the DeviceStatusInfo
	// value for details.
	DeviceStatus *string `type:"string" enum:"DeviceStatus"`

	// Detailed information about a device's status.
	DeviceStatusInfo *DeviceStatusInfo `type:"structure"`

	// The type of a device.
	DeviceType *string `type:"string"`

	// The MAC address of a device.
	MacAddress *string `type:"string"`

	// Detailed information about a device's network profile.
	NetworkProfileInfo *DeviceNetworkProfileInfo `type:"structure"`

	// The room ARN of a device.
	RoomArn *string `type:"string"`

	// The software version of a device.
	SoftwareVersion *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Device) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Device) GoString() string {
	return s.String()
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *Device) SetDeviceArn(v string) *Device {
	s.DeviceArn = &v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *Device) SetDeviceName(v string) *Device {
	s.DeviceName = &v
	return s
}

// SetDeviceSerialNumber sets the DeviceSerialNumber field's value.
func (s *Device) SetDeviceSerialNumber(v string) *Device {
	s.DeviceSerialNumber = &v
	return s
}

// SetDeviceStatus sets the DeviceStatus field's value.
func (s *Device) SetDeviceStatus(v string) *Device {
	s.DeviceStatus = &v
	return s
}

// SetDeviceStatusInfo sets the DeviceStatusInfo field's value.
func (s *Device) SetDeviceStatusInfo(v *DeviceStatusInfo) *Device {
	s.DeviceStatusInfo = v
	return s
}

// SetDeviceType sets the DeviceType field's value.
func (s *Device) SetDeviceType(v string) *Device {
	s.DeviceType = &v
	return s
}

// SetMacAddress sets the MacAddress field's value.
func (s *Device) SetMacAddress(v string) *Device {
	s.MacAddress = &v
	return s
}

// SetNetworkProfileInfo sets the NetworkProfileInfo field's value.
func (s *Device) SetNetworkProfileInfo(v *DeviceNetworkProfileInfo) *Device {
	s.NetworkProfileInfo = v
	return s
}

// SetRoomArn sets the RoomArn field's value.
func (s *Device) SetRoomArn(v string) *Device {
	s.RoomArn = &v
	return s
}

// SetSoftwareVersion sets the SoftwareVersion field's value.
func (s *Device) SetSoftwareVersion(v string) *Device {
	s.SoftwareVersion = &v
	return s
}

// Device attributes.
type DeviceData struct {
	_ struct{} `type:"structure"`

	// The time (in epoch) when the device data was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The ARN of a device.
	DeviceArn *string `type:"string"`

	// The name of a device.
	DeviceName *string `min:"2" type:"string"`

	// The serial number of a device.
	DeviceSerialNumber *string `type:"string"`

	// The status of a device.
	DeviceStatus *string `type:"string" enum:"DeviceStatus"`

	// Detailed information about a device's status.
	DeviceStatusInfo *DeviceStatusInfo `type:"structure"`

	// The type of a device.
	DeviceType *string `type:"string"`

	// The MAC address of a device.
	MacAddress *string `type:"string"`

	// The ARN of the network profile associated with a device.
	NetworkProfileArn *string `type:"string"`

	// The name of the network profile associated with a device.
	NetworkProfileName *string `min:"1" type:"string"`

	// The room ARN associated with a device.
	RoomArn *string `type:"string"`

	// The name of the room associated with a device.
	RoomName *string `min:"1" type:"string"`

	// The software version of a device.
	SoftwareVersion *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceData) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DeviceData) SetCreatedTime(v time.Time) *DeviceData {
	s.CreatedTime = &v
	return s
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *DeviceData) SetDeviceArn(v string) *DeviceData {
	s.DeviceArn = &v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *DeviceData) SetDeviceName(v string) *DeviceData {
	s.DeviceName = &v
	return s
}

// SetDeviceSerialNumber sets the DeviceSerialNumber field's value.
func (s *DeviceData) SetDeviceSerialNumber(v string) *DeviceData {
	s.DeviceSerialNumber = &v
	return s
}

// SetDeviceStatus sets the DeviceStatus field's value.
func (s *DeviceData) SetDeviceStatus(v string) *DeviceData {
	s.DeviceStatus = &v
	return s
}

// SetDeviceStatusInfo sets the DeviceStatusInfo field's value.
func (s *DeviceData) SetDeviceStatusInfo(v *DeviceStatusInfo) *DeviceData {
	s.DeviceStatusInfo = v
	return s
}

// SetDeviceType sets the DeviceType field's value.
func (s *DeviceData) SetDeviceType(v string) *DeviceData {
	s.DeviceType = &v
	return s
}

// SetMacAddress sets the MacAddress field's value.
func (s *DeviceData) SetMacAddress(v string) *DeviceData {
	s.MacAddress = &v
	return s
}

// SetNetworkProfileArn sets the NetworkProfileArn field's value.
func (s *DeviceData) SetNetworkProfileArn(v string) *DeviceData {
	s.NetworkProfileArn = &v
	return s
}

// SetNetworkProfileName sets the NetworkProfileName field's value.
func (s *DeviceData) SetNetworkProfileName(v string) *DeviceData {
	s.NetworkProfileName = &v
	return s
}

// SetRoomArn sets the RoomArn field's value.
func (s *DeviceData) SetRoomArn(v string) *DeviceData {
	s.RoomArn = &v
	return s
}

// SetRoomName sets the RoomName field's value.
func (s *DeviceData) SetRoomName(v string) *DeviceData {
	s.RoomName = &v
	return s
}

// SetSoftwareVersion sets the SoftwareVersion field's value.
func (s *DeviceData) SetSoftwareVersion(v string) *DeviceData {
	s.SoftwareVersion = &v
	return s
}

// The list of device events.
type DeviceEvent struct {
	_ struct{} `type:"structure"`

	// The time (in epoch) when the event occurred.
	Timestamp *time.Time `type:"timestamp"`

	// The type of device event.
	Type *string `type:"string" enum:"DeviceEventType"`

	// The value of the event.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceEvent) GoString() string {
	return s.String()
}

// SetTimestamp sets the Timestamp field's value.
func (s *DeviceEvent) SetTimestamp(v time.Time) *DeviceEvent {
	s.Timestamp = &v
	return s
}

// SetType sets the Type field's value.
func (s *DeviceEvent) SetType(v string) *DeviceEvent {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *DeviceEvent) SetValue(v string) *DeviceEvent {
	s.Value = &v
	return s
}

// Detailed information about a device's network profile.
type DeviceNetworkProfileInfo struct {
	_ struct{} `type:"structure"`

	// The ARN of the certificate associated with a device.
	CertificateArn *string `type:"string"`

	// The time (in epoch) when the certificate expires.
	CertificateExpirationTime *time.Time `type:"timestamp"`

	// The ARN of the network profile associated with a device.
	NetworkProfileArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceNetworkProfileInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceNetworkProfileInfo) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *DeviceNetworkProfileInfo) SetCertificateArn(v string) *DeviceNetworkProfileInfo {
	s.CertificateArn = &v
	return s
}

// SetCertificateExpirationTime sets the CertificateExpirationTime field's value.
func (s *DeviceNetworkProfileInfo) SetCertificateExpirationTime(v time.Time) *DeviceNetworkProfileInfo {
	s.CertificateExpirationTime = &v
	return s
}

// SetNetworkProfileArn sets the NetworkProfileArn field's value.
func (s *DeviceNetworkProfileInfo) SetNetworkProfileArn(v string) *DeviceNetworkProfileInfo {
	s.NetworkProfileArn = &v
	return s
}

// The request failed because this device is no longer registered and therefore
// no longer managed by this account.
type DeviceNotRegisteredException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceNotRegisteredException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceNotRegisteredException) GoString() string {
	return s.String()
}

func newErrorDeviceNotRegisteredException(v protocol.ResponseMetadata) error {
	return &DeviceNotRegisteredException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DeviceNotRegisteredException) Code() string {
	return "DeviceNotRegisteredException"
}

// Message returns the exception's message.
func (s *DeviceNotRegisteredException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DeviceNotRegisteredException) OrigErr() error {
	return nil
}

func (s *DeviceNotRegisteredException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DeviceNotRegisteredException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DeviceNotRegisteredException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details of a device’s status.
type DeviceStatusDetail struct {
	_ struct{} `type:"structure"`

	// The device status detail code.
	Code *string `type:"string" enum:"DeviceStatusDetailCode"`

	// The list of available features on the device.
	Feature *string `type:"string" enum:"Feature"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceStatusDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceStatusDetail) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *DeviceStatusDetail) SetCode(v string) *DeviceStatusDetail {
	s.Code = &v
	return s
}

// SetFeature sets the Feature field's value.
func (s *DeviceStatusDetail) SetFeature(v string) *DeviceStatusDetail {
	s.Feature = &v
	return s
}

// Detailed information about a device's status.
type DeviceStatusInfo struct {
	_ struct{} `type:"structure"`

	// The latest available information about the connection status of a device.
	ConnectionStatus *string `type:"string" enum:"ConnectionStatus"`

	// The time (in epoch) when the device connection status changed.
	ConnectionStatusUpdatedTime *time.Time `type:"timestamp"`

	// One or more device status detail descriptions.
	DeviceStatusDetails []*DeviceStatusDetail `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceStatusInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceStatusInfo) GoString() string {
	return s.String()
}

// SetConnectionStatus sets the ConnectionStatus field's value.
func (s *DeviceStatusInfo) SetConnectionStatus(v string) *DeviceStatusInfo {
	s.ConnectionStatus = &v
	return s
}

// SetConnectionStatusUpdatedTime sets the ConnectionStatusUpdatedTime field's value.
func (s *DeviceStatusInfo) SetConnectionStatusUpdatedTime(v time.Time) *DeviceStatusInfo {
	s.ConnectionStatusUpdatedTime = &v
	return s
}

// SetDeviceStatusDetails sets the DeviceStatusDetails field's value.
func (s *DeviceStatusInfo) SetDeviceStatusDetails(v []*DeviceStatusDetail) *DeviceStatusInfo {
	s.DeviceStatusDetails = v
	return s
}

type DisassociateContactFromAddressBookInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the address from which to disassociate the contact.
	//
	// AddressBookArn is a required field
	AddressBookArn *string `type:"string" required:"true"`

	// The ARN of the contact to disassociate from an address book.
	//
	// ContactArn is a required field
	ContactArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateContactFromAddressBookInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateContactFromAddressBookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateContactFromAddressBookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateContactFromAddressBookInput"}
	if s.AddressBookArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AddressBookArn"))
	}
	if s.ContactArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressBookArn sets the AddressBookArn field's value.
func (s *DisassociateContactFromAddressBookInput) SetAddressBookArn(v string) *DisassociateContactFromAddressBookInput {
	s.AddressBookArn = &v
	return s
}

// SetContactArn sets the ContactArn field's value.
func (s *DisassociateContactFromAddressBookInput) SetContactArn(v string) *DisassociateContactFromAddressBookInput {
	s.ContactArn = &v
	return s
}

type DisassociateContactFromAddressBookOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateContactFromAddressBookOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateContactFromAddressBookOutput) GoString() string {
	return s.String()
}

type DisassociateDeviceFromRoomInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the device to disassociate from a room. Required.
	DeviceArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateDeviceFromRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateDeviceFromRoomInput) GoString() string {
	return s.String()
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *DisassociateDeviceFromRoomInput) SetDeviceArn(v string) *DisassociateDeviceFromRoomInput {
	s.DeviceArn = &v
	return s
}

type DisassociateDeviceFromRoomOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateDeviceFromRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateDeviceFromRoomOutput) GoString() string {
	return s.String()
}

type DisassociateSkillFromSkillGroupInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of a skill. Required.
	SkillGroupArn *string `type:"string"`

	// The ARN of a skill group to associate to a skill.
	//
	// SkillId is a required field
	SkillId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateSkillFromSkillGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateSkillFromSkillGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateSkillFromSkillGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateSkillFromSkillGroupInput"}
	if s.SkillId == nil {
		invalidParams.Add(request.NewErrParamRequired("SkillId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSkillGroupArn sets the SkillGroupArn field's value.
func (s *DisassociateSkillFromSkillGroupInput) SetSkillGroupArn(v string) *DisassociateSkillFromSkillGroupInput {
	s.SkillGroupArn = &v
	return s
}

// SetSkillId sets the SkillId field's value.
func (s *DisassociateSkillFromSkillGroupInput) SetSkillId(v string) *DisassociateSkillFromSkillGroupInput {
	s.SkillId = &v
	return s
}

type DisassociateSkillFromSkillGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateSkillFromSkillGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateSkillFromSkillGroupOutput) GoString() string {
	return s.String()
}

type DisassociateSkillFromUsersInput struct {
	_ struct{} `type:"structure"`

	// The private skill ID you want to make unavailable for enrolled users.
	//
	// SkillId is a required field
	SkillId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateSkillFromUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateSkillFromUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateSkillFromUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateSkillFromUsersInput"}
	if s.SkillId == nil {
		invalidParams.Add(request.NewErrParamRequired("SkillId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSkillId sets the SkillId field's value.
func (s *DisassociateSkillFromUsersInput) SetSkillId(v string) *DisassociateSkillFromUsersInput {
	s.SkillId = &v
	return s
}

type DisassociateSkillFromUsersOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateSkillFromUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateSkillFromUsersOutput) GoString() string {
	return s.String()
}

type DisassociateSkillGroupFromRoomInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the room from which the skill group is to be disassociated. Required.
	RoomArn *string `type:"string"`

	// The ARN of the skill group to disassociate from a room. Required.
	SkillGroupArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateSkillGroupFromRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateSkillGroupFromRoomInput) GoString() string {
	return s.String()
}

// SetRoomArn sets the RoomArn field's value.
func (s *DisassociateSkillGroupFromRoomInput) SetRoomArn(v string) *DisassociateSkillGroupFromRoomInput {
	s.RoomArn = &v
	return s
}

// SetSkillGroupArn sets the SkillGroupArn field's value.
func (s *DisassociateSkillGroupFromRoomInput) SetSkillGroupArn(v string) *DisassociateSkillGroupFromRoomInput {
	s.SkillGroupArn = &v
	return s
}

type DisassociateSkillGroupFromRoomOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateSkillGroupFromRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateSkillGroupFromRoomOutput) GoString() string {
	return s.String()
}

// Settings for the end of meeting reminder feature that are applied to a room
// profile. The end of meeting reminder enables Alexa to remind users when a
// meeting is ending.
type EndOfMeetingReminder struct {
	_ struct{} `type:"structure"`

	// Whether an end of meeting reminder is enabled or not.
	Enabled *bool `type:"boolean"`

	// A range of 3 to 15 minutes that determines when the reminder begins.
	ReminderAtMinutes []*int64 `min:"1" type:"list"`

	// The type of sound that users hear during the end of meeting reminder.
	ReminderType *string `type:"string" enum:"EndOfMeetingReminderType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndOfMeetingReminder) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndOfMeetingReminder) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *EndOfMeetingReminder) SetEnabled(v bool) *EndOfMeetingReminder {
	s.Enabled = &v
	return s
}

// SetReminderAtMinutes sets the ReminderAtMinutes field's value.
func (s *EndOfMeetingReminder) SetReminderAtMinutes(v []*int64) *EndOfMeetingReminder {
	s.ReminderAtMinutes = v
	return s
}

// SetReminderType sets the ReminderType field's value.
func (s *EndOfMeetingReminder) SetReminderType(v string) *EndOfMeetingReminder {
	s.ReminderType = &v
	return s
}

// A filter name and value pair that is used to return a more specific list
// of results. Filters can be used to match a set of resources by various criteria.
type Filter struct {
	_ struct{} `type:"structure"`

	// The key of a filter.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The values of a filter.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Filter) SetKey(v string) *Filter {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

type ForgetSmartHomeAppliancesInput struct {
	_ struct{} `type:"structure"`

	// The room that the appliances are associated with.
	//
	// RoomArn is a required field
	RoomArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForgetSmartHomeAppliancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForgetSmartHomeAppliancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ForgetSmartHomeAppliancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ForgetSmartHomeAppliancesInput"}
	if s.RoomArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoomArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoomArn sets the RoomArn field's value.
func (s *ForgetSmartHomeAppliancesInput) SetRoomArn(v string) *ForgetSmartHomeAppliancesInput {
	s.RoomArn = &v
	return s
}

type ForgetSmartHomeAppliancesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForgetSmartHomeAppliancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForgetSmartHomeAppliancesOutput) GoString() string {
	return s.String()
}

// The details of the gateway.
type Gateway struct {
	_ struct{} `type:"structure"`

	// The ARN of the gateway.
	Arn *string `type:"string"`

	// The description of the gateway.
	Description *string `type:"string"`

	// The ARN of the gateway group that the gateway is associated to.
	GatewayGroupArn *string `type:"string"`

	// The name of the gateway.
	Name *string `min:"1" type:"string"`

	// The software version of the gateway. The gateway automatically updates its
	// software version during normal operation.
	SoftwareVersion *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Gateway) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Gateway) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Gateway) SetArn(v string) *Gateway {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Gateway) SetDescription(v string) *Gateway {
	s.Description = &v
	return s
}

// SetGatewayGroupArn sets the GatewayGroupArn field's value.
func (s *Gateway) SetGatewayGroupArn(v string) *Gateway {
	s.GatewayGroupArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *Gateway) SetName(v string) *Gateway {
	s.Name = &v
	return s
}

// SetSoftwareVersion sets the SoftwareVersion field's value.
func (s *Gateway) SetSoftwareVersion(v string) *Gateway {
	s.SoftwareVersion = &v
	return s
}

// The details of the gateway group.
type GatewayGroup struct {
	_ struct{} `type:"structure"`

	// The ARN of the gateway group.
	Arn *string `type:"string"`

	// The description of the gateway group.
	Description *string `type:"string"`

	// The name of the gateway group.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayGroup) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GatewayGroup) SetArn(v string) *GatewayGroup {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GatewayGroup) SetDescription(v string) *GatewayGroup {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *GatewayGroup) SetName(v string) *GatewayGroup {
	s.Name = &v
	return s
}

// The summary of a gateway group.
type GatewayGroupSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the gateway group.
	Arn *string `type:"string"`

	// The description of the gateway group.
	Description *string `type:"string"`

	// The name of the gateway group.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayGroupSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GatewayGroupSummary) SetArn(v string) *GatewayGroupSummary {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GatewayGroupSummary) SetDescription(v string) *GatewayGroupSummary {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *GatewayGroupSummary) SetName(v string) *GatewayGroupSummary {
	s.Name = &v
	return s
}

// The summary of a gateway.
type GatewaySummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the gateway.
	Arn *string `type:"string"`

	// The description of the gateway.
	Description *string `type:"string"`

	// The ARN of the gateway group that the gateway is associated to.
	GatewayGroupArn *string `type:"string"`

	// The name of the gateway.
	Name *string `min:"1" type:"string"`

	// The software version of the gateway. The gateway automatically updates its
	// software version during normal operation.
	SoftwareVersion *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewaySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewaySummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GatewaySummary) SetArn(v string) *GatewaySummary {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GatewaySummary) SetDescription(v string) *GatewaySummary {
	s.Description = &v
	return s
}

// SetGatewayGroupArn sets the GatewayGroupArn field's value.
func (s *GatewaySummary) SetGatewayGroupArn(v string) *GatewaySummary {
	s.GatewayGroupArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GatewaySummary) SetName(v string) *GatewaySummary {
	s.Name = &v
	return s
}

// SetSoftwareVersion sets the SoftwareVersion field's value.
func (s *GatewaySummary) SetSoftwareVersion(v string) *GatewaySummary {
	s.SoftwareVersion = &v
	return s
}

type GetAddressBookInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the address book for which to request details.
	//
	// AddressBookArn is a required field
	AddressBookArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAddressBookInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAddressBookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAddressBookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAddressBookInput"}
	if s.AddressBookArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AddressBookArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressBookArn sets the AddressBookArn field's value.
func (s *GetAddressBookInput) SetAddressBookArn(v string) *GetAddressBookInput {
	s.AddressBookArn = &v
	return s
}

type GetAddressBookOutput struct {
	_ struct{} `type:"structure"`

	// The details of the requested address book.
	AddressBook *AddressBook `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAddressBookOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAddressBookOutput) GoString() string {
	return s.String()
}

// SetAddressBook sets the AddressBook field's value.
func (s *GetAddressBookOutput) SetAddressBook(v *AddressBook) *GetAddressBookOutput {
	s.AddressBook = v
	return s
}

type GetConferencePreferenceInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConferencePreferenceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConferencePreferenceInput) GoString() string {
	return s.String()
}

type GetConferencePreferenceOutput struct {
	_ struct{} `type:"structure"`

	// The conference preference.
	Preference *ConferencePreference `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConferencePreferenceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConferencePreferenceOutput) GoString() string {
	return s.String()
}

// SetPreference sets the Preference field's value.
func (s *GetConferencePreferenceOutput) SetPreference(v *ConferencePreference) *GetConferencePreferenceOutput {
	s.Preference = v
	return s
}

type GetConferenceProviderInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the newly created conference provider.
	//
	// ConferenceProviderArn is a required field
	ConferenceProviderArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConferenceProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConferenceProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConferenceProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConferenceProviderInput"}
	if s.ConferenceProviderArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConferenceProviderArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConferenceProviderArn sets the ConferenceProviderArn field's value.
func (s *GetConferenceProviderInput) SetConferenceProviderArn(v string) *GetConferenceProviderInput {
	s.ConferenceProviderArn = &v
	return s
}

type GetConferenceProviderOutput struct {
	_ struct{} `type:"structure"`

	// The conference provider.
	ConferenceProvider *ConferenceProvider `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConferenceProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConferenceProviderOutput) GoString() string {
	return s.String()
}

// SetConferenceProvider sets the ConferenceProvider field's value.
func (s *GetConferenceProviderOutput) SetConferenceProvider(v *ConferenceProvider) *GetConferenceProviderOutput {
	s.ConferenceProvider = v
	return s
}

type GetContactInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the contact for which to request details.
	//
	// ContactArn is a required field
	ContactArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetContactInput"}
	if s.ContactArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactArn sets the ContactArn field's value.
func (s *GetContactInput) SetContactArn(v string) *GetContactInput {
	s.ContactArn = &v
	return s
}

type GetContactOutput struct {
	_ struct{} `type:"structure"`

	// The details of the requested contact.
	Contact *Contact `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactOutput) GoString() string {
	return s.String()
}

// SetContact sets the Contact field's value.
func (s *GetContactOutput) SetContact(v *Contact) *GetContactOutput {
	s.Contact = v
	return s
}

type GetDeviceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the device for which to request details. Required.
	DeviceArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceInput) GoString() string {
	return s.String()
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *GetDeviceInput) SetDeviceArn(v string) *GetDeviceInput {
	s.DeviceArn = &v
	return s
}

type GetDeviceOutput struct {
	_ struct{} `type:"structure"`

	// The details of the device requested. Required.
	Device *Device `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeviceOutput) GoString() string {
	return s.String()
}

// SetDevice sets the Device field's value.
func (s *GetDeviceOutput) SetDevice(v *Device) *GetDeviceOutput {
	s.Device = v
	return s
}

type GetGatewayGroupInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the gateway group to get.
	//
	// GatewayGroupArn is a required field
	GatewayGroupArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGatewayGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGatewayGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGatewayGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGatewayGroupInput"}
	if s.GatewayGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayGroupArn sets the GatewayGroupArn field's value.
func (s *GetGatewayGroupInput) SetGatewayGroupArn(v string) *GetGatewayGroupInput {
	s.GatewayGroupArn = &v
	return s
}

type GetGatewayGroupOutput struct {
	_ struct{} `type:"structure"`

	// The details of the gateway group.
	GatewayGroup *GatewayGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGatewayGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGatewayGroupOutput) GoString() string {
	return s.String()
}

// SetGatewayGroup sets the GatewayGroup field's value.
func (s *GetGatewayGroupOutput) SetGatewayGroup(v *GatewayGroup) *GetGatewayGroupOutput {
	s.GatewayGroup = v
	return s
}

type GetGatewayInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the gateway to get.
	//
	// GatewayArn is a required field
	GatewayArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGatewayInput"}
	if s.GatewayArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayArn sets the GatewayArn field's value.
func (s *GetGatewayInput) SetGatewayArn(v string) *GetGatewayInput {
	s.GatewayArn = &v
	return s
}

type GetGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The details of the gateway.
	Gateway *Gateway `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGatewayOutput) GoString() string {
	return s.String()
}

// SetGateway sets the Gateway field's value.
func (s *GetGatewayOutput) SetGateway(v *Gateway) *GetGatewayOutput {
	s.Gateway = v
	return s
}

type GetInvitationConfigurationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInvitationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInvitationConfigurationInput) GoString() string {
	return s.String()
}

type GetInvitationConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The email ID of the organization or individual contact that the enrolled
	// user can use.
	ContactEmail *string `min:"1" type:"string"`

	// The name of the organization sending the enrollment invite to a user.
	OrganizationName *string `min:"1" type:"string"`

	// The list of private skill IDs that you want to recommend to the user to enable
	// in the invitation.
	PrivateSkillIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInvitationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInvitationConfigurationOutput) GoString() string {
	return s.String()
}

// SetContactEmail sets the ContactEmail field's value.
func (s *GetInvitationConfigurationOutput) SetContactEmail(v string) *GetInvitationConfigurationOutput {
	s.ContactEmail = &v
	return s
}

// SetOrganizationName sets the OrganizationName field's value.
func (s *GetInvitationConfigurationOutput) SetOrganizationName(v string) *GetInvitationConfigurationOutput {
	s.OrganizationName = &v
	return s
}

// SetPrivateSkillIds sets the PrivateSkillIds field's value.
func (s *GetInvitationConfigurationOutput) SetPrivateSkillIds(v []*string) *GetInvitationConfigurationOutput {
	s.PrivateSkillIds = v
	return s
}

type GetNetworkProfileInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the network profile associated with a device.
	//
	// NetworkProfileArn is a required field
	NetworkProfileArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNetworkProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNetworkProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetNetworkProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetNetworkProfileInput"}
	if s.NetworkProfileArn == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkProfileArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNetworkProfileArn sets the NetworkProfileArn field's value.
func (s *GetNetworkProfileInput) SetNetworkProfileArn(v string) *GetNetworkProfileInput {
	s.NetworkProfileArn = &v
	return s
}

type GetNetworkProfileOutput struct {
	_ struct{} `type:"structure"`

	// The network profile associated with a device.
	NetworkProfile *NetworkProfile `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNetworkProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNetworkProfileOutput) GoString() string {
	return s.String()
}

// SetNetworkProfile sets the NetworkProfile field's value.
func (s *GetNetworkProfileOutput) SetNetworkProfile(v *NetworkProfile) *GetNetworkProfileOutput {
	s.NetworkProfile = v
	return s
}

type GetProfileInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the room profile for which to request details. Required.
	ProfileArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileInput) GoString() string {
	return s.String()
}

// SetProfileArn sets the ProfileArn field's value.
func (s *GetProfileInput) SetProfileArn(v string) *GetProfileInput {
	s.ProfileArn = &v
	return s
}

type GetProfileOutput struct {
	_ struct{} `type:"structure"`

	// The details of the room profile requested. Required.
	Profile *Profile `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileOutput) GoString() string {
	return s.String()
}

// SetProfile sets the Profile field's value.
func (s *GetProfileOutput) SetProfile(v *Profile) *GetProfileOutput {
	s.Profile = v
	return s
}

type GetRoomInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the room for which to request details. Required.
	RoomArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRoomInput) GoString() string {
	return s.String()
}

// SetRoomArn sets the RoomArn field's value.
func (s *GetRoomInput) SetRoomArn(v string) *GetRoomInput {
	s.RoomArn = &v
	return s
}

type GetRoomOutput struct {
	_ struct{} `type:"structure"`

	// The details of the room requested.
	Room *Room `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRoomOutput) GoString() string {
	return s.String()
}

// SetRoom sets the Room field's value.
func (s *GetRoomOutput) SetRoom(v *Room) *GetRoomOutput {
	s.Room = v
	return s
}

type GetRoomSkillParameterInput struct {
	_ struct{} `type:"structure"`

	// The room skill parameter key for which to get details. Required.
	//
	// ParameterKey is a required field
	ParameterKey *string `min:"1" type:"string" required:"true"`

	// The ARN of the room from which to get the room skill parameter details.
	RoomArn *string `type:"string"`

	// The ARN of the skill from which to get the room skill parameter details.
	// Required.
	//
	// SkillId is a required field
	SkillId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRoomSkillParameterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRoomSkillParameterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRoomSkillParameterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRoomSkillParameterInput"}
	if s.ParameterKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterKey"))
	}
	if s.ParameterKey != nil && len(*s.ParameterKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParameterKey", 1))
	}
	if s.SkillId == nil {
		invalidParams.Add(request.NewErrParamRequired("SkillId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameterKey sets the ParameterKey field's value.
func (s *GetRoomSkillParameterInput) SetParameterKey(v string) *GetRoomSkillParameterInput {
	s.ParameterKey = &v
	return s
}

// SetRoomArn sets the RoomArn field's value.
func (s *GetRoomSkillParameterInput) SetRoomArn(v string) *GetRoomSkillParameterInput {
	s.RoomArn = &v
	return s
}

// SetSkillId sets the SkillId field's value.
func (s *GetRoomSkillParameterInput) SetSkillId(v string) *GetRoomSkillParameterInput {
	s.SkillId = &v
	return s
}

type GetRoomSkillParameterOutput struct {
	_ struct{} `type:"structure"`

	// The details of the room skill parameter requested. Required.
	RoomSkillParameter *RoomSkillParameter `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRoomSkillParameterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRoomSkillParameterOutput) GoString() string {
	return s.String()
}

// SetRoomSkillParameter sets the RoomSkillParameter field's value.
func (s *GetRoomSkillParameterOutput) SetRoomSkillParameter(v *RoomSkillParameter) *GetRoomSkillParameterOutput {
	s.RoomSkillParameter = v
	return s
}

type GetSkillGroupInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the skill group for which to get details. Required.
	SkillGroupArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSkillGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSkillGroupInput) GoString() string {
	return s.String()
}

// SetSkillGroupArn sets the SkillGroupArn field's value.
func (s *GetSkillGroupInput) SetSkillGroupArn(v string) *GetSkillGroupInput {
	s.SkillGroupArn = &v
	return s
}

type GetSkillGroupOutput struct {
	_ struct{} `type:"structure"`

	// The details of the skill group requested. Required.
	SkillGroup *SkillGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSkillGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSkillGroupOutput) GoString() string {
	return s.String()
}

// SetSkillGroup sets the SkillGroup field's value.
func (s *GetSkillGroupOutput) SetSkillGroup(v *SkillGroup) *GetSkillGroupOutput {
	s.SkillGroup = v
	return s
}

// The IP endpoint and protocol for calling.
type IPDialIn struct {
	_ struct{} `type:"structure"`

	// The protocol, including SIP, SIPS, and H323.
	//
	// CommsProtocol is a required field
	CommsProtocol *string `type:"string" required:"true" enum:"CommsProtocol"`

	// The IP address.
	//
	// Endpoint is a required field
	Endpoint *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IPDialIn) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IPDialIn) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IPDialIn) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IPDialIn"}
	if s.CommsProtocol == nil {
		invalidParams.Add(request.NewErrParamRequired("CommsProtocol"))
	}
	if s.Endpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("Endpoint"))
	}
	if s.Endpoint != nil && len(*s.Endpoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Endpoint", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommsProtocol sets the CommsProtocol field's value.
func (s *IPDialIn) SetCommsProtocol(v string) *IPDialIn {
	s.CommsProtocol = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *IPDialIn) SetEndpoint(v string) *IPDialIn {
	s.Endpoint = &v
	return s
}

// Settings for the instant booking feature that are applied to a room profile.
// When users start their meeting with Alexa, Alexa automatically books the
// room for the configured duration if the room is available.
type InstantBooking struct {
	_ struct{} `type:"structure"`

	// Duration between 15 and 240 minutes at increments of 15 that determines how
	// long to book an available room when a meeting is started with Alexa.
	DurationInMinutes *int64 `type:"integer"`

	// Whether instant booking is enabled or not.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstantBooking) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstantBooking) GoString() string {
	return s.String()
}

// SetDurationInMinutes sets the DurationInMinutes field's value.
func (s *InstantBooking) SetDurationInMinutes(v int64) *InstantBooking {
	s.DurationInMinutes = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *InstantBooking) SetEnabled(v bool) *InstantBooking {
	s.Enabled = &v
	return s
}

// The Certificate Authority can't issue or revoke a certificate.
type InvalidCertificateAuthorityException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidCertificateAuthorityException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidCertificateAuthorityException) GoString() string {
	return s.String()
}

func newErrorInvalidCertificateAuthorityException(v protocol.ResponseMetadata) error {
	return &InvalidCertificateAuthorityException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidCertificateAuthorityException) Code() string {
	return "InvalidCertificateAuthorityException"
}

// Message returns the exception's message.
func (s *InvalidCertificateAuthorityException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidCertificateAuthorityException) OrigErr() error {
	return nil
}

func (s *InvalidCertificateAuthorityException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidCertificateAuthorityException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidCertificateAuthorityException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The device is in an invalid state.
type InvalidDeviceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidDeviceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidDeviceException) GoString() string {
	return s.String()
}

func newErrorInvalidDeviceException(v protocol.ResponseMetadata) error {
	return &InvalidDeviceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidDeviceException) Code() string {
	return "InvalidDeviceException"
}

// Message returns the exception's message.
func (s *InvalidDeviceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidDeviceException) OrigErr() error {
	return nil
}

func (s *InvalidDeviceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidDeviceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidDeviceException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A password in SecretsManager is in an invalid state.
type InvalidSecretsManagerResourceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidSecretsManagerResourceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidSecretsManagerResourceException) GoString() string {
	return s.String()
}

func newErrorInvalidSecretsManagerResourceException(v protocol.ResponseMetadata) error {
	return &InvalidSecretsManagerResourceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidSecretsManagerResourceException) Code() string {
	return "InvalidSecretsManagerResourceException"
}

// Message returns the exception's message.
func (s *InvalidSecretsManagerResourceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidSecretsManagerResourceException) OrigErr() error {
	return nil
}

func (s *InvalidSecretsManagerResourceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidSecretsManagerResourceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidSecretsManagerResourceException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service linked role is locked for deletion.
type InvalidServiceLinkedRoleStateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidServiceLinkedRoleStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidServiceLinkedRoleStateException) GoString() string {
	return s.String()
}

func newErrorInvalidServiceLinkedRoleStateException(v protocol.ResponseMetadata) error {
	return &InvalidServiceLinkedRoleStateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidServiceLinkedRoleStateException) Code() string {
	return "InvalidServiceLinkedRoleStateException"
}

// Message returns the exception's message.
func (s *InvalidServiceLinkedRoleStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidServiceLinkedRoleStateException) OrigErr() error {
	return nil
}

func (s *InvalidServiceLinkedRoleStateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidServiceLinkedRoleStateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidServiceLinkedRoleStateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The attempt to update a user is invalid due to the user's current status.
type InvalidUserStatusException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidUserStatusException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidUserStatusException) GoString() string {
	return s.String()
}

func newErrorInvalidUserStatusException(v protocol.ResponseMetadata) error {
	return &InvalidUserStatusException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidUserStatusException) Code() string {
	return "InvalidUserStatusException"
}

// Message returns the exception's message.
func (s *InvalidUserStatusException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidUserStatusException) OrigErr() error {
	return nil
}

func (s *InvalidUserStatusException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidUserStatusException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidUserStatusException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You are performing an action that would put you beyond your account's limits.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListBusinessReportSchedulesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of schedules listed in the call.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token used to list the remaining schedules from the previous API call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBusinessReportSchedulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBusinessReportSchedulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBusinessReportSchedulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBusinessReportSchedulesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBusinessReportSchedulesInput) SetMaxResults(v int64) *ListBusinessReportSchedulesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBusinessReportSchedulesInput) SetNextToken(v string) *ListBusinessReportSchedulesInput {
	s.NextToken = &v
	return s
}

type ListBusinessReportSchedulesOutput struct {
	_ struct{} `type:"structure"`

	// The schedule of the reports.
	BusinessReportSchedules []*BusinessReportSchedule `type:"list"`

	// The token used to list the remaining schedules from the previous API call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBusinessReportSchedulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBusinessReportSchedulesOutput) GoString() string {
	return s.String()
}

// SetBusinessReportSchedules sets the BusinessReportSchedules field's value.
func (s *ListBusinessReportSchedulesOutput) SetBusinessReportSchedules(v []*BusinessReportSchedule) *ListBusinessReportSchedulesOutput {
	s.BusinessReportSchedules = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBusinessReportSchedulesOutput) SetNextToken(v string) *ListBusinessReportSchedulesOutput {
	s.NextToken = &v
	return s
}

type ListConferenceProvidersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of conference providers to be returned, per paginated
	// calls.
	MaxResults *int64 `min:"1" type:"integer"`

	// The tokens used for pagination.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConferenceProvidersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConferenceProvidersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConferenceProvidersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListConferenceProvidersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConferenceProvidersInput) SetMaxResults(v int64) *ListConferenceProvidersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConferenceProvidersInput) SetNextToken(v string) *ListConferenceProvidersInput {
	s.NextToken = &v
	return s
}

type ListConferenceProvidersOutput struct {
	_ struct{} `type:"structure"`

	// The conference providers.
	ConferenceProviders []*ConferenceProvider `type:"list"`

	// The tokens used for pagination.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConferenceProvidersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConferenceProvidersOutput) GoString() string {
	return s.String()
}

// SetConferenceProviders sets the ConferenceProviders field's value.
func (s *ListConferenceProvidersOutput) SetConferenceProviders(v []*ConferenceProvider) *ListConferenceProvidersOutput {
	s.ConferenceProviders = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConferenceProvidersOutput) SetNextToken(v string) *ListConferenceProvidersOutput {
	s.NextToken = &v
	return s
}

type ListDeviceEventsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of a device.
	//
	// DeviceArn is a required field
	DeviceArn *string `type:"string" required:"true"`

	// The event type to filter device events. If EventType isn't specified, this
	// returns a list of all device events in reverse chronological order. If EventType
	// is specified, this returns a list of device events for that EventType in
	// reverse chronological order.
	EventType *string `type:"string" enum:"DeviceEventType"`

	// The maximum number of results to include in the response. The default value
	// is 50. If more results exist than the specified MaxResults value, a token
	// is included in the response so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// only includes results beyond the token, up to the value specified by MaxResults.
	// When the end of results is reached, the response has a value of null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeviceEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeviceEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeviceEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeviceEventsInput"}
	if s.DeviceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *ListDeviceEventsInput) SetDeviceArn(v string) *ListDeviceEventsInput {
	s.DeviceArn = &v
	return s
}

// SetEventType sets the EventType field's value.
func (s *ListDeviceEventsInput) SetEventType(v string) *ListDeviceEventsInput {
	s.EventType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDeviceEventsInput) SetMaxResults(v int64) *ListDeviceEventsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeviceEventsInput) SetNextToken(v string) *ListDeviceEventsInput {
	s.NextToken = &v
	return s
}

type ListDeviceEventsOutput struct {
	_ struct{} `type:"structure"`

	// The device events requested for the device ARN.
	DeviceEvents []*DeviceEvent `type:"list"`

	// The token returned to indicate that there is more data available.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeviceEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeviceEventsOutput) GoString() string {
	return s.String()
}

// SetDeviceEvents sets the DeviceEvents field's value.
func (s *ListDeviceEventsOutput) SetDeviceEvents(v []*DeviceEvent) *ListDeviceEventsOutput {
	s.DeviceEvents = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeviceEventsOutput) SetNextToken(v string) *ListDeviceEventsOutput {
	s.NextToken = &v
	return s
}

type ListGatewayGroupsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of gateway group summaries to return. The default is 50.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token used to paginate though multiple pages of gateway group summaries.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGatewayGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGatewayGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGatewayGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGatewayGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGatewayGroupsInput) SetMaxResults(v int64) *ListGatewayGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGatewayGroupsInput) SetNextToken(v string) *ListGatewayGroupsInput {
	s.NextToken = &v
	return s
}

type ListGatewayGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The gateway groups in the list.
	GatewayGroups []*GatewayGroupSummary `type:"list"`

	// The token used to paginate though multiple pages of gateway group summaries.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGatewayGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGatewayGroupsOutput) GoString() string {
	return s.String()
}

// SetGatewayGroups sets the GatewayGroups field's value.
func (s *ListGatewayGroupsOutput) SetGatewayGroups(v []*GatewayGroupSummary) *ListGatewayGroupsOutput {
	s.GatewayGroups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGatewayGroupsOutput) SetNextToken(v string) *ListGatewayGroupsOutput {
	s.NextToken = &v
	return s
}

type ListGatewaysInput struct {
	_ struct{} `type:"structure"`

	// The gateway group ARN for which to list gateways.
	GatewayGroupArn *string `type:"string"`

	// The maximum number of gateway summaries to return. The default is 50.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token used to paginate though multiple pages of gateway summaries.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGatewaysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGatewaysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGatewaysInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayGroupArn sets the GatewayGroupArn field's value.
func (s *ListGatewaysInput) SetGatewayGroupArn(v string) *ListGatewaysInput {
	s.GatewayGroupArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGatewaysInput) SetMaxResults(v int64) *ListGatewaysInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGatewaysInput) SetNextToken(v string) *ListGatewaysInput {
	s.NextToken = &v
	return s
}

type ListGatewaysOutput struct {
	_ struct{} `type:"structure"`

	// The gateways in the list.
	Gateways []*GatewaySummary `type:"list"`

	// The token used to paginate though multiple pages of gateway summaries.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGatewaysOutput) GoString() string {
	return s.String()
}

// SetGateways sets the Gateways field's value.
func (s *ListGatewaysOutput) SetGateways(v []*GatewaySummary) *ListGatewaysOutput {
	s.Gateways = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGatewaysOutput) SetNextToken(v string) *ListGatewaysOutput {
	s.NextToken = &v
	return s
}

type ListSkillsInput struct {
	_ struct{} `type:"structure"`

	// Whether the skill is enabled under the user's account.
	EnablementType *string `type:"string" enum:"EnablementTypeFilter"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`

	// The ARN of the skill group for which to list enabled skills.
	SkillGroupArn *string `type:"string"`

	// Whether the skill is publicly available or is a private skill.
	SkillType *string `type:"string" enum:"SkillTypeFilter"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSkillsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSkillsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSkillsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSkillsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnablementType sets the EnablementType field's value.
func (s *ListSkillsInput) SetEnablementType(v string) *ListSkillsInput {
	s.EnablementType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSkillsInput) SetMaxResults(v int64) *ListSkillsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSkillsInput) SetNextToken(v string) *ListSkillsInput {
	s.NextToken = &v
	return s
}

// SetSkillGroupArn sets the SkillGroupArn field's value.
func (s *ListSkillsInput) SetSkillGroupArn(v string) *ListSkillsInput {
	s.SkillGroupArn = &v
	return s
}

// SetSkillType sets the SkillType field's value.
func (s *ListSkillsInput) SetSkillType(v string) *ListSkillsInput {
	s.SkillType = &v
	return s
}

type ListSkillsOutput struct {
	_ struct{} `type:"structure"`

	// The token returned to indicate that there is more data available.
	NextToken *string `min:"1" type:"string"`

	// The list of enabled skills requested. Required.
	SkillSummaries []*SkillSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSkillsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSkillsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSkillsOutput) SetNextToken(v string) *ListSkillsOutput {
	s.NextToken = &v
	return s
}

// SetSkillSummaries sets the SkillSummaries field's value.
func (s *ListSkillsOutput) SetSkillSummaries(v []*SkillSummary) *ListSkillsOutput {
	s.SkillSummaries = v
	return s
}

type ListSkillsStoreCategoriesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of categories returned, per paginated calls.
	MaxResults *int64 `min:"1" type:"integer"`

	// The tokens used for pagination.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSkillsStoreCategoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSkillsStoreCategoriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSkillsStoreCategoriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSkillsStoreCategoriesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSkillsStoreCategoriesInput) SetMaxResults(v int64) *ListSkillsStoreCategoriesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSkillsStoreCategoriesInput) SetNextToken(v string) *ListSkillsStoreCategoriesInput {
	s.NextToken = &v
	return s
}

type ListSkillsStoreCategoriesOutput struct {
	_ struct{} `type:"structure"`

	// The list of categories.
	CategoryList []*Category `type:"list"`

	// The tokens used for pagination.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSkillsStoreCategoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSkillsStoreCategoriesOutput) GoString() string {
	return s.String()
}

// SetCategoryList sets the CategoryList field's value.
func (s *ListSkillsStoreCategoriesOutput) SetCategoryList(v []*Category) *ListSkillsStoreCategoriesOutput {
	s.CategoryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSkillsStoreCategoriesOutput) SetNextToken(v string) *ListSkillsStoreCategoriesOutput {
	s.NextToken = &v
	return s
}

type ListSkillsStoreSkillsByCategoryInput struct {
	_ struct{} `type:"structure"`

	// The category ID for which the skills are being retrieved from the skill store.
	//
	// CategoryId is a required field
	CategoryId *int64 `min:"1" type:"long" required:"true"`

	// The maximum number of skills returned per paginated calls.
	MaxResults *int64 `min:"1" type:"integer"`

	// The tokens used for pagination.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSkillsStoreSkillsByCategoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSkillsStoreSkillsByCategoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSkillsStoreSkillsByCategoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSkillsStoreSkillsByCategoryInput"}
	if s.CategoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("CategoryId"))
	}
	if s.CategoryId != nil && *s.CategoryId < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CategoryId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategoryId sets the CategoryId field's value.
func (s *ListSkillsStoreSkillsByCategoryInput) SetCategoryId(v int64) *ListSkillsStoreSkillsByCategoryInput {
	s.CategoryId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSkillsStoreSkillsByCategoryInput) SetMaxResults(v int64) *ListSkillsStoreSkillsByCategoryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSkillsStoreSkillsByCategoryInput) SetNextToken(v string) *ListSkillsStoreSkillsByCategoryInput {
	s.NextToken = &v
	return s
}

type ListSkillsStoreSkillsByCategoryOutput struct {
	_ struct{} `type:"structure"`

	// The tokens used for pagination.
	NextToken *string `min:"1" type:"string"`

	// The skill store skills.
	SkillsStoreSkills []*SkillsStoreSkill `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSkillsStoreSkillsByCategoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSkillsStoreSkillsByCategoryOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSkillsStoreSkillsByCategoryOutput) SetNextToken(v string) *ListSkillsStoreSkillsByCategoryOutput {
	s.NextToken = &v
	return s
}

// SetSkillsStoreSkills sets the SkillsStoreSkills field's value.
func (s *ListSkillsStoreSkillsByCategoryOutput) SetSkillsStoreSkills(v []*SkillsStoreSkill) *ListSkillsStoreSkillsByCategoryOutput {
	s.SkillsStoreSkills = v
	return s
}

type ListSmartHomeAppliancesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of appliances to be returned, per paginated calls.
	MaxResults *int64 `min:"1" type:"integer"`

	// The tokens used for pagination.
	NextToken *string `min:"1" type:"string"`

	// The room that the appliances are associated with.
	//
	// RoomArn is a required field
	RoomArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSmartHomeAppliancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSmartHomeAppliancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSmartHomeAppliancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSmartHomeAppliancesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.RoomArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoomArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSmartHomeAppliancesInput) SetMaxResults(v int64) *ListSmartHomeAppliancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSmartHomeAppliancesInput) SetNextToken(v string) *ListSmartHomeAppliancesInput {
	s.NextToken = &v
	return s
}

// SetRoomArn sets the RoomArn field's value.
func (s *ListSmartHomeAppliancesInput) SetRoomArn(v string) *ListSmartHomeAppliancesInput {
	s.RoomArn = &v
	return s
}

type ListSmartHomeAppliancesOutput struct {
	_ struct{} `type:"structure"`

	// The tokens used for pagination.
	NextToken *string `min:"1" type:"string"`

	// The smart home appliances.
	SmartHomeAppliances []*SmartHomeAppliance `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSmartHomeAppliancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSmartHomeAppliancesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSmartHomeAppliancesOutput) SetNextToken(v string) *ListSmartHomeAppliancesOutput {
	s.NextToken = &v
	return s
}

// SetSmartHomeAppliances sets the SmartHomeAppliances field's value.
func (s *ListSmartHomeAppliancesOutput) SetSmartHomeAppliances(v []*SmartHomeAppliance) *ListSmartHomeAppliancesOutput {
	s.SmartHomeAppliances = v
	return s
}

type ListTagsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the specified resource for which to list tags.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListTagsInput) SetArn(v string) *ListTagsInput {
	s.Arn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsInput) SetMaxResults(v int64) *ListTagsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsInput) SetNextToken(v string) *ListTagsInput {
	s.NextToken = &v
	return s
}

type ListTagsOutput struct {
	_ struct{} `type:"structure"`

	// The token returned to indicate that there is more data available.
	NextToken *string `min:"1" type:"string"`

	// The tags requested for the specified resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsOutput) SetNextToken(v string) *ListTagsOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsOutput) SetTags(v []*Tag) *ListTagsOutput {
	s.Tags = v
	return s
}

// Meeting room settings of a room profile.
type MeetingRoomConfiguration struct {
	_ struct{} `type:"structure"`

	// Settings for the end of meeting reminder feature that are applied to a room
	// profile. The end of meeting reminder enables Alexa to remind users when a
	// meeting is ending.
	EndOfMeetingReminder *EndOfMeetingReminder `type:"structure"`

	// Settings to automatically book the room if available for a configured duration
	// when joining a meeting with Alexa.
	InstantBooking *InstantBooking `type:"structure"`

	// Settings for requiring a check in when a room is reserved. Alexa can cancel
	// a room reservation if it's not checked into. This makes the room available
	// for others. Users can check in by joining the meeting with Alexa or an AVS
	// device, or by saying “Alexa, check in.”
	RequireCheckIn *RequireCheckIn `type:"structure"`

	// Whether room utilization metrics are enabled or not.
	RoomUtilizationMetricsEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeetingRoomConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeetingRoomConfiguration) GoString() string {
	return s.String()
}

// SetEndOfMeetingReminder sets the EndOfMeetingReminder field's value.
func (s *MeetingRoomConfiguration) SetEndOfMeetingReminder(v *EndOfMeetingReminder) *MeetingRoomConfiguration {
	s.EndOfMeetingReminder = v
	return s
}

// SetInstantBooking sets the InstantBooking field's value.
func (s *MeetingRoomConfiguration) SetInstantBooking(v *InstantBooking) *MeetingRoomConfiguration {
	s.InstantBooking = v
	return s
}

// SetRequireCheckIn sets the RequireCheckIn field's value.
func (s *MeetingRoomConfiguration) SetRequireCheckIn(v *RequireCheckIn) *MeetingRoomConfiguration {
	s.RequireCheckIn = v
	return s
}

// SetRoomUtilizationMetricsEnabled sets the RoomUtilizationMetricsEnabled field's value.
func (s *MeetingRoomConfiguration) SetRoomUtilizationMetricsEnabled(v bool) *MeetingRoomConfiguration {
	s.RoomUtilizationMetricsEnabled = &v
	return s
}

// The values that indicate whether a pin is always required (YES), never required
// (NO), or OPTIONAL.
//
//    * If YES, Alexa will always ask for a meeting pin.
//
//    * If NO, Alexa will never ask for a meeting pin.
//
//    * If OPTIONAL, Alexa will ask if you have a meeting pin and if the customer
//    responds with yes, it will ask for the meeting pin.
type MeetingSetting struct {
	_ struct{} `type:"structure"`

	// The values that indicate whether the pin is always required.
	//
	// RequirePin is a required field
	RequirePin *string `type:"string" required:"true" enum:"RequirePin"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeetingSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeetingSetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MeetingSetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MeetingSetting"}
	if s.RequirePin == nil {
		invalidParams.Add(request.NewErrParamRequired("RequirePin"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRequirePin sets the RequirePin field's value.
func (s *MeetingSetting) SetRequirePin(v string) *MeetingSetting {
	s.RequirePin = &v
	return s
}

// The name sent in the request is already in use.
type NameInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NameInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NameInUseException) GoString() string {
	return s.String()
}

func newErrorNameInUseException(v protocol.ResponseMetadata) error {
	return &NameInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NameInUseException) Code() string {
	return "NameInUseException"
}

// Message returns the exception's message.
func (s *NameInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NameInUseException) OrigErr() error {
	return nil
}

func (s *NameInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NameInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NameInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The network profile associated with a device.
type NetworkProfile struct {
	_ struct{} `type:"structure"`

	// The ARN of the Private Certificate Authority (PCA) created in AWS Certificate
	// Manager (ACM). This is used to issue certificates to the devices.
	CertificateAuthorityArn *string `type:"string"`

	// The current password of the Wi-Fi network.
	//
	// CurrentPassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by NetworkProfile's
	// String and GoString methods.
	CurrentPassword *string `min:"5" type:"string" sensitive:"true"`

	// Detailed information about a device's network profile.
	Description *string `type:"string"`

	// The authentication standard that is used in the EAP framework. Currently,
	// EAP_TLS is supported.
	EapMethod *string `type:"string" enum:"NetworkEapMethod"`

	// The ARN of the network profile associated with a device.
	NetworkProfileArn *string `type:"string"`

	// The name of the network profile associated with a device.
	NetworkProfileName *string `min:"1" type:"string"`

	// The next, or subsequent, password of the Wi-Fi network. This password is
	// asynchronously transmitted to the device and is used when the password of
	// the network changes to NextPassword.
	//
	// NextPassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by NetworkProfile's
	// String and GoString methods.
	NextPassword *string `type:"string" sensitive:"true"`

	// The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK,
	// WPA_PSK, WEP, or OPEN.
	SecurityType *string `type:"string" enum:"NetworkSecurityType"`

	// The SSID of the Wi-Fi network.
	Ssid *string `min:"1" type:"string"`

	// The root certificates of your authentication server, which is installed on
	// your devices and used to trust your authentication server during EAP negotiation.
	TrustAnchors []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkProfile) GoString() string {
	return s.String()
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *NetworkProfile) SetCertificateAuthorityArn(v string) *NetworkProfile {
	s.CertificateAuthorityArn = &v
	return s
}

// SetCurrentPassword sets the CurrentPassword field's value.
func (s *NetworkProfile) SetCurrentPassword(v string) *NetworkProfile {
	s.CurrentPassword = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *NetworkProfile) SetDescription(v string) *NetworkProfile {
	s.Description = &v
	return s
}

// SetEapMethod sets the EapMethod field's value.
func (s *NetworkProfile) SetEapMethod(v string) *NetworkProfile {
	s.EapMethod = &v
	return s
}

// SetNetworkProfileArn sets the NetworkProfileArn field's value.
func (s *NetworkProfile) SetNetworkProfileArn(v string) *NetworkProfile {
	s.NetworkProfileArn = &v
	return s
}

// SetNetworkProfileName sets the NetworkProfileName field's value.
func (s *NetworkProfile) SetNetworkProfileName(v string) *NetworkProfile {
	s.NetworkProfileName = &v
	return s
}

// SetNextPassword sets the NextPassword field's value.
func (s *NetworkProfile) SetNextPassword(v string) *NetworkProfile {
	s.NextPassword = &v
	return s
}

// SetSecurityType sets the SecurityType field's value.
func (s *NetworkProfile) SetSecurityType(v string) *NetworkProfile {
	s.SecurityType = &v
	return s
}

// SetSsid sets the Ssid field's value.
func (s *NetworkProfile) SetSsid(v string) *NetworkProfile {
	s.Ssid = &v
	return s
}

// SetTrustAnchors sets the TrustAnchors field's value.
func (s *NetworkProfile) SetTrustAnchors(v []*string) *NetworkProfile {
	s.TrustAnchors = v
	return s
}

// The data associated with a network profile.
type NetworkProfileData struct {
	_ struct{} `type:"structure"`

	// The ARN of the Private Certificate Authority (PCA) created in AWS Certificate
	// Manager (ACM). This is used to issue certificates to the devices.
	CertificateAuthorityArn *string `type:"string"`

	// Detailed information about a device's network profile.
	Description *string `type:"string"`

	// The authentication standard that is used in the EAP framework. Currently,
	// EAP_TLS is supported.
	EapMethod *string `type:"string" enum:"NetworkEapMethod"`

	// The ARN of the network profile associated with a device.
	NetworkProfileArn *string `type:"string"`

	// The name of the network profile associated with a device.
	NetworkProfileName *string `min:"1" type:"string"`

	// The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK,
	// WPA_PSK, WEP, or OPEN.
	SecurityType *string `type:"string" enum:"NetworkSecurityType"`

	// The SSID of the Wi-Fi network.
	Ssid *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkProfileData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkProfileData) GoString() string {
	return s.String()
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *NetworkProfileData) SetCertificateAuthorityArn(v string) *NetworkProfileData {
	s.CertificateAuthorityArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *NetworkProfileData) SetDescription(v string) *NetworkProfileData {
	s.Description = &v
	return s
}

// SetEapMethod sets the EapMethod field's value.
func (s *NetworkProfileData) SetEapMethod(v string) *NetworkProfileData {
	s.EapMethod = &v
	return s
}

// SetNetworkProfileArn sets the NetworkProfileArn field's value.
func (s *NetworkProfileData) SetNetworkProfileArn(v string) *NetworkProfileData {
	s.NetworkProfileArn = &v
	return s
}

// SetNetworkProfileName sets the NetworkProfileName field's value.
func (s *NetworkProfileData) SetNetworkProfileName(v string) *NetworkProfileData {
	s.NetworkProfileName = &v
	return s
}

// SetSecurityType sets the SecurityType field's value.
func (s *NetworkProfileData) SetSecurityType(v string) *NetworkProfileData {
	s.SecurityType = &v
	return s
}

// SetSsid sets the Ssid field's value.
func (s *NetworkProfileData) SetSsid(v string) *NetworkProfileData {
	s.Ssid = &v
	return s
}

// The resource is not found.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The information for public switched telephone network (PSTN) conferencing.
type PSTNDialIn struct {
	_ struct{} `type:"structure"`

	// The zip code.
	//
	// CountryCode is a required field
	CountryCode *string `type:"string" required:"true"`

	// The delay duration before Alexa enters the conference ID with dual-tone multi-frequency
	// (DTMF). Each number on the dial pad corresponds to a DTMF tone, which is
	// how we send data over the telephone network.
	//
	// OneClickIdDelay is a required field
	OneClickIdDelay *string `min:"1" type:"string" required:"true"`

	// The delay duration before Alexa enters the conference pin with dual-tone
	// multi-frequency (DTMF). Each number on the dial pad corresponds to a DTMF
	// tone, which is how we send data over the telephone network.
	//
	// OneClickPinDelay is a required field
	OneClickPinDelay *string `min:"1" type:"string" required:"true"`

	// The phone number to call to join the conference.
	//
	// PhoneNumber is a required field
	PhoneNumber *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PSTNDialIn) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PSTNDialIn) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PSTNDialIn) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PSTNDialIn"}
	if s.CountryCode == nil {
		invalidParams.Add(request.NewErrParamRequired("CountryCode"))
	}
	if s.OneClickIdDelay == nil {
		invalidParams.Add(request.NewErrParamRequired("OneClickIdDelay"))
	}
	if s.OneClickIdDelay != nil && len(*s.OneClickIdDelay) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OneClickIdDelay", 1))
	}
	if s.OneClickPinDelay == nil {
		invalidParams.Add(request.NewErrParamRequired("OneClickPinDelay"))
	}
	if s.OneClickPinDelay != nil && len(*s.OneClickPinDelay) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OneClickPinDelay", 1))
	}
	if s.PhoneNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCountryCode sets the CountryCode field's value.
func (s *PSTNDialIn) SetCountryCode(v string) *PSTNDialIn {
	s.CountryCode = &v
	return s
}

// SetOneClickIdDelay sets the OneClickIdDelay field's value.
func (s *PSTNDialIn) SetOneClickIdDelay(v string) *PSTNDialIn {
	s.OneClickIdDelay = &v
	return s
}

// SetOneClickPinDelay sets the OneClickPinDelay field's value.
func (s *PSTNDialIn) SetOneClickPinDelay(v string) *PSTNDialIn {
	s.OneClickPinDelay = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *PSTNDialIn) SetPhoneNumber(v string) *PSTNDialIn {
	s.PhoneNumber = &v
	return s
}

// The phone number for the contact containing the raw number and phone number
// type.
type PhoneNumber struct {
	_ struct{} `type:"structure"`

	// The raw value of the phone number.
	//
	// Number is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PhoneNumber's
	// String and GoString methods.
	//
	// Number is a required field
	Number *string `type:"string" required:"true" sensitive:"true"`

	// The type of the phone number.
	//
	// Type is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PhoneNumber's
	// String and GoString methods.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"PhoneNumberType" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhoneNumber) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PhoneNumber) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PhoneNumber) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PhoneNumber"}
	if s.Number == nil {
		invalidParams.Add(request.NewErrParamRequired("Number"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNumber sets the Number field's value.
func (s *PhoneNumber) SetNumber(v string) *PhoneNumber {
	s.Number = &v
	return s
}

// SetType sets the Type field's value.
func (s *PhoneNumber) SetType(v string) *PhoneNumber {
	s.Type = &v
	return s
}

// A room profile with attributes.
type Profile struct {
	_ struct{} `type:"structure"`

	// The address of a room profile.
	Address *string `min:"1" type:"string"`

	// The ARN of the address book.
	AddressBookArn *string `type:"string"`

	// Whether data retention of the profile is enabled.
	DataRetentionOptIn *bool `type:"boolean"`

	// The distance unit of a room profile.
	DistanceUnit *string `type:"string" enum:"DistanceUnit"`

	// Retrieves if the profile is default or not.
	IsDefault *bool `type:"boolean"`

	// The locale of a room profile. (This is currently available only to a limited
	// preview audience.)
	Locale *string `min:"1" type:"string"`

	// The max volume limit of a room profile.
	MaxVolumeLimit *int64 `type:"integer"`

	// Meeting room settings of a room profile.
	MeetingRoomConfiguration *MeetingRoomConfiguration `type:"structure"`

	// The PSTN setting of a room profile.
	PSTNEnabled *bool `type:"boolean"`

	// The ARN of a room profile.
	ProfileArn *string `type:"string"`

	// The name of a room profile.
	ProfileName *string `min:"1" type:"string"`

	// The setup mode of a room profile.
	SetupModeDisabled *bool `type:"boolean"`

	// The temperature unit of a room profile.
	TemperatureUnit *string `type:"string" enum:"TemperatureUnit"`

	// The time zone of a room profile.
	Timezone *string `min:"1" type:"string"`

	// The wake word of a room profile.
	WakeWord *string `type:"string" enum:"WakeWord"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Profile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Profile) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *Profile) SetAddress(v string) *Profile {
	s.Address = &v
	return s
}

// SetAddressBookArn sets the AddressBookArn field's value.
func (s *Profile) SetAddressBookArn(v string) *Profile {
	s.AddressBookArn = &v
	return s
}

// SetDataRetentionOptIn sets the DataRetentionOptIn field's value.
func (s *Profile) SetDataRetentionOptIn(v bool) *Profile {
	s.DataRetentionOptIn = &v
	return s
}

// SetDistanceUnit sets the DistanceUnit field's value.
func (s *Profile) SetDistanceUnit(v string) *Profile {
	s.DistanceUnit = &v
	return s
}

// SetIsDefault sets the IsDefault field's value.
func (s *Profile) SetIsDefault(v bool) *Profile {
	s.IsDefault = &v
	return s
}

// SetLocale sets the Locale field's value.
func (s *Profile) SetLocale(v string) *Profile {
	s.Locale = &v
	return s
}

// SetMaxVolumeLimit sets the MaxVolumeLimit field's value.
func (s *Profile) SetMaxVolumeLimit(v int64) *Profile {
	s.MaxVolumeLimit = &v
	return s
}

// SetMeetingRoomConfiguration sets the MeetingRoomConfiguration field's value.
func (s *Profile) SetMeetingRoomConfiguration(v *MeetingRoomConfiguration) *Profile {
	s.MeetingRoomConfiguration = v
	return s
}

// SetPSTNEnabled sets the PSTNEnabled field's value.
func (s *Profile) SetPSTNEnabled(v bool) *Profile {
	s.PSTNEnabled = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *Profile) SetProfileArn(v string) *Profile {
	s.ProfileArn = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *Profile) SetProfileName(v string) *Profile {
	s.ProfileName = &v
	return s
}

// SetSetupModeDisabled sets the SetupModeDisabled field's value.
func (s *Profile) SetSetupModeDisabled(v bool) *Profile {
	s.SetupModeDisabled = &v
	return s
}

// SetTemperatureUnit sets the TemperatureUnit field's value.
func (s *Profile) SetTemperatureUnit(v string) *Profile {
	s.TemperatureUnit = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *Profile) SetTimezone(v string) *Profile {
	s.Timezone = &v
	return s
}

// SetWakeWord sets the WakeWord field's value.
func (s *Profile) SetWakeWord(v string) *Profile {
	s.WakeWord = &v
	return s
}

// The data of a room profile.
type ProfileData struct {
	_ struct{} `type:"structure"`

	// The address of a room profile.
	Address *string `min:"1" type:"string"`

	// The distance unit of a room profile.
	DistanceUnit *string `type:"string" enum:"DistanceUnit"`

	// Retrieves if the profile data is default or not.
	IsDefault *bool `type:"boolean"`

	// The locale of a room profile. (This is currently available only to a limited
	// preview audience.)
	Locale *string `min:"1" type:"string"`

	// The ARN of a room profile.
	ProfileArn *string `type:"string"`

	// The name of a room profile.
	ProfileName *string `min:"1" type:"string"`

	// The temperature unit of a room profile.
	TemperatureUnit *string `type:"string" enum:"TemperatureUnit"`

	// The time zone of a room profile.
	Timezone *string `min:"1" type:"string"`

	// The wake word of a room profile.
	WakeWord *string `type:"string" enum:"WakeWord"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileData) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *ProfileData) SetAddress(v string) *ProfileData {
	s.Address = &v
	return s
}

// SetDistanceUnit sets the DistanceUnit field's value.
func (s *ProfileData) SetDistanceUnit(v string) *ProfileData {
	s.DistanceUnit = &v
	return s
}

// SetIsDefault sets the IsDefault field's value.
func (s *ProfileData) SetIsDefault(v bool) *ProfileData {
	s.IsDefault = &v
	return s
}

// SetLocale sets the Locale field's value.
func (s *ProfileData) SetLocale(v string) *ProfileData {
	s.Locale = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *ProfileData) SetProfileArn(v string) *ProfileData {
	s.ProfileArn = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *ProfileData) SetProfileName(v string) *ProfileData {
	s.ProfileName = &v
	return s
}

// SetTemperatureUnit sets the TemperatureUnit field's value.
func (s *ProfileData) SetTemperatureUnit(v string) *ProfileData {
	s.TemperatureUnit = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *ProfileData) SetTimezone(v string) *ProfileData {
	s.Timezone = &v
	return s
}

// SetWakeWord sets the WakeWord field's value.
func (s *ProfileData) SetWakeWord(v string) *ProfileData {
	s.WakeWord = &v
	return s
}

type PutConferencePreferenceInput struct {
	_ struct{} `type:"structure"`

	// The conference preference of a specific conference provider.
	//
	// ConferencePreference is a required field
	ConferencePreference *ConferencePreference `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutConferencePreferenceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutConferencePreferenceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutConferencePreferenceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutConferencePreferenceInput"}
	if s.ConferencePreference == nil {
		invalidParams.Add(request.NewErrParamRequired("ConferencePreference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConferencePreference sets the ConferencePreference field's value.
func (s *PutConferencePreferenceInput) SetConferencePreference(v *ConferencePreference) *PutConferencePreferenceInput {
	s.ConferencePreference = v
	return s
}

type PutConferencePreferenceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutConferencePreferenceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutConferencePreferenceOutput) GoString() string {
	return s.String()
}

type PutInvitationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The email ID of the organization or individual contact that the enrolled
	// user can use.
	ContactEmail *string `min:"1" type:"string"`

	// The name of the organization sending the enrollment invite to a user.
	//
	// OrganizationName is a required field
	OrganizationName *string `min:"1" type:"string" required:"true"`

	// The list of private skill IDs that you want to recommend to the user to enable
	// in the invitation.
	PrivateSkillIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutInvitationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutInvitationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutInvitationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutInvitationConfigurationInput"}
	if s.ContactEmail != nil && len(*s.ContactEmail) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactEmail", 1))
	}
	if s.OrganizationName == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationName"))
	}
	if s.OrganizationName != nil && len(*s.OrganizationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactEmail sets the ContactEmail field's value.
func (s *PutInvitationConfigurationInput) SetContactEmail(v string) *PutInvitationConfigurationInput {
	s.ContactEmail = &v
	return s
}

// SetOrganizationName sets the OrganizationName field's value.
func (s *PutInvitationConfigurationInput) SetOrganizationName(v string) *PutInvitationConfigurationInput {
	s.OrganizationName = &v
	return s
}

// SetPrivateSkillIds sets the PrivateSkillIds field's value.
func (s *PutInvitationConfigurationInput) SetPrivateSkillIds(v []*string) *PutInvitationConfigurationInput {
	s.PrivateSkillIds = v
	return s
}

type PutInvitationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutInvitationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutInvitationConfigurationOutput) GoString() string {
	return s.String()
}

type PutRoomSkillParameterInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the room associated with the room skill parameter. Required.
	RoomArn *string `type:"string"`

	// The updated room skill parameter. Required.
	//
	// RoomSkillParameter is a required field
	RoomSkillParameter *RoomSkillParameter `type:"structure" required:"true"`

	// The ARN of the skill associated with the room skill parameter. Required.
	//
	// SkillId is a required field
	SkillId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRoomSkillParameterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRoomSkillParameterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRoomSkillParameterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRoomSkillParameterInput"}
	if s.RoomSkillParameter == nil {
		invalidParams.Add(request.NewErrParamRequired("RoomSkillParameter"))
	}
	if s.SkillId == nil {
		invalidParams.Add(request.NewErrParamRequired("SkillId"))
	}
	if s.RoomSkillParameter != nil {
		if err := s.RoomSkillParameter.Validate(); err != nil {
			invalidParams.AddNested("RoomSkillParameter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoomArn sets the RoomArn field's value.
func (s *PutRoomSkillParameterInput) SetRoomArn(v string) *PutRoomSkillParameterInput {
	s.RoomArn = &v
	return s
}

// SetRoomSkillParameter sets the RoomSkillParameter field's value.
func (s *PutRoomSkillParameterInput) SetRoomSkillParameter(v *RoomSkillParameter) *PutRoomSkillParameterInput {
	s.RoomSkillParameter = v
	return s
}

// SetSkillId sets the SkillId field's value.
func (s *PutRoomSkillParameterInput) SetSkillId(v string) *PutRoomSkillParameterInput {
	s.SkillId = &v
	return s
}

type PutRoomSkillParameterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRoomSkillParameterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRoomSkillParameterOutput) GoString() string {
	return s.String()
}

type PutSkillAuthorizationInput struct {
	_ struct{} `type:"structure"`

	// The authorization result specific to OAUTH code grant output. "Code” must
	// be populated in the AuthorizationResult map to establish the authorization.
	//
	// AuthorizationResult is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PutSkillAuthorizationInput's
	// String and GoString methods.
	//
	// AuthorizationResult is a required field
	AuthorizationResult map[string]*string `type:"map" required:"true" sensitive:"true"`

	// The room that the skill is authorized for.
	RoomArn *string `type:"string"`

	// The unique identifier of a skill.
	//
	// SkillId is a required field
	SkillId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSkillAuthorizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSkillAuthorizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutSkillAuthorizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutSkillAuthorizationInput"}
	if s.AuthorizationResult == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizationResult"))
	}
	if s.SkillId == nil {
		invalidParams.Add(request.NewErrParamRequired("SkillId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizationResult sets the AuthorizationResult field's value.
func (s *PutSkillAuthorizationInput) SetAuthorizationResult(v map[string]*string) *PutSkillAuthorizationInput {
	s.AuthorizationResult = v
	return s
}

// SetRoomArn sets the RoomArn field's value.
func (s *PutSkillAuthorizationInput) SetRoomArn(v string) *PutSkillAuthorizationInput {
	s.RoomArn = &v
	return s
}

// SetSkillId sets the SkillId field's value.
func (s *PutSkillAuthorizationInput) SetSkillId(v string) *PutSkillAuthorizationInput {
	s.SkillId = &v
	return s
}

type PutSkillAuthorizationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSkillAuthorizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSkillAuthorizationOutput) GoString() string {
	return s.String()
}

type RegisterAVSDeviceInput struct {
	_ struct{} `type:"structure"`

	// The device type ID for your AVS device generated by Amazon when the OEM creates
	// a new product on Amazon's Developer Console.
	//
	// AmazonId is a required field
	AmazonId *string `type:"string" required:"true"`

	// The client ID of the OEM used for code-based linking authorization on an
	// AVS device.
	//
	// ClientId is a required field
	ClientId *string `type:"string" required:"true"`

	// The key generated by the OEM that uniquely identifies a specified instance
	// of your AVS device.
	DeviceSerialNumber *string `type:"string"`

	// The product ID used to identify your AVS device during authorization.
	//
	// ProductId is a required field
	ProductId *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the room with which to associate your AVS
	// device.
	RoomArn *string `type:"string"`

	// The tags to be added to the specified resource. Do not provide system tags.
	Tags []*Tag `type:"list"`

	// The code that is obtained after your AVS device has made a POST request to
	// LWA as a part of the Device Authorization Request component of the OAuth
	// code-based linking specification.
	//
	// UserCode is a required field
	UserCode *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterAVSDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterAVSDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterAVSDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterAVSDeviceInput"}
	if s.AmazonId == nil {
		invalidParams.Add(request.NewErrParamRequired("AmazonId"))
	}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ProductId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductId"))
	}
	if s.UserCode == nil {
		invalidParams.Add(request.NewErrParamRequired("UserCode"))
	}
	if s.UserCode != nil && len(*s.UserCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserCode", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmazonId sets the AmazonId field's value.
func (s *RegisterAVSDeviceInput) SetAmazonId(v string) *RegisterAVSDeviceInput {
	s.AmazonId = &v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *RegisterAVSDeviceInput) SetClientId(v string) *RegisterAVSDeviceInput {
	s.ClientId = &v
	return s
}

// SetDeviceSerialNumber sets the DeviceSerialNumber field's value.
func (s *RegisterAVSDeviceInput) SetDeviceSerialNumber(v string) *RegisterAVSDeviceInput {
	s.DeviceSerialNumber = &v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *RegisterAVSDeviceInput) SetProductId(v string) *RegisterAVSDeviceInput {
	s.ProductId = &v
	return s
}

// SetRoomArn sets the RoomArn field's value.
func (s *RegisterAVSDeviceInput) SetRoomArn(v string) *RegisterAVSDeviceInput {
	s.RoomArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RegisterAVSDeviceInput) SetTags(v []*Tag) *RegisterAVSDeviceInput {
	s.Tags = v
	return s
}

// SetUserCode sets the UserCode field's value.
func (s *RegisterAVSDeviceInput) SetUserCode(v string) *RegisterAVSDeviceInput {
	s.UserCode = &v
	return s
}

type RegisterAVSDeviceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the device.
	DeviceArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterAVSDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterAVSDeviceOutput) GoString() string {
	return s.String()
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *RegisterAVSDeviceOutput) SetDeviceArn(v string) *RegisterAVSDeviceOutput {
	s.DeviceArn = &v
	return s
}

type RejectSkillInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the skill.
	//
	// SkillId is a required field
	SkillId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectSkillInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectSkillInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RejectSkillInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RejectSkillInput"}
	if s.SkillId == nil {
		invalidParams.Add(request.NewErrParamRequired("SkillId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSkillId sets the SkillId field's value.
func (s *RejectSkillInput) SetSkillId(v string) *RejectSkillInput {
	s.SkillId = &v
	return s
}

type RejectSkillOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectSkillOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectSkillOutput) GoString() string {
	return s.String()
}

// Settings for the require check in feature that are applied to a room profile.
// Require check in allows a meeting room’s Alexa or AVS device to prompt
// the user to check in; otherwise, the room will be released.
type RequireCheckIn struct {
	_ struct{} `type:"structure"`

	// Whether require check in is enabled or not.
	Enabled *bool `type:"boolean"`

	// Duration between 5 and 20 minutes to determine when to release the room if
	// it's not checked into.
	ReleaseAfterMinutes *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequireCheckIn) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequireCheckIn) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *RequireCheckIn) SetEnabled(v bool) *RequireCheckIn {
	s.Enabled = &v
	return s
}

// SetReleaseAfterMinutes sets the ReleaseAfterMinutes field's value.
func (s *RequireCheckIn) SetReleaseAfterMinutes(v int64) *RequireCheckIn {
	s.ReleaseAfterMinutes = &v
	return s
}

type ResolveRoomInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the skill that was requested. Required.
	//
	// SkillId is a required field
	SkillId *string `type:"string" required:"true"`

	// The ARN of the user. Required.
	//
	// UserId is a required field
	UserId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolveRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolveRoomInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResolveRoomInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResolveRoomInput"}
	if s.SkillId == nil {
		invalidParams.Add(request.NewErrParamRequired("SkillId"))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSkillId sets the SkillId field's value.
func (s *ResolveRoomInput) SetSkillId(v string) *ResolveRoomInput {
	s.SkillId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *ResolveRoomInput) SetUserId(v string) *ResolveRoomInput {
	s.UserId = &v
	return s
}

type ResolveRoomOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the room from which the skill request was invoked.
	RoomArn *string `type:"string"`

	// The name of the room from which the skill request was invoked.
	RoomName *string `min:"1" type:"string"`

	// Response to get the room profile request. Required.
	RoomSkillParameters []*RoomSkillParameter `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolveRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolveRoomOutput) GoString() string {
	return s.String()
}

// SetRoomArn sets the RoomArn field's value.
func (s *ResolveRoomOutput) SetRoomArn(v string) *ResolveRoomOutput {
	s.RoomArn = &v
	return s
}

// SetRoomName sets the RoomName field's value.
func (s *ResolveRoomOutput) SetRoomName(v string) *ResolveRoomOutput {
	s.RoomName = &v
	return s
}

// SetRoomSkillParameters sets the RoomSkillParameters field's value.
func (s *ResolveRoomOutput) SetRoomSkillParameters(v []*RoomSkillParameter) *ResolveRoomOutput {
	s.RoomSkillParameters = v
	return s
}

// Another resource is associated with the resource in the request.
type ResourceAssociatedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAssociatedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAssociatedException) GoString() string {
	return s.String()
}

func newErrorResourceAssociatedException(v protocol.ResponseMetadata) error {
	return &ResourceAssociatedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAssociatedException) Code() string {
	return "ResourceAssociatedException"
}

// Message returns the exception's message.
func (s *ResourceAssociatedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAssociatedException) OrigErr() error {
	return nil
}

func (s *ResourceAssociatedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAssociatedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAssociatedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource in the request is already in use.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A unique, user-specified identifier for the request that ensures idempotency.
	ClientRequestToken *string `min:"10" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

type RevokeInvitationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the enrollment invitation to revoke. Required.
	EnrollmentId *string `type:"string"`

	// The ARN of the user for whom to revoke an enrollment invitation. Required.
	UserArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeInvitationInput) GoString() string {
	return s.String()
}

// SetEnrollmentId sets the EnrollmentId field's value.
func (s *RevokeInvitationInput) SetEnrollmentId(v string) *RevokeInvitationInput {
	s.EnrollmentId = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *RevokeInvitationInput) SetUserArn(v string) *RevokeInvitationInput {
	s.UserArn = &v
	return s
}

type RevokeInvitationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeInvitationOutput) GoString() string {
	return s.String()
}

// A room with attributes.
type Room struct {
	_ struct{} `type:"structure"`

	// The description of a room.
	Description *string `min:"1" type:"string"`

	// The profile ARN of a room.
	ProfileArn *string `type:"string"`

	// The provider calendar ARN of a room.
	ProviderCalendarId *string `type:"string"`

	// The ARN of a room.
	RoomArn *string `type:"string"`

	// The name of a room.
	RoomName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Room) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Room) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Room) SetDescription(v string) *Room {
	s.Description = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *Room) SetProfileArn(v string) *Room {
	s.ProfileArn = &v
	return s
}

// SetProviderCalendarId sets the ProviderCalendarId field's value.
func (s *Room) SetProviderCalendarId(v string) *Room {
	s.ProviderCalendarId = &v
	return s
}

// SetRoomArn sets the RoomArn field's value.
func (s *Room) SetRoomArn(v string) *Room {
	s.RoomArn = &v
	return s
}

// SetRoomName sets the RoomName field's value.
func (s *Room) SetRoomName(v string) *Room {
	s.RoomName = &v
	return s
}

// The data of a room.
type RoomData struct {
	_ struct{} `type:"structure"`

	// The description of a room.
	Description *string `min:"1" type:"string"`

	// The profile ARN of a room.
	ProfileArn *string `type:"string"`

	// The profile name of a room.
	ProfileName *string `min:"1" type:"string"`

	// The provider calendar ARN of a room.
	ProviderCalendarId *string `type:"string"`

	// The ARN of a room.
	RoomArn *string `type:"string"`

	// The name of a room.
	RoomName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RoomData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RoomData) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *RoomData) SetDescription(v string) *RoomData {
	s.Description = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *RoomData) SetProfileArn(v string) *RoomData {
	s.ProfileArn = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *RoomData) SetProfileName(v string) *RoomData {
	s.ProfileName = &v
	return s
}

// SetProviderCalendarId sets the ProviderCalendarId field's value.
func (s *RoomData) SetProviderCalendarId(v string) *RoomData {
	s.ProviderCalendarId = &v
	return s
}

// SetRoomArn sets the RoomArn field's value.
func (s *RoomData) SetRoomArn(v string) *RoomData {
	s.RoomArn = &v
	return s
}

// SetRoomName sets the RoomName field's value.
func (s *RoomData) SetRoomName(v string) *RoomData {
	s.RoomName = &v
	return s
}

// A skill parameter associated with a room.
type RoomSkillParameter struct {
	_ struct{} `type:"structure"`

	// The parameter key of a room skill parameter. ParameterKey is an enumerated
	// type that only takes “DEFAULT” or “SCOPE” as valid values.
	//
	// ParameterKey is a required field
	ParameterKey *string `min:"1" type:"string" required:"true"`

	// The parameter value of a room skill parameter.
	//
	// ParameterValue is a required field
	ParameterValue *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RoomSkillParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RoomSkillParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RoomSkillParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RoomSkillParameter"}
	if s.ParameterKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterKey"))
	}
	if s.ParameterKey != nil && len(*s.ParameterKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParameterKey", 1))
	}
	if s.ParameterValue == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterValue"))
	}
	if s.ParameterValue != nil && len(*s.ParameterValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParameterValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameterKey sets the ParameterKey field's value.
func (s *RoomSkillParameter) SetParameterKey(v string) *RoomSkillParameter {
	s.ParameterKey = &v
	return s
}

// SetParameterValue sets the ParameterValue field's value.
func (s *RoomSkillParameter) SetParameterValue(v string) *RoomSkillParameter {
	s.ParameterValue = &v
	return s
}

type SearchAddressBooksInput struct {
	_ struct{} `type:"structure"`

	// The filters to use to list a specified set of address books. The supported
	// filter key is AddressBookName.
	Filters []*Filter `type:"list"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// only includes results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`

	// The sort order to use in listing the specified set of address books. The
	// supported sort key is AddressBookName.
	SortCriteria []*Sort `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchAddressBooksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchAddressBooksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchAddressBooksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchAddressBooksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SortCriteria != nil {
		for i, v := range s.SortCriteria {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortCriteria", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SearchAddressBooksInput) SetFilters(v []*Filter) *SearchAddressBooksInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchAddressBooksInput) SetMaxResults(v int64) *SearchAddressBooksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchAddressBooksInput) SetNextToken(v string) *SearchAddressBooksInput {
	s.NextToken = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *SearchAddressBooksInput) SetSortCriteria(v []*Sort) *SearchAddressBooksInput {
	s.SortCriteria = v
	return s
}

type SearchAddressBooksOutput struct {
	_ struct{} `type:"structure"`

	// The address books that meet the specified set of filter criteria, in sort
	// order.
	AddressBooks []*AddressBookData `type:"list"`

	// The token returned to indicate that there is more data available.
	NextToken *string `min:"1" type:"string"`

	// The total number of address books returned.
	TotalCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchAddressBooksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchAddressBooksOutput) GoString() string {
	return s.String()
}

// SetAddressBooks sets the AddressBooks field's value.
func (s *SearchAddressBooksOutput) SetAddressBooks(v []*AddressBookData) *SearchAddressBooksOutput {
	s.AddressBooks = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchAddressBooksOutput) SetNextToken(v string) *SearchAddressBooksOutput {
	s.NextToken = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *SearchAddressBooksOutput) SetTotalCount(v int64) *SearchAddressBooksOutput {
	s.TotalCount = &v
	return s
}

type SearchContactsInput struct {
	_ struct{} `type:"structure"`

	// The filters to use to list a specified set of address books. The supported
	// filter keys are DisplayName, FirstName, LastName, and AddressBookArns.
	Filters []*Filter `type:"list"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// only includes results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`

	// The sort order to use in listing the specified set of contacts. The supported
	// sort keys are DisplayName, FirstName, and LastName.
	SortCriteria []*Sort `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchContactsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchContactsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchContactsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchContactsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SortCriteria != nil {
		for i, v := range s.SortCriteria {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortCriteria", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SearchContactsInput) SetFilters(v []*Filter) *SearchContactsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchContactsInput) SetMaxResults(v int64) *SearchContactsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchContactsInput) SetNextToken(v string) *SearchContactsInput {
	s.NextToken = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *SearchContactsInput) SetSortCriteria(v []*Sort) *SearchContactsInput {
	s.SortCriteria = v
	return s
}

type SearchContactsOutput struct {
	_ struct{} `type:"structure"`

	// The contacts that meet the specified set of filter criteria, in sort order.
	Contacts []*ContactData `type:"list"`

	// The token returned to indicate that there is more data available.
	NextToken *string `min:"1" type:"string"`

	// The total number of contacts returned.
	TotalCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchContactsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchContactsOutput) GoString() string {
	return s.String()
}

// SetContacts sets the Contacts field's value.
func (s *SearchContactsOutput) SetContacts(v []*ContactData) *SearchContactsOutput {
	s.Contacts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchContactsOutput) SetNextToken(v string) *SearchContactsOutput {
	s.NextToken = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *SearchContactsOutput) SetTotalCount(v int64) *SearchContactsOutput {
	s.TotalCount = &v
	return s
}

type SearchDevicesInput struct {
	_ struct{} `type:"structure"`

	// The filters to use to list a specified set of devices. Supported filter keys
	// are DeviceName, DeviceStatus, DeviceStatusDetailCode, RoomName, DeviceType,
	// DeviceSerialNumber, UnassociatedOnly, ConnectionStatus (ONLINE and OFFLINE),
	// NetworkProfileName, NetworkProfileArn, Feature, and FailureCode.
	Filters []*Filter `type:"list"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`

	// The sort order to use in listing the specified set of devices. Supported
	// sort keys are DeviceName, DeviceStatus, RoomName, DeviceType, DeviceSerialNumber,
	// ConnectionStatus, NetworkProfileName, NetworkProfileArn, Feature, and FailureCode.
	SortCriteria []*Sort `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchDevicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchDevicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchDevicesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SortCriteria != nil {
		for i, v := range s.SortCriteria {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortCriteria", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SearchDevicesInput) SetFilters(v []*Filter) *SearchDevicesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchDevicesInput) SetMaxResults(v int64) *SearchDevicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchDevicesInput) SetNextToken(v string) *SearchDevicesInput {
	s.NextToken = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *SearchDevicesInput) SetSortCriteria(v []*Sort) *SearchDevicesInput {
	s.SortCriteria = v
	return s
}

type SearchDevicesOutput struct {
	_ struct{} `type:"structure"`

	// The devices that meet the specified set of filter criteria, in sort order.
	Devices []*DeviceData `type:"list"`

	// The token returned to indicate that there is more data available.
	NextToken *string `min:"1" type:"string"`

	// The total number of devices returned.
	TotalCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchDevicesOutput) GoString() string {
	return s.String()
}

// SetDevices sets the Devices field's value.
func (s *SearchDevicesOutput) SetDevices(v []*DeviceData) *SearchDevicesOutput {
	s.Devices = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchDevicesOutput) SetNextToken(v string) *SearchDevicesOutput {
	s.NextToken = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *SearchDevicesOutput) SetTotalCount(v int64) *SearchDevicesOutput {
	s.TotalCount = &v
	return s
}

type SearchNetworkProfilesInput struct {
	_ struct{} `type:"structure"`

	// The filters to use to list a specified set of network profiles. Valid filters
	// are NetworkProfileName, Ssid, and SecurityType.
	Filters []*Filter `type:"list"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`

	// The sort order to use to list the specified set of network profiles. Valid
	// sort criteria includes NetworkProfileName, Ssid, and SecurityType.
	SortCriteria []*Sort `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchNetworkProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchNetworkProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchNetworkProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchNetworkProfilesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SortCriteria != nil {
		for i, v := range s.SortCriteria {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortCriteria", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SearchNetworkProfilesInput) SetFilters(v []*Filter) *SearchNetworkProfilesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchNetworkProfilesInput) SetMaxResults(v int64) *SearchNetworkProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchNetworkProfilesInput) SetNextToken(v string) *SearchNetworkProfilesInput {
	s.NextToken = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *SearchNetworkProfilesInput) SetSortCriteria(v []*Sort) *SearchNetworkProfilesInput {
	s.SortCriteria = v
	return s
}

type SearchNetworkProfilesOutput struct {
	_ struct{} `type:"structure"`

	// The network profiles that meet the specified set of filter criteria, in sort
	// order. It is a list of NetworkProfileData objects.
	NetworkProfiles []*NetworkProfileData `type:"list"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`

	// The total number of network profiles returned.
	TotalCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchNetworkProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchNetworkProfilesOutput) GoString() string {
	return s.String()
}

// SetNetworkProfiles sets the NetworkProfiles field's value.
func (s *SearchNetworkProfilesOutput) SetNetworkProfiles(v []*NetworkProfileData) *SearchNetworkProfilesOutput {
	s.NetworkProfiles = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchNetworkProfilesOutput) SetNextToken(v string) *SearchNetworkProfilesOutput {
	s.NextToken = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *SearchNetworkProfilesOutput) SetTotalCount(v int64) *SearchNetworkProfilesOutput {
	s.TotalCount = &v
	return s
}

type SearchProfilesInput struct {
	_ struct{} `type:"structure"`

	// The filters to use to list a specified set of room profiles. Supported filter
	// keys are ProfileName and Address. Required.
	Filters []*Filter `type:"list"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`

	// The sort order to use in listing the specified set of room profiles. Supported
	// sort keys are ProfileName and Address.
	SortCriteria []*Sort `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchProfilesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SortCriteria != nil {
		for i, v := range s.SortCriteria {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortCriteria", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SearchProfilesInput) SetFilters(v []*Filter) *SearchProfilesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchProfilesInput) SetMaxResults(v int64) *SearchProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchProfilesInput) SetNextToken(v string) *SearchProfilesInput {
	s.NextToken = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *SearchProfilesInput) SetSortCriteria(v []*Sort) *SearchProfilesInput {
	s.SortCriteria = v
	return s
}

type SearchProfilesOutput struct {
	_ struct{} `type:"structure"`

	// The token returned to indicate that there is more data available.
	NextToken *string `min:"1" type:"string"`

	// The profiles that meet the specified set of filter criteria, in sort order.
	Profiles []*ProfileData `type:"list"`

	// The total number of room profiles returned.
	TotalCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchProfilesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchProfilesOutput) SetNextToken(v string) *SearchProfilesOutput {
	s.NextToken = &v
	return s
}

// SetProfiles sets the Profiles field's value.
func (s *SearchProfilesOutput) SetProfiles(v []*ProfileData) *SearchProfilesOutput {
	s.Profiles = v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *SearchProfilesOutput) SetTotalCount(v int64) *SearchProfilesOutput {
	s.TotalCount = &v
	return s
}

type SearchRoomsInput struct {
	_ struct{} `type:"structure"`

	// The filters to use to list a specified set of rooms. The supported filter
	// keys are RoomName and ProfileName.
	Filters []*Filter `type:"list"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`

	// The sort order to use in listing the specified set of rooms. The supported
	// sort keys are RoomName and ProfileName.
	SortCriteria []*Sort `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchRoomsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchRoomsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchRoomsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchRoomsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SortCriteria != nil {
		for i, v := range s.SortCriteria {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortCriteria", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SearchRoomsInput) SetFilters(v []*Filter) *SearchRoomsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchRoomsInput) SetMaxResults(v int64) *SearchRoomsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchRoomsInput) SetNextToken(v string) *SearchRoomsInput {
	s.NextToken = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *SearchRoomsInput) SetSortCriteria(v []*Sort) *SearchRoomsInput {
	s.SortCriteria = v
	return s
}

type SearchRoomsOutput struct {
	_ struct{} `type:"structure"`

	// The token returned to indicate that there is more data available.
	NextToken *string `min:"1" type:"string"`

	// The rooms that meet the specified set of filter criteria, in sort order.
	Rooms []*RoomData `type:"list"`

	// The total number of rooms returned.
	TotalCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchRoomsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchRoomsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchRoomsOutput) SetNextToken(v string) *SearchRoomsOutput {
	s.NextToken = &v
	return s
}

// SetRooms sets the Rooms field's value.
func (s *SearchRoomsOutput) SetRooms(v []*RoomData) *SearchRoomsOutput {
	s.Rooms = v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *SearchRoomsOutput) SetTotalCount(v int64) *SearchRoomsOutput {
	s.TotalCount = &v
	return s
}

type SearchSkillGroupsInput struct {
	_ struct{} `type:"structure"`

	// The filters to use to list a specified set of skill groups. The supported
	// filter key is SkillGroupName.
	Filters []*Filter `type:"list"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	// Required.
	NextToken *string `min:"1" type:"string"`

	// The sort order to use in listing the specified set of skill groups. The supported
	// sort key is SkillGroupName.
	SortCriteria []*Sort `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchSkillGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchSkillGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchSkillGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchSkillGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SortCriteria != nil {
		for i, v := range s.SortCriteria {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortCriteria", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SearchSkillGroupsInput) SetFilters(v []*Filter) *SearchSkillGroupsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchSkillGroupsInput) SetMaxResults(v int64) *SearchSkillGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchSkillGroupsInput) SetNextToken(v string) *SearchSkillGroupsInput {
	s.NextToken = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *SearchSkillGroupsInput) SetSortCriteria(v []*Sort) *SearchSkillGroupsInput {
	s.SortCriteria = v
	return s
}

type SearchSkillGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The token returned to indicate that there is more data available.
	NextToken *string `min:"1" type:"string"`

	// The skill groups that meet the filter criteria, in sort order.
	SkillGroups []*SkillGroupData `type:"list"`

	// The total number of skill groups returned.
	TotalCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchSkillGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchSkillGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchSkillGroupsOutput) SetNextToken(v string) *SearchSkillGroupsOutput {
	s.NextToken = &v
	return s
}

// SetSkillGroups sets the SkillGroups field's value.
func (s *SearchSkillGroupsOutput) SetSkillGroups(v []*SkillGroupData) *SearchSkillGroupsOutput {
	s.SkillGroups = v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *SearchSkillGroupsOutput) SetTotalCount(v int64) *SearchSkillGroupsOutput {
	s.TotalCount = &v
	return s
}

type SearchUsersInput struct {
	_ struct{} `type:"structure"`

	// The filters to use for listing a specific set of users. Required. Supported
	// filter keys are UserId, FirstName, LastName, Email, and EnrollmentStatus.
	Filters []*Filter `type:"list"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved. Required.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	// Required.
	NextToken *string `min:"1" type:"string"`

	// The sort order to use in listing the filtered set of users. Required. Supported
	// sort keys are UserId, FirstName, LastName, Email, and EnrollmentStatus.
	SortCriteria []*Sort `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchUsersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SortCriteria != nil {
		for i, v := range s.SortCriteria {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortCriteria", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SearchUsersInput) SetFilters(v []*Filter) *SearchUsersInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchUsersInput) SetMaxResults(v int64) *SearchUsersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchUsersInput) SetNextToken(v string) *SearchUsersInput {
	s.NextToken = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *SearchUsersInput) SetSortCriteria(v []*Sort) *SearchUsersInput {
	s.SortCriteria = v
	return s
}

type SearchUsersOutput struct {
	_ struct{} `type:"structure"`

	// The token returned to indicate that there is more data available.
	NextToken *string `min:"1" type:"string"`

	// The total number of users returned.
	TotalCount *int64 `type:"integer"`

	// The users that meet the specified set of filter criteria, in sort order.
	Users []*UserData `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchUsersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchUsersOutput) SetNextToken(v string) *SearchUsersOutput {
	s.NextToken = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *SearchUsersOutput) SetTotalCount(v int64) *SearchUsersOutput {
	s.TotalCount = &v
	return s
}

// SetUsers sets the Users field's value.
func (s *SearchUsersOutput) SetUsers(v []*UserData) *SearchUsersOutput {
	s.Users = v
	return s
}

type SendAnnouncementInput struct {
	_ struct{} `type:"structure"`

	// The unique, user-specified identifier for the request that ensures idempotency.
	ClientRequestToken *string `min:"10" type:"string" idempotencyToken:"true"`

	// The announcement content. This can contain only one of the three possible
	// announcement types (text, SSML or audio).
	//
	// Content is a required field
	Content *Content `type:"structure" required:"true"`

	// The filters to use to send an announcement to a specified list of rooms.
	// The supported filter keys are RoomName, ProfileName, RoomArn, and ProfileArn.
	// To send to all rooms, specify an empty RoomFilters list.
	//
	// RoomFilters is a required field
	RoomFilters []*Filter `type:"list" required:"true"`

	// The time to live for an announcement. Default is 300. If delivery doesn't
	// occur within this time, the announcement is not delivered.
	TimeToLiveInSeconds *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendAnnouncementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendAnnouncementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendAnnouncementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendAnnouncementInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 10))
	}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.RoomFilters == nil {
		invalidParams.Add(request.NewErrParamRequired("RoomFilters"))
	}
	if s.TimeToLiveInSeconds != nil && *s.TimeToLiveInSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TimeToLiveInSeconds", 1))
	}
	if s.Content != nil {
		if err := s.Content.Validate(); err != nil {
			invalidParams.AddNested("Content", err.(request.ErrInvalidParams))
		}
	}
	if s.RoomFilters != nil {
		for i, v := range s.RoomFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RoomFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *SendAnnouncementInput) SetClientRequestToken(v string) *SendAnnouncementInput {
	s.ClientRequestToken = &v
	return s
}

// SetContent sets the Content field's value.
func (s *SendAnnouncementInput) SetContent(v *Content) *SendAnnouncementInput {
	s.Content = v
	return s
}

// SetRoomFilters sets the RoomFilters field's value.
func (s *SendAnnouncementInput) SetRoomFilters(v []*Filter) *SendAnnouncementInput {
	s.RoomFilters = v
	return s
}

// SetTimeToLiveInSeconds sets the TimeToLiveInSeconds field's value.
func (s *SendAnnouncementInput) SetTimeToLiveInSeconds(v int64) *SendAnnouncementInput {
	s.TimeToLiveInSeconds = &v
	return s
}

type SendAnnouncementOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the announcement.
	AnnouncementArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendAnnouncementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendAnnouncementOutput) GoString() string {
	return s.String()
}

// SetAnnouncementArn sets the AnnouncementArn field's value.
func (s *SendAnnouncementOutput) SetAnnouncementArn(v string) *SendAnnouncementOutput {
	s.AnnouncementArn = &v
	return s
}

type SendInvitationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the user to whom to send an invitation. Required.
	UserArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendInvitationInput) GoString() string {
	return s.String()
}

// SetUserArn sets the UserArn field's value.
func (s *SendInvitationInput) SetUserArn(v string) *SendInvitationInput {
	s.UserArn = &v
	return s
}

type SendInvitationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendInvitationOutput) GoString() string {
	return s.String()
}

// The SIP address for the contact containing the URI and SIP address type.
type SipAddress struct {
	_ struct{} `type:"structure"`

	// The type of the SIP address.
	//
	// Type is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SipAddress's
	// String and GoString methods.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"SipType" sensitive:"true"`

	// The URI for the SIP address.
	//
	// Uri is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SipAddress's
	// String and GoString methods.
	//
	// Uri is a required field
	Uri *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SipAddress) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SipAddress) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SipAddress) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SipAddress"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("Uri"))
	}
	if s.Uri != nil && len(*s.Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *SipAddress) SetType(v string) *SipAddress {
	s.Type = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *SipAddress) SetUri(v string) *SipAddress {
	s.Uri = &v
	return s
}

// Granular information about the skill.
type SkillDetails struct {
	_ struct{} `type:"structure"`

	// The details about what the skill supports organized as bullet points.
	BulletPoints []*string `type:"list"`

	// The details about the developer that published the skill.
	DeveloperInfo *DeveloperInfo `type:"structure"`

	// The URL of the end user license agreement.
	EndUserLicenseAgreement *string `type:"string"`

	// The generic keywords associated with the skill that can be used to find a
	// skill.
	GenericKeywords []*string `type:"list"`

	// The phrase used to trigger the skill.
	InvocationPhrase *string `type:"string"`

	// The updates added in bullet points.
	NewInThisVersionBulletPoints []*string `type:"list"`

	// The description of the product.
	ProductDescription *string `type:"string"`

	// The date when the skill was released.
	ReleaseDate *string `type:"string"`

	// This member has been deprecated.
	//
	// The list of reviews for the skill, including Key and Value pair.
	Reviews map[string]*string `type:"map"`

	// The types of skills.
	SkillTypes []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SkillDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SkillDetails) GoString() string {
	return s.String()
}

// SetBulletPoints sets the BulletPoints field's value.
func (s *SkillDetails) SetBulletPoints(v []*string) *SkillDetails {
	s.BulletPoints = v
	return s
}

// SetDeveloperInfo sets the DeveloperInfo field's value.
func (s *SkillDetails) SetDeveloperInfo(v *DeveloperInfo) *SkillDetails {
	s.DeveloperInfo = v
	return s
}

// SetEndUserLicenseAgreement sets the EndUserLicenseAgreement field's value.
func (s *SkillDetails) SetEndUserLicenseAgreement(v string) *SkillDetails {
	s.EndUserLicenseAgreement = &v
	return s
}

// SetGenericKeywords sets the GenericKeywords field's value.
func (s *SkillDetails) SetGenericKeywords(v []*string) *SkillDetails {
	s.GenericKeywords = v
	return s
}

// SetInvocationPhrase sets the InvocationPhrase field's value.
func (s *SkillDetails) SetInvocationPhrase(v string) *SkillDetails {
	s.InvocationPhrase = &v
	return s
}

// SetNewInThisVersionBulletPoints sets the NewInThisVersionBulletPoints field's value.
func (s *SkillDetails) SetNewInThisVersionBulletPoints(v []*string) *SkillDetails {
	s.NewInThisVersionBulletPoints = v
	return s
}

// SetProductDescription sets the ProductDescription field's value.
func (s *SkillDetails) SetProductDescription(v string) *SkillDetails {
	s.ProductDescription = &v
	return s
}

// SetReleaseDate sets the ReleaseDate field's value.
func (s *SkillDetails) SetReleaseDate(v string) *SkillDetails {
	s.ReleaseDate = &v
	return s
}

// SetReviews sets the Reviews field's value.
func (s *SkillDetails) SetReviews(v map[string]*string) *SkillDetails {
	s.Reviews = v
	return s
}

// SetSkillTypes sets the SkillTypes field's value.
func (s *SkillDetails) SetSkillTypes(v []*string) *SkillDetails {
	s.SkillTypes = v
	return s
}

// A skill group with attributes.
type SkillGroup struct {
	_ struct{} `type:"structure"`

	// The description of a skill group.
	Description *string `min:"1" type:"string"`

	// The ARN of a skill group.
	SkillGroupArn *string `type:"string"`

	// The name of a skill group.
	SkillGroupName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SkillGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SkillGroup) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *SkillGroup) SetDescription(v string) *SkillGroup {
	s.Description = &v
	return s
}

// SetSkillGroupArn sets the SkillGroupArn field's value.
func (s *SkillGroup) SetSkillGroupArn(v string) *SkillGroup {
	s.SkillGroupArn = &v
	return s
}

// SetSkillGroupName sets the SkillGroupName field's value.
func (s *SkillGroup) SetSkillGroupName(v string) *SkillGroup {
	s.SkillGroupName = &v
	return s
}

// The attributes of a skill group.
type SkillGroupData struct {
	_ struct{} `type:"structure"`

	// The description of a skill group.
	Description *string `min:"1" type:"string"`

	// The skill group ARN of a skill group.
	SkillGroupArn *string `type:"string"`

	// The skill group name of a skill group.
	SkillGroupName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SkillGroupData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SkillGroupData) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *SkillGroupData) SetDescription(v string) *SkillGroupData {
	s.Description = &v
	return s
}

// SetSkillGroupArn sets the SkillGroupArn field's value.
func (s *SkillGroupData) SetSkillGroupArn(v string) *SkillGroupData {
	s.SkillGroupArn = &v
	return s
}

// SetSkillGroupName sets the SkillGroupName field's value.
func (s *SkillGroupData) SetSkillGroupName(v string) *SkillGroupData {
	s.SkillGroupName = &v
	return s
}

// The skill must be linked to a third-party account.
type SkillNotLinkedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SkillNotLinkedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SkillNotLinkedException) GoString() string {
	return s.String()
}

func newErrorSkillNotLinkedException(v protocol.ResponseMetadata) error {
	return &SkillNotLinkedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SkillNotLinkedException) Code() string {
	return "SkillNotLinkedException"
}

// Message returns the exception's message.
func (s *SkillNotLinkedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SkillNotLinkedException) OrigErr() error {
	return nil
}

func (s *SkillNotLinkedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SkillNotLinkedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SkillNotLinkedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The summary of skills.
type SkillSummary struct {
	_ struct{} `type:"structure"`

	// Whether the skill is enabled under the user's account, or if it requires
	// linking to be used.
	EnablementType *string `type:"string" enum:"EnablementType"`

	// The ARN of the skill summary.
	SkillId *string `type:"string"`

	// The name of the skill.
	SkillName *string `min:"1" type:"string"`

	// Whether the skill is publicly available or is a private skill.
	SkillType *string `min:"1" type:"string" enum:"SkillType"`

	// Linking support for a skill.
	SupportsLinking *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SkillSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SkillSummary) GoString() string {
	return s.String()
}

// SetEnablementType sets the EnablementType field's value.
func (s *SkillSummary) SetEnablementType(v string) *SkillSummary {
	s.EnablementType = &v
	return s
}

// SetSkillId sets the SkillId field's value.
func (s *SkillSummary) SetSkillId(v string) *SkillSummary {
	s.SkillId = &v
	return s
}

// SetSkillName sets the SkillName field's value.
func (s *SkillSummary) SetSkillName(v string) *SkillSummary {
	s.SkillName = &v
	return s
}

// SetSkillType sets the SkillType field's value.
func (s *SkillSummary) SetSkillType(v string) *SkillSummary {
	s.SkillType = &v
	return s
}

// SetSupportsLinking sets the SupportsLinking field's value.
func (s *SkillSummary) SetSupportsLinking(v bool) *SkillSummary {
	s.SupportsLinking = &v
	return s
}

// The detailed information about an Alexa skill.
type SkillsStoreSkill struct {
	_ struct{} `type:"structure"`

	// The URL where the skill icon resides.
	IconUrl *string `type:"string"`

	// Sample utterances that interact with the skill.
	SampleUtterances []*string `type:"list"`

	// Short description about the skill.
	ShortDescription *string `type:"string"`

	// Information about the skill.
	SkillDetails *SkillDetails `type:"structure"`

	// The ARN of the skill.
	SkillId *string `type:"string"`

	// The name of the skill.
	SkillName *string `min:"1" type:"string"`

	// Linking support for a skill.
	SupportsLinking *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SkillsStoreSkill) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SkillsStoreSkill) GoString() string {
	return s.String()
}

// SetIconUrl sets the IconUrl field's value.
func (s *SkillsStoreSkill) SetIconUrl(v string) *SkillsStoreSkill {
	s.IconUrl = &v
	return s
}

// SetSampleUtterances sets the SampleUtterances field's value.
func (s *SkillsStoreSkill) SetSampleUtterances(v []*string) *SkillsStoreSkill {
	s.SampleUtterances = v
	return s
}

// SetShortDescription sets the ShortDescription field's value.
func (s *SkillsStoreSkill) SetShortDescription(v string) *SkillsStoreSkill {
	s.ShortDescription = &v
	return s
}

// SetSkillDetails sets the SkillDetails field's value.
func (s *SkillsStoreSkill) SetSkillDetails(v *SkillDetails) *SkillsStoreSkill {
	s.SkillDetails = v
	return s
}

// SetSkillId sets the SkillId field's value.
func (s *SkillsStoreSkill) SetSkillId(v string) *SkillsStoreSkill {
	s.SkillId = &v
	return s
}

// SetSkillName sets the SkillName field's value.
func (s *SkillsStoreSkill) SetSkillName(v string) *SkillsStoreSkill {
	s.SkillName = &v
	return s
}

// SetSupportsLinking sets the SupportsLinking field's value.
func (s *SkillsStoreSkill) SetSupportsLinking(v bool) *SkillsStoreSkill {
	s.SupportsLinking = &v
	return s
}

// A smart home appliance that can connect to a central system. Any domestic
// device can be a smart appliance.
type SmartHomeAppliance struct {
	_ struct{} `type:"structure"`

	// The description of the smart home appliance.
	Description *string `type:"string"`

	// The friendly name of the smart home appliance.
	FriendlyName *string `type:"string"`

	// The name of the manufacturer of the smart home appliance.
	ManufacturerName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SmartHomeAppliance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SmartHomeAppliance) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *SmartHomeAppliance) SetDescription(v string) *SmartHomeAppliance {
	s.Description = &v
	return s
}

// SetFriendlyName sets the FriendlyName field's value.
func (s *SmartHomeAppliance) SetFriendlyName(v string) *SmartHomeAppliance {
	s.FriendlyName = &v
	return s
}

// SetManufacturerName sets the ManufacturerName field's value.
func (s *SmartHomeAppliance) SetManufacturerName(v string) *SmartHomeAppliance {
	s.ManufacturerName = &v
	return s
}

// An object representing a sort criteria.
type Sort struct {
	_ struct{} `type:"structure"`

	// The sort key of a sort object.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The sort value of a sort object.
	//
	// Value is a required field
	Value *string `type:"string" required:"true" enum:"SortValue"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Sort) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Sort) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Sort) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Sort"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Sort) SetKey(v string) *Sort {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Sort) SetValue(v string) *Sort {
	s.Value = &v
	return s
}

// The SSML message. For more information, see SSML Reference (https://developer.amazon.com/docs/custom-skills/speech-synthesis-markup-language-ssml-reference.html).
type Ssml struct {
	_ struct{} `type:"structure"`

	// The locale of the SSML message. Currently, en-US is supported.
	//
	// Locale is a required field
	Locale *string `type:"string" required:"true" enum:"Locale"`

	// The value of the SSML message in the correct SSML format. The audio tag is
	// not supported.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ssml) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ssml) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ssml) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Ssml"}
	if s.Locale == nil {
		invalidParams.Add(request.NewErrParamRequired("Locale"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocale sets the Locale field's value.
func (s *Ssml) SetLocale(v string) *Ssml {
	s.Locale = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Ssml) SetValue(v string) *Ssml {
	s.Value = &v
	return s
}

type StartDeviceSyncInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the device to sync. Required.
	DeviceArn *string `type:"string"`

	// Request structure to start the device sync. Required.
	//
	// Features is a required field
	Features []*string `type:"list" required:"true" enum:"Feature"`

	// The ARN of the room with which the device to sync is associated. Required.
	RoomArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDeviceSyncInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDeviceSyncInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDeviceSyncInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDeviceSyncInput"}
	if s.Features == nil {
		invalidParams.Add(request.NewErrParamRequired("Features"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *StartDeviceSyncInput) SetDeviceArn(v string) *StartDeviceSyncInput {
	s.DeviceArn = &v
	return s
}

// SetFeatures sets the Features field's value.
func (s *StartDeviceSyncInput) SetFeatures(v []*string) *StartDeviceSyncInput {
	s.Features = v
	return s
}

// SetRoomArn sets the RoomArn field's value.
func (s *StartDeviceSyncInput) SetRoomArn(v string) *StartDeviceSyncInput {
	s.RoomArn = &v
	return s
}

type StartDeviceSyncOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDeviceSyncOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDeviceSyncOutput) GoString() string {
	return s.String()
}

type StartSmartHomeApplianceDiscoveryInput struct {
	_ struct{} `type:"structure"`

	// The room where smart home appliance discovery was initiated.
	//
	// RoomArn is a required field
	RoomArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSmartHomeApplianceDiscoveryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSmartHomeApplianceDiscoveryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartSmartHomeApplianceDiscoveryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartSmartHomeApplianceDiscoveryInput"}
	if s.RoomArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoomArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoomArn sets the RoomArn field's value.
func (s *StartSmartHomeApplianceDiscoveryInput) SetRoomArn(v string) *StartSmartHomeApplianceDiscoveryInput {
	s.RoomArn = &v
	return s
}

type StartSmartHomeApplianceDiscoveryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSmartHomeApplianceDiscoveryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSmartHomeApplianceDiscoveryOutput) GoString() string {
	return s.String()
}

// A key-value pair that can be associated with a resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of a tag. Tag keys are case-sensitive.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of a tag. Tag values are case sensitive and can be null.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource to which to add metadata tags. Required.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The tags to be added to the specified resource. Do not provide system tags.
	// Required.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *TagResourceInput) SetArn(v string) *TagResourceInput {
	s.Arn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The text message.
type Text struct {
	_ struct{} `type:"structure"`

	// The locale of the text message. Currently, en-US is supported.
	//
	// Locale is a required field
	Locale *string `type:"string" required:"true" enum:"Locale"`

	// The value of the text message.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Text) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Text) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Text) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Text"}
	if s.Locale == nil {
		invalidParams.Add(request.NewErrParamRequired("Locale"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocale sets the Locale field's value.
func (s *Text) SetLocale(v string) *Text {
	s.Locale = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Text) SetValue(v string) *Text {
	s.Value = &v
	return s
}

// The caller has no permissions to operate on the resource involved in the
// API call.
type UnauthorizedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedException(v protocol.ResponseMetadata) error {
	return &UnauthorizedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnauthorizedException) Code() string {
	return "UnauthorizedException"
}

// Message returns the exception's message.
func (s *UnauthorizedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnauthorizedException) OrigErr() error {
	return nil
}

func (s *UnauthorizedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnauthorizedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnauthorizedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource from which to remove metadata tags. Required.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The tags to be removed from the specified resource. Do not provide system
	// tags. Required.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UntagResourceInput) SetArn(v string) *UntagResourceInput {
	s.Arn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAddressBookInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the room to update.
	//
	// AddressBookArn is a required field
	AddressBookArn *string `type:"string" required:"true"`

	// The updated description of the room.
	Description *string `min:"1" type:"string"`

	// The updated name of the room.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAddressBookInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAddressBookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAddressBookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAddressBookInput"}
	if s.AddressBookArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AddressBookArn"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressBookArn sets the AddressBookArn field's value.
func (s *UpdateAddressBookInput) SetAddressBookArn(v string) *UpdateAddressBookInput {
	s.AddressBookArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateAddressBookInput) SetDescription(v string) *UpdateAddressBookInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAddressBookInput) SetName(v string) *UpdateAddressBookInput {
	s.Name = &v
	return s
}

type UpdateAddressBookOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAddressBookOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAddressBookOutput) GoString() string {
	return s.String()
}

type UpdateBusinessReportScheduleInput struct {
	_ struct{} `type:"structure"`

	// The format of the generated report (individual CSV files or zipped files
	// of individual files).
	Format *string `type:"string" enum:"BusinessReportFormat"`

	// The recurrence of the reports.
	Recurrence *BusinessReportRecurrence `type:"structure"`

	// The S3 location of the output reports.
	S3BucketName *string `type:"string"`

	// The S3 key where the report is delivered.
	S3KeyPrefix *string `type:"string"`

	// The ARN of the business report schedule.
	//
	// ScheduleArn is a required field
	ScheduleArn *string `type:"string" required:"true"`

	// The name identifier of the schedule.
	ScheduleName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBusinessReportScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBusinessReportScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBusinessReportScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBusinessReportScheduleInput"}
	if s.ScheduleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFormat sets the Format field's value.
func (s *UpdateBusinessReportScheduleInput) SetFormat(v string) *UpdateBusinessReportScheduleInput {
	s.Format = &v
	return s
}

// SetRecurrence sets the Recurrence field's value.
func (s *UpdateBusinessReportScheduleInput) SetRecurrence(v *BusinessReportRecurrence) *UpdateBusinessReportScheduleInput {
	s.Recurrence = v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *UpdateBusinessReportScheduleInput) SetS3BucketName(v string) *UpdateBusinessReportScheduleInput {
	s.S3BucketName = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *UpdateBusinessReportScheduleInput) SetS3KeyPrefix(v string) *UpdateBusinessReportScheduleInput {
	s.S3KeyPrefix = &v
	return s
}

// SetScheduleArn sets the ScheduleArn field's value.
func (s *UpdateBusinessReportScheduleInput) SetScheduleArn(v string) *UpdateBusinessReportScheduleInput {
	s.ScheduleArn = &v
	return s
}

// SetScheduleName sets the ScheduleName field's value.
func (s *UpdateBusinessReportScheduleInput) SetScheduleName(v string) *UpdateBusinessReportScheduleInput {
	s.ScheduleName = &v
	return s
}

type UpdateBusinessReportScheduleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBusinessReportScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBusinessReportScheduleOutput) GoString() string {
	return s.String()
}

type UpdateConferenceProviderInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the conference provider.
	//
	// ConferenceProviderArn is a required field
	ConferenceProviderArn *string `type:"string" required:"true"`

	// The type of the conference provider.
	//
	// ConferenceProviderType is a required field
	ConferenceProviderType *string `type:"string" required:"true" enum:"ConferenceProviderType"`

	// The IP endpoint and protocol for calling.
	IPDialIn *IPDialIn `type:"structure"`

	// The meeting settings for the conference provider.
	//
	// MeetingSetting is a required field
	MeetingSetting *MeetingSetting `type:"structure" required:"true"`

	// The information for PSTN conferencing.
	PSTNDialIn *PSTNDialIn `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConferenceProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConferenceProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConferenceProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConferenceProviderInput"}
	if s.ConferenceProviderArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConferenceProviderArn"))
	}
	if s.ConferenceProviderType == nil {
		invalidParams.Add(request.NewErrParamRequired("ConferenceProviderType"))
	}
	if s.MeetingSetting == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingSetting"))
	}
	if s.IPDialIn != nil {
		if err := s.IPDialIn.Validate(); err != nil {
			invalidParams.AddNested("IPDialIn", err.(request.ErrInvalidParams))
		}
	}
	if s.MeetingSetting != nil {
		if err := s.MeetingSetting.Validate(); err != nil {
			invalidParams.AddNested("MeetingSetting", err.(request.ErrInvalidParams))
		}
	}
	if s.PSTNDialIn != nil {
		if err := s.PSTNDialIn.Validate(); err != nil {
			invalidParams.AddNested("PSTNDialIn", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConferenceProviderArn sets the ConferenceProviderArn field's value.
func (s *UpdateConferenceProviderInput) SetConferenceProviderArn(v string) *UpdateConferenceProviderInput {
	s.ConferenceProviderArn = &v
	return s
}

// SetConferenceProviderType sets the ConferenceProviderType field's value.
func (s *UpdateConferenceProviderInput) SetConferenceProviderType(v string) *UpdateConferenceProviderInput {
	s.ConferenceProviderType = &v
	return s
}

// SetIPDialIn sets the IPDialIn field's value.
func (s *UpdateConferenceProviderInput) SetIPDialIn(v *IPDialIn) *UpdateConferenceProviderInput {
	s.IPDialIn = v
	return s
}

// SetMeetingSetting sets the MeetingSetting field's value.
func (s *UpdateConferenceProviderInput) SetMeetingSetting(v *MeetingSetting) *UpdateConferenceProviderInput {
	s.MeetingSetting = v
	return s
}

// SetPSTNDialIn sets the PSTNDialIn field's value.
func (s *UpdateConferenceProviderInput) SetPSTNDialIn(v *PSTNDialIn) *UpdateConferenceProviderInput {
	s.PSTNDialIn = v
	return s
}

type UpdateConferenceProviderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConferenceProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConferenceProviderOutput) GoString() string {
	return s.String()
}

type UpdateContactInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the contact to update.
	//
	// ContactArn is a required field
	ContactArn *string `type:"string" required:"true"`

	// The updated display name of the contact.
	DisplayName *string `min:"1" type:"string"`

	// The updated first name of the contact.
	FirstName *string `min:"1" type:"string"`

	// The updated last name of the contact.
	LastName *string `min:"1" type:"string"`

	// The updated phone number of the contact. The phone number type defaults to
	// WORK. You can either specify PhoneNumber or PhoneNumbers. We recommend that
	// you use PhoneNumbers, which lets you specify the phone number type and multiple
	// numbers.
	//
	// PhoneNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateContactInput's
	// String and GoString methods.
	PhoneNumber *string `type:"string" sensitive:"true"`

	// The list of phone numbers for the contact.
	PhoneNumbers []*PhoneNumber `type:"list"`

	// The list of SIP addresses for the contact.
	SipAddresses []*SipAddress `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateContactInput"}
	if s.ContactArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactArn"))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.FirstName != nil && len(*s.FirstName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirstName", 1))
	}
	if s.LastName != nil && len(*s.LastName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LastName", 1))
	}
	if s.PhoneNumbers != nil {
		for i, v := range s.PhoneNumbers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PhoneNumbers", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SipAddresses != nil {
		for i, v := range s.SipAddresses {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SipAddresses", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactArn sets the ContactArn field's value.
func (s *UpdateContactInput) SetContactArn(v string) *UpdateContactInput {
	s.ContactArn = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateContactInput) SetDisplayName(v string) *UpdateContactInput {
	s.DisplayName = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *UpdateContactInput) SetFirstName(v string) *UpdateContactInput {
	s.FirstName = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *UpdateContactInput) SetLastName(v string) *UpdateContactInput {
	s.LastName = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *UpdateContactInput) SetPhoneNumber(v string) *UpdateContactInput {
	s.PhoneNumber = &v
	return s
}

// SetPhoneNumbers sets the PhoneNumbers field's value.
func (s *UpdateContactInput) SetPhoneNumbers(v []*PhoneNumber) *UpdateContactInput {
	s.PhoneNumbers = v
	return s
}

// SetSipAddresses sets the SipAddresses field's value.
func (s *UpdateContactInput) SetSipAddresses(v []*SipAddress) *UpdateContactInput {
	s.SipAddresses = v
	return s
}

type UpdateContactOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContactOutput) GoString() string {
	return s.String()
}

type UpdateDeviceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the device to update. Required.
	DeviceArn *string `type:"string"`

	// The updated device name. Required.
	DeviceName *string `min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDeviceInput"}
	if s.DeviceName != nil && len(*s.DeviceName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *UpdateDeviceInput) SetDeviceArn(v string) *UpdateDeviceInput {
	s.DeviceArn = &v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *UpdateDeviceInput) SetDeviceName(v string) *UpdateDeviceInput {
	s.DeviceName = &v
	return s
}

type UpdateDeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeviceOutput) GoString() string {
	return s.String()
}

// Settings for the end of meeting reminder feature that are applied to a room
// profile. The end of meeting reminder enables Alexa to remind users when a
// meeting is ending.
type UpdateEndOfMeetingReminder struct {
	_ struct{} `type:"structure"`

	// Whether an end of meeting reminder is enabled or not.
	Enabled *bool `type:"boolean"`

	// Updates settings for the end of meeting reminder feature that are applied
	// to a room profile. The end of meeting reminder enables Alexa to remind users
	// when a meeting is ending.
	ReminderAtMinutes []*int64 `min:"1" type:"list"`

	// The type of sound that users hear during the end of meeting reminder.
	ReminderType *string `type:"string" enum:"EndOfMeetingReminderType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEndOfMeetingReminder) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEndOfMeetingReminder) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEndOfMeetingReminder) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEndOfMeetingReminder"}
	if s.ReminderAtMinutes != nil && len(s.ReminderAtMinutes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReminderAtMinutes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *UpdateEndOfMeetingReminder) SetEnabled(v bool) *UpdateEndOfMeetingReminder {
	s.Enabled = &v
	return s
}

// SetReminderAtMinutes sets the ReminderAtMinutes field's value.
func (s *UpdateEndOfMeetingReminder) SetReminderAtMinutes(v []*int64) *UpdateEndOfMeetingReminder {
	s.ReminderAtMinutes = v
	return s
}

// SetReminderType sets the ReminderType field's value.
func (s *UpdateEndOfMeetingReminder) SetReminderType(v string) *UpdateEndOfMeetingReminder {
	s.ReminderType = &v
	return s
}

type UpdateGatewayGroupInput struct {
	_ struct{} `type:"structure"`

	// The updated description of the gateway group.
	Description *string `type:"string"`

	// The ARN of the gateway group to update.
	//
	// GatewayGroupArn is a required field
	GatewayGroupArn *string `type:"string" required:"true"`

	// The updated name of the gateway group.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGatewayGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGatewayGroupInput"}
	if s.GatewayGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayGroupArn"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateGatewayGroupInput) SetDescription(v string) *UpdateGatewayGroupInput {
	s.Description = &v
	return s
}

// SetGatewayGroupArn sets the GatewayGroupArn field's value.
func (s *UpdateGatewayGroupInput) SetGatewayGroupArn(v string) *UpdateGatewayGroupInput {
	s.GatewayGroupArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateGatewayGroupInput) SetName(v string) *UpdateGatewayGroupInput {
	s.Name = &v
	return s
}

type UpdateGatewayGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayGroupOutput) GoString() string {
	return s.String()
}

type UpdateGatewayInput struct {
	_ struct{} `type:"structure"`

	// The updated description of the gateway.
	Description *string `type:"string"`

	// The ARN of the gateway to update.
	//
	// GatewayArn is a required field
	GatewayArn *string `type:"string" required:"true"`

	// The updated name of the gateway.
	Name *string `min:"1" type:"string"`

	// The updated software version of the gateway. The gateway automatically updates
	// its software version during normal operation.
	SoftwareVersion *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGatewayInput"}
	if s.GatewayArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayArn"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SoftwareVersion != nil && len(*s.SoftwareVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SoftwareVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateGatewayInput) SetDescription(v string) *UpdateGatewayInput {
	s.Description = &v
	return s
}

// SetGatewayArn sets the GatewayArn field's value.
func (s *UpdateGatewayInput) SetGatewayArn(v string) *UpdateGatewayInput {
	s.GatewayArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateGatewayInput) SetName(v string) *UpdateGatewayInput {
	s.Name = &v
	return s
}

// SetSoftwareVersion sets the SoftwareVersion field's value.
func (s *UpdateGatewayInput) SetSoftwareVersion(v string) *UpdateGatewayInput {
	s.SoftwareVersion = &v
	return s
}

type UpdateGatewayOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayOutput) GoString() string {
	return s.String()
}

// Updates settings for the instant booking feature that are applied to a room
// profile. If instant booking is enabled, Alexa automatically reserves a room
// if it is free when a user joins a meeting with Alexa.
type UpdateInstantBooking struct {
	_ struct{} `type:"structure"`

	// Duration between 15 and 240 minutes at increments of 15 that determines how
	// long to book an available room when a meeting is started with Alexa.
	DurationInMinutes *int64 `type:"integer"`

	// Whether instant booking is enabled or not.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInstantBooking) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInstantBooking) GoString() string {
	return s.String()
}

// SetDurationInMinutes sets the DurationInMinutes field's value.
func (s *UpdateInstantBooking) SetDurationInMinutes(v int64) *UpdateInstantBooking {
	s.DurationInMinutes = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *UpdateInstantBooking) SetEnabled(v bool) *UpdateInstantBooking {
	s.Enabled = &v
	return s
}

// Updates meeting room settings of a room profile.
type UpdateMeetingRoomConfiguration struct {
	_ struct{} `type:"structure"`

	// Settings for the end of meeting reminder feature that are applied to a room
	// profile. The end of meeting reminder enables Alexa to remind users when a
	// meeting is ending.
	EndOfMeetingReminder *UpdateEndOfMeetingReminder `type:"structure"`

	// Settings to automatically book an available room available for a configured
	// duration when joining a meeting with Alexa.
	InstantBooking *UpdateInstantBooking `type:"structure"`

	// Settings for requiring a check in when a room is reserved. Alexa can cancel
	// a room reservation if it's not checked into to make the room available for
	// others. Users can check in by joining the meeting with Alexa or an AVS device,
	// or by saying “Alexa, check in.”
	RequireCheckIn *UpdateRequireCheckIn `type:"structure"`

	// Whether room utilization metrics are enabled or not.
	RoomUtilizationMetricsEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMeetingRoomConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMeetingRoomConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMeetingRoomConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMeetingRoomConfiguration"}
	if s.EndOfMeetingReminder != nil {
		if err := s.EndOfMeetingReminder.Validate(); err != nil {
			invalidParams.AddNested("EndOfMeetingReminder", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndOfMeetingReminder sets the EndOfMeetingReminder field's value.
func (s *UpdateMeetingRoomConfiguration) SetEndOfMeetingReminder(v *UpdateEndOfMeetingReminder) *UpdateMeetingRoomConfiguration {
	s.EndOfMeetingReminder = v
	return s
}

// SetInstantBooking sets the InstantBooking field's value.
func (s *UpdateMeetingRoomConfiguration) SetInstantBooking(v *UpdateInstantBooking) *UpdateMeetingRoomConfiguration {
	s.InstantBooking = v
	return s
}

// SetRequireCheckIn sets the RequireCheckIn field's value.
func (s *UpdateMeetingRoomConfiguration) SetRequireCheckIn(v *UpdateRequireCheckIn) *UpdateMeetingRoomConfiguration {
	s.RequireCheckIn = v
	return s
}

// SetRoomUtilizationMetricsEnabled sets the RoomUtilizationMetricsEnabled field's value.
func (s *UpdateMeetingRoomConfiguration) SetRoomUtilizationMetricsEnabled(v bool) *UpdateMeetingRoomConfiguration {
	s.RoomUtilizationMetricsEnabled = &v
	return s
}

type UpdateNetworkProfileInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the Private Certificate Authority (PCA) created in AWS Certificate
	// Manager (ACM). This is used to issue certificates to the devices.
	CertificateAuthorityArn *string `type:"string"`

	// The current password of the Wi-Fi network.
	//
	// CurrentPassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateNetworkProfileInput's
	// String and GoString methods.
	CurrentPassword *string `min:"5" type:"string" sensitive:"true"`

	// Detailed information about a device's network profile.
	Description *string `type:"string"`

	// The ARN of the network profile associated with a device.
	//
	// NetworkProfileArn is a required field
	NetworkProfileArn *string `type:"string" required:"true"`

	// The name of the network profile associated with a device.
	NetworkProfileName *string `min:"1" type:"string"`

	// The next, or subsequent, password of the Wi-Fi network. This password is
	// asynchronously transmitted to the device and is used when the password of
	// the network changes to NextPassword.
	//
	// NextPassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateNetworkProfileInput's
	// String and GoString methods.
	NextPassword *string `type:"string" sensitive:"true"`

	// The root certificate(s) of your authentication server that will be installed
	// on your devices and used to trust your authentication server during EAP negotiation.
	TrustAnchors []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNetworkProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNetworkProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNetworkProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateNetworkProfileInput"}
	if s.CurrentPassword != nil && len(*s.CurrentPassword) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CurrentPassword", 5))
	}
	if s.NetworkProfileArn == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkProfileArn"))
	}
	if s.NetworkProfileName != nil && len(*s.NetworkProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkProfileName", 1))
	}
	if s.TrustAnchors != nil && len(s.TrustAnchors) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrustAnchors", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *UpdateNetworkProfileInput) SetCertificateAuthorityArn(v string) *UpdateNetworkProfileInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetCurrentPassword sets the CurrentPassword field's value.
func (s *UpdateNetworkProfileInput) SetCurrentPassword(v string) *UpdateNetworkProfileInput {
	s.CurrentPassword = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateNetworkProfileInput) SetDescription(v string) *UpdateNetworkProfileInput {
	s.Description = &v
	return s
}

// SetNetworkProfileArn sets the NetworkProfileArn field's value.
func (s *UpdateNetworkProfileInput) SetNetworkProfileArn(v string) *UpdateNetworkProfileInput {
	s.NetworkProfileArn = &v
	return s
}

// SetNetworkProfileName sets the NetworkProfileName field's value.
func (s *UpdateNetworkProfileInput) SetNetworkProfileName(v string) *UpdateNetworkProfileInput {
	s.NetworkProfileName = &v
	return s
}

// SetNextPassword sets the NextPassword field's value.
func (s *UpdateNetworkProfileInput) SetNextPassword(v string) *UpdateNetworkProfileInput {
	s.NextPassword = &v
	return s
}

// SetTrustAnchors sets the TrustAnchors field's value.
func (s *UpdateNetworkProfileInput) SetTrustAnchors(v []*string) *UpdateNetworkProfileInput {
	s.TrustAnchors = v
	return s
}

type UpdateNetworkProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNetworkProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNetworkProfileOutput) GoString() string {
	return s.String()
}

type UpdateProfileInput struct {
	_ struct{} `type:"structure"`

	// The updated address for the room profile.
	Address *string `min:"1" type:"string"`

	// Whether data retention of the profile is enabled.
	DataRetentionOptIn *bool `type:"boolean"`

	// The updated distance unit for the room profile.
	DistanceUnit *string `type:"string" enum:"DistanceUnit"`

	// Sets the profile as default if selected. If this is missing, no update is
	// done to the default status.
	IsDefault *bool `type:"boolean"`

	// The updated locale for the room profile. (This is currently only available
	// to a limited preview audience.)
	Locale *string `min:"1" type:"string"`

	// The updated maximum volume limit for the room profile.
	MaxVolumeLimit *int64 `type:"integer"`

	// The updated meeting room settings of a room profile.
	MeetingRoomConfiguration *UpdateMeetingRoomConfiguration `type:"structure"`

	// Whether the PSTN setting of the room profile is enabled.
	PSTNEnabled *bool `type:"boolean"`

	// The ARN of the room profile to update. Required.
	ProfileArn *string `type:"string"`

	// The updated name for the room profile.
	ProfileName *string `min:"1" type:"string"`

	// Whether the setup mode of the profile is enabled.
	SetupModeDisabled *bool `type:"boolean"`

	// The updated temperature unit for the room profile.
	TemperatureUnit *string `type:"string" enum:"TemperatureUnit"`

	// The updated timezone for the room profile.
	Timezone *string `min:"1" type:"string"`

	// The updated wake word for the room profile.
	WakeWord *string `type:"string" enum:"WakeWord"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProfileInput"}
	if s.Address != nil && len(*s.Address) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Address", 1))
	}
	if s.Locale != nil && len(*s.Locale) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Locale", 1))
	}
	if s.ProfileName != nil && len(*s.ProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileName", 1))
	}
	if s.Timezone != nil && len(*s.Timezone) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Timezone", 1))
	}
	if s.MeetingRoomConfiguration != nil {
		if err := s.MeetingRoomConfiguration.Validate(); err != nil {
			invalidParams.AddNested("MeetingRoomConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddress sets the Address field's value.
func (s *UpdateProfileInput) SetAddress(v string) *UpdateProfileInput {
	s.Address = &v
	return s
}

// SetDataRetentionOptIn sets the DataRetentionOptIn field's value.
func (s *UpdateProfileInput) SetDataRetentionOptIn(v bool) *UpdateProfileInput {
	s.DataRetentionOptIn = &v
	return s
}

// SetDistanceUnit sets the DistanceUnit field's value.
func (s *UpdateProfileInput) SetDistanceUnit(v string) *UpdateProfileInput {
	s.DistanceUnit = &v
	return s
}

// SetIsDefault sets the IsDefault field's value.
func (s *UpdateProfileInput) SetIsDefault(v bool) *UpdateProfileInput {
	s.IsDefault = &v
	return s
}

// SetLocale sets the Locale field's value.
func (s *UpdateProfileInput) SetLocale(v string) *UpdateProfileInput {
	s.Locale = &v
	return s
}

// SetMaxVolumeLimit sets the MaxVolumeLimit field's value.
func (s *UpdateProfileInput) SetMaxVolumeLimit(v int64) *UpdateProfileInput {
	s.MaxVolumeLimit = &v
	return s
}

// SetMeetingRoomConfiguration sets the MeetingRoomConfiguration field's value.
func (s *UpdateProfileInput) SetMeetingRoomConfiguration(v *UpdateMeetingRoomConfiguration) *UpdateProfileInput {
	s.MeetingRoomConfiguration = v
	return s
}

// SetPSTNEnabled sets the PSTNEnabled field's value.
func (s *UpdateProfileInput) SetPSTNEnabled(v bool) *UpdateProfileInput {
	s.PSTNEnabled = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *UpdateProfileInput) SetProfileArn(v string) *UpdateProfileInput {
	s.ProfileArn = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *UpdateProfileInput) SetProfileName(v string) *UpdateProfileInput {
	s.ProfileName = &v
	return s
}

// SetSetupModeDisabled sets the SetupModeDisabled field's value.
func (s *UpdateProfileInput) SetSetupModeDisabled(v bool) *UpdateProfileInput {
	s.SetupModeDisabled = &v
	return s
}

// SetTemperatureUnit sets the TemperatureUnit field's value.
func (s *UpdateProfileInput) SetTemperatureUnit(v string) *UpdateProfileInput {
	s.TemperatureUnit = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *UpdateProfileInput) SetTimezone(v string) *UpdateProfileInput {
	s.Timezone = &v
	return s
}

// SetWakeWord sets the WakeWord field's value.
func (s *UpdateProfileInput) SetWakeWord(v string) *UpdateProfileInput {
	s.WakeWord = &v
	return s
}

type UpdateProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileOutput) GoString() string {
	return s.String()
}

// Updates settings for the require check in feature that are applied to a room
// profile. Require check in allows a meeting room’s Alexa or AVS device to
// prompt the user to check in; otherwise, the room will be released.
type UpdateRequireCheckIn struct {
	_ struct{} `type:"structure"`

	// Whether require check in is enabled or not.
	Enabled *bool `type:"boolean"`

	// Duration between 5 and 20 minutes to determine when to release the room if
	// it's not checked into.
	ReleaseAfterMinutes *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRequireCheckIn) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRequireCheckIn) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *UpdateRequireCheckIn) SetEnabled(v bool) *UpdateRequireCheckIn {
	s.Enabled = &v
	return s
}

// SetReleaseAfterMinutes sets the ReleaseAfterMinutes field's value.
func (s *UpdateRequireCheckIn) SetReleaseAfterMinutes(v int64) *UpdateRequireCheckIn {
	s.ReleaseAfterMinutes = &v
	return s
}

type UpdateRoomInput struct {
	_ struct{} `type:"structure"`

	// The updated description for the room.
	Description *string `min:"1" type:"string"`

	// The updated profile ARN for the room.
	ProfileArn *string `type:"string"`

	// The updated provider calendar ARN for the room.
	ProviderCalendarId *string `type:"string"`

	// The ARN of the room to update.
	RoomArn *string `type:"string"`

	// The updated name for the room.
	RoomName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRoomInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRoomInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRoomInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.RoomName != nil && len(*s.RoomName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoomName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateRoomInput) SetDescription(v string) *UpdateRoomInput {
	s.Description = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *UpdateRoomInput) SetProfileArn(v string) *UpdateRoomInput {
	s.ProfileArn = &v
	return s
}

// SetProviderCalendarId sets the ProviderCalendarId field's value.
func (s *UpdateRoomInput) SetProviderCalendarId(v string) *UpdateRoomInput {
	s.ProviderCalendarId = &v
	return s
}

// SetRoomArn sets the RoomArn field's value.
func (s *UpdateRoomInput) SetRoomArn(v string) *UpdateRoomInput {
	s.RoomArn = &v
	return s
}

// SetRoomName sets the RoomName field's value.
func (s *UpdateRoomInput) SetRoomName(v string) *UpdateRoomInput {
	s.RoomName = &v
	return s
}

type UpdateRoomOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRoomOutput) GoString() string {
	return s.String()
}

type UpdateSkillGroupInput struct {
	_ struct{} `type:"structure"`

	// The updated description for the skill group.
	Description *string `min:"1" type:"string"`

	// The ARN of the skill group to update.
	SkillGroupArn *string `type:"string"`

	// The updated name for the skill group.
	SkillGroupName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSkillGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSkillGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSkillGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSkillGroupInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.SkillGroupName != nil && len(*s.SkillGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SkillGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateSkillGroupInput) SetDescription(v string) *UpdateSkillGroupInput {
	s.Description = &v
	return s
}

// SetSkillGroupArn sets the SkillGroupArn field's value.
func (s *UpdateSkillGroupInput) SetSkillGroupArn(v string) *UpdateSkillGroupInput {
	s.SkillGroupArn = &v
	return s
}

// SetSkillGroupName sets the SkillGroupName field's value.
func (s *UpdateSkillGroupInput) SetSkillGroupName(v string) *UpdateSkillGroupInput {
	s.SkillGroupName = &v
	return s
}

type UpdateSkillGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSkillGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSkillGroupOutput) GoString() string {
	return s.String()
}

// Information related to a user.
type UserData struct {
	_ struct{} `type:"structure"`

	// The email of a user.
	Email *string `min:"1" type:"string"`

	// The enrollment ARN of a user.
	EnrollmentId *string `type:"string"`

	// The enrollment status of a user.
	EnrollmentStatus *string `type:"string" enum:"EnrollmentStatus"`

	// The first name of a user.
	FirstName *string `type:"string"`

	// The last name of a user.
	LastName *string `type:"string"`

	// The ARN of a user.
	UserArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserData) GoString() string {
	return s.String()
}

// SetEmail sets the Email field's value.
func (s *UserData) SetEmail(v string) *UserData {
	s.Email = &v
	return s
}

// SetEnrollmentId sets the EnrollmentId field's value.
func (s *UserData) SetEnrollmentId(v string) *UserData {
	s.EnrollmentId = &v
	return s
}

// SetEnrollmentStatus sets the EnrollmentStatus field's value.
func (s *UserData) SetEnrollmentStatus(v string) *UserData {
	s.EnrollmentStatus = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *UserData) SetFirstName(v string) *UserData {
	s.FirstName = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *UserData) SetLastName(v string) *UserData {
	s.LastName = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *UserData) SetUserArn(v string) *UserData {
	s.UserArn = &v
	return s
}

const (
	// BusinessReportFailureCodeAccessDenied is a BusinessReportFailureCode enum value
	BusinessReportFailureCodeAccessDenied = "ACCESS_DENIED"

	// BusinessReportFailureCodeNoSuchBucket is a BusinessReportFailureCode enum value
	BusinessReportFailureCodeNoSuchBucket = "NO_SUCH_BUCKET"

	// BusinessReportFailureCodeInternalFailure is a BusinessReportFailureCode enum value
	BusinessReportFailureCodeInternalFailure = "INTERNAL_FAILURE"
)

// BusinessReportFailureCode_Values returns all elements of the BusinessReportFailureCode enum
func BusinessReportFailureCode_Values() []string {
	return []string{
		BusinessReportFailureCodeAccessDenied,
		BusinessReportFailureCodeNoSuchBucket,
		BusinessReportFailureCodeInternalFailure,
	}
}

const (
	// BusinessReportFormatCsv is a BusinessReportFormat enum value
	BusinessReportFormatCsv = "CSV"

	// BusinessReportFormatCsvZip is a BusinessReportFormat enum value
	BusinessReportFormatCsvZip = "CSV_ZIP"
)

// BusinessReportFormat_Values returns all elements of the BusinessReportFormat enum
func BusinessReportFormat_Values() []string {
	return []string{
		BusinessReportFormatCsv,
		BusinessReportFormatCsvZip,
	}
}

const (
	// BusinessReportIntervalOneDay is a BusinessReportInterval enum value
	BusinessReportIntervalOneDay = "ONE_DAY"

	// BusinessReportIntervalOneWeek is a BusinessReportInterval enum value
	BusinessReportIntervalOneWeek = "ONE_WEEK"

	// BusinessReportIntervalThirtyDays is a BusinessReportInterval enum value
	BusinessReportIntervalThirtyDays = "THIRTY_DAYS"
)

// BusinessReportInterval_Values returns all elements of the BusinessReportInterval enum
func BusinessReportInterval_Values() []string {
	return []string{
		BusinessReportIntervalOneDay,
		BusinessReportIntervalOneWeek,
		BusinessReportIntervalThirtyDays,
	}
}

const (
	// BusinessReportStatusRunning is a BusinessReportStatus enum value
	BusinessReportStatusRunning = "RUNNING"

	// BusinessReportStatusSucceeded is a BusinessReportStatus enum value
	BusinessReportStatusSucceeded = "SUCCEEDED"

	// BusinessReportStatusFailed is a BusinessReportStatus enum value
	BusinessReportStatusFailed = "FAILED"
)

// BusinessReportStatus_Values returns all elements of the BusinessReportStatus enum
func BusinessReportStatus_Values() []string {
	return []string{
		BusinessReportStatusRunning,
		BusinessReportStatusSucceeded,
		BusinessReportStatusFailed,
	}
}

const (
	// CommsProtocolSip is a CommsProtocol enum value
	CommsProtocolSip = "SIP"

	// CommsProtocolSips is a CommsProtocol enum value
	CommsProtocolSips = "SIPS"

	// CommsProtocolH323 is a CommsProtocol enum value
	CommsProtocolH323 = "H323"
)

// CommsProtocol_Values returns all elements of the CommsProtocol enum
func CommsProtocol_Values() []string {
	return []string{
		CommsProtocolSip,
		CommsProtocolSips,
		CommsProtocolH323,
	}
}

const (
	// ConferenceProviderTypeChime is a ConferenceProviderType enum value
	ConferenceProviderTypeChime = "CHIME"

	// ConferenceProviderTypeBluejeans is a ConferenceProviderType enum value
	ConferenceProviderTypeBluejeans = "BLUEJEANS"

	// ConferenceProviderTypeFuze is a ConferenceProviderType enum value
	ConferenceProviderTypeFuze = "FUZE"

	// ConferenceProviderTypeGoogleHangouts is a ConferenceProviderType enum value
	ConferenceProviderTypeGoogleHangouts = "GOOGLE_HANGOUTS"

	// ConferenceProviderTypePolycom is a ConferenceProviderType enum value
	ConferenceProviderTypePolycom = "POLYCOM"

	// ConferenceProviderTypeRingcentral is a ConferenceProviderType enum value
	ConferenceProviderTypeRingcentral = "RINGCENTRAL"

	// ConferenceProviderTypeSkypeForBusiness is a ConferenceProviderType enum value
	ConferenceProviderTypeSkypeForBusiness = "SKYPE_FOR_BUSINESS"

	// ConferenceProviderTypeWebex is a ConferenceProviderType enum value
	ConferenceProviderTypeWebex = "WEBEX"

	// ConferenceProviderTypeZoom is a ConferenceProviderType enum value
	ConferenceProviderTypeZoom = "ZOOM"

	// ConferenceProviderTypeCustom is a ConferenceProviderType enum value
	ConferenceProviderTypeCustom = "CUSTOM"
)

// ConferenceProviderType_Values returns all elements of the ConferenceProviderType enum
func ConferenceProviderType_Values() []string {
	return []string{
		ConferenceProviderTypeChime,
		ConferenceProviderTypeBluejeans,
		ConferenceProviderTypeFuze,
		ConferenceProviderTypeGoogleHangouts,
		ConferenceProviderTypePolycom,
		ConferenceProviderTypeRingcentral,
		ConferenceProviderTypeSkypeForBusiness,
		ConferenceProviderTypeWebex,
		ConferenceProviderTypeZoom,
		ConferenceProviderTypeCustom,
	}
}

const (
	// ConnectionStatusOnline is a ConnectionStatus enum value
	ConnectionStatusOnline = "ONLINE"

	// ConnectionStatusOffline is a ConnectionStatus enum value
	ConnectionStatusOffline = "OFFLINE"
)

// ConnectionStatus_Values returns all elements of the ConnectionStatus enum
func ConnectionStatus_Values() []string {
	return []string{
		ConnectionStatusOnline,
		ConnectionStatusOffline,
	}
}

const (
	// DeviceEventTypeConnectionStatus is a DeviceEventType enum value
	DeviceEventTypeConnectionStatus = "CONNECTION_STATUS"

	// DeviceEventTypeDeviceStatus is a DeviceEventType enum value
	DeviceEventTypeDeviceStatus = "DEVICE_STATUS"
)

// DeviceEventType_Values returns all elements of the DeviceEventType enum
func DeviceEventType_Values() []string {
	return []string{
		DeviceEventTypeConnectionStatus,
		DeviceEventTypeDeviceStatus,
	}
}

const (
	// DeviceStatusReady is a DeviceStatus enum value
	DeviceStatusReady = "READY"

	// DeviceStatusPending is a DeviceStatus enum value
	DeviceStatusPending = "PENDING"

	// DeviceStatusWasOffline is a DeviceStatus enum value
	DeviceStatusWasOffline = "WAS_OFFLINE"

	// DeviceStatusDeregistered is a DeviceStatus enum value
	DeviceStatusDeregistered = "DEREGISTERED"

	// DeviceStatusFailed is a DeviceStatus enum value
	DeviceStatusFailed = "FAILED"
)

// DeviceStatus_Values returns all elements of the DeviceStatus enum
func DeviceStatus_Values() []string {
	return []string{
		DeviceStatusReady,
		DeviceStatusPending,
		DeviceStatusWasOffline,
		DeviceStatusDeregistered,
		DeviceStatusFailed,
	}
}

const (
	// DeviceStatusDetailCodeDeviceSoftwareUpdateNeeded is a DeviceStatusDetailCode enum value
	DeviceStatusDetailCodeDeviceSoftwareUpdateNeeded = "DEVICE_SOFTWARE_UPDATE_NEEDED"

	// DeviceStatusDetailCodeDeviceWasOffline is a DeviceStatusDetailCode enum value
	DeviceStatusDetailCodeDeviceWasOffline = "DEVICE_WAS_OFFLINE"

	// DeviceStatusDetailCodeCredentialsAccessFailure is a DeviceStatusDetailCode enum value
	DeviceStatusDetailCodeCredentialsAccessFailure = "CREDENTIALS_ACCESS_FAILURE"

	// DeviceStatusDetailCodeTlsVersionMismatch is a DeviceStatusDetailCode enum value
	DeviceStatusDetailCodeTlsVersionMismatch = "TLS_VERSION_MISMATCH"

	// DeviceStatusDetailCodeAssociationRejection is a DeviceStatusDetailCode enum value
	DeviceStatusDetailCodeAssociationRejection = "ASSOCIATION_REJECTION"

	// DeviceStatusDetailCodeAuthenticationFailure is a DeviceStatusDetailCode enum value
	DeviceStatusDetailCodeAuthenticationFailure = "AUTHENTICATION_FAILURE"

	// DeviceStatusDetailCodeDhcpFailure is a DeviceStatusDetailCode enum value
	DeviceStatusDetailCodeDhcpFailure = "DHCP_FAILURE"

	// DeviceStatusDetailCodeInternetUnavailable is a DeviceStatusDetailCode enum value
	DeviceStatusDetailCodeInternetUnavailable = "INTERNET_UNAVAILABLE"

	// DeviceStatusDetailCodeDnsFailure is a DeviceStatusDetailCode enum value
	DeviceStatusDetailCodeDnsFailure = "DNS_FAILURE"

	// DeviceStatusDetailCodeUnknownFailure is a DeviceStatusDetailCode enum value
	DeviceStatusDetailCodeUnknownFailure = "UNKNOWN_FAILURE"

	// DeviceStatusDetailCodeCertificateIssuingLimitExceeded is a DeviceStatusDetailCode enum value
	DeviceStatusDetailCodeCertificateIssuingLimitExceeded = "CERTIFICATE_ISSUING_LIMIT_EXCEEDED"

	// DeviceStatusDetailCodeInvalidCertificateAuthority is a DeviceStatusDetailCode enum value
	DeviceStatusDetailCodeInvalidCertificateAuthority = "INVALID_CERTIFICATE_AUTHORITY"

	// DeviceStatusDetailCodeNetworkProfileNotFound is a DeviceStatusDetailCode enum value
	DeviceStatusDetailCodeNetworkProfileNotFound = "NETWORK_PROFILE_NOT_FOUND"

	// DeviceStatusDetailCodeInvalidPasswordState is a DeviceStatusDetailCode enum value
	DeviceStatusDetailCodeInvalidPasswordState = "INVALID_PASSWORD_STATE"

	// DeviceStatusDetailCodePasswordNotFound is a DeviceStatusDetailCode enum value
	DeviceStatusDetailCodePasswordNotFound = "PASSWORD_NOT_FOUND"

	// DeviceStatusDetailCodePasswordManagerAccessDenied is a DeviceStatusDetailCode enum value
	DeviceStatusDetailCodePasswordManagerAccessDenied = "PASSWORD_MANAGER_ACCESS_DENIED"

	// DeviceStatusDetailCodeCertificateAuthorityAccessDenied is a DeviceStatusDetailCode enum value
	DeviceStatusDetailCodeCertificateAuthorityAccessDenied = "CERTIFICATE_AUTHORITY_ACCESS_DENIED"
)

// DeviceStatusDetailCode_Values returns all elements of the DeviceStatusDetailCode enum
func DeviceStatusDetailCode_Values() []string {
	return []string{
		DeviceStatusDetailCodeDeviceSoftwareUpdateNeeded,
		DeviceStatusDetailCodeDeviceWasOffline,
		DeviceStatusDetailCodeCredentialsAccessFailure,
		DeviceStatusDetailCodeTlsVersionMismatch,
		DeviceStatusDetailCodeAssociationRejection,
		DeviceStatusDetailCodeAuthenticationFailure,
		DeviceStatusDetailCodeDhcpFailure,
		DeviceStatusDetailCodeInternetUnavailable,
		DeviceStatusDetailCodeDnsFailure,
		DeviceStatusDetailCodeUnknownFailure,
		DeviceStatusDetailCodeCertificateIssuingLimitExceeded,
		DeviceStatusDetailCodeInvalidCertificateAuthority,
		DeviceStatusDetailCodeNetworkProfileNotFound,
		DeviceStatusDetailCodeInvalidPasswordState,
		DeviceStatusDetailCodePasswordNotFound,
		DeviceStatusDetailCodePasswordManagerAccessDenied,
		DeviceStatusDetailCodeCertificateAuthorityAccessDenied,
	}
}

const (
	// DeviceUsageTypeVoice is a DeviceUsageType enum value
	DeviceUsageTypeVoice = "VOICE"
)

// DeviceUsageType_Values returns all elements of the DeviceUsageType enum
func DeviceUsageType_Values() []string {
	return []string{
		DeviceUsageTypeVoice,
	}
}

const (
	// DistanceUnitMetric is a DistanceUnit enum value
	DistanceUnitMetric = "METRIC"

	// DistanceUnitImperial is a DistanceUnit enum value
	DistanceUnitImperial = "IMPERIAL"
)

// DistanceUnit_Values returns all elements of the DistanceUnit enum
func DistanceUnit_Values() []string {
	return []string{
		DistanceUnitMetric,
		DistanceUnitImperial,
	}
}

const (
	// EnablementTypeEnabled is a EnablementType enum value
	EnablementTypeEnabled = "ENABLED"

	// EnablementTypePending is a EnablementType enum value
	EnablementTypePending = "PENDING"
)

// EnablementType_Values returns all elements of the EnablementType enum
func EnablementType_Values() []string {
	return []string{
		EnablementTypeEnabled,
		EnablementTypePending,
	}
}

const (
	// EnablementTypeFilterEnabled is a EnablementTypeFilter enum value
	EnablementTypeFilterEnabled = "ENABLED"

	// EnablementTypeFilterPending is a EnablementTypeFilter enum value
	EnablementTypeFilterPending = "PENDING"
)

// EnablementTypeFilter_Values returns all elements of the EnablementTypeFilter enum
func EnablementTypeFilter_Values() []string {
	return []string{
		EnablementTypeFilterEnabled,
		EnablementTypeFilterPending,
	}
}

const (
	// EndOfMeetingReminderTypeAnnouncementTimeCheck is a EndOfMeetingReminderType enum value
	EndOfMeetingReminderTypeAnnouncementTimeCheck = "ANNOUNCEMENT_TIME_CHECK"

	// EndOfMeetingReminderTypeAnnouncementVariableTimeLeft is a EndOfMeetingReminderType enum value
	EndOfMeetingReminderTypeAnnouncementVariableTimeLeft = "ANNOUNCEMENT_VARIABLE_TIME_LEFT"

	// EndOfMeetingReminderTypeChime is a EndOfMeetingReminderType enum value
	EndOfMeetingReminderTypeChime = "CHIME"

	// EndOfMeetingReminderTypeKnock is a EndOfMeetingReminderType enum value
	EndOfMeetingReminderTypeKnock = "KNOCK"
)

// EndOfMeetingReminderType_Values returns all elements of the EndOfMeetingReminderType enum
func EndOfMeetingReminderType_Values() []string {
	return []string{
		EndOfMeetingReminderTypeAnnouncementTimeCheck,
		EndOfMeetingReminderTypeAnnouncementVariableTimeLeft,
		EndOfMeetingReminderTypeChime,
		EndOfMeetingReminderTypeKnock,
	}
}

const (
	// EnrollmentStatusInitialized is a EnrollmentStatus enum value
	EnrollmentStatusInitialized = "INITIALIZED"

	// EnrollmentStatusPending is a EnrollmentStatus enum value
	EnrollmentStatusPending = "PENDING"

	// EnrollmentStatusRegistered is a EnrollmentStatus enum value
	EnrollmentStatusRegistered = "REGISTERED"

	// EnrollmentStatusDisassociating is a EnrollmentStatus enum value
	EnrollmentStatusDisassociating = "DISASSOCIATING"

	// EnrollmentStatusDeregistering is a EnrollmentStatus enum value
	EnrollmentStatusDeregistering = "DEREGISTERING"
)

// EnrollmentStatus_Values returns all elements of the EnrollmentStatus enum
func EnrollmentStatus_Values() []string {
	return []string{
		EnrollmentStatusInitialized,
		EnrollmentStatusPending,
		EnrollmentStatusRegistered,
		EnrollmentStatusDisassociating,
		EnrollmentStatusDeregistering,
	}
}

const (
	// FeatureBluetooth is a Feature enum value
	FeatureBluetooth = "BLUETOOTH"

	// FeatureVolume is a Feature enum value
	FeatureVolume = "VOLUME"

	// FeatureNotifications is a Feature enum value
	FeatureNotifications = "NOTIFICATIONS"

	// FeatureLists is a Feature enum value
	FeatureLists = "LISTS"

	// FeatureSkills is a Feature enum value
	FeatureSkills = "SKILLS"

	// FeatureNetworkProfile is a Feature enum value
	FeatureNetworkProfile = "NETWORK_PROFILE"

	// FeatureSettings is a Feature enum value
	FeatureSettings = "SETTINGS"

	// FeatureAll is a Feature enum value
	FeatureAll = "ALL"
)

// Feature_Values returns all elements of the Feature enum
func Feature_Values() []string {
	return []string{
		FeatureBluetooth,
		FeatureVolume,
		FeatureNotifications,
		FeatureLists,
		FeatureSkills,
		FeatureNetworkProfile,
		FeatureSettings,
		FeatureAll,
	}
}

const (
	// LocaleEnUs is a Locale enum value
	LocaleEnUs = "en-US"
)

// Locale_Values returns all elements of the Locale enum
func Locale_Values() []string {
	return []string{
		LocaleEnUs,
	}
}

const (
	// NetworkEapMethodEapTls is a NetworkEapMethod enum value
	NetworkEapMethodEapTls = "EAP_TLS"
)

// NetworkEapMethod_Values returns all elements of the NetworkEapMethod enum
func NetworkEapMethod_Values() []string {
	return []string{
		NetworkEapMethodEapTls,
	}
}

const (
	// NetworkSecurityTypeOpen is a NetworkSecurityType enum value
	NetworkSecurityTypeOpen = "OPEN"

	// NetworkSecurityTypeWep is a NetworkSecurityType enum value
	NetworkSecurityTypeWep = "WEP"

	// NetworkSecurityTypeWpaPsk is a NetworkSecurityType enum value
	NetworkSecurityTypeWpaPsk = "WPA_PSK"

	// NetworkSecurityTypeWpa2Psk is a NetworkSecurityType enum value
	NetworkSecurityTypeWpa2Psk = "WPA2_PSK"

	// NetworkSecurityTypeWpa2Enterprise is a NetworkSecurityType enum value
	NetworkSecurityTypeWpa2Enterprise = "WPA2_ENTERPRISE"
)

// NetworkSecurityType_Values returns all elements of the NetworkSecurityType enum
func NetworkSecurityType_Values() []string {
	return []string{
		NetworkSecurityTypeOpen,
		NetworkSecurityTypeWep,
		NetworkSecurityTypeWpaPsk,
		NetworkSecurityTypeWpa2Psk,
		NetworkSecurityTypeWpa2Enterprise,
	}
}

const (
	// PhoneNumberTypeMobile is a PhoneNumberType enum value
	PhoneNumberTypeMobile = "MOBILE"

	// PhoneNumberTypeWork is a PhoneNumberType enum value
	PhoneNumberTypeWork = "WORK"

	// PhoneNumberTypeHome is a PhoneNumberType enum value
	PhoneNumberTypeHome = "HOME"
)

// PhoneNumberType_Values returns all elements of the PhoneNumberType enum
func PhoneNumberType_Values() []string {
	return []string{
		PhoneNumberTypeMobile,
		PhoneNumberTypeWork,
		PhoneNumberTypeHome,
	}
}

const (
	// RequirePinYes is a RequirePin enum value
	RequirePinYes = "YES"

	// RequirePinNo is a RequirePin enum value
	RequirePinNo = "NO"

	// RequirePinOptional is a RequirePin enum value
	RequirePinOptional = "OPTIONAL"
)

// RequirePin_Values returns all elements of the RequirePin enum
func RequirePin_Values() []string {
	return []string{
		RequirePinYes,
		RequirePinNo,
		RequirePinOptional,
	}
}

const (
	// SipTypeWork is a SipType enum value
	SipTypeWork = "WORK"
)

// SipType_Values returns all elements of the SipType enum
func SipType_Values() []string {
	return []string{
		SipTypeWork,
	}
}

const (
	// SkillTypePublic is a SkillType enum value
	SkillTypePublic = "PUBLIC"

	// SkillTypePrivate is a SkillType enum value
	SkillTypePrivate = "PRIVATE"
)

// SkillType_Values returns all elements of the SkillType enum
func SkillType_Values() []string {
	return []string{
		SkillTypePublic,
		SkillTypePrivate,
	}
}

const (
	// SkillTypeFilterPublic is a SkillTypeFilter enum value
	SkillTypeFilterPublic = "PUBLIC"

	// SkillTypeFilterPrivate is a SkillTypeFilter enum value
	SkillTypeFilterPrivate = "PRIVATE"

	// SkillTypeFilterAll is a SkillTypeFilter enum value
	SkillTypeFilterAll = "ALL"
)

// SkillTypeFilter_Values returns all elements of the SkillTypeFilter enum
func SkillTypeFilter_Values() []string {
	return []string{
		SkillTypeFilterPublic,
		SkillTypeFilterPrivate,
		SkillTypeFilterAll,
	}
}

const (
	// SortValueAsc is a SortValue enum value
	SortValueAsc = "ASC"

	// SortValueDesc is a SortValue enum value
	SortValueDesc = "DESC"
)

// SortValue_Values returns all elements of the SortValue enum
func SortValue_Values() []string {
	return []string{
		SortValueAsc,
		SortValueDesc,
	}
}

const (
	// TemperatureUnitFahrenheit is a TemperatureUnit enum value
	TemperatureUnitFahrenheit = "FAHRENHEIT"

	// TemperatureUnitCelsius is a TemperatureUnit enum value
	TemperatureUnitCelsius = "CELSIUS"
)

// TemperatureUnit_Values returns all elements of the TemperatureUnit enum
func TemperatureUnit_Values() []string {
	return []string{
		TemperatureUnitFahrenheit,
		TemperatureUnitCelsius,
	}
}

const (
	// WakeWordAlexa is a WakeWord enum value
	WakeWordAlexa = "ALEXA"

	// WakeWordAmazon is a WakeWord enum value
	WakeWordAmazon = "AMAZON"

	// WakeWordEcho is a WakeWord enum value
	WakeWordEcho = "ECHO"

	// WakeWordComputer is a WakeWord enum value
	WakeWordComputer = "COMPUTER"
)

// WakeWord_Values returns all elements of the WakeWord enum
func WakeWord_Values() []string {
	return []string{
		WakeWordAlexa,
		WakeWordAmazon,
		WakeWordEcho,
		WakeWordComputer,
	}
}
