// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package securitylake

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateAwsLogSource = "CreateAwsLogSource"

// CreateAwsLogSourceRequest generates a "aws/request.Request" representing the
// client's request for the CreateAwsLogSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAwsLogSource for more information on using the CreateAwsLogSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAwsLogSourceRequest method.
//	req, resp := client.CreateAwsLogSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateAwsLogSource
func (c *SecurityLake) CreateAwsLogSourceRequest(input *CreateAwsLogSourceInput) (req *request.Request, output *CreateAwsLogSourceOutput) {
	op := &request.Operation{
		Name:       opCreateAwsLogSource,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/logsources/aws",
	}

	if input == nil {
		input = &CreateAwsLogSourceInput{}
	}

	output = &CreateAwsLogSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAwsLogSource API operation for Amazon Security Lake.
//
// Adds a natively-supported Amazon Web Services service as a Security Lake
// source. Enables source types for member accounts in required Regions, based
// on specified parameters. You can choose any source type in any Region for
// accounts that are either part of a trusted organization or standalone accounts.
// At least one of the three dimensions is a mandatory input to this API. However,
// any combination of the three dimensions can be supplied to this API.
//
// By default, dimension refers to the entire set. When you don't provide a
// dimension, Security Lake assumes that the missing dimension refers to the
// entire set. This is overridden when you supply any one of the inputs. For
// instance, when members is not specified, the API disables all Security Lake
// member accounts for sources. Similarly, when Regions are not specified, Security
// Lake is disabled for all the Regions where Security Lake is available as
// a service.
//
// You can use this API only to enable a natively-supported Amazon Web Services
// services as a source. Use CreateCustomLogSource to enable data collection
// from a custom source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation CreateAwsLogSource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - S3Exception
//     Provides an extension of the AmazonServiceException for errors reported by
//     Amazon S3 while processing a request. In particular, this class provides
//     access to Amazon S3's extended request ID. This ID is required debugging
//     information in the case the user needs to contact Amazon about an issue where
//     Amazon S3 is incorrectly handling a request.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccountNotFoundException
//     Amazon Security Lake can't find an Amazon Web Services account with the accountID
//     that you specified, or the account whose credentials you used to make this
//     request isn't a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateAwsLogSource
func (c *SecurityLake) CreateAwsLogSource(input *CreateAwsLogSourceInput) (*CreateAwsLogSourceOutput, error) {
	req, out := c.CreateAwsLogSourceRequest(input)
	return out, req.Send()
}

// CreateAwsLogSourceWithContext is the same as CreateAwsLogSource with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAwsLogSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) CreateAwsLogSourceWithContext(ctx aws.Context, input *CreateAwsLogSourceInput, opts ...request.Option) (*CreateAwsLogSourceOutput, error) {
	req, out := c.CreateAwsLogSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCustomLogSource = "CreateCustomLogSource"

// CreateCustomLogSourceRequest generates a "aws/request.Request" representing the
// client's request for the CreateCustomLogSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCustomLogSource for more information on using the CreateCustomLogSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCustomLogSourceRequest method.
//	req, resp := client.CreateCustomLogSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateCustomLogSource
func (c *SecurityLake) CreateCustomLogSourceRequest(input *CreateCustomLogSourceInput) (req *request.Request, output *CreateCustomLogSourceOutput) {
	op := &request.Operation{
		Name:       opCreateCustomLogSource,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/logsources/custom",
	}

	if input == nil {
		input = &CreateCustomLogSourceInput{}
	}

	output = &CreateCustomLogSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCustomLogSource API operation for Amazon Security Lake.
//
// Adds a third-party custom source in Amazon Security Lake, from the Region
// where you want to create a custom source. Security Lake can collect logs
// and events from third-party custom sources. After creating the appropriate
// API roles, use this API to add a custom source name in Security Lake. This
// operation creates a partition in the Security Lake S3 bucket as the target
// location for log files from the custom source, an associated Glue table,
// and an Glue crawler.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation CreateCustomLogSource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - ConflictSourceNamesException
//     There was a conflict when you attempted to modify a Security Lake source
//     name.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - BucketNotFoundException
//     Amazon Security Lake generally returns 404 errors if the requested object
//     is missing from the bucket.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccountNotFoundException
//     Amazon Security Lake can't find an Amazon Web Services account with the accountID
//     that you specified, or the account whose credentials you used to make this
//     request isn't a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateCustomLogSource
func (c *SecurityLake) CreateCustomLogSource(input *CreateCustomLogSourceInput) (*CreateCustomLogSourceOutput, error) {
	req, out := c.CreateCustomLogSourceRequest(input)
	return out, req.Send()
}

// CreateCustomLogSourceWithContext is the same as CreateCustomLogSource with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCustomLogSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) CreateCustomLogSourceWithContext(ctx aws.Context, input *CreateCustomLogSourceInput, opts ...request.Option) (*CreateCustomLogSourceOutput, error) {
	req, out := c.CreateCustomLogSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDatalake = "CreateDatalake"

// CreateDatalakeRequest generates a "aws/request.Request" representing the
// client's request for the CreateDatalake operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDatalake for more information on using the CreateDatalake
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDatalakeRequest method.
//	req, resp := client.CreateDatalakeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDatalake
func (c *SecurityLake) CreateDatalakeRequest(input *CreateDatalakeInput) (req *request.Request, output *CreateDatalakeOutput) {
	op := &request.Operation{
		Name:       opCreateDatalake,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/datalake",
	}

	if input == nil {
		input = &CreateDatalakeInput{}
	}

	output = &CreateDatalakeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateDatalake API operation for Amazon Security Lake.
//
// Initializes an Amazon Security Lake instance with the provided (or default)
// configuration. You can enable Security Lake in Regions with customized settings
// in advance before enabling log collection in Regions. You can either use
// the enableAll parameter to specify all Regions or you can specify the Regions
// you want to enable Security Lake using the Regions parameter and configure
// these Regions using the configurations parameter. When the CreateDataLake
// API is called multiple times, if that Region is already enabled, it will
// update the Region if configuration for that Region is provided. If that Region
// is a new Region, it will be set up with the customized configurations if
// it is specified.
//
// When you enable Security Lake, it starts ingesting security data after the
// CreateAwsLogSource call. This includes ingesting security data from sources,
// storing data, and making data accessible to subscribers. Security Lake also
// enables all the existing settings and resources that it stores or maintains
// for your account in the current Region, including security log and event
// data. For more information, see the Amazon Security Lake User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation CreateDatalake for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     You have exceeded your service quota. To perform the requested action, remove
//     some of the relevant resources, or use Service Quotas to request a service
//     quota increase.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDatalake
func (c *SecurityLake) CreateDatalake(input *CreateDatalakeInput) (*CreateDatalakeOutput, error) {
	req, out := c.CreateDatalakeRequest(input)
	return out, req.Send()
}

// CreateDatalakeWithContext is the same as CreateDatalake with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDatalake for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) CreateDatalakeWithContext(ctx aws.Context, input *CreateDatalakeInput, opts ...request.Option) (*CreateDatalakeOutput, error) {
	req, out := c.CreateDatalakeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDatalakeAutoEnable = "CreateDatalakeAutoEnable"

// CreateDatalakeAutoEnableRequest generates a "aws/request.Request" representing the
// client's request for the CreateDatalakeAutoEnable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDatalakeAutoEnable for more information on using the CreateDatalakeAutoEnable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDatalakeAutoEnableRequest method.
//	req, resp := client.CreateDatalakeAutoEnableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDatalakeAutoEnable
func (c *SecurityLake) CreateDatalakeAutoEnableRequest(input *CreateDatalakeAutoEnableInput) (req *request.Request, output *CreateDatalakeAutoEnableOutput) {
	op := &request.Operation{
		Name:       opCreateDatalakeAutoEnable,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/datalake/autoenable",
	}

	if input == nil {
		input = &CreateDatalakeAutoEnableInput{}
	}

	output = &CreateDatalakeAutoEnableOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateDatalakeAutoEnable API operation for Amazon Security Lake.
//
// Automatically enable Security Lake in the specified Regions to begin ingesting
// security data. When you choose to enable organization accounts automatically,
// then Security Lake begins to enable new accounts as member accounts as they
// are added to the organization. Security Lake does not enable existing organization
// accounts that are not yet enabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation CreateDatalakeAutoEnable for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - AccountNotFoundException
//     Amazon Security Lake can't find an Amazon Web Services account with the accountID
//     that you specified, or the account whose credentials you used to make this
//     request isn't a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDatalakeAutoEnable
func (c *SecurityLake) CreateDatalakeAutoEnable(input *CreateDatalakeAutoEnableInput) (*CreateDatalakeAutoEnableOutput, error) {
	req, out := c.CreateDatalakeAutoEnableRequest(input)
	return out, req.Send()
}

// CreateDatalakeAutoEnableWithContext is the same as CreateDatalakeAutoEnable with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDatalakeAutoEnable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) CreateDatalakeAutoEnableWithContext(ctx aws.Context, input *CreateDatalakeAutoEnableInput, opts ...request.Option) (*CreateDatalakeAutoEnableOutput, error) {
	req, out := c.CreateDatalakeAutoEnableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDatalakeDelegatedAdmin = "CreateDatalakeDelegatedAdmin"

// CreateDatalakeDelegatedAdminRequest generates a "aws/request.Request" representing the
// client's request for the CreateDatalakeDelegatedAdmin operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDatalakeDelegatedAdmin for more information on using the CreateDatalakeDelegatedAdmin
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDatalakeDelegatedAdminRequest method.
//	req, resp := client.CreateDatalakeDelegatedAdminRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDatalakeDelegatedAdmin
func (c *SecurityLake) CreateDatalakeDelegatedAdminRequest(input *CreateDatalakeDelegatedAdminInput) (req *request.Request, output *CreateDatalakeDelegatedAdminOutput) {
	op := &request.Operation{
		Name:       opCreateDatalakeDelegatedAdmin,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/datalake/delegate",
	}

	if input == nil {
		input = &CreateDatalakeDelegatedAdminInput{}
	}

	output = &CreateDatalakeDelegatedAdminOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateDatalakeDelegatedAdmin API operation for Amazon Security Lake.
//
// Designates the Security Lake administrator account for the organization.
// This API can only be called by the organization management account. The organization
// management account cannot be the delegated administrator account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation CreateDatalakeDelegatedAdmin for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDatalakeDelegatedAdmin
func (c *SecurityLake) CreateDatalakeDelegatedAdmin(input *CreateDatalakeDelegatedAdminInput) (*CreateDatalakeDelegatedAdminOutput, error) {
	req, out := c.CreateDatalakeDelegatedAdminRequest(input)
	return out, req.Send()
}

// CreateDatalakeDelegatedAdminWithContext is the same as CreateDatalakeDelegatedAdmin with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDatalakeDelegatedAdmin for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) CreateDatalakeDelegatedAdminWithContext(ctx aws.Context, input *CreateDatalakeDelegatedAdminInput, opts ...request.Option) (*CreateDatalakeDelegatedAdminOutput, error) {
	req, out := c.CreateDatalakeDelegatedAdminRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDatalakeExceptionsSubscription = "CreateDatalakeExceptionsSubscription"

// CreateDatalakeExceptionsSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CreateDatalakeExceptionsSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDatalakeExceptionsSubscription for more information on using the CreateDatalakeExceptionsSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDatalakeExceptionsSubscriptionRequest method.
//	req, resp := client.CreateDatalakeExceptionsSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDatalakeExceptionsSubscription
func (c *SecurityLake) CreateDatalakeExceptionsSubscriptionRequest(input *CreateDatalakeExceptionsSubscriptionInput) (req *request.Request, output *CreateDatalakeExceptionsSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateDatalakeExceptionsSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/datalake/exceptions/subscription",
	}

	if input == nil {
		input = &CreateDatalakeExceptionsSubscriptionInput{}
	}

	output = &CreateDatalakeExceptionsSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateDatalakeExceptionsSubscription API operation for Amazon Security Lake.
//
// Creates the specified notification subscription in Security Lake. Creates
// the specified subscription notifications in the specified organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation CreateDatalakeExceptionsSubscription for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - AccountNotFoundException
//     Amazon Security Lake can't find an Amazon Web Services account with the accountID
//     that you specified, or the account whose credentials you used to make this
//     request isn't a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDatalakeExceptionsSubscription
func (c *SecurityLake) CreateDatalakeExceptionsSubscription(input *CreateDatalakeExceptionsSubscriptionInput) (*CreateDatalakeExceptionsSubscriptionOutput, error) {
	req, out := c.CreateDatalakeExceptionsSubscriptionRequest(input)
	return out, req.Send()
}

// CreateDatalakeExceptionsSubscriptionWithContext is the same as CreateDatalakeExceptionsSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDatalakeExceptionsSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) CreateDatalakeExceptionsSubscriptionWithContext(ctx aws.Context, input *CreateDatalakeExceptionsSubscriptionInput, opts ...request.Option) (*CreateDatalakeExceptionsSubscriptionOutput, error) {
	req, out := c.CreateDatalakeExceptionsSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSubscriber = "CreateSubscriber"

// CreateSubscriberRequest generates a "aws/request.Request" representing the
// client's request for the CreateSubscriber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSubscriber for more information on using the CreateSubscriber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSubscriberRequest method.
//	req, resp := client.CreateSubscriberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateSubscriber
func (c *SecurityLake) CreateSubscriberRequest(input *CreateSubscriberInput) (req *request.Request, output *CreateSubscriberOutput) {
	op := &request.Operation{
		Name:       opCreateSubscriber,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/subscribers",
	}

	if input == nil {
		input = &CreateSubscriberInput{}
	}

	output = &CreateSubscriberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSubscriber API operation for Amazon Security Lake.
//
// Creates a subscription permission for accounts that are already enabled in
// Security Lake.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation CreateSubscriber for usage and error information.
//
// Returned Error Types:
//
//   - ConflictSubscriptionException
//     A conflicting subscription exception operation is in progress.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - BucketNotFoundException
//     Amazon Security Lake generally returns 404 errors if the requested object
//     is missing from the bucket.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccountNotFoundException
//     Amazon Security Lake can't find an Amazon Web Services account with the accountID
//     that you specified, or the account whose credentials you used to make this
//     request isn't a member of an organization.
//
//   - InvalidInputException
//     The request was rejected because an invalid or out-of-range value was supplied
//     for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateSubscriber
func (c *SecurityLake) CreateSubscriber(input *CreateSubscriberInput) (*CreateSubscriberOutput, error) {
	req, out := c.CreateSubscriberRequest(input)
	return out, req.Send()
}

// CreateSubscriberWithContext is the same as CreateSubscriber with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSubscriber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) CreateSubscriberWithContext(ctx aws.Context, input *CreateSubscriberInput, opts ...request.Option) (*CreateSubscriberOutput, error) {
	req, out := c.CreateSubscriberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSubscriptionNotificationConfiguration = "CreateSubscriptionNotificationConfiguration"

// CreateSubscriptionNotificationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateSubscriptionNotificationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSubscriptionNotificationConfiguration for more information on using the CreateSubscriptionNotificationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSubscriptionNotificationConfigurationRequest method.
//	req, resp := client.CreateSubscriptionNotificationConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateSubscriptionNotificationConfiguration
func (c *SecurityLake) CreateSubscriptionNotificationConfigurationRequest(input *CreateSubscriptionNotificationConfigurationInput) (req *request.Request, output *CreateSubscriptionNotificationConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateSubscriptionNotificationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/subscription-notifications/{subscriptionId}",
	}

	if input == nil {
		input = &CreateSubscriptionNotificationConfigurationInput{}
	}

	output = &CreateSubscriptionNotificationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSubscriptionNotificationConfiguration API operation for Amazon Security Lake.
//
// Creates the specified notification subscription in Security Lake. Creates
// the specified subscription notifications from the specified organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation CreateSubscriptionNotificationConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ConcurrentModificationException
//     More than one process tried to modify a resource at the same time.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccountNotFoundException
//     Amazon Security Lake can't find an Amazon Web Services account with the accountID
//     that you specified, or the account whose credentials you used to make this
//     request isn't a member of an organization.
//
//   - InvalidInputException
//     The request was rejected because an invalid or out-of-range value was supplied
//     for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateSubscriptionNotificationConfiguration
func (c *SecurityLake) CreateSubscriptionNotificationConfiguration(input *CreateSubscriptionNotificationConfigurationInput) (*CreateSubscriptionNotificationConfigurationOutput, error) {
	req, out := c.CreateSubscriptionNotificationConfigurationRequest(input)
	return out, req.Send()
}

// CreateSubscriptionNotificationConfigurationWithContext is the same as CreateSubscriptionNotificationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSubscriptionNotificationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) CreateSubscriptionNotificationConfigurationWithContext(ctx aws.Context, input *CreateSubscriptionNotificationConfigurationInput, opts ...request.Option) (*CreateSubscriptionNotificationConfigurationOutput, error) {
	req, out := c.CreateSubscriptionNotificationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAwsLogSource = "DeleteAwsLogSource"

// DeleteAwsLogSourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAwsLogSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAwsLogSource for more information on using the DeleteAwsLogSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAwsLogSourceRequest method.
//	req, resp := client.DeleteAwsLogSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteAwsLogSource
func (c *SecurityLake) DeleteAwsLogSourceRequest(input *DeleteAwsLogSourceInput) (req *request.Request, output *DeleteAwsLogSourceOutput) {
	op := &request.Operation{
		Name:       opDeleteAwsLogSource,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/logsources/aws/delete",
	}

	if input == nil {
		input = &DeleteAwsLogSourceInput{}
	}

	output = &DeleteAwsLogSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAwsLogSource API operation for Amazon Security Lake.
//
// Removes a natively-supported Amazon Web Services service as a Amazon Security
// Lake source. When you remove the source, Security Lake stops collecting data
// from that source, and subscribers can no longer consume new data from the
// source. Subscribers can still consume data that Amazon Security Lake collected
// from the source before disablement.
//
// You can choose any source type in any Region for accounts that are either
// part of a trusted organization or standalone accounts. At least one of the
// three dimensions is a mandatory input to this API. However, any combination
// of the three dimensions can be supplied to this API.
//
// By default, dimension refers to the entire set. This is overridden when you
// supply any one of the inputs. For instance, when members is not specified,
// the API disables all Security Lake member accounts for sources. Similarly,
// when Regions are not specified, Security Lake is disabled for all the Regions
// where Security Lake is available as a service.
//
// You can use this API to remove a natively-supported Amazon Web Services service
// as a source. Use DeregisterCustomData to remove a custom source.
//
// When you don't provide a dimension, Security Lake assumes that the missing
// dimension refers to the entire set. For example, if you don't provide specific
// accounts, the API applies to the entire set of accounts in your organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation DeleteAwsLogSource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - AccountNotFoundException
//     Amazon Security Lake can't find an Amazon Web Services account with the accountID
//     that you specified, or the account whose credentials you used to make this
//     request isn't a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteAwsLogSource
func (c *SecurityLake) DeleteAwsLogSource(input *DeleteAwsLogSourceInput) (*DeleteAwsLogSourceOutput, error) {
	req, out := c.DeleteAwsLogSourceRequest(input)
	return out, req.Send()
}

// DeleteAwsLogSourceWithContext is the same as DeleteAwsLogSource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAwsLogSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) DeleteAwsLogSourceWithContext(ctx aws.Context, input *DeleteAwsLogSourceInput, opts ...request.Option) (*DeleteAwsLogSourceOutput, error) {
	req, out := c.DeleteAwsLogSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCustomLogSource = "DeleteCustomLogSource"

// DeleteCustomLogSourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCustomLogSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCustomLogSource for more information on using the DeleteCustomLogSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCustomLogSourceRequest method.
//	req, resp := client.DeleteCustomLogSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteCustomLogSource
func (c *SecurityLake) DeleteCustomLogSourceRequest(input *DeleteCustomLogSourceInput) (req *request.Request, output *DeleteCustomLogSourceOutput) {
	op := &request.Operation{
		Name:       opDeleteCustomLogSource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/logsources/custom",
	}

	if input == nil {
		input = &DeleteCustomLogSourceInput{}
	}

	output = &DeleteCustomLogSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCustomLogSource API operation for Amazon Security Lake.
//
// Removes a custom log source from Security Lake.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation DeleteCustomLogSource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - ConflictSourceNamesException
//     There was a conflict when you attempted to modify a Security Lake source
//     name.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - BucketNotFoundException
//     Amazon Security Lake generally returns 404 errors if the requested object
//     is missing from the bucket.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccountNotFoundException
//     Amazon Security Lake can't find an Amazon Web Services account with the accountID
//     that you specified, or the account whose credentials you used to make this
//     request isn't a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteCustomLogSource
func (c *SecurityLake) DeleteCustomLogSource(input *DeleteCustomLogSourceInput) (*DeleteCustomLogSourceOutput, error) {
	req, out := c.DeleteCustomLogSourceRequest(input)
	return out, req.Send()
}

// DeleteCustomLogSourceWithContext is the same as DeleteCustomLogSource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCustomLogSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) DeleteCustomLogSourceWithContext(ctx aws.Context, input *DeleteCustomLogSourceInput, opts ...request.Option) (*DeleteCustomLogSourceOutput, error) {
	req, out := c.DeleteCustomLogSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDatalake = "DeleteDatalake"

// DeleteDatalakeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDatalake operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDatalake for more information on using the DeleteDatalake
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDatalakeRequest method.
//	req, resp := client.DeleteDatalakeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDatalake
func (c *SecurityLake) DeleteDatalakeRequest(input *DeleteDatalakeInput) (req *request.Request, output *DeleteDatalakeOutput) {
	op := &request.Operation{
		Name:       opDeleteDatalake,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/datalake",
	}

	if input == nil {
		input = &DeleteDatalakeInput{}
	}

	output = &DeleteDatalakeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDatalake API operation for Amazon Security Lake.
//
// When you delete Amazon Security Lake from your account, Security Lake is
// disabled in all Regions. Also, this API automatically performs the off-boarding
// steps to off-board the account from Security Lake . This includes ingesting
// security data from sources, storing data, and making data accessible to subscribers.
// Security Lake also deletes all the existing settings and resources that it
// stores or maintains for your account in the current Region, including security
// log and event data. DeleteDatalake does not delete the S3 bucket which is
// owned by the Amazon Web Services account. For more information, see the Amazon
// Security Lake User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation DeleteDatalake for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     You have exceeded your service quota. To perform the requested action, remove
//     some of the relevant resources, or use Service Quotas to request a service
//     quota increase.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDatalake
func (c *SecurityLake) DeleteDatalake(input *DeleteDatalakeInput) (*DeleteDatalakeOutput, error) {
	req, out := c.DeleteDatalakeRequest(input)
	return out, req.Send()
}

// DeleteDatalakeWithContext is the same as DeleteDatalake with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDatalake for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) DeleteDatalakeWithContext(ctx aws.Context, input *DeleteDatalakeInput, opts ...request.Option) (*DeleteDatalakeOutput, error) {
	req, out := c.DeleteDatalakeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDatalakeAutoEnable = "DeleteDatalakeAutoEnable"

// DeleteDatalakeAutoEnableRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDatalakeAutoEnable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDatalakeAutoEnable for more information on using the DeleteDatalakeAutoEnable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDatalakeAutoEnableRequest method.
//	req, resp := client.DeleteDatalakeAutoEnableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDatalakeAutoEnable
func (c *SecurityLake) DeleteDatalakeAutoEnableRequest(input *DeleteDatalakeAutoEnableInput) (req *request.Request, output *DeleteDatalakeAutoEnableOutput) {
	op := &request.Operation{
		Name:       opDeleteDatalakeAutoEnable,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/datalake/autoenable/delete",
	}

	if input == nil {
		input = &DeleteDatalakeAutoEnableInput{}
	}

	output = &DeleteDatalakeAutoEnableOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDatalakeAutoEnable API operation for Amazon Security Lake.
//
// Automatically delete Security Lake in the specified Regions to stop ingesting
// security data. When you delete Amazon Security Lake from your account, Security
// Lake is disabled in all Regions. Also, this API automatically performs the
// off-boarding steps to off-board the account from Security Lake . This includes
// ingesting security data from sources, storing data, and making data accessible
// to subscribers. Security Lake also deletes all the existing settings and
// resources that it stores or maintains for your account in the current Region,
// including security log and event data. For more information, see the Amazon
// Security Lake User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation DeleteDatalakeAutoEnable for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - AccountNotFoundException
//     Amazon Security Lake can't find an Amazon Web Services account with the accountID
//     that you specified, or the account whose credentials you used to make this
//     request isn't a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDatalakeAutoEnable
func (c *SecurityLake) DeleteDatalakeAutoEnable(input *DeleteDatalakeAutoEnableInput) (*DeleteDatalakeAutoEnableOutput, error) {
	req, out := c.DeleteDatalakeAutoEnableRequest(input)
	return out, req.Send()
}

// DeleteDatalakeAutoEnableWithContext is the same as DeleteDatalakeAutoEnable with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDatalakeAutoEnable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) DeleteDatalakeAutoEnableWithContext(ctx aws.Context, input *DeleteDatalakeAutoEnableInput, opts ...request.Option) (*DeleteDatalakeAutoEnableOutput, error) {
	req, out := c.DeleteDatalakeAutoEnableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDatalakeDelegatedAdmin = "DeleteDatalakeDelegatedAdmin"

// DeleteDatalakeDelegatedAdminRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDatalakeDelegatedAdmin operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDatalakeDelegatedAdmin for more information on using the DeleteDatalakeDelegatedAdmin
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDatalakeDelegatedAdminRequest method.
//	req, resp := client.DeleteDatalakeDelegatedAdminRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDatalakeDelegatedAdmin
func (c *SecurityLake) DeleteDatalakeDelegatedAdminRequest(input *DeleteDatalakeDelegatedAdminInput) (req *request.Request, output *DeleteDatalakeDelegatedAdminOutput) {
	op := &request.Operation{
		Name:       opDeleteDatalakeDelegatedAdmin,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/datalake/delegate/{account}",
	}

	if input == nil {
		input = &DeleteDatalakeDelegatedAdminInput{}
	}

	output = &DeleteDatalakeDelegatedAdminOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDatalakeDelegatedAdmin API operation for Amazon Security Lake.
//
// Deletes the Security Lake administrator account for the organization. This
// API can only be called by the organization management account. The organization
// management account cannot be the delegated administrator account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation DeleteDatalakeDelegatedAdmin for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDatalakeDelegatedAdmin
func (c *SecurityLake) DeleteDatalakeDelegatedAdmin(input *DeleteDatalakeDelegatedAdminInput) (*DeleteDatalakeDelegatedAdminOutput, error) {
	req, out := c.DeleteDatalakeDelegatedAdminRequest(input)
	return out, req.Send()
}

// DeleteDatalakeDelegatedAdminWithContext is the same as DeleteDatalakeDelegatedAdmin with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDatalakeDelegatedAdmin for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) DeleteDatalakeDelegatedAdminWithContext(ctx aws.Context, input *DeleteDatalakeDelegatedAdminInput, opts ...request.Option) (*DeleteDatalakeDelegatedAdminOutput, error) {
	req, out := c.DeleteDatalakeDelegatedAdminRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDatalakeExceptionsSubscription = "DeleteDatalakeExceptionsSubscription"

// DeleteDatalakeExceptionsSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDatalakeExceptionsSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDatalakeExceptionsSubscription for more information on using the DeleteDatalakeExceptionsSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDatalakeExceptionsSubscriptionRequest method.
//	req, resp := client.DeleteDatalakeExceptionsSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDatalakeExceptionsSubscription
func (c *SecurityLake) DeleteDatalakeExceptionsSubscriptionRequest(input *DeleteDatalakeExceptionsSubscriptionInput) (req *request.Request, output *DeleteDatalakeExceptionsSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteDatalakeExceptionsSubscription,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/datalake/exceptions/subscription",
	}

	if input == nil {
		input = &DeleteDatalakeExceptionsSubscriptionInput{}
	}

	output = &DeleteDatalakeExceptionsSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDatalakeExceptionsSubscription API operation for Amazon Security Lake.
//
// Deletes the specified notification subscription in Security Lake. Deletes
// the specified subscription notifications in the specified organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation DeleteDatalakeExceptionsSubscription for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - AccountNotFoundException
//     Amazon Security Lake can't find an Amazon Web Services account with the accountID
//     that you specified, or the account whose credentials you used to make this
//     request isn't a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteDatalakeExceptionsSubscription
func (c *SecurityLake) DeleteDatalakeExceptionsSubscription(input *DeleteDatalakeExceptionsSubscriptionInput) (*DeleteDatalakeExceptionsSubscriptionOutput, error) {
	req, out := c.DeleteDatalakeExceptionsSubscriptionRequest(input)
	return out, req.Send()
}

// DeleteDatalakeExceptionsSubscriptionWithContext is the same as DeleteDatalakeExceptionsSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDatalakeExceptionsSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) DeleteDatalakeExceptionsSubscriptionWithContext(ctx aws.Context, input *DeleteDatalakeExceptionsSubscriptionInput, opts ...request.Option) (*DeleteDatalakeExceptionsSubscriptionOutput, error) {
	req, out := c.DeleteDatalakeExceptionsSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSubscriber = "DeleteSubscriber"

// DeleteSubscriberRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSubscriber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSubscriber for more information on using the DeleteSubscriber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSubscriberRequest method.
//	req, resp := client.DeleteSubscriberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteSubscriber
func (c *SecurityLake) DeleteSubscriberRequest(input *DeleteSubscriberInput) (req *request.Request, output *DeleteSubscriberOutput) {
	op := &request.Operation{
		Name:       opDeleteSubscriber,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/subscribers",
	}

	if input == nil {
		input = &DeleteSubscriberInput{}
	}

	output = &DeleteSubscriberOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSubscriber API operation for Amazon Security Lake.
//
// Deletes the specified subscription permissions to Security Lake. Deletes
// the specified subscription permissions from the specified organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation DeleteSubscriber for usage and error information.
//
// Returned Error Types:
//
//   - ConcurrentModificationException
//     More than one process tried to modify a resource at the same time.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - BucketNotFoundException
//     Amazon Security Lake generally returns 404 errors if the requested object
//     is missing from the bucket.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccountNotFoundException
//     Amazon Security Lake can't find an Amazon Web Services account with the accountID
//     that you specified, or the account whose credentials you used to make this
//     request isn't a member of an organization.
//
//   - InvalidInputException
//     The request was rejected because an invalid or out-of-range value was supplied
//     for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteSubscriber
func (c *SecurityLake) DeleteSubscriber(input *DeleteSubscriberInput) (*DeleteSubscriberOutput, error) {
	req, out := c.DeleteSubscriberRequest(input)
	return out, req.Send()
}

// DeleteSubscriberWithContext is the same as DeleteSubscriber with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSubscriber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) DeleteSubscriberWithContext(ctx aws.Context, input *DeleteSubscriberInput, opts ...request.Option) (*DeleteSubscriberOutput, error) {
	req, out := c.DeleteSubscriberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSubscriptionNotificationConfiguration = "DeleteSubscriptionNotificationConfiguration"

// DeleteSubscriptionNotificationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSubscriptionNotificationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSubscriptionNotificationConfiguration for more information on using the DeleteSubscriptionNotificationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSubscriptionNotificationConfigurationRequest method.
//	req, resp := client.DeleteSubscriptionNotificationConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteSubscriptionNotificationConfiguration
func (c *SecurityLake) DeleteSubscriptionNotificationConfigurationRequest(input *DeleteSubscriptionNotificationConfigurationInput) (req *request.Request, output *DeleteSubscriptionNotificationConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteSubscriptionNotificationConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/subscription-notifications/{subscriptionId}",
	}

	if input == nil {
		input = &DeleteSubscriptionNotificationConfigurationInput{}
	}

	output = &DeleteSubscriptionNotificationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSubscriptionNotificationConfiguration API operation for Amazon Security Lake.
//
// Deletes the specified notification subscription in Security Lake. Deletes
// the specified subscription notifications from the specified organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation DeleteSubscriptionNotificationConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ConcurrentModificationException
//     More than one process tried to modify a resource at the same time.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccountNotFoundException
//     Amazon Security Lake can't find an Amazon Web Services account with the accountID
//     that you specified, or the account whose credentials you used to make this
//     request isn't a member of an organization.
//
//   - InvalidInputException
//     The request was rejected because an invalid or out-of-range value was supplied
//     for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/DeleteSubscriptionNotificationConfiguration
func (c *SecurityLake) DeleteSubscriptionNotificationConfiguration(input *DeleteSubscriptionNotificationConfigurationInput) (*DeleteSubscriptionNotificationConfigurationOutput, error) {
	req, out := c.DeleteSubscriptionNotificationConfigurationRequest(input)
	return out, req.Send()
}

// DeleteSubscriptionNotificationConfigurationWithContext is the same as DeleteSubscriptionNotificationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSubscriptionNotificationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) DeleteSubscriptionNotificationConfigurationWithContext(ctx aws.Context, input *DeleteSubscriptionNotificationConfigurationInput, opts ...request.Option) (*DeleteSubscriptionNotificationConfigurationOutput, error) {
	req, out := c.DeleteSubscriptionNotificationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDatalake = "GetDatalake"

// GetDatalakeRequest generates a "aws/request.Request" representing the
// client's request for the GetDatalake operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDatalake for more information on using the GetDatalake
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDatalakeRequest method.
//	req, resp := client.GetDatalakeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalake
func (c *SecurityLake) GetDatalakeRequest(input *GetDatalakeInput) (req *request.Request, output *GetDatalakeOutput) {
	op := &request.Operation{
		Name:       opGetDatalake,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/datalake",
	}

	if input == nil {
		input = &GetDatalakeInput{}
	}

	output = &GetDatalakeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDatalake API operation for Amazon Security Lake.
//
// Retrieve the Security Lake configuration object for the specified account
// ID. This API does not take input parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation GetDatalake for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccountNotFoundException
//     Amazon Security Lake can't find an Amazon Web Services account with the accountID
//     that you specified, or the account whose credentials you used to make this
//     request isn't a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalake
func (c *SecurityLake) GetDatalake(input *GetDatalakeInput) (*GetDatalakeOutput, error) {
	req, out := c.GetDatalakeRequest(input)
	return out, req.Send()
}

// GetDatalakeWithContext is the same as GetDatalake with the addition of
// the ability to pass a context and additional request options.
//
// See GetDatalake for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) GetDatalakeWithContext(ctx aws.Context, input *GetDatalakeInput, opts ...request.Option) (*GetDatalakeOutput, error) {
	req, out := c.GetDatalakeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDatalakeAutoEnable = "GetDatalakeAutoEnable"

// GetDatalakeAutoEnableRequest generates a "aws/request.Request" representing the
// client's request for the GetDatalakeAutoEnable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDatalakeAutoEnable for more information on using the GetDatalakeAutoEnable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDatalakeAutoEnableRequest method.
//	req, resp := client.GetDatalakeAutoEnableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeAutoEnable
func (c *SecurityLake) GetDatalakeAutoEnableRequest(input *GetDatalakeAutoEnableInput) (req *request.Request, output *GetDatalakeAutoEnableOutput) {
	op := &request.Operation{
		Name:       opGetDatalakeAutoEnable,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/datalake/autoenable",
	}

	if input == nil {
		input = &GetDatalakeAutoEnableInput{}
	}

	output = &GetDatalakeAutoEnableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDatalakeAutoEnable API operation for Amazon Security Lake.
//
// Retrieves the configuration that will be automatically set up for accounts
// added to the organization after the organization has on boarded to Amazon
// Security Lake. This API does not take input parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation GetDatalakeAutoEnable for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - AccountNotFoundException
//     Amazon Security Lake can't find an Amazon Web Services account with the accountID
//     that you specified, or the account whose credentials you used to make this
//     request isn't a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeAutoEnable
func (c *SecurityLake) GetDatalakeAutoEnable(input *GetDatalakeAutoEnableInput) (*GetDatalakeAutoEnableOutput, error) {
	req, out := c.GetDatalakeAutoEnableRequest(input)
	return out, req.Send()
}

// GetDatalakeAutoEnableWithContext is the same as GetDatalakeAutoEnable with the addition of
// the ability to pass a context and additional request options.
//
// See GetDatalakeAutoEnable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) GetDatalakeAutoEnableWithContext(ctx aws.Context, input *GetDatalakeAutoEnableInput, opts ...request.Option) (*GetDatalakeAutoEnableOutput, error) {
	req, out := c.GetDatalakeAutoEnableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDatalakeExceptionsExpiry = "GetDatalakeExceptionsExpiry"

// GetDatalakeExceptionsExpiryRequest generates a "aws/request.Request" representing the
// client's request for the GetDatalakeExceptionsExpiry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDatalakeExceptionsExpiry for more information on using the GetDatalakeExceptionsExpiry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDatalakeExceptionsExpiryRequest method.
//	req, resp := client.GetDatalakeExceptionsExpiryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeExceptionsExpiry
func (c *SecurityLake) GetDatalakeExceptionsExpiryRequest(input *GetDatalakeExceptionsExpiryInput) (req *request.Request, output *GetDatalakeExceptionsExpiryOutput) {
	op := &request.Operation{
		Name:       opGetDatalakeExceptionsExpiry,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/datalake/exceptions/expiry",
	}

	if input == nil {
		input = &GetDatalakeExceptionsExpiryInput{}
	}

	output = &GetDatalakeExceptionsExpiryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDatalakeExceptionsExpiry API operation for Amazon Security Lake.
//
// Retrieves the expiration period and time-to-live (TTL) for which the exception
// message will remain. Exceptions are stored by default, for a 2 week period
// of time from when a record was created in Security Lake. This API does not
// take input parameters. This API does not take input parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation GetDatalakeExceptionsExpiry for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - AccountNotFoundException
//     Amazon Security Lake can't find an Amazon Web Services account with the accountID
//     that you specified, or the account whose credentials you used to make this
//     request isn't a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeExceptionsExpiry
func (c *SecurityLake) GetDatalakeExceptionsExpiry(input *GetDatalakeExceptionsExpiryInput) (*GetDatalakeExceptionsExpiryOutput, error) {
	req, out := c.GetDatalakeExceptionsExpiryRequest(input)
	return out, req.Send()
}

// GetDatalakeExceptionsExpiryWithContext is the same as GetDatalakeExceptionsExpiry with the addition of
// the ability to pass a context and additional request options.
//
// See GetDatalakeExceptionsExpiry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) GetDatalakeExceptionsExpiryWithContext(ctx aws.Context, input *GetDatalakeExceptionsExpiryInput, opts ...request.Option) (*GetDatalakeExceptionsExpiryOutput, error) {
	req, out := c.GetDatalakeExceptionsExpiryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDatalakeExceptionsSubscription = "GetDatalakeExceptionsSubscription"

// GetDatalakeExceptionsSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the GetDatalakeExceptionsSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDatalakeExceptionsSubscription for more information on using the GetDatalakeExceptionsSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDatalakeExceptionsSubscriptionRequest method.
//	req, resp := client.GetDatalakeExceptionsSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeExceptionsSubscription
func (c *SecurityLake) GetDatalakeExceptionsSubscriptionRequest(input *GetDatalakeExceptionsSubscriptionInput) (req *request.Request, output *GetDatalakeExceptionsSubscriptionOutput) {
	op := &request.Operation{
		Name:       opGetDatalakeExceptionsSubscription,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/datalake/exceptions/subscription",
	}

	if input == nil {
		input = &GetDatalakeExceptionsSubscriptionInput{}
	}

	output = &GetDatalakeExceptionsSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDatalakeExceptionsSubscription API operation for Amazon Security Lake.
//
// Retrieves the details of exception notifications for the account in Amazon
// Security Lake.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation GetDatalakeExceptionsSubscription for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - AccountNotFoundException
//     Amazon Security Lake can't find an Amazon Web Services account with the accountID
//     that you specified, or the account whose credentials you used to make this
//     request isn't a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeExceptionsSubscription
func (c *SecurityLake) GetDatalakeExceptionsSubscription(input *GetDatalakeExceptionsSubscriptionInput) (*GetDatalakeExceptionsSubscriptionOutput, error) {
	req, out := c.GetDatalakeExceptionsSubscriptionRequest(input)
	return out, req.Send()
}

// GetDatalakeExceptionsSubscriptionWithContext is the same as GetDatalakeExceptionsSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See GetDatalakeExceptionsSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) GetDatalakeExceptionsSubscriptionWithContext(ctx aws.Context, input *GetDatalakeExceptionsSubscriptionInput, opts ...request.Option) (*GetDatalakeExceptionsSubscriptionOutput, error) {
	req, out := c.GetDatalakeExceptionsSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDatalakeStatus = "GetDatalakeStatus"

// GetDatalakeStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetDatalakeStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDatalakeStatus for more information on using the GetDatalakeStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDatalakeStatusRequest method.
//	req, resp := client.GetDatalakeStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeStatus
func (c *SecurityLake) GetDatalakeStatusRequest(input *GetDatalakeStatusInput) (req *request.Request, output *GetDatalakeStatusOutput) {
	op := &request.Operation{
		Name:       opGetDatalakeStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/datalake/status",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxAccountResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetDatalakeStatusInput{}
	}

	output = &GetDatalakeStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDatalakeStatus API operation for Amazon Security Lake.
//
// Retrieve the Security Lake configuration object for the specified account
// ID. This API does not take input parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation GetDatalakeStatus for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - AccountNotFoundException
//     Amazon Security Lake can't find an Amazon Web Services account with the accountID
//     that you specified, or the account whose credentials you used to make this
//     request isn't a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetDatalakeStatus
func (c *SecurityLake) GetDatalakeStatus(input *GetDatalakeStatusInput) (*GetDatalakeStatusOutput, error) {
	req, out := c.GetDatalakeStatusRequest(input)
	return out, req.Send()
}

// GetDatalakeStatusWithContext is the same as GetDatalakeStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetDatalakeStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) GetDatalakeStatusWithContext(ctx aws.Context, input *GetDatalakeStatusInput, opts ...request.Option) (*GetDatalakeStatusOutput, error) {
	req, out := c.GetDatalakeStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetDatalakeStatusPages iterates over the pages of a GetDatalakeStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetDatalakeStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetDatalakeStatus operation.
//	pageNum := 0
//	err := client.GetDatalakeStatusPages(params,
//	    func(page *securitylake.GetDatalakeStatusOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecurityLake) GetDatalakeStatusPages(input *GetDatalakeStatusInput, fn func(*GetDatalakeStatusOutput, bool) bool) error {
	return c.GetDatalakeStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetDatalakeStatusPagesWithContext same as GetDatalakeStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) GetDatalakeStatusPagesWithContext(ctx aws.Context, input *GetDatalakeStatusInput, fn func(*GetDatalakeStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetDatalakeStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetDatalakeStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetDatalakeStatusOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetSubscriber = "GetSubscriber"

// GetSubscriberRequest generates a "aws/request.Request" representing the
// client's request for the GetSubscriber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSubscriber for more information on using the GetSubscriber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSubscriberRequest method.
//	req, resp := client.GetSubscriberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetSubscriber
func (c *SecurityLake) GetSubscriberRequest(input *GetSubscriberInput) (req *request.Request, output *GetSubscriberOutput) {
	op := &request.Operation{
		Name:       opGetSubscriber,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/subscribers/{id}",
	}

	if input == nil {
		input = &GetSubscriberInput{}
	}

	output = &GetSubscriberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSubscriber API operation for Amazon Security Lake.
//
// Retrieves subscription information for the specified subscription ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation GetSubscriber for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccountNotFoundException
//     Amazon Security Lake can't find an Amazon Web Services account with the accountID
//     that you specified, or the account whose credentials you used to make this
//     request isn't a member of an organization.
//
//   - InvalidInputException
//     The request was rejected because an invalid or out-of-range value was supplied
//     for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/GetSubscriber
func (c *SecurityLake) GetSubscriber(input *GetSubscriberInput) (*GetSubscriberOutput, error) {
	req, out := c.GetSubscriberRequest(input)
	return out, req.Send()
}

// GetSubscriberWithContext is the same as GetSubscriber with the addition of
// the ability to pass a context and additional request options.
//
// See GetSubscriber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) GetSubscriberWithContext(ctx aws.Context, input *GetSubscriberInput, opts ...request.Option) (*GetSubscriberOutput, error) {
	req, out := c.GetSubscriberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDatalakeExceptions = "ListDatalakeExceptions"

// ListDatalakeExceptionsRequest generates a "aws/request.Request" representing the
// client's request for the ListDatalakeExceptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatalakeExceptions for more information on using the ListDatalakeExceptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDatalakeExceptionsRequest method.
//	req, resp := client.ListDatalakeExceptionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListDatalakeExceptions
func (c *SecurityLake) ListDatalakeExceptionsRequest(input *ListDatalakeExceptionsInput) (req *request.Request, output *ListDatalakeExceptionsOutput) {
	op := &request.Operation{
		Name:       opListDatalakeExceptions,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/datalake/exceptions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxFailures",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatalakeExceptionsInput{}
	}

	output = &ListDatalakeExceptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatalakeExceptions API operation for Amazon Security Lake.
//
// List the Amazon Security Lake exceptions that you can use to find the source
// of problems and fix them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation ListDatalakeExceptions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - AccountNotFoundException
//     Amazon Security Lake can't find an Amazon Web Services account with the accountID
//     that you specified, or the account whose credentials you used to make this
//     request isn't a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListDatalakeExceptions
func (c *SecurityLake) ListDatalakeExceptions(input *ListDatalakeExceptionsInput) (*ListDatalakeExceptionsOutput, error) {
	req, out := c.ListDatalakeExceptionsRequest(input)
	return out, req.Send()
}

// ListDatalakeExceptionsWithContext is the same as ListDatalakeExceptions with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatalakeExceptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) ListDatalakeExceptionsWithContext(ctx aws.Context, input *ListDatalakeExceptionsInput, opts ...request.Option) (*ListDatalakeExceptionsOutput, error) {
	req, out := c.ListDatalakeExceptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatalakeExceptionsPages iterates over the pages of a ListDatalakeExceptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatalakeExceptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDatalakeExceptions operation.
//	pageNum := 0
//	err := client.ListDatalakeExceptionsPages(params,
//	    func(page *securitylake.ListDatalakeExceptionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecurityLake) ListDatalakeExceptionsPages(input *ListDatalakeExceptionsInput, fn func(*ListDatalakeExceptionsOutput, bool) bool) error {
	return c.ListDatalakeExceptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatalakeExceptionsPagesWithContext same as ListDatalakeExceptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) ListDatalakeExceptionsPagesWithContext(ctx aws.Context, input *ListDatalakeExceptionsInput, fn func(*ListDatalakeExceptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatalakeExceptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatalakeExceptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDatalakeExceptionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLogSources = "ListLogSources"

// ListLogSourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListLogSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLogSources for more information on using the ListLogSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLogSourcesRequest method.
//	req, resp := client.ListLogSourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListLogSources
func (c *SecurityLake) ListLogSourcesRequest(input *ListLogSourcesInput) (req *request.Request, output *ListLogSourcesOutput) {
	op := &request.Operation{
		Name:       opListLogSources,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/logsources/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLogSourcesInput{}
	}

	output = &ListLogSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLogSources API operation for Amazon Security Lake.
//
// Lists the log sources in the current region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation ListLogSources for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccountNotFoundException
//     Amazon Security Lake can't find an Amazon Web Services account with the accountID
//     that you specified, or the account whose credentials you used to make this
//     request isn't a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListLogSources
func (c *SecurityLake) ListLogSources(input *ListLogSourcesInput) (*ListLogSourcesOutput, error) {
	req, out := c.ListLogSourcesRequest(input)
	return out, req.Send()
}

// ListLogSourcesWithContext is the same as ListLogSources with the addition of
// the ability to pass a context and additional request options.
//
// See ListLogSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) ListLogSourcesWithContext(ctx aws.Context, input *ListLogSourcesInput, opts ...request.Option) (*ListLogSourcesOutput, error) {
	req, out := c.ListLogSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLogSourcesPages iterates over the pages of a ListLogSources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLogSources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLogSources operation.
//	pageNum := 0
//	err := client.ListLogSourcesPages(params,
//	    func(page *securitylake.ListLogSourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecurityLake) ListLogSourcesPages(input *ListLogSourcesInput, fn func(*ListLogSourcesOutput, bool) bool) error {
	return c.ListLogSourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLogSourcesPagesWithContext same as ListLogSourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) ListLogSourcesPagesWithContext(ctx aws.Context, input *ListLogSourcesInput, fn func(*ListLogSourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLogSourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLogSourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLogSourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSubscribers = "ListSubscribers"

// ListSubscribersRequest generates a "aws/request.Request" representing the
// client's request for the ListSubscribers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSubscribers for more information on using the ListSubscribers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSubscribersRequest method.
//	req, resp := client.ListSubscribersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListSubscribers
func (c *SecurityLake) ListSubscribersRequest(input *ListSubscribersInput) (req *request.Request, output *ListSubscribersOutput) {
	op := &request.Operation{
		Name:       opListSubscribers,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/subscribers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSubscribersInput{}
	}

	output = &ListSubscribersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSubscribers API operation for Amazon Security Lake.
//
// List all subscribers for the specific Security Lake account ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation ListSubscribers for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccountNotFoundException
//     Amazon Security Lake can't find an Amazon Web Services account with the accountID
//     that you specified, or the account whose credentials you used to make this
//     request isn't a member of an organization.
//
//   - InvalidInputException
//     The request was rejected because an invalid or out-of-range value was supplied
//     for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/ListSubscribers
func (c *SecurityLake) ListSubscribers(input *ListSubscribersInput) (*ListSubscribersOutput, error) {
	req, out := c.ListSubscribersRequest(input)
	return out, req.Send()
}

// ListSubscribersWithContext is the same as ListSubscribers with the addition of
// the ability to pass a context and additional request options.
//
// See ListSubscribers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) ListSubscribersWithContext(ctx aws.Context, input *ListSubscribersInput, opts ...request.Option) (*ListSubscribersOutput, error) {
	req, out := c.ListSubscribersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSubscribersPages iterates over the pages of a ListSubscribers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSubscribers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSubscribers operation.
//	pageNum := 0
//	err := client.ListSubscribersPages(params,
//	    func(page *securitylake.ListSubscribersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SecurityLake) ListSubscribersPages(input *ListSubscribersInput, fn func(*ListSubscribersOutput, bool) bool) error {
	return c.ListSubscribersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSubscribersPagesWithContext same as ListSubscribersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) ListSubscribersPagesWithContext(ctx aws.Context, input *ListSubscribersInput, fn func(*ListSubscribersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSubscribersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSubscribersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSubscribersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opUpdateDatalake = "UpdateDatalake"

// UpdateDatalakeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDatalake operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDatalake for more information on using the UpdateDatalake
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDatalakeRequest method.
//	req, resp := client.UpdateDatalakeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateDatalake
func (c *SecurityLake) UpdateDatalakeRequest(input *UpdateDatalakeInput) (req *request.Request, output *UpdateDatalakeOutput) {
	op := &request.Operation{
		Name:       opUpdateDatalake,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/datalake",
	}

	if input == nil {
		input = &UpdateDatalakeInput{}
	}

	output = &UpdateDatalakeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDatalake API operation for Amazon Security Lake.
//
// Amazon Security Lake allows you to specify where to store your security data
// and for how long. You can specify a rollup Region to consolidate data from
// multiple regions.
//
// You can update the properties of a Region or source. Input can either be
// directly specified to the API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation UpdateDatalake for usage and error information.
//
// Returned Error Types:
//
//   - EventBridgeException
//     Represents an error interacting with the Amazon EventBridge service.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateDatalake
func (c *SecurityLake) UpdateDatalake(input *UpdateDatalakeInput) (*UpdateDatalakeOutput, error) {
	req, out := c.UpdateDatalakeRequest(input)
	return out, req.Send()
}

// UpdateDatalakeWithContext is the same as UpdateDatalake with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDatalake for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) UpdateDatalakeWithContext(ctx aws.Context, input *UpdateDatalakeInput, opts ...request.Option) (*UpdateDatalakeOutput, error) {
	req, out := c.UpdateDatalakeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDatalakeExceptionsExpiry = "UpdateDatalakeExceptionsExpiry"

// UpdateDatalakeExceptionsExpiryRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDatalakeExceptionsExpiry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDatalakeExceptionsExpiry for more information on using the UpdateDatalakeExceptionsExpiry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDatalakeExceptionsExpiryRequest method.
//	req, resp := client.UpdateDatalakeExceptionsExpiryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateDatalakeExceptionsExpiry
func (c *SecurityLake) UpdateDatalakeExceptionsExpiryRequest(input *UpdateDatalakeExceptionsExpiryInput) (req *request.Request, output *UpdateDatalakeExceptionsExpiryOutput) {
	op := &request.Operation{
		Name:       opUpdateDatalakeExceptionsExpiry,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/datalake/exceptions/expiry",
	}

	if input == nil {
		input = &UpdateDatalakeExceptionsExpiryInput{}
	}

	output = &UpdateDatalakeExceptionsExpiryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDatalakeExceptionsExpiry API operation for Amazon Security Lake.
//
// Update the expiration period for the exception message to your preferred
// time, and control the time-to-live (TTL) for the exception message to remain.
// Exceptions are stored by default, for a 2 week period of time from when a
// record was created in Security Lake.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation UpdateDatalakeExceptionsExpiry for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - AccountNotFoundException
//     Amazon Security Lake can't find an Amazon Web Services account with the accountID
//     that you specified, or the account whose credentials you used to make this
//     request isn't a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateDatalakeExceptionsExpiry
func (c *SecurityLake) UpdateDatalakeExceptionsExpiry(input *UpdateDatalakeExceptionsExpiryInput) (*UpdateDatalakeExceptionsExpiryOutput, error) {
	req, out := c.UpdateDatalakeExceptionsExpiryRequest(input)
	return out, req.Send()
}

// UpdateDatalakeExceptionsExpiryWithContext is the same as UpdateDatalakeExceptionsExpiry with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDatalakeExceptionsExpiry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) UpdateDatalakeExceptionsExpiryWithContext(ctx aws.Context, input *UpdateDatalakeExceptionsExpiryInput, opts ...request.Option) (*UpdateDatalakeExceptionsExpiryOutput, error) {
	req, out := c.UpdateDatalakeExceptionsExpiryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDatalakeExceptionsSubscription = "UpdateDatalakeExceptionsSubscription"

// UpdateDatalakeExceptionsSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDatalakeExceptionsSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDatalakeExceptionsSubscription for more information on using the UpdateDatalakeExceptionsSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDatalakeExceptionsSubscriptionRequest method.
//	req, resp := client.UpdateDatalakeExceptionsSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateDatalakeExceptionsSubscription
func (c *SecurityLake) UpdateDatalakeExceptionsSubscriptionRequest(input *UpdateDatalakeExceptionsSubscriptionInput) (req *request.Request, output *UpdateDatalakeExceptionsSubscriptionOutput) {
	op := &request.Operation{
		Name:       opUpdateDatalakeExceptionsSubscription,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/datalake/exceptions/subscription",
	}

	if input == nil {
		input = &UpdateDatalakeExceptionsSubscriptionInput{}
	}

	output = &UpdateDatalakeExceptionsSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDatalakeExceptionsSubscription API operation for Amazon Security Lake.
//
// Update the subscription notification for exception notification.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation UpdateDatalakeExceptionsSubscription for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - AccountNotFoundException
//     Amazon Security Lake can't find an Amazon Web Services account with the accountID
//     that you specified, or the account whose credentials you used to make this
//     request isn't a member of an organization.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateDatalakeExceptionsSubscription
func (c *SecurityLake) UpdateDatalakeExceptionsSubscription(input *UpdateDatalakeExceptionsSubscriptionInput) (*UpdateDatalakeExceptionsSubscriptionOutput, error) {
	req, out := c.UpdateDatalakeExceptionsSubscriptionRequest(input)
	return out, req.Send()
}

// UpdateDatalakeExceptionsSubscriptionWithContext is the same as UpdateDatalakeExceptionsSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDatalakeExceptionsSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) UpdateDatalakeExceptionsSubscriptionWithContext(ctx aws.Context, input *UpdateDatalakeExceptionsSubscriptionInput, opts ...request.Option) (*UpdateDatalakeExceptionsSubscriptionOutput, error) {
	req, out := c.UpdateDatalakeExceptionsSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSubscriber = "UpdateSubscriber"

// UpdateSubscriberRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSubscriber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSubscriber for more information on using the UpdateSubscriber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSubscriberRequest method.
//	req, resp := client.UpdateSubscriberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateSubscriber
func (c *SecurityLake) UpdateSubscriberRequest(input *UpdateSubscriberInput) (req *request.Request, output *UpdateSubscriberOutput) {
	op := &request.Operation{
		Name:       opUpdateSubscriber,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/subscribers/{id}",
	}

	if input == nil {
		input = &UpdateSubscriberInput{}
	}

	output = &UpdateSubscriberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSubscriber API operation for Amazon Security Lake.
//
// Update the subscription permission for the given Security Lake account ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation UpdateSubscriber for usage and error information.
//
// Returned Error Types:
//
//   - ConflictSubscriptionException
//     A conflicting subscription exception operation is in progress.
//
//   - ConcurrentModificationException
//     More than one process tried to modify a resource at the same time.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - AccountNotFoundException
//     Amazon Security Lake can't find an Amazon Web Services account with the accountID
//     that you specified, or the account whose credentials you used to make this
//     request isn't a member of an organization.
//
//   - InvalidInputException
//     The request was rejected because an invalid or out-of-range value was supplied
//     for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateSubscriber
func (c *SecurityLake) UpdateSubscriber(input *UpdateSubscriberInput) (*UpdateSubscriberOutput, error) {
	req, out := c.UpdateSubscriberRequest(input)
	return out, req.Send()
}

// UpdateSubscriberWithContext is the same as UpdateSubscriber with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSubscriber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) UpdateSubscriberWithContext(ctx aws.Context, input *UpdateSubscriberInput, opts ...request.Option) (*UpdateSubscriberOutput, error) {
	req, out := c.UpdateSubscriberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSubscriptionNotificationConfiguration = "UpdateSubscriptionNotificationConfiguration"

// UpdateSubscriptionNotificationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSubscriptionNotificationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSubscriptionNotificationConfiguration for more information on using the UpdateSubscriptionNotificationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSubscriptionNotificationConfigurationRequest method.
//	req, resp := client.UpdateSubscriptionNotificationConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateSubscriptionNotificationConfiguration
func (c *SecurityLake) UpdateSubscriptionNotificationConfigurationRequest(input *UpdateSubscriptionNotificationConfigurationInput) (req *request.Request, output *UpdateSubscriptionNotificationConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateSubscriptionNotificationConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/subscription-notifications/{subscriptionId}",
	}

	if input == nil {
		input = &UpdateSubscriptionNotificationConfigurationInput{}
	}

	output = &UpdateSubscriptionNotificationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSubscriptionNotificationConfiguration API operation for Amazon Security Lake.
//
// Create a new subscription notification or add the existing subscription notification
// setting for the specified subscription ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Security Lake's
// API operation UpdateSubscriptionNotificationConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ConcurrentModificationException
//     More than one process tried to modify a resource at the same time.
//
//   - InternalServerException
//     Internal service exceptions are sometimes caused by transient issues. Before
//     you start troubleshooting, perform the operation again.
//
//   - ValidationException
//     Your signing certificate could not be validated.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. Access denied errors
//     appear when Amazon Security Lake explicitly or implicitly denies an authorization
//     request. An explicit denial occurs when a policy contains a Deny statement
//     for the specific Amazon Web Services action. An implicit denial occurs when
//     there is no applicable Deny statement and also no applicable Allow statement.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccountNotFoundException
//     Amazon Security Lake can't find an Amazon Web Services account with the accountID
//     that you specified, or the account whose credentials you used to make this
//     request isn't a member of an organization.
//
//   - InvalidInputException
//     The request was rejected because an invalid or out-of-range value was supplied
//     for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/UpdateSubscriptionNotificationConfiguration
func (c *SecurityLake) UpdateSubscriptionNotificationConfiguration(input *UpdateSubscriptionNotificationConfigurationInput) (*UpdateSubscriptionNotificationConfigurationOutput, error) {
	req, out := c.UpdateSubscriptionNotificationConfigurationRequest(input)
	return out, req.Send()
}

// UpdateSubscriptionNotificationConfigurationWithContext is the same as UpdateSubscriptionNotificationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSubscriptionNotificationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityLake) UpdateSubscriptionNotificationConfigurationWithContext(ctx aws.Context, input *UpdateSubscriptionNotificationConfigurationInput, opts ...request.Option) (*UpdateSubscriptionNotificationConfigurationOutput, error) {
	req, out := c.UpdateSubscriptionNotificationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action. Access denied errors
// appear when Amazon Security Lake explicitly or implicitly denies an authorization
// request. An explicit denial occurs when a policy contains a Deny statement
// for the specific Amazon Web Services action. An implicit denial occurs when
// there is no applicable Deny statement and also no applicable Allow statement.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Amazon Security Lake can't find an Amazon Web Services account with the accountID
// that you specified, or the account whose credentials you used to make this
// request isn't a member of an organization.
type AccountNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountNotFoundException) GoString() string {
	return s.String()
}

func newErrorAccountNotFoundException(v protocol.ResponseMetadata) error {
	return &AccountNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccountNotFoundException) Code() string {
	return "AccountNotFoundException"
}

// Message returns the exception's message.
func (s *AccountNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccountNotFoundException) OrigErr() error {
	return nil
}

func (s *AccountNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccountNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccountNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Security Lake can collect logs and events from supported Amazon Web Services
// services and custom sources.
type AccountSources struct {
	_ struct{} `type:"structure"`

	// Account ID of the Security Lake account for which logs are collected.
	//
	// Account is a required field
	Account *string `locationName:"account" type:"string" required:"true"`

	// Initializes a new instance of the Event class.
	EventClass *string `locationName:"eventClass" type:"string" enum:"OcsfEventClass"`

	// Log status for the Security Lake account.
	LogsStatus []*LogsStatus `locationName:"logsStatus" type:"list"`

	// The supported Amazon Web Services services from which logs and events are
	// collected. Amazon Security Lake supports logs and events collection for natively-supported
	// Amazon Web Services services. For more information, see the Amazon Security
	// Lake User Guide.
	//
	// SourceType is a required field
	SourceType *string `locationName:"sourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountSources) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountSources) GoString() string {
	return s.String()
}

// SetAccount sets the Account field's value.
func (s *AccountSources) SetAccount(v string) *AccountSources {
	s.Account = &v
	return s
}

// SetEventClass sets the EventClass field's value.
func (s *AccountSources) SetEventClass(v string) *AccountSources {
	s.EventClass = &v
	return s
}

// SetLogsStatus sets the LogsStatus field's value.
func (s *AccountSources) SetLogsStatus(v []*LogsStatus) *AccountSources {
	s.LogsStatus = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *AccountSources) SetSourceType(v string) *AccountSources {
	s.SourceType = &v
	return s
}

// Automatically enable new organization accounts as member accounts from a
// Security Lake administrator account.
type AutoEnableNewRegionConfiguration struct {
	_ struct{} `type:"structure"`

	// The Regions where Security Lake is auto enabled
	//
	// Region is a required field
	Region *string `locationName:"region" type:"string" required:"true" enum:"Region"`

	// The Amazon Web Services sources which are auto enabled in Security Lake.
	//
	// Sources is a required field
	Sources []*string `locationName:"sources" type:"list" required:"true" enum:"AwsLogSourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoEnableNewRegionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoEnableNewRegionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoEnableNewRegionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoEnableNewRegionConfiguration"}
	if s.Region == nil {
		invalidParams.Add(request.NewErrParamRequired("Region"))
	}
	if s.Sources == nil {
		invalidParams.Add(request.NewErrParamRequired("Sources"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegion sets the Region field's value.
func (s *AutoEnableNewRegionConfiguration) SetRegion(v string) *AutoEnableNewRegionConfiguration {
	s.Region = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *AutoEnableNewRegionConfiguration) SetSources(v []*string) *AutoEnableNewRegionConfiguration {
	s.Sources = v
	return s
}

// Amazon Security Lake generally returns 404 errors if the requested object
// is missing from the bucket.
type BucketNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BucketNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BucketNotFoundException) GoString() string {
	return s.String()
}

func newErrorBucketNotFoundException(v protocol.ResponseMetadata) error {
	return &BucketNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BucketNotFoundException) Code() string {
	return "BucketNotFoundException"
}

// Message returns the exception's message.
func (s *BucketNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BucketNotFoundException) OrigErr() error {
	return nil
}

func (s *BucketNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BucketNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BucketNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// More than one process tried to modify a resource at the same time.
type ConcurrentModificationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s *ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentModificationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentModificationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Occurs when a conflict with a previous successful write is detected. This
// generally occurs when the previous write did not have time to propagate to
// the host serving the current request. A retry (with appropriate backoff logic)
// is the recommended response to this exception.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// A conflict occurred when prompting for the Resource ID.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The resource type.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// There was a conflict when you attempted to modify a Security Lake source
// name.
type ConflictSourceNamesException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictSourceNamesException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictSourceNamesException) GoString() string {
	return s.String()
}

func newErrorConflictSourceNamesException(v protocol.ResponseMetadata) error {
	return &ConflictSourceNamesException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictSourceNamesException) Code() string {
	return "ConflictSourceNamesException"
}

// Message returns the exception's message.
func (s *ConflictSourceNamesException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictSourceNamesException) OrigErr() error {
	return nil
}

func (s *ConflictSourceNamesException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictSourceNamesException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictSourceNamesException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A conflicting subscription exception operation is in progress.
type ConflictSubscriptionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictSubscriptionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictSubscriptionException) GoString() string {
	return s.String()
}

func newErrorConflictSubscriptionException(v protocol.ResponseMetadata) error {
	return &ConflictSubscriptionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictSubscriptionException) Code() string {
	return "ConflictSubscriptionException"
}

// Message returns the exception's message.
func (s *ConflictSubscriptionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictSubscriptionException) OrigErr() error {
	return nil
}

func (s *ConflictSubscriptionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictSubscriptionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictSubscriptionException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAwsLogSourceInput struct {
	_ struct{} `type:"structure"`

	// Enables specific sources in all Regions and source types.
	EnableAllDimensions map[string]map[string][]*string `locationName:"enableAllDimensions" type:"map"`

	// Enables all sources in specific accounts or Regions.
	EnableSingleDimension []*string `locationName:"enableSingleDimension" type:"list"`

	// Enables specific service sources in specific accounts or Regions.
	EnableTwoDimensions map[string][]*string `locationName:"enableTwoDimensions" type:"map"`

	// Specifies the input order to enable dimensions in Security Lake, namely region,
	// source type, and member account.
	//
	// InputOrder is a required field
	InputOrder []*string `locationName:"inputOrder" type:"list" required:"true" enum:"Dimension"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAwsLogSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAwsLogSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAwsLogSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAwsLogSourceInput"}
	if s.InputOrder == nil {
		invalidParams.Add(request.NewErrParamRequired("InputOrder"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnableAllDimensions sets the EnableAllDimensions field's value.
func (s *CreateAwsLogSourceInput) SetEnableAllDimensions(v map[string]map[string][]*string) *CreateAwsLogSourceInput {
	s.EnableAllDimensions = v
	return s
}

// SetEnableSingleDimension sets the EnableSingleDimension field's value.
func (s *CreateAwsLogSourceInput) SetEnableSingleDimension(v []*string) *CreateAwsLogSourceInput {
	s.EnableSingleDimension = v
	return s
}

// SetEnableTwoDimensions sets the EnableTwoDimensions field's value.
func (s *CreateAwsLogSourceInput) SetEnableTwoDimensions(v map[string][]*string) *CreateAwsLogSourceInput {
	s.EnableTwoDimensions = v
	return s
}

// SetInputOrder sets the InputOrder field's value.
func (s *CreateAwsLogSourceInput) SetInputOrder(v []*string) *CreateAwsLogSourceInput {
	s.InputOrder = v
	return s
}

type CreateAwsLogSourceOutput struct {
	_ struct{} `type:"structure"`

	// List of all accounts in which enabling a natively-supported Amazon Web Services
	// service as a Security Lake failed. The failure occurred as these accounts
	// are not part of an organization.
	Failed []*string `locationName:"failed" type:"list"`

	// List of all accounts which are in the process of enabling a natively-supported
	// Amazon Web Services service as a Security Lake.
	Processing []*string `locationName:"processing" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAwsLogSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAwsLogSourceOutput) GoString() string {
	return s.String()
}

// SetFailed sets the Failed field's value.
func (s *CreateAwsLogSourceOutput) SetFailed(v []*string) *CreateAwsLogSourceOutput {
	s.Failed = v
	return s
}

// SetProcessing sets the Processing field's value.
func (s *CreateAwsLogSourceOutput) SetProcessing(v []*string) *CreateAwsLogSourceOutput {
	s.Processing = v
	return s
}

type CreateCustomLogSourceInput struct {
	_ struct{} `type:"structure"`

	// The custom source name for a third-party custom source.
	//
	// CustomSourceName is a required field
	CustomSourceName *string `locationName:"customSourceName" type:"string" required:"true"`

	// The Open Cybersecurity Schema Framework (OCSF) event class.
	//
	// EventClass is a required field
	EventClass *string `locationName:"eventClass" type:"string" required:"true" enum:"OcsfEventClass"`

	// The IAM Role ARN to be used by the Glue Crawler. The recommended IAM policies
	// are:
	//
	//    * The managed policy AWSGlueServiceRole
	//
	//    * A custom policy granting access to your S3 Data Lake
	//
	// GlueInvocationRoleArn is a required field
	GlueInvocationRoleArn *string `locationName:"glueInvocationRoleArn" type:"string" required:"true"`

	// The Account ID that will assume the above Role to put logs into the Data
	// Lake.
	//
	// LogProviderAccountId is a required field
	LogProviderAccountId *string `locationName:"logProviderAccountId" min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomLogSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomLogSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCustomLogSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCustomLogSourceInput"}
	if s.CustomSourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomSourceName"))
	}
	if s.EventClass == nil {
		invalidParams.Add(request.NewErrParamRequired("EventClass"))
	}
	if s.GlueInvocationRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GlueInvocationRoleArn"))
	}
	if s.LogProviderAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("LogProviderAccountId"))
	}
	if s.LogProviderAccountId != nil && len(*s.LogProviderAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("LogProviderAccountId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomSourceName sets the CustomSourceName field's value.
func (s *CreateCustomLogSourceInput) SetCustomSourceName(v string) *CreateCustomLogSourceInput {
	s.CustomSourceName = &v
	return s
}

// SetEventClass sets the EventClass field's value.
func (s *CreateCustomLogSourceInput) SetEventClass(v string) *CreateCustomLogSourceInput {
	s.EventClass = &v
	return s
}

// SetGlueInvocationRoleArn sets the GlueInvocationRoleArn field's value.
func (s *CreateCustomLogSourceInput) SetGlueInvocationRoleArn(v string) *CreateCustomLogSourceInput {
	s.GlueInvocationRoleArn = &v
	return s
}

// SetLogProviderAccountId sets the LogProviderAccountId field's value.
func (s *CreateCustomLogSourceInput) SetLogProviderAccountId(v string) *CreateCustomLogSourceInput {
	s.LogProviderAccountId = &v
	return s
}

type CreateCustomLogSourceOutput struct {
	_ struct{} `type:"structure"`

	// The location of the partition in the Security Lake S3 bucket.
	//
	// CustomDataLocation is a required field
	CustomDataLocation *string `locationName:"customDataLocation" type:"string" required:"true"`

	// The name of the Glue crawler.
	//
	// GlueCrawlerName is a required field
	GlueCrawlerName *string `locationName:"glueCrawlerName" type:"string" required:"true"`

	// The Glue database where results are written, such as: arn:aws:daylight:us-east-1::database/sometable/*.
	//
	// GlueDatabaseName is a required field
	GlueDatabaseName *string `locationName:"glueDatabaseName" type:"string" required:"true"`

	// The table name of the Glue crawler.
	//
	// GlueTableName is a required field
	GlueTableName *string `locationName:"glueTableName" type:"string" required:"true"`

	// IAM Role ARN to be used by the entity putting logs into your Custom Source
	// partition. Security Lake will apply the correct access policies to this Role,
	// but this Role must have the trust policy created manually. This Role's name
	// must start with the text 'Security Lake'. It must trust the logProviderAccountId
	// to assume it.
	//
	// LogProviderAccessRoleArn is a required field
	LogProviderAccessRoleArn *string `locationName:"logProviderAccessRoleArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomLogSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomLogSourceOutput) GoString() string {
	return s.String()
}

// SetCustomDataLocation sets the CustomDataLocation field's value.
func (s *CreateCustomLogSourceOutput) SetCustomDataLocation(v string) *CreateCustomLogSourceOutput {
	s.CustomDataLocation = &v
	return s
}

// SetGlueCrawlerName sets the GlueCrawlerName field's value.
func (s *CreateCustomLogSourceOutput) SetGlueCrawlerName(v string) *CreateCustomLogSourceOutput {
	s.GlueCrawlerName = &v
	return s
}

// SetGlueDatabaseName sets the GlueDatabaseName field's value.
func (s *CreateCustomLogSourceOutput) SetGlueDatabaseName(v string) *CreateCustomLogSourceOutput {
	s.GlueDatabaseName = &v
	return s
}

// SetGlueTableName sets the GlueTableName field's value.
func (s *CreateCustomLogSourceOutput) SetGlueTableName(v string) *CreateCustomLogSourceOutput {
	s.GlueTableName = &v
	return s
}

// SetLogProviderAccessRoleArn sets the LogProviderAccessRoleArn field's value.
func (s *CreateCustomLogSourceOutput) SetLogProviderAccessRoleArn(v string) *CreateCustomLogSourceOutput {
	s.LogProviderAccessRoleArn = &v
	return s
}

type CreateDatalakeAutoEnableInput struct {
	_ struct{} `type:"structure"`

	// Enable Amazon Security Lake with the specified configurations settings to
	// begin ingesting security data for new accounts in Security Lake.
	//
	// ConfigurationForNewAccounts is a required field
	ConfigurationForNewAccounts []*AutoEnableNewRegionConfiguration `locationName:"configurationForNewAccounts" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatalakeAutoEnableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatalakeAutoEnableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatalakeAutoEnableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatalakeAutoEnableInput"}
	if s.ConfigurationForNewAccounts == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationForNewAccounts"))
	}
	if s.ConfigurationForNewAccounts != nil {
		for i, v := range s.ConfigurationForNewAccounts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ConfigurationForNewAccounts", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationForNewAccounts sets the ConfigurationForNewAccounts field's value.
func (s *CreateDatalakeAutoEnableInput) SetConfigurationForNewAccounts(v []*AutoEnableNewRegionConfiguration) *CreateDatalakeAutoEnableInput {
	s.ConfigurationForNewAccounts = v
	return s
}

type CreateDatalakeAutoEnableOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatalakeAutoEnableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatalakeAutoEnableOutput) GoString() string {
	return s.String()
}

type CreateDatalakeDelegatedAdminInput struct {
	_ struct{} `type:"structure"`

	// Account ID of the Security Lake delegated administrator.
	//
	// Account is a required field
	Account *string `locationName:"account" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatalakeDelegatedAdminInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatalakeDelegatedAdminInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatalakeDelegatedAdminInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatalakeDelegatedAdminInput"}
	if s.Account == nil {
		invalidParams.Add(request.NewErrParamRequired("Account"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccount sets the Account field's value.
func (s *CreateDatalakeDelegatedAdminInput) SetAccount(v string) *CreateDatalakeDelegatedAdminInput {
	s.Account = &v
	return s
}

type CreateDatalakeDelegatedAdminOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatalakeDelegatedAdminOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatalakeDelegatedAdminOutput) GoString() string {
	return s.String()
}

type CreateDatalakeExceptionsSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The account in which the exception notifications subscription is created.
	//
	// NotificationEndpoint is a required field
	NotificationEndpoint *string `locationName:"notificationEndpoint" type:"string" required:"true"`

	// The subscription protocol to which exception messages are posted.
	//
	// SubscriptionProtocol is a required field
	SubscriptionProtocol *string `locationName:"subscriptionProtocol" type:"string" required:"true" enum:"SubscriptionProtocolType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatalakeExceptionsSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatalakeExceptionsSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatalakeExceptionsSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatalakeExceptionsSubscriptionInput"}
	if s.NotificationEndpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("NotificationEndpoint"))
	}
	if s.SubscriptionProtocol == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionProtocol"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotificationEndpoint sets the NotificationEndpoint field's value.
func (s *CreateDatalakeExceptionsSubscriptionInput) SetNotificationEndpoint(v string) *CreateDatalakeExceptionsSubscriptionInput {
	s.NotificationEndpoint = &v
	return s
}

// SetSubscriptionProtocol sets the SubscriptionProtocol field's value.
func (s *CreateDatalakeExceptionsSubscriptionInput) SetSubscriptionProtocol(v string) *CreateDatalakeExceptionsSubscriptionInput {
	s.SubscriptionProtocol = &v
	return s
}

type CreateDatalakeExceptionsSubscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatalakeExceptionsSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatalakeExceptionsSubscriptionOutput) GoString() string {
	return s.String()
}

type CreateDatalakeInput struct {
	_ struct{} `type:"structure"`

	// Enable Security Lake with the specified configurations settings to begin
	// ingesting security data.
	Configurations map[string]*LakeConfigurationRequest `locationName:"configurations" type:"map"`

	// Enable Security Lake in all Regions to begin ingesting security data.
	EnableAll *bool `locationName:"enableAll" type:"boolean"`

	// The Role ARN used to create and update the Glue table with partitions generated
	// by ingestion and normalization of Amazon Web Services log sources and custom
	// sources.
	MetaStoreManagerRoleArn *string `locationName:"metaStoreManagerRoleArn" type:"string"`

	// Enable Security Lake in the specified Regions to begin ingesting security
	// data. To enable Security Lake in specific Amazon Web Services Regions, such
	// as us-east-1 or ap-northeast-3, provide the Region codes. For a list of Region
	// codes, see Region codes (https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints)
	// in the Amazon Web Services General Reference.
	Regions []*string `locationName:"regions" type:"list" enum:"Region"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatalakeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatalakeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatalakeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatalakeInput"}
	if s.Configurations != nil {
		for i, v := range s.Configurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Configurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurations sets the Configurations field's value.
func (s *CreateDatalakeInput) SetConfigurations(v map[string]*LakeConfigurationRequest) *CreateDatalakeInput {
	s.Configurations = v
	return s
}

// SetEnableAll sets the EnableAll field's value.
func (s *CreateDatalakeInput) SetEnableAll(v bool) *CreateDatalakeInput {
	s.EnableAll = &v
	return s
}

// SetMetaStoreManagerRoleArn sets the MetaStoreManagerRoleArn field's value.
func (s *CreateDatalakeInput) SetMetaStoreManagerRoleArn(v string) *CreateDatalakeInput {
	s.MetaStoreManagerRoleArn = &v
	return s
}

// SetRegions sets the Regions field's value.
func (s *CreateDatalakeInput) SetRegions(v []*string) *CreateDatalakeInput {
	s.Regions = v
	return s
}

type CreateDatalakeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatalakeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatalakeOutput) GoString() string {
	return s.String()
}

type CreateSubscriberInput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 or Lake Formation access type.
	AccessTypes []*string `locationName:"accessTypes" type:"list" enum:"AccessType"`

	// The third party Amazon Web Services account ID used to access your data.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`

	// The external ID of the subscriber. External ID allows the user that is assuming
	// the role to assert the circumstances in which they are operating. It also
	// provides a way for the account owner to permit the role to be assumed only
	// under specific circumstances.
	//
	// ExternalId is a required field
	ExternalId *string `locationName:"externalId" type:"string" required:"true"`

	// The supported Amazon Web Services services from which logs and events are
	// collected. Amazon Security Lake supports logs and events collection for natively-supported
	// Amazon Web Services services.
	//
	// SourceTypes is a required field
	SourceTypes []*SourceType `locationName:"sourceTypes" type:"list" required:"true"`

	// The subscriber descriptions for the subscriber account in Amazon Security
	// Lake.
	SubscriberDescription *string `locationName:"subscriberDescription" type:"string"`

	// The name of your Amazon Security Lake subscriber account.
	//
	// SubscriberName is a required field
	SubscriberName *string `locationName:"subscriberName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSubscriberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSubscriberInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.ExternalId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalId"))
	}
	if s.SourceTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceTypes"))
	}
	if s.SubscriberName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriberName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessTypes sets the AccessTypes field's value.
func (s *CreateSubscriberInput) SetAccessTypes(v []*string) *CreateSubscriberInput {
	s.AccessTypes = v
	return s
}

// SetAccountId sets the AccountId field's value.
func (s *CreateSubscriberInput) SetAccountId(v string) *CreateSubscriberInput {
	s.AccountId = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *CreateSubscriberInput) SetExternalId(v string) *CreateSubscriberInput {
	s.ExternalId = &v
	return s
}

// SetSourceTypes sets the SourceTypes field's value.
func (s *CreateSubscriberInput) SetSourceTypes(v []*SourceType) *CreateSubscriberInput {
	s.SourceTypes = v
	return s
}

// SetSubscriberDescription sets the SubscriberDescription field's value.
func (s *CreateSubscriberInput) SetSubscriberDescription(v string) *CreateSubscriberInput {
	s.SubscriberDescription = &v
	return s
}

// SetSubscriberName sets the SubscriberName field's value.
func (s *CreateSubscriberInput) SetSubscriberName(v string) *CreateSubscriberInput {
	s.SubscriberName = &v
	return s
}

type CreateSubscriberOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) created by the user to provide to the subscriber.
	// For more information about ARNs and how to use them in policies, see IAM
	// identifiers in the IAM User Guide.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The Amazon Resource Name (ARN) for the Amazon S3 bucket.
	S3BucketArn *string `locationName:"s3BucketArn" type:"string"`

	// The Amazon Resource Name (ARN) for the Amazon Simple Notification Service.
	SnsArn *string `locationName:"snsArn" type:"string"`

	// The subscriptionId that was created by the CreateSubscriber API call.
	//
	// SubscriptionId is a required field
	SubscriptionId *string `locationName:"subscriptionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriberOutput) GoString() string {
	return s.String()
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateSubscriberOutput) SetRoleArn(v string) *CreateSubscriberOutput {
	s.RoleArn = &v
	return s
}

// SetS3BucketArn sets the S3BucketArn field's value.
func (s *CreateSubscriberOutput) SetS3BucketArn(v string) *CreateSubscriberOutput {
	s.S3BucketArn = &v
	return s
}

// SetSnsArn sets the SnsArn field's value.
func (s *CreateSubscriberOutput) SetSnsArn(v string) *CreateSubscriberOutput {
	s.SnsArn = &v
	return s
}

// SetSubscriptionId sets the SubscriptionId field's value.
func (s *CreateSubscriberOutput) SetSubscriptionId(v string) *CreateSubscriberOutput {
	s.SubscriptionId = &v
	return s
}

type CreateSubscriptionNotificationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Create a new subscription notification for the specified subscription ID
	// in Security Lake.
	CreateSqs *bool `locationName:"createSqs" type:"boolean"`

	// The key name for the subscription notification.
	HttpsApiKeyName *string `locationName:"httpsApiKeyName" type:"string"`

	// The key value for the subscription notification.
	HttpsApiKeyValue *string `locationName:"httpsApiKeyValue" type:"string"`

	// The HTTPS method used for the subscription notification.
	HttpsMethod *string `locationName:"httpsMethod" type:"string" enum:"HttpsMethod"`

	// The Amazon Resource Name (ARN) specifying the role of the subscriber.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The subscription endpoint in Security Lake.
	SubscriptionEndpoint *string `locationName:"subscriptionEndpoint" type:"string"`

	// The subscription ID for which the subscription notification is specified.
	//
	// SubscriptionId is a required field
	SubscriptionId *string `location:"uri" locationName:"subscriptionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriptionNotificationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriptionNotificationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSubscriptionNotificationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSubscriptionNotificationConfigurationInput"}
	if s.SubscriptionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionId"))
	}
	if s.SubscriptionId != nil && len(*s.SubscriptionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubscriptionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreateSqs sets the CreateSqs field's value.
func (s *CreateSubscriptionNotificationConfigurationInput) SetCreateSqs(v bool) *CreateSubscriptionNotificationConfigurationInput {
	s.CreateSqs = &v
	return s
}

// SetHttpsApiKeyName sets the HttpsApiKeyName field's value.
func (s *CreateSubscriptionNotificationConfigurationInput) SetHttpsApiKeyName(v string) *CreateSubscriptionNotificationConfigurationInput {
	s.HttpsApiKeyName = &v
	return s
}

// SetHttpsApiKeyValue sets the HttpsApiKeyValue field's value.
func (s *CreateSubscriptionNotificationConfigurationInput) SetHttpsApiKeyValue(v string) *CreateSubscriptionNotificationConfigurationInput {
	s.HttpsApiKeyValue = &v
	return s
}

// SetHttpsMethod sets the HttpsMethod field's value.
func (s *CreateSubscriptionNotificationConfigurationInput) SetHttpsMethod(v string) *CreateSubscriptionNotificationConfigurationInput {
	s.HttpsMethod = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateSubscriptionNotificationConfigurationInput) SetRoleArn(v string) *CreateSubscriptionNotificationConfigurationInput {
	s.RoleArn = &v
	return s
}

// SetSubscriptionEndpoint sets the SubscriptionEndpoint field's value.
func (s *CreateSubscriptionNotificationConfigurationInput) SetSubscriptionEndpoint(v string) *CreateSubscriptionNotificationConfigurationInput {
	s.SubscriptionEndpoint = &v
	return s
}

// SetSubscriptionId sets the SubscriptionId field's value.
func (s *CreateSubscriptionNotificationConfigurationInput) SetSubscriptionId(v string) *CreateSubscriptionNotificationConfigurationInput {
	s.SubscriptionId = &v
	return s
}

type CreateSubscriptionNotificationConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Returns the Amazon resource name (ARN) of the queue.
	QueueArn *string `locationName:"queueArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriptionNotificationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriptionNotificationConfigurationOutput) GoString() string {
	return s.String()
}

// SetQueueArn sets the QueueArn field's value.
func (s *CreateSubscriptionNotificationConfigurationOutput) SetQueueArn(v string) *CreateSubscriptionNotificationConfigurationOutput {
	s.QueueArn = &v
	return s
}

type DeleteAwsLogSourceInput struct {
	_ struct{} `type:"structure"`

	// Removes the specific Amazon Web Services sources from all Regions and source
	// types.
	DisableAllDimensions map[string]map[string][]*string `locationName:"disableAllDimensions" type:"map"`

	// Removes all Amazon Web Services sources from specific accounts or Regions.
	DisableSingleDimension []*string `locationName:"disableSingleDimension" type:"list"`

	// Remove a specific Amazon Web Services source from specific accounts or Regions.
	DisableTwoDimensions map[string][]*string `locationName:"disableTwoDimensions" type:"map"`

	// This is a mandatory input. Specifies the input order to disable dimensions
	// in Security Lake, namely Region, source type, and member.
	//
	// InputOrder is a required field
	InputOrder []*string `locationName:"inputOrder" type:"list" required:"true" enum:"Dimension"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAwsLogSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAwsLogSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAwsLogSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAwsLogSourceInput"}
	if s.InputOrder == nil {
		invalidParams.Add(request.NewErrParamRequired("InputOrder"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisableAllDimensions sets the DisableAllDimensions field's value.
func (s *DeleteAwsLogSourceInput) SetDisableAllDimensions(v map[string]map[string][]*string) *DeleteAwsLogSourceInput {
	s.DisableAllDimensions = v
	return s
}

// SetDisableSingleDimension sets the DisableSingleDimension field's value.
func (s *DeleteAwsLogSourceInput) SetDisableSingleDimension(v []*string) *DeleteAwsLogSourceInput {
	s.DisableSingleDimension = v
	return s
}

// SetDisableTwoDimensions sets the DisableTwoDimensions field's value.
func (s *DeleteAwsLogSourceInput) SetDisableTwoDimensions(v map[string][]*string) *DeleteAwsLogSourceInput {
	s.DisableTwoDimensions = v
	return s
}

// SetInputOrder sets the InputOrder field's value.
func (s *DeleteAwsLogSourceInput) SetInputOrder(v []*string) *DeleteAwsLogSourceInput {
	s.InputOrder = v
	return s
}

type DeleteAwsLogSourceOutput struct {
	_ struct{} `type:"structure"`

	// Deletion of the Amazon Web Services sources failed as the account is not
	// a part of the organization.
	Failed []*string `locationName:"failed" type:"list"`

	// Deletion of the Amazon Web Services sources is in-progress.
	Processing []*string `locationName:"processing" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAwsLogSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAwsLogSourceOutput) GoString() string {
	return s.String()
}

// SetFailed sets the Failed field's value.
func (s *DeleteAwsLogSourceOutput) SetFailed(v []*string) *DeleteAwsLogSourceOutput {
	s.Failed = v
	return s
}

// SetProcessing sets the Processing field's value.
func (s *DeleteAwsLogSourceOutput) SetProcessing(v []*string) *DeleteAwsLogSourceOutput {
	s.Processing = v
	return s
}

type DeleteCustomLogSourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The custom source name for the custome log source.
	//
	// CustomSourceName is a required field
	CustomSourceName *string `location:"querystring" locationName:"customSourceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomLogSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomLogSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCustomLogSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCustomLogSourceInput"}
	if s.CustomSourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomSourceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomSourceName sets the CustomSourceName field's value.
func (s *DeleteCustomLogSourceInput) SetCustomSourceName(v string) *DeleteCustomLogSourceInput {
	s.CustomSourceName = &v
	return s
}

type DeleteCustomLogSourceOutput struct {
	_ struct{} `type:"structure"`

	// The location of the partition in the Security Lake S3 bucket.
	//
	// CustomDataLocation is a required field
	CustomDataLocation *string `locationName:"customDataLocation" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomLogSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomLogSourceOutput) GoString() string {
	return s.String()
}

// SetCustomDataLocation sets the CustomDataLocation field's value.
func (s *DeleteCustomLogSourceOutput) SetCustomDataLocation(v string) *DeleteCustomLogSourceOutput {
	s.CustomDataLocation = &v
	return s
}

type DeleteDatalakeAutoEnableInput struct {
	_ struct{} `type:"structure"`

	// Delete Amazon Security Lake with the specified configurations settings to
	// stop ingesting security data for new accounts in Security Lake.
	//
	// RemoveFromConfigurationForNewAccounts is a required field
	RemoveFromConfigurationForNewAccounts []*AutoEnableNewRegionConfiguration `locationName:"removeFromConfigurationForNewAccounts" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatalakeAutoEnableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatalakeAutoEnableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDatalakeAutoEnableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDatalakeAutoEnableInput"}
	if s.RemoveFromConfigurationForNewAccounts == nil {
		invalidParams.Add(request.NewErrParamRequired("RemoveFromConfigurationForNewAccounts"))
	}
	if s.RemoveFromConfigurationForNewAccounts != nil {
		for i, v := range s.RemoveFromConfigurationForNewAccounts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RemoveFromConfigurationForNewAccounts", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRemoveFromConfigurationForNewAccounts sets the RemoveFromConfigurationForNewAccounts field's value.
func (s *DeleteDatalakeAutoEnableInput) SetRemoveFromConfigurationForNewAccounts(v []*AutoEnableNewRegionConfiguration) *DeleteDatalakeAutoEnableInput {
	s.RemoveFromConfigurationForNewAccounts = v
	return s
}

type DeleteDatalakeAutoEnableOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatalakeAutoEnableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatalakeAutoEnableOutput) GoString() string {
	return s.String()
}

type DeleteDatalakeDelegatedAdminInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Account ID the Security Lake delegated administrator.
	//
	// Account is a required field
	Account *string `location:"uri" locationName:"account" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatalakeDelegatedAdminInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatalakeDelegatedAdminInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDatalakeDelegatedAdminInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDatalakeDelegatedAdminInput"}
	if s.Account == nil {
		invalidParams.Add(request.NewErrParamRequired("Account"))
	}
	if s.Account != nil && len(*s.Account) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Account", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccount sets the Account field's value.
func (s *DeleteDatalakeDelegatedAdminInput) SetAccount(v string) *DeleteDatalakeDelegatedAdminInput {
	s.Account = &v
	return s
}

type DeleteDatalakeDelegatedAdminOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatalakeDelegatedAdminOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatalakeDelegatedAdminOutput) GoString() string {
	return s.String()
}

type DeleteDatalakeExceptionsSubscriptionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatalakeExceptionsSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatalakeExceptionsSubscriptionInput) GoString() string {
	return s.String()
}

type DeleteDatalakeExceptionsSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Retrieves the status of the delete Security Lake operation for an account.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatalakeExceptionsSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatalakeExceptionsSubscriptionOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *DeleteDatalakeExceptionsSubscriptionOutput) SetStatus(v string) *DeleteDatalakeExceptionsSubscriptionOutput {
	s.Status = &v
	return s
}

type DeleteDatalakeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatalakeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatalakeInput) GoString() string {
	return s.String()
}

type DeleteDatalakeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatalakeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatalakeOutput) GoString() string {
	return s.String()
}

type DeleteSubscriberInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A value created by Security Lake that uniquely identifies your DeleteSubscriber
	// API request.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSubscriberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSubscriberInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteSubscriberInput) SetId(v string) *DeleteSubscriberInput {
	s.Id = &v
	return s
}

type DeleteSubscriberOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriberOutput) GoString() string {
	return s.String()
}

type DeleteSubscriptionNotificationConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The subscription ID of the Amazon Security Lake subscriber account.
	//
	// SubscriptionId is a required field
	SubscriptionId *string `location:"uri" locationName:"subscriptionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriptionNotificationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriptionNotificationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSubscriptionNotificationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSubscriptionNotificationConfigurationInput"}
	if s.SubscriptionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionId"))
	}
	if s.SubscriptionId != nil && len(*s.SubscriptionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubscriptionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubscriptionId sets the SubscriptionId field's value.
func (s *DeleteSubscriptionNotificationConfigurationInput) SetSubscriptionId(v string) *DeleteSubscriptionNotificationConfigurationInput {
	s.SubscriptionId = &v
	return s
}

type DeleteSubscriptionNotificationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriptionNotificationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriptionNotificationConfigurationOutput) GoString() string {
	return s.String()
}

// Represents an error interacting with the Amazon EventBridge service.
type EventBridgeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventBridgeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventBridgeException) GoString() string {
	return s.String()
}

func newErrorEventBridgeException(v protocol.ResponseMetadata) error {
	return &EventBridgeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *EventBridgeException) Code() string {
	return "EventBridgeException"
}

// Message returns the exception's message.
func (s *EventBridgeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *EventBridgeException) OrigErr() error {
	return nil
}

func (s *EventBridgeException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *EventBridgeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *EventBridgeException) RequestID() string {
	return s.RespMetadata.RequestID
}

// List of all failures.
type Failures struct {
	_ struct{} `type:"structure"`

	// List of all exception messages.
	//
	// ExceptionMessage is a required field
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string" required:"true"`

	// List of all remediation steps for failures.
	//
	// Remediation is a required field
	Remediation *string `locationName:"remediation" type:"string" required:"true"`

	// This error can occur if you configure the wrong timestamp format, or if the
	// subset of entries used for validation had errors or missing values.
	//
	// Timestamp is a required field
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Failures) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Failures) GoString() string {
	return s.String()
}

// SetExceptionMessage sets the ExceptionMessage field's value.
func (s *Failures) SetExceptionMessage(v string) *Failures {
	s.ExceptionMessage = &v
	return s
}

// SetRemediation sets the Remediation field's value.
func (s *Failures) SetRemediation(v string) *Failures {
	s.Remediation = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *Failures) SetTimestamp(v time.Time) *Failures {
	s.Timestamp = &v
	return s
}

// Response element for actions which make changes namely create, update, or
// delete actions.
type FailuresResponse struct {
	_ struct{} `type:"structure"`

	// List of all failures.
	Failures []*Failures `locationName:"failures" type:"list"`

	// List of Regions where the failure occurred.
	Region *string `locationName:"region" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailuresResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailuresResponse) GoString() string {
	return s.String()
}

// SetFailures sets the Failures field's value.
func (s *FailuresResponse) SetFailures(v []*Failures) *FailuresResponse {
	s.Failures = v
	return s
}

// SetRegion sets the Region field's value.
func (s *FailuresResponse) SetRegion(v string) *FailuresResponse {
	s.Region = &v
	return s
}

type GetDatalakeAutoEnableInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatalakeAutoEnableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatalakeAutoEnableInput) GoString() string {
	return s.String()
}

type GetDatalakeAutoEnableOutput struct {
	_ struct{} `type:"structure"`

	// The configuration for new accounts.
	//
	// AutoEnableNewAccounts is a required field
	AutoEnableNewAccounts []*AutoEnableNewRegionConfiguration `locationName:"autoEnableNewAccounts" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatalakeAutoEnableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatalakeAutoEnableOutput) GoString() string {
	return s.String()
}

// SetAutoEnableNewAccounts sets the AutoEnableNewAccounts field's value.
func (s *GetDatalakeAutoEnableOutput) SetAutoEnableNewAccounts(v []*AutoEnableNewRegionConfiguration) *GetDatalakeAutoEnableOutput {
	s.AutoEnableNewAccounts = v
	return s
}

type GetDatalakeExceptionsExpiryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatalakeExceptionsExpiryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatalakeExceptionsExpiryInput) GoString() string {
	return s.String()
}

type GetDatalakeExceptionsExpiryOutput struct {
	_ struct{} `type:"structure"`

	// The expiration period and time-to-live (TTL).
	//
	// ExceptionMessageExpiry is a required field
	ExceptionMessageExpiry *int64 `locationName:"exceptionMessageExpiry" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatalakeExceptionsExpiryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatalakeExceptionsExpiryOutput) GoString() string {
	return s.String()
}

// SetExceptionMessageExpiry sets the ExceptionMessageExpiry field's value.
func (s *GetDatalakeExceptionsExpiryOutput) SetExceptionMessageExpiry(v int64) *GetDatalakeExceptionsExpiryOutput {
	s.ExceptionMessageExpiry = &v
	return s
}

type GetDatalakeExceptionsSubscriptionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatalakeExceptionsSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatalakeExceptionsSubscriptionInput) GoString() string {
	return s.String()
}

type GetDatalakeExceptionsSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Retrieves the exception notification subscription information.
	//
	// ProtocolAndNotificationEndpoint is a required field
	ProtocolAndNotificationEndpoint *ProtocolAndNotificationEndpoint `locationName:"protocolAndNotificationEndpoint" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatalakeExceptionsSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatalakeExceptionsSubscriptionOutput) GoString() string {
	return s.String()
}

// SetProtocolAndNotificationEndpoint sets the ProtocolAndNotificationEndpoint field's value.
func (s *GetDatalakeExceptionsSubscriptionOutput) SetProtocolAndNotificationEndpoint(v *ProtocolAndNotificationEndpoint) *GetDatalakeExceptionsSubscriptionOutput {
	s.ProtocolAndNotificationEndpoint = v
	return s
}

type GetDatalakeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatalakeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatalakeInput) GoString() string {
	return s.String()
}

type GetDatalakeOutput struct {
	_ struct{} `type:"structure"`

	// Retrieves the Security Lake configuration object.
	//
	// Configurations is a required field
	Configurations map[string]*LakeConfigurationResponse `locationName:"configurations" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatalakeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatalakeOutput) GoString() string {
	return s.String()
}

// SetConfigurations sets the Configurations field's value.
func (s *GetDatalakeOutput) SetConfigurations(v map[string]*LakeConfigurationResponse) *GetDatalakeOutput {
	s.Configurations = v
	return s
}

type GetDatalakeStatusInput struct {
	_ struct{} `type:"structure"`

	// The account IDs for which a static snapshot of the current Region, including
	// enabled accounts and log sources is retrieved.
	AccountSet []*string `locationName:"accountSet" type:"list"`

	// The maximum limit of accounts for which the static snapshot of the current
	// Region including enabled accounts and log sources is retrieved.
	MaxAccountResults *int64 `locationName:"maxAccountResults" type:"integer"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatalakeStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatalakeStatusInput) GoString() string {
	return s.String()
}

// SetAccountSet sets the AccountSet field's value.
func (s *GetDatalakeStatusInput) SetAccountSet(v []*string) *GetDatalakeStatusInput {
	s.AccountSet = v
	return s
}

// SetMaxAccountResults sets the MaxAccountResults field's value.
func (s *GetDatalakeStatusInput) SetMaxAccountResults(v int64) *GetDatalakeStatusInput {
	s.MaxAccountResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDatalakeStatusInput) SetNextToken(v string) *GetDatalakeStatusInput {
	s.NextToken = &v
	return s
}

type GetDatalakeStatusOutput struct {
	_ struct{} `type:"structure"`

	// The list of enabled accounts and enabled sources.
	//
	// AccountSourcesList is a required field
	AccountSourcesList []*AccountSources `locationName:"accountSourcesList" type:"list" required:"true"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatalakeStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatalakeStatusOutput) GoString() string {
	return s.String()
}

// SetAccountSourcesList sets the AccountSourcesList field's value.
func (s *GetDatalakeStatusOutput) SetAccountSourcesList(v []*AccountSources) *GetDatalakeStatusOutput {
	s.AccountSourcesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDatalakeStatusOutput) SetNextToken(v string) *GetDatalakeStatusOutput {
	s.NextToken = &v
	return s
}

type GetSubscriberInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A value created by Security Lake that uniquely identifies your GetSubscriber
	// API request.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSubscriberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSubscriberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSubscriberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSubscriberInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetSubscriberInput) SetId(v string) *GetSubscriberInput {
	s.Id = &v
	return s
}

type GetSubscriberOutput struct {
	_ struct{} `type:"structure"`

	// Subscription information for the specified subscription ID
	Subscriber *SubscriberResource `locationName:"subscriber" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSubscriberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSubscriberOutput) GoString() string {
	return s.String()
}

// SetSubscriber sets the Subscriber field's value.
func (s *GetSubscriberOutput) SetSubscriber(v *SubscriberResource) *GetSubscriberOutput {
	s.Subscriber = v
	return s
}

// Internal service exceptions are sometimes caused by transient issues. Before
// you start troubleshooting, perform the operation again.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// Retry the request after the specified time.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because an invalid or out-of-range value was supplied
// for an input parameter.
type InvalidInputException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidInputException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidInputException) GoString() string {
	return s.String()
}

func newErrorInvalidInputException(v protocol.ResponseMetadata) error {
	return &InvalidInputException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidInputException) Code() string {
	return "InvalidInputException"
}

// Message returns the exception's message.
func (s *InvalidInputException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidInputException) OrigErr() error {
	return nil
}

func (s *InvalidInputException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidInputException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidInputException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides details of lake configuration object in Amazon Security Lake.
type LakeConfigurationRequest struct {
	_ struct{} `type:"structure"`

	// The type of encryption key used by Security Lake to encrypt the lake configuration
	// object.
	EncryptionKey *string `locationName:"encryptionKey" type:"string"`

	// Replication enables automatic, asynchronous copying of objects across Amazon
	// S3 buckets. Amazon S3 buckets that are configured for object replication
	// can be owned by the same Amazon Web Services account or by different accounts.
	// You can replicate objects to a single destination bucket or to multiple destination
	// buckets. The destination buckets can be in different Amazon Web Services
	// Regions or within the same Region as the source bucket.
	//
	// Set up one or more rollup Regions by providing the Region or Regions that
	// should contribute to the central rollup Region.
	ReplicationDestinationRegions []*string `locationName:"replicationDestinationRegions" type:"list" enum:"Region"`

	// Replication settings for the Amazon S3 buckets. This parameter uses the IAM
	// role created by you that is managed by Security Lake, to ensure the replication
	// setting is correct.
	ReplicationRoleArn *string `locationName:"replicationRoleArn" type:"string"`

	// Retention settings for the destination Amazon S3 buckets.
	RetentionSettings []*RetentionSetting `locationName:"retentionSettings" type:"list"`

	// A tag is a label that you assign to an Amazon Web Services resource. Each
	// tag consists of a key and an optional value, both of which you define.
	TagsMap map[string]*string `locationName:"tagsMap" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LakeConfigurationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LakeConfigurationRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LakeConfigurationRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LakeConfigurationRequest"}
	if s.RetentionSettings != nil {
		for i, v := range s.RetentionSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RetentionSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *LakeConfigurationRequest) SetEncryptionKey(v string) *LakeConfigurationRequest {
	s.EncryptionKey = &v
	return s
}

// SetReplicationDestinationRegions sets the ReplicationDestinationRegions field's value.
func (s *LakeConfigurationRequest) SetReplicationDestinationRegions(v []*string) *LakeConfigurationRequest {
	s.ReplicationDestinationRegions = v
	return s
}

// SetReplicationRoleArn sets the ReplicationRoleArn field's value.
func (s *LakeConfigurationRequest) SetReplicationRoleArn(v string) *LakeConfigurationRequest {
	s.ReplicationRoleArn = &v
	return s
}

// SetRetentionSettings sets the RetentionSettings field's value.
func (s *LakeConfigurationRequest) SetRetentionSettings(v []*RetentionSetting) *LakeConfigurationRequest {
	s.RetentionSettings = v
	return s
}

// SetTagsMap sets the TagsMap field's value.
func (s *LakeConfigurationRequest) SetTagsMap(v map[string]*string) *LakeConfigurationRequest {
	s.TagsMap = v
	return s
}

// Provides details of lake configuration object in Amazon Security Lake.
type LakeConfigurationResponse struct {
	_ struct{} `type:"structure"`

	// The type of encryption key used by Security Lake to encrypt the lake configuration
	EncryptionKey *string `locationName:"encryptionKey" type:"string"`

	// Replication enables automatic, asynchronous copying of objects across Amazon
	// S3 buckets. Amazon S3 buckets that are configured for object replication
	// can be owned by the same AWS account or by different accounts. You can replicate
	// objects to a single destination bucket or to multiple destination buckets.
	// The destination buckets can be in different Amazon Web Services Regions or
	// within the same Region as the source bucket.
	//
	// Set up one or more rollup Regions by providing the Region or Regions that
	// should contribute to the central rollup Region.
	ReplicationDestinationRegions []*string `locationName:"replicationDestinationRegions" type:"list" enum:"Region"`

	// Replication settings for the Amazon S3 buckets. This parameter uses the IAM
	// role created by you that is managed by Security Lake, to ensure the replication
	// setting is correct.
	ReplicationRoleArn *string `locationName:"replicationRoleArn" type:"string"`

	// Retention settings for the destination Amazon S3 buckets.
	RetentionSettings []*RetentionSetting `locationName:"retentionSettings" type:"list"`

	// Amazon Resource Names (ARNs) uniquely identify Amazon Web Services resources.
	// Security Lake requires an ARN when you need to specify a resource unambiguously
	// across all of Amazon Web Services, such as in IAM policies, Amazon Relational
	// Database Service (Amazon RDS) tags, and API calls.
	S3BucketArn *string `locationName:"s3BucketArn" type:"string"`

	// Retrieves the status of the configuration operation for an account in Amazon
	// Security Lake.
	Status *string `locationName:"status" type:"string" enum:"SettingsStatus"`

	// A tag is a label that you assign to an Amazon Web Services resource. Each
	// tag consists of a key and an optional value, both of which you define.
	TagsMap map[string]*string `locationName:"tagsMap" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LakeConfigurationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LakeConfigurationResponse) GoString() string {
	return s.String()
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *LakeConfigurationResponse) SetEncryptionKey(v string) *LakeConfigurationResponse {
	s.EncryptionKey = &v
	return s
}

// SetReplicationDestinationRegions sets the ReplicationDestinationRegions field's value.
func (s *LakeConfigurationResponse) SetReplicationDestinationRegions(v []*string) *LakeConfigurationResponse {
	s.ReplicationDestinationRegions = v
	return s
}

// SetReplicationRoleArn sets the ReplicationRoleArn field's value.
func (s *LakeConfigurationResponse) SetReplicationRoleArn(v string) *LakeConfigurationResponse {
	s.ReplicationRoleArn = &v
	return s
}

// SetRetentionSettings sets the RetentionSettings field's value.
func (s *LakeConfigurationResponse) SetRetentionSettings(v []*RetentionSetting) *LakeConfigurationResponse {
	s.RetentionSettings = v
	return s
}

// SetS3BucketArn sets the S3BucketArn field's value.
func (s *LakeConfigurationResponse) SetS3BucketArn(v string) *LakeConfigurationResponse {
	s.S3BucketArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *LakeConfigurationResponse) SetStatus(v string) *LakeConfigurationResponse {
	s.Status = &v
	return s
}

// SetTagsMap sets the TagsMap field's value.
func (s *LakeConfigurationResponse) SetTagsMap(v map[string]*string) *LakeConfigurationResponse {
	s.TagsMap = v
	return s
}

type ListDatalakeExceptionsInput struct {
	_ struct{} `type:"structure"`

	// List the maximum number of failures in Security Lake.
	MaxFailures *int64 `locationName:"maxFailures" type:"integer"`

	// List if there are more results available. if nextToken is returned, You can
	// make the call again using the returned token to retrieve the next page
	NextToken *string `locationName:"nextToken" type:"string"`

	// List the regions from which exceptions are retrieved.
	RegionSet []*string `locationName:"regionSet" type:"list" enum:"Region"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatalakeExceptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatalakeExceptionsInput) GoString() string {
	return s.String()
}

// SetMaxFailures sets the MaxFailures field's value.
func (s *ListDatalakeExceptionsInput) SetMaxFailures(v int64) *ListDatalakeExceptionsInput {
	s.MaxFailures = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatalakeExceptionsInput) SetNextToken(v string) *ListDatalakeExceptionsInput {
	s.NextToken = &v
	return s
}

// SetRegionSet sets the RegionSet field's value.
func (s *ListDatalakeExceptionsInput) SetRegionSet(v []*string) *ListDatalakeExceptionsInput {
	s.RegionSet = v
	return s
}

type ListDatalakeExceptionsOutput struct {
	_ struct{} `type:"structure"`

	// List if there are more results available. if nextToken is returned, You can
	// make the call again using the returned token to retrieve the next page
	NextToken *string `locationName:"nextToken" type:"string"`

	// Lists the non-retryable failures in the current region.
	//
	// NonRetryableFailures is a required field
	NonRetryableFailures []*FailuresResponse `locationName:"nonRetryableFailures" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatalakeExceptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatalakeExceptionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatalakeExceptionsOutput) SetNextToken(v string) *ListDatalakeExceptionsOutput {
	s.NextToken = &v
	return s
}

// SetNonRetryableFailures sets the NonRetryableFailures field's value.
func (s *ListDatalakeExceptionsOutput) SetNonRetryableFailures(v []*FailuresResponse) *ListDatalakeExceptionsOutput {
	s.NonRetryableFailures = v
	return s
}

type ListLogSourcesInput struct {
	_ struct{} `type:"structure"`

	// Lists the log sources in input order, namely Region, source type, and member
	// account.
	InputOrder []*string `locationName:"inputOrder" type:"list" enum:"Dimension"`

	// List the view of log sources for enabled Security Lake accounts in all Regions
	// and source types.
	ListAllDimensions map[string]map[string][]*string `locationName:"listAllDimensions" type:"map"`

	// List the view of log sources for enabled Security Lake accounts for the entire
	// region.
	ListSingleDimension []*string `locationName:"listSingleDimension" type:"list"`

	// Lists the log sources for the specified source types in enabled Security
	// Lake accounts for the entire Region, for selected member accounts.
	ListTwoDimensions map[string][]*string `locationName:"listTwoDimensions" type:"map"`

	// The maximum number of accounts for which the configuration is displayed.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// If nextToken is returned, there are more results available. You can make
	// the call again using the returned token to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLogSourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLogSourcesInput) GoString() string {
	return s.String()
}

// SetInputOrder sets the InputOrder field's value.
func (s *ListLogSourcesInput) SetInputOrder(v []*string) *ListLogSourcesInput {
	s.InputOrder = v
	return s
}

// SetListAllDimensions sets the ListAllDimensions field's value.
func (s *ListLogSourcesInput) SetListAllDimensions(v map[string]map[string][]*string) *ListLogSourcesInput {
	s.ListAllDimensions = v
	return s
}

// SetListSingleDimension sets the ListSingleDimension field's value.
func (s *ListLogSourcesInput) SetListSingleDimension(v []*string) *ListLogSourcesInput {
	s.ListSingleDimension = v
	return s
}

// SetListTwoDimensions sets the ListTwoDimensions field's value.
func (s *ListLogSourcesInput) SetListTwoDimensions(v map[string][]*string) *ListLogSourcesInput {
	s.ListTwoDimensions = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLogSourcesInput) SetMaxResults(v int64) *ListLogSourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLogSourcesInput) SetNextToken(v string) *ListLogSourcesInput {
	s.NextToken = &v
	return s
}

type ListLogSourcesOutput struct {
	_ struct{} `type:"structure"`

	// If nextToken is returned, there are more results available. You can make
	// the call again using the returned token to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Lists the log sources in the Regions for enabled Security Lake accounts.
	//
	// RegionSourceTypesAccountsList is a required field
	RegionSourceTypesAccountsList []map[string]map[string][]*string `locationName:"regionSourceTypesAccountsList" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLogSourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLogSourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListLogSourcesOutput) SetNextToken(v string) *ListLogSourcesOutput {
	s.NextToken = &v
	return s
}

// SetRegionSourceTypesAccountsList sets the RegionSourceTypesAccountsList field's value.
func (s *ListLogSourcesOutput) SetRegionSourceTypesAccountsList(v []map[string]map[string][]*string) *ListLogSourcesOutput {
	s.RegionSourceTypesAccountsList = v
	return s
}

type ListSubscribersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of accounts for which the configuration is displayed.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// If nextToken is returned, there are more results available. You can make
	// the call again using the returned token to retrieve the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSubscribersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSubscribersInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSubscribersInput) SetMaxResults(v int64) *ListSubscribersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSubscribersInput) SetNextToken(v string) *ListSubscribersInput {
	s.NextToken = &v
	return s
}

type ListSubscribersOutput struct {
	_ struct{} `type:"structure"`

	// If nextToken is returned, there are more results available. You can make
	// the call again using the returned token to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The subscribers available in the specified Security Lake account ID.
	//
	// Subscribers is a required field
	Subscribers []*SubscriberResource `locationName:"subscribers" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSubscribersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSubscribersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSubscribersOutput) SetNextToken(v string) *ListSubscribersOutput {
	s.NextToken = &v
	return s
}

// SetSubscribers sets the Subscribers field's value.
func (s *ListSubscribersOutput) SetSubscribers(v []*SubscriberResource) *ListSubscribersOutput {
	s.Subscribers = v
	return s
}

// Log status for the Security Lake account.
type LogsStatus struct {
	_ struct{} `type:"structure"`

	// Health status of services including error codes and patterns.
	//
	// HealthStatus is a required field
	HealthStatus *string `locationName:"healthStatus" type:"string" required:"true" enum:"SourceStatus"`

	// Defines path the stored logs are available which has information on your
	// systems, applications, and services.
	//
	// PathToLogs is a required field
	PathToLogs *string `locationName:"pathToLogs" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogsStatus) GoString() string {
	return s.String()
}

// SetHealthStatus sets the HealthStatus field's value.
func (s *LogsStatus) SetHealthStatus(v string) *LogsStatus {
	s.HealthStatus = &v
	return s
}

// SetPathToLogs sets the PathToLogs field's value.
func (s *LogsStatus) SetPathToLogs(v string) *LogsStatus {
	s.PathToLogs = &v
	return s
}

// Notifications in Security Lake which dictates how notifications are posted
// at the endpoint.
type ProtocolAndNotificationEndpoint struct {
	_ struct{} `type:"structure"`

	// The account which is subscribed to receive exception notifications.
	Endpoint *string `locationName:"endpoint" type:"string"`

	// The protocol to which notification messages are posted.
	Protocol *string `locationName:"protocol" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtocolAndNotificationEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtocolAndNotificationEndpoint) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *ProtocolAndNotificationEndpoint) SetEndpoint(v string) *ProtocolAndNotificationEndpoint {
	s.Endpoint = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *ProtocolAndNotificationEndpoint) SetProtocol(v string) *ProtocolAndNotificationEndpoint {
	s.Protocol = &v
	return s
}

// The resource could not be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource for which the type of resource could not be found.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of the resource that could not be found.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Retention settings for the destination Amazon S3 buckets in Security Lake.
type RetentionSetting struct {
	_ struct{} `type:"structure"`

	// The retention period specifies a fixed period of time during which the Security
	// Lake object remains locked. You can specify the retention period for one
	// or more source in days.
	RetentionPeriod *int64 `locationName:"retentionPeriod" min:"1" type:"integer"`

	// The range of storage classes that you can choose from based on the data access,
	// resiliency, and cost requirements of your workloads.
	StorageClass *string `locationName:"storageClass" type:"string" enum:"StorageClass"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetentionSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetentionSetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetentionSetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetentionSetting"}
	if s.RetentionPeriod != nil && *s.RetentionPeriod < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RetentionPeriod", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *RetentionSetting) SetRetentionPeriod(v int64) *RetentionSetting {
	s.RetentionPeriod = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *RetentionSetting) SetStorageClass(v string) *RetentionSetting {
	s.StorageClass = &v
	return s
}

// Provides an extension of the AmazonServiceException for errors reported by
// Amazon S3 while processing a request. In particular, this class provides
// access to Amazon S3's extended request ID. This ID is required debugging
// information in the case the user needs to contact Amazon about an issue where
// Amazon S3 is incorrectly handling a request.
type S3Exception struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Exception) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Exception) GoString() string {
	return s.String()
}

func newErrorS3Exception(v protocol.ResponseMetadata) error {
	return &S3Exception{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *S3Exception) Code() string {
	return "S3Exception"
}

// Message returns the exception's message.
func (s *S3Exception) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *S3Exception) OrigErr() error {
	return nil
}

func (s *S3Exception) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *S3Exception) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *S3Exception) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have exceeded your service quota. To perform the requested action, remove
// some of the relevant resources, or use Service Quotas to request a service
// quota increase.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// That the rate of requests to Security Lake is exceeding the request quotas
	// for your Amazon Web Services account.
	//
	// QuotaCode is a required field
	QuotaCode *string `locationName:"quotaCode" type:"string" required:"true"`

	// The ID of the resource that exceeds the service quota.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of the resource that exceeds the service quota.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`

	// The code for the service in Service Quotas.
	//
	// ServiceCode is a required field
	ServiceCode *string `locationName:"serviceCode" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The supported source types from which logs and events are collected in Amazon
// Security Lake.
type SourceType struct {
	_ struct{} `type:"structure"`

	// Amazon Security Lake supports logs and events collection for natively-supported
	// Amazon Web Services services. For more information, see the Amazon Security
	// Lake User Guide.
	AwsSourceType *string `locationName:"awsSourceType" type:"string" enum:"AwsLogSourceType"`

	// Amazon Security Lake supports custom source types. For the detailed list,
	// see the Amazon Security Lake User Guide.
	CustomSourceType *string `locationName:"customSourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceType) GoString() string {
	return s.String()
}

// SetAwsSourceType sets the AwsSourceType field's value.
func (s *SourceType) SetAwsSourceType(v string) *SourceType {
	s.AwsSourceType = &v
	return s
}

// SetCustomSourceType sets the CustomSourceType field's value.
func (s *SourceType) SetCustomSourceType(v string) *SourceType {
	s.CustomSourceType = &v
	return s
}

// Provides details of the Amazon Security Lake account subscription. Subscribers
// are notified of new objects for a source as the data is written to your Amazon
// Security Lake S3 bucket.
type SubscriberResource struct {
	_ struct{} `type:"structure"`

	// You can choose to notify subscribers of new objects with an Amazon Simple
	// Queue Service (Amazon SQS) queue or through messaging to an HTTPS endpoint
	// provided by the subscriber.
	//
	// Subscribers can consume data by directly querying Lake Formation tables in
	// your S3 bucket via services like Amazon Athena. This subscription type is
	// defined as LAKEFORMATION.
	AccessTypes []*string `locationName:"accessTypes" type:"list" enum:"AccessType"`

	// The Amazon Web Services account ID of the account that you are using to create
	// your Amazon Security Lake account.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`

	// The date and time when the subscription was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The external ID of the subscriber. External ID allows the user that is assuming
	// the role to assert the circumstances in which they are operating. It also
	// provides a way for the account owner to permit the role to be assumed only
	// under specific circumstances.
	ExternalId *string `locationName:"externalId" type:"string"`

	// The Amazon Resource Name (ARN) specifying the role of the subscriber.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The Amazon Resource Name (ARN) for the Amazon S3 bucket.
	S3BucketArn *string `locationName:"s3BucketArn" type:"string"`

	// The Amazon Resource Name (ARN) for the Amazon Simple Notification Service.
	SnsArn *string `locationName:"snsArn" type:"string"`

	// Amazon Security Lake supports logs and events collection for the natively-supported
	// Amazon Web Services services. For more information, see the Amazon Security
	// Lake User Guide.
	//
	// SourceTypes is a required field
	SourceTypes []*SourceType `locationName:"sourceTypes" type:"list" required:"true"`

	// The subscriber descriptions for a subscriber account. The description for
	// a subscriber includes subscriberName, accountID, externalID, and subscriptionId.
	SubscriberDescription *string `locationName:"subscriberDescription" type:"string"`

	// The name of your Amazon Security Lake subscriber account.
	SubscriberName *string `locationName:"subscriberName" type:"string"`

	// The subscription endpoint to which exception messages are posted.
	SubscriptionEndpoint *string `locationName:"subscriptionEndpoint" type:"string"`

	// The subscription ID of the Amazon Security Lake subscriber account.
	//
	// SubscriptionId is a required field
	SubscriptionId *string `locationName:"subscriptionId" type:"string" required:"true"`

	// The subscription protocol to which exception messages are posted.
	SubscriptionProtocol *string `locationName:"subscriptionProtocol" type:"string" enum:"EndpointProtocol"`

	// Subscription status of the Amazon Security Lake subscriber account.
	SubscriptionStatus *string `locationName:"subscriptionStatus" type:"string" enum:"SubscriptionStatus"`

	// The date and time when the subscription was created.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubscriberResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubscriberResource) GoString() string {
	return s.String()
}

// SetAccessTypes sets the AccessTypes field's value.
func (s *SubscriberResource) SetAccessTypes(v []*string) *SubscriberResource {
	s.AccessTypes = v
	return s
}

// SetAccountId sets the AccountId field's value.
func (s *SubscriberResource) SetAccountId(v string) *SubscriberResource {
	s.AccountId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *SubscriberResource) SetCreatedAt(v time.Time) *SubscriberResource {
	s.CreatedAt = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *SubscriberResource) SetExternalId(v string) *SubscriberResource {
	s.ExternalId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *SubscriberResource) SetRoleArn(v string) *SubscriberResource {
	s.RoleArn = &v
	return s
}

// SetS3BucketArn sets the S3BucketArn field's value.
func (s *SubscriberResource) SetS3BucketArn(v string) *SubscriberResource {
	s.S3BucketArn = &v
	return s
}

// SetSnsArn sets the SnsArn field's value.
func (s *SubscriberResource) SetSnsArn(v string) *SubscriberResource {
	s.SnsArn = &v
	return s
}

// SetSourceTypes sets the SourceTypes field's value.
func (s *SubscriberResource) SetSourceTypes(v []*SourceType) *SubscriberResource {
	s.SourceTypes = v
	return s
}

// SetSubscriberDescription sets the SubscriberDescription field's value.
func (s *SubscriberResource) SetSubscriberDescription(v string) *SubscriberResource {
	s.SubscriberDescription = &v
	return s
}

// SetSubscriberName sets the SubscriberName field's value.
func (s *SubscriberResource) SetSubscriberName(v string) *SubscriberResource {
	s.SubscriberName = &v
	return s
}

// SetSubscriptionEndpoint sets the SubscriptionEndpoint field's value.
func (s *SubscriberResource) SetSubscriptionEndpoint(v string) *SubscriberResource {
	s.SubscriptionEndpoint = &v
	return s
}

// SetSubscriptionId sets the SubscriptionId field's value.
func (s *SubscriberResource) SetSubscriptionId(v string) *SubscriberResource {
	s.SubscriptionId = &v
	return s
}

// SetSubscriptionProtocol sets the SubscriptionProtocol field's value.
func (s *SubscriberResource) SetSubscriptionProtocol(v string) *SubscriberResource {
	s.SubscriptionProtocol = &v
	return s
}

// SetSubscriptionStatus sets the SubscriptionStatus field's value.
func (s *SubscriberResource) SetSubscriptionStatus(v string) *SubscriberResource {
	s.SubscriptionStatus = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *SubscriberResource) SetUpdatedAt(v time.Time) *SubscriberResource {
	s.UpdatedAt = &v
	return s
}

// The limit on the number of requests per second was exceeded.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// That the rate of requests to Security Lake is exceeding the request quotas
	// for your Amazon Web Services account.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// Retry the request after the specified time.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`

	// The code for the service in Service Quotas.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateDatalakeExceptionsExpiryInput struct {
	_ struct{} `type:"structure"`

	// The time-to-live (TTL) for the exception message to remain.
	//
	// ExceptionMessageExpiry is a required field
	ExceptionMessageExpiry *int64 `locationName:"exceptionMessageExpiry" min:"1" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatalakeExceptionsExpiryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatalakeExceptionsExpiryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDatalakeExceptionsExpiryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDatalakeExceptionsExpiryInput"}
	if s.ExceptionMessageExpiry == nil {
		invalidParams.Add(request.NewErrParamRequired("ExceptionMessageExpiry"))
	}
	if s.ExceptionMessageExpiry != nil && *s.ExceptionMessageExpiry < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ExceptionMessageExpiry", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExceptionMessageExpiry sets the ExceptionMessageExpiry field's value.
func (s *UpdateDatalakeExceptionsExpiryInput) SetExceptionMessageExpiry(v int64) *UpdateDatalakeExceptionsExpiryInput {
	s.ExceptionMessageExpiry = &v
	return s
}

type UpdateDatalakeExceptionsExpiryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatalakeExceptionsExpiryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatalakeExceptionsExpiryOutput) GoString() string {
	return s.String()
}

type UpdateDatalakeExceptionsSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The account which is subscribed to receive exception notifications.
	//
	// NotificationEndpoint is a required field
	NotificationEndpoint *string `locationName:"notificationEndpoint" type:"string" required:"true"`

	// The subscription protocol to which exception messages are posted.
	//
	// SubscriptionProtocol is a required field
	SubscriptionProtocol *string `locationName:"subscriptionProtocol" type:"string" required:"true" enum:"SubscriptionProtocolType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatalakeExceptionsSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatalakeExceptionsSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDatalakeExceptionsSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDatalakeExceptionsSubscriptionInput"}
	if s.NotificationEndpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("NotificationEndpoint"))
	}
	if s.SubscriptionProtocol == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionProtocol"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotificationEndpoint sets the NotificationEndpoint field's value.
func (s *UpdateDatalakeExceptionsSubscriptionInput) SetNotificationEndpoint(v string) *UpdateDatalakeExceptionsSubscriptionInput {
	s.NotificationEndpoint = &v
	return s
}

// SetSubscriptionProtocol sets the SubscriptionProtocol field's value.
func (s *UpdateDatalakeExceptionsSubscriptionInput) SetSubscriptionProtocol(v string) *UpdateDatalakeExceptionsSubscriptionInput {
	s.SubscriptionProtocol = &v
	return s
}

type UpdateDatalakeExceptionsSubscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatalakeExceptionsSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatalakeExceptionsSubscriptionOutput) GoString() string {
	return s.String()
}

type UpdateDatalakeInput struct {
	_ struct{} `type:"structure"`

	// The configuration object
	//
	// Configurations is a required field
	Configurations map[string]*LakeConfigurationRequest `locationName:"configurations" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatalakeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatalakeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDatalakeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDatalakeInput"}
	if s.Configurations == nil {
		invalidParams.Add(request.NewErrParamRequired("Configurations"))
	}
	if s.Configurations != nil {
		for i, v := range s.Configurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Configurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurations sets the Configurations field's value.
func (s *UpdateDatalakeInput) SetConfigurations(v map[string]*LakeConfigurationRequest) *UpdateDatalakeInput {
	s.Configurations = v
	return s
}

type UpdateDatalakeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatalakeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatalakeOutput) GoString() string {
	return s.String()
}

type UpdateSubscriberInput struct {
	_ struct{} `type:"structure"`

	// External ID of the Security Lake account.
	ExternalId *string `locationName:"externalId" type:"string"`

	// A value created by Security Lake that uniquely identifies your UpdateSubscriber
	// API request.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// The supported Amazon Web Services services from which logs and events are
	// collected. Amazon Security Lake supports logs and events collection for the
	// following natively-supported Amazon Web Services services. For more information,
	// see the Amazon Security Lake User Guide.
	SourceTypes []*SourceType `locationName:"sourceTypes" type:"list"`

	// Description of the Security Lake account subscriber.
	SubscriberDescription *string `locationName:"subscriberDescription" type:"string"`

	// Name of the Security Lake account subscriber.
	SubscriberName *string `locationName:"subscriberName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSubscriberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSubscriberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSubscriberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSubscriberInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExternalId sets the ExternalId field's value.
func (s *UpdateSubscriberInput) SetExternalId(v string) *UpdateSubscriberInput {
	s.ExternalId = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateSubscriberInput) SetId(v string) *UpdateSubscriberInput {
	s.Id = &v
	return s
}

// SetSourceTypes sets the SourceTypes field's value.
func (s *UpdateSubscriberInput) SetSourceTypes(v []*SourceType) *UpdateSubscriberInput {
	s.SourceTypes = v
	return s
}

// SetSubscriberDescription sets the SubscriberDescription field's value.
func (s *UpdateSubscriberInput) SetSubscriberDescription(v string) *UpdateSubscriberInput {
	s.SubscriberDescription = &v
	return s
}

// SetSubscriberName sets the SubscriberName field's value.
func (s *UpdateSubscriberInput) SetSubscriberName(v string) *UpdateSubscriberInput {
	s.SubscriberName = &v
	return s
}

type UpdateSubscriberOutput struct {
	_ struct{} `type:"structure"`

	// The account subscriber in Amazon Security Lake.
	Subscriber *SubscriberResource `locationName:"subscriber" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSubscriberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSubscriberOutput) GoString() string {
	return s.String()
}

// SetSubscriber sets the Subscriber field's value.
func (s *UpdateSubscriberOutput) SetSubscriber(v *SubscriberResource) *UpdateSubscriberOutput {
	s.Subscriber = v
	return s
}

type UpdateSubscriptionNotificationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Create a new subscription notification for the specified subscription ID
	// in Security Lake.
	CreateSqs *bool `locationName:"createSqs" type:"boolean"`

	// The key name for the subscription notification.
	HttpsApiKeyName *string `locationName:"httpsApiKeyName" type:"string"`

	// The key value for the subscription notification.
	HttpsApiKeyValue *string `locationName:"httpsApiKeyValue" type:"string"`

	// The HTTPS method used for the subscription notification.
	HttpsMethod *string `locationName:"httpsMethod" type:"string" enum:"HttpsMethod"`

	// The Amazon Resource Name (ARN) specifying the role of the subscriber.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The subscription endpoint in Security Lake.
	SubscriptionEndpoint *string `locationName:"subscriptionEndpoint" type:"string"`

	// The subscription ID for which the subscription notification is specified.
	//
	// SubscriptionId is a required field
	SubscriptionId *string `location:"uri" locationName:"subscriptionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSubscriptionNotificationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSubscriptionNotificationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSubscriptionNotificationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSubscriptionNotificationConfigurationInput"}
	if s.SubscriptionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionId"))
	}
	if s.SubscriptionId != nil && len(*s.SubscriptionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubscriptionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreateSqs sets the CreateSqs field's value.
func (s *UpdateSubscriptionNotificationConfigurationInput) SetCreateSqs(v bool) *UpdateSubscriptionNotificationConfigurationInput {
	s.CreateSqs = &v
	return s
}

// SetHttpsApiKeyName sets the HttpsApiKeyName field's value.
func (s *UpdateSubscriptionNotificationConfigurationInput) SetHttpsApiKeyName(v string) *UpdateSubscriptionNotificationConfigurationInput {
	s.HttpsApiKeyName = &v
	return s
}

// SetHttpsApiKeyValue sets the HttpsApiKeyValue field's value.
func (s *UpdateSubscriptionNotificationConfigurationInput) SetHttpsApiKeyValue(v string) *UpdateSubscriptionNotificationConfigurationInput {
	s.HttpsApiKeyValue = &v
	return s
}

// SetHttpsMethod sets the HttpsMethod field's value.
func (s *UpdateSubscriptionNotificationConfigurationInput) SetHttpsMethod(v string) *UpdateSubscriptionNotificationConfigurationInput {
	s.HttpsMethod = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateSubscriptionNotificationConfigurationInput) SetRoleArn(v string) *UpdateSubscriptionNotificationConfigurationInput {
	s.RoleArn = &v
	return s
}

// SetSubscriptionEndpoint sets the SubscriptionEndpoint field's value.
func (s *UpdateSubscriptionNotificationConfigurationInput) SetSubscriptionEndpoint(v string) *UpdateSubscriptionNotificationConfigurationInput {
	s.SubscriptionEndpoint = &v
	return s
}

// SetSubscriptionId sets the SubscriptionId field's value.
func (s *UpdateSubscriptionNotificationConfigurationInput) SetSubscriptionId(v string) *UpdateSubscriptionNotificationConfigurationInput {
	s.SubscriptionId = &v
	return s
}

type UpdateSubscriptionNotificationConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Returns the Amazon resource name (ARN) of the queue.
	QueueArn *string `locationName:"queueArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSubscriptionNotificationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSubscriptionNotificationConfigurationOutput) GoString() string {
	return s.String()
}

// SetQueueArn sets the QueueArn field's value.
func (s *UpdateSubscriptionNotificationConfigurationOutput) SetQueueArn(v string) *UpdateSubscriptionNotificationConfigurationOutput {
	s.QueueArn = &v
	return s
}

// Your signing certificate could not be validated.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The list of parameters that failed to validate.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	Message_ *string `locationName:"message" type:"string"`

	// The reason for the validation exception.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input fails to meet the constraints specified in Amazon Security Lake
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// Describes the error encountered.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// Name of the validation exception.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// AccessTypeLakeformation is a AccessType enum value
	AccessTypeLakeformation = "LAKEFORMATION"

	// AccessTypeS3 is a AccessType enum value
	AccessTypeS3 = "S3"
)

// AccessType_Values returns all elements of the AccessType enum
func AccessType_Values() []string {
	return []string{
		AccessTypeLakeformation,
		AccessTypeS3,
	}
}

const (
	// AwsLogSourceTypeRoute53 is a AwsLogSourceType enum value
	AwsLogSourceTypeRoute53 = "ROUTE53"

	// AwsLogSourceTypeVpcFlow is a AwsLogSourceType enum value
	AwsLogSourceTypeVpcFlow = "VPC_FLOW"

	// AwsLogSourceTypeCloudTrail is a AwsLogSourceType enum value
	AwsLogSourceTypeCloudTrail = "CLOUD_TRAIL"

	// AwsLogSourceTypeShFindings is a AwsLogSourceType enum value
	AwsLogSourceTypeShFindings = "SH_FINDINGS"
)

// AwsLogSourceType_Values returns all elements of the AwsLogSourceType enum
func AwsLogSourceType_Values() []string {
	return []string{
		AwsLogSourceTypeRoute53,
		AwsLogSourceTypeVpcFlow,
		AwsLogSourceTypeCloudTrail,
		AwsLogSourceTypeShFindings,
	}
}

const (
	// DimensionRegion is a Dimension enum value
	DimensionRegion = "REGION"

	// DimensionSourceType is a Dimension enum value
	DimensionSourceType = "SOURCE_TYPE"

	// DimensionMember is a Dimension enum value
	DimensionMember = "MEMBER"
)

// Dimension_Values returns all elements of the Dimension enum
func Dimension_Values() []string {
	return []string{
		DimensionRegion,
		DimensionSourceType,
		DimensionMember,
	}
}

const (
	// EndpointProtocolHttps is a EndpointProtocol enum value
	EndpointProtocolHttps = "HTTPS"

	// EndpointProtocolSqs is a EndpointProtocol enum value
	EndpointProtocolSqs = "SQS"
)

// EndpointProtocol_Values returns all elements of the EndpointProtocol enum
func EndpointProtocol_Values() []string {
	return []string{
		EndpointProtocolHttps,
		EndpointProtocolSqs,
	}
}

const (
	// HttpsMethodPost is a HttpsMethod enum value
	HttpsMethodPost = "POST"

	// HttpsMethodPut is a HttpsMethod enum value
	HttpsMethodPut = "PUT"
)

// HttpsMethod_Values returns all elements of the HttpsMethod enum
func HttpsMethod_Values() []string {
	return []string{
		HttpsMethodPost,
		HttpsMethodPut,
	}
}

const (
	// OcsfEventClassAccessActivity is a OcsfEventClass enum value
	OcsfEventClassAccessActivity = "ACCESS_ACTIVITY"

	// OcsfEventClassFileActivity is a OcsfEventClass enum value
	OcsfEventClassFileActivity = "FILE_ACTIVITY"

	// OcsfEventClassKernelActivity is a OcsfEventClass enum value
	OcsfEventClassKernelActivity = "KERNEL_ACTIVITY"

	// OcsfEventClassKernelExtension is a OcsfEventClass enum value
	OcsfEventClassKernelExtension = "KERNEL_EXTENSION"

	// OcsfEventClassMemoryActivity is a OcsfEventClass enum value
	OcsfEventClassMemoryActivity = "MEMORY_ACTIVITY"

	// OcsfEventClassModuleActivity is a OcsfEventClass enum value
	OcsfEventClassModuleActivity = "MODULE_ACTIVITY"

	// OcsfEventClassProcessActivity is a OcsfEventClass enum value
	OcsfEventClassProcessActivity = "PROCESS_ACTIVITY"

	// OcsfEventClassRegistryKeyActivity is a OcsfEventClass enum value
	OcsfEventClassRegistryKeyActivity = "REGISTRY_KEY_ACTIVITY"

	// OcsfEventClassRegistryValueActivity is a OcsfEventClass enum value
	OcsfEventClassRegistryValueActivity = "REGISTRY_VALUE_ACTIVITY"

	// OcsfEventClassResourceActivity is a OcsfEventClass enum value
	OcsfEventClassResourceActivity = "RESOURCE_ACTIVITY"

	// OcsfEventClassScheduledJobActivity is a OcsfEventClass enum value
	OcsfEventClassScheduledJobActivity = "SCHEDULED_JOB_ACTIVITY"

	// OcsfEventClassSecurityFinding is a OcsfEventClass enum value
	OcsfEventClassSecurityFinding = "SECURITY_FINDING"

	// OcsfEventClassAccountChange is a OcsfEventClass enum value
	OcsfEventClassAccountChange = "ACCOUNT_CHANGE"

	// OcsfEventClassAuthentication is a OcsfEventClass enum value
	OcsfEventClassAuthentication = "AUTHENTICATION"

	// OcsfEventClassAuthorization is a OcsfEventClass enum value
	OcsfEventClassAuthorization = "AUTHORIZATION"

	// OcsfEventClassEntityManagementAudit is a OcsfEventClass enum value
	OcsfEventClassEntityManagementAudit = "ENTITY_MANAGEMENT_AUDIT"

	// OcsfEventClassDhcpActivity is a OcsfEventClass enum value
	OcsfEventClassDhcpActivity = "DHCP_ACTIVITY"

	// OcsfEventClassNetworkActivity is a OcsfEventClass enum value
	OcsfEventClassNetworkActivity = "NETWORK_ACTIVITY"

	// OcsfEventClassDnsActivity is a OcsfEventClass enum value
	OcsfEventClassDnsActivity = "DNS_ACTIVITY"

	// OcsfEventClassFtpActivity is a OcsfEventClass enum value
	OcsfEventClassFtpActivity = "FTP_ACTIVITY"

	// OcsfEventClassHttpActivity is a OcsfEventClass enum value
	OcsfEventClassHttpActivity = "HTTP_ACTIVITY"

	// OcsfEventClassRdpActivity is a OcsfEventClass enum value
	OcsfEventClassRdpActivity = "RDP_ACTIVITY"

	// OcsfEventClassSmbActivity is a OcsfEventClass enum value
	OcsfEventClassSmbActivity = "SMB_ACTIVITY"

	// OcsfEventClassSshActivity is a OcsfEventClass enum value
	OcsfEventClassSshActivity = "SSH_ACTIVITY"

	// OcsfEventClassCloudApi is a OcsfEventClass enum value
	OcsfEventClassCloudApi = "CLOUD_API"

	// OcsfEventClassContainerLifecycle is a OcsfEventClass enum value
	OcsfEventClassContainerLifecycle = "CONTAINER_LIFECYCLE"

	// OcsfEventClassDatabaseLifecycle is a OcsfEventClass enum value
	OcsfEventClassDatabaseLifecycle = "DATABASE_LIFECYCLE"

	// OcsfEventClassConfigState is a OcsfEventClass enum value
	OcsfEventClassConfigState = "CONFIG_STATE"

	// OcsfEventClassCloudStorage is a OcsfEventClass enum value
	OcsfEventClassCloudStorage = "CLOUD_STORAGE"

	// OcsfEventClassInventoryInfo is a OcsfEventClass enum value
	OcsfEventClassInventoryInfo = "INVENTORY_INFO"

	// OcsfEventClassRfbActivity is a OcsfEventClass enum value
	OcsfEventClassRfbActivity = "RFB_ACTIVITY"

	// OcsfEventClassSmtpActivity is a OcsfEventClass enum value
	OcsfEventClassSmtpActivity = "SMTP_ACTIVITY"

	// OcsfEventClassVirtualMachineActivity is a OcsfEventClass enum value
	OcsfEventClassVirtualMachineActivity = "VIRTUAL_MACHINE_ACTIVITY"
)

// OcsfEventClass_Values returns all elements of the OcsfEventClass enum
func OcsfEventClass_Values() []string {
	return []string{
		OcsfEventClassAccessActivity,
		OcsfEventClassFileActivity,
		OcsfEventClassKernelActivity,
		OcsfEventClassKernelExtension,
		OcsfEventClassMemoryActivity,
		OcsfEventClassModuleActivity,
		OcsfEventClassProcessActivity,
		OcsfEventClassRegistryKeyActivity,
		OcsfEventClassRegistryValueActivity,
		OcsfEventClassResourceActivity,
		OcsfEventClassScheduledJobActivity,
		OcsfEventClassSecurityFinding,
		OcsfEventClassAccountChange,
		OcsfEventClassAuthentication,
		OcsfEventClassAuthorization,
		OcsfEventClassEntityManagementAudit,
		OcsfEventClassDhcpActivity,
		OcsfEventClassNetworkActivity,
		OcsfEventClassDnsActivity,
		OcsfEventClassFtpActivity,
		OcsfEventClassHttpActivity,
		OcsfEventClassRdpActivity,
		OcsfEventClassSmbActivity,
		OcsfEventClassSshActivity,
		OcsfEventClassCloudApi,
		OcsfEventClassContainerLifecycle,
		OcsfEventClassDatabaseLifecycle,
		OcsfEventClassConfigState,
		OcsfEventClassCloudStorage,
		OcsfEventClassInventoryInfo,
		OcsfEventClassRfbActivity,
		OcsfEventClassSmtpActivity,
		OcsfEventClassVirtualMachineActivity,
	}
}

const (
	// RegionUsEast1 is a Region enum value
	RegionUsEast1 = "us-east-1"

	// RegionUsWest2 is a Region enum value
	RegionUsWest2 = "us-west-2"

	// RegionEuCentral1 is a Region enum value
	RegionEuCentral1 = "eu-central-1"

	// RegionUsEast2 is a Region enum value
	RegionUsEast2 = "us-east-2"

	// RegionEuWest1 is a Region enum value
	RegionEuWest1 = "eu-west-1"

	// RegionApNortheast1 is a Region enum value
	RegionApNortheast1 = "ap-northeast-1"

	// RegionApSoutheast2 is a Region enum value
	RegionApSoutheast2 = "ap-southeast-2"
)

// Region_Values returns all elements of the Region enum
func Region_Values() []string {
	return []string{
		RegionUsEast1,
		RegionUsWest2,
		RegionEuCentral1,
		RegionUsEast2,
		RegionEuWest1,
		RegionApNortheast1,
		RegionApSoutheast2,
	}
}

const (
	// SettingsStatusInitialized is a SettingsStatus enum value
	SettingsStatusInitialized = "INITIALIZED"

	// SettingsStatusPending is a SettingsStatus enum value
	SettingsStatusPending = "PENDING"

	// SettingsStatusCompleted is a SettingsStatus enum value
	SettingsStatusCompleted = "COMPLETED"

	// SettingsStatusFailed is a SettingsStatus enum value
	SettingsStatusFailed = "FAILED"
)

// SettingsStatus_Values returns all elements of the SettingsStatus enum
func SettingsStatus_Values() []string {
	return []string{
		SettingsStatusInitialized,
		SettingsStatusPending,
		SettingsStatusCompleted,
		SettingsStatusFailed,
	}
}

const (
	// SourceStatusActive is a SourceStatus enum value
	SourceStatusActive = "ACTIVE"

	// SourceStatusDeactivated is a SourceStatus enum value
	SourceStatusDeactivated = "DEACTIVATED"

	// SourceStatusPending is a SourceStatus enum value
	SourceStatusPending = "PENDING"
)

// SourceStatus_Values returns all elements of the SourceStatus enum
func SourceStatus_Values() []string {
	return []string{
		SourceStatusActive,
		SourceStatusDeactivated,
		SourceStatusPending,
	}
}

const (
	// StorageClassStandardIa is a StorageClass enum value
	StorageClassStandardIa = "STANDARD_IA"

	// StorageClassOnezoneIa is a StorageClass enum value
	StorageClassOnezoneIa = "ONEZONE_IA"

	// StorageClassIntelligentTiering is a StorageClass enum value
	StorageClassIntelligentTiering = "INTELLIGENT_TIERING"

	// StorageClassGlacierIr is a StorageClass enum value
	StorageClassGlacierIr = "GLACIER_IR"

	// StorageClassGlacier is a StorageClass enum value
	StorageClassGlacier = "GLACIER"

	// StorageClassDeepArchive is a StorageClass enum value
	StorageClassDeepArchive = "DEEP_ARCHIVE"

	// StorageClassExpire is a StorageClass enum value
	StorageClassExpire = "EXPIRE"
)

// StorageClass_Values returns all elements of the StorageClass enum
func StorageClass_Values() []string {
	return []string{
		StorageClassStandardIa,
		StorageClassOnezoneIa,
		StorageClassIntelligentTiering,
		StorageClassGlacierIr,
		StorageClassGlacier,
		StorageClassDeepArchive,
		StorageClassExpire,
	}
}

const (
	// SubscriptionProtocolTypeHttp is a SubscriptionProtocolType enum value
	SubscriptionProtocolTypeHttp = "HTTP"

	// SubscriptionProtocolTypeHttps is a SubscriptionProtocolType enum value
	SubscriptionProtocolTypeHttps = "HTTPS"

	// SubscriptionProtocolTypeEmail is a SubscriptionProtocolType enum value
	SubscriptionProtocolTypeEmail = "EMAIL"

	// SubscriptionProtocolTypeEmailJson is a SubscriptionProtocolType enum value
	SubscriptionProtocolTypeEmailJson = "EMAIL_JSON"

	// SubscriptionProtocolTypeSms is a SubscriptionProtocolType enum value
	SubscriptionProtocolTypeSms = "SMS"

	// SubscriptionProtocolTypeSqs is a SubscriptionProtocolType enum value
	SubscriptionProtocolTypeSqs = "SQS"

	// SubscriptionProtocolTypeLambda is a SubscriptionProtocolType enum value
	SubscriptionProtocolTypeLambda = "LAMBDA"

	// SubscriptionProtocolTypeApp is a SubscriptionProtocolType enum value
	SubscriptionProtocolTypeApp = "APP"

	// SubscriptionProtocolTypeFirehose is a SubscriptionProtocolType enum value
	SubscriptionProtocolTypeFirehose = "FIREHOSE"
)

// SubscriptionProtocolType_Values returns all elements of the SubscriptionProtocolType enum
func SubscriptionProtocolType_Values() []string {
	return []string{
		SubscriptionProtocolTypeHttp,
		SubscriptionProtocolTypeHttps,
		SubscriptionProtocolTypeEmail,
		SubscriptionProtocolTypeEmailJson,
		SubscriptionProtocolTypeSms,
		SubscriptionProtocolTypeSqs,
		SubscriptionProtocolTypeLambda,
		SubscriptionProtocolTypeApp,
		SubscriptionProtocolTypeFirehose,
	}
}

const (
	// SubscriptionStatusActive is a SubscriptionStatus enum value
	SubscriptionStatusActive = "ACTIVE"

	// SubscriptionStatusDeactivated is a SubscriptionStatus enum value
	SubscriptionStatusDeactivated = "DEACTIVATED"

	// SubscriptionStatusPending is a SubscriptionStatus enum value
	SubscriptionStatusPending = "PENDING"

	// SubscriptionStatusReady is a SubscriptionStatus enum value
	SubscriptionStatusReady = "READY"
)

// SubscriptionStatus_Values returns all elements of the SubscriptionStatus enum
func SubscriptionStatus_Values() []string {
	return []string{
		SubscriptionStatusActive,
		SubscriptionStatusDeactivated,
		SubscriptionStatusPending,
		SubscriptionStatusReady,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "unknownOperation"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "cannotParse"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "fieldValidationFailed"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "other"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
