// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCancelKeyDeletion = "CancelKeyDeletion"

// CancelKeyDeletionRequest generates a "aws/request.Request" representing the
// client's request for the CancelKeyDeletion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelKeyDeletion for more information on using the CancelKeyDeletion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelKeyDeletionRequest method.
//	req, resp := client.CancelKeyDeletionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CancelKeyDeletion
func (c *KMS) CancelKeyDeletionRequest(input *CancelKeyDeletionInput) (req *request.Request, output *CancelKeyDeletionOutput) {
	op := &request.Operation{
		Name:       opCancelKeyDeletion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelKeyDeletionInput{}
	}

	output = &CancelKeyDeletionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelKeyDeletion API operation for AWS Key Management Service.
//
// Cancels the deletion of a KMS key. When this operation succeeds, the key
// state of the KMS key is Disabled. To enable the KMS key, use EnableKey.
//
// For more information about scheduling and canceling deletion of a KMS key,
// see Deleting KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html)
// in the Key Management Service Developer Guide.
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: No. You cannot perform this operation on a KMS key in
// a different Amazon Web Services account.
//
// Required permissions: kms:CancelKeyDeletion (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations: ScheduleKeyDeletion
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation CancelKeyDeletion for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CancelKeyDeletion
func (c *KMS) CancelKeyDeletion(input *CancelKeyDeletionInput) (*CancelKeyDeletionOutput, error) {
	req, out := c.CancelKeyDeletionRequest(input)
	return out, req.Send()
}

// CancelKeyDeletionWithContext is the same as CancelKeyDeletion with the addition of
// the ability to pass a context and additional request options.
//
// See CancelKeyDeletion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) CancelKeyDeletionWithContext(ctx aws.Context, input *CancelKeyDeletionInput, opts ...request.Option) (*CancelKeyDeletionOutput, error) {
	req, out := c.CancelKeyDeletionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opConnectCustomKeyStore = "ConnectCustomKeyStore"

// ConnectCustomKeyStoreRequest generates a "aws/request.Request" representing the
// client's request for the ConnectCustomKeyStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ConnectCustomKeyStore for more information on using the ConnectCustomKeyStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ConnectCustomKeyStoreRequest method.
//	req, resp := client.ConnectCustomKeyStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ConnectCustomKeyStore
func (c *KMS) ConnectCustomKeyStoreRequest(input *ConnectCustomKeyStoreInput) (req *request.Request, output *ConnectCustomKeyStoreOutput) {
	op := &request.Operation{
		Name:       opConnectCustomKeyStore,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConnectCustomKeyStoreInput{}
	}

	output = &ConnectCustomKeyStoreOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ConnectCustomKeyStore API operation for AWS Key Management Service.
//
// Connects or reconnects a custom key store (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
// to its backing key store. For an CloudHSM key store, ConnectCustomKeyStore
// connects the key store to its associated CloudHSM cluster. For an external
// key store, ConnectCustomKeyStore connects the key store to the external key
// store proxy that communicates with your external key manager.
//
// The custom key store must be connected before you can create KMS keys in
// the key store or use the KMS keys it contains. You can disconnect and reconnect
// a custom key store at any time.
//
// The connection process for a custom key store can take an extended amount
// of time to complete. This operation starts the connection process, but it
// does not wait for it to complete. When it succeeds, this operation quickly
// returns an HTTP 200 response and a JSON object with no properties. However,
// this response does not indicate that the custom key store is connected. To
// get the connection state of the custom key store, use the DescribeCustomKeyStores
// operation.
//
// This operation is part of the custom key stores (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
// feature in KMS, which combines the convenience and extensive integration
// of KMS with the isolation and control of a key store that you own and manage.
//
// The ConnectCustomKeyStore operation might fail for various reasons. To find
// the reason, use the DescribeCustomKeyStores operation and see the ConnectionErrorCode
// in the response. For help interpreting the ConnectionErrorCode, see CustomKeyStoresListEntry.
//
// To fix the failure, use the DisconnectCustomKeyStore operation to disconnect
// the custom key store, correct the error, use the UpdateCustomKeyStore operation
// if necessary, and then use ConnectCustomKeyStore again.
//
// # CloudHSM key store
//
// During the connection process for an CloudHSM key store, KMS finds the CloudHSM
// cluster that is associated with the custom key store, creates the connection
// infrastructure, connects to the cluster, logs into the CloudHSM client as
// the kmsuser CU, and rotates its password.
//
// To connect an CloudHSM key store, its associated CloudHSM cluster must have
// at least one active HSM. To get the number of active HSMs in a cluster, use
// the DescribeClusters (https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html)
// operation. To add HSMs to the cluster, use the CreateHsm (https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_CreateHsm.html)
// operation. Also, the kmsuser crypto user (https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser)
// (CU) must not be logged into the cluster. This prevents KMS from using this
// account to log in.
//
// If you are having trouble connecting or disconnecting a CloudHSM key store,
// see Troubleshooting an CloudHSM key store (https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html)
// in the Key Management Service Developer Guide.
//
// # External key store
//
// When you connect an external key store that uses public endpoint connectivity,
// KMS tests its ability to communicate with your external key manager by sending
// a request via the external key store proxy.
//
// When you connect to an external key store that uses VPC endpoint service
// connectivity, KMS establishes the networking elements that it needs to communicate
// with your external key manager via the external key store proxy. This includes
// creating an interface endpoint to the VPC endpoint service and a private
// hosted zone for traffic between KMS and the VPC endpoint service.
//
// To connect an external key store, KMS must be able to connect to the external
// key store proxy, the external key store proxy must be able to communicate
// with your external key manager, and the external key manager must be available
// for cryptographic operations.
//
// If you are having trouble connecting or disconnecting an external key store,
// see Troubleshooting an external key store (https://docs.aws.amazon.com/kms/latest/developerguide/xks-troubleshooting.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: No. You cannot perform this operation on a custom key
// store in a different Amazon Web Services account.
//
// Required permissions: kms:ConnectCustomKeyStore (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (IAM policy)
//
// Related operations
//
//   - CreateCustomKeyStore
//
//   - DeleteCustomKeyStore
//
//   - DescribeCustomKeyStores
//
//   - DisconnectCustomKeyStore
//
//   - UpdateCustomKeyStore
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation ConnectCustomKeyStore for usage and error information.
//
// Returned Error Types:
//
//   - CloudHsmClusterNotActiveException
//     The request was rejected because the CloudHSM cluster associated with the
//     CloudHSM key store is not active. Initialize and activate the cluster and
//     try the command again. For detailed instructions, see Getting Started (https://docs.aws.amazon.com/cloudhsm/latest/userguide/getting-started.html)
//     in the CloudHSM User Guide.
//
//   - CustomKeyStoreInvalidStateException
//     The request was rejected because of the ConnectionState of the custom key
//     store. To get the ConnectionState of a custom key store, use the DescribeCustomKeyStores
//     operation.
//
//     This exception is thrown under the following conditions:
//
//   - You requested the ConnectCustomKeyStore operation on a custom key store
//     with a ConnectionState of DISCONNECTING or FAILED. This operation is valid
//     for all other ConnectionState values. To reconnect a custom key store
//     in a FAILED state, disconnect it (DisconnectCustomKeyStore), then connect
//     it (ConnectCustomKeyStore).
//
//   - You requested the CreateKey operation in a custom key store that is
//     not connected. This operations is valid only when the custom key store
//     ConnectionState is CONNECTED.
//
//   - You requested the DisconnectCustomKeyStore operation on a custom key
//     store with a ConnectionState of DISCONNECTING or DISCONNECTED. This operation
//     is valid for all other ConnectionState values.
//
//   - You requested the UpdateCustomKeyStore or DeleteCustomKeyStore operation
//     on a custom key store that is not disconnected. This operation is valid
//     only when the custom key store ConnectionState is DISCONNECTED.
//
//   - You requested the GenerateRandom operation in an CloudHSM key store
//     that is not connected. This operation is valid only when the CloudHSM
//     key store ConnectionState is CONNECTED.
//
//   - CustomKeyStoreNotFoundException
//     The request was rejected because KMS cannot find a custom key store with
//     the specified key store name or ID.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - CloudHsmClusterInvalidConfigurationException
//     The request was rejected because the associated CloudHSM cluster did not
//     meet the configuration requirements for an CloudHSM key store.
//
//   - The CloudHSM cluster must be configured with private subnets in at least
//     two different Availability Zones in the Region.
//
//   - The security group for the cluster (https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html)
//     (cloudhsm-cluster-<cluster-id>-sg) must include inbound rules and outbound
//     rules that allow TCP traffic on ports 2223-2225. The Source in the inbound
//     rules and the Destination in the outbound rules must match the security
//     group ID. These rules are set by default when you create the CloudHSM
//     cluster. Do not delete or change them. To get information about a particular
//     security group, use the DescribeSecurityGroups (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroups.html)
//     operation.
//
//   - The CloudHSM cluster must contain at least as many HSMs as the operation
//     requires. To add HSMs, use the CloudHSM CreateHsm (https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_CreateHsm.html)
//     operation. For the CreateCustomKeyStore, UpdateCustomKeyStore, and CreateKey
//     operations, the CloudHSM cluster must have at least two active HSMs, each
//     in a different Availability Zone. For the ConnectCustomKeyStore operation,
//     the CloudHSM must contain at least one active HSM.
//
//     For information about the requirements for an CloudHSM cluster that is associated
//     with an CloudHSM key store, see Assemble the Prerequisites (https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore)
//     in the Key Management Service Developer Guide. For information about creating
//     a private subnet for an CloudHSM cluster, see Create a Private Subnet (https://docs.aws.amazon.com/cloudhsm/latest/userguide/create-subnets.html)
//     in the CloudHSM User Guide. For information about cluster security groups,
//     see Configure a Default Security Group (https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html)
//     in the CloudHSM User Guide .
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ConnectCustomKeyStore
func (c *KMS) ConnectCustomKeyStore(input *ConnectCustomKeyStoreInput) (*ConnectCustomKeyStoreOutput, error) {
	req, out := c.ConnectCustomKeyStoreRequest(input)
	return out, req.Send()
}

// ConnectCustomKeyStoreWithContext is the same as ConnectCustomKeyStore with the addition of
// the ability to pass a context and additional request options.
//
// See ConnectCustomKeyStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ConnectCustomKeyStoreWithContext(ctx aws.Context, input *ConnectCustomKeyStoreInput, opts ...request.Option) (*ConnectCustomKeyStoreOutput, error) {
	req, out := c.ConnectCustomKeyStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAlias = "CreateAlias"

// CreateAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAlias for more information on using the CreateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAliasRequest method.
//	req, resp := client.CreateAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateAlias
func (c *KMS) CreateAliasRequest(input *CreateAliasInput) (req *request.Request, output *CreateAliasOutput) {
	op := &request.Operation{
		Name:       opCreateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAliasInput{}
	}

	output = &CreateAliasOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateAlias API operation for AWS Key Management Service.
//
// Creates a friendly name for a KMS key.
//
// Adding, deleting, or updating an alias can allow or deny permission to the
// KMS key. For details, see ABAC for KMS (https://docs.aws.amazon.com/kms/latest/developerguide/abac.html)
// in the Key Management Service Developer Guide.
//
// You can use an alias to identify a KMS key in the KMS console, in the DescribeKey
// operation and in cryptographic operations (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations),
// such as Encrypt and GenerateDataKey. You can also change the KMS key that's
// associated with the alias (UpdateAlias) or delete the alias (DeleteAlias)
// at any time. These operations don't affect the underlying KMS key.
//
// You can associate the alias with any customer managed key in the same Amazon
// Web Services Region. Each alias is associated with only one KMS key at a
// time, but a KMS key can have multiple aliases. A valid KMS key is required.
// You can't create an alias without a KMS key.
//
// The alias must be unique in the account and Region, but you can have aliases
// with the same name in different Regions. For detailed information about aliases,
// see Using aliases (https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html)
// in the Key Management Service Developer Guide.
//
// This operation does not return a response. To get the alias that you created,
// use the ListAliases operation.
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: No. You cannot perform this operation on an alias in a
// different Amazon Web Services account.
//
// Required permissions
//
//   - kms:CreateAlias (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
//     on the alias (IAM policy).
//
//   - kms:CreateAlias (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
//     on the KMS key (key policy).
//
// For details, see Controlling access to aliases (https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html#alias-access)
// in the Key Management Service Developer Guide.
//
// Related operations:
//
//   - DeleteAlias
//
//   - ListAliases
//
//   - UpdateAlias
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation CreateAlias for usage and error information.
//
// Returned Error Types:
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - AlreadyExistsException
//     The request was rejected because it attempted to create a resource that already
//     exists.
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - InvalidAliasNameException
//     The request was rejected because the specified alias name is not valid.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - LimitExceededException
//     The request was rejected because a quota was exceeded. For more information,
//     see Quotas (https://docs.aws.amazon.com/kms/latest/developerguide/limits.html)
//     in the Key Management Service Developer Guide.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateAlias
func (c *KMS) CreateAlias(input *CreateAliasInput) (*CreateAliasOutput, error) {
	req, out := c.CreateAliasRequest(input)
	return out, req.Send()
}

// CreateAliasWithContext is the same as CreateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) CreateAliasWithContext(ctx aws.Context, input *CreateAliasInput, opts ...request.Option) (*CreateAliasOutput, error) {
	req, out := c.CreateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCustomKeyStore = "CreateCustomKeyStore"

// CreateCustomKeyStoreRequest generates a "aws/request.Request" representing the
// client's request for the CreateCustomKeyStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCustomKeyStore for more information on using the CreateCustomKeyStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCustomKeyStoreRequest method.
//	req, resp := client.CreateCustomKeyStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateCustomKeyStore
func (c *KMS) CreateCustomKeyStoreRequest(input *CreateCustomKeyStoreInput) (req *request.Request, output *CreateCustomKeyStoreOutput) {
	op := &request.Operation{
		Name:       opCreateCustomKeyStore,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCustomKeyStoreInput{}
	}

	output = &CreateCustomKeyStoreOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCustomKeyStore API operation for AWS Key Management Service.
//
// Creates a custom key store (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
// backed by a key store that you own and manage. When you use a KMS key in
// a custom key store for a cryptographic operation, the cryptographic operation
// is actually performed in your key store using your keys. KMS supports CloudHSM
// key stores (https://docs.aws.amazon.com/kms/latest/developerguide/keystore-cloudhsm.html)
// backed by an CloudHSM cluster (https://docs.aws.amazon.com/cloudhsm/latest/userguide/clusters.html)
// and external key stores (https://docs.aws.amazon.com/kms/latest/developerguide/keystore-external.html)
// backed by an external key store proxy and external key manager outside of
// Amazon Web Services.
//
// This operation is part of the custom key stores (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
// feature in KMS, which combines the convenience and extensive integration
// of KMS with the isolation and control of a key store that you own and manage.
//
// Before you create the custom key store, the required elements must be in
// place and operational. We recommend that you use the test tools that KMS
// provides to verify the configuration your external key store proxy. For details
// about the required elements and verification tests, see Assemble the prerequisites
// (for CloudHSM key stores) (https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore)
// or Assemble the prerequisites (for external key stores) (https://docs.aws.amazon.com/kms/latest/developerguide/create-xks-keystore.html#xks-requirements)
// in the Key Management Service Developer Guide.
//
// To create a custom key store, use the following parameters.
//
//   - To create an CloudHSM key store, specify the CustomKeyStoreName, CloudHsmClusterId,
//     KeyStorePassword, and TrustAnchorCertificate. The CustomKeyStoreType parameter
//     is optional for CloudHSM key stores. If you include it, set it to the
//     default value, AWS_CLOUDHSM. For help with failures, see Troubleshooting
//     an CloudHSM key store (https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html)
//     in the Key Management Service Developer Guide.
//
//   - To create an external key store, specify the CustomKeyStoreName and
//     a CustomKeyStoreType of EXTERNAL_KEY_STORE. Also, specify values for XksProxyConnectivity,
//     XksProxyAuthenticationCredential, XksProxyUriEndpoint, and XksProxyUriPath.
//     If your XksProxyConnectivity value is VPC_ENDPOINT_SERVICE, specify the
//     XksProxyVpcEndpointServiceName parameter. For help with failures, see
//     Troubleshooting an external key store (https://docs.aws.amazon.com/kms/latest/developerguide/xks-troubleshooting.html)
//     in the Key Management Service Developer Guide.
//
// For external key stores:
//
// Some external key managers provide a simpler method for creating an external
// key store. For details, see your external key manager documentation.
//
// When creating an external key store in the KMS console, you can upload a
// JSON-based proxy configuration file with the desired values. You cannot use
// a proxy configuration with the CreateCustomKeyStore operation. However, you
// can use the values in the file to help you determine the correct values for
// the CreateCustomKeyStore parameters.
//
// When the operation completes successfully, it returns the ID of the new custom
// key store. Before you can use your new custom key store, you need to use
// the ConnectCustomKeyStore operation to connect a new CloudHSM key store to
// its CloudHSM cluster, or to connect a new external key store to the external
// key store proxy for your external key manager. Even if you are not going
// to use your custom key store immediately, you might want to connect it to
// verify that all settings are correct and then disconnect it until you are
// ready to use it.
//
// For help with failures, see Troubleshooting a custom key store (https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: No. You cannot perform this operation on a custom key
// store in a different Amazon Web Services account.
//
// Required permissions: kms:CreateCustomKeyStore (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (IAM policy).
//
// Related operations:
//
//   - ConnectCustomKeyStore
//
//   - DeleteCustomKeyStore
//
//   - DescribeCustomKeyStores
//
//   - DisconnectCustomKeyStore
//
//   - UpdateCustomKeyStore
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation CreateCustomKeyStore for usage and error information.
//
// Returned Error Types:
//
//   - CloudHsmClusterInUseException
//     The request was rejected because the specified CloudHSM cluster is already
//     associated with an CloudHSM key store in the account, or it shares a backup
//     history with an CloudHSM key store in the account. Each CloudHSM key store
//     in the account must be associated with a different CloudHSM cluster.
//
//     CloudHSM clusters that share a backup history have the same cluster certificate.
//     To view the cluster certificate of an CloudHSM cluster, use the DescribeClusters
//     (https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html)
//     operation.
//
//   - CustomKeyStoreNameInUseException
//     The request was rejected because the specified custom key store name is already
//     assigned to another custom key store in the account. Try again with a custom
//     key store name that is unique in the account.
//
//   - CloudHsmClusterNotFoundException
//     The request was rejected because KMS cannot find the CloudHSM cluster with
//     the specified cluster ID. Retry the request with a different cluster ID.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - CloudHsmClusterNotActiveException
//     The request was rejected because the CloudHSM cluster associated with the
//     CloudHSM key store is not active. Initialize and activate the cluster and
//     try the command again. For detailed instructions, see Getting Started (https://docs.aws.amazon.com/cloudhsm/latest/userguide/getting-started.html)
//     in the CloudHSM User Guide.
//
//   - IncorrectTrustAnchorException
//     The request was rejected because the trust anchor certificate in the request
//     to create an CloudHSM key store is not the trust anchor certificate for the
//     specified CloudHSM cluster.
//
//     When you initialize the CloudHSM cluster (https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html#sign-csr),
//     you create the trust anchor certificate and save it in the customerCA.crt
//     file.
//
//   - CloudHsmClusterInvalidConfigurationException
//     The request was rejected because the associated CloudHSM cluster did not
//     meet the configuration requirements for an CloudHSM key store.
//
//   - The CloudHSM cluster must be configured with private subnets in at least
//     two different Availability Zones in the Region.
//
//   - The security group for the cluster (https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html)
//     (cloudhsm-cluster-<cluster-id>-sg) must include inbound rules and outbound
//     rules that allow TCP traffic on ports 2223-2225. The Source in the inbound
//     rules and the Destination in the outbound rules must match the security
//     group ID. These rules are set by default when you create the CloudHSM
//     cluster. Do not delete or change them. To get information about a particular
//     security group, use the DescribeSecurityGroups (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroups.html)
//     operation.
//
//   - The CloudHSM cluster must contain at least as many HSMs as the operation
//     requires. To add HSMs, use the CloudHSM CreateHsm (https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_CreateHsm.html)
//     operation. For the CreateCustomKeyStore, UpdateCustomKeyStore, and CreateKey
//     operations, the CloudHSM cluster must have at least two active HSMs, each
//     in a different Availability Zone. For the ConnectCustomKeyStore operation,
//     the CloudHSM must contain at least one active HSM.
//
//     For information about the requirements for an CloudHSM cluster that is associated
//     with an CloudHSM key store, see Assemble the Prerequisites (https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore)
//     in the Key Management Service Developer Guide. For information about creating
//     a private subnet for an CloudHSM cluster, see Create a Private Subnet (https://docs.aws.amazon.com/cloudhsm/latest/userguide/create-subnets.html)
//     in the CloudHSM User Guide. For information about cluster security groups,
//     see Configure a Default Security Group (https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html)
//     in the CloudHSM User Guide .
//
//   - LimitExceededException
//     The request was rejected because a quota was exceeded. For more information,
//     see Quotas (https://docs.aws.amazon.com/kms/latest/developerguide/limits.html)
//     in the Key Management Service Developer Guide.
//
//   - XksProxyUriInUseException
//     The request was rejected because the concatenation of the XksProxyUriEndpoint
//     and XksProxyUriPath is already associated with an external key store in the
//     Amazon Web Services account and Region. Each external key store in an account
//     and Region must use a unique external key store proxy API address.
//
//   - XksProxyUriEndpointInUseException
//     The request was rejected because the concatenation of the XksProxyUriEndpoint
//     is already associated with an external key store in the Amazon Web Services
//     account and Region. Each external key store in an account and Region must
//     use a unique external key store proxy address.
//
//   - XksProxyUriUnreachableException
//     KMS was unable to reach the specified XksProxyUriPath. The path must be reachable
//     before you create the external key store or update its settings.
//
//     This exception is also thrown when the external key store proxy response
//     to a GetHealthStatus request indicates that all external key manager instances
//     are unavailable.
//
//   - XksProxyIncorrectAuthenticationCredentialException
//     The request was rejected because the proxy credentials failed to authenticate
//     to the specified external key store proxy. The specified external key store
//     proxy rejected a status request from KMS due to invalid credentials. This
//     can indicate an error in the credentials or in the identification of the
//     external key store proxy.
//
//   - XksProxyVpcEndpointServiceInUseException
//     The request was rejected because the specified Amazon VPC endpoint service
//     is already associated with an external key store in the Amazon Web Services
//     account and Region. Each external key store in an Amazon Web Services account
//     and Region must use a different Amazon VPC endpoint service.
//
//   - XksProxyVpcEndpointServiceNotFoundException
//     The request was rejected because KMS could not find the specified VPC endpoint
//     service. Use DescribeCustomKeyStores to verify the VPC endpoint service name
//     for the external key store. Also, confirm that the Allow principals list
//     for the VPC endpoint service includes the KMS service principal for the Region,
//     such as cks.kms.us-east-1.amazonaws.com.
//
//   - XksProxyVpcEndpointServiceInvalidConfigurationException
//     The request was rejected because the Amazon VPC endpoint service configuration
//     does not fulfill the requirements for an external key store proxy. For details,
//     see the exception message and review the requirements (kms/latest/developerguide/vpc-connectivity.html#xks-vpc-requirements)
//     for Amazon VPC endpoint service connectivity for an external key store.
//
//   - XksProxyInvalidResponseException
//     KMS cannot interpret the response it received from the external key store
//     proxy. The problem might be a poorly constructed response, but it could also
//     be a transient network issue. If you see this error repeatedly, report it
//     to the proxy vendor.
//
//   - XksProxyInvalidConfigurationException
//     The request was rejected because the Amazon VPC endpoint service configuration
//     does not fulfill the requirements for an external key store proxy. For details,
//     see the exception message.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateCustomKeyStore
func (c *KMS) CreateCustomKeyStore(input *CreateCustomKeyStoreInput) (*CreateCustomKeyStoreOutput, error) {
	req, out := c.CreateCustomKeyStoreRequest(input)
	return out, req.Send()
}

// CreateCustomKeyStoreWithContext is the same as CreateCustomKeyStore with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCustomKeyStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) CreateCustomKeyStoreWithContext(ctx aws.Context, input *CreateCustomKeyStoreInput, opts ...request.Option) (*CreateCustomKeyStoreOutput, error) {
	req, out := c.CreateCustomKeyStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGrant = "CreateGrant"

// CreateGrantRequest generates a "aws/request.Request" representing the
// client's request for the CreateGrant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGrant for more information on using the CreateGrant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateGrantRequest method.
//	req, resp := client.CreateGrantRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateGrant
func (c *KMS) CreateGrantRequest(input *CreateGrantInput) (req *request.Request, output *CreateGrantOutput) {
	op := &request.Operation{
		Name:       opCreateGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGrantInput{}
	}

	output = &CreateGrantOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGrant API operation for AWS Key Management Service.
//
// Adds a grant to a KMS key.
//
// A grant is a policy instrument that allows Amazon Web Services principals
// to use KMS keys in cryptographic operations. It also can allow them to view
// a KMS key (DescribeKey) and create and manage grants. When authorizing access
// to a KMS key, grants are considered along with key policies and IAM policies.
// Grants are often used for temporary permissions because you can create one,
// use its permissions, and delete it without changing your key policies or
// IAM policies.
//
// For detailed information about grants, including grant terminology, see Grants
// in KMS (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html)
// in the Key Management Service Developer Guide . For examples of working with
// grants in several programming languages, see Programming grants (https://docs.aws.amazon.com/kms/latest/developerguide/programming-grants.html).
//
// The CreateGrant operation returns a GrantToken and a GrantId.
//
//   - When you create, retire, or revoke a grant, there might be a brief delay,
//     usually less than five minutes, until the grant is available throughout
//     KMS. This state is known as eventual consistency. Once the grant has achieved
//     eventual consistency, the grantee principal can use the permissions in
//     the grant without identifying the grant. However, to use the permissions
//     in the grant immediately, use the GrantToken that CreateGrant returns.
//     For details, see Using a grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
//     in the Key Management Service Developer Guide .
//
//   - The CreateGrant operation also returns a GrantId. You can use the GrantId
//     and a key identifier to identify the grant in the RetireGrant and RevokeGrant
//     operations. To find the grant ID, use the ListGrants or ListRetirableGrants
//     operations.
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: Yes. To perform this operation on a KMS key in a different
// Amazon Web Services account, specify the key ARN in the value of the KeyId
// parameter.
//
// Required permissions: kms:CreateGrant (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations:
//
//   - ListGrants
//
//   - ListRetirableGrants
//
//   - RetireGrant
//
//   - RevokeGrant
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation CreateGrant for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - DisabledException
//     The request was rejected because the specified KMS key is not enabled.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidGrantTokenException
//     The request was rejected because the specified grant token is not valid.
//
//   - LimitExceededException
//     The request was rejected because a quota was exceeded. For more information,
//     see Quotas (https://docs.aws.amazon.com/kms/latest/developerguide/limits.html)
//     in the Key Management Service Developer Guide.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateGrant
func (c *KMS) CreateGrant(input *CreateGrantInput) (*CreateGrantOutput, error) {
	req, out := c.CreateGrantRequest(input)
	return out, req.Send()
}

// CreateGrantWithContext is the same as CreateGrant with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGrant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) CreateGrantWithContext(ctx aws.Context, input *CreateGrantInput, opts ...request.Option) (*CreateGrantOutput, error) {
	req, out := c.CreateGrantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKey = "CreateKey"

// CreateKeyRequest generates a "aws/request.Request" representing the
// client's request for the CreateKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateKey for more information on using the CreateKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateKeyRequest method.
//	req, resp := client.CreateKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateKey
func (c *KMS) CreateKeyRequest(input *CreateKeyInput) (req *request.Request, output *CreateKeyOutput) {
	op := &request.Operation{
		Name:       opCreateKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateKeyInput{}
	}

	output = &CreateKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateKey API operation for AWS Key Management Service.
//
// Creates a unique customer managed KMS key (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms-keys)
// in your Amazon Web Services account and Region. You can use a KMS key in
// cryptographic operations, such as encryption and signing. Some Amazon Web
// Services services let you use KMS keys that you create and manage to protect
// your service resources.
//
// A KMS key is a logical representation of a cryptographic key. In addition
// to the key material used in cryptographic operations, a KMS key includes
// metadata, such as the key ID, key policy, creation date, description, and
// key state. For details, see Managing keys (https://docs.aws.amazon.com/kms/latest/developerguide/getting-started.html)
// in the Key Management Service Developer Guide
//
// Use the parameters of CreateKey to specify the type of KMS key, the source
// of its key material, its key policy, description, tags, and other properties.
//
// KMS has replaced the term customer master key (CMK) with KMS key and KMS
// key. The concept has not changed. To prevent breaking changes, KMS is keeping
// some variations of this term.
//
// To create different types of KMS keys, use the following guidance:
//
// # Symmetric encryption KMS key
//
// By default, CreateKey creates a symmetric encryption KMS key with key material
// that KMS generates. This is the basic and most widely used type of KMS key,
// and provides the best performance.
//
// To create a symmetric encryption KMS key, you don't need to specify any parameters.
// The default value for KeySpec, SYMMETRIC_DEFAULT, the default value for KeyUsage,
// ENCRYPT_DECRYPT, and the default value for Origin, AWS_KMS, create a symmetric
// encryption KMS key with KMS key material.
//
// If you need a key for basic encryption and decryption or you are creating
// a KMS key to protect your resources in an Amazon Web Services service, create
// a symmetric encryption KMS key. The key material in a symmetric encryption
// key never leaves KMS unencrypted. You can use a symmetric encryption KMS
// key to encrypt and decrypt data up to 4,096 bytes, but they are typically
// used to generate data keys and data keys pairs. For details, see GenerateDataKey
// and GenerateDataKeyPair.
//
// # Asymmetric KMS keys
//
// To create an asymmetric KMS key, use the KeySpec parameter to specify the
// type of key material in the KMS key. Then, use the KeyUsage parameter to
// determine whether the KMS key will be used to encrypt and decrypt or sign
// and verify. You can't change these properties after the KMS key is created.
//
// Asymmetric KMS keys contain an RSA key pair, Elliptic Curve (ECC) key pair,
// or an SM2 key pair (China Regions only). The private key in an asymmetric
// KMS key never leaves KMS unencrypted. However, you can use the GetPublicKey
// operation to download the public key so it can be used outside of KMS. KMS
// keys with RSA or SM2 key pairs can be used to encrypt or decrypt data or
// sign and verify messages (but not both). KMS keys with ECC key pairs can
// be used only to sign and verify messages. For information about asymmetric
// KMS keys, see Asymmetric KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
// in the Key Management Service Developer Guide.
//
// # HMAC KMS key
//
// To create an HMAC KMS key, set the KeySpec parameter to a key spec value
// for HMAC KMS keys. Then set the KeyUsage parameter to GENERATE_VERIFY_MAC.
// You must set the key usage even though GENERATE_VERIFY_MAC is the only valid
// key usage value for HMAC KMS keys. You can't change these properties after
// the KMS key is created.
//
// HMAC KMS keys are symmetric keys that never leave KMS unencrypted. You can
// use HMAC keys to generate (GenerateMac) and verify (VerifyMac) HMAC codes
// for messages up to 4096 bytes.
//
// HMAC KMS keys are not supported in all Amazon Web Services Regions. If you
// try to create an HMAC KMS key in an Amazon Web Services Region in which HMAC
// keys are not supported, the CreateKey operation returns an UnsupportedOperationException.
// For a list of Regions in which HMAC KMS keys are supported, see HMAC keys
// in KMS (https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html)
// in the Key Management Service Developer Guide.
//
// # Multi-Region primary keys
//
// # Imported key material
//
// To create a multi-Region primary key in the local Amazon Web Services Region,
// use the MultiRegion parameter with a value of True. To create a multi-Region
// replica key, that is, a KMS key with the same key ID and key material as
// a primary key, but in a different Amazon Web Services Region, use the ReplicateKey
// operation. To change a replica key to a primary key, and its primary key
// to a replica key, use the UpdatePrimaryRegion operation.
//
// You can create multi-Region KMS keys for all supported KMS key types: symmetric
// encryption KMS keys, HMAC KMS keys, asymmetric encryption KMS keys, and asymmetric
// signing KMS keys. You can also create multi-Region keys with imported key
// material. However, you can't create multi-Region keys in a custom key store.
//
// This operation supports multi-Region keys, an KMS feature that lets you create
// multiple interoperable KMS keys in different Amazon Web Services Regions.
// Because these KMS keys have the same key ID, key material, and other metadata,
// you can use them interchangeably to encrypt data in one Amazon Web Services
// Region and decrypt it in a different Amazon Web Services Region without re-encrypting
// the data or making a cross-Region call. For more information about multi-Region
// keys, see Multi-Region keys in KMS (https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html)
// in the Key Management Service Developer Guide.
//
// To import your own key material into a KMS key, begin by creating a symmetric
// encryption KMS key with no key material. To do this, use the Origin parameter
// of CreateKey with a value of EXTERNAL. Next, use GetParametersForImport operation
// to get a public key and import token, and use the public key to encrypt your
// key material. Then, use ImportKeyMaterial with your import token to import
// the key material. For step-by-step instructions, see Importing Key Material
// (https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html)
// in the Key Management Service Developer Guide .
//
// This feature supports only symmetric encryption KMS keys, including multi-Region
// symmetric encryption KMS keys. You cannot import key material into any other
// type of KMS key.
//
// To create a multi-Region primary key with imported key material, use the
// Origin parameter of CreateKey with a value of EXTERNAL and the MultiRegion
// parameter with a value of True. To create replicas of the multi-Region primary
// key, use the ReplicateKey operation. For instructions, see Importing key
// material into multi-Region keys (https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-import.html).
// For more information about multi-Region keys, see Multi-Region keys in KMS
// (https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html)
// in the Key Management Service Developer Guide.
//
// # Custom key store
//
// A custom key store (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
// lets you protect your Amazon Web Services resources using keys in a backing
// key store that you own and manage. When you request a cryptographic operation
// with a KMS key in a custom key store, the operation is performed in the backing
// key store using its cryptographic keys.
//
// KMS supports CloudHSM key stores (https://docs.aws.amazon.com/kms/latest/developerguide/keystore-cloudhsm.html)
// backed by an CloudHSM cluster and external key stores (https://docs.aws.amazon.com/kms/latest/developerguide/keystore-external.html)
// backed by an external key manager outside of Amazon Web Services. When you
// create a KMS key in an CloudHSM key store, KMS generates an encryption key
// in the CloudHSM cluster and associates it with the KMS key. When you create
// a KMS key in an external key store, you specify an existing encryption key
// in the external key manager.
//
// Some external key managers provide a simpler method for creating a KMS key
// in an external key store. For details, see your external key manager documentation.
//
// Before you create a KMS key in a custom key store, the ConnectionState of
// the key store must be CONNECTED. To connect the custom key store, use the
// ConnectCustomKeyStore operation. To find the ConnectionState, use the DescribeCustomKeyStores
// operation.
//
// To create a KMS key in a custom key store, use the CustomKeyStoreId. Use
// the default KeySpec value, SYMMETRIC_DEFAULT, and the default KeyUsage value,
// ENCRYPT_DECRYPT to create a symmetric encryption key. No other key type is
// supported in a custom key store.
//
// To create a KMS key in an CloudHSM key store (https://docs.aws.amazon.com/kms/latest/developerguide/keystore-cloudhsm.html),
// use the Origin parameter with a value of AWS_CLOUDHSM. The CloudHSM cluster
// that is associated with the custom key store must have at least two active
// HSMs in different Availability Zones in the Amazon Web Services Region.
//
// To create a KMS key in an external key store (https://docs.aws.amazon.com/kms/latest/developerguide/keystore-external.html),
// use the Origin parameter with a value of EXTERNAL_KEY_STORE and an XksKeyId
// parameter that identifies an existing external key.
//
// Some external key managers provide a simpler method for creating a KMS key
// in an external key store. For details, see your external key manager documentation.
//
// Cross-account use: No. You cannot use this operation to create a KMS key
// in a different Amazon Web Services account.
//
// Required permissions: kms:CreateKey (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (IAM policy). To use the Tags parameter, kms:TagResource (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (IAM policy). For examples and information about related permissions, see
// Allow a user to create KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/iam-policies.html#iam-policy-example-create-key)
// in the Key Management Service Developer Guide.
//
// Related operations:
//
//   - DescribeKey
//
//   - ListKeys
//
//   - ScheduleKeyDeletion
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation CreateKey for usage and error information.
//
// Returned Error Types:
//
//   - MalformedPolicyDocumentException
//     The request was rejected because the specified policy is not syntactically
//     or semantically correct.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - UnsupportedOperationException
//     The request was rejected because a specified parameter is not supported or
//     a specified resource is not valid for this operation.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - LimitExceededException
//     The request was rejected because a quota was exceeded. For more information,
//     see Quotas (https://docs.aws.amazon.com/kms/latest/developerguide/limits.html)
//     in the Key Management Service Developer Guide.
//
//   - TagException
//     The request was rejected because one or more tags are not valid.
//
//   - CustomKeyStoreNotFoundException
//     The request was rejected because KMS cannot find a custom key store with
//     the specified key store name or ID.
//
//   - CustomKeyStoreInvalidStateException
//     The request was rejected because of the ConnectionState of the custom key
//     store. To get the ConnectionState of a custom key store, use the DescribeCustomKeyStores
//     operation.
//
//     This exception is thrown under the following conditions:
//
//   - You requested the ConnectCustomKeyStore operation on a custom key store
//     with a ConnectionState of DISCONNECTING or FAILED. This operation is valid
//     for all other ConnectionState values. To reconnect a custom key store
//     in a FAILED state, disconnect it (DisconnectCustomKeyStore), then connect
//     it (ConnectCustomKeyStore).
//
//   - You requested the CreateKey operation in a custom key store that is
//     not connected. This operations is valid only when the custom key store
//     ConnectionState is CONNECTED.
//
//   - You requested the DisconnectCustomKeyStore operation on a custom key
//     store with a ConnectionState of DISCONNECTING or DISCONNECTED. This operation
//     is valid for all other ConnectionState values.
//
//   - You requested the UpdateCustomKeyStore or DeleteCustomKeyStore operation
//     on a custom key store that is not disconnected. This operation is valid
//     only when the custom key store ConnectionState is DISCONNECTED.
//
//   - You requested the GenerateRandom operation in an CloudHSM key store
//     that is not connected. This operation is valid only when the CloudHSM
//     key store ConnectionState is CONNECTED.
//
//   - CloudHsmClusterInvalidConfigurationException
//     The request was rejected because the associated CloudHSM cluster did not
//     meet the configuration requirements for an CloudHSM key store.
//
//   - The CloudHSM cluster must be configured with private subnets in at least
//     two different Availability Zones in the Region.
//
//   - The security group for the cluster (https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html)
//     (cloudhsm-cluster-<cluster-id>-sg) must include inbound rules and outbound
//     rules that allow TCP traffic on ports 2223-2225. The Source in the inbound
//     rules and the Destination in the outbound rules must match the security
//     group ID. These rules are set by default when you create the CloudHSM
//     cluster. Do not delete or change them. To get information about a particular
//     security group, use the DescribeSecurityGroups (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroups.html)
//     operation.
//
//   - The CloudHSM cluster must contain at least as many HSMs as the operation
//     requires. To add HSMs, use the CloudHSM CreateHsm (https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_CreateHsm.html)
//     operation. For the CreateCustomKeyStore, UpdateCustomKeyStore, and CreateKey
//     operations, the CloudHSM cluster must have at least two active HSMs, each
//     in a different Availability Zone. For the ConnectCustomKeyStore operation,
//     the CloudHSM must contain at least one active HSM.
//
//     For information about the requirements for an CloudHSM cluster that is associated
//     with an CloudHSM key store, see Assemble the Prerequisites (https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore)
//     in the Key Management Service Developer Guide. For information about creating
//     a private subnet for an CloudHSM cluster, see Create a Private Subnet (https://docs.aws.amazon.com/cloudhsm/latest/userguide/create-subnets.html)
//     in the CloudHSM User Guide. For information about cluster security groups,
//     see Configure a Default Security Group (https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html)
//     in the CloudHSM User Guide .
//
//   - XksKeyInvalidConfigurationException
//     The request was rejected because the external key specified by the XksKeyId
//     parameter did not meet the configuration requirements for an external key
//     store.
//
//     The external key must be an AES-256 symmetric key that is enabled and performs
//     encryption and decryption.
//
//   - XksKeyAlreadyInUseException
//     The request was rejected because the (XksKeyId) is already associated with
//     a KMS key in this external key store. Each KMS key in an external key store
//     must be associated with a different external key.
//
//   - XksKeyNotFoundException
//     The request was rejected because the external key store proxy could not find
//     the external key. This exception is thrown when the value of the XksKeyId
//     parameter doesn't identify a key in the external key manager associated with
//     the external key proxy.
//
//     Verify that the XksKeyId represents an existing key in the external key manager.
//     Use the key identifier that the external key store proxy uses to identify
//     the key. For details, see the documentation provided with your external key
//     store proxy or key manager.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateKey
func (c *KMS) CreateKey(input *CreateKeyInput) (*CreateKeyOutput, error) {
	req, out := c.CreateKeyRequest(input)
	return out, req.Send()
}

// CreateKeyWithContext is the same as CreateKey with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) CreateKeyWithContext(ctx aws.Context, input *CreateKeyInput, opts ...request.Option) (*CreateKeyOutput, error) {
	req, out := c.CreateKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDecrypt = "Decrypt"

// DecryptRequest generates a "aws/request.Request" representing the
// client's request for the Decrypt operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Decrypt for more information on using the Decrypt
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DecryptRequest method.
//	req, resp := client.DecryptRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/Decrypt
func (c *KMS) DecryptRequest(input *DecryptInput) (req *request.Request, output *DecryptOutput) {
	op := &request.Operation{
		Name:       opDecrypt,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DecryptInput{}
	}

	output = &DecryptOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Decrypt API operation for AWS Key Management Service.
//
// Decrypts ciphertext that was encrypted by a KMS key using any of the following
// operations:
//
//   - Encrypt
//
//   - GenerateDataKey
//
//   - GenerateDataKeyPair
//
//   - GenerateDataKeyWithoutPlaintext
//
//   - GenerateDataKeyPairWithoutPlaintext
//
// You can use this operation to decrypt ciphertext that was encrypted under
// a symmetric encryption KMS key or an asymmetric encryption KMS key. When
// the KMS key is asymmetric, you must specify the KMS key and the encryption
// algorithm that was used to encrypt the ciphertext. For information about
// asymmetric KMS keys, see Asymmetric KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
// in the Key Management Service Developer Guide.
//
// The Decrypt operation also decrypts ciphertext that was encrypted outside
// of KMS by the public key in an KMS asymmetric KMS key. However, it cannot
// decrypt symmetric ciphertext produced by other libraries, such as the Amazon
// Web Services Encryption SDK (https://docs.aws.amazon.com/encryption-sdk/latest/developer-guide/)
// or Amazon S3 client-side encryption (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html).
// These libraries return a ciphertext format that is incompatible with KMS.
//
// If the ciphertext was encrypted under a symmetric encryption KMS key, the
// KeyId parameter is optional. KMS can get this information from metadata that
// it adds to the symmetric ciphertext blob. This feature adds durability to
// your implementation by ensuring that authorized users can decrypt ciphertext
// decades after it was encrypted, even if they've lost track of the key ID.
// However, specifying the KMS key is always recommended as a best practice.
// When you use the KeyId parameter to specify a KMS key, KMS only uses the
// KMS key you specify. If the ciphertext was encrypted under a different KMS
// key, the Decrypt operation fails. This practice ensures that you use the
// KMS key that you intend.
//
// Whenever possible, use key policies to give users permission to call the
// Decrypt operation on a particular KMS key, instead of using IAM policies.
// Otherwise, you might create an IAM user policy that gives the user Decrypt
// permission on all KMS keys. This user could decrypt ciphertext that was encrypted
// by KMS keys in other accounts if the key policy for the cross-account KMS
// key permits it. If you must use an IAM policy for Decrypt permissions, limit
// the user to particular KMS keys or particular trusted accounts. For details,
// see Best practices for IAM policies (https://docs.aws.amazon.com/kms/latest/developerguide/iam-policies.html#iam-policies-best-practices)
// in the Key Management Service Developer Guide.
//
// Applications in Amazon Web Services Nitro Enclaves can call this operation
// by using the Amazon Web Services Nitro Enclaves Development Kit (https://github.com/aws/aws-nitro-enclaves-sdk-c).
// For information about the supporting parameters, see How Amazon Web Services
// Nitro Enclaves use KMS (https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html)
// in the Key Management Service Developer Guide.
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: Yes. To perform this operation with a KMS key in a different
// Amazon Web Services account, specify the key ARN or alias ARN in the value
// of the KeyId parameter.
//
// Required permissions: kms:Decrypt (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations:
//
//   - Encrypt
//
//   - GenerateDataKey
//
//   - GenerateDataKeyPair
//
//   - ReEncrypt
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation Decrypt for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - DisabledException
//     The request was rejected because the specified KMS key is not enabled.
//
//   - InvalidCiphertextException
//     From the Decrypt or ReEncrypt operation, the request was rejected because
//     the specified ciphertext, or additional authenticated data incorporated into
//     the ciphertext, such as the encryption context, is corrupted, missing, or
//     otherwise invalid.
//
//     From the ImportKeyMaterial operation, the request was rejected because KMS
//     could not decrypt the encrypted (wrapped) key material.
//
//   - KeyUnavailableException
//     The request was rejected because the specified KMS key was not available.
//     You can retry the request.
//
//   - IncorrectKeyException
//     The request was rejected because the specified KMS key cannot decrypt the
//     data. The KeyId in a Decrypt request and the SourceKeyId in a ReEncrypt request
//     must identify the same KMS key that was used to encrypt the ciphertext.
//
//   - InvalidKeyUsageException
//     The request was rejected for one of the following reasons:
//
//   - The KeyUsage value of the KMS key is incompatible with the API operation.
//
//   - The encryption algorithm or signing algorithm specified for the operation
//     is incompatible with the type of key material in the KMS key (KeySpec).
//
//     For encrypting, decrypting, re-encrypting, and generating data keys, the
//     KeyUsage must be ENCRYPT_DECRYPT. For signing and verifying messages, the
//     KeyUsage must be SIGN_VERIFY. For generating and verifying message authentication
//     codes (MACs), the KeyUsage must be GENERATE_VERIFY_MAC. To find the KeyUsage
//     of a KMS key, use the DescribeKey operation.
//
//     To find the encryption or signing algorithms supported for a particular KMS
//     key, use the DescribeKey operation.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InvalidGrantTokenException
//     The request was rejected because the specified grant token is not valid.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/Decrypt
func (c *KMS) Decrypt(input *DecryptInput) (*DecryptOutput, error) {
	req, out := c.DecryptRequest(input)
	return out, req.Send()
}

// DecryptWithContext is the same as Decrypt with the addition of
// the ability to pass a context and additional request options.
//
// See Decrypt for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DecryptWithContext(ctx aws.Context, input *DecryptInput, opts ...request.Option) (*DecryptOutput, error) {
	req, out := c.DecryptRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAlias = "DeleteAlias"

// DeleteAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAlias for more information on using the DeleteAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAliasRequest method.
//	req, resp := client.DeleteAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DeleteAlias
func (c *KMS) DeleteAliasRequest(input *DeleteAliasInput) (req *request.Request, output *DeleteAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAliasInput{}
	}

	output = &DeleteAliasOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAlias API operation for AWS Key Management Service.
//
// Deletes the specified alias.
//
// Adding, deleting, or updating an alias can allow or deny permission to the
// KMS key. For details, see ABAC for KMS (https://docs.aws.amazon.com/kms/latest/developerguide/abac.html)
// in the Key Management Service Developer Guide.
//
// Because an alias is not a property of a KMS key, you can delete and change
// the aliases of a KMS key without affecting the KMS key. Also, aliases do
// not appear in the response from the DescribeKey operation. To get the aliases
// of all KMS keys, use the ListAliases operation.
//
// Each KMS key can have multiple aliases. To change the alias of a KMS key,
// use DeleteAlias to delete the current alias and CreateAlias to create a new
// alias. To associate an existing alias with a different KMS key, call UpdateAlias.
//
// Cross-account use: No. You cannot perform this operation on an alias in a
// different Amazon Web Services account.
//
// Required permissions
//
//   - kms:DeleteAlias (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
//     on the alias (IAM policy).
//
//   - kms:DeleteAlias (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
//     on the KMS key (key policy).
//
// For details, see Controlling access to aliases (https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html#alias-access)
// in the Key Management Service Developer Guide.
//
// Related operations:
//
//   - CreateAlias
//
//   - ListAliases
//
//   - UpdateAlias
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation DeleteAlias for usage and error information.
//
// Returned Error Types:
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DeleteAlias
func (c *KMS) DeleteAlias(input *DeleteAliasInput) (*DeleteAliasOutput, error) {
	req, out := c.DeleteAliasRequest(input)
	return out, req.Send()
}

// DeleteAliasWithContext is the same as DeleteAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DeleteAliasWithContext(ctx aws.Context, input *DeleteAliasInput, opts ...request.Option) (*DeleteAliasOutput, error) {
	req, out := c.DeleteAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCustomKeyStore = "DeleteCustomKeyStore"

// DeleteCustomKeyStoreRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCustomKeyStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCustomKeyStore for more information on using the DeleteCustomKeyStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCustomKeyStoreRequest method.
//	req, resp := client.DeleteCustomKeyStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DeleteCustomKeyStore
func (c *KMS) DeleteCustomKeyStoreRequest(input *DeleteCustomKeyStoreInput) (req *request.Request, output *DeleteCustomKeyStoreOutput) {
	op := &request.Operation{
		Name:       opDeleteCustomKeyStore,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCustomKeyStoreInput{}
	}

	output = &DeleteCustomKeyStoreOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCustomKeyStore API operation for AWS Key Management Service.
//
// Deletes a custom key store (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html).
// This operation does not affect any backing elements of the custom key store.
// It does not delete the CloudHSM cluster that is associated with an CloudHSM
// key store, or affect any users or keys in the cluster. For an external key
// store, it does not affect the external key store proxy, external key manager,
// or any external keys.
//
// This operation is part of the custom key stores (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
// feature in KMS, which combines the convenience and extensive integration
// of KMS with the isolation and control of a key store that you own and manage.
//
// The custom key store that you delete cannot contain any KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms_keys).
// Before deleting the key store, verify that you will never need to use any
// of the KMS keys in the key store for any cryptographic operations (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations).
// Then, use ScheduleKeyDeletion to delete the KMS keys from the key store.
// After the required waiting period expires and all KMS keys are deleted from
// the custom key store, use DisconnectCustomKeyStore to disconnect the key
// store from KMS. Then, you can delete the custom key store.
//
// For keys in an CloudHSM key store, the ScheduleKeyDeletion operation makes
// a best effort to delete the key material from the associated cluster. However,
// you might need to manually delete the orphaned key material (https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-orphaned-key)
// from the cluster and its backups. KMS never creates, manages, or deletes
// cryptographic keys in the external key manager associated with an external
// key store. You must manage them using your external key manager tools.
//
// Instead of deleting the custom key store, consider using the DisconnectCustomKeyStore
// operation to disconnect the custom key store from its backing key store.
// While the key store is disconnected, you cannot create or use the KMS keys
// in the key store. But, you do not need to delete KMS keys and you can reconnect
// a disconnected custom key store at any time.
//
// If the operation succeeds, it returns a JSON object with no properties.
//
// Cross-account use: No. You cannot perform this operation on a custom key
// store in a different Amazon Web Services account.
//
// Required permissions: kms:DeleteCustomKeyStore (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (IAM policy)
//
// Related operations:
//
//   - ConnectCustomKeyStore
//
//   - CreateCustomKeyStore
//
//   - DescribeCustomKeyStores
//
//   - DisconnectCustomKeyStore
//
//   - UpdateCustomKeyStore
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation DeleteCustomKeyStore for usage and error information.
//
// Returned Error Types:
//
//   - CustomKeyStoreHasCMKsException
//     The request was rejected because the custom key store contains KMS keys.
//     After verifying that you do not need to use the KMS keys, use the ScheduleKeyDeletion
//     operation to delete the KMS keys. After they are deleted, you can delete
//     the custom key store.
//
//   - CustomKeyStoreInvalidStateException
//     The request was rejected because of the ConnectionState of the custom key
//     store. To get the ConnectionState of a custom key store, use the DescribeCustomKeyStores
//     operation.
//
//     This exception is thrown under the following conditions:
//
//   - You requested the ConnectCustomKeyStore operation on a custom key store
//     with a ConnectionState of DISCONNECTING or FAILED. This operation is valid
//     for all other ConnectionState values. To reconnect a custom key store
//     in a FAILED state, disconnect it (DisconnectCustomKeyStore), then connect
//     it (ConnectCustomKeyStore).
//
//   - You requested the CreateKey operation in a custom key store that is
//     not connected. This operations is valid only when the custom key store
//     ConnectionState is CONNECTED.
//
//   - You requested the DisconnectCustomKeyStore operation on a custom key
//     store with a ConnectionState of DISCONNECTING or DISCONNECTED. This operation
//     is valid for all other ConnectionState values.
//
//   - You requested the UpdateCustomKeyStore or DeleteCustomKeyStore operation
//     on a custom key store that is not disconnected. This operation is valid
//     only when the custom key store ConnectionState is DISCONNECTED.
//
//   - You requested the GenerateRandom operation in an CloudHSM key store
//     that is not connected. This operation is valid only when the CloudHSM
//     key store ConnectionState is CONNECTED.
//
//   - CustomKeyStoreNotFoundException
//     The request was rejected because KMS cannot find a custom key store with
//     the specified key store name or ID.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DeleteCustomKeyStore
func (c *KMS) DeleteCustomKeyStore(input *DeleteCustomKeyStoreInput) (*DeleteCustomKeyStoreOutput, error) {
	req, out := c.DeleteCustomKeyStoreRequest(input)
	return out, req.Send()
}

// DeleteCustomKeyStoreWithContext is the same as DeleteCustomKeyStore with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCustomKeyStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DeleteCustomKeyStoreWithContext(ctx aws.Context, input *DeleteCustomKeyStoreInput, opts ...request.Option) (*DeleteCustomKeyStoreOutput, error) {
	req, out := c.DeleteCustomKeyStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteImportedKeyMaterial = "DeleteImportedKeyMaterial"

// DeleteImportedKeyMaterialRequest generates a "aws/request.Request" representing the
// client's request for the DeleteImportedKeyMaterial operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteImportedKeyMaterial for more information on using the DeleteImportedKeyMaterial
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteImportedKeyMaterialRequest method.
//	req, resp := client.DeleteImportedKeyMaterialRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DeleteImportedKeyMaterial
func (c *KMS) DeleteImportedKeyMaterialRequest(input *DeleteImportedKeyMaterialInput) (req *request.Request, output *DeleteImportedKeyMaterialOutput) {
	op := &request.Operation{
		Name:       opDeleteImportedKeyMaterial,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteImportedKeyMaterialInput{}
	}

	output = &DeleteImportedKeyMaterialOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteImportedKeyMaterial API operation for AWS Key Management Service.
//
// Deletes key material that you previously imported. This operation makes the
// specified KMS key unusable. For more information about importing key material
// into KMS, see Importing Key Material (https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html)
// in the Key Management Service Developer Guide.
//
// When the specified KMS key is in the PendingDeletion state, this operation
// does not change the KMS key's state. Otherwise, it changes the KMS key's
// state to PendingImport.
//
// After you delete key material, you can use ImportKeyMaterial to reimport
// the same key material into the KMS key.
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: No. You cannot perform this operation on a KMS key in
// a different Amazon Web Services account.
//
// Required permissions: kms:DeleteImportedKeyMaterial (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations:
//
//   - GetParametersForImport
//
//   - ImportKeyMaterial
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation DeleteImportedKeyMaterial for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - UnsupportedOperationException
//     The request was rejected because a specified parameter is not supported or
//     a specified resource is not valid for this operation.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DeleteImportedKeyMaterial
func (c *KMS) DeleteImportedKeyMaterial(input *DeleteImportedKeyMaterialInput) (*DeleteImportedKeyMaterialOutput, error) {
	req, out := c.DeleteImportedKeyMaterialRequest(input)
	return out, req.Send()
}

// DeleteImportedKeyMaterialWithContext is the same as DeleteImportedKeyMaterial with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteImportedKeyMaterial for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DeleteImportedKeyMaterialWithContext(ctx aws.Context, input *DeleteImportedKeyMaterialInput, opts ...request.Option) (*DeleteImportedKeyMaterialOutput, error) {
	req, out := c.DeleteImportedKeyMaterialRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCustomKeyStores = "DescribeCustomKeyStores"

// DescribeCustomKeyStoresRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCustomKeyStores operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCustomKeyStores for more information on using the DescribeCustomKeyStores
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeCustomKeyStoresRequest method.
//	req, resp := client.DescribeCustomKeyStoresRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DescribeCustomKeyStores
func (c *KMS) DescribeCustomKeyStoresRequest(input *DescribeCustomKeyStoresInput) (req *request.Request, output *DescribeCustomKeyStoresOutput) {
	op := &request.Operation{
		Name:       opDescribeCustomKeyStores,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCustomKeyStoresInput{}
	}

	output = &DescribeCustomKeyStoresOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCustomKeyStores API operation for AWS Key Management Service.
//
// Gets information about custom key stores (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
// in the account and Region.
//
// This operation is part of the custom key stores (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
// feature in KMS, which combines the convenience and extensive integration
// of KMS with the isolation and control of a key store that you own and manage.
//
// By default, this operation returns information about all custom key stores
// in the account and Region. To get only information about a particular custom
// key store, use either the CustomKeyStoreName or CustomKeyStoreId parameter
// (but not both).
//
// To determine whether the custom key store is connected to its CloudHSM cluster
// or external key store proxy, use the ConnectionState element in the response.
// If an attempt to connect the custom key store failed, the ConnectionState
// value is FAILED and the ConnectionErrorCode element in the response indicates
// the cause of the failure. For help interpreting the ConnectionErrorCode,
// see CustomKeyStoresListEntry.
//
// Custom key stores have a DISCONNECTED connection state if the key store has
// never been connected or you used the DisconnectCustomKeyStore operation to
// disconnect it. Otherwise, the connection state is CONNECTED. If your custom
// key store connection state is CONNECTED but you are having trouble using
// it, verify that the backing store is active and available. For an CloudHSM
// key store, verify that the associated CloudHSM cluster is active and contains
// the minimum number of HSMs required for the operation, if any. For an external
// key store, verify that the external key store proxy and its associated external
// key manager are reachable and enabled.
//
// For help repairing your CloudHSM key store, see the Troubleshooting CloudHSM
// key stores (https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html).
// For help repairing your external key store, see the Troubleshooting external
// key stores (https://docs.aws.amazon.com/kms/latest/developerguide/xks-troubleshooting.html).
// Both topics are in the Key Management Service Developer Guide.
//
// Cross-account use: No. You cannot perform this operation on a custom key
// store in a different Amazon Web Services account.
//
// Required permissions: kms:DescribeCustomKeyStores (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (IAM policy)
//
// Related operations:
//
//   - ConnectCustomKeyStore
//
//   - CreateCustomKeyStore
//
//   - DeleteCustomKeyStore
//
//   - DisconnectCustomKeyStore
//
//   - UpdateCustomKeyStore
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation DescribeCustomKeyStores for usage and error information.
//
// Returned Error Types:
//
//   - CustomKeyStoreNotFoundException
//     The request was rejected because KMS cannot find a custom key store with
//     the specified key store name or ID.
//
//   - InvalidMarkerException
//     The request was rejected because the marker that specifies where pagination
//     should next begin is not valid.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DescribeCustomKeyStores
func (c *KMS) DescribeCustomKeyStores(input *DescribeCustomKeyStoresInput) (*DescribeCustomKeyStoresOutput, error) {
	req, out := c.DescribeCustomKeyStoresRequest(input)
	return out, req.Send()
}

// DescribeCustomKeyStoresWithContext is the same as DescribeCustomKeyStores with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCustomKeyStores for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DescribeCustomKeyStoresWithContext(ctx aws.Context, input *DescribeCustomKeyStoresInput, opts ...request.Option) (*DescribeCustomKeyStoresOutput, error) {
	req, out := c.DescribeCustomKeyStoresRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeCustomKeyStoresPages iterates over the pages of a DescribeCustomKeyStores operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCustomKeyStores method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeCustomKeyStores operation.
//	pageNum := 0
//	err := client.DescribeCustomKeyStoresPages(params,
//	    func(page *kms.DescribeCustomKeyStoresOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *KMS) DescribeCustomKeyStoresPages(input *DescribeCustomKeyStoresInput, fn func(*DescribeCustomKeyStoresOutput, bool) bool) error {
	return c.DescribeCustomKeyStoresPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeCustomKeyStoresPagesWithContext same as DescribeCustomKeyStoresPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DescribeCustomKeyStoresPagesWithContext(ctx aws.Context, input *DescribeCustomKeyStoresInput, fn func(*DescribeCustomKeyStoresOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeCustomKeyStoresInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeCustomKeyStoresRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeCustomKeyStoresOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeKey = "DescribeKey"

// DescribeKeyRequest generates a "aws/request.Request" representing the
// client's request for the DescribeKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeKey for more information on using the DescribeKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeKeyRequest method.
//	req, resp := client.DescribeKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DescribeKey
func (c *KMS) DescribeKeyRequest(input *DescribeKeyInput) (req *request.Request, output *DescribeKeyOutput) {
	op := &request.Operation{
		Name:       opDescribeKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeKeyInput{}
	}

	output = &DescribeKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeKey API operation for AWS Key Management Service.
//
// Provides detailed information about a KMS key. You can run DescribeKey on
// a customer managed key (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk)
// or an Amazon Web Services managed key (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk).
//
// This detailed information includes the key ARN, creation date (and deletion
// date, if applicable), the key state, and the origin and expiration date (if
// any) of the key material. It includes fields, like KeySpec, that help you
// distinguish different types of KMS keys. It also displays the key usage (encryption,
// signing, or generating and verifying MACs) and the algorithms that the KMS
// key supports.
//
// For multi-Region keys (kms/latest/developerguide/multi-region-keys-overview.html),
// DescribeKey displays the primary key and all related replica keys. For KMS
// keys in CloudHSM key stores (kms/latest/developerguide/keystore-cloudhsm.html),
// it includes information about the key store, such as the key store ID and
// the CloudHSM cluster ID. For KMS keys in external key stores (kms/latest/developerguide/keystore-external.html),
// it includes the custom key store ID and the ID of the external key.
//
// DescribeKey does not return the following information:
//
//   - Aliases associated with the KMS key. To get this information, use ListAliases.
//
//   - Whether automatic key rotation is enabled on the KMS key. To get this
//     information, use GetKeyRotationStatus. Also, some key states prevent a
//     KMS key from being automatically rotated. For details, see How Automatic
//     Key Rotation Works (https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html#rotate-keys-how-it-works)
//     in the Key Management Service Developer Guide.
//
//   - Tags on the KMS key. To get this information, use ListResourceTags.
//
//   - Key policies and grants on the KMS key. To get this information, use
//     GetKeyPolicy and ListGrants.
//
// In general, DescribeKey is a non-mutating operation. It returns data about
// KMS keys, but doesn't change them. However, Amazon Web Services services
// use DescribeKey to create Amazon Web Services managed keys (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk)
// from a predefined Amazon Web Services alias with no key ID.
//
// Cross-account use: Yes. To perform this operation with a KMS key in a different
// Amazon Web Services account, specify the key ARN or alias ARN in the value
// of the KeyId parameter.
//
// Required permissions: kms:DescribeKey (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations:
//
//   - GetKeyPolicy
//
//   - GetKeyRotationStatus
//
//   - ListAliases
//
//   - ListGrants
//
//   - ListKeys
//
//   - ListResourceTags
//
//   - ListRetirableGrants
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation DescribeKey for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DescribeKey
func (c *KMS) DescribeKey(input *DescribeKeyInput) (*DescribeKeyOutput, error) {
	req, out := c.DescribeKeyRequest(input)
	return out, req.Send()
}

// DescribeKeyWithContext is the same as DescribeKey with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DescribeKeyWithContext(ctx aws.Context, input *DescribeKeyInput, opts ...request.Option) (*DescribeKeyOutput, error) {
	req, out := c.DescribeKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableKey = "DisableKey"

// DisableKeyRequest generates a "aws/request.Request" representing the
// client's request for the DisableKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableKey for more information on using the DisableKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisableKeyRequest method.
//	req, resp := client.DisableKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DisableKey
func (c *KMS) DisableKeyRequest(input *DisableKeyInput) (req *request.Request, output *DisableKeyOutput) {
	op := &request.Operation{
		Name:       opDisableKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableKeyInput{}
	}

	output = &DisableKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableKey API operation for AWS Key Management Service.
//
// Sets the state of a KMS key to disabled. This change temporarily prevents
// use of the KMS key for cryptographic operations (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations).
//
// For more information about how key state affects the use of a KMS key, see
// Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide .
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: No. You cannot perform this operation on a KMS key in
// a different Amazon Web Services account.
//
// Required permissions: kms:DisableKey (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations: EnableKey
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation DisableKey for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DisableKey
func (c *KMS) DisableKey(input *DisableKeyInput) (*DisableKeyOutput, error) {
	req, out := c.DisableKeyRequest(input)
	return out, req.Send()
}

// DisableKeyWithContext is the same as DisableKey with the addition of
// the ability to pass a context and additional request options.
//
// See DisableKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DisableKeyWithContext(ctx aws.Context, input *DisableKeyInput, opts ...request.Option) (*DisableKeyOutput, error) {
	req, out := c.DisableKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableKeyRotation = "DisableKeyRotation"

// DisableKeyRotationRequest generates a "aws/request.Request" representing the
// client's request for the DisableKeyRotation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableKeyRotation for more information on using the DisableKeyRotation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisableKeyRotationRequest method.
//	req, resp := client.DisableKeyRotationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DisableKeyRotation
func (c *KMS) DisableKeyRotationRequest(input *DisableKeyRotationInput) (req *request.Request, output *DisableKeyRotationOutput) {
	op := &request.Operation{
		Name:       opDisableKeyRotation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableKeyRotationInput{}
	}

	output = &DisableKeyRotationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableKeyRotation API operation for AWS Key Management Service.
//
// Disables automatic rotation of the key material (https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html)
// of the specified symmetric encryption KMS key.
//
// Automatic key rotation is supported only on symmetric encryption KMS keys.
// You cannot enable automatic rotation of asymmetric KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html),
// HMAC KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html),
// KMS keys with imported key material (https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html),
// or KMS keys in a custom key store (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html).
// To enable or disable automatic rotation of a set of related multi-Region
// keys (https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-manage.html#multi-region-rotate),
// set the property on the primary key.
//
// You can enable (EnableKeyRotation) and disable automatic rotation of the
// key material in customer managed KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk).
// Key material rotation of Amazon Web Services managed KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk)
// is not configurable. KMS always rotates the key material for every year.
// Rotation of Amazon Web Services owned KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-owned-cmk)
// varies.
//
// In May 2022, KMS changed the rotation schedule for Amazon Web Services managed
// keys from every three years to every year. For details, see EnableKeyRotation.
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: No. You cannot perform this operation on a KMS key in
// a different Amazon Web Services account.
//
// Required permissions: kms:DisableKeyRotation (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations:
//
//   - EnableKeyRotation
//
//   - GetKeyRotationStatus
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation DisableKeyRotation for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - DisabledException
//     The request was rejected because the specified KMS key is not enabled.
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
//   - UnsupportedOperationException
//     The request was rejected because a specified parameter is not supported or
//     a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DisableKeyRotation
func (c *KMS) DisableKeyRotation(input *DisableKeyRotationInput) (*DisableKeyRotationOutput, error) {
	req, out := c.DisableKeyRotationRequest(input)
	return out, req.Send()
}

// DisableKeyRotationWithContext is the same as DisableKeyRotation with the addition of
// the ability to pass a context and additional request options.
//
// See DisableKeyRotation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DisableKeyRotationWithContext(ctx aws.Context, input *DisableKeyRotationInput, opts ...request.Option) (*DisableKeyRotationOutput, error) {
	req, out := c.DisableKeyRotationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisconnectCustomKeyStore = "DisconnectCustomKeyStore"

// DisconnectCustomKeyStoreRequest generates a "aws/request.Request" representing the
// client's request for the DisconnectCustomKeyStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisconnectCustomKeyStore for more information on using the DisconnectCustomKeyStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisconnectCustomKeyStoreRequest method.
//	req, resp := client.DisconnectCustomKeyStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DisconnectCustomKeyStore
func (c *KMS) DisconnectCustomKeyStoreRequest(input *DisconnectCustomKeyStoreInput) (req *request.Request, output *DisconnectCustomKeyStoreOutput) {
	op := &request.Operation{
		Name:       opDisconnectCustomKeyStore,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisconnectCustomKeyStoreInput{}
	}

	output = &DisconnectCustomKeyStoreOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisconnectCustomKeyStore API operation for AWS Key Management Service.
//
// Disconnects the custom key store (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
// from its backing key store. This operation disconnects an CloudHSM key store
// from its associated CloudHSM cluster or disconnects an external key store
// from the external key store proxy that communicates with your external key
// manager.
//
// This operation is part of the custom key stores (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
// feature in KMS, which combines the convenience and extensive integration
// of KMS with the isolation and control of a key store that you own and manage.
//
// While a custom key store is disconnected, you can manage the custom key store
// and its KMS keys, but you cannot create or use its KMS keys. You can reconnect
// the custom key store at any time.
//
// While a custom key store is disconnected, all attempts to create KMS keys
// in the custom key store or to use existing KMS keys in cryptographic operations
// (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
// will fail. This action can prevent users from storing and accessing sensitive
// data.
//
// When you disconnect a custom key store, its ConnectionState changes to Disconnected.
// To find the connection state of a custom key store, use the DescribeCustomKeyStores
// operation. To reconnect a custom key store, use the ConnectCustomKeyStore
// operation.
//
// If the operation succeeds, it returns a JSON object with no properties.
//
// Cross-account use: No. You cannot perform this operation on a custom key
// store in a different Amazon Web Services account.
//
// Required permissions: kms:DisconnectCustomKeyStore (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (IAM policy)
//
// Related operations:
//
//   - ConnectCustomKeyStore
//
//   - CreateCustomKeyStore
//
//   - DeleteCustomKeyStore
//
//   - DescribeCustomKeyStores
//
//   - UpdateCustomKeyStore
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation DisconnectCustomKeyStore for usage and error information.
//
// Returned Error Types:
//
//   - CustomKeyStoreInvalidStateException
//     The request was rejected because of the ConnectionState of the custom key
//     store. To get the ConnectionState of a custom key store, use the DescribeCustomKeyStores
//     operation.
//
//     This exception is thrown under the following conditions:
//
//   - You requested the ConnectCustomKeyStore operation on a custom key store
//     with a ConnectionState of DISCONNECTING or FAILED. This operation is valid
//     for all other ConnectionState values. To reconnect a custom key store
//     in a FAILED state, disconnect it (DisconnectCustomKeyStore), then connect
//     it (ConnectCustomKeyStore).
//
//   - You requested the CreateKey operation in a custom key store that is
//     not connected. This operations is valid only when the custom key store
//     ConnectionState is CONNECTED.
//
//   - You requested the DisconnectCustomKeyStore operation on a custom key
//     store with a ConnectionState of DISCONNECTING or DISCONNECTED. This operation
//     is valid for all other ConnectionState values.
//
//   - You requested the UpdateCustomKeyStore or DeleteCustomKeyStore operation
//     on a custom key store that is not disconnected. This operation is valid
//     only when the custom key store ConnectionState is DISCONNECTED.
//
//   - You requested the GenerateRandom operation in an CloudHSM key store
//     that is not connected. This operation is valid only when the CloudHSM
//     key store ConnectionState is CONNECTED.
//
//   - CustomKeyStoreNotFoundException
//     The request was rejected because KMS cannot find a custom key store with
//     the specified key store name or ID.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DisconnectCustomKeyStore
func (c *KMS) DisconnectCustomKeyStore(input *DisconnectCustomKeyStoreInput) (*DisconnectCustomKeyStoreOutput, error) {
	req, out := c.DisconnectCustomKeyStoreRequest(input)
	return out, req.Send()
}

// DisconnectCustomKeyStoreWithContext is the same as DisconnectCustomKeyStore with the addition of
// the ability to pass a context and additional request options.
//
// See DisconnectCustomKeyStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DisconnectCustomKeyStoreWithContext(ctx aws.Context, input *DisconnectCustomKeyStoreInput, opts ...request.Option) (*DisconnectCustomKeyStoreOutput, error) {
	req, out := c.DisconnectCustomKeyStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableKey = "EnableKey"

// EnableKeyRequest generates a "aws/request.Request" representing the
// client's request for the EnableKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableKey for more information on using the EnableKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the EnableKeyRequest method.
//	req, resp := client.EnableKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/EnableKey
func (c *KMS) EnableKeyRequest(input *EnableKeyInput) (req *request.Request, output *EnableKeyOutput) {
	op := &request.Operation{
		Name:       opEnableKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableKeyInput{}
	}

	output = &EnableKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableKey API operation for AWS Key Management Service.
//
// Sets the key state of a KMS key to enabled. This allows you to use the KMS
// key for cryptographic operations (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations).
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: No. You cannot perform this operation on a KMS key in
// a different Amazon Web Services account.
//
// Required permissions: kms:EnableKey (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations: DisableKey
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation EnableKey for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - LimitExceededException
//     The request was rejected because a quota was exceeded. For more information,
//     see Quotas (https://docs.aws.amazon.com/kms/latest/developerguide/limits.html)
//     in the Key Management Service Developer Guide.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/EnableKey
func (c *KMS) EnableKey(input *EnableKeyInput) (*EnableKeyOutput, error) {
	req, out := c.EnableKeyRequest(input)
	return out, req.Send()
}

// EnableKeyWithContext is the same as EnableKey with the addition of
// the ability to pass a context and additional request options.
//
// See EnableKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) EnableKeyWithContext(ctx aws.Context, input *EnableKeyInput, opts ...request.Option) (*EnableKeyOutput, error) {
	req, out := c.EnableKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableKeyRotation = "EnableKeyRotation"

// EnableKeyRotationRequest generates a "aws/request.Request" representing the
// client's request for the EnableKeyRotation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableKeyRotation for more information on using the EnableKeyRotation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the EnableKeyRotationRequest method.
//	req, resp := client.EnableKeyRotationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/EnableKeyRotation
func (c *KMS) EnableKeyRotationRequest(input *EnableKeyRotationInput) (req *request.Request, output *EnableKeyRotationOutput) {
	op := &request.Operation{
		Name:       opEnableKeyRotation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableKeyRotationInput{}
	}

	output = &EnableKeyRotationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableKeyRotation API operation for AWS Key Management Service.
//
// Enables automatic rotation of the key material (https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html)
// of the specified symmetric encryption KMS key.
//
// When you enable automatic rotation of acustomer managed KMS key (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk),
// KMS rotates the key material of the KMS key one year (approximately 365 days)
// from the enable date and every year thereafter. You can monitor rotation
// of the key material for your KMS keys in CloudTrail and Amazon CloudWatch.
// To disable rotation of the key material in a customer managed KMS key, use
// the DisableKeyRotation operation.
//
// Automatic key rotation is supported only on symmetric encryption KMS keys
// (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#symmetric-cmks).
// You cannot enable automatic rotation of asymmetric KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html),
// HMAC KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html),
// KMS keys with imported key material (https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html),
// or KMS keys in a custom key store (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html).
// To enable or disable automatic rotation of a set of related multi-Region
// keys (https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-manage.html#multi-region-rotate),
// set the property on the primary key.
//
// You cannot enable or disable automatic rotation Amazon Web Services managed
// KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk).
// KMS always rotates the key material of Amazon Web Services managed keys every
// year. Rotation of Amazon Web Services owned KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-owned-cmk)
// varies.
//
// In May 2022, KMS changed the rotation schedule for Amazon Web Services managed
// keys from every three years (approximately 1,095 days) to every year (approximately
// 365 days).
//
// New Amazon Web Services managed keys are automatically rotated one year after
// they are created, and approximately every year thereafter.
//
// Existing Amazon Web Services managed keys are automatically rotated one year
// after their most recent rotation, and every year thereafter.
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: No. You cannot perform this operation on a KMS key in
// a different Amazon Web Services account.
//
// Required permissions: kms:EnableKeyRotation (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations:
//
//   - DisableKeyRotation
//
//   - GetKeyRotationStatus
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation EnableKeyRotation for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - DisabledException
//     The request was rejected because the specified KMS key is not enabled.
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
//   - UnsupportedOperationException
//     The request was rejected because a specified parameter is not supported or
//     a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/EnableKeyRotation
func (c *KMS) EnableKeyRotation(input *EnableKeyRotationInput) (*EnableKeyRotationOutput, error) {
	req, out := c.EnableKeyRotationRequest(input)
	return out, req.Send()
}

// EnableKeyRotationWithContext is the same as EnableKeyRotation with the addition of
// the ability to pass a context and additional request options.
//
// See EnableKeyRotation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) EnableKeyRotationWithContext(ctx aws.Context, input *EnableKeyRotationInput, opts ...request.Option) (*EnableKeyRotationOutput, error) {
	req, out := c.EnableKeyRotationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEncrypt = "Encrypt"

// EncryptRequest generates a "aws/request.Request" representing the
// client's request for the Encrypt operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Encrypt for more information on using the Encrypt
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the EncryptRequest method.
//	req, resp := client.EncryptRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/Encrypt
func (c *KMS) EncryptRequest(input *EncryptInput) (req *request.Request, output *EncryptOutput) {
	op := &request.Operation{
		Name:       opEncrypt,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EncryptInput{}
	}

	output = &EncryptOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Encrypt API operation for AWS Key Management Service.
//
// Encrypts plaintext of up to 4,096 bytes using a KMS key. You can use a symmetric
// or asymmetric KMS key with a KeyUsage of ENCRYPT_DECRYPT.
//
// You can use this operation to encrypt small amounts of arbitrary data, such
// as a personal identifier or database password, or other sensitive information.
// You don't need to use the Encrypt operation to encrypt a data key. The GenerateDataKey
// and GenerateDataKeyPair operations return a plaintext data key and an encrypted
// copy of that data key.
//
// If you use a symmetric encryption KMS key, you can use an encryption context
// to add additional security to your encryption operation. If you specify an
// EncryptionContext when encrypting data, you must specify the same encryption
// context (a case-sensitive exact match) when decrypting the data. Otherwise,
// the request to decrypt fails with an InvalidCiphertextException. For more
// information, see Encryption Context (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
// in the Key Management Service Developer Guide.
//
// If you specify an asymmetric KMS key, you must also specify the encryption
// algorithm. The algorithm must be compatible with the KMS key spec.
//
// When you use an asymmetric KMS key to encrypt or reencrypt data, be sure
// to record the KMS key and encryption algorithm that you choose. You will
// be required to provide the same KMS key and encryption algorithm when you
// decrypt the data. If the KMS key and algorithm do not match the values used
// to encrypt the data, the decrypt operation fails.
//
// You are not required to supply the key ID and encryption algorithm when you
// decrypt with symmetric encryption KMS keys because KMS stores this information
// in the ciphertext blob. KMS cannot store metadata in ciphertext generated
// with asymmetric keys. The standard format for asymmetric key ciphertext does
// not include configurable fields.
//
// The maximum size of the data that you can encrypt varies with the type of
// KMS key and the encryption algorithm that you choose.
//
//   - Symmetric encryption KMS keys SYMMETRIC_DEFAULT: 4096 bytes
//
//   - RSA_2048 RSAES_OAEP_SHA_1: 214 bytes RSAES_OAEP_SHA_256: 190 bytes
//
//   - RSA_3072 RSAES_OAEP_SHA_1: 342 bytes RSAES_OAEP_SHA_256: 318 bytes
//
//   - RSA_4096 RSAES_OAEP_SHA_1: 470 bytes RSAES_OAEP_SHA_256: 446 bytes
//
//   - SM2PKE: 1024 bytes (China Regions only)
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: Yes. To perform this operation with a KMS key in a different
// Amazon Web Services account, specify the key ARN or alias ARN in the value
// of the KeyId parameter.
//
// Required permissions: kms:Encrypt (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations:
//
//   - Decrypt
//
//   - GenerateDataKey
//
//   - GenerateDataKeyPair
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation Encrypt for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - DisabledException
//     The request was rejected because the specified KMS key is not enabled.
//
//   - KeyUnavailableException
//     The request was rejected because the specified KMS key was not available.
//     You can retry the request.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InvalidKeyUsageException
//     The request was rejected for one of the following reasons:
//
//   - The KeyUsage value of the KMS key is incompatible with the API operation.
//
//   - The encryption algorithm or signing algorithm specified for the operation
//     is incompatible with the type of key material in the KMS key (KeySpec).
//
//     For encrypting, decrypting, re-encrypting, and generating data keys, the
//     KeyUsage must be ENCRYPT_DECRYPT. For signing and verifying messages, the
//     KeyUsage must be SIGN_VERIFY. For generating and verifying message authentication
//     codes (MACs), the KeyUsage must be GENERATE_VERIFY_MAC. To find the KeyUsage
//     of a KMS key, use the DescribeKey operation.
//
//     To find the encryption or signing algorithms supported for a particular KMS
//     key, use the DescribeKey operation.
//
//   - InvalidGrantTokenException
//     The request was rejected because the specified grant token is not valid.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/Encrypt
func (c *KMS) Encrypt(input *EncryptInput) (*EncryptOutput, error) {
	req, out := c.EncryptRequest(input)
	return out, req.Send()
}

// EncryptWithContext is the same as Encrypt with the addition of
// the ability to pass a context and additional request options.
//
// See Encrypt for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) EncryptWithContext(ctx aws.Context, input *EncryptInput, opts ...request.Option) (*EncryptOutput, error) {
	req, out := c.EncryptRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGenerateDataKey = "GenerateDataKey"

// GenerateDataKeyRequest generates a "aws/request.Request" representing the
// client's request for the GenerateDataKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GenerateDataKey for more information on using the GenerateDataKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GenerateDataKeyRequest method.
//	req, resp := client.GenerateDataKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateDataKey
func (c *KMS) GenerateDataKeyRequest(input *GenerateDataKeyInput) (req *request.Request, output *GenerateDataKeyOutput) {
	op := &request.Operation{
		Name:       opGenerateDataKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GenerateDataKeyInput{}
	}

	output = &GenerateDataKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GenerateDataKey API operation for AWS Key Management Service.
//
// Returns a unique symmetric data key for use outside of KMS. This operation
// returns a plaintext copy of the data key and a copy that is encrypted under
// a symmetric encryption KMS key that you specify. The bytes in the plaintext
// key are random; they are not related to the caller or the KMS key. You can
// use the plaintext key to encrypt your data outside of KMS and store the encrypted
// data key with the encrypted data.
//
// To generate a data key, specify the symmetric encryption KMS key that will
// be used to encrypt the data key. You cannot use an asymmetric KMS key to
// encrypt data keys. To get the type of your KMS key, use the DescribeKey operation.
//
// You must also specify the length of the data key. Use either the KeySpec
// or NumberOfBytes parameters (but not both). For 128-bit and 256-bit data
// keys, use the KeySpec parameter.
//
// To generate an SM4 data key (China Regions only), specify a KeySpec value
// of AES_128 or NumberOfBytes value of 128. The symmetric encryption key used
// in China Regions to encrypt your data key is an SM4 encryption key.
//
// To get only an encrypted copy of the data key, use GenerateDataKeyWithoutPlaintext.
// To generate an asymmetric data key pair, use the GenerateDataKeyPair or GenerateDataKeyPairWithoutPlaintext
// operation. To get a cryptographically secure random byte string, use GenerateRandom.
//
// You can use an optional encryption context to add additional security to
// the encryption operation. If you specify an EncryptionContext, you must specify
// the same encryption context (a case-sensitive exact match) when decrypting
// the encrypted data key. Otherwise, the request to decrypt fails with an InvalidCiphertextException.
// For more information, see Encryption Context (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
// in the Key Management Service Developer Guide.
//
// Applications in Amazon Web Services Nitro Enclaves can call this operation
// by using the Amazon Web Services Nitro Enclaves Development Kit (https://github.com/aws/aws-nitro-enclaves-sdk-c).
// For information about the supporting parameters, see How Amazon Web Services
// Nitro Enclaves use KMS (https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html)
// in the Key Management Service Developer Guide.
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// # How to use your data key
//
// We recommend that you use the following pattern to encrypt data locally in
// your application. You can write your own code or use a client-side encryption
// library, such as the Amazon Web Services Encryption SDK (https://docs.aws.amazon.com/encryption-sdk/latest/developer-guide/),
// the Amazon DynamoDB Encryption Client (https://docs.aws.amazon.com/dynamodb-encryption-client/latest/devguide/),
// or Amazon S3 client-side encryption (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html)
// to do these tasks for you.
//
// To encrypt data outside of KMS:
//
// Use the GenerateDataKey operation to get a data key.
//
// Use the plaintext data key (in the Plaintext field of the response) to encrypt
// your data outside of KMS. Then erase the plaintext data key from memory.
//
// Store the encrypted data key (in the CiphertextBlob field of the response)
// with the encrypted data.
//
// To decrypt data outside of KMS:
//
// Use the Decrypt operation to decrypt the encrypted data key. The operation
// returns a plaintext copy of the data key.
//
// Use the plaintext data key to decrypt data outside of KMS, then erase the
// plaintext data key from memory.
//
// Cross-account use: Yes. To perform this operation with a KMS key in a different
// Amazon Web Services account, specify the key ARN or alias ARN in the value
// of the KeyId parameter.
//
// Required permissions: kms:GenerateDataKey (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations:
//
//   - Decrypt
//
//   - Encrypt
//
//   - GenerateDataKeyPair
//
//   - GenerateDataKeyPairWithoutPlaintext
//
//   - GenerateDataKeyWithoutPlaintext
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation GenerateDataKey for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - DisabledException
//     The request was rejected because the specified KMS key is not enabled.
//
//   - KeyUnavailableException
//     The request was rejected because the specified KMS key was not available.
//     You can retry the request.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InvalidKeyUsageException
//     The request was rejected for one of the following reasons:
//
//   - The KeyUsage value of the KMS key is incompatible with the API operation.
//
//   - The encryption algorithm or signing algorithm specified for the operation
//     is incompatible with the type of key material in the KMS key (KeySpec).
//
//     For encrypting, decrypting, re-encrypting, and generating data keys, the
//     KeyUsage must be ENCRYPT_DECRYPT. For signing and verifying messages, the
//     KeyUsage must be SIGN_VERIFY. For generating and verifying message authentication
//     codes (MACs), the KeyUsage must be GENERATE_VERIFY_MAC. To find the KeyUsage
//     of a KMS key, use the DescribeKey operation.
//
//     To find the encryption or signing algorithms supported for a particular KMS
//     key, use the DescribeKey operation.
//
//   - InvalidGrantTokenException
//     The request was rejected because the specified grant token is not valid.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateDataKey
func (c *KMS) GenerateDataKey(input *GenerateDataKeyInput) (*GenerateDataKeyOutput, error) {
	req, out := c.GenerateDataKeyRequest(input)
	return out, req.Send()
}

// GenerateDataKeyWithContext is the same as GenerateDataKey with the addition of
// the ability to pass a context and additional request options.
//
// See GenerateDataKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) GenerateDataKeyWithContext(ctx aws.Context, input *GenerateDataKeyInput, opts ...request.Option) (*GenerateDataKeyOutput, error) {
	req, out := c.GenerateDataKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGenerateDataKeyPair = "GenerateDataKeyPair"

// GenerateDataKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the GenerateDataKeyPair operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GenerateDataKeyPair for more information on using the GenerateDataKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GenerateDataKeyPairRequest method.
//	req, resp := client.GenerateDataKeyPairRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateDataKeyPair
func (c *KMS) GenerateDataKeyPairRequest(input *GenerateDataKeyPairInput) (req *request.Request, output *GenerateDataKeyPairOutput) {
	op := &request.Operation{
		Name:       opGenerateDataKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GenerateDataKeyPairInput{}
	}

	output = &GenerateDataKeyPairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GenerateDataKeyPair API operation for AWS Key Management Service.
//
// Returns a unique asymmetric data key pair for use outside of KMS. This operation
// returns a plaintext public key, a plaintext private key, and a copy of the
// private key that is encrypted under the symmetric encryption KMS key you
// specify. You can use the data key pair to perform asymmetric cryptography
// and implement digital signatures outside of KMS. The bytes in the keys are
// random; they not related to the caller or to the KMS key that is used to
// encrypt the private key.
//
// You can use the public key that GenerateDataKeyPair returns to encrypt data
// or verify a signature outside of KMS. Then, store the encrypted private key
// with the data. When you are ready to decrypt data or sign a message, you
// can use the Decrypt operation to decrypt the encrypted private key.
//
// To generate a data key pair, you must specify a symmetric encryption KMS
// key to encrypt the private key in a data key pair. You cannot use an asymmetric
// KMS key or a KMS key in a custom key store. To get the type and origin of
// your KMS key, use the DescribeKey operation.
//
// Use the KeyPairSpec parameter to choose an RSA or Elliptic Curve (ECC) data
// key pair. In China Regions, you can also choose an SM2 data key pair. KMS
// recommends that you use ECC key pairs for signing, and use RSA and SM2 key
// pairs for either encryption or signing, but not both. However, KMS cannot
// enforce any restrictions on the use of data key pairs outside of KMS.
//
// If you are using the data key pair to encrypt data, or for any operation
// where you don't immediately need a private key, consider using the GenerateDataKeyPairWithoutPlaintext
// operation. GenerateDataKeyPairWithoutPlaintext returns a plaintext public
// key and an encrypted private key, but omits the plaintext private key that
// you need only to decrypt ciphertext or sign a message. Later, when you need
// to decrypt the data or sign a message, use the Decrypt operation to decrypt
// the encrypted private key in the data key pair.
//
// GenerateDataKeyPair returns a unique data key pair for each request. The
// bytes in the keys are random; they are not related to the caller or the KMS
// key that is used to encrypt the private key. The public key is a DER-encoded
// X.509 SubjectPublicKeyInfo, as specified in RFC 5280 (https://tools.ietf.org/html/rfc5280).
// The private key is a DER-encoded PKCS8 PrivateKeyInfo, as specified in RFC
// 5958 (https://tools.ietf.org/html/rfc5958).
//
// You can use an optional encryption context to add additional security to
// the encryption operation. If you specify an EncryptionContext, you must specify
// the same encryption context (a case-sensitive exact match) when decrypting
// the encrypted data key. Otherwise, the request to decrypt fails with an InvalidCiphertextException.
// For more information, see Encryption Context (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
// in the Key Management Service Developer Guide.
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: Yes. To perform this operation with a KMS key in a different
// Amazon Web Services account, specify the key ARN or alias ARN in the value
// of the KeyId parameter.
//
// Required permissions: kms:GenerateDataKeyPair (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations:
//
//   - Decrypt
//
//   - Encrypt
//
//   - GenerateDataKey
//
//   - GenerateDataKeyPairWithoutPlaintext
//
//   - GenerateDataKeyWithoutPlaintext
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation GenerateDataKeyPair for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - DisabledException
//     The request was rejected because the specified KMS key is not enabled.
//
//   - KeyUnavailableException
//     The request was rejected because the specified KMS key was not available.
//     You can retry the request.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InvalidKeyUsageException
//     The request was rejected for one of the following reasons:
//
//   - The KeyUsage value of the KMS key is incompatible with the API operation.
//
//   - The encryption algorithm or signing algorithm specified for the operation
//     is incompatible with the type of key material in the KMS key (KeySpec).
//
//     For encrypting, decrypting, re-encrypting, and generating data keys, the
//     KeyUsage must be ENCRYPT_DECRYPT. For signing and verifying messages, the
//     KeyUsage must be SIGN_VERIFY. For generating and verifying message authentication
//     codes (MACs), the KeyUsage must be GENERATE_VERIFY_MAC. To find the KeyUsage
//     of a KMS key, use the DescribeKey operation.
//
//     To find the encryption or signing algorithms supported for a particular KMS
//     key, use the DescribeKey operation.
//
//   - InvalidGrantTokenException
//     The request was rejected because the specified grant token is not valid.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
//   - UnsupportedOperationException
//     The request was rejected because a specified parameter is not supported or
//     a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateDataKeyPair
func (c *KMS) GenerateDataKeyPair(input *GenerateDataKeyPairInput) (*GenerateDataKeyPairOutput, error) {
	req, out := c.GenerateDataKeyPairRequest(input)
	return out, req.Send()
}

// GenerateDataKeyPairWithContext is the same as GenerateDataKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See GenerateDataKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) GenerateDataKeyPairWithContext(ctx aws.Context, input *GenerateDataKeyPairInput, opts ...request.Option) (*GenerateDataKeyPairOutput, error) {
	req, out := c.GenerateDataKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGenerateDataKeyPairWithoutPlaintext = "GenerateDataKeyPairWithoutPlaintext"

// GenerateDataKeyPairWithoutPlaintextRequest generates a "aws/request.Request" representing the
// client's request for the GenerateDataKeyPairWithoutPlaintext operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GenerateDataKeyPairWithoutPlaintext for more information on using the GenerateDataKeyPairWithoutPlaintext
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GenerateDataKeyPairWithoutPlaintextRequest method.
//	req, resp := client.GenerateDataKeyPairWithoutPlaintextRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateDataKeyPairWithoutPlaintext
func (c *KMS) GenerateDataKeyPairWithoutPlaintextRequest(input *GenerateDataKeyPairWithoutPlaintextInput) (req *request.Request, output *GenerateDataKeyPairWithoutPlaintextOutput) {
	op := &request.Operation{
		Name:       opGenerateDataKeyPairWithoutPlaintext,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GenerateDataKeyPairWithoutPlaintextInput{}
	}

	output = &GenerateDataKeyPairWithoutPlaintextOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GenerateDataKeyPairWithoutPlaintext API operation for AWS Key Management Service.
//
// Returns a unique asymmetric data key pair for use outside of KMS. This operation
// returns a plaintext public key and a copy of the private key that is encrypted
// under the symmetric encryption KMS key you specify. Unlike GenerateDataKeyPair,
// this operation does not return a plaintext private key. The bytes in the
// keys are random; they are not related to the caller or to the KMS key that
// is used to encrypt the private key.
//
// You can use the public key that GenerateDataKeyPairWithoutPlaintext returns
// to encrypt data or verify a signature outside of KMS. Then, store the encrypted
// private key with the data. When you are ready to decrypt data or sign a message,
// you can use the Decrypt operation to decrypt the encrypted private key.
//
// To generate a data key pair, you must specify a symmetric encryption KMS
// key to encrypt the private key in a data key pair. You cannot use an asymmetric
// KMS key or a KMS key in a custom key store. To get the type and origin of
// your KMS key, use the DescribeKey operation.
//
// Use the KeyPairSpec parameter to choose an RSA or Elliptic Curve (ECC) data
// key pair. In China Regions, you can also choose an SM2 data key pair. KMS
// recommends that you use ECC key pairs for signing, and use RSA and SM2 key
// pairs for either encryption or signing, but not both. However, KMS cannot
// enforce any restrictions on the use of data key pairs outside of KMS.
//
// GenerateDataKeyPairWithoutPlaintext returns a unique data key pair for each
// request. The bytes in the key are not related to the caller or KMS key that
// is used to encrypt the private key. The public key is a DER-encoded X.509
// SubjectPublicKeyInfo, as specified in RFC 5280 (https://tools.ietf.org/html/rfc5280).
//
// You can use an optional encryption context to add additional security to
// the encryption operation. If you specify an EncryptionContext, you must specify
// the same encryption context (a case-sensitive exact match) when decrypting
// the encrypted data key. Otherwise, the request to decrypt fails with an InvalidCiphertextException.
// For more information, see Encryption Context (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
// in the Key Management Service Developer Guide.
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: Yes. To perform this operation with a KMS key in a different
// Amazon Web Services account, specify the key ARN or alias ARN in the value
// of the KeyId parameter.
//
// Required permissions: kms:GenerateDataKeyPairWithoutPlaintext (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations:
//
//   - Decrypt
//
//   - Encrypt
//
//   - GenerateDataKey
//
//   - GenerateDataKeyPair
//
//   - GenerateDataKeyWithoutPlaintext
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation GenerateDataKeyPairWithoutPlaintext for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - DisabledException
//     The request was rejected because the specified KMS key is not enabled.
//
//   - KeyUnavailableException
//     The request was rejected because the specified KMS key was not available.
//     You can retry the request.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InvalidKeyUsageException
//     The request was rejected for one of the following reasons:
//
//   - The KeyUsage value of the KMS key is incompatible with the API operation.
//
//   - The encryption algorithm or signing algorithm specified for the operation
//     is incompatible with the type of key material in the KMS key (KeySpec).
//
//     For encrypting, decrypting, re-encrypting, and generating data keys, the
//     KeyUsage must be ENCRYPT_DECRYPT. For signing and verifying messages, the
//     KeyUsage must be SIGN_VERIFY. For generating and verifying message authentication
//     codes (MACs), the KeyUsage must be GENERATE_VERIFY_MAC. To find the KeyUsage
//     of a KMS key, use the DescribeKey operation.
//
//     To find the encryption or signing algorithms supported for a particular KMS
//     key, use the DescribeKey operation.
//
//   - InvalidGrantTokenException
//     The request was rejected because the specified grant token is not valid.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
//   - UnsupportedOperationException
//     The request was rejected because a specified parameter is not supported or
//     a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateDataKeyPairWithoutPlaintext
func (c *KMS) GenerateDataKeyPairWithoutPlaintext(input *GenerateDataKeyPairWithoutPlaintextInput) (*GenerateDataKeyPairWithoutPlaintextOutput, error) {
	req, out := c.GenerateDataKeyPairWithoutPlaintextRequest(input)
	return out, req.Send()
}

// GenerateDataKeyPairWithoutPlaintextWithContext is the same as GenerateDataKeyPairWithoutPlaintext with the addition of
// the ability to pass a context and additional request options.
//
// See GenerateDataKeyPairWithoutPlaintext for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) GenerateDataKeyPairWithoutPlaintextWithContext(ctx aws.Context, input *GenerateDataKeyPairWithoutPlaintextInput, opts ...request.Option) (*GenerateDataKeyPairWithoutPlaintextOutput, error) {
	req, out := c.GenerateDataKeyPairWithoutPlaintextRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGenerateDataKeyWithoutPlaintext = "GenerateDataKeyWithoutPlaintext"

// GenerateDataKeyWithoutPlaintextRequest generates a "aws/request.Request" representing the
// client's request for the GenerateDataKeyWithoutPlaintext operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GenerateDataKeyWithoutPlaintext for more information on using the GenerateDataKeyWithoutPlaintext
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GenerateDataKeyWithoutPlaintextRequest method.
//	req, resp := client.GenerateDataKeyWithoutPlaintextRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateDataKeyWithoutPlaintext
func (c *KMS) GenerateDataKeyWithoutPlaintextRequest(input *GenerateDataKeyWithoutPlaintextInput) (req *request.Request, output *GenerateDataKeyWithoutPlaintextOutput) {
	op := &request.Operation{
		Name:       opGenerateDataKeyWithoutPlaintext,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GenerateDataKeyWithoutPlaintextInput{}
	}

	output = &GenerateDataKeyWithoutPlaintextOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GenerateDataKeyWithoutPlaintext API operation for AWS Key Management Service.
//
// Returns a unique symmetric data key for use outside of KMS. This operation
// returns a data key that is encrypted under a symmetric encryption KMS key
// that you specify. The bytes in the key are random; they are not related to
// the caller or to the KMS key.
//
// GenerateDataKeyWithoutPlaintext is identical to the GenerateDataKey operation
// except that it does not return a plaintext copy of the data key.
//
// This operation is useful for systems that need to encrypt data at some point,
// but not immediately. When you need to encrypt the data, you call the Decrypt
// operation on the encrypted copy of the key.
//
// It's also useful in distributed systems with different levels of trust. For
// example, you might store encrypted data in containers. One component of your
// system creates new containers and stores an encrypted data key with each
// container. Then, a different component puts the data into the containers.
// That component first decrypts the data key, uses the plaintext data key to
// encrypt data, puts the encrypted data into the container, and then destroys
// the plaintext data key. In this system, the component that creates the containers
// never sees the plaintext data key.
//
// To request an asymmetric data key pair, use the GenerateDataKeyPair or GenerateDataKeyPairWithoutPlaintext
// operations.
//
// To generate a data key, you must specify the symmetric encryption KMS key
// that is used to encrypt the data key. You cannot use an asymmetric KMS key
// or a key in a custom key store to generate a data key. To get the type of
// your KMS key, use the DescribeKey operation.
//
// You must also specify the length of the data key. Use either the KeySpec
// or NumberOfBytes parameters (but not both). For 128-bit and 256-bit data
// keys, use the KeySpec parameter.
//
// To generate an SM4 data key (China Regions only), specify a KeySpec value
// of AES_128 or NumberOfBytes value of 128. The symmetric encryption key used
// in China Regions to encrypt your data key is an SM4 encryption key.
//
// If the operation succeeds, you will find the encrypted copy of the data key
// in the CiphertextBlob field.
//
// You can use an optional encryption context to add additional security to
// the encryption operation. If you specify an EncryptionContext, you must specify
// the same encryption context (a case-sensitive exact match) when decrypting
// the encrypted data key. Otherwise, the request to decrypt fails with an InvalidCiphertextException.
// For more information, see Encryption Context (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
// in the Key Management Service Developer Guide.
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: Yes. To perform this operation with a KMS key in a different
// Amazon Web Services account, specify the key ARN or alias ARN in the value
// of the KeyId parameter.
//
// Required permissions: kms:GenerateDataKeyWithoutPlaintext (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations:
//
//   - Decrypt
//
//   - Encrypt
//
//   - GenerateDataKey
//
//   - GenerateDataKeyPair
//
//   - GenerateDataKeyPairWithoutPlaintext
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation GenerateDataKeyWithoutPlaintext for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - DisabledException
//     The request was rejected because the specified KMS key is not enabled.
//
//   - KeyUnavailableException
//     The request was rejected because the specified KMS key was not available.
//     You can retry the request.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InvalidKeyUsageException
//     The request was rejected for one of the following reasons:
//
//   - The KeyUsage value of the KMS key is incompatible with the API operation.
//
//   - The encryption algorithm or signing algorithm specified for the operation
//     is incompatible with the type of key material in the KMS key (KeySpec).
//
//     For encrypting, decrypting, re-encrypting, and generating data keys, the
//     KeyUsage must be ENCRYPT_DECRYPT. For signing and verifying messages, the
//     KeyUsage must be SIGN_VERIFY. For generating and verifying message authentication
//     codes (MACs), the KeyUsage must be GENERATE_VERIFY_MAC. To find the KeyUsage
//     of a KMS key, use the DescribeKey operation.
//
//     To find the encryption or signing algorithms supported for a particular KMS
//     key, use the DescribeKey operation.
//
//   - InvalidGrantTokenException
//     The request was rejected because the specified grant token is not valid.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateDataKeyWithoutPlaintext
func (c *KMS) GenerateDataKeyWithoutPlaintext(input *GenerateDataKeyWithoutPlaintextInput) (*GenerateDataKeyWithoutPlaintextOutput, error) {
	req, out := c.GenerateDataKeyWithoutPlaintextRequest(input)
	return out, req.Send()
}

// GenerateDataKeyWithoutPlaintextWithContext is the same as GenerateDataKeyWithoutPlaintext with the addition of
// the ability to pass a context and additional request options.
//
// See GenerateDataKeyWithoutPlaintext for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) GenerateDataKeyWithoutPlaintextWithContext(ctx aws.Context, input *GenerateDataKeyWithoutPlaintextInput, opts ...request.Option) (*GenerateDataKeyWithoutPlaintextOutput, error) {
	req, out := c.GenerateDataKeyWithoutPlaintextRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGenerateMac = "GenerateMac"

// GenerateMacRequest generates a "aws/request.Request" representing the
// client's request for the GenerateMac operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GenerateMac for more information on using the GenerateMac
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GenerateMacRequest method.
//	req, resp := client.GenerateMacRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateMac
func (c *KMS) GenerateMacRequest(input *GenerateMacInput) (req *request.Request, output *GenerateMacOutput) {
	op := &request.Operation{
		Name:       opGenerateMac,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GenerateMacInput{}
	}

	output = &GenerateMacOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GenerateMac API operation for AWS Key Management Service.
//
// Generates a hash-based message authentication code (HMAC) for a message using
// an HMAC KMS key and a MAC algorithm that the key supports. HMAC KMS keys
// and the HMAC algorithms that KMS uses conform to industry standards defined
// in RFC 2104 (https://datatracker.ietf.org/doc/html/rfc2104).
//
// You can use value that GenerateMac returns in the VerifyMac operation to
// demonstrate that the original message has not changed. Also, because a secret
// key is used to create the hash, you can verify that the party that generated
// the hash has the required secret key. You can also use the raw result to
// implement HMAC-based algorithms such as key derivation functions. This operation
// is part of KMS support for HMAC KMS keys. For details, see HMAC keys in KMS
// (https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html) in the
// Key Management Service Developer Guide .
//
// Best practices recommend that you limit the time during which any signing
// mechanism, including an HMAC, is effective. This deters an attack where the
// actor uses a signed message to establish validity repeatedly or long after
// the message is superseded. HMAC tags do not include a timestamp, but you
// can include a timestamp in the token or message to help you detect when its
// time to refresh the HMAC.
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: Yes. To perform this operation with a KMS key in a different
// Amazon Web Services account, specify the key ARN or alias ARN in the value
// of the KeyId parameter.
//
// Required permissions: kms:GenerateMac (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations: VerifyMac
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation GenerateMac for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - DisabledException
//     The request was rejected because the specified KMS key is not enabled.
//
//   - KeyUnavailableException
//     The request was rejected because the specified KMS key was not available.
//     You can retry the request.
//
//   - InvalidKeyUsageException
//     The request was rejected for one of the following reasons:
//
//   - The KeyUsage value of the KMS key is incompatible with the API operation.
//
//   - The encryption algorithm or signing algorithm specified for the operation
//     is incompatible with the type of key material in the KMS key (KeySpec).
//
//     For encrypting, decrypting, re-encrypting, and generating data keys, the
//     KeyUsage must be ENCRYPT_DECRYPT. For signing and verifying messages, the
//     KeyUsage must be SIGN_VERIFY. For generating and verifying message authentication
//     codes (MACs), the KeyUsage must be GENERATE_VERIFY_MAC. To find the KeyUsage
//     of a KMS key, use the DescribeKey operation.
//
//     To find the encryption or signing algorithms supported for a particular KMS
//     key, use the DescribeKey operation.
//
//   - InvalidGrantTokenException
//     The request was rejected because the specified grant token is not valid.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateMac
func (c *KMS) GenerateMac(input *GenerateMacInput) (*GenerateMacOutput, error) {
	req, out := c.GenerateMacRequest(input)
	return out, req.Send()
}

// GenerateMacWithContext is the same as GenerateMac with the addition of
// the ability to pass a context and additional request options.
//
// See GenerateMac for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) GenerateMacWithContext(ctx aws.Context, input *GenerateMacInput, opts ...request.Option) (*GenerateMacOutput, error) {
	req, out := c.GenerateMacRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGenerateRandom = "GenerateRandom"

// GenerateRandomRequest generates a "aws/request.Request" representing the
// client's request for the GenerateRandom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GenerateRandom for more information on using the GenerateRandom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GenerateRandomRequest method.
//	req, resp := client.GenerateRandomRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateRandom
func (c *KMS) GenerateRandomRequest(input *GenerateRandomInput) (req *request.Request, output *GenerateRandomOutput) {
	op := &request.Operation{
		Name:       opGenerateRandom,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GenerateRandomInput{}
	}

	output = &GenerateRandomOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GenerateRandom API operation for AWS Key Management Service.
//
// Returns a random byte string that is cryptographically secure.
//
// You must use the NumberOfBytes parameter to specify the length of the random
// byte string. There is no default value for string length.
//
// By default, the random byte string is generated in KMS. To generate the byte
// string in the CloudHSM cluster associated with an CloudHSM key store, use
// the CustomKeyStoreId parameter.
//
// Applications in Amazon Web Services Nitro Enclaves can call this operation
// by using the Amazon Web Services Nitro Enclaves Development Kit (https://github.com/aws/aws-nitro-enclaves-sdk-c).
// For information about the supporting parameters, see How Amazon Web Services
// Nitro Enclaves use KMS (https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html)
// in the Key Management Service Developer Guide.
//
// For more information about entropy and random number generation, see Key
// Management Service Cryptographic Details (https://docs.aws.amazon.com/kms/latest/cryptographic-details/).
//
// Cross-account use: Not applicable. GenerateRandom does not use any account-specific
// resources, such as KMS keys.
//
// Required permissions: kms:GenerateRandom (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (IAM policy)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation GenerateRandom for usage and error information.
//
// Returned Error Types:
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - UnsupportedOperationException
//     The request was rejected because a specified parameter is not supported or
//     a specified resource is not valid for this operation.
//
//   - CustomKeyStoreNotFoundException
//     The request was rejected because KMS cannot find a custom key store with
//     the specified key store name or ID.
//
//   - CustomKeyStoreInvalidStateException
//     The request was rejected because of the ConnectionState of the custom key
//     store. To get the ConnectionState of a custom key store, use the DescribeCustomKeyStores
//     operation.
//
//     This exception is thrown under the following conditions:
//
//   - You requested the ConnectCustomKeyStore operation on a custom key store
//     with a ConnectionState of DISCONNECTING or FAILED. This operation is valid
//     for all other ConnectionState values. To reconnect a custom key store
//     in a FAILED state, disconnect it (DisconnectCustomKeyStore), then connect
//     it (ConnectCustomKeyStore).
//
//   - You requested the CreateKey operation in a custom key store that is
//     not connected. This operations is valid only when the custom key store
//     ConnectionState is CONNECTED.
//
//   - You requested the DisconnectCustomKeyStore operation on a custom key
//     store with a ConnectionState of DISCONNECTING or DISCONNECTED. This operation
//     is valid for all other ConnectionState values.
//
//   - You requested the UpdateCustomKeyStore or DeleteCustomKeyStore operation
//     on a custom key store that is not disconnected. This operation is valid
//     only when the custom key store ConnectionState is DISCONNECTED.
//
//   - You requested the GenerateRandom operation in an CloudHSM key store
//     that is not connected. This operation is valid only when the CloudHSM
//     key store ConnectionState is CONNECTED.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GenerateRandom
func (c *KMS) GenerateRandom(input *GenerateRandomInput) (*GenerateRandomOutput, error) {
	req, out := c.GenerateRandomRequest(input)
	return out, req.Send()
}

// GenerateRandomWithContext is the same as GenerateRandom with the addition of
// the ability to pass a context and additional request options.
//
// See GenerateRandom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) GenerateRandomWithContext(ctx aws.Context, input *GenerateRandomInput, opts ...request.Option) (*GenerateRandomOutput, error) {
	req, out := c.GenerateRandomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetKeyPolicy = "GetKeyPolicy"

// GetKeyPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetKeyPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKeyPolicy for more information on using the GetKeyPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetKeyPolicyRequest method.
//	req, resp := client.GetKeyPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetKeyPolicy
func (c *KMS) GetKeyPolicyRequest(input *GetKeyPolicyInput) (req *request.Request, output *GetKeyPolicyOutput) {
	op := &request.Operation{
		Name:       opGetKeyPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetKeyPolicyInput{}
	}

	output = &GetKeyPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKeyPolicy API operation for AWS Key Management Service.
//
// Gets a key policy attached to the specified KMS key.
//
// Cross-account use: No. You cannot perform this operation on a KMS key in
// a different Amazon Web Services account.
//
// Required permissions: kms:GetKeyPolicy (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations: PutKeyPolicy
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation GetKeyPolicy for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetKeyPolicy
func (c *KMS) GetKeyPolicy(input *GetKeyPolicyInput) (*GetKeyPolicyOutput, error) {
	req, out := c.GetKeyPolicyRequest(input)
	return out, req.Send()
}

// GetKeyPolicyWithContext is the same as GetKeyPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetKeyPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) GetKeyPolicyWithContext(ctx aws.Context, input *GetKeyPolicyInput, opts ...request.Option) (*GetKeyPolicyOutput, error) {
	req, out := c.GetKeyPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetKeyRotationStatus = "GetKeyRotationStatus"

// GetKeyRotationStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetKeyRotationStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKeyRotationStatus for more information on using the GetKeyRotationStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetKeyRotationStatusRequest method.
//	req, resp := client.GetKeyRotationStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetKeyRotationStatus
func (c *KMS) GetKeyRotationStatusRequest(input *GetKeyRotationStatusInput) (req *request.Request, output *GetKeyRotationStatusOutput) {
	op := &request.Operation{
		Name:       opGetKeyRotationStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetKeyRotationStatusInput{}
	}

	output = &GetKeyRotationStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKeyRotationStatus API operation for AWS Key Management Service.
//
// Gets a Boolean value that indicates whether automatic rotation of the key
// material (https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html)
// is enabled for the specified KMS key.
//
// When you enable automatic rotation for customer managed KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk),
// KMS rotates the key material of the KMS key one year (approximately 365 days)
// from the enable date and every year thereafter. You can monitor rotation
// of the key material for your KMS keys in CloudTrail and Amazon CloudWatch.
//
// Automatic key rotation is supported only on symmetric encryption KMS keys
// (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#symmetric-cmks).
// You cannot enable automatic rotation of asymmetric KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html),
// HMAC KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html),
// KMS keys with imported key material (https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html),
// or KMS keys in a custom key store (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html).
// To enable or disable automatic rotation of a set of related multi-Region
// keys (https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-manage.html#multi-region-rotate),
// set the property on the primary key..
//
// You can enable (EnableKeyRotation) and disable automatic rotation (DisableKeyRotation)
// of the key material in customer managed KMS keys. Key material rotation of
// Amazon Web Services managed KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk)
// is not configurable. KMS always rotates the key material in Amazon Web Services
// managed KMS keys every year. The key rotation status for Amazon Web Services
// managed KMS keys is always true.
//
// In May 2022, KMS changed the rotation schedule for Amazon Web Services managed
// keys from every three years to every year. For details, see EnableKeyRotation.
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
//   - Disabled: The key rotation status does not change when you disable a
//     KMS key. However, while the KMS key is disabled, KMS does not rotate the
//     key material. When you re-enable the KMS key, rotation resumes. If the
//     key material in the re-enabled KMS key hasn't been rotated in one year,
//     KMS rotates it immediately, and every year thereafter. If it's been less
//     than a year since the key material in the re-enabled KMS key was rotated,
//     the KMS key resumes its prior rotation schedule.
//
//   - Pending deletion: While a KMS key is pending deletion, its key rotation
//     status is false and KMS does not rotate the key material. If you cancel
//     the deletion, the original key rotation status returns to true.
//
// Cross-account use: Yes. To perform this operation on a KMS key in a different
// Amazon Web Services account, specify the key ARN in the value of the KeyId
// parameter.
//
// Required permissions: kms:GetKeyRotationStatus (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations:
//
//   - DisableKeyRotation
//
//   - EnableKeyRotation
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation GetKeyRotationStatus for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
//   - UnsupportedOperationException
//     The request was rejected because a specified parameter is not supported or
//     a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetKeyRotationStatus
func (c *KMS) GetKeyRotationStatus(input *GetKeyRotationStatusInput) (*GetKeyRotationStatusOutput, error) {
	req, out := c.GetKeyRotationStatusRequest(input)
	return out, req.Send()
}

// GetKeyRotationStatusWithContext is the same as GetKeyRotationStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetKeyRotationStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) GetKeyRotationStatusWithContext(ctx aws.Context, input *GetKeyRotationStatusInput, opts ...request.Option) (*GetKeyRotationStatusOutput, error) {
	req, out := c.GetKeyRotationStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetParametersForImport = "GetParametersForImport"

// GetParametersForImportRequest generates a "aws/request.Request" representing the
// client's request for the GetParametersForImport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetParametersForImport for more information on using the GetParametersForImport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetParametersForImportRequest method.
//	req, resp := client.GetParametersForImportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetParametersForImport
func (c *KMS) GetParametersForImportRequest(input *GetParametersForImportInput) (req *request.Request, output *GetParametersForImportOutput) {
	op := &request.Operation{
		Name:       opGetParametersForImport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetParametersForImportInput{}
	}

	output = &GetParametersForImportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetParametersForImport API operation for AWS Key Management Service.
//
// Returns the items you need to import key material into a symmetric encryption
// KMS key. For more information about importing key material into KMS, see
// Importing key material (https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html)
// in the Key Management Service Developer Guide.
//
// This operation returns a public key and an import token. Use the public key
// to encrypt the symmetric key material. Store the import token to send with
// a subsequent ImportKeyMaterial request.
//
// You must specify the key ID of the symmetric encryption KMS key into which
// you will import key material. The KMS key Origin must be EXTERNAL. You must
// also specify the wrapping algorithm and type of wrapping key (public key)
// that you will use to encrypt the key material. You cannot perform this operation
// on an asymmetric KMS key, an HMAC KMS key, or on any KMS key in a different
// Amazon Web Services account.
//
// To import key material, you must use the public key and import token from
// the same response. These items are valid for 24 hours. The expiration date
// and time appear in the GetParametersForImport response. You cannot use an
// expired token in an ImportKeyMaterial request. If your key and token expire,
// send another GetParametersForImport request.
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: No. You cannot perform this operation on a KMS key in
// a different Amazon Web Services account.
//
// Required permissions: kms:GetParametersForImport (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations:
//
//   - ImportKeyMaterial
//
//   - DeleteImportedKeyMaterial
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation GetParametersForImport for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - UnsupportedOperationException
//     The request was rejected because a specified parameter is not supported or
//     a specified resource is not valid for this operation.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetParametersForImport
func (c *KMS) GetParametersForImport(input *GetParametersForImportInput) (*GetParametersForImportOutput, error) {
	req, out := c.GetParametersForImportRequest(input)
	return out, req.Send()
}

// GetParametersForImportWithContext is the same as GetParametersForImport with the addition of
// the ability to pass a context and additional request options.
//
// See GetParametersForImport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) GetParametersForImportWithContext(ctx aws.Context, input *GetParametersForImportInput, opts ...request.Option) (*GetParametersForImportOutput, error) {
	req, out := c.GetParametersForImportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPublicKey = "GetPublicKey"

// GetPublicKeyRequest generates a "aws/request.Request" representing the
// client's request for the GetPublicKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPublicKey for more information on using the GetPublicKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPublicKeyRequest method.
//	req, resp := client.GetPublicKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetPublicKey
func (c *KMS) GetPublicKeyRequest(input *GetPublicKeyInput) (req *request.Request, output *GetPublicKeyOutput) {
	op := &request.Operation{
		Name:       opGetPublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPublicKeyInput{}
	}

	output = &GetPublicKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPublicKey API operation for AWS Key Management Service.
//
// Returns the public key of an asymmetric KMS key. Unlike the private key of
// a asymmetric KMS key, which never leaves KMS unencrypted, callers with kms:GetPublicKey
// permission can download the public key of an asymmetric KMS key. You can
// share the public key to allow others to encrypt messages and verify signatures
// outside of KMS. For information about asymmetric KMS keys, see Asymmetric
// KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
// in the Key Management Service Developer Guide.
//
// You do not need to download the public key. Instead, you can use the public
// key within KMS by calling the Encrypt, ReEncrypt, or Verify operations with
// the identifier of an asymmetric KMS key. When you use the public key within
// KMS, you benefit from the authentication, authorization, and logging that
// are part of every KMS operation. You also reduce of risk of encrypting data
// that cannot be decrypted. These features are not effective outside of KMS.
//
// To help you use the public key safely outside of KMS, GetPublicKey returns
// important information about the public key in the response, including:
//
//   - KeySpec (https://docs.aws.amazon.com/kms/latest/APIReference/API_GetPublicKey.html#KMS-GetPublicKey-response-KeySpec):
//     The type of key material in the public key, such as RSA_4096 or ECC_NIST_P521.
//
//   - KeyUsage (https://docs.aws.amazon.com/kms/latest/APIReference/API_GetPublicKey.html#KMS-GetPublicKey-response-KeyUsage):
//     Whether the key is used for encryption or signing.
//
//   - EncryptionAlgorithms (https://docs.aws.amazon.com/kms/latest/APIReference/API_GetPublicKey.html#KMS-GetPublicKey-response-EncryptionAlgorithms)
//     or SigningAlgorithms (https://docs.aws.amazon.com/kms/latest/APIReference/API_GetPublicKey.html#KMS-GetPublicKey-response-SigningAlgorithms):
//     A list of the encryption algorithms or the signing algorithms for the
//     key.
//
// Although KMS cannot enforce these restrictions on external operations, it
// is crucial that you use this information to prevent the public key from being
// used improperly. For example, you can prevent a public signing key from being
// used encrypt data, or prevent a public key from being used with an encryption
// algorithm that is not supported by KMS. You can also avoid errors, such as
// using the wrong signing algorithm in a verification operation.
//
// To verify a signature outside of KMS with an SM2 public key (China Regions
// only), you must specify the distinguishing ID. By default, KMS uses 1234567812345678
// as the distinguishing ID. For more information, see Offline verification
// with SM2 key pairs (https://docs.aws.amazon.com/kms/latest/developerguide/asymmetric-key-specs.html#key-spec-sm-offline-verification).
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: Yes. To perform this operation with a KMS key in a different
// Amazon Web Services account, specify the key ARN or alias ARN in the value
// of the KeyId parameter.
//
// Required permissions: kms:GetPublicKey (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations: CreateKey
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation GetPublicKey for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - DisabledException
//     The request was rejected because the specified KMS key is not enabled.
//
//   - KeyUnavailableException
//     The request was rejected because the specified KMS key was not available.
//     You can retry the request.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - UnsupportedOperationException
//     The request was rejected because a specified parameter is not supported or
//     a specified resource is not valid for this operation.
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - InvalidGrantTokenException
//     The request was rejected because the specified grant token is not valid.
//
//   - InvalidKeyUsageException
//     The request was rejected for one of the following reasons:
//
//   - The KeyUsage value of the KMS key is incompatible with the API operation.
//
//   - The encryption algorithm or signing algorithm specified for the operation
//     is incompatible with the type of key material in the KMS key (KeySpec).
//
//     For encrypting, decrypting, re-encrypting, and generating data keys, the
//     KeyUsage must be ENCRYPT_DECRYPT. For signing and verifying messages, the
//     KeyUsage must be SIGN_VERIFY. For generating and verifying message authentication
//     codes (MACs), the KeyUsage must be GENERATE_VERIFY_MAC. To find the KeyUsage
//     of a KMS key, use the DescribeKey operation.
//
//     To find the encryption or signing algorithms supported for a particular KMS
//     key, use the DescribeKey operation.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetPublicKey
func (c *KMS) GetPublicKey(input *GetPublicKeyInput) (*GetPublicKeyOutput, error) {
	req, out := c.GetPublicKeyRequest(input)
	return out, req.Send()
}

// GetPublicKeyWithContext is the same as GetPublicKey with the addition of
// the ability to pass a context and additional request options.
//
// See GetPublicKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) GetPublicKeyWithContext(ctx aws.Context, input *GetPublicKeyInput, opts ...request.Option) (*GetPublicKeyOutput, error) {
	req, out := c.GetPublicKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportKeyMaterial = "ImportKeyMaterial"

// ImportKeyMaterialRequest generates a "aws/request.Request" representing the
// client's request for the ImportKeyMaterial operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportKeyMaterial for more information on using the ImportKeyMaterial
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ImportKeyMaterialRequest method.
//	req, resp := client.ImportKeyMaterialRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ImportKeyMaterial
func (c *KMS) ImportKeyMaterialRequest(input *ImportKeyMaterialInput) (req *request.Request, output *ImportKeyMaterialOutput) {
	op := &request.Operation{
		Name:       opImportKeyMaterial,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportKeyMaterialInput{}
	}

	output = &ImportKeyMaterialOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ImportKeyMaterial API operation for AWS Key Management Service.
//
// Imports key material into an existing symmetric encryption KMS key that was
// created without key material. After you successfully import key material
// into a KMS key, you can reimport the same key material (https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html#reimport-key-material)
// into that KMS key, but you cannot import different key material.
//
// You cannot perform this operation on an asymmetric KMS key, an HMAC KMS key,
// or on any KMS key in a different Amazon Web Services account. For more information
// about creating KMS keys with no key material and then importing key material,
// see Importing Key Material (https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html)
// in the Key Management Service Developer Guide.
//
// Before using this operation, call GetParametersForImport. Its response includes
// a public key and an import token. Use the public key to encrypt the key material.
// Then, submit the import token from the same GetParametersForImport response.
//
// When calling this operation, you must specify the following values:
//
//   - The key ID or key ARN of a KMS key with no key material. Its Origin
//     must be EXTERNAL. To create a KMS key with no key material, call CreateKey
//     and set the value of its Origin parameter to EXTERNAL. To get the Origin
//     of a KMS key, call DescribeKey.)
//
//   - The encrypted key material. To get the public key to encrypt the key
//     material, call GetParametersForImport.
//
//   - The import token that GetParametersForImport returned. You must use
//     a public key and token from the same GetParametersForImport response.
//
//   - Whether the key material expires (ExpirationModel) and, if so, when
//     (ValidTo). If you set an expiration date, on the specified date, KMS deletes
//     the key material from the KMS key, making the KMS key unusable. To use
//     the KMS key in cryptographic operations again, you must reimport the same
//     key material. The only way to change the expiration model or expiration
//     date is by reimporting the same key material and specifying a new expiration
//     date.
//
// When this operation is successful, the key state of the KMS key changes from
// PendingImport to Enabled, and you can use the KMS key.
//
// If this operation fails, use the exception to help determine the problem.
// If the error is related to the key material, the import token, or wrapping
// key, use GetParametersForImport to get a new public key and import token
// for the KMS key and repeat the import procedure. For help, see How To Import
// Key Material (https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html#importing-keys-overview)
// in the Key Management Service Developer Guide.
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: No. You cannot perform this operation on a KMS key in
// a different Amazon Web Services account.
//
// Required permissions: kms:ImportKeyMaterial (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations:
//
//   - DeleteImportedKeyMaterial
//
//   - GetParametersForImport
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation ImportKeyMaterial for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - UnsupportedOperationException
//     The request was rejected because a specified parameter is not supported or
//     a specified resource is not valid for this operation.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
//   - InvalidCiphertextException
//     From the Decrypt or ReEncrypt operation, the request was rejected because
//     the specified ciphertext, or additional authenticated data incorporated into
//     the ciphertext, such as the encryption context, is corrupted, missing, or
//     otherwise invalid.
//
//     From the ImportKeyMaterial operation, the request was rejected because KMS
//     could not decrypt the encrypted (wrapped) key material.
//
//   - IncorrectKeyMaterialException
//     The request was rejected because the key material in the request is, expired,
//     invalid, or is not the same key material that was previously imported into
//     this KMS key.
//
//   - ExpiredImportTokenException
//     The request was rejected because the specified import token is expired. Use
//     GetParametersForImport to get a new import token and public key, use the
//     new public key to encrypt the key material, and then try the request again.
//
//   - InvalidImportTokenException
//     The request was rejected because the provided import token is invalid or
//     is associated with a different KMS key.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ImportKeyMaterial
func (c *KMS) ImportKeyMaterial(input *ImportKeyMaterialInput) (*ImportKeyMaterialOutput, error) {
	req, out := c.ImportKeyMaterialRequest(input)
	return out, req.Send()
}

// ImportKeyMaterialWithContext is the same as ImportKeyMaterial with the addition of
// the ability to pass a context and additional request options.
//
// See ImportKeyMaterial for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ImportKeyMaterialWithContext(ctx aws.Context, input *ImportKeyMaterialInput, opts ...request.Option) (*ImportKeyMaterialOutput, error) {
	req, out := c.ImportKeyMaterialRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAliases = "ListAliases"

// ListAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListAliases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAliases for more information on using the ListAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAliasesRequest method.
//	req, resp := client.ListAliasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListAliases
func (c *KMS) ListAliasesRequest(input *ListAliasesInput) (req *request.Request, output *ListAliasesOutput) {
	op := &request.Operation{
		Name:       opListAliases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAliasesInput{}
	}

	output = &ListAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAliases API operation for AWS Key Management Service.
//
// Gets a list of aliases in the caller's Amazon Web Services account and region.
// For more information about aliases, see CreateAlias.
//
// By default, the ListAliases operation returns all aliases in the account
// and region. To get only the aliases associated with a particular KMS key,
// use the KeyId parameter.
//
// The ListAliases response can include aliases that you created and associated
// with your customer managed keys, and aliases that Amazon Web Services created
// and associated with Amazon Web Services managed keys in your account. You
// can recognize Amazon Web Services aliases because their names have the format
// aws/<service-name>, such as aws/dynamodb.
//
// The response might also include aliases that have no TargetKeyId field. These
// are predefined aliases that Amazon Web Services has created but has not yet
// associated with a KMS key. Aliases that Amazon Web Services creates in your
// account, including predefined aliases, do not count against your KMS aliases
// quota (https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#aliases-limit).
//
// Cross-account use: No. ListAliases does not return aliases in other Amazon
// Web Services accounts.
//
// Required permissions: kms:ListAliases (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (IAM policy)
//
// For details, see Controlling access to aliases (https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html#alias-access)
// in the Key Management Service Developer Guide.
//
// Related operations:
//
//   - CreateAlias
//
//   - DeleteAlias
//
//   - UpdateAlias
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation ListAliases for usage and error information.
//
// Returned Error Types:
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InvalidMarkerException
//     The request was rejected because the marker that specifies where pagination
//     should next begin is not valid.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListAliases
func (c *KMS) ListAliases(input *ListAliasesInput) (*ListAliasesOutput, error) {
	req, out := c.ListAliasesRequest(input)
	return out, req.Send()
}

// ListAliasesWithContext is the same as ListAliases with the addition of
// the ability to pass a context and additional request options.
//
// See ListAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ListAliasesWithContext(ctx aws.Context, input *ListAliasesInput, opts ...request.Option) (*ListAliasesOutput, error) {
	req, out := c.ListAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAliasesPages iterates over the pages of a ListAliases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAliases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAliases operation.
//	pageNum := 0
//	err := client.ListAliasesPages(params,
//	    func(page *kms.ListAliasesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *KMS) ListAliasesPages(input *ListAliasesInput, fn func(*ListAliasesOutput, bool) bool) error {
	return c.ListAliasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAliasesPagesWithContext same as ListAliasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ListAliasesPagesWithContext(ctx aws.Context, input *ListAliasesInput, fn func(*ListAliasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAliasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAliasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAliasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGrants = "ListGrants"

// ListGrantsRequest generates a "aws/request.Request" representing the
// client's request for the ListGrants operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGrants for more information on using the ListGrants
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListGrantsRequest method.
//	req, resp := client.ListGrantsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListGrants
func (c *KMS) ListGrantsRequest(input *ListGrantsInput) (req *request.Request, output *ListGrantsResponse) {
	op := &request.Operation{
		Name:       opListGrants,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGrantsInput{}
	}

	output = &ListGrantsResponse{}
	req = c.newRequest(op, input, output)
	return
}

// ListGrants API operation for AWS Key Management Service.
//
// Gets a list of all grants for the specified KMS key.
//
// You must specify the KMS key in all requests. You can filter the grant list
// by grant ID or grantee principal.
//
// For detailed information about grants, including grant terminology, see Grants
// in KMS (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html)
// in the Key Management Service Developer Guide . For examples of working with
// grants in several programming languages, see Programming grants (https://docs.aws.amazon.com/kms/latest/developerguide/programming-grants.html).
//
// The GranteePrincipal field in the ListGrants response usually contains the
// user or role designated as the grantee principal in the grant. However, when
// the grantee principal in the grant is an Amazon Web Services service, the
// GranteePrincipal field contains the service principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services),
// which might represent several different grantee principals.
//
// Cross-account use: Yes. To perform this operation on a KMS key in a different
// Amazon Web Services account, specify the key ARN in the value of the KeyId
// parameter.
//
// Required permissions: kms:ListGrants (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations:
//
//   - CreateGrant
//
//   - ListRetirableGrants
//
//   - RetireGrant
//
//   - RevokeGrant
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation ListGrants for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InvalidMarkerException
//     The request was rejected because the marker that specifies where pagination
//     should next begin is not valid.
//
//   - InvalidGrantIdException
//     The request was rejected because the specified GrantId is not valid.
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListGrants
func (c *KMS) ListGrants(input *ListGrantsInput) (*ListGrantsResponse, error) {
	req, out := c.ListGrantsRequest(input)
	return out, req.Send()
}

// ListGrantsWithContext is the same as ListGrants with the addition of
// the ability to pass a context and additional request options.
//
// See ListGrants for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ListGrantsWithContext(ctx aws.Context, input *ListGrantsInput, opts ...request.Option) (*ListGrantsResponse, error) {
	req, out := c.ListGrantsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGrantsPages iterates over the pages of a ListGrants operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGrants method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListGrants operation.
//	pageNum := 0
//	err := client.ListGrantsPages(params,
//	    func(page *kms.ListGrantsResponse, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *KMS) ListGrantsPages(input *ListGrantsInput, fn func(*ListGrantsResponse, bool) bool) error {
	return c.ListGrantsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGrantsPagesWithContext same as ListGrantsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ListGrantsPagesWithContext(ctx aws.Context, input *ListGrantsInput, fn func(*ListGrantsResponse, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGrantsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGrantsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGrantsResponse), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListKeyPolicies = "ListKeyPolicies"

// ListKeyPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListKeyPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListKeyPolicies for more information on using the ListKeyPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListKeyPoliciesRequest method.
//	req, resp := client.ListKeyPoliciesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListKeyPolicies
func (c *KMS) ListKeyPoliciesRequest(input *ListKeyPoliciesInput) (req *request.Request, output *ListKeyPoliciesOutput) {
	op := &request.Operation{
		Name:       opListKeyPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListKeyPoliciesInput{}
	}

	output = &ListKeyPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListKeyPolicies API operation for AWS Key Management Service.
//
// Gets the names of the key policies that are attached to a KMS key. This operation
// is designed to get policy names that you can use in a GetKeyPolicy operation.
// However, the only valid policy name is default.
//
// Cross-account use: No. You cannot perform this operation on a KMS key in
// a different Amazon Web Services account.
//
// Required permissions: kms:ListKeyPolicies (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations:
//
//   - GetKeyPolicy
//
//   - PutKeyPolicy
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation ListKeyPolicies for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListKeyPolicies
func (c *KMS) ListKeyPolicies(input *ListKeyPoliciesInput) (*ListKeyPoliciesOutput, error) {
	req, out := c.ListKeyPoliciesRequest(input)
	return out, req.Send()
}

// ListKeyPoliciesWithContext is the same as ListKeyPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListKeyPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ListKeyPoliciesWithContext(ctx aws.Context, input *ListKeyPoliciesInput, opts ...request.Option) (*ListKeyPoliciesOutput, error) {
	req, out := c.ListKeyPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListKeyPoliciesPages iterates over the pages of a ListKeyPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListKeyPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListKeyPolicies operation.
//	pageNum := 0
//	err := client.ListKeyPoliciesPages(params,
//	    func(page *kms.ListKeyPoliciesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *KMS) ListKeyPoliciesPages(input *ListKeyPoliciesInput, fn func(*ListKeyPoliciesOutput, bool) bool) error {
	return c.ListKeyPoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListKeyPoliciesPagesWithContext same as ListKeyPoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ListKeyPoliciesPagesWithContext(ctx aws.Context, input *ListKeyPoliciesInput, fn func(*ListKeyPoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListKeyPoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListKeyPoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListKeyPoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListKeys = "ListKeys"

// ListKeysRequest generates a "aws/request.Request" representing the
// client's request for the ListKeys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListKeys for more information on using the ListKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListKeysRequest method.
//	req, resp := client.ListKeysRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListKeys
func (c *KMS) ListKeysRequest(input *ListKeysInput) (req *request.Request, output *ListKeysOutput) {
	op := &request.Operation{
		Name:       opListKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListKeysInput{}
	}

	output = &ListKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListKeys API operation for AWS Key Management Service.
//
// Gets a list of all KMS keys in the caller's Amazon Web Services account and
// Region.
//
// Cross-account use: No. You cannot perform this operation on a KMS key in
// a different Amazon Web Services account.
//
// Required permissions: kms:ListKeys (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (IAM policy)
//
// Related operations:
//
//   - CreateKey
//
//   - DescribeKey
//
//   - ListAliases
//
//   - ListResourceTags
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation ListKeys for usage and error information.
//
// Returned Error Types:
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidMarkerException
//     The request was rejected because the marker that specifies where pagination
//     should next begin is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListKeys
func (c *KMS) ListKeys(input *ListKeysInput) (*ListKeysOutput, error) {
	req, out := c.ListKeysRequest(input)
	return out, req.Send()
}

// ListKeysWithContext is the same as ListKeys with the addition of
// the ability to pass a context and additional request options.
//
// See ListKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ListKeysWithContext(ctx aws.Context, input *ListKeysInput, opts ...request.Option) (*ListKeysOutput, error) {
	req, out := c.ListKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListKeysPages iterates over the pages of a ListKeys operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListKeys method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListKeys operation.
//	pageNum := 0
//	err := client.ListKeysPages(params,
//	    func(page *kms.ListKeysOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *KMS) ListKeysPages(input *ListKeysInput, fn func(*ListKeysOutput, bool) bool) error {
	return c.ListKeysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListKeysPagesWithContext same as ListKeysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ListKeysPagesWithContext(ctx aws.Context, input *ListKeysInput, fn func(*ListKeysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListKeysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListKeysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListKeysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResourceTags = "ListResourceTags"

// ListResourceTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourceTags for more information on using the ListResourceTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListResourceTagsRequest method.
//	req, resp := client.ListResourceTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListResourceTags
func (c *KMS) ListResourceTagsRequest(input *ListResourceTagsInput) (req *request.Request, output *ListResourceTagsOutput) {
	op := &request.Operation{
		Name:       opListResourceTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResourceTagsInput{}
	}

	output = &ListResourceTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourceTags API operation for AWS Key Management Service.
//
// Returns all tags on the specified KMS key.
//
// For general information about tags, including the format and syntax, see
// Tagging Amazon Web Services resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
// in the Amazon Web Services General Reference. For information about using
// tags in KMS, see Tagging keys (https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html).
//
// Cross-account use: No. You cannot perform this operation on a KMS key in
// a different Amazon Web Services account.
//
// Required permissions: kms:ListResourceTags (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations:
//
//   - CreateKey
//
//   - ReplicateKey
//
//   - TagResource
//
//   - UntagResource
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation ListResourceTags for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - InvalidMarkerException
//     The request was rejected because the marker that specifies where pagination
//     should next begin is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListResourceTags
func (c *KMS) ListResourceTags(input *ListResourceTagsInput) (*ListResourceTagsOutput, error) {
	req, out := c.ListResourceTagsRequest(input)
	return out, req.Send()
}

// ListResourceTagsWithContext is the same as ListResourceTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ListResourceTagsWithContext(ctx aws.Context, input *ListResourceTagsInput, opts ...request.Option) (*ListResourceTagsOutput, error) {
	req, out := c.ListResourceTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResourceTagsPages iterates over the pages of a ListResourceTags operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResourceTags method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListResourceTags operation.
//	pageNum := 0
//	err := client.ListResourceTagsPages(params,
//	    func(page *kms.ListResourceTagsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *KMS) ListResourceTagsPages(input *ListResourceTagsInput, fn func(*ListResourceTagsOutput, bool) bool) error {
	return c.ListResourceTagsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResourceTagsPagesWithContext same as ListResourceTagsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ListResourceTagsPagesWithContext(ctx aws.Context, input *ListResourceTagsInput, fn func(*ListResourceTagsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResourceTagsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResourceTagsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResourceTagsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRetirableGrants = "ListRetirableGrants"

// ListRetirableGrantsRequest generates a "aws/request.Request" representing the
// client's request for the ListRetirableGrants operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRetirableGrants for more information on using the ListRetirableGrants
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRetirableGrantsRequest method.
//	req, resp := client.ListRetirableGrantsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListRetirableGrants
func (c *KMS) ListRetirableGrantsRequest(input *ListRetirableGrantsInput) (req *request.Request, output *ListGrantsResponse) {
	op := &request.Operation{
		Name:       opListRetirableGrants,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRetirableGrantsInput{}
	}

	output = &ListGrantsResponse{}
	req = c.newRequest(op, input, output)
	return
}

// ListRetirableGrants API operation for AWS Key Management Service.
//
// Returns information about all grants in the Amazon Web Services account and
// Region that have the specified retiring principal.
//
// You can specify any principal in your Amazon Web Services account. The grants
// that are returned include grants for KMS keys in your Amazon Web Services
// account and other Amazon Web Services accounts. You might use this operation
// to determine which grants you may retire. To retire a grant, use the RetireGrant
// operation.
//
// For detailed information about grants, including grant terminology, see Grants
// in KMS (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html)
// in the Key Management Service Developer Guide . For examples of working with
// grants in several programming languages, see Programming grants (https://docs.aws.amazon.com/kms/latest/developerguide/programming-grants.html).
//
// Cross-account use: You must specify a principal in your Amazon Web Services
// account. However, this operation can return grants in any Amazon Web Services
// account. You do not need kms:ListRetirableGrants permission (or any other
// additional permission) in any Amazon Web Services account other than your
// own.
//
// Required permissions: kms:ListRetirableGrants (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (IAM policy) in your Amazon Web Services account.
//
// Related operations:
//
//   - CreateGrant
//
//   - ListGrants
//
//   - RetireGrant
//
//   - RevokeGrant
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation ListRetirableGrants for usage and error information.
//
// Returned Error Types:
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InvalidMarkerException
//     The request was rejected because the marker that specifies where pagination
//     should next begin is not valid.
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListRetirableGrants
func (c *KMS) ListRetirableGrants(input *ListRetirableGrantsInput) (*ListGrantsResponse, error) {
	req, out := c.ListRetirableGrantsRequest(input)
	return out, req.Send()
}

// ListRetirableGrantsWithContext is the same as ListRetirableGrants with the addition of
// the ability to pass a context and additional request options.
//
// See ListRetirableGrants for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ListRetirableGrantsWithContext(ctx aws.Context, input *ListRetirableGrantsInput, opts ...request.Option) (*ListGrantsResponse, error) {
	req, out := c.ListRetirableGrantsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRetirableGrantsPages iterates over the pages of a ListRetirableGrants operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRetirableGrants method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRetirableGrants operation.
//	pageNum := 0
//	err := client.ListRetirableGrantsPages(params,
//	    func(page *kms.ListGrantsResponse, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *KMS) ListRetirableGrantsPages(input *ListRetirableGrantsInput, fn func(*ListGrantsResponse, bool) bool) error {
	return c.ListRetirableGrantsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRetirableGrantsPagesWithContext same as ListRetirableGrantsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ListRetirableGrantsPagesWithContext(ctx aws.Context, input *ListRetirableGrantsInput, fn func(*ListGrantsResponse, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRetirableGrantsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRetirableGrantsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGrantsResponse), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutKeyPolicy = "PutKeyPolicy"

// PutKeyPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutKeyPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutKeyPolicy for more information on using the PutKeyPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutKeyPolicyRequest method.
//	req, resp := client.PutKeyPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/PutKeyPolicy
func (c *KMS) PutKeyPolicyRequest(input *PutKeyPolicyInput) (req *request.Request, output *PutKeyPolicyOutput) {
	op := &request.Operation{
		Name:       opPutKeyPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutKeyPolicyInput{}
	}

	output = &PutKeyPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutKeyPolicy API operation for AWS Key Management Service.
//
// Attaches a key policy to the specified KMS key.
//
// For more information about key policies, see Key Policies (https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html)
// in the Key Management Service Developer Guide. For help writing and formatting
// a JSON policy document, see the IAM JSON Policy Reference (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html)
// in the Identity and Access Management User Guide . For examples of adding
// a key policy in multiple programming languages, see Setting a key policy
// (https://docs.aws.amazon.com/kms/latest/developerguide/programming-key-policies.html#put-policy)
// in the Key Management Service Developer Guide.
//
// Cross-account use: No. You cannot perform this operation on a KMS key in
// a different Amazon Web Services account.
//
// Required permissions: kms:PutKeyPolicy (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations: GetKeyPolicy
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation PutKeyPolicy for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - MalformedPolicyDocumentException
//     The request was rejected because the specified policy is not syntactically
//     or semantically correct.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - UnsupportedOperationException
//     The request was rejected because a specified parameter is not supported or
//     a specified resource is not valid for this operation.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - LimitExceededException
//     The request was rejected because a quota was exceeded. For more information,
//     see Quotas (https://docs.aws.amazon.com/kms/latest/developerguide/limits.html)
//     in the Key Management Service Developer Guide.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/PutKeyPolicy
func (c *KMS) PutKeyPolicy(input *PutKeyPolicyInput) (*PutKeyPolicyOutput, error) {
	req, out := c.PutKeyPolicyRequest(input)
	return out, req.Send()
}

// PutKeyPolicyWithContext is the same as PutKeyPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutKeyPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) PutKeyPolicyWithContext(ctx aws.Context, input *PutKeyPolicyInput, opts ...request.Option) (*PutKeyPolicyOutput, error) {
	req, out := c.PutKeyPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReEncrypt = "ReEncrypt"

// ReEncryptRequest generates a "aws/request.Request" representing the
// client's request for the ReEncrypt operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ReEncrypt for more information on using the ReEncrypt
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ReEncryptRequest method.
//	req, resp := client.ReEncryptRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ReEncrypt
func (c *KMS) ReEncryptRequest(input *ReEncryptInput) (req *request.Request, output *ReEncryptOutput) {
	op := &request.Operation{
		Name:       opReEncrypt,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReEncryptInput{}
	}

	output = &ReEncryptOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReEncrypt API operation for AWS Key Management Service.
//
// Decrypts ciphertext and then reencrypts it entirely within KMS. You can use
// this operation to change the KMS key under which data is encrypted, such
// as when you manually rotate (https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html#rotate-keys-manually)
// a KMS key or change the KMS key that protects a ciphertext. You can also
// use it to reencrypt ciphertext under the same KMS key, such as to change
// the encryption context (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
// of a ciphertext.
//
// The ReEncrypt operation can decrypt ciphertext that was encrypted by using
// a KMS key in an KMS operation, such as Encrypt or GenerateDataKey. It can
// also decrypt ciphertext that was encrypted by using the public key of an
// asymmetric KMS key (https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html#asymmetric-cmks)
// outside of KMS. However, it cannot decrypt ciphertext produced by other libraries,
// such as the Amazon Web Services Encryption SDK (https://docs.aws.amazon.com/encryption-sdk/latest/developer-guide/)
// or Amazon S3 client-side encryption (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html).
// These libraries return a ciphertext format that is incompatible with KMS.
//
// When you use the ReEncrypt operation, you need to provide information for
// the decrypt operation and the subsequent encrypt operation.
//
//   - If your ciphertext was encrypted under an asymmetric KMS key, you must
//     use the SourceKeyId parameter to identify the KMS key that encrypted the
//     ciphertext. You must also supply the encryption algorithm that was used.
//     This information is required to decrypt the data.
//
//   - If your ciphertext was encrypted under a symmetric encryption KMS key,
//     the SourceKeyId parameter is optional. KMS can get this information from
//     metadata that it adds to the symmetric ciphertext blob. This feature adds
//     durability to your implementation by ensuring that authorized users can
//     decrypt ciphertext decades after it was encrypted, even if they've lost
//     track of the key ID. However, specifying the source KMS key is always
//     recommended as a best practice. When you use the SourceKeyId parameter
//     to specify a KMS key, KMS uses only the KMS key you specify. If the ciphertext
//     was encrypted under a different KMS key, the ReEncrypt operation fails.
//     This practice ensures that you use the KMS key that you intend.
//
//   - To reencrypt the data, you must use the DestinationKeyId parameter to
//     specify the KMS key that re-encrypts the data after it is decrypted. If
//     the destination KMS key is an asymmetric KMS key, you must also provide
//     the encryption algorithm. The algorithm that you choose must be compatible
//     with the KMS key. When you use an asymmetric KMS key to encrypt or reencrypt
//     data, be sure to record the KMS key and encryption algorithm that you
//     choose. You will be required to provide the same KMS key and encryption
//     algorithm when you decrypt the data. If the KMS key and algorithm do not
//     match the values used to encrypt the data, the decrypt operation fails.
//     You are not required to supply the key ID and encryption algorithm when
//     you decrypt with symmetric encryption KMS keys because KMS stores this
//     information in the ciphertext blob. KMS cannot store metadata in ciphertext
//     generated with asymmetric keys. The standard format for asymmetric key
//     ciphertext does not include configurable fields.
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: Yes. The source KMS key and destination KMS key can be
// in different Amazon Web Services accounts. Either or both KMS keys can be
// in a different account than the caller. To specify a KMS key in a different
// account, you must use its key ARN or alias ARN.
//
// Required permissions:
//
//   - kms:ReEncryptFrom (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
//     permission on the source KMS key (key policy)
//
//   - kms:ReEncryptTo (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
//     permission on the destination KMS key (key policy)
//
// To permit reencryption from or to a KMS key, include the "kms:ReEncrypt*"
// permission in your key policy (https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html).
// This permission is automatically included in the key policy when you use
// the console to create a KMS key. But you must include it manually when you
// create a KMS key programmatically or when you use the PutKeyPolicy operation
// to set a key policy.
//
// Related operations:
//
//   - Decrypt
//
//   - Encrypt
//
//   - GenerateDataKey
//
//   - GenerateDataKeyPair
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation ReEncrypt for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - DisabledException
//     The request was rejected because the specified KMS key is not enabled.
//
//   - InvalidCiphertextException
//     From the Decrypt or ReEncrypt operation, the request was rejected because
//     the specified ciphertext, or additional authenticated data incorporated into
//     the ciphertext, such as the encryption context, is corrupted, missing, or
//     otherwise invalid.
//
//     From the ImportKeyMaterial operation, the request was rejected because KMS
//     could not decrypt the encrypted (wrapped) key material.
//
//   - KeyUnavailableException
//     The request was rejected because the specified KMS key was not available.
//     You can retry the request.
//
//   - IncorrectKeyException
//     The request was rejected because the specified KMS key cannot decrypt the
//     data. The KeyId in a Decrypt request and the SourceKeyId in a ReEncrypt request
//     must identify the same KMS key that was used to encrypt the ciphertext.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InvalidKeyUsageException
//     The request was rejected for one of the following reasons:
//
//   - The KeyUsage value of the KMS key is incompatible with the API operation.
//
//   - The encryption algorithm or signing algorithm specified for the operation
//     is incompatible with the type of key material in the KMS key (KeySpec).
//
//     For encrypting, decrypting, re-encrypting, and generating data keys, the
//     KeyUsage must be ENCRYPT_DECRYPT. For signing and verifying messages, the
//     KeyUsage must be SIGN_VERIFY. For generating and verifying message authentication
//     codes (MACs), the KeyUsage must be GENERATE_VERIFY_MAC. To find the KeyUsage
//     of a KMS key, use the DescribeKey operation.
//
//     To find the encryption or signing algorithms supported for a particular KMS
//     key, use the DescribeKey operation.
//
//   - InvalidGrantTokenException
//     The request was rejected because the specified grant token is not valid.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ReEncrypt
func (c *KMS) ReEncrypt(input *ReEncryptInput) (*ReEncryptOutput, error) {
	req, out := c.ReEncryptRequest(input)
	return out, req.Send()
}

// ReEncryptWithContext is the same as ReEncrypt with the addition of
// the ability to pass a context and additional request options.
//
// See ReEncrypt for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ReEncryptWithContext(ctx aws.Context, input *ReEncryptInput, opts ...request.Option) (*ReEncryptOutput, error) {
	req, out := c.ReEncryptRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReplicateKey = "ReplicateKey"

// ReplicateKeyRequest generates a "aws/request.Request" representing the
// client's request for the ReplicateKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ReplicateKey for more information on using the ReplicateKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ReplicateKeyRequest method.
//	req, resp := client.ReplicateKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ReplicateKey
func (c *KMS) ReplicateKeyRequest(input *ReplicateKeyInput) (req *request.Request, output *ReplicateKeyOutput) {
	op := &request.Operation{
		Name:       opReplicateKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReplicateKeyInput{}
	}

	output = &ReplicateKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReplicateKey API operation for AWS Key Management Service.
//
// Replicates a multi-Region key into the specified Region. This operation creates
// a multi-Region replica key based on a multi-Region primary key in a different
// Region of the same Amazon Web Services partition. You can create multiple
// replicas of a primary key, but each must be in a different Region. To create
// a multi-Region primary key, use the CreateKey operation.
//
// This operation supports multi-Region keys, an KMS feature that lets you create
// multiple interoperable KMS keys in different Amazon Web Services Regions.
// Because these KMS keys have the same key ID, key material, and other metadata,
// you can use them interchangeably to encrypt data in one Amazon Web Services
// Region and decrypt it in a different Amazon Web Services Region without re-encrypting
// the data or making a cross-Region call. For more information about multi-Region
// keys, see Multi-Region keys in KMS (https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html)
// in the Key Management Service Developer Guide.
//
// A replica key is a fully-functional KMS key that can be used independently
// of its primary and peer replica keys. A primary key and its replica keys
// share properties that make them interoperable. They have the same key ID
// (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id)
// and key material. They also have the same key spec (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-spec),
// key usage (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-usage),
// key material origin (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-origin),
// and automatic key rotation status (https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html).
// KMS automatically synchronizes these shared properties among related multi-Region
// keys. All other properties of a replica key can differ, including its key
// policy (https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html),
// tags (https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html),
// aliases (https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html),
// and Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html).
// KMS pricing and quotas for KMS keys apply to each primary key and replica
// key.
//
// When this operation completes, the new replica key has a transient key state
// of Creating. This key state changes to Enabled (or PendingImport) after a
// few seconds when the process of creating the new replica key is complete.
// While the key state is Creating, you can manage key, but you cannot yet use
// it in cryptographic operations. If you are creating and using the replica
// key programmatically, retry on KMSInvalidStateException or call DescribeKey
// to check its KeyState value before using it. For details about the Creating
// key state, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// You cannot create more than one replica of a primary key in any Region. If
// the Region already includes a replica of the key you're trying to replicate,
// ReplicateKey returns an AlreadyExistsException error. If the key state of
// the existing replica is PendingDeletion, you can cancel the scheduled key
// deletion (CancelKeyDeletion) or wait for the key to be deleted. The new replica
// key you create will have the same shared properties (https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html#mrk-sync-properties)
// as the original replica key.
//
// The CloudTrail log of a ReplicateKey operation records a ReplicateKey operation
// in the primary key's Region and a CreateKey operation in the replica key's
// Region.
//
// If you replicate a multi-Region primary key with imported key material, the
// replica key is created with no key material. You must import the same key
// material that you imported into the primary key. For details, see Importing
// key material into multi-Region keys (kms/latest/developerguide/multi-region-keys-import.html)
// in the Key Management Service Developer Guide.
//
// To convert a replica key to a primary key, use the UpdatePrimaryRegion operation.
//
// ReplicateKey uses different default values for the KeyPolicy and Tags parameters
// than those used in the KMS console. For details, see the parameter descriptions.
//
// Cross-account use: No. You cannot use this operation to create a replica
// key in a different Amazon Web Services account.
//
// Required permissions:
//
//   - kms:ReplicateKey on the primary key (in the primary key's Region). Include
//     this permission in the primary key's key policy.
//
//   - kms:CreateKey in an IAM policy in the replica Region.
//
//   - To use the Tags parameter, kms:TagResource in an IAM policy in the replica
//     Region.
//
// Related operations
//
//   - CreateKey
//
//   - UpdatePrimaryRegion
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation ReplicateKey for usage and error information.
//
// Returned Error Types:
//
//   - AlreadyExistsException
//     The request was rejected because it attempted to create a resource that already
//     exists.
//
//   - DisabledException
//     The request was rejected because the specified KMS key is not enabled.
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - LimitExceededException
//     The request was rejected because a quota was exceeded. For more information,
//     see Quotas (https://docs.aws.amazon.com/kms/latest/developerguide/limits.html)
//     in the Key Management Service Developer Guide.
//
//   - MalformedPolicyDocumentException
//     The request was rejected because the specified policy is not syntactically
//     or semantically correct.
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - TagException
//     The request was rejected because one or more tags are not valid.
//
//   - UnsupportedOperationException
//     The request was rejected because a specified parameter is not supported or
//     a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ReplicateKey
func (c *KMS) ReplicateKey(input *ReplicateKeyInput) (*ReplicateKeyOutput, error) {
	req, out := c.ReplicateKeyRequest(input)
	return out, req.Send()
}

// ReplicateKeyWithContext is the same as ReplicateKey with the addition of
// the ability to pass a context and additional request options.
//
// See ReplicateKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ReplicateKeyWithContext(ctx aws.Context, input *ReplicateKeyInput, opts ...request.Option) (*ReplicateKeyOutput, error) {
	req, out := c.ReplicateKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRetireGrant = "RetireGrant"

// RetireGrantRequest generates a "aws/request.Request" representing the
// client's request for the RetireGrant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RetireGrant for more information on using the RetireGrant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RetireGrantRequest method.
//	req, resp := client.RetireGrantRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/RetireGrant
func (c *KMS) RetireGrantRequest(input *RetireGrantInput) (req *request.Request, output *RetireGrantOutput) {
	op := &request.Operation{
		Name:       opRetireGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RetireGrantInput{}
	}

	output = &RetireGrantOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RetireGrant API operation for AWS Key Management Service.
//
// Deletes a grant. Typically, you retire a grant when you no longer need its
// permissions. To identify the grant to retire, use a grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token),
// or both the grant ID and a key identifier (key ID or key ARN) of the KMS
// key. The CreateGrant operation returns both values.
//
// This operation can be called by the retiring principal for a grant, by the
// grantee principal if the grant allows the RetireGrant operation, and by the
// Amazon Web Services account in which the grant is created. It can also be
// called by principals to whom permission for retiring a grant is delegated.
// For details, see Retiring and revoking grants (https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#grant-delete)
// in the Key Management Service Developer Guide.
//
// For detailed information about grants, including grant terminology, see Grants
// in KMS (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html)
// in the Key Management Service Developer Guide . For examples of working with
// grants in several programming languages, see Programming grants (https://docs.aws.amazon.com/kms/latest/developerguide/programming-grants.html).
//
// Cross-account use: Yes. You can retire a grant on a KMS key in a different
// Amazon Web Services account.
//
// Required permissions::Permission to retire a grant is determined primarily
// by the grant. For details, see Retiring and revoking grants (https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#grant-delete)
// in the Key Management Service Developer Guide.
//
// Related operations:
//
//   - CreateGrant
//
//   - ListGrants
//
//   - ListRetirableGrants
//
//   - RevokeGrant
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation RetireGrant for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - InvalidGrantTokenException
//     The request was rejected because the specified grant token is not valid.
//
//   - InvalidGrantIdException
//     The request was rejected because the specified GrantId is not valid.
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/RetireGrant
func (c *KMS) RetireGrant(input *RetireGrantInput) (*RetireGrantOutput, error) {
	req, out := c.RetireGrantRequest(input)
	return out, req.Send()
}

// RetireGrantWithContext is the same as RetireGrant with the addition of
// the ability to pass a context and additional request options.
//
// See RetireGrant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) RetireGrantWithContext(ctx aws.Context, input *RetireGrantInput, opts ...request.Option) (*RetireGrantOutput, error) {
	req, out := c.RetireGrantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokeGrant = "RevokeGrant"

// RevokeGrantRequest generates a "aws/request.Request" representing the
// client's request for the RevokeGrant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokeGrant for more information on using the RevokeGrant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RevokeGrantRequest method.
//	req, resp := client.RevokeGrantRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/RevokeGrant
func (c *KMS) RevokeGrantRequest(input *RevokeGrantInput) (req *request.Request, output *RevokeGrantOutput) {
	op := &request.Operation{
		Name:       opRevokeGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeGrantInput{}
	}

	output = &RevokeGrantOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RevokeGrant API operation for AWS Key Management Service.
//
// Deletes the specified grant. You revoke a grant to terminate the permissions
// that the grant allows. For more information, see Retiring and revoking grants
// (https://docs.aws.amazon.com/kms/latest/developerguide/managing-grants.html#grant-delete)
// in the Key Management Service Developer Guide .
//
// When you create, retire, or revoke a grant, there might be a brief delay,
// usually less than five minutes, until the grant is available throughout KMS.
// This state is known as eventual consistency. For details, see Eventual consistency
// (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#terms-eventual-consistency)
// in the Key Management Service Developer Guide .
//
// For detailed information about grants, including grant terminology, see Grants
// in KMS (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html)
// in the Key Management Service Developer Guide . For examples of working with
// grants in several programming languages, see Programming grants (https://docs.aws.amazon.com/kms/latest/developerguide/programming-grants.html).
//
// Cross-account use: Yes. To perform this operation on a KMS key in a different
// Amazon Web Services account, specify the key ARN in the value of the KeyId
// parameter.
//
// Required permissions: kms:RevokeGrant (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy).
//
// Related operations:
//
//   - CreateGrant
//
//   - ListGrants
//
//   - ListRetirableGrants
//
//   - RetireGrant
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation RevokeGrant for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - InvalidGrantIdException
//     The request was rejected because the specified GrantId is not valid.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/RevokeGrant
func (c *KMS) RevokeGrant(input *RevokeGrantInput) (*RevokeGrantOutput, error) {
	req, out := c.RevokeGrantRequest(input)
	return out, req.Send()
}

// RevokeGrantWithContext is the same as RevokeGrant with the addition of
// the ability to pass a context and additional request options.
//
// See RevokeGrant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) RevokeGrantWithContext(ctx aws.Context, input *RevokeGrantInput, opts ...request.Option) (*RevokeGrantOutput, error) {
	req, out := c.RevokeGrantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opScheduleKeyDeletion = "ScheduleKeyDeletion"

// ScheduleKeyDeletionRequest generates a "aws/request.Request" representing the
// client's request for the ScheduleKeyDeletion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ScheduleKeyDeletion for more information on using the ScheduleKeyDeletion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ScheduleKeyDeletionRequest method.
//	req, resp := client.ScheduleKeyDeletionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ScheduleKeyDeletion
func (c *KMS) ScheduleKeyDeletionRequest(input *ScheduleKeyDeletionInput) (req *request.Request, output *ScheduleKeyDeletionOutput) {
	op := &request.Operation{
		Name:       opScheduleKeyDeletion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ScheduleKeyDeletionInput{}
	}

	output = &ScheduleKeyDeletionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ScheduleKeyDeletion API operation for AWS Key Management Service.
//
// Schedules the deletion of a KMS key. By default, KMS applies a waiting period
// of 30 days, but you can specify a waiting period of 7-30 days. When this
// operation is successful, the key state of the KMS key changes to PendingDeletion
// and the key can't be used in any cryptographic operations. It remains in
// this state for the duration of the waiting period. Before the waiting period
// ends, you can use CancelKeyDeletion to cancel the deletion of the KMS key.
// After the waiting period ends, KMS deletes the KMS key, its key material,
// and all KMS data associated with it, including all aliases that refer to
// it.
//
// Deleting a KMS key is a destructive and potentially dangerous operation.
// When a KMS key is deleted, all data that was encrypted under the KMS key
// is unrecoverable. (The only exception is a multi-Region replica key.) To
// prevent the use of a KMS key without deleting it, use DisableKey.
//
// You can schedule the deletion of a multi-Region primary key and its replica
// keys at any time. However, KMS will not delete a multi-Region primary key
// with existing replica keys. If you schedule the deletion of a primary key
// with replicas, its key state changes to PendingReplicaDeletion and it cannot
// be replicated or used in cryptographic operations. This status can continue
// indefinitely. When the last of its replicas keys is deleted (not just scheduled),
// the key state of the primary key changes to PendingDeletion and its waiting
// period (PendingWindowInDays) begins. For details, see Deleting multi-Region
// keys (https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-delete.html)
// in the Key Management Service Developer Guide.
//
// When KMS deletes a KMS key from an CloudHSM key store (https://docs.aws.amazon.com/kms/latest/developerguide/delete-cmk-keystore.html),
// it makes a best effort to delete the associated key material from the associated
// CloudHSM cluster. However, you might need to manually delete the orphaned
// key material (https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-orphaned-key)
// from the cluster and its backups. Deleting a KMS key from an external key
// store (https://docs.aws.amazon.com/kms/latest/developerguide/delete-xks-key.html)
// has no effect on the associated external key. However, for both types of
// custom key stores, deleting a KMS key is destructive and irreversible. You
// cannot decrypt ciphertext encrypted under the KMS key by using only its associated
// external key or CloudHSM key. Also, you cannot recreate a KMS key in an external
// key store by creating a new KMS key with the same key material.
//
// For more information about scheduling a KMS key for deletion, see Deleting
// KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html)
// in the Key Management Service Developer Guide.
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: No. You cannot perform this operation on a KMS key in
// a different Amazon Web Services account.
//
// Required permissions: kms:ScheduleKeyDeletion (key policy)
//
// Related operations
//
//   - CancelKeyDeletion
//
//   - DisableKey
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation ScheduleKeyDeletion for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ScheduleKeyDeletion
func (c *KMS) ScheduleKeyDeletion(input *ScheduleKeyDeletionInput) (*ScheduleKeyDeletionOutput, error) {
	req, out := c.ScheduleKeyDeletionRequest(input)
	return out, req.Send()
}

// ScheduleKeyDeletionWithContext is the same as ScheduleKeyDeletion with the addition of
// the ability to pass a context and additional request options.
//
// See ScheduleKeyDeletion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ScheduleKeyDeletionWithContext(ctx aws.Context, input *ScheduleKeyDeletionInput, opts ...request.Option) (*ScheduleKeyDeletionOutput, error) {
	req, out := c.ScheduleKeyDeletionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSign = "Sign"

// SignRequest generates a "aws/request.Request" representing the
// client's request for the Sign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Sign for more information on using the Sign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SignRequest method.
//	req, resp := client.SignRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/Sign
func (c *KMS) SignRequest(input *SignInput) (req *request.Request, output *SignOutput) {
	op := &request.Operation{
		Name:       opSign,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SignInput{}
	}

	output = &SignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Sign API operation for AWS Key Management Service.
//
// Creates a digital signature (https://en.wikipedia.org/wiki/Digital_signature)
// for a message or message digest by using the private key in an asymmetric
// signing KMS key. To verify the signature, use the Verify operation, or use
// the public key in the same asymmetric KMS key outside of KMS. For information
// about asymmetric KMS keys, see Asymmetric KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
// in the Key Management Service Developer Guide.
//
// Digital signatures are generated and verified by using asymmetric key pair,
// such as an RSA or ECC pair that is represented by an asymmetric KMS key.
// The key owner (or an authorized user) uses their private key to sign a message.
// Anyone with the public key can verify that the message was signed with that
// particular private key and that the message hasn't changed since it was signed.
//
// To use the Sign operation, provide the following information:
//
//   - Use the KeyId parameter to identify an asymmetric KMS key with a KeyUsage
//     value of SIGN_VERIFY. To get the KeyUsage value of a KMS key, use the
//     DescribeKey operation. The caller must have kms:Sign permission on the
//     KMS key.
//
//   - Use the Message parameter to specify the message or message digest to
//     sign. You can submit messages of up to 4096 bytes. To sign a larger message,
//     generate a hash digest of the message, and then provide the hash digest
//     in the Message parameter. To indicate whether the message is a full message
//     or a digest, use the MessageType parameter.
//
//   - Choose a signing algorithm that is compatible with the KMS key.
//
// When signing a message, be sure to record the KMS key and the signing algorithm.
// This information is required to verify the signature.
//
// Best practices recommend that you limit the time during which any signature
// is effective. This deters an attack where the actor uses a signed message
// to establish validity repeatedly or long after the message is superseded.
// Signatures do not include a timestamp, but you can include a timestamp in
// the signed message to help you detect when its time to refresh the signature.
//
// To verify the signature that this operation generates, use the Verify operation.
// Or use the GetPublicKey operation to download the public key and then use
// the public key to verify the signature outside of KMS.
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: Yes. To perform this operation with a KMS key in a different
// Amazon Web Services account, specify the key ARN or alias ARN in the value
// of the KeyId parameter.
//
// Required permissions: kms:Sign (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations: Verify
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation Sign for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - DisabledException
//     The request was rejected because the specified KMS key is not enabled.
//
//   - KeyUnavailableException
//     The request was rejected because the specified KMS key was not available.
//     You can retry the request.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InvalidKeyUsageException
//     The request was rejected for one of the following reasons:
//
//   - The KeyUsage value of the KMS key is incompatible with the API operation.
//
//   - The encryption algorithm or signing algorithm specified for the operation
//     is incompatible with the type of key material in the KMS key (KeySpec).
//
//     For encrypting, decrypting, re-encrypting, and generating data keys, the
//     KeyUsage must be ENCRYPT_DECRYPT. For signing and verifying messages, the
//     KeyUsage must be SIGN_VERIFY. For generating and verifying message authentication
//     codes (MACs), the KeyUsage must be GENERATE_VERIFY_MAC. To find the KeyUsage
//     of a KMS key, use the DescribeKey operation.
//
//     To find the encryption or signing algorithms supported for a particular KMS
//     key, use the DescribeKey operation.
//
//   - InvalidGrantTokenException
//     The request was rejected because the specified grant token is not valid.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/Sign
func (c *KMS) Sign(input *SignInput) (*SignOutput, error) {
	req, out := c.SignRequest(input)
	return out, req.Send()
}

// SignWithContext is the same as Sign with the addition of
// the ability to pass a context and additional request options.
//
// See Sign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) SignWithContext(ctx aws.Context, input *SignInput, opts ...request.Option) (*SignOutput, error) {
	req, out := c.SignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/TagResource
func (c *KMS) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Key Management Service.
//
// Adds or edits tags on a customer managed key (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk).
//
// Tagging or untagging a KMS key can allow or deny permission to the KMS key.
// For details, see ABAC for KMS (https://docs.aws.amazon.com/kms/latest/developerguide/abac.html)
// in the Key Management Service Developer Guide.
//
// Each tag consists of a tag key and a tag value, both of which are case-sensitive
// strings. The tag value can be an empty (null) string. To add a tag, specify
// a new tag key and a tag value. To edit a tag, specify an existing tag key
// and a new tag value.
//
// You can use this operation to tag a customer managed key (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk),
// but you cannot tag an Amazon Web Services managed key (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk),
// an Amazon Web Services owned key (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-owned-cmk),
// a custom key store (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#keystore-concept),
// or an alias (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#alias-concept).
//
// You can also add tags to a KMS key while creating it (CreateKey) or replicating
// it (ReplicateKey).
//
// For information about using tags in KMS, see Tagging keys (https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html).
// For general information about tags, including the format and syntax, see
// Tagging Amazon Web Services resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
// in the Amazon Web Services General Reference.
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: No. You cannot perform this operation on a KMS key in
// a different Amazon Web Services account.
//
// Required permissions: kms:TagResource (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations
//
//   - CreateKey
//
//   - ListResourceTags
//
//   - ReplicateKey
//
//   - UntagResource
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
//   - LimitExceededException
//     The request was rejected because a quota was exceeded. For more information,
//     see Quotas (https://docs.aws.amazon.com/kms/latest/developerguide/limits.html)
//     in the Key Management Service Developer Guide.
//
//   - TagException
//     The request was rejected because one or more tags are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/TagResource
func (c *KMS) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/UntagResource
func (c *KMS) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Key Management Service.
//
// Deletes tags from a customer managed key (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk).
// To delete a tag, specify the tag key and the KMS key.
//
// Tagging or untagging a KMS key can allow or deny permission to the KMS key.
// For details, see ABAC for KMS (https://docs.aws.amazon.com/kms/latest/developerguide/abac.html)
// in the Key Management Service Developer Guide.
//
// When it succeeds, the UntagResource operation doesn't return any output.
// Also, if the specified tag key isn't found on the KMS key, it doesn't throw
// an exception or return a response. To confirm that the operation worked,
// use the ListResourceTags operation.
//
// For information about using tags in KMS, see Tagging keys (https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html).
// For general information about tags, including the format and syntax, see
// Tagging Amazon Web Services resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
// in the Amazon Web Services General Reference.
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: No. You cannot perform this operation on a KMS key in
// a different Amazon Web Services account.
//
// Required permissions: kms:UntagResource (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations
//
//   - CreateKey
//
//   - ListResourceTags
//
//   - ReplicateKey
//
//   - TagResource
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
//   - TagException
//     The request was rejected because one or more tags are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/UntagResource
func (c *KMS) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAlias = "UpdateAlias"

// UpdateAliasRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAlias for more information on using the UpdateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAliasRequest method.
//	req, resp := client.UpdateAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/UpdateAlias
func (c *KMS) UpdateAliasRequest(input *UpdateAliasInput) (req *request.Request, output *UpdateAliasOutput) {
	op := &request.Operation{
		Name:       opUpdateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAliasInput{}
	}

	output = &UpdateAliasOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateAlias API operation for AWS Key Management Service.
//
// Associates an existing KMS alias with a different KMS key. Each alias is
// associated with only one KMS key at a time, although a KMS key can have multiple
// aliases. The alias and the KMS key must be in the same Amazon Web Services
// account and Region.
//
// Adding, deleting, or updating an alias can allow or deny permission to the
// KMS key. For details, see ABAC for KMS (https://docs.aws.amazon.com/kms/latest/developerguide/abac.html)
// in the Key Management Service Developer Guide.
//
// The current and new KMS key must be the same type (both symmetric or both
// asymmetric or both HMAC), and they must have the same key usage. This restriction
// prevents errors in code that uses aliases. If you must assign an alias to
// a different type of KMS key, use DeleteAlias to delete the old alias and
// CreateAlias to create a new alias.
//
// You cannot use UpdateAlias to change an alias name. To change an alias name,
// use DeleteAlias to delete the old alias and CreateAlias to create a new alias.
//
// Because an alias is not a property of a KMS key, you can create, update,
// and delete the aliases of a KMS key without affecting the KMS key. Also,
// aliases do not appear in the response from the DescribeKey operation. To
// get the aliases of all KMS keys in the account, use the ListAliases operation.
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: No. You cannot perform this operation on a KMS key in
// a different Amazon Web Services account.
//
// Required permissions
//
//   - kms:UpdateAlias (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
//     on the alias (IAM policy).
//
//   - kms:UpdateAlias (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
//     on the current KMS key (key policy).
//
//   - kms:UpdateAlias (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
//     on the new KMS key (key policy).
//
// For details, see Controlling access to aliases (https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html#alias-access)
// in the Key Management Service Developer Guide.
//
// Related operations:
//
//   - CreateAlias
//
//   - DeleteAlias
//
//   - ListAliases
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation UpdateAlias for usage and error information.
//
// Returned Error Types:
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - LimitExceededException
//     The request was rejected because a quota was exceeded. For more information,
//     see Quotas (https://docs.aws.amazon.com/kms/latest/developerguide/limits.html)
//     in the Key Management Service Developer Guide.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/UpdateAlias
func (c *KMS) UpdateAlias(input *UpdateAliasInput) (*UpdateAliasOutput, error) {
	req, out := c.UpdateAliasRequest(input)
	return out, req.Send()
}

// UpdateAliasWithContext is the same as UpdateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) UpdateAliasWithContext(ctx aws.Context, input *UpdateAliasInput, opts ...request.Option) (*UpdateAliasOutput, error) {
	req, out := c.UpdateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCustomKeyStore = "UpdateCustomKeyStore"

// UpdateCustomKeyStoreRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCustomKeyStore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCustomKeyStore for more information on using the UpdateCustomKeyStore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCustomKeyStoreRequest method.
//	req, resp := client.UpdateCustomKeyStoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/UpdateCustomKeyStore
func (c *KMS) UpdateCustomKeyStoreRequest(input *UpdateCustomKeyStoreInput) (req *request.Request, output *UpdateCustomKeyStoreOutput) {
	op := &request.Operation{
		Name:       opUpdateCustomKeyStore,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCustomKeyStoreInput{}
	}

	output = &UpdateCustomKeyStoreOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateCustomKeyStore API operation for AWS Key Management Service.
//
// Changes the properties of a custom key store. You can use this operation
// to change the properties of an CloudHSM key store or an external key store.
//
// Use the required CustomKeyStoreId parameter to identify the custom key store.
// Use the remaining optional parameters to change its properties. This operation
// does not return any property values. To verify the updated property values,
// use the DescribeCustomKeyStores operation.
//
// This operation is part of the custom key stores (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
// feature in KMS, which combines the convenience and extensive integration
// of KMS with the isolation and control of a key store that you own and manage.
//
// When updating the properties of an external key store, verify that the updated
// settings connect your key store, via the external key store proxy, to the
// same external key manager as the previous settings, or to a backup or snapshot
// of the external key manager with the same cryptographic keys. If the updated
// connection settings fail, you can fix them and retry, although an extended
// delay might disrupt Amazon Web Services services. However, if KMS permanently
// loses its access to cryptographic keys, ciphertext encrypted under those
// keys is unrecoverable.
//
// For external key stores:
//
// Some external key managers provide a simpler method for updating an external
// key store. For details, see your external key manager documentation.
//
// When updating an external key store in the KMS console, you can upload a
// JSON-based proxy configuration file with the desired values. You cannot upload
// the proxy configuration file to the UpdateCustomKeyStore operation. However,
// you can use the file to help you determine the correct values for the UpdateCustomKeyStore
// parameters.
//
// For an CloudHSM key store, you can use this operation to change the custom
// key store friendly name (NewCustomKeyStoreName), to tell KMS about a change
// to the kmsuser crypto user password (KeyStorePassword), or to associate the
// custom key store with a different, but related, CloudHSM cluster (CloudHsmClusterId).
// To update any property of an CloudHSM key store, the ConnectionState of the
// CloudHSM key store must be DISCONNECTED.
//
// For an external key store, you can use this operation to change the custom
// key store friendly name (NewCustomKeyStoreName), or to tell KMS about a change
// to the external key store proxy authentication credentials (XksProxyAuthenticationCredential),
// connection method (XksProxyConnectivity), external proxy endpoint (XksProxyUriEndpoint)
// and path (XksProxyUriPath). For external key stores with an XksProxyConnectivity
// of VPC_ENDPOINT_SERVICE, you can also update the Amazon VPC endpoint service
// name (XksProxyVpcEndpointServiceName). To update most properties of an external
// key store, the ConnectionState of the external key store must be DISCONNECTED.
// However, you can update the CustomKeyStoreName, XksProxyAuthenticationCredential,
// and XksProxyUriPath of an external key store when it is in the CONNECTED
// or DISCONNECTED state.
//
// If your update requires a DISCONNECTED state, before using UpdateCustomKeyStore,
// use the DisconnectCustomKeyStore operation to disconnect the custom key store.
// After the UpdateCustomKeyStore operation completes, use the ConnectCustomKeyStore
// to reconnect the custom key store. To find the ConnectionState of the custom
// key store, use the DescribeCustomKeyStores operation.
//
// Before updating the custom key store, verify that the new values allow KMS
// to connect the custom key store to its backing key store. For example, before
// you change the XksProxyUriPath value, verify that the external key store
// proxy is reachable at the new path.
//
// If the operation succeeds, it returns a JSON object with no properties.
//
// Cross-account use: No. You cannot perform this operation on a custom key
// store in a different Amazon Web Services account.
//
// Required permissions: kms:UpdateCustomKeyStore (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (IAM policy)
//
// Related operations:
//
//   - ConnectCustomKeyStore
//
//   - CreateCustomKeyStore
//
//   - DeleteCustomKeyStore
//
//   - DescribeCustomKeyStores
//
//   - DisconnectCustomKeyStore
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation UpdateCustomKeyStore for usage and error information.
//
// Returned Error Types:
//
//   - CustomKeyStoreNotFoundException
//     The request was rejected because KMS cannot find a custom key store with
//     the specified key store name or ID.
//
//   - CustomKeyStoreNameInUseException
//     The request was rejected because the specified custom key store name is already
//     assigned to another custom key store in the account. Try again with a custom
//     key store name that is unique in the account.
//
//   - CloudHsmClusterNotFoundException
//     The request was rejected because KMS cannot find the CloudHSM cluster with
//     the specified cluster ID. Retry the request with a different cluster ID.
//
//   - CloudHsmClusterNotRelatedException
//     The request was rejected because the specified CloudHSM cluster has a different
//     cluster certificate than the original cluster. You cannot use the operation
//     to specify an unrelated cluster for an CloudHSM key store.
//
//     Specify an CloudHSM cluster that shares a backup history with the original
//     cluster. This includes clusters that were created from a backup of the current
//     cluster, and clusters that were created from the same backup that produced
//     the current cluster.
//
//     CloudHSM clusters that share a backup history have the same cluster certificate.
//     To view the cluster certificate of an CloudHSM cluster, use the DescribeClusters
//     (https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html)
//     operation.
//
//   - CustomKeyStoreInvalidStateException
//     The request was rejected because of the ConnectionState of the custom key
//     store. To get the ConnectionState of a custom key store, use the DescribeCustomKeyStores
//     operation.
//
//     This exception is thrown under the following conditions:
//
//   - You requested the ConnectCustomKeyStore operation on a custom key store
//     with a ConnectionState of DISCONNECTING or FAILED. This operation is valid
//     for all other ConnectionState values. To reconnect a custom key store
//     in a FAILED state, disconnect it (DisconnectCustomKeyStore), then connect
//     it (ConnectCustomKeyStore).
//
//   - You requested the CreateKey operation in a custom key store that is
//     not connected. This operations is valid only when the custom key store
//     ConnectionState is CONNECTED.
//
//   - You requested the DisconnectCustomKeyStore operation on a custom key
//     store with a ConnectionState of DISCONNECTING or DISCONNECTED. This operation
//     is valid for all other ConnectionState values.
//
//   - You requested the UpdateCustomKeyStore or DeleteCustomKeyStore operation
//     on a custom key store that is not disconnected. This operation is valid
//     only when the custom key store ConnectionState is DISCONNECTED.
//
//   - You requested the GenerateRandom operation in an CloudHSM key store
//     that is not connected. This operation is valid only when the CloudHSM
//     key store ConnectionState is CONNECTED.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - CloudHsmClusterNotActiveException
//     The request was rejected because the CloudHSM cluster associated with the
//     CloudHSM key store is not active. Initialize and activate the cluster and
//     try the command again. For detailed instructions, see Getting Started (https://docs.aws.amazon.com/cloudhsm/latest/userguide/getting-started.html)
//     in the CloudHSM User Guide.
//
//   - CloudHsmClusterInvalidConfigurationException
//     The request was rejected because the associated CloudHSM cluster did not
//     meet the configuration requirements for an CloudHSM key store.
//
//   - The CloudHSM cluster must be configured with private subnets in at least
//     two different Availability Zones in the Region.
//
//   - The security group for the cluster (https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html)
//     (cloudhsm-cluster-<cluster-id>-sg) must include inbound rules and outbound
//     rules that allow TCP traffic on ports 2223-2225. The Source in the inbound
//     rules and the Destination in the outbound rules must match the security
//     group ID. These rules are set by default when you create the CloudHSM
//     cluster. Do not delete or change them. To get information about a particular
//     security group, use the DescribeSecurityGroups (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroups.html)
//     operation.
//
//   - The CloudHSM cluster must contain at least as many HSMs as the operation
//     requires. To add HSMs, use the CloudHSM CreateHsm (https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_CreateHsm.html)
//     operation. For the CreateCustomKeyStore, UpdateCustomKeyStore, and CreateKey
//     operations, the CloudHSM cluster must have at least two active HSMs, each
//     in a different Availability Zone. For the ConnectCustomKeyStore operation,
//     the CloudHSM must contain at least one active HSM.
//
//     For information about the requirements for an CloudHSM cluster that is associated
//     with an CloudHSM key store, see Assemble the Prerequisites (https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore)
//     in the Key Management Service Developer Guide. For information about creating
//     a private subnet for an CloudHSM cluster, see Create a Private Subnet (https://docs.aws.amazon.com/cloudhsm/latest/userguide/create-subnets.html)
//     in the CloudHSM User Guide. For information about cluster security groups,
//     see Configure a Default Security Group (https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html)
//     in the CloudHSM User Guide .
//
//   - XksProxyUriInUseException
//     The request was rejected because the concatenation of the XksProxyUriEndpoint
//     and XksProxyUriPath is already associated with an external key store in the
//     Amazon Web Services account and Region. Each external key store in an account
//     and Region must use a unique external key store proxy API address.
//
//   - XksProxyUriEndpointInUseException
//     The request was rejected because the concatenation of the XksProxyUriEndpoint
//     is already associated with an external key store in the Amazon Web Services
//     account and Region. Each external key store in an account and Region must
//     use a unique external key store proxy address.
//
//   - XksProxyUriUnreachableException
//     KMS was unable to reach the specified XksProxyUriPath. The path must be reachable
//     before you create the external key store or update its settings.
//
//     This exception is also thrown when the external key store proxy response
//     to a GetHealthStatus request indicates that all external key manager instances
//     are unavailable.
//
//   - XksProxyIncorrectAuthenticationCredentialException
//     The request was rejected because the proxy credentials failed to authenticate
//     to the specified external key store proxy. The specified external key store
//     proxy rejected a status request from KMS due to invalid credentials. This
//     can indicate an error in the credentials or in the identification of the
//     external key store proxy.
//
//   - XksProxyVpcEndpointServiceInUseException
//     The request was rejected because the specified Amazon VPC endpoint service
//     is already associated with an external key store in the Amazon Web Services
//     account and Region. Each external key store in an Amazon Web Services account
//     and Region must use a different Amazon VPC endpoint service.
//
//   - XksProxyVpcEndpointServiceNotFoundException
//     The request was rejected because KMS could not find the specified VPC endpoint
//     service. Use DescribeCustomKeyStores to verify the VPC endpoint service name
//     for the external key store. Also, confirm that the Allow principals list
//     for the VPC endpoint service includes the KMS service principal for the Region,
//     such as cks.kms.us-east-1.amazonaws.com.
//
//   - XksProxyVpcEndpointServiceInvalidConfigurationException
//     The request was rejected because the Amazon VPC endpoint service configuration
//     does not fulfill the requirements for an external key store proxy. For details,
//     see the exception message and review the requirements (kms/latest/developerguide/vpc-connectivity.html#xks-vpc-requirements)
//     for Amazon VPC endpoint service connectivity for an external key store.
//
//   - XksProxyInvalidResponseException
//     KMS cannot interpret the response it received from the external key store
//     proxy. The problem might be a poorly constructed response, but it could also
//     be a transient network issue. If you see this error repeatedly, report it
//     to the proxy vendor.
//
//   - XksProxyInvalidConfigurationException
//     The request was rejected because the Amazon VPC endpoint service configuration
//     does not fulfill the requirements for an external key store proxy. For details,
//     see the exception message.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/UpdateCustomKeyStore
func (c *KMS) UpdateCustomKeyStore(input *UpdateCustomKeyStoreInput) (*UpdateCustomKeyStoreOutput, error) {
	req, out := c.UpdateCustomKeyStoreRequest(input)
	return out, req.Send()
}

// UpdateCustomKeyStoreWithContext is the same as UpdateCustomKeyStore with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCustomKeyStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) UpdateCustomKeyStoreWithContext(ctx aws.Context, input *UpdateCustomKeyStoreInput, opts ...request.Option) (*UpdateCustomKeyStoreOutput, error) {
	req, out := c.UpdateCustomKeyStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateKeyDescription = "UpdateKeyDescription"

// UpdateKeyDescriptionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateKeyDescription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateKeyDescription for more information on using the UpdateKeyDescription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateKeyDescriptionRequest method.
//	req, resp := client.UpdateKeyDescriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/UpdateKeyDescription
func (c *KMS) UpdateKeyDescriptionRequest(input *UpdateKeyDescriptionInput) (req *request.Request, output *UpdateKeyDescriptionOutput) {
	op := &request.Operation{
		Name:       opUpdateKeyDescription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateKeyDescriptionInput{}
	}

	output = &UpdateKeyDescriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateKeyDescription API operation for AWS Key Management Service.
//
// Updates the description of a KMS key. To see the description of a KMS key,
// use DescribeKey.
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: No. You cannot perform this operation on a KMS key in
// a different Amazon Web Services account.
//
// Required permissions: kms:UpdateKeyDescription (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations
//
//   - CreateKey
//
//   - DescribeKey
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation UpdateKeyDescription for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/UpdateKeyDescription
func (c *KMS) UpdateKeyDescription(input *UpdateKeyDescriptionInput) (*UpdateKeyDescriptionOutput, error) {
	req, out := c.UpdateKeyDescriptionRequest(input)
	return out, req.Send()
}

// UpdateKeyDescriptionWithContext is the same as UpdateKeyDescription with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateKeyDescription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) UpdateKeyDescriptionWithContext(ctx aws.Context, input *UpdateKeyDescriptionInput, opts ...request.Option) (*UpdateKeyDescriptionOutput, error) {
	req, out := c.UpdateKeyDescriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePrimaryRegion = "UpdatePrimaryRegion"

// UpdatePrimaryRegionRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePrimaryRegion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePrimaryRegion for more information on using the UpdatePrimaryRegion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePrimaryRegionRequest method.
//	req, resp := client.UpdatePrimaryRegionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/UpdatePrimaryRegion
func (c *KMS) UpdatePrimaryRegionRequest(input *UpdatePrimaryRegionInput) (req *request.Request, output *UpdatePrimaryRegionOutput) {
	op := &request.Operation{
		Name:       opUpdatePrimaryRegion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePrimaryRegionInput{}
	}

	output = &UpdatePrimaryRegionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdatePrimaryRegion API operation for AWS Key Management Service.
//
// Changes the primary key of a multi-Region key.
//
// This operation changes the replica key in the specified Region to a primary
// key and changes the former primary key to a replica key. For example, suppose
// you have a primary key in us-east-1 and a replica key in eu-west-2. If you
// run UpdatePrimaryRegion with a PrimaryRegion value of eu-west-2, the primary
// key is now the key in eu-west-2, and the key in us-east-1 becomes a replica
// key. For details, see Updating the primary Region (https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-manage.html#multi-region-update)
// in the Key Management Service Developer Guide.
//
// This operation supports multi-Region keys, an KMS feature that lets you create
// multiple interoperable KMS keys in different Amazon Web Services Regions.
// Because these KMS keys have the same key ID, key material, and other metadata,
// you can use them interchangeably to encrypt data in one Amazon Web Services
// Region and decrypt it in a different Amazon Web Services Region without re-encrypting
// the data or making a cross-Region call. For more information about multi-Region
// keys, see Multi-Region keys in KMS (https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html)
// in the Key Management Service Developer Guide.
//
// The primary key of a multi-Region key is the source for properties that are
// always shared by primary and replica keys, including the key material, key
// ID (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id),
// key spec (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-spec),
// key usage (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-usage),
// key material origin (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-origin),
// and automatic key rotation (https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html).
// It's the only key that can be replicated. You cannot delete the primary key
// (https://docs.aws.amazon.com/kms/latest/APIReference/API_ScheduleKeyDeletion.html)
// until all replica keys are deleted.
//
// The key ID and primary Region that you specify uniquely identify the replica
// key that will become the primary key. The primary Region must already have
// a replica key. This operation does not create a KMS key in the specified
// Region. To find the replica keys, use the DescribeKey operation on the primary
// key or any replica key. To create a replica key, use the ReplicateKey operation.
//
// You can run this operation while using the affected multi-Region keys in
// cryptographic operations. This operation should not delay, interrupt, or
// cause failures in cryptographic operations.
//
// Even after this operation completes, the process of updating the primary
// Region might still be in progress for a few more seconds. Operations such
// as DescribeKey might display both the old and new primary keys as replicas.
// The old and new primary keys have a transient key state of Updating. The
// original key state is restored when the update is complete. While the key
// state is Updating, you can use the keys in cryptographic operations, but
// you cannot replicate the new primary key or perform certain management operations,
// such as enabling or disabling these keys. For details about the Updating
// key state, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// This operation does not return any output. To verify that primary key is
// changed, use the DescribeKey operation.
//
// Cross-account use: No. You cannot use this operation in a different Amazon
// Web Services account.
//
// Required permissions:
//
//   - kms:UpdatePrimaryRegion on the current primary key (in the primary key's
//     Region). Include this permission primary key's key policy.
//
//   - kms:UpdatePrimaryRegion on the current replica key (in the replica key's
//     Region). Include this permission in the replica key's key policy.
//
// Related operations
//
//   - CreateKey
//
//   - ReplicateKey
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation UpdatePrimaryRegion for usage and error information.
//
// Returned Error Types:
//
//   - DisabledException
//     The request was rejected because the specified KMS key is not enabled.
//
//   - InvalidArnException
//     The request was rejected because a specified ARN, or an ARN in a key policy,
//     is not valid.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - UnsupportedOperationException
//     The request was rejected because a specified parameter is not supported or
//     a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/UpdatePrimaryRegion
func (c *KMS) UpdatePrimaryRegion(input *UpdatePrimaryRegionInput) (*UpdatePrimaryRegionOutput, error) {
	req, out := c.UpdatePrimaryRegionRequest(input)
	return out, req.Send()
}

// UpdatePrimaryRegionWithContext is the same as UpdatePrimaryRegion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePrimaryRegion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) UpdatePrimaryRegionWithContext(ctx aws.Context, input *UpdatePrimaryRegionInput, opts ...request.Option) (*UpdatePrimaryRegionOutput, error) {
	req, out := c.UpdatePrimaryRegionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opVerify = "Verify"

// VerifyRequest generates a "aws/request.Request" representing the
// client's request for the Verify operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Verify for more information on using the Verify
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the VerifyRequest method.
//	req, resp := client.VerifyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/Verify
func (c *KMS) VerifyRequest(input *VerifyInput) (req *request.Request, output *VerifyOutput) {
	op := &request.Operation{
		Name:       opVerify,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyInput{}
	}

	output = &VerifyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Verify API operation for AWS Key Management Service.
//
// Verifies a digital signature that was generated by the Sign operation.
//
// Verification confirms that an authorized user signed the message with the
// specified KMS key and signing algorithm, and the message hasn't changed since
// it was signed. If the signature is verified, the value of the SignatureValid
// field in the response is True. If the signature verification fails, the Verify
// operation fails with an KMSInvalidSignatureException exception.
//
// A digital signature is generated by using the private key in an asymmetric
// KMS key. The signature is verified by using the public key in the same asymmetric
// KMS key. For information about asymmetric KMS keys, see Asymmetric KMS keys
// (https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
// in the Key Management Service Developer Guide.
//
// To verify a digital signature, you can use the Verify operation. Specify
// the same asymmetric KMS key, message, and signing algorithm that were used
// to produce the signature.
//
// You can also verify the digital signature by using the public key of the
// KMS key outside of KMS. Use the GetPublicKey operation to download the public
// key in the asymmetric KMS key and then use the public key to verify the signature
// outside of KMS. The advantage of using the Verify operation is that it is
// performed within KMS. As a result, it's easy to call, the operation is performed
// within the FIPS boundary, it is logged in CloudTrail, and you can use key
// policy and IAM policy to determine who is authorized to use the KMS key to
// verify signatures.
//
// To verify a signature outside of KMS with an SM2 public key (China Regions
// only), you must specify the distinguishing ID. By default, KMS uses 1234567812345678
// as the distinguishing ID. For more information, see Offline verification
// with SM2 key pairs (https://docs.aws.amazon.com/kms/latest/developerguide/asymmetric-key-specs.html#key-spec-sm-offline-verification).
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: Yes. To perform this operation with a KMS key in a different
// Amazon Web Services account, specify the key ARN or alias ARN in the value
// of the KeyId parameter.
//
// Required permissions: kms:Verify (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations: Sign
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation Verify for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - DisabledException
//     The request was rejected because the specified KMS key is not enabled.
//
//   - KeyUnavailableException
//     The request was rejected because the specified KMS key was not available.
//     You can retry the request.
//
//   - DependencyTimeoutException
//     The system timed out while trying to fulfill the request. You can retry the
//     request.
//
//   - InvalidKeyUsageException
//     The request was rejected for one of the following reasons:
//
//   - The KeyUsage value of the KMS key is incompatible with the API operation.
//
//   - The encryption algorithm or signing algorithm specified for the operation
//     is incompatible with the type of key material in the KMS key (KeySpec).
//
//     For encrypting, decrypting, re-encrypting, and generating data keys, the
//     KeyUsage must be ENCRYPT_DECRYPT. For signing and verifying messages, the
//     KeyUsage must be SIGN_VERIFY. For generating and verifying message authentication
//     codes (MACs), the KeyUsage must be GENERATE_VERIFY_MAC. To find the KeyUsage
//     of a KMS key, use the DescribeKey operation.
//
//     To find the encryption or signing algorithms supported for a particular KMS
//     key, use the DescribeKey operation.
//
//   - InvalidGrantTokenException
//     The request was rejected because the specified grant token is not valid.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
//   - KMSInvalidSignatureException
//     The request was rejected because the signature verification failed. Signature
//     verification fails when it cannot confirm that signature was produced by
//     signing the specified message with the specified KMS key and signing algorithm.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/Verify
func (c *KMS) Verify(input *VerifyInput) (*VerifyOutput, error) {
	req, out := c.VerifyRequest(input)
	return out, req.Send()
}

// VerifyWithContext is the same as Verify with the addition of
// the ability to pass a context and additional request options.
//
// See Verify for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) VerifyWithContext(ctx aws.Context, input *VerifyInput, opts ...request.Option) (*VerifyOutput, error) {
	req, out := c.VerifyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opVerifyMac = "VerifyMac"

// VerifyMacRequest generates a "aws/request.Request" representing the
// client's request for the VerifyMac operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See VerifyMac for more information on using the VerifyMac
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the VerifyMacRequest method.
//	req, resp := client.VerifyMacRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/VerifyMac
func (c *KMS) VerifyMacRequest(input *VerifyMacInput) (req *request.Request, output *VerifyMacOutput) {
	op := &request.Operation{
		Name:       opVerifyMac,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyMacInput{}
	}

	output = &VerifyMacOutput{}
	req = c.newRequest(op, input, output)
	return
}

// VerifyMac API operation for AWS Key Management Service.
//
// Verifies the hash-based message authentication code (HMAC) for a specified
// message, HMAC KMS key, and MAC algorithm. To verify the HMAC, VerifyMac computes
// an HMAC using the message, HMAC KMS key, and MAC algorithm that you specify,
// and compares the computed HMAC to the HMAC that you specify. If the HMACs
// are identical, the verification succeeds; otherwise, it fails. Verification
// indicates that the message hasn't changed since the HMAC was calculated,
// and the specified key was used to generate and verify the HMAC.
//
// HMAC KMS keys and the HMAC algorithms that KMS uses conform to industry standards
// defined in RFC 2104 (https://datatracker.ietf.org/doc/html/rfc2104).
//
// This operation is part of KMS support for HMAC KMS keys. For details, see
// HMAC keys in KMS (https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html)
// in the Key Management Service Developer Guide.
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Key Management Service Developer Guide.
//
// Cross-account use: Yes. To perform this operation with a KMS key in a different
// Amazon Web Services account, specify the key ARN or alias ARN in the value
// of the KeyId parameter.
//
// Required permissions: kms:VerifyMac (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
// (key policy)
//
// Related operations: GenerateMac
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation VerifyMac for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     The request was rejected because the specified entity or resource could not
//     be found.
//
//   - DisabledException
//     The request was rejected because the specified KMS key is not enabled.
//
//   - KeyUnavailableException
//     The request was rejected because the specified KMS key was not available.
//     You can retry the request.
//
//   - InvalidKeyUsageException
//     The request was rejected for one of the following reasons:
//
//   - The KeyUsage value of the KMS key is incompatible with the API operation.
//
//   - The encryption algorithm or signing algorithm specified for the operation
//     is incompatible with the type of key material in the KMS key (KeySpec).
//
//     For encrypting, decrypting, re-encrypting, and generating data keys, the
//     KeyUsage must be ENCRYPT_DECRYPT. For signing and verifying messages, the
//     KeyUsage must be SIGN_VERIFY. For generating and verifying message authentication
//     codes (MACs), the KeyUsage must be GENERATE_VERIFY_MAC. To find the KeyUsage
//     of a KMS key, use the DescribeKey operation.
//
//     To find the encryption or signing algorithms supported for a particular KMS
//     key, use the DescribeKey operation.
//
//   - InvalidGrantTokenException
//     The request was rejected because the specified grant token is not valid.
//
//   - InternalException
//     The request was rejected because an internal exception occurred. The request
//     can be retried.
//
//   - KMSInvalidMacException
//     The request was rejected because the HMAC verification failed. HMAC verification
//     fails when the HMAC computed by using the specified message, HMAC KMS key,
//     and MAC algorithm does not match the HMAC specified in the request.
//
//   - InvalidStateException
//     The request was rejected because the state of the specified resource is not
//     valid for this request.
//
//     This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/VerifyMac
func (c *KMS) VerifyMac(input *VerifyMacInput) (*VerifyMacOutput, error) {
	req, out := c.VerifyMacRequest(input)
	return out, req.Send()
}

// VerifyMacWithContext is the same as VerifyMac with the addition of
// the ability to pass a context and additional request options.
//
// See VerifyMac for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) VerifyMacWithContext(ctx aws.Context, input *VerifyMacInput, opts ...request.Option) (*VerifyMacOutput, error) {
	req, out := c.VerifyMacRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Contains information about an alias.
type AliasListEntry struct {
	_ struct{} `type:"structure"`

	// String that contains the key ARN.
	AliasArn *string `min:"20" type:"string"`

	// String that contains the alias. This value begins with alias/.
	AliasName *string `min:"1" type:"string"`

	// Date and time that the alias was most recently created in the account and
	// Region. Formatted as Unix time.
	CreationDate *time.Time `type:"timestamp"`

	// Date and time that the alias was most recently associated with a KMS key
	// in the account and Region. Formatted as Unix time.
	LastUpdatedDate *time.Time `type:"timestamp"`

	// String that contains the key identifier of the KMS key associated with the
	// alias.
	TargetKeyId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AliasListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AliasListEntry) GoString() string {
	return s.String()
}

// SetAliasArn sets the AliasArn field's value.
func (s *AliasListEntry) SetAliasArn(v string) *AliasListEntry {
	s.AliasArn = &v
	return s
}

// SetAliasName sets the AliasName field's value.
func (s *AliasListEntry) SetAliasName(v string) *AliasListEntry {
	s.AliasName = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *AliasListEntry) SetCreationDate(v time.Time) *AliasListEntry {
	s.CreationDate = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *AliasListEntry) SetLastUpdatedDate(v time.Time) *AliasListEntry {
	s.LastUpdatedDate = &v
	return s
}

// SetTargetKeyId sets the TargetKeyId field's value.
func (s *AliasListEntry) SetTargetKeyId(v string) *AliasListEntry {
	s.TargetKeyId = &v
	return s
}

// The request was rejected because it attempted to create a resource that already
// exists.
type AlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &AlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AlreadyExistsException) Code() string {
	return "AlreadyExistsException"
}

// Message returns the exception's message.
func (s *AlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AlreadyExistsException) OrigErr() error {
	return nil
}

func (s *AlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CancelKeyDeletionInput struct {
	_ struct{} `type:"structure"`

	// Identifies the KMS key whose deletion is being canceled.
	//
	// Specify the key ID or key ARN of the KMS key.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelKeyDeletionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelKeyDeletionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelKeyDeletionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelKeyDeletionInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyId sets the KeyId field's value.
func (s *CancelKeyDeletionInput) SetKeyId(v string) *CancelKeyDeletionInput {
	s.KeyId = &v
	return s
}

type CancelKeyDeletionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (key ARN (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN))
	// of the KMS key whose deletion is canceled.
	KeyId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelKeyDeletionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelKeyDeletionOutput) GoString() string {
	return s.String()
}

// SetKeyId sets the KeyId field's value.
func (s *CancelKeyDeletionOutput) SetKeyId(v string) *CancelKeyDeletionOutput {
	s.KeyId = &v
	return s
}

// The request was rejected because the specified CloudHSM cluster is already
// associated with an CloudHSM key store in the account, or it shares a backup
// history with an CloudHSM key store in the account. Each CloudHSM key store
// in the account must be associated with a different CloudHSM cluster.
//
// CloudHSM clusters that share a backup history have the same cluster certificate.
// To view the cluster certificate of an CloudHSM cluster, use the DescribeClusters
// (https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html)
// operation.
type CloudHsmClusterInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudHsmClusterInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudHsmClusterInUseException) GoString() string {
	return s.String()
}

func newErrorCloudHsmClusterInUseException(v protocol.ResponseMetadata) error {
	return &CloudHsmClusterInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CloudHsmClusterInUseException) Code() string {
	return "CloudHsmClusterInUseException"
}

// Message returns the exception's message.
func (s *CloudHsmClusterInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CloudHsmClusterInUseException) OrigErr() error {
	return nil
}

func (s *CloudHsmClusterInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CloudHsmClusterInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CloudHsmClusterInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because the associated CloudHSM cluster did not
// meet the configuration requirements for an CloudHSM key store.
//
//   - The CloudHSM cluster must be configured with private subnets in at least
//     two different Availability Zones in the Region.
//
//   - The security group for the cluster (https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html)
//     (cloudhsm-cluster-<cluster-id>-sg) must include inbound rules and outbound
//     rules that allow TCP traffic on ports 2223-2225. The Source in the inbound
//     rules and the Destination in the outbound rules must match the security
//     group ID. These rules are set by default when you create the CloudHSM
//     cluster. Do not delete or change them. To get information about a particular
//     security group, use the DescribeSecurityGroups (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroups.html)
//     operation.
//
//   - The CloudHSM cluster must contain at least as many HSMs as the operation
//     requires. To add HSMs, use the CloudHSM CreateHsm (https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_CreateHsm.html)
//     operation. For the CreateCustomKeyStore, UpdateCustomKeyStore, and CreateKey
//     operations, the CloudHSM cluster must have at least two active HSMs, each
//     in a different Availability Zone. For the ConnectCustomKeyStore operation,
//     the CloudHSM must contain at least one active HSM.
//
// For information about the requirements for an CloudHSM cluster that is associated
// with an CloudHSM key store, see Assemble the Prerequisites (https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore)
// in the Key Management Service Developer Guide. For information about creating
// a private subnet for an CloudHSM cluster, see Create a Private Subnet (https://docs.aws.amazon.com/cloudhsm/latest/userguide/create-subnets.html)
// in the CloudHSM User Guide. For information about cluster security groups,
// see Configure a Default Security Group (https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html)
// in the CloudHSM User Guide .
type CloudHsmClusterInvalidConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudHsmClusterInvalidConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudHsmClusterInvalidConfigurationException) GoString() string {
	return s.String()
}

func newErrorCloudHsmClusterInvalidConfigurationException(v protocol.ResponseMetadata) error {
	return &CloudHsmClusterInvalidConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CloudHsmClusterInvalidConfigurationException) Code() string {
	return "CloudHsmClusterInvalidConfigurationException"
}

// Message returns the exception's message.
func (s *CloudHsmClusterInvalidConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CloudHsmClusterInvalidConfigurationException) OrigErr() error {
	return nil
}

func (s *CloudHsmClusterInvalidConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CloudHsmClusterInvalidConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CloudHsmClusterInvalidConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because the CloudHSM cluster associated with the
// CloudHSM key store is not active. Initialize and activate the cluster and
// try the command again. For detailed instructions, see Getting Started (https://docs.aws.amazon.com/cloudhsm/latest/userguide/getting-started.html)
// in the CloudHSM User Guide.
type CloudHsmClusterNotActiveException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudHsmClusterNotActiveException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudHsmClusterNotActiveException) GoString() string {
	return s.String()
}

func newErrorCloudHsmClusterNotActiveException(v protocol.ResponseMetadata) error {
	return &CloudHsmClusterNotActiveException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CloudHsmClusterNotActiveException) Code() string {
	return "CloudHsmClusterNotActiveException"
}

// Message returns the exception's message.
func (s *CloudHsmClusterNotActiveException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CloudHsmClusterNotActiveException) OrigErr() error {
	return nil
}

func (s *CloudHsmClusterNotActiveException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CloudHsmClusterNotActiveException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CloudHsmClusterNotActiveException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because KMS cannot find the CloudHSM cluster with
// the specified cluster ID. Retry the request with a different cluster ID.
type CloudHsmClusterNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudHsmClusterNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudHsmClusterNotFoundException) GoString() string {
	return s.String()
}

func newErrorCloudHsmClusterNotFoundException(v protocol.ResponseMetadata) error {
	return &CloudHsmClusterNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CloudHsmClusterNotFoundException) Code() string {
	return "CloudHsmClusterNotFoundException"
}

// Message returns the exception's message.
func (s *CloudHsmClusterNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CloudHsmClusterNotFoundException) OrigErr() error {
	return nil
}

func (s *CloudHsmClusterNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CloudHsmClusterNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CloudHsmClusterNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because the specified CloudHSM cluster has a different
// cluster certificate than the original cluster. You cannot use the operation
// to specify an unrelated cluster for an CloudHSM key store.
//
// Specify an CloudHSM cluster that shares a backup history with the original
// cluster. This includes clusters that were created from a backup of the current
// cluster, and clusters that were created from the same backup that produced
// the current cluster.
//
// CloudHSM clusters that share a backup history have the same cluster certificate.
// To view the cluster certificate of an CloudHSM cluster, use the DescribeClusters
// (https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html)
// operation.
type CloudHsmClusterNotRelatedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudHsmClusterNotRelatedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudHsmClusterNotRelatedException) GoString() string {
	return s.String()
}

func newErrorCloudHsmClusterNotRelatedException(v protocol.ResponseMetadata) error {
	return &CloudHsmClusterNotRelatedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CloudHsmClusterNotRelatedException) Code() string {
	return "CloudHsmClusterNotRelatedException"
}

// Message returns the exception's message.
func (s *CloudHsmClusterNotRelatedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CloudHsmClusterNotRelatedException) OrigErr() error {
	return nil
}

func (s *CloudHsmClusterNotRelatedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CloudHsmClusterNotRelatedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CloudHsmClusterNotRelatedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ConnectCustomKeyStoreInput struct {
	_ struct{} `type:"structure"`

	// Enter the key store ID of the custom key store that you want to connect.
	// To find the ID of a custom key store, use the DescribeCustomKeyStores operation.
	//
	// CustomKeyStoreId is a required field
	CustomKeyStoreId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectCustomKeyStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectCustomKeyStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectCustomKeyStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConnectCustomKeyStoreInput"}
	if s.CustomKeyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomKeyStoreId"))
	}
	if s.CustomKeyStoreId != nil && len(*s.CustomKeyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomKeyStoreId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomKeyStoreId sets the CustomKeyStoreId field's value.
func (s *ConnectCustomKeyStoreInput) SetCustomKeyStoreId(v string) *ConnectCustomKeyStoreInput {
	s.CustomKeyStoreId = &v
	return s
}

type ConnectCustomKeyStoreOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectCustomKeyStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectCustomKeyStoreOutput) GoString() string {
	return s.String()
}

type CreateAliasInput struct {
	_ struct{} `type:"structure"`

	// Specifies the alias name. This value must begin with alias/ followed by a
	// name, such as alias/ExampleAlias.
	//
	// The AliasName value must be string of 1-256 characters. It can contain only
	// alphanumeric characters, forward slashes (/), underscores (_), and dashes
	// (-). The alias name cannot begin with alias/aws/. The alias/aws/ prefix is
	// reserved for Amazon Web Services managed keys (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk).
	//
	// AliasName is a required field
	AliasName *string `min:"1" type:"string" required:"true"`

	// Associates the alias with the specified customer managed key (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk).
	// The KMS key must be in the same Amazon Web Services Region.
	//
	// A valid key ID is required. If you supply a null or empty string value, this
	// operation returns an error.
	//
	// For help finding the key ID and ARN, see Finding the Key ID and ARN (https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html#find-cmk-id-arn)
	// in the Key Management Service Developer Guide .
	//
	// Specify the key ID or key ARN of the KMS key.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// TargetKeyId is a required field
	TargetKeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAliasInput"}
	if s.AliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 1))
	}
	if s.TargetKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetKeyId"))
	}
	if s.TargetKeyId != nil && len(*s.TargetKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasName sets the AliasName field's value.
func (s *CreateAliasInput) SetAliasName(v string) *CreateAliasInput {
	s.AliasName = &v
	return s
}

// SetTargetKeyId sets the TargetKeyId field's value.
func (s *CreateAliasInput) SetTargetKeyId(v string) *CreateAliasInput {
	s.TargetKeyId = &v
	return s
}

type CreateAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAliasOutput) GoString() string {
	return s.String()
}

type CreateCustomKeyStoreInput struct {
	_ struct{} `type:"structure"`

	// Identifies the CloudHSM cluster for an CloudHSM key store. This parameter
	// is required for custom key stores with CustomKeyStoreType of AWS_CLOUDHSM.
	//
	// Enter the cluster ID of any active CloudHSM cluster that is not already associated
	// with a custom key store. To find the cluster ID, use the DescribeClusters
	// (https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html)
	// operation.
	CloudHsmClusterId *string `min:"19" type:"string"`

	// Specifies a friendly name for the custom key store. The name must be unique
	// in your Amazon Web Services account and Region. This parameter is required
	// for all custom key stores.
	//
	// CustomKeyStoreName is a required field
	CustomKeyStoreName *string `min:"1" type:"string" required:"true"`

	// Specifies the type of custom key store. The default value is AWS_CLOUDHSM.
	//
	// For a custom key store backed by an CloudHSM cluster, omit the parameter
	// or enter AWS_CLOUDHSM. For a custom key store backed by an external key manager
	// outside of Amazon Web Services, enter EXTERNAL_KEY_STORE. You cannot change
	// this property after the key store is created.
	CustomKeyStoreType *string `type:"string" enum:"CustomKeyStoreType"`

	// Specifies the kmsuser password for an CloudHSM key store. This parameter
	// is required for custom key stores with a CustomKeyStoreType of AWS_CLOUDHSM.
	//
	// Enter the password of the kmsuser crypto user (CU) account (https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser)
	// in the specified CloudHSM cluster. KMS logs into the cluster as this user
	// to manage key material on your behalf.
	//
	// The password must be a string of 7 to 32 characters. Its value is case sensitive.
	//
	// This parameter tells KMS the kmsuser account password; it does not change
	// the password in the CloudHSM cluster.
	//
	// KeyStorePassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateCustomKeyStoreInput's
	// String and GoString methods.
	KeyStorePassword *string `min:"7" type:"string" sensitive:"true"`

	// Specifies the certificate for an CloudHSM key store. This parameter is required
	// for custom key stores with a CustomKeyStoreType of AWS_CLOUDHSM.
	//
	// Enter the content of the trust anchor certificate for the CloudHSM cluster.
	// This is the content of the customerCA.crt file that you created when you
	// initialized the cluster (https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html).
	TrustAnchorCertificate *string `min:"1" type:"string"`

	// Specifies an authentication credential for the external key store proxy (XKS
	// proxy). This parameter is required for all custom key stores with a CustomKeyStoreType
	// of EXTERNAL_KEY_STORE.
	//
	// The XksProxyAuthenticationCredential has two required elements: RawSecretAccessKey,
	// a secret key, and AccessKeyId, a unique identifier for the RawSecretAccessKey.
	// For character requirements, see XksProxyAuthenticationCredentialType (kms/latest/APIReference/API_XksProxyAuthenticationCredentialType.html).
	//
	// KMS uses this authentication credential to sign requests to the external
	// key store proxy on your behalf. This credential is unrelated to Identity
	// and Access Management (IAM) and Amazon Web Services credentials.
	//
	// This parameter doesn't set or change the authentication credentials on the
	// XKS proxy. It just tells KMS the credential that you established on your
	// external key store proxy. If you rotate your proxy authentication credential,
	// use the UpdateCustomKeyStore operation to provide the new credential to KMS.
	XksProxyAuthenticationCredential *XksProxyAuthenticationCredentialType `type:"structure"`

	// Indicates how KMS communicates with the external key store proxy. This parameter
	// is required for custom key stores with a CustomKeyStoreType of EXTERNAL_KEY_STORE.
	//
	// If the external key store proxy uses a public endpoint, specify PUBLIC_ENDPOINT.
	// If the external key store proxy uses a Amazon VPC endpoint service for communication
	// with KMS, specify VPC_ENDPOINT_SERVICE. For help making this choice, see
	// Choosing a connectivity option (https://docs.aws.amazon.com/kms/latest/developerguide/plan-xks-keystore.html#choose-xks-connectivity)
	// in the Key Management Service Developer Guide.
	//
	// An Amazon VPC endpoint service keeps your communication with KMS in a private
	// address space entirely within Amazon Web Services, but it requires more configuration,
	// including establishing a Amazon VPC with multiple subnets, a VPC endpoint
	// service, a network load balancer, and a verified private DNS name. A public
	// endpoint is simpler to set up, but it might be slower and might not fulfill
	// your security requirements. You might consider testing with a public endpoint,
	// and then establishing a VPC endpoint service for production tasks. Note that
	// this choice does not determine the location of the external key store proxy.
	// Even if you choose a VPC endpoint service, the proxy can be hosted within
	// the VPC or outside of Amazon Web Services such as in your corporate data
	// center.
	XksProxyConnectivity *string `type:"string" enum:"XksProxyConnectivityType"`

	// Specifies the endpoint that KMS uses to send requests to the external key
	// store proxy (XKS proxy). This parameter is required for custom key stores
	// with a CustomKeyStoreType of EXTERNAL_KEY_STORE.
	//
	// The protocol must be HTTPS. KMS communicates on port 443. Do not specify
	// the port in the XksProxyUriEndpoint value.
	//
	// For external key stores with XksProxyConnectivity value of VPC_ENDPOINT_SERVICE,
	// specify https:// followed by the private DNS name of the VPC endpoint service.
	//
	// For external key stores with PUBLIC_ENDPOINT connectivity, this endpoint
	// must be reachable before you create the custom key store. KMS connects to
	// the external key store proxy while creating the custom key store. For external
	// key stores with VPC_ENDPOINT_SERVICE connectivity, KMS connects when you
	// call the ConnectCustomKeyStore operation.
	//
	// The value of this parameter must begin with https://. The remainder can contain
	// upper and lower case letters (A-Z and a-z), numbers (0-9), dots (.), and
	// hyphens (-). Additional slashes (/ and \) are not permitted.
	//
	// Uniqueness requirements:
	//
	//    * The combined XksProxyUriEndpoint and XksProxyUriPath values must be
	//    unique in the Amazon Web Services account and Region.
	//
	//    * An external key store with PUBLIC_ENDPOINT connectivity cannot use the
	//    same XksProxyUriEndpoint value as an external key store with VPC_ENDPOINT_SERVICE
	//    connectivity in the same Amazon Web Services Region.
	//
	//    * Each external key store with VPC_ENDPOINT_SERVICE connectivity must
	//    have its own private DNS name. The XksProxyUriEndpoint value for external
	//    key stores with VPC_ENDPOINT_SERVICE connectivity (private DNS name) must
	//    be unique in the Amazon Web Services account and Region.
	XksProxyUriEndpoint *string `min:"10" type:"string"`

	// Specifies the base path to the proxy APIs for this external key store. To
	// find this value, see the documentation for your external key store proxy.
	// This parameter is required for all custom key stores with a CustomKeyStoreType
	// of EXTERNAL_KEY_STORE.
	//
	// The value must start with / and must end with /kms/xks/v1 where v1 represents
	// the version of the KMS external key store proxy API. This path can include
	// an optional prefix between the required elements such as /prefix/kms/xks/v1.
	//
	// Uniqueness requirements:
	//
	//    * The combined XksProxyUriEndpoint and XksProxyUriPath values must be
	//    unique in the Amazon Web Services account and Region.
	XksProxyUriPath *string `min:"10" type:"string"`

	// Specifies the name of the Amazon VPC endpoint service for interface endpoints
	// that is used to communicate with your external key store proxy (XKS proxy).
	// This parameter is required when the value of CustomKeyStoreType is EXTERNAL_KEY_STORE
	// and the value of XksProxyConnectivity is VPC_ENDPOINT_SERVICE.
	//
	// The Amazon VPC endpoint service must fulfill all requirements (https://docs.aws.amazon.com/kms/latest/developerguide/create-xks-keystore.html#xks-requirements)
	// for use with an external key store.
	//
	// Uniqueness requirements:
	//
	//    * External key stores with VPC_ENDPOINT_SERVICE connectivity can share
	//    an Amazon VPC, but each external key store must have its own VPC endpoint
	//    service and private DNS name.
	XksProxyVpcEndpointServiceName *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomKeyStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomKeyStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCustomKeyStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCustomKeyStoreInput"}
	if s.CloudHsmClusterId != nil && len(*s.CloudHsmClusterId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("CloudHsmClusterId", 19))
	}
	if s.CustomKeyStoreName == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomKeyStoreName"))
	}
	if s.CustomKeyStoreName != nil && len(*s.CustomKeyStoreName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomKeyStoreName", 1))
	}
	if s.KeyStorePassword != nil && len(*s.KeyStorePassword) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KeyStorePassword", 7))
	}
	if s.TrustAnchorCertificate != nil && len(*s.TrustAnchorCertificate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrustAnchorCertificate", 1))
	}
	if s.XksProxyUriEndpoint != nil && len(*s.XksProxyUriEndpoint) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("XksProxyUriEndpoint", 10))
	}
	if s.XksProxyUriPath != nil && len(*s.XksProxyUriPath) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("XksProxyUriPath", 10))
	}
	if s.XksProxyVpcEndpointServiceName != nil && len(*s.XksProxyVpcEndpointServiceName) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("XksProxyVpcEndpointServiceName", 20))
	}
	if s.XksProxyAuthenticationCredential != nil {
		if err := s.XksProxyAuthenticationCredential.Validate(); err != nil {
			invalidParams.AddNested("XksProxyAuthenticationCredential", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudHsmClusterId sets the CloudHsmClusterId field's value.
func (s *CreateCustomKeyStoreInput) SetCloudHsmClusterId(v string) *CreateCustomKeyStoreInput {
	s.CloudHsmClusterId = &v
	return s
}

// SetCustomKeyStoreName sets the CustomKeyStoreName field's value.
func (s *CreateCustomKeyStoreInput) SetCustomKeyStoreName(v string) *CreateCustomKeyStoreInput {
	s.CustomKeyStoreName = &v
	return s
}

// SetCustomKeyStoreType sets the CustomKeyStoreType field's value.
func (s *CreateCustomKeyStoreInput) SetCustomKeyStoreType(v string) *CreateCustomKeyStoreInput {
	s.CustomKeyStoreType = &v
	return s
}

// SetKeyStorePassword sets the KeyStorePassword field's value.
func (s *CreateCustomKeyStoreInput) SetKeyStorePassword(v string) *CreateCustomKeyStoreInput {
	s.KeyStorePassword = &v
	return s
}

// SetTrustAnchorCertificate sets the TrustAnchorCertificate field's value.
func (s *CreateCustomKeyStoreInput) SetTrustAnchorCertificate(v string) *CreateCustomKeyStoreInput {
	s.TrustAnchorCertificate = &v
	return s
}

// SetXksProxyAuthenticationCredential sets the XksProxyAuthenticationCredential field's value.
func (s *CreateCustomKeyStoreInput) SetXksProxyAuthenticationCredential(v *XksProxyAuthenticationCredentialType) *CreateCustomKeyStoreInput {
	s.XksProxyAuthenticationCredential = v
	return s
}

// SetXksProxyConnectivity sets the XksProxyConnectivity field's value.
func (s *CreateCustomKeyStoreInput) SetXksProxyConnectivity(v string) *CreateCustomKeyStoreInput {
	s.XksProxyConnectivity = &v
	return s
}

// SetXksProxyUriEndpoint sets the XksProxyUriEndpoint field's value.
func (s *CreateCustomKeyStoreInput) SetXksProxyUriEndpoint(v string) *CreateCustomKeyStoreInput {
	s.XksProxyUriEndpoint = &v
	return s
}

// SetXksProxyUriPath sets the XksProxyUriPath field's value.
func (s *CreateCustomKeyStoreInput) SetXksProxyUriPath(v string) *CreateCustomKeyStoreInput {
	s.XksProxyUriPath = &v
	return s
}

// SetXksProxyVpcEndpointServiceName sets the XksProxyVpcEndpointServiceName field's value.
func (s *CreateCustomKeyStoreInput) SetXksProxyVpcEndpointServiceName(v string) *CreateCustomKeyStoreInput {
	s.XksProxyVpcEndpointServiceName = &v
	return s
}

type CreateCustomKeyStoreOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the new custom key store.
	CustomKeyStoreId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomKeyStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomKeyStoreOutput) GoString() string {
	return s.String()
}

// SetCustomKeyStoreId sets the CustomKeyStoreId field's value.
func (s *CreateCustomKeyStoreOutput) SetCustomKeyStoreId(v string) *CreateCustomKeyStoreOutput {
	s.CustomKeyStoreId = &v
	return s
}

type CreateGrantInput struct {
	_ struct{} `type:"structure"`

	// Specifies a grant constraint.
	//
	// KMS supports the EncryptionContextEquals and EncryptionContextSubset grant
	// constraints. Each constraint value can include up to 8 encryption context
	// pairs. The encryption context value in each constraint cannot exceed 384
	// characters. For information about grant constraints, see Using grant constraints
	// (https://docs.aws.amazon.com/kms/latest/developerguide/create-grant-overview.html#grant-constraints)
	// in the Key Management Service Developer Guide. For more information about
	// encryption context, see Encryption context (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
	// in the Key Management Service Developer Guide .
	//
	// The encryption context grant constraints allow the permissions in the grant
	// only when the encryption context in the request matches (EncryptionContextEquals)
	// or includes (EncryptionContextSubset) the encryption context specified in
	// this structure.
	//
	// The encryption context grant constraints are supported only on grant operations
	// (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#terms-grant-operations)
	// that include an EncryptionContext parameter, such as cryptographic operations
	// on symmetric encryption KMS keys. Grants with grant constraints can include
	// the DescribeKey and RetireGrant operations, but the constraint doesn't apply
	// to these operations. If a grant with a grant constraint includes the CreateGrant
	// operation, the constraint requires that any grants created with the CreateGrant
	// permission have an equally strict or stricter encryption context constraint.
	//
	// You cannot use an encryption context grant constraint for cryptographic operations
	// with asymmetric KMS keys or HMAC KMS keys. These keys don't support an encryption
	// context.
	Constraints *GrantConstraints `type:"structure"`

	// A list of grant tokens.
	//
	// Use a grant token when your permission to call this operation comes from
	// a new grant that has not yet achieved eventual consistency. For more information,
	// see Grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
	// and Using a grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
	// in the Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// The identity that gets the permissions specified in the grant.
	//
	// To specify the principal, use the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of an Amazon Web Services principal. Valid Amazon Web Services principals
	// include Amazon Web Services accounts (root), IAM users, IAM roles, federated
	// users, and assumed role users. For examples of the ARN syntax to use for
	// specifying a principal, see Amazon Web Services Identity and Access Management
	// (IAM) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam)
	// in the Example ARNs section of the Amazon Web Services General Reference.
	//
	// GranteePrincipal is a required field
	GranteePrincipal *string `min:"1" type:"string" required:"true"`

	// Identifies the KMS key for the grant. The grant gives principals permission
	// to use this KMS key.
	//
	// Specify the key ID or key ARN of the KMS key. To specify a KMS key in a different
	// Amazon Web Services account, you must use the key ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// A friendly name for the grant. Use this value to prevent the unintended creation
	// of duplicate grants when retrying this request.
	//
	// When this value is absent, all CreateGrant requests result in a new grant
	// with a unique GrantId even if all the supplied parameters are identical.
	// This can result in unintended duplicates when you retry the CreateGrant request.
	//
	// When this value is present, you can retry a CreateGrant request with identical
	// parameters; if the grant already exists, the original GrantId is returned
	// without creating a new grant. Note that the returned grant token is unique
	// with every CreateGrant request, even when a duplicate GrantId is returned.
	// All grant tokens for the same grant ID can be used interchangeably.
	Name *string `min:"1" type:"string"`

	// A list of operations that the grant permits.
	//
	// This list must include only operations that are permitted in a grant. Also,
	// the operation must be supported on the KMS key. For example, you cannot create
	// a grant for a symmetric encryption KMS key that allows the Sign operation,
	// or a grant for an asymmetric KMS key that allows the GenerateDataKey operation.
	// If you try, KMS returns a ValidationError exception. For details, see Grant
	// operations (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#terms-grant-operations)
	// in the Key Management Service Developer Guide.
	//
	// Operations is a required field
	Operations []*string `type:"list" required:"true" enum:"GrantOperation"`

	// The principal that has permission to use the RetireGrant operation to retire
	// the grant.
	//
	// To specify the principal, use the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of an Amazon Web Services principal. Valid Amazon Web Services principals
	// include Amazon Web Services accounts (root), IAM users, federated users,
	// and assumed role users. For examples of the ARN syntax to use for specifying
	// a principal, see Amazon Web Services Identity and Access Management (IAM)
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam)
	// in the Example ARNs section of the Amazon Web Services General Reference.
	//
	// The grant determines the retiring principal. Other principals might have
	// permission to retire the grant or revoke the grant. For details, see RevokeGrant
	// and Retiring and revoking grants (https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#grant-delete)
	// in the Key Management Service Developer Guide.
	RetiringPrincipal *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGrantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGrantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGrantInput"}
	if s.GranteePrincipal == nil {
		invalidParams.Add(request.NewErrParamRequired("GranteePrincipal"))
	}
	if s.GranteePrincipal != nil && len(*s.GranteePrincipal) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GranteePrincipal", 1))
	}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Operations == nil {
		invalidParams.Add(request.NewErrParamRequired("Operations"))
	}
	if s.RetiringPrincipal != nil && len(*s.RetiringPrincipal) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RetiringPrincipal", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConstraints sets the Constraints field's value.
func (s *CreateGrantInput) SetConstraints(v *GrantConstraints) *CreateGrantInput {
	s.Constraints = v
	return s
}

// SetGrantTokens sets the GrantTokens field's value.
func (s *CreateGrantInput) SetGrantTokens(v []*string) *CreateGrantInput {
	s.GrantTokens = v
	return s
}

// SetGranteePrincipal sets the GranteePrincipal field's value.
func (s *CreateGrantInput) SetGranteePrincipal(v string) *CreateGrantInput {
	s.GranteePrincipal = &v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *CreateGrantInput) SetKeyId(v string) *CreateGrantInput {
	s.KeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateGrantInput) SetName(v string) *CreateGrantInput {
	s.Name = &v
	return s
}

// SetOperations sets the Operations field's value.
func (s *CreateGrantInput) SetOperations(v []*string) *CreateGrantInput {
	s.Operations = v
	return s
}

// SetRetiringPrincipal sets the RetiringPrincipal field's value.
func (s *CreateGrantInput) SetRetiringPrincipal(v string) *CreateGrantInput {
	s.RetiringPrincipal = &v
	return s
}

type CreateGrantOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the grant.
	//
	// You can use the GrantId in a ListGrants, RetireGrant, or RevokeGrant operation.
	GrantId *string `min:"1" type:"string"`

	// The grant token.
	//
	// Use a grant token when your permission to call this operation comes from
	// a new grant that has not yet achieved eventual consistency. For more information,
	// see Grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
	// and Using a grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
	// in the Key Management Service Developer Guide.
	GrantToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGrantOutput) GoString() string {
	return s.String()
}

// SetGrantId sets the GrantId field's value.
func (s *CreateGrantOutput) SetGrantId(v string) *CreateGrantOutput {
	s.GrantId = &v
	return s
}

// SetGrantToken sets the GrantToken field's value.
func (s *CreateGrantOutput) SetGrantToken(v string) *CreateGrantOutput {
	s.GrantToken = &v
	return s
}

type CreateKeyInput struct {
	_ struct{} `type:"structure"`

	// A flag to indicate whether to bypass the key policy lockout safety check.
	//
	// Setting this value to true increases the risk that the KMS key becomes unmanageable.
	// Do not set this value to true indiscriminately.
	//
	// For more information, refer to the scenario in the Default Key Policy (https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
	// section in the Key Management Service Developer Guide .
	//
	// Use this parameter only when you include a policy in the request and you
	// intend to prevent the principal that is making the request from making a
	// subsequent PutKeyPolicy request on the KMS key.
	//
	// The default value is false.
	BypassPolicyLockoutSafetyCheck *bool `type:"boolean"`

	// Creates the KMS key in the specified custom key store (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html).
	// The ConnectionState of the custom key store must be CONNECTED. To find the
	// CustomKeyStoreID and ConnectionState use the DescribeCustomKeyStores operation.
	//
	// This parameter is valid only for symmetric encryption KMS keys in a single
	// Region. You cannot create any other type of KMS key in a custom key store.
	//
	// When you create a KMS key in an CloudHSM key store, KMS generates a non-exportable
	// 256-bit symmetric key in its associated CloudHSM cluster and associates it
	// with the KMS key. When you create a KMS key in an external key store, you
	// must use the XksKeyId parameter to specify an external key that serves as
	// key material for the KMS key.
	CustomKeyStoreId *string `min:"1" type:"string"`

	// Instead, use the KeySpec parameter.
	//
	// The KeySpec and CustomerMasterKeySpec parameters work the same way. Only
	// the names differ. We recommend that you use KeySpec parameter in your code.
	// However, to avoid breaking changes, KMS supports both parameters.
	//
	// Deprecated: This parameter has been deprecated. Instead, use the KeySpec parameter.
	CustomerMasterKeySpec *string `deprecated:"true" type:"string" enum:"CustomerMasterKeySpec"`

	// A description of the KMS key.
	//
	// Use a description that helps you decide whether the KMS key is appropriate
	// for a task. The default value is an empty string (no description).
	//
	// To set or change the description after the key is created, use UpdateKeyDescription.
	Description *string `type:"string"`

	// Specifies the type of KMS key to create. The default value, SYMMETRIC_DEFAULT,
	// creates a KMS key with a 256-bit AES-GCM key that is used for encryption
	// and decryption, except in China Regions, where it creates a 128-bit symmetric
	// key that uses SM4 encryption. For help choosing a key spec for your KMS key,
	// see Choosing a KMS key type (https://docs.aws.amazon.com/kms/latest/developerguide/key-types.html#symm-asymm-choose)
	// in the Key Management Service Developer Guide .
	//
	// The KeySpec determines whether the KMS key contains a symmetric key or an
	// asymmetric key pair. It also determines the algorithms that the KMS key supports.
	// You can't change the KeySpec after the KMS key is created. To further restrict
	// the algorithms that can be used with the KMS key, use a condition key in
	// its key policy or IAM policy. For more information, see kms:EncryptionAlgorithm
	// (https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-encryption-algorithm),
	// kms:MacAlgorithm (https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-mac-algorithm)
	// or kms:Signing Algorithm (https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-signing-algorithm)
	// in the Key Management Service Developer Guide .
	//
	// Amazon Web Services services that are integrated with KMS (http://aws.amazon.com/kms/features/#AWS_Service_Integration)
	// use symmetric encryption KMS keys to protect your data. These services do
	// not support asymmetric KMS keys or HMAC KMS keys.
	//
	// KMS supports the following key specs for KMS keys:
	//
	//    * Symmetric encryption key (default) SYMMETRIC_DEFAULT
	//
	//    * HMAC keys (symmetric) HMAC_224 HMAC_256 HMAC_384 HMAC_512
	//
	//    * Asymmetric RSA key pairs RSA_2048 RSA_3072 RSA_4096
	//
	//    * Asymmetric NIST-recommended elliptic curve key pairs ECC_NIST_P256 (secp256r1)
	//    ECC_NIST_P384 (secp384r1) ECC_NIST_P521 (secp521r1)
	//
	//    * Other asymmetric elliptic curve key pairs ECC_SECG_P256K1 (secp256k1),
	//    commonly used for cryptocurrencies.
	//
	//    * SM2 key pairs (China Regions only) SM2
	KeySpec *string `type:"string" enum:"KeySpec"`

	// Determines the cryptographic operations (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
	// for which you can use the KMS key. The default value is ENCRYPT_DECRYPT.
	// This parameter is optional when you are creating a symmetric encryption KMS
	// key; otherwise, it is required. You can't change the KeyUsage value after
	// the KMS key is created.
	//
	// Select only one valid value.
	//
	//    * For symmetric encryption KMS keys, omit the parameter or specify ENCRYPT_DECRYPT.
	//
	//    * For HMAC KMS keys (symmetric), specify GENERATE_VERIFY_MAC.
	//
	//    * For asymmetric KMS keys with RSA key material, specify ENCRYPT_DECRYPT
	//    or SIGN_VERIFY.
	//
	//    * For asymmetric KMS keys with ECC key material, specify SIGN_VERIFY.
	//
	//    * For asymmetric KMS keys with SM2 key material (China Regions only),
	//    specify ENCRYPT_DECRYPT or SIGN_VERIFY.
	KeyUsage *string `type:"string" enum:"KeyUsageType"`

	// Creates a multi-Region primary key that you can replicate into other Amazon
	// Web Services Regions. You cannot change this value after you create the KMS
	// key.
	//
	// For a multi-Region key, set this parameter to True. For a single-Region KMS
	// key, omit this parameter or set it to False. The default value is False.
	//
	// This operation supports multi-Region keys, an KMS feature that lets you create
	// multiple interoperable KMS keys in different Amazon Web Services Regions.
	// Because these KMS keys have the same key ID, key material, and other metadata,
	// you can use them interchangeably to encrypt data in one Amazon Web Services
	// Region and decrypt it in a different Amazon Web Services Region without re-encrypting
	// the data or making a cross-Region call. For more information about multi-Region
	// keys, see Multi-Region keys in KMS (https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html)
	// in the Key Management Service Developer Guide.
	//
	// This value creates a primary key, not a replica. To create a replica key,
	// use the ReplicateKey operation.
	//
	// You can create a symmetric or asymmetric multi-Region key, and you can create
	// a multi-Region key with imported key material. However, you cannot create
	// a multi-Region key in a custom key store.
	MultiRegion *bool `type:"boolean"`

	// The source of the key material for the KMS key. You cannot change the origin
	// after you create the KMS key. The default is AWS_KMS, which means that KMS
	// creates the key material.
	//
	// To create a KMS key with no key material (https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-create-cmk.html)
	// (for imported key material), set this value to EXTERNAL. For more information
	// about importing key material into KMS, see Importing Key Material (https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html)
	// in the Key Management Service Developer Guide. The EXTERNAL origin value
	// is valid only for symmetric KMS keys.
	//
	// To create a KMS key in an CloudHSM key store (https://docs.aws.amazon.com/kms/latest/developerguide/create-cmk-keystore.html)
	// and create its key material in the associated CloudHSM cluster, set this
	// value to AWS_CLOUDHSM. You must also use the CustomKeyStoreId parameter to
	// identify the CloudHSM key store. The KeySpec value must be SYMMETRIC_DEFAULT.
	//
	// To create a KMS key in an external key store (https://docs.aws.amazon.com/kms/latest/developerguide/create-xks-keys.html),
	// set this value to EXTERNAL_KEY_STORE. You must also use the CustomKeyStoreId
	// parameter to identify the external key store and the XksKeyId parameter to
	// identify the associated external key. The KeySpec value must be SYMMETRIC_DEFAULT.
	Origin *string `type:"string" enum:"OriginType"`

	// The key policy to attach to the KMS key.
	//
	// If you provide a key policy, it must meet the following criteria:
	//
	//    * If you don't set BypassPolicyLockoutSafetyCheck to true, the key policy
	//    must allow the principal that is making the CreateKey request to make
	//    a subsequent PutKeyPolicy request on the KMS key. This reduces the risk
	//    that the KMS key becomes unmanageable. For more information, refer to
	//    the scenario in the Default Key Policy (https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
	//    section of the Key Management Service Developer Guide .
	//
	//    * Each statement in the key policy must contain one or more principals.
	//    The principals in the key policy must exist and be visible to KMS. When
	//    you create a new Amazon Web Services principal (for example, an IAM user
	//    or role), you might need to enforce a delay before including the new principal
	//    in a key policy because the new principal might not be immediately visible
	//    to KMS. For more information, see Changes that I make are not always immediately
	//    visible (https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency)
	//    in the Amazon Web Services Identity and Access Management User Guide.
	//
	// If you do not provide a key policy, KMS attaches a default key policy to
	// the KMS key. For more information, see Default Key Policy (https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default)
	// in the Key Management Service Developer Guide.
	//
	// The key policy size quota is 32 kilobytes (32768 bytes).
	//
	// For help writing and formatting a JSON policy document, see the IAM JSON
	// Policy Reference (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html)
	// in the Identity and Access Management User Guide .
	Policy *string `min:"1" type:"string"`

	// Assigns one or more tags to the KMS key. Use this parameter to tag the KMS
	// key when it is created. To tag an existing KMS key, use the TagResource operation.
	//
	// Tagging or untagging a KMS key can allow or deny permission to the KMS key.
	// For details, see ABAC for KMS (https://docs.aws.amazon.com/kms/latest/developerguide/abac.html)
	// in the Key Management Service Developer Guide.
	//
	// To use this parameter, you must have kms:TagResource (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
	// permission in an IAM policy.
	//
	// Each tag consists of a tag key and a tag value. Both the tag key and the
	// tag value are required, but the tag value can be an empty (null) string.
	// You cannot have more than one tag on a KMS key with the same tag key. If
	// you specify an existing tag key with a different tag value, KMS replaces
	// the current tag value with the specified one.
	//
	// When you add tags to an Amazon Web Services resource, Amazon Web Services
	// generates a cost allocation report with usage and costs aggregated by tags.
	// Tags can also be used to control access to a KMS key. For details, see Tagging
	// Keys (https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html).
	Tags []*Tag `type:"list"`

	// Identifies the external key (https://docs.aws.amazon.com/kms/latest/developerguide/keystore-external.html#concept-external-key)
	// that serves as key material for the KMS key in an external key store (https://docs.aws.amazon.com/kms/latest/developerguide/keystore-external.html).
	// Specify the ID that the external key store proxy (https://docs.aws.amazon.com/kms/latest/developerguide/keystore-external.html#concept-xks-proxy)
	// uses to refer to the external key. For help, see the documentation for your
	// external key store proxy.
	//
	// This parameter is required for a KMS key with an Origin value of EXTERNAL_KEY_STORE.
	// It is not valid for KMS keys with any other Origin value.
	//
	// The external key must be an existing 256-bit AES symmetric encryption key
	// hosted outside of Amazon Web Services in an external key manager associated
	// with the external key store specified by the CustomKeyStoreId parameter.
	// This key must be enabled and configured to perform encryption and decryption.
	// Each KMS key in an external key store must use a different external key.
	// For details, see Requirements for a KMS key in an external key store (https://docs.aws.amazon.com/create-xks-keys.html#xks-key-requirements)
	// in the Key Management Service Developer Guide.
	//
	// Each KMS key in an external key store is associated two backing keys. One
	// is key material that KMS generates. The other is the external key specified
	// by this parameter. When you use the KMS key in an external key store to encrypt
	// data, the encryption operation is performed first by KMS using the KMS key
	// material, and then by the external key manager using the specified external
	// key, a process known as double encryption. For details, see Double encryption
	// (https://docs.aws.amazon.com/kms/latest/developerguide/keystore-external.html#concept-double-encryption)
	// in the Key Management Service Developer Guide.
	XksKeyId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateKeyInput"}
	if s.CustomKeyStoreId != nil && len(*s.CustomKeyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomKeyStoreId", 1))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}
	if s.XksKeyId != nil && len(*s.XksKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("XksKeyId", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBypassPolicyLockoutSafetyCheck sets the BypassPolicyLockoutSafetyCheck field's value.
func (s *CreateKeyInput) SetBypassPolicyLockoutSafetyCheck(v bool) *CreateKeyInput {
	s.BypassPolicyLockoutSafetyCheck = &v
	return s
}

// SetCustomKeyStoreId sets the CustomKeyStoreId field's value.
func (s *CreateKeyInput) SetCustomKeyStoreId(v string) *CreateKeyInput {
	s.CustomKeyStoreId = &v
	return s
}

// SetCustomerMasterKeySpec sets the CustomerMasterKeySpec field's value.
func (s *CreateKeyInput) SetCustomerMasterKeySpec(v string) *CreateKeyInput {
	s.CustomerMasterKeySpec = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateKeyInput) SetDescription(v string) *CreateKeyInput {
	s.Description = &v
	return s
}

// SetKeySpec sets the KeySpec field's value.
func (s *CreateKeyInput) SetKeySpec(v string) *CreateKeyInput {
	s.KeySpec = &v
	return s
}

// SetKeyUsage sets the KeyUsage field's value.
func (s *CreateKeyInput) SetKeyUsage(v string) *CreateKeyInput {
	s.KeyUsage = &v
	return s
}

// SetMultiRegion sets the MultiRegion field's value.
func (s *CreateKeyInput) SetMultiRegion(v bool) *CreateKeyInput {
	s.MultiRegion = &v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *CreateKeyInput) SetOrigin(v string) *CreateKeyInput {
	s.Origin = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *CreateKeyInput) SetPolicy(v string) *CreateKeyInput {
	s.Policy = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateKeyInput) SetTags(v []*Tag) *CreateKeyInput {
	s.Tags = v
	return s
}

// SetXksKeyId sets the XksKeyId field's value.
func (s *CreateKeyInput) SetXksKeyId(v string) *CreateKeyInput {
	s.XksKeyId = &v
	return s
}

type CreateKeyOutput struct {
	_ struct{} `type:"structure"`

	// Metadata associated with the KMS key.
	KeyMetadata *KeyMetadata `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKeyOutput) GoString() string {
	return s.String()
}

// SetKeyMetadata sets the KeyMetadata field's value.
func (s *CreateKeyOutput) SetKeyMetadata(v *KeyMetadata) *CreateKeyOutput {
	s.KeyMetadata = v
	return s
}

// The request was rejected because the custom key store contains KMS keys.
// After verifying that you do not need to use the KMS keys, use the ScheduleKeyDeletion
// operation to delete the KMS keys. After they are deleted, you can delete
// the custom key store.
type CustomKeyStoreHasCMKsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomKeyStoreHasCMKsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomKeyStoreHasCMKsException) GoString() string {
	return s.String()
}

func newErrorCustomKeyStoreHasCMKsException(v protocol.ResponseMetadata) error {
	return &CustomKeyStoreHasCMKsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CustomKeyStoreHasCMKsException) Code() string {
	return "CustomKeyStoreHasCMKsException"
}

// Message returns the exception's message.
func (s *CustomKeyStoreHasCMKsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CustomKeyStoreHasCMKsException) OrigErr() error {
	return nil
}

func (s *CustomKeyStoreHasCMKsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CustomKeyStoreHasCMKsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CustomKeyStoreHasCMKsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because of the ConnectionState of the custom key
// store. To get the ConnectionState of a custom key store, use the DescribeCustomKeyStores
// operation.
//
// This exception is thrown under the following conditions:
//
//   - You requested the ConnectCustomKeyStore operation on a custom key store
//     with a ConnectionState of DISCONNECTING or FAILED. This operation is valid
//     for all other ConnectionState values. To reconnect a custom key store
//     in a FAILED state, disconnect it (DisconnectCustomKeyStore), then connect
//     it (ConnectCustomKeyStore).
//
//   - You requested the CreateKey operation in a custom key store that is
//     not connected. This operations is valid only when the custom key store
//     ConnectionState is CONNECTED.
//
//   - You requested the DisconnectCustomKeyStore operation on a custom key
//     store with a ConnectionState of DISCONNECTING or DISCONNECTED. This operation
//     is valid for all other ConnectionState values.
//
//   - You requested the UpdateCustomKeyStore or DeleteCustomKeyStore operation
//     on a custom key store that is not disconnected. This operation is valid
//     only when the custom key store ConnectionState is DISCONNECTED.
//
//   - You requested the GenerateRandom operation in an CloudHSM key store
//     that is not connected. This operation is valid only when the CloudHSM
//     key store ConnectionState is CONNECTED.
type CustomKeyStoreInvalidStateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomKeyStoreInvalidStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomKeyStoreInvalidStateException) GoString() string {
	return s.String()
}

func newErrorCustomKeyStoreInvalidStateException(v protocol.ResponseMetadata) error {
	return &CustomKeyStoreInvalidStateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CustomKeyStoreInvalidStateException) Code() string {
	return "CustomKeyStoreInvalidStateException"
}

// Message returns the exception's message.
func (s *CustomKeyStoreInvalidStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CustomKeyStoreInvalidStateException) OrigErr() error {
	return nil
}

func (s *CustomKeyStoreInvalidStateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CustomKeyStoreInvalidStateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CustomKeyStoreInvalidStateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because the specified custom key store name is already
// assigned to another custom key store in the account. Try again with a custom
// key store name that is unique in the account.
type CustomKeyStoreNameInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomKeyStoreNameInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomKeyStoreNameInUseException) GoString() string {
	return s.String()
}

func newErrorCustomKeyStoreNameInUseException(v protocol.ResponseMetadata) error {
	return &CustomKeyStoreNameInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CustomKeyStoreNameInUseException) Code() string {
	return "CustomKeyStoreNameInUseException"
}

// Message returns the exception's message.
func (s *CustomKeyStoreNameInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CustomKeyStoreNameInUseException) OrigErr() error {
	return nil
}

func (s *CustomKeyStoreNameInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CustomKeyStoreNameInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CustomKeyStoreNameInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because KMS cannot find a custom key store with
// the specified key store name or ID.
type CustomKeyStoreNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomKeyStoreNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomKeyStoreNotFoundException) GoString() string {
	return s.String()
}

func newErrorCustomKeyStoreNotFoundException(v protocol.ResponseMetadata) error {
	return &CustomKeyStoreNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CustomKeyStoreNotFoundException) Code() string {
	return "CustomKeyStoreNotFoundException"
}

// Message returns the exception's message.
func (s *CustomKeyStoreNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CustomKeyStoreNotFoundException) OrigErr() error {
	return nil
}

func (s *CustomKeyStoreNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CustomKeyStoreNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CustomKeyStoreNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about each custom key store in the custom key store
// list.
type CustomKeyStoresListEntry struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the CloudHSM cluster that is associated with an CloudHSM
	// key store. This field appears only when the CustomKeyStoreType is AWS_CLOUDHSM.
	CloudHsmClusterId *string `min:"19" type:"string"`

	// Describes the connection error. This field appears in the response only when
	// the ConnectionState is FAILED.
	//
	// Many failures can be resolved by updating the properties of the custom key
	// store. To update a custom key store, disconnect it (DisconnectCustomKeyStore),
	// correct the errors (UpdateCustomKeyStore), and try to connect again (ConnectCustomKeyStore).
	// For additional help resolving these errors, see How to Fix a Connection Failure
	// (https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-failed)
	// in Key Management Service Developer Guide.
	//
	// All custom key stores:
	//
	//    * INTERNAL_ERROR — KMS could not complete the request due to an internal
	//    error. Retry the request. For ConnectCustomKeyStore requests, disconnect
	//    the custom key store before trying to connect again.
	//
	//    * NETWORK_ERRORS — Network errors are preventing KMS from connecting
	//    the custom key store to its backing key store.
	//
	// CloudHSM key stores:
	//
	//    * CLUSTER_NOT_FOUND — KMS cannot find the CloudHSM cluster with the
	//    specified cluster ID.
	//
	//    * INSUFFICIENT_CLOUDHSM_HSMS — The associated CloudHSM cluster does
	//    not contain any active HSMs. To connect a custom key store to its CloudHSM
	//    cluster, the cluster must contain at least one active HSM.
	//
	//    * INSUFFICIENT_FREE_ADDRESSES_IN_SUBNET — At least one private subnet
	//    associated with the CloudHSM cluster doesn't have any available IP addresses.
	//    A CloudHSM key store connection requires one free IP address in each of
	//    the associated private subnets, although two are preferable. For details,
	//    see How to Fix a Connection Failure (https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-failed)
	//    in the Key Management Service Developer Guide.
	//
	//    * INVALID_CREDENTIALS — The KeyStorePassword for the custom key store
	//    doesn't match the current password of the kmsuser crypto user in the CloudHSM
	//    cluster. Before you can connect your custom key store to its CloudHSM
	//    cluster, you must change the kmsuser account password and update the KeyStorePassword
	//    value for the custom key store.
	//
	//    * SUBNET_NOT_FOUND — A subnet in the CloudHSM cluster configuration
	//    was deleted. If KMS cannot find all of the subnets in the cluster configuration,
	//    attempts to connect the custom key store to the CloudHSM cluster fail.
	//    To fix this error, create a cluster from a recent backup and associate
	//    it with your custom key store. (This process creates a new cluster configuration
	//    with a VPC and private subnets.) For details, see How to Fix a Connection
	//    Failure (https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-failed)
	//    in the Key Management Service Developer Guide.
	//
	//    * USER_LOCKED_OUT — The kmsuser CU account is locked out of the associated
	//    CloudHSM cluster due to too many failed password attempts. Before you
	//    can connect your custom key store to its CloudHSM cluster, you must change
	//    the kmsuser account password and update the key store password value for
	//    the custom key store.
	//
	//    * USER_LOGGED_IN — The kmsuser CU account is logged into the associated
	//    CloudHSM cluster. This prevents KMS from rotating the kmsuser account
	//    password and logging into the cluster. Before you can connect your custom
	//    key store to its CloudHSM cluster, you must log the kmsuser CU out of
	//    the cluster. If you changed the kmsuser password to log into the cluster,
	//    you must also and update the key store password value for the custom key
	//    store. For help, see How to Log Out and Reconnect (https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#login-kmsuser-2)
	//    in the Key Management Service Developer Guide.
	//
	//    * USER_NOT_FOUND — KMS cannot find a kmsuser CU account in the associated
	//    CloudHSM cluster. Before you can connect your custom key store to its
	//    CloudHSM cluster, you must create a kmsuser CU account in the cluster,
	//    and then update the key store password value for the custom key store.
	//
	// External key stores:
	//
	//    * INVALID_CREDENTIALS — One or both of the XksProxyAuthenticationCredential
	//    values is not valid on the specified external key store proxy.
	//
	//    * XKS_PROXY_ACCESS_DENIED — KMS requests are denied access to the external
	//    key store proxy. If the external key store proxy has authorization rules,
	//    verify that they permit KMS to communicate with the proxy on your behalf.
	//
	//    * XKS_PROXY_INVALID_CONFIGURATION — A configuration error is preventing
	//    the external key store from connecting to its proxy. Verify the value
	//    of the XksProxyUriPath.
	//
	//    * XKS_PROXY_INVALID_RESPONSE — KMS cannot interpret the response from
	//    the external key store proxy. If you see this connection error code repeatedly,
	//    notify your external key store proxy vendor.
	//
	//    * XKS_PROXY_INVALID_TLS_CONFIGURATION — KMS cannot connect to the external
	//    key store proxy because the TLS configuration is invalid. Verify that
	//    the XKS proxy supports TLS 1.2 or 1.3. Also, verify that the TLS certificate
	//    is not expired, and that it matches the hostname in the XksProxyUriEndpoint
	//    value, and that it is signed by a certificate authority included in the
	//    Trusted Certificate Authorities (https://github.com/aws/aws-kms-xksproxy-api-spec/blob/main/TrustedCertificateAuthorities)
	//    list.
	//
	//    * XKS_PROXY_NOT_REACHABLE — KMS can't communicate with your external
	//    key store proxy. Verify that the XksProxyUriEndpoint and XksProxyUriPath
	//    are correct. Use the tools for your external key store proxy to verify
	//    that the proxy is active and available on its network. Also, verify that
	//    your external key manager instances are operating properly. Connection
	//    attempts fail with this connection error code if the proxy reports that
	//    all external key manager instances are unavailable.
	//
	//    * XKS_PROXY_TIMED_OUT — KMS can connect to the external key store proxy,
	//    but the proxy does not respond to KMS in the time allotted. If you see
	//    this connection error code repeatedly, notify your external key store
	//    proxy vendor.
	//
	//    * XKS_VPC_ENDPOINT_SERVICE_INVALID_CONFIGURATION — The Amazon VPC endpoint
	//    service configuration doesn't conform to the requirements for an KMS external
	//    key store. The VPC endpoint service must be an endpoint service for interface
	//    endpoints in the caller's Amazon Web Services account. It must have a
	//    network load balancer (NLB) connected to at least two subnets, each in
	//    a different Availability Zone. The Allow principals list must include
	//    the KMS service principal for the Region, cks.kms.<region>.amazonaws.com,
	//    such as cks.kms.us-east-1.amazonaws.com. It must not require acceptance
	//    (https://docs.aws.amazon.com/vpc/latest/privatelink/create-endpoint-service.html)
	//    of connection requests. It must have a private DNS name. The private DNS
	//    name for an external key store with VPC_ENDPOINT_SERVICE connectivity
	//    must be unique in its Amazon Web Services Region. The domain of the private
	//    DNS name must have a verification status (https://docs.aws.amazon.com/vpc/latest/privatelink/verify-domains.html)
	//    of verified. The TLS certificate (https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html)
	//    specifies the private DNS hostname at which the endpoint is reachable.
	//
	//    * XKS_VPC_ENDPOINT_SERVICE_NOT_FOUND — KMS can't find the VPC endpoint
	//    service that it uses to communicate with the external key store proxy.
	//    Verify that the XksProxyVpcEndpointServiceName is correct and the KMS
	//    service principal has service consumer permissions on the Amazon VPC endpoint
	//    service.
	ConnectionErrorCode *string `type:"string" enum:"ConnectionErrorCodeType"`

	// Indicates whether the custom key store is connected to its backing key store.
	// For an CloudHSM key store, the ConnectionState indicates whether it is connected
	// to its CloudHSM cluster. For an external key store, the ConnectionState indicates
	// whether it is connected to the external key store proxy that communicates
	// with your external key manager.
	//
	// You can create and use KMS keys in your custom key stores only when its ConnectionState
	// is CONNECTED.
	//
	// The ConnectionState value is DISCONNECTED only if the key store has never
	// been connected or you use the DisconnectCustomKeyStore operation to disconnect
	// it. If the value is CONNECTED but you are having trouble using the custom
	// key store, make sure that the backing key store is reachable and active.
	// For an CloudHSM key store, verify that its associated CloudHSM cluster is
	// active and contains at least one active HSM. For an external key store, verify
	// that the external key store proxy and external key manager are connected
	// and enabled.
	//
	// A value of FAILED indicates that an attempt to connect was unsuccessful.
	// The ConnectionErrorCode field in the response indicates the cause of the
	// failure. For help resolving a connection failure, see Troubleshooting a custom
	// key store (https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html)
	// in the Key Management Service Developer Guide.
	ConnectionState *string `type:"string" enum:"ConnectionStateType"`

	// The date and time when the custom key store was created.
	CreationDate *time.Time `type:"timestamp"`

	// A unique identifier for the custom key store.
	CustomKeyStoreId *string `min:"1" type:"string"`

	// The user-specified friendly name for the custom key store.
	CustomKeyStoreName *string `min:"1" type:"string"`

	// Indicates the type of the custom key store. AWS_CLOUDHSM indicates a custom
	// key store backed by an CloudHSM cluster. EXTERNAL_KEY_STORE indicates a custom
	// key store backed by an external key store proxy and external key manager
	// outside of Amazon Web Services.
	CustomKeyStoreType *string `type:"string" enum:"CustomKeyStoreType"`

	// The trust anchor certificate of the CloudHSM cluster associated with an CloudHSM
	// key store. When you initialize the cluster (https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html#sign-csr),
	// you create this certificate and save it in the customerCA.crt file.
	//
	// This field appears only when the CustomKeyStoreType is AWS_CLOUDHSM.
	TrustAnchorCertificate *string `min:"1" type:"string"`

	// Configuration settings for the external key store proxy (XKS proxy). The
	// external key store proxy translates KMS requests into a format that your
	// external key manager can understand. The proxy configuration includes connection
	// information that KMS requires.
	//
	// This field appears only when the CustomKeyStoreType is EXTERNAL_KEY_STORE.
	XksProxyConfiguration *XksProxyConfigurationType `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomKeyStoresListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomKeyStoresListEntry) GoString() string {
	return s.String()
}

// SetCloudHsmClusterId sets the CloudHsmClusterId field's value.
func (s *CustomKeyStoresListEntry) SetCloudHsmClusterId(v string) *CustomKeyStoresListEntry {
	s.CloudHsmClusterId = &v
	return s
}

// SetConnectionErrorCode sets the ConnectionErrorCode field's value.
func (s *CustomKeyStoresListEntry) SetConnectionErrorCode(v string) *CustomKeyStoresListEntry {
	s.ConnectionErrorCode = &v
	return s
}

// SetConnectionState sets the ConnectionState field's value.
func (s *CustomKeyStoresListEntry) SetConnectionState(v string) *CustomKeyStoresListEntry {
	s.ConnectionState = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *CustomKeyStoresListEntry) SetCreationDate(v time.Time) *CustomKeyStoresListEntry {
	s.CreationDate = &v
	return s
}

// SetCustomKeyStoreId sets the CustomKeyStoreId field's value.
func (s *CustomKeyStoresListEntry) SetCustomKeyStoreId(v string) *CustomKeyStoresListEntry {
	s.CustomKeyStoreId = &v
	return s
}

// SetCustomKeyStoreName sets the CustomKeyStoreName field's value.
func (s *CustomKeyStoresListEntry) SetCustomKeyStoreName(v string) *CustomKeyStoresListEntry {
	s.CustomKeyStoreName = &v
	return s
}

// SetCustomKeyStoreType sets the CustomKeyStoreType field's value.
func (s *CustomKeyStoresListEntry) SetCustomKeyStoreType(v string) *CustomKeyStoresListEntry {
	s.CustomKeyStoreType = &v
	return s
}

// SetTrustAnchorCertificate sets the TrustAnchorCertificate field's value.
func (s *CustomKeyStoresListEntry) SetTrustAnchorCertificate(v string) *CustomKeyStoresListEntry {
	s.TrustAnchorCertificate = &v
	return s
}

// SetXksProxyConfiguration sets the XksProxyConfiguration field's value.
func (s *CustomKeyStoresListEntry) SetXksProxyConfiguration(v *XksProxyConfigurationType) *CustomKeyStoresListEntry {
	s.XksProxyConfiguration = v
	return s
}

type DecryptInput struct {
	_ struct{} `type:"structure"`

	// Ciphertext to be decrypted. The blob includes metadata.
	// CiphertextBlob is automatically base64 encoded/decoded by the SDK.
	//
	// CiphertextBlob is a required field
	CiphertextBlob []byte `min:"1" type:"blob" required:"true"`

	// Specifies the encryption algorithm that will be used to decrypt the ciphertext.
	// Specify the same algorithm that was used to encrypt the data. If you specify
	// a different algorithm, the Decrypt operation fails.
	//
	// This parameter is required only when the ciphertext was encrypted under an
	// asymmetric KMS key. The default value, SYMMETRIC_DEFAULT, represents the
	// only supported algorithm that is valid for symmetric encryption KMS keys.
	EncryptionAlgorithm *string `type:"string" enum:"EncryptionAlgorithmSpec"`

	// Specifies the encryption context to use when decrypting the data. An encryption
	// context is valid only for cryptographic operations (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
	// with a symmetric encryption KMS key. The standard asymmetric encryption algorithms
	// and HMAC algorithms that KMS uses do not support an encryption context.
	//
	// An encryption context is a collection of non-secret key-value pairs that
	// represent additional authenticated data. When you use an encryption context
	// to encrypt data, you must specify the same (an exact case-sensitive match)
	// encryption context to decrypt the data. An encryption context is supported
	// only on operations with symmetric encryption KMS keys. On operations with
	// symmetric encryption KMS keys, an encryption context is optional, but it
	// is strongly recommended.
	//
	// For more information, see Encryption context (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
	// in the Key Management Service Developer Guide.
	EncryptionContext map[string]*string `type:"map"`

	// A list of grant tokens.
	//
	// Use a grant token when your permission to call this operation comes from
	// a new grant that has not yet achieved eventual consistency. For more information,
	// see Grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
	// and Using a grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
	// in the Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// Specifies the KMS key that KMS uses to decrypt the ciphertext.
	//
	// Enter a key ID of the KMS key that was used to encrypt the ciphertext. If
	// you identify a different KMS key, the Decrypt operation throws an IncorrectKeyException.
	//
	// This parameter is required only when the ciphertext was encrypted under an
	// asymmetric KMS key. If you used a symmetric encryption KMS key, KMS can get
	// the KMS key from metadata that it adds to the symmetric ciphertext blob.
	// However, it is always recommended as a best practice. This practice ensures
	// that you use the KMS key that you intend.
	//
	// To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
	// When using an alias name, prefix it with "alias/". To specify a KMS key in
	// a different Amazon Web Services account, you must use the key ARN or alias
	// ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	// To get the alias name and alias ARN, use ListAliases.
	KeyId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DecryptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DecryptInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DecryptInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DecryptInput"}
	if s.CiphertextBlob == nil {
		invalidParams.Add(request.NewErrParamRequired("CiphertextBlob"))
	}
	if s.CiphertextBlob != nil && len(s.CiphertextBlob) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CiphertextBlob", 1))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCiphertextBlob sets the CiphertextBlob field's value.
func (s *DecryptInput) SetCiphertextBlob(v []byte) *DecryptInput {
	s.CiphertextBlob = v
	return s
}

// SetEncryptionAlgorithm sets the EncryptionAlgorithm field's value.
func (s *DecryptInput) SetEncryptionAlgorithm(v string) *DecryptInput {
	s.EncryptionAlgorithm = &v
	return s
}

// SetEncryptionContext sets the EncryptionContext field's value.
func (s *DecryptInput) SetEncryptionContext(v map[string]*string) *DecryptInput {
	s.EncryptionContext = v
	return s
}

// SetGrantTokens sets the GrantTokens field's value.
func (s *DecryptInput) SetGrantTokens(v []*string) *DecryptInput {
	s.GrantTokens = v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *DecryptInput) SetKeyId(v string) *DecryptInput {
	s.KeyId = &v
	return s
}

type DecryptOutput struct {
	_ struct{} `type:"structure"`

	// The encryption algorithm that was used to decrypt the ciphertext.
	EncryptionAlgorithm *string `type:"string" enum:"EncryptionAlgorithmSpec"`

	// The Amazon Resource Name (key ARN (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN))
	// of the KMS key that was used to decrypt the ciphertext.
	KeyId *string `min:"1" type:"string"`

	// Decrypted plaintext data. When you use the HTTP API or the Amazon Web Services
	// CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
	//
	// Plaintext is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DecryptOutput's
	// String and GoString methods.
	//
	// Plaintext is automatically base64 encoded/decoded by the SDK.
	Plaintext []byte `min:"1" type:"blob" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DecryptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DecryptOutput) GoString() string {
	return s.String()
}

// SetEncryptionAlgorithm sets the EncryptionAlgorithm field's value.
func (s *DecryptOutput) SetEncryptionAlgorithm(v string) *DecryptOutput {
	s.EncryptionAlgorithm = &v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *DecryptOutput) SetKeyId(v string) *DecryptOutput {
	s.KeyId = &v
	return s
}

// SetPlaintext sets the Plaintext field's value.
func (s *DecryptOutput) SetPlaintext(v []byte) *DecryptOutput {
	s.Plaintext = v
	return s
}

type DeleteAliasInput struct {
	_ struct{} `type:"structure"`

	// The alias to be deleted. The alias name must begin with alias/ followed by
	// the alias name, such as alias/ExampleAlias.
	//
	// AliasName is a required field
	AliasName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAliasInput"}
	if s.AliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasName sets the AliasName field's value.
func (s *DeleteAliasInput) SetAliasName(v string) *DeleteAliasInput {
	s.AliasName = &v
	return s
}

type DeleteAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAliasOutput) GoString() string {
	return s.String()
}

type DeleteCustomKeyStoreInput struct {
	_ struct{} `type:"structure"`

	// Enter the ID of the custom key store you want to delete. To find the ID of
	// a custom key store, use the DescribeCustomKeyStores operation.
	//
	// CustomKeyStoreId is a required field
	CustomKeyStoreId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomKeyStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomKeyStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCustomKeyStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCustomKeyStoreInput"}
	if s.CustomKeyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomKeyStoreId"))
	}
	if s.CustomKeyStoreId != nil && len(*s.CustomKeyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomKeyStoreId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomKeyStoreId sets the CustomKeyStoreId field's value.
func (s *DeleteCustomKeyStoreInput) SetCustomKeyStoreId(v string) *DeleteCustomKeyStoreInput {
	s.CustomKeyStoreId = &v
	return s
}

type DeleteCustomKeyStoreOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomKeyStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomKeyStoreOutput) GoString() string {
	return s.String()
}

type DeleteImportedKeyMaterialInput struct {
	_ struct{} `type:"structure"`

	// Identifies the KMS key from which you are deleting imported key material.
	// The Origin of the KMS key must be EXTERNAL.
	//
	// Specify the key ID or key ARN of the KMS key.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImportedKeyMaterialInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImportedKeyMaterialInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteImportedKeyMaterialInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteImportedKeyMaterialInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyId sets the KeyId field's value.
func (s *DeleteImportedKeyMaterialInput) SetKeyId(v string) *DeleteImportedKeyMaterialInput {
	s.KeyId = &v
	return s
}

type DeleteImportedKeyMaterialOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImportedKeyMaterialOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImportedKeyMaterialOutput) GoString() string {
	return s.String()
}

// The system timed out while trying to fulfill the request. You can retry the
// request.
type DependencyTimeoutException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DependencyTimeoutException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DependencyTimeoutException) GoString() string {
	return s.String()
}

func newErrorDependencyTimeoutException(v protocol.ResponseMetadata) error {
	return &DependencyTimeoutException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DependencyTimeoutException) Code() string {
	return "DependencyTimeoutException"
}

// Message returns the exception's message.
func (s *DependencyTimeoutException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DependencyTimeoutException) OrigErr() error {
	return nil
}

func (s *DependencyTimeoutException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DependencyTimeoutException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DependencyTimeoutException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DescribeCustomKeyStoresInput struct {
	_ struct{} `type:"structure"`

	// Gets only information about the specified custom key store. Enter the key
	// store ID.
	//
	// By default, this operation gets information about all custom key stores in
	// the account and Region. To limit the output to a particular custom key store,
	// provide either the CustomKeyStoreId or CustomKeyStoreName parameter, but
	// not both.
	CustomKeyStoreId *string `min:"1" type:"string"`

	// Gets only information about the specified custom key store. Enter the friendly
	// name of the custom key store.
	//
	// By default, this operation gets information about all custom key stores in
	// the account and Region. To limit the output to a particular custom key store,
	// provide either the CustomKeyStoreId or CustomKeyStoreName parameter, but
	// not both.
	CustomKeyStoreName *string `min:"1" type:"string"`

	// Use this parameter to specify the maximum number of items to return. When
	// this value is present, KMS does not return more than the specified number
	// of items, but it might return fewer.
	Limit *int64 `min:"1" type:"integer"`

	// Use this parameter in a subsequent request after you receive a response with
	// truncated results. Set it to the value of NextMarker from the truncated response
	// you just received.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomKeyStoresInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomKeyStoresInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCustomKeyStoresInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCustomKeyStoresInput"}
	if s.CustomKeyStoreId != nil && len(*s.CustomKeyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomKeyStoreId", 1))
	}
	if s.CustomKeyStoreName != nil && len(*s.CustomKeyStoreName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomKeyStoreName", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomKeyStoreId sets the CustomKeyStoreId field's value.
func (s *DescribeCustomKeyStoresInput) SetCustomKeyStoreId(v string) *DescribeCustomKeyStoresInput {
	s.CustomKeyStoreId = &v
	return s
}

// SetCustomKeyStoreName sets the CustomKeyStoreName field's value.
func (s *DescribeCustomKeyStoresInput) SetCustomKeyStoreName(v string) *DescribeCustomKeyStoresInput {
	s.CustomKeyStoreName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeCustomKeyStoresInput) SetLimit(v int64) *DescribeCustomKeyStoresInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCustomKeyStoresInput) SetMarker(v string) *DescribeCustomKeyStoresInput {
	s.Marker = &v
	return s
}

type DescribeCustomKeyStoresOutput struct {
	_ struct{} `type:"structure"`

	// Contains metadata about each custom key store.
	CustomKeyStores []*CustomKeyStoresListEntry `type:"list"`

	// When Truncated is true, this element is present and contains the value to
	// use for the Marker parameter in a subsequent request.
	NextMarker *string `min:"1" type:"string"`

	// A flag that indicates whether there are more items in the list. When this
	// value is true, the list in this response is truncated. To get more items,
	// pass the value of the NextMarker element in thisresponse to the Marker parameter
	// in a subsequent request.
	Truncated *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomKeyStoresOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomKeyStoresOutput) GoString() string {
	return s.String()
}

// SetCustomKeyStores sets the CustomKeyStores field's value.
func (s *DescribeCustomKeyStoresOutput) SetCustomKeyStores(v []*CustomKeyStoresListEntry) *DescribeCustomKeyStoresOutput {
	s.CustomKeyStores = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *DescribeCustomKeyStoresOutput) SetNextMarker(v string) *DescribeCustomKeyStoresOutput {
	s.NextMarker = &v
	return s
}

// SetTruncated sets the Truncated field's value.
func (s *DescribeCustomKeyStoresOutput) SetTruncated(v bool) *DescribeCustomKeyStoresOutput {
	s.Truncated = &v
	return s
}

type DescribeKeyInput struct {
	_ struct{} `type:"structure"`

	// A list of grant tokens.
	//
	// Use a grant token when your permission to call this operation comes from
	// a new grant that has not yet achieved eventual consistency. For more information,
	// see Grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
	// and Using a grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
	// in the Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// Describes the specified KMS key.
	//
	// If you specify a predefined Amazon Web Services alias (an Amazon Web Services
	// alias with no key ID), KMS associates the alias with an Amazon Web Services
	// managed key (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html##aws-managed-cmk)
	// and returns its KeyId and Arn in the response.
	//
	// To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
	// When using an alias name, prefix it with "alias/". To specify a KMS key in
	// a different Amazon Web Services account, you must use the key ARN or alias
	// ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	// To get the alias name and alias ARN, use ListAliases.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeKeyInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrantTokens sets the GrantTokens field's value.
func (s *DescribeKeyInput) SetGrantTokens(v []*string) *DescribeKeyInput {
	s.GrantTokens = v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *DescribeKeyInput) SetKeyId(v string) *DescribeKeyInput {
	s.KeyId = &v
	return s
}

type DescribeKeyOutput struct {
	_ struct{} `type:"structure"`

	// Metadata associated with the key.
	KeyMetadata *KeyMetadata `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeKeyOutput) GoString() string {
	return s.String()
}

// SetKeyMetadata sets the KeyMetadata field's value.
func (s *DescribeKeyOutput) SetKeyMetadata(v *KeyMetadata) *DescribeKeyOutput {
	s.KeyMetadata = v
	return s
}

type DisableKeyInput struct {
	_ struct{} `type:"structure"`

	// Identifies the KMS key to disable.
	//
	// Specify the key ID or key ARN of the KMS key.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableKeyInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyId sets the KeyId field's value.
func (s *DisableKeyInput) SetKeyId(v string) *DisableKeyInput {
	s.KeyId = &v
	return s
}

type DisableKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableKeyOutput) GoString() string {
	return s.String()
}

type DisableKeyRotationInput struct {
	_ struct{} `type:"structure"`

	// Identifies a symmetric encryption KMS key. You cannot enable or disable automatic
	// rotation of asymmetric KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html#asymmetric-cmks),
	// HMAC KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html),
	// KMS keys with imported key material (https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html),
	// or KMS keys in a custom key store (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html).
	//
	// Specify the key ID or key ARN of the KMS key.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableKeyRotationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableKeyRotationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableKeyRotationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableKeyRotationInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyId sets the KeyId field's value.
func (s *DisableKeyRotationInput) SetKeyId(v string) *DisableKeyRotationInput {
	s.KeyId = &v
	return s
}

type DisableKeyRotationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableKeyRotationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableKeyRotationOutput) GoString() string {
	return s.String()
}

// The request was rejected because the specified KMS key is not enabled.
type DisabledException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisabledException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisabledException) GoString() string {
	return s.String()
}

func newErrorDisabledException(v protocol.ResponseMetadata) error {
	return &DisabledException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DisabledException) Code() string {
	return "DisabledException"
}

// Message returns the exception's message.
func (s *DisabledException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DisabledException) OrigErr() error {
	return nil
}

func (s *DisabledException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DisabledException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DisabledException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DisconnectCustomKeyStoreInput struct {
	_ struct{} `type:"structure"`

	// Enter the ID of the custom key store you want to disconnect. To find the
	// ID of a custom key store, use the DescribeCustomKeyStores operation.
	//
	// CustomKeyStoreId is a required field
	CustomKeyStoreId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectCustomKeyStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectCustomKeyStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisconnectCustomKeyStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisconnectCustomKeyStoreInput"}
	if s.CustomKeyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomKeyStoreId"))
	}
	if s.CustomKeyStoreId != nil && len(*s.CustomKeyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomKeyStoreId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomKeyStoreId sets the CustomKeyStoreId field's value.
func (s *DisconnectCustomKeyStoreInput) SetCustomKeyStoreId(v string) *DisconnectCustomKeyStoreInput {
	s.CustomKeyStoreId = &v
	return s
}

type DisconnectCustomKeyStoreOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectCustomKeyStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectCustomKeyStoreOutput) GoString() string {
	return s.String()
}

type EnableKeyInput struct {
	_ struct{} `type:"structure"`

	// Identifies the KMS key to enable.
	//
	// Specify the key ID or key ARN of the KMS key.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableKeyInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyId sets the KeyId field's value.
func (s *EnableKeyInput) SetKeyId(v string) *EnableKeyInput {
	s.KeyId = &v
	return s
}

type EnableKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableKeyOutput) GoString() string {
	return s.String()
}

type EnableKeyRotationInput struct {
	_ struct{} `type:"structure"`

	// Identifies a symmetric encryption KMS key. You cannot enable automatic rotation
	// of asymmetric KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html),
	// HMAC KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html),
	// KMS keys with imported key material (https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html),
	// or KMS keys in a custom key store (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html).
	// To enable or disable automatic rotation of a set of related multi-Region
	// keys (https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-manage.html#multi-region-rotate),
	// set the property on the primary key.
	//
	// Specify the key ID or key ARN of the KMS key.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableKeyRotationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableKeyRotationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableKeyRotationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableKeyRotationInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyId sets the KeyId field's value.
func (s *EnableKeyRotationInput) SetKeyId(v string) *EnableKeyRotationInput {
	s.KeyId = &v
	return s
}

type EnableKeyRotationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableKeyRotationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableKeyRotationOutput) GoString() string {
	return s.String()
}

type EncryptInput struct {
	_ struct{} `type:"structure"`

	// Specifies the encryption algorithm that KMS will use to encrypt the plaintext
	// message. The algorithm must be compatible with the KMS key that you specify.
	//
	// This parameter is required only for asymmetric KMS keys. The default value,
	// SYMMETRIC_DEFAULT, is the algorithm used for symmetric encryption KMS keys.
	// If you are using an asymmetric KMS key, we recommend RSAES_OAEP_SHA_256.
	//
	// The SM2PKE algorithm is only available in China Regions.
	EncryptionAlgorithm *string `type:"string" enum:"EncryptionAlgorithmSpec"`

	// Specifies the encryption context that will be used to encrypt the data. An
	// encryption context is valid only for cryptographic operations (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
	// with a symmetric encryption KMS key. The standard asymmetric encryption algorithms
	// and HMAC algorithms that KMS uses do not support an encryption context.
	//
	// An encryption context is a collection of non-secret key-value pairs that
	// represent additional authenticated data. When you use an encryption context
	// to encrypt data, you must specify the same (an exact case-sensitive match)
	// encryption context to decrypt the data. An encryption context is supported
	// only on operations with symmetric encryption KMS keys. On operations with
	// symmetric encryption KMS keys, an encryption context is optional, but it
	// is strongly recommended.
	//
	// For more information, see Encryption context (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
	// in the Key Management Service Developer Guide.
	EncryptionContext map[string]*string `type:"map"`

	// A list of grant tokens.
	//
	// Use a grant token when your permission to call this operation comes from
	// a new grant that has not yet achieved eventual consistency. For more information,
	// see Grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
	// and Using a grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
	// in the Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// Identifies the KMS key to use in the encryption operation. The KMS key must
	// have a KeyUsage of ENCRYPT_DECRYPT. To find the KeyUsage of a KMS key, use
	// the DescribeKey operation.
	//
	// To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
	// When using an alias name, prefix it with "alias/". To specify a KMS key in
	// a different Amazon Web Services account, you must use the key ARN or alias
	// ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	// To get the alias name and alias ARN, use ListAliases.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// Data to be encrypted.
	//
	// Plaintext is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EncryptInput's
	// String and GoString methods.
	//
	// Plaintext is automatically base64 encoded/decoded by the SDK.
	//
	// Plaintext is a required field
	Plaintext []byte `min:"1" type:"blob" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.Plaintext == nil {
		invalidParams.Add(request.NewErrParamRequired("Plaintext"))
	}
	if s.Plaintext != nil && len(s.Plaintext) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Plaintext", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionAlgorithm sets the EncryptionAlgorithm field's value.
func (s *EncryptInput) SetEncryptionAlgorithm(v string) *EncryptInput {
	s.EncryptionAlgorithm = &v
	return s
}

// SetEncryptionContext sets the EncryptionContext field's value.
func (s *EncryptInput) SetEncryptionContext(v map[string]*string) *EncryptInput {
	s.EncryptionContext = v
	return s
}

// SetGrantTokens sets the GrantTokens field's value.
func (s *EncryptInput) SetGrantTokens(v []*string) *EncryptInput {
	s.GrantTokens = v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *EncryptInput) SetKeyId(v string) *EncryptInput {
	s.KeyId = &v
	return s
}

// SetPlaintext sets the Plaintext field's value.
func (s *EncryptInput) SetPlaintext(v []byte) *EncryptInput {
	s.Plaintext = v
	return s
}

type EncryptOutput struct {
	_ struct{} `type:"structure"`

	// The encrypted plaintext. When you use the HTTP API or the Amazon Web Services
	// CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
	// CiphertextBlob is automatically base64 encoded/decoded by the SDK.
	CiphertextBlob []byte `min:"1" type:"blob"`

	// The encryption algorithm that was used to encrypt the plaintext.
	EncryptionAlgorithm *string `type:"string" enum:"EncryptionAlgorithmSpec"`

	// The Amazon Resource Name (key ARN (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN))
	// of the KMS key that was used to encrypt the plaintext.
	KeyId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptOutput) GoString() string {
	return s.String()
}

// SetCiphertextBlob sets the CiphertextBlob field's value.
func (s *EncryptOutput) SetCiphertextBlob(v []byte) *EncryptOutput {
	s.CiphertextBlob = v
	return s
}

// SetEncryptionAlgorithm sets the EncryptionAlgorithm field's value.
func (s *EncryptOutput) SetEncryptionAlgorithm(v string) *EncryptOutput {
	s.EncryptionAlgorithm = &v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *EncryptOutput) SetKeyId(v string) *EncryptOutput {
	s.KeyId = &v
	return s
}

// The request was rejected because the specified import token is expired. Use
// GetParametersForImport to get a new import token and public key, use the
// new public key to encrypt the key material, and then try the request again.
type ExpiredImportTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpiredImportTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpiredImportTokenException) GoString() string {
	return s.String()
}

func newErrorExpiredImportTokenException(v protocol.ResponseMetadata) error {
	return &ExpiredImportTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ExpiredImportTokenException) Code() string {
	return "ExpiredImportTokenException"
}

// Message returns the exception's message.
func (s *ExpiredImportTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ExpiredImportTokenException) OrigErr() error {
	return nil
}

func (s *ExpiredImportTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ExpiredImportTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ExpiredImportTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GenerateDataKeyInput struct {
	_ struct{} `type:"structure"`

	// Specifies the encryption context that will be used when encrypting the data
	// key.
	//
	// An encryption context is a collection of non-secret key-value pairs that
	// represent additional authenticated data. When you use an encryption context
	// to encrypt data, you must specify the same (an exact case-sensitive match)
	// encryption context to decrypt the data. An encryption context is supported
	// only on operations with symmetric encryption KMS keys. On operations with
	// symmetric encryption KMS keys, an encryption context is optional, but it
	// is strongly recommended.
	//
	// For more information, see Encryption context (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
	// in the Key Management Service Developer Guide.
	EncryptionContext map[string]*string `type:"map"`

	// A list of grant tokens.
	//
	// Use a grant token when your permission to call this operation comes from
	// a new grant that has not yet achieved eventual consistency. For more information,
	// see Grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
	// and Using a grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
	// in the Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// Specifies the symmetric encryption KMS key that encrypts the data key. You
	// cannot specify an asymmetric KMS key or a KMS key in a custom key store.
	// To get the type and origin of your KMS key, use the DescribeKey operation.
	//
	// To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
	// When using an alias name, prefix it with "alias/". To specify a KMS key in
	// a different Amazon Web Services account, you must use the key ARN or alias
	// ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	// To get the alias name and alias ARN, use ListAliases.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// Specifies the length of the data key. Use AES_128 to generate a 128-bit symmetric
	// key, or AES_256 to generate a 256-bit symmetric key.
	//
	// You must specify either the KeySpec or the NumberOfBytes parameter (but not
	// both) in every GenerateDataKey request.
	KeySpec *string `type:"string" enum:"DataKeySpec"`

	// Specifies the length of the data key in bytes. For example, use the value
	// 64 to generate a 512-bit data key (64 bytes is 512 bits). For 128-bit (16-byte)
	// and 256-bit (32-byte) data keys, use the KeySpec parameter.
	//
	// You must specify either the KeySpec or the NumberOfBytes parameter (but not
	// both) in every GenerateDataKey request.
	NumberOfBytes *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateDataKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateDataKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GenerateDataKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GenerateDataKeyInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.NumberOfBytes != nil && *s.NumberOfBytes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumberOfBytes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionContext sets the EncryptionContext field's value.
func (s *GenerateDataKeyInput) SetEncryptionContext(v map[string]*string) *GenerateDataKeyInput {
	s.EncryptionContext = v
	return s
}

// SetGrantTokens sets the GrantTokens field's value.
func (s *GenerateDataKeyInput) SetGrantTokens(v []*string) *GenerateDataKeyInput {
	s.GrantTokens = v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *GenerateDataKeyInput) SetKeyId(v string) *GenerateDataKeyInput {
	s.KeyId = &v
	return s
}

// SetKeySpec sets the KeySpec field's value.
func (s *GenerateDataKeyInput) SetKeySpec(v string) *GenerateDataKeyInput {
	s.KeySpec = &v
	return s
}

// SetNumberOfBytes sets the NumberOfBytes field's value.
func (s *GenerateDataKeyInput) SetNumberOfBytes(v int64) *GenerateDataKeyInput {
	s.NumberOfBytes = &v
	return s
}

type GenerateDataKeyOutput struct {
	_ struct{} `type:"structure"`

	// The encrypted copy of the data key. When you use the HTTP API or the Amazon
	// Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
	// CiphertextBlob is automatically base64 encoded/decoded by the SDK.
	CiphertextBlob []byte `min:"1" type:"blob"`

	// The Amazon Resource Name (key ARN (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN))
	// of the KMS key that encrypted the data key.
	KeyId *string `min:"1" type:"string"`

	// The plaintext data key. When you use the HTTP API or the Amazon Web Services
	// CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded. Use
	// this data key to encrypt your data outside of KMS. Then, remove it from memory
	// as soon as possible.
	//
	// Plaintext is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GenerateDataKeyOutput's
	// String and GoString methods.
	//
	// Plaintext is automatically base64 encoded/decoded by the SDK.
	Plaintext []byte `min:"1" type:"blob" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateDataKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateDataKeyOutput) GoString() string {
	return s.String()
}

// SetCiphertextBlob sets the CiphertextBlob field's value.
func (s *GenerateDataKeyOutput) SetCiphertextBlob(v []byte) *GenerateDataKeyOutput {
	s.CiphertextBlob = v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *GenerateDataKeyOutput) SetKeyId(v string) *GenerateDataKeyOutput {
	s.KeyId = &v
	return s
}

// SetPlaintext sets the Plaintext field's value.
func (s *GenerateDataKeyOutput) SetPlaintext(v []byte) *GenerateDataKeyOutput {
	s.Plaintext = v
	return s
}

type GenerateDataKeyPairInput struct {
	_ struct{} `type:"structure"`

	// Specifies the encryption context that will be used when encrypting the private
	// key in the data key pair.
	//
	// An encryption context is a collection of non-secret key-value pairs that
	// represent additional authenticated data. When you use an encryption context
	// to encrypt data, you must specify the same (an exact case-sensitive match)
	// encryption context to decrypt the data. An encryption context is supported
	// only on operations with symmetric encryption KMS keys. On operations with
	// symmetric encryption KMS keys, an encryption context is optional, but it
	// is strongly recommended.
	//
	// For more information, see Encryption context (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
	// in the Key Management Service Developer Guide.
	EncryptionContext map[string]*string `type:"map"`

	// A list of grant tokens.
	//
	// Use a grant token when your permission to call this operation comes from
	// a new grant that has not yet achieved eventual consistency. For more information,
	// see Grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
	// and Using a grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
	// in the Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// Specifies the symmetric encryption KMS key that encrypts the private key
	// in the data key pair. You cannot specify an asymmetric KMS key or a KMS key
	// in a custom key store. To get the type and origin of your KMS key, use the
	// DescribeKey operation.
	//
	// To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
	// When using an alias name, prefix it with "alias/". To specify a KMS key in
	// a different Amazon Web Services account, you must use the key ARN or alias
	// ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	// To get the alias name and alias ARN, use ListAliases.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// Determines the type of data key pair that is generated.
	//
	// The KMS rule that restricts the use of asymmetric RSA and SM2 KMS keys to
	// encrypt and decrypt or to sign and verify (but not both), and the rule that
	// permits you to use ECC KMS keys only to sign and verify, are not effective
	// on data key pairs, which are used outside of KMS. The SM2 key spec is only
	// available in China Regions.
	//
	// KeyPairSpec is a required field
	KeyPairSpec *string `type:"string" required:"true" enum:"DataKeyPairSpec"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateDataKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateDataKeyPairInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GenerateDataKeyPairInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GenerateDataKeyPairInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.KeyPairSpec == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyPairSpec"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionContext sets the EncryptionContext field's value.
func (s *GenerateDataKeyPairInput) SetEncryptionContext(v map[string]*string) *GenerateDataKeyPairInput {
	s.EncryptionContext = v
	return s
}

// SetGrantTokens sets the GrantTokens field's value.
func (s *GenerateDataKeyPairInput) SetGrantTokens(v []*string) *GenerateDataKeyPairInput {
	s.GrantTokens = v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *GenerateDataKeyPairInput) SetKeyId(v string) *GenerateDataKeyPairInput {
	s.KeyId = &v
	return s
}

// SetKeyPairSpec sets the KeyPairSpec field's value.
func (s *GenerateDataKeyPairInput) SetKeyPairSpec(v string) *GenerateDataKeyPairInput {
	s.KeyPairSpec = &v
	return s
}

type GenerateDataKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (key ARN (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN))
	// of the KMS key that encrypted the private key.
	KeyId *string `min:"1" type:"string"`

	// The type of data key pair that was generated.
	KeyPairSpec *string `type:"string" enum:"DataKeyPairSpec"`

	// The encrypted copy of the private key. When you use the HTTP API or the Amazon
	// Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
	// PrivateKeyCiphertextBlob is automatically base64 encoded/decoded by the SDK.
	PrivateKeyCiphertextBlob []byte `min:"1" type:"blob"`

	// The plaintext copy of the private key. When you use the HTTP API or the Amazon
	// Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
	//
	// PrivateKeyPlaintext is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GenerateDataKeyPairOutput's
	// String and GoString methods.
	//
	// PrivateKeyPlaintext is automatically base64 encoded/decoded by the SDK.
	PrivateKeyPlaintext []byte `min:"1" type:"blob" sensitive:"true"`

	// The public key (in plaintext). When you use the HTTP API or the Amazon Web
	// Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
	// PublicKey is automatically base64 encoded/decoded by the SDK.
	PublicKey []byte `min:"1" type:"blob"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateDataKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateDataKeyPairOutput) GoString() string {
	return s.String()
}

// SetKeyId sets the KeyId field's value.
func (s *GenerateDataKeyPairOutput) SetKeyId(v string) *GenerateDataKeyPairOutput {
	s.KeyId = &v
	return s
}

// SetKeyPairSpec sets the KeyPairSpec field's value.
func (s *GenerateDataKeyPairOutput) SetKeyPairSpec(v string) *GenerateDataKeyPairOutput {
	s.KeyPairSpec = &v
	return s
}

// SetPrivateKeyCiphertextBlob sets the PrivateKeyCiphertextBlob field's value.
func (s *GenerateDataKeyPairOutput) SetPrivateKeyCiphertextBlob(v []byte) *GenerateDataKeyPairOutput {
	s.PrivateKeyCiphertextBlob = v
	return s
}

// SetPrivateKeyPlaintext sets the PrivateKeyPlaintext field's value.
func (s *GenerateDataKeyPairOutput) SetPrivateKeyPlaintext(v []byte) *GenerateDataKeyPairOutput {
	s.PrivateKeyPlaintext = v
	return s
}

// SetPublicKey sets the PublicKey field's value.
func (s *GenerateDataKeyPairOutput) SetPublicKey(v []byte) *GenerateDataKeyPairOutput {
	s.PublicKey = v
	return s
}

type GenerateDataKeyPairWithoutPlaintextInput struct {
	_ struct{} `type:"structure"`

	// Specifies the encryption context that will be used when encrypting the private
	// key in the data key pair.
	//
	// An encryption context is a collection of non-secret key-value pairs that
	// represent additional authenticated data. When you use an encryption context
	// to encrypt data, you must specify the same (an exact case-sensitive match)
	// encryption context to decrypt the data. An encryption context is supported
	// only on operations with symmetric encryption KMS keys. On operations with
	// symmetric encryption KMS keys, an encryption context is optional, but it
	// is strongly recommended.
	//
	// For more information, see Encryption context (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
	// in the Key Management Service Developer Guide.
	EncryptionContext map[string]*string `type:"map"`

	// A list of grant tokens.
	//
	// Use a grant token when your permission to call this operation comes from
	// a new grant that has not yet achieved eventual consistency. For more information,
	// see Grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
	// and Using a grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
	// in the Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// Specifies the symmetric encryption KMS key that encrypts the private key
	// in the data key pair. You cannot specify an asymmetric KMS key or a KMS key
	// in a custom key store. To get the type and origin of your KMS key, use the
	// DescribeKey operation.
	//
	// To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
	// When using an alias name, prefix it with "alias/". To specify a KMS key in
	// a different Amazon Web Services account, you must use the key ARN or alias
	// ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	// To get the alias name and alias ARN, use ListAliases.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// Determines the type of data key pair that is generated.
	//
	// The KMS rule that restricts the use of asymmetric RSA and SM2 KMS keys to
	// encrypt and decrypt or to sign and verify (but not both), and the rule that
	// permits you to use ECC KMS keys only to sign and verify, are not effective
	// on data key pairs, which are used outside of KMS. The SM2 key spec is only
	// available in China Regions.
	//
	// KeyPairSpec is a required field
	KeyPairSpec *string `type:"string" required:"true" enum:"DataKeyPairSpec"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateDataKeyPairWithoutPlaintextInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateDataKeyPairWithoutPlaintextInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GenerateDataKeyPairWithoutPlaintextInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GenerateDataKeyPairWithoutPlaintextInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.KeyPairSpec == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyPairSpec"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionContext sets the EncryptionContext field's value.
func (s *GenerateDataKeyPairWithoutPlaintextInput) SetEncryptionContext(v map[string]*string) *GenerateDataKeyPairWithoutPlaintextInput {
	s.EncryptionContext = v
	return s
}

// SetGrantTokens sets the GrantTokens field's value.
func (s *GenerateDataKeyPairWithoutPlaintextInput) SetGrantTokens(v []*string) *GenerateDataKeyPairWithoutPlaintextInput {
	s.GrantTokens = v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *GenerateDataKeyPairWithoutPlaintextInput) SetKeyId(v string) *GenerateDataKeyPairWithoutPlaintextInput {
	s.KeyId = &v
	return s
}

// SetKeyPairSpec sets the KeyPairSpec field's value.
func (s *GenerateDataKeyPairWithoutPlaintextInput) SetKeyPairSpec(v string) *GenerateDataKeyPairWithoutPlaintextInput {
	s.KeyPairSpec = &v
	return s
}

type GenerateDataKeyPairWithoutPlaintextOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (key ARN (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN))
	// of the KMS key that encrypted the private key.
	KeyId *string `min:"1" type:"string"`

	// The type of data key pair that was generated.
	KeyPairSpec *string `type:"string" enum:"DataKeyPairSpec"`

	// The encrypted copy of the private key. When you use the HTTP API or the Amazon
	// Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
	// PrivateKeyCiphertextBlob is automatically base64 encoded/decoded by the SDK.
	PrivateKeyCiphertextBlob []byte `min:"1" type:"blob"`

	// The public key (in plaintext). When you use the HTTP API or the Amazon Web
	// Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
	// PublicKey is automatically base64 encoded/decoded by the SDK.
	PublicKey []byte `min:"1" type:"blob"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateDataKeyPairWithoutPlaintextOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateDataKeyPairWithoutPlaintextOutput) GoString() string {
	return s.String()
}

// SetKeyId sets the KeyId field's value.
func (s *GenerateDataKeyPairWithoutPlaintextOutput) SetKeyId(v string) *GenerateDataKeyPairWithoutPlaintextOutput {
	s.KeyId = &v
	return s
}

// SetKeyPairSpec sets the KeyPairSpec field's value.
func (s *GenerateDataKeyPairWithoutPlaintextOutput) SetKeyPairSpec(v string) *GenerateDataKeyPairWithoutPlaintextOutput {
	s.KeyPairSpec = &v
	return s
}

// SetPrivateKeyCiphertextBlob sets the PrivateKeyCiphertextBlob field's value.
func (s *GenerateDataKeyPairWithoutPlaintextOutput) SetPrivateKeyCiphertextBlob(v []byte) *GenerateDataKeyPairWithoutPlaintextOutput {
	s.PrivateKeyCiphertextBlob = v
	return s
}

// SetPublicKey sets the PublicKey field's value.
func (s *GenerateDataKeyPairWithoutPlaintextOutput) SetPublicKey(v []byte) *GenerateDataKeyPairWithoutPlaintextOutput {
	s.PublicKey = v
	return s
}

type GenerateDataKeyWithoutPlaintextInput struct {
	_ struct{} `type:"structure"`

	// Specifies the encryption context that will be used when encrypting the data
	// key.
	//
	// An encryption context is a collection of non-secret key-value pairs that
	// represent additional authenticated data. When you use an encryption context
	// to encrypt data, you must specify the same (an exact case-sensitive match)
	// encryption context to decrypt the data. An encryption context is supported
	// only on operations with symmetric encryption KMS keys. On operations with
	// symmetric encryption KMS keys, an encryption context is optional, but it
	// is strongly recommended.
	//
	// For more information, see Encryption context (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
	// in the Key Management Service Developer Guide.
	EncryptionContext map[string]*string `type:"map"`

	// A list of grant tokens.
	//
	// Use a grant token when your permission to call this operation comes from
	// a new grant that has not yet achieved eventual consistency. For more information,
	// see Grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
	// and Using a grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
	// in the Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// Specifies the symmetric encryption KMS key that encrypts the data key. You
	// cannot specify an asymmetric KMS key or a KMS key in a custom key store.
	// To get the type and origin of your KMS key, use the DescribeKey operation.
	//
	// To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
	// When using an alias name, prefix it with "alias/". To specify a KMS key in
	// a different Amazon Web Services account, you must use the key ARN or alias
	// ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	// To get the alias name and alias ARN, use ListAliases.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// The length of the data key. Use AES_128 to generate a 128-bit symmetric key,
	// or AES_256 to generate a 256-bit symmetric key.
	KeySpec *string `type:"string" enum:"DataKeySpec"`

	// The length of the data key in bytes. For example, use the value 64 to generate
	// a 512-bit data key (64 bytes is 512 bits). For common key lengths (128-bit
	// and 256-bit symmetric keys), we recommend that you use the KeySpec field
	// instead of this one.
	NumberOfBytes *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateDataKeyWithoutPlaintextInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateDataKeyWithoutPlaintextInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GenerateDataKeyWithoutPlaintextInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GenerateDataKeyWithoutPlaintextInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.NumberOfBytes != nil && *s.NumberOfBytes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumberOfBytes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionContext sets the EncryptionContext field's value.
func (s *GenerateDataKeyWithoutPlaintextInput) SetEncryptionContext(v map[string]*string) *GenerateDataKeyWithoutPlaintextInput {
	s.EncryptionContext = v
	return s
}

// SetGrantTokens sets the GrantTokens field's value.
func (s *GenerateDataKeyWithoutPlaintextInput) SetGrantTokens(v []*string) *GenerateDataKeyWithoutPlaintextInput {
	s.GrantTokens = v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *GenerateDataKeyWithoutPlaintextInput) SetKeyId(v string) *GenerateDataKeyWithoutPlaintextInput {
	s.KeyId = &v
	return s
}

// SetKeySpec sets the KeySpec field's value.
func (s *GenerateDataKeyWithoutPlaintextInput) SetKeySpec(v string) *GenerateDataKeyWithoutPlaintextInput {
	s.KeySpec = &v
	return s
}

// SetNumberOfBytes sets the NumberOfBytes field's value.
func (s *GenerateDataKeyWithoutPlaintextInput) SetNumberOfBytes(v int64) *GenerateDataKeyWithoutPlaintextInput {
	s.NumberOfBytes = &v
	return s
}

type GenerateDataKeyWithoutPlaintextOutput struct {
	_ struct{} `type:"structure"`

	// The encrypted data key. When you use the HTTP API or the Amazon Web Services
	// CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
	// CiphertextBlob is automatically base64 encoded/decoded by the SDK.
	CiphertextBlob []byte `min:"1" type:"blob"`

	// The Amazon Resource Name (key ARN (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN))
	// of the KMS key that encrypted the data key.
	KeyId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateDataKeyWithoutPlaintextOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateDataKeyWithoutPlaintextOutput) GoString() string {
	return s.String()
}

// SetCiphertextBlob sets the CiphertextBlob field's value.
func (s *GenerateDataKeyWithoutPlaintextOutput) SetCiphertextBlob(v []byte) *GenerateDataKeyWithoutPlaintextOutput {
	s.CiphertextBlob = v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *GenerateDataKeyWithoutPlaintextOutput) SetKeyId(v string) *GenerateDataKeyWithoutPlaintextOutput {
	s.KeyId = &v
	return s
}

type GenerateMacInput struct {
	_ struct{} `type:"structure"`

	// A list of grant tokens.
	//
	// Use a grant token when your permission to call this operation comes from
	// a new grant that has not yet achieved eventual consistency. For more information,
	// see Grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
	// and Using a grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
	// in the Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// The HMAC KMS key to use in the operation. The MAC algorithm computes the
	// HMAC for the message and the key as described in RFC 2104 (https://datatracker.ietf.org/doc/html/rfc2104).
	//
	// To identify an HMAC KMS key, use the DescribeKey operation and see the KeySpec
	// field in the response.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// The MAC algorithm used in the operation.
	//
	// The algorithm must be compatible with the HMAC KMS key that you specify.
	// To find the MAC algorithms that your HMAC KMS key supports, use the DescribeKey
	// operation and see the MacAlgorithms field in the DescribeKey response.
	//
	// MacAlgorithm is a required field
	MacAlgorithm *string `type:"string" required:"true" enum:"MacAlgorithmSpec"`

	// The message to be hashed. Specify a message of up to 4,096 bytes.
	//
	// GenerateMac and VerifyMac do not provide special handling for message digests.
	// If you generate an HMAC for a hash digest of a message, you must verify the
	// HMAC of the same hash digest.
	//
	// Message is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GenerateMacInput's
	// String and GoString methods.
	//
	// Message is automatically base64 encoded/decoded by the SDK.
	//
	// Message is a required field
	Message []byte `min:"1" type:"blob" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateMacInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateMacInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GenerateMacInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GenerateMacInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.MacAlgorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("MacAlgorithm"))
	}
	if s.Message == nil {
		invalidParams.Add(request.NewErrParamRequired("Message"))
	}
	if s.Message != nil && len(s.Message) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Message", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrantTokens sets the GrantTokens field's value.
func (s *GenerateMacInput) SetGrantTokens(v []*string) *GenerateMacInput {
	s.GrantTokens = v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *GenerateMacInput) SetKeyId(v string) *GenerateMacInput {
	s.KeyId = &v
	return s
}

// SetMacAlgorithm sets the MacAlgorithm field's value.
func (s *GenerateMacInput) SetMacAlgorithm(v string) *GenerateMacInput {
	s.MacAlgorithm = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *GenerateMacInput) SetMessage(v []byte) *GenerateMacInput {
	s.Message = v
	return s
}

type GenerateMacOutput struct {
	_ struct{} `type:"structure"`

	// The HMAC KMS key used in the operation.
	KeyId *string `min:"1" type:"string"`

	// The hash-based message authentication code (HMAC) that was generated for
	// the specified message, HMAC KMS key, and MAC algorithm.
	//
	// This is the standard, raw HMAC defined in RFC 2104 (https://datatracker.ietf.org/doc/html/rfc2104).
	// Mac is automatically base64 encoded/decoded by the SDK.
	Mac []byte `min:"1" type:"blob"`

	// The MAC algorithm that was used to generate the HMAC.
	MacAlgorithm *string `type:"string" enum:"MacAlgorithmSpec"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateMacOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateMacOutput) GoString() string {
	return s.String()
}

// SetKeyId sets the KeyId field's value.
func (s *GenerateMacOutput) SetKeyId(v string) *GenerateMacOutput {
	s.KeyId = &v
	return s
}

// SetMac sets the Mac field's value.
func (s *GenerateMacOutput) SetMac(v []byte) *GenerateMacOutput {
	s.Mac = v
	return s
}

// SetMacAlgorithm sets the MacAlgorithm field's value.
func (s *GenerateMacOutput) SetMacAlgorithm(v string) *GenerateMacOutput {
	s.MacAlgorithm = &v
	return s
}

type GenerateRandomInput struct {
	_ struct{} `type:"structure"`

	// Generates the random byte string in the CloudHSM cluster that is associated
	// with the specified CloudHSM key store. To find the ID of a custom key store,
	// use the DescribeCustomKeyStores operation.
	//
	// External key store IDs are not valid for this parameter. If you specify the
	// ID of an external key store, GenerateRandom throws an UnsupportedOperationException.
	CustomKeyStoreId *string `min:"1" type:"string"`

	// The length of the random byte string. This parameter is required.
	NumberOfBytes *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateRandomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateRandomInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GenerateRandomInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GenerateRandomInput"}
	if s.CustomKeyStoreId != nil && len(*s.CustomKeyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomKeyStoreId", 1))
	}
	if s.NumberOfBytes != nil && *s.NumberOfBytes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumberOfBytes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomKeyStoreId sets the CustomKeyStoreId field's value.
func (s *GenerateRandomInput) SetCustomKeyStoreId(v string) *GenerateRandomInput {
	s.CustomKeyStoreId = &v
	return s
}

// SetNumberOfBytes sets the NumberOfBytes field's value.
func (s *GenerateRandomInput) SetNumberOfBytes(v int64) *GenerateRandomInput {
	s.NumberOfBytes = &v
	return s
}

type GenerateRandomOutput struct {
	_ struct{} `type:"structure"`

	// The random byte string. When you use the HTTP API or the Amazon Web Services
	// CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
	//
	// Plaintext is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GenerateRandomOutput's
	// String and GoString methods.
	//
	// Plaintext is automatically base64 encoded/decoded by the SDK.
	Plaintext []byte `min:"1" type:"blob" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateRandomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateRandomOutput) GoString() string {
	return s.String()
}

// SetPlaintext sets the Plaintext field's value.
func (s *GenerateRandomOutput) SetPlaintext(v []byte) *GenerateRandomOutput {
	s.Plaintext = v
	return s
}

type GetKeyPolicyInput struct {
	_ struct{} `type:"structure"`

	// Gets the key policy for the specified KMS key.
	//
	// Specify the key ID or key ARN of the KMS key.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// Specifies the name of the key policy. The only valid name is default. To
	// get the names of key policies, use ListKeyPolicies.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKeyPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKeyPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetKeyPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetKeyPolicyInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyId sets the KeyId field's value.
func (s *GetKeyPolicyInput) SetKeyId(v string) *GetKeyPolicyInput {
	s.KeyId = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *GetKeyPolicyInput) SetPolicyName(v string) *GetKeyPolicyInput {
	s.PolicyName = &v
	return s
}

type GetKeyPolicyOutput struct {
	_ struct{} `type:"structure"`

	// A key policy document in JSON format.
	Policy *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKeyPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKeyPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetKeyPolicyOutput) SetPolicy(v string) *GetKeyPolicyOutput {
	s.Policy = &v
	return s
}

type GetKeyRotationStatusInput struct {
	_ struct{} `type:"structure"`

	// Gets the rotation status for the specified KMS key.
	//
	// Specify the key ID or key ARN of the KMS key. To specify a KMS key in a different
	// Amazon Web Services account, you must use the key ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKeyRotationStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKeyRotationStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetKeyRotationStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetKeyRotationStatusInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyId sets the KeyId field's value.
func (s *GetKeyRotationStatusInput) SetKeyId(v string) *GetKeyRotationStatusInput {
	s.KeyId = &v
	return s
}

type GetKeyRotationStatusOutput struct {
	_ struct{} `type:"structure"`

	// A Boolean value that specifies whether key rotation is enabled.
	KeyRotationEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKeyRotationStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKeyRotationStatusOutput) GoString() string {
	return s.String()
}

// SetKeyRotationEnabled sets the KeyRotationEnabled field's value.
func (s *GetKeyRotationStatusOutput) SetKeyRotationEnabled(v bool) *GetKeyRotationStatusOutput {
	s.KeyRotationEnabled = &v
	return s
}

type GetParametersForImportInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the symmetric encryption KMS key into which you will import
	// key material. The Origin of the KMS key must be EXTERNAL.
	//
	// Specify the key ID or key ARN of the KMS key.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// The algorithm you will use to encrypt the key material before importing it
	// with ImportKeyMaterial. For more information, see Encrypt the Key Material
	// (https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html)
	// in the Key Management Service Developer Guide.
	//
	// WrappingAlgorithm is a required field
	WrappingAlgorithm *string `type:"string" required:"true" enum:"AlgorithmSpec"`

	// The type of wrapping key (public key) to return in the response. Only 2048-bit
	// RSA public keys are supported.
	//
	// WrappingKeySpec is a required field
	WrappingKeySpec *string `type:"string" required:"true" enum:"WrappingKeySpec"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetParametersForImportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetParametersForImportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetParametersForImportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetParametersForImportInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.WrappingAlgorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("WrappingAlgorithm"))
	}
	if s.WrappingKeySpec == nil {
		invalidParams.Add(request.NewErrParamRequired("WrappingKeySpec"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyId sets the KeyId field's value.
func (s *GetParametersForImportInput) SetKeyId(v string) *GetParametersForImportInput {
	s.KeyId = &v
	return s
}

// SetWrappingAlgorithm sets the WrappingAlgorithm field's value.
func (s *GetParametersForImportInput) SetWrappingAlgorithm(v string) *GetParametersForImportInput {
	s.WrappingAlgorithm = &v
	return s
}

// SetWrappingKeySpec sets the WrappingKeySpec field's value.
func (s *GetParametersForImportInput) SetWrappingKeySpec(v string) *GetParametersForImportInput {
	s.WrappingKeySpec = &v
	return s
}

type GetParametersForImportOutput struct {
	_ struct{} `type:"structure"`

	// The import token to send in a subsequent ImportKeyMaterial request.
	// ImportToken is automatically base64 encoded/decoded by the SDK.
	ImportToken []byte `min:"1" type:"blob"`

	// The Amazon Resource Name (key ARN (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN))
	// of the KMS key to use in a subsequent ImportKeyMaterial request. This is
	// the same KMS key specified in the GetParametersForImport request.
	KeyId *string `min:"1" type:"string"`

	// The time at which the import token and public key are no longer valid. After
	// this time, you cannot use them to make an ImportKeyMaterial request and you
	// must send another GetParametersForImport request to get new ones.
	ParametersValidTo *time.Time `type:"timestamp"`

	// The public key to use to encrypt the key material before importing it with
	// ImportKeyMaterial.
	//
	// PublicKey is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetParametersForImportOutput's
	// String and GoString methods.
	//
	// PublicKey is automatically base64 encoded/decoded by the SDK.
	PublicKey []byte `min:"1" type:"blob" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetParametersForImportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetParametersForImportOutput) GoString() string {
	return s.String()
}

// SetImportToken sets the ImportToken field's value.
func (s *GetParametersForImportOutput) SetImportToken(v []byte) *GetParametersForImportOutput {
	s.ImportToken = v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *GetParametersForImportOutput) SetKeyId(v string) *GetParametersForImportOutput {
	s.KeyId = &v
	return s
}

// SetParametersValidTo sets the ParametersValidTo field's value.
func (s *GetParametersForImportOutput) SetParametersValidTo(v time.Time) *GetParametersForImportOutput {
	s.ParametersValidTo = &v
	return s
}

// SetPublicKey sets the PublicKey field's value.
func (s *GetParametersForImportOutput) SetPublicKey(v []byte) *GetParametersForImportOutput {
	s.PublicKey = v
	return s
}

type GetPublicKeyInput struct {
	_ struct{} `type:"structure"`

	// A list of grant tokens.
	//
	// Use a grant token when your permission to call this operation comes from
	// a new grant that has not yet achieved eventual consistency. For more information,
	// see Grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
	// and Using a grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
	// in the Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// Identifies the asymmetric KMS key that includes the public key.
	//
	// To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
	// When using an alias name, prefix it with "alias/". To specify a KMS key in
	// a different Amazon Web Services account, you must use the key ARN or alias
	// ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	// To get the alias name and alias ARN, use ListAliases.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPublicKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPublicKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPublicKeyInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrantTokens sets the GrantTokens field's value.
func (s *GetPublicKeyInput) SetGrantTokens(v []*string) *GetPublicKeyInput {
	s.GrantTokens = v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *GetPublicKeyInput) SetKeyId(v string) *GetPublicKeyInput {
	s.KeyId = &v
	return s
}

type GetPublicKeyOutput struct {
	_ struct{} `type:"structure"`

	// Instead, use the KeySpec field in the GetPublicKey response.
	//
	// The KeySpec and CustomerMasterKeySpec fields have the same value. We recommend
	// that you use the KeySpec field in your code. However, to avoid breaking changes,
	// KMS supports both fields.
	//
	// Deprecated: This field has been deprecated. Instead, use the KeySpec field.
	CustomerMasterKeySpec *string `deprecated:"true" type:"string" enum:"CustomerMasterKeySpec"`

	// The encryption algorithms that KMS supports for this key.
	//
	// This information is critical. If a public key encrypts data outside of KMS
	// by using an unsupported encryption algorithm, the ciphertext cannot be decrypted.
	//
	// This field appears in the response only when the KeyUsage of the public key
	// is ENCRYPT_DECRYPT.
	EncryptionAlgorithms []*string `type:"list" enum:"EncryptionAlgorithmSpec"`

	// The Amazon Resource Name (key ARN (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN))
	// of the asymmetric KMS key from which the public key was downloaded.
	KeyId *string `min:"1" type:"string"`

	// The type of the of the public key that was downloaded.
	KeySpec *string `type:"string" enum:"KeySpec"`

	// The permitted use of the public key. Valid values are ENCRYPT_DECRYPT or
	// SIGN_VERIFY.
	//
	// This information is critical. If a public key with SIGN_VERIFY key usage
	// encrypts data outside of KMS, the ciphertext cannot be decrypted.
	KeyUsage *string `type:"string" enum:"KeyUsageType"`

	// The exported public key.
	//
	// The value is a DER-encoded X.509 public key, also known as SubjectPublicKeyInfo
	// (SPKI), as defined in RFC 5280 (https://tools.ietf.org/html/rfc5280). When
	// you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded.
	// Otherwise, it is not Base64-encoded.
	// PublicKey is automatically base64 encoded/decoded by the SDK.
	PublicKey []byte `min:"1" type:"blob"`

	// The signing algorithms that KMS supports for this key.
	//
	// This field appears in the response only when the KeyUsage of the public key
	// is SIGN_VERIFY.
	SigningAlgorithms []*string `type:"list" enum:"SigningAlgorithmSpec"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPublicKeyOutput) GoString() string {
	return s.String()
}

// SetCustomerMasterKeySpec sets the CustomerMasterKeySpec field's value.
func (s *GetPublicKeyOutput) SetCustomerMasterKeySpec(v string) *GetPublicKeyOutput {
	s.CustomerMasterKeySpec = &v
	return s
}

// SetEncryptionAlgorithms sets the EncryptionAlgorithms field's value.
func (s *GetPublicKeyOutput) SetEncryptionAlgorithms(v []*string) *GetPublicKeyOutput {
	s.EncryptionAlgorithms = v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *GetPublicKeyOutput) SetKeyId(v string) *GetPublicKeyOutput {
	s.KeyId = &v
	return s
}

// SetKeySpec sets the KeySpec field's value.
func (s *GetPublicKeyOutput) SetKeySpec(v string) *GetPublicKeyOutput {
	s.KeySpec = &v
	return s
}

// SetKeyUsage sets the KeyUsage field's value.
func (s *GetPublicKeyOutput) SetKeyUsage(v string) *GetPublicKeyOutput {
	s.KeyUsage = &v
	return s
}

// SetPublicKey sets the PublicKey field's value.
func (s *GetPublicKeyOutput) SetPublicKey(v []byte) *GetPublicKeyOutput {
	s.PublicKey = v
	return s
}

// SetSigningAlgorithms sets the SigningAlgorithms field's value.
func (s *GetPublicKeyOutput) SetSigningAlgorithms(v []*string) *GetPublicKeyOutput {
	s.SigningAlgorithms = v
	return s
}

// Use this structure to allow cryptographic operations (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
// in the grant only when the operation request includes the specified encryption
// context (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context).
//
// KMS applies the grant constraints only to cryptographic operations that support
// an encryption context, that is, all cryptographic operations with a symmetric
// KMS key (https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html#symmetric-cmks).
// Grant constraints are not applied to operations that do not support an encryption
// context, such as cryptographic operations with asymmetric KMS keys and management
// operations, such as DescribeKey or RetireGrant.
//
// In a cryptographic operation, the encryption context in the decryption operation
// must be an exact, case-sensitive match for the keys and values in the encryption
// context of the encryption operation. Only the order of the pairs can vary.
//
// However, in a grant constraint, the key in each key-value pair is not case
// sensitive, but the value is case sensitive.
//
// To avoid confusion, do not use multiple encryption context pairs that differ
// only by case. To require a fully case-sensitive encryption context, use the
// kms:EncryptionContext: and kms:EncryptionContextKeys conditions in an IAM
// or key policy. For details, see kms:EncryptionContext: (https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-encryption-context)
// in the Key Management Service Developer Guide .
type GrantConstraints struct {
	_ struct{} `type:"structure"`

	// A list of key-value pairs that must match the encryption context in the cryptographic
	// operation (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
	// request. The grant allows the operation only when the encryption context
	// in the request is the same as the encryption context specified in this constraint.
	EncryptionContextEquals map[string]*string `type:"map"`

	// A list of key-value pairs that must be included in the encryption context
	// of the cryptographic operation (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
	// request. The grant allows the cryptographic operation only when the encryption
	// context in the request includes the key-value pairs specified in this constraint,
	// although it can include additional key-value pairs.
	EncryptionContextSubset map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrantConstraints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrantConstraints) GoString() string {
	return s.String()
}

// SetEncryptionContextEquals sets the EncryptionContextEquals field's value.
func (s *GrantConstraints) SetEncryptionContextEquals(v map[string]*string) *GrantConstraints {
	s.EncryptionContextEquals = v
	return s
}

// SetEncryptionContextSubset sets the EncryptionContextSubset field's value.
func (s *GrantConstraints) SetEncryptionContextSubset(v map[string]*string) *GrantConstraints {
	s.EncryptionContextSubset = v
	return s
}

// Contains information about a grant.
type GrantListEntry struct {
	_ struct{} `type:"structure"`

	// A list of key-value pairs that must be present in the encryption context
	// of certain subsequent operations that the grant allows.
	Constraints *GrantConstraints `type:"structure"`

	// The date and time when the grant was created.
	CreationDate *time.Time `type:"timestamp"`

	// The unique identifier for the grant.
	GrantId *string `min:"1" type:"string"`

	// The identity that gets the permissions in the grant.
	//
	// The GranteePrincipal field in the ListGrants response usually contains the
	// user or role designated as the grantee principal in the grant. However, when
	// the grantee principal in the grant is an Amazon Web Services service, the
	// GranteePrincipal field contains the service principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services),
	// which might represent several different grantee principals.
	GranteePrincipal *string `min:"1" type:"string"`

	// The Amazon Web Services account under which the grant was issued.
	IssuingAccount *string `min:"1" type:"string"`

	// The unique identifier for the KMS key to which the grant applies.
	KeyId *string `min:"1" type:"string"`

	// The friendly name that identifies the grant. If a name was provided in the
	// CreateGrant request, that name is returned. Otherwise this value is null.
	Name *string `min:"1" type:"string"`

	// The list of operations permitted by the grant.
	Operations []*string `type:"list" enum:"GrantOperation"`

	// The principal that can retire the grant.
	RetiringPrincipal *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrantListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrantListEntry) GoString() string {
	return s.String()
}

// SetConstraints sets the Constraints field's value.
func (s *GrantListEntry) SetConstraints(v *GrantConstraints) *GrantListEntry {
	s.Constraints = v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *GrantListEntry) SetCreationDate(v time.Time) *GrantListEntry {
	s.CreationDate = &v
	return s
}

// SetGrantId sets the GrantId field's value.
func (s *GrantListEntry) SetGrantId(v string) *GrantListEntry {
	s.GrantId = &v
	return s
}

// SetGranteePrincipal sets the GranteePrincipal field's value.
func (s *GrantListEntry) SetGranteePrincipal(v string) *GrantListEntry {
	s.GranteePrincipal = &v
	return s
}

// SetIssuingAccount sets the IssuingAccount field's value.
func (s *GrantListEntry) SetIssuingAccount(v string) *GrantListEntry {
	s.IssuingAccount = &v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *GrantListEntry) SetKeyId(v string) *GrantListEntry {
	s.KeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GrantListEntry) SetName(v string) *GrantListEntry {
	s.Name = &v
	return s
}

// SetOperations sets the Operations field's value.
func (s *GrantListEntry) SetOperations(v []*string) *GrantListEntry {
	s.Operations = v
	return s
}

// SetRetiringPrincipal sets the RetiringPrincipal field's value.
func (s *GrantListEntry) SetRetiringPrincipal(v string) *GrantListEntry {
	s.RetiringPrincipal = &v
	return s
}

type ImportKeyMaterialInput struct {
	_ struct{} `type:"structure"`

	// The encrypted key material to import. The key material must be encrypted
	// with the public wrapping key that GetParametersForImport returned, using
	// the wrapping algorithm that you specified in the same GetParametersForImport
	// request.
	// EncryptedKeyMaterial is automatically base64 encoded/decoded by the SDK.
	//
	// EncryptedKeyMaterial is a required field
	EncryptedKeyMaterial []byte `min:"1" type:"blob" required:"true"`

	// Specifies whether the key material expires. The default is KEY_MATERIAL_EXPIRES.
	//
	// When the value of ExpirationModel is KEY_MATERIAL_EXPIRES, you must specify
	// a value for the ValidTo parameter. When value is KEY_MATERIAL_DOES_NOT_EXPIRE,
	// you must omit the ValidTo parameter.
	//
	// You cannot change the ExpirationModel or ValidTo values for the current import
	// after the request completes. To change either value, you must delete (DeleteImportedKeyMaterial)
	// and reimport the key material.
	ExpirationModel *string `type:"string" enum:"ExpirationModelType"`

	// The import token that you received in the response to a previous GetParametersForImport
	// request. It must be from the same response that contained the public key
	// that you used to encrypt the key material.
	// ImportToken is automatically base64 encoded/decoded by the SDK.
	//
	// ImportToken is a required field
	ImportToken []byte `min:"1" type:"blob" required:"true"`

	// The identifier of the symmetric encryption KMS key that receives the imported
	// key material. This must be the same KMS key specified in the KeyID parameter
	// of the corresponding GetParametersForImport request. The Origin of the KMS
	// key must be EXTERNAL. You cannot perform this operation on an asymmetric
	// KMS key, an HMAC KMS key, a KMS key in a custom key store, or on a KMS key
	// in a different Amazon Web Services account
	//
	// Specify the key ID or key ARN of the KMS key.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// The date and time when the imported key material expires. This parameter
	// is required when the value of the ExpirationModel parameter is KEY_MATERIAL_EXPIRES.
	// Otherwise it is not valid.
	//
	// The value of this parameter must be a future date and time. The maximum value
	// is 365 days from the request date.
	//
	// When the key material expires, KMS deletes the key material from the KMS
	// key. Without its key material, the KMS key is unusable. To use the KMS key
	// in cryptographic operations, you must reimport the same key material.
	//
	// You cannot change the ExpirationModel or ValidTo values for the current import
	// after the request completes. To change either value, you must delete (DeleteImportedKeyMaterial)
	// and reimport the key material.
	ValidTo *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportKeyMaterialInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportKeyMaterialInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportKeyMaterialInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportKeyMaterialInput"}
	if s.EncryptedKeyMaterial == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptedKeyMaterial"))
	}
	if s.EncryptedKeyMaterial != nil && len(s.EncryptedKeyMaterial) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EncryptedKeyMaterial", 1))
	}
	if s.ImportToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ImportToken"))
	}
	if s.ImportToken != nil && len(s.ImportToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImportToken", 1))
	}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptedKeyMaterial sets the EncryptedKeyMaterial field's value.
func (s *ImportKeyMaterialInput) SetEncryptedKeyMaterial(v []byte) *ImportKeyMaterialInput {
	s.EncryptedKeyMaterial = v
	return s
}

// SetExpirationModel sets the ExpirationModel field's value.
func (s *ImportKeyMaterialInput) SetExpirationModel(v string) *ImportKeyMaterialInput {
	s.ExpirationModel = &v
	return s
}

// SetImportToken sets the ImportToken field's value.
func (s *ImportKeyMaterialInput) SetImportToken(v []byte) *ImportKeyMaterialInput {
	s.ImportToken = v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *ImportKeyMaterialInput) SetKeyId(v string) *ImportKeyMaterialInput {
	s.KeyId = &v
	return s
}

// SetValidTo sets the ValidTo field's value.
func (s *ImportKeyMaterialInput) SetValidTo(v time.Time) *ImportKeyMaterialInput {
	s.ValidTo = &v
	return s
}

type ImportKeyMaterialOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportKeyMaterialOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportKeyMaterialOutput) GoString() string {
	return s.String()
}

// The request was rejected because the specified KMS key cannot decrypt the
// data. The KeyId in a Decrypt request and the SourceKeyId in a ReEncrypt request
// must identify the same KMS key that was used to encrypt the ciphertext.
type IncorrectKeyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncorrectKeyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncorrectKeyException) GoString() string {
	return s.String()
}

func newErrorIncorrectKeyException(v protocol.ResponseMetadata) error {
	return &IncorrectKeyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *IncorrectKeyException) Code() string {
	return "IncorrectKeyException"
}

// Message returns the exception's message.
func (s *IncorrectKeyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *IncorrectKeyException) OrigErr() error {
	return nil
}

func (s *IncorrectKeyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *IncorrectKeyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *IncorrectKeyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because the key material in the request is, expired,
// invalid, or is not the same key material that was previously imported into
// this KMS key.
type IncorrectKeyMaterialException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncorrectKeyMaterialException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncorrectKeyMaterialException) GoString() string {
	return s.String()
}

func newErrorIncorrectKeyMaterialException(v protocol.ResponseMetadata) error {
	return &IncorrectKeyMaterialException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *IncorrectKeyMaterialException) Code() string {
	return "IncorrectKeyMaterialException"
}

// Message returns the exception's message.
func (s *IncorrectKeyMaterialException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *IncorrectKeyMaterialException) OrigErr() error {
	return nil
}

func (s *IncorrectKeyMaterialException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *IncorrectKeyMaterialException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *IncorrectKeyMaterialException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because the trust anchor certificate in the request
// to create an CloudHSM key store is not the trust anchor certificate for the
// specified CloudHSM cluster.
//
// When you initialize the CloudHSM cluster (https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html#sign-csr),
// you create the trust anchor certificate and save it in the customerCA.crt
// file.
type IncorrectTrustAnchorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncorrectTrustAnchorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncorrectTrustAnchorException) GoString() string {
	return s.String()
}

func newErrorIncorrectTrustAnchorException(v protocol.ResponseMetadata) error {
	return &IncorrectTrustAnchorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *IncorrectTrustAnchorException) Code() string {
	return "IncorrectTrustAnchorException"
}

// Message returns the exception's message.
func (s *IncorrectTrustAnchorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *IncorrectTrustAnchorException) OrigErr() error {
	return nil
}

func (s *IncorrectTrustAnchorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *IncorrectTrustAnchorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *IncorrectTrustAnchorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because an internal exception occurred. The request
// can be retried.
type InternalException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalException) GoString() string {
	return s.String()
}

func newErrorInternalException(v protocol.ResponseMetadata) error {
	return &InternalException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalException) Code() string {
	return "KMSInternalException"
}

// Message returns the exception's message.
func (s *InternalException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalException) OrigErr() error {
	return nil
}

func (s *InternalException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because the specified alias name is not valid.
type InvalidAliasNameException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidAliasNameException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidAliasNameException) GoString() string {
	return s.String()
}

func newErrorInvalidAliasNameException(v protocol.ResponseMetadata) error {
	return &InvalidAliasNameException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidAliasNameException) Code() string {
	return "InvalidAliasNameException"
}

// Message returns the exception's message.
func (s *InvalidAliasNameException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidAliasNameException) OrigErr() error {
	return nil
}

func (s *InvalidAliasNameException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidAliasNameException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidAliasNameException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because a specified ARN, or an ARN in a key policy,
// is not valid.
type InvalidArnException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidArnException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidArnException) GoString() string {
	return s.String()
}

func newErrorInvalidArnException(v protocol.ResponseMetadata) error {
	return &InvalidArnException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidArnException) Code() string {
	return "InvalidArnException"
}

// Message returns the exception's message.
func (s *InvalidArnException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidArnException) OrigErr() error {
	return nil
}

func (s *InvalidArnException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidArnException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidArnException) RequestID() string {
	return s.RespMetadata.RequestID
}

// From the Decrypt or ReEncrypt operation, the request was rejected because
// the specified ciphertext, or additional authenticated data incorporated into
// the ciphertext, such as the encryption context, is corrupted, missing, or
// otherwise invalid.
//
// From the ImportKeyMaterial operation, the request was rejected because KMS
// could not decrypt the encrypted (wrapped) key material.
type InvalidCiphertextException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidCiphertextException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidCiphertextException) GoString() string {
	return s.String()
}

func newErrorInvalidCiphertextException(v protocol.ResponseMetadata) error {
	return &InvalidCiphertextException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidCiphertextException) Code() string {
	return "InvalidCiphertextException"
}

// Message returns the exception's message.
func (s *InvalidCiphertextException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidCiphertextException) OrigErr() error {
	return nil
}

func (s *InvalidCiphertextException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidCiphertextException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidCiphertextException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because the specified GrantId is not valid.
type InvalidGrantIdException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidGrantIdException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidGrantIdException) GoString() string {
	return s.String()
}

func newErrorInvalidGrantIdException(v protocol.ResponseMetadata) error {
	return &InvalidGrantIdException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidGrantIdException) Code() string {
	return "InvalidGrantIdException"
}

// Message returns the exception's message.
func (s *InvalidGrantIdException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidGrantIdException) OrigErr() error {
	return nil
}

func (s *InvalidGrantIdException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidGrantIdException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidGrantIdException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because the specified grant token is not valid.
type InvalidGrantTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidGrantTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidGrantTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidGrantTokenException(v protocol.ResponseMetadata) error {
	return &InvalidGrantTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidGrantTokenException) Code() string {
	return "InvalidGrantTokenException"
}

// Message returns the exception's message.
func (s *InvalidGrantTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidGrantTokenException) OrigErr() error {
	return nil
}

func (s *InvalidGrantTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidGrantTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidGrantTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because the provided import token is invalid or
// is associated with a different KMS key.
type InvalidImportTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidImportTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidImportTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidImportTokenException(v protocol.ResponseMetadata) error {
	return &InvalidImportTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidImportTokenException) Code() string {
	return "InvalidImportTokenException"
}

// Message returns the exception's message.
func (s *InvalidImportTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidImportTokenException) OrigErr() error {
	return nil
}

func (s *InvalidImportTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidImportTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidImportTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected for one of the following reasons:
//
//   - The KeyUsage value of the KMS key is incompatible with the API operation.
//
//   - The encryption algorithm or signing algorithm specified for the operation
//     is incompatible with the type of key material in the KMS key (KeySpec).
//
// For encrypting, decrypting, re-encrypting, and generating data keys, the
// KeyUsage must be ENCRYPT_DECRYPT. For signing and verifying messages, the
// KeyUsage must be SIGN_VERIFY. For generating and verifying message authentication
// codes (MACs), the KeyUsage must be GENERATE_VERIFY_MAC. To find the KeyUsage
// of a KMS key, use the DescribeKey operation.
//
// To find the encryption or signing algorithms supported for a particular KMS
// key, use the DescribeKey operation.
type InvalidKeyUsageException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidKeyUsageException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidKeyUsageException) GoString() string {
	return s.String()
}

func newErrorInvalidKeyUsageException(v protocol.ResponseMetadata) error {
	return &InvalidKeyUsageException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidKeyUsageException) Code() string {
	return "InvalidKeyUsageException"
}

// Message returns the exception's message.
func (s *InvalidKeyUsageException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidKeyUsageException) OrigErr() error {
	return nil
}

func (s *InvalidKeyUsageException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidKeyUsageException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidKeyUsageException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because the marker that specifies where pagination
// should next begin is not valid.
type InvalidMarkerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidMarkerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidMarkerException) GoString() string {
	return s.String()
}

func newErrorInvalidMarkerException(v protocol.ResponseMetadata) error {
	return &InvalidMarkerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidMarkerException) Code() string {
	return "InvalidMarkerException"
}

// Message returns the exception's message.
func (s *InvalidMarkerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidMarkerException) OrigErr() error {
	return nil
}

func (s *InvalidMarkerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidMarkerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidMarkerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because the state of the specified resource is not
// valid for this request.
//
// This exceptions means one of the following:
//
//   - The key state of the KMS key is not compatible with the operation. To
//     find the key state, use the DescribeKey operation. For more information
//     about which key states are compatible with each KMS operation, see Key
//     states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Key Management Service Developer Guide .
//
//   - For cryptographic operations on KMS keys in custom key stores, this
//     exception represents a general failure with many possible causes. To identify
//     the cause, see the error message that accompanies the exception.
type InvalidStateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidStateException) GoString() string {
	return s.String()
}

func newErrorInvalidStateException(v protocol.ResponseMetadata) error {
	return &InvalidStateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidStateException) Code() string {
	return "KMSInvalidStateException"
}

// Message returns the exception's message.
func (s *InvalidStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidStateException) OrigErr() error {
	return nil
}

func (s *InvalidStateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidStateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidStateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because the HMAC verification failed. HMAC verification
// fails when the HMAC computed by using the specified message, HMAC KMS key,
// and MAC algorithm does not match the HMAC specified in the request.
type KMSInvalidMacException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSInvalidMacException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSInvalidMacException) GoString() string {
	return s.String()
}

func newErrorKMSInvalidMacException(v protocol.ResponseMetadata) error {
	return &KMSInvalidMacException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSInvalidMacException) Code() string {
	return "KMSInvalidMacException"
}

// Message returns the exception's message.
func (s *KMSInvalidMacException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSInvalidMacException) OrigErr() error {
	return nil
}

func (s *KMSInvalidMacException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSInvalidMacException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSInvalidMacException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because the signature verification failed. Signature
// verification fails when it cannot confirm that signature was produced by
// signing the specified message with the specified KMS key and signing algorithm.
type KMSInvalidSignatureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSInvalidSignatureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSInvalidSignatureException) GoString() string {
	return s.String()
}

func newErrorKMSInvalidSignatureException(v protocol.ResponseMetadata) error {
	return &KMSInvalidSignatureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSInvalidSignatureException) Code() string {
	return "KMSInvalidSignatureException"
}

// Message returns the exception's message.
func (s *KMSInvalidSignatureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSInvalidSignatureException) OrigErr() error {
	return nil
}

func (s *KMSInvalidSignatureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSInvalidSignatureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSInvalidSignatureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about each entry in the key list.
type KeyListEntry struct {
	_ struct{} `type:"structure"`

	// ARN of the key.
	KeyArn *string `min:"20" type:"string"`

	// Unique identifier of the key.
	KeyId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyListEntry) GoString() string {
	return s.String()
}

// SetKeyArn sets the KeyArn field's value.
func (s *KeyListEntry) SetKeyArn(v string) *KeyListEntry {
	s.KeyArn = &v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *KeyListEntry) SetKeyId(v string) *KeyListEntry {
	s.KeyId = &v
	return s
}

// Contains metadata about a KMS key.
//
// This data type is used as a response element for the CreateKey, DescribeKey,
// and ReplicateKey operations.
type KeyMetadata struct {
	_ struct{} `type:"structure"`

	// The twelve-digit account ID of the Amazon Web Services account that owns
	// the KMS key.
	AWSAccountId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the KMS key. For examples, see Key Management
	// Service (KMS) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms)
	// in the Example ARNs section of the Amazon Web Services General Reference.
	Arn *string `min:"20" type:"string"`

	// The cluster ID of the CloudHSM cluster that contains the key material for
	// the KMS key. When you create a KMS key in an CloudHSM custom key store (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html),
	// KMS creates the key material for the KMS key in the associated CloudHSM cluster.
	// This field is present only when the KMS key is created in an CloudHSM key
	// store.
	CloudHsmClusterId *string `min:"19" type:"string"`

	// The date and time when the KMS key was created.
	CreationDate *time.Time `type:"timestamp"`

	// A unique identifier for the custom key store (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
	// that contains the KMS key. This field is present only when the KMS key is
	// created in a custom key store.
	CustomKeyStoreId *string `min:"1" type:"string"`

	// Instead, use the KeySpec field.
	//
	// The KeySpec and CustomerMasterKeySpec fields have the same value. We recommend
	// that you use the KeySpec field in your code. However, to avoid breaking changes,
	// KMS supports both fields.
	//
	// Deprecated: This field has been deprecated. Instead, use the KeySpec field.
	CustomerMasterKeySpec *string `deprecated:"true" type:"string" enum:"CustomerMasterKeySpec"`

	// The date and time after which KMS deletes this KMS key. This value is present
	// only when the KMS key is scheduled for deletion, that is, when its KeyState
	// is PendingDeletion.
	//
	// When the primary key in a multi-Region key is scheduled for deletion but
	// still has replica keys, its key state is PendingReplicaDeletion and the length
	// of its waiting period is displayed in the PendingDeletionWindowInDays field.
	DeletionDate *time.Time `type:"timestamp"`

	// The description of the KMS key.
	Description *string `type:"string"`

	// Specifies whether the KMS key is enabled. When KeyState is Enabled this value
	// is true, otherwise it is false.
	Enabled *bool `type:"boolean"`

	// The encryption algorithms that the KMS key supports. You cannot use the KMS
	// key with other encryption algorithms within KMS.
	//
	// This value is present only when the KeyUsage of the KMS key is ENCRYPT_DECRYPT.
	EncryptionAlgorithms []*string `type:"list" enum:"EncryptionAlgorithmSpec"`

	// Specifies whether the KMS key's key material expires. This value is present
	// only when Origin is EXTERNAL, otherwise this value is omitted.
	ExpirationModel *string `type:"string" enum:"ExpirationModelType"`

	// The globally unique identifier for the KMS key.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// The manager of the KMS key. KMS keys in your Amazon Web Services account
	// are either customer managed or Amazon Web Services managed. For more information
	// about the difference, see KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms_keys)
	// in the Key Management Service Developer Guide.
	KeyManager *string `type:"string" enum:"KeyManagerType"`

	// Describes the type of key material in the KMS key.
	KeySpec *string `type:"string" enum:"KeySpec"`

	// The current status of the KMS key.
	//
	// For more information about how key state affects the use of a KMS key, see
	// Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
	// in the Key Management Service Developer Guide.
	KeyState *string `type:"string" enum:"KeyState"`

	// The cryptographic operations (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
	// for which you can use the KMS key.
	KeyUsage *string `type:"string" enum:"KeyUsageType"`

	// The message authentication code (MAC) algorithm that the HMAC KMS key supports.
	//
	// This value is present only when the KeyUsage of the KMS key is GENERATE_VERIFY_MAC.
	MacAlgorithms []*string `type:"list" enum:"MacAlgorithmSpec"`

	// Indicates whether the KMS key is a multi-Region (True) or regional (False)
	// key. This value is True for multi-Region primary and replica keys and False
	// for regional KMS keys.
	//
	// For more information about multi-Region keys, see Multi-Region keys in KMS
	// (https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html)
	// in the Key Management Service Developer Guide.
	MultiRegion *bool `type:"boolean"`

	// Lists the primary and replica keys in same multi-Region key. This field is
	// present only when the value of the MultiRegion field is True.
	//
	// For more information about any listed KMS key, use the DescribeKey operation.
	//
	//    * MultiRegionKeyType indicates whether the KMS key is a PRIMARY or REPLICA
	//    key.
	//
	//    * PrimaryKey displays the key ARN and Region of the primary key. This
	//    field displays the current KMS key if it is the primary key.
	//
	//    * ReplicaKeys displays the key ARNs and Regions of all replica keys. This
	//    field includes the current KMS key if it is a replica key.
	MultiRegionConfiguration *MultiRegionConfiguration `type:"structure"`

	// The source of the key material for the KMS key. When this value is AWS_KMS,
	// KMS created the key material. When this value is EXTERNAL, the key material
	// was imported or the KMS key doesn't have any key material. When this value
	// is AWS_CLOUDHSM, the key material was created in the CloudHSM cluster associated
	// with a custom key store.
	Origin *string `type:"string" enum:"OriginType"`

	// The waiting period before the primary key in a multi-Region key is deleted.
	// This waiting period begins when the last of its replica keys is deleted.
	// This value is present only when the KeyState of the KMS key is PendingReplicaDeletion.
	// That indicates that the KMS key is the primary key in a multi-Region key,
	// it is scheduled for deletion, and it still has existing replica keys.
	//
	// When a single-Region KMS key or a multi-Region replica key is scheduled for
	// deletion, its deletion date is displayed in the DeletionDate field. However,
	// when the primary key in a multi-Region key is scheduled for deletion, its
	// waiting period doesn't begin until all of its replica keys are deleted. This
	// value displays that waiting period. When the last replica key in the multi-Region
	// key is deleted, the KeyState of the scheduled primary key changes from PendingReplicaDeletion
	// to PendingDeletion and the deletion date appears in the DeletionDate field.
	PendingDeletionWindowInDays *int64 `min:"1" type:"integer"`

	// The signing algorithms that the KMS key supports. You cannot use the KMS
	// key with other signing algorithms within KMS.
	//
	// This field appears only when the KeyUsage of the KMS key is SIGN_VERIFY.
	SigningAlgorithms []*string `type:"list" enum:"SigningAlgorithmSpec"`

	// The time at which the imported key material expires. When the key material
	// expires, KMS deletes the key material and the KMS key becomes unusable. This
	// value is present only for KMS keys whose Origin is EXTERNAL and whose ExpirationModel
	// is KEY_MATERIAL_EXPIRES, otherwise this value is omitted.
	ValidTo *time.Time `type:"timestamp"`

	// Information about the external key that is associated with a KMS key in an
	// external key store.
	//
	// For more information, see External key (https://docs.aws.amazon.com/kms/latest/developerguide/keystore-external.html#concept-external-key)
	// in the Key Management Service Developer Guide.
	XksKeyConfiguration *XksKeyConfigurationType `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyMetadata) GoString() string {
	return s.String()
}

// SetAWSAccountId sets the AWSAccountId field's value.
func (s *KeyMetadata) SetAWSAccountId(v string) *KeyMetadata {
	s.AWSAccountId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *KeyMetadata) SetArn(v string) *KeyMetadata {
	s.Arn = &v
	return s
}

// SetCloudHsmClusterId sets the CloudHsmClusterId field's value.
func (s *KeyMetadata) SetCloudHsmClusterId(v string) *KeyMetadata {
	s.CloudHsmClusterId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *KeyMetadata) SetCreationDate(v time.Time) *KeyMetadata {
	s.CreationDate = &v
	return s
}

// SetCustomKeyStoreId sets the CustomKeyStoreId field's value.
func (s *KeyMetadata) SetCustomKeyStoreId(v string) *KeyMetadata {
	s.CustomKeyStoreId = &v
	return s
}

// SetCustomerMasterKeySpec sets the CustomerMasterKeySpec field's value.
func (s *KeyMetadata) SetCustomerMasterKeySpec(v string) *KeyMetadata {
	s.CustomerMasterKeySpec = &v
	return s
}

// SetDeletionDate sets the DeletionDate field's value.
func (s *KeyMetadata) SetDeletionDate(v time.Time) *KeyMetadata {
	s.DeletionDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *KeyMetadata) SetDescription(v string) *KeyMetadata {
	s.Description = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *KeyMetadata) SetEnabled(v bool) *KeyMetadata {
	s.Enabled = &v
	return s
}

// SetEncryptionAlgorithms sets the EncryptionAlgorithms field's value.
func (s *KeyMetadata) SetEncryptionAlgorithms(v []*string) *KeyMetadata {
	s.EncryptionAlgorithms = v
	return s
}

// SetExpirationModel sets the ExpirationModel field's value.
func (s *KeyMetadata) SetExpirationModel(v string) *KeyMetadata {
	s.ExpirationModel = &v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *KeyMetadata) SetKeyId(v string) *KeyMetadata {
	s.KeyId = &v
	return s
}

// SetKeyManager sets the KeyManager field's value.
func (s *KeyMetadata) SetKeyManager(v string) *KeyMetadata {
	s.KeyManager = &v
	return s
}

// SetKeySpec sets the KeySpec field's value.
func (s *KeyMetadata) SetKeySpec(v string) *KeyMetadata {
	s.KeySpec = &v
	return s
}

// SetKeyState sets the KeyState field's value.
func (s *KeyMetadata) SetKeyState(v string) *KeyMetadata {
	s.KeyState = &v
	return s
}

// SetKeyUsage sets the KeyUsage field's value.
func (s *KeyMetadata) SetKeyUsage(v string) *KeyMetadata {
	s.KeyUsage = &v
	return s
}

// SetMacAlgorithms sets the MacAlgorithms field's value.
func (s *KeyMetadata) SetMacAlgorithms(v []*string) *KeyMetadata {
	s.MacAlgorithms = v
	return s
}

// SetMultiRegion sets the MultiRegion field's value.
func (s *KeyMetadata) SetMultiRegion(v bool) *KeyMetadata {
	s.MultiRegion = &v
	return s
}

// SetMultiRegionConfiguration sets the MultiRegionConfiguration field's value.
func (s *KeyMetadata) SetMultiRegionConfiguration(v *MultiRegionConfiguration) *KeyMetadata {
	s.MultiRegionConfiguration = v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *KeyMetadata) SetOrigin(v string) *KeyMetadata {
	s.Origin = &v
	return s
}

// SetPendingDeletionWindowInDays sets the PendingDeletionWindowInDays field's value.
func (s *KeyMetadata) SetPendingDeletionWindowInDays(v int64) *KeyMetadata {
	s.PendingDeletionWindowInDays = &v
	return s
}

// SetSigningAlgorithms sets the SigningAlgorithms field's value.
func (s *KeyMetadata) SetSigningAlgorithms(v []*string) *KeyMetadata {
	s.SigningAlgorithms = v
	return s
}

// SetValidTo sets the ValidTo field's value.
func (s *KeyMetadata) SetValidTo(v time.Time) *KeyMetadata {
	s.ValidTo = &v
	return s
}

// SetXksKeyConfiguration sets the XksKeyConfiguration field's value.
func (s *KeyMetadata) SetXksKeyConfiguration(v *XksKeyConfigurationType) *KeyMetadata {
	s.XksKeyConfiguration = v
	return s
}

// The request was rejected because the specified KMS key was not available.
// You can retry the request.
type KeyUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyUnavailableException) GoString() string {
	return s.String()
}

func newErrorKeyUnavailableException(v protocol.ResponseMetadata) error {
	return &KeyUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KeyUnavailableException) Code() string {
	return "KeyUnavailableException"
}

// Message returns the exception's message.
func (s *KeyUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KeyUnavailableException) OrigErr() error {
	return nil
}

func (s *KeyUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KeyUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KeyUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because a quota was exceeded. For more information,
// see Quotas (https://docs.aws.amazon.com/kms/latest/developerguide/limits.html)
// in the Key Management Service Developer Guide.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAliasesInput struct {
	_ struct{} `type:"structure"`

	// Lists only aliases that are associated with the specified KMS key. Enter
	// a KMS key in your Amazon Web Services account.
	//
	// This parameter is optional. If you omit it, ListAliases returns all aliases
	// in the account and Region.
	//
	// Specify the key ID or key ARN of the KMS key.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	KeyId *string `min:"1" type:"string"`

	// Use this parameter to specify the maximum number of items to return. When
	// this value is present, KMS does not return more than the specified number
	// of items, but it might return fewer.
	//
	// This value is optional. If you include a value, it must be between 1 and
	// 100, inclusive. If you do not include a value, it defaults to 50.
	Limit *int64 `min:"1" type:"integer"`

	// Use this parameter in a subsequent request after you receive a response with
	// truncated results. Set it to the value of NextMarker from the truncated response
	// you just received.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAliasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAliasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAliasesInput"}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyId sets the KeyId field's value.
func (s *ListAliasesInput) SetKeyId(v string) *ListAliasesInput {
	s.KeyId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListAliasesInput) SetLimit(v int64) *ListAliasesInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListAliasesInput) SetMarker(v string) *ListAliasesInput {
	s.Marker = &v
	return s
}

type ListAliasesOutput struct {
	_ struct{} `type:"structure"`

	// A list of aliases.
	Aliases []*AliasListEntry `type:"list"`

	// When Truncated is true, this element is present and contains the value to
	// use for the Marker parameter in a subsequent request.
	NextMarker *string `min:"1" type:"string"`

	// A flag that indicates whether there are more items in the list. When this
	// value is true, the list in this response is truncated. To get more items,
	// pass the value of the NextMarker element in thisresponse to the Marker parameter
	// in a subsequent request.
	Truncated *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAliasesOutput) GoString() string {
	return s.String()
}

// SetAliases sets the Aliases field's value.
func (s *ListAliasesOutput) SetAliases(v []*AliasListEntry) *ListAliasesOutput {
	s.Aliases = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListAliasesOutput) SetNextMarker(v string) *ListAliasesOutput {
	s.NextMarker = &v
	return s
}

// SetTruncated sets the Truncated field's value.
func (s *ListAliasesOutput) SetTruncated(v bool) *ListAliasesOutput {
	s.Truncated = &v
	return s
}

type ListGrantsInput struct {
	_ struct{} `type:"structure"`

	// Returns only the grant with the specified grant ID. The grant ID uniquely
	// identifies the grant.
	GrantId *string `min:"1" type:"string"`

	// Returns only grants where the specified principal is the grantee principal
	// for the grant.
	GranteePrincipal *string `min:"1" type:"string"`

	// Returns only grants for the specified KMS key. This parameter is required.
	//
	// Specify the key ID or key ARN of the KMS key. To specify a KMS key in a different
	// Amazon Web Services account, you must use the key ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// Use this parameter to specify the maximum number of items to return. When
	// this value is present, KMS does not return more than the specified number
	// of items, but it might return fewer.
	//
	// This value is optional. If you include a value, it must be between 1 and
	// 100, inclusive. If you do not include a value, it defaults to 50.
	Limit *int64 `min:"1" type:"integer"`

	// Use this parameter in a subsequent request after you receive a response with
	// truncated results. Set it to the value of NextMarker from the truncated response
	// you just received.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGrantsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGrantsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGrantsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGrantsInput"}
	if s.GrantId != nil && len(*s.GrantId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GrantId", 1))
	}
	if s.GranteePrincipal != nil && len(*s.GranteePrincipal) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GranteePrincipal", 1))
	}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrantId sets the GrantId field's value.
func (s *ListGrantsInput) SetGrantId(v string) *ListGrantsInput {
	s.GrantId = &v
	return s
}

// SetGranteePrincipal sets the GranteePrincipal field's value.
func (s *ListGrantsInput) SetGranteePrincipal(v string) *ListGrantsInput {
	s.GranteePrincipal = &v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *ListGrantsInput) SetKeyId(v string) *ListGrantsInput {
	s.KeyId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListGrantsInput) SetLimit(v int64) *ListGrantsInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListGrantsInput) SetMarker(v string) *ListGrantsInput {
	s.Marker = &v
	return s
}

type ListGrantsResponse struct {
	_ struct{} `type:"structure"`

	// A list of grants.
	Grants []*GrantListEntry `type:"list"`

	// When Truncated is true, this element is present and contains the value to
	// use for the Marker parameter in a subsequent request.
	NextMarker *string `min:"1" type:"string"`

	// A flag that indicates whether there are more items in the list. When this
	// value is true, the list in this response is truncated. To get more items,
	// pass the value of the NextMarker element in thisresponse to the Marker parameter
	// in a subsequent request.
	Truncated *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGrantsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGrantsResponse) GoString() string {
	return s.String()
}

// SetGrants sets the Grants field's value.
func (s *ListGrantsResponse) SetGrants(v []*GrantListEntry) *ListGrantsResponse {
	s.Grants = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListGrantsResponse) SetNextMarker(v string) *ListGrantsResponse {
	s.NextMarker = &v
	return s
}

// SetTruncated sets the Truncated field's value.
func (s *ListGrantsResponse) SetTruncated(v bool) *ListGrantsResponse {
	s.Truncated = &v
	return s
}

type ListKeyPoliciesInput struct {
	_ struct{} `type:"structure"`

	// Gets the names of key policies for the specified KMS key.
	//
	// Specify the key ID or key ARN of the KMS key.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// Use this parameter to specify the maximum number of items to return. When
	// this value is present, KMS does not return more than the specified number
	// of items, but it might return fewer.
	//
	// This value is optional. If you include a value, it must be between 1 and
	// 1000, inclusive. If you do not include a value, it defaults to 100.
	//
	// Only one policy can be attached to a key.
	Limit *int64 `min:"1" type:"integer"`

	// Use this parameter in a subsequent request after you receive a response with
	// truncated results. Set it to the value of NextMarker from the truncated response
	// you just received.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeyPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeyPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKeyPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKeyPoliciesInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyId sets the KeyId field's value.
func (s *ListKeyPoliciesInput) SetKeyId(v string) *ListKeyPoliciesInput {
	s.KeyId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListKeyPoliciesInput) SetLimit(v int64) *ListKeyPoliciesInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListKeyPoliciesInput) SetMarker(v string) *ListKeyPoliciesInput {
	s.Marker = &v
	return s
}

type ListKeyPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// When Truncated is true, this element is present and contains the value to
	// use for the Marker parameter in a subsequent request.
	NextMarker *string `min:"1" type:"string"`

	// A list of key policy names. The only valid value is default.
	PolicyNames []*string `type:"list"`

	// A flag that indicates whether there are more items in the list. When this
	// value is true, the list in this response is truncated. To get more items,
	// pass the value of the NextMarker element in thisresponse to the Marker parameter
	// in a subsequent request.
	Truncated *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeyPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeyPoliciesOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListKeyPoliciesOutput) SetNextMarker(v string) *ListKeyPoliciesOutput {
	s.NextMarker = &v
	return s
}

// SetPolicyNames sets the PolicyNames field's value.
func (s *ListKeyPoliciesOutput) SetPolicyNames(v []*string) *ListKeyPoliciesOutput {
	s.PolicyNames = v
	return s
}

// SetTruncated sets the Truncated field's value.
func (s *ListKeyPoliciesOutput) SetTruncated(v bool) *ListKeyPoliciesOutput {
	s.Truncated = &v
	return s
}

type ListKeysInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter to specify the maximum number of items to return. When
	// this value is present, KMS does not return more than the specified number
	// of items, but it might return fewer.
	//
	// This value is optional. If you include a value, it must be between 1 and
	// 1000, inclusive. If you do not include a value, it defaults to 100.
	Limit *int64 `min:"1" type:"integer"`

	// Use this parameter in a subsequent request after you receive a response with
	// truncated results. Set it to the value of NextMarker from the truncated response
	// you just received.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKeysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKeysInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListKeysInput) SetLimit(v int64) *ListKeysInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListKeysInput) SetMarker(v string) *ListKeysInput {
	s.Marker = &v
	return s
}

type ListKeysOutput struct {
	_ struct{} `type:"structure"`

	// A list of KMS keys.
	Keys []*KeyListEntry `type:"list"`

	// When Truncated is true, this element is present and contains the value to
	// use for the Marker parameter in a subsequent request.
	NextMarker *string `min:"1" type:"string"`

	// A flag that indicates whether there are more items in the list. When this
	// value is true, the list in this response is truncated. To get more items,
	// pass the value of the NextMarker element in thisresponse to the Marker parameter
	// in a subsequent request.
	Truncated *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeysOutput) GoString() string {
	return s.String()
}

// SetKeys sets the Keys field's value.
func (s *ListKeysOutput) SetKeys(v []*KeyListEntry) *ListKeysOutput {
	s.Keys = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListKeysOutput) SetNextMarker(v string) *ListKeysOutput {
	s.NextMarker = &v
	return s
}

// SetTruncated sets the Truncated field's value.
func (s *ListKeysOutput) SetTruncated(v bool) *ListKeysOutput {
	s.Truncated = &v
	return s
}

type ListResourceTagsInput struct {
	_ struct{} `type:"structure"`

	// Gets tags on the specified KMS key.
	//
	// Specify the key ID or key ARN of the KMS key.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// Use this parameter to specify the maximum number of items to return. When
	// this value is present, KMS does not return more than the specified number
	// of items, but it might return fewer.
	//
	// This value is optional. If you include a value, it must be between 1 and
	// 50, inclusive. If you do not include a value, it defaults to 50.
	Limit *int64 `min:"1" type:"integer"`

	// Use this parameter in a subsequent request after you receive a response with
	// truncated results. Set it to the value of NextMarker from the truncated response
	// you just received.
	//
	// Do not attempt to construct this value. Use only the value of NextMarker
	// from the truncated response you just received.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourceTagsInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyId sets the KeyId field's value.
func (s *ListResourceTagsInput) SetKeyId(v string) *ListResourceTagsInput {
	s.KeyId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListResourceTagsInput) SetLimit(v int64) *ListResourceTagsInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListResourceTagsInput) SetMarker(v string) *ListResourceTagsInput {
	s.Marker = &v
	return s
}

type ListResourceTagsOutput struct {
	_ struct{} `type:"structure"`

	// When Truncated is true, this element is present and contains the value to
	// use for the Marker parameter in a subsequent request.
	//
	// Do not assume or infer any information from this value.
	NextMarker *string `min:"1" type:"string"`

	// A list of tags. Each tag consists of a tag key and a tag value.
	//
	// Tagging or untagging a KMS key can allow or deny permission to the KMS key.
	// For details, see ABAC for KMS (https://docs.aws.amazon.com/kms/latest/developerguide/abac.html)
	// in the Key Management Service Developer Guide.
	Tags []*Tag `type:"list"`

	// A flag that indicates whether there are more items in the list. When this
	// value is true, the list in this response is truncated. To get more items,
	// pass the value of the NextMarker element in thisresponse to the Marker parameter
	// in a subsequent request.
	Truncated *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceTagsOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListResourceTagsOutput) SetNextMarker(v string) *ListResourceTagsOutput {
	s.NextMarker = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListResourceTagsOutput) SetTags(v []*Tag) *ListResourceTagsOutput {
	s.Tags = v
	return s
}

// SetTruncated sets the Truncated field's value.
func (s *ListResourceTagsOutput) SetTruncated(v bool) *ListResourceTagsOutput {
	s.Truncated = &v
	return s
}

type ListRetirableGrantsInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter to specify the maximum number of items to return. When
	// this value is present, KMS does not return more than the specified number
	// of items, but it might return fewer.
	//
	// This value is optional. If you include a value, it must be between 1 and
	// 100, inclusive. If you do not include a value, it defaults to 50.
	Limit *int64 `min:"1" type:"integer"`

	// Use this parameter in a subsequent request after you receive a response with
	// truncated results. Set it to the value of NextMarker from the truncated response
	// you just received.
	Marker *string `min:"1" type:"string"`

	// The retiring principal for which to list grants. Enter a principal in your
	// Amazon Web Services account.
	//
	// To specify the retiring principal, use the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of an Amazon Web Services principal. Valid Amazon Web Services principals
	// include Amazon Web Services accounts (root), IAM users, federated users,
	// and assumed role users. For examples of the ARN syntax for specifying a principal,
	// see Amazon Web Services Identity and Access Management (IAM) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam)
	// in the Example ARNs section of the Amazon Web Services General Reference.
	//
	// RetiringPrincipal is a required field
	RetiringPrincipal *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRetirableGrantsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRetirableGrantsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRetirableGrantsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRetirableGrantsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.RetiringPrincipal == nil {
		invalidParams.Add(request.NewErrParamRequired("RetiringPrincipal"))
	}
	if s.RetiringPrincipal != nil && len(*s.RetiringPrincipal) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RetiringPrincipal", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListRetirableGrantsInput) SetLimit(v int64) *ListRetirableGrantsInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListRetirableGrantsInput) SetMarker(v string) *ListRetirableGrantsInput {
	s.Marker = &v
	return s
}

// SetRetiringPrincipal sets the RetiringPrincipal field's value.
func (s *ListRetirableGrantsInput) SetRetiringPrincipal(v string) *ListRetirableGrantsInput {
	s.RetiringPrincipal = &v
	return s
}

// The request was rejected because the specified policy is not syntactically
// or semantically correct.
type MalformedPolicyDocumentException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MalformedPolicyDocumentException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MalformedPolicyDocumentException) GoString() string {
	return s.String()
}

func newErrorMalformedPolicyDocumentException(v protocol.ResponseMetadata) error {
	return &MalformedPolicyDocumentException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MalformedPolicyDocumentException) Code() string {
	return "MalformedPolicyDocumentException"
}

// Message returns the exception's message.
func (s *MalformedPolicyDocumentException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MalformedPolicyDocumentException) OrigErr() error {
	return nil
}

func (s *MalformedPolicyDocumentException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MalformedPolicyDocumentException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MalformedPolicyDocumentException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes the configuration of this multi-Region key. This field appears
// only when the KMS key is a primary or replica of a multi-Region key.
//
// For more information about any listed KMS key, use the DescribeKey operation.
type MultiRegionConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates whether the KMS key is a PRIMARY or REPLICA key.
	MultiRegionKeyType *string `type:"string" enum:"MultiRegionKeyType"`

	// Displays the key ARN and Region of the primary key. This field includes the
	// current KMS key if it is the primary key.
	PrimaryKey *MultiRegionKey `type:"structure"`

	// displays the key ARNs and Regions of all replica keys. This field includes
	// the current KMS key if it is a replica key.
	ReplicaKeys []*MultiRegionKey `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiRegionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiRegionConfiguration) GoString() string {
	return s.String()
}

// SetMultiRegionKeyType sets the MultiRegionKeyType field's value.
func (s *MultiRegionConfiguration) SetMultiRegionKeyType(v string) *MultiRegionConfiguration {
	s.MultiRegionKeyType = &v
	return s
}

// SetPrimaryKey sets the PrimaryKey field's value.
func (s *MultiRegionConfiguration) SetPrimaryKey(v *MultiRegionKey) *MultiRegionConfiguration {
	s.PrimaryKey = v
	return s
}

// SetReplicaKeys sets the ReplicaKeys field's value.
func (s *MultiRegionConfiguration) SetReplicaKeys(v []*MultiRegionKey) *MultiRegionConfiguration {
	s.ReplicaKeys = v
	return s
}

// Describes the primary or replica key in a multi-Region key.
type MultiRegionKey struct {
	_ struct{} `type:"structure"`

	// Displays the key ARN of a primary or replica key of a multi-Region key.
	Arn *string `min:"20" type:"string"`

	// Displays the Amazon Web Services Region of a primary or replica key in a
	// multi-Region key.
	Region *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiRegionKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiRegionKey) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *MultiRegionKey) SetArn(v string) *MultiRegionKey {
	s.Arn = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *MultiRegionKey) SetRegion(v string) *MultiRegionKey {
	s.Region = &v
	return s
}

// The request was rejected because the specified entity or resource could not
// be found.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type PutKeyPolicyInput struct {
	_ struct{} `type:"structure"`

	// A flag to indicate whether to bypass the key policy lockout safety check.
	//
	// Setting this value to true increases the risk that the KMS key becomes unmanageable.
	// Do not set this value to true indiscriminately.
	//
	// For more information, refer to the scenario in the Default Key Policy (https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
	// section in the Key Management Service Developer Guide.
	//
	// Use this parameter only when you intend to prevent the principal that is
	// making the request from making a subsequent PutKeyPolicy request on the KMS
	// key.
	//
	// The default value is false.
	BypassPolicyLockoutSafetyCheck *bool `type:"boolean"`

	// Sets the key policy on the specified KMS key.
	//
	// Specify the key ID or key ARN of the KMS key.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// The key policy to attach to the KMS key.
	//
	// The key policy must meet the following criteria:
	//
	//    * If you don't set BypassPolicyLockoutSafetyCheck to true, the key policy
	//    must allow the principal that is making the PutKeyPolicy request to make
	//    a subsequent PutKeyPolicy request on the KMS key. This reduces the risk
	//    that the KMS key becomes unmanageable. For more information, refer to
	//    the scenario in the Default Key Policy (https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
	//    section of the Key Management Service Developer Guide.
	//
	//    * Each statement in the key policy must contain one or more principals.
	//    The principals in the key policy must exist and be visible to KMS. When
	//    you create a new Amazon Web Services principal (for example, an IAM user
	//    or role), you might need to enforce a delay before including the new principal
	//    in a key policy because the new principal might not be immediately visible
	//    to KMS. For more information, see Changes that I make are not always immediately
	//    visible (https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency)
	//    in the Amazon Web Services Identity and Access Management User Guide.
	//
	// A key policy document can include only the following characters:
	//
	//    * Printable ASCII characters from the space character (\u0020) through
	//    the end of the ASCII character range.
	//
	//    * Printable characters in the Basic Latin and Latin-1 Supplement character
	//    set (through \u00FF).
	//
	//    * The tab (\u0009), line feed (\u000A), and carriage return (\u000D) special
	//    characters
	//
	// For information about key policies, see Key policies in KMS (https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html)
	// in the Key Management Service Developer Guide.For help writing and formatting
	// a JSON policy document, see the IAM JSON Policy Reference (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html)
	// in the Identity and Access Management User Guide .
	//
	// Policy is a required field
	Policy *string `min:"1" type:"string" required:"true"`

	// The name of the key policy. The only valid value is default.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutKeyPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutKeyPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutKeyPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutKeyPolicyInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBypassPolicyLockoutSafetyCheck sets the BypassPolicyLockoutSafetyCheck field's value.
func (s *PutKeyPolicyInput) SetBypassPolicyLockoutSafetyCheck(v bool) *PutKeyPolicyInput {
	s.BypassPolicyLockoutSafetyCheck = &v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *PutKeyPolicyInput) SetKeyId(v string) *PutKeyPolicyInput {
	s.KeyId = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutKeyPolicyInput) SetPolicy(v string) *PutKeyPolicyInput {
	s.Policy = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *PutKeyPolicyInput) SetPolicyName(v string) *PutKeyPolicyInput {
	s.PolicyName = &v
	return s
}

type PutKeyPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutKeyPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutKeyPolicyOutput) GoString() string {
	return s.String()
}

type ReEncryptInput struct {
	_ struct{} `type:"structure"`

	// Ciphertext of the data to reencrypt.
	// CiphertextBlob is automatically base64 encoded/decoded by the SDK.
	//
	// CiphertextBlob is a required field
	CiphertextBlob []byte `min:"1" type:"blob" required:"true"`

	// Specifies the encryption algorithm that KMS will use to reecrypt the data
	// after it has decrypted it. The default value, SYMMETRIC_DEFAULT, represents
	// the encryption algorithm used for symmetric encryption KMS keys.
	//
	// This parameter is required only when the destination KMS key is an asymmetric
	// KMS key.
	DestinationEncryptionAlgorithm *string `type:"string" enum:"EncryptionAlgorithmSpec"`

	// Specifies that encryption context to use when the reencrypting the data.
	//
	// A destination encryption context is valid only when the destination KMS key
	// is a symmetric encryption KMS key. The standard ciphertext format for asymmetric
	// KMS keys does not include fields for metadata.
	//
	// An encryption context is a collection of non-secret key-value pairs that
	// represent additional authenticated data. When you use an encryption context
	// to encrypt data, you must specify the same (an exact case-sensitive match)
	// encryption context to decrypt the data. An encryption context is supported
	// only on operations with symmetric encryption KMS keys. On operations with
	// symmetric encryption KMS keys, an encryption context is optional, but it
	// is strongly recommended.
	//
	// For more information, see Encryption context (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
	// in the Key Management Service Developer Guide.
	DestinationEncryptionContext map[string]*string `type:"map"`

	// A unique identifier for the KMS key that is used to reencrypt the data. Specify
	// a symmetric encryption KMS key or an asymmetric KMS key with a KeyUsage value
	// of ENCRYPT_DECRYPT. To find the KeyUsage value of a KMS key, use the DescribeKey
	// operation.
	//
	// To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
	// When using an alias name, prefix it with "alias/". To specify a KMS key in
	// a different Amazon Web Services account, you must use the key ARN or alias
	// ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	// To get the alias name and alias ARN, use ListAliases.
	//
	// DestinationKeyId is a required field
	DestinationKeyId *string `min:"1" type:"string" required:"true"`

	// A list of grant tokens.
	//
	// Use a grant token when your permission to call this operation comes from
	// a new grant that has not yet achieved eventual consistency. For more information,
	// see Grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
	// and Using a grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
	// in the Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// Specifies the encryption algorithm that KMS will use to decrypt the ciphertext
	// before it is reencrypted. The default value, SYMMETRIC_DEFAULT, represents
	// the algorithm used for symmetric encryption KMS keys.
	//
	// Specify the same algorithm that was used to encrypt the ciphertext. If you
	// specify a different algorithm, the decrypt attempt fails.
	//
	// This parameter is required only when the ciphertext was encrypted under an
	// asymmetric KMS key.
	SourceEncryptionAlgorithm *string `type:"string" enum:"EncryptionAlgorithmSpec"`

	// Specifies the encryption context to use to decrypt the ciphertext. Enter
	// the same encryption context that was used to encrypt the ciphertext.
	//
	// An encryption context is a collection of non-secret key-value pairs that
	// represent additional authenticated data. When you use an encryption context
	// to encrypt data, you must specify the same (an exact case-sensitive match)
	// encryption context to decrypt the data. An encryption context is supported
	// only on operations with symmetric encryption KMS keys. On operations with
	// symmetric encryption KMS keys, an encryption context is optional, but it
	// is strongly recommended.
	//
	// For more information, see Encryption context (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
	// in the Key Management Service Developer Guide.
	SourceEncryptionContext map[string]*string `type:"map"`

	// Specifies the KMS key that KMS will use to decrypt the ciphertext before
	// it is re-encrypted.
	//
	// Enter a key ID of the KMS key that was used to encrypt the ciphertext. If
	// you identify a different KMS key, the ReEncrypt operation throws an IncorrectKeyException.
	//
	// This parameter is required only when the ciphertext was encrypted under an
	// asymmetric KMS key. If you used a symmetric encryption KMS key, KMS can get
	// the KMS key from metadata that it adds to the symmetric ciphertext blob.
	// However, it is always recommended as a best practice. This practice ensures
	// that you use the KMS key that you intend.
	//
	// To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
	// When using an alias name, prefix it with "alias/". To specify a KMS key in
	// a different Amazon Web Services account, you must use the key ARN or alias
	// ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	// To get the alias name and alias ARN, use ListAliases.
	SourceKeyId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReEncryptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReEncryptInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReEncryptInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReEncryptInput"}
	if s.CiphertextBlob == nil {
		invalidParams.Add(request.NewErrParamRequired("CiphertextBlob"))
	}
	if s.CiphertextBlob != nil && len(s.CiphertextBlob) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CiphertextBlob", 1))
	}
	if s.DestinationKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationKeyId"))
	}
	if s.DestinationKeyId != nil && len(*s.DestinationKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationKeyId", 1))
	}
	if s.SourceKeyId != nil && len(*s.SourceKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCiphertextBlob sets the CiphertextBlob field's value.
func (s *ReEncryptInput) SetCiphertextBlob(v []byte) *ReEncryptInput {
	s.CiphertextBlob = v
	return s
}

// SetDestinationEncryptionAlgorithm sets the DestinationEncryptionAlgorithm field's value.
func (s *ReEncryptInput) SetDestinationEncryptionAlgorithm(v string) *ReEncryptInput {
	s.DestinationEncryptionAlgorithm = &v
	return s
}

// SetDestinationEncryptionContext sets the DestinationEncryptionContext field's value.
func (s *ReEncryptInput) SetDestinationEncryptionContext(v map[string]*string) *ReEncryptInput {
	s.DestinationEncryptionContext = v
	return s
}

// SetDestinationKeyId sets the DestinationKeyId field's value.
func (s *ReEncryptInput) SetDestinationKeyId(v string) *ReEncryptInput {
	s.DestinationKeyId = &v
	return s
}

// SetGrantTokens sets the GrantTokens field's value.
func (s *ReEncryptInput) SetGrantTokens(v []*string) *ReEncryptInput {
	s.GrantTokens = v
	return s
}

// SetSourceEncryptionAlgorithm sets the SourceEncryptionAlgorithm field's value.
func (s *ReEncryptInput) SetSourceEncryptionAlgorithm(v string) *ReEncryptInput {
	s.SourceEncryptionAlgorithm = &v
	return s
}

// SetSourceEncryptionContext sets the SourceEncryptionContext field's value.
func (s *ReEncryptInput) SetSourceEncryptionContext(v map[string]*string) *ReEncryptInput {
	s.SourceEncryptionContext = v
	return s
}

// SetSourceKeyId sets the SourceKeyId field's value.
func (s *ReEncryptInput) SetSourceKeyId(v string) *ReEncryptInput {
	s.SourceKeyId = &v
	return s
}

type ReEncryptOutput struct {
	_ struct{} `type:"structure"`

	// The reencrypted data. When you use the HTTP API or the Amazon Web Services
	// CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
	// CiphertextBlob is automatically base64 encoded/decoded by the SDK.
	CiphertextBlob []byte `min:"1" type:"blob"`

	// The encryption algorithm that was used to reencrypt the data.
	DestinationEncryptionAlgorithm *string `type:"string" enum:"EncryptionAlgorithmSpec"`

	// The Amazon Resource Name (key ARN (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN))
	// of the KMS key that was used to reencrypt the data.
	KeyId *string `min:"1" type:"string"`

	// The encryption algorithm that was used to decrypt the ciphertext before it
	// was reencrypted.
	SourceEncryptionAlgorithm *string `type:"string" enum:"EncryptionAlgorithmSpec"`

	// Unique identifier of the KMS key used to originally encrypt the data.
	SourceKeyId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReEncryptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReEncryptOutput) GoString() string {
	return s.String()
}

// SetCiphertextBlob sets the CiphertextBlob field's value.
func (s *ReEncryptOutput) SetCiphertextBlob(v []byte) *ReEncryptOutput {
	s.CiphertextBlob = v
	return s
}

// SetDestinationEncryptionAlgorithm sets the DestinationEncryptionAlgorithm field's value.
func (s *ReEncryptOutput) SetDestinationEncryptionAlgorithm(v string) *ReEncryptOutput {
	s.DestinationEncryptionAlgorithm = &v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *ReEncryptOutput) SetKeyId(v string) *ReEncryptOutput {
	s.KeyId = &v
	return s
}

// SetSourceEncryptionAlgorithm sets the SourceEncryptionAlgorithm field's value.
func (s *ReEncryptOutput) SetSourceEncryptionAlgorithm(v string) *ReEncryptOutput {
	s.SourceEncryptionAlgorithm = &v
	return s
}

// SetSourceKeyId sets the SourceKeyId field's value.
func (s *ReEncryptOutput) SetSourceKeyId(v string) *ReEncryptOutput {
	s.SourceKeyId = &v
	return s
}

type ReplicateKeyInput struct {
	_ struct{} `type:"structure"`

	// A flag to indicate whether to bypass the key policy lockout safety check.
	//
	// Setting this value to true increases the risk that the KMS key becomes unmanageable.
	// Do not set this value to true indiscriminately.
	//
	// For more information, refer to the scenario in the Default Key Policy (https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
	// section in the Key Management Service Developer Guide.
	//
	// Use this parameter only when you intend to prevent the principal that is
	// making the request from making a subsequent PutKeyPolicy request on the KMS
	// key.
	//
	// The default value is false.
	BypassPolicyLockoutSafetyCheck *bool `type:"boolean"`

	// A description of the KMS key. The default value is an empty string (no description).
	//
	// The description is not a shared property of multi-Region keys. You can specify
	// the same description or a different description for each key in a set of
	// related multi-Region keys. KMS does not synchronize this property.
	Description *string `type:"string"`

	// Identifies the multi-Region primary key that is being replicated. To determine
	// whether a KMS key is a multi-Region primary key, use the DescribeKey operation
	// to check the value of the MultiRegionKeyType property.
	//
	// Specify the key ID or key ARN of a multi-Region primary key.
	//
	// For example:
	//
	//    * Key ID: mrk-1234abcd12ab34cd56ef1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// The key policy to attach to the KMS key. This parameter is optional. If you
	// do not provide a key policy, KMS attaches the default key policy (https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default)
	// to the KMS key.
	//
	// The key policy is not a shared property of multi-Region keys. You can specify
	// the same key policy or a different key policy for each key in a set of related
	// multi-Region keys. KMS does not synchronize this property.
	//
	// If you provide a key policy, it must meet the following criteria:
	//
	//    * If you don't set BypassPolicyLockoutSafetyCheck to true, the key policy
	//    must give the caller kms:PutKeyPolicy permission on the replica key. This
	//    reduces the risk that the KMS key becomes unmanageable. For more information,
	//    refer to the scenario in the Default Key Policy (https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
	//    section of the Key Management Service Developer Guide .
	//
	//    * Each statement in the key policy must contain one or more principals.
	//    The principals in the key policy must exist and be visible to KMS. When
	//    you create a new Amazon Web Services principal (for example, an IAM user
	//    or role), you might need to enforce a delay before including the new principal
	//    in a key policy because the new principal might not be immediately visible
	//    to KMS. For more information, see Changes that I make are not always immediately
	//    visible (https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency)
	//    in the Identity and Access Management User Guide .
	//
	// A key policy document can include only the following characters:
	//
	//    * Printable ASCII characters from the space character (\u0020) through
	//    the end of the ASCII character range.
	//
	//    * Printable characters in the Basic Latin and Latin-1 Supplement character
	//    set (through \u00FF).
	//
	//    * The tab (\u0009), line feed (\u000A), and carriage return (\u000D) special
	//    characters
	//
	// For information about key policies, see Key policies in KMS (https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html)
	// in the Key Management Service Developer Guide. For help writing and formatting
	// a JSON policy document, see the IAM JSON Policy Reference (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html)
	// in the Identity and Access Management User Guide .
	Policy *string `min:"1" type:"string"`

	// The Region ID of the Amazon Web Services Region for this replica key.
	//
	// Enter the Region ID, such as us-east-1 or ap-southeast-2. For a list of Amazon
	// Web Services Regions in which KMS is supported, see KMS service endpoints
	// (https://docs.aws.amazon.com/general/latest/gr/kms.html#kms_region) in the
	// Amazon Web Services General Reference.
	//
	// HMAC KMS keys are not supported in all Amazon Web Services Regions. If you
	// try to replicate an HMAC KMS key in an Amazon Web Services Region in which
	// HMAC keys are not supported, the ReplicateKey operation returns an UnsupportedOperationException.
	// For a list of Regions in which HMAC KMS keys are supported, see HMAC keys
	// in KMS (https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html)
	// in the Key Management Service Developer Guide.
	//
	// The replica must be in a different Amazon Web Services Region than its primary
	// key and other replicas of that primary key, but in the same Amazon Web Services
	// partition. KMS must be available in the replica Region. If the Region is
	// not enabled by default, the Amazon Web Services account must be enabled in
	// the Region. For information about Amazon Web Services partitions, see Amazon
	// Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference. For information about enabling
	// and disabling Regions, see Enabling a Region (https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable)
	// and Disabling a Region (https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-disable)
	// in the Amazon Web Services General Reference.
	//
	// ReplicaRegion is a required field
	ReplicaRegion *string `min:"1" type:"string" required:"true"`

	// Assigns one or more tags to the replica key. Use this parameter to tag the
	// KMS key when it is created. To tag an existing KMS key, use the TagResource
	// operation.
	//
	// Tagging or untagging a KMS key can allow or deny permission to the KMS key.
	// For details, see ABAC for KMS (https://docs.aws.amazon.com/kms/latest/developerguide/abac.html)
	// in the Key Management Service Developer Guide.
	//
	// To use this parameter, you must have kms:TagResource (https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
	// permission in an IAM policy.
	//
	// Tags are not a shared property of multi-Region keys. You can specify the
	// same tags or different tags for each key in a set of related multi-Region
	// keys. KMS does not synchronize this property.
	//
	// Each tag consists of a tag key and a tag value. Both the tag key and the
	// tag value are required, but the tag value can be an empty (null) string.
	// You cannot have more than one tag on a KMS key with the same tag key. If
	// you specify an existing tag key with a different tag value, KMS replaces
	// the current tag value with the specified one.
	//
	// When you add tags to an Amazon Web Services resource, Amazon Web Services
	// generates a cost allocation report with usage and costs aggregated by tags.
	// Tags can also be used to control access to a KMS key. For details, see Tagging
	// Keys (https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html).
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicateKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicateKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicateKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReplicateKeyInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}
	if s.ReplicaRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicaRegion"))
	}
	if s.ReplicaRegion != nil && len(*s.ReplicaRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReplicaRegion", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBypassPolicyLockoutSafetyCheck sets the BypassPolicyLockoutSafetyCheck field's value.
func (s *ReplicateKeyInput) SetBypassPolicyLockoutSafetyCheck(v bool) *ReplicateKeyInput {
	s.BypassPolicyLockoutSafetyCheck = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ReplicateKeyInput) SetDescription(v string) *ReplicateKeyInput {
	s.Description = &v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *ReplicateKeyInput) SetKeyId(v string) *ReplicateKeyInput {
	s.KeyId = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *ReplicateKeyInput) SetPolicy(v string) *ReplicateKeyInput {
	s.Policy = &v
	return s
}

// SetReplicaRegion sets the ReplicaRegion field's value.
func (s *ReplicateKeyInput) SetReplicaRegion(v string) *ReplicateKeyInput {
	s.ReplicaRegion = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ReplicateKeyInput) SetTags(v []*Tag) *ReplicateKeyInput {
	s.Tags = v
	return s
}

type ReplicateKeyOutput struct {
	_ struct{} `type:"structure"`

	// Displays details about the new replica key, including its Amazon Resource
	// Name (key ARN (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN))
	// and Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html).
	// It also includes the ARN and Amazon Web Services Region of its primary key
	// and other replica keys.
	ReplicaKeyMetadata *KeyMetadata `type:"structure"`

	// The key policy of the new replica key. The value is a key policy document
	// in JSON format.
	ReplicaPolicy *string `min:"1" type:"string"`

	// The tags on the new replica key. The value is a list of tag key and tag value
	// pairs.
	ReplicaTags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicateKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicateKeyOutput) GoString() string {
	return s.String()
}

// SetReplicaKeyMetadata sets the ReplicaKeyMetadata field's value.
func (s *ReplicateKeyOutput) SetReplicaKeyMetadata(v *KeyMetadata) *ReplicateKeyOutput {
	s.ReplicaKeyMetadata = v
	return s
}

// SetReplicaPolicy sets the ReplicaPolicy field's value.
func (s *ReplicateKeyOutput) SetReplicaPolicy(v string) *ReplicateKeyOutput {
	s.ReplicaPolicy = &v
	return s
}

// SetReplicaTags sets the ReplicaTags field's value.
func (s *ReplicateKeyOutput) SetReplicaTags(v []*Tag) *ReplicateKeyOutput {
	s.ReplicaTags = v
	return s
}

type RetireGrantInput struct {
	_ struct{} `type:"structure"`

	// Identifies the grant to retire. To get the grant ID, use CreateGrant, ListGrants,
	// or ListRetirableGrants.
	//
	//    * Grant ID Example - 0123456789012345678901234567890123456789012345678901234567890123
	GrantId *string `min:"1" type:"string"`

	// Identifies the grant to be retired. You can use a grant token to identify
	// a new grant even before it has achieved eventual consistency.
	//
	// Only the CreateGrant operation returns a grant token. For details, see Grant
	// token (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
	// and Eventual consistency (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#terms-eventual-consistency)
	// in the Key Management Service Developer Guide.
	GrantToken *string `min:"1" type:"string"`

	// The key ARN KMS key associated with the grant. To find the key ARN, use the
	// ListKeys operation.
	//
	// For example: arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab
	KeyId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetireGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetireGrantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetireGrantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetireGrantInput"}
	if s.GrantId != nil && len(*s.GrantId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GrantId", 1))
	}
	if s.GrantToken != nil && len(*s.GrantToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GrantToken", 1))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrantId sets the GrantId field's value.
func (s *RetireGrantInput) SetGrantId(v string) *RetireGrantInput {
	s.GrantId = &v
	return s
}

// SetGrantToken sets the GrantToken field's value.
func (s *RetireGrantInput) SetGrantToken(v string) *RetireGrantInput {
	s.GrantToken = &v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *RetireGrantInput) SetKeyId(v string) *RetireGrantInput {
	s.KeyId = &v
	return s
}

type RetireGrantOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetireGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetireGrantOutput) GoString() string {
	return s.String()
}

type RevokeGrantInput struct {
	_ struct{} `type:"structure"`

	// Identifies the grant to revoke. To get the grant ID, use CreateGrant, ListGrants,
	// or ListRetirableGrants.
	//
	// GrantId is a required field
	GrantId *string `min:"1" type:"string" required:"true"`

	// A unique identifier for the KMS key associated with the grant. To get the
	// key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// Specify the key ID or key ARN of the KMS key. To specify a KMS key in a different
	// Amazon Web Services account, you must use the key ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeGrantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeGrantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevokeGrantInput"}
	if s.GrantId == nil {
		invalidParams.Add(request.NewErrParamRequired("GrantId"))
	}
	if s.GrantId != nil && len(*s.GrantId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GrantId", 1))
	}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrantId sets the GrantId field's value.
func (s *RevokeGrantInput) SetGrantId(v string) *RevokeGrantInput {
	s.GrantId = &v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *RevokeGrantInput) SetKeyId(v string) *RevokeGrantInput {
	s.KeyId = &v
	return s
}

type RevokeGrantOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeGrantOutput) GoString() string {
	return s.String()
}

type ScheduleKeyDeletionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the KMS key to delete.
	//
	// Specify the key ID or key ARN of the KMS key.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// The waiting period, specified in number of days. After the waiting period
	// ends, KMS deletes the KMS key.
	//
	// If the KMS key is a multi-Region primary key with replica keys, the waiting
	// period begins when the last of its replica keys is deleted. Otherwise, the
	// waiting period begins immediately.
	//
	// This value is optional. If you include a value, it must be between 7 and
	// 30, inclusive. If you do not include a value, it defaults to 30.
	PendingWindowInDays *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleKeyDeletionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleKeyDeletionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleKeyDeletionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduleKeyDeletionInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.PendingWindowInDays != nil && *s.PendingWindowInDays < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PendingWindowInDays", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyId sets the KeyId field's value.
func (s *ScheduleKeyDeletionInput) SetKeyId(v string) *ScheduleKeyDeletionInput {
	s.KeyId = &v
	return s
}

// SetPendingWindowInDays sets the PendingWindowInDays field's value.
func (s *ScheduleKeyDeletionInput) SetPendingWindowInDays(v int64) *ScheduleKeyDeletionInput {
	s.PendingWindowInDays = &v
	return s
}

type ScheduleKeyDeletionOutput struct {
	_ struct{} `type:"structure"`

	// The date and time after which KMS deletes the KMS key.
	//
	// If the KMS key is a multi-Region primary key with replica keys, this field
	// does not appear. The deletion date for the primary key isn't known until
	// its last replica key is deleted.
	DeletionDate *time.Time `type:"timestamp"`

	// The Amazon Resource Name (key ARN (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN))
	// of the KMS key whose deletion is scheduled.
	KeyId *string `min:"1" type:"string"`

	// The current status of the KMS key.
	//
	// For more information about how key state affects the use of a KMS key, see
	// Key states of KMS keys (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
	// in the Key Management Service Developer Guide.
	KeyState *string `type:"string" enum:"KeyState"`

	// The waiting period before the KMS key is deleted.
	//
	// If the KMS key is a multi-Region primary key with replicas, the waiting period
	// begins when the last of its replica keys is deleted. Otherwise, the waiting
	// period begins immediately.
	PendingWindowInDays *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleKeyDeletionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleKeyDeletionOutput) GoString() string {
	return s.String()
}

// SetDeletionDate sets the DeletionDate field's value.
func (s *ScheduleKeyDeletionOutput) SetDeletionDate(v time.Time) *ScheduleKeyDeletionOutput {
	s.DeletionDate = &v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *ScheduleKeyDeletionOutput) SetKeyId(v string) *ScheduleKeyDeletionOutput {
	s.KeyId = &v
	return s
}

// SetKeyState sets the KeyState field's value.
func (s *ScheduleKeyDeletionOutput) SetKeyState(v string) *ScheduleKeyDeletionOutput {
	s.KeyState = &v
	return s
}

// SetPendingWindowInDays sets the PendingWindowInDays field's value.
func (s *ScheduleKeyDeletionOutput) SetPendingWindowInDays(v int64) *ScheduleKeyDeletionOutput {
	s.PendingWindowInDays = &v
	return s
}

type SignInput struct {
	_ struct{} `type:"structure"`

	// A list of grant tokens.
	//
	// Use a grant token when your permission to call this operation comes from
	// a new grant that has not yet achieved eventual consistency. For more information,
	// see Grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
	// and Using a grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
	// in the Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// Identifies an asymmetric KMS key. KMS uses the private key in the asymmetric
	// KMS key to sign the message. The KeyUsage type of the KMS key must be SIGN_VERIFY.
	// To find the KeyUsage of a KMS key, use the DescribeKey operation.
	//
	// To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
	// When using an alias name, prefix it with "alias/". To specify a KMS key in
	// a different Amazon Web Services account, you must use the key ARN or alias
	// ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	// To get the alias name and alias ARN, use ListAliases.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// Specifies the message or message digest to sign. Messages can be 0-4096 bytes.
	// To sign a larger message, provide the message digest.
	//
	// If you provide a message, KMS generates a hash digest of the message and
	// then signs it.
	//
	// Message is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SignInput's
	// String and GoString methods.
	//
	// Message is automatically base64 encoded/decoded by the SDK.
	//
	// Message is a required field
	Message []byte `min:"1" type:"blob" required:"true" sensitive:"true"`

	// Tells KMS whether the value of the Message parameter is a message or message
	// digest. The default value, RAW, indicates a message. To indicate a message
	// digest, enter DIGEST.
	MessageType *string `type:"string" enum:"MessageType"`

	// Specifies the signing algorithm to use when signing the message.
	//
	// Choose an algorithm that is compatible with the type and size of the specified
	// asymmetric KMS key.
	//
	// SigningAlgorithm is a required field
	SigningAlgorithm *string `type:"string" required:"true" enum:"SigningAlgorithmSpec"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SignInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.Message == nil {
		invalidParams.Add(request.NewErrParamRequired("Message"))
	}
	if s.Message != nil && len(s.Message) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Message", 1))
	}
	if s.SigningAlgorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("SigningAlgorithm"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrantTokens sets the GrantTokens field's value.
func (s *SignInput) SetGrantTokens(v []*string) *SignInput {
	s.GrantTokens = v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *SignInput) SetKeyId(v string) *SignInput {
	s.KeyId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *SignInput) SetMessage(v []byte) *SignInput {
	s.Message = v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *SignInput) SetMessageType(v string) *SignInput {
	s.MessageType = &v
	return s
}

// SetSigningAlgorithm sets the SigningAlgorithm field's value.
func (s *SignInput) SetSigningAlgorithm(v string) *SignInput {
	s.SigningAlgorithm = &v
	return s
}

type SignOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (key ARN (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN))
	// of the asymmetric KMS key that was used to sign the message.
	KeyId *string `min:"1" type:"string"`

	// The cryptographic signature that was generated for the message.
	//
	//    * When used with the supported RSA signing algorithms, the encoding of
	//    this value is defined by PKCS #1 in RFC 8017 (https://tools.ietf.org/html/rfc8017).
	//
	//    * When used with the ECDSA_SHA_256, ECDSA_SHA_384, or ECDSA_SHA_512 signing
	//    algorithms, this value is a DER-encoded object as defined by ANS X9.62–2005
	//    and RFC 3279 Section 2.2.3 (https://tools.ietf.org/html/rfc3279#section-2.2.3).
	//    This is the most commonly used signature format and is appropriate for
	//    most uses.
	//
	// When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded.
	// Otherwise, it is not Base64-encoded.
	// Signature is automatically base64 encoded/decoded by the SDK.
	Signature []byte `min:"1" type:"blob"`

	// The signing algorithm that was used to sign the message.
	SigningAlgorithm *string `type:"string" enum:"SigningAlgorithmSpec"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SignOutput) GoString() string {
	return s.String()
}

// SetKeyId sets the KeyId field's value.
func (s *SignOutput) SetKeyId(v string) *SignOutput {
	s.KeyId = &v
	return s
}

// SetSignature sets the Signature field's value.
func (s *SignOutput) SetSignature(v []byte) *SignOutput {
	s.Signature = v
	return s
}

// SetSigningAlgorithm sets the SigningAlgorithm field's value.
func (s *SignOutput) SetSigningAlgorithm(v string) *SignOutput {
	s.SigningAlgorithm = &v
	return s
}

// A key-value pair. A tag consists of a tag key and a tag value. Tag keys and
// tag values are both required, but tag values can be empty (null) strings.
//
// For information about the rules that apply to tag keys and tag values, see
// User-Defined Tag Restrictions (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html)
// in the Amazon Web Services Billing and Cost Management User Guide.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// TagKey is a required field
	TagKey *string `min:"1" type:"string" required:"true"`

	// The value of the tag.
	//
	// TagValue is a required field
	TagValue *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.TagKey == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKey"))
	}
	if s.TagKey != nil && len(*s.TagKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKey", 1))
	}
	if s.TagValue == nil {
		invalidParams.Add(request.NewErrParamRequired("TagValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTagKey sets the TagKey field's value.
func (s *Tag) SetTagKey(v string) *Tag {
	s.TagKey = &v
	return s
}

// SetTagValue sets the TagValue field's value.
func (s *Tag) SetTagValue(v string) *Tag {
	s.TagValue = &v
	return s
}

// The request was rejected because one or more tags are not valid.
type TagException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagException) GoString() string {
	return s.String()
}

func newErrorTagException(v protocol.ResponseMetadata) error {
	return &TagException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TagException) Code() string {
	return "TagException"
}

// Message returns the exception's message.
func (s *TagException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TagException) OrigErr() error {
	return nil
}

func (s *TagException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TagException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TagException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// Identifies a customer managed key in the account and Region.
	//
	// Specify the key ID or key ARN of the KMS key.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// One or more tags.
	//
	// Each tag consists of a tag key and a tag value. The tag value can be an empty
	// (null) string.
	//
	// You cannot have more than one tag on a KMS key with the same tag key. If
	// you specify an existing tag key with a different tag value, KMS replaces
	// the current tag value with the specified one.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyId sets the KeyId field's value.
func (s *TagResourceInput) SetKeyId(v string) *TagResourceInput {
	s.KeyId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was rejected because a specified parameter is not supported or
// a specified resource is not valid for this operation.
type UnsupportedOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedOperationException) GoString() string {
	return s.String()
}

func newErrorUnsupportedOperationException(v protocol.ResponseMetadata) error {
	return &UnsupportedOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedOperationException) Code() string {
	return "UnsupportedOperationException"
}

// Message returns the exception's message.
func (s *UnsupportedOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedOperationException) OrigErr() error {
	return nil
}

func (s *UnsupportedOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// Identifies the KMS key from which you are removing tags.
	//
	// Specify the key ID or key ARN of the KMS key.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// One or more tag keys. Specify only the tag keys, not the tag values.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyId sets the KeyId field's value.
func (s *UntagResourceInput) SetKeyId(v string) *UntagResourceInput {
	s.KeyId = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAliasInput struct {
	_ struct{} `type:"structure"`

	// Identifies the alias that is changing its KMS key. This value must begin
	// with alias/ followed by the alias name, such as alias/ExampleAlias. You cannot
	// use UpdateAlias to change the alias name.
	//
	// AliasName is a required field
	AliasName *string `min:"1" type:"string" required:"true"`

	// Identifies the customer managed key (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk)
	// to associate with the alias. You don't have permission to associate an alias
	// with an Amazon Web Services managed key (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk).
	//
	// The KMS key must be in the same Amazon Web Services account and Region as
	// the alias. Also, the new target KMS key must be the same type as the current
	// target KMS key (both symmetric or both asymmetric or both HMAC) and they
	// must have the same key usage.
	//
	// Specify the key ID or key ARN of the KMS key.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// To verify that the alias is mapped to the correct KMS key, use ListAliases.
	//
	// TargetKeyId is a required field
	TargetKeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAliasInput"}
	if s.AliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 1))
	}
	if s.TargetKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetKeyId"))
	}
	if s.TargetKeyId != nil && len(*s.TargetKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasName sets the AliasName field's value.
func (s *UpdateAliasInput) SetAliasName(v string) *UpdateAliasInput {
	s.AliasName = &v
	return s
}

// SetTargetKeyId sets the TargetKeyId field's value.
func (s *UpdateAliasInput) SetTargetKeyId(v string) *UpdateAliasInput {
	s.TargetKeyId = &v
	return s
}

type UpdateAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAliasOutput) GoString() string {
	return s.String()
}

type UpdateCustomKeyStoreInput struct {
	_ struct{} `type:"structure"`

	// Associates the custom key store with a related CloudHSM cluster. This parameter
	// is valid only for custom key stores with a CustomKeyStoreType of AWS_CLOUDHSM.
	//
	// Enter the cluster ID of the cluster that you used to create the custom key
	// store or a cluster that shares a backup history and has the same cluster
	// certificate as the original cluster. You cannot use this parameter to associate
	// a custom key store with an unrelated cluster. In addition, the replacement
	// cluster must fulfill the requirements (https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore)
	// for a cluster associated with a custom key store. To view the cluster certificate
	// of a cluster, use the DescribeClusters (https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html)
	// operation.
	//
	// To change this value, the CloudHSM key store must be disconnected.
	CloudHsmClusterId *string `min:"19" type:"string"`

	// Identifies the custom key store that you want to update. Enter the ID of
	// the custom key store. To find the ID of a custom key store, use the DescribeCustomKeyStores
	// operation.
	//
	// CustomKeyStoreId is a required field
	CustomKeyStoreId *string `min:"1" type:"string" required:"true"`

	// Enter the current password of the kmsuser crypto user (CU) in the CloudHSM
	// cluster that is associated with the custom key store. This parameter is valid
	// only for custom key stores with a CustomKeyStoreType of AWS_CLOUDHSM.
	//
	// This parameter tells KMS the current password of the kmsuser crypto user
	// (CU). It does not set or change the password of any users in the CloudHSM
	// cluster.
	//
	// To change this value, the CloudHSM key store must be disconnected.
	//
	// KeyStorePassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateCustomKeyStoreInput's
	// String and GoString methods.
	KeyStorePassword *string `min:"7" type:"string" sensitive:"true"`

	// Changes the friendly name of the custom key store to the value that you specify.
	// The custom key store name must be unique in the Amazon Web Services account.
	//
	// To change this value, an CloudHSM key store must be disconnected. An external
	// key store can be connected or disconnected.
	NewCustomKeyStoreName *string `min:"1" type:"string"`

	// Changes the credentials that KMS uses to sign requests to the external key
	// store proxy (XKS proxy). This parameter is valid only for custom key stores
	// with a CustomKeyStoreType of EXTERNAL_KEY_STORE.
	//
	// You must specify both the AccessKeyId and SecretAccessKey value in the authentication
	// credential, even if you are only updating one value.
	//
	// This parameter doesn't establish or change your authentication credentials
	// on the proxy. It just tells KMS the credential that you established with
	// your external key store proxy. For example, if you rotate the credential
	// on your external key store proxy, you can use this parameter to update the
	// credential in KMS.
	//
	// You can change this value when the external key store is connected or disconnected.
	XksProxyAuthenticationCredential *XksProxyAuthenticationCredentialType `type:"structure"`

	// Changes the connectivity setting for the external key store. To indicate
	// that the external key store proxy uses a Amazon VPC endpoint service to communicate
	// with KMS, specify VPC_ENDPOINT_SERVICE. Otherwise, specify PUBLIC_ENDPOINT.
	//
	// If you change the XksProxyConnectivity to VPC_ENDPOINT_SERVICE, you must
	// also change the XksProxyUriEndpoint and add an XksProxyVpcEndpointServiceName
	// value.
	//
	// If you change the XksProxyConnectivity to PUBLIC_ENDPOINT, you must also
	// change the XksProxyUriEndpoint and specify a null or empty string for the
	// XksProxyVpcEndpointServiceName value.
	//
	// To change this value, the external key store must be disconnected.
	XksProxyConnectivity *string `type:"string" enum:"XksProxyConnectivityType"`

	// Changes the URI endpoint that KMS uses to connect to your external key store
	// proxy (XKS proxy). This parameter is valid only for custom key stores with
	// a CustomKeyStoreType of EXTERNAL_KEY_STORE.
	//
	// For external key stores with an XksProxyConnectivity value of PUBLIC_ENDPOINT,
	// the protocol must be HTTPS.
	//
	// For external key stores with an XksProxyConnectivity value of VPC_ENDPOINT_SERVICE,
	// specify https:// followed by the private DNS name associated with the VPC
	// endpoint service. Each external key store must use a different private DNS
	// name.
	//
	// The combined XksProxyUriEndpoint and XksProxyUriPath values must be unique
	// in the Amazon Web Services account and Region.
	//
	// To change this value, the external key store must be disconnected.
	XksProxyUriEndpoint *string `min:"10" type:"string"`

	// Changes the base path to the proxy APIs for this external key store. To find
	// this value, see the documentation for your external key manager and external
	// key store proxy (XKS proxy). This parameter is valid only for custom key
	// stores with a CustomKeyStoreType of EXTERNAL_KEY_STORE.
	//
	// The value must start with / and must end with /kms/xks/v1, where v1 represents
	// the version of the KMS external key store proxy API. You can include an optional
	// prefix between the required elements such as /example/kms/xks/v1.
	//
	// The combined XksProxyUriEndpoint and XksProxyUriPath values must be unique
	// in the Amazon Web Services account and Region.
	//
	// You can change this value when the external key store is connected or disconnected.
	XksProxyUriPath *string `min:"10" type:"string"`

	// Changes the name that KMS uses to identify the Amazon VPC endpoint service
	// for your external key store proxy (XKS proxy). This parameter is valid when
	// the CustomKeyStoreType is EXTERNAL_KEY_STORE and the XksProxyConnectivity
	// is VPC_ENDPOINT_SERVICE.
	//
	// To change this value, the external key store must be disconnected.
	XksProxyVpcEndpointServiceName *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomKeyStoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomKeyStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCustomKeyStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCustomKeyStoreInput"}
	if s.CloudHsmClusterId != nil && len(*s.CloudHsmClusterId) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("CloudHsmClusterId", 19))
	}
	if s.CustomKeyStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomKeyStoreId"))
	}
	if s.CustomKeyStoreId != nil && len(*s.CustomKeyStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomKeyStoreId", 1))
	}
	if s.KeyStorePassword != nil && len(*s.KeyStorePassword) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KeyStorePassword", 7))
	}
	if s.NewCustomKeyStoreName != nil && len(*s.NewCustomKeyStoreName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NewCustomKeyStoreName", 1))
	}
	if s.XksProxyUriEndpoint != nil && len(*s.XksProxyUriEndpoint) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("XksProxyUriEndpoint", 10))
	}
	if s.XksProxyUriPath != nil && len(*s.XksProxyUriPath) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("XksProxyUriPath", 10))
	}
	if s.XksProxyVpcEndpointServiceName != nil && len(*s.XksProxyVpcEndpointServiceName) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("XksProxyVpcEndpointServiceName", 20))
	}
	if s.XksProxyAuthenticationCredential != nil {
		if err := s.XksProxyAuthenticationCredential.Validate(); err != nil {
			invalidParams.AddNested("XksProxyAuthenticationCredential", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudHsmClusterId sets the CloudHsmClusterId field's value.
func (s *UpdateCustomKeyStoreInput) SetCloudHsmClusterId(v string) *UpdateCustomKeyStoreInput {
	s.CloudHsmClusterId = &v
	return s
}

// SetCustomKeyStoreId sets the CustomKeyStoreId field's value.
func (s *UpdateCustomKeyStoreInput) SetCustomKeyStoreId(v string) *UpdateCustomKeyStoreInput {
	s.CustomKeyStoreId = &v
	return s
}

// SetKeyStorePassword sets the KeyStorePassword field's value.
func (s *UpdateCustomKeyStoreInput) SetKeyStorePassword(v string) *UpdateCustomKeyStoreInput {
	s.KeyStorePassword = &v
	return s
}

// SetNewCustomKeyStoreName sets the NewCustomKeyStoreName field's value.
func (s *UpdateCustomKeyStoreInput) SetNewCustomKeyStoreName(v string) *UpdateCustomKeyStoreInput {
	s.NewCustomKeyStoreName = &v
	return s
}

// SetXksProxyAuthenticationCredential sets the XksProxyAuthenticationCredential field's value.
func (s *UpdateCustomKeyStoreInput) SetXksProxyAuthenticationCredential(v *XksProxyAuthenticationCredentialType) *UpdateCustomKeyStoreInput {
	s.XksProxyAuthenticationCredential = v
	return s
}

// SetXksProxyConnectivity sets the XksProxyConnectivity field's value.
func (s *UpdateCustomKeyStoreInput) SetXksProxyConnectivity(v string) *UpdateCustomKeyStoreInput {
	s.XksProxyConnectivity = &v
	return s
}

// SetXksProxyUriEndpoint sets the XksProxyUriEndpoint field's value.
func (s *UpdateCustomKeyStoreInput) SetXksProxyUriEndpoint(v string) *UpdateCustomKeyStoreInput {
	s.XksProxyUriEndpoint = &v
	return s
}

// SetXksProxyUriPath sets the XksProxyUriPath field's value.
func (s *UpdateCustomKeyStoreInput) SetXksProxyUriPath(v string) *UpdateCustomKeyStoreInput {
	s.XksProxyUriPath = &v
	return s
}

// SetXksProxyVpcEndpointServiceName sets the XksProxyVpcEndpointServiceName field's value.
func (s *UpdateCustomKeyStoreInput) SetXksProxyVpcEndpointServiceName(v string) *UpdateCustomKeyStoreInput {
	s.XksProxyVpcEndpointServiceName = &v
	return s
}

type UpdateCustomKeyStoreOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomKeyStoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomKeyStoreOutput) GoString() string {
	return s.String()
}

type UpdateKeyDescriptionInput struct {
	_ struct{} `type:"structure"`

	// New description for the KMS key.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// Updates the description of the specified KMS key.
	//
	// Specify the key ID or key ARN of the KMS key.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKeyDescriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKeyDescriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateKeyDescriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateKeyDescriptionInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateKeyDescriptionInput) SetDescription(v string) *UpdateKeyDescriptionInput {
	s.Description = &v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *UpdateKeyDescriptionInput) SetKeyId(v string) *UpdateKeyDescriptionInput {
	s.KeyId = &v
	return s
}

type UpdateKeyDescriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKeyDescriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKeyDescriptionOutput) GoString() string {
	return s.String()
}

type UpdatePrimaryRegionInput struct {
	_ struct{} `type:"structure"`

	// Identifies the current primary key. When the operation completes, this KMS
	// key will be a replica key.
	//
	// Specify the key ID or key ARN of a multi-Region primary key.
	//
	// For example:
	//
	//    * Key ID: mrk-1234abcd12ab34cd56ef1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// The Amazon Web Services Region of the new primary key. Enter the Region ID,
	// such as us-east-1 or ap-southeast-2. There must be an existing replica key
	// in this Region.
	//
	// When the operation completes, the multi-Region key in this Region will be
	// the primary key.
	//
	// PrimaryRegion is a required field
	PrimaryRegion *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePrimaryRegionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePrimaryRegionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePrimaryRegionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePrimaryRegionInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.PrimaryRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("PrimaryRegion"))
	}
	if s.PrimaryRegion != nil && len(*s.PrimaryRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrimaryRegion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyId sets the KeyId field's value.
func (s *UpdatePrimaryRegionInput) SetKeyId(v string) *UpdatePrimaryRegionInput {
	s.KeyId = &v
	return s
}

// SetPrimaryRegion sets the PrimaryRegion field's value.
func (s *UpdatePrimaryRegionInput) SetPrimaryRegion(v string) *UpdatePrimaryRegionInput {
	s.PrimaryRegion = &v
	return s
}

type UpdatePrimaryRegionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePrimaryRegionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePrimaryRegionOutput) GoString() string {
	return s.String()
}

type VerifyInput struct {
	_ struct{} `type:"structure"`

	// A list of grant tokens.
	//
	// Use a grant token when your permission to call this operation comes from
	// a new grant that has not yet achieved eventual consistency. For more information,
	// see Grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
	// and Using a grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
	// in the Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// Identifies the asymmetric KMS key that will be used to verify the signature.
	// This must be the same KMS key that was used to generate the signature. If
	// you specify a different KMS key, the signature verification fails.
	//
	// To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
	// When using an alias name, prefix it with "alias/". To specify a KMS key in
	// a different Amazon Web Services account, you must use the key ARN or alias
	// ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	// To get the alias name and alias ARN, use ListAliases.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// Specifies the message that was signed. You can submit a raw message of up
	// to 4096 bytes, or a hash digest of the message. If you submit a digest, use
	// the MessageType parameter with a value of DIGEST.
	//
	// If the message specified here is different from the message that was signed,
	// the signature verification fails. A message and its hash digest are considered
	// to be the same message.
	//
	// Message is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by VerifyInput's
	// String and GoString methods.
	//
	// Message is automatically base64 encoded/decoded by the SDK.
	//
	// Message is a required field
	Message []byte `min:"1" type:"blob" required:"true" sensitive:"true"`

	// Tells KMS whether the value of the Message parameter is a message or message
	// digest. The default value, RAW, indicates a message. To indicate a message
	// digest, enter DIGEST.
	//
	// Use the DIGEST value only when the value of the Message parameter is a message
	// digest. If you use the DIGEST value with a raw message, the security of the
	// verification operation can be compromised.
	MessageType *string `type:"string" enum:"MessageType"`

	// The signature that the Sign operation generated.
	// Signature is automatically base64 encoded/decoded by the SDK.
	//
	// Signature is a required field
	Signature []byte `min:"1" type:"blob" required:"true"`

	// The signing algorithm that was used to sign the message. If you submit a
	// different algorithm, the signature verification fails.
	//
	// SigningAlgorithm is a required field
	SigningAlgorithm *string `type:"string" required:"true" enum:"SigningAlgorithmSpec"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerifyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VerifyInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.Message == nil {
		invalidParams.Add(request.NewErrParamRequired("Message"))
	}
	if s.Message != nil && len(s.Message) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Message", 1))
	}
	if s.Signature == nil {
		invalidParams.Add(request.NewErrParamRequired("Signature"))
	}
	if s.Signature != nil && len(s.Signature) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Signature", 1))
	}
	if s.SigningAlgorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("SigningAlgorithm"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrantTokens sets the GrantTokens field's value.
func (s *VerifyInput) SetGrantTokens(v []*string) *VerifyInput {
	s.GrantTokens = v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *VerifyInput) SetKeyId(v string) *VerifyInput {
	s.KeyId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *VerifyInput) SetMessage(v []byte) *VerifyInput {
	s.Message = v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *VerifyInput) SetMessageType(v string) *VerifyInput {
	s.MessageType = &v
	return s
}

// SetSignature sets the Signature field's value.
func (s *VerifyInput) SetSignature(v []byte) *VerifyInput {
	s.Signature = v
	return s
}

// SetSigningAlgorithm sets the SigningAlgorithm field's value.
func (s *VerifyInput) SetSigningAlgorithm(v string) *VerifyInput {
	s.SigningAlgorithm = &v
	return s
}

type VerifyMacInput struct {
	_ struct{} `type:"structure"`

	// A list of grant tokens.
	//
	// Use a grant token when your permission to call this operation comes from
	// a new grant that has not yet achieved eventual consistency. For more information,
	// see Grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
	// and Using a grant token (https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
	// in the Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// The KMS key that will be used in the verification.
	//
	// Enter a key ID of the KMS key that was used to generate the HMAC. If you
	// identify a different KMS key, the VerifyMac operation fails.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// The HMAC to verify. Enter the HMAC that was generated by the GenerateMac
	// operation when you specified the same message, HMAC KMS key, and MAC algorithm
	// as the values specified in this request.
	// Mac is automatically base64 encoded/decoded by the SDK.
	//
	// Mac is a required field
	Mac []byte `min:"1" type:"blob" required:"true"`

	// The MAC algorithm that will be used in the verification. Enter the same MAC
	// algorithm that was used to compute the HMAC. This algorithm must be supported
	// by the HMAC KMS key identified by the KeyId parameter.
	//
	// MacAlgorithm is a required field
	MacAlgorithm *string `type:"string" required:"true" enum:"MacAlgorithmSpec"`

	// The message that will be used in the verification. Enter the same message
	// that was used to generate the HMAC.
	//
	// GenerateMac and VerifyMac do not provide special handling for message digests.
	// If you generated an HMAC for a hash digest of a message, you must verify
	// the HMAC for the same hash digest.
	//
	// Message is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by VerifyMacInput's
	// String and GoString methods.
	//
	// Message is automatically base64 encoded/decoded by the SDK.
	//
	// Message is a required field
	Message []byte `min:"1" type:"blob" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyMacInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyMacInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerifyMacInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VerifyMacInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.Mac == nil {
		invalidParams.Add(request.NewErrParamRequired("Mac"))
	}
	if s.Mac != nil && len(s.Mac) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Mac", 1))
	}
	if s.MacAlgorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("MacAlgorithm"))
	}
	if s.Message == nil {
		invalidParams.Add(request.NewErrParamRequired("Message"))
	}
	if s.Message != nil && len(s.Message) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Message", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrantTokens sets the GrantTokens field's value.
func (s *VerifyMacInput) SetGrantTokens(v []*string) *VerifyMacInput {
	s.GrantTokens = v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *VerifyMacInput) SetKeyId(v string) *VerifyMacInput {
	s.KeyId = &v
	return s
}

// SetMac sets the Mac field's value.
func (s *VerifyMacInput) SetMac(v []byte) *VerifyMacInput {
	s.Mac = v
	return s
}

// SetMacAlgorithm sets the MacAlgorithm field's value.
func (s *VerifyMacInput) SetMacAlgorithm(v string) *VerifyMacInput {
	s.MacAlgorithm = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *VerifyMacInput) SetMessage(v []byte) *VerifyMacInput {
	s.Message = v
	return s
}

type VerifyMacOutput struct {
	_ struct{} `type:"structure"`

	// The HMAC KMS key used in the verification.
	KeyId *string `min:"1" type:"string"`

	// The MAC algorithm used in the verification.
	MacAlgorithm *string `type:"string" enum:"MacAlgorithmSpec"`

	// A Boolean value that indicates whether the HMAC was verified. A value of
	// True indicates that the HMAC (Mac) was generated with the specified Message,
	// HMAC KMS key (KeyID) and MacAlgorithm..
	//
	// If the HMAC is not verified, the VerifyMac operation fails with a KMSInvalidMacException
	// exception. This exception indicates that one or more of the inputs changed
	// since the HMAC was computed.
	MacValid *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyMacOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyMacOutput) GoString() string {
	return s.String()
}

// SetKeyId sets the KeyId field's value.
func (s *VerifyMacOutput) SetKeyId(v string) *VerifyMacOutput {
	s.KeyId = &v
	return s
}

// SetMacAlgorithm sets the MacAlgorithm field's value.
func (s *VerifyMacOutput) SetMacAlgorithm(v string) *VerifyMacOutput {
	s.MacAlgorithm = &v
	return s
}

// SetMacValid sets the MacValid field's value.
func (s *VerifyMacOutput) SetMacValid(v bool) *VerifyMacOutput {
	s.MacValid = &v
	return s
}

type VerifyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (key ARN (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN))
	// of the asymmetric KMS key that was used to verify the signature.
	KeyId *string `min:"1" type:"string"`

	// A Boolean value that indicates whether the signature was verified. A value
	// of True indicates that the Signature was produced by signing the Message
	// with the specified KeyID and SigningAlgorithm. If the signature is not verified,
	// the Verify operation fails with a KMSInvalidSignatureException exception.
	SignatureValid *bool `type:"boolean"`

	// The signing algorithm that was used to verify the signature.
	SigningAlgorithm *string `type:"string" enum:"SigningAlgorithmSpec"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyOutput) GoString() string {
	return s.String()
}

// SetKeyId sets the KeyId field's value.
func (s *VerifyOutput) SetKeyId(v string) *VerifyOutput {
	s.KeyId = &v
	return s
}

// SetSignatureValid sets the SignatureValid field's value.
func (s *VerifyOutput) SetSignatureValid(v bool) *VerifyOutput {
	s.SignatureValid = &v
	return s
}

// SetSigningAlgorithm sets the SigningAlgorithm field's value.
func (s *VerifyOutput) SetSigningAlgorithm(v string) *VerifyOutput {
	s.SigningAlgorithm = &v
	return s
}

// The request was rejected because the (XksKeyId) is already associated with
// a KMS key in this external key store. Each KMS key in an external key store
// must be associated with a different external key.
type XksKeyAlreadyInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksKeyAlreadyInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksKeyAlreadyInUseException) GoString() string {
	return s.String()
}

func newErrorXksKeyAlreadyInUseException(v protocol.ResponseMetadata) error {
	return &XksKeyAlreadyInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *XksKeyAlreadyInUseException) Code() string {
	return "XksKeyAlreadyInUseException"
}

// Message returns the exception's message.
func (s *XksKeyAlreadyInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *XksKeyAlreadyInUseException) OrigErr() error {
	return nil
}

func (s *XksKeyAlreadyInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *XksKeyAlreadyInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *XksKeyAlreadyInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about the external key (https://docs.aws.amazon.com/kms/latest/developerguide/keystore-external.html#concept-external-key)that
// is associated with a KMS key in an external key store.
//
// This element appears in a CreateKey or DescribeKey response only for a KMS
// key in an external key store.
//
// The external key is a symmetric encryption key that is hosted by an external
// key manager outside of Amazon Web Services. When you use the KMS key in an
// external key store in a cryptographic operation, the cryptographic operation
// is performed in the external key manager using the specified external key.
// For more information, see External key (https://docs.aws.amazon.com/kms/latest/developerguide/keystore-external.html#concept-external-key)
// in the Key Management Service Developer Guide.
type XksKeyConfigurationType struct {
	_ struct{} `type:"structure"`

	// The ID of the external key in its external key manager. This is the ID that
	// the external key store proxy uses to identify the external key.
	Id *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksKeyConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksKeyConfigurationType) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *XksKeyConfigurationType) SetId(v string) *XksKeyConfigurationType {
	s.Id = &v
	return s
}

// The request was rejected because the external key specified by the XksKeyId
// parameter did not meet the configuration requirements for an external key
// store.
//
// The external key must be an AES-256 symmetric key that is enabled and performs
// encryption and decryption.
type XksKeyInvalidConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksKeyInvalidConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksKeyInvalidConfigurationException) GoString() string {
	return s.String()
}

func newErrorXksKeyInvalidConfigurationException(v protocol.ResponseMetadata) error {
	return &XksKeyInvalidConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *XksKeyInvalidConfigurationException) Code() string {
	return "XksKeyInvalidConfigurationException"
}

// Message returns the exception's message.
func (s *XksKeyInvalidConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *XksKeyInvalidConfigurationException) OrigErr() error {
	return nil
}

func (s *XksKeyInvalidConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *XksKeyInvalidConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *XksKeyInvalidConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because the external key store proxy could not find
// the external key. This exception is thrown when the value of the XksKeyId
// parameter doesn't identify a key in the external key manager associated with
// the external key proxy.
//
// Verify that the XksKeyId represents an existing key in the external key manager.
// Use the key identifier that the external key store proxy uses to identify
// the key. For details, see the documentation provided with your external key
// store proxy or key manager.
type XksKeyNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksKeyNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksKeyNotFoundException) GoString() string {
	return s.String()
}

func newErrorXksKeyNotFoundException(v protocol.ResponseMetadata) error {
	return &XksKeyNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *XksKeyNotFoundException) Code() string {
	return "XksKeyNotFoundException"
}

// Message returns the exception's message.
func (s *XksKeyNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *XksKeyNotFoundException) OrigErr() error {
	return nil
}

func (s *XksKeyNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *XksKeyNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *XksKeyNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// KMS uses the authentication credential to sign requests that it sends to
// the external key store proxy (XKS proxy) on your behalf. You establish these
// credentials on your external key store proxy and report them to KMS.
//
// The XksProxyAuthenticationCredential includes two required elements.
type XksProxyAuthenticationCredentialType struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the raw secret access key.
	//
	// AccessKeyId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by XksProxyAuthenticationCredentialType's
	// String and GoString methods.
	//
	// AccessKeyId is a required field
	AccessKeyId *string `min:"20" type:"string" required:"true" sensitive:"true"`

	// A secret string of 43-64 characters. Valid characters are a-z, A-Z, 0-9,
	// /, +, and =.
	//
	// RawSecretAccessKey is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by XksProxyAuthenticationCredentialType's
	// String and GoString methods.
	//
	// RawSecretAccessKey is a required field
	RawSecretAccessKey *string `min:"43" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksProxyAuthenticationCredentialType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksProxyAuthenticationCredentialType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *XksProxyAuthenticationCredentialType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "XksProxyAuthenticationCredentialType"}
	if s.AccessKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessKeyId"))
	}
	if s.AccessKeyId != nil && len(*s.AccessKeyId) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("AccessKeyId", 20))
	}
	if s.RawSecretAccessKey == nil {
		invalidParams.Add(request.NewErrParamRequired("RawSecretAccessKey"))
	}
	if s.RawSecretAccessKey != nil && len(*s.RawSecretAccessKey) < 43 {
		invalidParams.Add(request.NewErrParamMinLen("RawSecretAccessKey", 43))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *XksProxyAuthenticationCredentialType) SetAccessKeyId(v string) *XksProxyAuthenticationCredentialType {
	s.AccessKeyId = &v
	return s
}

// SetRawSecretAccessKey sets the RawSecretAccessKey field's value.
func (s *XksProxyAuthenticationCredentialType) SetRawSecretAccessKey(v string) *XksProxyAuthenticationCredentialType {
	s.RawSecretAccessKey = &v
	return s
}

// Detailed information about the external key store proxy (XKS proxy). Your
// external key store proxy translates KMS requests into a format that your
// external key manager can understand. These fields appear in a DescribeCustomKeyStores
// response only when the CustomKeyStoreType is EXTERNAL_KEY_STORE.
type XksProxyConfigurationType struct {
	_ struct{} `type:"structure"`

	// The part of the external key store proxy authentication credential (https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateCustomKeyStore.html#KMS-CreateCustomKeyStore-request-XksProxyAuthenticationCredential)
	// that uniquely identifies the secret access key.
	//
	// AccessKeyId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by XksProxyConfigurationType's
	// String and GoString methods.
	AccessKeyId *string `min:"20" type:"string" sensitive:"true"`

	// Indicates whether the external key store proxy uses a public endpoint or
	// an Amazon VPC endpoint service to communicate with KMS.
	Connectivity *string `type:"string" enum:"XksProxyConnectivityType"`

	// The URI endpoint for the external key store proxy.
	//
	// If the external key store proxy has a public endpoint, it is displayed here.
	//
	// If the external key store proxy uses an Amazon VPC endpoint service name,
	// this field displays the private DNS name associated with the VPC endpoint
	// service.
	UriEndpoint *string `min:"10" type:"string"`

	// The path to the external key store proxy APIs.
	UriPath *string `min:"10" type:"string"`

	// The Amazon VPC endpoint service used to communicate with the external key
	// store proxy. This field appears only when the external key store proxy uses
	// an Amazon VPC endpoint service to communicate with KMS.
	VpcEndpointServiceName *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksProxyConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksProxyConfigurationType) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *XksProxyConfigurationType) SetAccessKeyId(v string) *XksProxyConfigurationType {
	s.AccessKeyId = &v
	return s
}

// SetConnectivity sets the Connectivity field's value.
func (s *XksProxyConfigurationType) SetConnectivity(v string) *XksProxyConfigurationType {
	s.Connectivity = &v
	return s
}

// SetUriEndpoint sets the UriEndpoint field's value.
func (s *XksProxyConfigurationType) SetUriEndpoint(v string) *XksProxyConfigurationType {
	s.UriEndpoint = &v
	return s
}

// SetUriPath sets the UriPath field's value.
func (s *XksProxyConfigurationType) SetUriPath(v string) *XksProxyConfigurationType {
	s.UriPath = &v
	return s
}

// SetVpcEndpointServiceName sets the VpcEndpointServiceName field's value.
func (s *XksProxyConfigurationType) SetVpcEndpointServiceName(v string) *XksProxyConfigurationType {
	s.VpcEndpointServiceName = &v
	return s
}

// The request was rejected because the proxy credentials failed to authenticate
// to the specified external key store proxy. The specified external key store
// proxy rejected a status request from KMS due to invalid credentials. This
// can indicate an error in the credentials or in the identification of the
// external key store proxy.
type XksProxyIncorrectAuthenticationCredentialException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksProxyIncorrectAuthenticationCredentialException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksProxyIncorrectAuthenticationCredentialException) GoString() string {
	return s.String()
}

func newErrorXksProxyIncorrectAuthenticationCredentialException(v protocol.ResponseMetadata) error {
	return &XksProxyIncorrectAuthenticationCredentialException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *XksProxyIncorrectAuthenticationCredentialException) Code() string {
	return "XksProxyIncorrectAuthenticationCredentialException"
}

// Message returns the exception's message.
func (s *XksProxyIncorrectAuthenticationCredentialException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *XksProxyIncorrectAuthenticationCredentialException) OrigErr() error {
	return nil
}

func (s *XksProxyIncorrectAuthenticationCredentialException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *XksProxyIncorrectAuthenticationCredentialException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *XksProxyIncorrectAuthenticationCredentialException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because the Amazon VPC endpoint service configuration
// does not fulfill the requirements for an external key store proxy. For details,
// see the exception message.
type XksProxyInvalidConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksProxyInvalidConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksProxyInvalidConfigurationException) GoString() string {
	return s.String()
}

func newErrorXksProxyInvalidConfigurationException(v protocol.ResponseMetadata) error {
	return &XksProxyInvalidConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *XksProxyInvalidConfigurationException) Code() string {
	return "XksProxyInvalidConfigurationException"
}

// Message returns the exception's message.
func (s *XksProxyInvalidConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *XksProxyInvalidConfigurationException) OrigErr() error {
	return nil
}

func (s *XksProxyInvalidConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *XksProxyInvalidConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *XksProxyInvalidConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// KMS cannot interpret the response it received from the external key store
// proxy. The problem might be a poorly constructed response, but it could also
// be a transient network issue. If you see this error repeatedly, report it
// to the proxy vendor.
type XksProxyInvalidResponseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksProxyInvalidResponseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksProxyInvalidResponseException) GoString() string {
	return s.String()
}

func newErrorXksProxyInvalidResponseException(v protocol.ResponseMetadata) error {
	return &XksProxyInvalidResponseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *XksProxyInvalidResponseException) Code() string {
	return "XksProxyInvalidResponseException"
}

// Message returns the exception's message.
func (s *XksProxyInvalidResponseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *XksProxyInvalidResponseException) OrigErr() error {
	return nil
}

func (s *XksProxyInvalidResponseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *XksProxyInvalidResponseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *XksProxyInvalidResponseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because the concatenation of the XksProxyUriEndpoint
// is already associated with an external key store in the Amazon Web Services
// account and Region. Each external key store in an account and Region must
// use a unique external key store proxy address.
type XksProxyUriEndpointInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksProxyUriEndpointInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksProxyUriEndpointInUseException) GoString() string {
	return s.String()
}

func newErrorXksProxyUriEndpointInUseException(v protocol.ResponseMetadata) error {
	return &XksProxyUriEndpointInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *XksProxyUriEndpointInUseException) Code() string {
	return "XksProxyUriEndpointInUseException"
}

// Message returns the exception's message.
func (s *XksProxyUriEndpointInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *XksProxyUriEndpointInUseException) OrigErr() error {
	return nil
}

func (s *XksProxyUriEndpointInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *XksProxyUriEndpointInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *XksProxyUriEndpointInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because the concatenation of the XksProxyUriEndpoint
// and XksProxyUriPath is already associated with an external key store in the
// Amazon Web Services account and Region. Each external key store in an account
// and Region must use a unique external key store proxy API address.
type XksProxyUriInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksProxyUriInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksProxyUriInUseException) GoString() string {
	return s.String()
}

func newErrorXksProxyUriInUseException(v protocol.ResponseMetadata) error {
	return &XksProxyUriInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *XksProxyUriInUseException) Code() string {
	return "XksProxyUriInUseException"
}

// Message returns the exception's message.
func (s *XksProxyUriInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *XksProxyUriInUseException) OrigErr() error {
	return nil
}

func (s *XksProxyUriInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *XksProxyUriInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *XksProxyUriInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// KMS was unable to reach the specified XksProxyUriPath. The path must be reachable
// before you create the external key store or update its settings.
//
// This exception is also thrown when the external key store proxy response
// to a GetHealthStatus request indicates that all external key manager instances
// are unavailable.
type XksProxyUriUnreachableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksProxyUriUnreachableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksProxyUriUnreachableException) GoString() string {
	return s.String()
}

func newErrorXksProxyUriUnreachableException(v protocol.ResponseMetadata) error {
	return &XksProxyUriUnreachableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *XksProxyUriUnreachableException) Code() string {
	return "XksProxyUriUnreachableException"
}

// Message returns the exception's message.
func (s *XksProxyUriUnreachableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *XksProxyUriUnreachableException) OrigErr() error {
	return nil
}

func (s *XksProxyUriUnreachableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *XksProxyUriUnreachableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *XksProxyUriUnreachableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because the specified Amazon VPC endpoint service
// is already associated with an external key store in the Amazon Web Services
// account and Region. Each external key store in an Amazon Web Services account
// and Region must use a different Amazon VPC endpoint service.
type XksProxyVpcEndpointServiceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksProxyVpcEndpointServiceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksProxyVpcEndpointServiceInUseException) GoString() string {
	return s.String()
}

func newErrorXksProxyVpcEndpointServiceInUseException(v protocol.ResponseMetadata) error {
	return &XksProxyVpcEndpointServiceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *XksProxyVpcEndpointServiceInUseException) Code() string {
	return "XksProxyVpcEndpointServiceInUseException"
}

// Message returns the exception's message.
func (s *XksProxyVpcEndpointServiceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *XksProxyVpcEndpointServiceInUseException) OrigErr() error {
	return nil
}

func (s *XksProxyVpcEndpointServiceInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *XksProxyVpcEndpointServiceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *XksProxyVpcEndpointServiceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because the Amazon VPC endpoint service configuration
// does not fulfill the requirements for an external key store proxy. For details,
// see the exception message and review the requirements (kms/latest/developerguide/vpc-connectivity.html#xks-vpc-requirements)
// for Amazon VPC endpoint service connectivity for an external key store.
type XksProxyVpcEndpointServiceInvalidConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksProxyVpcEndpointServiceInvalidConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksProxyVpcEndpointServiceInvalidConfigurationException) GoString() string {
	return s.String()
}

func newErrorXksProxyVpcEndpointServiceInvalidConfigurationException(v protocol.ResponseMetadata) error {
	return &XksProxyVpcEndpointServiceInvalidConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *XksProxyVpcEndpointServiceInvalidConfigurationException) Code() string {
	return "XksProxyVpcEndpointServiceInvalidConfigurationException"
}

// Message returns the exception's message.
func (s *XksProxyVpcEndpointServiceInvalidConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *XksProxyVpcEndpointServiceInvalidConfigurationException) OrigErr() error {
	return nil
}

func (s *XksProxyVpcEndpointServiceInvalidConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *XksProxyVpcEndpointServiceInvalidConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *XksProxyVpcEndpointServiceInvalidConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because KMS could not find the specified VPC endpoint
// service. Use DescribeCustomKeyStores to verify the VPC endpoint service name
// for the external key store. Also, confirm that the Allow principals list
// for the VPC endpoint service includes the KMS service principal for the Region,
// such as cks.kms.us-east-1.amazonaws.com.
type XksProxyVpcEndpointServiceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksProxyVpcEndpointServiceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s XksProxyVpcEndpointServiceNotFoundException) GoString() string {
	return s.String()
}

func newErrorXksProxyVpcEndpointServiceNotFoundException(v protocol.ResponseMetadata) error {
	return &XksProxyVpcEndpointServiceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *XksProxyVpcEndpointServiceNotFoundException) Code() string {
	return "XksProxyVpcEndpointServiceNotFoundException"
}

// Message returns the exception's message.
func (s *XksProxyVpcEndpointServiceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *XksProxyVpcEndpointServiceNotFoundException) OrigErr() error {
	return nil
}

func (s *XksProxyVpcEndpointServiceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *XksProxyVpcEndpointServiceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *XksProxyVpcEndpointServiceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// AlgorithmSpecRsaesPkcs1V15 is a AlgorithmSpec enum value
	AlgorithmSpecRsaesPkcs1V15 = "RSAES_PKCS1_V1_5"

	// AlgorithmSpecRsaesOaepSha1 is a AlgorithmSpec enum value
	AlgorithmSpecRsaesOaepSha1 = "RSAES_OAEP_SHA_1"

	// AlgorithmSpecRsaesOaepSha256 is a AlgorithmSpec enum value
	AlgorithmSpecRsaesOaepSha256 = "RSAES_OAEP_SHA_256"
)

// AlgorithmSpec_Values returns all elements of the AlgorithmSpec enum
func AlgorithmSpec_Values() []string {
	return []string{
		AlgorithmSpecRsaesPkcs1V15,
		AlgorithmSpecRsaesOaepSha1,
		AlgorithmSpecRsaesOaepSha256,
	}
}

const (
	// ConnectionErrorCodeTypeInvalidCredentials is a ConnectionErrorCodeType enum value
	ConnectionErrorCodeTypeInvalidCredentials = "INVALID_CREDENTIALS"

	// ConnectionErrorCodeTypeClusterNotFound is a ConnectionErrorCodeType enum value
	ConnectionErrorCodeTypeClusterNotFound = "CLUSTER_NOT_FOUND"

	// ConnectionErrorCodeTypeNetworkErrors is a ConnectionErrorCodeType enum value
	ConnectionErrorCodeTypeNetworkErrors = "NETWORK_ERRORS"

	// ConnectionErrorCodeTypeInternalError is a ConnectionErrorCodeType enum value
	ConnectionErrorCodeTypeInternalError = "INTERNAL_ERROR"

	// ConnectionErrorCodeTypeInsufficientCloudhsmHsms is a ConnectionErrorCodeType enum value
	ConnectionErrorCodeTypeInsufficientCloudhsmHsms = "INSUFFICIENT_CLOUDHSM_HSMS"

	// ConnectionErrorCodeTypeUserLockedOut is a ConnectionErrorCodeType enum value
	ConnectionErrorCodeTypeUserLockedOut = "USER_LOCKED_OUT"

	// ConnectionErrorCodeTypeUserNotFound is a ConnectionErrorCodeType enum value
	ConnectionErrorCodeTypeUserNotFound = "USER_NOT_FOUND"

	// ConnectionErrorCodeTypeUserLoggedIn is a ConnectionErrorCodeType enum value
	ConnectionErrorCodeTypeUserLoggedIn = "USER_LOGGED_IN"

	// ConnectionErrorCodeTypeSubnetNotFound is a ConnectionErrorCodeType enum value
	ConnectionErrorCodeTypeSubnetNotFound = "SUBNET_NOT_FOUND"

	// ConnectionErrorCodeTypeInsufficientFreeAddressesInSubnet is a ConnectionErrorCodeType enum value
	ConnectionErrorCodeTypeInsufficientFreeAddressesInSubnet = "INSUFFICIENT_FREE_ADDRESSES_IN_SUBNET"

	// ConnectionErrorCodeTypeXksProxyAccessDenied is a ConnectionErrorCodeType enum value
	ConnectionErrorCodeTypeXksProxyAccessDenied = "XKS_PROXY_ACCESS_DENIED"

	// ConnectionErrorCodeTypeXksProxyNotReachable is a ConnectionErrorCodeType enum value
	ConnectionErrorCodeTypeXksProxyNotReachable = "XKS_PROXY_NOT_REACHABLE"

	// ConnectionErrorCodeTypeXksVpcEndpointServiceNotFound is a ConnectionErrorCodeType enum value
	ConnectionErrorCodeTypeXksVpcEndpointServiceNotFound = "XKS_VPC_ENDPOINT_SERVICE_NOT_FOUND"

	// ConnectionErrorCodeTypeXksProxyInvalidResponse is a ConnectionErrorCodeType enum value
	ConnectionErrorCodeTypeXksProxyInvalidResponse = "XKS_PROXY_INVALID_RESPONSE"

	// ConnectionErrorCodeTypeXksProxyInvalidConfiguration is a ConnectionErrorCodeType enum value
	ConnectionErrorCodeTypeXksProxyInvalidConfiguration = "XKS_PROXY_INVALID_CONFIGURATION"

	// ConnectionErrorCodeTypeXksVpcEndpointServiceInvalidConfiguration is a ConnectionErrorCodeType enum value
	ConnectionErrorCodeTypeXksVpcEndpointServiceInvalidConfiguration = "XKS_VPC_ENDPOINT_SERVICE_INVALID_CONFIGURATION"

	// ConnectionErrorCodeTypeXksProxyTimedOut is a ConnectionErrorCodeType enum value
	ConnectionErrorCodeTypeXksProxyTimedOut = "XKS_PROXY_TIMED_OUT"

	// ConnectionErrorCodeTypeXksProxyInvalidTlsConfiguration is a ConnectionErrorCodeType enum value
	ConnectionErrorCodeTypeXksProxyInvalidTlsConfiguration = "XKS_PROXY_INVALID_TLS_CONFIGURATION"
)

// ConnectionErrorCodeType_Values returns all elements of the ConnectionErrorCodeType enum
func ConnectionErrorCodeType_Values() []string {
	return []string{
		ConnectionErrorCodeTypeInvalidCredentials,
		ConnectionErrorCodeTypeClusterNotFound,
		ConnectionErrorCodeTypeNetworkErrors,
		ConnectionErrorCodeTypeInternalError,
		ConnectionErrorCodeTypeInsufficientCloudhsmHsms,
		ConnectionErrorCodeTypeUserLockedOut,
		ConnectionErrorCodeTypeUserNotFound,
		ConnectionErrorCodeTypeUserLoggedIn,
		ConnectionErrorCodeTypeSubnetNotFound,
		ConnectionErrorCodeTypeInsufficientFreeAddressesInSubnet,
		ConnectionErrorCodeTypeXksProxyAccessDenied,
		ConnectionErrorCodeTypeXksProxyNotReachable,
		ConnectionErrorCodeTypeXksVpcEndpointServiceNotFound,
		ConnectionErrorCodeTypeXksProxyInvalidResponse,
		ConnectionErrorCodeTypeXksProxyInvalidConfiguration,
		ConnectionErrorCodeTypeXksVpcEndpointServiceInvalidConfiguration,
		ConnectionErrorCodeTypeXksProxyTimedOut,
		ConnectionErrorCodeTypeXksProxyInvalidTlsConfiguration,
	}
}

const (
	// ConnectionStateTypeConnected is a ConnectionStateType enum value
	ConnectionStateTypeConnected = "CONNECTED"

	// ConnectionStateTypeConnecting is a ConnectionStateType enum value
	ConnectionStateTypeConnecting = "CONNECTING"

	// ConnectionStateTypeFailed is a ConnectionStateType enum value
	ConnectionStateTypeFailed = "FAILED"

	// ConnectionStateTypeDisconnected is a ConnectionStateType enum value
	ConnectionStateTypeDisconnected = "DISCONNECTED"

	// ConnectionStateTypeDisconnecting is a ConnectionStateType enum value
	ConnectionStateTypeDisconnecting = "DISCONNECTING"
)

// ConnectionStateType_Values returns all elements of the ConnectionStateType enum
func ConnectionStateType_Values() []string {
	return []string{
		ConnectionStateTypeConnected,
		ConnectionStateTypeConnecting,
		ConnectionStateTypeFailed,
		ConnectionStateTypeDisconnected,
		ConnectionStateTypeDisconnecting,
	}
}

const (
	// CustomKeyStoreTypeAwsCloudhsm is a CustomKeyStoreType enum value
	CustomKeyStoreTypeAwsCloudhsm = "AWS_CLOUDHSM"

	// CustomKeyStoreTypeExternalKeyStore is a CustomKeyStoreType enum value
	CustomKeyStoreTypeExternalKeyStore = "EXTERNAL_KEY_STORE"
)

// CustomKeyStoreType_Values returns all elements of the CustomKeyStoreType enum
func CustomKeyStoreType_Values() []string {
	return []string{
		CustomKeyStoreTypeAwsCloudhsm,
		CustomKeyStoreTypeExternalKeyStore,
	}
}

const (
	// CustomerMasterKeySpecRsa2048 is a CustomerMasterKeySpec enum value
	CustomerMasterKeySpecRsa2048 = "RSA_2048"

	// CustomerMasterKeySpecRsa3072 is a CustomerMasterKeySpec enum value
	CustomerMasterKeySpecRsa3072 = "RSA_3072"

	// CustomerMasterKeySpecRsa4096 is a CustomerMasterKeySpec enum value
	CustomerMasterKeySpecRsa4096 = "RSA_4096"

	// CustomerMasterKeySpecEccNistP256 is a CustomerMasterKeySpec enum value
	CustomerMasterKeySpecEccNistP256 = "ECC_NIST_P256"

	// CustomerMasterKeySpecEccNistP384 is a CustomerMasterKeySpec enum value
	CustomerMasterKeySpecEccNistP384 = "ECC_NIST_P384"

	// CustomerMasterKeySpecEccNistP521 is a CustomerMasterKeySpec enum value
	CustomerMasterKeySpecEccNistP521 = "ECC_NIST_P521"

	// CustomerMasterKeySpecEccSecgP256k1 is a CustomerMasterKeySpec enum value
	CustomerMasterKeySpecEccSecgP256k1 = "ECC_SECG_P256K1"

	// CustomerMasterKeySpecSymmetricDefault is a CustomerMasterKeySpec enum value
	CustomerMasterKeySpecSymmetricDefault = "SYMMETRIC_DEFAULT"

	// CustomerMasterKeySpecHmac224 is a CustomerMasterKeySpec enum value
	CustomerMasterKeySpecHmac224 = "HMAC_224"

	// CustomerMasterKeySpecHmac256 is a CustomerMasterKeySpec enum value
	CustomerMasterKeySpecHmac256 = "HMAC_256"

	// CustomerMasterKeySpecHmac384 is a CustomerMasterKeySpec enum value
	CustomerMasterKeySpecHmac384 = "HMAC_384"

	// CustomerMasterKeySpecHmac512 is a CustomerMasterKeySpec enum value
	CustomerMasterKeySpecHmac512 = "HMAC_512"

	// CustomerMasterKeySpecSm2 is a CustomerMasterKeySpec enum value
	CustomerMasterKeySpecSm2 = "SM2"
)

// CustomerMasterKeySpec_Values returns all elements of the CustomerMasterKeySpec enum
func CustomerMasterKeySpec_Values() []string {
	return []string{
		CustomerMasterKeySpecRsa2048,
		CustomerMasterKeySpecRsa3072,
		CustomerMasterKeySpecRsa4096,
		CustomerMasterKeySpecEccNistP256,
		CustomerMasterKeySpecEccNistP384,
		CustomerMasterKeySpecEccNistP521,
		CustomerMasterKeySpecEccSecgP256k1,
		CustomerMasterKeySpecSymmetricDefault,
		CustomerMasterKeySpecHmac224,
		CustomerMasterKeySpecHmac256,
		CustomerMasterKeySpecHmac384,
		CustomerMasterKeySpecHmac512,
		CustomerMasterKeySpecSm2,
	}
}

const (
	// DataKeyPairSpecRsa2048 is a DataKeyPairSpec enum value
	DataKeyPairSpecRsa2048 = "RSA_2048"

	// DataKeyPairSpecRsa3072 is a DataKeyPairSpec enum value
	DataKeyPairSpecRsa3072 = "RSA_3072"

	// DataKeyPairSpecRsa4096 is a DataKeyPairSpec enum value
	DataKeyPairSpecRsa4096 = "RSA_4096"

	// DataKeyPairSpecEccNistP256 is a DataKeyPairSpec enum value
	DataKeyPairSpecEccNistP256 = "ECC_NIST_P256"

	// DataKeyPairSpecEccNistP384 is a DataKeyPairSpec enum value
	DataKeyPairSpecEccNistP384 = "ECC_NIST_P384"

	// DataKeyPairSpecEccNistP521 is a DataKeyPairSpec enum value
	DataKeyPairSpecEccNistP521 = "ECC_NIST_P521"

	// DataKeyPairSpecEccSecgP256k1 is a DataKeyPairSpec enum value
	DataKeyPairSpecEccSecgP256k1 = "ECC_SECG_P256K1"

	// DataKeyPairSpecSm2 is a DataKeyPairSpec enum value
	DataKeyPairSpecSm2 = "SM2"
)

// DataKeyPairSpec_Values returns all elements of the DataKeyPairSpec enum
func DataKeyPairSpec_Values() []string {
	return []string{
		DataKeyPairSpecRsa2048,
		DataKeyPairSpecRsa3072,
		DataKeyPairSpecRsa4096,
		DataKeyPairSpecEccNistP256,
		DataKeyPairSpecEccNistP384,
		DataKeyPairSpecEccNistP521,
		DataKeyPairSpecEccSecgP256k1,
		DataKeyPairSpecSm2,
	}
}

const (
	// DataKeySpecAes256 is a DataKeySpec enum value
	DataKeySpecAes256 = "AES_256"

	// DataKeySpecAes128 is a DataKeySpec enum value
	DataKeySpecAes128 = "AES_128"
)

// DataKeySpec_Values returns all elements of the DataKeySpec enum
func DataKeySpec_Values() []string {
	return []string{
		DataKeySpecAes256,
		DataKeySpecAes128,
	}
}

const (
	// EncryptionAlgorithmSpecSymmetricDefault is a EncryptionAlgorithmSpec enum value
	EncryptionAlgorithmSpecSymmetricDefault = "SYMMETRIC_DEFAULT"

	// EncryptionAlgorithmSpecRsaesOaepSha1 is a EncryptionAlgorithmSpec enum value
	EncryptionAlgorithmSpecRsaesOaepSha1 = "RSAES_OAEP_SHA_1"

	// EncryptionAlgorithmSpecRsaesOaepSha256 is a EncryptionAlgorithmSpec enum value
	EncryptionAlgorithmSpecRsaesOaepSha256 = "RSAES_OAEP_SHA_256"

	// EncryptionAlgorithmSpecSm2pke is a EncryptionAlgorithmSpec enum value
	EncryptionAlgorithmSpecSm2pke = "SM2PKE"
)

// EncryptionAlgorithmSpec_Values returns all elements of the EncryptionAlgorithmSpec enum
func EncryptionAlgorithmSpec_Values() []string {
	return []string{
		EncryptionAlgorithmSpecSymmetricDefault,
		EncryptionAlgorithmSpecRsaesOaepSha1,
		EncryptionAlgorithmSpecRsaesOaepSha256,
		EncryptionAlgorithmSpecSm2pke,
	}
}

const (
	// ExpirationModelTypeKeyMaterialExpires is a ExpirationModelType enum value
	ExpirationModelTypeKeyMaterialExpires = "KEY_MATERIAL_EXPIRES"

	// ExpirationModelTypeKeyMaterialDoesNotExpire is a ExpirationModelType enum value
	ExpirationModelTypeKeyMaterialDoesNotExpire = "KEY_MATERIAL_DOES_NOT_EXPIRE"
)

// ExpirationModelType_Values returns all elements of the ExpirationModelType enum
func ExpirationModelType_Values() []string {
	return []string{
		ExpirationModelTypeKeyMaterialExpires,
		ExpirationModelTypeKeyMaterialDoesNotExpire,
	}
}

const (
	// GrantOperationDecrypt is a GrantOperation enum value
	GrantOperationDecrypt = "Decrypt"

	// GrantOperationEncrypt is a GrantOperation enum value
	GrantOperationEncrypt = "Encrypt"

	// GrantOperationGenerateDataKey is a GrantOperation enum value
	GrantOperationGenerateDataKey = "GenerateDataKey"

	// GrantOperationGenerateDataKeyWithoutPlaintext is a GrantOperation enum value
	GrantOperationGenerateDataKeyWithoutPlaintext = "GenerateDataKeyWithoutPlaintext"

	// GrantOperationReEncryptFrom is a GrantOperation enum value
	GrantOperationReEncryptFrom = "ReEncryptFrom"

	// GrantOperationReEncryptTo is a GrantOperation enum value
	GrantOperationReEncryptTo = "ReEncryptTo"

	// GrantOperationSign is a GrantOperation enum value
	GrantOperationSign = "Sign"

	// GrantOperationVerify is a GrantOperation enum value
	GrantOperationVerify = "Verify"

	// GrantOperationGetPublicKey is a GrantOperation enum value
	GrantOperationGetPublicKey = "GetPublicKey"

	// GrantOperationCreateGrant is a GrantOperation enum value
	GrantOperationCreateGrant = "CreateGrant"

	// GrantOperationRetireGrant is a GrantOperation enum value
	GrantOperationRetireGrant = "RetireGrant"

	// GrantOperationDescribeKey is a GrantOperation enum value
	GrantOperationDescribeKey = "DescribeKey"

	// GrantOperationGenerateDataKeyPair is a GrantOperation enum value
	GrantOperationGenerateDataKeyPair = "GenerateDataKeyPair"

	// GrantOperationGenerateDataKeyPairWithoutPlaintext is a GrantOperation enum value
	GrantOperationGenerateDataKeyPairWithoutPlaintext = "GenerateDataKeyPairWithoutPlaintext"

	// GrantOperationGenerateMac is a GrantOperation enum value
	GrantOperationGenerateMac = "GenerateMac"

	// GrantOperationVerifyMac is a GrantOperation enum value
	GrantOperationVerifyMac = "VerifyMac"
)

// GrantOperation_Values returns all elements of the GrantOperation enum
func GrantOperation_Values() []string {
	return []string{
		GrantOperationDecrypt,
		GrantOperationEncrypt,
		GrantOperationGenerateDataKey,
		GrantOperationGenerateDataKeyWithoutPlaintext,
		GrantOperationReEncryptFrom,
		GrantOperationReEncryptTo,
		GrantOperationSign,
		GrantOperationVerify,
		GrantOperationGetPublicKey,
		GrantOperationCreateGrant,
		GrantOperationRetireGrant,
		GrantOperationDescribeKey,
		GrantOperationGenerateDataKeyPair,
		GrantOperationGenerateDataKeyPairWithoutPlaintext,
		GrantOperationGenerateMac,
		GrantOperationVerifyMac,
	}
}

const (
	// KeyManagerTypeAws is a KeyManagerType enum value
	KeyManagerTypeAws = "AWS"

	// KeyManagerTypeCustomer is a KeyManagerType enum value
	KeyManagerTypeCustomer = "CUSTOMER"
)

// KeyManagerType_Values returns all elements of the KeyManagerType enum
func KeyManagerType_Values() []string {
	return []string{
		KeyManagerTypeAws,
		KeyManagerTypeCustomer,
	}
}

const (
	// KeySpecRsa2048 is a KeySpec enum value
	KeySpecRsa2048 = "RSA_2048"

	// KeySpecRsa3072 is a KeySpec enum value
	KeySpecRsa3072 = "RSA_3072"

	// KeySpecRsa4096 is a KeySpec enum value
	KeySpecRsa4096 = "RSA_4096"

	// KeySpecEccNistP256 is a KeySpec enum value
	KeySpecEccNistP256 = "ECC_NIST_P256"

	// KeySpecEccNistP384 is a KeySpec enum value
	KeySpecEccNistP384 = "ECC_NIST_P384"

	// KeySpecEccNistP521 is a KeySpec enum value
	KeySpecEccNistP521 = "ECC_NIST_P521"

	// KeySpecEccSecgP256k1 is a KeySpec enum value
	KeySpecEccSecgP256k1 = "ECC_SECG_P256K1"

	// KeySpecSymmetricDefault is a KeySpec enum value
	KeySpecSymmetricDefault = "SYMMETRIC_DEFAULT"

	// KeySpecHmac224 is a KeySpec enum value
	KeySpecHmac224 = "HMAC_224"

	// KeySpecHmac256 is a KeySpec enum value
	KeySpecHmac256 = "HMAC_256"

	// KeySpecHmac384 is a KeySpec enum value
	KeySpecHmac384 = "HMAC_384"

	// KeySpecHmac512 is a KeySpec enum value
	KeySpecHmac512 = "HMAC_512"

	// KeySpecSm2 is a KeySpec enum value
	KeySpecSm2 = "SM2"
)

// KeySpec_Values returns all elements of the KeySpec enum
func KeySpec_Values() []string {
	return []string{
		KeySpecRsa2048,
		KeySpecRsa3072,
		KeySpecRsa4096,
		KeySpecEccNistP256,
		KeySpecEccNistP384,
		KeySpecEccNistP521,
		KeySpecEccSecgP256k1,
		KeySpecSymmetricDefault,
		KeySpecHmac224,
		KeySpecHmac256,
		KeySpecHmac384,
		KeySpecHmac512,
		KeySpecSm2,
	}
}

const (
	// KeyStateCreating is a KeyState enum value
	KeyStateCreating = "Creating"

	// KeyStateEnabled is a KeyState enum value
	KeyStateEnabled = "Enabled"

	// KeyStateDisabled is a KeyState enum value
	KeyStateDisabled = "Disabled"

	// KeyStatePendingDeletion is a KeyState enum value
	KeyStatePendingDeletion = "PendingDeletion"

	// KeyStatePendingImport is a KeyState enum value
	KeyStatePendingImport = "PendingImport"

	// KeyStatePendingReplicaDeletion is a KeyState enum value
	KeyStatePendingReplicaDeletion = "PendingReplicaDeletion"

	// KeyStateUnavailable is a KeyState enum value
	KeyStateUnavailable = "Unavailable"

	// KeyStateUpdating is a KeyState enum value
	KeyStateUpdating = "Updating"
)

// KeyState_Values returns all elements of the KeyState enum
func KeyState_Values() []string {
	return []string{
		KeyStateCreating,
		KeyStateEnabled,
		KeyStateDisabled,
		KeyStatePendingDeletion,
		KeyStatePendingImport,
		KeyStatePendingReplicaDeletion,
		KeyStateUnavailable,
		KeyStateUpdating,
	}
}

const (
	// KeyUsageTypeSignVerify is a KeyUsageType enum value
	KeyUsageTypeSignVerify = "SIGN_VERIFY"

	// KeyUsageTypeEncryptDecrypt is a KeyUsageType enum value
	KeyUsageTypeEncryptDecrypt = "ENCRYPT_DECRYPT"

	// KeyUsageTypeGenerateVerifyMac is a KeyUsageType enum value
	KeyUsageTypeGenerateVerifyMac = "GENERATE_VERIFY_MAC"
)

// KeyUsageType_Values returns all elements of the KeyUsageType enum
func KeyUsageType_Values() []string {
	return []string{
		KeyUsageTypeSignVerify,
		KeyUsageTypeEncryptDecrypt,
		KeyUsageTypeGenerateVerifyMac,
	}
}

const (
	// MacAlgorithmSpecHmacSha224 is a MacAlgorithmSpec enum value
	MacAlgorithmSpecHmacSha224 = "HMAC_SHA_224"

	// MacAlgorithmSpecHmacSha256 is a MacAlgorithmSpec enum value
	MacAlgorithmSpecHmacSha256 = "HMAC_SHA_256"

	// MacAlgorithmSpecHmacSha384 is a MacAlgorithmSpec enum value
	MacAlgorithmSpecHmacSha384 = "HMAC_SHA_384"

	// MacAlgorithmSpecHmacSha512 is a MacAlgorithmSpec enum value
	MacAlgorithmSpecHmacSha512 = "HMAC_SHA_512"
)

// MacAlgorithmSpec_Values returns all elements of the MacAlgorithmSpec enum
func MacAlgorithmSpec_Values() []string {
	return []string{
		MacAlgorithmSpecHmacSha224,
		MacAlgorithmSpecHmacSha256,
		MacAlgorithmSpecHmacSha384,
		MacAlgorithmSpecHmacSha512,
	}
}

const (
	// MessageTypeRaw is a MessageType enum value
	MessageTypeRaw = "RAW"

	// MessageTypeDigest is a MessageType enum value
	MessageTypeDigest = "DIGEST"
)

// MessageType_Values returns all elements of the MessageType enum
func MessageType_Values() []string {
	return []string{
		MessageTypeRaw,
		MessageTypeDigest,
	}
}

const (
	// MultiRegionKeyTypePrimary is a MultiRegionKeyType enum value
	MultiRegionKeyTypePrimary = "PRIMARY"

	// MultiRegionKeyTypeReplica is a MultiRegionKeyType enum value
	MultiRegionKeyTypeReplica = "REPLICA"
)

// MultiRegionKeyType_Values returns all elements of the MultiRegionKeyType enum
func MultiRegionKeyType_Values() []string {
	return []string{
		MultiRegionKeyTypePrimary,
		MultiRegionKeyTypeReplica,
	}
}

const (
	// OriginTypeAwsKms is a OriginType enum value
	OriginTypeAwsKms = "AWS_KMS"

	// OriginTypeExternal is a OriginType enum value
	OriginTypeExternal = "EXTERNAL"

	// OriginTypeAwsCloudhsm is a OriginType enum value
	OriginTypeAwsCloudhsm = "AWS_CLOUDHSM"

	// OriginTypeExternalKeyStore is a OriginType enum value
	OriginTypeExternalKeyStore = "EXTERNAL_KEY_STORE"
)

// OriginType_Values returns all elements of the OriginType enum
func OriginType_Values() []string {
	return []string{
		OriginTypeAwsKms,
		OriginTypeExternal,
		OriginTypeAwsCloudhsm,
		OriginTypeExternalKeyStore,
	}
}

const (
	// SigningAlgorithmSpecRsassaPssSha256 is a SigningAlgorithmSpec enum value
	SigningAlgorithmSpecRsassaPssSha256 = "RSASSA_PSS_SHA_256"

	// SigningAlgorithmSpecRsassaPssSha384 is a SigningAlgorithmSpec enum value
	SigningAlgorithmSpecRsassaPssSha384 = "RSASSA_PSS_SHA_384"

	// SigningAlgorithmSpecRsassaPssSha512 is a SigningAlgorithmSpec enum value
	SigningAlgorithmSpecRsassaPssSha512 = "RSASSA_PSS_SHA_512"

	// SigningAlgorithmSpecRsassaPkcs1V15Sha256 is a SigningAlgorithmSpec enum value
	SigningAlgorithmSpecRsassaPkcs1V15Sha256 = "RSASSA_PKCS1_V1_5_SHA_256"

	// SigningAlgorithmSpecRsassaPkcs1V15Sha384 is a SigningAlgorithmSpec enum value
	SigningAlgorithmSpecRsassaPkcs1V15Sha384 = "RSASSA_PKCS1_V1_5_SHA_384"

	// SigningAlgorithmSpecRsassaPkcs1V15Sha512 is a SigningAlgorithmSpec enum value
	SigningAlgorithmSpecRsassaPkcs1V15Sha512 = "RSASSA_PKCS1_V1_5_SHA_512"

	// SigningAlgorithmSpecEcdsaSha256 is a SigningAlgorithmSpec enum value
	SigningAlgorithmSpecEcdsaSha256 = "ECDSA_SHA_256"

	// SigningAlgorithmSpecEcdsaSha384 is a SigningAlgorithmSpec enum value
	SigningAlgorithmSpecEcdsaSha384 = "ECDSA_SHA_384"

	// SigningAlgorithmSpecEcdsaSha512 is a SigningAlgorithmSpec enum value
	SigningAlgorithmSpecEcdsaSha512 = "ECDSA_SHA_512"

	// SigningAlgorithmSpecSm2dsa is a SigningAlgorithmSpec enum value
	SigningAlgorithmSpecSm2dsa = "SM2DSA"
)

// SigningAlgorithmSpec_Values returns all elements of the SigningAlgorithmSpec enum
func SigningAlgorithmSpec_Values() []string {
	return []string{
		SigningAlgorithmSpecRsassaPssSha256,
		SigningAlgorithmSpecRsassaPssSha384,
		SigningAlgorithmSpecRsassaPssSha512,
		SigningAlgorithmSpecRsassaPkcs1V15Sha256,
		SigningAlgorithmSpecRsassaPkcs1V15Sha384,
		SigningAlgorithmSpecRsassaPkcs1V15Sha512,
		SigningAlgorithmSpecEcdsaSha256,
		SigningAlgorithmSpecEcdsaSha384,
		SigningAlgorithmSpecEcdsaSha512,
		SigningAlgorithmSpecSm2dsa,
	}
}

const (
	// WrappingKeySpecRsa2048 is a WrappingKeySpec enum value
	WrappingKeySpecRsa2048 = "RSA_2048"
)

// WrappingKeySpec_Values returns all elements of the WrappingKeySpec enum
func WrappingKeySpec_Values() []string {
	return []string{
		WrappingKeySpecRsa2048,
	}
}

const (
	// XksProxyConnectivityTypePublicEndpoint is a XksProxyConnectivityType enum value
	XksProxyConnectivityTypePublicEndpoint = "PUBLIC_ENDPOINT"

	// XksProxyConnectivityTypeVpcEndpointService is a XksProxyConnectivityType enum value
	XksProxyConnectivityTypeVpcEndpointService = "VPC_ENDPOINT_SERVICE"
)

// XksProxyConnectivityType_Values returns all elements of the XksProxyConnectivityType enum
func XksProxyConnectivityType_Values() []string {
	return []string{
		XksProxyConnectivityTypePublicEndpoint,
		XksProxyConnectivityTypeVpcEndpointService,
	}
}
