/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.inventory.impl.webconsole;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class ResourceBundleManager
implements BundleListener {
    private final BundleContext bundleContext;
    private final Map resourceBundleCaches;
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;

    public ResourceBundleManager(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.resourceBundleCaches = new HashMap();
        bundleContext.addBundleListener((BundleListener)this);
    }

    public void dispose() {
        this.bundleContext.removeBundleListener((BundleListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundle getResourceBundle(Bundle provider) {
        ResourceBundle cache;
        Long key = new Long(provider.getBundleId());
        Map map = this.resourceBundleCaches;
        synchronized (map) {
            cache = (ResourceBundle)this.resourceBundleCaches.get(key);
            if (cache == null && !this.resourceBundleCaches.containsKey(key)) {
                cache = this.loadResourceBundle(provider);
                this.resourceBundleCaches.put(key, cache);
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void bundleChanged(BundleEvent event) {
        if (event.getType() == 4) {
            Long key = new Long(event.getBundle().getBundleId());
            Map map = this.resourceBundleCaches;
            synchronized (map) {
                this.resourceBundleCaches.remove(key);
            }
        }
    }

    private ResourceBundle loadResourceBundle(Bundle bundle) {
        String path = "_" + DEFAULT_LOCALE.toString();
        URL source = (URL)this.getResourceBundleEntries(bundle).get(path);
        if (source != null) {
            try {
                return new PropertyResourceBundle(source.openStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private synchronized Map getResourceBundleEntries(Bundle bundle) {
        String file = (String)bundle.getHeaders().get("Bundle-Localization");
        if (file == null) {
            file = "OSGI-INF/l10n/bundle";
        }
        if (file.startsWith("/")) {
            file = file.substring(1);
        }
        int slash = file.lastIndexOf(47);
        String fileName = file.substring(slash + 1);
        String path = slash <= 0 ? "/" : file.substring(0, slash);
        HashMap<String, URL> resourceBundleEntries = new HashMap<String, URL>();
        Enumeration locales = bundle.findEntries(path, fileName + "*.properties", false);
        if (locales != null) {
            while (locales.hasMoreElements()) {
                int end;
                URL entry = (URL)locales.nextElement();
                String entryPath = entry.getPath();
                int start = entryPath.lastIndexOf(47) + 1 + fileName.length();
                if ((entryPath = entryPath.substring(start, end = entryPath.length() - 11)).length() == 0) {
                    entryPath = "_" + DEFAULT_LOCALE;
                }
                if (resourceBundleEntries.containsKey(entryPath)) continue;
                resourceBundleEntries.put(entryPath, entry);
            }
        }
        return resourceBundleEntries;
    }
}

