/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.net;

import java.time.Duration;
import org.signal.libsignal.internal.CalledFromNative;
import org.signal.libsignal.net.RegistrationException;

public class RegistrationLockException
extends RegistrationException {
    private Duration timeRemaining;
    private String svr2Username;
    private String svr2Password;

    @CalledFromNative
    private RegistrationLockException(long timeRemainingSeconds, String svr2Username, String svr2Password) {
        super("Registration lock is enabled");
        this.timeRemaining = Duration.ofSeconds(timeRemainingSeconds);
        this.svr2Username = svr2Username;
        this.svr2Password = svr2Password;
    }

    public Duration getTimeRemaining() {
        return this.timeRemaining;
    }

    public String getSvr2Username() {
        return this.svr2Username;
    }

    public String getSvr2Password() {
        return this.svr2Password;
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

