/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.ProvisioningCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.manager.ProvisioningManager;
import org.asamk.signal.manager.api.UserAlreadyExistsException;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.output.PlainTextWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkCommand
implements ProvisioningCommand {
    private static final Logger logger = LoggerFactory.getLogger(LinkCommand.class);

    @Override
    public String getName() {
        return "link";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Link to an existing device, instead of registering a new number.");
        subparser.addArgument(new String[]{"-n", "--name"}).help("Specify a name to describe this new device.");
    }

    @Override
    public void handleCommand(Namespace ns, ProvisioningManager m, OutputWriter outputWriter) throws CommandException {
        PlainTextWriter writer = (PlainTextWriter)outputWriter;
        String deviceName = ns.getString("name");
        if (deviceName == null) {
            deviceName = "cli";
        }
        try {
            writer.println("{}", m.getDeviceLinkUri());
            String number = m.finishDeviceLink(deviceName);
            writer.println("Associated with: {}", number);
        }
        catch (TimeoutException e) {
            throw new UserErrorException("Link request timed out, please try again.");
        }
        catch (IOException e) {
            throw new IOErrorException("Link request error: " + e.getMessage(), e);
        }
        catch (UserAlreadyExistsException e) {
            throw new UserErrorException("The user " + e.getNumber() + " already exists\nDelete \"" + String.valueOf(e.getFileName()) + "\" before trying again.");
        }
    }
}

