/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.payments;

import java.util.Locale;

public final class FormatterOptions {
    public final Locale locale;
    public final boolean alwaysPositive;
    public final boolean alwaysPrefixWithSign;
    public final boolean withSpaceBeforeUnit;
    public final boolean withUnit;
    public final int maximumFractionDigits;

    FormatterOptions(Builder builder) {
        this.locale = builder.locale;
        this.alwaysPositive = builder.alwaysPositive;
        this.alwaysPrefixWithSign = builder.alwaysPrefixWithSign;
        this.withSpaceBeforeUnit = builder.withSpaceBeforeUnit;
        this.withUnit = builder.withUnit;
        this.maximumFractionDigits = builder.maximumFractionDigits;
    }

    public static FormatterOptions defaults() {
        return FormatterOptions.builder().build();
    }

    public static FormatterOptions defaults(Locale locale) {
        return FormatterOptions.builder(locale).build();
    }

    public static Builder builder() {
        return FormatterOptions.builder(Locale.getDefault());
    }

    public static Builder builder(Locale locale) {
        return new Builder(locale);
    }

    public static final class Builder {
        private final Locale locale;
        private boolean alwaysPositive = false;
        private boolean alwaysPrefixWithSign = false;
        private boolean withSpaceBeforeUnit = true;
        private boolean withUnit = true;
        private int maximumFractionDigits = Integer.MAX_VALUE;

        private Builder(Locale locale) {
            this.locale = locale;
        }

        public Builder alwaysPositive() {
            this.alwaysPositive = true;
            return this;
        }

        public Builder alwaysPrefixWithSign() {
            this.alwaysPrefixWithSign = true;
            return this;
        }

        public Builder withoutSpaceBeforeUnit() {
            this.withSpaceBeforeUnit = false;
            return this;
        }

        public Builder withoutUnit() {
            this.withUnit = false;
            return this;
        }

        public Builder withMaximumFractionDigits(int maximumFractionDigits) {
            this.maximumFractionDigits = Math.max(maximumFractionDigits, 0);
            return this;
        }

        public FormatterOptions build() {
            return new FormatterOptions(this);
        }
    }
}

