"use strict"
define("vault/adapters/-json-api",["exports","@ember-data/adapter/json-api"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/adapters/application",["exports","@ember-data/adapter/error","@ember-data/adapter/rest","@ember/service","@ember/polyfills","@ember/object","rsvp","vault/config/environment","fetch"],(function(e,t,n,l,a,i,r,o,s){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const{APP:u}=o.default,{POLLING_URLS:d,NAMESPACE_ROOT_URLS:c}=u
var p=n.default.extend({auth:(0,l.inject)(),namespaceService:(0,l.inject)("namespace"),controlGroup:(0,l.inject)(),flashMessages:(0,l.inject)(),namespace:"v1/sys",shouldReloadAll:()=>!0,shouldReloadRecord:()=>!0,shouldBackgroundReloadRecord:()=>!1,addHeaders(e,t){const n=t.clientToken||this.auth.currentToken,l={}
n&&!t.unauthenticated&&(l["X-Vault-Token"]=n),t.wrapTTL&&(l["X-Vault-Wrap-TTL"]=t.wrapTTL)
const i=void 0===t.namespace?this.namespaceService.path:t.namespace
i&&!c.some((t=>e.includes(t)))&&(l["X-Vault-Namespace"]=i),t.headers=(0,a.assign)(t.headers||{},l)},_preRequest(e,t){this.addHeaders(e,t)
return d.some((t=>e.includes(t)))||this.auth.setLastFetch(Date.now()),t.timeout=6e4,t},ajax(e,t){var n=this
let l=e,a=t,i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{}
const r=this.controlGroup,o=r.tokenForUrl(l)
o&&(l="/v1/sys/wrapping/unwrap",a="POST",i={clientToken:o.token,data:{token:o.token}})
const s=this._preRequest(l,i)
return this._super(l,a,s).then((function(){o&&r.deleteControlGroupToken(o.accessor)
for(var e=arguments.length,t=new Array(e),l=0;l<e;l++)t[l]=arguments[l]
const[a]=t
if(a&&a.warnings){const e=n.flashMessages
a.warnings.forEach((t=>{e.info(t)}))}return r.checkForControlGroup(t,a,i.wrapTTL)}))},rawRequest(e,t){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{}
const l=this._preRequest(e,n)
return(0,s.default)(e,{method:t||"GET",headers:l.headers||{},body:l.body,signal:l.signal}).then((e=>e.status>=200&&e.status<300?r.default.resolve(e):r.default.reject(e)))},handleResponse(e,n,l,a){const r=this._super(...arguments)
return r instanceof t.default&&((0,i.set)(r,"httpStatus",e),(0,i.set)(r,"path",a.url),l?.data?.error&&!l.errors&&(0,i.set)(r,"errors",[l.data.error])),r}})
e.default=p})),define("vault/adapters/auth-config/_base",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({namespace:"/v1/auth",pathForType(e){const t=e.split("/").pop()
return"identity-accesslist"===t||"roletag-denylist"===t?`tidy/${t}`:t},buildURL(e,t,n){const l=t||n.belongsTo("backend").id
let a=`${this.namespace}/${l}/config`
return e.includes("aws")&&(a=`${a}/${this.pathForType(e)}`),a},createRecord(e,t,n){const l=n.belongsTo("backend").id
return this._super(...arguments).then((()=>({id:l})))},updateRecord(e,t,n){const l=n.belongsTo("backend").id
return this._super(...arguments).then((()=>({id:l})))}})
e.default=n})),define("vault/adapters/auth-config/aws/client",["exports","vault/adapters/auth-config/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend()
e.default=n})),define("vault/adapters/auth-config/aws/identity-accesslist",["exports","vault/adapters/auth-config/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend()
e.default=n})),define("vault/adapters/auth-config/aws/roletag-denylist",["exports","vault/adapters/auth-config/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend()
e.default=n})),define("vault/adapters/auth-config/azure",["exports","vault/adapters/auth-config/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend()
e.default=n})),define("vault/adapters/auth-config/gcp",["exports","vault/adapters/auth-config/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend()
e.default=n})),define("vault/adapters/auth-config/github",["exports","vault/adapters/auth-config/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend()
e.default=n})),define("vault/adapters/auth-config/jwt",["exports","vault/adapters/auth-config/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend()
e.default=n})),define("vault/adapters/auth-config/kubernetes",["exports","vault/adapters/auth-config/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend()
e.default=n})),define("vault/adapters/auth-config/ldap",["exports","vault/adapters/auth-config/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend()
e.default=n})),define("vault/adapters/auth-config/oidc",["exports","vault/adapters/auth-config/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend()
e.default=n})),define("vault/adapters/auth-config/okta",["exports","vault/adapters/auth-config/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend()
e.default=n})),define("vault/adapters/auth-config/radius",["exports","vault/adapters/auth-config/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend()
e.default=n})),define("vault/adapters/auth-method",["exports","@ember-data/adapter/error","@ember/polyfills","@ember/object","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=a.default.extend({url(e){const t=`${this.buildURL()}/auth`
return e?t+"/"+(0,i.encodePath)(e):t},pathForType:()=>"mounts/auth",findAll(e,n,a,i){if(i?.adapterOptions?.unauthenticated){const e=`/${this.urlPrefix()}/internal/ui/mounts`
return this.ajax(e,"GET",{unauthenticated:!0}).then((e=>({data:e.data.auth}))).catch((()=>({data:{}})))}return this.ajax(this.url(),"GET").catch((e=>{throw e instanceof t.default&&(0,l.set)(e,"policyPath","sys/auth"),e}))},createRecord(e,t,l){const a=e.serializerFor(t.modelName).serialize(l),i=l.attr("path")
return this.ajax(this.url(i),"POST",{data:a}).then((()=>(a.config.id=i,{data:(0,n.assign)({},a,{path:i+"/",id:i})})))},urlForDeleteRecord(e,t,n){return this.url(n.id)},exchangeOIDC(e,t,n){return this.ajax(`/v1/auth/${(0,i.encodePath)(e)}/oidc/callback`,"GET",{data:{state:t,code:n}})},pollSAMLToken(e,t,n){return this.ajax(`/v1/auth/${(0,i.encodePath)(e)}/token`,"PUT",{data:{token_poll_id:t,client_verifier:n}})},tune(e,t){const n=`${this.buildURL()}/${this.pathForType()}/${(0,i.encodePath)(e)}tune`
return this.ajax(n,"POST",{data:t})}})
e.default=r})),define("vault/adapters/aws-credential",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({createRecord(e,t,n){const l=n.attr("ttl"),a=n.attr("roleArn"),i=n.attr("credentialType")
let r,o="POST"
const s={}
"iam_user"===i?o="GET":(void 0!==l&&(s.ttl=l),"assumed_role"===i&&a&&(s.role_arn=a),r=s.ttl||s.role_arn?{data:s}:{})
const u=n.attr("role"),d=`/v1/${u.backend}/creds/${u.name}`
return this.ajax(d,o,r).then((l=>{l.id=n.id,l.modelName=t.modelName,e.pushPayload(t.modelName,l)}))}})
e.default=n})),define("vault/adapters/capabilities",["exports","@ember-data/adapter/error","@ember/object","vault/adapters/application","core/utils/sanitize-path"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=l.default.extend({pathForType:()=>"capabilities-self",formatPaths(e){const{relativeNamespace:t}=this.namespaceService
return t?[`${t}/${e.replace(/^\//,"")}`]:[e]},async findRecord(e,l,i){const r=this.formatPaths(i)
return this.ajax(this.buildURL(l),"POST",{data:{paths:r},namespace:(0,a.sanitizePath)(this.namespaceService.userRootNamespace)}).catch((e=>{throw e instanceof t.default&&(0,n.set)(e,"policyPath","sys/capabilities-self"),e}))},queryRecord(e,t,n){const{id:l}=n
if(l)return this.findRecord(e,t,l).then((e=>(e.path=l,e)))}})
e.default=i})),define("vault/adapters/clients/activity",["exports","vault/adapters/application","date-fns"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{formatQueryParams(e){let{start_time:t,end_time:l}=e
return t=t.timestamp||(0,n.getUnixTime)(Date.UTC(t.year,t.monthIdx,1)),l=l.timestamp||(0,n.getUnixTime)(Date.UTC(l.year,l.monthIdx+1,0)),{start_time:t,end_time:l}}queryRecord(e,t,n){const l=`${this.buildURL()}/internal/counters/activity`,a=this.formatQueryParams(n)
if(a)return this.ajax(l,"GET",{data:a}).then((e=>{const t=e||{}
return t.id=t.request_id||"no-data",t}))}}e.default=l})),define("vault/adapters/clients/config",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({queryRecord(){return this.ajax(this.urlForQuery(),"GET").then((e=>(e.id=e.request_id,e)))},urlForUpdateRecord(){return this.buildURL()+"/internal/counters/config"},urlForQuery(){return this.buildURL()+"/internal/counters/config"}})
e.default=n})),define("vault/adapters/clients/version-history",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{findAll(){return this.ajax(this.buildURL()+"/version-history","GET",{data:{list:!0}}).then((e=>e))}}e.default=n})),define("vault/adapters/cluster",["exports","@ember-data/adapter/error","@ember/service","@ember/polyfills","rsvp","@ember/debug","ember-inflector","vault/adapters/application"],(function(e,t,n,l,a,i,r,o){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const s=["health","seal-status","tokens","token","seal","unseal","init","capabilities-self","license"]
var u=o.default.extend({version:(0,n.inject)(),namespaceService:(0,n.inject)("namespace"),shouldBackgroundReloadRecord:()=>!0,findRecord(e,n,i,r){const o={health:this.health(),sealStatus:this.sealStatus().catch((e=>e))}
return this.version.isEnterprise&&this.namespaceService.inRootNamespace&&(o.replicationStatus=this.replicationStatus().catch((e=>e))),(0,a.hash)(o).then((e=>{let{health:n,sealStatus:o,replicationStatus:s}=e,u={id:i,name:r.attr("name")}
return u=(0,l.assign)(u,n),o instanceof t.default==!1&&(u=(0,l.assign)(u,{nodes:[o]})),s&&s instanceof t.default==!1&&(u=(0,l.assign)(u,s.data)),(0,a.resolve)(u)}))},pathForType:e=>"cluster"===e?"clusters":(0,r.pluralize)(e),health(){return this.ajax(this.urlFor("health"),"GET",{data:{standbycode:200,sealedcode:200,uninitcode:200,drsecondarycode:200,performancestandbycode:200},unauthenticated:!0}).catch((()=>({has_chroot_namespace:!0})))},features(){return this.ajax(`${this.urlFor("license")}/features`,"GET",{unauthenticated:!0})},sealStatus(){return this.ajax(this.urlFor("seal-status"),"GET",{unauthenticated:!0})},seal(){return this.ajax(this.urlFor("seal"),"PUT")},unseal(e){return this.ajax(this.urlFor("unseal"),"PUT",{data:e,unauthenticated:!0})},initCluster(e){return this.ajax(this.urlFor("init"),"PUT",{data:e,unauthenticated:!0})},authenticate(e){let{backend:t,data:n}=e
const{role:l,jwt:a,token:i,password:r,username:o,path:s,nonce:u}=n,d=this.urlForAuth(t,o,s),c="token"===t?"GET":"POST",p={unauthenticated:!0}
return"token"===t?p.headers={"X-Vault-Token":i}:p.data="jwt"===t||"oidc"===t?{role:l,jwt:a}:"okta"===t?{password:r,nonce:u}:i?{token:i,password:r}:{password:r},this.ajax(d,c,p)},mfaValidate(e){let{mfa_request_id:t,mfa_constraints:n}=e
const l={data:{mfa_request_id:t,mfa_payload:n.reduce(((e,t)=>{let{selectedMethod:n,passcode:l}=t,a=[]
return l&&(a="duo"!==n.type||l.includes("passcode=")?[l]:[`passcode=${l}`]),e[n.id]=a,e}),{})}}
return this.ajax("/v1/sys/mfa/validate","POST",l)},urlFor(e){if(!s.includes(e))throw new Error(`Calls to a ${e} endpoint are not currently allowed in the vault cluster adapater`)
return`${this.buildURL()}/${e}`},urlForAuth(e,t,n){const l=e.toLowerCase(),a={github:"login",jwt:"login",oidc:"login",userpass:`login/${encodeURIComponent(t)}`,ldap:`login/${encodeURIComponent(t)}`,okta:`login/${encodeURIComponent(t)}`,radius:`login/${encodeURIComponent(t)}`,token:"lookup-self"}[l],i=n&&"token"!==l?n:l
if(!a)throw new Error(`There is no auth url for ${e}.`)
return`/v1/auth/${i}/${a}`},urlForReplication(e,t,n){let l
return l=t?`${e}/${t}/${n}`:`${n}`,`${this.buildURL()}/replication/${l}`},replicationStatus(){return this.ajax(`${this.buildURL()}/replication/status`,"GET",{unauthenticated:!0})},replicationDrPromote(e,t){const n=t&&t.checkStatus?"GET":"PUT"
return this.ajax(`${this.buildURL()}/replication/dr/secondary/promote`,n,{data:e,unauthenticated:!0})},generateDrOperationToken(e,t){let n="POST",l=`${this.buildURL()}/replication/dr/secondary/generate-operation-token/`
return t?.cancel?(n="DELETE",l+="attempt"):t?.checkStatus?(n="GET",l+="attempt"):l+=e?.pgp_key||e?.attempt?"attempt":"update",this.ajax(l,n,{data:e,unauthenticated:!0})},replicationAction(e,t,n,l){const a="recover"===e||"reindex"===e?this.urlForReplication(t,null,e):this.urlForReplication(t,n,e)
return this.ajax(a,"POST",{data:l})}})
e.default=u})),define("vault/adapters/console",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({namespace:"v1",pathForType:e=>e})
e.default=n})),define("vault/adapters/control-group-config",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({pathForType:()=>"config/control-group",urlForDeleteRecord(e,t){return this.buildURL(t)},urlForFindRecord(e,t){return this.buildURL(t)},urlForUpdateRecord(e,t){return this.buildURL(t)}})
e.default=n})),define("vault/adapters/control-group",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({pathForType:()=>"control-group",async findRecord(e,t,n){const l=this.buildURL(t.modelName)
return this.ajax(`${l}/request`,"POST",{data:{accessor:n}}).then((e=>(e.id=n,e)))},urlForUpdateRecord(e,t){return`${this.buildURL(t)}/authorize`}})
e.default=n})),define("vault/adapters/database/connection",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({namespace:"v1",urlFor(e,t){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:""
if("ROTATE"===n)return`${this.buildURL()}/${e}/rotate-root/${t}`
if("RESET"===n)return`${this.buildURL()}/${e}/reset/${t}`
let l=`${this.buildURL()}/${e}/config`
return t&&(l=`${this.buildURL()}/${e}/config/${t}`),l},optionsForQuery(e){const t={}
return e||(t.list=!0),{data:t}},fetchByQuery(e,t){const{backend:n,id:l}=t
return this.ajax(this.urlFor(n,l),"GET",this.optionsForQuery(l)).then((e=>(e.backend=n,l&&(e.id=l),e)))},query(e,t,n){return this.fetchByQuery(e,n)},queryRecord(e,t,n){return this.fetchByQuery(e,n)},createRecord(e,t,n){const l=e.serializerFor(t.modelName).serialize(n),a=n.attr("name"),i=n.attr("backend")
return this.ajax(this.urlFor(i,a),"POST",{data:l}).then((()=>({data:{id:a,name:a,...l}})))},updateRecord(){return this.createRecord(...arguments)},deleteRecord(e,t,n){const l=n.id,a=n.attr("backend")
return this.ajax(this.urlFor(a,l),"DELETE")},rotateRootCredentials(e,t){return this.ajax(this.urlFor(e,t,"ROTATE"),"POST")},resetConnection(e,t){return this.ajax(this.urlFor(e,t,"RESET"),"POST")}})
e.default=n})),define("vault/adapters/database/credential",["exports","rsvp","vault/adapters/application","vault/lib/control-group-error"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=n.default.extend({namespace:"v1",_staticCreds(e,t){return this.ajax(`${this.buildURL()}/${encodeURIComponent(e)}/static-creds/${encodeURIComponent(t)}`,"GET").then((e=>({...e,roleType:"static"})))},_dynamicCreds(e,t){return this.ajax(`${this.buildURL()}/${encodeURIComponent(e)}/creds/${encodeURIComponent(t)}`,"GET").then((e=>({...e,roleType:"dynamic"})))},fetchByQuery(e,n){const{backend:a,secret:i}=n
return"static"===n.roleType?this._staticCreds(a,i):"dynamic"===n.roleType?this._dynamicCreds(a,i):(0,t.allSettled)([this._staticCreds(a,i),this._dynamicCreds(a,i)]).then((e=>{let[t,n]=e
if("rejected"===t.state&&"rejected"===n.state){let e=t.reason
if(n.reason instanceof l.default)throw n.reason
throw e?.httpStatus<n.reason?.httpStatus&&(e=n.reason),e}return t.value||n.value}))},queryRecord(e,t,n){return this.fetchByQuery(e,n)},rotateRoleCredentials(e,t){return this.ajax(`${this.buildURL()}/${encodeURIComponent(e)}/rotate-role/${encodeURIComponent(t)}`,"POST")}})
e.default=a})),define("vault/adapters/database/role",["exports","@ember/polyfills","@ember/debug","vault/lib/control-group-error","vault/adapters/application","rsvp","vault/helpers/add-to-array","vault/helpers/remove-from-array"],(function(e,t,n,l,a,i,r,o){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var s=a.default.extend({namespace:"v1",pathForType(){},urlFor(e,t){let n="roles"
"static"===(arguments.length>2&&void 0!==arguments[2]?arguments[2]:"dynamic")&&(n="static-roles")
let l=`${this.buildURL()}/${e}/${n}`
return t&&(l=`${this.buildURL()}/${e}/${n}/${t}`),l},staticRoles(e,t){return this.ajax(this.urlFor(e,t,"static"),"GET",this.optionsForQuery(t)).then((n=>t?{...n,type:"static",backend:e,id:t}:n))},dynamicRoles(e,t){return this.ajax(this.urlFor(e,t),"GET",this.optionsForQuery(t)).then((n=>t?{...n,type:"dynamic",backend:e,id:t}:n))},optionsForQuery(e){const t={}
return e||(t.list=!0),{data:t}},queryRecord(e,n,a){const{backend:r,id:o}=a
return"static"===a.type?this.staticRoles(r,o):"dynamic"===a?.type?this.dynamicRoles(r,o):(0,i.allSettled)([this.staticRoles(r,o),this.dynamicRoles(r,o)]).then((e=>{let[n,a]=e
if("rejected"===n.state&&"rejected"===a.state){let e=n.reason
if(a.reason instanceof l.default)throw a.reason
throw e?.httpStatus<a.reason?.httpStatus&&(e=a.reason),e}const i=n.value?"static":"dynamic",s=n.value||a.value,u={data:{},backend:r,id:o,type:i}
return u.data=(0,t.assign)({},s.data),u}))},query(e,n,l){const{backend:a}=l,r=this.staticRoles(a),o=this.dynamicRoles(a)
return(0,i.allSettled)([r,o]).then((e=>{let[n,l]=e
const i={backend:a,data:{keys:[]}}
if(n.reason&&l.reason)throw l.reason
let r=[],o=[]
return n.value&&(r=n.value.data.keys),l.value&&(o=l.value.data.keys),i.data=(0,t.assign)({},i.data,{keys:[...r,...o]},{backend:a},{staticRoles:r,dynamicRoles:o}),i}))},async _updateAllowedRoles(e,t){let{role:n,backend:l,db:a,type:i="add"}=t
const s=await e.queryRecord("database/connection",{backend:l,id:a}),u=[...s.allowed_roles||[]],d="add"===i?(0,r.addToArray)([u,n]):(0,o.removeFromArray)([u,n])
return s.allowed_roles=d,s.save()},async createRecord(e,n,l){const a=e.serializerFor(n.modelName).serialize(l),i=l.attr("type"),r=l.attr("backend"),o=l.attr("name"),s=l.attr("database")
try{await this._updateAllowedRoles(e,{role:o,backend:r,db:s[0]})}catch(u){this.checkError(u)}return this.ajax(this.urlFor(r,o,i),"POST",{data:a}).then((()=>({data:(0,t.assign)({},a,{id:o})})))},async deleteRecord(e,t,n){const l=n.attr("type"),a=n.attr("backend"),i=n.attr("name"),r=n.attr("database")
try{await this._updateAllowedRoles(e,{role:i,backend:a,db:r[0],type:"remove"})}catch(o){this.checkError(o)}return this.ajax(this.urlFor(a,i,l),"DELETE")},async updateRecord(e,t,n){const l=e.serializerFor(t.modelName).serialize(n),a=n.attr("type"),i=n.attr("backend"),r=n.attr("name")
return this.ajax(this.urlFor(i,r,a),"POST",{data:l}).then((()=>l))},checkError(e){if(403!==e.httpStatus)throw new Error(`Could not update allowed roles for selected database: ${e.errors.join(", ")}`)}})
e.default=s})),define("vault/adapters/generated-item-list",["exports","@ember/polyfills","vault/adapters/application","ember-concurrency","@ember/service"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=n.default.extend({store:(0,a.inject)(),namespace:"v1",urlForItem(){},dynamicApiPath:"",getDynamicApiPath:(0,l.task)((function*(e){const t=yield this.store.peekRecord("auth-method",e)
this.dynamicApiPath=t.apiPath})),fetchByQuery:(0,l.task)((function*(e,n,l){const{id:a}=n,i={}
return l&&(i.list=!0,yield this.getDynamicApiPath.perform(a)),this.ajax(this.urlForItem(a,l,this.dynamicApiPath),"GET",{data:i}).then((e=>{const n={id:a,method:a}
return(0,t.assign)({},e,n)}))})),query(e,t,n){return this.fetchByQuery.perform(e,n,!0)},queryRecord(e,t,n){return this.fetchByQuery.perform(e,n)}})
e.default=i})),define("vault/adapters/identity/base",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({namespace:"v1",pathForType:e=>e,urlForQuery(){return this._super(...arguments)+"?list=true"},query(e,t){return this.ajax(this.buildURL(t.modelName,null,null,"query"),"GET")},buildURL(e,t,n,l,a){return"createRecord"===l?this._super(...arguments):this._super(`${e}/id`,t,n,l,a)}})
e.default=n}))
define("vault/adapters/identity/entity-alias",["exports","vault/adapters/identity/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend()
e.default=n})),define("vault/adapters/identity/entity-merge",["exports","vault/adapters/identity/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({buildURL(){const[,...e]=arguments
return this._super("identity/entity/merge",...e)},createRecord(e,t,n){return this._super(...arguments).then((()=>({id:n.attr("toEntityId")})))}})
e.default=n})),define("vault/adapters/identity/entity",["exports","vault/adapters/identity/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({lookup(e,t){const n=`/${this.urlPrefix()}/identity/lookup/entity`
return this.ajax(n,"POST",{data:t}).then((t=>{if(!t)return
const n="identity/entity"
return e.push(e.serializerFor(n).normalizeResponse(e,e.modelFor(n),t,t.data.id,"findRecord")),t}))}})
e.default=n})),define("vault/adapters/identity/group-alias",["exports","vault/adapters/identity/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend()
e.default=n})),define("vault/adapters/identity/group",["exports","vault/adapters/identity/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({lookup(e,t){const n=`/${this.urlPrefix()}/identity/lookup/group`
return this.ajax(n,"POST",{data:t}).then((t=>{if(!t)return
const n="identity/group"
return e.push(e.serializerFor(n).normalizeResponse(e,e.modelFor(n),t,t.data.id,"findRecord")),t}))}})
e.default=n})),define("vault/adapters/keymgmt/key",["exports","vault/adapters/application","vault/utils/path-encoding-helpers","vault/lib/control-group-error","@ember/service"],(function(e,t,n,l,a){var i,r
function o(e,t){const n={}
return Object.keys(e).forEach((l=>{t.indexOf(l)>=0&&(n[l]=e[l])})),n}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let s=(i=class extends t.default{constructor(){var e,t,n,l,a,i,o
super(...arguments),e=this,t="store",l=this,(n=r)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0}),o="v1",(i="namespace")in(a=this)?Object.defineProperty(a,i,{value:o,enumerable:!0,configurable:!0,writable:!0}):a[i]=o}pathForType(){return"key"}buildURL(e,t,n,l,a){let i=super.buildURL(...arguments)
return n?i=i.replace("key",`${n.attr("backend")}/key`):a&&(i=i.replace("key",`${a.backend}/key`)),i}url(e,t,l){const a=`${this.buildURL()}/${e}/key`
return t?"ROTATE"===l?a+"/"+(0,n.encodePath)(t)+"/rotate":"PROVIDERS"===l?a+"/"+(0,n.encodePath)(t)+"/kms":a+"/"+(0,n.encodePath)(t):a}_updateKey(e,t,n){const l=o(n,["deletion_allowed","min_enabled_version"])
return this.ajax(this.url(e,t),"PUT",{data:l})}_createKey(e,t,n){const l=o(n,["type"])
return this.ajax(this.url(e,t),"POST",{data:l})}async createRecord(e,t,n){const l=e.serializerFor(t.modelName).serialize(n),a=n.attr("name"),i=n.attr("backend")
if(await this._createKey(i,a,l),n.attr("deletionAllowed"))try{await this._updateKey(i,a,l)}catch{throw new Error(`Key ${a} was created, but not all settings were saved`)}return{data:{...l,id:a,backend:i}}}updateRecord(e,t,n){const l=e.serializerFor(t.modelName).serialize(n),a=n.attr("name"),i=n.attr("backend")
return this._updateKey(i,a,l)}distribute(e,t,l,a){return this.ajax(`${this.buildURL()}/${e}/kms/${(0,n.encodePath)(t)}/key/${(0,n.encodePath)(l)}`,"PUT",{data:{...a}})}async getProvider(e,t){try{const n=await this.ajax(this.url(e,t,"PROVIDERS"),"GET",{data:{list:!0}})
return n.data.keys?n.data.keys[0]:null}catch(n){if(404===n.httpStatus)return null
if(403===n.httpStatus)return{permissionsError:!0}
throw n}}getDistribution(e,t,n){const a=`${this.buildURL()}/${e}/kms/${t}/key/${n}`
return this.ajax(a,"GET").then((e=>({...e.data,purposeArray:e.data.purpose.split(",")}))).catch((e=>{if(e instanceof l.default)throw e
return null}))}async queryRecord(e,t,n){const{id:l,backend:a,recordOnly:i=!1}=n,r=await this.ajax(this.url(a,l),"GET")
let o,s
return r.data.id=l,r.data.backend=a,i||(o=await this.getProvider(a,l),o&&!o.permissionsError&&(s=await this.getDistribution(a,o,l))),{...r,provider:o,distribution:s}}async query(e,t,n){const{backend:l,provider:a}=n,i=e.adapterFor("keymgmt/provider"),r=a?i.buildKeysURL(n):this.url(l)
return this.ajax(r,"GET",{data:{list:!0}}).then((e=>(e.backend=l,e)))}async rotateKey(e,t){const n=this.store.peekRecord("keymgmt/key",t),l=await this.ajax(this.url(e,t,"ROTATE"),"PUT")
return await n.reload(),l}removeFromProvider(e){const t=`${this.buildURL()}/${e.backend}/kms/${e.provider}/key/${e.name}`
return this.ajax(t,"DELETE").then((()=>{e.provider=null}))}},u=i.prototype,d="store",c=[a.inject],p={configurable:!0,enumerable:!0,writable:!0,initializer:null},f={},Object.keys(p).forEach((function(e){f[e]=p[e]})),f.enumerable=!!f.enumerable,f.configurable=!!f.configurable,("value"in f||f.initializer)&&(f.writable=!0),f=c.slice().reverse().reduce((function(e,t){return t(u,d,e)||e}),f),m&&void 0!==f.initializer&&(f.value=f.initializer?f.initializer.call(m):void 0,f.initializer=void 0),void 0===f.initializer&&(Object.defineProperty(u,d,f),f=null),r=f,i)
var u,d,c,p,m,f
e.default=s})),define("vault/adapters/keymgmt/provider",["exports","vault/adapters/application","rsvp"],(function(e,t,n){function l(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class a extends t.default{constructor(){super(...arguments),l(this,"namespace","v1"),l(this,"listPayload",{data:{list:!0}})}pathForType(){return"kms"}buildURL(e,t,n,l,a){let i=super.buildURL(...arguments)
return n?i=i.replace("kms",`${n.attr("backend")}/kms`):a&&(i=i.replace("kms",`${a.backend}/kms`)),i}buildKeysURL(e){return`${this.buildURL("keymgmt/provider",null,null,"query",e)}/${e.provider}/key`}async createRecord(e,t,n){let{modelName:l}=t
const a=e.serializerFor(l).serialize(n),i=this.buildURL(l,n.attr("name"),n,"updateRecord")
return this.ajax(i,"PUT",{data:a}).then((()=>a))}findRecord(e,t,n){return super.findRecord(...arguments).then((e=>(e.data={...e.data,name:n},e)))}async query(e,t,l){const{backend:a}=l,i=this.buildURL(t.modelName,null,null,"query",l)
return this.ajax(i,"GET",this.listPayload).then((async i=>{const r=await(0,n.all)(i.data.keys.map((n=>this.findRecord(e,t,n,this._mockSnapshot(l.backend)))))
return i.data.keys=r.map((e=>e.data)),i.backend=a,i}))}async queryRecord(e,t,n){return this.findRecord(e,t,n.id,this._mockSnapshot(n.backend))}_mockSnapshot(e){return{attr:t=>"backend"===t?e:null}}}e.default=a})),define("vault/adapters/kmip/base",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend({namespace:"v1",pathForType:e=>e.replace("kmip/",""),_url(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},l=arguments.length>2?arguments[2]:void 0
const{backend:a,scope:i,role:r}=t,o=this.pathForType(e)
let s
switch(o){case"scope":s=`${(0,n.encodePath)(a)}/scope`
break
case"role":s=`${(0,n.encodePath)(a)}/scope/${(0,n.encodePath)(i)}/role`
break
case"credential":s=`${(0,n.encodePath)(a)}/scope/${(0,n.encodePath)(i)}/role/${(0,n.encodePath)(r)}/credential`}return l&&"credential"===o?`/v1/${s}/lookup?serial_number=${(0,n.encodePath)(l)}`:l?`/v1/${s}/${(0,n.encodePath)(l)}`:`/v1/${s}`},urlForQuery(e,t){return this._url(t,e)+"?list=true"},query(e,t,n){return this.ajax(this.urlForQuery(n,t.modelName),"GET").then((e=>{const{...t}=n
return e._requestQuery=t,e}))},queryRecord(e,t,n){const l=n.id
return delete n.id,this.ajax(this._url(t.modelName,n,l),"GET").then((e=>(e.id=l,e={...e,...n})))},buildURL(e,t,n,l,a){return"createRecord"===l?this._super(...arguments):this._super(`${e}`,t,n,l,a)}})
e.default=l})),define("vault/adapters/kmip/ca",["exports","vault/adapters/kmip/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({urlForFindRecord(e,t,n){const l=this.pathForType(t)
return this.buildURL(e,l,n)}})
e.default=n})),define("vault/adapters/kmip/config",["exports","vault/adapters/kmip/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({_url(e,t,n){const l=this.pathForType(t)
return this.buildURL(e,l,n)},urlForFindRecord(){return this._url(...arguments)},urlForCreateRecord(e,t){return this._url(t.id,e,t)},urlForUpdateRecord(){return this._url(...arguments)}})
e.default=n})),define("vault/adapters/kmip/credential",["exports","vault/adapters/kmip/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({createRecord(e,t,n){let l=this._url(t.modelName,{backend:n.record.backend,scope:n.record.scope,role:n.record.role})
return l=`${l}/generate`,this.ajax(l,"POST",{data:n.serialize()}).then((e=>(e.data.id=e.data.serial_number,e)))},deleteRecord(e,t,n){let l=this._url(t.modelName,{backend:n.record.backend,scope:n.record.scope,role:n.record.role})
return l=`${l}/revoke`,this.ajax(l,"POST",{data:{serial_number:n.id}})}})
e.default=n})),define("vault/adapters/kmip/role",["exports","vault/adapters/kmip/base","@ember/string","@ember/object"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=t.default.extend({createRecord(e,t,n){const l=n.id||n.attr("name"),a=this._url(t.modelName,{backend:n.record.backend,scope:n.record.scope},l)
return this.ajax(a,"POST",{data:this.serialize(n)}).then((()=>({id:l,name:l,backend:n.record.backend,scope:n.record.scope})))},deleteRecord(e,t,n){const l=n.id||n.attr("name"),a=this._url(t.modelName,{backend:n.record.backend,scope:n.record.scope},l)
return this.ajax(a,"DELETE")},serialize(e){const t=e.serialize(),a=e.record.nonOperationFields.map(n.decamelize),i=(0,l.getProperties)(t,a)
for(const n in i)null==i[n]&&delete i[n]
return t.operation_all?{operation_all:!0,...i}:t.operation_none?{operation_none:!0,...i}:(delete t.operation_none,delete t.operation_all,t)},updateRecord(){return this.createRecord(...arguments)}})
e.default=a})),define("vault/adapters/kmip/scope",["exports","vault/adapters/kmip/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({createRecord(e,t,n){const l=n.attr("name")
return this.ajax(this._url(t.modelName,{backend:n.record.backend},l),"POST").then((()=>({id:l,name:l})))},deleteRecord(e,t,n){let l=this._url(t.modelName,{backend:n.record.backend},n.id)
return l=`${l}?force=true`,this.ajax(l,"DELETE")}})
e.default=n})),define("vault/adapters/kubernetes/config",["exports","vault/adapters/secrets-engine-path"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{constructor(){var e,t,n
super(...arguments),n="config",(t="path")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}checkConfigVars(e){return this.ajax(`${this._getURL(e,"check")}`,"GET")}}e.default=n})),define("vault/adapters/kubernetes/role",["exports","vault/adapters/named-path","vault/utils/path-encoding-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{getURL(e,t){const l=`${this.buildURL()}/${(0,n.encodePath)(e)}/roles`
return t?`${l}/${t}`:l}urlForQuery(e){let{backend:t}=e
return this.getURL(t)}urlForUpdateRecord(e,t,n){return this.getURL(n.attr("backend"),e)}urlForDeleteRecord(e,t,n){return this.getURL(n.attr("backend"),e)}query(e,t,n){const{backend:l}=n
return this.ajax(this.getURL(l),"GET",{data:{list:!0}}).then((e=>e.data.keys.map((e=>({name:e,backend:l})))))}queryRecord(e,t,n){const{backend:l,name:a}=n
return this.ajax(this.getURL(l,a),"GET").then((e=>(e.data.backend=l,e.data.name=a,e.data)))}generateCredentials(e,t){const l=`${this.buildURL()}/${(0,n.encodePath)(e)}/creds/${t.role}`
return delete t.role,this.ajax(l,"POST",{data:t}).then((e=>{const{lease_id:t,lease_duration:n,data:l}=e
return{lease_id:t,lease_duration:n,...l}}))}}e.default=l})),define("vault/adapters/kv/config",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{constructor(){var e,t,n
super(...arguments),n="v1",(t="namespace")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}urlForFindRecord(e){return`${this.buildURL()}/${e}/config`}}e.default=n})),define("vault/adapters/kv/data",["exports","vault/adapters/application","vault/utils/kv-path","@ember/debug","vault/lib/control-group-error"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends t.default{constructor(){var e,t,n
super(...arguments),n="v1",(t="namespace")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}_url(e){return`${this.buildURL()}/${e}`}createRecord(e,t,l){const{backend:a,path:i}=l.record,r=this._url((0,n.kvDataPath)(a,i))
return this.ajax(r,"POST",{data:this.serialize(l)}).then((e=>({data:{id:(0,n.kvDataPath)(a,i,e.data.version),backend:a,path:i,...e.data}})))}fetchWrapInfo(e){const{backend:t,path:l,version:a,wrapTTL:i}=e,r=(0,n.kvDataPath)(t,l,a)
return this.ajax(this._url(r),"GET",{wrapTTL:i}).then((e=>e.wrap_info))}queryRecord(e,t,l){const{backend:i,path:r,version:o}=l
let s=(0,n.kvDataPath)(i,r,o)
return this.ajax(this._url(s),"GET").then((e=>(o||(s=(0,n.kvDataPath)(i,r,e.data.metadata.version)),{...e,data:{id:s,backend:i,path:r,...e.data}}))).catch((e=>{const t={id:s,backend:i,path:r,version:o},n=e.httpStatus
if(e instanceof a.default)throw e
if(403===n)return{data:{...t,fail_read_error_code:n}}
if(e.data)return{...e,data:{...t,...e.data}}
throw e}))}deleteRecord(e,t,l){const{backend:a,path:i}=l.record,{deleteType:r,deleteVersions:o}=l.adapterOptions
if(!a||!i)throw new Error("The request to delete or undelete is missing required attributes.")
switch(r){case"delete-latest-version":return this.ajax(this._url((0,n.kvDataPath)(a,i)),"DELETE")
case"delete-version":return this.ajax(this._url((0,n.kvDeletePath)(a,i)),"POST",{data:{versions:o}})
case"destroy":return this.ajax(this._url((0,n.kvDestroyPath)(a,i)),"PUT",{data:{versions:o}})
case"undelete":return this.ajax(this._url((0,n.kvUndeletePath)(a,i)),"POST",{data:{versions:o}})
case"destroy-all-versions":return this.ajax(this._url((0,n.kvMetadataPath)(a,i)),"DELETE")}}handleResponse(e,t,n,l){return 404===e&&n.data?.metadata?super.handleResponse(200,t,n,l):super.handleResponse(...arguments)}}e.default=i})),define("vault/adapters/kv/metadata",["exports","vault/adapters/application","vault/utils/kv-path"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{constructor(){var e,t,n
super(...arguments),n="v1",(t="namespace")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}_url(e){return`${this.buildURL()}/${e}`}createRecord(e,t,l){const{backend:a,path:i}=l.record,r=(0,n.kvMetadataPath)(a,i),o=this._url(r),s=this.serialize(l)
return this.ajax(o,"POST",{data:s}).then((()=>({id:r,data:s})))}updateRecord(e,t,l){const{backend:a,path:i}=l.record,r=(0,n.kvMetadataPath)(a,i),o=this._url(r),s=this.serialize(l)
return this.ajax(o,"POST",{data:s}).then((()=>({id:r,data:s})))}query(e,t,l){const{backend:a,pathToSecret:i}=l
return this.ajax(this._url((0,n.kvMetadataPath)(a,i)),"GET",{data:{list:!0}}).then((e=>(e.backend=a,e.path=i,e)))}queryRecord(e,t,l){const{backend:a,path:i}=l,r=(0,n.kvMetadataPath)(a,i)
return this.ajax(this._url(r),"GET").then((e=>({id:r,...e,data:{backend:a,path:i,...e.data}})))}deleteRecord(e,t,l){const{backend:a,path:i,fullSecretPath:r}=l.record
return this.ajax(this._url((0,n.kvMetadataPath)(a,r||i)),"DELETE")}}e.default=l})),define("vault/adapters/ldap/config",["exports","vault/adapters/secrets-engine-path"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{constructor(){var e,t,n
super(...arguments),n="config",(t="path")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}async rotateRoot(e){return this.ajax(this._getURL(e,"rotate-root"),"POST")}}e.default=n})),define("vault/adapters/ldap/library",["exports","vault/adapters/named-path","vault/utils/path-encoding-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{getURL(e,t){const l=`${this.buildURL()}/${(0,n.encodePath)(e)}/library`
return t?`${l}/${t}`:l}urlForUpdateRecord(e,t,n){return this.getURL(n.attr("backend"),e)}urlForDeleteRecord(e,t,n){return this.getURL(n.attr("backend"),e)}query(e,t,n){const{backend:l}=n
return this.ajax(this.getURL(l),"GET",{data:{list:!0}}).then((e=>e.data.keys.map((e=>({name:e,backend:l}))))).catch((e=>{if(404===e.httpStatus)return[]
throw e}))}queryRecord(e,t,n){const{backend:l,name:a}=n
return this.ajax(this.getURL(l,a),"GET").then((e=>({...e.data,backend:l,name:a})))}fetchStatus(e,t){const n=`${this.getURL(e,t)}/status`
return this.ajax(n,"GET").then((e=>{const n=[]
for(const l in e.data){const a={...e.data[l],account:l,library:t}
n.push(a)}return n}))}checkOutAccount(e,t,n){const l=`${this.getURL(e,t)}/check-out`
return this.ajax(l,"POST",{data:{ttl:n}}).then((e=>{const{lease_id:t,lease_duration:n,renewable:l}=e,{service_account_name:a,password:i}=e.data
return{account:a,password:i,lease_id:t,lease_duration:n,renewable:l}}))}checkInAccount(e,t,n){const l=`${this.getURL(e,t)}/check-in`
return this.ajax(l,"POST",{data:{service_account_names:n}}).then((e=>e.data))}}e.default=l})),define("vault/adapters/ldap/role",["exports","vault/adapters/named-path","vault/utils/path-encoding-helpers","@ember/service"],(function(e,t,n,l){var a,i
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let r=(a=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="flashMessages",l=this,(n=i)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}getURL(e,t,l){const a=`${this.buildURL()}/${(0,n.encodePath)(e)}/${t}`
return l?`${a}/${l}`:a}pathForRoleType(e,t){return"static"===e?t?"static-cred":"static-role":t?"creds":"role"}urlForUpdateRecord(e,t,n){const{backend:l,type:a}=n.record
return this.getURL(l,this.pathForRoleType(a),e)}urlForDeleteRecord(e,t,n){const{backend:l,type:a}=n.record
return this.getURL(l,this.pathForRoleType(a),e)}async query(e,t,n,l,a){const{showPartialError:i}=a.adapterOptions||{},{backend:r}=n,o=[],s=[]
for(const d of["static","dynamic"]){const e=this.getURL(r,this.pathForRoleType(d))
try{const t=await this.ajax(e,"GET",{data:{list:!0}}).then((e=>e.data.keys.map((e=>({id:e,name:e,backend:r,type:d})))))
o.addObjects(t)}catch(u){404!==u.httpStatus&&s.push(u)}}if(s.length){const e=s.reduce(((e,t)=>(t.errors.forEach((n=>{e.push(`${t.path}: ${n}`)})),e)),[])
if(2===s.length)throw{message:"Error fetching roles:",errors:e}
i&&this.flashMessages.info(`Error fetching roles from ${e.join(", ")}`)}return{data:{keys:o.sortBy("name")}}}queryRecord(e,t,n){const{backend:l,name:a,type:i}=n,r=this.getURL(l,this.pathForRoleType(i),a)
return this.ajax(r,"GET").then((e=>({...e.data,backend:l,name:a,type:i})))}fetchCredentials(e,t,n){const l=this.getURL(e,this.pathForRoleType(t,!0),n)
return this.ajax(l,"GET").then((e=>{if("dynamic"===t){const{lease_id:n,lease_duration:l,renewable:a}=e
return{...e.data,lease_id:n,lease_duration:l,renewable:a,type:t}}return{...e.data,type:t}}))}rotateStaticPassword(e,t){const n=this.getURL(e,"rotate-role",t)
return this.ajax(n,"POST")}},o=a.prototype,s="flashMessages",u=[l.inject],d={configurable:!0,enumerable:!0,writable:!0,initializer:null},p={},Object.keys(d).forEach((function(e){p[e]=d[e]})),p.enumerable=!!p.enumerable,p.configurable=!!p.configurable,("value"in p||p.initializer)&&(p.writable=!0),p=u.slice().reverse().reduce((function(e,t){return t(o,s,e)||e}),p),c&&void 0!==p.initializer&&(p.value=p.initializer?p.initializer.call(c):void 0,p.initializer=void 0),void 0===p.initializer&&(Object.defineProperty(o,s,p),p=null),i=p,a)
var o,s,u,d,c,p
e.default=r})),define("vault/adapters/lease",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend({revokePrefix(e){let t=this.buildURL()+"/leases/revoke-prefix/"+(0,n.encodePath)(e)
return t=t.replace(/\/$/,""),this.ajax(t,"PUT")},forceRevokePrefix(e){let t=this.buildURL()+"/leases/revoke-force/"+(0,n.encodePath)(e)
return t=t.replace(/\/$/,""),this.ajax(t,"PUT")},renew(e,t){const n=this.buildURL()+"/leases/renew"
return this.ajax(n,"PUT",{data:{lease_id:e,increment:t}})},deleteRecord(e,t,n){const l=n.id
return this.ajax(this.buildURL()+"/leases/revoke","PUT",{data:{lease_id:l}})},queryRecord(e,t,n){const{lease_id:l}=n
return this.ajax(this.buildURL()+"/leases/lookup","PUT",{data:{lease_id:l}})},query(e,t,l){const a=l.prefix||""
return this.ajax(this.buildURL()+"/leases/lookup/"+(0,n.encodePath)(a),"GET",{data:{list:!0}}).then((e=>(a&&(e.prefix=a),e)))}})
e.default=l})),define("vault/adapters/license",["exports","vault/adapters/cluster"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({pathForType:()=>"license/status"})
e.default=n})),define("vault/adapters/mfa-login-enforcement",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{constructor(){var e,t,n
super(...arguments),n="v1",(t="namespace")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}pathForType(){return"identity/mfa/login-enforcement"}_saveRecord(e,t,n){let{modelName:l}=t
const a=e.serializerFor(l).serialize(n)
return this.ajax(this.urlForUpdateRecord(n.attr("name"),l,n),"POST",{data:a}).then((()=>a))}createRecord(){return this._saveRecord(...arguments)}updateRecord(){return this._saveRecord(...arguments)}query(e,t,n){const l=this.urlForQuery(n,t.modelName)
return this.ajax(l,"GET",{data:{list:!0}})}}e.default=n})),define("vault/adapters/mfa-method",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{constructor(){var e,t,n
super(...arguments),n="v1",(t="namespace")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}pathForType(){return"identity/mfa/method"}createOrUpdate(e,t,n){const l=e.serializerFor(t.modelName).serialize(n),{id:a}=n
return this.ajax(this.buildURL(t.modelName,a,n,"POST"),"POST",{data:l}).then((e=>({data:{...l,id:e?.data?.method_id||a}})))}createRecord(){return this.createOrUpdate(...arguments)}updateRecord(){return this.createOrUpdate(...arguments)}urlForDeleteRecord(e,t,n){return this.buildURL(t,e,n,"POST")}query(e,t,n){const l=this.urlForQuery(n,t.modelName)
return this.ajax(l,"GET",{data:{list:!0}})}buildURL(e,t,n,l){if("POST"===l){const l=`${super.buildURL(e)}/${n.attr("type")}`
return t?`${l}/${t}`:l}return super.buildURL(...arguments)}}e.default=n})),define("vault/adapters/mfa-setup",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{currentTokenGenerate(e){return this.ajax("/v1/identity/mfa/method/totp/generate","POST",{data:e})}adminDestroy(e){return this.ajax("/v1/identity/mfa/method/totp/admin-destroy","POST",{data:e})}}e.default=n})),define("vault/adapters/named-path",["exports","vault/adapters/application","@ember/debug"],(function(e,t,n){function l(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class a extends t.default{constructor(){super(...arguments),l(this,"namespace","v1"),l(this,"saveMethod","POST")}_saveRecord(e,t,n){let{modelName:l}=t
const a=e.serializerFor(l).serialize(n)
return this.ajax(this.urlForUpdateRecord(n.attr("name"),l,n),this.saveMethod,{data:a}).then((()=>a))}createRecord(){const[e,{modelName:t},n]=arguments,l=n.attr("name")
if(e.hasRecordForId(t,l))throw new Error(`A record already exists with the name: ${l}`)
return this._saveRecord(...arguments)}updateRecord(){return this._saveRecord(...arguments)}findRecord(e,t,n){return super.findRecord(...arguments).then((e=>(e.data.name||(e.data.name=n),e)))}async query(e,t,n){const l=this.urlForQuery(n,t.modelName),{paramKey:a,filterFor:i,allowed_client_id:r}=n,o={list:!0,...r&&{allowed_client_id:r}},s=await this.ajax(l,"GET",{data:o})
if(s.data.key_info&&i&&a&&!i.includes("*")){const e=this.filterListResponse(a,i,s.data.key_info)
return{...s,data:e}}return s}filterListResponse(e,t,n){const l=Object.entries(n).filter((n=>{const l=n[1]
return t.includes(l[e])})),a=Object.fromEntries(l)
return{keys:Object.keys(a),key_info:a}}}e.default=a})),define("vault/adapters/namespace",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{pathForType(){return"namespaces"}urlForFindAll(e,t){return t.adapterOptions&&t.adapterOptions.forUser?`/${this.urlPrefix()}/internal/ui/namespaces`:`/${this.urlPrefix()}/namespaces?list=true`}urlForCreateRecord(e,t){const n=t.attr("path")
return this.buildURL(e,n)}createRecord(e,t,n){const l=n.attr("path")
return super.createRecord(...arguments).then((()=>({id:l})))}findAll(e,t,n,l){return l.adapterOptions&&void 0!==l.adapterOptions.namespace?this.ajax(this.urlForFindAll("namespace",l),"GET",{namespace:l.adapterOptions.namespace}):super.findAll(...arguments)}query(){return this.ajax(`/${this.urlPrefix()}/namespaces?list=true`)}}e.default=n})),define("vault/adapters/node",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend()
e.default=n})),define("vault/adapters/oidc/assignment",["exports","vault/adapters/named-path"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{pathForType(){return"identity/oidc/assignment"}}e.default=n}))
define("vault/adapters/oidc/client",["exports","vault/adapters/named-path"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{pathForType(){return"identity/oidc/client"}}e.default=n})),define("vault/adapters/oidc/key",["exports","vault/adapters/named-path"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{pathForType(){return"identity/oidc/key"}rotate(e,t){const n=t?{verification_ttl:t}:{}
return this.ajax(`${this.urlForUpdateRecord(e,"oidc/key")}/rotate`,"POST",{data:n})}}e.default=n})),define("vault/adapters/oidc/provider",["exports","vault/adapters/named-path"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{pathForType(){return"identity/oidc/provider"}}e.default=n})),define("vault/adapters/oidc/scope",["exports","vault/adapters/named-path"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{pathForType(){return"identity/oidc/scope"}}e.default=n})),define("vault/adapters/path-filter-config",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({url(e){return`${this.buildURL()}/replication/performance/primary/paths-filter/${e}`},findRecord(e,t,n){return this.ajax(this.url(n),"GET").then((e=>(e.id=n,e)))},createRecord(e,t,n){return this.ajax(this.url(n.id),"PUT",{data:this.serialize(n)})},updateRecord(){return this.createRecord(...arguments)},deleteRecord(e,t,n){return this.ajax(this.url(n.id),"DELETE")}})
e.default=n})),define("vault/adapters/permissions",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({query(){const e=this.namespaceService.userRootNamespace||this.namespaceService.path
return this.ajax(this.urlForQuery(),"GET",{namespace:e})},urlForQuery(){return this.buildURL()+"/internal/ui/resultant-acl"}})
e.default=n})),define("vault/adapters/pki/action",["exports","@ember/debug","vault/utils/path-encoding-helpers","vault/adapters/application"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class a extends l.default{constructor(){var e,t,n
super(...arguments),n="v1",(t="namespace")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}urlForCreateRecord(e,t){const{type:l}=t.record,{actionType:a,useIssuer:i,issuerRef:r,mount:o}=t.adapterOptions,s=o||t.record.backend
if(!s||!a)throw new Error("URL for create record is missing required attributes")
const u=`${this.buildURL()}/${(0,n.encodePath)(s)}`
switch(a){case"import":return i?`${u}/issuers/import/bundle`:`${u}/config/ca`
case"generate-root":return i?`${u}/issuers/generate/root/${l}`:`${u}/root/generate/${l}`
case"generate-csr":return i?`${u}/issuers/generate/intermediate/${l}`:`${u}/intermediate/generate/${l}`
case"sign-intermediate":return`${u}/issuer/${(0,n.encodePath)(r)}/sign-intermediate`
case"rotate-root":return`${u}/root/rotate/${l}`}}createRecord(e,t,n){const l=e.serializerFor(t.modelName),a=this.urlForCreateRecord(t.modelName,n),i=l.serialize(n,n.adapterOptions.actionType)
return this.ajax(a,"POST",{data:i}).then((e=>({id:e.request_id,...e})))}}e.default=a})),define("vault/adapters/pki/certificate/base",["exports","vault/utils/path-encoding-helpers","vault/adapters/application"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends n.default{constructor(){var e,t,n
super(...arguments),n="v1",(t="namespace")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}getURL(e,n){const l=`${this.buildURL()}/${(0,t.encodePath)(e)}`
return n?`${l}/cert/${n}`:`${l}/certs`}fetchByQuery(e){const{backend:t,id:n}=e,l=n?{}:{list:!0}
return this.ajax(this.getURL(t,n),"GET",{data:l}).then((e=>(e.data.backend=t,n&&(e.data.id=n,e.data.serial_number=n),e)))}query(e,t,n){return this.fetchByQuery(n)}queryRecord(e,t,n){return this.fetchByQuery(n)}updateRecord(e,n,l){const{backend:a,serialNumber:i,certificate:r}=l.record,o=i?{serial_number:i}:{certificate:r}
return this.ajax(`${this.buildURL()}/${(0,t.encodePath)(a)}/revoke`,"POST",{data:o}).then((e=>({data:{...this.serialize(l),...e.data}})))}}e.default=l})),define("vault/adapters/pki/certificate/generate",["exports","vault/utils/path-encoding-helpers","vault/adapters/pki/certificate/base"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends n.default{urlForCreateRecord(e,n){const{role:l,backend:a}=n.record
if(!l||!a)throw new Error("URL for create record is missing required attributes")
return`${this.buildURL()}/${(0,t.encodePath)(a)}/issue/${(0,t.encodePath)(l)}`}}e.default=l})),define("vault/adapters/pki/certificate/sign",["exports","vault/utils/path-encoding-helpers","vault/adapters/pki/certificate/base"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends n.default{urlForCreateRecord(e,n){const{role:l,backend:a}=n.record
if(!l||!a)throw new Error("URL for create record is missing required attributes")
return`${this.buildURL()}/${(0,t.encodePath)(a)}/sign/${(0,t.encodePath)(l)}`}}e.default=l})),define("vault/adapters/pki/config/acme",["exports","vault/utils/path-encoding-helpers","vault/adapters/pki/config/base"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends n.default{constructor(){var e,t,n
super(...arguments),n="v1",(t="namespace")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}_url(e){return`${this.buildURL()}/${(0,t.encodePath)(e)}/config/acme`}}e.default=l})),define("vault/adapters/pki/config/base",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{constructor(){var e,t,n
super(...arguments),n="v1",(t="namespace")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}findRecord(e,t,n){return this.ajax(this._url(n),"GET").then((e=>e.data))}updateRecord(e,t,n){const l=n.serialize()
return this.ajax(this._url(n.record.id),"POST",{data:l})}}e.default=n})),define("vault/adapters/pki/config/cluster",["exports","vault/utils/path-encoding-helpers","vault/adapters/pki/config/base"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends n.default{constructor(){var e,t,n
super(...arguments),n="v1",(t="namespace")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}_url(e){return`${this.buildURL()}/${(0,t.encodePath)(e)}/config/cluster`}}e.default=l})),define("vault/adapters/pki/config/crl",["exports","vault/utils/path-encoding-helpers","vault/adapters/pki/config/base"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends n.default{constructor(){var e,t,n
super(...arguments),n="v1",(t="namespace")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}_url(e){return`${this.buildURL()}/${(0,t.encodePath)(e)}/config/crl`}}e.default=l})),define("vault/adapters/pki/config/urls",["exports","vault/utils/path-encoding-helpers","vault/adapters/pki/config/base"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends n.default{constructor(){var e,t,n
super(...arguments),n="v1",(t="namespace")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}_url(e){return`${this.buildURL()}/${(0,t.encodePath)(e)}/config/urls`}}e.default=l})),define("vault/adapters/pki/issuer",["exports","vault/adapters/application","vault/utils/path-encoding-helpers","rsvp","vault/utils/parse-pki-cert"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends t.default{constructor(){var e,t,n
super(...arguments),n="v1",(t="namespace")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}_getBackend(e){const{record:t,adapterOptions:n}=e
return n?.mount||t.backend}optionsForQuery(e){const t={}
return e||(t.list=!0),{data:t}}urlForQuery(e,t){const l=`${this.buildURL()}/${(0,n.encodePath)(e)}`
return t?`${l}/issuer/${(0,n.encodePath)(t)}`:`${l}/issuers`}async getIssuerMetadata(e,t,n,l,i){const r=l.data.key_info[i]
try{const l=await this.queryRecord(e,t,{id:i,backend:n.backend}),{data:o}=l,s=await(0,a.verifyCertificates)(o.certificate,o.certificate),u=(0,a.parseCertificate)(o.certificate)
return{...r,...o,isRoot:s,parsedCertificate:{common_name:u.common_name}}}catch(o){return{...r,issuer_id:i}}}updateRecord(e,t,n){const{issuerId:l}=n.record,a=this._getBackend(n),i=this.serialize(n),r=this.urlForQuery(a,l)
return this.ajax(r,"POST",{data:i})}query(e,t,n){const{backend:a,isListView:i}=n,r=this.urlForQuery(a)
return this.ajax(r,"GET",this.optionsForQuery()).then((async a=>{if(i&&a.data.keys.length<=10){const i=await(0,l.all)(a.data.keys.map((l=>this.getIssuerMetadata(e,t,n,a,l)))),r={}
return a.data.keys.forEach((e=>{r[e]=i.find((t=>t.issuer_id===e))})),a.data.key_info=r,a}return a}))}queryRecord(e,t,n){const{backend:l,id:a}=n
return this.ajax(this.urlForQuery(l,a),"GET",this.optionsForQuery(a))}deleteAllIssuers(e){const t=`${this.buildURL()}/${(0,n.encodePath)(e)}/root`
return this.ajax(t,"DELETE")}}e.default=i})),define("vault/adapters/pki/key",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{constructor(){var e,t,n
super(...arguments),n="v1",(t="namespace")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}_baseUrl(e,t){const l=`${this.buildURL()}/${(0,n.encodePath)(e)}`
return t?l+"/key/"+(0,n.encodePath)(t):l+"/keys"}createRecord(e,t,n){const{record:l,adapterOptions:a}=n
let i=this._baseUrl(l.backend)
return i=a.import?`${i}/import`:`${i}/generate/${l.type}`,this.ajax(i,"POST",{data:this.serialize(n)}).then((e=>e))}updateRecord(e,t,n){const{record:l}=n,{key_name:a}=this.serialize(n),i=this._baseUrl(l.backend,l.id)
return this.ajax(i,"POST",{data:{key_name:a}})}query(e,t,n){const{backend:l}=n
return this.ajax(this._baseUrl(l),"GET",{data:{list:!0}})}queryRecord(e,t,n){const{backend:l,id:a}=n
return this.ajax(this._baseUrl(l,a),"GET")}deleteRecord(e,t,n){const{id:l,record:a}=n
return this.ajax(this._baseUrl(a.backend,l),"DELETE")}}e.default=l})),define("vault/adapters/pki/role",["exports","vault/adapters/application","@ember/polyfills","vault/utils/path-encoding-helpers"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class a extends t.default{constructor(){var e,t,n
super(...arguments),n="v1",(t="namespace")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}_urlForRole(e,t){let n=`${this.buildURL()}/${(0,l.encodePath)(e)}/roles`
return t&&(n=n+"/"+(0,l.encodePath)(t)),n}_optionsForQuery(e){const t={}
return e||(t.list=!0),{data:t}}createRecord(e,t,n){const l=n.attr("name"),a=this._urlForRole(n.record.backend,l)
return this.ajax(a,"POST",{data:this.serialize(n)}).then((()=>({id:l,name:l,backend:n.record.backend})))}updateRecord(e,t,n){const{name:l,backend:a}=n.record,i=this.serialize(n),r=this._urlForRole(a,l)
return this.ajax(r,"POST",{data:i})}fetchByQuery(e,t){const{id:l,backend:a}=t
return this.ajax(this._urlForRole(a,l),"GET",this._optionsForQuery(l)).then((e=>{const t={id:l,name:l,backend:a}
return(0,n.assign)({},e,t)}))}query(e,t,n){return this.fetchByQuery(e,n)}queryRecord(e,t,n){return this.fetchByQuery(e,n)}deleteRecord(e,t,n){const{id:l,record:a}=n
return this.ajax(this._urlForRole(a.backend,l),"DELETE")}}e.default=a})),define("vault/adapters/pki/sign-intermediate",["exports","vault/utils/path-encoding-helpers","vault/adapters/application"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends n.default{constructor(){var e,t,n
super(...arguments),n="v1",(t="namespace")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}createRecord(e,n,l){const a=e.serializerFor(n.modelName),{backend:i,issuerRef:r}=l.record,o=`${this.buildURL()}/${(0,t.encodePath)(i)}/issuer/${(0,t.encodePath)(r)}/sign-intermediate`,s=a.serialize(l,n)
return this.ajax(o,"POST",{data:s}).then((e=>({id:e.request_id,...e})))}}e.default=l})),define("vault/adapters/pki/tidy",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{constructor(){var e,t,n
super(...arguments),n="v1",(t="namespace")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}_baseUrl(e){return`${this.buildURL()}/${(0,n.encodePath)(e)}`}createRecord(e,t,n){const{backend:l}=n.record,{tidyType:a}=n.adapterOptions
if("auto"===a)throw new Error("Auto tidy type models are never new, please use findRecord")
const i=`${this._baseUrl(l)}/tidy`
return this.ajax(i,"POST",{data:this.serialize(n,a)})}updateRecord(e,t,n){const l=n.record.id,{tidyType:a}=n.adapterOptions
if("manual"===a)throw new Error("Manual tidy type models are always new, please use createRecord")
const i=`${this._baseUrl(l)}/config/auto-tidy`
return this.ajax(i,"POST",{data:this.serialize(n,a)})}findRecord(e,t,n){return this.ajax(`${this._baseUrl(n)}/config/auto-tidy`,"GET").then((e=>e.data))}cancelTidy(e){const t=`${this._baseUrl(e)}`
return this.ajax(`${t}/tidy-cancel`,"POST")}}e.default=l})),define("vault/adapters/policy",["exports","@ember/polyfills","vault/adapters/application"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=n.default.extend({namespace:"v1/sys",pathForType:e=>e.replace("policy","policies"),createOrUpdate(e,n,l){const a=e.serializerFor("policy").serialize(l),i=l.attr("name")
return this.ajax(this.buildURL(n.modelName,i),"PUT",{data:a}).then((()=>({data:(0,t.assign)({},this.serialize(l),{id:i})})))},createRecord(){return this.createOrUpdate(...arguments)},updateRecord(){return this.createOrUpdate(...arguments)},query(e,t){return this.ajax(this.buildURL(t.modelName),"GET",{data:{list:!0}})}})
e.default=l})),define("vault/adapters/policy/acl",["exports","vault/adapters/policy"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend()
e.default=n})),define("vault/adapters/policy/egp",["exports","vault/adapters/policy"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend()
e.default=n})),define("vault/adapters/policy/rgp",["exports","vault/adapters/policy"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend()
e.default=n})),define("vault/adapters/raft-join",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({urlForCreateRecord:()=>"/v1/sys/storage/raft/join"})
e.default=n})),define("vault/adapters/replication-mode",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({getStatusUrl(e){return this.buildURL()+`/replication/${e}/status`},fetchStatus(e){const t=this.getStatusUrl(e)
return this.ajax(t,"GET",{unauthenticated:!0}).then((e=>e.data))}})
e.default=n})),define("vault/adapters/role-aws",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend({namespace:"v1",createOrUpdate(e,t,n,l){const{name:a,backend:i}=n.record,r=e.serializerFor(t.modelName).serialize(n,l),o=this.urlForRole(i,a)
return this.ajax(o,"POST",{data:r}).then((e=>{const t=e||{data:{}}
return t.data.name=a,t.data.backend=a,t}))},createRecord(){return this.createOrUpdate(...arguments)},updateRecord(){return this.createOrUpdate(...arguments,"update")},deleteRecord(e,t,n){const{id:l}=n
return this.ajax(this.urlForRole(n.record.get("backend"),l),"DELETE")},pathForType:()=>"roles",urlForRole(e,t){let l=`${this.buildURL()}/${(0,n.encodePath)(e)}/roles`
return t&&(l=l+"/"+(0,n.encodePath)(t)),l},optionsForQuery(e){const t={}
return e||(t.list=!0),{data:t}},fetchByQuery(e,t){const{id:n,backend:l}=t
return this.ajax(this.urlForRole(l,n),"GET",this.optionsForQuery(n)).then((e=>({...e,...{id:n,name:n,backend:l}})))},query(e,t,n){return this.fetchByQuery(e,n)},queryRecord(e,t,n){return this.fetchByQuery(e,n)}})
e.default=l})),define("vault/adapters/role-jwt",["exports","vault/adapters/application","@ember/service","vault/utils/path-encoding-helpers"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=t.default.extend({router:(0,n.inject)(),findRecord(e,t,n,a){let[i,r]=JSON.parse(n)
i=(0,l.encodePath)(i)
const o=a?.adapterOptions.namespace,s=`/v1/auth/${i}/oidc/auth_url`
let u=`${window.location.origin}${this.router.urlFor("vault.cluster.oidc-callback",{auth_path:i})}`
return o&&(u=`${window.location.origin}${this.router.urlFor("vault.cluster.oidc-callback",{auth_path:i},{queryParams:{namespace:o}})}`),this.ajax(s,"POST",{data:{role:r,redirect_uri:u}})}})
e.default=a})),define("vault/adapters/role-saml",["exports","vault/adapters/application","@ember/service","vault/utils/path-encoding-helpers","uuid"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=t.default.extend({router:(0,n.inject)(),async generateClientChallenge(e){const t=(new TextEncoder).encode(e),n=await crypto.subtle.digest("SHA-256",t),l=new Uint8Array(n)
return btoa(String.fromCharCode.apply(null,l))},async findRecord(e,t,n,l){let[i,o]=JSON.parse(n)
i=r(i)
let s=`${window.location.origin}/v1/`,u=l?.adapterOptions.namespace
u&&(u=r(u),s=s.concat(u,"/")),s=s.concat("auth/",i,"/callback")
const d=(0,a.v4)(),c=await this.generateClientChallenge(d)
return{...(await this.ajax(`/v1/auth/${i}/sso_service_url`,"PUT",{data:{acs_url:s,role:o,client_challenge:c,client_type:"browser"}})).data,client_verifier:d}}})
function r(e){return e=(e=e.replace(/^\//,"")).replace(/\/$/,""),(0,l.encodePath)(e)}e.default=i})),define("vault/adapters/role-ssh",["exports","@ember/polyfills","rsvp","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=l.default.extend({namespace:"v1",createOrUpdate(e,t,n,l){const{name:a,backend:i}=n.record,r=e.serializerFor(t.modelName).serialize(n,l),o=this.urlForRole(i,a)
return this.ajax(o,"POST",{data:r}).then((e=>{const t=e||{data:{}}
return t.data.name=a,t}))},createRecord(){return this.createOrUpdate(...arguments)},updateRecord(){return this.createOrUpdate(...arguments,"update")},deleteRecord(e,t,n){const{id:l}=n
return this.ajax(this.urlForRole(n.record.get("backend"),l),"DELETE")},pathForType:()=>"roles",urlForRole(e,t){let n=`${this.buildURL()}/${(0,a.encodePath)(e)}/roles`
return t&&(n=n+"/"+(0,a.encodePath)(t)),n},optionsForQuery(e){const t={}
return e||(t.list=!0),{data:t}},fetchByQuery(e,l){const{id:a,backend:i}=l
let r=(0,n.resolve)()
const o=this.ajax(this.urlForRole(i,a),"GET",this.optionsForQuery(a))
return a||(r=this.findAllZeroAddress(e,l)),(0,n.allSettled)([o,r]).then((e=>{if(!e[0].value)throw e[0].reason
const n={id:a,name:a,backend:i,data:{}}
return e.forEach((e=>{e.value&&(e.value.data.roles?n.data=(0,t.assign)({},n.data,{zero_address_roles:e.value.data.roles}):n.data=(0,t.assign)({},n.data,e.value.data))})),n}))},findAllZeroAddress(e,t){const{backend:n}=t,l=`/v1/${(0,a.encodePath)(n)}/config/zeroaddress`
return this.ajax(l,"GET")},query(e,t,n){return this.fetchByQuery(e,n)},queryRecord(e,t,n){return this.fetchByQuery(e,n)}})
e.default=i}))
define("vault/adapters/secret-engine",["exports","@ember/polyfills","vault/adapters/application","vault/utils/path-encoding-helpers","vault/helpers/split-object"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=n.default.extend({url(e){const t=`${this.buildURL()}/mounts`
return e?t+"/"+(0,l.encodePath)(e):t},urlForConfig:e=>`/v1/${e}/config`,internalURL(e){let t=`/${this.urlPrefix()}/internal/ui/mounts`
return e&&(t=`${t}/${(0,l.encodePath)(e)}`),t},pathForType:()=>"mounts",async query(e,t,n){let l,a
try{l=await this.ajax(this.internalURL(n.path),"GET"),"kv"===l?.data?.type&&"2"===l?.data?.options?.version&&(a=await this.ajax(this.urlForConfig(n.path),"GET"),l.data={...l.data,...a.data})}catch(i){if(!n.path||!l)throw i}return l},async createRecord(e,n,l){let i=e.serializerFor(n.modelName).serialize(l)
const r=l.attr("path")
if(i.config.id=r,"kv"===i.type&&2===i.options.version){const e=(0,a.splitObject)(i,["max_versions","delete_version_after","cas_required"])
let n;[n,i]=e,i.id||(i.id=r),await this.ajax(this.url(r),"POST",{data:i})
try{await this.ajax(this.urlForConfig(r),"POST",{data:n})}catch(o){}return{data:(0,t.assign)({},i,{path:r+"/",id:r})}}return this.ajax(this.url(r),"POST",{data:i}).then((()=>({data:(0,t.assign)({},i,{path:r+"/",id:r})})))},findRecord(e,t,n,a){if("ssh"===a.attr("type"))return this.ajax(`/v1/${(0,l.encodePath)(n)}/config/ca`,"GET")},queryRecord(e,t,n){if("aws"===n.type)return this.ajax(`/v1/${(0,l.encodePath)(n.backend)}/config/lease`,"GET").then((e=>(e.path=n.backend+"/",e)))},updateRecord(e,t,n){const{apiPath:a,options:i,adapterMethod:r}=n.adapterOptions
if(r)return this[r](...arguments)
if(a){const r=e.serializerFor(t.modelName).serialize(n),o=(0,l.encodePath)(n.id)
return this.ajax(`/v1/${o}/${a}`,i.isDelete?"DELETE":"POST",{data:r})}},saveAWSRoot(e,t,n){const{data:a}=n.adapterOptions,i=(0,l.encodePath)(n.id)
return this.ajax(`/v1/${i}/config/root`,"POST",{data:a})},saveAWSLease(e,t,n){const{data:a}=n.adapterOptions,i=(0,l.encodePath)(n.id)
return this.ajax(`/v1/${i}/config/lease`,"POST",{data:a})},saveZeroAddressConfig(e,t,n){const a=(0,l.encodePath)(n.id),i=e.peekAll("role-ssh").filterBy("zeroAddress").mapBy("id").join(","),r=`/v1/${a}/config/zeroaddress`,o={roles:i}
return""===i?this.ajax(r,"DELETE"):this.ajax(r,"POST",{data:o})}})
e.default=i})),define("vault/adapters/secret-v2-version",["exports","@ember-data/adapter/error","@ember/utils","@ember/object","vault/adapters/application","vault/utils/path-encoding-helpers","@ember/service"],(function(e,t,n,l,a,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var o=a.default.extend({store:(0,r.inject)(),namespace:"v1",_url(e,t){let l=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"data",a=`${this.buildURL()}/${(0,i.encodePath)(e)}/${l}/`
return(0,n.isEmpty)(t)||(a+=(0,i.encodePath)(t)),a},urlForFindRecord(e){let[t,n,l]=JSON.parse(e),a=this._url(t,n)
return l?a+`?version=${l}`:a},urlForQueryRecord(e){return this.urlForFindRecord(e)},findRecord(){return this._super(...arguments).catch((e=>{if(e instanceof t.default)throw e
return e}))},async getSecretDataVersion(e,t){this._url(e,t)
return(await this.ajax(this._url(e,t),"GET")).data.metadata.version},queryRecord(e,t){return this.ajax(this.urlForQueryRecord(e),"GET",t).then((n=>(t.wrapTTL||(n.id=e,n.backend=backend),n)))},querySecretDataByVersion(e){return this.ajax(this.urlForQueryRecord(e),"GET").then((e=>e.data)).catch((e=>e.data))},urlForCreateRecord(e,t){let n=t.belongsTo("secret").belongsTo("engine").id,l=t.attr("path")
return this._url(n,l)},createRecord(e,t,n){let l=n.belongsTo("secret").belongsTo("engine").id,a=n.attr("path")
return this._super(...arguments).then((e=>(e.id=JSON.stringify([l,a,e.version]),e)))},urlForUpdateRecord(e){let[t,n]=JSON.parse(e)
return this._url(t,n)},async deleteLatestVersion(e,t){try{await this.ajax(this._url(e,t,"data"),"DELETE")
let n=this.store.peekRecord("secret-v2-version",t)
return await n.reload(),n&&n.rollbackAttributes()}catch(n){return n}},async undeleteVersion(e,t,n){try{await this.ajax(this._url(e,t,"undelete"),"POST",{data:{versions:[n]}})
let l=this.store.peekRecord("secret-v2-version",t)
return await l.reload(),l&&l.rollbackAttributes()}catch(l){return l}},async softDelete(e,t,n){try{await this.ajax(this._url(e,t,"delete"),"POST",{data:{versions:[n]}})
let l=this.store.peekRecord("secret-v2-version",t)
return await l.reload(),l&&l.rollbackAttributes()}catch(l){return l}},async deleteByDeleteType(e,t,n,l){try{await this.ajax(this._url(e,t,n),"POST",{data:{versions:[l]}})
let a=this.store.peekRecord("secret-v2-version",t)
return await a.reload(),a&&a.rollbackAttributes()}catch(a){return a}},v2DeleteOperation(e,t){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"delete",l=arguments.length>3?arguments[3]:void 0,[a,i,r]=JSON.parse(t)
return l&&"delete"===n||"delete-latest-version"===n?this.deleteLatestVersion(a,i):"undelete"!==n||r?"soft-delete"===n?this.softDelete(a,i,r):(r=r||l,this.deleteByDeleteType(a,i,n,r)):this.undeleteVersion(a,i,l)},handleResponse(e,t,n,a){return 404===e&&(0,l.get)(n,"data.metadata")?this._super(200,t,n,a):this._super(...arguments)}})
e.default=o})),define("vault/adapters/secret-v2",["exports","@ember/utils","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=n.default.extend({namespace:"v1",_url(e,n){let a=`${this.buildURL()}/${(0,l.encodePath)(e)}/metadata/`
return(0,t.isEmpty)(n)||(a+=(0,l.encodePath)(n)),a},query(e,t,n){let{backend:l,id:a}=n
return this.ajax(this._url(l,a),"GET",{data:{list:!0}}).then((e=>(e.id=a,e.backend=l,e)))},urlForQueryRecord(e){let{id:t,backend:n}=e
return this._url(n,t)},queryRecord(e,t,n){let{backend:l,id:a}=n
return this.ajax(this._url(l,a),"GET").then((e=>(e.id=a,e.backend=l,e)))},detailURL(e){let t=e.belongsTo("engine",{id:!0})||e.attr("engineId"),{id:n}=e
return this._url(t,n)},urlForUpdateRecord(e,t,n){return this.detailURL(n)},urlForCreateRecord(e,t){return this.detailURL(t)},urlForDeleteRecord(e,t,n){return this.detailURL(n)}})
e.default=a})),define("vault/adapters/secret",["exports","@ember/utils","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=n.default.extend({namespace:"v1",createOrUpdate(e,t,n){const l=e.serializerFor(t.modelName).serialize(n),{id:a}=n,i=n.record.path
return this.ajax(this.urlForSecret(n.attr("backend"),i||a),"POST",{data:l}).then((()=>(l.id=i||a,l)))},createRecord(){return this.createOrUpdate(...arguments)},updateRecord(){return this.createOrUpdate(...arguments)},deleteRecord(e,t,n){const{id:l}=n
return this.ajax(this.urlForSecret(n.attr("backend"),l),"DELETE")},urlForSecret(e,n){let a=`${this.buildURL()}/${(0,l.encodePath)(e)}/`
return(0,t.isEmpty)(n)||(a+=(0,l.encodePath)(n)),a},pathForType:()=>"mounts",optionsForQuery(e,t,n){const l={}
return"query"===t&&(l.list=!0),n?{data:l,wrapTTL:n}:{data:l}},fetchByQuery(e,t){const{id:n,backend:l,wrapTTL:a}=e
return this.ajax(this.urlForSecret(l,n),"GET",this.optionsForQuery(n,t,a)).then((e=>(a||(e.id=n,e.backend=l),e)))},query(e,t,n){return this.fetchByQuery(n,"query")},queryRecord(e,t,n){return this.fetchByQuery(n,"queryRecord")}})
e.default=a})),define("vault/adapters/secrets-engine-path",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{constructor(){var e,t,n
super(...arguments),n="v1",(t="namespace")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}_getURL(e,t){return`${this.buildURL()}/${(0,n.encodePath)(e)}/${t||this.path}`}urlForUpdateRecord(e,t,n){return this._getURL(n.attr("backend"))}urlForDeleteRecord(e){return this._getURL(e)}queryRecord(e,t,n){const{backend:l}=n
return this.ajax(this._getURL(l),"GET").then((e=>(e.backend=l,e)))}createRecord(){return this._saveRecord(...arguments)}updateRecord(){return this._saveRecord(...arguments)}_saveRecord(e,t,n){let{modelName:l}=t
const a=e.serializerFor(l).serialize(n),i=this._getURL(n.attr("backend"))
return this.ajax(i,"POST",{data:a}).then((()=>a))}}e.default=l})),define("vault/adapters/server",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const n="/v1/sys/storage/raft/configuration"
var l=t.default.extend({urlForFindAll:()=>n,urlForQuery:()=>n,urlForDeleteRecord:()=>"/v1/sys/storage/raft/remove-peer",deleteRecord(e,t,n){const l=n.attr("nodeId")
return this.ajax("/v1/sys/storage/raft/remove-peer","POST",{data:{server_id:l}})}})
e.default=l})),define("vault/adapters/ssh-otp-credential",["exports","vault/adapters/ssh"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({url:e=>`/v1/${e.backend}/creds/${e.name}`})
e.default=n})),define("vault/adapters/ssh-sign",["exports","vault/adapters/ssh"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({url:e=>`/v1/${e.backend}/sign/${e.name}`})
e.default=n})),define("vault/adapters/ssh",["exports","@ember/debug","vault/adapters/application"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=n.default.extend({namespace:"v1",url(){},createRecord(e,t,n,l){const a=e.serializerFor(t.modelName).serialize(n,l),i=n.attr("role")
return this.ajax(this.url(i),"POST",{data:a}).then((l=>{l.id=n.id,l.modelName=t.modelName,e.pushPayload(t.modelName,l)}))}})
e.default=l})),define("vault/adapters/tools",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const n=["lookup","wrap","unwrap","rewrap"],l=["random","hash"]
var a=t.default.extend({toolUrlFor(e){const t=n.includes(e),a=l.includes(e),i=t?"wrapping":"tools"
if(!t&&!a)throw new Error(`Calls to a ${e} endpoint are not currently allowed in the tool adapter`)
return`${this.buildURL()}/${i}/${e}`},toolAction(e,t){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{}
const{wrapTTL:l,clientToken:a}=n,i=this.toolUrlFor(e),r=l?{data:t,wrapTTL:l,clientToken:a}:{data:t,clientToken:a}
return this.ajax(i,"POST",r)}})
e.default=a})),define("vault/adapters/transform",["exports","@ember/polyfills","rsvp","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=l.default.extend({namespace:"v1",createOrUpdate(e,t,n){let{modelName:l}=t
const{backend:a,name:i,type:r}=n.record,o=e.serializerFor(l).serialize(n),s=this.urlForTransformations(a,i,r)
return this.ajax(s,"POST",{data:o}).then((e=>{const t=e||{}
return t.id=i,t}))},createRecord(){return this.createOrUpdate(...arguments)},updateRecord(){return this.createOrUpdate(...arguments,"update")},deleteRecord(e,t,n){const{id:l}=n
return this.ajax(this.urlForTransformations(n.record.get("backend"),l),"DELETE")},pathForType:()=>"transform",urlForTransformations(e,t,n){const l=`${this.buildURL()}/${(0,a.encodePath)(e)}`,i=n?`${l}/transformations/${n}`:`${l}/transformation`
return t?`${i}/${(0,a.encodePath)(t)}`:i},optionsForQuery(e){const t={}
return e||(t.list=!0),{data:t}},fetchByQuery(e,l){const{id:a,backend:i}=l,r=this.ajax(this.urlForTransformations(i,a),"GET",this.optionsForQuery(a))
return(0,n.allSettled)([r]).then((e=>{if(!e[0].value)throw e[0].reason
const n={id:a,name:a,backend:i,data:{}}
return e.forEach((e=>{if(e.value){let l=e.value.data
l.templates&&(l={...l,template:l.templates},delete l.templates),n.data=(0,t.assign)({},n.data,l)}})),n}))},query(e,t,n){return this.fetchByQuery(e,n)},queryRecord(e,t,n){return this.fetchByQuery(e,n)}})
e.default=i})),define("vault/adapters/transform/alphabet",["exports","vault/adapters/transform/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({pathForType:()=>"alphabet"})
e.default=n})),define("vault/adapters/transform/base",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend({namespace:"v1",pathForType:e=>e.replace("transform/",""),createOrUpdate(e,t,n){const{backend:l,name:a}=n.record,i=e.serializerFor(t.modelName).serialize(n),r=this.url(l,t.modelName,a)
return this.ajax(r,"POST",{data:i}).then((e=>{const t=e||{data:{}}
return t.data.name=a,t}))},createRecord(){return this.createOrUpdate(...arguments)},updateRecord(){return this.createOrUpdate(...arguments,"update")},deleteRecord(e,t,n){const{id:l}=n
return this.ajax(this.url(n.record.get("backend"),t.modelName,l),"DELETE")},url(e,t,l){const a=this.pathForType(t),i=`/${this.namespace}/${(0,n.encodePath)(e)}/${(0,n.encodePath)(a)}`
return l?`${i}/${(0,n.encodePath)(l)}`:i+"?list=true"},fetchByQuery(e){const{backend:t,modelName:n,id:l}=e
return this.ajax(this.url(t,n,l),"GET").then((e=>({...e,backend:t,id:l,name:l})))},query(e,t,n){return this.fetchByQuery(n)},queryRecord(e,t,n){return this.ajax(this.url(n.backend,t.modelName,n.id),"GET").then((e=>({id:n.id,name:n.id,...e})))}})
e.default=l})),define("vault/adapters/transform/role",["exports","vault/adapters/transform/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({pathForType:()=>"role"})
e.default=n})),define("vault/adapters/transform/template",["exports","vault/adapters/transform/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({pathForType:()=>"template"})
e.default=n})),define("vault/adapters/transform/transformation",["exports","vault/adapters/transform/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({})
e.default=n})),define("vault/adapters/transit-key",["exports","vault/adapters/application","ember-inflector","vault/utils/path-encoding-helpers"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=t.default.extend({namespace:"v1",createOrUpdate(e,t,n,l){const a=e.serializerFor(t.modelName).serialize(n,l),i=n.attr("name")
let r=this.urlForSecret(n.record.get("backend"),i)
return"update"===l&&(r+="/config"),this.ajax(r,"POST",{data:a}).then((e=>{const t=e||{}
return t.id=i,t}))},createRecord(){return this.createOrUpdate(...arguments)},updateRecord(){return this.createOrUpdate(...arguments,"update")},deleteRecord(e,t,n){const{id:l}=n
return this.ajax(this.urlForSecret(n.record.get("backend"),l),"DELETE")},pathForType(e){let t
switch(e){case"cluster":t="clusters"
break
case"secret-engine":t="secrets"
break
default:t=(0,n.pluralize)(e)}return t},urlForSecret(e,t){let n=`${this.buildURL()}/${(0,l.encodePath)(e)}/keys/`
return t&&(n+=(0,l.encodePath)(t)),n},urlForAction(e,t,n,a){const i=`${this.buildURL()}/${(0,l.encodePath)(t)}/${e}`
if("hash"===e||"random"===e)return i
if("datakey"===e&&a)return`${i}/${a}/${(0,l.encodePath)(n)}`
if("export"===e&&a){const[e,t]=a,r=`${i}/${e}-key/${(0,l.encodePath)(n)}`
return t?`${r}/${t}`:r}return`${i}/${(0,l.encodePath)(n)}`},optionsForQuery(e){const t={}
return e||(t.list=!0),{data:t}},fetchByQuery(e){const{id:t,backend:n}=e
return this.ajax(this.urlForSecret(n,t),"GET",this.optionsForQuery(t)).then((e=>(e.id=t,e.backend=n,e)))},query(e,t,n){return this.fetchByQuery(n)},queryRecord(e,t,n){return this.fetchByQuery(n)},keyAction(e,t){let{backend:n,id:l,payload:a}=t,i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{}
const r="export"===e?"GET":"POST",{wrapTTL:o}=i
if("rotate"===e)return this.ajax(this.urlForSecret(n,l)+"/rotate",r)
const{param:s}=a
return delete a.param,this.ajax(this.urlForAction(e,n,l,s),r,{data:a,wrapTTL:o})}})
e.default=a})),define("vault/app",["exports","@ember/application","ember-resolver","ember-load-initializers","vault/config/environment"],(function(e,t,n,l,a){function i(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class r extends t.default{constructor(){super(...arguments),i(this,"modulePrefix",a.default.modulePrefix),i(this,"podModulePrefix",a.default.podModulePrefix),i(this,"Resolver",n.default),i(this,"engines",{openApiExplorer:{dependencies:{services:["auth","flash-messages","namespace","router","version"]}},replication:{dependencies:{services:["auth","flash-messages","namespace","replication-mode","router","store","version"],externalRoutes:{replication:"vault.cluster.replication.index"}}},kmip:{dependencies:{services:["auth","download","flash-messages","namespace","path-help","router","store","version","secret-mount-path"],externalRoutes:{secrets:"vault.cluster.secrets.backends"}}},kubernetes:{dependencies:{services:["router","store","secret-mount-path","flash-messages"],externalRoutes:{secrets:"vault.cluster.secrets.backends"}}},ldap:{dependencies:{services:["router","store","secret-mount-path","flash-messages","auth"],externalRoutes:{secrets:"vault.cluster.secrets.backends"}}},kv:{dependencies:{services:["download","namespace","router","store","secret-mount-path","flash-messages","control-group"],externalRoutes:{secrets:"vault.cluster.secrets.backends"}}},pki:{dependencies:{services:["auth","download","flash-messages","namespace","path-help","router","secret-mount-path","store","version"],externalRoutes:{secrets:"vault.cluster.secrets.backends",externalMountIssuer:"vault.cluster.secrets.backend.pki.issuers.issuer.details",secretsListRootConfiguration:"vault.cluster.secrets.backend.configuration"}}}})}}e.default=r,(0,l.default)(r,a.default.modulePrefix)})),define("vault/breakpoints",["exports"],(function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default={mobile:"(max-width: 768px)",tablet:"(min-width: 769px)",desktop:"(min-width: 1088px)"}})),define("vault/component-managers/glimmer",["exports","@glimmer/component/-private/ember-component-manager"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/-dynamic-element-alt",["exports","@glimmer/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/components/-dynamic-element",["exports","@glimmer/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/components/alert-inline",["exports","core/components/alert-inline"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/alphabet-edit",["exports","vault/components/transform-edit-base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({})
e.default=n})),define("vault/components/auth-config-form/config",["exports","@ember-data/adapter/error","@ember/service","@ember/component","ember-concurrency","@ember/test-waiters"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=l.default.extend({tagName:"",model:null,flashMessages:(0,n.inject)(),router:(0,n.inject)(),saveModel:(0,a.task)((0,i.waitFor)((function*(){try{yield this.model.save()}catch(e){if(e instanceof t.default==!1)throw e
return}this.router.transitionTo("vault.cluster.access.methods").followRedirects(),this.flashMessages.success("The configuration was saved successfully.")})))})
r.reopenClass({positionalParams:["model"]})
var o=r
e.default=o})),define("vault/components/auth-config-form/options",["exports","@ember-data/adapter/error","vault/components/auth-config-form/config","@ember/service","ember-concurrency","@ember/test-waiters"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=n.default.extend({flashMessages:(0,l.inject)(),router:(0,l.inject)(),saveModel:(0,a.task)((0,i.waitFor)((function*(){const e=this.model.config.serialize()
e.description=this.model.description,"token"===this.model.methodType&&delete e.token_type
try{yield this.model.tune(e)}catch(n){if(n instanceof t.default==!1)throw n
try{this.model.set("errorMessage",n.errors.firstObject)}catch{}return}this.router.transitionTo("vault.cluster.access.methods").followRedirects(),this.flashMessages.success("The configuration was saved successfully.")})))})
e.default=r})),define("vault/components/auth-form-options",["exports","@ember/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({})
e.default=n})),define("vault/components/auth-form",["exports","ember","@ember/runloop","@ember/service","@ember/object/computed","@ember/string","@ember/component","@ember/object","vault/helpers/supported-auth-backends","ember-concurrency","@ember/test-waiters","uuid"],(function(e,t,n,l,a,i,r,o,s,u,d,c){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const p={token:null,username:null,password:null,customPath:null}
var m=r.default.extend(p,{router:(0,l.inject)(),auth:(0,l.inject)(),flashMessages:(0,l.inject)(),store:(0,l.inject)(),csp:(0,l.inject)("csp-event"),version:(0,l.inject)(),selectedAuth:null,methods:null,cluster:null,namespace:null,wrappedToken:null,oldNamespace:null,oktaNumberChallengeAnswer:null,authMethods:(0,o.computed)("version.isEnterprise",(function(){return this.version.isEnterprise?(0,s.allSupportedAuthBackends)():(0,s.supportedAuthBackends)()})),didReceiveAttrs(){this._super(...arguments)
const{wrappedToken:e,oldWrappedToken:t,oldNamespace:l,namespace:a,selectedAuth:i,oldSelectedAuth:r,cancelAuthForOktaNumberChallenge:o}=this
o&&(this.set("oktaNumberChallengeAnswer",null),this.authenticate.cancelAll(),this.pollForOktaNumberChallenge.cancelAll()),(0,n.next)((()=>{e||null!==l&&l===a||this.fetchMethods.perform(),this.set("oldNamespace",a),e&&!t&&(this.unwrapToken.perform(e),this.set("oldWrappedToken",e)),r&&r!==i&&this.resetDefaults(),this.set("oldSelectedAuth",i)}))},didRender(){this._super(...arguments)
const e=this.element.querySelector("li.is-active")
e&&e.scrollIntoView(),(0,n.next)((()=>{const e=this.firstMethod()
!this.wrappedToken&&(this.fetchMethods.isIdle&&e&&!this.selectedAuth||this.selectedAuth&&!this.selectedAuthBackend)&&this.set("selectedAuth",e)}))},firstMethod(){const e=this.methodsToShow.firstObject
if(e)return e.path||e.type},resetDefaults(){this.setProperties(p)},getAuthBackend(e){const{wrappedToken:t,methods:n,selectedAuth:l,selectedAuthIsPath:a}=this,i=e||l
return n||t?a&&!e?n.findBy("path",i):this.authMethods.findBy("type",i):{}},selectedAuthIsPath:(0,a.match)("selectedAuth",/\/$/),selectedAuthBackend:(0,o.computed)("wrappedToken","methods","methods.[]","selectedAuth","selectedAuthIsPath",(function(){return this.getAuthBackend()})),providerName:(0,o.computed)("selectedAuthBackend.type",(function(){if(!this.selectedAuthBackend)return
let e=this.selectedAuthBackend.type||"token"
e=e.toLowerCase()
return(0,i.dasherize)(e)})),hasCSPError:(0,a.alias)("csp.connectionViolations.firstObject"),cspErrorText:"This is a standby Vault node but can't communicate with the active node via request forwarding. Sign in at the active node to use the Vault UI.",allSupportedMethods:(0,o.computed)("methodsToShow","hasMethodsWithPath","authMethods",(function(){const e=this.hasMethodsWithPath,t=this.methodsToShow
return e?t.concat(this.authMethods):t})),hasMethodsWithPath:(0,o.computed)("methodsToShow",(function(){return this.methodsToShow.isAny("path")})),methodsToShow:(0,o.computed)("methods","authMethods",(function(){const e=(this.methods||[]).filter((e=>this.authMethods.find((t=>t.type.toLowerCase()===e.type.toLowerCase()))))
return e.length?e:this.authMethods})),unwrapToken:(0,u.task)((0,d.waitFor)((function*(e){this.set("selectedAuth","token")
const t=this.store.adapterFor("tools")
try{const n=yield t.toolAction("unwrap",null,{clientToken:e})
this.set("token",n.auth.client_token),this.send("doSubmit")}catch(n){this.set("error",`Token unwrap failed: ${n.errors[0]}`)}}))),fetchMethods:(0,u.task)((0,d.waitFor)((function*(){const e=this.store
try{const t=yield e.findAll("auth-method",{adapterOptions:{unauthenticated:!0}})
this.set("methods",t.map((e=>{const t=e.serialize({includeId:!0})
return{...t,mountDescription:t.description}}))),(0,n.next)((()=>{e.unloadAll("auth-method")}))}catch(t){this.set("error",`There was an error fetching Auth Methods: ${t.errors[0]}`)}}))),showLoading:(0,a.or)("isLoading","authenticate.isRunning","fetchMethods.isRunning","unwrapToken.isRunning"),authenticate:(0,u.task)((0,d.waitFor)((function*(e,t){const{selectedAuth:n,cluster:{id:l}}=this
try{"okta"===e?this.pollForOktaNumberChallenge.perform(t.nonce,t.path):this.delayAuthMessageReminder.perform()
const a=yield this.auth.authenticate({clusterId:l,backend:e,data:t,selectedAuth:n})
this.onSuccess(a,e,t)}catch(a){this.set("isLoading",!1),this.auth.mfaError||this.set("error",`Authentication failed: ${this.auth.handleError(a)}`)}}))),pollForOktaNumberChallenge:(0,u.task)((function*(e,n){if(yield(0,u.timeout)(1e3),this.error)return
let l=null
for(this.setOktaNumberChallenge(!0),this.setCancellingAuth(!1);null===l;){if(t.default.testing)return
yield(0,u.timeout)(1e3),l=yield this.auth.getOktaNumberChallengeAnswer(e,n)}this.set("oktaNumberChallengeAnswer",l)})),delayAuthMessageReminder:(0,u.task)((function*(){t.default.testing?yield(0,u.timeout)(0):yield(0,u.timeout)(5e3)})),actions:{doSubmit(e,t,n){t&&t.preventDefault(),n&&this.set("token",n),this.set("error",null)
const l=n?this.getAuthBackend("token"):this.selectedAuthBackend||{},a=(this.authMethods.find((e=>(e.type||"").toLowerCase()===(l.type||"").toLowerCase()))||{}).formAttributes||[],i=this.getProperties(...a)
return e&&Object.assign(i,e),(this.customPath||l.id)&&(i.path=this.customPath||l.id),"okta"===l.type&&(i.nonce=(0,c.v4)(),i.path||(i.path="okta")),this.authenticate.unlinked().perform(l.type,i)},handleError(e){this.setProperties({isLoading:!1,error:e?this.auth.handleError(e):null})},returnToLoginFromOktaNumberChallenge(){this.setOktaNumberChallenge(!1),this.set("oktaNumberChallengeAnswer",null)}}})
e.default=m})),define("vault/components/auth-jwt",["exports","ember","@ember/service","vault/components/outer-html","ember-concurrency","@ember/object","@ember/test-waiters"],(function(e,t,n,l,a,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=e.ERROR_WINDOW_CLOSED=e.ERROR_MISSING_PARAMS=e.ERROR_JWT_LOGIN=void 0
const o="The provider window was closed before authentication was complete. Your web browser may have blocked or closed a pop-up window. Please check your settings and click Sign In to try again."
e.ERROR_WINDOW_CLOSED=o
const s="The callback from the provider did not supply all of the required parameters.  Please click Sign In to try again. If the problem persists, you may want to contact your administrator."
e.ERROR_MISSING_PARAMS=s
const u="OIDC login is not configured for this mount"
e.ERROR_JWT_LOGIN=u
var d=l.default.extend({store:(0,n.inject)(),featureFlagService:(0,n.inject)("featureFlag"),selectedAuthPath:null,selectedAuthType:null,roleName:null,role:null,errorMessage:null,onRoleName(){},onLoading(){},onError(){},onNamespace(){},didReceiveAttrs(){this._super()
const e=!this.oldSelectedAuthPath&&!this.selectedAuthPath;(this.oldSelectedAuthPath!==this.selectedAuthPath||e)&&this.fetchRole.perform(this.roleName,{debounce:e}),this.set("errorMessage",null),this.set("oldSelectedAuthPath",this.selectedAuthPath)},isOIDC:(0,i.computed)("errorMessage",(function(){return this.errorMessage!==u})),getWindow(){return this.window||window},fetchRole:(0,a.task)((0,r.waitFor)((function*(e){let n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{debounce:!0}
n.debounce&&(this.onRoleName(e),yield(0,a.timeout)(t.default.testing?0:500))
const l=this.selectedAuthPath||this.selectedAuthType,i=JSON.stringify([l,e])
let r=null
try{r=yield this.store.findRecord("role-jwt",i,{adapterOptions:{namespace:this.namespace}})}catch(o){if(!(o.httpStatus&&400===o.httpStatus||t.default.testing))throw o
o.errors&&o.errors.length>0&&this.set("errorMessage",o.errors[0])}this.set("role",r)}))).restartable(),cancelLogin(e,t){this.closeWindow(e),this.handleOIDCError(t)},closeWindow(e){this.watchPopup.cancelAll(),this.watchCurrent.cancelAll(),e.close()},handleOIDCError(e){this.onLoading(!1),this.prepareForOIDC.cancelAll(),this.onError(e)},prepareForOIDC:(0,a.task)((function*(e){const t=this.getWindow()
for(this.onLoading(!0),this.watchPopup.perform(e),this.watchCurrent.perform(e);;){const n=yield(0,a.waitForEvent)(t,"message")
if(n.origin===t.origin&&n.isTrusted&&"oidc-callback"===n.data.source)return this.exchangeOIDC.perform(n.data,e)}})),watchPopup:(0,a.task)((function*(e){for(;;)if(yield(0,a.timeout)(500),!e||e.closed)return this.handleOIDCError(o)})),watchCurrent:(0,a.task)((function*(e){yield(0,a.waitForEvent)(this.getWindow(),"beforeunload"),e.close()})),exchangeOIDC:(0,a.task)((function*(e,t){if(null==e)return
this.onLoading(!0)
let{namespace:n,path:l,state:a,code:i}=e
if(""===n||this.featureFlagService.managedNamespaceRoot){const e=a.indexOf(",ns=")
e>=0&&(n=a.substring(e+4),a=a.substring(0,e))}if(!l||!a||!i)return this.cancelLogin(t,s)
const r=this.store.adapterFor("auth-method")
let o
this.onNamespace(n)
try{o=yield r.exchangeOIDC(l,a,i),this.closeWindow(t)}catch(u){return this.cancelLogin(t,u)}yield this.onSubmit(null,null,o.auth.client_token)})),actions:{async startOIDCAuth(e,t){this.onError(null),t&&t.preventDefault&&t.preventDefault()
try{await this.fetchRole.perform(this.roleName,{debounce:!1})}catch(r){if("TaskCancelation"!==r?.name)throw r}if(!this.isOIDC||!this.role||!this.role.authUrl){let e=this.errorMessage
return this.role?this.role.authUrl||(e="Missing auth_url. Please check that allowed_redirect_uris for the role include this mount path."):e="Invalid role. Please try again.",void this.onError(e)}const n=this.getWindow(),l=n.screen.width/2-250,a=n.screen.height/2-300,i=n.open(this.role.authUrl,"vaultOIDCWindow",`width=500,height=600,resizable,scrollbars=yes,top=${a},left=${l}`)
this.prepareForOIDC.perform(i)}}})
e.default=d})),define("vault/components/auth-saml",["exports","@ember/service","vault/components/outer-html","ember-concurrency","@ember/object","vault/utils/error-message"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=e.ERROR_WINDOW_CLOSED=e.ERROR_MISSING_PARAMS=void 0
const r="The provider window was closed before authentication was complete. Your web browser may have blocked or closed a pop-up window. Please check your settings and click Sign In to try again."
e.ERROR_WINDOW_CLOSED=r
e.ERROR_MISSING_PARAMS="The callback from the provider did not supply all of the required parameters. Please click Sign In to try again. If the problem persists, you may want to contact your administrator."
var o=n.default.extend({store:(0,t.inject)(),featureFlagService:(0,t.inject)("featureFlag"),selectedAuthPath:null,selectedAuthType:null,roleName:null,errorMessage:null,onRoleName(){},onLoading(){},onError(){},onNamespace(){},didReceiveAttrs(){this._super(),this.set("errorMessage",null)},getWindow(){return this.window||window},canLoginSaml:(0,a.computed)("getWindow",(function(){return this.getWindow().isSecureContext})),async fetchRole(e){const t=this.selectedAuthPath||this.selectedAuthType,n=JSON.stringify([t,e])
return this.store.findRecord("role-saml",n,{adapterOptions:{namespace:this.namespace}})},cancelLogin(e,t){this.closeWindow(e),this.handleSAMLError(t),this.exchangeSAMLTokenPollID.cancelAll()},closeWindow(e){this.watchPopup.cancelAll(),this.watchCurrent.cancelAll(),e.close()},handleSAMLError(e){this.onLoading(!1),this.onError(e)},watchPopup:(0,l.task)((function*(e){for(;;)if(yield(0,l.timeout)(500),!e||e.closed)return this.exchangeSAMLTokenPollID.cancelAll(),this.handleSAMLError(r)})),watchCurrent:(0,l.task)((function*(e){yield(0,l.waitForEvent)(this.getWindow(),"beforeunload"),e?.close()})),exchangeSAMLTokenPollID:(0,l.task)((function*(e,t){this.onLoading(!0),this.watchPopup.perform(e),this.watchCurrent.perform(e)
const n=this.selectedAuthPath||this.selectedAuthType,a=this.store.adapterFor("auth-method")
let r
this.onNamespace(this.namespace)
for(let s=0;s<180;s++){yield(0,l.timeout)(500)
try{if(r=yield a.pollSAMLToken(n,t.tokenPollID,t.clientVerifier),!r?.auth)continue
return yield this.onSubmit(null,null,r.auth.client_token),void this.closeWindow(e)}catch(o){if(401===o.httpStatus)continue
return this.cancelLogin(e,(0,i.default)(o))}}this.cancelLogin(e,"The authentication request has timed out. Please click Sign In to try again.")})),actions:{setRole(e){this.onRoleName(e)},async startSAMLAuth(e,t,n){this.onError(null),this.onLoading(!0),n&&n.preventDefault&&n.preventDefault()
const l=t.role
let a
try{a=await this.fetchRole(l)}catch(u){return void this.handleSAMLError(u)}const i=this.getWindow(),r=i.screen.width/2-250,o=i.screen.height/2-300,s=i.open(a.ssoServiceURL,"vaultSAMLWindow",`width=500,height=600,resizable,scrollbars=yes,top=${o},left=${r}`)
this.exchangeSAMLTokenPollID.perform(s,a)}}})
e.default=o}))
define("vault/components/autocomplete-input",["exports","core/components/autocomplete-input"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/b64-toggle",["exports","@ember/object/computed","@ember/utils","@ember/component","@ember/object","vault/utils/b64"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r="base64",o="utf-8"
var s=l.default.extend({tagName:"button",attributeBindings:["type","data-test-transit-b64-toggle"],type:"button",classNames:["button","b64-toggle"],classNameBindings:["isInput:is-input:is-textarea"],isInput:!0,value:null,initialEncoding:o,_value:"",currentEncoding:"",lastEncoding:"",isBase64:(0,t.equal)("currentEncoding",r),valuesMatch:(0,a.computed)("value","_value",(function(){const{value:e,_value:t}=this
return!((0,n.isBlank)(e)||(0,n.isBlank)(t))&&e===t})),init(){this._super(...arguments)
const e=this.initialEncoding;(0,a.set)(this,"currentEncoding",e),e===r&&((0,a.set)(this,"_value",this.value),(0,a.set)(this,"lastEncoding",r))},didReceiveAttrs(){this._super(),""!==this.value?(this.isBase64&&!this.valuesMatch&&(0,a.set)(this,"currentEncoding",o),this.lastEncoding===r&&this.valuesMatch&&(0,a.set)(this,"currentEncoding",r)):(0,a.set)(this,"currentEncoding",o)},click(){const e=this.value,t=this.currentEncoding===o
if(!e)return
const n=t?(0,i.encodeString)(e):(0,i.decodeString)(e),l=t?r:o;(0,a.set)(this,"value",n),(0,a.set)(this,"_value",n),(0,a.set)(this,"lastEncoding",l),(0,a.set)(this,"currentEncoding",l)}})
e.default=s})),define("vault/components/basic-dropdown-content",["exports","ember-basic-dropdown/components/basic-dropdown-content"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/basic-dropdown-trigger",["exports","ember-basic-dropdown/components/basic-dropdown-trigger"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/basic-dropdown",["exports","ember-basic-dropdown/components/basic-dropdown"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/basic-dropdown/trigger",["exports","ember-basic-dropdown/components/basic-dropdown/trigger"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({attributeBindings:["type"]})
e.default=n})),define("vault/components/box-radio",["exports","core/components/box-radio"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/calendar-widget",["exports","@glimmer/component","@ember/object","@glimmer/tracking","core/utils/date-formatters","date-fns","core/utils/timestamp"],(function(e,t,n,l,a,i,r){var o,s,u,d,c
function p(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function m(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let f=(o=class extends t.default{constructor(){var e,t,n
super(...arguments),e=this,t="currentDate",n=r.default.now(),t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,p(this,"calendarDisplayDate",s,this),p(this,"showCalendar",u,this),p(this,"tooltipTarget",d,this),p(this,"tooltipText",c,this)}get startDate(){return(0,a.parseAPITimestamp)(this.args.startTimestamp)}get endDate(){return(0,a.parseAPITimestamp)(this.args.endTimestamp)}get displayYear(){return this.calendarDisplayDate.getFullYear()}get disableFutureYear(){return(0,i.isSameYear)(this.calendarDisplayDate,this.currentDate)}get disablePastYear(){return(0,i.isSameYear)(this.calendarDisplayDate,this.startDate)}get widgetMonths(){const e=this.startDate.getFullYear(),t=this.startDate.getMonth()
return a.ARRAY_OF_MONTHS.map(((n,l)=>{let a=!1
return e===this.displayYear&&l<t&&(a=!0),this.displayYear===this.currentDate.getFullYear()&&l>this.currentDate.getMonth()&&(a=!0),{index:l,year:this.displayYear,name:n,readonly:a}}))}addTooltip(){if(this.disablePastYear){const e=this.displayYear-1
this.tooltipText=`${e} is unavailable because it is before your start date. Change your start month to a date in ${e} to see data for this year.`,this.tooltipTarget="#previous-year"}}removeTooltip(){this.tooltipTarget=null}addYear(){this.calendarDisplayDate=(0,i.addYears)(this.calendarDisplayDate,1)}subYear(){this.calendarDisplayDate=(0,i.subYears)(this.calendarDisplayDate,1)}toggleShowCalendar(){this.showCalendar=!this.showCalendar,this.calendarDisplayDate=this.endDate}handleDateShortcut(e,t){let{target:n}=t
this.args.selectMonth({dateType:n.name}),this.showCalendar=!1,e.close()}selectMonth(e,t){const{index:n,year:l,name:a}=e
this.toggleShowCalendar(),this.args.selectMonth({monthIdx:n,monthName:a,year:l,dateType:"endDate"}),t.close()}},s=m(o.prototype,"calendarDisplayDate",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return this.currentDate}}),u=m(o.prototype,"showCalendar",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),d=m(o.prototype,"tooltipTarget",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),c=m(o.prototype,"tooltipText",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),m(o.prototype,"addTooltip",[n.action],Object.getOwnPropertyDescriptor(o.prototype,"addTooltip"),o.prototype),m(o.prototype,"removeTooltip",[n.action],Object.getOwnPropertyDescriptor(o.prototype,"removeTooltip"),o.prototype),m(o.prototype,"addYear",[n.action],Object.getOwnPropertyDescriptor(o.prototype,"addYear"),o.prototype),m(o.prototype,"subYear",[n.action],Object.getOwnPropertyDescriptor(o.prototype,"subYear"),o.prototype),m(o.prototype,"toggleShowCalendar",[n.action],Object.getOwnPropertyDescriptor(o.prototype,"toggleShowCalendar"),o.prototype),m(o.prototype,"handleDateShortcut",[n.action],Object.getOwnPropertyDescriptor(o.prototype,"handleDateShortcut"),o.prototype),m(o.prototype,"selectMonth",[n.action],Object.getOwnPropertyDescriptor(o.prototype,"selectMonth"),o.prototype),o)
e.default=f})),define("vault/components/certificate-card",["exports","core/components/certificate-card"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/checkbox-grid",["exports","core/components/checkbox-grid"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/chevron",["exports","core/components/chevron"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/choose-pgp-key-form",["exports","core/components/choose-pgp-key-form"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/clients/attribution",["exports","@glimmer/component","@ember/object","@glimmer/tracking","@ember/service","core/utils/date-formatters","date-fns"],(function(e,t,n,l,a,i,r){var o,s,u
function d(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function c(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let p=(o=class extends t.default{constructor(){super(...arguments),d(this,"showCSVDownloadModal",s,this),d(this,"download",u,this)}get formattedStartDate(){return this.args.startTimestamp?(0,i.parseAPITimestamp)(this.args.startTimestamp,"MMMM yyyy"):null}get formattedEndDate(){if(!this.args.startTimestamp&&!this.args.endTimestamp)return null
const e=(0,i.parseAPITimestamp)(this.args.startTimestamp),t=(0,i.parseAPITimestamp)(this.args.endTimestamp)
return(0,r.isSameMonth)(e,t)?null:(0,r.format)(t,"MMMM yyyy")}get hasCsvData(){return!!this.args.totalClientAttribution&&this.args.totalClientAttribution.length>0}get isSingleNamespace(){return this.args.totalClientAttribution?!!this.args.selectedNamespace:"no data"}get barChartTotalClients(){return this.args.totalClientAttribution?.slice(0,10)}get barChartNewClients(){return this.args.newClientAttribution?.slice(0,10)}get topClientCounts(){return this.args.totalClientAttribution?this.args.totalClientAttribution[0]:null}get attributionBreakdown(){return this.isSingleNamespace?"auth method":"namespace"}get chartText(){const e=this.formattedEndDate?"date range":"month"
switch(this.isSingleNamespace){case!0:return{description:"This data shows the top ten authentication methods by client count within this namespace, and can be used to understand where clients are originating. Authentication methods are organized by path.",newCopy:`The new clients used by the auth method for this ${e}. This aids in understanding which auth methods create and use new clients${"date range"===e?" over time.":"."}`,totalCopy:`The total clients used by the auth method for this ${e}. This number is useful for identifying overall usage volume. `}
case!1:return{description:"This data shows the top ten namespaces by client count and can be used to understand where clients are originating. Namespaces are identified by path. To see all namespaces, export this data.",newCopy:`The new clients in the namespace for this ${e}.\n          This aids in understanding which namespaces create and use new clients${"date range"===e?" over time.":"."}`,totalCopy:`The total clients in the namespace for this ${e}. This number is useful for identifying overall usage volume.`}
case"no data":return{description:"There is a problem gathering data"}
default:return""}}destructureCountsToArray(e){const{clients:t,entity_clients:n,non_entity_clients:l}=e
return[t,n,l]}constructCsvRow(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,n=arguments.length>2?arguments[2]:void 0,l=arguments.length>3&&void 0!==arguments[3]?arguments[3]:null
const a=l?[...n,...l]:[...n]
return[`${"string"==typeof e?e:e.label}`,`${t?t.label:"*"}`,...a]}generateCsvData(){const e=this.args.totalClientAttribution,t=this.barChartNewClients?this.args.newClientAttribution:null,n=[],l=["Namespace path",`"Authentication method ${this.isSingleNamespace?"":"\n  *namespace totals, inclusive of auth method clients"}"`,"Total clients","Entity clients","Non-entity clients"]
return t&&l.push("Total new clients, New entity clients, New non-entity clients"),e.forEach((e=>{const l=this.isSingleNamespace?this.args.selectedNamespace:e,a=this.isSingleNamespace?e:null,i=t?t.find((t=>t.label===e.label)):null,r=this.destructureCountsToArray(e),o=i?this.destructureCountsToArray(i):null
n.push(this.constructCsvRow(l,a,r,o)),!this.isSingleNamespace&&l.mounts&&l.mounts.forEach((e=>{const a=t?i?.mounts.find((t=>t.label===e.label)):null,r=this.destructureCountsToArray(e),o=a?this.destructureCountsToArray(a):null
n.push(this.constructCsvRow(l,e,r,o))}))})),n.unshift(l),n.map((e=>e.join())).join("\n")}get formattedCsvFileName(){const e=this.formattedEndDate?`-${this.formattedEndDate}`:"",t=this.formattedStartDate+e
return this.isSingleNamespace?`clients_by_auth_method_${t}`:`clients_by_namespace_${t}`}exportChartData(e){const t=this.generateCsvData()
this.download.csv(e,t),this.showCSVDownloadModal=!1}},s=c(o.prototype,"showCSVDownloadModal",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),u=c(o.prototype,"download",[a.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c(o.prototype,"exportChartData",[n.action],Object.getOwnPropertyDescriptor(o.prototype,"exportChartData"),o.prototype),o)
e.default=p})),define("vault/components/clients/config",["exports","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","ember-concurrency"],(function(e,t,n,l,a,i){var r,o,s,u,d,c,p,m
function f(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function h(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let b=(r=(0,i.task)((function*(){try{yield this.args.model.save(),this.router.transitionTo("vault.cluster.clients.config")}catch(e){this.error=e.message,this.modalOpen=!1}})).drop(),o=class extends t.default{constructor(){super(...arguments),f(this,"router",s,this),f(this,"mode",u,this),f(this,"modalOpen",d,this),f(this,"validations",c,this),f(this,"error",p,this),f(this,"save",m,this)}get infoRows(){return[{label:"Usage data collection",helperText:"Enable or disable collecting data to track clients.",valueKey:"enabled"},{label:"Retention period",helperText:"The number of months of activity logs to maintain for client tracking.",valueKey:"retentionMonths"}]}get modalTitle(){return`Turn usage tracking ${this.args.model.enabled.toLowerCase()}?`}toggleEnabled(e){this.args.model.enabled=e.target.checked?"On":"Off"}onSaveChanges(e){e.preventDefault()
const{isValid:t,state:n}=this.args.model.validate(),l=this.args.model.changedAttributes()
t?l.enabled?this.modalOpen=!0:this.save.perform():this.validations=n}},s=h(o.prototype,"router",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=h(o.prototype,"mode",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return"show"}}),d=h(o.prototype,"modalOpen",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),c=h(o.prototype,"validations",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=h(o.prototype,"error",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),m=h(o.prototype,"save",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h(o.prototype,"toggleEnabled",[n.action],Object.getOwnPropertyDescriptor(o.prototype,"toggleEnabled"),o.prototype),h(o.prototype,"onSaveChanges",[n.action],Object.getOwnPropertyDescriptor(o.prototype,"onSaveChanges"),o.prototype),o)
e.default=b})),define("vault/components/clients/dashboard",["exports","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","date-fns","vault/lib/token-storage","core/utils/date-formatters"],(function(e,t,n,l,a,i,r,o){var s,u,d,c,p,m,f,h,b,y,v,g,w,k
function x(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function _(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let P=(s=class extends t.default{get namespaceArray(){return this.getActivityResponse.byNamespace?this.getActivityResponse.byNamespace.map((e=>({name:e.label,id:e.label}))):[]}constructor(){var e,t,n
super(...arguments),x(this,"store",u,this),x(this,"version",d,this),n=[{key:"entity_clients",label:"entity clients"},{key:"non_entity_clients",label:"non-entity clients"}],(t="chartLegend")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,x(this,"startMonthTimestamp",c,this),x(this,"endMonthTimestamp",p,this),x(this,"queriedActivityResponse",m,this),x(this,"activityQueryParams",f,this),x(this,"selectedNamespace",h,this),x(this,"selectedAuthMethod",b,this),x(this,"authMethodOptions",y,this),x(this,"noActivityData",v,this),x(this,"showBillingStartModal",g,this),x(this,"isLoadingQuery",w,this),x(this,"errorObject",k,this),this.startMonthTimestamp=this.args.model.licenseStartTimestamp,this.endMonthTimestamp=this.args.model.currentDate,this.activityQueryParams.start.timestamp=this.args.model.licenseStartTimestamp,this.activityQueryParams.end.timestamp=this.args.model.currentDate,this.noActivityData="no-data"===this.args.model.activity.id}get dateRangeMessage(){if(!this.startMonthTimestamp&&!this.endMonthTimestamp)return null
const e=(0,i.isSameMonth)((0,o.parseAPITimestamp)(this.startMonthTimestamp),(0,o.parseAPITimestamp)(this.endMonthTimestamp))?"":` to ${(0,o.parseAPITimestamp)(this.endMonthTimestamp,"MMMM yyyy")}`
return`from ${(0,o.parseAPITimestamp)(this.startMonthTimestamp,"MMMM yyyy")}`+e}get versionText(){return this.version.isEnterprise?{label:"Billing start month",description:"This date comes from your license, and defines when client counting starts. Without this starting point, the data shown is not reliable.",title:"No billing start date found",message:"In order to get the most from this data, please enter your billing period start month. This will ensure that the resulting data is accurate."}:{label:"Client counting start date",description:"This date is when client counting starts. Without this starting point, the data shown is not reliable.",title:"No start date found",message:"In order to get the most from this data, please enter a start month above. Vault will calculate new clients starting from that month."}}get isDateRange(){return!(0,i.isSameMonth)((0,o.parseAPITimestamp)(this.getActivityResponse.startTime),(0,o.parseAPITimestamp)(this.getActivityResponse.endTime))}get isCurrentMonth(){return(0,i.isSameMonth)((0,o.parseAPITimestamp)(this.getActivityResponse.startTime),(0,o.parseAPITimestamp)(this.args.model.currentDate))&&(0,i.isSameMonth)((0,o.parseAPITimestamp)(this.getActivityResponse.endTime),(0,o.parseAPITimestamp)(this.args.model.currentDate))}get startTimeDiscrepancy(){const e=(0,o.parseAPITimestamp)(this.getActivityResponse.startTime),t=(0,o.parseAPITimestamp)(this.startMonthTimestamp)
let n="You requested data from"
return this.startMonthTimestamp===this.args.model.licenseStartTimestamp&&this.version.isEnterprise&&(n="Your license start date is"),(0,i.isAfter)(e,t)&&!(0,i.isSameMonth)(e,t)?`${n} ${(0,o.parseAPITimestamp)(this.startMonthTimestamp,"MMMM yyyy")}.\n        We only have data from ${(0,o.parseAPITimestamp)(this.getActivityResponse.startTime,"MMMM yyyy")},\n        and that is what is being shown here.`:null}get upgradeDuringActivity(){const e=this.args.model.versionHistory
if(!e||0===e.length)return null
const t=e.filter((e=>{let{version:t}=e
return t.match("1.9")||t.match("1.10")}))
if(!t||0===t.length)return null
const n=(0,o.parseAPITimestamp)(this.getActivityResponse.startTime),l=(0,o.parseAPITimestamp)(this.getActivityResponse.endTime),a=t.filter((e=>{let{timestampInstalled:t}=e
const a=(0,o.parseAPITimestamp)(t)
return(0,i.isAfter)(a,n)&&(0,i.isBefore)(a,l)}))
return 0===a.length?null:a}get upgradeVersionAndDate(){if(!this.upgradeDuringActivity)return null
if(2===this.upgradeDuringActivity.length){const[e,t]=this.upgradeDuringActivity,n=(0,o.parseAPITimestamp)(e.timestampInstalled,"MMM d, yyyy"),l=(0,o.parseAPITimestamp)(t.timestampInstalled,"MMM d, yyyy")
return`Vault was upgraded to ${e.version} (${n}) and ${t.version} (${l}) during this time range.`}{const[e]=this.upgradeDuringActivity
return`Vault was upgraded to ${e.version} on ${(0,o.parseAPITimestamp)(e.timestampInstalled,"MMM d, yyyy")}.`}}get upgradeExplanation(){if(!this.upgradeDuringActivity)return null
if(1===this.upgradeDuringActivity.length){const e=this.upgradeDuringActivity[0].version
if(e.match("1.9"))return" How we count clients changed in 1.9, so keep that in mind when looking at the data."
if(e.match("1.10"))return" We added monthly breakdowns and mount level attribution starting in 1.10, so keep that in mind when looking at the data."}return" How we count clients changed in 1.9 and we added monthly breakdowns and mount level attribution starting in 1.10. Keep this in mind when looking at the data."}get formattedStartDate(){return this.startMonthTimestamp?(0,o.parseAPITimestamp)(this.startMonthTimestamp,"MMMM yyyy"):null}get getActivityResponse(){return this.queriedActivityResponse||this.args.model.activity}get byMonthActivityData(){return this.selectedNamespace?this.filteredActivityByMonth:this.getActivityResponse?.byMonth}get hasAttributionData(){return!this.selectedAuthMethod&&(this.selectedNamespace?this.authMethodOptions.length>0:!!this.totalClientAttribution&&this.totalUsageCounts&&0!==this.totalUsageCounts.clients)}get totalUsageCounts(){return this.selectedNamespace?this.filteredActivityByNamespace:this.getActivityResponse.total}get newClientCounts(){return this.isDateRange?null:this.byMonthActivityData[0]?.new_clients}get totalClientAttribution(){return this.selectedNamespace?this.filteredActivityByNamespace?.mounts||null:this.getActivityResponse?.byNamespace||null}get newClientAttribution(){return this.isDateRange||this.isCurrentMonth?null:this.selectedNamespace?this.newClientCounts?.mounts||null:this.newClientCounts?.namespaces||null}get responseTimestamp(){return this.getActivityResponse.responseTimestamp}get filteredActivityByNamespace(){const e=this.selectedNamespace,t=this.selectedAuthMethod
return e||t?t?this.getActivityResponse.byNamespace.find((t=>t.label===e)).mounts?.find((e=>e.label===t)):this.getActivityResponse.byNamespace.find((t=>t.label===e)):this.getActivityResponse}get filteredActivityByMonth(){const e=this.selectedNamespace,t=this.selectedAuthMethod
if(!e&&!t)return this.getActivityResponse?.byMonth
const n=this.getActivityResponse?.byMonth.map((t=>t.namespaces_by_key[e])).filter((e=>void 0!==e))
if(!t)return 0===n.length?null:n
const l=n.map((e=>e.mounts_by_key[t])).filter((e=>void 0!==e))
return 0===l.length?null:l}async handleClientActivityQuery(e){let{dateType:t,monthIdx:n,year:l}=e
switch(this.showBillingStartModal=!1,t){case"cancel":return
case"reset":this.activityQueryParams.start.timestamp=this.args.model.licenseStartTimestamp,this.activityQueryParams.end.timestamp=this.args.model.currentDate
break
case"currentMonth":this.activityQueryParams.start.timestamp=this.args.model.currentDate,this.activityQueryParams.end.timestamp=this.args.model.currentDate
break
case"startDate":this.activityQueryParams.start={monthIdx:n,year:l},this.activityQueryParams.end.timestamp=this.args.model.currentDate
break
case"endDate":this.activityQueryParams.end={monthIdx:n,year:l}}try{this.isLoadingQuery=!0
const e=await this.store.queryRecord("clients/activity",{start_time:this.activityQueryParams.start,end_time:this.activityQueryParams.end}),{byMonth:t}=e
this.startMonthTimestamp=t[0]?.timestamp||e.startTime,this.endMonthTimestamp=t[t.length-1]?.timestamp||e.endTime,"no-data"===e.id?this.noActivityData=!0:(this.noActivityData=!1,(0,r.default)().setItem("vault:ui-inputted-start-date",this.startMonthTimestamp)),this.queriedActivityResponse=e,this.selectedNamespace=null,this.selectedAuthMethod=null,this.authMethodOptions=[]}catch(a){return this.errorObject=a,a}finally{this.isLoadingQuery=!1}}get hasMultipleMonthsData(){return this.byMonthActivityData&&this.byMonthActivityData.length>1}selectNamespace(e){let[t]=e
if(this.selectedNamespace=t,t){const e=this.filteredActivityByNamespace.mounts?.map((e=>({id:e.label,name:e.label})))
this.authMethodOptions=e}else this.authMethodOptions=[],this.selectedAuthMethod=null}setAuthMethod(e){let[t]=e
this.selectedAuthMethod=t}isEndBeforeStart(e){let{start:t}=this.activityQueryParams
return t=t?.timestamp?(0,o.parseAPITimestamp)(t.timestamp):new Date(t.year,t.monthIdx),!(!(0,i.isBefore)(e,t)||(0,i.isSameMonth)(t,e))&&`End date must be after ${(0,i.format)(t,"MMMM yyyy")}`}},u=_(s.prototype,"store",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=_(s.prototype,"version",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=_(s.prototype,"startMonthTimestamp",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=_(s.prototype,"endMonthTimestamp",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=_(s.prototype,"queriedActivityResponse",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),f=_(s.prototype,"activityQueryParams",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return{start:{},end:{}}}}),h=_(s.prototype,"selectedNamespace",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),b=_(s.prototype,"selectedAuthMethod",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),y=_(s.prototype,"authMethodOptions",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return[]}}),v=_(s.prototype,"noActivityData",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g=_(s.prototype,"showBillingStartModal",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),w=_(s.prototype,"isLoadingQuery",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),k=_(s.prototype,"errorObject",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),_(s.prototype,"handleClientActivityQuery",[n.action],Object.getOwnPropertyDescriptor(s.prototype,"handleClientActivityQuery"),s.prototype),_(s.prototype,"selectNamespace",[n.action],Object.getOwnPropertyDescriptor(s.prototype,"selectNamespace"),s.prototype),_(s.prototype,"setAuthMethod",[n.action],Object.getOwnPropertyDescriptor(s.prototype,"setAuthMethod"),s.prototype),_(s.prototype,"isEndBeforeStart",[n.action],Object.getOwnPropertyDescriptor(s.prototype,"isEndBeforeStart"),s.prototype),s)
e.default=P})),define("vault/components/clients/horizontal-bar-chart",["exports","@glimmer/component","@ember/object","d3-shape","d3-selection","d3-scale","d3-axis","d3-array","vault/utils/chart-helpers","@glimmer/tracking","core/helpers/format-number"],(function(e,t,n,l,a,i,r,o,s,u,d){var c,p,m,f
function h(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function b(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const y=10,v=95,g=14,w=99
let k=(c=class extends t.default{constructor(){super(...arguments),h(this,"tooltipTarget",p,this),h(this,"tooltipText",m,this),h(this,"isLabel",f,this)}get labelKey(){return this.args.labelKey||"label"}get xKey(){return this.args.xKey||"clients"}get chartLegend(){return this.args.chartLegend}get topNamespace(){return this.args.dataset[(0,o.maxIndex)(this.args.dataset,(e=>e[this.xKey]))]}get total(){return this.args.totalCounts[this.xKey]||null}removeTooltip(){this.tooltipTarget=null}renderChart(e,t){let[n]=t
const u=n,c=(0,l.stack)().keys(this.chartLegend.map((e=>e.key)))(u),p=this.labelKey,m=this.xKey,f=(0,i.scaleLinear)().domain([0,(0,o.max)(u.map((e=>e[m])))]).range([0,75]),h=(0,i.scaleBand)().domain(u.map((e=>e[p]))).range([0,24*u.length]).paddingInner(.765),b=(0,a.select)(e)
b.attr("width","100%").attr("viewBox","0 0 564 "+24*(u.length+1))
const k=b.selectAll("g").remove().exit().data(c).enter().append("g").attr("data-test-group",(e=>`${e.key}`)).attr("transform",`translate(${v}, ${y})`).style("fill",((e,t)=>s.LIGHT_AND_DARK_BLUE[t]));(0,r.axisLeft)(h).tickSize(0)(b.append("g").attr("data-test-group","y-labels").attr("transform",`translate(${v}, ${y})`)),b.select(".domain").remove()
b.selectAll(".tick text").call((e=>e.text((e=>e.length<15?e:e.slice(0,12)+"...")))),k.selectAll("rect").remove().exit().data((e=>e)).enter().append("rect").attr("class","data-bar").style("cursor","pointer").attr("width",(e=>`${f(Math.abs(e[1]-e[0]))}%`)).attr("height",h.bandwidth()).attr("x",(e=>`${f(e[0])}%`)).attr("y",(e=>{let{data:t}=e
return h(t[p])})).attr("rx",3).attr("ry",3)
const x=b.append("g").attr("data-test-group","action-bars").selectAll(".action-bar").remove().exit().data(u).enter().append("rect").style("cursor","pointer").attr("class","action-bar").attr("width","100%").attr("height","24px").attr("x","0").attr("y",(e=>h(e[p]))).style("fill",`${s.GREY}`).style("opacity","0").style("mix-blend-mode","multiply"),_=b.append("g").attr("data-test-group","label-action-bars").selectAll(".label-action-bar").remove().exit().data(u).enter().append("rect").style("cursor","pointer").attr("class","label-action-bar").attr("width",v).attr("height","24px").attr("x","0").attr("y",(e=>h(e[p]))).style("opacity","0").style("mix-blend-mode","multiply"),P=b.selectAll("rect.data-bar"),T=b.selectAll("rect.action-bar"),O=(e,t,n)=>(0,a.select)(e).attr(`${n}`)===(0,a.select)(t).attr(`${n}`)
x.on("mouseover",(e=>{const t=x.filter((t=>t[p]===e[p])).node()
this.tooltipTarget=t,this.isLabel=!1,this.tooltipText=this.total?`${Math.round(100*e[m]/this.total)}%\n        of total client counts:\n        ${(0,s.formatTooltipNumber)(e.entity_clients)} entity clients,\n        ${(0,s.formatTooltipNumber)(e.non_entity_clients)} non-entity clients.`:"",(0,a.select)(t).style("opacity",1),P.filter((function(){return O(this,t,"y")})).style("fill",((e,t)=>`${s.BAR_COLOR_HOVER[t]}`))})).on("mouseout",(function(){(0,a.select)(this).style("opacity",0),P.filter((function(){return O(this,a.event.target,"y")})).style("fill",((e,t)=>`${s.LIGHT_AND_DARK_BLUE[t]}`))})),_.on("mouseover",(e=>{if(e[p].length>=15){const t=_.filter((t=>t[p]===e[p])).node()
this.tooltipTarget=t,this.isLabel=!0,this.tooltipText=e[p]}else this.tooltipTarget=null
P.filter((function(){return O(this,a.event.target,"y")})).style("fill",((e,t)=>`${s.BAR_COLOR_HOVER[t]}`)),T.filter((function(){return O(this,a.event.target,"y")})).style("opacity","1")})).on("mouseout",(function(){this.tooltipTarget=null,P.filter((function(){return O(this,a.event.target,"y")})).style("fill",((e,t)=>`${s.LIGHT_AND_DARK_BLUE[t]}`)),T.filter((function(){return O(this,a.event.target,"y")})).style("opacity","0")}))
b.append("g").attr("data-test-group","total-values").attr("transform",`translate(${w}, ${g})`).selectAll("text").data(u).enter().append("text").text((e=>(0,d.formatNumber)([e[m]]))).attr("fill","#000").attr("class","total-value").style("font-size",".8rem").attr("text-anchor","start").attr("alignment-baseline","middle").attr("x",(e=>`${f(e[m])}%`)).attr("y",(e=>h(e[p])))}},p=b(c.prototype,"tooltipTarget",[u.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),m=b(c.prototype,"tooltipText",[u.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),f=b(c.prototype,"isLabel",[u.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),b(c.prototype,"removeTooltip",[n.action],Object.getOwnPropertyDescriptor(c.prototype,"removeTooltip"),c.prototype),b(c.prototype,"renderChart",[n.action],Object.getOwnPropertyDescriptor(c.prototype,"renderChart"),c.prototype),c)
e.default=k})),define("vault/components/clients/line-chart",["exports","@glimmer/component","@ember/object","@glimmer/tracking","d3-array","d3-selection","d3-axis","d3-scale","d3-shape","vault/utils/chart-helpers","core/utils/date-formatters","core/helpers/format-number"],(function(e,t,n,l,a,i,r,o,s,u,d,c){var p,m,f,h,b,y
function v(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function g(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let w=(p=class extends t.default{constructor(){super(...arguments),v(this,"tooltipTarget",m,this),v(this,"tooltipMonth",f,this),v(this,"tooltipTotal",h,this),v(this,"tooltipNew",b,this),v(this,"tooltipUpgradeText",y,this)}get yKey(){return this.args.yKey||"clients"}get xKey(){return this.args.xKey||"month"}get upgradeData(){const e=this.args.upgradeData
return e?Array.isArray(e)?Object.keys(e[0]).includes("timestampInstalled")?e?.map((e=>({[this.xKey]:(0,d.parseAPITimestamp)(e.timestampInstalled,"M/yy"),...e}))):(console.debug("upgrade must be an object with the following key names: ['version', 'previousVersion', 'timestampInstalled']"),null):(console.debug("upgradeData must be an array of objects containing upgrade history"),null):null}removeTooltip(){this.tooltipTarget=null}renderChart(e,t){let[n]=t
const l=n,p=l.filter((e=>Object.keys(e).includes(this.yKey))),m=(0,a.max)(p.map((e=>e[this.yKey]))),f=(0,i.select)(e)
f.attr("viewBox",`-50 20 600 ${u.SVG_DIMENSIONS.height}`),f.selectAll("g").remove().exit().data(p).enter()
const h=(0,o.scaleLinear)().domain([0,m]).range([0,100]).nice(),b=(0,o.scaleLinear)().domain([0,m]).range([u.SVG_DIMENSIONS.height,0]).nice(),y=(0,o.scalePoint)().domain(l.map((e=>e[this.xKey]))).range([0,u.SVG_DIMENSIONS.width]).padding(.2),v=(0,r.axisLeft)(b).ticks(4).tickPadding(10).tickSizeInner(-u.SVG_DIMENSIONS.width).tickFormat(u.formatNumbers),g=(0,r.axisBottom)(y).tickSize(0)
v(f.append("g").attr("data-test-line-chart","y-axis-labels")),g(f.append("g").attr("transform",`translate(0, ${u.SVG_DIMENSIONS.height+10})`).attr("data-test-line-chart","x-axis-labels")),f.selectAll(".domain").remove()
const w=e=>this.upgradeData?this.upgradeData.find((t=>t[this.xKey]===e[this.xKey])):null
f.append("g").selectAll("circle").data(p).enter().append("circle").attr("class","upgrade-circle").attr("data-test-line-chart",(e=>`upgrade-${e[this.xKey]}`)).attr("fill",u.UPGRADE_WARNING).style("opacity",(e=>w(e)?"1":"0")).attr("cy",(e=>100-h(e[this.yKey])+"%")).attr("cx",(e=>y(e[this.xKey]))).attr("r",10)
const k=(0,s.line)().x((e=>y(e[this.xKey]))).y((e=>b(e[this.yKey])))
f.append("g").append("path").attr("fill","none").attr("stroke",u.LIGHT_AND_DARK_BLUE[1]).attr("stroke-width",.5).attr("d",k(p)),f.append("g").selectAll("circle").data(p).enter().append("circle").attr("data-test-line-chart","plot-point").attr("cy",(e=>100-h(e[this.yKey])+"%")).attr("cx",(e=>y(e[this.xKey]))).attr("r",3.5).attr("fill",u.LIGHT_AND_DARK_BLUE[0]).attr("stroke",u.LIGHT_AND_DARK_BLUE[1]).attr("stroke-width",1.5),f.append("g").selectAll("circle").data(p).enter().append("circle").attr("class","hover-circle").style("cursor","pointer").style("opacity","0").attr("cy",(e=>100-h(e[this.yKey])+"%")).attr("cx",(e=>y(e[this.xKey]))).attr("r",10)
const x=f.selectAll(".hover-circle")
x.on("mouseover",(e=>{this.tooltipMonth=(0,d.formatChartDate)(e[this.xKey]),this.tooltipTotal=(0,c.formatNumber)([e[this.yKey]])+" total clients",this.tooltipNew=((0,c.formatNumber)([e?.new_clients[this.yKey]])||"0")+" new clients",this.tooltipUpgradeText=""
const t=w(e)
if(t){const{version:e,previousVersion:n}=t
this.tooltipUpgradeText=`Vault was upgraded\n        ${n?"from "+n:""} to ${e}`}const n=x.filter((t=>t[this.xKey]===e[this.xKey])).node()
this.tooltipTarget=n}))}},m=g(p.prototype,"tooltipTarget",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),f=g(p.prototype,"tooltipMonth",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),h=g(p.prototype,"tooltipTotal",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),b=g(p.prototype,"tooltipNew",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),y=g(p.prototype,"tooltipUpgradeText",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),g(p.prototype,"removeTooltip",[n.action],Object.getOwnPropertyDescriptor(p.prototype,"removeTooltip"),p.prototype),g(p.prototype,"renderChart",[n.action],Object.getOwnPropertyDescriptor(p.prototype,"renderChart"),p.prototype),p)
e.default=w})),define("vault/components/clients/monthly-usage",["exports","@glimmer/component","vault/utils/chart-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{get averageTotalClients(){return(0,n.calculateAverage)(this.args.verticalBarChartData,"clients")||"0"}get averageNewClients(){return(0,n.calculateAverage)(this.args.verticalBarChartData?.map((e=>e.new_clients)),"clients")||"0"}}e.default=l})),define("vault/components/clients/running-total",["exports","@glimmer/component","vault/utils/chart-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{get byMonthNewClients(){return this.args.byMonthActivityData?this.args.byMonthActivityData?.map((e=>e.new_clients)):null}get entityClientData(){return{runningTotal:this.args.runningTotals.entity_clients,averageNewClients:(0,n.calculateAverage)(this.byMonthNewClients,"entity_clients")}}get nonEntityClientData(){return{runningTotal:this.args.runningTotals.non_entity_clients,averageNewClients:(0,n.calculateAverage)(this.byMonthNewClients,"non_entity_clients")}}get hasRunningTotalClients(){return"number"==typeof this.entityClientData.runningTotal||"number"==typeof this.nonEntityClientData.runningTotal}get hasAverageNewClients(){return"number"==typeof this.entityClientData.averageNewClients||"number"==typeof this.nonEntityClientData.averageNewClients}get singleMonthData(){return this.args?.byMonthActivityData[0]}}e.default=l})),define("vault/components/clients/vertical-bar-chart",["exports","@glimmer/component","@ember/object","@glimmer/tracking","d3-array","d3-selection","d3-axis","d3-scale","d3-shape","vault/utils/chart-helpers","core/helpers/format-number"],(function(e,t,n,l,a,i,r,o,s,u,d){var c,p,m,f,h
function b(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function y(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let v=(c=class extends t.default{constructor(){super(...arguments),b(this,"tooltipTarget",p,this),b(this,"tooltipTotal",m,this),b(this,"entityClients",f,this),b(this,"nonEntityClients",h,this)}get chartLegend(){return this.args.chartLegend}get xKey(){return this.args.xKey||"month"}get yKey(){return this.args.yKey||"clients"}renderChart(e,t){let[n]=t
const l=n,c=l.filter((e=>Object.keys(e).includes("clients"))),p=(0,s.stack)().keys(this.chartLegend.map((e=>e.key)))(c),m=(0,i.select)(e),f=(0,a.max)(c.map((e=>e[this.yKey])))
m.attr("viewBox",`-50 20 600 ${u.SVG_DIMENSIONS.height}`)
const h=(0,o.scaleLinear)().domain([0,f]).range([0,100]).nice(),b=(0,o.scalePoint)().domain(l.map((e=>e[this.xKey]))).range([0,u.SVG_DIMENSIONS.width]).padding(.2)
m.selectAll("g").remove().exit().data(p).enter()
m.selectAll("g").data(p).enter().append("g").style("fill",((e,t)=>u.LIGHT_AND_DARK_BLUE[t])).selectAll("rect").data((e=>e)).enter().append("rect").attr("width","7px").attr("class","data-bar").attr("data-test-vertical-chart","data-bar").attr("height",(e=>`${h(e[1]-e[0])}%`)).attr("x",(e=>{let{data:t}=e
return b(t[this.xKey])})).attr("y",(e=>100-h(e[1])+"%"))
const y=m.append("g").attr("transform","translate(3.5)").attr("data-test-vertical-chart","tooltip-tethers").selectAll("circle").data(c).enter().append("circle").style("opacity","0").attr("cy",(e=>100-h(e[this.yKey])+"%")).attr("cx",(e=>b(e[this.xKey]))).attr("r",1),v=(0,o.scaleLinear)().domain([0,(0,a.max)(c.map((e=>e[this.yKey])))]).range([`${u.SVG_DIMENSIONS.height}`,0]).nice(),g=(0,r.axisLeft)(v).ticks(4).tickPadding(10).tickSizeInner(-u.SVG_DIMENSIONS.width).tickFormat(u.formatNumbers),w=(0,r.axisBottom)(b).tickSize(0)
g(m.append("g").attr("data-test-vertical-chart","y-axis-labels")),w(m.append("g").attr("transform",`translate(0, ${u.SVG_DIMENSIONS.height+10})`).attr("data-test-vertical-chart","x-axis-labels")),m.selectAll(".domain").remove()
m.append("g").attr("transform",`translate(${u.TRANSLATE.left})`).style("fill",`${u.GREY}`).style("opacity","0").style("mix-blend-mode","multiply").selectAll("rect").data(c).enter().append("rect").style("cursor","pointer").attr("class","tooltip-rect").attr("height","100%").attr("width","30px").attr("y","0").attr("x",(e=>b(e[this.xKey]))).on("mouseover",(e=>{const t=e[this.xKey]
this.tooltipTotal=`${(0,d.formatNumber)([e[this.yKey]])} ${e.new_clients?"total":"new"} clients`,this.entityClients=`${(0,d.formatNumber)([e.entity_clients])} entity clients`,this.nonEntityClients=`${(0,d.formatNumber)([e.non_entity_clients])} non-entity clients`
const n=y.filter((e=>e.month===t)).node()
this.tooltipTarget=n}))}removeTooltip(){this.tooltipTarget=null}},p=y(c.prototype,"tooltipTarget",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),m=y(c.prototype,"tooltipTotal",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),f=y(c.prototype,"entityClients",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),h=y(c.prototype,"nonEntityClients",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),y(c.prototype,"renderChart",[n.action],Object.getOwnPropertyDescriptor(c.prototype,"renderChart"),c.prototype),y(c.prototype,"removeTooltip",[n.action],Object.getOwnPropertyDescriptor(c.prototype,"removeTooltip"),c.prototype),c)
e.default=v})),define("vault/components/code-snippet",["exports","core/components/code-snippet"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/configure-aws-secret",["exports","@glimmer/component","@ember/object"],(function(e,t,n){var l
function a(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(a((l=class extends t.default{saveRootCreds(e,t){t.preventDefault(),this.args.saveAWSRoot(e)}saveLease(e,t){t.preventDefault(),this.args.saveAWSLease(e)}handleTtlChange(e,t){const n=t.enabled?t.goSafeTimeString:0
this.args.model.set(e,n)}}).prototype,"saveRootCreds",[n.action],Object.getOwnPropertyDescriptor(l.prototype,"saveRootCreds"),l.prototype),a(l.prototype,"saveLease",[n.action],Object.getOwnPropertyDescriptor(l.prototype,"saveLease"),l.prototype),a(l.prototype,"handleTtlChange",[n.action],Object.getOwnPropertyDescriptor(l.prototype,"handleTtlChange"),l.prototype),l)
e.default=i})),define("vault/components/configure-ssh-secret",["exports","@glimmer/component","@ember/object"],(function(e,t,n){var l
function a(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(a((l=class extends t.default{delete(){this.args.saveConfig({delete:!0})}saveConfig(e){e.preventDefault(),this.args.saveConfig({delete:!1})}}).prototype,"delete",[n.action],Object.getOwnPropertyDescriptor(l.prototype,"delete"),l.prototype),a(l.prototype,"saveConfig",[n.action],Object.getOwnPropertyDescriptor(l.prototype,"saveConfig"),l.prototype),l)
e.default=i})),define("vault/components/confirm-action",["exports","core/components/confirm-action"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/confirm",["exports","core/components/confirm"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/confirm/message",["exports","core/components/confirm/message"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/confirmation-modal",["exports","core/components/confirmation-modal"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/console/command-input",["exports","@ember/component","core/utils/key-codes"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend({onExecuteCommand(){},onFullscreen(){},onValueUpdate(){},onShiftCommand(){},value:null,isFullscreen:null,actions:{handleKeyUp(e){const t=e.keyCode
switch(t){case n.default.ENTER:this.onExecuteCommand(e.target.value)
break
case n.default.UP:case n.default.DOWN:this.onShiftCommand(t)
break
default:this.onValueUpdate(e.target.value)}},fullscreen(){this.onFullscreen()}}})
e.default=l})),define("vault/components/console/log-json",["exports","@ember/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({"data-test-component":"console/log-json",attributeBindings:["data-test-component"]})
e.default=n})),define("vault/components/console/log-list",["exports","@ember/object/computed","@ember/component"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=n.default.extend({content:null,list:(0,t.reads)("content.keys")})
e.default=l}))
define("vault/components/console/log-object",["exports","@ember/string","@ember/component","@ember/object","columnify"],(function(e,t,n,l,a){function i(e){Object.keys(e).forEach((t=>{let n=e[t]
"string"!=typeof n&&(n=JSON.stringify(n)),e[t]=n}))}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.stringifyObjectValues=i
var r=n.default.extend({content:null,columns:(0,l.computed)("content",(function(){const e=this.content
return i(e),(0,a.default)(e,{preserveNewLines:!0,headingTransform:function(e){return(0,t.capitalize)(e)}})}))})
e.default=r})),define("vault/components/console/log-text",["exports","@ember/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({"data-test-component":"console/log-text",attributeBindings:["data-test-component"]})
e.default=n})),define("vault/components/console/output-log",["exports","@ember/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({"data-test-component":"console/output-log",attributeBindings:["data-test-component"],log:null})
e.default=n})),define("vault/components/console/ui-panel",["exports","@ember/service","@ember/object/computed","@ember/component","@ember/application","@ember/runloop","@ember/string","ember-concurrency","vault/lib/control-group-error","vault/lib/console-helpers"],(function(e,t,n,l,a,i,r,o,s,u){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var d=l.default.extend({console:(0,t.inject)(),router:(0,t.inject)(),controlGroup:(0,t.inject)(),store:(0,t.inject)(),"data-test-component":"console/ui-panel",attributeBindings:["data-test-component"],classNames:"console-ui-panel",classNameBindings:["isFullscreen:fullscreen"],isFullscreen:!1,inputValue:null,cliLog:(0,n.alias)("console.log"),didRender(){this._super(...arguments),this.scrollToBottom()},logAndOutput(e,t){this.console.logAndOutput(e,t),(0,i.schedule)("afterRender",(()=>this.scrollToBottom()))},isRunning:(0,n.or)("executeCommand.isRunning","refreshRoute.isRunning"),executeCommand:(0,o.task)((function*(e){let t=arguments.length>1&&void 0!==arguments[1]&&arguments[1]
this.set("inputValue","")
const n=this.console
let l
if((0,u.executeUICommand)(e,(e=>this.logAndOutput(e)),{api:()=>this.routeToExplore.perform(e),clearall:()=>n.clearLog(!0),clear:()=>n.clearLog(),fullscreen:()=>this.toggleProperty("isFullscreen"),refresh:()=>this.refreshRoute.perform()}))return
try{l=(0,u.parseCommand)(e)}catch(f){return void(t&&this.logAndOutput(e,{type:"help"}))}const{method:a,flagArray:i,path:o,dataArray:d}=l,c=(0,u.extractFlagsFromStrings)(i,a),p=(0,u.extractDataFromStrings)(d),m=(0,u.formattedErrorFromInput)(o,a,c,d)
if(m)this.logAndOutput(e,m)
else try{const t=yield n[(0,r.camelize)(a)].call(n,o,p,c)
this.logAndOutput(e,(0,u.logFromResponse)(t,o,a,c))}catch(h){if(h instanceof s.default)return this.logAndOutput(e,this.controlGroup.logFromError(h))
this.logAndOutput(e,(0,u.logFromError)(h,o,a))}})),refreshRoute:(0,o.task)((function*(){const e=(0,a.getOwner)(this).lookup("router:main").get("currentRouteName")
try{this.store.clearAllDatasets(),yield this.router.transitionTo(e),this.logAndOutput(null,{type:"success",content:"The current screen has been refreshed!"})}catch(t){this.logAndOutput(null,{type:"error",content:"The was a problem refreshing the current screen."})}})),routeToExplore:(0,o.task)((function*(e){const t=e.replace("api","").trim()
let n="Welcome to the Vault API explorer! \nYou can search for endpoints, see what parameters they accept, and even execute requests with your current token."
t&&(n=`Welcome to the Vault API explorer! \nWe've filtered the list of endpoints for '${t}'.`)
try{yield this.router.transitionTo("vault.cluster.tools.open-api-explorer",{queryParams:{filter:t}}),this.logAndOutput(null,{type:"success",content:n})}catch(l){"TransitionAborted"===l.message?this.logAndOutput(null,{type:"success",content:n}):this.logAndOutput(null,{type:"error",content:"There was a problem navigating to the api explorer."})}})),shiftCommandIndex(e){this.console.shiftCommandIndex(e,(e=>{this.set("inputValue",e)}))},scrollToBottom(){this.element.scrollTop=this.element.scrollHeight},actions:{closeConsole(){this.set("console.isOpen",!1)},toggleFullscreen(){this.toggleProperty("isFullscreen")},executeCommand(e){this.executeCommand.perform(e,!0)},shiftCommandIndex(e){this.shiftCommandIndex(e)}}})
e.default=d})),define("vault/components/control-group-success",["exports","@ember/service","@ember/component","ember-concurrency"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=n.default.extend({router:(0,t.inject)(),controlGroup:(0,t.inject)(),store:(0,t.inject)(),model:null,controlGroupResponse:null,error:null,unwrapData:null,unwrap:(0,l.task)((function*(e){const t=this.store.adapterFor("tools")
this.set("error",null)
try{const n=yield t.toolAction("unwrap",null,{clientToken:e})
this.set("unwrapData",n.auth||n.data),this.controlGroup.deleteControlGroupToken(this.model.id)}catch(n){this.set("error",`Token unwrap failed: ${n.errors[0]}`)}})).drop(),markAndNavigate:(0,l.task)((function*(){this.controlGroup.markTokenForUnwrap(this.model.id)
const{url:e}=this.controlGroupResponse.uiParams
yield this.router.transitionTo(e)})).drop()})
e.default=a})),define("vault/components/control-group",["exports","@ember/service","@ember/object/computed","@ember/component","@ember/object","ember-concurrency"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=l.default.extend({tagName:"",auth:(0,t.inject)(),controlGroup:(0,t.inject)(),model:null,didReceiveAttrs(){this._super(...arguments)
const e=this.model.id,t=this.controlGroup.wrapInfoForAccessor(e)
this.set("controlGroupResponse",t)},currentUserEntityId:(0,n.alias)("auth.authData.entity_id"),currentUserIsRequesting:(0,a.computed)("currentUserEntityId","model.requestEntity.id",(function(){return!!this.model.requestEntity&&this.currentUserEntityId===this.model.requestEntity.id})),currentUserHasAuthorized:(0,a.computed)("currentUserEntityId","model.authorizations.@each.id",(function(){const e=this.model.authorizations||[]
return Boolean(e.findBy("id",this.currentUserEntityId))})),isSuccess:(0,n.or)("currentUserHasAuthorized","model.approved"),requestorName:(0,a.computed)("currentUserIsRequesting","model.requestEntity",(function(){const e=this.model.requestEntity
return this.currentUserIsRequesting?"You":e&&e.name?e.name:"Someone"})),bannerPrefix:(0,a.computed)("model.approved","currentUserHasAuthorized",(function(){return this.currentUserHasAuthorized?"Thanks!":this.model.approved?"Success!":"Locked"})),bannerText:(0,a.computed)("model.approved","currentUserIsRequesting","currentUserHasAuthorized",(function(){const e=this.model.approved,{currentUserHasAuthorized:t,currentUserIsRequesting:n}=this
return t?"You have given authorization":n&&e?"You have been given authorization":e?"This Control Group has been authorized":n?"The path you requested is locked by a Control Group":"Someone is requesting access to a path locked by a Control Group"})),refresh:(0,i.task)((function*(){try{yield this.model.reload()}catch(e){this.set("errors",e)}})).drop(),authorize:(0,i.task)((function*(){try{yield this.model.save(),yield this.refresh.perform()}catch(e){this.set("errors",e)}})).drop()})
e.default=r})),define("vault/components/copy-button",["exports","ember-cli-clipboard/components/copy-button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/copy-secret-dropdown",["exports","core/components/copy-secret-dropdown"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/dashboard/client-count-card",["exports","@glimmer/component","vault/lib/token-storage","core/utils/timestamp","ember-concurrency","@ember/test-waiters","@glimmer/tracking","@ember/service"],(function(e,t,n,l,a,i,r,o){var s,u,d,c,p
function m(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function f(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0

;/**
   * @module DashboardClientCountCard
   * DashboardClientCountCard component are used to display total and new client count information
   *
   * @example
   * ```js
   * <Dashboard::ClientCountCard @license={{@model.license}}  />
   * ```
   *  @param {object} license - license object passed from the parent
   */
let h=(s=class extends t.default{constructor(){super(...arguments),m(this,"store",u,this),m(this,"activityData",d,this),m(this,"clientConfig",c,this),m(this,"updatedAt",p,this),this.fetchClientActivity.perform(),this.clientConfig=this.store.queryRecord("clients/config",{}).catch((()=>{}))}get currentMonthActivityTotalCount(){return this.activityData?.byMonth?.lastObject?.new_clients.clients}get licenseStartTime(){return this.args.license.startTime||(0,n.default)().getItem("vault:ui-inputted-start-date")||null}*fetchClientActivity(e){if(e&&e.preventDefault(),this.updatedAt=l.default.now().toISOString(),!this.licenseStartTime)return{}
try{this.activityData=yield this.store.queryRecord("clients/activity",{start_time:{timestamp:this.licenseStartTime},end_time:{timestamp:this.updatedAt}}),this.noActivityData="no-data"===this.activityData.activity.id}catch(t){this.error=t}}},u=f(s.prototype,"store",[o.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=f(s.prototype,"activityData",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),c=f(s.prototype,"clientConfig",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),p=f(s.prototype,"updatedAt",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return l.default.now().toISOString()}}),f(s.prototype,"fetchClientActivity",[a.task,i.waitFor],Object.getOwnPropertyDescriptor(s.prototype,"fetchClientActivity"),s.prototype),s)
e.default=h})),define("vault/components/dashboard/learn-more-card",["exports","@glimmer/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{get learnMoreLinks(){return[{link:"/vault/tutorials/secrets-management",icon:"docs-link",title:"Secrets Management"},{link:"/vault/tutorials/monitoring",icon:"docs-link",title:"Monitor & Troubleshooting"},{link:"/vault/tutorials/adp/transform",icon:"learn-link",title:"Advanced Data Protection: Transform engine",requiredFeature:"Transform Secrets Engine"},{link:"/vault/tutorials/secrets-management/pki-engine",icon:"learn-link",title:"Build your own Certificate Authority (CA)"}]}}e.default=n})),define("vault/components/dashboard/quick-actions-card",["exports","@glimmer/component","@ember/object","@glimmer/tracking","@ember/service","kv/utils/kv-breadcrumbs"],(function(e,t,n,l,a,i){var r,o,s,u,d
function c(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function p(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const m=["pki","database"]
let f=(r=class extends t.default{constructor(){super(...arguments),c(this,"router",o,this),c(this,"selectedEngine",s,this),c(this,"selectedAction",u,this),c(this,"paramValue",d,this)}get actionOptions(){switch(this.selectedEngine.type){case"kv":return["Find KV secrets"]
case"database":return["Generate credentials for database"]
case"pki":return["Issue certificate","View certificate","View issuer"]
default:return[]}}get searchSelectParams(){switch(this.selectedAction){case"Find KV secrets":return{title:"Secret path",subText:"Path of the secret you want to read.",buttonText:"Read secrets",model:"kv/metadata",route:"vault.cluster.secrets.backend.kv.secret.details",nameKey:"path",queryObject:{pathToSecret:"",backend:this.selectedEngine.id},objectKeys:["path","id"]}
case"Generate credentials for database":return{title:"Role to use",buttonText:"Generate credentials",model:"database/role",route:"vault.cluster.secrets.backend.credentials",queryObject:{backend:this.selectedEngine.id}}
case"Issue certificate":return{title:"Role to use",placeholder:"Type to find a role",buttonText:"Issue leaf certificate",model:"pki/role",route:"vault.cluster.secrets.backend.pki.roles.role.generate",queryObject:{backend:this.selectedEngine.id}}
case"View certificate":return{title:"Certificate serial number",placeholder:"33:a3:...",buttonText:"View certificate",model:"pki/certificate/base",route:"vault.cluster.secrets.backend.pki.certificates.certificate.details",queryObject:{backend:this.selectedEngine.id}}
case"View issuer":return{title:"Issuer",placeholder:"Type issuer name or ID",buttonText:"View issuer",model:"pki/issuer",route:"vault.cluster.secrets.backend.pki.issuers.issuer.details",nameKey:"issuerName",queryObject:{backend:this.selectedEngine.id},objectKeys:["id","issuerName"]}
default:return{placeholder:"Please select an action above",buttonText:"Select an action",model:""}}}get filteredSecretEngines(){return this.args.secretsEngines?.filter((e=>"kv"===e.type&&2==e.version||m.includes(e.type)))}get mountOptions(){return this.filteredSecretEngines?.map((e=>{const{id:t,type:n}=e
return{name:t,type:n,id:t}}))}handleSearchEngineSelect(e){let[t]=e
this.selectedEngine=t,this.selectedAction=null,this.paramValue=null}setSelectedAction(e){this.selectedAction=e,this.paramValue=null}handleActionSelect(e){Array.isArray(e)?this.paramValue=e[0]:this.paramValue=e}navigateToPage(){let e=this.searchSelectParams.route,t=this.paramValue.id||this.paramValue
if("kv"===this.selectedEngine.type){const n=this.paramValue.path||this.paramValue
e=(0,i.pathIsDirectory)(n)?"vault.cluster.secrets.backend.kv.list-directory":"vault.cluster.secrets.backend.kv.secret.details",t=n}this.router.transitionTo(e,this.selectedEngine.id,t)}},o=p(r.prototype,"router",[a.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=p(r.prototype,"selectedEngine",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=p(r.prototype,"selectedAction",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=p(r.prototype,"paramValue",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p(r.prototype,"handleSearchEngineSelect",[n.action],Object.getOwnPropertyDescriptor(r.prototype,"handleSearchEngineSelect"),r.prototype),p(r.prototype,"setSelectedAction",[n.action],Object.getOwnPropertyDescriptor(r.prototype,"setSelectedAction"),r.prototype),p(r.prototype,"handleActionSelect",[n.action],Object.getOwnPropertyDescriptor(r.prototype,"handleActionSelect"),r.prototype),p(r.prototype,"navigateToPage",[n.action],Object.getOwnPropertyDescriptor(r.prototype,"navigateToPage"),r.prototype),r)
e.default=f})),define("vault/components/dashboard/secrets-engines-card",["exports","@glimmer/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{get filteredSecretsEngines(){return this.args.secretsEngines?.filter((e=>e.shouldIncludeInList))}get firstFiveSecretsEngines(){return this.filteredSecretsEngines?.slice(0,5)}}e.default=n})),define("vault/components/dashboard/vault-configuration-details-card",["exports","@glimmer/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{get tls(){return this.args.vaultConfiguration?.listeners.find((e=>{const{tls_disable:t,tls_cert_file:n,tls_key_file:l}=e.config||{}
return!t&&n&&l}))?"Enabled":"Disabled"}}e.default=n})),define("vault/components/dashboard/vault-version-title",["exports","@glimmer/component","@ember/service"],(function(e,t,n){var l,a,i
function r(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function o(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let s=(l=class extends t.default{constructor(){super(...arguments),r(this,"version",a,this),r(this,"namespace",i,this)}get versionHeader(){return this.version.isEnterprise?`Vault v${this.version.version.slice(0,this.version.version.indexOf("+"))}`:`Vault v${this.version.version}`}get namespaceDisplay(){if(this.namespace.inRootNamespace)return"root"
const e=this.namespace.path?.split("/")
return e[e.length-1]}},a=o(l.prototype,"version",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),i=o(l.prototype,"namespace",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),l)
e.default=s})),define("vault/components/database-connection",["exports","@glimmer/component","@ember/service","@glimmer/tracking","@ember/object"],(function(e,t,n,l,a){var i,r,o,s,u,d
function c(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function p(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const m="vault.cluster.secrets.backend.show",f=e=>{let t=e?.join(". ")||"Something went wrong. Check the Vault logs for more information."
return t.indexOf("failed to verify")>=0&&(t="There was a verification error for this connection. Check the Vault logs for more information."),t}
let h=(i=class extends t.default{constructor(){super(...arguments),c(this,"store",r,this),c(this,"router",o,this),c(this,"flashMessages",s,this),c(this,"showPasswordField",u,this),c(this,"showSaveModal",d,this)}rotateCredentials(e,t){return this.store.adapterFor("database/connection").rotateRootCredentials(e,t)}transitionToRoute(){return this.router.transitionTo(...arguments)}updateShowPassword(e){this.showPasswordField=e,e||(this.args.model.password=void 0)}updatePassword(e,t){const n=t.target.value
this.args.model[e]=n}async handleCreateConnection(e){e.preventDefault()
this.args.model.save().then((()=>{this.showSaveModal=!0})).catch((e=>{const t=f(e.errors)
this.flashMessages.danger(t)}))}continueWithoutRotate(e){e.preventDefault()
const{name:t}=this.args.model
this.transitionToRoute(m,t)}continueWithRotate(e){e.preventDefault()
const{backend:t,name:n}=this.args.model
this.rotateCredentials(t,n).then((()=>{this.flashMessages.success(`Successfully rotated root credentials for connection "${n}"`),this.transitionToRoute(m,n)})).catch((e=>{this.flashMessages.danger(`Error rotating root credentials: ${e.errors}`),this.transitionToRoute(m,n)}))}handleUpdateConnection(e){e.preventDefault()
const t=this.args.model,n=t.name
t.save().then((()=>{this.transitionToRoute(m,n)})).catch((e=>{const t=f(e.errors)
this.flashMessages.danger(t)}))}delete(e){e.preventDefault()
const t=this.args.model,n=t.backend
t.destroyRecord().then((()=>{this.transitionToRoute("vault.cluster.secrets.backend.list-root",n)}))}reset(){const{name:e,backend:t}=this.args.model
this.store.adapterFor("database/connection").resetConnection(t,e).then((()=>{this.flashMessages.success("Successfully reset connection")})).catch((e=>{const t=f(e.errors)
this.flashMessages.danger(t)}))}rotate(){const{name:e,backend:t}=this.args.model
this.rotateCredentials(t,e).then((()=>{this.flashMessages.success("Successfully rotated credentials")})).catch((e=>{const t=f(e.errors)
this.flashMessages.danger(t)}))}},r=p(i.prototype,"store",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),o=p(i.prototype,"router",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=p(i.prototype,"flashMessages",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=p(i.prototype,"showPasswordField",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),d=p(i.prototype,"showSaveModal",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),p(i.prototype,"updateShowPassword",[a.action],Object.getOwnPropertyDescriptor(i.prototype,"updateShowPassword"),i.prototype),p(i.prototype,"updatePassword",[a.action],Object.getOwnPropertyDescriptor(i.prototype,"updatePassword"),i.prototype),p(i.prototype,"handleCreateConnection",[a.action],Object.getOwnPropertyDescriptor(i.prototype,"handleCreateConnection"),i.prototype),p(i.prototype,"continueWithoutRotate",[a.action],Object.getOwnPropertyDescriptor(i.prototype,"continueWithoutRotate"),i.prototype),p(i.prototype,"continueWithRotate",[a.action],Object.getOwnPropertyDescriptor(i.prototype,"continueWithRotate"),i.prototype),p(i.prototype,"handleUpdateConnection",[a.action],Object.getOwnPropertyDescriptor(i.prototype,"handleUpdateConnection"),i.prototype),p(i.prototype,"delete",[a.action],Object.getOwnPropertyDescriptor(i.prototype,"delete"),i.prototype),p(i.prototype,"reset",[a.action],Object.getOwnPropertyDescriptor(i.prototype,"reset"),i.prototype),p(i.prototype,"rotate",[a.action],Object.getOwnPropertyDescriptor(i.prototype,"rotate"),i.prototype),i)
e.default=h})),define("vault/components/database-role-edit",["exports","@glimmer/component","@ember/service","@ember/object","@glimmer/tracking"],(function(e,t,n,l,a){var i,r,o,s,u
function d(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function c(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let p=(i=class extends t.default{constructor(){super(...arguments),d(this,"router",r,this),d(this,"flashMessages",o,this),d(this,"store",s,this),d(this,"loading",u,this),this.args.initialKey&&(this.args.model.database=[this.args.initialKey])}get warningMessages(){const e={}
return("dynamic"===this.args.model.type&&!1===this.args.model.canCreateDynamic||"static"===this.args.model.type&&!1===this.args.model.canCreateStatic)&&(e.type="You don't have permissions to create this type of role."),e}get databaseType(){const e=this.args.model?.backend,t=this.args.model?.database||[]
return e&&0!==t.length?this.store.queryRecord("database/connection",{id:t[0],backend:e}).then((e=>e.plugin_name)).catch((()=>null)):null}generateCreds(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:""
this.router.transitionTo("vault.cluster.secrets.backend.credentials",e,{queryParams:{roleType:t}})}delete(){const e=this.args.model,t=e.backend
return e.destroyRecord().then((()=>{try{this.router.transitionTo("vault.cluster.secrets.backend.list-root",t,{queryParams:{tab:"role"}})}catch(e){console.debug(e)}})).catch((e=>{this.flashMessages.danger(e.errors?.join(". "))}))}handleCreateEditRole(e){e.preventDefault(),this.loading=!0
const t=this.args.mode,n=this.args.model,l=n.name
if("create"===t){n.set("id",l)
const e="static"===n.type?"static-roles":"roles"
n.set("path",e)}return n.save().then((()=>{try{this.router.transitionTo("vault.cluster.secrets.backend.show",`role/${l}`)}catch(e){console.debug(e)}})).catch((e=>{const t=e.errors?.join(". ")||e.message
this.flashMessages.danger(t||"Could not save the role. Please check Vault logs for more information."),this.loading=!1}))}rotateRoleCred(e){const t=this.args.model?.backend
return this.store.adapterFor("database/credential").rotateRoleCredentials(t,e).then((()=>{this.flashMessages.success(`Success: Credentials for ${e} role were rotated`)})).catch((e=>{this.flashMessages.danger(e.errors)}))}},r=c(i.prototype,"router",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),o=c(i.prototype,"flashMessages",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=c(i.prototype,"store",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=c(i.prototype,"loading",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),c(i.prototype,"generateCreds",[l.action],Object.getOwnPropertyDescriptor(i.prototype,"generateCreds"),i.prototype),c(i.prototype,"delete",[l.action],Object.getOwnPropertyDescriptor(i.prototype,"delete"),i.prototype),c(i.prototype,"handleCreateEditRole",[l.action],Object.getOwnPropertyDescriptor(i.prototype,"handleCreateEditRole"),i.prototype),c(i.prototype,"rotateRoleCred",[l.action],Object.getOwnPropertyDescriptor(i.prototype,"rotateRoleCred"),i.prototype),i)
e.default=p})),define("vault/components/database-role-setting-form",["exports","@glimmer/component","vault/utils/database-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{get settingFields(){if(!this.args.roleType)return null
const e=(0,n.getRoleFields)(this.args.roleType)
return this.args.attrs.filter((t=>e.includes(t.name)))}get statementFields(){const e=this.args.roleType,t=this.args.dbType
if(!e)return null
const l=(0,n.getStatementFields)(e,t)
return this.args.attrs.filter((e=>l.includes(e.name)))}}e.default=l})),define("vault/components/date-dropdown",["exports","@glimmer/component","@ember/object","@glimmer/tracking","core/utils/date-formatters","core/utils/timestamp"],(function(e,t,n,l,a,i){var r,o,s,u,d,c
function p(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function m(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function f(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let h=(r=class extends t.default{constructor(){super(...arguments),m(this,"currentDate",i.default.now()),m(this,"currentYear",this.currentDate.getFullYear()),m(this,"currentMonthIdx",this.currentDate.getMonth()),m(this,"dropdownMonths",a.ARRAY_OF_MONTHS.map(((e,t)=>({name:e,index:t})))),m(this,"dropdownYears",Array.from({length:5},((e,t)=>this.currentYear-t))),p(this,"maxMonthIdx",o,this),p(this,"disabledYear",s,this),p(this,"selectedMonth",u,this),p(this,"selectedYear",d,this),p(this,"invalidDate",c,this)}selectMonth(e,t){this.selectedMonth=e,this.disabledYear=e.index>this.currentMonthIdx?this.currentYear:null,t.close()}selectYear(e,t){this.selectedYear=e,this.maxMonthIdx=e===this.currentYear?this.currentMonthIdx:11,t.close()}handleSubmit(){if(this.args.validateDate&&(this.invalidDate=null,this.invalidDate=this.args.validateDate(new Date(this.selectedYear,this.selectedMonth.index)),this.invalidDate))return
const{index:e,name:t}=this.selectedMonth
this.args.handleSubmit({monthIdx:e,monthName:t,year:this.selectedYear,dateType:this.args.dateType}),this.resetDropdown()}handleCancel(){this.args.handleCancel(),this.resetDropdown()}resetDropdown(){this.maxMonthIdx=11,this.disabledYear=null,this.selectedMonth=null,this.selectedYear=null,this.invalidDate=null}},o=f(r.prototype,"maxMonthIdx",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return 11}}),s=f(r.prototype,"disabledYear",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),u=f(r.prototype,"selectedMonth",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),d=f(r.prototype,"selectedYear",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),c=f(r.prototype,"invalidDate",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),f(r.prototype,"selectMonth",[n.action],Object.getOwnPropertyDescriptor(r.prototype,"selectMonth"),r.prototype),f(r.prototype,"selectYear",[n.action],Object.getOwnPropertyDescriptor(r.prototype,"selectYear"),r.prototype),f(r.prototype,"handleSubmit",[n.action],Object.getOwnPropertyDescriptor(r.prototype,"handleSubmit"),r.prototype),f(r.prototype,"handleCancel",[n.action],Object.getOwnPropertyDescriptor(r.prototype,"handleCancel"),r.prototype),r)
e.default=h})),define("vault/components/diff-version-selector",["exports","@glimmer/component","@ember/service","@ember/object","@glimmer/tracking"],(function(e,t,n,l,a){var i,r,o,s,u,d,c,p
function m(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function f(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let h=(i=class extends t.default{constructor(){var e,t,n
super(...arguments),m(this,"leftSideVersionDataSelected",r,this),m(this,"leftSideVersionSelected",o,this),m(this,"rightSideVersionDataSelected",s,this),m(this,"rightSideVersionSelected",u,this),m(this,"statesMatch",d,this),m(this,"visualDiff",c,this),m(this,"store",p,this),e=this,t="adapter",n=this.store.adapterFor("secret-v2-version"),t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,this.createVisualDiff()}get leftSideDataInit(){const e=`["${this.args.model.engineId}", "${this.args.model.id}", "${this.args.model.currentVersion}"]`
return this.adapter.querySecretDataByVersion(e).then((e=>e.data)).catch((()=>null))}get rightSideDataInit(){const e=`["${this.args.model.engineId}", "${this.args.model.id}", "${this.rightSideVersionInit}"]`
return this.adapter.querySecretDataByVersion(e).then((e=>e.data)).catch((()=>null))}get rightSideVersionInit(){return 1===this.args.model.currentVersion?0:this.args.model.currentVersion-1}async createVisualDiff(){const e=jsondiffpatch.create({}),t=this.leftSideVersionDataSelected||await this.leftSideDataInit,n=this.rightSideVersionDataSelected||await this.rightSideDataInit,l=e.diff(n,t)
void 0===l?(this.statesMatch=!0,this.visualDiff=JSON.stringify(t,void 0,2)):(this.statesMatch=!1,this.visualDiff=jsondiffpatch.formatters.html.format(l,n))}async selectVersion(e,t,n){const l=`["${this.args.model.engineId}", "${this.args.model.id}", "${e}"]`,a=await this.adapter.querySecretDataByVersion(l)
"left"===n&&(this.leftSideVersionDataSelected=a.data,this.leftSideVersionSelected=e),"right"===n&&(this.rightSideVersionDataSelected=a.data,this.rightSideVersionSelected=e),await this.createVisualDiff(),t.close()}},r=f(i.prototype,"leftSideVersionDataSelected",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),o=f(i.prototype,"leftSideVersionSelected",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),s=f(i.prototype,"rightSideVersionDataSelected",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),u=f(i.prototype,"rightSideVersionSelected",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),d=f(i.prototype,"statesMatch",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),c=f(i.prototype,"visualDiff",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),p=f(i.prototype,"store",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f(i.prototype,"selectVersion",[l.action],Object.getOwnPropertyDescriptor(i.prototype,"selectVersion"),i.prototype),i)
e.default=h})),define("vault/components/doc-link",["exports","core/components/doc-link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/download-button",["exports","core/components/download-button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/edit-form",["exports","core/components/edit-form"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-modal-dialog-positioned-container",["exports","ember-modal-dialog/components/positioned-container"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-modal-dialog/-basic-dialog",["exports","ember-modal-dialog/components/basic-dialog"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-modal-dialog/-in-place-dialog",["exports","ember-modal-dialog/components/in-place-dialog"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-modal-dialog/-liquid-dialog",["exports","ember-modal-dialog/components/liquid-dialog"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-modal-dialog/-liquid-tether-dialog",["exports","ember-modal-dialog/components/liquid-tether-dialog"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-modal-dialog/-tether-dialog",["exports","ember-modal-dialog/components/tether-dialog"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-tether",["exports","ember-tether/components/ember-tether"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-wormhole",["exports","ember-wormhole/components/ember-wormhole"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/empty-state",["exports","core/components/empty-state"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/external-link",["exports","core/components/external-link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/field-group-show",["exports","core/components/field-group-show"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/file-to-array-buffer",["exports","@glimmer/component","@glimmer/tracking","@ember/object","filesize"],(function(e,t,n,l,a){var i,r,o,s
function u(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function d(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let c=(i=class extends t.default{constructor(){super(...arguments),u(this,"filename",r,this),u(this,"fileSize",o,this),u(this,"fileLastModified",s,this)}readFile(e){const t=new FileReader
t.onload=()=>{this.isDestroyed||this.isDestroying||this.fileChange(t.result,e)},t.readAsArrayBuffer(e)}pickedFile(e){const{files:t}=e.target
if(t.length)for(let n=0,l=t.length;n<l;n++)this.readFile(t[n])}fileChange(e,t){const{name:n,size:l,lastModifiedDate:i}=t||{}
this.filename=n,this.fileSize=l?(0,a.default)(l):null,this.fileLastModified=i,this.args.onChange(e,n)}},r=d(i.prototype,"filename",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),o=d(i.prototype,"fileSize",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),s=d(i.prototype,"fileLastModified",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),d(i.prototype,"pickedFile",[l.action],Object.getOwnPropertyDescriptor(i.prototype,"pickedFile"),i.prototype),d(i.prototype,"fileChange",[l.action],Object.getOwnPropertyDescriptor(i.prototype,"fileChange"),i.prototype),i)
e.default=c})),define("vault/components/filter-input",["exports","core/components/filter-input"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/flash-message",["exports","ember-cli-flash/components/flash-message"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{get alertType(){return`is-${this.args.flash.type||""}`}}e.default=n})),define("vault/components/flight-icon",["exports","@hashicorp/ember-flight-icons/components/flight-icon"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/form-error",["exports","core/components/form-error"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/form-field-groups-loop",["exports","core/components/form-field-groups-loop"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/form-field-groups",["exports","core/components/form-field-groups"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/form-field-label",["exports","core/components/form-field-label"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/form-field",["exports","core/components/form-field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/form-save-buttons",["exports","core/components/form-save-buttons"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/generate-credentials-database",["exports","@glimmer/component","@ember/object"],(function(e,t,n){var l
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let a=(l=class extends t.default{get errorTitle(){return this.args.model.errorTitle||"Something went wrong"}redirectPreviousPage(){window.history.back()}},i=l.prototype,r="redirectPreviousPage",o=[n.action],s=Object.getOwnPropertyDescriptor(l.prototype,"redirectPreviousPage"),u=l.prototype,d={},Object.keys(s).forEach((function(e){d[e]=s[e]})),d.enumerable=!!d.enumerable,d.configurable=!!d.configurable,("value"in d||d.initializer)&&(d.writable=!0),d=o.slice().reverse().reduce((function(e,t){return t(i,r,e)||e}),d),u&&void 0!==d.initializer&&(d.value=d.initializer?d.initializer.call(u):void 0,d.initializer=void 0),void 0===d.initializer&&(Object.defineProperty(i,r,d),d=null),l)
var i,r,o,s,u,d
e.default=a})),define("vault/components/generate-credentials",["exports","@ember/service","@ember/object","@ember/component"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const a={"ssh-sign":{model:"ssh-sign"},"ssh-creds":{model:"ssh-otp-credential",title:"Generate SSH Credentials"},"aws-creds":{model:"aws-credential",title:"Generate AWS Credentials",backIsListLink:!0}}
var i=l.default.extend({controlGroup:(0,t.inject)(),store:(0,t.inject)(),router:(0,t.inject)(),backendType:null,backendPath:null,roleName:null,action:null,model:null,loading:!1,emptyData:"{\n}",modelForType(){const e=this.options
if(e)return e.model
this.router.transitionTo("vault.cluster.secrets.backend.list-root",this.backendPath)},options:(0,n.computed)("action","backendType",(function(){const e=this.action||"creds"
return a[`${this.backendType}-${e}`]})),init(){this._super(...arguments),this.createOrReplaceModel()},willDestroy(){!(this.store&&!this.store.isDestroying)||this.model.isDestroyed||this.model.isDestroying||this.model.unloadRecord(),this._super(...arguments)},createOrReplaceModel(){const e=this.modelForType(),t=this.model,n=this.roleName,l=this.backendPath
if(!e)return
t&&t.unloadRecord()
const a={role:{backend:l,name:n},id:`${l}-${n}`},i=this.store.createRecord(e,a)
this.set("model",i)},actions:{create(){const e=this.model
this.set("loading",!0),this.model.save().then((()=>{e.set("hasGenerated",!0)})).catch((e=>{if("Control Group encountered"===e.message){this.controlGroup.saveTokenFromError(e)
const t=this.controlGroup.logFromError(e)
e.errors=[t.content]}throw e})).finally((()=>{this.set("loading",!1)}))},codemirrorUpdated(e,t,l){l.performLint()
l.state.lint.marked.length>0||(0,n.set)(this.model,e,JSON.parse(t))},newModel(){this.createOrReplaceModel()}}})
e.default=i})),define("vault/components/generated-item-list",["exports","@ember/service","@glimmer/component","@ember/object","@ember/application"],(function(e,t,n,l,a){var i,r,o
function s(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function u(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let d=(i=class extends n.default{constructor(){super(...arguments),s(this,"router",r,this),s(this,"store",o,this)}get model(){return this.args.model||null}get itemType(){return this.args.itemType||null}refreshItemList(){const e=(0,a.getOwner)(this).lookup(`route:${this.router.currentRouteName}`)
this.store.clearAllDatasets(),e.refresh()}},r=u(i.prototype,"router",[t.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),o=u(i.prototype,"store",[t.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u(i.prototype,"refreshItemList",[l.action],Object.getOwnPropertyDescriptor(i.prototype,"refreshItemList"),i.prototype),i)
e.default=d})),define("vault/components/generated-item",["exports","@ember-data/adapter/error","@ember/service","@ember/component","@ember/object","ember-concurrency","@ember/test-waiters"],(function(e,t,n,l,a,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var o=l.default.extend({model:null,itemType:null,flashMessages:(0,n.inject)(),router:(0,n.inject)(),modelValidations:null,isFormInvalid:!1,props:(0,a.computed)("model",(function(){return this.model.serialize()})),saveModel:(0,i.task)((0,r.waitFor)((function*(){try{yield this.model.save()}catch(e){if(e instanceof t.default==!1)throw e
return}this.router.transitionTo("vault.cluster.access.method.item.list").followRedirects(),this.flashMessages.success(`Successfully saved ${this.itemType} ${this.model.id}.`)}))),init(){this._super(...arguments),"edit"===this.mode&&this.model.fieldGroups.forEach((e=>{e.default&&e.default.forEach((e=>{const t=e.options&&e.options.fieldValue
t&&(this.model[e.name]=this.model[t])}))}))},actions:{onKeyUp(e,t){if(this.model.set(e,t),this.model.validate){const{isValid:e,state:t}=this.model.validate()
this.setProperties({modelValidations:t,isFormInvalid:!e})}else this.set("isFormInvalid",!1)},deleteItem(){this.model.destroyRecord().then((()=>{this.router.transitionTo("vault.cluster.access.method.item.list").followRedirects(),this.flashMessages.success(`Successfully deleted ${this.itemType} ${this.model.id}.`)}))}}})
e.default=o})),define("vault/components/get-credentials-card",["exports","@ember/component","@ember/template-factory","@glimmer/component","@ember/service","@ember/object","@glimmer/tracking"],(function(e,t,n,l,a,i,r){var o,s,u,d,c
function p(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function m(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const f=(0,n.createTemplateFactory)({id:"YQARR4kk",block:'[[[11,"form"],[24,0,"selectable-card is-rounded no-flex data-test-get-credentials-card"],[4,[38,0],["submit",[30,0,["transitionToCredential"]]],null],[12],[1,"\\n  "],[10,0],[14,0,"is-flex-between is-fullwidth card-details"],[12],[1,"\\n    "],[10,"h3"],[14,0,"title is-5"],[12],[1,[30,1]],[13],[1,"\\n  "],[13],[1,"\\n  "],[10,0],[14,0,"has-top-bottom-margin"],[12],[1,"\\n    "],[10,2],[14,0,"is-label search-label"],[12],[1,[30,2]],[13],[1,"\\n  "],[13],[1,"\\n  "],[10,2],[14,0,"sub-text"],[12],[1,[30,3]],[13],[1,"\\n"],[41,[30,4],[[[1,"    "],[8,[39,2],null,[["@id","@onChange","@placeholder","@initialValue"],[[29,["search-input-",[30,5]]],[30,0,["handleInput"]],[30,6],[30,7]]],null],[1,"\\n"]],[]],[[[1,"    "],[8,[39,3],null,[["@id","@models","@selectLimit","@backend","@fallbackComponent","@onChange","@placeholder"],[[29,["search-input-",[30,5]]],[30,8],"1",[30,9],"input-search",[30,0,["handleInput"]],[30,6]]],null],[1,"\\n"]],[]]],[1,"  "],[10,"button"],[14,0,"button is-secondary"],[15,"disabled",[30,0,["buttonDisabled"]]],[14,4,"submit"],[12],[1,"\\n    "],[1,[30,0,["buttonText"]]],[1,"\\n  "],[13],[1,"\\n"],[13]],["@title","@searchLabel","@subText","@renderInputSearch","@type","@placeholder","@initialValue","@models","@backend"],false,["on","if","input-search","search-select"]]',moduleName:"vault/components/get-credentials-card.hbs",isStrictMode:!1})
let h=(o=class extends l.default{constructor(){super(...arguments),p(this,"router",s,this),p(this,"store",u,this),p(this,"role",d,this),p(this,"secret",c,this),this.secret=this.args?.initialValue||""}get buttonText(){return"secret"===this.args.type?this.secret.endsWith("/")?"View list":"View secret":"Get credentials"}get buttonDisabled(){return!this.role&&!this.secret}transitionToCredential(e){e.preventDefault()
const t=this.role,n=this.secret
if(t&&this.router.transitionTo("vault.cluster.secrets.backend.credentials",t),n){if(n.endsWith("/"))return void this.router.transitionTo("vault.cluster.secrets.backend.list",n)
this.router.transitionTo("vault.cluster.secrets.backend.show",n)}}handleInput(e){"role"===this.args.type&&(Array.isArray(e)?this.role=e[0]:this.role=e),"secret"===this.args.type&&(this.secret=e)}},s=m(o.prototype,"router",[a.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=m(o.prototype,"store",[a.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=m(o.prototype,"role",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),c=m(o.prototype,"secret",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),m(o.prototype,"transitionToCredential",[i.action],Object.getOwnPropertyDescriptor(o.prototype,"transitionToCredential"),o.prototype),m(o.prototype,"handleInput",[i.action],Object.getOwnPropertyDescriptor(o.prototype,"handleInput"),o.prototype),o)
e.default=h,(0,t.setComponentTemplate)(f,h)})),define("vault/components/hds/alert/description",["exports","@hashicorp/design-system-components/components/hds/alert/description"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/alert/index",["exports","@hashicorp/design-system-components/components/hds/alert/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/alert/title",["exports","@hashicorp/design-system-components/components/hds/alert/title"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-frame/index",["exports","@hashicorp/design-system-components/components/hds/app-frame/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-frame/parts/footer",["exports","@hashicorp/design-system-components/components/hds/app-frame/parts/footer"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-frame/parts/header",["exports","@hashicorp/design-system-components/components/hds/app-frame/parts/header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-frame/parts/main",["exports","@hashicorp/design-system-components/components/hds/app-frame/parts/main"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-frame/parts/modals",["exports","@hashicorp/design-system-components/components/hds/app-frame/parts/modals"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-frame/parts/sidebar",["exports","@hashicorp/design-system-components/components/hds/app-frame/parts/sidebar"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/application-state/body",["exports","@hashicorp/design-system-components/components/hds/application-state/body"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/application-state/footer",["exports","@hashicorp/design-system-components/components/hds/application-state/footer"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/application-state/header",["exports","@hashicorp/design-system-components/components/hds/application-state/header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/hds/application-state/index",["exports","@hashicorp/design-system-components/components/hds/application-state/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/avatar/index",["exports","@hashicorp/design-system-components/components/hds/avatar/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/badge-count/index",["exports","@hashicorp/design-system-components/components/hds/badge-count/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/badge/index",["exports","@hashicorp/design-system-components/components/hds/badge/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/breadcrumb/index",["exports","@hashicorp/design-system-components/components/hds/breadcrumb/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/breadcrumb/item",["exports","@hashicorp/design-system-components/components/hds/breadcrumb/item"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/breadcrumb/truncation",["exports","@hashicorp/design-system-components/components/hds/breadcrumb/truncation"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/button-set/index",["exports","@hashicorp/design-system-components/components/hds/button-set/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/button/index",["exports","@hashicorp/design-system-components/components/hds/button/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/card/container",["exports","@hashicorp/design-system-components/components/hds/card/container"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/disclosure-primitive/index",["exports","@hashicorp/design-system-components/components/hds/disclosure-primitive/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dismiss-button/index",["exports","@hashicorp/design-system-components/components/hds/dismiss-button/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/footer",["exports","@hashicorp/design-system-components/components/hds/dropdown/footer"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/header",["exports","@hashicorp/design-system-components/components/hds/dropdown/header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/index",["exports","@hashicorp/design-system-components/components/hds/dropdown/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/checkbox",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/checkbox"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/checkmark",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/checkmark"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/copy-item",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/copy-item"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/description",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/description"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/generic",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/generic"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/interactive",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/interactive"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/radio",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/radio"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/separator",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/separator"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/title",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/title"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/toggle/button",["exports","@hashicorp/design-system-components/components/hds/dropdown/toggle/button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/toggle/chevron",["exports","@hashicorp/design-system-components/components/hds/dropdown/toggle/chevron"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/toggle/icon",["exports","@hashicorp/design-system-components/components/hds/dropdown/toggle/icon"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/flyout/body",["exports","@hashicorp/design-system-components/components/hds/flyout/body"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/flyout/description",["exports","@hashicorp/design-system-components/components/hds/flyout/description"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/flyout/footer",["exports","@hashicorp/design-system-components/components/hds/flyout/footer"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/hds/flyout/header",["exports","@hashicorp/design-system-components/components/hds/flyout/header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/flyout/index",["exports","@hashicorp/design-system-components/components/hds/flyout/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/checkbox/base",["exports","@hashicorp/design-system-components/components/hds/form/checkbox/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/checkbox/field",["exports","@hashicorp/design-system-components/components/hds/form/checkbox/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/checkbox/group",["exports","@hashicorp/design-system-components/components/hds/form/checkbox/group"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/error/index",["exports","@hashicorp/design-system-components/components/hds/form/error/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/error/message",["exports","@hashicorp/design-system-components/components/hds/form/error/message"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/field/index",["exports","@hashicorp/design-system-components/components/hds/form/field/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/fieldset/index",["exports","@hashicorp/design-system-components/components/hds/form/fieldset/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/helper-text/index",["exports","@hashicorp/design-system-components/components/hds/form/helper-text/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/indicator/index",["exports","@hashicorp/design-system-components/components/hds/form/indicator/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/label/index",["exports","@hashicorp/design-system-components/components/hds/form/label/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/legend/index",["exports","@hashicorp/design-system-components/components/hds/form/legend/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/radio-card/description",["exports","@hashicorp/design-system-components/components/hds/form/radio-card/description"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/radio-card/group",["exports","@hashicorp/design-system-components/components/hds/form/radio-card/group"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/radio-card/index",["exports","@hashicorp/design-system-components/components/hds/form/radio-card/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/radio-card/label",["exports","@hashicorp/design-system-components/components/hds/form/radio-card/label"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/radio/base",["exports","@hashicorp/design-system-components/components/hds/form/radio/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/radio/field",["exports","@hashicorp/design-system-components/components/hds/form/radio/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/radio/group",["exports","@hashicorp/design-system-components/components/hds/form/radio/group"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/select/base",["exports","@hashicorp/design-system-components/components/hds/form/select/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/select/field",["exports","@hashicorp/design-system-components/components/hds/form/select/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/text-input/base",["exports","@hashicorp/design-system-components/components/hds/form/text-input/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/text-input/field",["exports","@hashicorp/design-system-components/components/hds/form/text-input/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/textarea/base",["exports","@hashicorp/design-system-components/components/hds/form/textarea/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/textarea/field",["exports","@hashicorp/design-system-components/components/hds/form/textarea/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/toggle/base",["exports","@hashicorp/design-system-components/components/hds/form/toggle/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/toggle/field",["exports","@hashicorp/design-system-components/components/hds/form/toggle/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/toggle/group",["exports","@hashicorp/design-system-components/components/hds/form/toggle/group"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/icon-tile/index",["exports","@hashicorp/design-system-components/components/hds/icon-tile/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/hds/interactive/index",["exports","@hashicorp/design-system-components/components/hds/interactive/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/link/inline",["exports","@hashicorp/design-system-components/components/hds/link/inline"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/link/standalone",["exports","@hashicorp/design-system-components/components/hds/link/standalone"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/menu-primitive/index",["exports","@hashicorp/design-system-components/components/hds/menu-primitive/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/modal/body",["exports","@hashicorp/design-system-components/components/hds/modal/body"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/modal/footer",["exports","@hashicorp/design-system-components/components/hds/modal/footer"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/modal/header",["exports","@hashicorp/design-system-components/components/hds/modal/header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/modal/index",["exports","@hashicorp/design-system-components/components/hds/modal/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/page-header/actions",["exports","@hashicorp/design-system-components/components/hds/page-header/actions"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/page-header/badges",["exports","@hashicorp/design-system-components/components/hds/page-header/badges"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/page-header/description",["exports","@hashicorp/design-system-components/components/hds/page-header/description"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/page-header/index",["exports","@hashicorp/design-system-components/components/hds/page-header/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/page-header/subtitle",["exports","@hashicorp/design-system-components/components/hds/page-header/subtitle"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/page-header/title",["exports","@hashicorp/design-system-components/components/hds/page-header/title"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/pagination/compact/index",["exports","@hashicorp/design-system-components/components/hds/pagination/compact/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/pagination/info",["exports","@hashicorp/design-system-components/components/hds/pagination/info"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/pagination/nav/arrow",["exports","@hashicorp/design-system-components/components/hds/pagination/nav/arrow"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/pagination/nav/ellipsis",["exports","@hashicorp/design-system-components/components/hds/pagination/nav/ellipsis"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/pagination/nav/number",["exports","@hashicorp/design-system-components/components/hds/pagination/nav/number"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/pagination/numbered/index",["exports","@hashicorp/design-system-components/components/hds/pagination/numbered/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/pagination/size-selector",["exports","@hashicorp/design-system-components/components/hds/pagination/size-selector"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/reveal/index",["exports","@hashicorp/design-system-components/components/hds/reveal/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/reveal/toggle/button",["exports","@hashicorp/design-system-components/components/hds/reveal/toggle/button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/segmented-group/index",["exports","@hashicorp/design-system-components/components/hds/segmented-group/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/separator/index",["exports","@hashicorp/design-system-components/components/hds/separator/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/base",["exports","@hashicorp/design-system-components/components/hds/side-nav/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/header/home-link",["exports","@hashicorp/design-system-components/components/hds/side-nav/header/home-link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/header/icon-button",["exports","@hashicorp/design-system-components/components/hds/side-nav/header/icon-button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/header/index",["exports","@hashicorp/design-system-components/components/hds/side-nav/header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/index",["exports","@hashicorp/design-system-components/components/hds/side-nav/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/hds/side-nav/list/back-link",["exports","@hashicorp/design-system-components/components/hds/side-nav/list/back-link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/list/index",["exports","@hashicorp/design-system-components/components/hds/side-nav/list/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/list/item",["exports","@hashicorp/design-system-components/components/hds/side-nav/list/item"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/list/link",["exports","@hashicorp/design-system-components/components/hds/side-nav/list/link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/list/title",["exports","@hashicorp/design-system-components/components/hds/side-nav/list/title"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/portal/index",["exports","@hashicorp/design-system-components/components/hds/side-nav/portal/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/portal/target",["exports","@hashicorp/design-system-components/components/hds/side-nav/portal/target"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/stepper/step/indicator",["exports","@hashicorp/design-system-components/components/hds/stepper/step/indicator"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/stepper/task/indicator",["exports","@hashicorp/design-system-components/components/hds/stepper/task/indicator"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/table/index",["exports","@hashicorp/design-system-components/components/hds/table/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/table/td",["exports","@hashicorp/design-system-components/components/hds/table/td"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/table/th-sort",["exports","@hashicorp/design-system-components/components/hds/table/th-sort"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/table/th",["exports","@hashicorp/design-system-components/components/hds/table/th"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/table/tr",["exports","@hashicorp/design-system-components/components/hds/table/tr"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/tabs/index",["exports","@hashicorp/design-system-components/components/hds/tabs/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/tabs/panel",["exports","@hashicorp/design-system-components/components/hds/tabs/panel"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/tabs/tab",["exports","@hashicorp/design-system-components/components/hds/tabs/tab"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/tag/index",["exports","@hashicorp/design-system-components/components/hds/tag/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/toast/index",["exports","@hashicorp/design-system-components/components/hds/toast/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/tooltip-button/index",["exports","@hashicorp/design-system-components/components/hds/tooltip-button/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/yield/index",["exports","@hashicorp/design-system-components/components/hds/yield/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hover-copy-button",["exports","@glimmer/component","@glimmer/tracking"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="tooltipText",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}get alwaysShow(){return this.args.alwaysShow||!1}get copyValue(){return this.args.copyValue||!1}},r=l.prototype,o="tooltipText",s=[n.tracked],u={configurable:!0,enumerable:!0,writable:!0,initializer:function(){return"Copy"}},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/components/icon",["exports","core/components/icon"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/identity/_popup-base",["exports","@ember/service","@ember/debug","@ember/component"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=l.default.extend({tagName:"",flashMessages:(0,t.inject)(),params:null,successMessage:()=>"Save was successful",errorMessage:()=>"There was an error saving",onError(e){e&&e.rollbackAttributes&&e.rollbackAttributes()},onSuccess(){},transaction(){},actions:{performTransaction(){const e=[...arguments],t=this.messageArgs(...e)
return this.transaction(...e).then((()=>{this.onSuccess(),this.flashMessages.success(this.successMessage(...t))})).catch((e=>{this.onError(...t),this.flashMessages.success(this.errorMessage(e,...t))}))}}})
e.default=a})),define("vault/components/identity/edit-form",["exports","@ember/service","@ember/component","@ember/object","ember-concurrency","vault/helpers/humanize","@ember/test-waiters"],(function(e,t,n,l,a,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var o=n.default.extend({flashMessages:(0,t.inject)(),store:(0,t.inject)(),"data-test-component":"identity-edit-form",attributeBindings:["data-test-component"],model:null,mode:"create",onSave:()=>{},cancelLink:(0,l.computed)("mode","model.identityType",(function(){const{model:e,mode:t}=this
return{"create-entity":"vault.cluster.access.identity","edit-entity":"vault.cluster.access.identity.show","merge-entity-merge":"vault.cluster.access.identity","create-entity-alias":"vault.cluster.access.identity.aliases","edit-entity-alias":"vault.cluster.access.identity.aliases.show","create-group":"vault.cluster.access.identity","edit-group":"vault.cluster.access.identity.show","create-group-alias":"vault.cluster.access.identity.aliases","edit-group-alias":"vault.cluster.access.identity.aliases.show"}[e?`${t}-${e.identityType}`:"merge-entity-alias"]})),getMessage(e){let t=arguments.length>1&&void 0!==arguments[1]&&arguments[1]
const n=this.mode,l=(0,i.humanize)([e.identityType]),a=t?"deleted":"saved"
return"merge"===n?"Successfully merged entities":e.id?`Successfully ${a} ${l} ${e.id}.`:`Successfully ${a} ${l}.`},save:(0,a.task)((0,r.waitFor)((function*(){const e=this.model,t=this.getMessage(e)
try{yield e.save()}catch(n){return}this.flashMessages.success(t),yield this.onSave({saveType:"save",model:e})}))).drop(),willDestroy(){const e=this.store&&!this.store.isDestroying,t=this.model
e&&t&&t.get("isDirty")&&!t.isDestroyed&&!t.isDestroying&&t.rollbackAttributes(),this._super(...arguments)},actions:{deleteItem(e){const t=this.getMessage(e,!0),n=this.flashMessages
e.destroyRecord().then((()=>(n.success(t),this.onSave({saveType:"delete",model:e}))))}}})
e.default=o})),define("vault/components/identity/entity-nav",["exports","@ember/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({})
e.default=n})),define("vault/components/identity/item-details",["exports","@ember/service","@ember/component"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=n.default.extend({flashMessages:(0,t.inject)(),actions:{enable(e){e.set("disabled",!1),e.save().then((()=>{this.flashMessages.success(`Successfully enabled entity: ${e.id}`)})).catch((t=>{this.flashMessages.success(`There was a problem enabling the entity: ${e.id} - ${t.errors.join(" ")||t.message}`)}))}}})
e.default=l})),define("vault/components/identity/lookup-input",["exports","@ember/service","@ember/component","ember-concurrency","vault/helpers/underscore"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=n.default.extend({store:(0,t.inject)(),flashMessages:(0,t.inject)(),router:(0,t.inject)(),type:"entity",param:"alias name",paramValue:null,aliasMountAccessor:null,authMethods:null,init(){this._super(...arguments),this.store.findAll("auth-method").then((e=>{this.set("authMethods",e),this.set("aliasMountAccessor",e.get("firstObject.accessor"))}))},adapter(){const e=this.type
return this.store.adapterFor(`identity/${e}`)},data(){const{param:e,paramValue:t,aliasMountAccessor:n}=this,l={}
return l[(0,a.underscore)([e])]=t,"alias name"===e&&(l.alias_mount_accessor=n),l},lookup:(0,l.task)((function*(){const e=this.flashMessages,t=this.type,n=this.store,{param:l,paramValue:a}=this
let i
try{i=yield this.adapter().lookup(n,this.data())}catch(r){return void e.danger(`We encountered an error attempting the ${t} lookup: ${r.message||r.errors.join("")}.`)}if(i)return this.router.transitionTo("vault.cluster.access.identity.show",i.id,"details")
e.danger(`We were unable to find an identity ${t} with a "${l}" of "${a}".`)}))})
e.default=i})),define("vault/components/identity/popup-alias",["exports","vault/components/identity/_popup-base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({messageArgs:e=>[e.get("identityType"),e.id],successMessage:(e,t)=>`Successfully deleted ${e}: ${t}`,errorMessage:(e,t,n)=>`There was a problem deleting ${t}: ${n} - ${e.errors?e.errors.join(" "):e.message}`,transaction:e=>e.destroyRecord()})
e.default=n})),define("vault/components/identity/popup-members",["exports","@ember/object/computed","@ember/object","vault/components/identity/_popup-base"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=l.default.extend({model:(0,t.alias)("params.firstObject"),groupArray:(0,n.computed)("params",(function(){return this.params.objectAt(1)})),memberId:(0,n.computed)("params",(function(){return this.params.objectAt(2)})),messageArgs(){return[...arguments]},successMessage:(e,t,n)=>`Successfully removed '${n}' from the group`,errorMessage:(e,t,n,l)=>`There was a problem removing '${l}' from the group - ${e.errors?e.errors.join(" "):e.message}`,transaction(e,t,n){const l=e.get(t)
return e.set(t,l.without(n)),e.save()}})
e.default=a}))
define("vault/components/identity/popup-metadata",["exports","vault/components/identity/_popup-base","@ember/object","@ember/object/computed"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=t.default.extend({model:(0,l.alias)("params.firstObject"),key:(0,n.computed)("params",(function(){return this.params.objectAt(1)})),messageArgs:(e,t)=>[e,t],successMessage:(e,t)=>`Successfully removed '${t}' from metadata`,errorMessage:(e,t,n)=>`There was a problem removing '${n}' from the metadata - ${e.errors?e.errors.join(" "):e.message}`,transaction(e,t){const n=e.metadata
return delete n[t],e.set("metadata",{...n}),e.save()}})
e.default=a})),define("vault/components/identity/popup-policy",["exports","@ember/object/computed","@ember/object","vault/components/identity/_popup-base"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=l.default.extend({model:(0,t.alias)("params.firstObject"),policyName:(0,n.computed)("params",(function(){return this.params.objectAt(1)})),messageArgs:(e,t)=>[e,t],successMessage:(e,t)=>`Successfully removed '${t}' policy from ${e.id} `,errorMessage:(e,t,n)=>`There was a problem removing '${n}' policy - ${e.errors?e.errors.join(" "):e.message}`,transaction(e,t){const n=e.get("policies")
return e.set("policies",n.without(t)),e.save()}})
e.default=a})),define("vault/components/info-table-item-array",["exports","core/components/info-table-item-array"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/info-table-row",["exports","core/components/info-table-row"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/info-table",["exports","core/components/info-table"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/info-tooltip",["exports","core/components/info-tooltip"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/input-search",["exports","core/components/input-search"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/json-editor",["exports","core/components/json-editor"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/key-value-header",["exports","core/components/key-value-header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/key-version-select",["exports","@ember/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({tagName:""})
e.default=n})),define("vault/components/keymgmt/distribute",["exports","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","vault/models/keymgmt/key","ember-concurrency","@ember/test-waiters"],(function(e,t,n,l,a,i,r,o){var s,u,d,c,p,m,f,h,b,y,v,g,w,k
function x(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function _(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let P=(u=_((s=class{constructor(){x(this,"key",u,this),x(this,"provider",d,this),x(this,"operations",c,this),x(this,"protection",p,this)}}).prototype,"key",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=_(s.prototype,"provider",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=_(s.prototype,"operations",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=_(s.prototype,"protection",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s)
const T={gcpckms:["aes256-gcm96","rsa-2048","rsa-3072","rsa-4096","ecdsa-p256","ecdsa-p384","ecdsa-p521"],awskms:["aes256-gcm96"],azurekeyvault:["rsa-2048","rsa-3072","rsa-4096"]}
let O=(m=class extends t.default{constructor(){super(...arguments),x(this,"store",f,this),x(this,"flashMessages",h,this),x(this,"router",b,this),x(this,"keyModel",y,this),x(this,"isNewKey",v,this),x(this,"providerType",g,this),x(this,"formData",w,this),x(this,"formErrors",k,this),this.formData=new P,this.formData.key=this.args.key||"",this.formData.provider=this.args.provider||"",this.args.provider&&this.getProviderType(this.args.provider),this.args.key&&this.getKeyInfo(this.args.key),this.formData.operations=[]}get keyTypes(){return i.KEY_TYPES}get validMatchError(){if(!this.providerType||!this.keyModel?.type)return null
if(T[this.providerType]?.includes(this.keyModel.type))return null
if(this.args.provider)return{key:`This key type is incompatible with the ${this.providerType} provider. To distribute to this provider, change the key type or choose another key.`}
const e=`This provider is incompatible with the ${this.keyModel.type} key type. Please choose another provider`
return{provider:this.args.key?`${e}.`:`${e} or change the key type.`}}get operations(){const e=this.providerType
if("awskms"===e)return["encrypt","decrypt"]
if("gcpckms"===e){switch(this.keyModel?.type||""){case"aes256-gcm96":return["encrypt","decrypt"]
case"rsa-2048":case"rsa-3072":case"rsa-4096":return["decrypt","sign"]
case"ecdsa-p256":case"ecdsa-p384":return["sign"]
default:return["encrypt","decrypt","sign","verify","wrap","unwrap"]}}return["encrypt","decrypt","sign","verify","wrap","unwrap"]}get disableOperations(){return this.validMatchError||!this.formData.provider||!this.formData.key||this.isNewKey&&!this.keyModel.type}async getKeyInfo(e){let t
arguments.length>1&&void 0!==arguments[1]&&arguments[1]?(this.isNewKey=!0,t=this.store.createRecord("keymgmt/key",{backend:this.args.backend,id:e,name:e})):t=await this.store.queryRecord("keymgmt/key",{backend:this.args.backend,id:e,recordOnly:!0}).catch((()=>{})),this.keyModel=t}async getProviderType(e){if(!e)return void(this.providerType="")
const t=await this.store.queryRecord("keymgmt/provider",{backend:this.args.backend,id:e}).catch((()=>{}))
this.providerType=t?.provider}destroyKey(){this.isNewKey&&this.keyModel.destroyRecord().finally((()=>{this.keyModel=null})),this.isNewKey=!1,this.keyModel=null}formatData(e){const{key:t,provider:n,operations:l,protection:a}=e
return t&&n&&l&&0!==l.length?{key:t,provider:n,purpose:l.join(","),protection:a}:null}distributeKey(e,t){const n=this.store.adapterFor("keymgmt/key"),{key:l,provider:a,purpose:i,protection:r}=t
return n.distribute(e,a,l,{purpose:i,protection:r}).then((()=>{this.flashMessages.success(`Successfully distributed key ${l} to ${a}`),this.store.clearDataset("keymgmt/key")
const e=this.store.peekRecord("keymgmt/provider",a)
e.fetchKeys(e.keys?.meta?.currentPage||1),this.args.onClose()})).catch((e=>{this.formErrors=`${e.errors}`}))}handleProvider(e){let t=e[0]
"string"==typeof e&&(t=e),this.formData.provider=t,t&&this.getProviderType(t)}handleKeyType(e){this.keyModel.set("type",e.target.value)}handleOperation(e){const t=[...this.formData.operations]
if(e.target.checked)t.push(e.target.id)
else{const n=t.indexOf(e.target.id)
t.splice(n,1)}this.formData.operations=t}async handleKeySelect(e){const t=e[0]||null
return t?(this.formData.key=t.id,this.getKeyInfo(t.id,t.isNew)):(this.formData.key=null,this.destroyKey())}*createDistribution(e){e.preventDefault()
const{backend:t}=this.args,n=this.formatData(this.formData)
if(n){if(this.isNewKey)try{yield this.keyModel.save(),this.flashMessages.success(`Successfully created key ${this.keyModel.name}`)}catch(l){return void this.flashMessages.danger(`Error creating new key ${this.keyModel.name}: ${l.errors}`)}yield this.distributeKey(t,n),yield this.store.queryRecord("keymgmt/key",{backend:this.args.backend,id:this.keyModel.name})}else this.flashMessages.danger("Key, provider, and operations are all required")}},f=_(m.prototype,"store",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=_(m.prototype,"flashMessages",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=_(m.prototype,"router",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=_(m.prototype,"keyModel",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),v=_(m.prototype,"isNewKey",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),g=_(m.prototype,"providerType",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=_(m.prototype,"formData",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=_(m.prototype,"formErrors",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_(m.prototype,"handleProvider",[n.action],Object.getOwnPropertyDescriptor(m.prototype,"handleProvider"),m.prototype),_(m.prototype,"handleKeyType",[n.action],Object.getOwnPropertyDescriptor(m.prototype,"handleKeyType"),m.prototype),_(m.prototype,"handleOperation",[n.action],Object.getOwnPropertyDescriptor(m.prototype,"handleOperation"),m.prototype),_(m.prototype,"handleKeySelect",[n.action],Object.getOwnPropertyDescriptor(m.prototype,"handleKeySelect"),m.prototype),_(m.prototype,"createDistribution",[r.task,o.waitFor],Object.getOwnPropertyDescriptor(m.prototype,"createDistribution"),m.prototype),m)
e.default=O})),define("vault/components/keymgmt/key-edit",["exports","@glimmer/component","@ember/service","@ember/object","@glimmer/tracking","ember-concurrency","@ember/test-waiters"],(function(e,t,n,l,a,i,r){var o,s,u,d,c
function p(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function m(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const f="vault.cluster.secrets.backend.show"
let h=(o=class extends t.default{constructor(){super(...arguments),p(this,"store",s,this),p(this,"router",u,this),p(this,"flashMessages",d,this),p(this,"isDeleteModalOpen",c,this)}get mode(){return this.args.mode||"show"}get keyAdapter(){return this.store.adapterFor("keymgmt/key")}get isMutable(){return["create","edit"].includes(this.args.mode)}get isCreating(){return"create"===this.args.mode}toggleModal(e){this.isDeleteModalOpen=e}*saveKey(e){e.preventDefault()
const{model:t}=this.args
try{yield t.save(),this.router.transitionTo(f,t.name)}catch(n){let e=n
n.errors&&(e=n.errors.join(". ")),this.flashMessages.danger(e),n.errors||this.router.transitionTo(f,t.name)}}*removeKey(){try{yield this.keyAdapter.removeFromProvider(this.args.model),yield this.args.model.reload(),this.flashMessages.success("Key has been successfully removed from provider")}catch(e){this.flashMessages.danger(e.errors?.join(". "))}}deleteKey(){const e=this.args.model,t=e.backend
e.destroyRecord().then((()=>{this.router.transitionTo("vault.cluster.secrets.backend.list-root",t)})).catch((e=>{this.flashMessages.danger(e.errors?.join(". "))}))}*rotateKey(){const e=this.args.model.name,t=this.args.model.backend,n=this.keyAdapter
yield n.rotateKey(t,e).then((()=>{this.flashMessages.success(`Success: ${e} connection was rotated`)})).catch((e=>{this.flashMessages.danger(e.errors)}))}},s=m(o.prototype,"store",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=m(o.prototype,"router",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=m(o.prototype,"flashMessages",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=m(o.prototype,"isDeleteModalOpen",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),m(o.prototype,"toggleModal",[l.action],Object.getOwnPropertyDescriptor(o.prototype,"toggleModal"),o.prototype),m(o.prototype,"saveKey",[i.task,r.waitFor],Object.getOwnPropertyDescriptor(o.prototype,"saveKey"),o.prototype),m(o.prototype,"removeKey",[i.task,r.waitFor],Object.getOwnPropertyDescriptor(o.prototype,"removeKey"),o.prototype),m(o.prototype,"deleteKey",[l.action],Object.getOwnPropertyDescriptor(o.prototype,"deleteKey"),o.prototype),m(o.prototype,"rotateKey",[i.task,r.waitFor],Object.getOwnPropertyDescriptor(o.prototype,"rotateKey"),o.prototype),o)
e.default=h})),define("vault/components/keymgmt/provider-edit",["exports","@glimmer/component","@ember/service","@ember/object","@glimmer/tracking","ember-concurrency","@ember/test-waiters"],(function(e,t,n,l,a,i,r){var o,s,u,d
function c(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function p(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let m=(o=class extends t.default{constructor(){super(...arguments),c(this,"router",s,this),c(this,"flashMessages",u,this),c(this,"modelValidations",d,this),"show"===this.args.mode&&this.fetchKeys.perform()}get isShowing(){return"show"===this.args.mode}get isCreating(){return"create"===this.args.mode}get viewingKeys(){return"keys"===this.args.tab}*saveTask(){const{model:e}=this.args
try{yield e.save(),this.router.transitionTo("vault.cluster.secrets.backend.show",e.id,{queryParams:{itemType:"provider"}})}catch(t){this.flashMessages.danger(t.errors.join(". "))}}*fetchKeys(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:1
try{yield this.args.model.fetchKeys(e)}catch(t){this.flashMessages.danger(t.errors.join(". "))}}async onSave(e){e.preventDefault()
const{isValid:t,state:n}=await this.args.model.validate()
t?(this.modelValidations=null,this.saveTask.perform()):this.modelValidations=n}async onDelete(){try{const{model:e,root:t}=this.args
await e.destroyRecord(),this.router.transitionTo(t.path,t.model,{queryParams:{tab:"provider"}})}catch(e){this.flashMessages.danger(e.errors.join(". "))}}async onDeleteKey(e){try{await e.destroyRecord(),this.args.model.keys.removeObject(e)}catch(t){this.flashMessages.danger(t.errors.join(". "))}}},s=p(o.prototype,"router",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=p(o.prototype,"flashMessages",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=p(o.prototype,"modelValidations",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p(o.prototype,"saveTask",[i.task,r.waitFor],Object.getOwnPropertyDescriptor(o.prototype,"saveTask"),o.prototype),p(o.prototype,"fetchKeys",[i.task,r.waitFor],Object.getOwnPropertyDescriptor(o.prototype,"fetchKeys"),o.prototype),p(o.prototype,"onSave",[l.action],Object.getOwnPropertyDescriptor(o.prototype,"onSave"),o.prototype),p(o.prototype,"onDelete",[l.action],Object.getOwnPropertyDescriptor(o.prototype,"onDelete"),o.prototype),p(o.prototype,"onDeleteKey",[l.action],Object.getOwnPropertyDescriptor(o.prototype,"onDeleteKey"),o.prototype),o)
e.default=m})),define("vault/components/kv-object-editor",["exports","core/components/kv-object-editor"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/layout-loading",["exports","core/components/layout-loading"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/license-banners",["exports","@glimmer/component","@ember/object","@glimmer/tracking","@ember/service","date-fns/isAfter","date-fns/differenceInDays","vault/lib/local-storage","core/utils/timestamp"],(function(e,t,n,l,a,i,r,o,s){var u,d,c,p
function m(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function f(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let h=(u=class extends t.default{constructor(){super(...arguments),m(this,"version",d,this),m(this,"warningDismissed",c,this),m(this,"expiredDismissed",p,this)
const e=o.default.getItem(this.dismissedBannerKey)
this.updateDismissType(e)}get currentVersion(){return this.version.version}get dismissedBannerKey(){return`dismiss-license-banner-${this.currentVersion}-${this.args.expiry}`}get licenseExpired(){return!!this.args.expiry&&(0,i.default)(s.default.now(),new Date(this.args.expiry))}get licenseExpiringInDays(){return this.args.expiry?(0,r.default)(new Date(this.args.expiry),s.default.now()):99}dismissBanner(e){o.default.cleanupStorage("dismiss-license-banner",this.dismissedBannerKey),o.default.setItem(this.dismissedBannerKey,e),this.updateDismissType(e)}updateDismissType(e){"warning"===e?this.warningDismissed=!0:"expired"===e&&(this.expiredDismissed=!0)}},d=f(u.prototype,"version",[a.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=f(u.prototype,"warningDismissed",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=f(u.prototype,"expiredDismissed",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f(u.prototype,"dismissBanner",[n.action],Object.getOwnPropertyDescriptor(u.prototype,"dismissBanner"),u.prototype),u)
e.default=h})),define("vault/components/license-info",["exports","@glimmer/component","vault/helpers/all-features"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0

;/**
   * @module LicenseInfo
   *
   * @example
   * ```js
   * <LicenseInfo
   *   @startTime="2020-03-12T23:20:50.52Z"
   *   @expirationTime="2021-05-12T23:20:50.52Z"
   *   @licenseId="some-license-id"
   *   @features={{array 'Namespaces' 'DR Replication'}}
   *   @autoloaded={{true}}
   *   @performanceStandbyCount=1
   * />
   *
   * @param {string} startTime - RFC3339 formatted timestamp of when the license became active
   * @param {string} expirationTime - RFC3339 formatted timestamp of when the license will expire
   * @param {string} licenseId - unique ID of the license
   * @param {Array<string>} features - Array of feature names active on license
   * @param {boolean} autoloaded - Whether the license is autoloaded
   * @param {number} performanceStandbyCount - Number of performance standbys active
   */
class l extends t.default{get featuresInfo(){const e=this.args.features.filter((e=>!(0,n.allFeatures)().includes(e)))
return[...(0,n.allFeatures)(),...e].map((e=>{const t=this.args.features.includes(e)
if(t&&"Performance Standby"===e){const n=this.args.performanceStandbyCount
return{name:e,active:!!n&&t,count:n}}return{name:e,active:t}}))}}e.default=l})),define("vault/components/link-status",["exports","@glimmer/component","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="version",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}get state(){return this.args.status?"connected"===this.args.status?this.args.status:this.args.status.split(" ",1).toString():null}get timestamp(){try{return"connected"!==this.state?this.args.status.split("since")[1].split(";")[0].trim():null}catch{return null}}get error(){const e=this.args.status
return e&&"connected"!==e?e.split("error:")[1]:null}},r=l.prototype,o="version",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/components/link-to-external",["exports","ember-engines/components/link-to-external"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/linked-block",["exports","core/components/linked-block"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/list-item",["exports","core/components/list-item"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/list-item/content",["exports","core/components/list-item/content"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/list-item/popup-menu",["exports","core/components/list-item/popup-menu"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/list-pagination",["exports","core/components/list-pagination"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/list-view",["exports","core/components/list-view"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/logo-edition",["exports","@ember/service","@ember/component"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=n.default.extend({tagName:"",version:(0,t.inject)()})
e.default=l})),define("vault/components/masked-input",["exports","core/components/masked-input"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/maybe-in-element",["exports","ember-maybe-in-element/components/maybe-in-element"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/menu-loader",["exports","core/components/menu-loader"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/message-error",["exports","core/components/message-error"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/mfa/method-form",["exports","@glimmer/component","@ember/object","@glimmer/tracking","@ember/service","ember-concurrency"],(function(e,t,n,l,a,i){var r,o,s,u,d
function c(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function p(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let m=(r=class extends t.default{constructor(){super(...arguments),c(this,"store",o,this),c(this,"flashMessages",s,this),c(this,"editValidations",u,this),c(this,"isEditModalActive",d,this)}*save(){try{yield this.args.model.save(),this.args.onSave()}catch(e){this.flashMessages.danger(e.errors?.join(". ")||e.message)}}async initSave(e){e.preventDefault()
const{isValid:t,state:n}=await this.args.model.validate()
t?this.isEditModalActive=!0:this.editValidations=n}cancel(){this.args.model.rollbackAttributes(),this.args.onClose()}},o=p(r.prototype,"store",[a.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=p(r.prototype,"flashMessages",[a.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=p(r.prototype,"editValidations",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=p(r.prototype,"isEditModalActive",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),p(r.prototype,"save",[i.task],Object.getOwnPropertyDescriptor(r.prototype,"save"),r.prototype),p(r.prototype,"initSave",[n.action],Object.getOwnPropertyDescriptor(r.prototype,"initSave"),r.prototype),p(r.prototype,"cancel",[n.action],Object.getOwnPropertyDescriptor(r.prototype,"cancel"),r.prototype),r)
e.default=m})),define("vault/components/mfa/mfa-form",["exports","@glimmer/component","@ember/service","@glimmer/tracking","@ember/object","ember-concurrency","vault/helpers/number-to-word"],(function(e,t,n,l,a,i,r){var o,s,u,d,c
function p(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function m(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=e.TOTP_VALIDATION_ERROR=void 0
const f="The passcode failed to validate. If you entered the correct passcode, contact your administrator."
e.TOTP_VALIDATION_ERROR=f
let h=(o=class extends t.default{constructor(){super(...arguments),p(this,"auth",s,this),p(this,"countdown",u,this),p(this,"error",d,this),p(this,"codeDelayMessage",c,this)
this.constraints.filter((e=>e.methods.length>1||e.methods.findBy("uses_passcode"))).length||this.validate.perform()}get constraints(){return this.args.authData.mfa_requirement.mfa_constraints}get multiConstraint(){return this.constraints.length>1}get singleConstraintMultiMethod(){return!this.isMultiConstraint&&this.constraints[0].methods.length>1}get singlePasscode(){return!this.isMultiConstraint&&1===this.constraints[0].methods.length&&this.constraints[0].methods[0].uses_passcode}get description(){let e="Multi-factor authentication is enabled for your account."
if(this.singlePasscode&&(e+=" Enter your authentication code to log in."),this.singleConstraintMultiMethod&&(e+=" Select the MFA method you wish to use."),this.multiConstraint){const t=this.constraints.length
e+=` ${(0,r.numberToWord)(t,!0)} methods are required for successful authentication.`}return e}*validate(){try{this.error=null
const e=yield this.auth.totpValidate({clusterId:this.args.clusterId,...this.args.authData})
this.args.onSuccess(e)}catch(e){const t=e.errors||[],n=t.find((e=>e.includes("code already used"))),l=t.find((e=>e.includes("maximum TOTP validation attempts"))),a=n||l
if(a){const e=n?"This code has already been used":"Maximum validation attempts exceeded"
this.codeDelayMessage=`${e}. Please wait until a new code is available.`,this.newCodeDelay.perform(a)}else this.singlePasscode?this.error=f:this.args.onError(this.auth.handleError(e))}}*newCodeDelay(e){for(this.countdown=parseInt(e.match(/(\d\w seconds)/)[0].split(" ")[0]);this.countdown;)yield(0,i.timeout)(1e3),this.countdown--}onSelect(e,t){(0,a.set)(e,"selectedId",t),(0,a.set)(e,"selectedMethod",e.methods.findBy("id",t))}submit(e){e.preventDefault(),this.validate.perform()}},s=m(o.prototype,"auth",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=m(o.prototype,"countdown",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=m(o.prototype,"error",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=m(o.prototype,"codeDelayMessage",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m(o.prototype,"validate",[i.task],Object.getOwnPropertyDescriptor(o.prototype,"validate"),o.prototype),m(o.prototype,"newCodeDelay",[i.task],Object.getOwnPropertyDescriptor(o.prototype,"newCodeDelay"),o.prototype),m(o.prototype,"onSelect",[a.action],Object.getOwnPropertyDescriptor(o.prototype,"onSelect"),o.prototype),m(o.prototype,"submit",[a.action],Object.getOwnPropertyDescriptor(o.prototype,"submit"),o.prototype),o)
e.default=h})),define("vault/components/mfa/mfa-login-enforcement-form",["exports","@glimmer/component","@glimmer/tracking","@ember/object","@ember/array","@ember/service","ember-concurrency","core/utils/search-select-has-many"],(function(e,t,n,l,a,i,r,o){var s,u,d,c,p,m,f,h,b,y
function v(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function g(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function w(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let k=(s=class extends t.default{constructor(){super(...arguments),v(this,"store",u,this),v(this,"flashMessages",d,this),g(this,"targetTypes",[{label:"Authentication mount",type:"accessor",key:"auth_method_accessors"},{label:"Authentication method",type:"method",key:"auth_method_types"},{label:"Group",type:"identity/group",key:"identity_groups"},{label:"Entity",type:"identity/entity",key:"identity_entities"}]),g(this,"searchSelectOptions",null),v(this,"name",c,this),v(this,"targets",p,this),v(this,"selectedTargetType",m,this),v(this,"selectedTargetValue",f,this),v(this,"searchSelect",h,this),v(this,"authMethods",b,this),v(this,"modelErrors",y,this),this.flattenTargets(),this.resetTargetState(),this.fetchAuthMethods()}async flattenTargets(){for(const{label:e,key:t}of this.targetTypes){const n=(await this.args.model[t]).map((n=>({label:e,key:t,value:n})))
this.targets.addObjects(n)}}async resetTargetState(){this.selectedTargetValue=null
const e=this.searchSelectOptions||{}
if(!this.searchSelectOptions){const n=["identity/group","identity/entity"]
for(const l of n)try{e[l]=(await this.store.query(l,{})).toArray()}catch(t){e[l]=[]}this.searchSelectOptions=e}this.selectedTargetType.includes("identity")&&(this.searchSelect={selected:[],options:[...e[this.selectedTargetType]]})}async fetchAuthMethods(){const e=(await this.store.findAll("auth-method")).toArray()
this.authMethods=e.mapBy("type")}get selectedTarget(){return this.targetTypes.findBy("type",this.selectedTargetType)}get errors(){return this.args.modelErrors||this.modelErrors}updateModelForKey(e){const t=this.targets.filter((t=>t.key===e)).map((e=>e.value))
this.args.model[e]=t}*save(){this.modelErrors={}
const{isValid:e,state:t}=this.args.model.validate()
if(e)try{yield this.args.model.save(),this.args.onSave()}catch(n){const e=n.errors?n.errors.join(". "):n.message
this.flashMessages.danger(e)}else this.modelErrors=t}async onMethodChange(e){const t=await this.args.model.mfa_methods;(0,o.default)(e,t,this.store,"mfa-method")}onTargetSelect(e){this.selectedTargetType=e,this.resetTargetState()}setTargetValue(e){const{type:t}=this.selectedTarget
t.includes("identity")?this.selectedTargetValue=this.store.peekRecord(t,e[0]):this.selectedTargetValue=e}addTarget(){const{label:e,key:t}=this.selectedTarget,n=this.selectedTargetValue
this.targets.addObject({label:e,value:n,key:t}),this.updateModelForKey(t),this.selectedTargetValue=null,this.resetTargetState()}removeTarget(e){this.targets.removeObject(e),this.updateModelForKey(e.key)}cancel(){this.args.model.rollbackAttributes(),this.args.onClose()}},u=w(s.prototype,"store",[i.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=w(s.prototype,"flashMessages",[i.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=w(s.prototype,"name",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=w(s.prototype,"targets",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return(0,a.A)([])}}),m=w(s.prototype,"selectedTargetType",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return"accessor"}}),f=w(s.prototype,"selectedTargetValue",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),h=w(s.prototype,"searchSelect",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return{options:[],selected:[]}}}),b=w(s.prototype,"authMethods",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return(0,a.A)([])}}),y=w(s.prototype,"modelErrors",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w(s.prototype,"save",[r.task],Object.getOwnPropertyDescriptor(s.prototype,"save"),s.prototype),w(s.prototype,"onMethodChange",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"onMethodChange"),s.prototype),w(s.prototype,"onTargetSelect",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"onTargetSelect"),s.prototype),w(s.prototype,"setTargetValue",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"setTargetValue"),s.prototype),w(s.prototype,"addTarget",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"addTarget"),s.prototype),w(s.prototype,"removeTarget",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"removeTarget"),s.prototype),w(s.prototype,"cancel",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"cancel"),s.prototype),s)
e.default=k})),define("vault/components/mfa/mfa-login-enforcement-header",["exports","@glimmer/component","@glimmer/tracking","@ember/service","@ember/object"],(function(e,t,n,l,a){var i,r,o
function s(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function u(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let d=(i=class extends t.default{constructor(){super(...arguments),s(this,"store",r,this),s(this,"enforcements",o,this),this.args.isInline&&this.fetchEnforcements()}async fetchEnforcements(){try{this._enforcements=(await this.store.query("mfa-login-enforcement",{})).toArray(),this.enforcements=[...this._enforcements]}catch(e){this.enforcements=[]}}onEnforcementSelect(e){let[t]=e
this.args.onEnforcementSelect(this._enforcements.findBy("name",t))}},r=u(i.prototype,"store",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),o=u(i.prototype,"enforcements",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return[]}}),u(i.prototype,"onEnforcementSelect",[a.action],Object.getOwnPropertyDescriptor(i.prototype,"onEnforcementSelect"),i.prototype),i)
e.default=d})),define("vault/components/mfa/mfa-setup-step-one",["exports","@glimmer/component","@ember/service","@ember/object","@glimmer/tracking"],(function(e,t,n,l,a){var i,r,o,s,u
function d(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function c(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let p=(i=class extends t.default{constructor(){super(...arguments),d(this,"store",r,this),d(this,"error",o,this),d(this,"warning",s,this),d(this,"qrCode",u,this)}redirectPreviousPage(){this.args.restartFlow(),window.history.back()}async verifyUUID(e){e.preventDefault()
const t=await this.postCurrentTokenGenerate()
"stop_progress"===t?this.args.isUUIDVerified(!1):"reset_method"===t?this.args.showWarning(this.warning):this.args.isUUIDVerified(!0)}async postCurrentTokenGenerate(){this.error="",this.warning=""
const e=this.store.adapterFor("mfa-setup")
let t
try{t=await e.currentTokenGenerate({method_id:this.UUID}),this.args.saveUUIDandQrCode(this.UUID,t.data?.url)
const n=t.warnings||[]
if(n.length>0){this.UUID=""
return n.find((e=>e.includes("Entity already has a secret for MFA method")))?(this.warning="A QR code has already been generated, scanned, and MFA set up for this entity. If a new code is required, contact your administrator.","reset_method"):(this.warning=n,"reset_method")}}catch(n){return this.UUID="",this.error=n.errors,"stop_progress"}return t}},r=c(i.prototype,"store",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),o=c(i.prototype,"error",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),s=c(i.prototype,"warning",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),u=c(i.prototype,"qrCode",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),c(i.prototype,"redirectPreviousPage",[l.action],Object.getOwnPropertyDescriptor(i.prototype,"redirectPreviousPage"),i.prototype),c(i.prototype,"verifyUUID",[l.action],Object.getOwnPropertyDescriptor(i.prototype,"verifyUUID"),i.prototype),i)
e.default=p})),define("vault/components/mfa/mfa-setup-step-two",["exports","@glimmer/component","@ember/service","@ember/object"],(function(e,t,n,l){var a,i
function r(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let o=(a=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=i)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}redirectPreviousPage(){this.args.restartFlow(),window.history.back()}async restartSetup(){this.error=null
const e=this.store.adapterFor("mfa-setup")
try{await e.adminDestroy({entity_id:this.args.entityId,method_id:this.args.uuid})}catch(t){return this.error=t.errors,"stop_progress"}this.args.restartFlow()}},i=r(a.prototype,"store",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),r(a.prototype,"redirectPreviousPage",[l.action],Object.getOwnPropertyDescriptor(a.prototype,"redirectPreviousPage"),a.prototype),r(a.prototype,"restartSetup",[l.action],Object.getOwnPropertyDescriptor(a.prototype,"restartSetup"),a.prototype),a)
e.default=o})),define("vault/components/modal-dialog",["exports","ember-modal-dialog/components/modal-dialog"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/modal-form/oidc-assignment-template",["exports","@ember/component","@ember/template-factory","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking"],(function(e,t,n,l,a,i,r){var o,s,u
function d(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function c(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const p=(0,n.createTemplateFactory)({id:"KQxxdMLY",block:'[[[8,[39,0],null,[["@onSave","@model","@onCancel"],[[30,0,["onSave"]],[30,0,["assignment"]],[30,1]]],null]],["@onCancel"],false,["oidc/assignment-form"]]',moduleName:"vault/components/modal-form/oidc-assignment-template.hbs",isStrictMode:!1})
let m=(o=class extends l.default{constructor(){super(...arguments),d(this,"store",s,this),d(this,"assignment",u,this),this.assignment=this.store.createRecord("oidc/assignment",{name:this.args.nameInput})}onSave(e){this.args.onSave(e),this.assignment=null}},s=c(o.prototype,"store",[i.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=c(o.prototype,"assignment",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),c(o.prototype,"onSave",[a.action],Object.getOwnPropertyDescriptor(o.prototype,"onSave"),o.prototype),o)
e.default=m,(0,t.setComponentTemplate)(p,m)})),define("vault/components/modal-form/policy-template",["exports","@ember/component","@ember/template-factory","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking"],(function(e,t,n,l,a,i,r){var o,s,u,d,c
function p(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function m(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const f=(0,n.createTemplateFactory)({id:"w5+BTQjm",block:'[[[41,[30,0,["policy","policyType"]],[[[1,"  "],[10,"nav"],[14,0,"tabs has-bottom-margin-l"],[12],[1,"\\n    "],[10,"ul"],[12],[1,"\\n      "],[10,"li"],[15,0,[52,[51,[30,0,["showExamplePolicy"]]],"active"]],[12],[1,"\\n        "],[11,"button"],[24,3,"form"],[16,0,[29,["link link-plain tab has-text-weight-semibold ",[52,[51,[30,0,["showExamplePolicy"]]]," is-active"]]]],[24,4,"button"],[4,[38,2],["click",[28,[37,3],[[28,[37,4],[[30,0,["showExamplePolicy"]]],null],false],null]],null],[12],[1,"\\n          Your Policy\\n        "],[13],[1,"\\n      "],[13],[1,"\\n      "],[10,"li"],[15,0,[52,[30,0,["showExamplePolicy"]],"active"]],[12],[1,"\\n        "],[11,"button"],[24,3,"form"],[16,0,[29,["link link-plain tab has-text-weight-semibold ",[52,[30,0,["showExamplePolicy"]]," is-active"]]]],[24,4,"button"],[4,[38,2],["click",[28,[37,3],[[28,[37,4],[[30,0,["showExamplePolicy"]]],null],true],null]],null],[12],[1,"\\n          Example Policy\\n        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]],null],[41,[30,0,["showExamplePolicy"]],[[[1,"  "],[8,[39,5],null,[["@policyType"],[[30,0,["policy","policyType"]]]],null],[1,"\\n"]],[]],[[[1,"  "],[8,[39,6],null,[["@name","@label","@options","@isFullwidth","@selectedValue","@onChange","@noDefault"],["policyType","Type",[30,0,["policyOptions"]],true,[30,0,["policy","policyType"]],[30,0,["setPolicyType"]],true]],null],[1,"\\n"],[41,[30,0,["policy","policyType"]],[[[1,"    "],[8,[39,7],null,[["@onSave","@model","@onCancel"],[[30,0,["onSave"]],[30,0,["policy"]],[30,1]]],null],[1,"\\n"]],[]],[[[1,"    "],[8,[39,8],null,[["@title","@message"],["No policy type selected","Select a policy type to continue creating."]],null],[1,"\\n"]],[]]]],[]]]],["@onCancel"],false,["if","unless","on","fn","mut","policy-example","select","policy-form","empty-state"]]',moduleName:"vault/components/modal-form/policy-template.hbs",isStrictMode:!1})
let h=(o=class extends l.default{constructor(){super(...arguments),p(this,"store",s,this),p(this,"version",u,this),p(this,"policy",d,this),p(this,"showExamplePolicy",c,this)}get policyOptions(){return[{label:"ACL Policy",value:"acl",isDisabled:!1},{label:"Role Governing Policy",value:"rgp",isDisabled:!this.version.hasSentinel}]}setPolicyType(e){this.policy&&this.policy.unloadRecord(),this.policy=this.store.createRecord(`policy/${e}`,{name:this.args.nameInput})}onSave(e){this.args.onSave(e),this.policy=null}},s=m(o.prototype,"store",[i.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=m(o.prototype,"version",[i.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=m(o.prototype,"policy",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),c=m(o.prototype,"showExamplePolicy",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),m(o.prototype,"setPolicyType",[a.action],Object.getOwnPropertyDescriptor(o.prototype,"setPolicyType"),o.prototype),m(o.prototype,"onSave",[a.action],Object.getOwnPropertyDescriptor(o.prototype,"onSave"),o.prototype),o)
e.default=h,(0,t.setComponentTemplate)(f,h)})),define("vault/components/modal",["exports","core/components/modal"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/mount-accessor-select",["exports","@glimmer/component","@ember/service","ember-concurrency","@ember/object"],(function(e,t,n,l,a){var i,r
function o(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let s=(i=class extends t.default{get filterToken(){return this.args.filterToken||!1}get noDefault(){return this.args.noDefault||!1}constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=r)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0}),this.authMethods.perform()}*authMethods(){const e=yield this.store.findAll("auth-method")
if(!this.args.value&&!this.args.noDefault){const t=e.get("firstObject.accessor")
this.args.onChange(t)}return e}change(e){this.args.onChange(e.target.value)}},r=o(i.prototype,"store",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),o(i.prototype,"authMethods",[l.task],Object.getOwnPropertyDescriptor(i.prototype,"authMethods"),i.prototype),o(i.prototype,"change",[a.action],Object.getOwnPropertyDescriptor(i.prototype,"change"),i.prototype),i)
e.default=s})),define("vault/components/mount-backend-form",["exports","@glimmer/component","@glimmer/tracking","@ember/service","@ember/object","ember-concurrency","@ember/test-waiters","vault/helpers/supported-secret-backends","vault/helpers/mountable-auth-methods","vault/helpers/mountable-secret-engines"],(function(e,t,n,l,a,i,r,o,s,u){var d,c,p,m,f,h
function b(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function y(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let v=(d=class extends t.default{constructor(){super(...arguments),b(this,"store",c,this),b(this,"flashMessages",p,this),b(this,"modelValidations",m,this),b(this,"invalidFormAlert",f,this),b(this,"errorMessage",h,this)}willDestroy(){this.store&&!this.store.isDestroying&&this.args?.mountModel?.isNew&&this.args.mountModel.unloadRecord(),super.willDestroy(...arguments)}checkPathChange(e){if(!e)return
const t=this.args.mountModel,n=t.path,l="secret"===this.args.mountType?(0,o.supportedSecretBackends)():(0,s.methods)().map((e=>e.type))
n&&!l.includes(n)||(t.path=e)}typeChangeSideEffect(e){"secret"!==!this.args.mountType&&(this.args.mountModel.config.maxLeaseTtl="pki"===e?"3650d":0)}checkModelValidity(e){const{isValid:t,state:n,invalidFormMessage:l}=e.validate()
return this.modelValidations=n,this.invalidFormAlert=l,t}checkModelWarnings(){const{state:e}=this.args.mountModel.validate()
for(const t in e)e[t].errors=[]
this.modelValidations=e,this.invalidFormAlert=null}async showWarningsForKvv2(){try{(await this.store.findRecord("capabilities",`${this.args.mountModel.path}/config`))?.canUpdate||(this.flashMessages.warning("You do not have access to the config endpoint. The secret engine was mounted, but the configuration settings were not saved."),[this.args.mountModel.maxVersions,this.args.mountModel.casRequired,this.args.mountModel.deleteVersionAfter]=[0,!1,0])}catch(e){this.flashMessages.warning("You may not have access to the config endpoint. The secret engine was mounted, but the configuration settings may not be saved.")}}*mountBackend(e){e.preventDefault()
const t=this.args.mountModel,{type:n,path:l}=t
if(!this.checkModelValidity(t))return
const a=Object.keys(t.changedAttributes()),i=a.includes("casRequired")||a.includes("deleteVersionAfter")||a.includes("maxVersions")
try{yield t.save()}catch(o){if(403===o.httpStatus)return void this.flashMessages.danger("You do not have access to the sys/mounts endpoint. The secret engine was not mounted.")
if(o.errors){const e=o.errors.map((e=>"object"==typeof e?e.title||e.message||JSON.stringify(e):e))
this.errorMessage=e}else o.message?this.errorMessage=o.message:this.errorMessage="An error occurred, check the vault logs."
return}t.isV2KV&&i&&(yield this.showWarningsForKvv2()),this.flashMessages.success(`Successfully mounted the ${n} ${"secret"===this.args.mountType?"secrets engine":"auth method"} at ${l}.`)
const r=(0,u.isAddonEngine)(t.engineType,t.version)
yield this.args.onMountSuccess(n,l,r)}onKeyUp(e,t){this.args.mountModel[e]=t,this.checkModelWarnings()}setMountType(e){this.args.mountModel.type=e,this.typeChangeSideEffect(e),this.checkPathChange(e)}},c=y(d.prototype,"store",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=y(d.prototype,"flashMessages",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=y(d.prototype,"modelValidations",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),f=y(d.prototype,"invalidFormAlert",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),h=y(d.prototype,"errorMessage",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),y(d.prototype,"mountBackend",[i.task,r.waitFor],Object.getOwnPropertyDescriptor(d.prototype,"mountBackend"),d.prototype),y(d.prototype,"onKeyUp",[a.action],Object.getOwnPropertyDescriptor(d.prototype,"onKeyUp"),d.prototype),y(d.prototype,"setMountType",[a.action],Object.getOwnPropertyDescriptor(d.prototype,"setMountType"),d.prototype),d)
e.default=v})),define("vault/components/mount-backend/type-form",["exports","@ember/component","@ember/template-factory","@glimmer/component","@ember/service","vault/helpers/mountable-auth-methods","vault/helpers/mountable-secret-engines","@glimmer/tracking"],(function(e,t,n,l,a,i,r,o){var s,u,d
function c(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function p(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const m=(0,n.createTemplateFactory)({id:"OOUDh/Hm",block:'[[[42,[28,[37,1],[[28,[37,1],[[28,[37,2],["generic","cloud","infra"],null]],null]],null],null,[[[1,"  "],[10,"h3"],[14,0,"title box-radio-header"],[12],[1,"\\n    "],[1,[28,[35,3],[[30,1]],null]],[1,"\\n  "],[13],[1,"\\n  "],[10,0],[14,0,"box-radio-container"],[12],[1,"\\n"],[42,[28,[37,1],[[28,[37,1],[[28,[37,4],["category",[30,1],[30,0,["mountTypes"]]],null]],null]],null],null,[[[1,"      "],[8,[39,5],null,[["@displayName","@type","@glyph","@groupValue","@groupName","@onRadioChange","@disabled","@tooltipMessage"],[[30,2,["displayName"]],[30,2,["type"]],[28,[37,6],[[30,2,["glyph"]],[30,2,["type"]]],null],[30,0,["selection"]],"mount-type",[28,[37,7],[[30,0,["selection"]]],null],[52,[30,2,["requiredFeature"]],[28,[37,9],[[28,[37,10],[[30,2,["requiredFeature"]]],null]],null],false],[52,[28,[37,6],[[28,[37,11],[[30,2,["type"]],"transform"],null],[28,[37,11],[[30,2,["type"]],"kmip"],null],[28,[37,11],[[30,2,["type"]],"keymgmt"],null]],null],[28,[37,12],[[30,2,["displayName"]]," is part of the Advanced Data Protection module, which is not included in your enterprise license."],null],"This secret engine is not included in your license."]]],null],[1,"\\n"]],[2]],null],[1,"  "],[13],[1,"\\n"]],[1]],null],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n  "],[11,"button"],[24,0,"button is-primary"],[16,"disabled",[28,[37,9],[[30,0,["selection"]]],null]],[24,4,"button"],[4,[38,13],["click",[28,[37,14],[[30,3],[30,0,["selection"]]],null]],null],[12],[1,"\\n    Next\\n  "],[13],[1,"\\n"],[13]],["category","type","@setMountType"],false,["each","-track-array","array","capitalize","filter-by","box-radio","or","mut","if","not","has-feature","eq","concat","on","fn"]]',moduleName:"vault/components/mount-backend/type-form.hbs",isStrictMode:!1})
let f=(s=class extends l.default{constructor(){super(...arguments),c(this,"version",u,this),c(this,"selection",d,this)}get secretEngines(){return this.version.isEnterprise?(0,r.allEngines)():(0,r.mountableEngines)()}get authMethods(){return this.version.isEnterprise?(0,i.allMethods)():(0,i.methods)()}get mountTypes(){return"secret"===this.args.mountType?this.secretEngines:this.authMethods}},u=p(s.prototype,"version",[a.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=p(s.prototype,"selection",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s)
e.default=f,(0,t.setComponentTemplate)(m,f)})),define("vault/components/namespace-link",["exports","@ember/service","@ember/object/computed","@ember/component","@ember/object"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=l.default.extend({namespaceService:(0,t.inject)("namespace"),currentNamespace:(0,n.alias)("namespaceService.path"),tagName:"",targetNamespace:null,showLastSegment:!1,unparsed:!1,normalizedNamespace:(0,a.computed)("targetNamespace","unparsed",(function(){const e=this.targetNamespace||""
return this.unparsed?e:e.replace(/\.+/g,"/").replace(/☃/g,".")})),namespaceDisplay:(0,a.computed)("normalizedNamespace","showLastSegment",(function(){const e=this.normalizedNamespace
if(!e)return"root"
const t=this.showLastSegment,n=e?.split("/")
return t?n[n.length-1]:e})),isCurrentNamespace:(0,a.computed)("targetNamespace","currentNamespace",(function(){return this.currentNamespace===this.targetNamespace})),get namespaceLink(){const e=window.location.protocol+"//"+window.location.hostname+(window.location.port?":"+window.location.port:"")
return this.normalizedNamespace?`${e}/ui/vault/dashboard?namespace=${encodeURIComponent(this.normalizedNamespace)}`:`${e}/ui/vault/dashboard`}})
e.default=i})),define("vault/components/namespace-picker",["exports","@ember/service","@ember/object/computed","@ember/component","@ember/object","ember-concurrency","vault/lib/path-to-tree","core/utils/key-utils"],(function(e,t,n,l,a,i,r,o){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var s=l.default.extend({tagName:"",namespaceService:(0,t.inject)("namespace"),auth:(0,t.inject)(),store:(0,t.inject)(),namespace:null,listCapability:null,canList:!1,init(){this._super(...arguments),this.namespaceService?.findNamespacesForUser.perform()},didReceiveAttrs(){this._super(...arguments)
const e=this.namespace,t=this.oldNamespace
t&&e===t||(this.setForAnimation.perform(),this.fetchListCapability.perform()),this.set("oldNamespace",e)},fetchListCapability:(0,i.task)((function*(){try{const e=yield this.store.findRecord("capabilities","sys/namespaces/")
this.set("listCapability",e),this.set("canList",!0)}catch(e){this.set("canList",!1)}})),setForAnimation:(0,i.task)((function*(){const e=this.menuLeaves,t=this.lastMenuLeaves
if(!t)return this.set("lastMenuLeaves",e),void(yield(0,i.timeout)(0))
const n=e.length>t.length,l=(n?e:t).get("lastObject")
if(this.set("isAdding",n),this.set("changedLeaf",l),n)return this.set("lastMenuLeaves",e),void(yield(0,i.timeout)(0))
yield(0,i.timeout)(250),this.set("lastMenuLeaves",e)})).drop(),isAnimating:(0,n.alias)("setForAnimation.isRunning"),namespacePath:(0,n.alias)("namespaceService.path"),accessibleNamespaces:(0,n.alias)("namespaceService.accessibleNamespaces"),inRootNamespace:(0,n.alias)("namespaceService.inRootNamespace"),namespaceTree:(0,a.computed)("accessibleNamespaces",(function(){const e=this.accessibleNamespaces
return e?(0,r.default)(e):[]})),maybeAddRoot(e){return""===this.auth.authData.userRootNamespace&&e.unshift(""),e.uniq()},pathToLeaf:e=>e.replace(/\/$/,"").replace(/\.+/g,"☃").replace(/\/+/g,"."),menuLeaves:(0,a.computed)("namespacePath","namespaceTree","pathToLeaf",(function(){let e=this.namespacePath
e=(e||"").replace(/^\//,"")
let t=(0,o.ancestorKeysForKey)(e)
return t.push(e),t=this.maybeAddRoot(t),t=t.map(this.pathToLeaf),t})),rootLeaves:(0,a.computed)("namespaceTree",(function(){const e=this.namespaceTree
return Object.keys(e)})),currentLeaf:(0,n.alias)("lastMenuLeaves.lastObject"),canAccessMultipleNamespaces:(0,n.gt)("accessibleNamespaces.length",1),isUserRootNamespace:(0,a.computed)("auth.authData.userRootNamespace","namespacePath",(function(){return this.auth.authData.userRootNamespace===this.namespacePath})),namespaceDisplay:(0,a.computed)("namespacePath","accessibleNamespaces","accessibleNamespaces.[]",(function(){const e=this.namespacePath
if(!e)return"root"
const t=e?.split("/")
return t[t.length-1]})),actions:{refreshNamespaceList(){this.namespaceService.findNamespacesForUser.perform()}}})
e.default=s})),define("vault/components/namespace-reminder",["exports","core/components/namespace-reminder"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/navigate-input",["exports","core/components/navigate-input"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/navigation-narrator",["exports","ember-a11y-refocus/components/navigation-narrator"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/not-found",["exports","@ember/service","@ember/object/computed","@ember/component"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=l.default.extend({model:null,tagName:"",router:(0,t.inject)(),path:(0,n.alias)("router.currentURL")})
e.default=a})),define("vault/components/object-list-input",["exports","core/components/object-list-input"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/oidc-consent-block",["exports","ember","@glimmer/component","@ember/object","@glimmer/tracking"],(function(e,t,n,l,a){var i,r
function o(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const s=["code","state"]
let u=(i=class extends n.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="didCancel",l=this,(n=r)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}get win(){return this.window||window}buildUrl(e,t){try{const n=new URL(e)
return Object.keys(t).forEach((e=>{t[e]&&s.includes(e)&&n.searchParams.append(e,t[e])})),n}catch(n){throw console.debug("DEBUG: parsing url failed for",e),new Error("Invalid URL")}}handleSubmit(e){e.preventDefault()
const{redirect:n,...l}=this.args,a=this.buildUrl(n,l)
t.default.testing?this.args.testRedirect(a.toString()):this.win.location.replace(a)}handleCancel(e){e.preventDefault(),this.didCancel=!0}},r=o(i.prototype,"didCancel",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),o(i.prototype,"handleSubmit",[l.action],Object.getOwnPropertyDescriptor(i.prototype,"handleSubmit"),i.prototype),o(i.prototype,"handleCancel",[l.action],Object.getOwnPropertyDescriptor(i.prototype,"handleCancel"),i.prototype),i)
e.default=u})),define("vault/components/oidc/assignment-form",["exports","@glimmer/component","@ember/object","@ember/service","ember-concurrency","@glimmer/tracking"],(function(e,t,n,l,a,i){var r,o,s,u,d
function c(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function p(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let m=(r=class extends t.default{constructor(){super(...arguments),c(this,"store",o,this),c(this,"flashMessages",s,this),c(this,"modelValidations",u,this),c(this,"errorBanner",d,this)}*save(e){e.preventDefault()
try{const{isValid:e,state:t}=this.args.model.validate()
if(this.modelValidations=e?null:t,e){const{isNew:e,name:t}=this.args.model
yield this.args.model.save(),this.flashMessages.success(`Successfully ${e?"created":"updated"} the assignment ${t}.`),this.args.onSave(this.args.model)}}catch(t){const e=t.errors?t.errors.join(". "):t.message
this.errorBanner=e}}cancel(){const e=this.args.model.isNew?"unloadRecord":"rollbackAttributes"
this.args.model[e](),this.args.onCancel()}handleOperation(e){let{target:t}=e
this.args.model.name=t.value}onEntitiesSelect(e){this.args.model.entityIds=e}onGroupsSelect(e){this.args.model.groupIds=e}},o=p(r.prototype,"store",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=p(r.prototype,"flashMessages",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=p(r.prototype,"modelValidations",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=p(r.prototype,"errorBanner",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p(r.prototype,"save",[a.task],Object.getOwnPropertyDescriptor(r.prototype,"save"),r.prototype),p(r.prototype,"cancel",[n.action],Object.getOwnPropertyDescriptor(r.prototype,"cancel"),r.prototype),p(r.prototype,"handleOperation",[n.action],Object.getOwnPropertyDescriptor(r.prototype,"handleOperation"),r.prototype),p(r.prototype,"onEntitiesSelect",[n.action],Object.getOwnPropertyDescriptor(r.prototype,"onEntitiesSelect"),r.prototype),p(r.prototype,"onGroupsSelect",[n.action],Object.getOwnPropertyDescriptor(r.prototype,"onGroupsSelect"),r.prototype),r)
e.default=m})),define("vault/components/oidc/client-form",["exports","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","ember-concurrency"],(function(e,t,n,l,a,i){var r,o,s,u,d,c
function p(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function m(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let f=(r=class extends t.default{constructor(){super(...arguments),p(this,"flashMessages",o,this),p(this,"modelValidations",s,this),p(this,"errorBanner",u,this),p(this,"invalidFormAlert",d,this),p(this,"radioCardGroupValue",c,this)}get modelAssignments(){const{assignments:e}=this.args.model
return e.includes("allow_all")&&1===e.length?[]:e}handleAssignmentSelection(e){Array.isArray(e)?this.args.model.assignments=e:(this.radioCardGroupValue=e,this.args.model.assignments=[])}cancel(){const e=this.args.model.isNew?"unloadRecord":"rollbackAttributes"
this.args.model[e](),this.args.onCancel()}*save(e){e.preventDefault()
try{const{isValid:e,state:t,invalidFormMessage:n}=this.args.model.validate()
if(this.modelValidations=e?null:t,this.invalidFormAlert=n,e){"allow_all"===this.radioCardGroupValue&&(this.args.model.assignments=["allow_all"])
const{idTokenTtl:e,accessTokenTtl:t}=this.args.model
0===Number(e)&&(this.args.model.idTokenTtl="24h"),0===Number(t)&&(this.args.model.accessTokenTtl="24h")
const{isNew:n,name:l}=this.args.model
yield this.args.model.save(),this.flashMessages.success(`Successfully ${n?"created":"updated"} the application ${l}.`),this.args.onSave()}}catch(t){const e=t.errors?t.errors.join(". "):t.message
this.errorBanner=e,this.invalidFormAlert="There was an error submitting this form."}}},o=m(r.prototype,"flashMessages",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=m(r.prototype,"modelValidations",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=m(r.prototype,"errorBanner",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=m(r.prototype,"invalidFormAlert",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=m(r.prototype,"radioCardGroupValue",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!this.args.model.assignments||this.args.model.assignments.includes("allow_all")?"allow_all":"limited"}}),m(r.prototype,"handleAssignmentSelection",[n.action],Object.getOwnPropertyDescriptor(r.prototype,"handleAssignmentSelection"),r.prototype),m(r.prototype,"cancel",[n.action],Object.getOwnPropertyDescriptor(r.prototype,"cancel"),r.prototype),m(r.prototype,"save",[i.task],Object.getOwnPropertyDescriptor(r.prototype,"save"),r.prototype),r)
e.default=f})),define("vault/components/oidc/key-form",["exports","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","ember-concurrency"],(function(e,t,n,l,a,i){var r,o,s,u,d,c,p
function m(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function f(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let h=(r=class extends t.default{constructor(){super(...arguments),m(this,"store",o,this),m(this,"flashMessages",s,this),m(this,"errorBanner",u,this),m(this,"invalidFormAlert",d,this),m(this,"modelValidations",c,this),m(this,"radioCardGroupValue",p,this)}get filterDropdownOptions(){return{paramKey:"key",filterFor:[this.args.model.name]}}handleClientSelection(e){Array.isArray(e)?this.args.model.allowedClientIds=e.map((e=>e.clientId)):(this.radioCardGroupValue=e,this.args.model.allowedClientIds=[])}cancel(){const e=this.args.model.isNew?"unloadRecord":"rollbackAttributes"
this.args.model[e](),this.args.onCancel()}*save(e){e.preventDefault()
try{const{isValid:e,state:t,invalidFormMessage:n}=this.args.model.validate()
if(this.modelValidations=e?null:t,this.invalidFormAlert=n,e){const{isNew:e,name:t}=this.args.model
"allow_all"===this.radioCardGroupValue&&(this.args.model.allowedClientIds=["*"])
const{rotationPeriod:n,verificationTtl:l}=this.args.model
0===Number(n)&&(this.args.model.rotationPeriod="24h"),0===Number(l)&&(this.args.model.verificationTtl="24h"),yield this.args.model.save(),this.flashMessages.success(`Successfully ${e?"created":"updated"} the key\n          ${t}.`),this.args.onSave()}}catch(t){const e=t.errors?t.errors.join(". "):t.message
this.errorBanner=e,this.invalidFormAlert="There was an error submitting this form."}}},o=f(r.prototype,"store",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=f(r.prototype,"flashMessages",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=f(r.prototype,"errorBanner",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=f(r.prototype,"invalidFormAlert",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=f(r.prototype,"modelValidations",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=f(r.prototype,"radioCardGroupValue",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!this.args.model.allowedClientIds||this.args.model.allowedClientIds.includes("*")?"allow_all":"limited"}}),f(r.prototype,"handleClientSelection",[n.action],Object.getOwnPropertyDescriptor(r.prototype,"handleClientSelection"),r.prototype),f(r.prototype,"cancel",[n.action],Object.getOwnPropertyDescriptor(r.prototype,"cancel"),r.prototype),f(r.prototype,"save",[i.task],Object.getOwnPropertyDescriptor(r.prototype,"save"),r.prototype),r)
e.default=h})),define("vault/components/oidc/provider-form",["exports","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","ember-concurrency","core/utils/parse-url"],(function(e,t,n,l,a,i,r){var o,s,u,d,c,p,m
function f(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function h(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let b=(o=class extends t.default{constructor(){super(...arguments),f(this,"store",s,this),f(this,"flashMessages",u,this),f(this,"modelValidations",d,this),f(this,"errorBanner",c,this),f(this,"invalidFormAlert",p,this),f(this,"radioCardGroupValue",m,this)}renderInfoTooltip(e,t){return!!!t.findBy("clientId",e)&&"The application associated with this client_id no longer exists"}setIssuer(e,t){let[n]=t
n.issuer=n.isNew?"":(0,r.default)(n.issuer).origin}handleClientSelection(e){Array.isArray(e)?this.args.model.allowedClientIds=e.map((e=>e.clientId)):(this.radioCardGroupValue=e,this.args.model.allowedClientIds=[])}cancel(){const e=this.args.model.isNew?"unloadRecord":"rollbackAttributes"
this.args.model[e](),this.args.onCancel()}*save(e){e.preventDefault()
try{const{isValid:e,state:t,invalidFormMessage:n}=this.args.model.validate()
if(this.modelValidations=e?null:t,this.invalidFormAlert=n,e){const{isNew:e,name:t}=this.args.model
"allow_all"===this.radioCardGroupValue&&(this.args.model.allowedClientIds=["*"]),yield this.args.model.save(),this.flashMessages.success(`Successfully ${e?"created":"updated"} the OIDC provider\n          ${t}.`),this.args.onSave()}}catch(t){const e=t.errors?t.errors.join(". "):t.message
this.errorBanner=e,this.invalidFormAlert="There was an error submitting this form."}}},s=h(o.prototype,"store",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=h(o.prototype,"flashMessages",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=h(o.prototype,"modelValidations",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=h(o.prototype,"errorBanner",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=h(o.prototype,"invalidFormAlert",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=h(o.prototype,"radioCardGroupValue",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!this.args.model.allowedClientIds||this.args.model.allowedClientIds.includes("*")?"allow_all":"limited"}}),h(o.prototype,"setIssuer",[n.action],Object.getOwnPropertyDescriptor(o.prototype,"setIssuer"),o.prototype),h(o.prototype,"handleClientSelection",[n.action],Object.getOwnPropertyDescriptor(o.prototype,"handleClientSelection"),o.prototype),h(o.prototype,"cancel",[n.action],Object.getOwnPropertyDescriptor(o.prototype,"cancel"),o.prototype),h(o.prototype,"save",[i.task],Object.getOwnPropertyDescriptor(o.prototype,"save"),o.prototype),o)
e.default=b})),define("vault/components/oidc/scope-form",["exports","@glimmer/component","@glimmer/tracking","@ember/object","ember-concurrency","@ember/service"],(function(e,t,n,l,a,i){var r,o,s,u,d
function c(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function p(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let m=(r=class extends t.default{constructor(){var e,t,n
super(...arguments),c(this,"flashMessages",o,this),c(this,"errorBanner",s,this),c(this,"invalidFormAlert",u,this),c(this,"modelValidations",d,this),n='{\n  "username": {{identity.entity.aliases.$MOUNT_ACCESSOR.name}},\n  "contact": {\n    "email": {{identity.entity.metadata.email}},\n    "phone_number": {{identity.entity.metadata.phone_number}}\n  },\n  "groups": {{identity.entity.groups.names}}\n}',(t="exampleTemplate")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}*save(e){e.preventDefault()
try{const{isValid:e,state:t,invalidFormMessage:n}=this.args.model.validate()
if(this.modelValidations=e?null:t,this.invalidFormAlert=n,e){const{isNew:e,name:t}=this.args.model
yield this.args.model.save(),this.flashMessages.success(`Successfully ${e?"created":"updated"} the scope ${t}.`),this.args.onSave()}}catch(t){const e=t.errors?t.errors.join(". "):t.message
this.errorBanner=e,this.invalidFormAlert="There was an error submitting this form."}}cancel(){const e=this.args.model.isNew?"unloadRecord":"rollbackAttributes"
this.args.model[e](),this.args.onCancel()}},o=p(r.prototype,"flashMessages",[i.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=p(r.prototype,"errorBanner",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=p(r.prototype,"invalidFormAlert",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=p(r.prototype,"modelValidations",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p(r.prototype,"save",[a.task],Object.getOwnPropertyDescriptor(r.prototype,"save"),r.prototype),p(r.prototype,"cancel",[l.action],Object.getOwnPropertyDescriptor(r.prototype,"cancel"),r.prototype),r)
e.default=m})),define("vault/components/outer-html",["exports","@ember/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({tagName:""})
e.default=n})),define("vault/components/overview-card",["exports","core/components/overview-card"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/page-header-level",["exports","core/components/page-header-level"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/page-header",["exports","core/components/page-header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/page/breadcrumbs",["exports","core/components/page/breadcrumbs"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/page/error",["exports","core/components/page/error"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/pagination-controls",["exports","@glimmer/component","@glimmer/tracking","@ember/object"],(function(e,t,n,l){var a,i
function r(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let o=(a=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="page",l=this,(n=i)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0}),this.page=this.args.startPage||1,this.size=this.args.size||15}get totalPages(){return Math.ceil(this.args.total/this.size)}get displayInfo(){const{total:e}=this.args,t=this.page*this.size
return`${t-this.size+1}-${t>e?e:t} of ${e}`}get pages(){let e=this.page-2>=1?this.page-2:1
const t=e+4,n=t<=this.totalPages?t:this.totalPages,l=[]
for(;e<=n;)l.push(e),e++
return l}get hasMorePages(){return this.pages.lastObject!==this.totalPages}changePage(e){this.page=e,this.args.onChange(e)}},i=r(a.prototype,"page",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),r(a.prototype,"changePage",[l.action],Object.getOwnPropertyDescriptor(a.prototype,"changePage"),a.prototype),a)
e.default=o})),define("vault/components/pgp-file",["exports","@ember/component","@ember/object","ember-concurrency","@ember/test-waiters"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=/^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/gi
var r=t.default.extend({"data-test-pgp-file":!0,attributeBindings:["data-test-pgp-file"],classNames:["box","is-fullwidth","is-marginless","is-shadowless"],key:null,index:null,onChange:()=>{},label:null,fileHelpText:null,textareaHelpText:null,readFile(e){const t=new FileReader
t.onload=()=>this.setPGPKey.perform(t.result,e.name),t.readAsDataURL(e)},setPGPKey:(0,l.task)((0,a.waitFor)((function*(e,t){const n=e.split(",")[1].trim(),l=atob(n).trim(),a=l.match(i)?l:n
yield this.onChange(this.index,{value:a,filename:t})}))),actions:{pickedFile(e){const{files:t}=e.target
if(t.length)for(let n=0,l=t.length;n<l;n++)this.readFile(t[n])},updateData(e){const t=this.key;(0,n.set)(t,"value",e.target.value),this.onChange(this.index,this.key)},clearKey(){this.onChange(this.index,{value:""})}}})
e.default=r})),define("vault/components/pgp-list",["exports","@ember/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({onDataUpdate:()=>{},listLength:0,listData:null,init(){this._super(...arguments)
let e=this.listLength
e&&(e=parseInt(e,10))
const t=this.newList(e)
this.set("listData",t)},didReceiveAttrs(){let e
this._super(...arguments),this.listLength?this.listData.length!==this.listLength&&(this.listLength<this.listData.length?e=this.listData.slice(0,this.listLength):this.listLength>this.listData.length&&(e=[...this.listData,...this.newList(this.listLength-this.listData.length)]),this.set("listData",e||this.listData),this.onDataUpdate((e||this.listData).compact().map((e=>e.value)))):this.set("listData",[])},newList:e=>Array(e||0).fill(null).map((()=>({value:""}))),actions:{setKey(e,t){const{listData:n}=this
n.splice(e,1,t),this.onDataUpdate(n.compact().map((e=>e.value)))}}})
e.default=n})),define("vault/components/policy-example",["exports","core/components/policy-example"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/policy-form",["exports","@ember/component","@ember/template-factory","@glimmer/component","@ember/object","@ember/service","ember-concurrency","vault/utils/trim-right","@glimmer/tracking"],(function(e,t,n,l,a,i,r,o,s){var u,d,c,p,m
function f(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function h(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const b=(0,n.createTemplateFactory)({id:"rfGtENTo",block:'[[[11,"form"],[4,[38,0],["submit",[28,[37,1],[[30,0,["save"]]],null]],null],[12],[1,"\\n  "],[10,0],[14,0,"box is-bottomless is-fullwidth is-marginless"],[12],[1,"\\n    "],[8,[39,2],null,[["@errorMessage"],[[30,0,["errorBanner"]]]],null],[1,"\\n    "],[8,[39,3],null,[["@mode","@noun"],[[52,[30,1,["isNew"]],"create","edit"],"policy"]],null],[1,"\\n"],[41,[30,1,["isNew"]],[[[1,"      "],[10,0],[14,0,"field"],[12],[1,"\\n        "],[10,"label"],[14,"for","policy-name"],[14,0,"is-label"],[12],[1,"Name"],[13],[1,"\\n        "],[10,0],[14,0,"control"],[12],[1,"\\n          "],[8,[39,5],[[24,1,"policy-name"],[24,0,"input"],[4,[38,0],["input",[30,0,["setModelName"]]],null]],[["@type","@value"],["text",[28,[37,6],[[30,1,["name"]]],null]]],null],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n"]],[]],null],[1,"    "],[10,0],[14,0,"field"],[12],[1,"\\n"],[41,[30,1,["isNew"]],[[[1,"        "],[8,[39,7],null,null,[["default"],[[[[1,"\\n          "],[10,"label"],[14,0,"has-text-weight-bold"],[12],[1,"Policy"],[13],[1,"\\n          "],[8,[39,8],null,null,[["default"],[[[[1,"\\n            "],[10,0],[14,0,"toolbar-separator"],[12],[13],[1,"\\n            "],[10,0],[14,0,"control is-flex"],[12],[1,"\\n              "],[8,[39,5],[[24,1,"fileUploadToggle"],[24,3,"fileUploadToggle"],[24,0,"switch is-rounded is-success is-small"],[4,[38,0],["change",[28,[37,9],[[28,[37,10],[[30,0,["showFileUpload"]]],null],[28,[37,11],[[30,0,["showFileUpload"]]],null]],null]],null]],[["@type","@checked"],["checkbox",[30,0,["showFileUpload"]]]],null],[1,"\\n              "],[10,"label"],[14,"for","fileUploadToggle"],[12],[1,"Upload file"],[13],[1,"\\n            "],[13],[1,"\\n          "]],[]]]]],[1,"\\n        "]],[]]]]],[1,"\\n"],[41,[30,0,["showFileUpload"]],[[[1,"          "],[8,[39,12],null,[["@uploadOnly","@onChange"],[true,[30,0,["setPolicyFromFile"]]]],null],[1,"\\n"]],[]],[[[1,"          "],[8,[39,13],null,[["@title","@showToolbar","@value","@valueUpdated","@mode","@extraKeys"],["Policy",false,[30,1,["policy"]],[28,[37,14],[[30,0],[28,[37,10],[[30,1,["policy"]]],null]],null],"ruby",[28,[37,15],null,[["Shift-Enter"],[[28,[37,1],[[30,0,["save"]]],null]]]]]],null],[1,"\\n"]],[]]]],[]],[[[1,"        "],[8,[39,13],null,[["@title","@value","@valueUpdated","@mode","@extraKeys"],["Policy",[30,1,["policy"]],[28,[37,14],[[30,0],[28,[37,10],[[30,1,["policy"]]],null]],null],"ruby",[28,[37,15],null,[["Shift-Enter"],[[28,[37,1],[[30,0,["save"]]],null]]]]]],null],[1,"\\n"]],[]]],[1,"      "],[10,0],[14,0,"has-top-margin-xs"],[12],[1,"\\n        "],[10,1],[14,0,"is-size-9 has-text-grey has-bottom-margin-l"],[12],[1,"\\n          You can use Alt+Tab (Option+Tab on MacOS) in the code editor to skip to the next field.\\n        "],[13],[1,"\\n"],[41,[30,2],[[[1,"          "],[10,1],[14,0,"is-size-9 has-text-grey has-bottom-margin-l"],[12],[1,"\\n            See\\n            "],[11,"button"],[24,0,"text-button has-text-info"],[24,4,"button"],[4,[38,0],["click",[28,[37,9],[[28,[37,10],[[30,0,["showTemplateModal"]]],null]],null]],null],[12],[1,"\\n              example template\\n            "],[13],[1,".\\n          "],[13],[1,"\\n"]],[]],[[[1,"          "],[10,2],[14,0,"has-top-margin-l"],[12],[1,"\\n            More information about\\n            "],[1,[28,[35,16],[[30,1,["policyType"]]],null]],[1,"\\n            policies can be found\\n            "],[8,[39,17],null,[["@path"],[[52,[28,[37,18],[[30,1,["policyType"]],"acl"],null],"/vault/docs/concepts/policies#capabilities","/vault/tutorials/policies/sentinel#role-governing-policies-rgps"]]],[["default"],[[[[1,"\\n              here.\\n            "]],[]]]]],[1,"\\n          "],[13],[1,"\\n"]],[]]],[1,"      "],[13],[1,"\\n    "],[13],[1,"\\n"],[42,[28,[37,20],[[28,[37,20],[[30,1,["additionalAttrs"]]],null]],null],null,[[[1,"      "],[8,[39,21],null,[["@attr","@model"],[[30,3],[30,1]]],null],[1,"\\n"]],[3]],null],[1,"  "],[13],[1,"\\n  "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n    "],[10,0],[14,0,"control"],[12],[1,"\\n      "],[10,"button"],[15,0,[29,["button is-primary ",[52,[30,0,["save","isRunning"]],"is-loading"]]]],[15,"disabled",[30,0,["save","isRunning"]]],[14,4,"submit"],[12],[1,"\\n        "],[1,[52,[30,1,["isNew"]],"Create policy","Save"]],[1,"\\n      "],[13],[1,"\\n      "],[11,"button"],[24,0,"button has-left-margin-s"],[16,"disabled",[30,0,["save","isRunning"]]],[24,4,"button"],[4,[38,0],["click",[30,0,["cancel"]]],null],[12],[1,"\\n        Cancel\\n      "],[13],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"],[13],[1,"\\n"],[41,[30,2],[[[1,"  "],[8,[39,22],null,[["@title","@onClose","@isActive","@showCloseButton"],[[29,["Example ",[28,[37,16],[[30,1,["policyType"]]],null]," Policy"]],[28,[37,9],[[28,[37,10],[[30,0,["showTemplateModal"]]],null],false],null],[30,0,["showTemplateModal"]],true]],[["default"],[[[[1,"\\n    "],[10,"section"],[14,0,"modal-card-body"],[12],[1,"\\n"],[41,[30,0,["showTemplateModal"]],[[[1,"        "],[8,[39,23],null,[["@policyType"],[[30,1,["policyType"]]]],null],[1,"\\n"]],[]],null],[1,"    "],[13],[1,"\\n    "],[10,0],[14,0,"modal-card-head has-border-top-light"],[12],[1,"\\n      "],[11,"button"],[24,0,"button"],[24,4,"button"],[4,[38,0],["click",[28,[37,9],[[28,[37,10],[[30,0,["showTemplateModal"]]],null],false],null]],null],[12],[1,"\\n        Close\\n      "],[13],[1,"\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[]],null]],["@model","@renderPolicyExampleModal","attr"],false,["on","perform","message-error","namespace-reminder","if","input","lowercase","toolbar","toolbar-actions","fn","mut","not","text-file","json-editor","action","hash","uppercase","doc-link","eq","each","-track-array","form-field","modal","policy-example"]]',moduleName:"vault/components/policy-form.hbs",isStrictMode:!1})
let y=(u=class extends l.default{constructor(){super(...arguments),f(this,"flashMessages",d,this),f(this,"errorBanner",c,this),f(this,"showFileUpload",p,this),f(this,"showTemplateModal",m,this)}*save(e){e.preventDefault()
try{const{name:e,policyType:t,isNew:n}=this.args.model
yield this.args.model.save(),this.flashMessages.success(`${t.toUpperCase()} policy "${e}" was successfully ${n?"created":"updated"}.`),this.args.onSave(this.args.model)}catch(t){const e=t.errors?t.errors.join(". "):t.message
this.errorBanner=e}}setModelName(e){let{target:t}=e
this.args.model.name=t.value.toLowerCase()}setPolicyFromFile(e){const{value:t,filename:n}=e
if(this.args.model.policy=t,!this.args.model.name){const e=(0,o.default)(n,[".json",".txt",".hcl",".policy"])
this.args.model.name=e.toLowerCase()}this.showFileUpload=!1}cancel(){const e=this.args.model.isNew?"unloadRecord":"rollbackAttributes"
this.args.model[e](),this.args.onCancel()}},d=h(u.prototype,"flashMessages",[i.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=h(u.prototype,"errorBanner",[s.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),p=h(u.prototype,"showFileUpload",[s.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),m=h(u.prototype,"showTemplateModal",[s.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),h(u.prototype,"save",[r.task],Object.getOwnPropertyDescriptor(u.prototype,"save"),u.prototype),h(u.prototype,"setModelName",[a.action],Object.getOwnPropertyDescriptor(u.prototype,"setModelName"),u.prototype),h(u.prototype,"setPolicyFromFile",[a.action],Object.getOwnPropertyDescriptor(u.prototype,"setPolicyFromFile"),u.prototype),h(u.prototype,"cancel",[a.action],Object.getOwnPropertyDescriptor(u.prototype,"cancel"),u.prototype),u)
e.default=y,(0,t.setComponentTemplate)(b,y)})),define("vault/components/popup-menu",["exports","core/components/popup-menu"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/portal-target",["exports","ember-stargate/components/portal-target"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/portal",["exports","ember-stargate/components/portal"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select-multiple",["exports","ember-power-select/components/power-select-multiple"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select-multiple/trigger",["exports","ember-power-select/components/power-select-multiple/trigger"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select",["exports","ember-power-select/components/power-select"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select/before-options",["exports","ember-power-select/components/power-select/before-options"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select/no-matches-message",["exports","ember-power-select/components/power-select/no-matches-message"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select/options",["exports","ember-power-select/components/power-select/options"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select/placeholder",["exports","ember-power-select/components/power-select/placeholder"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select/power-select-group",["exports","ember-power-select/components/power-select/power-select-group"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select/search-message",["exports","ember-power-select/components/power-select/search-message"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select/trigger",["exports","ember-power-select/components/power-select/trigger"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/qr-code",["exports","ember-qrcode-shim/components/qr-code"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/radial-progress",["exports","@ember/component","@ember/object"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend({"data-test-radial-progress":!0,tagName:"svg",classNames:"radial-progress",attributeBindings:["size:width","size:height","viewBox","data-test-radial-progress"],progressDecimal:null,size:20,strokeWidth:1,viewBox:(0,n.computed)("size",(function(){const e=this.size
return`0 0 ${e} ${e}`})),centerValue:(0,n.computed)("size",(function(){return this.size/2})),r:(0,n.computed)("size","strokeWidth",(function(){return(this.size-this.strokeWidth)/2})),c:(0,n.computed)("r",(function(){return 2*Math.PI*this.r})),dashArrayOffset:(0,n.computed)("c","progressDecimal",(function(){return this.c*(1-this.progressDecimal)}))})
e.default=l})),define("vault/components/radio-button",["exports","core/components/radio-button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/radio-card",["exports","core/components/radio-card"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/raft-join",["exports","@ember/service","@ember/component"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=n.default.extend({classNames:"raft-join",store:(0,t.inject)(),onDismiss(){},preference:"join",showJoinForm:!1,actions:{advanceFirstScreen(e){e.preventDefault(),"join"===this.preference?this.set("showJoinForm",!0):this.onDismiss()},newModel(){return this.store.createRecord("raft-join")}}})
e.default=l})),define("vault/components/raft-storage-overview",["exports","@ember/component","@ember/application","vault/config/environment","@ember/service"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=t.default.extend({flashMessages:(0,a.inject)(),auth:(0,a.inject)(),useServiceWorker:null,async init(){if(this._super(...arguments),!1!==this.useServiceWorker&&"serviceWorker"in navigator){await navigator.serviceWorker.getRegistration(l.default.serviceWorkerScope)&&(navigator.serviceWorker.addEventListener("message",this.serviceWorkerGetToken.bind(this)),this.set("useServiceWorker",!0))}},willDestroy(){this.useServiceWorker&&navigator.serviceWorker.removeEventListener("message",this.serviceWorkerGetToken),this._super(...arguments)},serviceWorkerGetToken(e){const{action:t}=e.data,[n]=e.ports
"getToken"===t?n.postMessage({token:this.auth.currentToken}):(console.error("Unknown event",e),n.postMessage({error:"Unknown request"}))},actions:{async removePeer(e){const{nodeId:t}=e
try{await e.destroyRecord()}catch(n){const e=n.errors?n.errors.join(" "):n.message||n
return void this.flashMessages.danger(`There was an issue removing the peer ${t}: ${e}`)}this.flashMessages.success(`Successfully removed the peer: ${t}.`)},downloadViaServiceWorker(){this.flashMessages.success("The snapshot download will begin shortly.")},async downloadSnapshot(){const e=(0,n.getOwner)(this).lookup("adapter:application")
let t,l
this.flashMessages.success("The snapshot download has begun.")
try{t=await e.rawRequest("/v1/sys/storage/raft/snapshot","GET"),l=await t.blob()}catch(s){const e=s.errors?s.errors.join(" "):s.message||s
this.flashMessages.danger(`There was an error trying to download the snapshot: ${e}`)}const a="snapshot.gz",i=new Blob([l],{type:"application/x-gzip"})
if(i.name=a,"msSaveOrOpenBlob"in navigator)return void navigator.msSaveOrOpenBlob(i,a)
const r=document.createElement("a"),o=window.URL.createObjectURL(i)
r.href=o,r.download=a,document.body.appendChild(r),r.click(),r.remove(),window.URL.revokeObjectURL(o)}}})
e.default=i})),define("vault/components/raft-storage-restore",["exports","@ember/component","ember-concurrency","@ember/application","@ember/service","@ember/object/computed","fetch"],(function(e,t,n,l,a,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var o=t.default.extend({file:null,errors:null,forceRestore:!1,flashMessages:(0,a.inject)(),isUploading:(0,i.alias)("restore.isRunning"),abortController:null,restore:(0,n.task)((function*(){this.set("errors",null)
const e=(0,l.getOwner)(this).lookup("adapter:application")
try{let t="/v1/sys/storage/raft/snapshot"
this.forceRestore&&(t=`${t}-force`)
const n=new Blob([this.file],{type:"application/gzip"}),l=new r.AbortController
this.set("abortController",l),yield e.rawRequest(t,"POST",{body:n,signal:l.signal}),this.flashMessages.success("The snapshot was successfully uploaded!")}catch(t){if("AbortError"===t.name)return
let e
t.json&&(e=yield t.json())
const n=e?e.errors:[t]
this.set("errors",n)}})),actions:{cancelUpload(){this.abortController.abort()}}})
e.default=o})),define("vault/components/read-more",["exports","core/components/read-more"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/readonly-form-field",["exports","core/components/readonly-form-field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/regex-validator",["exports","@ember/component","@ember/template-factory","@glimmer/component","@glimmer/tracking","@ember/object"],(function(e,t,n,l,a,i){var r,o,s
function u(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function d(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const c=(0,n.createTemplateFactory)({id:"Tecl3l3z",block:'[[[41,[30,1],[[[1,"  "],[10,0],[14,0,"field"],[12],[1,"\\n    "],[10,0],[14,0,"regex-label-wrapper"],[12],[1,"\\n      "],[10,0],[14,0,"regex-label"],[12],[1,"\\n        "],[10,"label"],[15,"for",[30,1,["name"]]],[14,0,"is-label"],[12],[1,"\\n          "],[1,[30,2]],[1,"\\n"],[41,[30,1,["options","helpText"]],[[[1,"            "],[8,[39,1],null,null,[["default"],[[[[1,"\\n              "],[10,1],[12],[1,"\\n                "],[1,[30,1,["options","helpText"]]],[1,"\\n              "],[13],[1,"\\n            "]],[]]]]],[1,"\\n"]],[]],null],[1,"        "],[13],[1,"\\n"],[41,[30,1,["options","subText"]],[[[1,"          "],[10,2],[14,0,"sub-text"],[12],[1,"\\n            "],[1,[30,1,["options","subText"]]],[1,"\\n"],[41,[30,1,["options","docLink"]],[[[1,"              "],[8,[39,2],null,[["@path"],[[30,1,["options","docLink"]]]],[["default"],[[[[1,"\\n                See our documentation\\n              "]],[]]]]],[1,"\\n              for help.\\n"]],[]],null],[1,"          "],[13],[1,"\\n"]],[]],null],[1,"      "],[13],[1,"\\n      "],[10,0],[12],[1,"\\n        "],[8,[39,3],null,[["@name","@status","@size","@checked","@onChange"],[[28,[37,4],[[30,1,["name"]],"-validation-toggle"],null],"success","small",[30,0,["showTestValue"]],[30,0,["toggleTestValue"]]]],[["default"],[[[[1,"\\n          "],[10,1],[14,0,"has-text-grey"],[12],[1,"Validation"],[13],[1,"\\n        "]],[]]]]],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n    "],[11,"input"],[16,1,[30,1,["name"]]],[24,"autocomplete","off"],[24,"spellcheck","false"],[16,2,[30,3]],[24,0,"input"],[4,[38,5],["change",[30,4]],null],[12],[13],[1,"\\n  "],[13],[1,"\\n"]],[]],null],[41,[30,0,["showTestValue"]],[[[1,"  "],[10,0],[12],[1,"\\n    "],[10,"label"],[14,"for","regex-test-val"],[14,0,"is-label"],[12],[1,"\\n      "],[1,[30,0,["testInputLabel"]]],[1,"\\n    "],[13],[1,"\\n"],[41,[30,5],[[[1,"      "],[10,2],[14,0,"sub-text"],[12],[1,[30,5]],[13],[1,"\\n"]],[]],null],[1,"    "],[11,"input"],[24,1,"regex-test-val"],[24,"autocomplete","off"],[24,"spellcheck","false"],[16,2,[30,0,["testValue"]]],[16,0,[29,["input ",[52,[30,0,["regexError"]],"has-error"]]]],[4,[38,5],["change",[30,0,["updateTestValue"]]],null],[12],[13],[1,"\\n\\n"],[41,[30,0,["testValue"]],[[[1,"      "],[10,0],[12],[1,"\\n"],[41,[28,[37,6],[[30,3]],null],[[[1,"          "],[8,[39,7],null,[["@type","@message"],["warning",[28,[37,4],["A pattern has not been entered. Enter a pattern to check this ",[28,[37,8],[[30,0,["testInputLabel"]]],null]," against it."],null]]],null],[1,"\\n"]],[]],[[[41,[30,0,["regexError"]],[[[1,"          "],[8,[39,7],null,[["@type","@message"],["danger","This test string does not match the pattern regex."]],null],[1,"\\n"]],[]],[[[1,"          "],[8,[39,7],null,[["@type","@message"],["success","This test string matches the pattern regex."]],null],[1,"\\n        "]],[]]]],[]]],[1,"      "],[13],[1,"\\n"]],[]],null],[1,"  "],[13],[1,"\\n"]],[]],null],[41,[30,6],[[[1,"  "],[10,0],[14,0,"has-top-margin-l"],[12],[1,"\\n    "],[10,"label"],[14,0,"is-label"],[12],[1,"Groups"],[13],[1,"\\n"],[41,[28,[37,9],[[30,3],[30,0,["testValue"]],[28,[37,6],[[30,0,["regexError"]]],null]],null],[[[1,"      "],[10,0],[14,0,"regex-group"],[12],[1,"\\n"],[42,[28,[37,11],[[28,[37,11],[[30,0,["captureGroups"]]],null]],null],null,[[[1,"          "],[10,1],[14,0,"regex-group-position"],[12],[1,"\\n            "],[10,1],[12],[1,[30,7,["position"]]],[13],[1,"\\n          "],[13],[1,"\\n          "],[10,1],[14,0,"regex-group-value"],[12],[1,"\\n            "],[1,[30,7,["value"]]],[1,"\\n          "],[13],[1,"\\n"]],[7]],null],[1,"      "],[13],[1,"\\n"]],[]],[[[1,"      "],[10,2],[14,0,"sub-text"],[12],[1,"\\n        Enter pattern and test string to show groupings.\\n      "],[13],[1,"\\n"]],[]]],[1,"  "],[13],[1,"\\n"]],[]],null]],["@attr","@labelString","@value","@onChange","@testInputSubText","@showGroups","group"],false,["if","info-tooltip","doc-link","toggle","concat","on","not","alert-inline","lowercase","and","each","-track-array"]]',moduleName:"vault/components/regex-validator.hbs",isStrictMode:!1})
let p=(r=class extends l.default{constructor(){super(...arguments),u(this,"testValue",o,this),u(this,"showTestValue",s,this),this.showTestValue=!this.args.attr}get testInputLabel(){return this.args.testInputLabel||"Test string"}get regex(){return new RegExp(this.args.value,"g")}get regexError(){const e=this.testValue
if(!e||!this.args.value)return!1
const t=e.toString().match(this.regex)
return this.args.onValidate&&this.args.onValidate(this.testValue,this.captureGroups),e!==t?.join("")}get captureGroups(){const e=this.regex.exec(this.testValue)
if(e){const[t,...n]=e,l=n.map(((e,t)=>({position:`$${t+1}`,value:e})))
if(e.groups)for(const a in e.groups)l.push({position:`$${a}`,value:e.groups[a]})
return l}return[]}updateTestValue(e){this.testValue=e.target.value}toggleTestValue(){this.showTestValue=!this.showTestValue}},o=d(r.prototype,"testValue",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),s=d(r.prototype,"showTestValue",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),d(r.prototype,"updateTestValue",[i.action],Object.getOwnPropertyDescriptor(r.prototype,"updateTestValue"),r.prototype),d(r.prototype,"toggleTestValue",[i.action],Object.getOwnPropertyDescriptor(r.prototype,"toggleTestValue"),r.prototype),r)
e.default=p,(0,t.setComponentTemplate)(c,p)}))
define("vault/components/replication-action-demote",["exports","core/components/replication-action-demote"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-action-disable",["exports","core/components/replication-action-disable"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-action-generate-token",["exports","core/components/replication-action-generate-token"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-action-promote",["exports","core/components/replication-action-promote"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-action-recover",["exports","core/components/replication-action-recover"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-action-reindex",["exports","core/components/replication-action-reindex"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-action-update-primary",["exports","core/components/replication-action-update-primary"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-actions-single",["exports","core/components/replication-actions-single"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-actions",["exports","core/components/replication-actions"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-dashboard",["exports","core/components/replication-dashboard"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-header",["exports","core/components/replication-header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-mode-summary",["exports","core/components/replication-mode-summary"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-page",["exports","core/components/replication-page"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-secondary-card",["exports","core/components/replication-secondary-card"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-summary-card",["exports","core/components/replication-summary-card"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-table-rows",["exports","core/components/replication-table-rows"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/resultant-acl-banner",["exports","@ember/component","@ember/template-factory","@ember/service","@glimmer/component","@glimmer/tracking","vault/services/permissions"],(function(e,t,n,l,a,i,r){var o,s,u,d
function c(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function p(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const m=(0,n.createTemplateFactory)({id:"3Pgwkas+",block:'[[[41,[51,[30,0,["hideBanner"]]],[[[1,"  "],[8,[39,1],null,[["@type","@color","@onDismiss"],["inline","critical",[28,[37,2],[[28,[37,3],[[30,0,["hideBanner"]]],null],true],null]]],[["default"],[[[[1,"\\n    "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,[30,0,["title"]]]],[]]]]],[1,"\\n    "],[8,[30,1,["Description"]],null,null,[["default"],[[[[1,"\\n      "],[1,[30,0,["message"]]],[1,"\\n    "]],[]]]]],[1,"\\n"],[41,[30,2],[[[1,"      "],[8,[30,1,["Link::Standalone"]],null,[["@icon","@iconPosition","@text","@route","@query"],["arrow-right","trailing",[28,[37,5],["Log into ",[30,0,["ns"]]," namespace"],null],"vault.cluster.logout",[30,0,["queryParams"]]]],null],[1,"\\n"]],[]],null],[1,"  "]],[1]]]]],[1,"\\n"]],[]],null]],["A","@isEnterprise"],false,["unless","hds/alert","fn","mut","if","concat"]]',moduleName:"vault/components/resultant-acl-banner.hbs",isStrictMode:!1})
let f=(o=class extends a.default{constructor(){super(...arguments),c(this,"namespace",s,this),c(this,"router",u,this),c(this,"hideBanner",d,this)}get ns(){return this.namespace.path||"root"}get queryParams(){return{redirect_to:this.router.currentURL}}get title(){return this.args.failType===r.PERMISSIONS_BANNER_STATES.noAccess?"You do not have access to this namespace":"Resultant ACL check failed"}get message(){return this.args.failType===r.PERMISSIONS_BANNER_STATES.noAccess?"Log into the namespace directly, or contact your administrator if you think you should have access.":"Links might be shown that you don't have access to. Contact your administrator to update your policy."}},s=p(o.prototype,"namespace",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=p(o.prototype,"router",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=p(o.prototype,"hideBanner",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),o)
e.default=f,(0,t.setComponentTemplate)(m,f)})),define("vault/components/role-aws-edit",["exports","@ember/utils","@ember/object","vault/components/role-edit"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=l.default.extend({actions:{createOrUpdate(e,l){l.preventDefault()
const a=this.model.id||this.model.name
if("create"!==e||!(0,t.isBlank)(a)){var i=this.model.credential_type
"iam_user"==i&&(0,n.set)(this,"model.role_arns",[]),"assumed_role"==i&&(0,n.set)(this,"model.policy_arns",[]),"federation_token"==i&&((0,n.set)(this,"model.role_arns",[]),(0,n.set)(this,"model.policy_arns",[])),"{}"==this.model.policy_document&&(0,n.set)(this,"model.policy_document",""),this.persist("save",(()=>{this.hasDataChanges(),this.transitionToRoute("vault.cluster.secrets.backend.show",a)}))}},codemirrorUpdated(e,t,l){l.performLint()
l.state.lint.marked.length>0||(0,n.set)(this.model,e,t)}}})
e.default=a})),define("vault/components/role-edit",["exports","@ember/service","@ember/object/computed","@ember/utils","ember-concurrency","@ember/component","@ember/object","vault/mixins/focus-on-insert","core/utils/key-codes"],(function(e,t,n,l,a,i,r,o,s){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const u="vault.cluster.secrets.backend.list-root"
var d=i.default.extend(o.default,{router:(0,t.inject)(),mode:null,emptyData:"{\n}",onDataChange(){},onRefresh(){},model:null,requestInFlight:(0,n.or)("model.isLoading","model.isReloading","model.isSaving"),willDestroyElement(){this.model&&this.model.isError&&!this.model.isDestroyed&&!this.model.isDestroying&&this.model.rollbackAttributes(),this._super(...arguments)},waitForKeyUp:(0,a.task)((function*(){for(;;){const e=yield(0,a.waitForEvent)(document.body,"keyup")
this.onEscape(e)}})).on("didInsertElement").cancelOn("willDestroyElement"),transitionToRoute(){this.router.transitionTo(...arguments)},onEscape(e){e.keyCode===s.default.ESC&&"show"===this.mode&&this.transitionToRoute(u)},hasDataChanges(){this.onDataChange(this.model.hasDirtyAttributes)},persist(e,t){const n=this.model
return n[e]().then((()=>{n.isError||t(n)}))},actions:{createOrUpdate(e,t){t.preventDefault()
const n=this.model.id||this.model.name
"create"===e&&(0,l.isBlank)(n)||this.persist("save",(()=>{this.hasDataChanges(),this.transitionToRoute("vault.cluster.secrets.backend.show",n)}))},setValue(e,t){(0,r.set)(this.model,e,t.target.checked)},refresh(){this.onRefresh()},delete(){this.persist("destroyRecord",(()=>{this.hasDataChanges(),this.transitionToRoute(u)}))},codemirrorUpdated(e,t,n){n.performLint()
n.state.lint.marked.length>0||(0,r.set)(this.model,e,JSON.parse(t))}}})
e.default=d})),define("vault/components/role-ssh-edit",["exports","vault/components/role-edit"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({init(){this._super(...arguments),this.set("backendType","ssh")},actions:{updateTtl(e,t){const n=this.model,l=!0===t.enabled?`${t.seconds}s`:void 0
n.set(e,l)}}})
e.default=n})),define("vault/components/seal-action",["exports","@ember/component","@ember/template-factory","@ember/object","@glimmer/component","@glimmer/tracking","vault/utils/error-message"],(function(e,t,n,l,a,i,r){var o,s
function u(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const d=(0,n.createTemplateFactory)({id:"EXok/eQ5",block:'[[[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n"],[41,[30,0,["error"]],[[[1,"    "],[8,[39,1],[[24,0,"has-bottom-margin-m"]],[["@type","@color"],["inline","critical"]],[["default"],[[[[1,"\\n      "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Error"]],[]]]]],[1,"\\n      "],[8,[30,1,["Description"]],null,null,[["default"],[[[[1,"\\n        "],[1,[30,0,["error"]]],[1,"\\n      "]],[]]]]],[1,"\\n    "]],[1]]]]],[1,"\\n"]],[]],null],[1,"  "],[10,2],[12],[1,"\\n    Sealing a vault tells the Vault server to stop responding to any access operations until it is unsealed again. A sealed\\n    vault throws away its root key to unlock the data, so it physically is blocked from responding to operations again until\\n    the Vault is unsealed again with the \\"unseal\\" command or via the API.\\n  "],[13],[1,"\\n"],[13],[1,"\\n\\n"],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n  "],[8,[39,2],null,[["@buttonClasses","@confirmTitle","@confirmMessage","@confirmButtonText","@horizontalPosition","@onConfirmAction"],["button is-primary","Seal this cluster?","You will not be able to read or write any data until the cluster is unsealed again.","Seal","auto-left",[30,0,["handleSeal"]]]],[["default"],[[[[1,"\\n    Seal\\n  "]],[]]]]],[1,"\\n"],[13]],["A"],false,["if","hds/alert","confirm-action"]]',moduleName:"vault/components/seal-action.hbs",isStrictMode:!1})
let c=(o=class extends a.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="error",l=this,(n=s)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}async handleSeal(){try{await this.args.onSeal()}catch(e){this.error=(0,r.default)(e,"Seal attempt failed. Check Vault logs for details.")}}},s=u(o.prototype,"error",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u(o.prototype,"handleSeal",[l.action],Object.getOwnPropertyDescriptor(o.prototype,"handleSeal"),o.prototype),o)
e.default=c,(0,t.setComponentTemplate)(d,c)})),define("vault/components/search-select-placeholder",["exports","core/components/search-select-placeholder"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/search-select-with-modal",["exports","core/components/search-select-with-modal"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/search-select",["exports","core/components/search-select"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/secret-create-or-update",["exports","@glimmer/component","vault/lib/control-group-error","ember","core/utils/key-codes","@ember/object","@ember/service","@glimmer/tracking","@ember/utils","ember-concurrency"],(function(e,t,n,l,a,i,r,o,s,u){var d,c,p,m,f,h,b,y,v,g,w,k,x
function _(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function P(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let T=(d=(0,u.task)((function*(e,t){for(this.checkValidation(e,t);;){const e=yield(0,u.waitForEvent)(document.body,"keyup")
this.onEscape(e)}})).on("didInsertElement").cancelOn("willDestroyElement"),c=class extends t.default{constructor(){super(...arguments),_(this,"codemirrorString",p,this),_(this,"error",m,this),_(this,"secretPaths",f,this),_(this,"pathWhiteSpaceWarning",h,this),_(this,"validationErrorCount",b,this),_(this,"validationMessages",y,this),_(this,"controlGroup",v,this),_(this,"flashMessages",g,this),_(this,"router",w,this),_(this,"store",k,this),_(this,"waitForKeyUp",x,this)}setup(e,t){let[n,a,i]=t
if(this.codemirrorString=n.toJSONString(),this.validationMessages={path:""},l.default.testing)this.secretPaths=["beep","bop","boop"]
else{const e=this.store.adapterFor("secret-v2"),t={modelName:"secret-v2"},n={backend:a.backend}
e.query(this.store,t,n).then((e=>{this.secretPaths=e.data.keys}))}this.checkRows(),"edit"===i&&this.addRow()}checkRows(){0===this.args.secretData.length&&this.addRow()}checkValidation(e,t){"path"===e&&(this.pathHasWhiteSpace(t),t?(0,i.set)(this.validationMessages,e,""):(0,i.set)(this.validationMessages,e,`${e} can't be blank.`)),"path"===e&&t&&(this.secretPaths?.includes(t)?(0,i.set)(this.validationMessages,e,`A secret with this ${e} already exists.`):(0,i.set)(this.validationMessages,e,""))
const n=Object.values(this.validationMessages)
this.validationErrorCount=n.filter(Boolean).length}onEscape(e){if(e.keyCode!==a.default.ESC||"show"!==this.args.mode)return
const t=this.args.model.parentKey
t?this.transitionToRoute("vault.cluster.secrets.backend.list",t):this.transitionToRoute("vault.cluster.secrets.backend.list-root")}pathHasWhiteSpace(e){const t=new RegExp("\\s","g")
this.pathWhiteSpaceWarning=t.test(e)}persistKey(e){const t=this.args.model,l=this.args.modelForData,a=this.args.isV2
let i=l.get("path")||t.id
i.startsWith("/")&&(i=i.replace(/^\/+/g,""),l.set(l.pathAttr,i))
const r=t.changedAttributes(),o=Object.keys(r)
return l.save().then((()=>{!this.args.canReadSecretData&&t.selectedVersion&&delete t.selectedVersion.secretData,l.isError||(a&&t.set("id",i),a&&o.length>0&&"currentVersion"!==o[0]?t.save().then((()=>{this.saveComplete(e,i)})).catch((e=>{"create"===this.args.mode&&(this.error=e.errors.join(" "))})):this.saveComplete(e,i))})).catch((e=>{if(e instanceof n.default){const t=this.controlGroup.logFromError(e)
this.error=t.content,this.controlGroup.saveTokenFromError(e)}throw e}))}saveComplete(e,t){e(t)}transitionToRoute(){return this.router.transitionTo(...arguments)}get isCreateNewVersionFromOldVersion(){const e=this.args.model
return!!e&&(!e.failedServerRead&&!e.selectedVersion?.failedServerRead&&e.selectedVersion?.version!==e.currentVersion)}addRow(){const e=this.args.secretData;(0,s.isNone)(e.findBy("name",""))&&(e.pushObject({name:"",value:""}),this.handleChange()),this.checkRows()}codemirrorUpdated(e,t){this.error=null,t.performLint()
if(0===t.state.lint.marked.length)try{this.args.secretData.fromJSONString(e),(0,i.set)(this.args.modelForData,"secretData",this.args.secretData.toJSON())}catch(n){this.error=n.message}this.codemirrorString=e}createOrUpdateKey(e,t){if(t.preventDefault(),"create"===e&&(0,s.isBlank)(this.args.modelForData.path||this.args.modelForData.id))return void this.checkValidation("path","")
const n="create"===e?this.args.modelForData.path:this.args.model.id
this.persistKey((()=>{this.flashMessages.success(`Secret ${n} ${"create"===e?"created":"updated"} successfully.`),this.transitionToRoute("vault.cluster.secrets.backend.show",n)}))}deleteRow(e){const t=this.args.secretData,n=t.findBy("name",e);(0,s.isBlank)(n.name)||(t.removeObject(n),this.checkRows(),this.handleChange())}formatJSON(){this.codemirrorString=this.args.secretData.toJSONString(!0)}handleMaskedInputChange(e,t,n){const l={...e,value:n};(0,i.set)(this.args.secretData,t,l),this.handleChange()}handleChange(){this.codemirrorString=this.args.secretData.toJSONString(!0),(0,i.set)(this.args.modelForData,"secretData",this.args.secretData.toJSON())}updateValidationErrorCount(e){this.validationErrorCount=e}},p=P(c.prototype,"codemirrorString",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),m=P(c.prototype,"error",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),f=P(c.prototype,"secretPaths",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),h=P(c.prototype,"pathWhiteSpaceWarning",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),b=P(c.prototype,"validationErrorCount",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return 0}}),y=P(c.prototype,"validationMessages",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),v=P(c.prototype,"controlGroup",[r.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g=P(c.prototype,"flashMessages",[r.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=P(c.prototype,"router",[r.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=P(c.prototype,"store",[r.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P(c.prototype,"setup",[i.action],Object.getOwnPropertyDescriptor(c.prototype,"setup"),c.prototype),x=P(c.prototype,"waitForKeyUp",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P(c.prototype,"addRow",[i.action],Object.getOwnPropertyDescriptor(c.prototype,"addRow"),c.prototype),P(c.prototype,"codemirrorUpdated",[i.action],Object.getOwnPropertyDescriptor(c.prototype,"codemirrorUpdated"),c.prototype),P(c.prototype,"createOrUpdateKey",[i.action],Object.getOwnPropertyDescriptor(c.prototype,"createOrUpdateKey"),c.prototype),P(c.prototype,"deleteRow",[i.action],Object.getOwnPropertyDescriptor(c.prototype,"deleteRow"),c.prototype),P(c.prototype,"formatJSON",[i.action],Object.getOwnPropertyDescriptor(c.prototype,"formatJSON"),c.prototype),P(c.prototype,"handleMaskedInputChange",[i.action],Object.getOwnPropertyDescriptor(c.prototype,"handleMaskedInputChange"),c.prototype),P(c.prototype,"handleChange",[i.action],Object.getOwnPropertyDescriptor(c.prototype,"handleChange"),c.prototype),P(c.prototype,"updateValidationErrorCount",[i.action],Object.getOwnPropertyDescriptor(c.prototype,"updateValidationErrorCount"),c.prototype),c)
e.default=T})),define("vault/components/secret-delete-menu",["exports","ember","@ember/service","@glimmer/component","@glimmer/tracking","@ember/object"],(function(e,t,n,l,a,i){var r,o,s,u,d
function c(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function p(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let m=(r=class extends l.default{constructor(){super(...arguments),c(this,"store",o,this),c(this,"router",s,this),c(this,"flashMessages",u,this),c(this,"showDeleteModal",d,this)}get canUndeleteVersion(){return this.args.modelForData.canUndeleteVersion}get canDestroyVersion(){return this.args.modelForData.canDestroyVersion}get canDestroyAllVersions(){return this.args.modelForData.canDestroyAllVersions}get canDeleteSecretData(){return this.args.modelForData.canDeleteSecretData}get canSoftDeleteSecretData(){return this.args.modelForData.canSoftDeleteSecretData}get isLatestVersion(){const{model:e}=this.args
if(!e)return!1
return e.currentVersion===e.selectedVersion.version}handleDelete(e){if(e){if("destroy-all-versions"!==e&&"v1"!==e){let n
return this.args.canReadSecretMetadata||(n=this.args.modelForData?.version),this.store.adapterFor("secret-v2-version").v2DeleteOperation(this.store,this.args.modelForData.id,e,n).then((e=>{if(t.default.testing)this.showDeleteModal=!1
else{if(!e)return this.showDeleteModal=!1,void this.args.refresh()
if(e.isAdapterError){const t=e.errors?.join(". ")||"Something went wrong. Check the Vault logs for more information."
this.flashMessages.danger(t)}else location.reload()}}))}this.args.model.destroyRecord().then((()=>this.router.transitionTo("vault.cluster.secrets.backend.list-root")))}}},o=p(r.prototype,"store",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=p(r.prototype,"router",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=p(r.prototype,"flashMessages",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=p(r.prototype,"showDeleteModal",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),p(r.prototype,"handleDelete",[i.action],Object.getOwnPropertyDescriptor(r.prototype,"handleDelete"),r.prototype),r)
e.default=m})),define("vault/components/secret-edit-metadata",["exports","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking"],(function(e,t,n,l,a){var i,r,o,s,u
function d(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function c(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let p=(i=class extends t.default{constructor(){super(...arguments),d(this,"router",r,this),d(this,"store",o,this),d(this,"validationErrorCount",s,this),d(this,"modelValidations",u,this)}async save(){const e=this.args.model
try{await e.save()}catch(t){return void(this.error=t)}this.router.transitionTo("vault.cluster.secrets.backend.metadata",this.args.model.id)}onSaveChanges(e){return e.preventDefault(),this.save()}onKeyUp(e,t){let n={}
if(t){if("customMetadata"===e){const l=/^[^\\]+$/g
t.match(l)||(n[e]={errors:["Custom values cannot contain a backward slash."],isValid:!1})}"maxVersions"===e&&(this.args.model.maxVersions=t,n=this.args.model.validate().state)}let l=0
for(const a in n)n[a].isValid||l++
this.modelValidations=n,this.validationErrorCount=l,this.args.updateValidationErrorCount&&this.args.updateValidationErrorCount(this.validationErrorCount)}},r=c(i.prototype,"router",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),o=c(i.prototype,"store",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=c(i.prototype,"validationErrorCount",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return 0}}),u=c(i.prototype,"modelValidations",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c(i.prototype,"onSaveChanges",[n.action],Object.getOwnPropertyDescriptor(i.prototype,"onSaveChanges"),i.prototype),c(i.prototype,"onKeyUp",[n.action],Object.getOwnPropertyDescriptor(i.prototype,"onKeyUp"),i.prototype),i)
e.default=p})),define("vault/components/secret-edit-toolbar",["exports","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","ember-concurrency","@ember/test-waiters"],(function(e,t,n,l,a,i,r){var o,s,u,d
function c(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function p(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let m=(o=class extends t.default{constructor(){super(...arguments),c(this,"store",s,this),c(this,"flashMessages",u,this),c(this,"wrappedData",d,this)}clearWrappedData(){this.wrappedData=null}*wrapSecret(){const{id:e}=this.args.modelForData,{backend:t}=this.args.model,n={wrapTTL:1800}
try{const l=yield this.args.isV2?this.store.adapterFor("secret-v2-version").queryRecord(e,n):this.store.adapterFor("secret").queryRecord(null,null,{backend:t,id:e,...n})
this.wrappedData=l.wrap_info.token,this.flashMessages.success("Secret successfully wrapped!")}catch(l){this.flashMessages.danger("Could not wrap secret.")}}},s=p(o.prototype,"store",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=p(o.prototype,"flashMessages",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=p(o.prototype,"wrappedData",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),p(o.prototype,"clearWrappedData",[n.action],Object.getOwnPropertyDescriptor(o.prototype,"clearWrappedData"),o.prototype),p(o.prototype,"wrapSecret",[i.task,r.waitFor],Object.getOwnPropertyDescriptor(o.prototype,"wrapSecret"),o.prototype),o)
e.default=m})),define("vault/components/secret-edit",["exports","@ember/service","@glimmer/component","@ember/object","@glimmer/tracking","vault/lib/kv-object","vault/macros/maybe-query-record","@ember/object/computed"],(function(e,t,n,l,a,i,r,o){var s,u,d,c,p,m,f,h,b,y,v,g,w,k,x,_,P,T,O,j,M,z
function S(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function C(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let A=(s=(0,r.maybeQueryRecord)("capabilities",(e=>{if(!e.args.model||"create"===e.args.mode)return
const t=e.isV2?e.args.model.engine.id:e.args.model.backend,n=e.args.model.id
return{id:e.isV2?`${t}/data/${n}`:`${t}/${n}`}}),"isV2","model","model.id","mode"),u=(0,o.alias)("checkSecretCapabilities.canUpdate"),d=(0,o.alias)("checkSecretCapabilities.canRead"),c=(0,r.maybeQueryRecord)("capabilities",(e=>{if(!e.args.model||!e.isV2)return
return{id:`${e.args.model.backend}/metadata/${e.args.model.id}`}}),"isV2","model","model.id","mode"),p=(0,o.alias)("checkMetadataCapabilities.canDelete"),m=(0,o.alias)("checkMetadataCapabilities.canUpdate"),f=(0,o.alias)("checkMetadataCapabilities.canRead"),h=(0,o.or)("model.isLoading","model.isReloading","model.isSaving"),b=(0,o.or)("requestInFlight","model.isFolder","model.flagsIsInvalid"),y=class extends n.default{constructor(){super(...arguments),S(this,"store",v,this),S(this,"secretData",g,this),S(this,"codemirrorString",w,this),S(this,"checkSecretCapabilities",k,this),S(this,"canUpdateSecretData",x,this),S(this,"canReadSecretData",_,this),S(this,"checkMetadataCapabilities",P,this),S(this,"canDeleteSecretMetadata",T,this),S(this,"canUpdateSecretMetadata",O,this),S(this,"canReadSecretMetadata",j,this),S(this,"requestInFlight",M,this),S(this,"buttonDisabled",z,this)}createKvData(e,t){let[n]=t
this.isV2&&(n.secretData=n.belongsTo("selectedVersion").value().secretData),this.secretData=i.default.create({content:[]}).fromJSON(n.secretData),this.codemirrorString=this.secretData.toJSONString()}get isV2(){return!!this.args.model?.selectedVersion}get modelForData(){const{model:e}=this.args
return e?this.isV2?e.belongsTo("selectedVersion").value():e:null}get basicModeDisabled(){return this.secretDataIsAdvanced||!1===this.showAdvancedMode}get secretDataAsJSON(){return this.secretData.toJSON()}get secretDataIsAdvanced(){return this.secretData.isAdvanced()}get showAdvancedMode(){return this.secretDataIsAdvanced||this.args.preferAdvancedEdit}get isWriteWithoutRead(){return!!this.args.model&&(!(!this.isV2||!this.modelForData.failedServerRead)||!(this.isV2||!this.args.model.failedServerRead))}refresh(){this.args.onRefresh()}toggleAdvanced(e){this.args.onToggleAdvancedEdit(e)}},v=C(y.prototype,"store",[t.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g=C(y.prototype,"secretData",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),w=C(y.prototype,"codemirrorString",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),C(y.prototype,"createKvData",[l.action],Object.getOwnPropertyDescriptor(y.prototype,"createKvData"),y.prototype),k=C(y.prototype,"checkSecretCapabilities",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=C(y.prototype,"canUpdateSecretData",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_=C(y.prototype,"canReadSecretData",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P=C(y.prototype,"checkMetadataCapabilities",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=C(y.prototype,"canDeleteSecretMetadata",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=C(y.prototype,"canUpdateSecretMetadata",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=C(y.prototype,"canReadSecretMetadata",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),M=C(y.prototype,"requestInFlight",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),z=C(y.prototype,"buttonDisabled",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),C(y.prototype,"refresh",[l.action],Object.getOwnPropertyDescriptor(y.prototype,"refresh"),y.prototype),C(y.prototype,"toggleAdvanced",[l.action],Object.getOwnPropertyDescriptor(y.prototype,"toggleAdvanced"),y.prototype),y)
e.default=A})),define("vault/components/secret-link",["exports","@glimmer/component","@ember/object","vault/utils/path-encoding-helpers"],(function(e,t,n,l){var a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(a=class extends t.default{get link(){const{mode:e,secret:t}=this.args,n=`vault.cluster.secrets.backend.${e}`
return"versions"!==e&&!t||" "===t?{route:`${n}-root`,models:[]}:{route:n,models:[(0,l.encodePath)(t)]}}get query(){const e=this.args.queryParams||{}
return e.isQueryParams?e.values:e}onLinkClick(){this.args.onLinkClick&&this.args.onLinkClick(...arguments)}},r=a.prototype,o="onLinkClick",s=[n.action],u=Object.getOwnPropertyDescriptor(a.prototype,"onLinkClick"),d=a.prototype,c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a)
var r,o,s,u,d,c
e.default=i}))
define("vault/components/secret-list-header-tab",["exports","core/components/secret-list-header-tab"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/secret-list-header",["exports","core/components/secret-list-header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/secret-list/database-list-item",["exports","@glimmer/component","@glimmer/tracking","@ember/service","@ember/object"],(function(e,t,n,l,a){var i,r,o,s
function u(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function d(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let c=(i=class extends t.default{constructor(){super(...arguments),u(this,"roleType",r,this),u(this,"store",o,this),u(this,"flashMessages",s,this)}get keyTypeValue(){const e=this.args.item
return"roles"===e.path?"dynamic":"static-roles"===e.path?"static":""}resetConnection(e){const{backend:t}=this.args.item
this.store.adapterFor("database/connection").resetConnection(t,e).then((()=>{this.flashMessages.success(`Success: ${e} connection was reset`)})).catch((e=>{this.flashMessages.danger(e.errors)}))}rotateRootCred(e){const{backend:t}=this.args.item
this.store.adapterFor("database/connection").rotateRootCredentials(t,e).then((()=>{this.flashMessages.success(`Success: ${e} connection was rotated`)})).catch((e=>{this.flashMessages.danger(e.errors)}))}rotateRoleCred(e){const{backend:t}=this.args.item
this.store.adapterFor("database/credential").rotateRoleCredentials(t,e).then((()=>{this.flashMessages.success(`Success: Credentials for ${e} role were rotated`)})).catch((e=>{this.flashMessages.danger(e.errors)}))}},r=d(i.prototype,"roleType",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),o=d(i.prototype,"store",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=d(i.prototype,"flashMessages",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d(i.prototype,"resetConnection",[a.action],Object.getOwnPropertyDescriptor(i.prototype,"resetConnection"),i.prototype),d(i.prototype,"rotateRootCred",[a.action],Object.getOwnPropertyDescriptor(i.prototype,"rotateRootCred"),i.prototype),d(i.prototype,"rotateRoleCred",[a.action],Object.getOwnPropertyDescriptor(i.prototype,"rotateRoleCred"),i.prototype),i)
e.default=c})),define("vault/components/secret-list/transform-list-item",["exports","@ember/object","@ember/component"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=n.default.extend({item:null,itemPath:"",itemType:"",isBuiltin:(0,t.computed)("item","itemType",(function(){const e=this.item
return("alphabet"===this.itemType||"template"===this.itemType)&&e.get("id").startsWith("builtin/")})),backendType:"transform"})
e.default=l})),define("vault/components/secret-version-menu",["exports","@glimmer/component","@ember/object","@ember/service","@ember/runloop"],(function(e,t,n,l,a){var i,r
function o(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let s=(i=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="router",l=this,(n=r)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}onRefresh(){}closeDropdown(e){(0,a.next)((()=>e.actions.close()))}},r=o(i.prototype,"router",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),o(i.prototype,"closeDropdown",[n.action],Object.getOwnPropertyDescriptor(i.prototype,"closeDropdown"),i.prototype),i)
e.default=s})),define("vault/components/secrets-engine-mount-config",["exports","core/components/secrets-engine-mount-config"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/section-tabs",["exports","@ember/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const n=t.default.extend({tagName:"",model:null,tabType:"authSettings"})
n.reopenClass({positionalParams:["model","tabType","paths"]})
var l=n
e.default=l})),define("vault/components/select",["exports","core/components/select"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/selectable-card",["exports","@glimmer/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{get gridContainer(){return this.args.gridContainer||!1}get total(){return this.args.total||0}}e.default=n})),define("vault/components/shamir-progress",["exports","@ember/component","@ember/object"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend({threshold:null,progress:null,classNames:["shamir-progress"],progressDecimal:(0,n.computed)("threshold","progress",(function(){const{threshold:e,progress:t}=this
return e&&t?t/e:0}))})
e.default=l})),define("vault/components/shamir/dr-token-flow",["exports","core/components/shamir/dr-token-flow"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/shamir/flow",["exports","core/components/shamir/flow"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/shamir/form",["exports","core/components/shamir/form"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/sidebar/frame",["exports","@ember/component","@ember/template-factory","@glimmer/component","@ember/service","@ember/controller"],(function(e,t,n,l,a,i){var r,o,s,u,d
function c(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function p(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const m=(0,n.createTemplateFactory)({id:"iWVKQn7c",block:'[[[8,[39,0],null,[["@hasSidebar","@hasHeader","@hasFooter"],[[30,1],false,false]],[["default"],[[[[1,"\\n  "],[8,[30,2,["Sidebar"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,[["@isResponsive","@hasA11yRefocus","@a11yRefocusSkipTo"],[true,true,"app-main-content"]],[["header","body","footer"],[[[[1,"\\n        "],[8,[39,2],null,null,[["logo","actions"],[[[[1,"\\n            "],[8,[39,3],null,[["@icon","@route","@model","@ariaLabel"],["vault","vault.cluster.dashboard",[30,0,["currentCluster","cluster","name"]],"home link"]],null],[1,"\\n          "]],[]],[[[1,"\\n            "],[8,[39,4],[[4,[38,5],["click",[28,[37,6],[[28,[37,7],[[30,0,["console","isOpen"]]],null],[28,[37,8],[[30,0,["console","isOpen"]]],null]],null]],null]],[["@icon","@ariaLabel"],["terminal-screen","Console toggle"]],null],[1,"\\n            "],[8,[39,9],null,null,null],[1,"\\n          "]],[]]]]],[1,"\\n      "]],[]],[[[1,"\\n        "],[8,[39,10],[[24,"aria-label","sidebar navigation links"]],null,null],[1,"\\n      "]],[]],[[[1,"\\n"],[41,[28,[37,12],["Namespaces"],null],[[[1,"          "],[8,[39,13],[[24,0,"hds-side-nav-hide-when-minimized"]],[["@namespace"],[[30,0,["clusterController","namespaceQueryParam"]]]],null],[1,"\\n"]],[]],null],[1,"      "]],[]]]]],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[30,2,["Main"]],[[24,1,"app-main-content"],[16,0,[52,[30,0,["console","isOpen"]],"main--console-open"]]],null,[["default"],[[[[1,"\\n"],[1,"    "],[10,0],[14,1,"modal-wormhole"],[12],[13],[1,"\\n    "],[8,[39,14],null,[["@status"],[[30,0,["currentCluster","cluster","hcpLinkStatus"]]]],null],[1,"\\n    "],[18,3,null],[1,"\\n    "],[10,0],[15,0,[52,[30,0,["console","isOpen"]],"panel-open"]],[12],[1,"\\n      "],[8,[39,16],null,[["@isFullscreen"],[[30,0,["consoleFullscreen"]]]],null],[1,"\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[2]]]]]],["@showSidebar","Frame","&default"],false,["hds/app-frame","hds/side-nav","hds/side-nav/header","hds/side-nav/header/home-link","hds/side-nav/header/icon-button","on","fn","mut","not","sidebar/user-menu","hds/side-nav/portal/target","if","has-feature","namespace-picker","link-status","yield","console/ui-panel"]]',moduleName:"vault/components/sidebar/frame.hbs",isStrictMode:!1})
let f=(r=(0,i.inject)("vault.cluster"),o=class extends l.default{constructor(){super(...arguments),c(this,"currentCluster",s,this),c(this,"console",u,this),c(this,"clusterController",d,this)}},s=p(o.prototype,"currentCluster",[a.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=p(o.prototype,"console",[a.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=p(o.prototype,"clusterController",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),o)
e.default=f,(0,t.setComponentTemplate)(m,f)})),define("vault/components/sidebar/nav/access",["exports","@ember/component","@ember/template-factory","@ember/component/template-only"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const a=(0,n.createTemplateFactory)({id:"K40BzJay",block:'[[[8,[39,0],null,[["@ariaLabel"],["Access Navigation Links"]],[["default"],[[[[1,"\\n  "],[8,[30,1,["BackLink"]],null,[["@route","@current-when","@icon","@text"],["vault.cluster",false,"arrow-left","Back to main navigation"]],null],[1,"\\n\\n"],[41,[28,[37,2],["access"],[["routeParams"],[[28,[37,3],["methods","mfa","oidc"],null]]]],[[[1,"    "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Authentication"]],[]]]]],[1,"\\n"]],[]],null],[41,[28,[37,2],["access"],[["routeParams"],["methods"]]],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@current-when","@text"],["vault.cluster.access.methods","vault.cluster.access.methods vault.cluster.access.method vault.cluster.settings.auth","Authentication Methods"]],null],[1,"\\n"]],[]],null],[41,[28,[37,2],["access"],[["routeParams"],["mfa"]]],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@current-when","@text"],["vault.cluster.access.mfa.methods","vault.cluster.access.mfa.methods vault.cluster.access.mfa.enforcements vault.cluster.access.mfa.index","Multi-Factor Authentication"]],null],[1,"\\n"]],[]],null],[41,[28,[37,2],["access"],[["routeParams"],["oidc"]]],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@text"],["vault.cluster.access.oidc","OIDC Provider"]],null],[1,"\\n"]],[]],null],[1,"\\n"],[41,[28,[37,4],[[28,[37,5],["Control Groups"],null],[28,[37,2],["access"],[["routeParams"],["control-groups"]]]],null],[[[1,"    "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Access Control"]],[]]]]],[1,"\\n    "],[8,[30,1,["Link"]],null,[["@route","@current-when","@text"],["vault.cluster.access.control-groups","vault.cluster.access.control-groups vault.cluster.access.control-group-accessor vault.cluster.access.control-groups-configure","Control Groups"]],null],[1,"\\n"]],[]],null],[1,"\\n"],[41,[28,[37,2],["access"],[["routeParams"],[[28,[37,3],["namespaces","groups","entities"],null]]]],[[[1,"    "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Organization"]],[]]]]],[1,"\\n"]],[]],null],[41,[28,[37,4],[[28,[37,5],["Namespaces"],null],[28,[37,2],["access"],[["routeParams"],["namespaces"]]]],null],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@text"],["vault.cluster.access.namespaces","Namespaces"]],null],[1,"\\n"]],[]],null],[41,[28,[37,2],["access"],[["routeParams"],["groups"]]],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@model","@text"],["vault.cluster.access.identity","groups","Groups"]],null],[1,"\\n"]],[]],null],[41,[28,[37,2],["access"],[["routeParams"],["entities"]]],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@model","@text"],["vault.cluster.access.identity","entities","Entities"]],null],[1,"\\n"]],[]],null],[1,"\\n"],[41,[28,[37,2],["access"],[["routeParams"],["leases"]]],[[[1,"    "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Administration"]],[]]]]],[1,"\\n    "],[8,[30,1,["Link"]],null,[["@route","@text"],["vault.cluster.access.leases","Leases"]],null],[1,"\\n"]],[]],null]],[1]]]]]],["Nav"],false,["hds/side-nav/portal","if","has-permission","array","and","has-feature"]]',moduleName:"vault/components/sidebar/nav/access.hbs",isStrictMode:!1})
var i=(0,t.setComponentTemplate)(a,(0,l.default)())
e.default=i})),define("vault/components/sidebar/nav/cluster",["exports","@ember/component","@ember/template-factory","@glimmer/component","@ember/service"],(function(e,t,n,l,a){var i,r,o,s,u
function d(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function c(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const p=(0,n.createTemplateFactory)({id:"NDa3fZ8d",block:'[[[8,[39,0],null,[["@ariaLabel"],["Cluster Navigation Links"]],[["default"],[[[[1,"\\n  "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Vault"]],[]]]]],[1,"\\n\\n  "],[8,[30,1,["Link"]],null,[["@route","@text"],["vault.cluster.dashboard","Dashboard"]],null],[1,"\\n  "],[8,[30,1,["Link"]],null,[["@route","@current-when","@text"],["vault.cluster.secrets","vault.cluster.secrets vault.cluster.settings.mount-secret-backend vault.cluster.settings.configure-secret-backend","Secrets Engines"]],null],[1,"\\n"],[41,[28,[37,2],["access"],null],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@models","@current-when","@text","@hasSubItems"],[[28,[37,3],[[28,[37,4],["access"],null],"route"],null],[28,[37,3],[[28,[37,4],["access"],null],"models"],null],"vault.cluster.access vault.cluster.settings.auth","Access",true]],null],[1,"\\n"]],[]],null],[41,[28,[37,2],["policies"],null],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@models","@text","@hasSubItems"],["vault.cluster.policies",[28,[37,3],[[28,[37,4],["policies"],null],"models"],null],"Policies",true]],null],[1,"\\n"]],[]],null],[41,[28,[37,2],["tools"],null],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@models","@text","@hasSubItems"],["vault.cluster.tools.tool",[28,[37,3],[[28,[37,4],["tools"],null],"models"],null],"Tools",true]],null],[1,"\\n"]],[]],null],[1,"\\n"],[41,[28,[37,5],[[30,0,["version","isEnterprise"]],[30,0,["namespace","inRootNamespace"]],[30,0,["cluster","anyReplicationEnabled"]],[28,[37,2],["status"],[["routeParams"],["replication"]]]],null],[[[1,"    "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Replication"]],[]]]]],[1,"\\n    "],[8,[30,1,["Link"]],null,[["@route","@model","@text"],["vault.cluster.replication.mode.index","dr","Disaster Recovery"]],null],[1,"\\n\\n"],[41,[28,[37,6],["Performance Replication"],null],[[[1,"      "],[8,[30,1,["Link"]],null,[["@route","@model","@text"],["vault.cluster.replication.mode.index","performance","Performance"]],null],[1,"\\n"]],[]],null]],[]],null],[1,"\\n"],[41,[28,[37,7],[[28,[37,5],[[30,0,["isRootNamespace"]],[28,[37,2],["status"],[["routeParams"],[[28,[37,8],["replication","raft","license","seal"],null]]]]],null],[28,[37,2],["clients"],[["routeParams"],["activity"]]]],null],[[[1,"    "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Monitoring"]],[]]]]],[1,"\\n"]],[]],null],[41,[28,[37,5],[[30,0,["version","isEnterprise"]],[30,0,["namespace","inRootNamespace"]],[28,[37,2],["status"],[["routeParams"],["replication"]]]],null],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@text"],["vault.cluster.replication.index","Replication"]],null],[1,"\\n"]],[]],null],[41,[28,[37,5],[[30,0,["cluster","usingRaft"]],[30,0,["isRootNamespace"]],[28,[37,2],["status"],[["routeParams"],["raft"]]]],null],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@model","@text"],["vault.cluster.storage",[30,0,["cluster","name"]],"Raft Storage"]],null],[1,"\\n"]],[]],null],[41,[28,[37,5],[[28,[37,2],["clients"],[["routeParams"],["activity"]]],[28,[37,9],[[30,0,["cluster","dr","isSecondary"]]],null]],null],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@text"],["vault.cluster.clients","Client Count"]],null],[1,"\\n"]],[]],null],[41,[28,[37,5],[[30,0,["version","features"]],[30,0,["isRootNamespace"]],[28,[37,2],["status"],[["routeParams"],["license"]]],[28,[37,9],[[30,0,["cluster","dr","isSecondary"]]],null]],null],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@model","@text"],["vault.cluster.license",[30,0,["cluster","name"]],"License"]],null],[1,"\\n"]],[]],null],[41,[28,[37,5],[[30,0,["isRootNamespace"]],[28,[37,2],["status"],[["routeParams"],["seal"]]],[28,[37,9],[[30,0,["cluster","dr","isSecondary"]]],null]],null],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@model","@text"],["vault.cluster.settings.seal",[30,0,["cluster","name"]],"Seal Vault"]],null],[1,"\\n"]],[]],null]],[1]]]]]],["Nav"],false,["hds/side-nav/portal","if","has-permission","get","route-params-for","and","has-feature","or","array","not"]]',moduleName:"vault/components/sidebar/nav/cluster.hbs",isStrictMode:!1})
let m=(i=class extends l.default{constructor(){super(...arguments),d(this,"currentCluster",r,this),d(this,"version",o,this),d(this,"auth",s,this),d(this,"namespace",u,this)}get cluster(){return this.currentCluster.cluster}get isRootNamespace(){return this.namespace.inRootNamespace&&!this.currentCluster.hasChrootNamespace}},r=c(i.prototype,"currentCluster",[a.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),o=c(i.prototype,"version",[a.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=c(i.prototype,"auth",[a.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=c(i.prototype,"namespace",[a.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),i)
e.default=m,(0,t.setComponentTemplate)(p,m)})),define("vault/components/sidebar/nav/policies",["exports","@ember/component","@ember/template-factory","@ember/component/template-only"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const a=(0,n.createTemplateFactory)({id:"d0Y4ZHuz",block:'[[[8,[39,0],null,[["@ariaLabel"],["Policies Navigation Links"]],[["default"],[[[[1,"\\n  "],[8,[30,1,["BackLink"]],null,[["@route","@current-when","@icon","@text"],["vault.cluster",false,"arrow-left","Back to main navigation"]],null],[1,"\\n\\n  "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Policies"]],[]]]]],[1,"\\n\\n"],[41,[28,[37,2],["policies"],[["routeParams"],["acl"]]],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@model","@current-when","@text"],["vault.cluster.policies","acl","vault.cluster.policies vault.cluster.policy","ACL Policies"]],null],[1,"\\n"]],[]],null],[41,[28,[37,3],[[28,[37,4],["Sentinel"],null],[28,[37,2],["policies"],[["routeParams"],["rgp"]]]],null],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@model","@current-when","@text"],["vault.cluster.policies","rgp","vault.cluster.policies vault.cluster.policy","Role-Governing Policies"]],null],[1,"\\n"]],[]],null],[41,[28,[37,3],[[28,[37,4],["Sentinel"],null],[28,[37,2],["policies"],[["routeParams"],["egp"]]]],null],[[[1,"    "],[8,[30,1,["Link"]],null,[["@route","@model","@current-when","@text"],["vault.cluster.policies","egp","vault.cluster.policies vault.cluster.policy","Endpoint Governing Policies"]],null],[1,"\\n"]],[]],null]],[1]]]]]],["Nav"],false,["hds/side-nav/portal","if","has-permission","and","has-feature"]]',moduleName:"vault/components/sidebar/nav/policies.hbs",isStrictMode:!1})
var i=(0,t.setComponentTemplate)(a,(0,l.default)())
e.default=i})),define("vault/components/sidebar/nav/tools",["exports","@ember/component","@ember/template-factory","@ember/component/template-only"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const a=(0,n.createTemplateFactory)({id:"/GY1/a+I",block:'[[[8,[39,0],null,[["@ariaLabel"],["Tools Navigation Links"]],[["default"],[[[[1,"\\n  "],[8,[30,1,["BackLink"]],null,[["@route","@current-when","@icon","@text"],["vault.cluster",false,"arrow-left","Back to main navigation"]],null],[1,"\\n\\n  "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Tools"]],[]]]]],[1,"\\n\\n"],[42,[28,[37,2],[[28,[37,2],[[28,[37,3],null,null]],null]],null],null,[[[41,[28,[37,5],["tools"],[["routeParams"],[[30,2]]]],[[[1,"      "],[8,[30,1,["Link"]],null,[["@route","@model","@text"],["vault.cluster.tools.tool",[30,2],[28,[37,6],[[30,2]],null]]],null],[1,"\\n"]],[]],null]],[2]],null],[1,"  "],[8,[30,1,["Link"]],null,[["@route","@text"],["vault.cluster.tools.open-api-explorer","API Explorer"]],null],[1,"\\n"]],[1]]]]]],["Nav","supportedAction"],false,["hds/side-nav/portal","each","-track-array","tools-actions","if","has-permission","capitalize"]]',moduleName:"vault/components/sidebar/nav/tools.hbs",isStrictMode:!1})
var i=(0,t.setComponentTemplate)(a,(0,l.default)())
e.default=i})),define("vault/components/sidebar/user-menu",["exports","@ember/component","@ember/template-factory","@glimmer/component","@ember/service","@ember/runloop","@ember/object","@glimmer/tracking"],(function(e,t,n,l,a,i,r,o){var s,u,d,c,p
function m(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function f(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const h=(0,n.createTemplateFactory)({id:"gS70zMDl",block:'[[[8,[39,0],[[24,0,"sidebar-user-menu"]],[["@horizontalPosition","@verticalPosition","@renderInPlace"],["right","below",true]],[["default"],[[[[1,"\\n  "],[8,[30,1,["Trigger"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,[["@icon","@ariaLabel"],["user","User menu"]],null],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["Content"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,2],null,null,[["default"],[[[[1,"\\n      "],[10,0],[14,0,"popup-menu-content"],[12],[1,"\\n        "],[10,0],[14,0,"box"],[12],[1,"\\n          "],[10,0],[14,0,"menu-label"],[12],[1,"\\n            "],[1,[28,[35,3],[[30,0,["auth","authData","displayName"]]],null]],[1,"\\n          "],[13],[1,"\\n          "],[10,"nav"],[14,0,"menu"],[12],[1,"\\n            "],[10,"ul"],[14,0,"menu-list"],[12],[1,"\\n"],[41,[30,0,["auth","allowExpiration"]],[[[1,"                "],[10,"li"],[14,0,"token-alert is-flex"],[12],[1,"\\n                  "],[10,1],[12],[8,[39,5],[[24,0,"has-text-highlight"]],[["@name"],["alert-triangle-fill"]],null],[13],[1,"\\n                  "],[10,1],[14,0,"is-size-8 has-text-semibold"],[12],[1,"\\n                    We\'ve stopped auto-renewing your token due to inactivity. It will expire on\\n                    "],[1,[28,[35,6],[[30,0,["auth","tokenExpirationDate"]],"MMMM do yyyy, h:mm:ss a"],null]],[1,".\\n                  "],[13],[1,"\\n                "],[13],[1,"\\n"]],[]],null],[41,[30,0,["hasEntityId"]],[[[1,"                "],[10,"li"],[14,0,"action"],[12],[1,"\\n                  "],[8,[39,7],null,[["@route"],["vault.cluster.mfa-setup"]],[["default"],[[[[1,"\\n                    Multi-factor authentication\\n                  "]],[]]]]],[1,"\\n                "],[13],[1,"\\n"]],[]],null],[1,"              "],[10,"li"],[14,0,"action"],[14,1,"container"],[12],[1,"\\n                "],[8,[39,8],[[24,0,"link"]],[["@clipboardText","@buttonType","@success","@container"],[[30,0,["auth","currentToken"]],"button",[28,[37,9],[[30,0],[28,[37,10],["Token copied!"],null]],null],"#container"]],[["default"],[[[[1,"\\n                  Copy token\\n                "]],[]]]]],[1,"\\n              "],[13],[1,"\\n"],[41,[28,[37,11],[[28,[37,12],null,[["interval"],[1000]]],[30,0,["auth","tokenExpirationDate"]]],null],[[[41,[30,0,["auth","authData","renewable"]],[[[1,"                  "],[10,"li"],[14,0,"action"],[12],[1,"\\n                    "],[11,"button"],[16,0,[29,["link button ",[52,[30,0,["isRenewing"]],"is-loading"]]]],[24,4,"button"],[4,[38,13],["click",[30,0,["renewToken"]]],null],[12],[1,"\\n                      Renew token\\n                    "],[13],[1,"\\n                  "],[13],[1,"\\n"]],[]],null],[1,"                "],[10,"li"],[14,0,"action"],[12],[1,"\\n                  "],[8,[30,2,["Message"]],null,[["@id","@title","@onConfirm","@message","@triggerText","@confirmButtonText"],[[28,[37,14],[[30,0,["auth"]],"authData.displayName"],null],[28,[37,15],["Revoke ",[28,[37,14],[[30,0,["auth"]],"authData.displayName"],null],"?"],null],[28,[37,9],[[30,0],"revokeToken"],null],"You will not be able to log in again with this token.","Revoke token","Revoke"]],null],[1,"\\n                "],[13],[1,"\\n"]],[]],null],[1,"              "],[10,"li"],[14,0,"action"],[12],[1,"\\n                "],[8,[39,7],[[24,1,"logout"]],[["@route","@model"],["vault.cluster.logout",[30,0,["currentCluster","cluster","name"]]]],[["default"],[[[[1,"\\n                  Log out\\n                "]],[]]]]],[1,"\\n              "],[13],[1,"\\n            "],[13],[1,"\\n          "],[13],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n    "]],[2]]]]],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]]],["Dropdown","c"],false,["basic-dropdown","hds/side-nav/header/icon-button","confirm","capitalize","if","icon","date-format","link-to","copy-button","action","set-flash-message","is-before","now","on","get","concat"]]',moduleName:"vault/components/sidebar/user-menu.hbs",isStrictMode:!1})
let b=(s=class extends l.default{constructor(){super(...arguments),m(this,"auth",u,this),m(this,"currentCluster",d,this),m(this,"router",c,this),m(this,"fakeRenew",p,this)}get hasEntityId(){return!!this.auth.authData?.entity_id}get isRenewing(){return this.fakeRenew||this.auth.isRenewing}transitionToRoute(){this.router.transitionTo(...arguments)}renewToken(){this.fakeRenew=!0,(0,i.later)((()=>{this.auth.renew().then((()=>{this.fakeRenew=this.auth.isRenewing}))}),200)}revokeToken(){this.auth.revokeCurrentToken().then((()=>{this.transitionToRoute("vault.cluster.logout")}))}},u=f(s.prototype,"auth",[a.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=f(s.prototype,"currentCluster",[a.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=f(s.prototype,"router",[a.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=f(s.prototype,"fakeRenew",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),f(s.prototype,"renewToken",[r.action],Object.getOwnPropertyDescriptor(s.prototype,"renewToken"),s.prototype),f(s.prototype,"revokeToken",[r.action],Object.getOwnPropertyDescriptor(s.prototype,"revokeToken"),s.prototype),s)
e.default=b,(0,t.setComponentTemplate)(h,b)})),define("vault/components/splash-page",["exports","@glimmer/component","@ember/service"],(function(e,t,n){var l,a,i,r
function o(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function s(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let u=(l=class extends t.default{constructor(){super(...arguments),o(this,"version",a,this),o(this,"auth",i,this),o(this,"store",r,this)}get showTruncatedNavBar(){return!1!==this.args.showTruncatedNavBar}},a=s(l.prototype,"version",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),i=s(l.prototype,"auth",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),r=s(l.prototype,"store",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),l)
e.default=u})),define("vault/components/splash-page/splash-content",["exports","@ember/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({tagName:""})
e.default=n})),define("vault/components/splash-page/splash-footer",["exports","@ember/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({tagName:""})
e.default=n})),define("vault/components/splash-page/splash-header",["exports","@ember/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({tagName:""})
e.default=n})),define("vault/components/stat-text",["exports","core/components/stat-text"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/string-list",["exports","core/components/string-list"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/text-file",["exports","core/components/text-file"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/toggle-button",["exports","core/components/toggle-button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/toggle",["exports","core/components/toggle"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/token-expire-warning",["exports","@ember/component","@ember/template-factory","@glimmer/component","@ember/service","@glimmer/tracking","@ember/runloop","ember-concurrency"],(function(e,t,n,l,a,i,r,o){var s,u,d,c
function p(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function m(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const f=(0,n.createTemplateFactory)({id:"uhMw8mQF",block:'[[[41,[28,[37,1],[[30,0,["showWarning"]],[28,[37,2],[[28,[37,3],null,[["interval"],[1000]]],[30,1]],null]],null],[[[1,"  "],[8,[39,4],null,[["@type","@color"],["page","critical"]],[["default"],[[[[1,"\\n    "],[8,[30,2,["Title"]],null,null,[["default"],[[[[1,"Error"]],[]]]]],[1,"\\n    "],[8,[30,2,["Description"]],null,null,[["default"],[[[[1,"\\n      Your auth token expired on\\n      "],[1,[28,[35,5],[[30,1],"MMMM do yyyy, h:mm:ss a"],null]],[1,". You will need to re-authenticate.\\n    "]],[]]]]],[1,"\\n    "],[8,[30,2,["Link::Standalone"]],null,[["@icon","@iconPosition","@text","@route","@query"],["arrow-right","trailing","Reauthenticate","vault.cluster.logout",[30,0,["queryParams"]]]],null],[1,"\\n  "]],[2]]]]],[1,"\\n"]],[]],[[[1,"  "],[10,"section"],[14,0,"section"],[12],[1,"\\n    "],[10,0],[14,0,"container is-widescreen"],[12],[1,"\\n"],[41,[28,[37,1],[[30,0,["showWarning"]],[30,3],[30,0,["canDismiss"]]],null],[[[1,"        "],[8,[39,4],[[24,0,"has-top-margin-s"]],[["@type","@color","@onDismiss"],["inline","warning",[28,[37,6],[[28,[37,7],[[30,0,["canDismiss"]]],null],false],null]]],[["default"],[[[[1,"\\n          "],[8,[30,4,["Title"]],null,null,[["default"],[[[[1,"Session will expire"]],[]]]]],[1,"\\n          "],[8,[30,4,["Description"]],null,null,[["default"],[[[[1,"\\n            We\'ve stopped auto-renewing your token due to inactivity. It will expire in\\n            "],[1,[28,[35,8],[[30,1]],null]],[1,"\\n            on\\n            "],[1,[28,[35,5],[[30,1],"MMMM do yyyy, h:mm:ss a O"],null]],[1,".\\n          "]],[]]]]],[1,"\\n          "],[8,[30,4,["Button"]],[[16,"disabled",[30,0,["renewToken","isRunning"]]],[4,[38,9],["click",[28,[37,10],[[30,0,["renewToken"]]],null]],null]],[["@text","@color","@icon","@iconPosition"],["Renew token","secondary",[52,[30,0,["renewToken","isRunning"]],"loading","reload"],"trailing"]],null],[1,"\\n          "],[8,[30,4,["Link::Standalone"]],null,[["@icon","@iconPosition","@color","@text","@route"],["arrow-right","trailing","secondary","Log out","vault.cluster.logout"]],null],[1,"\\n        "]],[4]]]]],[1,"\\n"]],[]],null],[1,"      "],[18,5,null],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]]]],["@expirationDate","A","@allowingExpiration","A","&default"],false,["if","and","is-after","now","hds/alert","date-format","fn","mut","date-from-now","on","perform","yield"]]',moduleName:"vault/components/token-expire-warning.hbs",isStrictMode:!1})
let h=(s=class extends l.default{constructor(){super(...arguments),p(this,"auth",u,this),p(this,"router",d,this),p(this,"canDismiss",c,this)}handleRenew(){return new Promise((e=>{(0,r.later)((()=>{this.auth.renew().then((()=>{this.auth.setLastFetch(Date.now())})).finally((()=>{e()}))}),200)}))}*renewToken(){yield this.handleRenew()}get queryParams(){return{redirect_to:this.router.currentURL}}get showWarning(){return"vault.cluster.oidc-provider"!==this.router.currentRouteName&&!!this.args.expirationDate}},u=m(s.prototype,"auth",[a.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=m(s.prototype,"router",[a.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=m(s.prototype,"canDismiss",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!0}}),m(s.prototype,"renewToken",[o.task],Object.getOwnPropertyDescriptor(s.prototype,"renewToken"),s.prototype),s)
e.default=h,(0,t.setComponentTemplate)(f,h)})),define("vault/components/tool-actions-form",["exports","@ember/object/computed","@ember/polyfills","@ember/service","@ember/component","@ember/object","date-fns","@ember/array"],(function(e,t,n,l,a,i,r,o){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const s={token:null,rewrap_token:null,errors:(0,o.A)(),wrap_info:null,creation_time:null,creation_ttl:null,data:"{\n}",unwrap_data:null,details:null,wrapTTL:null,sum:null,random_bytes:null,input:null},u=["lookup","wrap","unwrap","rewrap"]
var d=a.default.extend(s,{store:(0,l.inject)(),bytes:32,format:"base64",algorithm:"sha2-256",tagName:"",unwrapActiveTab:"data",didReceiveAttrs(){this._super(...arguments),this.checkAction()},selectedAction:null,reset(){this.isDestroyed||this.isDestroying||(0,i.setProperties)(this,s)},checkAction(){const e=this.selectedAction
e!==this.oldSelectedAction&&this.reset(),(0,i.set)(this,"oldSelectedAction",e)},dataIsEmpty:(0,t.match)("data",new RegExp(s.data)),expirationDate:(0,i.computed)("creation_time","creation_ttl",(function(){const{creation_time:e,creation_ttl:t}=this
return e&&t?(0,r.addSeconds)((0,r.parseISO)(e),t):null})),handleError(e){(0,i.set)(this,"errors",e.errors)},handleSuccess(e,t){let l={}
const a=e&&e.data||e.auth
if(a&&"unwrap"===t){const t={"Request ID":e.request_id,"Lease ID":e.lease_id||"None",Renewable:e.renewable?"Yes":"No","Lease Duration":e.lease_duration||"None"}
l=(0,n.assign)({},l,{unwrap_data:a},{details:t})}if(l=(0,n.assign)({},l,a),e&&e.wrap_info){const a="rewrap"===t?"rewrap_token":"token"
l=(0,n.assign)({},l,{[a]:e.wrap_info.token})}(0,i.setProperties)(this,l)},getData(){const e=this.selectedAction
return u.includes(e)?this.dataIsEmpty?{token:(this.token||"").trim()}:JSON.parse(this.data):"random"===e?{bytes:this.bytes,format:this.format}:"hash"===e?{input:this.input,format:this.format,algorithm:this.algorithm}:void 0},actions:{doSubmit(e){var t=this
e.preventDefault()
const n=this.selectedAction,l="wrap"===n?this.wrapTTL:null,a=this.getData();(0,i.setProperties)(this,{errors:null,wrap_info:null,creation_time:null,creation_ttl:null}),this.store.adapterFor("tools").toolAction(n,a,{wrapTTL:l}).then((e=>this.handleSuccess(e,n)),(function(){return t.handleError(...arguments)}))},onClear(){this.reset()},updateTtl(e){(0,i.set)(this,"wrapTTL",e)},codemirrorUpdated(e,t){(0,i.setProperties)(this,{buttonDisabled:t,data:e})}}})
e.default=d}))
define("vault/components/tool-hash",["exports","@glimmer/component","@ember/object"],(function(e,t,n){var l
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let a=(l=class extends t.default{onClear(){this.args.onClear()}},i=l.prototype,r="onClear",o=[n.action],s=Object.getOwnPropertyDescriptor(l.prototype,"onClear"),u=l.prototype,d={},Object.keys(s).forEach((function(e){d[e]=s[e]})),d.enumerable=!!d.enumerable,d.configurable=!!d.configurable,("value"in d||d.initializer)&&(d.writable=!0),d=o.slice().reverse().reduce((function(e,t){return t(i,r,e)||e}),d),u&&void 0!==d.initializer&&(d.value=d.initializer?d.initializer.call(u):void 0,d.initializer=void 0),void 0===d.initializer&&(Object.defineProperty(i,r,d),d=null),l)
var i,r,o,s,u,d
e.default=a})),define("vault/components/tool-lookup",["exports","@glimmer/component","@ember/object"],(function(e,t,n){var l
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let a=(l=class extends t.default{onClear(){this.args.onClear()}},i=l.prototype,r="onClear",o=[n.action],s=Object.getOwnPropertyDescriptor(l.prototype,"onClear"),u=l.prototype,d={},Object.keys(s).forEach((function(e){d[e]=s[e]})),d.enumerable=!!d.enumerable,d.configurable=!!d.configurable,("value"in d||d.initializer)&&(d.writable=!0),d=o.slice().reverse().reduce((function(e,t){return t(i,r,e)||e}),d),u&&void 0!==d.initializer&&(d.value=d.initializer?d.initializer.call(u):void 0,d.initializer=void 0),void 0===d.initializer&&(Object.defineProperty(i,r,d),d=null),l)
var i,r,o,s,u,d
e.default=a})),define("vault/components/tool-random",["exports","@glimmer/component","@ember/object"],(function(e,t,n){var l
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let a=(l=class extends t.default{onClear(){this.args.onClear()}},i=l.prototype,r="onClear",o=[n.action],s=Object.getOwnPropertyDescriptor(l.prototype,"onClear"),u=l.prototype,d={},Object.keys(s).forEach((function(e){d[e]=s[e]})),d.enumerable=!!d.enumerable,d.configurable=!!d.configurable,("value"in d||d.initializer)&&(d.writable=!0),d=o.slice().reverse().reduce((function(e,t){return t(i,r,e)||e}),d),u&&void 0!==d.initializer&&(d.value=d.initializer?d.initializer.call(u):void 0,d.initializer=void 0),void 0===d.initializer&&(Object.defineProperty(i,r,d),d=null),l)
var i,r,o,s,u,d
e.default=a})),define("vault/components/tool-rewrap",["exports","@glimmer/component","@ember/object"],(function(e,t,n){var l
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let a=(l=class extends t.default{onClear(){this.args.onClear()}},i=l.prototype,r="onClear",o=[n.action],s=Object.getOwnPropertyDescriptor(l.prototype,"onClear"),u=l.prototype,d={},Object.keys(s).forEach((function(e){d[e]=s[e]})),d.enumerable=!!d.enumerable,d.configurable=!!d.configurable,("value"in d||d.initializer)&&(d.writable=!0),d=o.slice().reverse().reduce((function(e,t){return t(i,r,e)||e}),d),u&&void 0!==d.initializer&&(d.value=d.initializer?d.initializer.call(u):void 0,d.initializer=void 0),void 0===d.initializer&&(Object.defineProperty(i,r,d),d=null),l)
var i,r,o,s,u,d
e.default=a})),define("vault/components/tool-tip",["exports","core/components/tool-tip"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/tool-unwrap",["exports","@glimmer/component","@ember/object"],(function(e,t,n){var l
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let a=(l=class extends t.default{onClear(){this.args.onClear()}},i=l.prototype,r="onClear",o=[n.action],s=Object.getOwnPropertyDescriptor(l.prototype,"onClear"),u=l.prototype,d={},Object.keys(s).forEach((function(e){d[e]=s[e]})),d.enumerable=!!d.enumerable,d.configurable=!!d.configurable,("value"in d||d.initializer)&&(d.writable=!0),d=o.slice().reverse().reduce((function(e,t){return t(i,r,e)||e}),d),u&&void 0!==d.initializer&&(d.value=d.initializer?d.initializer.call(u):void 0,d.initializer=void 0),void 0===d.initializer&&(Object.defineProperty(i,r,d),d=null),l)
var i,r,o,s,u,d
e.default=a})),define("vault/components/tool-wrap",["exports","@glimmer/component","@ember/object","@glimmer/tracking"],(function(e,t,n,l){var a,i,r
function o(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function s(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let u=(a=class extends t.default{constructor(){super(...arguments),o(this,"data",i,this),o(this,"buttonDisabled",r,this)}onClear(){this.args.onClear()}updateTtl(e){if(!e)return
const t=e.enabled?`${e.seconds}s`:"30m"
this.args.updateTtl(t)}codemirrorUpdated(e,t){t.performLint()
const n=t?.state.lint.marked?.length>0
this.data=e,this.buttonDisabled=n,this.args.codemirrorUpdated(e,n)}},i=s(a.prototype,"data",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return"{\n}"}}),r=s(a.prototype,"buttonDisabled",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),s(a.prototype,"onClear",[n.action],Object.getOwnPropertyDescriptor(a.prototype,"onClear"),a.prototype),s(a.prototype,"updateTtl",[n.action],Object.getOwnPropertyDescriptor(a.prototype,"updateTtl"),a.prototype),s(a.prototype,"codemirrorUpdated",[n.action],Object.getOwnPropertyDescriptor(a.prototype,"codemirrorUpdated"),a.prototype),a)
e.default=u})),define("vault/components/toolbar-actions",["exports","core/components/toolbar-actions"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/toolbar-filters",["exports","core/components/toolbar-filters"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/toolbar-link",["exports","core/components/toolbar-link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/toolbar-secret-link",["exports","@glimmer/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{get glyph(){return"add"===this.args.type?"plus":"chevron-right"}}e.default=n})),define("vault/components/toolbar",["exports","core/components/toolbar"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/transform-advanced-templating",["exports","@glimmer/component","@glimmer/tracking","@ember/object"],(function(e,t,n,l){var a,i
function r(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let o=(a=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="inputOptions",l=this,(n=i)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}setInputOptions(e,t){t&&t.length?this.inputOptions=t.map((e=>{let{position:t,value:n}=e
return{label:`${t}: ${n}`,value:t}})):this.inputOptions=[]}decodeFormatValueChange(e,t,n){(0,l.set)(e,"value",n),this.args.model.decodeFormats=t.toJSON()}},i=r(a.prototype,"inputOptions",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return[]}}),r(a.prototype,"setInputOptions",[l.action],Object.getOwnPropertyDescriptor(a.prototype,"setInputOptions"),a.prototype),r(a.prototype,"decodeFormatValueChange",[l.action],Object.getOwnPropertyDescriptor(a.prototype,"decodeFormatValueChange"),a.prototype),a)
e.default=o})),define("vault/components/transform-create-form",["exports","vault/components/transformation-edit"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({})
e.default=n})),define("vault/components/transform-edit-base",["exports","@ember/service","@ember/object/computed","@ember/utils","@ember/component","@ember/object","vault/mixins/focus-on-insert"],(function(e,t,n,l,a,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.removeFromList=e.default=e.addToList=void 0
e.addToList=(e,t)=>e&&Array.isArray(e)?(e.push(t),e.uniq()):e
e.removeFromList=(e,t)=>{if(!e)return e
const n=e.indexOf(t)
if(n<0)return e
return e.removeAt(n,1).uniq()}
var o=a.default.extend(r.default,{store:(0,t.inject)(),flashMessages:(0,t.inject)(),router:(0,t.inject)(),mode:null,onDataChange(){},onRefresh(){},model:null,requestInFlight:(0,n.or)("model.isLoading","model.isReloading","model.isSaving"),init(){this._super(...arguments),this.set("backendType","transform")},willDestroyElement(){this.model&&this.model.isError&&!this.model.isDestroyed&&!this.model.isDestroying&&this.model.rollbackAttributes(),this._super(...arguments)},transitionToRoute(){this.router.transitionTo(...arguments)},modelPrefixFromType(e){let t=""
return e&&e.startsWith("transform/")&&(t=`${e.replace("transform/","")}/`),t},listTabFromType(e){let t
return e&&e.startsWith("transform/")&&(t=`${e.replace("transform/","")}`),t},persist(e,t){const n=this.model
return n[e]().then((()=>{t(n)})).catch((e=>{throw n.set("displayErrors",e.errors),e}))},applyDelete(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:()=>{}
const t=this.listTabFromType(this.model.constructor.modelName)
this.persist("destroyRecord",(()=>{this.hasDataChanges(),e(),this.transitionToRoute("vault.cluster.secrets.backend.list-root",{queryParams:{tab:t}})}))},applyChanges(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:()=>{}
const n=this.model.id||this.model.name,a=this.modelPrefixFromType(this.model.constructor.modelName)
"create"===e&&(0,l.isBlank)(n)||this.persist("save",(()=>{this.hasDataChanges(),t(),this.transitionToRoute("vault.cluster.secrets.backend.show",`${a}${n}`)}))},hasDataChanges(){this.onDataChange(this.model?.hasDirtyAttributes)},actions:{createOrUpdate(e,t){t.preventDefault(),this.applyChanges(e)},setValue(e,t){(0,i.set)(this.model,e,t.target.checked)},refresh(){this.onRefresh()},delete(){this.applyDelete()}}})
e.default=o})),define("vault/components/transform-edit-form",["exports","vault/components/transformation-edit"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({})
e.default=n})),define("vault/components/transform-role-edit",["exports","vault/components/transform-edit-base","@ember/service"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend({flashMessages:(0,n.inject)(),store:(0,n.inject)(),initialTransformations:null,init(){this._super(...arguments),this.set("initialTransformations",this.model.transformations)},handleUpdateTransformations(e,n){let l=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"update"
if(!e)return
const a=this.model.backend,i=e.map((e=>this.store.queryRecord("transform",{backend:a,id:e.id}).then((function(l){let i=l.allowed_roles
return"ADD"===e.action?i=(0,t.addToList)(i,n):"REMOVE"===e.action&&(i=(0,t.removeFromList)(i,n)),l.setProperties({backend:a,allowed_roles:i}),l.save().catch((t=>({errorStatus:t.httpStatus,...e})))}))))
Promise.all(i).then((e=>{if(e.find((e=>!!e.errorStatus))){const t=e.find((e=>403===e.errorStatus&&"ADD"===e.action)),n=e.find((e=>403===e.errorStatus&&"REMOVE"===e.action))
let a="The edits to this role were successful, but allowed_roles for its transformations was not edited due to a lack of permissions."
"create"===l?a="Transformations have been attached to this role, but the role was not added to those transformations’ allowed_roles due to a lack of permissions.":t&&n?a="This role was edited to both add and remove transformations; however, this role was not added or removed from those transformations’ allowed_roles due to a lack of permissions.":t?a="This role was edited to include new transformations, but this role was not added to those transformations’ allowed_roles due to a lack of permissions.":n&&(a="This role was edited to remove transformations, but this role was not removed from those transformations’ allowed_roles due to a lack of permissions."),this.flashMessages.info(a,{sticky:!0,priority:300})}}))},actions:{createOrUpdate(e,t){t.preventDefault(),this.applyChanges("save",(()=>{const t=this.model.id,n=this.model.transformations
if(!this.initialTransformations)return void this.handleUpdateTransformations(n.map((e=>({id:e,action:"ADD"}))),t,e)
const l=[...n,...this.initialTransformations].map((e=>this.initialTransformations.indexOf(e)<0?{id:e,action:"ADD"}:n.indexOf(e)<0?{id:e,action:"REMOVE"}:null)).filter((e=>!!e))
this.handleUpdateTransformations(l,t)}))},delete(){const e=this.model?.id,t=(this.model?.transformations||[]).map((e=>({id:e,action:"REMOVE"})))
this.handleUpdateTransformations(t,e),this.applyDelete()}}})
e.default=l})),define("vault/components/transform-show-transformation",["exports","vault/components/transform-edit-base","@ember/object"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend({cliCommand:(0,n.computed)("model.{allowed_roles,type,tweak_source}",(function(){if(!this.model)return
const{type:e,allowed_roles:t,tweak_source:n,name:l}=this.model,a=t.find((e=>e.includes("*")))
let i="<choose a role>"
let r=""
return 1!==t.length||a||(i=t[0]),"fpe"===e&&"supplied"===n&&(r="tweak=<enter your tweak>"),`${i} value=<enter your value here> ${r} transformation=${l}`}))})
e.default=l})),define("vault/components/transform-template-edit",["exports","vault/components/transform-edit-base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({})
e.default=n})),define("vault/components/transformation-edit",["exports","vault/components/transform-edit-base","@ember/service"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend({flashMessages:(0,n.inject)(),store:(0,n.inject)(),initialRoles:null,init(){this._super(...arguments),this.model&&this.set("initialRoles",this.model.allowed_roles)},updateOrCreateRole(e,n,l){return this.store.queryRecord("transform/role",{backend:l,id:e.id}).then((a=>{let i=a.transformations
return"ADD"===e.action?i=(0,t.addToList)(i,n):"REMOVE"===e.action&&(i=(0,t.removeFromList)(i,n)),a.setProperties({backend:l,transformations:i}),a.save().catch((t=>({errorStatus:t.httpStatus,...e})))})).catch((t=>403!==t.httpStatus&&"ADD"===e.action?this.store.createRecord("transform/role",{id:e.id,name:e.id,transformations:[n],backend:l}).save().catch((t=>({errorStatus:t.httpStatus,...e,action:"CREATE"}))):{...e,errorStatus:t.httpStatus}))},handleUpdateRoles(e,t){if(!e)return
const n=this.model.backend,l=e.map((e=>this.updateOrCreateRole(e,t,n)))
Promise.all(l).then((e=>{if(e.find((e=>!!e.errorStatus))){let t="The edits to this transformation were successful, but transformations for its roles was not edited due to a lack of permissions."
e.find((e=>!!e.errorStatus&&403!==e.errorStatus))&&(t="You've edited the allowed_roles for this transformation. However, the corresponding edits to some roles' transformations were not made"),this.flashMessages.info(t,{sticky:!0,priority:300})}}))},isWildcard:e=>"string"==typeof e?e.indexOf("*")>=0:!(!e||!e.id)&&e.id.indexOf("*")>=0,actions:{createOrUpdate(e,t){t.preventDefault(),this.applyChanges("save",(()=>{const e=this.model.id||this.model.name,t=this.model.allowed_roles||[],n=this.initialRoles||[],l=[...t,...n].filter((e=>!this.isWildcard(e))).map((e=>n.indexOf(e)<0?{id:e,action:"ADD"}:t.indexOf(e)<0?{id:e,action:"REMOVE"}:null)).filter((e=>!!e))
this.handleUpdateRoles(l,e)}))}}})
e.default=l})),define("vault/components/transit-edit",["exports","@ember/service","@ember/object/computed","@ember/utils","@ember/component","ember-concurrency","@ember/object","vault/mixins/focus-on-insert","core/utils/key-codes"],(function(e,t,n,l,a,i,r,o,s){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const u="vault.cluster.secrets.backend.list-root"
var d=a.default.extend(o.default,{router:(0,t.inject)(),mode:null,onDataChange(){},onRefresh(){},key:null,autoRotateInvalid:!1,requestInFlight:(0,n.or)("key.isLoading","key.isReloading","key.isSaving"),willDestroyElement(){this.key&&this.key.isError&&!this.key.isDestroyed&&!this.key.isDestroying&&this.key.rollbackAttributes(),this._super(...arguments)},waitForKeyUp:(0,i.task)((function*(){for(;;){const e=yield(0,i.waitForEvent)(document.body,"keyup")
this.onEscape(e)}})).on("didInsertElement").cancelOn("willDestroyElement"),transitionToRoute(){this.router.transitionTo(...arguments)},onEscape(e){e.keyCode===s.default.ESC&&"show"===this.mode&&this.transitionToRoute(u)},hasDataChanges(){this.onDataChange(this.key.hasDirtyAttributes)},persistKey(e,t){const n=this.key
return n[e]().then((()=>{n.isError||t(n)}))},actions:{createOrUpdateKey(e,t){t.preventDefault()
const n=this.key.id||this.key.name
"create"===e&&(0,l.isBlank)(n)||this.persistKey("save",(()=>{this.hasDataChanges(),this.transitionToRoute("vault.cluster.secrets.backend.show",n)}),"create"===e)},setValueOnKey(e,t){(0,r.set)(this.key,e,t.target.checked)},handleAutoRotateChange(e){e.enabled?((0,r.set)(this.key,"autoRotatePeriod",e.goSafeTimeString),this.set("autoRotateInvalid",e.seconds<3600)):(0,r.set)(this.key,"autoRotatePeriod",0)},derivedChange(e){this.key.setDerived(e)},convergentEncryptionChange(e){this.key.setConvergentEncryption(e)},refresh(){this.onRefresh()},deleteKey(){this.persistKey("destroyRecord",(()=>{this.hasDataChanges(),this.transitionToRoute(u)}))}}})
e.default=d})),define("vault/components/transit-key-action/export",["exports","@glimmer/component","@glimmer/tracking"],(function(e,t,n){var l,a,i
function r(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function o(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let s=(l=class extends t.default{constructor(){super(...arguments),r(this,"wrapTTL",a,this),r(this,"exportVersion",i,this)}},a=o(l.prototype,"wrapTTL",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),i=o(l.prototype,"exportVersion",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),l)
e.default=s})),define("vault/components/transit-key-actions",["exports","@ember/polyfills","ember-copy","@ember/debug","@ember/service","@ember/component","@ember/object","vault/utils/b64"],(function(e,t,n,l,a,i,r,o){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const s={hash_algorithm:"sha2-256",algorithm:"sha2-256",signature_algorithm:"pss",bits:256,bytes:32,ciphertext:null,context:null,format:"base64",hmac:null,input:null,key_version:0,keys:null,nonce:null,param:"wrapped",prehashed:!1,plaintext:null,random_bytes:null,signature:null,sum:null,encodedBase64:!1,exportKeyType:null,exportKeyVersion:null,wrappedToken:null,valid:null,plaintextOriginal:null,didDecode:!1,verification:"Signature"},u={sign:["input","hash_algorithm","key_version","prehashed","signature_algorithm"],verify:["input","hmac","signature","hash_algorithm","prehashed"],hmac:["input","algorithm","key_version"],encrypt:["plaintext","context","nonce","key_version"],decrypt:["ciphertext","context","nonce"],rewrap:["ciphertext","context","nonce","key_version"]},d={sign:"Signed your data",hmac:"Created your hash output",encrypt:"Created a wrapped token for your data",decrypt:"Decrypted the data from your token",rewrap:"Created a new token for your data",datakey:"Generated your key",export:"Exported your key"}
var c=i.default.extend(s,{store:(0,a.inject)(),flashMessages:(0,a.inject)(),selectedAction:null,key:null,isModalActive:!1,onRefresh(){},init(){this._super(...arguments),this.selectedAction||(0,r.set)(this,"selectedAction",(0,r.get)(this,"key.supportedActions.firstObject"))},didReceiveAttrs(){this._super(...arguments),this.checkAction(),"export"===this.selectedAction&&this.setExportKeyDefaults()},setExportKeyDefaults(){const e=this.key.exportKeyTypes.firstObject,t=this.key.validKeyVersions.lastObject
this.setProperties({exportKeyType:e,exportKeyVersion:t})},keyIsRSA:(0,r.computed)("key.type",(function(){const e=this.key.type
return"rsa-2048"===e||"rsa-3072"===e||"rsa-4096"===e})),getModelInfo(){const e=this.key||this.backend
if(!e)return null
return{backend:e.backend||e.id,id:e.id}},checkAction(){const e=this.selectedAction,t=this.oldSelectedAction
this.resetParams(t,e),(0,r.set)(this,"oldSelectedAction",e)},resetParams(e,t){const l=(0,n.copy)(s)
let a
!(!e||"datakey"===e||"rewrap"===e&&!this.key.supportsEncryption)&&t&&(a=u[t]),a&&a.forEach((e=>delete l[e])),this.clearErrors(),this.setProperties(l),"export"===t&&this.setExportKeyDefaults()},handleError(e){this.set("errors",e.errors)},clearErrors(){this.set("errors",null)},triggerSuccessMessage(e){const t=d[e]
t&&this.flashMessages.success(t)},handleSuccess(e,n,l){let a={}
if(e&&e.data){if("export"===l&&e.data.keys){const{keys:t,type:n,name:l}=e.data
e.data.keys={keys:t,type:n,name:l}}a=(0,t.assign)({},a,e.data)}n.wrapTTL&&(a=(0,t.assign)({},a,{wrappedToken:e.wrap_info.token})),this.isDestroyed||this.isDestroying||(this.toggleProperty("isModalActive"),this.setProperties(a)),"rotate"===l&&this.onRefresh(),this.triggerSuccessMessage(l)},compactData(e){const t=this.key.type,n="rsa-2048"===t||"rsa-3072"===t||"rsa-4096"===t
return Object.keys(e).reduce(((t,l)=>"signature_algorithm"!==l||n?(e[l]&&(t[l]=e[l]),t):t),{})},actions:{onActionChange(e){(0,r.set)(this,"selectedAction",e),this.checkAction()},onClear(){this.resetParams(null,this.selectedAction)},clearParams(e){(Array.isArray(e)?e:[e]).forEach((e=>this.set(e,null)))},toggleModal(e){e&&"string"==typeof e&&this.flashMessages.success(e),this.toggleProperty("isModalActive")},doSubmit(e){var t=this
let n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},l=arguments.length>2?arguments[2]:void 0
const a="submit"===n.type?n:l
a&&a.preventDefault()
const{backend:i,id:r}=this.getModelInfo(),s=this.selectedAction,{encodedBase64:u,...d}=e||{}
u||("encrypt"===s&&d.plaintext&&(d.plaintext=(0,o.encodeString)(d.plaintext)),"hmac"!==s&&"verify"!==s&&"sign"!==s||!d.input||(d.input=(0,o.encodeString)(d.input)))
const c=d?this.compactData(d):null
this.setProperties({errors:null,result:null}),this.store.adapterFor("transit-key").keyAction(s,{backend:i,id:r,payload:c},n).then((e=>this.handleSuccess(e,n,s)),(function(){return t.handleError(...arguments)}))}}})
e.default=c})),define("vault/components/ttl-picker",["exports","core/components/ttl-picker"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ui-wizard",["exports","@ember/service","@ember/object/computed","@ember/component","xstate"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=l.default.extend({classNames:["ui-wizard-container"],wizard:(0,t.inject)(),auth:(0,t.inject)(),router:(0,t.inject)(),shouldRender:(0,n.or)("auth.currentToken","wizard.showWhenUnauthenticated"),currentState:(0,n.alias)("wizard.currentState"),featureState:(0,n.alias)("wizard.featureState"),featureComponent:(0,n.alias)("wizard.featureComponent"),tutorialComponent:(0,n.alias)("wizard.tutorialComponent"),componentState:(0,n.alias)("wizard.componentState"),nextFeature:(0,n.alias)("wizard.nextFeature"),nextStep:(0,n.alias)("wizard.nextStep"),currentRouteName:(0,n.alias)("router.currentRouteName"),actions:{dismissWizard(){this.wizard.transitionTutorialMachine(this.currentState,"DISMISS")},advanceWizard(){const e=(0,a.matchesState)("init",this.wizard.currentState)&&this.wizard.initEvent||"CONTINUE"
this.wizard.transitionTutorialMachine(this.currentState,e)},advanceFeature(){this.wizard.transitionFeatureMachine(this.featureState,"CONTINUE")},finishFeature(){this.wizard.transitionFeatureMachine(this.featureState,"DONE")},repeatStep(){this.wizard.transitionFeatureMachine(this.featureState,"REPEAT",this.componentState)},resetFeature(){this.wizard.transitionFeatureMachine(this.featureState,"RESET",this.componentState)},pauseWizard(){this.wizard.transitionTutorialMachine(this.currentState,"PAUSE")}}})
e.default=i})),define("vault/components/upgrade-page",["exports","core/components/upgrade-page"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/vault-logo-spinner",["exports","core/components/vault-logo-spinner"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/wizard-content",["exports","@ember/object/computed","@ember/service","@ember/component","@ember/object","vault/helpers/wizard-constants"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=l.default.extend({wizard:(0,n.inject)(),classNames:["ui-wizard"],glyph:null,headerText:null,selectProgress:null,currentMachine:(0,t.alias)("wizard.currentMachine"),tutorialState:(0,t.alias)("wizard.currentState"),tutorialComponent:(0,t.alias)("wizard.tutorialComponent"),showProgress:(0,a.computed)("tutorialComponent","tutorialState","wizard.{featureComponent,featureMachineHistory}",(function(){if(this.tutorialComponent)return this.tutorialComponent.includes("active")&&(this.tutorialState.includes("init.active")||this.wizard.featureComponent&&this.wizard.featureMachineHistory)})),featureMachineHistory:(0,t.alias)("wizard.featureMachineHistory"),totalFeatures:(0,t.reads)("wizard.featureList.length"),completedFeatures:(0,a.computed)("wizard.currentMachine",(function(){return this.wizard.getCompletedFeatures()})),currentFeatureProgress:(0,a.computed)("currentMachine","featureMachineHistory.[]","tutorialState",(function(){if(this.tutorialState.includes("active.feature")){let e=i.FEATURE_MACHINE_STEPS[this.currentMachine]
return"secrets"===this.currentMachine&&(this.featureMachineHistory.includes("secret")&&(e=e.secret.secret),this.featureMachineHistory.includes("list")&&(e=e.secret.list),this.featureMachineHistory.includes("encryption")&&(e=e.encryption),(this.featureMachineHistory.includes("role")||"object"==typeof e)&&(e=e.role)),{percentage:this.featureMachineHistory.length/e*100,feature:this.currentMachine,text:`Step ${this.featureMachineHistory.length} of ${e}`}}return null})),currentTutorialProgress:(0,a.computed)("tutorialState",(function(){if(this.tutorialState.includes("init.active")){const e=this.tutorialState.split(".")[2],t=i.INIT_STEPS.indexOf(e)+1
return{percentage:t/i.INIT_STEPS.length*100,text:`Step ${t} of ${i.INIT_STEPS.length}`}}return null})),progressBar:(0,a.computed)("completedFeatures","currentFeature","currentFeatureProgress.percentage","currentMachine","currentTutorialProgress.percentage","wizard.featureList",(function(){const e=[]
return this.currentTutorialProgress?e.push({style:`width:${this.currentTutorialProgress.percentage}%;`,completed:!1,showIcon:!0}):this.currentFeatureProgress&&(this.completedFeatures.forEach((t=>{e.push({style:"width:100%;",completed:!0,feature:t,showIcon:!0})})),this.wizard.featureList.forEach((t=>{t===this.currentMachine?e.push({style:`width:${this.currentFeatureProgress.percentage}%;`,completed:100==this.currentFeatureProgress.percentage,feature:t,showIcon:!0}):e.push({style:"width:0%;",completed:!1,feature:t,showIcon:!0})}))),e})),actions:{dismissWizard(){this.wizard.transitionTutorialMachine(this.wizard.currentState,"DISMISS")}}})
e.default=r})),define("vault/components/wizard/features-selection",["exports","@ember/object/computed","@ember/service","@ember/component","@ember/object","vault/helpers/wizard-constants"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=l.default.extend({wizard:(0,n.inject)(),version:(0,n.inject)(),permissions:(0,n.inject)(),init(){this._super(...arguments),this.maybeHideFeatures()},maybeHideFeatures(){if(this.allFeatures.forEach((e=>{e.disabled=this.doesNotHavePermission(e.requiredPermissions)})),!1===this.showReplication){this.allFeatures.findBy("key","replication").show=!1}},doesNotHavePermission(e){return!Object.keys(e).every((t=>this.permissions.hasPermission(t,e[t])))},estimatedTime:(0,a.computed)("selectedFeatures",(function(){let e=0
for(const t of Object.keys(i.FEATURE_MACHINE_TIME))this.selectedFeatures.includes(t)&&(e+=i.FEATURE_MACHINE_TIME[t])
return e})),selectProgress:(0,a.computed)("selectedFeatures",(function(){let e=this.selectedFeatures.map((e=>({style:"width:0%;",completed:!1,showIcon:!0,feature:e})))
return 0===e.length&&(e=[{style:"width:0%;",showIcon:!1}]),e})),allFeatures:(0,a.computed)((function(){return[{key:"secrets",name:"Secrets",steps:["Enabling a Secrets Engine","Adding a secret"],selected:!1,show:!0,disabled:!1,requiredPermissions:{"sys/mounts/example":["update"]}},{key:"authentication",name:"Authentication",steps:["Enabling an Auth Method","Managing your Auth Method"],selected:!1,show:!0,disabled:!1,requiredPermissions:{"sys/auth":["read"],"sys/auth/foo":["update","sudo"]}},{key:"policies",name:"Policies",steps:["Choosing a policy type","Creating a policy","Deleting your policy","Other types of policies"],selected:!1,show:!0,disabled:!1,requiredPermissions:{"sys/policies/acl":["list"]}},{key:"replication",name:"Replication",steps:["Setting up replication","Your cluster information"],selected:!1,show:!0,disabled:!1,requiredPermissions:{"sys/replication/performance/primary/enable":["update"],"sys/replication/dr/primary/enable":["update"]}},{key:"tools",name:"Tools",steps:["Wrapping data","Lookup wrapped data","Rewrapping your data","Unwrapping your data"],selected:!1,show:!0,disabled:!1,requiredPermissions:{"sys/wrapping/wrap":["update"],"sys/wrapping/lookup":["update"],"sys/wrapping/unwrap":["update"],"sys/wrapping/rewrap":["update"]}}]})),showReplication:(0,t.or)("version.hasPerfReplication","version.hasDRReplication"),selectedFeatures:(0,a.computed)("allFeatures.@each.selected",(function(){return this.allFeatures.filterBy("selected").mapBy("key")})),cannotStartWizard:(0,t.not)("selectedFeatures.length"),actions:{saveFeatures(){const e=this.wizard
e.saveFeatures(this.selectedFeatures),e.transitionTutorialMachine("active.select","CONTINUE")}}})
e.default=r})),define("vault/components/wizard/mounts-wizard",["exports","@ember/service","@ember/object/computed","@ember/component","@ember/object","vault/helpers/mountable-secret-engines","vault/helpers/mountable-auth-methods","vault/helpers/supported-secret-backends","vault/helpers/supported-auth-backends"],(function(e,t,n,l,a,i,r,o,s){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const u=(0,o.supportedSecretBackends)(),d=(0,s.supportedAuthBackends)()
var c=l.default.extend({wizard:(0,t.inject)(),featureState:(0,n.alias)("wizard.featureState"),currentState:(0,n.alias)("wizard.currentState"),currentMachine:(0,n.alias)("wizard.currentMachine"),mountSubtype:(0,n.alias)("wizard.componentState"),fullNextStep:(0,n.alias)("wizard.nextStep"),nextFeature:(0,n.alias)("wizard.nextFeature"),nextStep:(0,a.computed)("fullNextStep",(function(){return this.fullNextStep.split(".").lastObject})),needsConnection:(0,n.equal)("mountSubtype","database"),needsEncryption:(0,n.equal)("mountSubtype","transit"),stepComponent:(0,n.alias)("wizard.stepComponent"),detailsComponent:(0,a.computed)("currentMachine","mountSubtype",(function(){const e="secrets"===this.currentMachine?"engine":"method"
return this.mountSubtype?`wizard/${this.mountSubtype}-${e}`:null})),isSupported:(0,a.computed)("currentMachine","mountSubtype",(function(){return"secrets"===this.currentMachine?u.includes(this.mountSubtype):d.includes(this.mountSubtype)})),mountName:(0,a.computed)("currentMachine","mountSubtype",(function(){if("secrets"===this.currentMachine){const e=(0,i.mountableEngines)().find((e=>e.type===this.mountSubtype))
if(e)return e.displayName}else{var e=(0,r.methods)().find((e=>e.type===this.mountSubtype))
if(e)return e.displayName}return null})),actionText:(0,a.computed)("mountSubtype",(function(){switch(this.mountSubtype){case"aws":return"Generate credential"
case"ssh":return"Sign keys"
case"pki":return"Generate certificate"
default:return null}})),onAdvance(){},onRepeat(){},onReset(){},onDone(){}})
e.default=c}))
define("vault/components/wizard/secrets-keymgmt",["exports","@glimmer/component"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{get headerText(){return{provider:"Creating a provider",displayProvider:"Distributing a key",distribute:"Creating a key"}[this.args.featureState]}get body(){return{provider:"This process connects an external provider to Vault. You will need its credentials.",displayProvider:"A key can now be created and distributed to this destination.",distribute:"This process creates a key and distributes it to your provider."}[this.args.featureState]}get instructions(){return{provider:"Enter your provider details and click “Create provider“.",displayProvider:"Click “Distribute key” in the toolbar.",distribute:"Enter your key details and click “Distribute key”."}[this.args.featureState]}}e.default=n})),define("vault/components/wrap-ttl",["exports","@ember/component","@ember/template-factory","@ember/debug","@glimmer/component","@ember/object","@glimmer/tracking"],(function(e,t,n,l,a,i,r){var o,s
function u(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const d=(0,n.createTemplateFactory)({id:"IsdqWI96",block:'[[[10,0],[14,0,"field"],[12],[1,"\\n  "],[8,[39,0],null,[["@label","@helperTextDisabled","@helperTextEnabled","@initialEnabled","@initialValue","@onChange","@changeOnInit"],["Wrap response","Will not wrap response","Will wrap response with a lease of",true,"30m",[30,0,["changedValue"]],true]],null],[1,"\\n"],[13]],[],false,["ttl-picker"]]',moduleName:"vault/components/wrap-ttl.hbs",isStrictMode:!1})
let c=(o=class extends a.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="wrapResponse",l=this,(n=s)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}get wrapTTL(){const{wrapResponse:e,ttl:t}=this
return e?t:null}changedValue(e){this.wrapResponse=e.enabled,this.ttl=e.goSafeTimeString,this.args.onChange(this.wrapTTL)}},s=u(o.prototype,"wrapResponse",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!0}}),u(o.prototype,"changedValue",[i.action],Object.getOwnPropertyDescriptor(o.prototype,"changedValue"),o.prototype),o)
e.default=c,(0,t.setComponentTemplate)(d,c)})),define("vault/config/asset-manifest",["exports","require","vault/config/environment"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const l=n.default.modulePrefix,a=`${l}/config/asset-manifest`,i=`${l}/config/node-asset-manifest`
let r={}
try{if(t.default.has(i))r=(0,t.default)(i).default
else{const e=document.querySelector('meta[name="'+a+'"]').getAttribute("content")
r=JSON.parse(unescape(e))}}catch(s){throw new Error('Failed to load asset manifest. For browser environments, verify the meta tag with name "'+a+'" is present. For non-browser environments, verify that you included the node-asset-manifest module.')}var o=r
e.default=o})),define("vault/controllers/application",["exports","@ember/service","@ember/controller","vault/config/environment"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=n.default.extend({env:l.default.environment,auth:(0,t.inject)(),store:(0,t.inject)()})
e.default=a})),define("vault/controllers/vault",["exports","@ember/service","@ember/controller","vault/config/environment"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=n.default.extend({queryParams:[{wrappedToken:"wrapped_token",redirectTo:"redirect_to"}],wrappedToken:"",redirectTo:"",env:l.default.environment,auth:(0,t.inject)(),store:(0,t.inject)()})
e.default=a})),define("vault/controllers/vault/cluster",["exports","@ember/service","@ember/object/computed","@ember/controller","@ember/object"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=l.default.extend({auth:(0,t.inject)(),store:(0,t.inject)(),media:(0,t.inject)(),router:(0,t.inject)(),permissions:(0,t.inject)(),namespaceService:(0,t.inject)("namespace"),flashMessages:(0,t.inject)(),vaultVersion:(0,t.inject)("version"),console:(0,t.inject)(),queryParams:[{namespaceQueryParam:{scope:"controller",as:"namespace"}}],namespaceQueryParam:"",onQPChange:(0,a.observer)("namespaceQueryParam",(function(){this.namespaceService.setNamespace(this.namespaceQueryParam)})),consoleOpen:(0,n.alias)("console.isOpen"),activeCluster:(0,n.alias)("auth.activeCluster"),permissionBanner:(0,n.alias)("permissions.permissionsBanner"),actions:{toggleConsole(){this.toggleProperty("consoleOpen")}}})
e.default=i})),define("vault/controllers/vault/cluster/access/control-groups-configure",["exports","@ember/controller"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({actions:{onSave(e){let{saveType:t}=e
"destroyRecord"===t&&this.send("reload")}}})
e.default=n})),define("vault/controllers/vault/cluster/access/identity/aliases/add",["exports","vault/controllers/vault/cluster/access/identity/create"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({showRoute:"vault.cluster.access.identity.aliases.show"})
e.default=n})),define("vault/controllers/vault/cluster/access/identity/aliases/edit",["exports","vault/controllers/vault/cluster/access/identity/aliases/add"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend()
e.default=n})),define("vault/controllers/vault/cluster/access/identity/aliases/index",["exports","@ember/controller","core/mixins/list-controller"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend(n.default,{actions:{onDelete(){this.send("reload")}}})
e.default=l})),define("vault/controllers/vault/cluster/access/identity/create",["exports","@ember/controller","ember-concurrency"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend({showRoute:"vault.cluster.access.identity.show",showTab:"details",navAfterSave:(0,n.task)((function*(e){let{saveType:t,model:n}=e
const l="delete"===t,a={"entity-alias":"vault.cluster.access.identity.aliases.index","group-alias":"vault.cluster.access.identity.aliases.index",group:"vault.cluster.access.identity.index",entity:"vault.cluster.access.identity.index"}[n.get("identityType")]
l?yield this.transitionToRoute(a):yield this.transitionToRoute(this.showRoute,n.id,this.showTab)}))})
e.default=l})),define("vault/controllers/vault/cluster/access/identity/edit",["exports","vault/controllers/vault/cluster/access/identity/create"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend()
e.default=n})),define("vault/controllers/vault/cluster/access/identity/index",["exports","@ember/service","@ember/controller","core/mixins/list-controller"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=n.default.extend(l.default,{flashMessages:(0,t.inject)(),actions:{delete(e){const t=e.get("identityType"),n=e.id
return e.destroyRecord().then((()=>{this.send("reload"),this.flashMessages.success(`Successfully deleted ${t}: ${n}`)})).catch((e=>{this.flashMessages.success(`There was a problem deleting ${t}: ${n} - ${e.errors.join(" ")||e.message}`)}))},toggleDisabled(e){const t=e.get("disabled")?["enabled","enabling"]:["disabled","disabling"],n=e.get("identityType"),l=e.id
e.toggleProperty("disabled"),e.save().then((()=>{this.flashMessages.success(`Successfully ${t[0]} ${n}: ${l}`)})).catch((e=>{this.flashMessages.success(`There was a problem ${t[1]} ${n}: ${l} - ${e.errors.join(" ")||e.message}`)}))},reloadRecord(e){e.reload()}}})
e.default=a})),define("vault/controllers/vault/cluster/access/identity/merge",["exports","vault/controllers/vault/cluster/access/identity/create"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend()
e.default=n})),define("vault/controllers/vault/cluster/access/leases/index",["exports","@ember/controller"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({actions:{lookupLease(e){this.transitionToRoute("vault.cluster.access.leases.show",e)}}})
e.default=n})),define("vault/controllers/vault/cluster/access/leases/list-root",["exports","vault/controllers/vault/cluster/access/leases/list"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/controllers/vault/cluster/access/leases/list",["exports","@ember/service","@ember/object","@ember/controller","core/mixins/list-controller","core/utils/key-utils"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=l.default.extend(a.default,{flashMessages:(0,t.inject)(),store:(0,t.inject)(),clusterController:(0,l.inject)("vault.cluster"),backendCrumb:(0,n.computed)("clusterController.model.name",(function(){return{label:"leases",text:"leases",path:"vault.cluster.access.leases.list-root",model:this.clusterController.model.name}})),isLoading:!1,filterIsFolder:(0,n.computed)("filter",(function(){return!!(0,i.keyIsFolder)(this.filter)})),emptyTitle:(0,n.computed)("baseKey.id","filter","filterIsFolder",(function(){const e=this.baseKey.id,t=this.filter
return""===e?"There are currently no leases.":this.filterIsFolder?t===e?`There are no leases under &quot;${t}&quot;.`:`We couldn't find a prefix matching &quot;${t}&quot;.`:""})),actions:{revokePrefix(e,t){const n=this.store.adapterFor("lease")
n[t?"forceRevokePrefix":"revokePrefix"].call(n,e).then((()=>this.transitionToRoute("vault.cluster.access.leases.list-root").then((()=>{this.flashMessages.success(`All of the leases under ${e} will be revoked.`)})))).catch((t=>{const n=t.errors.join(".")
this.flashMessages.danger(`There was an error attempting to revoke the prefix: ${e}. ${n}.`)}))}}})
e.default=r})),define("vault/controllers/vault/cluster/access/leases/show",["exports","@ember/runloop","@ember/service","@ember/object","@ember/controller"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=a.default.extend({clusterController:(0,a.inject)("vault.cluster"),backendCrumb:(0,l.computed)("clusterController.model.name",(function(){return{label:"leases",text:"leases",path:"vault.cluster.access.leases.list-root",model:this.clusterController.model.name}})),flashMessages:(0,n.inject)(),actions:{revokeLease(e){return e.destroyRecord().then((()=>this.transitionToRoute("vault.cluster.access.leases.list-root")))},renewLease(e,n){const l=e.store.adapterFor("lease"),a=this.flashMessages
l.renew(e.id,n?.seconds).then((()=>{this.send("refreshModel"),(0,t.next)((()=>{a.success(`The lease ${e.id} was successfully renewed.`)}))})).catch((e=>{const t=e.errors.join(".")
a.danger(`There was an error renewing the lease: ${t}`)}))}}})
e.default=i})),define("vault/controllers/vault/cluster/access/method/item/list",["exports","@ember/controller","vault/mixins/list-controller"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend(n.default,{})
e.default=l})),define("vault/controllers/vault/cluster/access/methods",["exports","@ember/controller","ember-concurrency","@ember/service","@ember/object","@glimmer/tracking"],(function(e,t,n,l,a,i){var r,o,s,u,d
function c(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function p(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function m(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let f=(r=class extends t.default{constructor(){super(...arguments),c(this,"flashMessages",o,this),c(this,"authMethodOptions",s,this),c(this,"selectedAuthType",u,this),c(this,"selectedAuthName",d,this),p(this,"queryParams",["page, pageFilter"]),p(this,"page",1),p(this,"pageFilter",null),p(this,"filter",null)}get authMethodList(){return this.selectedAuthType?this.selectedAuthName?this.model.filter((e=>this.selectedAuthName===e.id)):this.model.filter((e=>this.selectedAuthType===e.type)):this.selectedAuthName?this.model.filter((e=>this.selectedAuthName===e.id)):this.model}get authMethodArrayByType(){const e=this.authMethodList.map((e=>e.type))
return[...new Set(e)].map((e=>({name:e,id:e})))}get authMethodArrayByName(){return this.authMethodList.map((e=>({name:e.id,id:e.id})))}filterAuthType(e){let[t]=e
this.selectedAuthType=t}filterAuthName(e){let[t]=e
this.selectedAuthName=t}*disableMethod(e){const{type:t,path:n}=e
try{yield e.destroyRecord(),this.flashMessages.success(`The ${t} Auth Method at ${n} has been disabled.`)}catch(l){this.flashMessages.danger(`There was an error disabling Auth Method at ${n}: ${l.errors.join(" ")}.`)}}},o=m(r.prototype,"flashMessages",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=m(r.prototype,"authMethodOptions",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return[]}}),u=m(r.prototype,"selectedAuthType",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),d=m(r.prototype,"selectedAuthName",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),m(r.prototype,"filterAuthType",[a.action],Object.getOwnPropertyDescriptor(r.prototype,"filterAuthType"),r.prototype),m(r.prototype,"filterAuthName",[a.action],Object.getOwnPropertyDescriptor(r.prototype,"filterAuthName"),r.prototype),m(r.prototype,"disableMethod",[n.dropTask],Object.getOwnPropertyDescriptor(r.prototype,"disableMethod"),r.prototype),r)
e.default=f})),define("vault/controllers/vault/cluster/access/mfa/enforcements/enforcement/index",["exports","@ember/controller","@glimmer/tracking","@ember/object","@ember/service"],(function(e,t,n,l,a){var i,r,o,s,u
function d(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function c(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function p(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let m=(i=class extends t.default{constructor(){super(...arguments),d(this,"router",r,this),d(this,"flashMessages",o,this),c(this,"queryParams",["tab"]),c(this,"tab","targets"),d(this,"showDeleteConfirmation",s,this),d(this,"deleteError",u,this)}async delete(){try{await this.model.destroyRecord(),this.showDeleteConfirmation=!1,this.flashMessages.success("MFA login enforcement deleted successfully"),this.router.transitionTo("vault.cluster.access.mfa.enforcements")}catch(e){this.deleteError=e}}},r=p(i.prototype,"router",[a.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),o=p(i.prototype,"flashMessages",[a.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=p(i.prototype,"showDeleteConfirmation",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),u=p(i.prototype,"deleteError",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p(i.prototype,"delete",[l.action],Object.getOwnPropertyDescriptor(i.prototype,"delete"),i.prototype),i)
e.default=m})),define("vault/controllers/vault/cluster/access/mfa/enforcements/index",["exports","@ember/controller"],(function(e,t){function n(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{constructor(){super(...arguments),n(this,"queryParams",["page"]),n(this,"page",1)}}e.default=l})),define("vault/controllers/vault/cluster/access/mfa/methods",["exports","@ember/controller"],(function(e,t){function n(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{constructor(){super(...arguments),n(this,"queryParams",["page"]),n(this,"page",1)}}e.default=l})),define("vault/controllers/vault/cluster/access/mfa/methods/create",["exports","@ember/controller","@ember/service","@glimmer/tracking","@ember/object","@ember/string","ember-concurrency"],(function(e,t,n,l,a,i,r){var o,s,u,d,c,p,m,f,h,b
function y(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function v(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function g(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let w=(o=class extends t.default{constructor(){super(...arguments),y(this,"store",s,this),y(this,"flashMessages",u,this),y(this,"router",d,this),v(this,"queryParams",["type"]),v(this,"methodNames",["TOTP","Duo","Okta","PingID"]),y(this,"type",c,this),y(this,"method",p,this),y(this,"enforcement",m,this),y(this,"enforcementPreference",f,this),y(this,"methodErrors",h,this),y(this,"enforcementErrors",b,this)}get description(){return"totp"===this.type?"Once set up, TOTP requires a passcode to be presented alongside a Vault token when invoking an API request.\n        The passcode will be validated against the TOTP key present in the identity of the caller in Vault.":`Once set up, the ${this.formattedType} MFA method will require a push confirmation on mobile before login.`}get formattedType(){return this.type?"totp"===this.type?this.type.toUpperCase():(0,i.capitalize)(this.type):""}get isTotp(){return"totp"===this.type}get showForms(){return this.type&&this.method}onTypeSelect(e){this.method=null,this.enforcement=null,this.methodErrors=null,this.enforcementErrors=null,this.enforcementPreference="new",this.type=e}createModels(){this.method&&this.method.unloadRecord(),this.enforcement&&this.enforcement.unloadRecord(),this.method=this.store.createRecord("mfa-method",{type:this.type}),this.enforcement=this.store.createRecord("mfa-login-enforcement")}onEnforcementPreferenceChange(e){"new"===e?this.enforcement=this.store.createRecord("mfa-login-enforcement"):this.enforcement&&(this.enforcement.unloadRecord(),this.enforcement=null),this.enforcementPreference=e}cancel(){this.method=null,this.enforcement=null,this.enforcementPreference=null,this.router.transitionTo("vault.cluster.access.mfa.methods")}*save(){if(this.checkValidityState())try{if(yield this.method.save(),this.enforcement){this.enforcement.mfa_methods.addObject(this.method)
try{yield this.enforcement.save()}catch(e){this.handleError(e,"Error saving enforcement. You can still create an enforcement separately and add this method to it.")}}this.router.transitionTo("vault.cluster.access.mfa.methods.method",this.method.id)}catch(e){this.handleError(e,"Error saving method")}}checkValidityState(){let e=!0
const t=this.method.validate()
if(t.isValid||(this.methodErrors=t.state),"new"===this.enforcementPreference){const t=this.enforcement.validate(),{name:n,targets:l}=t.state
e=n.isValid&&l.isValid,t.isValid||(this.enforcementErrors=t.state)}return t.isValid&&e}handleError(e,t){const n=e?.errors?`${t}: ${e.errors.join(", ")}`:t
this.flashMessages.danger(n)}},s=g(o.prototype,"store",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=g(o.prototype,"flashMessages",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=g(o.prototype,"router",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=g(o.prototype,"type",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),p=g(o.prototype,"method",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),m=g(o.prototype,"enforcement",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=g(o.prototype,"enforcementPreference",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return"new"}}),h=g(o.prototype,"methodErrors",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=g(o.prototype,"enforcementErrors",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g(o.prototype,"onTypeSelect",[a.action],Object.getOwnPropertyDescriptor(o.prototype,"onTypeSelect"),o.prototype),g(o.prototype,"createModels",[a.action],Object.getOwnPropertyDescriptor(o.prototype,"createModels"),o.prototype),g(o.prototype,"onEnforcementPreferenceChange",[a.action],Object.getOwnPropertyDescriptor(o.prototype,"onEnforcementPreferenceChange"),o.prototype),g(o.prototype,"cancel",[a.action],Object.getOwnPropertyDescriptor(o.prototype,"cancel"),o.prototype),g(o.prototype,"save",[r.task],Object.getOwnPropertyDescriptor(o.prototype,"save"),o.prototype),o)
e.default=w})),define("vault/controllers/vault/cluster/access/mfa/methods/method/index",["exports","@ember/controller","@ember/service","@ember/object"],(function(e,t,n,l){var a,i,r
function o(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function s(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function u(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let d=(a=class extends t.default{constructor(){super(...arguments),o(this,"router",i,this),o(this,"flashMessages",r,this),s(this,"queryParams",["tab"]),s(this,"tab","config")}async deleteMethod(){try{await this.model.method.destroyRecord(),this.flashMessages.success("MFA method deleted successfully."),this.router.transitionTo("vault.cluster.access.mfa.methods")}catch(e){this.flashMessages.danger("There was an error deleting this MFA method.")}}},i=u(a.prototype,"router",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),r=u(a.prototype,"flashMessages",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u(a.prototype,"deleteMethod",[l.action],Object.getOwnPropertyDescriptor(a.prototype,"deleteMethod"),a.prototype),a)
e.default=d})),define("vault/controllers/vault/cluster/access/namespaces/create",["exports","@ember/service","@ember/controller"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=n.default.extend({namespaceService:(0,t.inject)("namespace"),actions:{onSave(e){let{saveType:t}=e
if("save"===t)return this.namespaceService.findNamespacesForUser.perform(),this.transitionToRoute("vault.cluster.access.namespaces.index")}}})
e.default=l})),define("vault/controllers/vault/cluster/access/namespaces/index",["exports","@ember/service","@ember/object/computed","@ember/controller"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=l.default.extend({namespaceService:(0,t.inject)("namespace"),accessibleNamespaces:(0,n.alias)("namespaceService.accessibleNamespaces"),currentNamespace:(0,n.alias)("namespaceService.path"),actions:{refreshNamespaceList(){this.namespaceService.findNamespacesForUser.perform(),this.send("reload")}}})
e.default=a})),define("vault/controllers/vault/cluster/access/oidc",["exports","@ember/controller","@ember/service","@glimmer/tracking"],(function(e,t,n,l){var a,i,r
function o(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function s(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let u=(a=class extends t.default{constructor(){super(...arguments),o(this,"router",i,this),o(this,"header",r,this),this.router.on("routeDidChange",(e=>this.setHeader(e)))}setHeader(e){const t=e.to.name
if(t.includes("oidc.index"))this.header="cta"
else{const e=["clients","assignments","keys","scopes","providers"].find((e=>t.includes(`${e}.index`)))
this.header=e?"list":null}}get isCta(){return"cta"===this.header}},i=s(a.prototype,"router",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),r=s(a.prototype,"header",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),a)
e.default=u})),define("vault/controllers/vault/cluster/access/oidc/assignments/assignment/details",["exports","@ember/controller","@ember/object","@ember/service"],(function(e,t,n,l){var a,i,r
function o(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function s(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let u=(a=class extends t.default{constructor(){super(...arguments),o(this,"router",i,this),o(this,"flashMessages",r,this)}async delete(){try{await this.model.destroyRecord(),this.flashMessages.success("Assignment deleted successfully"),this.router.transitionTo("vault.cluster.access.oidc.assignments")}catch(e){this.model.rollbackAttributes()
const t=e.errors?e.errors.join(". "):e.message
this.flashMessages.danger(t)}}},i=s(a.prototype,"router",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),r=s(a.prototype,"flashMessages",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s(a.prototype,"delete",[n.action],Object.getOwnPropertyDescriptor(a.prototype,"delete"),a.prototype),a)
e.default=u})),define("vault/controllers/vault/cluster/access/oidc/clients/client",["exports","@ember/controller","@ember/service","@glimmer/tracking"],(function(e,t,n,l){var a,i,r
function o(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function s(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let u=(a=class extends t.default{constructor(){super(...arguments),o(this,"router",i,this),o(this,"isEditRoute",r,this),this.router.on("routeDidChange",(e=>{let{targetName:t}=e
return this.isEditRoute=!!t.includes("edit")}))}get showHeader(){return!this.isEditRoute}},i=s(a.prototype,"router",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),r=s(a.prototype,"isEditRoute",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),a)
e.default=u}))
define("vault/controllers/vault/cluster/access/oidc/clients/client/details",["exports","@ember/controller","@ember/object","@ember/service"],(function(e,t,n,l){var a,i,r
function o(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function s(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let u=(a=class extends t.default{constructor(){super(...arguments),o(this,"router",i,this),o(this,"flashMessages",r,this)}async delete(){try{await this.model.destroyRecord(),this.flashMessages.success("Application deleted successfully"),this.router.transitionTo("vault.cluster.access.oidc.clients")}catch(e){this.model.rollbackAttributes()
const t=e.errors?e.errors.join(". "):e.message
this.flashMessages.danger(t)}}},i=s(a.prototype,"router",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),r=s(a.prototype,"flashMessages",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s(a.prototype,"delete",[n.action],Object.getOwnPropertyDescriptor(a.prototype,"delete"),a.prototype),a)
e.default=u})),define("vault/controllers/vault/cluster/access/oidc/keys/key",["exports","@ember/controller","@ember/service","@glimmer/tracking"],(function(e,t,n,l){var a,i,r
function o(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function s(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let u=(a=class extends t.default{constructor(){super(...arguments),o(this,"router",i,this),o(this,"isEditRoute",r,this),this.router.on("routeDidChange",(e=>{let{targetName:t}=e
return this.isEditRoute=!!t.includes("edit")}))}get showHeader(){return!this.isEditRoute}},i=s(a.prototype,"router",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),r=s(a.prototype,"isEditRoute",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),a)
e.default=u})),define("vault/controllers/vault/cluster/access/oidc/keys/key/details",["exports","@ember/controller","@ember/object","@ember/service","ember-concurrency","@ember/test-waiters"],(function(e,t,n,l,a,i){var r,o,s,u
function d(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function c(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let p=(r=class extends t.default{constructor(){super(...arguments),d(this,"store",o,this),d(this,"router",s,this),d(this,"flashMessages",u,this)}*rotateKey(){const e=this.store.adapterFor("oidc/key")
yield e.rotate(this.model.name,this.model.verificationTtl).then((()=>{this.flashMessages.success(`Success: ${this.model.name} connection was rotated.`)})).catch((e=>{this.flashMessages.danger(e.errors)}))}async delete(){try{await this.model.destroyRecord(),this.flashMessages.success("Key deleted successfully"),this.router.transitionTo("vault.cluster.access.oidc.keys")}catch(e){this.model.rollbackAttributes()
const t=e.errors?e.errors.join(". "):e.message
this.flashMessages.danger(t)}}},o=c(r.prototype,"store",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=c(r.prototype,"router",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=c(r.prototype,"flashMessages",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c(r.prototype,"rotateKey",[a.task,i.waitFor],Object.getOwnPropertyDescriptor(r.prototype,"rotateKey"),r.prototype),c(r.prototype,"delete",[n.action],Object.getOwnPropertyDescriptor(r.prototype,"delete"),r.prototype),r)
e.default=p})),define("vault/controllers/vault/cluster/access/oidc/providers/provider",["exports","@ember/controller","@ember/service","@glimmer/tracking"],(function(e,t,n,l){var a,i,r
function o(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function s(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let u=(a=class extends t.default{constructor(){super(...arguments),o(this,"router",i,this),o(this,"isEditRoute",r,this),this.router.on("routeDidChange",(e=>{let{targetName:t}=e
return this.isEditRoute=!!t.includes("edit")}))}get showHeader(){return!this.isEditRoute}},i=s(a.prototype,"router",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),r=s(a.prototype,"isEditRoute",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),a)
e.default=u})),define("vault/controllers/vault/cluster/access/oidc/providers/provider/details",["exports","@ember/controller","@ember/object","@ember/service"],(function(e,t,n,l){var a,i,r
function o(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function s(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let u=(a=class extends t.default{constructor(){super(...arguments),o(this,"router",i,this),o(this,"flashMessages",r,this)}async delete(){try{await this.model.destroyRecord(),this.flashMessages.success("Provider deleted successfully"),this.router.transitionTo("vault.cluster.access.oidc.providers")}catch(e){this.model.rollbackAttributes()
const t=e.errors?e.errors.join(". "):e.message
this.flashMessages.danger(t)}}},i=s(a.prototype,"router",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),r=s(a.prototype,"flashMessages",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s(a.prototype,"delete",[n.action],Object.getOwnPropertyDescriptor(a.prototype,"delete"),a.prototype),a)
e.default=u})),define("vault/controllers/vault/cluster/access/oidc/scopes/scope/details",["exports","@ember/controller","@ember/object","@ember/service"],(function(e,t,n,l){var a,i,r
function o(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function s(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let u=(a=class extends t.default{constructor(){super(...arguments),o(this,"router",i,this),o(this,"flashMessages",r,this)}async delete(){try{await this.model.destroyRecord(),this.flashMessages.success("Scope deleted successfully"),this.router.transitionTo("vault.cluster.access.oidc.scopes")}catch(e){this.model.rollbackAttributes()
const t=e.errors?e.errors.join(". "):e.message
this.flashMessages.danger(t)}}},i=s(a.prototype,"router",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),r=s(a.prototype,"flashMessages",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s(a.prototype,"delete",[n.action],Object.getOwnPropertyDescriptor(a.prototype,"delete"),a.prototype),a)
e.default=u})),define("vault/controllers/vault/cluster/auth",["exports","@ember/service","@ember/object/computed","@ember/controller","ember-concurrency","core/utils/sanitize-path"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=l.default.extend({flashMessages:(0,t.inject)(),vaultController:(0,l.inject)("vault"),clusterController:(0,l.inject)("vault.cluster"),namespaceService:(0,t.inject)("namespace"),featureFlagService:(0,t.inject)("featureFlag"),auth:(0,t.inject)(),router:(0,t.inject)(),queryParams:[{authMethod:"with",oidcProvider:"o"}],namespaceQueryParam:(0,n.alias)("clusterController.namespaceQueryParam"),wrappedToken:(0,n.alias)("vaultController.wrappedToken"),redirectTo:(0,n.alias)("vaultController.redirectTo"),managedNamespaceRoot:(0,n.alias)("featureFlagService.managedNamespaceRoot"),authMethod:"",oidcProvider:"",get namespaceInput(){const e=this.clusterController.namespaceQueryParam
if(this.managedNamespaceRoot){const t=e.split("/")
return t.length>1?(t.shift(),`/${t.join("/")}`):""}return e},fullNamespaceFromInput(e){const t=(0,i.sanitizePath)(e)
return this.managedNamespaceRoot?`${this.managedNamespaceRoot}/${t}`:t},updateNamespace:(0,a.task)((function*(e){yield(0,a.timeout)(500)
const t=this.fullNamespaceFromInput(e)
this.namespaceService.setNamespace(t,!0),this.set("namespaceQueryParam",t)})).restartable(),authSuccess(e){let t,{isRoot:n,namespace:l}=e
this.redirectTo?(t=this.router.transitionTo(this.redirectTo),this.set("redirectTo","")):t=this.router.transitionTo("vault.cluster",{queryParams:{namespace:l}}),t.followRedirects().then((()=>{n&&this.flashMessages.warning("You have logged in with a root token. As a security precaution, this root token will not be stored by your browser and you will need to re-authenticate after the window is closed or refreshed.")}))},actions:{onAuthResponse(e,t,n){const{mfa_requirement:l}=e
l?this.set("mfaAuthData",{mfa_requirement:l,backend:t,data:n}):this.authSuccess(e)},onMfaSuccess(e){this.authSuccess(e)},onMfaErrorDismiss(){this.setProperties({mfaAuthData:null,mfaErrors:null})},cancelAuthentication(){this.set("cancelAuth",!0),this.set("waitingForOktaNumberChallenge",!1)}}})
e.default=r})),define("vault/controllers/vault/cluster/clients",["exports","@ember/controller"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/controllers/vault/cluster/dashboard",["exports","@ember/controller","@ember/object","@glimmer/tracking","core/utils/timestamp"],(function(e,t,n,l,a){var i,r
function o(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let s=(i=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="replicationUpdatedAt",l=this,(n=r)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}refreshModel(e){e&&e.preventDefault(),this.replicationUpdatedAt=a.default.now().toISOString(),this.send("refreshRoute")}},r=o(i.prototype,"replicationUpdatedAt",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return a.default.now().toISOString()}}),o(i.prototype,"refreshModel",[n.action],Object.getOwnPropertyDescriptor(i.prototype,"refreshModel"),i.prototype),i)
e.default=s})),define("vault/controllers/vault/cluster/init",["exports","@ember/object","@ember/controller"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const l={keyData:null,secret_shares:null,secret_threshold:null,pgp_keys:null,use_pgp:!1,loading:!1}
var a=n.default.extend(l,{reset(){this.setProperties(l)},initSuccess(e){this.set("loading",!1),this.set("keyData",e),this.model.reload()},initError(e){if(this.set("loading",!1),400!==e.httpStatus)throw e
this.set("errors",e.errors)},keyFilename:(0,t.computed)("model.name",(function(){return`vault-cluster-${this.model.name}`})),actions:{initCluster(e){var t=this
const n=!!this.model.sealType&&"shamir"!==this.model.sealType
if(e.secret_shares){const t=parseInt(e.secret_shares,10)
e.secret_shares=t,n&&(e.stored_shares=1,e.recovery_shares=t,delete e.secret_shares)}if(e.secret_threshold){const t=parseInt(e.secret_threshold,10)
e.secret_threshold=t,n&&(e.recovery_threshold=t,delete e.secret_threshold)}e.use_pgp||delete e.pgp_keys,e.use_pgp&&n&&(e.recovery_pgp_keys=e.pgp_keys),e.use_pgp_for_root||delete e.root_token_pgp_key,delete e.use_pgp,delete e.use_pgp_for_root
const l=this.model.store
this.setProperties({loading:!0,errors:null}),l.adapterFor("cluster").initCluster(e).then((e=>this.initSuccess(e)),(function(){return t.initError(...arguments)}))},setKeys(e){this.set("pgp_keys",e)},setRootKey(e){let[t]=e
this.set("root_token_pgp_key",t)}}})
e.default=a})),define("vault/controllers/vault/cluster/mfa-setup",["exports","@ember/controller","@ember/service","@ember/object","@glimmer/tracking"],(function(e,t,n,l,a){var i,r,o,s,u,d
function c(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function p(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let m=(i=class extends t.default{constructor(){super(...arguments),c(this,"auth",r,this),c(this,"onStep",o,this),c(this,"warning",s,this),c(this,"uuid",u,this),c(this,"qrCode",d,this)}get entityId(){return this.auth.authData.entity_id}isUUIDVerified(e){this.warning="",e?this.onStep=2:this.restartFlow()}restartFlow(){this.onStep=1}saveUUIDandQrCode(e,t){this.uuid=e,this.qrCode=t}showWarning(e){this.warning=e,this.onStep=2}},r=p(i.prototype,"auth",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),o=p(i.prototype,"onStep",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return 1}}),s=p(i.prototype,"warning",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),u=p(i.prototype,"uuid",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),d=p(i.prototype,"qrCode",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),p(i.prototype,"isUUIDVerified",[l.action],Object.getOwnPropertyDescriptor(i.prototype,"isUUIDVerified"),i.prototype),p(i.prototype,"restartFlow",[l.action],Object.getOwnPropertyDescriptor(i.prototype,"restartFlow"),i.prototype),p(i.prototype,"saveUUIDandQrCode",[l.action],Object.getOwnPropertyDescriptor(i.prototype,"saveUUIDandQrCode"),i.prototype),p(i.prototype,"showWarning",[l.action],Object.getOwnPropertyDescriptor(i.prototype,"showWarning"),i.prototype),i)
e.default=m})),define("vault/controllers/vault/cluster/oidc-callback",["exports","@ember/controller"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({queryParams:["state","code"],code:null,state:null})
e.default=n})),define("vault/controllers/vault/cluster/oidc-provider-ns",["exports","vault/controllers/vault/cluster/oidc-provider"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/controllers/vault/cluster/oidc-provider",["exports","@ember/controller"],(function(e,t){function n(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{constructor(){super(...arguments),n(this,"queryParams",["scope","response_type","client_id","redirect_uri","state","nonce","display","prompt","max_age","code_challenge","code_challenge_method","request","request_uri"]),n(this,"scope",null),n(this,"response_type",null),n(this,"client_id",null),n(this,"redirect_uri",null),n(this,"state",null),n(this,"nonce",null),n(this,"display",null),n(this,"prompt",null),n(this,"max_age",null),n(this,"code_challenge",null),n(this,"code_challenge_method",null),n(this,"request",null),n(this,"request_uri",null)}}e.default=l})),define("vault/controllers/vault/cluster/policies/index",["exports","@ember/service","@ember/object","@ember/controller"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=l.default.extend({flashMessages:(0,t.inject)(),queryParams:{page:"page",pageFilter:"pageFilter"},filter:null,page:1,pageFilter:null,filterFocused:!1,isLoading:!1,filterMatchesKey:(0,n.computed)("filter","model","model.[]",(function(){var e=this.filter,t=this.model
return!!(t&&t.length&&t.findBy("id",e))})),firstPartialMatch:(0,n.computed)("filter","model","model.[]","filterMatchesKey",(function(){var e=this.filter,t=this.model
if(t){var n=this.filterMatchesKey,l=new RegExp("^"+e)
return n?null:t.find((function(e){return l.test(e.get("id"))}))}})),actions:{setFilter:function(e){this.set("filter",e)},setFilterFocus:function(e){this.set("filterFocused",e)},deletePolicy(e){const t=e.get("policyType"),n=e.id,l=this.flashMessages
e.destroyRecord().then((()=>{this.send("reload"),l.success(`${t.toUpperCase()} policy "${n}" was successfully deleted.`)})).catch((e=>{const a=e.errors?e.errors.join(""):e.message
l.danger(`There was an error deleting the ${t.toUpperCase()} policy "${n}": ${a}.`)}))}}})
e.default=a})),define("vault/controllers/vault/cluster/policy/edit",["exports","@ember/controller","@ember/object","@ember/service"],(function(e,t,n,l){var a,i,r
function o(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function s(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let u=(a=class extends t.default{constructor(){super(...arguments),o(this,"router",i,this),o(this,"flashMessages",r,this)}async deletePolicy(){const{policyType:e,name:t}=this.model
try{await this.model.destroyRecord(),this.flashMessages.success(`${e.toUpperCase()} policy "${t}" was successfully deleted.`),this.router.transitionTo("vault.cluster.policies",e)}catch(n){this.model.rollbackAttributes()
const l=n.errors?n.errors.join(". "):n.message,a=`There was an error deleting the ${e.toUpperCase()} policy "${t}": ${l}.`
this.flashMessages.danger(a)}}},i=s(a.prototype,"router",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),r=s(a.prototype,"flashMessages",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s(a.prototype,"deletePolicy",[n.action],Object.getOwnPropertyDescriptor(a.prototype,"deletePolicy"),a.prototype),a)
e.default=u})),define("vault/controllers/vault/cluster/replication-dr-promote/index",["exports","@ember/controller"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({queryParams:["action"],action:"",actions:{onPromote(){this.transitionToRoute("vault.cluster.replication.mode.index","dr")}}})
e.default=n})),define("vault/controllers/vault/cluster/secrets/backend",["exports","@ember/controller"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({preferAdvancedEdit:!1})
e.default=n})),define("vault/controllers/vault/cluster/secrets/backend/actions-root",["exports","vault/controllers/vault/cluster/secrets/backend/actions"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/controllers/vault/cluster/secrets/backend/actions",["exports","@ember/controller","vault/mixins/backend-crumb"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend(n.default,{queryParams:{selectedAction:"action"},actions:{refresh:function(){this.send("refreshModel")}}})
e.default=l})),define("vault/controllers/vault/cluster/secrets/backend/configuration",["exports","@ember/object","@ember/controller"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=n.default.extend({isConfigurable:(0,t.computed)("model.type",(function(){return["aws","ssh"].includes(this.model.type)}))})
e.default=l})),define("vault/controllers/vault/cluster/secrets/backend/create-root",["exports","vault/controllers/vault/cluster/secrets/backend/create"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/controllers/vault/cluster/secrets/backend/create",["exports","@ember/controller","vault/mixins/backend-crumb"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend(n.default,{backendController:(0,t.inject)("vault.cluster.secrets.backend"),queryParams:["initialKey","itemType"],initialKey:"",itemType:"",actions:{refresh:function(){this.send("refreshModel")},toggleAdvancedEdit(e){this.set("preferAdvancedEdit",e),this.backendController.set("preferAdvancedEdit",e)}}})
e.default=l})),define("vault/controllers/vault/cluster/secrets/backend/credentials-root",["exports","vault/controllers/vault/cluster/secrets/backend/credentials"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/controllers/vault/cluster/secrets/backend/credentials",["exports","@ember/controller"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({queryParams:["action","roleType"],action:"",roleType:"",reset(){this.set("action",""),this.set("roleType","")}})
e.default=n})),define("vault/controllers/vault/cluster/secrets/backend/diff",["exports","@ember/controller","vault/mixins/backend-crumb"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends(t.default.extend(n.default)){}e.default=l})),define("vault/controllers/vault/cluster/secrets/backend/edit-root",["exports","vault/controllers/vault/cluster/secrets/backend/edit"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/controllers/vault/cluster/secrets/backend/edit",["exports","@ember/controller","vault/mixins/backend-crumb"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend(n.default,{backendController:(0,t.inject)("vault.cluster.secrets.backend"),queryParams:["version","itemType"],version:"",itemType:"",reset(){this.set("version",""),this.set("itemType","")},actions:{refresh:function(){this.send("refreshModel")},toggleAdvancedEdit(e){this.set("preferAdvancedEdit",e),this.backendController.set("preferAdvancedEdit",e)}}})
e.default=l})),define("vault/controllers/vault/cluster/secrets/backend/list-root",["exports","vault/controllers/vault/cluster/secrets/backend/list"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/controllers/vault/cluster/secrets/backend/list",["exports","@ember/object/computed","@ember/object","@ember/service","@ember/controller","vault/mixins/backend-crumb","vault/mixins/with-nav-to-nearest-ancestor","core/mixins/list-controller","core/utils/key-utils"],(function(e,t,n,l,a,i,r,o,s){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var u=a.default.extend(o.default,i.default,r.default,{flashMessages:(0,l.inject)(),queryParams:["page","pageFilter","tab"],tab:"",filterIsFolder:(0,n.computed)("filter",(function(){return!!(0,s.keyIsFolder)(this.filter)})),isConfigurableTab:(0,t.or)("isCertTab","isConfigure"),actions:{chooseAction(e){this.set("selectedAction",e)},toggleZeroAddress(e,t){e.toggleProperty("zeroAddress"),this.set("loading-"+e.id,!0),t.saveZeroAddressConfig().catch((t=>{e.set("zeroAddress",!1),this.flashMessages.danger(t.message)})).finally((()=>{this.set("loading-"+e.id,!1)}))},delete(e,t){const n=e.id
e.destroyRecord().then((()=>{this.flashMessages.success(`${n} was successfully deleted.`),this.send("reload"),"secret"===t&&this.navToNearestAncestor.perform(n)})).catch((e=>{const t=e.errors?e.errors.join(". "):e.message
this.flashMessages.danger(t)}))}}})
e.default=u}))
define("vault/controllers/vault/cluster/secrets/backend/metadata",["exports","@ember/controller","vault/mixins/backend-crumb","@ember/object"],(function(e,t,n,l){var a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(a=class extends(t.default.extend(n.default)){refreshModel(){this.send("refreshModel")}},r=a.prototype,o="refreshModel",s=[l.action],u=Object.getOwnPropertyDescriptor(a.prototype,"refreshModel"),d=a.prototype,c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a)
var r,o,s,u,d,c
e.default=i})),define("vault/controllers/vault/cluster/secrets/backend/show-root",["exports","vault/controllers/vault/cluster/secrets/backend/show"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/controllers/vault/cluster/secrets/backend/show",["exports","@ember/controller","vault/mixins/backend-crumb"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend(n.default,{backendController:(0,t.inject)("vault.cluster.secrets.backend"),queryParams:["tab","version","type","itemType","page"],version:"",tab:"",type:"",itemType:"",reset(){this.set("tab",""),this.set("version",""),this.set("type",""),this.set("itemType","")},actions:{refresh:function(){this.send("refreshModel")},toggleAdvancedEdit(e){this.set("preferAdvancedEdit",e),this.backendController.set("preferAdvancedEdit",e)}}})
e.default=l})),define("vault/controllers/vault/cluster/secrets/backend/sign-root",["exports","vault/controllers/vault/cluster/secrets/backend/sign"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/controllers/vault/cluster/secrets/backend/sign",["exports","@ember/service","@ember/controller","@ember/object"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=n.default.extend({store:(0,t.inject)(),loading:!1,emptyData:"{\n}",actions:{sign(){this.set("loading",!0),this.model.save().finally((()=>{this.set("loading",!1)}))},codemirrorUpdated(e,t,n){n.performLint()
n.state.lint.marked.length>0||(0,l.set)(this.model,e,JSON.parse(t))},updateTtl(e,t){const n=this.model,a=!0===t.enabled?`${t.seconds}s`:void 0;(0,l.set)(n,e,a)},newModel(){const e=this.model,t=e.get("role")
e.unloadRecord()
const n=this.store.createRecord("ssh-sign",{role:t,id:`${t.backend}-${t.name}`})
this.set("model",n)}}})
e.default=a})),define("vault/controllers/vault/cluster/secrets/backends",["exports","@ember/controller","@ember/service","@ember/object","@glimmer/tracking","@ember/object/computed","ember-concurrency"],(function(e,t,n,l,a,i,r){var o,s,u,d,c,p,m
function f(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function h(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let b=(o=(0,i.filterBy)("model","shouldIncludeInList"),s=class extends t.default{constructor(){super(...arguments),f(this,"flashMessages",u,this),f(this,"displayableBackends",d,this),f(this,"secretEngineOptions",c,this),f(this,"selectedEngineType",p,this),f(this,"selectedEngineName",m,this)}get sortedDisplayableBackends(){const e=this.displayableBackends.sort(((e,t)=>t.isSupportedBackend-e.isSupportedBackend||e.id-t.id))
return this.selectedEngineType?this.selectedEngineName?e.filter((e=>this.selectedEngineName===e.id)):e.filter((e=>this.selectedEngineType===e.engineType)):this.selectedEngineName?e.filter((e=>this.selectedEngineName===e.id)):e}get secretEngineArrayByType(){const e=this.sortedDisplayableBackends.map((e=>e.engineType))
return[...new Set(e)].map((e=>({name:e,id:e})))}get secretEngineArrayByName(){return this.sortedDisplayableBackends.map((e=>({name:e.id,id:e.id})))}filterEngineType(e){let[t]=e
this.selectedEngineType=t}filterEngineName(e){let[t]=e
this.selectedEngineName=t}*disableEngine(e){const{engineType:t,path:n}=e
try{yield e.destroyRecord(),this.flashMessages.success(`The ${t} Secrets Engine at ${n} has been disabled.`)}catch(l){this.flashMessages.danger(`There was an error disabling the ${t} Secrets Engine at ${n}: ${l.errors.join(" ")}.`)}}},u=h(s.prototype,"flashMessages",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=h(s.prototype,"displayableBackends",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=h(s.prototype,"secretEngineOptions",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return[]}}),p=h(s.prototype,"selectedEngineType",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),m=h(s.prototype,"selectedEngineName",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),h(s.prototype,"filterEngineType",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"filterEngineType"),s.prototype),h(s.prototype,"filterEngineName",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"filterEngineName"),s.prototype),h(s.prototype,"disableEngine",[r.dropTask],Object.getOwnPropertyDescriptor(s.prototype,"disableEngine"),s.prototype),s)
e.default=b})),define("vault/controllers/vault/cluster/settings",["exports","@ember/service","@ember/controller"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=n.default.extend({namespaceService:(0,t.inject)("namespace")})
e.default=l})),define("vault/controllers/vault/cluster/settings/auth/enable",["exports","@ember/controller"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({actions:{onMountSuccess:function(e,t){return this.transitionToRoute("vault.cluster.settings.auth.configure",t).followRedirects()}}})
e.default=n})),define("vault/controllers/vault/cluster/settings/configure-secret-backend",["exports","@ember/utils","@ember/service","@ember/controller"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const a={configured:!1,iamEndpoint:null,stsEndpoint:null,accessKey:null,secretKey:null,region:""}
var i=l.default.extend(a,{queryParams:["tab"],tab:"",flashMessages:(0,n.inject)(),loading:!1,reset(){this.model.rollbackAttributes(),this.setProperties(a)},actions:{saveConfig(){const e=(arguments.length>0&&void 0!==arguments[0]?arguments[0]:{delete:!1}).delete
"ssh"===this.model.type&&(this.set("loading",!0),this.model.saveCA({isDelete:e}).then((()=>{this.send("refreshRoute"),this.set("configured",!e),e?this.flashMessages.success("SSH Certificate Authority Configuration deleted!"):this.flashMessages.success("SSH Certificate Authority Configuration saved!")})).catch((e=>{const t=e.errors?e.errors.join(". "):e
this.flashMessages.danger(t)})).finally((()=>{this.set("loading",!1)})))},save(e,n){this.set("loading",!0)
Object.keys(n).some((e=>(0,t.isPresent)(n[e])))&&this.model.save({adapterOptions:{adapterMethod:e,data:n}}).then((()=>{this.reset(),this.flashMessages.success("The backend configuration saved successfully!")})).finally((()=>{this.set("loading",!1)}))}}})
e.default=i})),define("vault/controllers/vault/cluster/settings/mount-secret-backend",["exports","@ember/service","@ember/controller","vault/helpers/supported-secret-backends","vault/helpers/mountable-secret-engines","@ember/object"],(function(e,t,n,l,a,i){var r,o
function s(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const u=(0,l.supportedSecretBackends)()
let d=(r=class extends n.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="router",l=this,(n=o)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}onMountSuccess(e,t){let n,l=arguments.length>2&&void 0!==arguments[2]&&arguments[2]
if(u.includes(e)){const i=(0,a.allEngines)().findBy("type",e)
if(l)n=this.router.transitionTo(`vault.cluster.secrets.backend.${i.engineRoute}`,t)
else{const e=i?.routeQueryParams||{}
n=this.router.transitionTo("vault.cluster.secrets.backend.index",t,{queryParams:e})}}else n=this.router.transitionTo("vault.cluster.secrets.backends")
return n.followRedirects()}},o=s(r.prototype,"router",[t.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s(r.prototype,"onMountSuccess",[i.action],Object.getOwnPropertyDescriptor(r.prototype,"onMountSuccess"),r.prototype),r)
e.default=d})),define("vault/controllers/vault/cluster/settings/seal",["exports","@ember/service","@ember/controller"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=n.default.extend({auth:(0,t.inject)(),actions:{seal(){return this.model.cluster.store.adapterFor("cluster").seal().then((()=>(this.model.cluster.get("leaderNode").set("sealed",!0),this.auth.deleteCurrentToken(),this.transitionToRoute("vault.cluster.unseal"))))}}})
e.default=l})),define("vault/controllers/vault/cluster/unseal",["exports","@ember/controller"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({showLicenseError:!1,actions:{transitionToCluster(){return this.model.reload().then((()=>this.transitionToRoute("vault.cluster",this.model.name)))},reloadCluster(){return this.model.reload()},isUnsealed:e=>!1===e.sealed,handleLicenseError(){this.set("showLicenseError",!0)}}})
e.default=n})),define("vault/data-adapter",["exports","@ember-data/debug"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/decorators/confirm-leave",["exports","core/decorators/confirm-leave"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"withConfirmLeave",{enumerable:!0,get:function(){return t.withConfirmLeave}})})),define("vault/decorators/model-expanded-attributes",["exports","vault/utils/field-to-attrs","@ember-data/model","@ember/debug"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.withExpandedAttributes=function(){return function(e){return Object.prototype.isPrototypeOf.call(n.default,e)?class extends e{constructor(){super(...arguments),function(e,t,n){t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}(this,"_allByKey",null)}_expandGroups(e){if(!Array.isArray(e))throw new Error("_expandGroups expects an array of objects")
return e.map((e=>{const[t,n]=Object.entries(e)[0],l=n.map((e=>this.allByKey[e])).filter((e=>!!e))
return{[t]:l}}))}get allByKey(){if(!this._allByKey){const e={},n=[]
this.eachAttribute((function(e){n.push(e)}));(0,t.expandAttributeMeta)(this,n).forEach((t=>{e[t.name]=t})),this.eachRelationship((function(n,l){if("belongsTo"!==l.kind)return
const a=this[n],i=[]
a.eachAttribute((function(e){i.push(e)}));(0,t.expandAttributeMeta)(a,i).forEach((t=>{e[`${n}.${t.name}`]={...t,options:{...t.options,fieldValue:`${n}.${t.fieldValue||t.name}`}}}))}),this),this._allByKey=e}return this._allByKey}}:(console.error("withExpandedAttributes decorator must be used on instance of ember-data Model class. Decorator not applied to returned class"),e)}}})),define("vault/decorators/model-form-fields",["exports","vault/utils/field-to-attrs","@ember-data/model"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.withFormFields=function(e,l){return function(a){return Object.prototype.isPrototypeOf.call(n.default,a)?class extends a{constructor(){super(...arguments),e&&(this.formFields=(0,t.expandAttributeMeta)(this,e)),l&&(this.formFieldGroups=(0,t.default)(this,l))
const n=[]
this.eachAttribute((function(e){n.push(e)})),this.allFields=(0,t.expandAttributeMeta)(this,n)}}:(console.error("withFormFields decorator must be used on instance of ember-data Model class. Decorator not applied to returned class"),a)}}})),define("vault/decorators/model-validations",["exports","vault/utils/validators","@ember/object"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.withModelValidations=function(e){return function(l){var a,i
return i=a=class extends l{constructor(){if(super(...arguments),!e||"object"!=typeof e)throw new Error("Validations object must be provided to constructor for setup")
this._validations=e}validate(){let e=!0
const l={}
let a=0
for(const i in this._validations){const r=this._validations[i]
if(Array.isArray(r)){l[i]={errors:[],warnings:[]}
for(const a of r){const{type:r,options:o,level:s,message:u,validator:d}=a,c="function"==typeof d,p=c?d:t.default[r]
if(!p){console.error(r?`Validator type: "${r}" not found. Available validators: ${Object.keys(t.default).join(", ")}`:'Validator not found. Define either type or pass custom validator function under "validator" key in validations object')
continue}if(!(c?p(this):p((0,n.get)(this,i),o))){const t="function"==typeof u?u(this):u
"warn"===s?l[i].warnings.push(t):(l[i].errors.push(t),e&&(e=!1))}}a+=l[i].errors.length,l[i].isValid=!l[i].errors.length}else console.error(`Must provide validations as an array for property "${i}" on ${this.modelName} model`)}return{isValid:e,state:l,invalidFormMessage:this.generateErrorCountMessage(a)}}generateErrorCountMessage(e){if(e<1)return null
const t=e>1&&`are ${e} errors`
return`There ${t||"is an error"} with this form.`}},function(e,t,n){t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}(a,"_validations",void 0),i}}})),define("vault/flash/object",["exports","ember-cli-flash/flash/object"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/-date-base",["exports","@ember/runloop","@ember/component/helper","ember"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=n.default.extend({disableInterval:!1,compute(e,n){let{interval:a}=n
l.default.testing||this.disableInterval||(this.clearTimer(),a&&(this.intervalTimer=setTimeout((()=>{(0,t.run)((()=>this.recompute()))}),parseInt(a,10))))},clearTimer(){clearTimeout(this.intervalTimer)},destroy(){this.clearTimer(),this._super(...arguments)}})
e.default=a})),define("vault/helpers/add-to-array",["exports","@ember/component/helper","@ember/debug"],(function(e,t,n){function l(e){let[t,n]=e
Array.isArray(t)
const l=[...t]
return l.push(n),(a=l).filter(((e,t)=>a.indexOf(e)===t))
var a}Object.defineProperty(e,"__esModule",{value:!0}),e.addToArray=l,e.default=void 0
var a=(0,t.helper)(l)
e.default=a})),define("vault/helpers/add",["exports","@ember/component/helper"],(function(e,t){function n(e){return e.reduce(((e,t)=>parseInt(t,0)+e),0)}Object.defineProperty(e,"__esModule",{value:!0}),e.add=n,e.default=void 0
var l=(0,t.helper)(n)
e.default=l})),define("vault/helpers/all-features",["exports","@ember/component/helper"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.allFeatures=l,e.default=void 0
const n=["HSM","Performance Replication","DR Replication","MFA","Sentinel","Seal Wrapping","Control Groups","Performance Standby","Namespaces","KMIP","Entropy Augmentation","Transform Secrets Engine"]
function l(){return n}var a=(0,t.helper)(l)
e.default=a})),define("vault/helpers/and",["exports","ember-truth-helpers/helpers/and"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"and",{enumerable:!0,get:function(){return t.and}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/append",["exports","ember-composable-helpers/helpers/append"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"append",{enumerable:!0,get:function(){return t.append}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/assign",["exports","ember-assign-helper/helpers/assign"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"assign",{enumerable:!0,get:function(){return t.assign}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/await",["exports","@ember/component/helper","rsvp"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{compute(e){let[t]=e
return t&&"function"==typeof t.then?(t!==this.lastPromise&&(this.lastPromise=t,this.value=null,this.resolve(t)),this.value):t}async resolve(e){let t
try{t=await n.Promise.resolve(e)}catch(l){t=l}finally{e===this.lastPromise&&(this.value=t,this.recompute())}}}e.default=l})),define("vault/helpers/aws-regions",["exports","@ember/component/helper"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.regions=l
const n=["us-east-1","us-east-2","us-west-1","us-west-2","ca-central-1","ap-south-1","ap-northeast-1","ap-northeast-2","ap-southeast-1","ap-southeast-2","eu-central-1","eu-west-1","eu-west-2","sa-east-1"]
function l(){return n.slice(0)}var a=(0,t.helper)(l)
e.default=a})),define("vault/helpers/call",["exports","ember-composable-helpers/helpers/call"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"call",{enumerable:!0,get:function(){return t.call}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/camelize",["exports","ember-cli-string-helpers/helpers/camelize"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"camelize",{enumerable:!0,get:function(){return t.camelize}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/cancel-all",["exports","ember-concurrency/helpers/cancel-all"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/helpers/capitalize",["exports","ember-cli-string-helpers/helpers/capitalize"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"capitalize",{enumerable:!0,get:function(){return t.capitalize}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/changelog-url-for",["exports","core/helpers/changelog-url-for"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"changelogUrlFor",{enumerable:!0,get:function(){return t.changelogUrlFor}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/chunk",["exports","ember-composable-helpers/helpers/chunk"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"chunk",{enumerable:!0,get:function(){return t.chunk}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/classify",["exports","ember-cli-string-helpers/helpers/classify"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"classify",{enumerable:!0,get:function(){return t.classify}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/cluster-states",["exports","core/helpers/cluster-states"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"CLUSTER_STATES",{enumerable:!0,get:function(){return t.CLUSTER_STATES}}),Object.defineProperty(e,"clusterStates",{enumerable:!0,get:function(){return t.clusterStates}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/coerce-eq",["exports","@ember/component/helper"],(function(e,t){function n(e){return e[0]==e[1]}Object.defineProperty(e,"__esModule",{value:!0}),e.coerceEq=n,e.default=void 0
var l=(0,t.helper)(n)
e.default=l})),define("vault/helpers/compact",["exports","ember-composable-helpers/helpers/compact"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/compute",["exports","ember-composable-helpers/helpers/compute"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"compute",{enumerable:!0,get:function(){return t.compute}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/contains",["exports","ember-composable-helpers/helpers/contains"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"contains",{enumerable:!0,get:function(){return t.contains}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/dasherize",["exports","ember-cli-string-helpers/helpers/dasherize"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"dasherize",{enumerable:!0,get:function(){return t.dasherize}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/date-format",["exports","core/helpers/date-format"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/date-from-now",["exports","@ember/component/helper","date-fns"],(function(e,t,n){function l(e){let[t]=e,l=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{}
const a="string"==typeof t?new Date(t):t
return(0,n.formatDistanceToNow)(a,{...l})}Object.defineProperty(e,"__esModule",{value:!0}),e.dateFromNow=l,e.default=void 0
var a=(0,t.helper)(l)
e.default=a})),define("vault/helpers/dec",["exports","ember-composable-helpers/helpers/dec"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"dec",{enumerable:!0,get:function(){return t.dec}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/decode-uri",["exports","@ember/component/helper"],(function(e,t){function n(e){return decodeURI(e)}Object.defineProperty(e,"__esModule",{value:!0}),e.decodeUri=n,e.default=void 0
var l=(0,t.helper)(n)
e.default=l})),define("vault/helpers/drop",["exports","ember-composable-helpers/helpers/drop"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/element",["exports","ember-element-helper/helpers/element"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/ember-power-select-is-group",["exports","ember-power-select/helpers/ember-power-select-is-group"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"emberPowerSelectIsGroup",{enumerable:!0,get:function(){return t.emberPowerSelectIsGroup}})})),define("vault/helpers/ember-power-select-is-selected",["exports","ember-power-select/helpers/ember-power-select-is-selected"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"emberPowerSelectIsSelected",{enumerable:!0,get:function(){return t.emberPowerSelectIsSelected}})})),define("vault/helpers/ensure-safe-component",["exports","@embroider/util"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.EnsureSafeComponentHelper}})})),define("vault/helpers/entries",["exports","ember-composable-helpers/helpers/entries"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"entries",{enumerable:!0,get:function(){return t.entries}})})),define("vault/helpers/eq",["exports","ember-truth-helpers/helpers/equal"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"equal",{enumerable:!0,get:function(){return t.equal}})})),define("vault/helpers/filter-by",["exports","ember-composable-helpers/helpers/filter-by"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/filter-wildcard",["exports","@ember/component/helper"],(function(e,t){function n(e){let[t,n]=e
if(!t||!n)return
!t.id&&t&&(t={id:t})
return(e=>n.filter((t=>new RegExp("^"+e.replace(/\*/g,".*")+"$").test(t))))(t.id).length}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.filterWildcard=n
var l=(0,t.helper)(n)
e.default=l})),define("vault/helpers/filter",["exports","ember-composable-helpers/helpers/filter"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/find-by",["exports","ember-composable-helpers/helpers/find-by"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/flatten",["exports","ember-composable-helpers/helpers/flatten"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"flatten",{enumerable:!0,get:function(){return t.flatten}})})),define("vault/helpers/format-duration",["exports","core/helpers/format-duration"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"duration",{enumerable:!0,get:function(){return t.duration}})})),define("vault/helpers/format-number",["exports","core/helpers/format-number"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"formatNumber",{enumerable:!0,get:function(){return t.formatNumber}})})),define("vault/helpers/from-entries",["exports","ember-composable-helpers/helpers/from-entries"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"fromEntries",{enumerable:!0,get:function(){return t.fromEntries}})})),define("vault/helpers/group-by",["exports","ember-composable-helpers/helpers/group-by"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/helpers/gt",["exports","ember-truth-helpers/helpers/gt"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"gt",{enumerable:!0,get:function(){return t.gt}})})),define("vault/helpers/gte",["exports","ember-truth-helpers/helpers/gte"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"gte",{enumerable:!0,get:function(){return t.gte}})})),define("vault/helpers/has-feature",["exports","core/helpers/has-feature"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/has-next",["exports","ember-composable-helpers/helpers/has-next"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"hasNext",{enumerable:!0,get:function(){return t.hasNext}})})),define("vault/helpers/has-permission",["exports","@ember/component/helper","@ember/service","@ember/object"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=t.default.extend({permissions:(0,n.inject)(),onPermissionsChange:(0,l.observer)("permissions.exactPaths","permissions.globPaths","permissions.canViewAll",(function(){this.recompute()})),compute(e,t){let[n]=e
const{routeParams:l,requireAll:a}=t
return this.permissions.hasNavPermission(n,l,a)}})
e.default=a})),define("vault/helpers/has-previous",["exports","ember-composable-helpers/helpers/has-previous"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"hasPrevious",{enumerable:!0,get:function(){return t.hasPrevious}})})),define("vault/helpers/hds-link-to-models",["exports","@hashicorp/design-system-components/helpers/hds-link-to-models"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/hds-link-to-query",["exports","@hashicorp/design-system-components/helpers/hds-link-to-query"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/html-safe",["exports","ember-cli-string-helpers/helpers/html-safe"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"htmlSafe",{enumerable:!0,get:function(){return t.htmlSafe}})})),define("vault/helpers/humanize",["exports","ember-cli-string-helpers/helpers/humanize"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"humanize",{enumerable:!0,get:function(){return t.humanize}})})),define("vault/helpers/if-key",["exports","ember-keyboard/helpers/if-key.js"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/ignore-children",["exports","ember-modal-dialog/helpers/ignore-children"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/img-path",["exports","core/helpers/img-path"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/inc",["exports","ember-composable-helpers/helpers/inc"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"inc",{enumerable:!0,get:function(){return t.inc}})})),define("vault/helpers/includes",["exports","ember-composable-helpers/helpers/includes"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"includes",{enumerable:!0,get:function(){return t.includes}})})),define("vault/helpers/intersect",["exports","ember-composable-helpers/helpers/intersect"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/invoke",["exports","ember-composable-helpers/helpers/invoke"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"invoke",{enumerable:!0,get:function(){return t.invoke}})})),define("vault/helpers/is-active-route",["exports","core/helpers/is-active-route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"isActiveRoute",{enumerable:!0,get:function(){return t.isActiveRoute}})})),define("vault/helpers/is-active",["exports","ember-router-helpers/helpers/is-active"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"isActive",{enumerable:!0,get:function(){return t.isActive}})})),define("vault/helpers/is-after",["exports","vault/helpers/-date-base","date-fns"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend({compute:function(e){let[t,l]=e
return this._super(...arguments),(0,n.isAfter)(t,l)}})
e.default=l})),define("vault/helpers/is-array",["exports","ember-truth-helpers/helpers/is-array"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"isArray",{enumerable:!0,get:function(){return t.isArray}})})),define("vault/helpers/is-before",["exports","vault/helpers/-date-base","date-fns"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend({compute:function(e){let[t,l]=e
return this._super(...arguments),(0,n.isBefore)(t,l)}})
e.default=l})),define("vault/helpers/is-clipboard-supported",["exports","ember-cli-clipboard/helpers/is-clipboard-supported"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/is-empty-value",["exports","@ember/component/helper"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=(0,t.helper)((function(e,t){let[n]=e,{hasDefault:l=!1}=t
return l&&(n=l),"object"==typeof n&&null!==n?0===Object.keys(n).length:null==n||""===n}))
e.default=n})),define("vault/helpers/is-empty",["exports","ember-truth-helpers/helpers/is-empty"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/is-equal",["exports","ember-truth-helpers/helpers/is-equal"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"isEqual",{enumerable:!0,get:function(){return t.isEqual}})})),define("vault/helpers/is-version",["exports","core/helpers/is-version"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/is-wildcard-string",["exports","@ember/component/helper"],(function(e,t){function n(e){let[t]=e
if(!t)return!1
if("object"==typeof t){if(Object.prototype.hasOwnProperty.call(t,"store"))return!1
t=Object.values(t).toString()}return t.includes("*")}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.isWildcardString=n
var l=(0,t.helper)(n)
e.default=l})),define("vault/helpers/join",["exports","ember-composable-helpers/helpers/join"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/jsonify",["exports","core/helpers/jsonify"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"jsonify",{enumerable:!0,get:function(){return t.jsonify}})}))
define("vault/helpers/keys",["exports","ember-composable-helpers/helpers/keys"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"keys",{enumerable:!0,get:function(){return t.keys}})})),define("vault/helpers/loose-equal",["exports","core/helpers/loose-equal"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/lowercase",["exports","ember-cli-string-helpers/helpers/lowercase"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"lowercase",{enumerable:!0,get:function(){return t.lowercase}})})),define("vault/helpers/lt",["exports","ember-truth-helpers/helpers/lt"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"lt",{enumerable:!0,get:function(){return t.lt}})})),define("vault/helpers/lte",["exports","ember-truth-helpers/helpers/lte"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"lte",{enumerable:!0,get:function(){return t.lte}})})),define("vault/helpers/map-by",["exports","ember-composable-helpers/helpers/map-by"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/map",["exports","ember-composable-helpers/helpers/map"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/media",["exports","ember-responsive/helpers/media"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/message-types",["exports","core/helpers/message-types"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"MESSAGE_TYPES",{enumerable:!0,get:function(){return t.MESSAGE_TYPES}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"messageTypes",{enumerable:!0,get:function(){return t.messageTypes}})})),define("vault/helpers/mountable-auth-methods",["exports","@ember/component/helper"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.allMethods=function(){return[...l,...n]},e.default=void 0,e.methods=a
const n=[{displayName:"SAML",value:"saml",type:"saml",category:"generic"}],l=[{displayName:"AliCloud",value:"alicloud",type:"alicloud",category:"cloud"},{displayName:"AppRole",value:"approle",type:"approle",category:"generic"},{displayName:"AWS",value:"aws",type:"aws",category:"cloud",glyph:"aws-color"},{displayName:"Azure",value:"azure",type:"azure",category:"cloud",glyph:"azure-color"},{displayName:"Google Cloud",value:"gcp",type:"gcp",category:"cloud",glyph:"gcp-color"},{displayName:"GitHub",value:"github",type:"github",category:"cloud",glyph:"github-color"},{displayName:"JWT",value:"jwt",type:"jwt",glyph:"auth",category:"generic"},{displayName:"OIDC",value:"oidc",type:"oidc",glyph:"auth",category:"generic"},{displayName:"Kubernetes",value:"kubernetes",type:"kubernetes",category:"infra",glyph:"kubernetes-color"},{displayName:"LDAP",value:"ldap",type:"ldap",glyph:"auth",category:"infra"},{displayName:"Okta",value:"okta",type:"okta",category:"infra",glyph:"okta-color"},{displayName:"RADIUS",value:"radius",type:"radius",glyph:"auth",category:"infra"},{displayName:"TLS Certificates",value:"cert",type:"cert",category:"generic"},{displayName:"Username & Password",value:"userpass",type:"userpass",category:"generic"}]
function a(){return l.slice()}var i=(0,t.helper)(a)
e.default=i})),define("vault/helpers/mountable-secret-engines",["exports","@ember/component/helper"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.allEngines=i,e.default=void 0,e.isAddonEngine=function(e,t){if("kv"===e&&1===t)return!1
return!!i().findBy("type",e)?.engineRoute},e.mountableEngines=a
const n=[{displayName:"KMIP",type:"kmip",engineRoute:"kmip.scopes.index",category:"generic",requiredFeature:"KMIP"},{displayName:"Transform",type:"transform",category:"generic",requiredFeature:"Transform Secrets Engine"},{displayName:"Key Management",type:"keymgmt",glyph:"key",category:"cloud",requiredFeature:"Key Management Secrets Engine",routeQueryParams:{tab:"provider"}}],l=[{displayName:"AliCloud",type:"alicloud",category:"cloud"},{displayName:"AWS",type:"aws",category:"cloud",glyph:"aws-color"},{displayName:"Azure",type:"azure",category:"cloud",glyph:"azure-color"},{displayName:"Consul",type:"consul",category:"infra"},{displayName:"Databases",type:"database",category:"infra"},{displayName:"Google Cloud",type:"gcp",category:"cloud",glyph:"gcp-color"},{displayName:"Google Cloud KMS",type:"gcpkms",category:"cloud",glyph:"gcp-color"},{displayName:"KV",type:"kv",engineRoute:"kv.list",category:"generic"},{displayName:"Nomad",type:"nomad",category:"infra"},{displayName:"PKI Certificates",type:"pki",engineRoute:"pki.overview",category:"generic"},{displayName:"RabbitMQ",type:"rabbitmq",category:"infra"},{displayName:"SSH",type:"ssh",category:"generic"},{displayName:"Transit",type:"transit",category:"generic"},{displayName:"TOTP",type:"totp",category:"generic"},{displayName:"LDAP",type:"ldap",engineRoute:"ldap.overview",category:"generic",glyph:"folder-users"},{displayName:"Kubernetes",type:"kubernetes",engineRoute:"kubernetes.overview",category:"generic",glyph:"kubernetes-color"}]
function a(){return l.slice()}function i(){return[...l,...n]}var r=(0,t.helper)(a)
e.default=r})),define("vault/helpers/multi-line-join",["exports","@ember/component/helper"],(function(e,t){function n(e){let[t]=e
return t.join("\n")}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.multiLineJoin=n
var l=(0,t.helper)(n)
e.default=l})),define("vault/helpers/nav-to-route",["exports","@ember/service","@ember/component/helper"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=n.default.extend({router:(0,t.inject)(),compute(e,t){let[n,...l]=e,{replace:a=!1}=t
return()=>{const e=this.router
return(a?e.replaceWith:e.transitionTo).call(e,n,...l)}}})
e.default=l})),define("vault/helpers/next",["exports","ember-composable-helpers/helpers/next"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"next",{enumerable:!0,get:function(){return t.next}})})),define("vault/helpers/noop",["exports","ember-composable-helpers/helpers/noop"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"noop",{enumerable:!0,get:function(){return t.noop}})})),define("vault/helpers/not-eq",["exports","ember-truth-helpers/helpers/not-equal"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"notEqualHelper",{enumerable:!0,get:function(){return t.notEqualHelper}})})),define("vault/helpers/not",["exports","ember-truth-helpers/helpers/not"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"not",{enumerable:!0,get:function(){return t.not}})})),define("vault/helpers/now",["exports","vault/helpers/-date-base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({compute(){return this._super(...arguments),Date.now()}})
e.default=n})),define("vault/helpers/number-to-word",["exports","@ember/component/helper"],(function(e,t){function n(e,t){const n={0:"zero",1:"one",2:"two",3:"three",4:"four",5:"five",6:"six",7:"seven",8:"eight",9:"nine"}[e]||e
return t&&"string"==typeof n?`${n.charAt(0).toUpperCase()}${n.slice(1)}`:n}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.numberToWord=n
var l=(0,t.helper)((function(e,t){let[l]=e,{capitalize:a}=t
return n(l,a)}))
e.default=l})),define("vault/helpers/object-at",["exports","ember-composable-helpers/helpers/object-at"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"objectAt",{enumerable:!0,get:function(){return t.objectAt}})})),define("vault/helpers/on-key",["exports","ember-keyboard/helpers/on-key.js"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/optional",["exports","ember-composable-helpers/helpers/optional"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"optional",{enumerable:!0,get:function(){return t.optional}})})),define("vault/helpers/options-for-backend",["exports","core/helpers/options-for-backend"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/or",["exports","ember-truth-helpers/helpers/or"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"or",{enumerable:!0,get:function(){return t.or}})})),define("vault/helpers/page-title",["exports","ember-page-title/helpers/page-title"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default
e.default=n})),define("vault/helpers/path-or-array",["exports","core/helpers/path-or-array"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/perform",["exports","ember-concurrency/helpers/perform"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/pick",["exports","ember-composable-helpers/helpers/pick"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"pick",{enumerable:!0,get:function(){return t.pick}})})),define("vault/helpers/pipe-action",["exports","ember-composable-helpers/helpers/pipe-action"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/pipe",["exports","ember-composable-helpers/helpers/pipe"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"pipe",{enumerable:!0,get:function(){return t.pipe}})}))
define("vault/helpers/pluralize",["exports","ember-inflector/lib/helpers/pluralize"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default
e.default=n})),define("vault/helpers/previous",["exports","ember-composable-helpers/helpers/previous"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"previous",{enumerable:!0,get:function(){return t.previous}})})),define("vault/helpers/queue",["exports","ember-composable-helpers/helpers/queue"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"queue",{enumerable:!0,get:function(){return t.queue}})})),define("vault/helpers/range",["exports","ember-composable-helpers/helpers/range"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"range",{enumerable:!0,get:function(){return t.range}})})),define("vault/helpers/reduce",["exports","ember-composable-helpers/helpers/reduce"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/reject-by",["exports","ember-composable-helpers/helpers/reject-by"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/remove-from-array",["exports","@ember/component/helper","@ember/debug"],(function(e,t,n){function l(e){let[t,n]=e
Array.isArray(t)
const l=[...t],a=l.indexOf(n)
return a>=0&&l.splice(a,1),(i=l).filter(((e,t)=>i.indexOf(e)===t))
var i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.removeFromArray=l
var a=(0,t.helper)(l)
e.default=a})),define("vault/helpers/repeat",["exports","ember-composable-helpers/helpers/repeat"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"repeat",{enumerable:!0,get:function(){return t.repeat}})})),define("vault/helpers/replication-action-for-mode",["exports","core/helpers/replication-action-for-mode"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/replication-mode-description",["exports","core/helpers/replication-mode-description"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"REPLICATION_MODE_DESCRIPTIONS",{enumerable:!0,get:function(){return t.REPLICATION_MODE_DESCRIPTIONS}}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"replicationModeDescription",{enumerable:!0,get:function(){return t.replicationModeDescription}})})),define("vault/helpers/reverse",["exports","ember-composable-helpers/helpers/reverse"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/root-url",["exports","ember-router-helpers/helpers/root-url"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"rootUrl",{enumerable:!0,get:function(){return t.rootUrl}})})),define("vault/helpers/route-params-for",["exports","@ember/component/helper","@ember/service"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend({permissions:(0,n.inject)(),compute(e){let[t]=e
return this.permissions.navPathParams(t)}})
e.default=l})),define("vault/helpers/route-params",["exports","ember-router-helpers/helpers/route-params"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"routeParams",{enumerable:!0,get:function(){return t.routeParams}})})),define("vault/helpers/sanitized-html",["exports","core/helpers/sanitized-html"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/secret-query-params",["exports","@ember/component/helper"],(function(e,t){function n(e,t){let[n,l=""]=e,{asQueryParams:a}=t
const i={transit:{tab:"actions"},database:{type:l},keymgmt:{itemType:"provider"===l?"provider":"key"}}[n]
return i&&a?{isQueryParams:!0,values:i}:i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.secretQueryParams=n
var l=(0,t.helper)(n)
e.default=l})),define("vault/helpers/set-flash-message",["exports","core/helpers/set-flash-message"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"setFlashMessage",{enumerable:!0,get:function(){return t.setFlashMessage}})})),define("vault/helpers/sha2-digest-sizes",["exports","@ember/component/helper"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.sha2DigestSizes=l
const n=["sha2-224","sha2-256","sha2-384","sha2-512"]
function l(){return n}var a=(0,t.helper)(l)
e.default=a})),define("vault/helpers/shuffle",["exports","ember-composable-helpers/helpers/shuffle"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"shuffle",{enumerable:!0,get:function(){return t.shuffle}})})),define("vault/helpers/singularize",["exports","ember-inflector/lib/helpers/singularize"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default
e.default=n})),define("vault/helpers/slice",["exports","ember-composable-helpers/helpers/slice"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/sort-by",["exports","ember-composable-helpers/helpers/sort-by"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/split-object",["exports","@ember/component/helper"],(function(e,t){function n(e,t){const n={},l={}
return Object.keys(e).forEach((a=>{t.includes(a)?n[a]=e[a]:l[a]=e[a]})),[n,l]}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.splitObject=n
var l=(0,t.helper)(n)
e.default=l})),define("vault/helpers/stringify",["exports","core/helpers/stringify"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"stringify",{enumerable:!0,get:function(){return t.stringify}})})),define("vault/helpers/sub",["exports","@ember/component/helper"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=(0,t.helper)((function(e){let[t,...n]=e
return n.reduce(((e,t)=>e-parseInt(t,0)),t)}))
e.default=n})),define("vault/helpers/supported-auth-backends",["exports","@ember/component/helper"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.allSupportedAuthBackends=function(){return[...n,...l]},e.default=void 0,e.supportedAuthBackends=a
const n=[{type:"token",typeDisplay:"Token",description:"Token authentication.",tokenPath:"id",displayNamePath:"display_name",formAttributes:["token"]},{type:"userpass",typeDisplay:"Username",description:"A simple username and password backend.",tokenPath:"client_token",displayNamePath:"metadata.username",formAttributes:["username","password"]},{type:"ldap",typeDisplay:"LDAP",description:"LDAP authentication.",tokenPath:"client_token",displayNamePath:"metadata.username",formAttributes:["username","password"]},{type:"okta",typeDisplay:"Okta",description:"Authenticate with your Okta username and password.",tokenPath:"client_token",displayNamePath:"metadata.username",formAttributes:["username","password"]},{type:"jwt",typeDisplay:"JWT",description:"Authenticate using JWT or OIDC provider.",tokenPath:"client_token",displayNamePath:"display_name",formAttributes:["role","jwt"]},{type:"oidc",typeDisplay:"OIDC",description:"Authenticate using JWT or OIDC provider.",tokenPath:"client_token",displayNamePath:"display_name",formAttributes:["role","jwt"]},{type:"radius",typeDisplay:"RADIUS",description:"Authenticate with your RADIUS username and password.",tokenPath:"client_token",displayNamePath:"metadata.username",formAttributes:["username","password"]},{type:"github",typeDisplay:"GitHub",description:"GitHub authentication.",tokenPath:"client_token",displayNamePath:["metadata.org","metadata.username"],formAttributes:["token"]}],l=[{type:"saml",typeDisplay:"SAML",description:"Authenticate using SAML provider.",tokenPath:"client_token",displayNamePath:"display_name",formAttributes:["role"]}]
function a(){return n}var i=(0,t.helper)(a)
e.default=i})),define("vault/helpers/supported-managed-auth-backends",["exports","@ember/component/helper"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.supportedManagedAuthBackends=l
const n=["cert","userpass","ldap","okta","radius"]
function l(){return n}var a=(0,t.helper)(l)
e.default=a})),define("vault/helpers/supported-secret-backends",["exports","@ember/component/helper"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.supportedSecretBackends=l
const n=["aws","database","cubbyhole","generic","kv","pki","ssh","transit","kmip","transform","keymgmt","kubernetes","ldap"]
function l(){return n}var a=(0,t.helper)(l)
e.default=a})),define("vault/helpers/svg-jar",["exports","ember-svg-jar/helpers/svg-jar"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"svgJar",{enumerable:!0,get:function(){return t.svgJar}})})),define("vault/helpers/tabs-for-auth-section",["exports","@ember/component/helper","ember-inflector","@ember/string"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.tabsForAuthSection=r
const a={aws:[{label:"Client",routeParams:["vault.cluster.settings.auth.configure.section","client"]},{label:"Identity Allow List Tidy",routeParams:["vault.cluster.settings.auth.configure.section","identity-accesslist"]},{label:"Role Tag Deny List Tidy",routeParams:["vault.cluster.settings.auth.configure.section","roletag-denylist"]}],azure:[{label:"Configuration",routeParams:["vault.cluster.settings.auth.configure.section","configuration"]}],github:[{label:"Configuration",routeParams:["vault.cluster.settings.auth.configure.section","configuration"]}],gcp:[{label:"Configuration",routeParams:["vault.cluster.settings.auth.configure.section","configuration"]}],jwt:[{label:"Configuration",routeParams:["vault.cluster.settings.auth.configure.section","configuration"]}],oidc:[{label:"Configuration",routeParams:["vault.cluster.settings.auth.configure.section","configuration"]}],kubernetes:[{label:"Configuration",routeParams:["vault.cluster.settings.auth.configure.section","configuration"]}],ldap:[{label:"Configuration",routeParams:["vault.cluster.settings.auth.configure.section","configuration"]}],okta:[{label:"Configuration",routeParams:["vault.cluster.settings.auth.configure.section","configuration"]}],radius:[{label:"Configuration",routeParams:["vault.cluster.settings.auth.configure.section","configuration"]}]},i={}
function r(e){let t,[r,o="authSettings",s]=e
return"authSettings"===o?(t=(a[r.type]||[]).slice(),t.push({label:"Method Options",routeParams:["vault.cluster.settings.auth.configure.section","options"]}),t):(s||r.paths?(r.paths&&(s=r.paths.paths.filter((e=>e.navigation))),t=s.compact().map((e=>({label:(0,l.capitalize)((0,n.pluralize)(e.itemName)),routeParams:["vault.cluster.access.method.item.list",e.itemType]})))):t=(i[r.type]||[]).slice(),t.push({label:"Configuration",routeParams:["vault.cluster.access.method.section","configuration"]}),t)}var o=(0,t.helper)(r)
e.default=o}))
define("vault/helpers/tabs-for-identity-show",["exports","@ember/component/helper"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=e.TABS=void 0,e.tabsForIdentityShow=l
const n={entity:["details","aliases","policies","groups","metadata"],"entity-alias":["details","metadata"],group:["details","aliases","policies","members","parent-groups","metadata"],"group-internal":["details","policies","members","parent-groups","metadata"],"group-external":["details","aliases","policies","members","parent-groups","metadata"],"group-alias":["details"]}
function l(e){let[t,l]=e,a=t
return l&&(a=`${a}-${l}`),n[a]}e.TABS=n
var a=(0,t.helper)(l)
e.default=a})),define("vault/helpers/take",["exports","ember-composable-helpers/helpers/take"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/task",["exports","ember-concurrency/helpers/task"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/titleize",["exports","ember-cli-string-helpers/helpers/titleize"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"titleize",{enumerable:!0,get:function(){return t.titleize}})})),define("vault/helpers/to-label",["exports","core/helpers/to-label"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/toggle-action",["exports","ember-composable-helpers/helpers/toggle-action"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/toggle",["exports","ember-composable-helpers/helpers/toggle"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"toggle",{enumerable:!0,get:function(){return t.toggle}})})),define("vault/helpers/tools-actions",["exports","@ember/component/helper"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.toolsActions=l
const n=["wrap","lookup","unwrap","rewrap","random","hash"]
function l(){return n}var a=(0,t.helper)(l)
e.default=a})),define("vault/helpers/transition-to",["exports","ember-router-helpers/helpers/transition-to"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"transitionTo",{enumerable:!0,get:function(){return t.transitionTo}})})),define("vault/helpers/trim",["exports","ember-cli-string-helpers/helpers/trim"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"trim",{enumerable:!0,get:function(){return t.trim}})})),define("vault/helpers/truncate",["exports","ember-cli-string-helpers/helpers/truncate"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"truncate",{enumerable:!0,get:function(){return t.truncate}})})),define("vault/helpers/underscore",["exports","ember-cli-string-helpers/helpers/underscore"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"underscore",{enumerable:!0,get:function(){return t.underscore}})})),define("vault/helpers/union",["exports","ember-composable-helpers/helpers/union"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/helpers/uppercase",["exports","ember-cli-string-helpers/helpers/uppercase"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"uppercase",{enumerable:!0,get:function(){return t.uppercase}})})),define("vault/helpers/url-for",["exports","ember-router-helpers/helpers/url-for"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"urlFor",{enumerable:!0,get:function(){return t.urlFor}})})),define("vault/helpers/values",["exports","ember-composable-helpers/helpers/values"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"values",{enumerable:!0,get:function(){return t.values}})})),define("vault/helpers/w",["exports","ember-cli-string-helpers/helpers/w"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"w",{enumerable:!0,get:function(){return t.w}})})),define("vault/helpers/without",["exports","ember-composable-helpers/helpers/without"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"without",{enumerable:!0,get:function(){return t.without}})})),define("vault/helpers/wizard-constants",["exports","vault/machines/tutorial-machine","vault/machines/secrets-machine","vault/machines/policies-machine","vault/machines/replication-machine","vault/machines/tools-machine","vault/machines/auth-machine"],(function(e,t,n,l,a,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.STORAGE_KEYS=e.MACHINES=e.INIT_STEPS=e.FEATURE_MACHINE_TIME=e.FEATURE_MACHINE_STEPS=e.DEFAULTS=void 0
e.STORAGE_KEYS={TUTORIAL_STATE:"vault:ui-tutorial-state",FEATURE_LIST:"vault:ui-feature-list",FEATURE_STATE:"vault:ui-feature-state",FEATURE_STATE_HISTORY:"vault:ui-feature-state-history",COMPLETED_FEATURES:"vault:ui-completed-list",COMPONENT_STATE:"vault:ui-component-state",RESUME_URL:"vault:ui-tutorial-resume-url",RESUME_ROUTE:"vault:ui-tutorial-resume-route"}
const o={tutorial:t.default,secrets:n.default,policies:l.default,replication:a.default,tools:i.default,authentication:r.default}
e.MACHINES=o
e.DEFAULTS={currentState:null,featureList:null,featureState:null,currentMachine:null,tutorialComponent:null,featureComponent:null,stepComponent:null,detailsComponent:null,componentState:null,nextFeature:null,nextStep:null,featureMachineHistory:null}
e.FEATURE_MACHINE_STEPS={secrets:{encryption:5,secret:{list:4,secret:5},role:7,provider:8},policies:5,replication:2,tools:8,authentication:4}
e.INIT_STEPS=["setup","save","unseal","login"]
e.FEATURE_MACHINE_TIME={secrets:7,policies:5,replication:5,tools:8,authentication:5}})),define("vault/helpers/xor",["exports","ember-truth-helpers/helpers/xor"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"xor",{enumerable:!0,get:function(){return t.xor}})})),define("vault/initializers/container-debug-adapter",["exports","ember-resolver/resolvers/classic/container-debug-adapter"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n={name:"container-debug-adapter",initialize(){(arguments[1]||arguments[0]).register("container-debug-adapter:main",t.default)}}
e.default=n})),define("vault/initializers/deprecation-filter",["exports","@ember/debug"],(function(e,t){function n(){(0,t.registerDeprecationHandler)(((e,t,n)=>{t?.until.includes("5.0")||n(e,t)}))}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.initialize=n
var l={initialize:n}
e.default=l})),define("vault/initializers/disable-ember-inspector",["exports","vault/config/environment"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n={name:"ember-inspect-disable",initialize:function(){"production"===t.default.environment&&(window.NO_EMBER_DEBUG=!0)}}
e.default=n})),define("vault/initializers/ember-cli-mirage",["exports"],(function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var t={name:"ember-cli-mirage",initialize(){}}
e.default=t})),define("vault/initializers/ember-data-data-adapter",["exports","@ember-data/debug/setup"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/initializers/ember-data-identifiers",["exports","@ember-data/store","@ember/string","uuid"],(function(e,t,n,l){function a(){(0,t.setIdentifierGenerationMethod)((e=>e.lid?e.lid:e.id?`@lid:${(0,n.dasherize)(e.type)}-${e.id}`:(0,l.v4)()))}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.initialize=a
var i={name:"ember-data-identifiers",initialize:a}
e.default=i})),define("vault/initializers/ember-data",["exports","ember-data","ember-data/setup-container"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l={name:"ember-data",initialize:n.default}
e.default=l})),define("vault/initializers/ember-responsive-breakpoints",["exports","ember-responsive/initializers/responsive"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default
e.default=n})),define("vault/initializers/enable-engines",["exports","vault/config/environment"],(function(e,t){function n(){t.default.addRootMounts=function(){this.mount("replication")}}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.initialize=n
var l={initialize:n}
e.default=l})),define("vault/initializers/engines",["exports","ember-engines/initializers/engines"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"initialize",{enumerable:!0,get:function(){return t.initialize}})}))
define("vault/instance-initializers/add-modals-container",["exports","ember-modal-dialog/instance-initializers/add-modals-container"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n={name:"add-modals-container",initialize:t.default}
e.default=n})),define("vault/instance-initializers/ember-data",["exports"],(function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var t={name:"ember-data",initialize(){}}
e.default=t})),define("vault/instance-initializers/load-asset-manifest",["exports","vault/config/asset-manifest"],(function(e,t){function n(e){e.lookup("service:asset-loader").pushManifest(t.default)}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.initialize=n
var l={name:"load-asset-manifest",initialize:n}
e.default=l})),define("vault/instance-initializers/track-csp-event",["exports"],(function(e){function t(e){e.lookup("service:csp-event").attach()}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.initialize=t
var n={name:"track-csp-event",initialize:t}
e.default=n})),define("vault/lib/arg-tokenizer",["exports"],(function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=function(e){if(Array.isArray(e))return e
e=e.trim()
for(var t=0,n=null,l=null,a=null,i=[],r=0;r<e.length;r++)n=l," "!==(l=e.charAt(r))||a?(l===a?(i[t]||(i[t]=""),a=null):"'"!==l&&'"'!==l||a||(a=l),i[t]||(i[t]=""),i[t]+=l):" "!==n&&t++
return i}})),define("vault/lib/attach-capabilities",["exports","@ember-data/model","@ember/debug","@ember/utils","@ember/array"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=function(e,i){const r=Object.keys(i),o=r.reduce(((e,n)=>(e[n]=(0,t.belongsTo)("capabilities"),e)),{})
return(0,n.debug)(`adding new relationships: ${r.join(", ")} to ${e.toString()}`),e.reopen(o),e.reopenClass({relatedCapabilities(e){let{data:t,included:n}=e
if(t||(t=e),(0,a.isArray)(t)){return{data:t.map(this.relatedCapabilities),included:n}}const o={id:t.id,...t.attributes}
for(const a of r){const e=i[a];(0,l.typeOf)(e)
t.relationships[a]={data:{type:"capabilities",id:e(o)}}}return n?{data:t,included:n}:t}}),e}})),define("vault/lib/console-helpers",["exports","core/utils/key-codes","shell-quote","vault/lib/arg-tokenizer"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.executeUICommand=function(e,t,n){const l=e.startsWith("api")?"api":e,a=i.includes(l)
a&&t(e)
const r=n[l]
r&&"function"==typeof r&&r()
return a},e.extractDataFromStrings=function(e){return e?e.reduce(((e,t)=>{const[n="",l=""]=t.split(/=(.+)?/)
if(!n)return e
const a=e[n]
return a?(e[n]=Array.isArray(a)?[...a,l]:[a,l],e):(e[n]=l,e)}),{}):{}},e.extractFlagsFromStrings=function(e,t){return e?e.reduce(((e,n)=>{const[l,a]=n.split(/=(.+)?/)
if(!l)return e
let i=l.replace(/^-/,"")
return"wrap-ttl"===i?i="wrapTTL":"write"===t&&("f"!==i&&"-force"!==i||(i="force")),e[i]=a||!0,e}),{}):{}},e.formattedErrorFromInput=function(e,t,n,l){if(void 0===e)return{type:"error",content:"A path is required to make a request."}
if("write"===t&&!n.force&&0===l.length)return{type:"error",content:"Must supply data or use -force"}
return},e.logFromError=function(e,t,n){let l
const{httpStatus:a,path:i}=e
l=`Error ${{read:"reading from","kv-get":"reading secret",write:"writing to",list:"listing",delete:"deleting at"}[n]}: ${t}.\nURL: ${i}\nCode: ${a}`,"string"==typeof e.errors[0]&&(l=`${l}\nErrors:\n  ${e.errors.join("\n  ")}`)
return{type:"error",content:l}},e.logFromResponse=function(e,t,n,l){const{format:a,field:i}=l,r=e&&(e.auth||e.data||e.wrap_info),o=r||e
if(!r){if("write"===n)return{type:"success",content:`Success! Data written to: ${t}`}
if("delete"===n)return{type:"success",content:`Success! Data deleted (if it existed) at: ${t}`}}if(i){const e=o[i]
let t
if(e){if(a&&"json"===a)return{type:"json",content:e}
t="string"==typeof e?{type:"text",content:e}:"number"==typeof e||"boolean"==typeof e||Array.isArray(e)?{type:"text",content:JSON.stringify(e)}:{type:"object",content:e}}else t={type:"error",content:`Field "${i}" not present in secret`}
return t}if(a&&"json"===a)return{type:"json",content:e}
if("list"===n)return{type:"list",content:o}
return{type:"object",content:o}},e.parseCommand=function(e){const t=(0,l.default)((0,n.parse)(e))
"vault"===t[0]&&t.shift()
const[i="",...r]=t
let o=""
const s=[],u=[]
if(r.forEach((e=>{if(e.startsWith("-"))s.push(e)
else if(o){const t=e.split(/=(.+)/).filter((e=>""!==e)).join("=")
u.push(t)}else o=e})),!a.includes(i))throw new Error("invalid command")
return{method:i,flagArray:s,path:o,dataArray:u}},e.shiftCommandIndex=function(e,n,l){let a
const i=n.length
if(!i)return[]
e===t.default.UP?(l-=1)<0&&(l=i-1):((l+=1)===i&&(a=""),l>i&&(l-=1))
""!==a&&(a=n.objectAt(l)?.content)
return[l,a]}
const a=["read","write","list","delete","kv-get"],i=["api","clearall","clear","fullscreen","refresh"]})),define("vault/lib/control-group-error",["exports","@ember-data/adapter/error"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{constructor(e){const{accessor:t,creation_path:n,creation_time:l,token:a,ttl:i}=e
super(),this.message="Control Group encountered",this.token=a,this.accessor=t,this.creation_path=n,this.creation_time=l,this.ttl=i}}e.default=n})),define("vault/lib/kv-object",["exports","@ember/array/proxy","@ember/utils","@ember/object/internals"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=t.default.extend({fromJSON(e){if(e&&"object"!==(0,n.typeOf)(e))throw new Error("Vault expects data to be formatted as an JSON object.")
const t=Object.keys(e||[]).map((t=>{const n={name:t,value:e[t]}
return(0,l.guidFor)(n),n}))
return this.setObjects(t.sort(((e,t)=>""===e.name?1:""===t.name?-1:e.name.localeCompare(t.name)))),this},fromJSONString(e){return this.fromJSON(JSON.parse(e))},toJSON(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0]
return this.reduce(((t,n)=>{if(!e&&""===n.value&&""===n.name)return t
const l=void 0===n.value?"":n.value
return t[n.name||""]=l,t}),{})},toJSONString(e){return JSON.stringify(this.toJSON(e),null,2)},isAdvanced(){return this.any((e=>"string"!=typeof e.value))}})
e.default=a})),define("vault/lib/local-storage",["exports"],(function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var t={isLocalStorageSupported(){try{const e="__storage__test"
return window.localStorage.setItem(e,null),window.localStorage.removeItem(e),!0}catch(e){throw e.errors=["This is likely due to your browser's cookie settings."],e}},getItem(e){const t=window.localStorage.getItem(e)
return t&&JSON.parse(t)},setItem(e,t){window.localStorage.setItem(e,JSON.stringify(t))},removeItem:e=>window.localStorage.removeItem(e),keys:()=>Object.keys(window.localStorage),cleanupStorage(e,t){if(!e)return
this.keys().filter((t=>t.startsWith(e)))?.forEach((e=>{e!==t&&localStorage.removeItem(e)}))}}
e.default=t})),define("vault/lib/memory-storage",["exports"],(function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const t={}
var n={getItem(e){var n=t[e]
return n&&JSON.parse(n)},setItem(e,n){t[e]=JSON.stringify(n)},removeItem(e){delete t[e]},keys:()=>Object.keys(t)}
e.default=n})),define("vault/lib/path-to-tree",["exports","flat","deepmerge"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=function(e){let t=e.slice(0).sort(((e,t)=>t.length-e.length||t.localeCompare(e))).reduce(((e,t)=>{const n=e.find((e=>e.startsWith(t)))
return n&&"/"===n.charAt(t.length)||e.push(t),e}),[])
return t=t.sort(((e,t)=>e.localeCompare(t))),n.default.all(t.map((e=>(e=e.replace(/\.+/g,"☃"),l({[e]:null},{delimiter:"/",object:!0})))))}
const{unflatten:l}=t.default})),define("vault/lib/route-paths",["exports"],(function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.UNSEAL=e.REDIRECT=e.OIDC_PROVIDER=e.OIDC_CALLBACK=e.NS_OIDC_PROVIDER=e.LOGOUT=e.INIT=e.EXCLUDED_REDIRECT_URLS=e.DR_REPLICATION_SECONDARY_DETAILS=e.DR_REPLICATION_SECONDARY=e.CLUSTER_INDEX=e.CLUSTER=e.AUTH=void 0
e.INIT="vault.cluster.init"
e.UNSEAL="vault.cluster.unseal"
e.AUTH="vault.cluster.auth"
e.LOGOUT="vault.cluster.logout"
e.REDIRECT="vault.cluster.redirect"
e.CLUSTER="vault.cluster"
e.CLUSTER_INDEX="vault.cluster.index"
e.OIDC_CALLBACK="vault.cluster.oidc-callback"
e.OIDC_PROVIDER="vault.cluster.oidc-provider"
e.NS_OIDC_PROVIDER="vault.cluster.oidc-provider-ns"
e.DR_REPLICATION_SECONDARY="vault.cluster.replication-dr-promote"
e.DR_REPLICATION_SECONDARY_DETAILS="vault.cluster.replication-dr-promote.details"
e.EXCLUDED_REDIRECT_URLS=["/vault/logout"]})),define("vault/lib/token-storage",["exports","vault/lib/local-storage","vault/lib/memory-storage"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=function(e){if("memory"===e)return n.default
let l
try{window.localStorage.getItem("test"),l=t.default}catch(a){l=n.default}return l}})),define("vault/machines/auth-machine",["exports"],(function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default={key:"auth",initial:"idle",on:{RESET:"idle",DONE:"complete"},states:{idle:{onEntry:[{type:"routeTransition",params:["vault.cluster.settings.auth.enable"]},{type:"render",level:"feature",component:"wizard/mounts-wizard"},{type:"render",level:"step",component:"wizard/auth-idle"}],on:{CONTINUE:"enable"}},enable:{onEntry:[{type:"render",level:"feature",component:"wizard/mounts-wizard"},{type:"render",level:"step",component:"wizard/auth-enable"}],on:{CONTINUE:"config"}},config:{onEntry:[{type:"render",level:"feature",component:"wizard/mounts-wizard"},{type:"render",level:"step",component:"wizard/auth-config"}],on:{CONTINUE:"details"}},details:{onEntry:[{type:"render",level:"step",component:"wizard/auth-details"},{type:"render",level:"feature",component:"wizard/mounts-wizard"}],on:{CONTINUE:"complete"}},complete:{onEntry:["completeFeature"]}}}})),define("vault/machines/policies-machine",["exports"],(function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default={key:"policies",initial:"idle",states:{idle:{onEntry:[{type:"routeTransition",params:["vault.cluster.policies.index","acl"]},{type:"render",level:"feature",component:"wizard/policies-intro"}],on:{CONTINUE:"create"}},create:{on:{CONTINUE:"details"},onEntry:[{type:"render",level:"feature",component:"wizard/policies-create"}]},details:{on:{CONTINUE:"delete"},onEntry:[{type:"render",level:"feature",component:"wizard/policies-details"}]},delete:{on:{CONTINUE:"others"},onEntry:[{type:"render",level:"feature",component:"wizard/policies-delete"}]},others:{on:{CONTINUE:"complete"},onEntry:[{type:"render",level:"feature",component:"wizard/policies-others"}]},complete:{onEntry:["completeFeature"]}}}})),define("vault/machines/replication-machine",["exports"],(function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default={key:"replication",initial:"setup",states:{setup:{on:{ENABLEREPLICATION:"details"},onEntry:[{type:"routeTransition",params:["vault.cluster.replication"]},{type:"render",level:"feature",component:"wizard/replication-setup"}]},details:{on:{CONTINUE:"complete"},onEntry:[{type:"render",level:"feature",component:"wizard/replication-details"}]},complete:{onEntry:["completeFeature"]}}}})),define("vault/machines/secrets-machine",["exports","vault/helpers/supported-secret-backends"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const n=(0,t.supportedSecretBackends)()
var l={key:"secrets",initial:"idle",on:{RESET:"idle",DONE:"complete",ERROR:"error"},states:{idle:{onEntry:[{type:"routeTransition",params:["vault.cluster.settings.mount-secret-backend"]},{type:"render",level:"feature",component:"wizard/mounts-wizard"},{type:"render",level:"step",component:"wizard/secrets-idle"}],on:{CONTINUE:"enable"}},enable:{onEntry:[{type:"render",level:"feature",component:"wizard/mounts-wizard"},{type:"render",level:"step",component:"wizard/secrets-enable"}],on:{CONTINUE:{details:{cond:e=>n.includes(e)},list:{cond:e=>!n.includes(e)}}}},details:{onEntry:[{type:"render",level:"feature",component:"wizard/mounts-wizard"},{type:"render",level:"step",component:"wizard/secrets-details"}],on:{CONTINUE:{connection:{cond:e=>"database"===e},role:{cond:e=>["pki","aws","ssh"].includes(e)},secret:{cond:e=>["kv"].includes(e)},encryption:{cond:e=>"transit"===e},provider:{cond:e=>"keymgmt"===e}}}},connection:{onEntry:[{type:"render",level:"step",component:"wizard/secrets-connection"},{type:"render",level:"feature",component:"wizard/mounts-wizard"}],on:{CONTINUE:"displayConnection"}},encryption:{onEntry:[{type:"render",level:"feature",component:"wizard/mounts-wizard"},{type:"render",level:"step",component:"wizard/secrets-encryption"}],on:{CONTINUE:"display"}},credentials:{onEntry:[{type:"render",level:"step",component:"wizard/secrets-credentials"},{type:"render",level:"feature",component:"wizard/mounts-wizard"}],on:{CONTINUE:"display"}},role:{onEntry:[{type:"render",level:"step",component:"wizard/secrets-role"},{type:"render",level:"feature",component:"wizard/mounts-wizard"}],on:{CONTINUE:"displayRole"}},displayRole:{onEntry:[{type:"render",level:"step",component:"wizard/secrets-display-role"},{type:"render",level:"feature",component:"wizard/mounts-wizard"}],on:{CONTINUE:"credentials"}},displayConnection:{onEntry:[{type:"render",level:"step",component:"wizard/secrets-connection-show"},{type:"render",level:"feature",component:"wizard/mounts-wizard"}],on:{CONTINUE:"displayRoleDatabase"}},displayRoleDatabase:{onEntry:[{type:"render",level:"step",component:"wizard/secrets-display-database-role"},{type:"render",level:"feature",component:"wizard/mounts-wizard"}],on:{CONTINUE:"display"}},secret:{onEntry:[{type:"render",level:"step",component:"wizard/secrets-secret"},{type:"render",level:"feature",component:"wizard/mounts-wizard"}],on:{CONTINUE:"display"}},provider:{onEntry:[{type:"render",level:"step",component:"wizard/secrets-keymgmt"},{type:"render",level:"feature",component:"wizard/mounts-wizard"}],on:{CONTINUE:"displayProvider"}},displayProvider:{onEntry:[{type:"render",level:"step",component:"wizard/secrets-keymgmt"},{type:"render",level:"feature",component:"wizard/mounts-wizard"}],on:{CONTINUE:"distribute"}},distribute:{onEntry:[{type:"render",level:"step",component:"wizard/secrets-keymgmt"},{type:"render",level:"feature",component:"wizard/mounts-wizard"}],on:{CONTINUE:"display"}},display:{onEntry:[{type:"render",level:"step",component:"wizard/secrets-display"},{type:"render",level:"feature",component:"wizard/mounts-wizard"}],on:{REPEAT:{connection:{cond:e=>"database"===e,actions:[{type:"routeTransition",params:["vault.cluster.secrets.backend.create-root"]}]},role:{cond:e=>["pki","aws","ssh"].includes(e),actions:[{type:"routeTransition",params:["vault.cluster.secrets.backend.create-root"]}]},secret:{cond:e=>["kv"].includes(e),actions:[{type:"routeTransition",params:["vault.cluster.secrets.backend.create-root"]}]},encryption:{cond:e=>"transit"===e,actions:[{type:"routeTransition",params:["vault.cluster.secrets.backend.create-root"]}]},provider:{cond:e=>"keymgmt"===e,actions:[{type:"routeTransition",params:["vault.cluster.secrets.backend.create-root",{queryParams:{itemType:"provider"}}]}]}}}},list:{onEntry:[{type:"render",level:"step",component:"wizard/secrets-list"},{type:"render",level:"feature",component:"wizard/mounts-wizard"}],on:{CONTINUE:"display"}},error:{onEntry:[{type:"render",level:"step",component:"wizard/tutorial-error"},{type:"render",level:"feature",component:"wizard/mounts-wizard"}],on:{CONTINUE:"complete"}},complete:{onEntry:["completeFeature"]}}}
e.default=l})),define("vault/machines/tools-machine",["exports"],(function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default={key:"tools",initial:"wrap",states:{wrap:{onEntry:[{type:"routeTransition",params:["vault.cluster.tools"]},{type:"render",level:"feature",component:"wizard/tools-wrap"}],on:{CONTINUE:"wrapped"}},wrapped:{onEntry:[{type:"render",level:"feature",component:"wizard/tools-wrapped"}],on:{LOOKUP:"lookup"}},lookup:{onEntry:[{type:"render",level:"feature",component:"wizard/tools-lookup"}],on:{CONTINUE:"info"}},info:{onEntry:[{type:"render",level:"feature",component:"wizard/tools-info"}],on:{REWRAP:"rewrap"}},rewrap:{onEntry:[{type:"render",level:"feature",component:"wizard/tools-rewrap"}],on:{CONTINUE:"rewrapped"}},rewrapped:{onEntry:[{type:"render",level:"feature",component:"wizard/tools-rewrapped"}],on:{UNWRAP:"unwrap"}},unwrap:{onEntry:[{type:"render",level:"feature",component:"wizard/tools-unwrap"}],on:{CONTINUE:"unwrapped"}},unwrapped:{onEntry:[{type:"render",level:"feature",component:"wizard/tools-unwrapped"}],on:{CONTINUE:"complete"}},complete:{onEntry:["completeFeature"]}}}})),define("vault/machines/tutorial-machine",["exports"],(function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default={key:"tutorial",initial:"idle",on:{DISMISS:"dismissed",DONE:"complete",PAUSE:"paused"},states:{init:{key:"init",initial:"idle",on:{INITDONE:"active.select"},onEntry:["showTutorialAlways",{type:"render",level:"tutorial",component:"wizard/tutorial-idle"},{type:"render",level:"feature",component:null}],onExit:["showTutorialWhenAuthenticated","clearFeatureData"],states:{idle:{on:{START:"active.setup",SAVE:"active.save",UNSEAL:"active.unseal",LOGIN:"active.login"}},active:{onEntry:{type:"render",level:"tutorial",component:"wizard/tutorial-active"},states:{setup:{on:{TOSAVE:"save"},onEntry:{type:"render",level:"feature",component:"wizard/init-setup"}},save:{on:{TOUNSEAL:"unseal",TOLOGIN:"login"},onEntry:{type:"render",level:"feature",component:"wizard/init-save-keys"}},unseal:{on:{TOLOGIN:"login"},onEntry:{type:"render",level:"feature",component:"wizard/init-unseal"}},login:{onEntry:{type:"render",level:"feature",component:"wizard/init-login"}}}}}},active:{key:"feature",initial:"select",onEntry:{type:"render",level:"tutorial",component:"wizard/tutorial-active"},states:{select:{on:{CONTINUE:"feature"},onEntry:{type:"render",level:"feature",component:"wizard/features-selection"}},feature:{}}},idle:{on:{INIT:"init.idle",AUTH:"active.select",CONTINUE:"active"},onEntry:[{type:"render",level:"feature",component:null},{type:"render",level:"step",component:null},{type:"render",level:"detail",component:null},{type:"render",level:"tutorial",component:"wizard/tutorial-idle"}]},dismissed:{onEntry:[{type:"render",level:"tutorial",component:null},{type:"render",level:"feature",component:null},{type:"render",level:"step",component:null},{type:"render",level:"detail",component:null},"handleDismissed"]},paused:{on:{CONTINUE:"active.feature"},onEntry:[{type:"render",level:"feature",component:null},{type:"render",level:"step",component:null},{type:"render",level:"detail",component:null},{type:"render",level:"tutorial",component:"wizard/tutorial-paused"},"handlePaused"],onExit:["handleResume"]},complete:{onEntry:[{type:"render",level:"feature",component:null},{type:"render",level:"step",component:null},{type:"render",level:"detail",component:null},{type:"render",level:"tutorial",component:"wizard/tutorial-complete"}]}}}})),define("vault/macros/identity-capabilities",["exports","vault/macros/lazy-capabilities"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=function(){return(0,t.default)(t.apiPath`identity/${"identityType"}/id/${"id"}`,"id","identityType")}})),define("vault/macros/lazy-capabilities",["exports","vault/macros/maybe-query-record"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.apiPath=function(e){for(var t=arguments.length,n=new Array(t>1?t-1:0),l=1;l<t;l++)n[l-1]=arguments[l]
return function(t){const l=t||{},a=[e[0]]
return n.forEach(((t,n)=>{a.push(l[t],e[n+1])})),a.join("")}},e.default=function(){const[e,...n]=arguments
return(0,t.maybeQueryRecord)("capabilities",(t=>{const l=t.getProperties(...n),a=Object.keys(l).reduce(((e,t)=>(null!=l[t]&&(e[t]=l[t]),e)),{})
if(Object.keys(a).length===n.length)return{id:e(a)}}),...n)}})),define("vault/macros/maybe-query-record",["exports","@ember/object","@ember/object/proxy","@ember/object/promise-proxy-mixin","rsvp"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.maybeQueryRecord=function(e){let i=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{}
for(var r=arguments.length,o=new Array(r>2?r-2:0),s=2;s<r;s++)o[s-2]=arguments[s]
return(0,t.computed)(...o,"store",{get(){const t="function"==typeof i?i(this):i
return n.default.extend(l.default).create({promise:t?this.store.queryRecord(e,t):(0,a.resolve)({})})}})},n.default.reopen({unknownProperty(e){if(!(this.isDestroying||this.isDestroyed||this.content&&(this.content.isDestroying||this.content.isDestroyed)))return this._super(e)}})})),define("vault/mixins/backend-crumb",["exports","@ember/object","@ember/object/mixin"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=n.default.create({backendCrumb:(0,t.computed)("backend",(function(){const e=this.backend
if(void 0===e)throw new Error("backend-crumb mixin requires backend to be set")
return{label:e,text:e,path:"vault.cluster.secrets.backend.list-root",model:e}}))})
e.default=l})),define("vault/mixins/cluster-route",["exports","@ember/service","@ember/object/mixin","rsvp","vault/lib/route-paths"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=n.default.create({auth:(0,t.inject)(),store:(0,t.inject)(),router:(0,t.inject)(),transitionToTargetRoute(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{}
const t=this.targetRouteName(e)
if(t&&t!==this.routeName&&t!==e.targetName&&t!==this.router.currentRouteName){const n=a.EXCLUDED_REDIRECT_URLS.find((e=>this.router.currentURL?.includes(e)))
return t!==a.AUTH||e.targetName===a.CLUSTER_INDEX||n?this.transitionTo(t):this.transitionTo(t,{queryParams:{redirect_to:this.router.currentURL}})}return l.default.resolve()},beforeModel(e){return this.transitionToTargetRoute(e)},clusterModel(){return this.modelFor(a.CLUSTER)||this.store.peekRecord("cluster","vault")},authToken(){return this.auth.currentToken},hasKeyData(){return!!this.controllerFor(a.INIT).keyData},targetRouteName(e){const t=this.clusterModel(),n=this.authToken()
return t.needsInit||this.hasKeyData()&&this.routeName!==a.UNSEAL&&this.routeName!==a.AUTH?a.INIT:t.sealed?a.UNSEAL:t?.dr?.isSecondary?e&&e.targetName===a.DR_REPLICATION_SECONDARY_DETAILS||this.router.currentRouteName===a.DR_REPLICATION_SECONDARY_DETAILS?a.DR_REPLICATION_SECONDARY_DETAILS:a.DR_REPLICATION_SECONDARY:n?!t.needsInit&&this.routeName===a.INIT||!t.sealed&&this.routeName===a.UNSEAL||!t?.dr?.isSecondary&&this.routeName===a.DR_REPLICATION_SECONDARY?a.CLUSTER:n&&this.routeName===a.AUTH?a.REDIRECT:null:e&&e.targetName===a.OIDC_PROVIDER||this.routeName===a.OIDC_PROVIDER?a.OIDC_PROVIDER:e&&e.targetName===a.NS_OIDC_PROVIDER||this.routeName===a.NS_OIDC_PROVIDER?a.NS_OIDC_PROVIDER:e&&e.targetName===a.OIDC_CALLBACK||this.routeName===a.OIDC_CALLBACK?a.OIDC_CALLBACK:a.AUTH}})
e.default=i})),define("vault/mixins/focus-on-insert",["exports","@ember/runloop","@ember/object/evented","@ember/object/mixin"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=l.default.create({focusOnInsertSelector:null,shouldFocus:!0,focusOnInsert:(0,n.on)("didInsertElement",(function(){(0,t.schedule)("afterRender",this,"focusOnInsertFocus")})),focusOnInsertFocus(){!1!==this.shouldFocus&&this.forceFocus()},forceFocus(){var e=this.element.querySelectorAll(this.focusOnInsertSelector||'input[type="text"]')[0]
e&&e!==document.activeElement&&e.focus()}})
e.default=a})),define("vault/mixins/key-mixin",["exports","@ember/object","@ember/object/mixin","core/utils/key-utils"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=n.default.create({pathAttr:"path",flags:null,initialParentKey:null,isCreating:(0,t.computed)("initialParentKey",(function(){return null!=this.initialParentKey})),pathVal(){return this[this.pathAttr]||this.id},isFolder:(0,t.computed)("id","path",(function(){return(0,l.keyIsFolder)(this.pathVal())})),keyParts:(0,t.computed)("id","path",(function(){return(0,l.keyPartsForKey)(this.pathVal())})),parentKey:(0,t.computed)("id","path","isCreating",{get:function(){return this.isCreating?this.initialParentKey:(0,l.parentKeyForKey)(this.pathVal())},set:function(e,t){return t}}),keyWithoutParent:(0,t.computed)("id","path","parentKey",{get:function(){var e=this.pathVal()
return e?e.replace(this.parentKey,""):null},set:function(e,t){return t&&t.trim()?this.set(this.pathAttr,this.parentKey+t):this.set(this.pathAttr,null),t}})})
e.default=a})),define("vault/mixins/list-controller",["exports","core/mixins/list-controller"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/mixins/list-route",["exports","core/mixins/list-route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/mixins/model-boundary-route",["exports","@ember/routing/route","@ember/utils","@ember/debug","@ember/object/evented","@ember/object/mixin"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=i.default.create({modelType:null,modelTypes:null,verifyProps:(0,a.on)("init",(function(){this.modelType,this.modelTypes})),clearModelCache:(0,a.on)("deactivate",(function(){var e=this.modelType,t=this.modelTypes;(e||t)&&(this.store.isDestroyed||this.store.isDestroying||(e&&this.store.unloadAll(e),t&&t.forEach((e=>{this.store.unloadAll(e)}))))}))})
e.default=r}))
define("vault/mixins/replication-actions",["exports","core/mixins/replication-actions"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/mixins/unload-model-route",["exports","@ember/object/mixin","vault/utils/remove-record"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.create({modelPath:"model",unloadModel(){const{modelPath:e}=this,t=this.controller.get(e)
t&&t.unloadRecord&&!t.isSaving&&((0,n.default)(this.store,t),this.controller.set(e,null))},actions:{willTransition(){return this.unloadModel(),!0}}})
e.default=l})),define("vault/mixins/unsaved-model-route",["exports","@ember/object/mixin","ember"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.create({actions:{willTransition(e){const t=this.controller.get("model")
return!t||(!t.hasDirtyAttributes||(n.default.testing||window.confirm("You have unsaved changes. Navigating away will discard these changes. Are you sure you want to discard your changes?")?(t.rollbackAttributes(),!0):(e.abort(),!1)))}}})
e.default=l})),define("vault/mixins/with-nav-to-nearest-ancestor",["exports","@ember/object/mixin","ember-concurrency","core/utils/key-utils"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=t.default.create({navToNearestAncestor:(0,n.task)((function*(e){const t=(0,l.ancestorKeysForKey)(e)
let n=!1,a=t.pop()
for(;a;)try{const e=this.transitionToRoute("vault.cluster.secrets.backend.list",a)
e.data.isDeletion=!0,yield e.promise}catch(i){n=!0,a=t.pop()}finally{if(!n)return void(a=null)
n=!1}yield this.transitionToRoute("vault.cluster.secrets.backend.list-root")}))})
e.default=a})),define("vault/models/auth-config",["exports","@ember-data/model"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({backend:(0,t.belongsTo)("auth-method",{inverse:"authConfigs",readOnly:!0,async:!1}),getHelpUrl:function(e){return`/v1/auth/${e}/config?help=1`}})
e.default=n})),define("vault/models/auth-config/approle",["exports","vault/models/auth-config"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({})
e.default=n})),define("vault/models/auth-config/aws/client",["exports","@ember-data/model","@ember/object","vault/models/auth-config","vault/utils/field-to-attrs"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=l.default.extend({secretKey:(0,t.attr)("string"),accessKey:(0,t.attr)("string"),endpoint:(0,t.attr)("string",{label:"EC2 Endpoint"}),iamEndpoint:(0,t.attr)("string",{label:"IAM Endpoint"}),stsEndpoint:(0,t.attr)("string",{label:"STS Endpoint"}),iamServerIdHeaderValue:(0,t.attr)("string",{label:"IAM Server ID Header Value"}),fieldGroups:(0,n.computed)((function(){return(0,a.default)(this,[{default:["accessKey","secretKey"]},{"AWS Options":["endpoint","iamEndpoint","stsEndpoint","iamServerIdHeaderValue"]}])}))})
e.default=i})),define("vault/models/auth-config/aws/identity-accesslist",["exports","vault/models/auth-config/aws/tidy"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend()
e.default=n})),define("vault/models/auth-config/aws/roletag-denylist",["exports","vault/models/auth-config/aws/tidy"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend()
e.default=n})),define("vault/models/auth-config/aws/tidy",["exports","@ember-data/model","@ember/object","vault/utils/field-to-attrs","vault/models/auth-config"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=a.default.extend({safetyBuffer:(0,t.attr)({defaultValue:"72h",editType:"ttl"}),disablePeriodicTidy:(0,t.attr)("boolean",{defaultValue:!1}),attrs:(0,n.computed)((function(){return(0,l.expandAttributeMeta)(this,["safetyBuffer","disablePeriodicTidy"])}))})
e.default=i})),define("vault/models/auth-config/azure",["exports","@ember-data/model","@ember/object","vault/models/auth-config","vault/utils/openapi-to-attrs","vault/utils/field-to-attrs"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=l.default.extend({useOpenAPI:!0,tenantId:(0,t.attr)("string",{label:"Tenant ID",helpText:"The tenant ID for the Azure Active Directory organization"}),resource:(0,t.attr)("string",{helpText:"The configured URL for the application registered in Azure Active Directory"}),clientId:(0,t.attr)("string",{label:"Client ID",helpText:"The client ID for credentials to query the Azure APIs. Currently read permissions to query compute resources are required."}),clientSecret:(0,t.attr)("string",{helpText:"The client secret for credentials to query the Azure APIs"}),googleCertsEndpoint:(0,t.attr)("string"),fieldGroups:(0,n.computed)("newFields",(function(){let e=[{default:["tenantId","resource"]},{"Azure Options":["clientId","clientSecret"]}]
return this.newFields&&(e=(0,a.combineFieldGroups)(e,this.newFields,[])),(0,i.default)(this,e)}))})
e.default=r})),define("vault/models/auth-config/cert",["exports","vault/models/auth-config"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({})
e.default=n})),define("vault/models/auth-config/gcp",["exports","@ember-data/model","@ember/object","vault/models/auth-config","vault/utils/openapi-to-attrs","vault/utils/field-to-attrs"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=l.default.extend({useOpenAPI:!0,credentials:(0,t.attr)("string",{editType:"file"}),googleCertsEndpoint:(0,t.attr)("string"),fieldGroups:(0,n.computed)("newFields",(function(){let e=[{default:["credentials"]},{"Google Cloud Options":["googleCertsEndpoint"]}]
return this.newFields&&(e=(0,a.combineFieldGroups)(e,this.newFields,[])),(0,i.default)(this,e)}))})
e.default=r})),define("vault/models/auth-config/github",["exports","@ember-data/model","@ember/object","vault/models/auth-config","vault/utils/field-to-attrs","vault/utils/openapi-to-attrs"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=l.default.extend({useOpenAPI:!0,organization:(0,t.attr)("string"),baseUrl:(0,t.attr)("string",{label:"Base URL"}),fieldGroups:(0,n.computed)("newFields",(function(){let e=[{default:["organization"]},{"GitHub Options":["baseUrl"]}]
return this.newFields&&(e=(0,i.combineFieldGroups)(e,this.newFields,[])),(0,a.default)(this,e)}))})
e.default=r})),define("vault/models/auth-config/jwt",["exports","@ember-data/model","@ember/object","vault/models/auth-config","vault/utils/field-to-attrs","vault/utils/openapi-to-attrs"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=l.default.extend({useOpenAPI:!0,oidcDiscoveryUrl:(0,t.attr)("string",{label:"OIDC discovery URL",helpText:"The OIDC discovery URL, without any .well-known component (base path). Cannot be used with jwt_validation_pubkeys"}),oidcClientId:(0,t.attr)("string",{label:"OIDC client ID"}),oidcClientSecret:(0,t.attr)("string",{label:"OIDC client secret"}),oidcDiscoveryCaPem:(0,t.attr)("string",{label:"OIDC discovery CA PEM",editType:"file",helpText:"The CA certificate or chain of certificates, in PEM format, to use to validate connections to the OIDC Discovery URL. If not set, system certificates are used"}),jwksCaPem:(0,t.attr)("string",{label:"JWKS CA PEM",editType:"file"}),jwksUrl:(0,t.attr)("string",{label:"JWKS URL"}),oidcResponseMode:(0,t.attr)("string",{label:"OIDC response mode"}),oidcResponseTypes:(0,t.attr)("string",{label:"OIDC response types"}),jwtValidationPubkeys:(0,t.attr)({label:"JWT validation public keys",editType:"stringArray"}),jwtSupportedAlgs:(0,t.attr)({label:"JWT supported algorithms"}),boundIssuer:(0,t.attr)("string",{helpText:"The value against which to match the iss claim in a JWT"}),fieldGroups:(0,n.computed)("constructor.modelName","newFields",(function(){let e=[{default:["oidcDiscoveryUrl","defaultRole","jwksCaPem","jwksUrl","oidcResponseMode","oidcResponseTypes"]},{[`${this.constructor.modelName.split("/")[1].toUpperCase()} Options`]:["oidcClientId","oidcClientSecret","oidcDiscoveryCaPem","jwtValidationPubkeys","jwtSupportedAlgs","boundIssuer"]}]
return this.newFields&&(e=(0,i.combineFieldGroups)(e,this.newFields,[])),(0,a.default)(this,e)}))})
e.default=r})),define("vault/models/auth-config/kubernetes",["exports","@ember-data/model","@ember/object","vault/models/auth-config","vault/utils/openapi-to-attrs","vault/utils/field-to-attrs"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=l.default.extend({useOpenAPI:!0,kubernetesHost:(0,t.attr)("string",{helpText:"Host must be a host string, a host:port pair, or a URL to the base of the Kubernetes API server"}),kubernetesCaCert:(0,t.attr)("string",{editType:"file",helpText:"PEM encoded CA cert for use by the TLS client used to talk with the Kubernetes API"}),tokenReviewerJwt:(0,t.attr)("string",{helpText:"A service account JWT used to access the TokenReview API to validate other JWTs during login. If not set the JWT used for login will be used to access the API"}),pemKeys:(0,t.attr)({editType:"stringArray"}),fieldGroups:(0,n.computed)("newFields",(function(){let e=[{default:["kubernetesHost","kubernetesCaCert"]},{"Kubernetes Options":["tokenReviewerJwt","pemKeys"]}]
return this.newFields&&(e=(0,a.combineFieldGroups)(e,this.newFields,[])),(0,i.default)(this,e)}))})
e.default=r})),define("vault/models/auth-config/ldap",["exports","@ember-data/model","@ember/object","vault/models/auth-config","vault/utils/field-to-attrs","vault/utils/openapi-to-attrs"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=l.default.extend({useOpenAPI:!0,certificate:(0,t.attr)({label:"Certificate",editType:"file"}),fieldGroups:(0,n.computed)("newFields",(function(){let e=[{default:["url"]},{"LDAP Options":["starttls","insecureTls","discoverdn","denyNullBind","tlsMinVersion","tlsMaxVersion","certificate","clientTlsCert","clientTlsKey","userattr","upndomain","anonymousGroupSearch"]},{"Customize User Search":["binddn","userdn","bindpass","userfilter"]},{"Customize Group Membership Search":["groupfilter","groupattr","groupdn","useTokenGroups"]}]
return this.newFields&&(e=(0,i.combineFieldGroups)(e,this.newFields,[])),(0,a.default)(this,e)}))})
e.default=r})),define("vault/models/auth-config/oidc",["exports","vault/models/auth-config/jwt"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/models/auth-config/okta",["exports","@ember-data/model","@ember/object","vault/models/auth-config","vault/utils/field-to-attrs","vault/utils/openapi-to-attrs"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=l.default.extend({useOpenAPI:!0,orgName:(0,t.attr)("string",{helpText:"Name of the organization to be used in the Okta API"}),apiToken:(0,t.attr)("string",{helpText:"Okta API token. This is required to query Okta for user group membership. If this is not supplied only locally configured groups will be enabled."}),baseUrl:(0,t.attr)("string",{helpText:"If set, will be used as the base domain for API requests. Examples are okta.com, oktapreview.com, and okta-emea.com"}),bypassOktaMfa:(0,t.attr)("boolean",{defaultValue:!1,helpText:"Useful if using Vault's built-in MFA mechanisms. Will also cause certain other statuses to be ignored, such as PASSWORD_EXPIRED"}),fieldGroups:(0,n.computed)("newFields",(function(){let e=[{default:["orgName"]},{Options:["apiToken","baseUrl","bypassOktaMfa"]}]
return this.newFields&&(e=(0,i.combineFieldGroups)(e,this.newFields,[])),(0,a.default)(this,e)}))})
e.default=r})),define("vault/models/auth-config/radius",["exports","@ember-data/model","@ember/object","vault/models/auth-config","vault/utils/openapi-to-attrs","vault/utils/field-to-attrs"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=l.default.extend({useOpenAPI:!0,host:(0,t.attr)("string"),secret:(0,t.attr)("string"),fieldGroups:(0,n.computed)("newFields",(function(){let e=[{default:["host","secret"]},{"RADIUS Options":["port","nasPort","nasIdentifier","dialTimeout","unregisteredUserPolicies"]}]
return this.newFields&&(e=(0,a.combineFieldGroups)(e,this.newFields,[])),(0,i.default)(this,e)}))})
e.default=r})),define("vault/models/auth-config/userpass",["exports","vault/models/auth-config"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({})
e.default=n})),define("vault/models/auth-method",["exports","@ember-data/model","@ember/object/computed","@ember/object","@ember/service","vault/utils/field-to-attrs","vault/utils/api-path","vault/lib/attach-capabilities","vault/decorators/model-validations"],(function(e,t,n,l,a,i,r,o,s){var u
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const d=((0,s.withModelValidations)({path:[{type:"presence",message:"Path can't be blank."},{type:"containsWhiteSpace",message:"Path contains whitespace. If this is desired, you'll need to encode it with %20 in API requests.",level:"warn"}]})(u=class extends t.default{})||u).extend({store:(0,a.inject)(),config:(0,t.belongsTo)("mount-config",{async:!1,inverse:null}),authConfigs:(0,t.hasMany)("auth-config",{polymorphic:!0,inverse:"backend",async:!1}),path:(0,t.attr)("string"),accessor:(0,t.attr)("string"),name:(0,t.attr)("string"),type:(0,t.attr)("string"),methodType:(0,l.computed)("type",(function(){return this.type.replace(/^ns_/,"")})),description:(0,t.attr)("string",{editType:"textarea"}),local:(0,t.attr)("boolean",{helpText:"When Replication is enabled, a local mount will not be replicated across clusters. This can only be specified at mount time."}),sealWrap:(0,t.attr)("boolean",{helpText:"When enabled - if a seal supporting seal wrapping is specified in the configuration, all critical security parameters (CSPs) in this backend will be seal wrapped. (For K/V mounts, all values will be seal wrapped.) This can only be specified at mount time."}),apiPath:(0,l.computed)("path",(function(){return`auth/${this.path}`})),localDisplay:(0,l.computed)("local",(function(){return this.local?"local":"replicated"})),tuneAttrs:(0,l.computed)("path",(function(){const{methodType:e}=this
let t
return t="token"===e?["description","config.{listingVisibility,defaultLeaseTtl,maxLeaseTtl,auditNonHmacRequestKeys,auditNonHmacResponseKeys,passthroughRequestHeaders}"]:["description","config.{listingVisibility,defaultLeaseTtl,maxLeaseTtl,tokenType,auditNonHmacRequestKeys,auditNonHmacResponseKeys,passthroughRequestHeaders}"],(0,i.expandAttributeMeta)(this,t)})),formFields:(0,l.computed)((function(){return["type","path","description","accessor","local","sealWrap","config.{listingVisibility,defaultLeaseTtl,maxLeaseTtl,tokenType,auditNonHmacRequestKeys,auditNonHmacResponseKeys,passthroughRequestHeaders}"]})),formFieldGroups:(0,l.computed)((function(){return[{default:["path"]},{"Method Options":["description","config.listingVisibility","local","sealWrap","config.{defaultLeaseTtl,maxLeaseTtl,tokenType,auditNonHmacRequestKeys,auditNonHmacResponseKeys,passthroughRequestHeaders}"]}]})),attrs:(0,l.computed)("formFields",(function(){return(0,i.expandAttributeMeta)(this,this.formFields)})),fieldGroups:(0,l.computed)("formFieldGroups",(function(){return(0,i.default)(this,this.formFieldGroups)})),canDisable:(0,n.alias)("deletePath.canDelete"),canEdit:(0,n.alias)("configPath.canUpdate"),tune(e){return this.store.adapterFor("auth-method").tune(this.path,e)}})
var c=(0,o.default)(d,{deletePath:r.default`sys/auth/${"id"}`,configPath:function(e){return"aws"===e.type?r.default`auth/${"id"}/config/client`.call(this,e):r.default`auth/${"id"}/config`.call(this,e)}})
e.default=c})),define("vault/models/aws-credential",["exports","@ember-data/model","@ember/object","vault/utils/field-to-attrs"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const a=["accessKey","secretKey","securityToken","leaseId","renewable","leaseDuration"]
var i=t.default.extend({helpText:"For Vault roles of credential type iam_user, there are no inputs, just submit the form. Choose a type to change the input options.",role:(0,t.attr)("object",{readOnly:!0}),credentialType:(0,t.attr)("string",{defaultValue:"iam_user",possibleValues:[{value:"iam_user",displayName:"IAM User"},{value:"assumed_role",displayName:"Assumed Role"},{value:"federation_token",displayName:"Federation Token"}],readOnly:!0}),roleArn:(0,t.attr)("string",{label:"Role ARN",helpText:"The ARN of the role to assume if credential_type on the Vault role is assumed_role. Optional if the role has a single role ARN; required otherwise."}),ttl:(0,t.attr)({editType:"ttl",defaultValue:"3600s",setDefault:!0,label:"TTL",helpText:"Specifies the TTL for the use of the STS token. Valid only when credential_type is assumed_role or federation_token."}),leaseId:(0,t.attr)("string"),renewable:(0,t.attr)("boolean"),leaseDuration:(0,t.attr)("number"),accessKey:(0,t.attr)("string"),secretKey:(0,t.attr)("string"),securityToken:(0,t.attr)("string"),attrs:(0,n.computed)("credentialType","accessKey","securityToken",(function(){const e=this.credentialType
return this.accessKey||this.securityToken?(0,l.expandAttributeMeta)(this,a.slice(0)):(0,l.expandAttributeMeta)(this,{iam_user:["credentialType"],assumed_role:["credentialType","ttl","roleArn"],federation_token:["credentialType","ttl"]}[e].slice(0))})),toCreds:(0,n.computed)("accessKey","secretKey","securityToken","leaseId",(function(){const e={accessKey:this.accessKey,secretKey:this.secretKey,securityToken:this.securityToken,leaseId:this.leaseId},t=Object.keys(e).reduce(((t,n)=>e[n]?(t[n]=e[n],t):t),{})
return JSON.stringify(t,null,2)}))})
e.default=i})),define("vault/models/capabilities",["exports","@ember-data/model","@ember/object"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=e.SUDO_PATH_PREFIXES=e.SUDO_PATHS=void 0
const l=["sys/seal","sys/replication/performance/primary/secondary-token","sys/replication/dr/primary/secondary-token","sys/replication/reindex","sys/leases/lookup/"]
e.SUDO_PATHS=l
const a=["sys/leases/revoke-prefix","sys/leases/revoke-force"]
e.SUDO_PATH_PREFIXES=a
const i=function(e){return(0,n.computed)("path","capabilities","capabilities.[]",(function(){const t=this.capabilities,n=this.path
return!!t&&(!!t.includes("root")||!t.includes("deny")&&(l.includes(n)||a.find((e=>n.startsWith(e)))?t.includes("sudo")&&t.includes(e):t.includes(e)))}))}
var r=t.default.extend({path:(0,t.attr)("string"),capabilities:(0,t.attr)("array"),canSudo:i("sudo"),canRead:i("read"),canCreate:i("create"),canUpdate:i("update"),canDelete:i("delete"),canList:i("list"),allowedParameters:(0,t.attr)(),deniedParameters:(0,t.attr)()})
e.default=r})),define("vault/models/clients/activity",["exports","@ember-data/model"],(function(e,t){var n,l,a,i,r,o,s,u,d,c,p,m,f
function h(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function b(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let y=(n=(0,t.attr)("array"),l=(0,t.attr)("array"),a=(0,t.attr)("object"),i=(0,t.attr)("string"),r=(0,t.attr)("string"),o=(0,t.attr)("string"),s=class extends t.default{constructor(){super(...arguments),h(this,"byMonth",u,this),h(this,"byNamespace",d,this),h(this,"total",c,this),h(this,"startTime",p,this),h(this,"endTime",m,this),h(this,"responseTimestamp",f,this)}},u=b(s.prototype,"byMonth",[n],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=b(s.prototype,"byNamespace",[l],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=b(s.prototype,"total",[a],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=b(s.prototype,"startTime",[i],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=b(s.prototype,"endTime",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=b(s.prototype,"responseTimestamp",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s)
e.default=y})),define("vault/models/clients/config",["exports","@ember-data/model","vault/macros/lazy-capabilities","vault/decorators/model-form-fields","vault/decorators/model-validations"],(function(e,t,n,l,a){var i,r,o,s,u,d,c,p,m,f,h,b,y,v,g,w,k,x
function _(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function P(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const T={retentionMonths:[{validator:e=>parseInt(e.retentionMonths)>=e.minimumRetentionMonths,message:e=>`Retention period must be greater than or equal to ${e.minimumRetentionMonths}.`}]}
let O=(i=(0,a.withModelValidations)(T),r=(0,l.withFormFields)(["enabled","retentionMonths"]),o=(0,t.attr)("boolean"),s=(0,t.attr)("number",{label:"Retention period",subText:"The number of months of activity logs to maintain for client tracking."}),u=(0,t.attr)("number"),d=(0,t.attr)("string"),c=(0,t.attr)("boolean"),p=(0,t.attr)("date"),m=(0,n.default)(n.apiPath`sys/internal/counters/config`),i(f=r((h=class extends t.default{constructor(){super(...arguments),_(this,"queriesAvailable",b,this),_(this,"retentionMonths",y,this),_(this,"minimumRetentionMonths",v,this),_(this,"enabled",g,this),_(this,"reportingEnabled",w,this),_(this,"billingStartTimestamp",k,this),_(this,"configPath",x,this)}get canRead(){return!1!==this.configPath.get("canRead")}get canEdit(){return!1!==this.configPath.get("canUpdate")}},b=P(h.prototype,"queriesAvailable",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=P(h.prototype,"retentionMonths",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),v=P(h.prototype,"minimumRetentionMonths",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g=P(h.prototype,"enabled",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=P(h.prototype,"reportingEnabled",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=P(h.prototype,"billingStartTimestamp",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=P(h.prototype,"configPath",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=h))||f)||f)
e.default=O})),define("vault/models/clients/version-history",["exports","@ember-data/model"],(function(e,t){var n,l,a,i,r,o,s
function u(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function d(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let c=(n=(0,t.attr)("string"),l=(0,t.attr)("string"),a=(0,t.attr)("string"),i=class extends t.default{constructor(){super(...arguments),u(this,"version",r,this),u(this,"previousVersion",o,this),u(this,"timestampInstalled",s,this)}},r=d(i.prototype,"version",[n],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),o=d(i.prototype,"previousVersion",[l],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=d(i.prototype,"timestampInstalled",[a],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),i)
e.default=c})),define("vault/models/cluster",["exports","@ember-data/model","@ember/service","@ember/object"],(function(e,t,n,l){var a,i,r,o,s,u,d,c,p,m,f,h,b,y,v,g,w,k,x,_,P,T,O,j
function M(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function z(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let S=(a=(0,t.hasMany)("nodes",{async:!1,inverse:null}),i=(0,t.attr)("string"),r=(0,t.attr)("string"),o=(0,t.attr)("boolean"),s=(0,t.attr)("string"),u=(0,t.attr)("object"),d=(0,t.attr)("boolean"),c=(0,t.attr)("string"),p=(0,t.belongsTo)("replication-attributes",{async:!1,inverse:null}),m=(0,t.belongsTo)("replication-attributes",{async:!1,inverse:null}),f=(0,n.inject)("replication-mode"),h=class extends t.default{constructor(){super(...arguments),M(this,"version",b,this),M(this,"nodes",y,this),M(this,"name",v,this),M(this,"status",g,this),M(this,"standby",w,this),M(this,"type",k,this),M(this,"license",x,this),M(this,"hasChrootNamespace",_,this),M(this,"mode",P,this),M(this,"dr",T,this),M(this,"performance",O,this),M(this,"rm",j,this)}get licenseExpiry(){return this.license?.expiry_time}get licenseState(){return this.license?.state}get needsInit(){return this.nodes.every((e=>!1===e.initialized))}get unsealed(){return!!this.nodes.find((e=>!1===e.sealed))}get sealed(){return!this.unsealed}get leaderNode(){const e=this.nodes
return 1===e.length?e[0]:e.find((e=>!0===e.isLeader))}get sealThreshold(){return this.leaderNode?.sealThreshold}get sealProgress(){return this.leaderNode?.progress}get sealType(){return this.leaderNode?.type}get storageType(){return this.leaderNode?.storageType}get hcpLinkStatus(){return this.leaderNode?.hcpLinkStatus}get hasProgress(){return this.sealProgress>=1}get usingRaft(){return"raft"===this.storageType}get allReplicationDisabled(){return this.dr?.replicationDisabled&&this.performance?.replicationDisabled}get anyReplicationEnabled(){return this.dr?.replicationEnabled||this.performance?.replicationEnabled}get drMode(){return this.dr.mode}get replicationMode(){return this.rm.mode}get replicationModeForDisplay(){return"dr"===this.replicationMode?"Disaster Recovery":"Performance"}get replicationIsInitializing(){return!this.dr?.mode||!this.performance?.mode}get replicationAttrs(){const e=this.replicationMode
return e?(0,l.get)(this,e):null}},b=z(h.prototype,"version",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=z(h.prototype,"nodes",[a],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),v=z(h.prototype,"name",[i],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g=z(h.prototype,"status",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=z(h.prototype,"standby",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=z(h.prototype,"type",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=z(h.prototype,"license",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_=z(h.prototype,"hasChrootNamespace",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P=z(h.prototype,"mode",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=z(h.prototype,"dr",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=z(h.prototype,"performance",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=z(h.prototype,"rm",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h)
e.default=S})),define("vault/models/control-group-config",["exports","@ember-data/model","@ember/object/computed","@ember/object","vault/macros/lazy-capabilities","vault/utils/field-to-attrs"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=t.default.extend({fields:(0,l.computed)((function(){return(0,i.expandAttributeMeta)(this,["maxTtl"])})),configurePath:(0,a.default)(a.apiPath`sys/config/control-group`),canDelete:(0,n.alias)("configurePath.canDelete"),maxTtl:(0,t.attr)({defaultValue:0,editType:"ttl",label:"Maximum TTL"})})
e.default=r})),define("vault/models/control-group",["exports","@ember-data/model","@ember/object/computed","vault/macros/lazy-capabilities"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=t.default.extend({approved:(0,t.attr)("boolean"),requestPath:(0,t.attr)("string"),requestEntity:(0,t.belongsTo)("identity/entity",{async:!1}),authorizations:(0,t.hasMany)("identity/entity",{async:!1}),authorizePath:(0,l.default)(l.apiPath`sys/control-group/authorize`),canAuthorize:(0,n.alias)("authorizePath.canUpdate"),configurePath:(0,l.default)(l.apiPath`sys/config/control-group`),canConfigure:(0,n.alias)("configurePath.canUpdate")})
e.default=a}))
define("vault/models/database/connection",["exports","@ember-data/model","@ember/object","@ember/object/computed","vault/macros/lazy-capabilities","vault/utils/field-to-attrs","vault/utils/database-helpers"],(function(e,t,n,l,a,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var o=t.default.extend({backend:(0,t.attr)("string",{readOnly:!0}),name:(0,t.attr)("string",{label:"Connection name"}),plugin_name:(0,t.attr)("string",{label:"Database plugin",possibleValues:r.AVAILABLE_PLUGIN_TYPES,noDefault:!0}),verify_connection:(0,t.attr)("boolean",{label:"Connection will be verified",defaultValue:!0}),allowed_roles:(0,t.attr)("array"),password_policy:(0,t.attr)("string",{label:"Use custom password policy",editType:"optionalText",subText:"Specify the name of an existing password policy.",defaultSubText:"Unless a custom policy is specified, Vault will use a default: 20 characters with at least 1 uppercase, 1 lowercase, 1 number, and 1 dash character.",defaultShown:"Default",docLink:"/vault/docs/concepts/password-policies"}),connection_url:(0,t.attr)("string",{label:"Connection URL",subText:"The connection string used to connect to the database. This allows for simple templating of username and password of the root user in the {{field_name}} format."}),url:(0,t.attr)("string",{label:"URL",subText:'The URL for Elasticsearch\'s API ("https://localhost:9200").'}),username:(0,t.attr)("string",{subText:'The name of the user to use as the "root" user when connecting to the database.'}),password:(0,t.attr)("string",{subText:"The password to use when connecting with the above username.",editType:"password"}),ca_cert:(0,t.attr)("string",{label:"CA certificate",subText:"The path to a PEM-encoded CA cert file to use to verify the Elasticsearch server's identity."}),ca_path:(0,t.attr)("string",{label:"CA path",subText:"The path to a directory of PEM-encoded CA cert files to use to verify the Elasticsearch server's identity."}),client_cert:(0,t.attr)("string",{label:"Client certificate",subText:"The path to the certificate for the Elasticsearch client to present for communication."}),client_key:(0,t.attr)("string",{subText:"The path to the key for the Elasticsearch client to use for communication."}),hosts:(0,t.attr)("string",{}),host:(0,t.attr)("string",{}),port:(0,t.attr)("string",{}),write_concern:(0,t.attr)("string",{subText:"Optional. Must be in JSON. See our documentation for help.",allowReset:!0,editType:"json",theme:"hashi short",defaultShown:"Default"}),username_template:(0,t.attr)("string",{editType:"optionalText",subText:"Enter the custom username template to use.",defaultSubText:"Template describing how dynamic usernames are generated. Vault will use the default for this plugin.",docLink:"/vault/docs/concepts/username-templating",defaultShown:"Default"}),max_open_connections:(0,t.attr)("number",{defaultValue:4}),max_idle_connections:(0,t.attr)("number",{defaultValue:0}),max_connection_lifetime:(0,t.attr)("string",{defaultValue:"0s"}),insecure:(0,t.attr)("boolean",{label:"Disable SSL verification",defaultValue:!1}),tls:(0,t.attr)("string",{label:"TLS Certificate Key",helpText:"x509 certificate for connecting to the database. This must be a PEM encoded version of the private key and the certificate combined.",editType:"file"}),tls_ca:(0,t.attr)("string",{label:"TLS CA",helpText:"x509 CA file for validating the certificate presented by the MongoDB server. Must be PEM encoded.",editType:"file"}),tls_server_name:(0,t.attr)("string",{label:"TLS server name",subText:"If set, this name is used to set the SNI host when connecting via 1TLS."}),root_rotation_statements:(0,t.attr)({subText:"The database statements to be executed to rotate the root user's credentials. If nothing is entered, Vault will use a reasonable default.",editType:"stringArray",defaultShown:"Default"}),isAvailablePlugin:(0,n.computed)("plugin_name",(function(){return!!r.AVAILABLE_PLUGIN_TYPES.find((e=>e.value===this.plugin_name))})),showAttrs:(0,n.computed)("plugin_name",(function(){const e=r.AVAILABLE_PLUGIN_TYPES.find((e=>e.value===this.plugin_name)).fields.filter((e=>!1!==e.show)).map((e=>e.attr))
return e.push("allowed_roles"),(0,i.expandAttributeMeta)(this,e)})),fieldAttrs:(0,n.computed)("plugin_name",(function(){let e=["plugin_name","name","connection_url","verify_connection","password_policy"]
return this.plugin_name&&(e=r.AVAILABLE_PLUGIN_TYPES.find((e=>e.value===this.plugin_name)).fields.filter((e=>!e.group)).map((e=>e.attr))),(0,i.expandAttributeMeta)(this,e)})),pluginFieldGroups:(0,n.computed)("plugin_name",(function(){if(!this.plugin_name)return null
const e=function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"subgroup"
const n=[],l=e.reduce((function(e,n){return(e[n[t]]=e[n[t]]||[]).push(n),e}),{})
return Object.keys(l).forEach((e=>{const t=l[e].map((e=>e.attr)),a="undefined"===e?"default":e
n.push({[a]:t})})),n}(r.AVAILABLE_PLUGIN_TYPES.find((e=>e.value===this.plugin_name)).fields.filter((e=>"pluginConfig"===e.group)),"subgroup")
return(0,i.default)(this,e)})),statementFields:(0,n.computed)("plugin_name",(function(){if(!this.plugin_name)return(0,i.expandAttributeMeta)(this,["root_rotation_statements"])
const e=r.AVAILABLE_PLUGIN_TYPES.find((e=>e.value===this.plugin_name)).fields.filter((e=>"statements"===e.group)).map((e=>e.attr))
return(0,i.expandAttributeMeta)(this,e)})),editConnectionPath:(0,a.default)(a.apiPath`${"backend"}/config/${"id"}`,"backend","id"),canEdit:(0,l.alias)("editConnectionPath.canUpdate"),canDelete:(0,l.alias)("editConnectionPath.canDelete"),resetConnectionPath:(0,a.default)(a.apiPath`${"backend"}/reset/${"id"}`,"backend","id"),canReset:(0,l.or)("resetConnectionPath.canUpdate","resetConnectionPath.canCreate"),rotateRootPath:(0,a.default)(a.apiPath`${"backend"}/rotate-root/${"id"}`,"backend","id"),canRotateRoot:(0,l.or)("rotateRootPath.canUpdate","rotateRootPath.canCreate"),rolePath:(0,a.default)(a.apiPath`${"backend"}/role/*`,"backend"),staticRolePath:(0,a.default)(a.apiPath`${"backend"}/static-role/*`,"backend"),canAddRole:(0,l.or)("rolePath.canCreate","staticRolePath.canCreate")})
e.default=o})),define("vault/models/database/credential",["exports","@ember-data/model"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({username:(0,t.attr)("string"),password:(0,t.attr)("string"),leaseId:(0,t.attr)("string"),leaseDuration:(0,t.attr)("string"),lastVaultRotation:(0,t.attr)("string"),rotationPeriod:(0,t.attr)("number"),ttl:(0,t.attr)("number"),roleType:(0,t.attr)("string")})
e.default=n})),define("vault/models/database/role",["exports","@ember-data/model","@ember/object","@ember/object/computed","vault/macros/lazy-capabilities","vault/utils/field-to-attrs","vault/utils/database-helpers"],(function(e,t,n,l,a,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var o=t.default.extend({idPrefix:"role/",backend:(0,t.attr)("string",{readOnly:!0}),name:(0,t.attr)("string",{label:"Role name"}),database:(0,t.attr)("array",{label:"Connection name",editType:"searchSelect",fallbackComponent:"string-list",models:["database/connection"],selectLimit:1,onlyAllowExisting:!0,subText:"The database connection for which credentials will be generated."}),type:(0,t.attr)("string",{label:"Type of role",noDefault:!0,possibleValues:["static","dynamic"]}),default_ttl:(0,t.attr)({editType:"ttl",defaultValue:"1h",label:"Generated credentials’s Time-to-Live (TTL)",helperTextDisabled:"Vault will use a TTL of 1 hour.",defaultShown:"Engine default"}),max_ttl:(0,t.attr)({editType:"ttl",defaultValue:"24h",label:"Generated credentials’s maximum Time-to-Live (Max TTL)",helperTextDisabled:"Vault will use a TTL of 24 hours.",defaultShown:"Engine default"}),username:(0,t.attr)("string",{subText:"The database username that this Vault role corresponds to."}),rotation_period:(0,t.attr)({editType:"ttl",defaultValue:"24h",helperTextDisabled:"Specifies the amount of time Vault should wait before rotating the password. The minimum is 5 seconds. Default is 24 hours.",helperTextEnabled:"Vault will rotate password after"}),creation_statements:(0,t.attr)("array",{editType:"stringArray"}),revocation_statements:(0,t.attr)("array",{editType:"stringArray",defaultShown:"Default"}),rotation_statements:(0,t.attr)("array",{editType:"stringArray",defaultShown:"Default"}),rollback_statements:(0,t.attr)("array",{editType:"stringArray",defaultShown:"Default"}),renew_statements:(0,t.attr)("array",{editType:"stringArray",defaultShown:"Default"}),creation_statement:(0,t.attr)("string",{editType:"json",allowReset:!0,theme:"hashi short",defaultShown:"Default"}),revocation_statement:(0,t.attr)("string",{editType:"json",allowReset:!0,theme:"hashi short",defaultShown:"Default"}),get fieldAttrs(){return(0,i.expandAttributeMeta)(this,["name","database","type"])},get showFields(){let e=["name","database","type"]
return e=e.concat((0,r.getRoleFields)(this.type)).concat(["creation_statements"]),"elasticsearch"!==this.database[0]&&(e=e.concat(["revocation_statements"])),(0,i.expandAttributeMeta)(this,e)},roleSettingAttrs:(0,n.computed)((function(){return(0,i.expandAttributeMeta)(this,["default_ttl","max_ttl","username","rotation_period","creation_statements","creation_statement","revocation_statements","revocation_statement","rotation_statements","rollback_statements","renew_statements"])})),path:(0,t.attr)("string",{readOnly:!0}),secretPath:(0,a.default)(a.apiPath`${"backend"}/${"path"}/${"id"}`,"backend","path","id"),canEditRole:(0,l.alias)("secretPath.canUpdate"),canDelete:(0,l.alias)("secretPath.canDelete"),dynamicPath:(0,a.default)(a.apiPath`${"backend"}/roles/+`,"backend"),canCreateDynamic:(0,l.alias)("dynamicPath.canCreate"),staticPath:(0,a.default)(a.apiPath`${"backend"}/static-roles/+`,"backend"),canCreateStatic:(0,l.alias)("staticPath.canCreate"),credentialPath:(0,a.default)(a.apiPath`${"backend"}/creds/${"id"}`,"backend","id"),staticCredentialPath:(0,a.default)(a.apiPath`${"backend"}/static-creds/${"id"}`,"backend","id"),canGenerateCredentials:(0,l.alias)("credentialPath.canRead"),canGetCredentials:(0,l.alias)("staticCredentialPath.canRead"),databasePath:(0,a.default)(a.apiPath`${"backend"}/config/${"database[0]"}`,"backend","database"),canUpdateDb:(0,l.alias)("databasePath.canUpdate"),rotateRolePath:(0,a.default)(a.apiPath`${"backend"}/rotate-role/${"id"}`,"backend","id"),canRotateRoleCredentials:(0,l.alias)("rotateRolePath.canUpdate")})
e.default=o})),define("vault/models/identity/_base",["exports","@ember-data/model","@ember/debug","@ember/object","vault/utils/field-to-attrs"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=t.default.extend({formFields:(0,l.computed)((function(){return(0,n.assert)("formFields should be overridden",!1)})),fields:(0,l.computed)("formFields","formFields.[]",(function(){return(0,a.expandAttributeMeta)(this,this.formFields)})),identityType:(0,l.computed)("constructor.modelName",(function(){return this.constructor.modelName.split("/")[1]}))})
e.default=i})),define("vault/models/identity/entity-alias",["exports","@ember-data/model","@ember/object","@ember/object/computed","vault/models/identity/_base","vault/macros/identity-capabilities"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=a.default.extend({parentType:"entity",formFields:(0,n.computed)((function(){return["name","mountAccessor"]})),entity:(0,t.belongsTo)("identity/entity",{readOnly:!0,async:!1}),name:(0,t.attr)("string"),canonicalId:(0,t.attr)("string"),mountAccessor:(0,t.attr)("string",{label:"Auth Backend",editType:"mountAccessor"}),metadata:(0,t.attr)({editType:"kv"}),mountPath:(0,t.attr)("string",{readOnly:!0}),mountType:(0,t.attr)("string",{readOnly:!0}),creationTime:(0,t.attr)("string",{readOnly:!0}),lastUpdateTime:(0,t.attr)("string",{readOnly:!0}),mergedFromCanonicalIds:(0,t.attr)(),updatePath:(0,i.default)(),canDelete:(0,l.alias)("updatePath.canDelete"),canEdit:(0,l.alias)("updatePath.canUpdate")})
e.default=r})),define("vault/models/identity/entity-merge",["exports","@ember-data/model","@ember/object","vault/models/identity/_base"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=l.default.extend({formFields:(0,n.computed)((function(){return["toEntityId","fromEntityIds","force"]})),toEntityId:(0,t.attr)("string",{label:"Entity to merge to"}),fromEntityIds:(0,t.attr)({label:"Entities to merge from",editType:"stringArray"}),force:(0,t.attr)("boolean",{label:'Keep MFA secrets from the "to" entity if there are merge conflicts',defaultValue:!1})})
e.default=a})),define("vault/models/identity/entity",["exports","@ember-data/model","@ember/object","@ember/object/computed","vault/models/identity/_base","vault/utils/api-path","vault/macros/lazy-capabilities"],(function(e,t,n,l,a,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var o=a.default.extend({formFields:(0,n.computed)((function(){return["name","disabled","policies","metadata"]})),name:(0,t.attr)("string"),disabled:(0,t.attr)("boolean",{defaultValue:!1,label:"Disable entity",helpText:"All associated tokens cannot be used, but are not revoked."}),mergedEntityIds:(0,t.attr)(),metadata:(0,t.attr)({editType:"kv"}),policies:(0,t.attr)({editType:"yield",isSectionHeader:!0}),creationTime:(0,t.attr)("string",{readOnly:!0}),lastUpdateTime:(0,t.attr)("string",{readOnly:!0}),aliases:(0,t.hasMany)("identity/entity-alias",{async:!1,readOnly:!0}),groupIds:(0,t.attr)({readOnly:!0}),directGroupIds:(0,t.attr)({readOnly:!0}),inheritedGroupIds:(0,t.attr)({readOnly:!0}),updatePath:(0,r.default)(i.default`identity/entity/id/${"id"}`,"id"),canDelete:(0,l.alias)("updatePath.canDelete"),canEdit:(0,l.alias)("updatePath.canUpdate"),canRead:(0,l.alias)("updatePath.canRead"),aliasPath:(0,r.default)(i.default`identity/entity-alias`),canAddAlias:(0,l.alias)("aliasPath.canCreate"),policyPath:(0,r.default)(i.default`sys/policies`),canCreatePolicies:(0,l.alias)("policyPath.canCreate")})
e.default=o})),define("vault/models/identity/group-alias",["exports","@ember-data/model","@ember/object","@ember/object/computed","vault/models/identity/_base","vault/macros/identity-capabilities"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=a.default.extend({parentType:"group",formFields:(0,n.computed)((function(){return["name","mountAccessor"]})),group:(0,t.belongsTo)("identity/group",{readOnly:!0,async:!1}),name:(0,t.attr)("string"),canonicalId:(0,t.attr)("string"),mountPath:(0,t.attr)("string",{readOnly:!0}),mountType:(0,t.attr)("string",{readOnly:!0}),mountAccessor:(0,t.attr)("string",{label:"Auth Backend",editType:"mountAccessor"}),creationTime:(0,t.attr)("string",{readOnly:!0}),lastUpdateTime:(0,t.attr)("string",{readOnly:!0}),updatePath:(0,i.default)(),canDelete:(0,l.alias)("updatePath.canDelete"),canEdit:(0,l.alias)("updatePath.canUpdate")})
e.default=r})),define("vault/models/identity/group",["exports","@ember-data/model","@ember/object/computed","@ember/object","vault/models/identity/_base","vault/macros/lazy-capabilities","vault/macros/identity-capabilities"],(function(e,t,n,l,a,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var o=a.default.extend({formFields:(0,l.computed)("type",(function(){const e=["name","type","policies","metadata"]
return"internal"===this.type?e.concat(["memberGroupIds","memberEntityIds"]):e})),name:(0,t.attr)("string"),type:(0,t.attr)("string",{defaultValue:"internal",possibleValues:["internal","external"]}),creationTime:(0,t.attr)("string",{readOnly:!0}),lastUpdateTime:(0,t.attr)("string",{readOnly:!0}),numMemberEntities:(0,t.attr)("number",{readOnly:!0}),numParentGroups:(0,t.attr)("number",{readOnly:!0}),metadata:(0,t.attr)("object",{editType:"kv"}),policies:(0,t.attr)({editType:"yield",isSectionHeader:!0}),memberGroupIds:(0,t.attr)({label:"Member Group IDs",editType:"searchSelect",isSectionHeader:!0,fallbackComponent:"string-list",models:["identity/group"]}),parentGroupIds:(0,t.attr)({label:"Parent Group IDs",editType:"searchSelect",isSectionHeader:!0,fallbackComponent:"string-list",models:["identity/group"]}),memberEntityIds:(0,t.attr)({label:"Member Entity IDs",editType:"searchSelect",isSectionHeader:!0,fallbackComponent:"string-list",models:["identity/entity"]}),hasMembers:(0,l.computed)("memberEntityIds","memberEntityIds.[]","memberGroupIds","memberGroupIds.[]",(function(){const{memberEntityIds:e,memberGroupIds:t}=this
return(e&&e.length||0)+(t&&t.length||0)>0})),policyPath:(0,i.default)(i.apiPath`sys/policies`),canCreatePolicies:(0,n.alias)("policyPath.canCreate"),alias:(0,t.belongsTo)("identity/group-alias",{async:!1,readOnly:!0}),updatePath:(0,r.default)(),canDelete:(0,n.alias)("updatePath.canDelete"),canEdit:(0,n.alias)("updatePath.canUpdate"),aliasPath:(0,i.default)(i.apiPath`identity/group-alias`),canAddAlias:(0,l.computed)("aliasPath.canCreate","type","alias",(function(){const e=this.type,t=this.alias
return"internal"!==e&&!t&&this.aliasPath.canCreate}))})
e.default=o})),define("vault/models/keymgmt/key",["exports","@ember-data/model","vault/utils/field-to-attrs","vault/macros/lazy-capabilities"],(function(e,t,n,l){var a,i,r,o,s,u,d,c,p,m,f,h,b,y,v,g,w,k,x,_,P,T,O,j,M,z,S,C,A
function R(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function D(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=e.KEY_TYPES=void 0
const E=["aes256-gcm96","rsa-2048","rsa-3072","rsa-4096","ecdsa-p256","ecdsa-p384","ecdsa-p521"]
e.KEY_TYPES=E
let N=(a=(0,t.attr)("string",{label:"Key name",subText:"This is the name of the key that shows in Vault."}),i=(0,t.attr)("string"),r=(0,t.attr)("string",{subText:"The type of cryptographic key that will be created.",possibleValues:E,defaultValue:"rsa-2048"}),o=(0,t.attr)("boolean",{label:"Allow deletion",defaultValue:!1}),s=(0,t.attr)("number",{label:"Current version"}),u=(0,t.attr)("number",{defaultValue:0,defaultShown:"All versions enabled"}),d=(0,t.attr)("array"),c=(0,t.attr)("date"),p=(0,t.attr)("date",{defaultShown:"Not yet rotated"}),m=(0,t.attr)(),f=(0,t.attr)(),h=(0,l.default)(l.apiPath`${"backend"}/key/${"id"}`,"backend","id"),b=(0,l.default)(l.apiPath`${"backend"}/key`,"backend"),y=(0,l.default)(l.apiPath`${"backend"}/key/${"id"}/kms`,"backend","id"),v=class extends t.default{constructor(){var e,t,n
super(...arguments),R(this,"name",g,this),R(this,"backend",w,this),R(this,"type",k,this),R(this,"deletionAllowed",x,this),R(this,"latestVersion",_,this),R(this,"minEnabledVersion",P,this),R(this,"versions",T,this),R(this,"created",O,this),R(this,"lastRotated",j,this),R(this,"provider",M,this),R(this,"distribution",z,this),n="key",(t="icon")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,R(this,"keyPath",S,this),R(this,"keysPath",C,this),R(this,"keyProvidersPath",A,this)}get hasVersions(){return this.versions.length>1}get createFields(){return(0,n.expandAttributeMeta)(this,["name","type","deletionAllowed"])}get updateFields(){return(0,n.expandAttributeMeta)(this,["minEnabledVersion","deletionAllowed"])}get showFields(){return(0,n.expandAttributeMeta)(this,["name","created","type","deletionAllowed","latestVersion","minEnabledVersion","lastRotated"])}get keyTypeOptions(){return(0,n.expandAttributeMeta)(this,["type"])[0]}get distFields(){return[{name:"name",type:"string",label:"Distributed name",subText:"The name given to the key by the provider."},{name:"purpose",type:"string",label:"Key Purpose"},{name:"protection",type:"string",subText:"Where cryptographic operations are performed."}]}get canCreate(){return this.keyPath.get("canCreate")}get canDelete(){return this.keyPath.get("canDelete")}get canEdit(){return this.keyPath.get("canUpdate")}get canRead(){return this.keyPath.get("canRead")}get canList(){return this.keysPath.get("canList")}get canListProviders(){return this.keyProvidersPath.get("canList")}},g=D(v.prototype,"name",[a],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=D(v.prototype,"backend",[i],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=D(v.prototype,"type",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=D(v.prototype,"deletionAllowed",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_=D(v.prototype,"latestVersion",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P=D(v.prototype,"minEnabledVersion",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=D(v.prototype,"versions",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=D(v.prototype,"created",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=D(v.prototype,"lastRotated",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),M=D(v.prototype,"provider",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),z=D(v.prototype,"distribution",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),S=D(v.prototype,"keyPath",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),C=D(v.prototype,"keysPath",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),A=D(v.prototype,"keyProvidersPath",[y],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),v)
e.default=N})),define("vault/models/keymgmt/provider",["exports","@ember-data/model","@glimmer/tracking","vault/utils/field-to-attrs","vault/decorators/model-validations","vault/macros/lazy-capabilities","@ember/service"],(function(e,t,n,l,a,i,r){var o,s,u,d,c,p,m,f,h,b,y,v,g,w,k,x,_,P,T,O
function j(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function M(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function z(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const S={azurekeyvault:["client_id","client_secret","tenant_id"],awskms:["access_key","secret_key","session_token","endpoint"],gcpckms:["service_account_file"]},C=["session_token","endpoint"],A={name:[{type:"presence",message:"Provider name is required"}],keyCollection:[{type:"presence",message:"Key Vault instance name"}],...Object.keys(S).reduce(((e,t)=>(S[t].forEach((t=>{C.includes(t)||(e[`credentials.${t}`]=[{message:`${t} is required`,validator:e=>!e.credentialProps.includes(t)||e.credentials[t]}])})),e)),{})}
let R=(o=(0,a.withModelValidations)(A),s=(0,t.attr)("string"),u=(0,t.attr)("string",{label:"Provider name",subText:"This is the name of the provider that will be displayed in Vault. This cannot be edited later."}),d=(0,t.attr)("string",{label:"Type",subText:"Choose the provider type.",possibleValues:["azurekeyvault","awskms","gcpckms"],noDefault:!0}),c=(0,t.attr)("string",{label:"Key Vault instance name",subText:"The name of a Key Vault instance must be supplied. This cannot be edited later."}),p=(0,i.default)(i.apiPath`${"backend"}/kms/${"id"}`,"backend","id"),m=(0,i.default)(i.apiPath`${"backend"}/kms`,"backend"),f=(0,i.default)(i.apiPath`${"backend"}/kms/${"id"}/key`,"backend","id"),o((b=class extends t.default{constructor(){super(...arguments),j(this,"store",y,this),j(this,"backend",v,this),j(this,"name",g,this),j(this,"provider",w,this),j(this,"keyCollection",k,this),M(this,"idPrefix","provider/"),M(this,"type","provider"),j(this,"keys",x,this),j(this,"credentials",_,this),j(this,"providerPath",P,this),j(this,"providersPath",T,this),j(this,"providerKeysPath",O,this)}get icon(){return{azurekeyvault:"azure-color",awskms:"aws-color",gcpckms:"gcp-color"}[this.provider]}get typeName(){return{azurekeyvault:"Azure Key Vault",awskms:"AWS Key Management Service",gcpckms:"Google Cloud Key Management Service"}[this.provider]}get showFields(){const e=(0,l.expandAttributeMeta)(this,["name","keyCollection"])
e.splice(1,0,{hasBlock:!0,label:"Type",value:this.typeName,icon:this.icon})
const t=this.keys.length,n=t?`${t} ${t>1?"keys":"key"}`:this.canListKeys?"None":"You do not have permission to list keys"
return e.push({hasBlock:!0,isLink:t,label:"Keys",value:n}),e}get credentialProps(){return this.provider?S[this.provider]:[]}get credentialFields(){const[e,t]=this.credentialProps.reduce(((e,t)=>{let[n,l]=e
n[t]=null
const a={name:`credentials.${t}`,type:"string",options:{label:t}}
return"service_account_file"===t&&(a.options.subText="The path to a Google service account key file, not the file itself."),l.push(a),[n,l]}),[{},[]])
return this.credentials=e,t}get createFields(){return(0,l.expandAttributeMeta)(this,["provider","name","keyCollection"])}async fetchKeys(e){if(!1===this.canListKeys)this.keys=[]
else try{this.keys=await this.store.lazyPaginatedQuery("keymgmt/key",{backend:this.backend,provider:this.name,responsePath:"data.keys",page:e})}catch(t){if(this.keys=[],404!==t.httpStatus)throw t}}get canCreate(){return this.providerPath.get("canCreate")}get canDelete(){return this.providerPath.get("canDelete")}get canEdit(){return this.providerPath.get("canUpdate")}get canRead(){return this.providerPath.get("canRead")}get canList(){return this.providersPath.get("canList")}get canListKeys(){return this.providerKeysPath.get("canList")}get canCreateKeys(){return this.providerKeysPath.get("canCreate")}},y=z(b.prototype,"store",[r.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),v=z(b.prototype,"backend",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g=z(b.prototype,"name",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=z(b.prototype,"provider",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=z(b.prototype,"keyCollection",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=z(b.prototype,"keys",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return[]}}),_=z(b.prototype,"credentials",[n.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),P=z(b.prototype,"providerPath",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=z(b.prototype,"providersPath",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=z(b.prototype,"providerKeysPath",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=b))||h)
e.default=R})),define("vault/models/kmip/ca",["exports","@ember-data/model"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({config:(0,t.belongsTo)("kmip/config",{async:!1}),caPem:(0,t.attr)("string",{label:"CA PEM"})})
e.default=n})),define("vault/models/kmip/config",["exports","@ember-data/model","@ember/object","vault/utils/openapi-to-attrs","vault/utils/field-to-attrs"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=t.default.extend({useOpenAPI:!0,ca:(0,t.belongsTo)("kmip/ca",{async:!1}),getHelpUrl:e=>`/v1/${e}/config?help=1`,fieldGroups:(0,n.computed)("newFields",(function(){let e=[{default:["listenAddrs","connectionTimeout"]}]
return e=(0,l.combineFieldGroups)(e,this.newFields,[]),(0,a.default)(this,e)}))})
e.default=i})),define("vault/models/kmip/credential",["exports","@ember-data/model","vault/utils/field-to-attrs","@ember/object","vault/utils/api-path","vault/macros/lazy-capabilities"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=t.default.extend({backend:(0,t.attr)({readOnly:!0}),scope:(0,t.attr)({readOnly:!0}),role:(0,t.attr)({readOnly:!0}),certificate:(0,t.attr)("string",{readOnly:!0}),caChain:(0,t.attr)({readOnly:!0}),privateKey:(0,t.attr)("string",{readOnly:!0,sensitive:!0}),format:(0,t.attr)("string",{possibleValues:["pem","der","pem_bundle"],defaultValue:"pem",label:"Certificate format"}),fieldGroups:(0,l.computed)((function(){return(0,n.default)(this,[{default:["format"]}])})),deletePath:(0,i.default)(a.default`${"backend"}/scope/${"scope"}/role/${"role"}/credentials/revoke`,"backend","scope","role")})
e.default=r})),define("vault/models/kmip/role",["exports","@ember-data/model","@ember/object","vault/utils/field-to-attrs","vault/utils/api-path","vault/macros/lazy-capabilities"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=e.COMPUTEDS=void 0
const r={operationFields:(0,n.computed)("newFields",(function(){return this.newFields.filter((e=>e.startsWith("operation")))})),operationFieldsWithoutSpecial:(0,n.computed)("operationFields",(function(){return this.operationFields.slice().removeObjects(["operationAll","operationNone"])})),tlsFields:(0,n.computed)((function(){return["tlsClientKeyBits","tlsClientKeyType","tlsClientTtl"]})),defaultFields:(0,n.computed)("newFields","operationFields","tlsFields",(function(){const e=["role"].concat(this.operationFields,this.tlsFields)
return this.newFields.slice().removeObjects(e)})),nonOperationFields:(0,n.computed)("newFields","operationFields",(function(){return this.newFields.slice().removeObjects(this.operationFields)}))}
e.COMPUTEDS=r
var o=t.default.extend(r,{useOpenAPI:!0,backend:(0,t.attr)({readOnly:!0}),scope:(0,t.attr)({readOnly:!0}),name:(0,t.attr)({readOnly:!0}),getHelpUrl:e=>`/v1/${e}/scope/example/role/example?help=1`,fieldGroups:(0,n.computed)("fields","defaultFields.length","tlsFields",(function(){const e=[{TLS:this.tlsFields}]
this.defaultFields.length&&e.unshift({default:this.defaultFields})
return(0,l.default)(this,e)})),operationFormFields:(0,n.computed)("operationFieldsWithoutSpecial",(function(){const e=["operationCreate","operationActivate","operationGet","operationLocate","operationRekey","operationRevoke","operationDestroy"],t=["operationAddAttribute","operationGetAttributes"],n=["operationDiscoverVersions"],a=this.operationFieldsWithoutSpecial.slice().removeObjects(e.concat(t,n)),i=[{"Managed Cryptographic Objects":e},{"Object Attributes":t},{Server:n}]
return a.length&&i.push({Other:a}),(0,l.default)(this,i)})),tlsFormFields:(0,n.computed)("tlsFields",(function(){return(0,l.expandAttributeMeta)(this,this.tlsFields)})),fields:(0,n.computed)("defaultFields",(function(){return(0,l.expandAttributeMeta)(this,this.defaultFields)})),updatePath:(0,i.default)(a.default`${"backend"}/scope/${"scope"}/role/${"id"}`,"backend","scope","id")})
e.default=o})),define("vault/models/kmip/scope",["exports","@ember-data/model","@ember/object","vault/utils/api-path","vault/utils/field-to-attrs","vault/macros/lazy-capabilities"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=t.default.extend({name:(0,t.attr)("string"),backend:(0,t.attr)({readOnly:!0}),attrs:(0,n.computed)((function(){return(0,a.expandAttributeMeta)(this,["name"])})),updatePath:(0,i.default)(l.default`${"backend"}/scope/${"id"}`,"backend","id")})
e.default=r})),define("vault/models/kubernetes/config",["exports","@ember-data/model","vault/decorators/model-form-fields","vault/decorators/model-validations"],(function(e,t,n,l){var a,i,r,o,s,u,d,c,p,m,f,h,b,y
function v(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function g(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let w=(a=(0,l.withModelValidations)({kubernetesHost:[{validator:e=>!(e.disableLocalCaJwt&&!e.kubernetesHost),message:"Kubernetes host is required"}]}),i=(0,n.withFormFields)(["kubernetesHost","serviceAccountJwt","kubernetesCaCert"]),r=(0,t.attr)("string"),o=(0,t.attr)("string",{label:"Kubernetes host",subText:"Kubernetes API URL to connect to."}),s=(0,t.attr)("string",{label:"Service account JWT",subText:"The JSON web token of the service account used by the secret engine to manage Kubernetes roles. Defaults to the local pod’s JWT if found."}),u=(0,t.attr)("string",{label:"Kubernetes CA Certificate",subText:"PEM-encoded CA certificate to use by the secret engine to verify the Kubernetes API server certificate. Defaults to the local pod’s CA if found.",editType:"textarea"}),d=(0,t.attr)("boolean",{defaultValue:!1}),a(c=i((p=class extends t.default{constructor(){super(...arguments),v(this,"backend",m,this),v(this,"kubernetesHost",f,this),v(this,"serviceAccountJwt",h,this),v(this,"kubernetesCaCert",b,this),v(this,"disableLocalCaJwt",y,this)}},m=g(p.prototype,"backend",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=g(p.prototype,"kubernetesHost",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=g(p.prototype,"serviceAccountJwt",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=g(p.prototype,"kubernetesCaCert",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=g(p.prototype,"disableLocalCaJwt",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=p))||c)||c)
e.default=w})),define("vault/models/kubernetes/role",["exports","@ember-data/model","vault/decorators/model-validations","vault/decorators/model-form-fields","vault/macros/lazy-capabilities","@glimmer/tracking"],(function(e,t,n,l,a,i){var r,o,s,u,d,c,p,m,f,h,b,y,v,g,w,k,x,_,P,T,O,j,M,z,S,C,A,R,D,E,N,F,I
function L(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function V(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let U=(r=(0,n.withModelValidations)({name:[{type:"presence",message:"Name is required"}]}),o=(0,l.withFormFields)(["name","serviceAccountName","kubernetesRoleType","kubernetesRoleName","allowedKubernetesNamespaces","tokenMaxTtl","tokenDefaultTtl","nameTemplate"]),s=(0,t.attr)("string"),u=(0,t.attr)("string",{label:"Role name",subText:"The role’s name in Vault."}),d=(0,t.attr)("string",{label:"Service account name",subText:"Vault will use the default template when generating service accounts, roles and role bindings."}),c=(0,t.attr)("string",{label:"Kubernetes role type",editType:"radio",possibleValues:["Role","ClusterRole"]}),p=(0,t.attr)("string",{label:"Kubernetes role name",subText:"Vault will use the default template when generating service accounts, roles and role bindings."}),m=(0,t.attr)("string",{label:"Allowed Kubernetes namespaces",subText:'A list of the valid Kubernetes namespaces in which this role can be used for creating service accounts. If set to "*" all namespaces are allowed.'}),f=(0,t.attr)({label:"Max Lease TTL",editType:"ttl"}),h=(0,t.attr)({label:"Default Lease TTL",editType:"ttl"}),b=(0,t.attr)("string",{label:"Name template",editType:"optionalText",defaultSubText:"Vault will use the default template when generating service accounts, roles and role bindings.",subText:"Vault will use the default template when generating service accounts, roles and role bindings."}),y=(0,t.attr)("string"),v=(0,a.default)(a.apiPath`${"backend"}/roles/${"name"}`,"backend","name"),g=(0,a.default)(a.apiPath`${"backend"}/creds/${"name"}`,"backend","name"),w=(0,a.default)(a.apiPath`${"backend"}/roles`,"backend"),r(k=o((x=class extends t.default{constructor(){super(...arguments),L(this,"backend",_,this),L(this,"name",P,this),L(this,"serviceAccountName",T,this),L(this,"kubernetesRoleType",O,this),L(this,"kubernetesRoleName",j,this),L(this,"allowedKubernetesNamespaces",M,this),L(this,"tokenMaxTtl",z,this),L(this,"tokenDefaultTtl",S,this),L(this,"nameTemplate",C,this),L(this,"extraAnnotations",A,this),L(this,"extraLabels",R,this),L(this,"generatedRoleRules",D,this),L(this,"_generationPreference",E,this),L(this,"rolePath",N,this),L(this,"credsPath",F,this),L(this,"rolesPath",I,this)}get generationPreference(){if(this._generationPreference)return this._generationPreference
let e=null
return this.serviceAccountName?e="basic":this.kubernetesRoleName?e="expanded":this.generatedRoleRules&&(e="full"),e}set generationPreference(e){({basic:["kubernetesRoleType","kubernetesRoleName","generatedRoleRules","nameTemplate"],expanded:["serviceAccountName","generatedRoleRules"],full:["serviceAccountName","kubernetesRoleName"]})[e].forEach((e=>this[e]=null)),this._generationPreference=e}get filteredFormFields(){const e={basic:[2,3,7],expanded:[1],full:[1,3]}[this.generationPreference]
return e?this.formFields.filter(((t,n)=>!e.includes(n))):null}get canCreate(){return this.rolePath.get("canCreate")}get canDelete(){return this.rolePath.get("canDelete")}get canEdit(){return this.rolePath.get("canUpdate")}get canRead(){return this.rolePath.get("canRead")}get canList(){return this.rolesPath.get("canList")}get canGenerateCreds(){return this.credsPath.get("canCreate")}},_=V(x.prototype,"backend",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P=V(x.prototype,"name",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=V(x.prototype,"serviceAccountName",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=V(x.prototype,"kubernetesRoleType",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=V(x.prototype,"kubernetesRoleName",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),M=V(x.prototype,"allowedKubernetesNamespaces",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),z=V(x.prototype,"tokenMaxTtl",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),S=V(x.prototype,"tokenDefaultTtl",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),C=V(x.prototype,"nameTemplate",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),A=V(x.prototype,"extraAnnotations",[t.attr],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),R=V(x.prototype,"extraLabels",[t.attr],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),D=V(x.prototype,"generatedRoleRules",[y],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),E=V(x.prototype,"_generationPreference",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),N=V(x.prototype,"rolePath",[v],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),F=V(x.prototype,"credsPath",[g],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),I=V(x.prototype,"rolesPath",[w],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=x))||k)||k)
e.default=U})),define("vault/models/kv/config",["exports","@ember-data/model","vault/macros/lazy-capabilities","vault/decorators/model-form-fields","core/helpers/format-duration"],(function(e,t,n,l,a){var i,r,o,s,u,d,c,p,m,f,h,b
function y(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function v(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let g=(i=(0,l.withFormFields)(["casRequired","deleteVersionAfter","maxVersions"]),r=(0,t.attr)("number",{label:"Maximum number of versions"}),o=(0,t.attr)("boolean",{label:"Require check and set"}),s=(0,t.attr)({label:"Automate secret deletion"}),u=(0,n.default)(n.apiPath`${"backend"}/config`,"backend"),i((c=class extends t.default{constructor(){super(...arguments),y(this,"backend",p,this),y(this,"maxVersions",m,this),y(this,"casRequired",f,this),y(this,"deleteVersionAfter",h,this),y(this,"configPath",b,this)}get canRead(){return!1!==this.configPath.get("canRead")}get displayFields(){return["casRequired","deleteVersionAfter","maxVersions"]}get displayDeleteTtl(){return"0s"===this.deleteVersionAfter?"Never delete":(0,a.duration)([this.deleteVersionAfter])}},p=v(c.prototype,"backend",[t.attr],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=v(c.prototype,"maxVersions",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=v(c.prototype,"casRequired",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=v(c.prototype,"deleteVersionAfter",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=v(c.prototype,"configPath",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=c))||d)
e.default=g})),define("vault/models/kv/data",["exports","@ember-data/model","vault/macros/lazy-capabilities","vault/decorators/model-validations","vault/decorators/model-form-fields","kv/utils/kv-deleted"],(function(e,t,n,l,a,i){var r,o,s,u,d,c,p,m,f,h,b,y,v,g,w,k,x,_,P,T,O,j,M,z,S,C,A,R,D,E,N,F,I,L
function V(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function U(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const $={path:[{type:"presence",message:"Path can't be blank."},{type:"endsInSlash",message:"Path can't end in forward slash '/'."},{type:"containsWhiteSpace",message:"Path contains whitespace. If this is desired, you'll need to encode it with %20 in API requests.",level:"warn"}],secretData:[{validator:e=>void 0===e.secretData||"object"==typeof e.secretData,message:"Vault expects data to be formatted as an JSON object."}]}
let q=(r=(0,l.withModelValidations)($),o=(0,a.withFormFields)(),s=(0,t.attr)("string"),u=(0,t.attr)("string",{label:"Path for this secret"}),d=(0,t.attr)("object"),c=(0,t.attr)("string"),p=(0,t.attr)("object"),m=(0,t.attr)("string"),f=(0,t.attr)("boolean"),h=(0,t.attr)("number"),b=(0,t.attr)("number"),y=(0,t.attr)("number"),v=(0,n.default)(n.apiPath`${"backend"}/data/${"path"}`,"backend","path"),g=(0,n.default)(n.apiPath`${"backend"}/metadata/${"path"}`,"backend","path"),w=(0,n.default)(n.apiPath`${"backend"}/delete/${"path"}`,"backend","path"),k=(0,n.default)(n.apiPath`${"backend"}/destroy/${"path"}`,"backend","path"),x=(0,n.default)(n.apiPath`${"backend"}/undelete/${"path"}`,"backend","path"),r(_=o((P=class extends t.default{constructor(){super(...arguments),V(this,"backend",T,this),V(this,"path",O,this),V(this,"secretData",j,this),V(this,"createdTime",M,this),V(this,"customMetadata",z,this),V(this,"deletionTime",S,this),V(this,"destroyed",C,this),V(this,"version",A,this),V(this,"failReadErrorCode",R,this),V(this,"casVersion",D,this),V(this,"dataPath",E,this),V(this,"metadataPath",N,this),V(this,"deletePath",F,this),V(this,"destroyPath",I,this),V(this,"undeletePath",L,this)}get state(){return this.destroyed?"destroyed":this.isSecretDeleted?"deleted":this.createdTime?"created":""}get isSecretDeleted(){return(0,i.isDeleted)(this.deletionTime)}get canDeleteLatestVersion(){return!1!==this.dataPath.get("canDelete")}get canDeleteVersion(){return!1!==this.deletePath.get("canUpdate")}get canUndelete(){return!1!==this.undeletePath.get("canUpdate")}get canDestroyVersion(){return!1!==this.destroyPath.get("canUpdate")}get canEditData(){return!1!==this.dataPath.get("canUpdate")}get canReadData(){return!1!==this.dataPath.get("canRead")}get canReadMetadata(){return!1!==this.metadataPath.get("canRead")}get canUpdateMetadata(){return!1!==this.metadataPath.get("canUpdate")}get canListMetadata(){return!1!==this.metadataPath.get("canList")}get canDeleteMetadata(){return!1!==this.metadataPath.get("canDelete")}},T=U(P.prototype,"backend",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=U(P.prototype,"path",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=U(P.prototype,"secretData",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),M=U(P.prototype,"createdTime",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),z=U(P.prototype,"customMetadata",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),S=U(P.prototype,"deletionTime",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),C=U(P.prototype,"destroyed",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),A=U(P.prototype,"version",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),R=U(P.prototype,"failReadErrorCode",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),D=U(P.prototype,"casVersion",[y],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),E=U(P.prototype,"dataPath",[v],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),N=U(P.prototype,"metadataPath",[g],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),F=U(P.prototype,"deletePath",[w],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),I=U(P.prototype,"destroyPath",[k],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),L=U(P.prototype,"undeletePath",[x],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_=P))||_)||_)
e.default=q})),define("vault/models/kv/metadata",["exports","@ember-data/model","vault/macros/lazy-capabilities","vault/decorators/model-validations","vault/decorators/model-form-fields","core/utils/key-utils","kv/utils/kv-deleted"],(function(e,t,n,l,a,i,r){var o,s,u,d,c,p,m,f,h,b,y,v,g,w,k,x,_,P,T,O,j,M,z,S,C,A,R,D,E,N,F,I
function L(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function V(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let U=(o=(0,l.withModelValidations)({maxVersions:[{type:"number",message:"Maximum versions must be a number."},{type:"length",options:{min:1,max:16},message:"You cannot go over 16 characters."}]}),s=(0,a.withFormFields)(["customMetadata","maxVersions","casRequired","deleteVersionAfter"]),u=(0,t.attr)("string"),d=(0,t.attr)("string"),c=(0,t.attr)("string"),p=(0,t.attr)("number",{defaultValue:0,label:"Maximum number of versions",subText:"The number of versions to keep per key. Once the number of keys exceeds the maximum number set here, the oldest version will be permanently deleted."}),m=(0,t.attr)("boolean",{defaultValue:!1,label:"Require Check and Set",subText:"Writes will only be allowed if the key's current version matches the version specified in the cas parameter."}),f=(0,t.attr)("string",{defaultValue:"0s",editType:"ttl",label:"Automate secret deletion",helperTextDisabled:"A secret's version must be manually deleted.",helperTextEnabled:"Delete all new versions of this secret after:"}),h=(0,t.attr)("object",{editType:"kv",subText:"An optional set of informational key-value pairs that will be stored with all secret versions."}),b=(0,t.attr)("string"),y=(0,t.attr)("number"),v=(0,t.attr)("number"),g=(0,t.attr)("string"),w=(0,t.attr)("object"),k=(0,n.default)(n.apiPath`${"backend"}/data/${"permissionsPath"}`,"backend","permissionsPath"),x=(0,n.default)(n.apiPath`${"backend"}/metadata/${"permissionsPath"}`,"backend","permissionsPath"),o(_=s((P=class extends t.default{constructor(){super(...arguments),L(this,"backend",T,this),L(this,"path",O,this),L(this,"fullSecretPath",j,this),L(this,"maxVersions",M,this),L(this,"casRequired",z,this),L(this,"deleteVersionAfter",S,this),L(this,"customMetadata",C,this),L(this,"createdTime",A,this),L(this,"currentVersion",R,this),L(this,"oldestVersion",D,this),L(this,"updatedTime",E,this),L(this,"versions",N,this),L(this,"dataPath",F,this),L(this,"metadataPath",I,this)}get pathIsDirectory(){return(0,i.keyIsFolder)(this.path)}get isSecretDeleted(){return(0,r.isDeleted)(this.deletionTime)}get sortedVersions(){const e=[]
for(const t in this.versions)this.versions[t].isSecretDeleted=(0,r.isDeleted)(this.versions[t].deletion_time),e.push({version:t,...this.versions[t]})
return e.reverse()}get currentSecret(){if(!this.versions||!this.currentVersion)return!1
const e=this.versions[this.currentVersion],t=e.destroyed?"destroyed":(0,r.isDeleted)(e.deletion_time)?"deleted":"created"
return{state:t,isDeactivated:"created"!==t}}get permissionsPath(){return this.fullSecretPath||this.path}get canDeleteMetadata(){return!1!==this.metadataPath.get("canDelete")}get canReadMetadata(){return!1!==this.metadataPath.get("canRead")}get canUpdateMetadata(){return!1!==this.metadataPath.get("canUpdate")}get canCreateVersionData(){return!1!==this.dataPath.get("canUpdate")}},T=V(P.prototype,"backend",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=V(P.prototype,"path",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=V(P.prototype,"fullSecretPath",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),M=V(P.prototype,"maxVersions",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),z=V(P.prototype,"casRequired",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),S=V(P.prototype,"deleteVersionAfter",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),C=V(P.prototype,"customMetadata",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),A=V(P.prototype,"createdTime",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),R=V(P.prototype,"currentVersion",[y],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),D=V(P.prototype,"oldestVersion",[v],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),E=V(P.prototype,"updatedTime",[g],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),N=V(P.prototype,"versions",[w],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),F=V(P.prototype,"dataPath",[k],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),I=V(P.prototype,"metadataPath",[x],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_=P))||_)||_)
e.default=U})),define("vault/models/ldap/config",["exports","@ember-data/model","vault/decorators/model-form-fields","vault/decorators/model-validations"],(function(e,t,n,l){var a,i,r,o,s,u,d,c,p,m,f,h,b,y,v,g,w,k,x,_,P,T,O,j,M,z,S,C,A,R,D,E,N,F,I,L
function V(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function U(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let $=(a=(0,l.withModelValidations)({binddn:[{type:"presence",message:"Administrator distinguished name is required."}],bindpass:[{type:"presence",message:"Administrator password is required."}]}),i=(0,n.withFormFields)(null,[{default:["binddn","bindpass","url","password_policy"]},{"TLS options":["starttls","insecure_tls","certificate","client_tls_cert","client_tls_key"]},{"More options":["userdn","userattr","upndomain","connection_timeout","request_timeout"]}]),r=(0,t.attr)("string"),o=(0,t.attr)("string",{label:"Administrator Distinguished Name",subText:"Distinguished name of the administrator to bind (Bind DN) when performing user and group search. Example: cn=vault,ou=Users,dc=example,dc=com."}),s=(0,t.attr)("string",{label:"Administrator Password",subText:"Password to use along with Bind DN when performing user search."}),u=(0,t.attr)("string",{label:"URL",subText:"The directory server to connect to."}),d=(0,t.attr)("string",{editType:"optionalText",label:"Use custom password policy",subText:"Specify the name of an existing password policy.",defaultSubText:"Unless a custom policy is specified, Vault will use a default.",defaultShown:"Default",docLink:"/vault/docs/concepts/password-policies"}),c=(0,t.attr)("string"),p=(0,t.attr)("boolean",{label:"Start TLS",subText:"If checked, or address contains “ldaps://”, creates an encrypted connection with LDAP."}),m=(0,t.attr)("boolean",{label:"Insecure TLS",subText:"If checked, skips LDAP server SSL certificate verification - insecure, use with caution!"}),f=(0,t.attr)("string",{editType:"file",label:"CA Certificate",helpText:"CA certificate to use when verifying LDAP server certificate, must be x509 PEM encoded."}),h=(0,t.attr)("string",{editType:"file",label:"Client TLS Certificate",helpText:"Client certificate to provide to the LDAP server, must be x509 PEM encoded."}),b=(0,t.attr)("string",{editType:"file",label:"Client TLS Key",helpText:"Client key to provide to the LDAP server, must be x509 PEM encoded."}),y=(0,t.attr)("string",{label:"Userdn",helpText:"The base DN under which to perform user search in library management and static roles."}),v=(0,t.attr)("string",{label:"Userattr",subText:"The attribute field name used to perform user search in library management and static roles."}),g=(0,t.attr)("string",{label:"Upndomain",subText:"The domain (userPrincipalDomain) used to construct a UPN string for authentication."}),w=(0,t.attr)("number",{editType:"optionalText",label:"Connection Timeout",subText:"Specify the connection timeout length in seconds.",defaultSubText:"Vault will use the default of 30 seconds.",defaultShown:"Default 30 seconds."}),k=(0,t.attr)("number",{editType:"optionalText",label:"Request Timeout",subText:"Specify the connection timeout length in seconds.",defaultSubText:"Vault will use the default of 90 seconds.",defaultShown:"Default 90 seconds."}),a(x=i((_=class extends t.default{constructor(){super(...arguments),V(this,"backend",P,this),V(this,"binddn",T,this),V(this,"bindpass",O,this),V(this,"url",j,this),V(this,"password_policy",M,this),V(this,"schema",z,this),V(this,"starttls",S,this),V(this,"insecure_tls",C,this),V(this,"certificate",A,this),V(this,"client_tls_cert",R,this),V(this,"client_tls_key",D,this),V(this,"userdn",E,this),V(this,"userattr",N,this),V(this,"upndomain",F,this),V(this,"connection_timeout",I,this),V(this,"request_timeout",L,this)}async rotateRoot(){return this.store.adapterFor("ldap/config").rotateRoot(this.backend)}},P=U(_.prototype,"backend",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=U(_.prototype,"binddn",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=U(_.prototype,"bindpass",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=U(_.prototype,"url",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),M=U(_.prototype,"password_policy",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),z=U(_.prototype,"schema",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),S=U(_.prototype,"starttls",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),C=U(_.prototype,"insecure_tls",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),A=U(_.prototype,"certificate",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),R=U(_.prototype,"client_tls_cert",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),D=U(_.prototype,"client_tls_key",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),E=U(_.prototype,"userdn",[y],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),N=U(_.prototype,"userattr",[v],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),F=U(_.prototype,"upndomain",[g],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),I=U(_.prototype,"connection_timeout",[w],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),L=U(_.prototype,"request_timeout",[k],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=_))||x)||x)
e.default=$})),define("vault/models/ldap/library",["exports","@ember-data/model","vault/decorators/model-form-fields","vault/decorators/model-validations","vault/macros/lazy-capabilities"],(function(e,t,n,l,a){var i,r,o,s,u,d,c,p,m,f,h,b,y,v,g,w,k,x,_,P,T,O,j,M
function z(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function S(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let C=(i=(0,l.withModelValidations)({name:[{type:"presence",message:"Library name is required."}],service_account_names:[{type:"presence",message:"At least one service account is required."}]}),r=(0,n.withFormFields)(["name","service_account_names","ttl","max_ttl","disable_check_in_enforcement"]),o=(0,t.attr)("string"),s=(0,t.attr)("string",{label:"Library name",editDisabled:!0}),u=(0,t.attr)("string",{editType:"stringArray",label:"Accounts",subText:"The names of all the accounts that can be checked out from this set. These accounts must only be used by Vault, and may only be in one set."}),d=(0,t.attr)({editType:"ttl",label:"Default lease TTL",detailsLabel:"TTL",helperTextDisabled:"Vault will use the default lease duration.",defaultValue:"24h",defaultShown:"Engine default"}),c=(0,t.attr)({editType:"ttl",label:"Max lease TTL",detailsLabel:"Max TTL",helperTextDisabled:"Vault will use the default lease duration.",defaultValue:"24h",defaultShown:"Engine default"}),p=(0,t.attr)("string",{editType:"radio",label:"Check-in enforcement",subText:"When enabled, accounts must be checked in by the entity or client token that checked them out. If disabled, anyone with the right permission can check the account back in.",possibleValues:["Disabled","Enabled"],defaultValue:"Enabled"}),m=(0,a.default)(a.apiPath`${"backend"}/library/${"name"}`,"backend","name"),f=(0,a.default)(a.apiPath`${"backend"}/library/${"name"}/status`,"backend","name"),h=(0,a.default)(a.apiPath`${"backend"}/library/${"name"}/check-out`,"backend","name"),b=(0,a.default)(a.apiPath`${"backend"}/library/${"name"}/check-in`,"backend","name"),i(y=r((v=class extends t.default{constructor(){super(...arguments),z(this,"backend",g,this),z(this,"name",w,this),z(this,"service_account_names",k,this),z(this,"ttl",x,this),z(this,"max_ttl",_,this),z(this,"disable_check_in_enforcement",P,this),z(this,"libraryPath",T,this),z(this,"statusPath",O,this),z(this,"checkOutPath",j,this),z(this,"checkInPath",M,this)}get displayFields(){return this.formFields.filter((e=>"service_account_names"!==e.name))}get canCreate(){return!1!==this.libraryPath.get("canCreate")}get canDelete(){return!1!==this.libraryPath.get("canDelete")}get canEdit(){return!1!==this.libraryPath.get("canUpdate")}get canRead(){return!1!==this.libraryPath.get("canRead")}get canList(){return!1!==this.libraryPath.get("canList")}get canReadStatus(){return!1!==this.statusPath.get("canRead")}get canCheckOut(){return!1!==this.checkOutPath.get("canUpdate")}get canCheckIn(){return!1!==this.checkInPath.get("canUpdate")}fetchStatus(){return this.store.adapterFor("ldap/library").fetchStatus(this.backend,this.name)}checkOutAccount(e){return this.store.adapterFor("ldap/library").checkOutAccount(this.backend,this.name,e)}checkInAccount(e){return this.store.adapterFor("ldap/library").checkInAccount(this.backend,this.name,[e])}},g=S(v.prototype,"backend",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=S(v.prototype,"name",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=S(v.prototype,"service_account_names",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=S(v.prototype,"ttl",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_=S(v.prototype,"max_ttl",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P=S(v.prototype,"disable_check_in_enforcement",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=S(v.prototype,"libraryPath",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=S(v.prototype,"statusPath",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=S(v.prototype,"checkOutPath",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),M=S(v.prototype,"checkInPath",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=v))||y)||y)
e.default=C})),define("vault/models/ldap/role",["exports","@ember-data/model","vault/decorators/model-form-fields","vault/decorators/model-validations","vault/macros/lazy-capabilities"],(function(e,t,n,l,a){var i,r,o,s,u,d,c,p,m,f,h,b,y,v,g,w,k,x,_,P,T,O,j,M,z,S,C,A,R,D,E,N,F,I
function L(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function V(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.staticRoleFields=e.dynamicRoleFields=e.default=void 0
e.staticRoleFields=["username","dn","rotation_period"]
e.dynamicRoleFields=["default_ttl","max_ttl","username_template","creation_ldif","deletion_ldif","rollback_ldif"]
let U=(i=(0,l.withModelValidations)({name:[{type:"presence",message:"Name is required"}],username:[{validator:e=>!(e.isStatic&&!e.username),message:"Username is required."}],rotation_period:[{validator:e=>!(e.isStatic&&!e.rotation_period),message:"Rotation Period is required."}],creation_ldif:[{validator:e=>!(e.isDynamic&&!e.creation_ldif),message:"Creation LDIF is required."}],deletion_ldif:[{validator:e=>!(e.isDynamic&&!e.creation_ldif),message:"Deletion LDIF is required."}]}),r=(0,n.withFormFields)(),o=(0,t.attr)("string"),s=(0,t.attr)("string",{defaultValue:"static"}),u=(0,t.attr)("string",{label:"Role name",subText:"The name of the role that will be used in Vault.",editDisabled:!0}),d=(0,t.attr)("string",{label:"Distinguished name",subText:"Distinguished name (DN) of entry Vault should manage."}),c=(0,t.attr)("string",{label:"Username",subText:"The name of the user to be used when logging in. This is useful when DN isn't used for login purposes."}),p=(0,t.attr)({editType:"ttl",label:"Rotation period",helperTextEnabled:"Specifies the amount of time Vault should wait before rotating the password. The minimum is 5 seconds.",hideToggle:!0}),m=(0,t.attr)({editType:"ttl",label:"Generated credential’s time-to-live (TTL)",detailsLabel:"TTL",helperTextDisabled:"Vault will use the default of 1 hour.",defaultValue:"1h",defaultShown:"Engine default"}),f=(0,t.attr)({editType:"ttl",label:"Generated credential’s maximum time-to-live (Max TTL)",detailsLabel:"Max TTL",helperTextDisabled:"Vault will use the engine default of 24 hours.",defaultValue:"24h",defaultShown:"Engine default"}),h=(0,t.attr)("string",{editType:"optionalText",label:"Username template",subText:"Enter the custom username template to use.",defaultSubText:"Template describing how dynamic usernames are generated. Vault will use the default for this plugin.",docLink:"/vault/docs/concepts/username-templating",defaultShown:"Default"}),b=(0,t.attr)("string",{editType:"json",label:"Creation LDIF",helpText:"Specifies the LDIF statements executed to create a user. May optionally be base64 encoded.",example:"# The example below is treated as a comment and will not be submitted\n# dn: cn={{.Username}},ou=users,dc=learn,dc=example\n# objectClass: person\n# objectClass: top\n",mode:"ruby",sectionHeading:"LDIF Statements"}),y=(0,t.attr)("string",{editType:"json",label:"Deletion LDIF",helpText:"Specifies the LDIF statements executed to delete a user once its TTL has expired. May optionally be base64 encoded.",example:"# The example below is treated as a comment and will not be submitted\n# dn: cn={{.Username}},ou=users,dc=learn,dc=example\n# changetype: delete\n",mode:"ruby"}),v=(0,t.attr)("string",{editType:"json",label:"Rollback LDIF",helpText:"Specifies the LDIF statement to attempt to rollback any changes if the creation results in an error. May optionally be base64 encoded.",example:"# The example below is treated as a comment and will not be submitted\n# dn: cn={{.Username}},ou=users,dc=learn,dc=example\n# changetype: delete\n",mode:"ruby"}),g=(0,a.default)(a.apiPath`${"backend"}/${"roleUri"}/${"name"}`,"backend","roleUri","name"),w=(0,a.default)(a.apiPath`${"backend"}/${"credsUri"}/${"name"}`,"backend","credsUri","name"),k=(0,a.default)(a.apiPath`${"backend"}/rotate-role/${"name"}`,"backend","name"),i(x=r((_=class extends t.default{constructor(){super(...arguments),L(this,"backend",P,this),L(this,"type",T,this),L(this,"name",O,this),L(this,"dn",j,this),L(this,"username",M,this),L(this,"rotation_period",z,this),L(this,"default_ttl",S,this),L(this,"max_ttl",C,this),L(this,"username_template",A,this),L(this,"creation_ldif",R,this),L(this,"deletion_ldif",D,this),L(this,"rollback_ldif",E,this),L(this,"rolePath",N,this),L(this,"credsPath",F,this),L(this,"staticRotateCredsPath",I,this)}get isStatic(){return"static"===this.type}get isDynamic(){return"dynamic"===this.type}get fieldsForType(){return this.isStatic?["username","dn","rotation_period"]:["default_ttl","max_ttl","username_template","creation_ldif","deletion_ldif","rollback_ldif"]}get formFields(){return this.allFields.filter((e=>"name"===e.name||this.fieldsForType.includes(e.name)))}get displayFields(){const[e,...t]=this.formFields
return[e,{name:"type",options:{label:"Role type"}},...t]}get roleUri(){return this.isStatic?"static-role":"role"}get credsUri(){return this.isStatic?"static-cred":"creds"}get canCreate(){return!1!==this.rolePath.get("canCreate")}get canDelete(){return!1!==this.rolePath.get("canDelete")}get canEdit(){return!1!==this.rolePath.get("canUpdate")}get canRead(){return!1!==this.rolePath.get("canRead")}get canList(){return!1!==this.rolePath.get("canList")}get canReadCreds(){return!1!==this.credsPath.get("canRead")}get canRotateStaticCreds(){return this.isStatic&&!1!==this.staticRotateCredsPath.get("canCreate")}fetchCredentials(){return this.store.adapterFor("ldap/role").fetchCredentials(this.backend,this.type,this.name)}rotateStaticPassword(){return this.store.adapterFor("ldap/role").rotateStaticPassword(this.backend,this.name)}},P=V(_.prototype,"backend",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=V(_.prototype,"type",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=V(_.prototype,"name",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=V(_.prototype,"dn",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),M=V(_.prototype,"username",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),z=V(_.prototype,"rotation_period",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),S=V(_.prototype,"default_ttl",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),C=V(_.prototype,"max_ttl",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),A=V(_.prototype,"username_template",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),R=V(_.prototype,"creation_ldif",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),D=V(_.prototype,"deletion_ldif",[y],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),E=V(_.prototype,"rollback_ldif",[v],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),N=V(_.prototype,"rolePath",[g],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),F=V(_.prototype,"credsPath",[w],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),I=V(_.prototype,"staticRotateCredsPath",[k],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=_))||x)||x)
e.default=U})),define("vault/models/lease",["exports","@ember-data/model","@ember/object/computed","vault/mixins/key-mixin"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=t.default.extend(l.default,{issueTime:(0,t.attr)("string"),expireTime:(0,t.attr)("string"),lastRenewal:(0,t.attr)("string"),renewable:(0,t.attr)("boolean"),ttl:(0,t.attr)("number"),isAuthLease:(0,n.match)("id",/^auth/)})
e.default=a})),define("vault/models/license",["exports","@ember-data/model"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({expirationTime:(0,t.attr)("string"),features:(0,t.attr)("array"),licenseId:(0,t.attr)("string"),startTime:(0,t.attr)("string"),performanceStandbyCount:(0,t.attr)("number"),autoloaded:(0,t.attr)("boolean")})
e.default=n})),define("vault/models/mfa-login-enforcement",["exports","@ember-data/model","@ember/array/proxy","@ember/object/promise-proxy-mixin","vault/helpers/mountable-auth-methods","vault/decorators/model-validations","@ember/utils","@ember/service"],(function(e,t,n,l,a,i,r,o){var s,u,d,c,p,m,f,h,b,y,v,g,w,k,x,_,P,T
function O(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function j(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const M={name:[{type:"presence",message:"Name is required"}],mfa_methods:[{type:"presence",message:"At least one MFA method is required"}],targets:[{validator(e){const t=e.hasMany("identity_entities").ids(),n=e.hasMany("identity_groups").ids()
return(0,r.isPresent)(e.auth_method_accessors)||(0,r.isPresent)(e.auth_method_types)||(0,r.isPresent)(t)||(0,r.isPresent)(n)},message:"At least one target is required. If you've selected one, click 'Add' to make sure it's added to this enforcement."}]}
let z=(s=(0,i.withModelValidations)(M),u=(0,t.attr)("string"),d=(0,t.hasMany)("mfa-method"),c=(0,t.attr)("string"),p=(0,t.attr)("array",{defaultValue:()=>[]}),m=(0,t.attr)("array",{defaultValue:()=>[]}),f=(0,t.hasMany)("identity/entity"),h=(0,t.hasMany)("identity/group"),s((y=class extends t.default{constructor(){super(...arguments),O(this,"store",v,this),O(this,"name",g,this),O(this,"mfa_methods",w,this),O(this,"namespace_id",k,this),O(this,"auth_method_accessors",x,this),O(this,"auth_method_types",_,this),O(this,"identity_entities",P,this),O(this,"identity_groups",T,this)}get targets(){return n.default.extend(l.default).create({promise:this.prepareTargets()})}async prepareTargets(){let e
const t=[]
if(this.auth_method_accessors.length||this.auth_method_types.length)try{const{data:t}=await this.store.adapterFor("auth-method").findAll()
e=Object.keys(t).map((e=>({path:e,...t[e]})))}catch(n){}if(this.auth_method_accessors.length){const n=e.filter((e=>this.auth_method_accessors.includes(e.accessor)))
t.addObjects(n.map((e=>({icon:this.iconForMount(e.type),link:"vault.cluster.access.method",linkModels:[e.path.slice(0,-1)],title:e.path,subTitle:e.accessor}))))}this.auth_method_types.forEach((n=>{const l=this.iconForMount(n),a=e.filterBy("type",n).length
t.addObject({key:"auth_method_types",icon:l,title:n,subTitle:`All ${n} mounts (${a})`})}))
for(const l of["identity_entities","identity_groups"])(await this[l]).forEach((e=>{t.addObject({key:l,icon:"user",link:"vault.cluster.access.identity.show",linkModels:[l.split("_")[1],e.id,"details"],title:e.name,subTitle:e.id})}))
return t}iconForMount(e){const t=(0,a.methods)().findBy("type",e)
return t?t.glyph||t.type:"token"}},v=j(y.prototype,"store",[o.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g=j(y.prototype,"name",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=j(y.prototype,"mfa_methods",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=j(y.prototype,"namespace_id",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=j(y.prototype,"auth_method_accessors",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_=j(y.prototype,"auth_method_types",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P=j(y.prototype,"identity_entities",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=j(y.prototype,"identity_groups",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=y))||b)
e.default=z})),define("vault/models/mfa-method",["exports","@ember-data/model","@ember/string","vault/utils/field-to-attrs","vault/decorators/model-validations","@ember/utils"],(function(e,t,n,l,a,i){var r,o,s,u,d,c,p,m,f,h,b,y,v,g,w,k,x,_,P,T,O,j,M,z,S,C,A,R,D,E,N,F,I,L,V,U,$,q,K,B,G,W,H,Y,Q,J,Z,X,ee,te,ne,le,ae,ie,re,oe,se
function ue(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function de(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const ce={common:[],duo:["username_format","secret_key","integration_key","api_hostname","push_info","use_passcode"],okta:["username_format","mount_accessor","org_name","api_token","base_url","primary_email"],totp:["issuer","period","key_size","qr_size","algorithm","digits","skew","max_validation_attempts"],pingid:["username_format","settings_file_base64","use_signature","idp_url","admin_url","authenticator_url","org_alias"]},pe={duo:["secret_key","integration_key","api_hostname"],okta:["org_name","api_token"],totp:["issuer"],pingid:["settings_file_base64"]},me=Object.keys(pe).reduce(((e,t)=>(pe[t].forEach((n=>{e[`${n}`]=[{message:`${n.replace(/_/g," ")} is required`,validator:e=>e.type!==t||(0,i.isPresent)(e[n])}]})),e)),{})
let fe=(r=(0,a.withModelValidations)(me),o=(0,t.attr)("string"),s=(0,t.attr)("string",{label:"Username format",subText:"How to map identity names to MFA method names. "}),u=(0,t.attr)("string",{label:"Namespace"}),d=(0,t.attr)("string"),c=(0,t.attr)("string",{label:"Settings file",subText:"A base-64 encoded third party setting file retrieved from the PingIDs configuration page."}),p=(0,t.attr)("boolean"),m=(0,t.attr)("string"),f=(0,t.attr)("string"),h=(0,t.attr)("string"),b=(0,t.attr)("string"),y=(0,t.attr)("string",{label:"Organization name",subText:"Name of the organization to be used in the Okta API."}),v=(0,t.attr)("string",{label:"Okta API key"}),g=(0,t.attr)("string",{label:"Base URL",subText:"If set, will be used as the base domain for API requests. Example are okta.com, oktapreview.com and okta-emea.com."}),w=(0,t.attr)("boolean"),k=(0,t.attr)("string",{label:"Duo secret key",sensitive:!0}),x=(0,t.attr)("string",{label:"Duo integration key",sensitive:!0}),_=(0,t.attr)("string",{label:"Duo API hostname"}),P=(0,t.attr)("string",{label:"Duo push information",subText:"Additional information displayed to the user when the push is presented to them."}),T=(0,t.attr)("boolean",{label:"Passcode reminder",subText:"If this is turned on, the user is reminded to use the passcode upon MFA validation."}),O=(0,t.attr)("string",{label:"Issuer",subText:"The human-readable name of the keys issuing organization."}),j=(0,t.attr)({label:"Period",editType:"ttl",helperTextEnabled:"How long each generated TOTP is valid.",hideToggle:!0,defaultValue:30}),M=(0,t.attr)("number",{label:"Key size",subText:"The size in bytes of the Vault generated key."}),z=(0,t.attr)("number",{label:"QR size",subText:"The pixel size of the generated square QR code."}),S=(0,t.attr)("string",{label:"Algorithm",editType:"radio",possibleValues:["SHA1","SHA256","SHA512"],subText:"The hashing algorithm used to generate the TOTP code."}),C=(0,t.attr)("number",{label:"Digits",editType:"radio",possibleValues:[6,8],subText:"The number digits in the generated TOTP code."}),A=(0,t.attr)("number",{label:"Skew",editType:"radio",possibleValues:[0,1],subText:"The number of delay periods allowed when validating a TOTP token."}),R=(0,t.attr)("number"),r((E=class extends t.default{constructor(){super(...arguments),ue(this,"type",N,this),ue(this,"username_format",F,this),ue(this,"namespace_id",I,this),ue(this,"mount_accessor",L,this),ue(this,"settings_file_base64",V,this),ue(this,"use_signature",U,this),ue(this,"idp_url",$,this),ue(this,"admin_url",q,this),ue(this,"authenticator_url",K,this),ue(this,"org_alias",B,this),ue(this,"org_name",G,this),ue(this,"api_token",W,this),ue(this,"base_url",H,this),ue(this,"primary_email",Y,this),ue(this,"secret_key",Q,this),ue(this,"integration_key",J,this),ue(this,"api_hostname",Z,this),ue(this,"push_info",X,this),ue(this,"use_passcode",ee,this),ue(this,"issuer",te,this),ue(this,"period",ne,this),ue(this,"key_size",le,this),ue(this,"qr_size",ae,this),ue(this,"algorithm",ie,this),ue(this,"digits",re,this),ue(this,"skew",oe,this),ue(this,"max_validation_attempts",se,this)}get name(){return"totp"===this.type?this.type.toUpperCase():(0,n.capitalize)(this.type)}get formFields(){return[...ce.common,...ce[this.type]]}get attrs(){return(0,l.expandAttributeMeta)(this,this.formFields)}},N=de(E.prototype,"type",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),F=de(E.prototype,"username_format",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),I=de(E.prototype,"namespace_id",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),L=de(E.prototype,"mount_accessor",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),V=de(E.prototype,"settings_file_base64",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),U=de(E.prototype,"use_signature",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),$=de(E.prototype,"idp_url",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),q=de(E.prototype,"admin_url",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),K=de(E.prototype,"authenticator_url",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),B=de(E.prototype,"org_alias",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),G=de(E.prototype,"org_name",[y],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),W=de(E.prototype,"api_token",[v],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),H=de(E.prototype,"base_url",[g],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Y=de(E.prototype,"primary_email",[w],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Q=de(E.prototype,"secret_key",[k],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),J=de(E.prototype,"integration_key",[x],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Z=de(E.prototype,"api_hostname",[_],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),X=de(E.prototype,"push_info",[P],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ee=de(E.prototype,"use_passcode",[T],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),te=de(E.prototype,"issuer",[O],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ne=de(E.prototype,"period",[j],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),le=de(E.prototype,"key_size",[M],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ae=de(E.prototype,"qr_size",[z],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ie=de(E.prototype,"algorithm",[S],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),re=de(E.prototype,"digits",[C],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),oe=de(E.prototype,"skew",[A],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),se=de(E.prototype,"max_validation_attempts",[R],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),D=E))||D)
e.default=fe})),define("vault/models/mount-config",["exports","@ember-data/model"],(function(e,t){var n,l,a,i,r,o,s,u,d,c,p,m,f,h,b,y,v,g,w
function k(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function x(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let _=(n=(0,t.attr)({label:"Default Lease TTL",editType:"ttl"}),l=(0,t.attr)({label:"Max Lease TTL",editType:"ttl"}),a=(0,t.attr)({label:"Request keys excluded from HMACing in audit",editType:"stringArray",helpText:"Keys that will not be HMAC'd by audit devices in the request data object."}),i=(0,t.attr)({label:"Response keys excluded from HMACing in audit",editType:"stringArray",helpText:"Keys that will not be HMAC'd by audit devices in the response data object."}),r=(0,t.attr)("mountVisibility",{editType:"boolean",label:"List method when unauthenticated",defaultValue:!1}),o=(0,t.attr)({label:"Allowed passthrough request headers",helpText:"Headers to allow and pass from the request to the backend",editType:"stringArray"}),s=(0,t.attr)({label:"Allowed response headers",helpText:"Headers to allow, allowing a plugin to include them in the response.",editType:"stringArray"}),u=(0,t.attr)("string",{label:"Token Type",helpText:"The type of token that should be generated via this role. For `default-service` and `default-batch` service and batch tokens will be issued respectively, unless the auth method explicitly requests a different type.",possibleValues:["default-service","default-batch","batch","service"],noDefault:!0}),d=(0,t.attr)({editType:"stringArray"}),c=class extends t.default{constructor(){super(...arguments),k(this,"defaultLeaseTtl",p,this),k(this,"maxLeaseTtl",m,this),k(this,"auditNonHmacRequestKeys",f,this),k(this,"auditNonHmacResponseKeys",h,this),k(this,"listingVisibility",b,this),k(this,"passthroughRequestHeaders",y,this),k(this,"allowedResponseHeaders",v,this),k(this,"tokenType",g,this),k(this,"allowedManagedKeys",w,this)}},p=x(c.prototype,"defaultLeaseTtl",[n],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=x(c.prototype,"maxLeaseTtl",[l],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=x(c.prototype,"auditNonHmacRequestKeys",[a],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=x(c.prototype,"auditNonHmacResponseKeys",[i],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=x(c.prototype,"listingVisibility",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=x(c.prototype,"passthroughRequestHeaders",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),v=x(c.prototype,"allowedResponseHeaders",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g=x(c.prototype,"tokenType",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=x(c.prototype,"allowedManagedKeys",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c)
e.default=_})),define("vault/models/namespace",["exports","@ember-data/model","vault/decorators/model-expanded-attributes","vault/decorators/model-validations"],(function(e,t,n,l){var a,i,r,o,s,u
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let d=(a=(0,n.withExpandedAttributes)(),i=(0,l.withModelValidations)({path:[{type:"presence",message:"Path can't be blank."},{type:"endsInSlash",message:"Path can't end in forward slash '/'."},{type:"containsWhiteSpace",message:"Path can't contain whitespace."}]}),r=(0,t.attr)("string"),a(o=i((s=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="path",l=this,(n=u)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}get fields(){return["path"].map((e=>this.allByKey[e]))}},c=s.prototype,p="path",m=[r],f={configurable:!0,enumerable:!0,writable:!0,initializer:null},b={},Object.keys(f).forEach((function(e){b[e]=f[e]})),b.enumerable=!!b.enumerable,b.configurable=!!b.configurable,("value"in b||b.initializer)&&(b.writable=!0),b=m.slice().reverse().reduce((function(e,t){return t(c,p,e)||e}),b),h&&void 0!==b.initializer&&(b.value=b.initializer?b.initializer.call(h):void 0,b.initializer=void 0),void 0===b.initializer&&(Object.defineProperty(c,p,b),b=null),u=b,o=s))||o)||o)
var c,p,m,f,h,b
e.default=d}))
define("vault/models/node",["exports","@ember-data/model","@ember/object/computed"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend({name:(0,t.attr)("string"),standby:(0,t.attr)("boolean"),isActive:(0,n.equal)("standby",!1),clusterId:(0,t.attr)("string"),isLeader:(0,n.and)("initialized","isActive"),initialized:(0,t.attr)("boolean"),sealed:(0,t.attr)("boolean"),isSealed:(0,n.alias)("sealed"),t:(0,t.attr)("number"),n:(0,t.attr)("number"),progress:(0,t.attr)("number"),sealThreshold:(0,n.alias)("t"),sealNumShares:(0,n.alias)("n"),version:(0,t.attr)("string"),type:(0,t.attr)("string"),storageType:(0,t.attr)("string"),hcpLinkStatus:(0,t.attr)("string"),haEnabled:(0,t.attr)("boolean"),isSelf:(0,t.attr)("boolean"),leaderAddress:(0,t.attr)("string")})
e.default=l})),define("vault/models/oidc/assignment",["exports","@ember-data/model","vault/macros/lazy-capabilities","vault/decorators/model-validations","@ember/utils"],(function(e,t,n,l,a){var i,r,o,s,u,d,c,p,m,f,h
function b(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function y(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const v={name:[{type:"presence",message:"Name is required."},{type:"containsWhiteSpace",message:"Name cannot contain whitespace."}],targets:[{validator:e=>(0,a.isPresent)(e.entityIds)||(0,a.isPresent)(e.groupIds),message:"At least one entity or group is required."}]}
let g=(i=(0,l.withModelValidations)(v),r=(0,t.attr)("string"),o=(0,t.attr)("array"),s=(0,t.attr)("array"),u=(0,n.default)(n.apiPath`identity/oidc/assignment/${"name"}`,"name"),i((c=class extends t.default{constructor(){super(...arguments),b(this,"name",p,this),b(this,"entityIds",m,this),b(this,"groupIds",f,this),b(this,"assignmentPath",h,this)}get canRead(){return this.assignmentPath.get("canRead")}get canEdit(){return this.assignmentPath.get("canUpdate")}get canDelete(){return this.assignmentPath.get("canDelete")}},p=y(c.prototype,"name",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=y(c.prototype,"entityIds",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=y(c.prototype,"groupIds",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=y(c.prototype,"assignmentPath",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=c))||d)
e.default=g})),define("vault/models/oidc/client",["exports","@ember-data/model","vault/macros/lazy-capabilities","vault/utils/field-to-attrs","vault/decorators/model-validations"],(function(e,t,n,l,a){var i,r,o,s,u,d,c,p,m,f,h,b,y,v,g,w,k,x,_,P,T,O,j
function M(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function z(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function S(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let C=(i=(0,a.withModelValidations)({name:[{type:"presence",message:"Name is required."},{type:"containsWhiteSpace",message:"Name cannot contain whitespace."}],key:[{type:"presence",message:"Key is required."}]}),r=(0,t.attr)("string",{label:"Application name",editDisabled:!0}),o=(0,t.attr)("string",{label:"Type",subText:"Specify whether the application type is confidential or public. The public type must use PKCE. This cannot be edited later.",editType:"radio",editDisabled:!0,defaultValue:"confidential",possibleValues:["confidential","public"]}),s=(0,t.attr)("array",{label:"Redirect URIs",subText:"One of these values must exactly match the redirect_uri parameter value used in each authentication request.",editType:"stringArray"}),u=(0,t.attr)("string",{label:"Signing key",subText:"Add a key to sign and verify the JSON web tokens (JWT). This cannot be edited later.",editType:"searchSelect",editDisabled:!0,onlyAllowExisting:!0,defaultValue:()=>["default"],fallbackComponent:"input-search",selectLimit:1,models:["oidc/key"]}),d=(0,t.attr)({label:"Access Token TTL",editType:"ttl",defaultValue:"24h"}),c=(0,t.attr)({label:"ID Token TTL",editType:"ttl",defaultValue:"24h"}),p=(0,t.attr)("array",{label:"Assign access"}),m=(0,t.attr)("string",{label:"Client ID"}),f=(0,t.attr)("string"),h=(0,n.default)(n.apiPath`identity/oidc/client/${"name"}`,"name"),i((y=class extends t.default{constructor(){super(...arguments),M(this,"name",v,this),M(this,"clientType",g,this),M(this,"redirectUris",w,this),M(this,"key",k,this),M(this,"accessTokenTtl",x,this),M(this,"idTokenTtl",_,this),M(this,"assignments",P,this),M(this,"clientId",T,this),M(this,"clientSecret",O,this),z(this,"_attributeMeta",null),z(this,"_fieldToAttrsGroups",null),M(this,"clientPath",j,this)}get formFields(){return this._attributeMeta||(this._attributeMeta=(0,l.expandAttributeMeta)(this,["name","clientType","redirectUris"])),this._attributeMeta}get fieldGroups(){return this._fieldToAttrsGroups||(this._fieldToAttrsGroups=(0,l.default)(this,[{"More options":["key","idTokenTtl","accessTokenTtl"]}])),this._fieldToAttrsGroups}get canRead(){return this.clientPath.get("canRead")}get canEdit(){return this.clientPath.get("canUpdate")}get canDelete(){return this.clientPath.get("canDelete")}},v=S(y.prototype,"name",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g=S(y.prototype,"clientType",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=S(y.prototype,"redirectUris",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=S(y.prototype,"key",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=S(y.prototype,"accessTokenTtl",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_=S(y.prototype,"idTokenTtl",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P=S(y.prototype,"assignments",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=S(y.prototype,"clientId",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=S(y.prototype,"clientSecret",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=S(y.prototype,"clientPath",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=y))||b)
e.default=C})),define("vault/models/oidc/key",["exports","@ember-data/model","vault/macros/lazy-capabilities","vault/utils/field-to-attrs","vault/decorators/model-validations"],(function(e,t,n,l,a){var i,r,o,s,u,d,c,p,m,f,h,b,y,v,g,w,k
function x(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function _(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let P=(i=(0,a.withModelValidations)({name:[{type:"presence",message:"Name is required."},{type:"containsWhiteSpace",message:"Name cannot contain whitespace."}]}),r=(0,t.attr)("string",{editDisabled:!0}),o=(0,t.attr)("string",{defaultValue:"RS256",possibleValues:["RS256","RS384","RS512","ES256","ES384","ES512","EdDSA"]}),s=(0,t.attr)({editType:"ttl",defaultValue:"24h"}),u=(0,t.attr)({label:"Verification TTL",editType:"ttl",defaultValue:"24h"}),d=(0,t.attr)("array",{label:"Allowed applications"}),c=(0,n.default)(n.apiPath`identity/oidc/key/${"name"}`,"name"),p=(0,n.default)(n.apiPath`identity/oidc/key/${"name"}/rotate`,"name"),i((f=class extends t.default{constructor(){var e,t,n
super(...arguments),x(this,"name",h,this),x(this,"algorithm",b,this),x(this,"rotationPeriod",y,this),x(this,"verificationTtl",v,this),x(this,"allowedClientIds",g,this),n=null,(t="_attributeMeta")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,x(this,"keyPath",w,this),x(this,"rotatePath",k,this)}get formFields(){return this._attributeMeta||(this._attributeMeta=(0,l.expandAttributeMeta)(this,["name","algorithm","rotationPeriod","verificationTtl"])),this._attributeMeta}get canRead(){return this.keyPath.get("canRead")}get canEdit(){return this.keyPath.get("canUpdate")}get canRotate(){return this.rotatePath.get("canUpdate")}get canDelete(){return this.keyPath.get("canDelete")}},h=_(f.prototype,"name",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=_(f.prototype,"algorithm",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=_(f.prototype,"rotationPeriod",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),v=_(f.prototype,"verificationTtl",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g=_(f.prototype,"allowedClientIds",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=_(f.prototype,"keyPath",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=_(f.prototype,"rotatePath",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=f))||m)
e.default=P})),define("vault/models/oidc/provider",["exports","@ember-data/model","vault/macros/lazy-capabilities","vault/utils/field-to-attrs","vault/decorators/model-validations"],(function(e,t,n,l,a){var i,r,o,s,u,d,c,p,m,f,h,b,y
function v(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function g(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let w=(i=(0,a.withModelValidations)({name:[{type:"presence",message:"Name is required."},{type:"containsWhiteSpace",message:"Name cannot contain whitespace."}]}),r=(0,t.attr)("string",{editDisabled:!0}),o=(0,t.attr)("string",{subText:"The scheme, host, and optional port for your issuer. This will be used to build the URL that validates ID tokens.",placeholderText:"e.g. https://example.com:8200",docLink:"/vault/api-docs/secret/identity/oidc-provider#create-or-update-a-provider",helpText:"Optional. This defaults to a URL with Vault's api_addr"}),s=(0,t.attr)("array",{label:"Supported scopes",subText:"Scopes define information about a user and the OIDC service. Optional.",editType:"searchSelect",models:["oidc/scope"],fallbackComponent:"string-list",onlyAllowExisting:!0}),u=(0,t.attr)("array",{label:"Allowed applications"}),d=(0,n.default)(n.apiPath`identity/oidc/provider/${"name"}`,"name"),i((p=class extends t.default{constructor(){var e,t,n
super(...arguments),v(this,"name",m,this),v(this,"issuer",f,this),v(this,"scopesSupported",h,this),v(this,"allowedClientIds",b,this),n=null,(t="_attributeMeta")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,v(this,"providerPath",y,this)}get formFields(){return this._attributeMeta||(this._attributeMeta=(0,l.expandAttributeMeta)(this,["name","issuer","scopesSupported"])),this._attributeMeta}get canRead(){return this.providerPath.get("canRead")}get canEdit(){return this.providerPath.get("canUpdate")}get canDelete(){return this.providerPath.get("canDelete")}},m=g(p.prototype,"name",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=g(p.prototype,"issuer",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=g(p.prototype,"scopesSupported",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=g(p.prototype,"allowedClientIds",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=g(p.prototype,"providerPath",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=p))||c)
e.default=w})),define("vault/models/oidc/scope",["exports","@ember-data/model","vault/macros/lazy-capabilities","vault/utils/field-to-attrs","vault/decorators/model-validations"],(function(e,t,n,l,a){var i,r,o,s,u,d,c,p,m,f,h
function b(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function y(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let v=(i=(0,a.withModelValidations)({name:[{type:"presence",message:"Name is required."}]}),r=(0,t.attr)("string",{editDisabled:!0}),o=(0,t.attr)("string",{editType:"textarea"}),s=(0,t.attr)("string",{label:"JSON Template",editType:"json",mode:"ruby"}),u=(0,n.default)(n.apiPath`identity/oidc/scope/${"name"}`,"name"),i((c=class extends t.default{constructor(){var e,t,n
super(...arguments),b(this,"name",p,this),b(this,"description",m,this),b(this,"template",f,this),n=null,(t="_attributeMeta")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,b(this,"scopePath",h,this)}get formFields(){return this._attributeMeta||(this._attributeMeta=(0,l.expandAttributeMeta)(this,["name","description","template"])),this._attributeMeta}get canRead(){return this.scopePath.get("canRead")}get canEdit(){return this.scopePath.get("canUpdate")}get canDelete(){return this.scopePath.get("canDelete")}},p=y(c.prototype,"name",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=y(c.prototype,"description",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=y(c.prototype,"template",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=y(c.prototype,"scopePath",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=c))||d)
e.default=v})),define("vault/models/path-filter-config",["exports","@ember-data/model"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({mode:(0,t.attr)("string"),paths:(0,t.attr)("array",{defaultValue:function(){return[]}})})
e.default=n})),define("vault/models/pki/action",["exports","@ember-data/model","@ember/service","@glimmer/tracking","vault/macros/lazy-capabilities","vault/decorators/model-form-fields","vault/decorators/model-validations"],(function(e,t,n,l,a,i,r){var o,s,u,d,c,p,m,f,h,b,y,v,g,w,k,x,_,P,T,O,j,M,z,S,C,A,R,D,E,N,F,I,L,V,U,$,q,K,B,G,W,H,Y,Q,J,Z,X,ee,te,ne,le,ae,ie,re,oe,se,ue,de,ce,pe,me,fe,he,be,ye,ve,ge,we,ke,xe,_e,Pe,Te,Oe,je,Me,ze,Se,Ce,Ae,Re,De,Ee,Ne,Fe,Ie,Le,Ve,Ue,$e,qe,Ke,Be,Ge,We,He,Ye,Qe
function Je(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function Ze(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const Xe={type:[{type:"presence",message:"Type is required."}],commonName:[{type:"presence",message:"Common name is required."}],issuerName:[{validator:e=>"generate-root"!==e.actionType&&"rotate-root"!==e.actionType||"default"!==e.issuerName,message:"Issuer name must be unique across all issuers and not be the reserved value 'default'."}],keyName:[{validator:e=>"default"!==e.keyName,message:"Key name cannot be the reserved value 'default'"}]}
let et=(o=(0,r.withModelValidations)(Xe),s=(0,i.withFormFields)(),u=(0,t.attr)("string"),d=(0,t.attr)("string",{readOnly:!0,isCertificate:!0}),c=(0,t.attr)("string",{label:"Issuing CA",readOnly:!0,isCertificate:!0}),p=(0,t.attr)("string",{possibleValues:["exported","internal","existing","kms"],noDefault:!0}),m=(0,t.attr)("string"),f=(0,t.attr)("string"),h=(0,t.attr)("string",{defaultValue:"default",label:"Key reference"}),b=(0,t.attr)("string"),y=(0,t.attr)("string",{label:"Subject Alternative Names (SANs)",editType:"stringArray"}),v=(0,t.attr)("string",{label:"IP Subject Alternative Names (IP SANs)",editType:"stringArray"}),g=(0,t.attr)("string",{label:"URI Subject Alternative Names (URI SANs)",editType:"stringArray"}),w=(0,t.attr)("string",{label:"Other SANs",editType:"stringArray"}),k=(0,t.attr)("string",{defaultValue:"pem",possibleValues:["pem","der","pem_bundle"]}),x=(0,t.attr)("string",{defaultValue:"der",possibleValues:["der","pkcs8"]}),_=(0,t.attr)("string",{defaultValue:"rsa",possibleValues:["rsa","ed25519","ec"]}),P=(0,t.attr)("string",{defaultValue:"0"}),T=(0,t.attr)("number",{defaultValue:-1}),O=(0,t.attr)("boolean",{label:"Exclude common name from SANs",subText:"If checked, the common name will not be included in DNS or Email Subject Alternate Names. This is useful if the CN is a human-readable identifier, not a hostname or email address.",defaultValue:!1}),j=(0,t.attr)("string",{label:"Permitted DNS domains"}),M=(0,t.attr)("string",{label:"Organizational Units (OU)",subText:"A list of allowed serial numbers to be requested during certificate issuance. Shell-style globbing is supported. If empty, custom-specified serial numbers will be forbidden.",editType:"stringArray"}),z=(0,t.attr)({editType:"stringArray"}),S=(0,t.attr)({editType:"stringArray"}),C=(0,t.attr)({editType:"stringArray"}),A=(0,t.attr)({editType:"stringArray"}),R=(0,t.attr)({editType:"stringArray"}),D=(0,t.attr)({editType:"stringArray"}),E=(0,t.attr)("string",{subText:"Specifies the requested Subject's named Serial Number value. This has no impact on the Certificate's serial number randomly generated by Vault."}),N=(0,t.attr)("boolean",{subText:"Whether to add a Basic Constraints extension with CA: true."}),F=(0,t.attr)({label:"Backdate validity",detailsLabel:"Issued certificate backdating",helperTextDisabled:"Vault will use the default value, 30s",helperTextEnabled:"Also called the not_before_duration property. Allows certificates to be valid for a certain time period before now. This is useful to correct clock misalignment on various systems when setting up your CA.",editType:"ttl",defaultValue:"30s"}),I=(0,t.attr)("string"),L=(0,t.attr)("string",{label:"Managed key UUID"}),V=(0,t.attr)({label:"Not valid after",detailsLabel:"Issued certificates expire after",subText:"The time after which this certificate will no longer be valid. This can be a TTL (a range of time from now) or a specific date.",editType:"yield"}),U=(0,t.attr)("string"),$=(0,t.attr)("date"),q=(0,t.attr)("string",{label:"Issuer ID",readOnly:!0,detailLinkTo:"issuers.issuer.details"}),K=(0,t.attr)("string",{label:"CSR",isCertificate:!0}),B=(0,t.attr)("string",{label:"Key ID",detailLinkTo:"keys.key.details"}),G=(0,t.attr)("string",{isCertificate:!0}),W=(0,t.attr)("string"),H=(0,a.default)(a.apiPath`${"backend"}/issuers/import/bundle`,"backend"),Y=(0,a.default)(a.apiPath`${"backend"}/issuers/generate/root/${"type"}`,"backend","type"),Q=(0,a.default)(a.apiPath`${"backend"}/issuers/generate/intermediate/${"type"}`,"backend","type"),J=(0,a.default)(a.apiPath`${"backend"}/issuers/cross-sign`,"backend"),o(Z=s((X=class extends t.default{constructor(){super(...arguments),Je(this,"secretMountPath",ee,this),Je(this,"actionType",te,this),Je(this,"pemBundle",ne,this),Je(this,"parsedCertificate",le,this),Je(this,"importedIssuers",ae,this),Je(this,"importedKeys",ie,this),Je(this,"mapping",re,this),Je(this,"certificate",oe,this),Je(this,"serialNumber",se,this),Je(this,"issuingCa",ue,this),Je(this,"type",de,this),Je(this,"issuerName",ce,this),Je(this,"keyName",pe,this),Je(this,"keyRef",me,this),Je(this,"commonName",fe,this),Je(this,"altNames",he,this),Je(this,"ipSans",be,this),Je(this,"uriSans",ye,this),Je(this,"otherSans",ve,this),Je(this,"format",ge,this),Je(this,"privateKeyFormat",we,this),Je(this,"keyType",ke,this),Je(this,"keyBits",xe,this),Je(this,"maxPathLength",_e,this),Je(this,"excludeCnFromSans",Pe,this),Je(this,"permittedDnsDomains",Te,this),Je(this,"ou",Oe,this),Je(this,"organization",je,this),Je(this,"country",Me,this)
Je(this,"locality",ze,this),Je(this,"province",Se,this),Je(this,"streetAddress",Ce,this),Je(this,"postalCode",Ae,this),Je(this,"subjectSerialNumber",Re,this),Je(this,"addBasicConstraints",De,this),Je(this,"notBeforeDuration",Ee,this),Je(this,"managedKeyName",Ne,this),Je(this,"managedKeyId",Fe,this),Je(this,"customTtl",Ie,this),Je(this,"ttl",Le,this),Je(this,"notAfter",Ve,this),Je(this,"issuerId",Ue,this),Je(this,"csr",$e,this),Je(this,"caChain",qe,this),Je(this,"keyId",Ke,this),Je(this,"privateKey",Be,this),Je(this,"privateKeyType",Ge,this),Je(this,"importBundlePath",We,this),Je(this,"generateIssuerRootPath",He,this),Je(this,"generateIssuerCsrPath",Ye,this),Je(this,"crossSignPath",Qe,this)}get backend(){return this.secretMountPath.currentPath}get canImportBundle(){return!0===this.importBundlePath.get("canCreate")}get canGenerateIssuerRoot(){return!0===this.generateIssuerRootPath.get("canCreate")}get canGenerateIssuerIntermediate(){return!0===this.generateIssuerCsrPath.get("canCreate")}get canCrossSign(){return!0===this.crossSignPath.get("canCreate")}},ee=Ze(X.prototype,"secretMountPath",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),te=Ze(X.prototype,"actionType",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ne=Ze(X.prototype,"pemBundle",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),le=Ze(X.prototype,"parsedCertificate",[t.attr],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ae=Ze(X.prototype,"importedIssuers",[t.attr],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ie=Ze(X.prototype,"importedKeys",[t.attr],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),re=Ze(X.prototype,"mapping",[t.attr],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),oe=Ze(X.prototype,"certificate",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),se=Ze(X.prototype,"serialNumber",[t.attr],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ue=Ze(X.prototype,"issuingCa",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),de=Ze(X.prototype,"type",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ce=Ze(X.prototype,"issuerName",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),pe=Ze(X.prototype,"keyName",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),me=Ze(X.prototype,"keyRef",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),fe=Ze(X.prototype,"commonName",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),he=Ze(X.prototype,"altNames",[y],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),be=Ze(X.prototype,"ipSans",[v],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ye=Ze(X.prototype,"uriSans",[g],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ve=Ze(X.prototype,"otherSans",[w],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ge=Ze(X.prototype,"format",[k],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),we=Ze(X.prototype,"privateKeyFormat",[x],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ke=Ze(X.prototype,"keyType",[_],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),xe=Ze(X.prototype,"keyBits",[P],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_e=Ze(X.prototype,"maxPathLength",[T],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Pe=Ze(X.prototype,"excludeCnFromSans",[O],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Te=Ze(X.prototype,"permittedDnsDomains",[j],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Oe=Ze(X.prototype,"ou",[M],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),je=Ze(X.prototype,"organization",[z],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Me=Ze(X.prototype,"country",[S],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ze=Ze(X.prototype,"locality",[C],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Se=Ze(X.prototype,"province",[A],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Ce=Ze(X.prototype,"streetAddress",[R],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Ae=Ze(X.prototype,"postalCode",[D],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Re=Ze(X.prototype,"subjectSerialNumber",[E],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),De=Ze(X.prototype,"addBasicConstraints",[N],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Ee=Ze(X.prototype,"notBeforeDuration",[F],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Ne=Ze(X.prototype,"managedKeyName",[I],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Fe=Ze(X.prototype,"managedKeyId",[L],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Ie=Ze(X.prototype,"customTtl",[V],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Le=Ze(X.prototype,"ttl",[U],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Ve=Ze(X.prototype,"notAfter",[$],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Ue=Ze(X.prototype,"issuerId",[q],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),$e=Ze(X.prototype,"csr",[K],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),qe=Ze(X.prototype,"caChain",[t.attr],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Ke=Ze(X.prototype,"keyId",[B],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Be=Ze(X.prototype,"privateKey",[G],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Ge=Ze(X.prototype,"privateKeyType",[W],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),We=Ze(X.prototype,"importBundlePath",[H],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),He=Ze(X.prototype,"generateIssuerRootPath",[Y],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Ye=Ze(X.prototype,"generateIssuerCsrPath",[Q],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Qe=Ze(X.prototype,"crossSignPath",[J],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Z=X))||Z)||Z)
e.default=et})),define("vault/models/pki/certificate/base",["exports","@ember-data/model","@ember/debug","@ember/service","vault/decorators/model-form-fields","vault/macros/lazy-capabilities"],(function(e,t,n,l,a,i){var r,o,s,u,d,c,p,m,f,h,b,y,v,g,w,k,x,_,P,T,O,j,M,z,S,C,A,R,D,E,N,F,I,L,V,U,$
function q(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function K(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let B=(r=(0,a.withFormFields)(["certificate","commonName","revocationTime","serialNumber"]),o=(0,t.attr)("string"),s=(0,t.attr)({label:"Not valid after",detailsLabel:"Issued certificates expire after",subText:"The time after which this certificate will no longer be valid. This can be a TTL (a range of time from now) or a specific date.",editType:"yield"}),u=(0,t.attr)("boolean",{label:"Exclude common name from SANs",subText:"If checked, the common name will not be included in DNS or Email Subject Alternate Names. This is useful if the CN is a human-readable identifier, not a hostname or email address.",defaultValue:!1}),d=(0,t.attr)("string",{label:"Subject Alternative Names (SANs)",subText:"The requested Subject Alternative Names; if email protection is enabled for the role, this may contain email addresses.",editType:"stringArray"}),c=(0,t.attr)("string",{label:"IP Subject Alternative Names (IP SANs)",subText:"Only valid if the role allows IP SANs (which is the default)."}),p=(0,t.attr)("string",{label:"URI Subject Alternative Names (URI SANs)",subText:"If any requested URIs do not match role policy, the entire request will be denied."}),m=(0,t.attr)("string",{subText:"Requested other SANs with the format <oid>;UTF8:<utf8 string value> for each entry."}),f=(0,t.attr)({label:"CA Chain",isCertificate:!0}),h=(0,t.attr)("string",{isCertificate:!0}),b=(0,t.attr)("number"),y=(0,t.attr)("string",{label:"Issuing CA",isCertificate:!0}),v=(0,t.attr)("string",{isCertificate:!0}),g=(0,t.attr)("string"),w=(0,t.attr)("number",{formatDate:!0}),k=(0,t.attr)("string"),x=(0,i.default)(i.apiPath`${"backend"}/revoke`,"backend"),r((P=class extends t.default{constructor(){super(...arguments),q(this,"secretMountPath",T,this),q(this,"parsedCertificate",O,this),q(this,"commonName",j,this),q(this,"customTtl",M,this),q(this,"excludeCnFromSans",z,this),q(this,"altNames",S,this),q(this,"ipSans",C,this),q(this,"uriSans",A,this),q(this,"otherSans",R,this),q(this,"caChain",D,this),q(this,"certificate",E,this),q(this,"expiration",N,this),q(this,"issuingCa",F,this),q(this,"privateKey",I,this),q(this,"privateKeyType",L,this),q(this,"revocationTime",V,this),q(this,"serialNumber",U,this),q(this,"revokePath",$,this)}get useOpenAPI(){return!0}get backend(){return this.secretMountPath.currentPath}getHelpUrl(){}get canRevoke(){return this.revokePath.get("isLoading")||!1!==this.revokePath.get("canCreate")}},T=K(P.prototype,"secretMountPath",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=K(P.prototype,"parsedCertificate",[t.attr],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=K(P.prototype,"commonName",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),M=K(P.prototype,"customTtl",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),z=K(P.prototype,"excludeCnFromSans",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),S=K(P.prototype,"altNames",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),C=K(P.prototype,"ipSans",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),A=K(P.prototype,"uriSans",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),R=K(P.prototype,"otherSans",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),D=K(P.prototype,"caChain",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),E=K(P.prototype,"certificate",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),N=K(P.prototype,"expiration",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),F=K(P.prototype,"issuingCa",[y],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),I=K(P.prototype,"privateKey",[v],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),L=K(P.prototype,"privateKeyType",[g],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),V=K(P.prototype,"revocationTime",[w],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),U=K(P.prototype,"serialNumber",[k],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),$=K(P.prototype,"revokePath",[x],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_=P))||_)
e.default=B})),define("vault/models/pki/certificate/generate",["exports","@ember-data/model","vault/decorators/model-form-fields","vault/models/pki/certificate/base"],(function(e,t,n,l){var a,i,r,o,s
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let u=(a=(0,n.withFormFields)(["certificate","commonName","revocationTime","serialNumber","caChain","issuingCa","privateKey","privateKeyType"],[{default:["commonName","userIds","customTtl","format","privateKeyFormat"]},{"Subject Alternative Name (SAN) Options":["excludeCnFromSans","altNames","ipSans","uriSans","otherSans"]}]),i=(0,t.attr)("string"),a((o=class extends l.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="role",l=this,(n=s)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}getHelpUrl(e){return`/v1/${e}/issue/example?help=1`}},d=o.prototype,c="role",p=[i],m={configurable:!0,enumerable:!0,writable:!0,initializer:null},h={},Object.keys(m).forEach((function(e){h[e]=m[e]})),h.enumerable=!!h.enumerable,h.configurable=!!h.configurable,("value"in h||h.initializer)&&(h.writable=!0),h=p.slice().reverse().reduce((function(e,t){return t(d,c,e)||e}),h),f&&void 0!==h.initializer&&(h.value=h.initializer?h.initializer.call(f):void 0,h.initializer=void 0),void 0===h.initializer&&(Object.defineProperty(d,c,h),h=null),s=h,r=o))||r)
var d,c,p,m,f,h
e.default=u})),define("vault/models/pki/certificate/sign",["exports","@ember-data/model","vault/decorators/model-form-fields","vault/models/pki/certificate/base"],(function(e,t,n,l){var a,i,r,o,s,u,d,c,p
function m(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function f(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let h=(a=(0,n.withFormFields)(null,[{default:["csr","commonName","customTtl","format","removeRootsFromChain"]},{"Subject Alternative Name (SAN) Options":["excludeCnFromSans","altNames","ipSans","uriSans","otherSans"]}]),i=(0,t.attr)("string"),r=(0,t.attr)("string",{label:"CSR",editType:"textarea"}),o=(0,t.attr)("boolean",{subText:"When checked, the CA chain will not include self-signed CA certificates."}),a((u=class extends l.default{constructor(){super(...arguments),m(this,"role",d,this),m(this,"csr",c,this),m(this,"removeRootsFromChain",p,this)}getHelpUrl(e){return`/v1/${e}/sign/example?help=1`}},d=f(u.prototype,"role",[i],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=f(u.prototype,"csr",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=f(u.prototype,"removeRootsFromChain",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=u))||s)
e.default=h})),define("vault/models/pki/config/acme",["exports","@ember-data/model","vault/decorators/model-form-fields","vault/macros/lazy-capabilities"],(function(e,t,n,l){var a,i,r,o,s,u,d,c,p,m,f,h,b,y,v,g,w,k,x
function _(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function P(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let T=(a=(0,n.withFormFields)(),i=(0,t.attr)("boolean",{label:"ACME enabled",subText:"When ACME is disabled, all requests to ACME directory URLs will return 404."}),r=(0,t.attr)("string",{subText:"Specifies the behavior of the default ACME directory. Can be 'forbid', 'sign-verbatim' or a role given by 'role:<role_name>'. If a role is used, it must be present in 'allowed_roles'."}),o=(0,t.attr)("array",{editType:"stringArray",subText:"The default value '*' allows every role within the mount to be used. If the default_directory_policy specifies a role, it must be allowed under this configuration."}),s=(0,t.attr)("boolean",{label:"Allow role ExtKeyUsage",subText:"When enabled, respect the role's ExtKeyUsage flags. Otherwise, ACME certificates are forced to ServerAuth."}),u=(0,t.attr)("array",{editType:"stringArray",subText:"Specifies a list of issuers allowed to issue certificates via explicit ACME paths. If an allowed role specifies an issuer outside this list, it will be allowed. The default value '*' allows every issuer within the mount."}),d=(0,t.attr)("string",{label:"EAB policy",possibleValues:["not-required","new-account-required","always-required"]}),c=(0,t.attr)("string",{label:"DNS resolver",subText:"An optional overriding DNS resolver to use for challenge verification lookups. When not specified, the default system resolver will be used. This allows domains on peered networks with an accessible DNS resolver to be validated."}),p=(0,l.default)(l.apiPath`${"id"}/config/acme`,"id"),a((f=class extends t.default{constructor(){super(...arguments),_(this,"enabled",h,this),_(this,"defaultDirectoryPolicy",b,this),_(this,"allowedRoles",y,this),_(this,"allowRoleExtKeyUsage",v,this),_(this,"allowedIssuers",g,this),_(this,"eabPolicy",w,this),_(this,"dnsResolver",k,this),_(this,"acmePath",x,this)}get useOpenAPI(){return!0}getHelpUrl(e){return`/v1/${e}/config/acme?help=1`}get canSet(){return!1!==this.acmePath.get("canUpdate")}},h=P(f.prototype,"enabled",[i],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=P(f.prototype,"defaultDirectoryPolicy",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=P(f.prototype,"allowedRoles",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),v=P(f.prototype,"allowRoleExtKeyUsage",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g=P(f.prototype,"allowedIssuers",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=P(f.prototype,"eabPolicy",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=P(f.prototype,"dnsResolver",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=P(f.prototype,"acmePath",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=f))||m)
e.default=T})),define("vault/models/pki/config/cluster",["exports","@ember-data/model","vault/decorators/model-form-fields","vault/macros/lazy-capabilities"],(function(e,t,n,l){var a,i,r,o,s,u,d,c,p
function m(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function f(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let h=(a=(0,n.withFormFields)(),i=(0,t.attr)("string",{label:"Mount's API path",subText:"Specifies the path to this performance replication cluster's API mount path, including any namespaces as path components. This address is used for the ACME directories, which must be served over a TLS-enabled listener."}),r=(0,t.attr)("string",{label:"AIA path",subText:"Specifies the path to this performance replication cluster's AIA distribution point; may refer to an external, non-Vault responder."}),o=(0,l.default)(l.apiPath`${"id"}/config/cluster`,"id"),a((u=class extends t.default{constructor(){super(...arguments),m(this,"path",d,this),m(this,"aiaPath",c,this),m(this,"clusterPath",p,this)}get useOpenAPI(){return!0}getHelpUrl(e){return`/v1/${e}/config/cluster?help=1`}get canSet(){return!1!==this.clusterPath.get("canUpdate")}},d=f(u.prototype,"path",[i],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=f(u.prototype,"aiaPath",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=f(u.prototype,"clusterPath",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=u))||s)
e.default=h})),define("vault/models/pki/config/crl",["exports","@ember-data/model","vault/decorators/model-form-fields","vault/macros/lazy-capabilities"],(function(e,t,n,l){var a,i,r,o,s,u,d,c,p,m,f,h,b,y,v,g,w,k,x,_,P,T,O,j,M,z,S
function C(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function A(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let R=(a=(0,n.withFormFields)(null,[{"Certificate Revocation List (CRL)":["expiry","autoRebuildGracePeriod","deltaRebuildInterval"]},{"Online Certificate Status Protocol (OCSP)":["ocspExpiry"]},{"Unified Revocation":["crossClusterRevocation","unifiedCrl","unifiedCrlOnExistingPaths"]}]),i=(0,t.attr)("boolean"),r=(0,t.attr)("string",{label:"Auto-rebuild on",labelDisabled:"Auto-rebuild off",mapToBoolean:"autoRebuild",isOppositeValue:!1,editType:"ttl",helperTextEnabled:"Vault will rebuild the CRL in the below grace period before expiration",helperTextDisabled:"Vault will not automatically rebuild the CRL"}),o=(0,t.attr)("boolean"),s=(0,t.attr)("string",{label:"Delta CRL building on",labelDisabled:"Delta CRL building off",mapToBoolean:"enableDelta",isOppositeValue:!1,editType:"ttl",helperTextEnabled:"Vault will rebuild the delta CRL at the interval below:",helperTextDisabled:"Vault will not rebuild the delta CRL at an interval"}),u=(0,t.attr)("boolean"),d=(0,t.attr)("string",{label:"Expiry",labelDisabled:"No expiry",mapToBoolean:"disable",isOppositeValue:!0,editType:"ttl",helperTextDisabled:"The CRL will not be built.",helperTextEnabled:"The CRL will expire after:"}),c=(0,t.attr)("boolean"),p=(0,t.attr)("string",{label:"OCSP responder APIs enabled",labelDisabled:"OCSP responder APIs disabled",mapToBoolean:"ocspDisable",isOppositeValue:!0,editType:"ttl",helperTextEnabled:"Requests about a certificate's status will be valid for:",helperTextDisabled:"Requests cannot be made to check if an individual certificate is valid."}),m=(0,t.attr)("boolean",{label:"Cross-cluster revocation",helpText:"Enables cross-cluster revocation request queues. When a serial not issued on this local cluster is passed to the /revoke endpoint, it is replicated across clusters and revoked by the issuing cluster if it is online."}),f=(0,t.attr)("boolean",{label:"Unified CRL",helpText:"Enables unified CRL and OCSP building. This synchronizes all revocations between clusters; a single, unified CRL will be built on the active node of the primary performance replication (PR) cluster."}),h=(0,t.attr)("boolean",{label:"Unified CRL on existing paths",helpText:"If enabled, existing CRL and OCSP paths will return the unified CRL instead of a response based on cluster-local data."}),b=(0,l.default)(l.apiPath`${"id"}/config/crl`,"id"),a((v=class extends t.default{constructor(){super(...arguments),C(this,"autoRebuild",g,this),C(this,"autoRebuildGracePeriod",w,this),C(this,"enableDelta",k,this),C(this,"deltaRebuildInterval",x,this),C(this,"disable",_,this),C(this,"expiry",P,this),C(this,"ocspDisable",T,this),C(this,"ocspExpiry",O,this),C(this,"crossClusterRevocation",j,this),C(this,"unifiedCrl",M,this),C(this,"unifiedCrlOnExistingPaths",z,this),C(this,"crlPath",S,this)}get canSet(){return!1!==this.crlPath.get("canUpdate")}},g=A(v.prototype,"autoRebuild",[i],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=A(v.prototype,"autoRebuildGracePeriod",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=A(v.prototype,"enableDelta",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=A(v.prototype,"deltaRebuildInterval",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_=A(v.prototype,"disable",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P=A(v.prototype,"expiry",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=A(v.prototype,"ocspDisable",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=A(v.prototype,"ocspExpiry",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=A(v.prototype,"crossClusterRevocation",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),M=A(v.prototype,"unifiedCrl",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),z=A(v.prototype,"unifiedCrlOnExistingPaths",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),S=A(v.prototype,"crlPath",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=v))||y)
e.default=R})),define("vault/models/pki/config/urls",["exports","@ember-data/model","vault/decorators/model-form-fields","vault/macros/lazy-capabilities"],(function(e,t,n,l){var a,i,r,o,s,u,d,c,p,m,f
function h(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function b(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let y=(a=(0,n.withFormFields)(),i=(0,t.attr)({label:"Issuing certificates",subText:"The URL values for the Issuing Certificate field; these are different URLs for the same resource.",showHelpText:!1,editType:"stringArray"}),r=(0,t.attr)({label:"CRL distribution points",subText:"Specifies the URL values for the CRL Distribution Points field.",showHelpText:!1,editType:"stringArray"}),o=(0,t.attr)({label:"OCSP Servers",subText:"Specifies the URL values for the OCSP Servers field.",showHelpText:!1,editType:"stringArray"}),s=(0,l.default)(l.apiPath`${"id"}/config/urls`,"id"),a((d=class extends t.default{constructor(){super(...arguments),h(this,"issuingCertificates",c,this),h(this,"crlDistributionPoints",p,this),h(this,"ocspServers",m,this),h(this,"urlsPath",f,this)}get useOpenAPI(){return!0}getHelpUrl(e){return`/v1/${e}/config/urls?help=1`}get canSet(){return!1!==this.urlsPath.get("canUpdate")}},c=b(d.prototype,"issuingCertificates",[i],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=b(d.prototype,"crlDistributionPoints",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=b(d.prototype,"ocspServers",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=b(d.prototype,"urlsPath",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=d))||u)
e.default=y})),define("vault/models/pki/issuer",["exports","@ember-data/model","vault/decorators/model-form-fields","vault/macros/lazy-capabilities","@ember/service"],(function(e,t,n,l,a){var i,r,o,s,u,d,c,p,m,f,h,b,y,v,g,w,k,x,_,P,T,O,j,M,z,S,C,A,R,D,E,N,F,I,L,V,U,$,q,K,B,G,W,H,Y,Q,J,Z,X,ee,te,ne,le,ae,ie,re,oe,se,ue,de,ce,pe,me
function fe(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function he(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const be=["issuingCertificates","crlDistributionPoints","ocspServers"],ye=["issuerName","leafNotAfterBehavior","usage","manualChain","revocationSignatureAlgorithm",...be],ve=[{default:["certificate","caChain","commonName","issuerName","issuerId","keyId"]},{"Issuer URLs":be}]
let ge=(i=(0,n.withFormFields)(ye,ve),r=(0,t.attr)("string",{label:"Issuer ID",detailLinkTo:"issuers.issuer.details"}),o=(0,t.attr)("string",{label:"Default key ID",detailLinkTo:"keys.key.details"}),s=(0,t.attr)({label:"CA Chain",isCertificate:!0}),u=(0,t.attr)({isCertificate:!0}),d=(0,t.attr)("string"),c=(0,t.attr)("string"),p=(0,t.attr)({label:"Subject Alternative Names (SANs)"}),m=(0,t.attr)({label:"IP SANs"}),f=(0,t.attr)({label:"URI SANs"}),h=(0,t.attr)({label:"Other SANs"}),b=(0,t.attr)("string"),y=(0,t.attr)({label:"Leaf notAfter behavior",subText:"What happens when a leaf certificate is issued, but its NotAfter field (and therefore its expiry date) exceeds that of this issuer.",docLink:"/vault/api-docs/secret/pki#update-issuer",editType:"yield",valueOptions:["err","truncate","permit"]}),v=(0,t.attr)({subText:"Allowed usages for this issuer. It can always be read.",editType:"yield",valueOptions:[{label:"Issuing certificates",value:"issuing-certificates"},{label:"Signing CRLs",value:"crl-signing"},{label:"Signing OCSPs",value:"ocsp-signing"}]}),g=(0,t.attr)("string",{subText:"An advanced field useful when automatic chain building isn't desired. The first element must be the present issuer's reference."}),w=(0,t.attr)({subText:"The signature algorithm to use when building CRLs. The default value (empty string) is for Go to select the signature algorithm automatically, which may not always work.",noDefault:!0,possibleValues:["sha256withrsa","ecdsawithsha384","sha256withrsapss","ed25519","sha384withrsapss","sha512withrsapss","pureed25519","sha384withrsa","sha512withrsa","ecdsawithsha256","ecdsawithsha512"]}),k=(0,t.attr)("string",{subText:"The URL values for the Issuing Certificate field; these are different URLs for the same resource.",editType:"stringArray"}),x=(0,t.attr)("string",{label:"CRL distribution points",subText:"Specifies the URL values for the CRL Distribution Points field.",editType:"stringArray"}),_=(0,t.attr)("string",{label:"OCSP servers",subText:"Specifies the URL values for the OCSP Servers field.",editType:"stringArray"}),P=(0,t.attr)("string"),T=(0,l.default)(l.apiPath`${"backend"}/issuer/${"issuerId"}`,"backend","issuerId"),O=(0,l.default)(l.apiPath`${"backend"}/root/rotate/exported`,"backend"),j=(0,l.default)(l.apiPath`${"backend"}/root/rotate/internal`,"backend"),M=(0,l.default)(l.apiPath`${"backend"}/root/rotate/existing`,"backend"),z=(0,l.default)(l.apiPath`${"backend"}/root`,"backend"),S=(0,l.default)(l.apiPath`${"backend"}/intermediate/cross-sign`,"backend"),C=(0,l.default)(l.apiPath`${"backend"}/issuer/${"issuerId"}/sign-intermediate`,"backend","issuerId"),i((R=class extends t.default{constructor(){super(...arguments),fe(this,"secretMountPath",D,this),fe(this,"isDefault",E,this),fe(this,"issuerId",N,this),fe(this,"keyId",F,this),fe(this,"caChain",I,this),fe(this,"certificate",L,this),fe(this,"serialNumber",V,this),fe(this,"parsedCertificate",U,this),fe(this,"commonName",$,this),fe(this,"isRoot",q,this),fe(this,"subjectSerialNumber",K,this),fe(this,"altNames",B,this),fe(this,"ipSans",G,this),fe(this,"uriSans",W,this),fe(this,"otherSans",H,this),fe(this,"issuerName",Y,this),fe(this,"leafNotAfterBehavior",Q,this),fe(this,"usage",J,this),fe(this,"manualChain",Z,this),fe(this,"revocationSignatureAlgorithm",X,this),fe(this,"issuingCertificates",ee,this),fe(this,"crlDistributionPoints",te,this),fe(this,"ocspServers",ne,this),fe(this,"pemBundle",le,this),fe(this,"importedIssuers",ae,this),fe(this,"importedKeys",ie,this),fe(this,"mapping",re,this),fe(this,"issuerPath",oe,this),fe(this,"rotateExported",se,this)
fe(this,"rotateInternal",ue,this),fe(this,"rotateExisting",de,this),fe(this,"deletePath",ce,this),fe(this,"crossSignPath",pe,this),fe(this,"signIntermediate",me,this)}get useOpenAPI(){return!1}get backend(){return this.secretMountPath.currentPath}get issuerRef(){return this.issuerName||this.issuerId}get canRotateIssuer(){return!1!==this.rotateExported.get("canUpdate")||!1!==this.rotateExisting.get("canUpdate")||!1!==this.rotateInternal.get("canUpdate")}get canCrossSign(){return!1!==this.crossSignPath.get("canUpdate")}get canSignIntermediate(){return!1!==this.signIntermediate.get("canUpdate")}get canConfigure(){return!1!==this.issuerPath.get("canUpdate")}get canDeleteAllIssuers(){return this.deletePath.get("isLoading")||!1!==this.deletePath.get("canDelete")}},D=he(R.prototype,"secretMountPath",[a.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),E=he(R.prototype,"isDefault",[t.attr],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),N=he(R.prototype,"issuerId",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),F=he(R.prototype,"keyId",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),I=he(R.prototype,"caChain",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),L=he(R.prototype,"certificate",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),V=he(R.prototype,"serialNumber",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),U=he(R.prototype,"parsedCertificate",[t.attr],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),$=he(R.prototype,"commonName",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),q=he(R.prototype,"isRoot",[t.attr],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),K=he(R.prototype,"subjectSerialNumber",[t.attr],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),B=he(R.prototype,"altNames",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),G=he(R.prototype,"ipSans",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),W=he(R.prototype,"uriSans",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),H=he(R.prototype,"otherSans",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Y=he(R.prototype,"issuerName",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Q=he(R.prototype,"leafNotAfterBehavior",[y],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),J=he(R.prototype,"usage",[v],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Z=he(R.prototype,"manualChain",[g],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),X=he(R.prototype,"revocationSignatureAlgorithm",[w],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ee=he(R.prototype,"issuingCertificates",[k],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),te=he(R.prototype,"crlDistributionPoints",[x],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ne=he(R.prototype,"ocspServers",[_],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),le=he(R.prototype,"pemBundle",[P],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ae=he(R.prototype,"importedIssuers",[t.attr],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ie=he(R.prototype,"importedKeys",[t.attr],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),re=he(R.prototype,"mapping",[t.attr],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),oe=he(R.prototype,"issuerPath",[T],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),se=he(R.prototype,"rotateExported",[O],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ue=he(R.prototype,"rotateInternal",[j],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),de=he(R.prototype,"rotateExisting",[M],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ce=he(R.prototype,"deletePath",[z],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),pe=he(R.prototype,"crossSignPath",[S],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),me=he(R.prototype,"signIntermediate",[C],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),A=R))||A)
e.default=ge})),define("vault/models/pki/key",["exports","@ember-data/model","@ember/service","vault/macros/lazy-capabilities","vault/decorators/model-form-fields","vault/decorators/model-validations"],(function(e,t,n,l,a,i){var r,o,s,u,d,c,p,m,f,h,b,y,v,g,w,k,x,_,P,T,O,j,M,z,S
function C(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function A(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const R={type:[{type:"presence",message:"Type is required."}],keyType:[{type:"presence",message:"Please select a key type."}],keyName:[{validator:e=>"default"!==e.keyName,message:"Key name cannot be the reserved value 'default'"}]}
let D=(r=(0,i.withModelValidations)(R),o=(0,a.withFormFields)(["keyId","keyName","keyType","keyBits"],[{default:["keyName","type"]},{"Key parameters":["keyType","keyBits"]}]),s=(0,t.attr)("string",{detailsLabel:"Key ID"}),u=(0,t.attr)("string",{subText:"Optional, human-readable name for this key. The name must be unique across all keys and cannot be 'default'."}),d=(0,t.attr)("string",{noDefault:!0,possibleValues:["internal","exported"],subText:"The type of operation. If exported, the private key will be returned in the response; if internal the private key will not be returned and cannot be retrieved later."}),c=(0,t.attr)("string",{noDefault:!0,possibleValues:["rsa","ec","ed25519"],subText:"The type of key that will be generated. Must be rsa, ed25519, or ec. "}),p=(0,t.attr)("string",{label:"Key bits",noDefault:!0,subText:"Bit length of the key to generate."}),m=(0,t.attr)("string"),f=(0,t.attr)("string"),h=(0,l.default)(l.apiPath`${"backend"}/key/${"keyId"}`,"backend","keyId"),b=(0,l.default)(l.apiPath`${"backend"}/keys/generate`,"backend"),y=(0,l.default)(l.apiPath`${"backend"}/keys/import`,"backend"),r(v=o((g=class extends t.default{constructor(){super(...arguments),C(this,"secretMountPath",w,this),C(this,"keyId",k,this),C(this,"keyName",x,this),C(this,"type",_,this),C(this,"keyType",P,this),C(this,"keyBits",T,this),C(this,"pemBundle",O,this),C(this,"privateKey",j,this),C(this,"keyPath",M,this),C(this,"generatePath",z,this),C(this,"importPath",S,this)}get backend(){return this.secretMountPath.currentPath}get canRead(){return!1!==this.keyPath.get("canRead")}get canEdit(){return!1!==this.keyPath.get("canUpdate")}get canDelete(){return!1!==this.keyPath.get("canDelete")}get canGenerateKey(){return!1!==this.generatePath.get("canUpdate")}get canImportKey(){return!1!==this.importPath.get("canUpdate")}},w=A(g.prototype,"secretMountPath",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=A(g.prototype,"keyId",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=A(g.prototype,"keyName",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_=A(g.prototype,"type",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P=A(g.prototype,"keyType",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=A(g.prototype,"keyBits",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=A(g.prototype,"pemBundle",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=A(g.prototype,"privateKey",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),M=A(g.prototype,"keyPath",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),z=A(g.prototype,"generatePath",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),S=A(g.prototype,"importPath",[y],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),v=g))||v)||v)
e.default=D})),define("vault/models/pki/role",["exports","@ember-data/model","vault/macros/lazy-capabilities","vault/decorators/model-validations","vault/decorators/model-form-fields"],(function(e,t,n,l,a){var i,r,o,s,u,d,c,p,m,f,h,b,y,v,g,w,k,x,_,P,T,O,j,M,z,S,C,A,R,D,E,N,F,I,L,V,U,$,q,K,B,G,W,H,Y,Q,J,Z,X,ee,te,ne,le,ae,ie,re,oe,se,ue,de,ce,pe,me,fe,he,be,ye,ve,ge,we,ke,xe,_e,Pe,Te,Oe,je,Me,ze,Se
function Ce(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function Ae(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let Re=(i=(0,a.withFormFields)(null,[{default:["name","issuerRef","customTtl","notBeforeDuration","maxTtl","generateLease","noStore","addBasicConstraints"]},{"Domain handling":["allowedDomains","allowedDomainsTemplate","allowBareDomains","allowSubdomains","allowGlobDomains","allowWildcardCertificates","allowLocalhost","allowAnyName","enforceHostnames"]},{"Key parameters":["keyType","keyBits","signatureBits"]},{"Key usage":["keyUsage","extKeyUsage","extKeyUsageOids"]},{"Policy identifiers":["policyIdentifiers"]},{"Subject Alternative Name (SAN) Options":["allowIpSans","allowedUriSans","allowUriSansTemplate","allowedOtherSans"]},{"Additional subject fields":["allowedUserIds","allowedSerialNumbers","requireCn","useCsrCommonName","useCsrSans","ou","organization","country","locality","province","streetAddress","postalCode"]}]),r=(0,l.withModelValidations)({name:[{type:"presence",message:"Name is required."}]}),o=(0,t.attr)("string",{readOnly:!0}),s=(0,t.attr)("string",{label:"Role name",fieldValue:"name",editDisabled:!0}),u=(0,t.attr)("string",{label:"Issuer reference",detailsLabel:"Issuer",defaultValue:"default",subText:"Specifies the issuer that will be used to create certificates with this role. To find this, run read -field=default pki_int/config/issuers in the console. By default, we will use the mounts default issuer."}),d=(0,t.attr)({label:"Not valid after",detailsLabel:"Issued certificates expire after",subText:"The time after which this certificate will no longer be valid. This can be a TTL (a range of time from now) or a specific date.",editType:"yield"}),c=(0,t.attr)({label:"Backdate validity",detailsLabel:"Issued certificate backdating",helperTextDisabled:"Vault will use the default value, 30s",helperTextEnabled:"Also called the not_before_duration property. Allows certificates to be valid for a certain time period before now. This is useful to correct clock misalignment on various systems when setting up your CA.",editType:"ttl",defaultValue:"30s"}),p=(0,t.attr)({label:"Max TTL",helperTextDisabled:"The maximum Time-To-Live of certificates generated by this role. If not set, the system max lease TTL will be used.",editType:"ttl",defaultShown:"System default"}),m=(0,t.attr)("boolean",{label:"Generate lease with certificate",subText:"Specifies if certificates issued/signed against this role will have Vault leases attached to them.",docLink:"/vault/api-docs/secret/pki#create-update-role"}),f=(0,t.attr)("boolean",{label:"Do not store certificates in storage backend",detailsLabel:"Store in storage backend",subText:"This can improve performance when issuing large numbers of certificates. However, certificates issued in this way cannot be enumerated or revoked.",docLink:"/vault/api-docs/secret/pki#create-update-role"}),h=(0,t.attr)("boolean",{label:"Basic constraints valid for non-CA",detailsLabel:"Add basic constraints",subText:"Mark Basic Constraints valid when issuing non-CA certificates."}),b=(0,t.attr)({label:"Allowed domains",subText:"Specifies the domains this role is allowed to issue certificates for.",editType:"stringArray"}),y=(0,t.attr)("boolean",{label:"Allow templates in allowed domains"}),v=(0,t.attr)("string",{label:"Key type",possibleValues:["rsa","ec","ed25519","any"],defaultValue:"rsa"}),g=(0,t.attr)("string",{label:"Key bits",defaultValue:"2048"}),w=(0,t.attr)("string",{label:"Signature bits",subText:"Only applicable for key_type 'RSA'. Ignore for other key types.",defaultValue:"0",possibleValues:["0","256","384","512"]}),k=(0,t.attr)({label:"Policy identifiers",subText:"A list of policy object identifiers (OIDs).",editType:"stringArray"}),x=(0,t.attr)("boolean",{label:"Allow IP SANs",subText:"Specifies if clients can request IP Subject Alternative Names.",defaultValue:!0}),_=(0,t.attr)({label:"URI Subject Alternative Names (URI SANs)",subText:"Defines allowed URI Subject Alternative Names.",editType:"stringArray",docLink:"/vault/docs/concepts/policies"}),P=(0,t.attr)("boolean",{label:"Allow URI SANs template",subText:"If true, the URI SANs above may contain templates, as with ACL Path Templating.",docLink:"/vault/docs/concepts/policies"}),T=(0,t.attr)({label:"Other SANs",subText:"Defines allowed custom OID/UTF8-string SANs.",editType:"stringArray"}),O=(0,t.attr)({label:"Allowed serial numbers",subText:"A list of allowed serial numbers to be requested during certificate issuance. Shell-style globbing is supported. If empty, custom-specified serial numbers will be forbidden.",editType:"stringArray"}),j=(0,t.attr)("boolean",{label:"Require common name",subText:"If set to false, common name will be optional when generating a certificate.",defaultValue:!0}),M=(0,t.attr)("boolean",{label:"Use CSR common name",subText:"When used with the CSR signing endpoint, the common name in the CSR will be used instead of taken from the JSON data.",defaultValue:!0}),z=(0,t.attr)("boolean",{label:"Use CSR SANs",subText:"When used with the CSR signing endpoint, the subject alternate names in the CSR will be used instead of taken from the JSON data.",defaultValue:!0}),S=(0,t.attr)({label:"Organization Units (OU)",subText:"A list of allowed serial numbers to be requested during certificate issuance. Shell-style globbing is supported. If empty, custom-specified serial numbers will be forbidden.",editType:"stringArray"}),C=(0,t.attr)("array",{defaultValue:()=>["DigitalSignature","KeyAgreement","KeyEncipherment"],defaultShown:"None"}),A=(0,t.attr)("array",{defaultShown:"None"}),R=(0,t.attr)("array",{defaultShown:"None"}),D=(0,t.attr)({editType:"stringArray"}),E=(0,t.attr)({editType:"stringArray"}),N=(0,t.attr)({editType:"stringArray"}),F=(0,t.attr)({editType:"stringArray"}),I=(0,t.attr)({editType:"stringArray"}),L=(0,t.attr)({editType:"stringArray"}),V=(0,t.attr)({editType:"stringArray"}),U=(0,n.default)(n.apiPath`${"backend"}/roles/${"id"}`,"backend","id"),$=(0,n.default)(n.apiPath`${"backend"}/issue/${"id"}`,"backend","id"),q=(0,n.default)(n.apiPath`${"backend"}/sign/${"id"}`,"backend","id"),K=(0,n.default)(n.apiPath`${"backend"}/sign-verbatim/${"id"}`,"backend","id"),i(B=r((G=class extends t.default{constructor(){super(...arguments),Ce(this,"backend",W,this),Ce(this,"name",H,this),Ce(this,"issuerRef",Y,this),Ce(this,"customTtl",Q,this),Ce(this,"notBeforeDuration",J,this),Ce(this,"maxTtl",Z,this),Ce(this,"generateLease",X,this),Ce(this,"noStore",ee,this),Ce(this,"addBasicConstraints",te,this),Ce(this,"allowedDomains",ne,this),Ce(this,"allowedDomainsTemplate",le,this),Ce(this,"keyType",ae,this),Ce(this,"keyBits",ie,this),Ce(this,"signatureBits",re,this),Ce(this,"policyIdentifiers",oe,this),Ce(this,"allowIpSans",se,this),Ce(this,"allowedUriSans",ue,this),Ce(this,"allowUriSansTemplate",de,this),Ce(this,"allowedOtherSans",ce,this),Ce(this,"allowedSerialNumbers",pe,this),Ce(this,"requireCn",me,this),Ce(this,"useCsrCommonName",fe,this),Ce(this,"useCsrSans",he,this),Ce(this,"ou",be,this),Ce(this,"keyUsage",ye,this),Ce(this,"extKeyUsage",ve,this),Ce(this,"extKeyUsageOids",ge,this),Ce(this,"allowedUserIds",we,this),Ce(this,"organization",ke,this)
Ce(this,"country",xe,this),Ce(this,"locality",_e,this),Ce(this,"province",Pe,this),Ce(this,"streetAddress",Te,this),Ce(this,"postalCode",Oe,this),Ce(this,"updatePath",je,this),Ce(this,"generatePath",Me,this),Ce(this,"signPath",ze,this),Ce(this,"signVerbatimPath",Se,this)}get useOpenAPI(){return!0}getHelpUrl(e){return`/v1/${e}/roles/example?help=1`}get canDelete(){return this.updatePath.get("isLoading")||!1!==this.updatePath.get("canCreate")}get canEdit(){return this.updatePath.get("isLoading")||!1!==this.updatePath.get("canUpdate")}get canRead(){return this.updatePath.get("isLoading")||!1!==this.updatePath.get("canRead")}get canGenerateCert(){return this.generatePath.get("isLoading")||!1!==this.generatePath.get("canUpdate")}get canSign(){return this.signPath.get("isLoading")||!1!==this.signPath.get("canUpdate")}get canSignVerbatim(){return this.signVerbatimPath.get("isLoading")||!1!==this.signVerbatimPath.get("canUpdate")}get fieldGroupsInfo(){return{"Domain handling":{footer:{text:"These options can interact intricately with one another. For more information,",docText:"learn more here.",docLink:"/vault/api-docs/secret/pki#allowed_domains"}},"Key parameters":{header:{text:"These are the parameters for generating or validating the certificate's key material."}},"Subject Alternative Name (SAN) Options":{header:{text:"Subject Alternative Names (SANs) are identities (domains, IP addresses, and URIs) Vault attaches to the requested certificates."}},"Additional subject fields":{header:{text:"Additional identity metadata Vault can attach to the requested certificates."}}}}},W=Ae(G.prototype,"backend",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),H=Ae(G.prototype,"name",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Y=Ae(G.prototype,"issuerRef",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Q=Ae(G.prototype,"customTtl",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),J=Ae(G.prototype,"notBeforeDuration",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Z=Ae(G.prototype,"maxTtl",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),X=Ae(G.prototype,"generateLease",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ee=Ae(G.prototype,"noStore",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),te=Ae(G.prototype,"addBasicConstraints",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ne=Ae(G.prototype,"allowedDomains",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),le=Ae(G.prototype,"allowedDomainsTemplate",[y],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ae=Ae(G.prototype,"keyType",[v],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ie=Ae(G.prototype,"keyBits",[g],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),re=Ae(G.prototype,"signatureBits",[w],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),oe=Ae(G.prototype,"policyIdentifiers",[k],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),se=Ae(G.prototype,"allowIpSans",[x],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ue=Ae(G.prototype,"allowedUriSans",[_],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),de=Ae(G.prototype,"allowUriSansTemplate",[P],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ce=Ae(G.prototype,"allowedOtherSans",[T],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),pe=Ae(G.prototype,"allowedSerialNumbers",[O],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),me=Ae(G.prototype,"requireCn",[j],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),fe=Ae(G.prototype,"useCsrCommonName",[M],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),he=Ae(G.prototype,"useCsrSans",[z],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),be=Ae(G.prototype,"ou",[S],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ye=Ae(G.prototype,"keyUsage",[C],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ve=Ae(G.prototype,"extKeyUsage",[A],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ge=Ae(G.prototype,"extKeyUsageOids",[R],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),we=Ae(G.prototype,"allowedUserIds",[D],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ke=Ae(G.prototype,"organization",[E],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),xe=Ae(G.prototype,"country",[N],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_e=Ae(G.prototype,"locality",[F],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Pe=Ae(G.prototype,"province",[I],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Te=Ae(G.prototype,"streetAddress",[L],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Oe=Ae(G.prototype,"postalCode",[V],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),je=Ae(G.prototype,"updatePath",[U],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Me=Ae(G.prototype,"generatePath",[$],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),ze=Ae(G.prototype,"signPath",[q],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),Se=Ae(G.prototype,"signVerbatimPath",[K],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),B=G))||B)||B)
e.default=Re})),define("vault/models/pki/sign-intermediate",["exports","@ember-data/model","vault/decorators/model-form-fields","vault/decorators/model-validations","vault/models/pki/certificate/base"],(function(e,t,n,l,a){var i,r,o,s,u,d,c,p,m,f,h,b,y,v,g,w,k,x,_,P,T,O,j
function M(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function z(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let S=(i=(0,l.withModelValidations)({csr:[{type:"presence",message:"CSR is required."}]}),r=(0,n.withFormFields)(["csr","useCsrValues","commonName","excludeCnFromSans","customTtl","notBeforeDuration","format","permittedDnsDomains","maxPathLength"]),o=(0,t.attr)("string",{label:"CSR",editType:"textarea",subText:"The PEM-encoded CSR to be signed."}),s=(0,t.attr)("boolean",{label:"Use CSR values",subText:"Subject information and key usages specified in the CSR will be used over parameters provided here, and extensions in the CSR will be copied into the issued certificate.",docLink:"/vault/api-docs/secret/pki#use_csr_values"}),u=(0,t.attr)({label:"Backdate validity",detailsLabel:"Issued certificate backdating",helperTextDisabled:"Vault will use the default value, 30s",helperTextEnabled:"Also called the not_before_duration property. Allows certificates to be valid for a certain time period before now. This is useful to correct clock misalignment on various systems when setting up your CA.",editType:"ttl",defaultValue:"30s"}),d=(0,t.attr)({label:"Permitted DNS domains",subText:"DNS domains for which certificates are allowed to be issued or signed by this CA certificate. Enter each value as a new input."}),c=(0,t.attr)({subText:"Specifies the maximum path length to encode in the generated certificate. -1 means no limit",defaultValue:"-1"}),p=(0,t.attr)({label:"Use PSS",subText:"If checked, PSS signatures will be used over PKCS#1v1.5 signatures when a RSA-type issuer is used. Ignored for ECDSA/Ed25519 issuers."}),m=(0,t.attr)({label:"Subject Key Identifier (SKID)",subText:"Value for the subject key identifier, specified as a string in hex format. If this is empty, Vault will automatically calculate the SKID. "}),f=(0,t.attr)({possibleValues:["0","256","384","512"]}),h=(0,t.attr)("string",{subText:"Specifies the requested Subject's named Serial Number value. This has no impact on the Certificate's serial number randomly generated by Vault."}),i(b=r((y=class extends a.default{constructor(){super(...arguments),M(this,"issuerRef",v,this),M(this,"csr",g,this),M(this,"useCsrValues",w,this),M(this,"notBeforeDuration",k,this),M(this,"permittedDnsDomains",x,this),M(this,"maxPathLength",_,this),M(this,"usePss",P,this),M(this,"skid",T,this),M(this,"signatureBits",O,this),M(this,"subjectSerialNumber",j,this)}getHelpUrl(e){return`/v1/${e}/issuer/example/sign-intermediate?help=1`}},v=z(y.prototype,"issuerRef",[t.attr],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g=z(y.prototype,"csr",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=z(y.prototype,"useCsrValues",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=z(y.prototype,"notBeforeDuration",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=z(y.prototype,"permittedDnsDomains",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_=z(y.prototype,"maxPathLength",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P=z(y.prototype,"usePss",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=z(y.prototype,"skid",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=z(y.prototype,"signatureBits",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=z(y.prototype,"subjectSerialNumber",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=y))||b)||b)
e.default=S})),define("vault/models/pki/tidy",["exports","@ember-data/model","@ember/service","vault/decorators/model-expanded-attributes"],(function(e,t,n,l){var a,i,r,o,s,u,d,c,p,m,f,h,b,y,v,g,w,k,x,_,P,T,O,j,M,z,S,C,A,R,D,E,N,F
function I(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function L(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let V=(a=(0,l.withExpandedAttributes)(),i=(0,t.attr)({label:"Tidy ACME enabled",labelDisabled:"Tidy ACME disabled",mapToBoolean:"tidyAcme",helperTextDisabled:"Tidying of ACME accounts, orders and authorizations is disabled",helperTextEnabled:"The amount of time that must pass after creation that an account with no orders is marked revoked, and the amount of time after being marked revoked or deactivated.",detailsLabel:"ACME account safety buffer",formatTtl:!0}),r=(0,t.attr)("boolean",{label:"Tidy ACME",defaultValue:!1}),o=(0,t.attr)("boolean",{label:"Automatic tidy enabled",defaultValue:!1}),s=(0,t.attr)({label:"Automatic tidy enabled",labelDisabled:"Automatic tidy disabled",mapToBoolean:"enabled",helperTextEnabled:"Sets the interval_duration between automatic tidy operations; note that this is from the end of one operation to the start of the next.",helperTextDisabled:"Automatic tidy operations will not run.",detailsLabel:"Automatic tidy duration",formatTtl:!0}),u=(0,t.attr)("string",{editType:"ttl",helperTextEnabled:"Specifies a duration that issuers should be kept for, past their NotAfter validity period. Defaults to 365 days (8760 hours).",hideToggle:!0,formatTtl:!0}),d=(0,t.attr)("string",{editType:"ttl",helperTextEnabled:"Specifies the duration to pause between tidying individual certificates. This releases the revocation lock and allows other operations to continue while tidy is running.",hideToggle:!0,formatTtl:!0}),c=(0,t.attr)("string",{editType:"ttl",helperTextEnabled:"Specifies a duration after which cross-cluster revocation requests will be removed as expired.",hideToggle:!0,formatTtl:!0}),p=(0,t.attr)("string",{editType:"ttl",helperTextEnabled:"For a certificate to be expunged, the time must be after the expiration time of the certificate (according to the local clock) plus the safety buffer. Defaults to 72 hours.",hideToggle:!0,formatTtl:!0}),m=(0,t.attr)("boolean",{label:"Tidy the certificate store"}),f=(0,t.attr)("boolean",{label:"Tidy cross-cluster revoked certificates",subText:"Remove expired, cross-cluster revocation entries."}),h=(0,t.attr)("boolean",{subText:"Automatically remove expired issuers after the issuer safety buffer duration has elapsed."}),b=(0,t.attr)("boolean",{label:"Tidy legacy CA bundle",subText:"Backup any legacy CA/issuers bundle (from Vault versions earlier than 1.11) to config/ca_bundle.bak. Migration will only occur after issuer safety buffer has passed."}),y=(0,t.attr)("boolean",{label:"Tidy cross-cluster revocation requests"}),v=(0,t.attr)("boolean",{label:"Tidy revoked certificate issuer associations"}),g=(0,t.attr)("boolean",{label:"Tidy revoked certificates",subText:"Remove all invalid and expired certificates from storage."}),a((k=class extends t.default{constructor(){super(...arguments),I(this,"version",x,this),I(this,"acmeAccountSafetyBuffer",_,this),I(this,"tidyAcme",P,this),I(this,"enabled",T,this),I(this,"intervalDuration",O,this),I(this,"issuerSafetyBuffer",j,this),I(this,"pauseDuration",M,this),I(this,"revocationQueueSafetyBuffer",z,this),I(this,"safetyBuffer",S,this),I(this,"tidyCertStore",C,this),I(this,"tidyCrossClusterRevokedCerts",A,this),I(this,"tidyExpiredIssuers",R,this),I(this,"tidyMoveLegacyCaBundle",D,this),I(this,"tidyRevocationQueue",E,this),I(this,"tidyRevokedCertIssuerAssociations",N,this),I(this,"tidyRevokedCerts",F,this)}get useOpenAPI(){return!0}getHelpUrl(e){return`/v1/${e}/config/auto-tidy?help=1`}get allGroups(){const e=[{autoTidy:["enabled","intervalDuration"]},...this.sharedFields]
return this._expandGroups(e)}get sharedFields(){const e=[{"Universal operations":["tidyCertStore","tidyRevokedCerts","tidyRevokedCertIssuerAssociations","safetyBuffer","pauseDuration"]},{"ACME operations":["tidyAcme","acmeAccountSafetyBuffer"]},{"Issuer operations":["tidyExpiredIssuers","tidyMoveLegacyCaBundle","issuerSafetyBuffer"]}]
return this.version.isEnterprise&&e.push({"Cross-cluster operations":["tidyRevocationQueue","tidyCrossClusterRevokedCerts","revocationQueueSafetyBuffer"]}),e}get formFieldGroups(){return this._expandGroups(this.sharedFields)}},x=L(k.prototype,"version",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_=L(k.prototype,"acmeAccountSafetyBuffer",[i],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P=L(k.prototype,"tidyAcme",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=L(k.prototype,"enabled",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O=L(k.prototype,"intervalDuration",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j=L(k.prototype,"issuerSafetyBuffer",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),M=L(k.prototype,"pauseDuration",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),z=L(k.prototype,"revocationQueueSafetyBuffer",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),S=L(k.prototype,"safetyBuffer",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),C=L(k.prototype,"tidyCertStore",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),A=L(k.prototype,"tidyCrossClusterRevokedCerts",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),R=L(k.prototype,"tidyExpiredIssuers",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),D=L(k.prototype,"tidyMoveLegacyCaBundle",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),E=L(k.prototype,"tidyRevocationQueue",[y],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),N=L(k.prototype,"tidyRevokedCertIssuerAssociations",[v],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),F=L(k.prototype,"tidyRevokedCerts",[g],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=k))||w)
e.default=V})),define("vault/models/policy",["exports","@ember-data/model","@ember/object/computed","@ember/object","vault/macros/lazy-capabilities"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=t.default.extend({name:(0,t.attr)("string"),policy:(0,t.attr)("string"),policyType:(0,l.computed)("constructor.modelName",(function(){return this.constructor.modelName.split("/")[1]})),updatePath:(0,a.default)(a.apiPath`sys/policies/${"policyType"}/${"id"}`,"id","policyType"),canDelete:(0,n.alias)("updatePath.canDelete"),canEdit:(0,n.alias)("updatePath.canUpdate"),canRead:(0,n.alias)("updatePath.canRead"),format:(0,l.computed)("policy",(function(){const e=this.policy
let t
try{JSON.parse(e)&&(t=!0)}catch(n){t=!1}return t?"json":"hcl"}))})
e.default=i})),define("vault/models/policy/acl",["exports","vault/models/policy"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend()
e.default=n})),define("vault/models/policy/egp",["exports","@ember-data/model","@ember/object","vault/models/policy/rgp","vault/utils/field-to-attrs"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=l.default.extend({paths:(0,t.attr)({editType:"stringArray"}),additionalAttrs:(0,n.computed)((function(){return(0,a.expandAttributeMeta)(this,["enforcementLevel","paths"])}))})
e.default=i})),define("vault/models/policy/rgp",["exports","@ember-data/model","@ember/object","vault/models/policy","vault/utils/field-to-attrs"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=l.default.extend({enforcementLevel:(0,t.attr)("string",{possibleValues:["advisory","soft-mandatory","hard-mandatory"],defaultValue:"hard-mandatory"}),additionalAttrs:(0,n.computed)((function(){return(0,a.expandAttributeMeta)(this,["enforcementLevel"])}))})
e.default=i})),define("vault/models/raft-join",["exports","@ember-data/model","vault/utils/field-to-attrs","@ember/object"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=t.default.extend({leaderApiAddr:(0,t.attr)("string",{label:"Leader API Address"}),retry:(0,t.attr)("boolean",{label:"Keep retrying to join in case of failures"}),leaderCaCert:(0,t.attr)("string",{label:"Leader CA Certificate",editType:"file"}),leaderClientCert:(0,t.attr)("string",{label:"Leader Client Certificate",editType:"file"}),leaderClientKey:(0,t.attr)("string",{label:"Leader Client Key",editType:"file"}),fields:(0,l.computed)((function(){return(0,n.expandAttributeMeta)(this,["leaderApiAddr","leaderCaCert","leaderClientCert","leaderClientKey","retry"])}))})
e.default=a})),define("vault/models/replication-attributes",["exports","@ember-data/model","@ember/object/computed","@ember/object"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=t.default.extend({clusterId:(0,t.attr)("string"),clusterIdDisplay:(0,l.computed)("clusterId","mode",(function(){const e=this.clusterId
return e?e.split("-")[0]:null})),mode:(0,t.attr)("string"),replicationDisabled:(0,n.match)("mode",/disabled|unsupported/),replicationUnsupported:(0,n.match)("mode",/unsupported/),replicationEnabled:(0,n.not)("replicationDisabled"),isPrimary:(0,n.match)("mode",/primary/),knownSecondaries:(0,t.attr)("array"),secondaries:(0,t.attr)("array"),isSecondary:(0,n.match)("mode",/secondary/),connection_state:(0,t.attr)("string"),modeForUrl:(0,l.computed)("isPrimary","isSecondary","mode",(function(){return"bootstrapping"===this.mode?"bootstrapping":this.isSecondary?"secondary":this.isPrimary&&"primary"})),modeForHeader:(0,l.computed)("mode",(function(){const e=this.mode
return e||"loading"})),secondaryId:(0,t.attr)("string"),primaryClusterAddr:(0,t.attr)("string"),knownPrimaryClusterAddrs:(0,t.attr)("array"),primaries:(0,t.attr)("array"),state:(0,t.attr)("string"),lastRemoteWAL:(0,t.attr)("number"),lastWAL:(0,t.attr)("number"),merkleRoot:(0,t.attr)("string"),merkleSyncProgress:(0,t.attr)("object"),get syncProgress(){const{state:e,merkleSyncProgress:t}=this
if("merkle-sync"!==e||!t)return null
const{sync_total_keys:n,sync_progress:l}=t
return{progress:l,total:n}},syncProgressPercent:(0,l.computed)("syncProgress",(function(){const e=this.syncProgress
if(!e)return null
const{progress:t,total:n}=e
return Math.floor(t/n*100)})),modeDisplay:(0,l.computed)("mode",(function(){return{disabled:"Disabled",unknown:"Unknown",bootstrapping:"Bootstrapping",primary:"Primary",secondary:"Secondary",unsupported:"Not supported"}[this.mode]||"Disabled"}))})
e.default=a})),define("vault/models/replication-mode",["exports","@ember-data/model"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({status:(0,t.attr)("object")})
e.default=n})),define("vault/models/role-aws",["exports","@ember-data/model","@ember/object/computed","@ember/object","vault/macros/lazy-capabilities","vault/utils/field-to-attrs"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=t.default.extend({backend:(0,t.attr)("string",{readOnly:!0}),name:(0,t.attr)("string",{label:"Role name",readOnly:!0}),credentialTypes:(0,t.attr)("array",{readOnly:!0}),credentialType:(0,t.attr)("string",{defaultValue:"iam_user",possibleValues:[{value:"iam_user",displayName:"IAM User"},{value:"assumed_role",displayName:"Assumed Role"},{value:"federation_token",displayName:"Federation Token"}]}),roleArns:(0,t.attr)({editType:"stringArray",label:"Role ARNs"}),policyArns:(0,t.attr)({editType:"stringArray",label:"Policy ARNs"}),policyDocument:(0,t.attr)("string",{editType:"json",helpText:"A policy is an object in AWS that, when associated with an identity or resource, defines their permissions."}),fields:(0,l.computed)("credentialType",(function(){const e=this.credentialType
return(0,i.expandAttributeMeta)(this,{iam_user:["name","credentialType","policyArns","policyDocument"],assumed_role:["name","credentialType","roleArns","policyDocument"],federation_token:["name","credentialType","policyDocument"]}[e])})),updatePath:(0,a.default)(a.apiPath`${"backend"}/roles/${"id"}`,"backend","id"),canDelete:(0,n.alias)("updatePath.canDelete"),canEdit:(0,n.alias)("updatePath.canUpdate"),canRead:(0,n.alias)("updatePath.canRead"),generatePath:(0,a.default)(a.apiPath`${"backend"}/creds/${"id"}`,"backend","id"),canGenerate:(0,n.alias)("generatePath.canUpdate")})
e.default=r})),define("vault/models/role-jwt",["exports","@ember-data/model","core/utils/parse-url"],(function(e,t,n){var l,a,i
Object.defineProperty(e,"__esModule",{value:!0}),e.default=e.PROVIDER_WITH_LOGO=e.DOMAIN_STRINGS=void 0
const r={"github.com":"GitHub","gitlab.com":"GitLab","google.com":"Google","ping.com":"Ping","okta.com":"Okta","auth0.com":"Auth0"}
e.DOMAIN_STRINGS=r
const o=["GitLab","Google","Auth0"]
e.PROVIDER_WITH_LOGO=o
let s=(l=(0,t.attr)("string"),a=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="authUrl",l=this,(n=i)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}get providerName(){const{hostname:e}=(0,n.default)(this.authUrl),t=Object.keys(r).find((t=>e.includes(t)))
return r[t]||null}get providerButtonComponent(){const{providerName:e}=this
return o.includes(e)?`auth-button-${e.toLowerCase()}`:null}},u=a.prototype,d="authUrl",c=[l],p={configurable:!0,enumerable:!0,writable:!0,initializer:null},f={},Object.keys(p).forEach((function(e){f[e]=p[e]})),f.enumerable=!!f.enumerable,f.configurable=!!f.configurable,("value"in f||f.initializer)&&(f.writable=!0),f=c.slice().reverse().reduce((function(e,t){return t(u,d,e)||e}),f),m&&void 0!==f.initializer&&(f.value=f.initializer?f.initializer.call(m):void 0,f.initializer=void 0),void 0===f.initializer&&(Object.defineProperty(u,d,f),f=null),i=f,a)
var u,d,c,p,m,f
e.default=s})),define("vault/models/role-saml",["exports","@ember-data/model"],(function(e,t){var n,l,a,i,r,o,s
function u(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function d(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let c=(n=(0,t.attr)("string"),l=(0,t.attr)("string"),a=(0,t.attr)("string"),i=class extends t.default{constructor(){super(...arguments),u(this,"ssoServiceURL",r,this),u(this,"tokenPollID",o,this),u(this,"clientVerifier",s,this)}},r=d(i.prototype,"ssoServiceURL",[n],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),o=d(i.prototype,"tokenPollID",[l],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=d(i.prototype,"clientVerifier",[a],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),i)
e.default=c}))
define("vault/models/role-ssh",["exports","@ember-data/model","@ember/object/computed","@ember/object","vault/utils/field-to-attrs","vault/macros/lazy-capabilities"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=["name","keyType","defaultUser","adminUser","port","allowedUsers","cidrList","excludeCidrList"],o=["name","keyType","allowUserCertificates","allowHostCertificates","defaultUser","allowedUsers","allowedUsersTemplate","allowedDomains","allowedDomainsTemplate","ttl","maxTtl","allowedCriticalOptions","defaultCriticalOptions","allowedExtensions","defaultExtensions","allowBareDomains","allowSubdomains","allowUserKeyIds","keyIdFormat","notBeforeDuration","algorithmSigner"]
var s=t.default.extend({useOpenAPI:!0,getHelpUrl:function(e){return`/v1/${e}/roles/example?help=1`},zeroAddress:(0,t.attr)("boolean",{readOnly:!0}),backend:(0,t.attr)("string",{readOnly:!0}),name:(0,t.attr)("string",{label:"Role Name",fieldValue:"name",readOnly:!0}),keyType:(0,t.attr)("string",{possibleValues:["ca","otp"]}),adminUser:(0,t.attr)("string",{helpText:"Username of the admin user at the remote host"}),defaultUser:(0,t.attr)("string",{helpText:"Username to use when one isn't specified"}),allowedUsers:(0,t.attr)("string",{helpText:"Create a list of users who are allowed to use this key (e.g. `admin, dev`, or use `*` to allow all.)"}),allowedUsersTemplate:(0,t.attr)("boolean",{helpText:"Specifies that Allowed Users can be templated e.g. {{identity.entity.aliases.mount_accessor_xyz.name}}"}),allowedDomains:(0,t.attr)("string",{helpText:"List of domains for which a client can request a certificate (e.g. `example.com`, or `*` to allow all)"}),allowedDomainsTemplate:(0,t.attr)("boolean",{helpText:"Specifies that Allowed Domains can be set using identity template policies. Non-templated domains are also permitted."}),cidrList:(0,t.attr)("string",{helpText:"List of CIDR blocks for which this role is applicable"}),excludeCidrList:(0,t.attr)("string",{helpText:"List of CIDR blocks that are not accepted by this role"}),port:(0,t.attr)("number",{helpText:"Port number for the SSH connection (default is `22`)"}),allowedCriticalOptions:(0,t.attr)("string",{helpText:"List of critical options that certificates have when signed"}),defaultCriticalOptions:(0,t.attr)("object",{helpText:"Map of critical options certificates should have if none are provided when signing"}),allowedExtensions:(0,t.attr)("string",{helpText:"List of extensions that certificates can have when signed"}),defaultExtensions:(0,t.attr)("object",{helpText:"Map of extensions certificates should have if none are provided when signing"}),allowUserCertificates:(0,t.attr)("boolean",{helpText:"Specifies if certificates are allowed to be signed for us as a user"}),allowHostCertificates:(0,t.attr)("boolean",{helpText:"Specifies if certificates are allowed to be signed for us as a host"}),allowBareDomains:(0,t.attr)("boolean",{helpText:"Specifies if host certificates that are requested are allowed to use the base domains listed in Allowed Domains"}),allowSubdomains:(0,t.attr)("boolean",{helpText:"Specifies if host certificates that are requested are allowed to be subdomains of those listed in Allowed Domains"}),allowUserKeyIds:(0,t.attr)("boolean",{helpText:'Specifies if users can override the key ID for a signed certificate with the "key_id" field'}),keyIdFormat:(0,t.attr)("string",{helpText:"When supplied, this value specifies a custom format for the key id of a signed certificate"}),algorithmSigner:(0,t.attr)("string",{helpText:"When supplied, this value specifies a signing algorithm for the key",possibleValues:["default","ssh-rsa","rsa-sha2-256","rsa-sha2-512"]}),showFields:(0,l.computed)("keyType",(function(){const e="ca"===this.keyType?o.slice(0):r.slice(0)
return(0,a.expandAttributeMeta)(this,e)})),fieldGroups:(0,l.computed)("keyType",(function(){const e="otp"===this.keyType?3:4,t="otp"===this.keyType?[...r]:[...o],n=[{default:t.splice(0,e)},{Options:[...t]}]
return(0,a.default)(this,n)})),updatePath:(0,i.default)(i.apiPath`${"backend"}/roles/${"id"}`,"backend","id"),canDelete:(0,n.alias)("updatePath.canDelete"),canEdit:(0,n.alias)("updatePath.canUpdate"),canRead:(0,n.alias)("updatePath.canRead"),generatePath:(0,i.default)(i.apiPath`${"backend"}/creds/${"id"}`,"backend","id"),canGenerate:(0,n.alias)("generatePath.canUpdate"),signPath:(0,i.default)(i.apiPath`${"backend"}/sign/${"id"}`,"backend","id"),canSign:(0,n.alias)("signPath.canUpdate"),zeroAddressPath:(0,i.default)(i.apiPath`${"backend"}/config/zeroaddress`,"backend"),canEditZeroAddress:(0,n.alias)("zeroAddressPath.canUpdate")})
e.default=s})),define("vault/models/secret-engine",["exports","@ember-data/model","vault/decorators/model-validations","vault/decorators/model-expanded-attributes","vault/helpers/supported-secret-backends","vault/helpers/mountable-secret-engines"],(function(e,t,n,l,a,i){var r,o,s,u,d,c,p,m,f,h,b,y,v,g,w,k,x,_,P,T,O,j,M,z,S,C,A,R,D,E,N,F,I,L,V,U,$,q
function K(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function B(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const G=(0,a.supportedSecretBackends)(),W=["system","identity"]
let H=(r=(0,n.withModelValidations)({path:[{type:"presence",message:"Path can't be blank."},{type:"containsWhiteSpace",message:"Path contains whitespace. If this is desired, you'll need to encode it with %20 in API requests.",level:"warn"}],maxVersions:[{type:"number",message:"Maximum versions must be a number."},{type:"length",options:{min:1,max:16},message:"You cannot go over 16 characters."}]}),o=(0,l.withExpandedAttributes)(),s=(0,t.attr)("string"),u=(0,t.attr)("string"),d=(0,t.attr)("string",{editType:"textarea"}),c=(0,t.belongsTo)("mount-config",{async:!1,inverse:null}),p=(0,t.attr)("boolean",{helpText:"When Replication is enabled, a local mount will not be replicated across clusters. This can only be specified at mount time."}),m=(0,t.attr)("boolean",{helpText:"When enabled - if a seal supporting seal wrapping is specified in the configuration, all critical security parameters (CSPs) in this backend will be seal wrapped. (For K/V mounts, all values will be seal wrapped.) This can only be specified at mount time."}),f=(0,t.attr)("boolean"),h=(0,t.attr)("number",{label:"Version",helpText:"The KV Secrets Engine can operate in different modes. Version 1 is the original generic Secrets Engine the allows for storing of static key/value pairs. Version 2 added more features including data versioning, TTLs, and check and set.",possibleValues:[2,1],defaultFormValue:2}),b=(0,t.attr)("string"),y=(0,t.attr)("string"),v=(0,t.attr)("boolean",{defaultValue:!0}),g=(0,t.attr)("string"),w=(0,t.attr)("string"),k=(0,t.attr)("string"),x=(0,t.attr)("number",{defaultValue:0,label:"Maximum number of versions",subText:"The number of versions to keep per key. Once the number of keys exceeds the maximum number set here, the oldest version will be permanently deleted. This value applies to all keys, but a key’s metadata settings can overwrite this value. When 0 is used or the value is unset, Vault will keep 10 versions."}),_=(0,t.attr)("boolean",{defaultValue:!1,label:"Require Check and Set",subText:"If checked, all keys will require the cas parameter to be set on all write requests. A key’s metadata settings can overwrite this value."}),P=(0,t.attr)({defaultValue:0,editType:"ttl",label:"Automate secret deletion",helperTextDisabled:"A secret’s version must be manually deleted.",helperTextEnabled:"Delete all new versions of this secret after"}),r(T=o((O=class extends t.default{constructor(){super(...arguments),K(this,"path",j,this),K(this,"type",M,this),K(this,"description",z,this),K(this,"config",S,this),K(this,"local",C,this),K(this,"sealWrap",A,this),K(this,"externalEntropyAccess",R,this),K(this,"version",D,this),K(this,"privateKey",E,this),K(this,"publicKey",N,this),K(this,"generateSigningKey",F,this),K(this,"lease",I,this),K(this,"leaseMax",L,this),K(this,"accessor",V,this),K(this,"maxVersions",U,this),K(this,"casRequired",$,this),K(this,"deleteVersionAfter",q,this)}get modelTypeForKV(){const e=this.engineType
return"kv"!==e&&"generic"!==e||2!==this.version?"secret":"secret-v2"}get isV2KV(){return"secret-v2"===this.modelTypeForKV}get attrs(){return this.formFields.map((e=>this.allByKey[e]))}get fieldGroups(){return this._expandGroups(this.formFieldGroups)}get icon(){const e=this.engineType||"secrets"
return{keymgmt:"key",kmip:"secrets",ldap:"folder-users"}[this.engineType]||e}get engineType(){return(this.type||"").replace(/^ns_/,"")}get shouldIncludeInList(){return!W.includes(this.engineType)}get isSupportedBackend(){return G.includes(this.engineType)}get backendLink(){if("database"===this.engineType)return"vault.cluster.secrets.backend.overview"
if((0,i.isAddonEngine)(this.engineType,this.version)){const{engineRoute:e}=(0,i.allEngines)().findBy("type",this.engineType)
return`vault.cluster.secrets.backend.${e}`}return"vault.cluster.secrets.backend.list-root"}get localDisplay(){return this.local?"local":"replicated"}get formFields(){const e=this.engineType,t=["type","path","description","accessor","local","sealWrap"]
return"keymgmt"!==e&&t.push("config.defaultLeaseTtl","config.maxLeaseTtl"),t.push("config.allowedManagedKeys","config.auditNonHmacRequestKeys","config.auditNonHmacResponseKeys","config.passthroughRequestHeaders","config.allowedResponseHeaders"),"kv"!==e&&"generic"!==e||t.push("version"),"kv"===e&&2===parseInt(this.version,10)&&t.push("casRequired","deleteVersionAfter","maxVersions"),t}get formFieldGroups(){let e,t=["path"]
const n=["description","config.listingVisibility","local","sealWrap"],l=["config.auditNonHmacRequestKeys","config.auditNonHmacResponseKeys","config.passthroughRequestHeaders","config.allowedResponseHeaders"]
switch(this.engineType){case"kv":t=["path","maxVersions","casRequired","deleteVersionAfter"],e=["version",...n,"config.defaultLeaseTtl","config.maxLeaseTtl","config.allowedManagedKeys",...l]
break
case"generic":e=["version",...n,"config.defaultLeaseTtl","config.maxLeaseTtl","config.allowedManagedKeys",...l]
break
case"database":t=["path","config.defaultLeaseTtl","config.maxLeaseTtl"],e=[...n,"config.allowedManagedKeys",...l]
break
case"pki":t=["path","config.defaultLeaseTtl","config.maxLeaseTtl","config.allowedManagedKeys"],e=[...n,...l]
break
case"keymgmt":e=[...n,"config.allowedManagedKeys",...l]
break
default:t=["path"],e=[...n,"config.defaultLeaseTtl","config.maxLeaseTtl","config.allowedManagedKeys",...l]}return[{default:t},{"Method Options":e}]}saveCA(e){if("ssh"===this.type)return e.isDelete&&(this.privateKey=null,this.publicKey=null,this.generateSigningKey=!1),this.save({adapterOptions:{options:e,apiPath:"config/ca",attrsToSend:["privateKey","publicKey","generateSigningKey"]}})}saveZeroAddressConfig(){return this.save({adapterOptions:{adapterMethod:"saveZeroAddressConfig"}})}},j=B(O.prototype,"path",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),M=B(O.prototype,"type",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),z=B(O.prototype,"description",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),S=B(O.prototype,"config",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),C=B(O.prototype,"local",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),A=B(O.prototype,"sealWrap",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),R=B(O.prototype,"externalEntropyAccess",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),D=B(O.prototype,"version",[h],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),E=B(O.prototype,"privateKey",[b],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),N=B(O.prototype,"publicKey",[y],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),F=B(O.prototype,"generateSigningKey",[v],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),I=B(O.prototype,"lease",[g],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),L=B(O.prototype,"leaseMax",[w],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),V=B(O.prototype,"accessor",[k],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),U=B(O.prototype,"maxVersions",[x],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),$=B(O.prototype,"casRequired",[_],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),q=B(O.prototype,"deleteVersionAfter",[P],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T=O))||T)||T)
e.default=H})),define("vault/models/secret-v2-version",["exports","@ember-data/model","core/utils/timestamp","vault/models/secret"],(function(e,t,n,l){var a,i,r,o,s,u,d,c,p,m,f,h,b,y,v,g,w
function k(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function x(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let _=(a=(0,t.attr)("boolean"),i=(0,t.attr)("number"),r=(0,t.attr)("string"),o=(0,t.attr)("string"),s=(0,t.attr)("string"),u=(0,t.attr)("boolean"),d=(0,t.attr)("number"),c=(0,t.belongsTo)("secret-v2"),p=class extends l.default{constructor(){var e,t,n
super(...arguments),k(this,"failedServerRead",m,this),k(this,"version",f,this),k(this,"path",h,this),k(this,"deletionTime",b,this),k(this,"createdTime",y,this),k(this,"destroyed",v,this),k(this,"currentVersion",g,this),k(this,"secret",w,this),n="path",(t="pathAttr")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}get deleted(){return new Date(this.deletionTime)<=n.default.now()}},m=x(p.prototype,"failedServerRead",[a],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=x(p.prototype,"version",[i],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=x(p.prototype,"path",[r],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=x(p.prototype,"deletionTime",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=x(p.prototype,"createdTime",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),v=x(p.prototype,"destroyed",[u],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g=x(p.prototype,"currentVersion",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=x(p.prototype,"secret",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p)
e.default=_})),define("vault/models/secret-v2",["exports","@ember-data/model","@ember/object","@ember/object/computed","vault/utils/field-to-attrs","vault/mixins/key-mixin","vault/macros/lazy-capabilities","vault/decorators/model-validations"],(function(e,t,n,l,a,i,r,o){var s
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var u=((0,o.withModelValidations)({maxVersions:[{type:"number",message:"Maximum versions must be a number."},{type:"length",options:{min:1,max:16},message:"You cannot go over 16 characters."}]})(s=class extends t.default{})||s).extend(i.default,{failedServerRead:(0,t.attr)("boolean"),engine:(0,t.belongsTo)("secret-engine",{async:!1}),engineId:(0,t.attr)("string"),versions:(0,t.hasMany)("secret-v2-version",{async:!1,inverse:null}),selectedVersion:(0,t.belongsTo)("secret-v2-version",{async:!1,inverse:"secret"}),createdTime:(0,t.attr)(),updatedTime:(0,t.attr)(),currentVersion:(0,t.attr)("number"),oldestVersion:(0,t.attr)("number"),customMetadata:(0,t.attr)("object",{editType:"kv",subText:"An optional set of informational key-value pairs that will be stored with all secret versions."}),maxVersions:(0,t.attr)("number",{defaultValue:0,label:"Maximum number of versions",subText:"The number of versions to keep per key. Once the number of keys exceeds the maximum number set here, the oldest version will be permanently deleted."}),casRequired:(0,t.attr)("boolean",{defaultValue:!1,label:"Require Check and Set",subText:"Writes will only be allowed if the key’s current version matches the version specified in the cas parameter."}),deleteVersionAfter:(0,t.attr)({defaultValue:0,editType:"ttl",label:"Automate secret deletion",helperTextDisabled:"A secret’s version must be manually deleted.",helperTextEnabled:"Delete all new versions of this secret after"}),fields:(0,n.computed)((function(){return(0,a.expandAttributeMeta)(this,["customMetadata","maxVersions","casRequired","deleteVersionAfter"])})),secretDataPath:(0,r.default)(r.apiPath`${"engineId"}/data/${"id"}`,"engineId","id"),secretMetadataPath:(0,r.default)(r.apiPath`${"engineId"}/metadata/${"id"}`,"engineId","id"),secretUndeletePath:(0,r.default)(r.apiPath`${"engineId"}/undelete/${"id"}`,"engineId","id"),secretDeletePath:(0,r.default)(r.apiPath`${"engineId"}/delete/${"id"}`,"engineId","id"),secretDestroyPath:(0,r.default)(r.apiPath`${"engineId"}/destroy/${"id"}`,"engineId","id"),canListMetadata:(0,l.alias)("secretMetadataPath.canList"),canReadMetadata:(0,l.alias)("secretMetadataPath.canRead"),canUpdateMetadata:(0,l.alias)("secretMetadataPath.canUpdate"),canReadSecretData:(0,l.alias)("secretDataPath.canRead"),canEditSecretData:(0,l.alias)("secretDataPath.canUpdate"),canDeleteSecretData:(0,l.alias)("secretDataPath.canDelete"),canUndelete:(0,l.alias)("secretUndeletePath.canUpdate"),canDestroyVersion:(0,l.alias)("secretDestroyPath.canUpdate"),canDestroyAllVersions:(0,l.alias)("secretMetadataPath.canDelete"),canSoftDeleteSecretData:(0,l.alias)("secretDeletePath.canUpdate")})
e.default=u})),define("vault/models/secret",["exports","@ember-data/model","@ember/object","@ember/object/computed","vault/mixins/key-mixin","vault/macros/lazy-capabilities"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=t.default.extend(a.default,{failedServerRead:(0,t.attr)("boolean"),auth:(0,t.attr)("string"),lease_duration:(0,t.attr)("number"),lease_id:(0,t.attr)("string"),renewable:(0,t.attr)("boolean"),secretData:(0,t.attr)("object"),secretKeyAndValue:(0,n.computed)("secretData",(function(){const e=this.secretData
return Object.keys(e).map((t=>({key:t,value:e[t]})))})),dataAsJSONString:(0,n.computed)("secretData",(function(){return JSON.stringify(this.secretData,null,2)})),isAdvancedFormat:(0,n.computed)("secretData",(function(){const e=this.secretData
return e&&Object.keys(e).some((t=>"string"!=typeof e[t]))})),helpText:(0,t.attr)("string"),backend:(0,t.attr)("string"),secretPath:(0,i.default)(i.apiPath`${"backend"}/${"id"}`,"backend","id"),canEdit:(0,l.alias)("secretPath.canUpdate"),canDelete:(0,l.alias)("secretPath.canDelete"),canRead:(0,l.alias)("secretPath.canRead")})
e.default=r})),define("vault/models/server",["exports","@ember-data/model"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({address:(0,t.attr)("string"),nodeId:(0,t.attr)("string"),protocolVersion:(0,t.attr)("string"),voter:(0,t.attr)("boolean"),leader:(0,t.attr)("boolean")})
e.default=n})),define("vault/models/ssh-otp-credential",["exports","@ember/object/computed","@ember-data/model","@ember/object","vault/utils/field-to-attrs"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=["username","ip"],r=["username","ip","key","keyType","port"]
var o=n.default.extend({role:(0,n.attr)("object",{readOnly:!0}),ip:(0,n.attr)("string",{label:"IP Address"}),username:(0,n.attr)("string"),key:(0,n.attr)("string"),keyType:(0,n.attr)("string"),port:(0,n.attr)("number"),attrs:(0,l.computed)("key",(function(){const e=this.key?r.slice(0):i.slice(0)
return(0,a.expandAttributeMeta)(this,e)})),toCreds:(0,t.reads)("key")})
e.default=o})),define("vault/models/ssh-sign",["exports","@ember-data/model","@ember/object","vault/utils/field-to-attrs"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const a=["publicKey","keyId","validPrincipals","certType","criticalOptions","extensions","ttl"],i=["signedKey","leaseId","renewable","leaseDuration","serialNumber"]
var r=t.default.extend({role:(0,t.attr)("object",{readOnly:!0}),publicKey:(0,t.attr)("string",{label:"Public Key",editType:"textarea"}),ttl:(0,t.attr)({label:"TTL",editType:"ttl"}),validPrincipals:(0,t.attr)("string"),certType:(0,t.attr)("string",{defaultValue:"user",label:"Certificate Type",possibleValues:["user","host"]}),keyId:(0,t.attr)("string",{label:"Key ID"}),criticalOptions:(0,t.attr)("object"),extensions:(0,t.attr)("object"),leaseId:(0,t.attr)("string",{label:"Lease ID"}),renewable:(0,t.attr)("boolean"),leaseDuration:(0,t.attr)("number"),serialNumber:(0,t.attr)("string"),signedKey:(0,t.attr)("string"),attrs:(0,n.computed)("signedKey",(function(){const e=this.signedKey?i.slice(0):a.slice(0)
return(0,l.expandAttributeMeta)(this,e)}))})
e.default=r})),define("vault/models/test-form-model",["exports","vault/models/auth-method","@ember-data/model"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend({otherConfig:(0,n.belongsTo)("mount-config",{async:!1,inverse:null})})
e.default=l})),define("vault/models/transform",["exports","@ember-data/model","@ember/object","vault/macros/lazy-capabilities","vault/utils/field-to-attrs"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=t.default.extend({name:(0,t.attr)("string",{label:"Name",readOnly:!0,subText:"The name for your transformation. This cannot be edited later."}),type:(0,t.attr)("string",{defaultValue:"fpe",label:"Type",possibleValues:[{value:"fpe",displayName:"Format Preserving Encryption (FPE)"},{value:"masking",displayName:"Masking"},{value:"tokenization",displayName:"Tokenization"}],subText:"Vault provides two types of transformations: Format Preserving Encryption (FPE) is reversible, while Masking is not. This cannot be edited later."}),tweak_source:(0,t.attr)("string",{defaultValue:"supplied",label:"Tweak source",possibleValues:[{value:"supplied",displayName:"supplied"},{value:"generated",displayName:"generated"},{value:"internal",displayName:"internal"}],subText:"A tweak value is used when performing FPE transformations. This can be supplied, generated, or internal."}),masking_character:(0,t.attr)("string",{characterLimit:1,defaultValue:"*",label:"Masking character",subText:"Specify which character you’d like to mask your data."}),template:(0,t.attr)("array",{editType:"searchSelect",isSectionHeader:!0,fallbackComponent:"string-list",label:"Template",models:["transform/template"],selectLimit:1,onlyAllowExisting:!0,subText:"Templates allow Vault to determine what and how to capture the value to be transformed. Type to use an existing template or create a new one."}),allowed_roles:(0,t.attr)("array",{editType:"searchSelect",isSectionHeader:!0,label:"Allowed roles",fallbackComponent:"string-list",models:["transform/role"],subText:"Search for an existing role, type a new role to create it, or use a wildcard (*).",wildcardLabel:"role"}),deletion_allowed:(0,t.attr)("boolean",{label:"Allow deletion",subText:"If checked, this transform can be deleted otherwise deletion is blocked. Note that deleting the transform deletes the underlying key which makes decoding of tokenized values impossible without restoring from a backup."}),convergent:(0,t.attr)("boolean",{label:"Use convergent tokenization",subText:"This cannot be edited later. If checked, tokenization of the same plaintext more than once results in the same token. Defaults to false as unique tokens are more desirable from a security standpoint if there isn't a use-case need for convergence."}),stores:(0,t.attr)("array",{label:"Stores",editType:"stringArray",subText:"The list of tokenization stores to use for tokenization state. Vault's internal storage is used by default."}),mapping_mode:(0,t.attr)("string",{defaultValue:"default",subText:'Specifies the mapping mode for stored tokenization values. "default" is strongly recommended for highest security, "exportable" allows for all plaintexts to be decoded via the export-decoded endpoint in an emergency.'}),max_ttl:(0,t.attr)({editType:"ttl",defaultValue:"0",label:"Maximum TTL (time-to-live) of a token",helperTextDisabled:'If "0" or unspecified, tokens may have no expiration.'}),transformAttrs:(0,n.computed)("type",(function(){const e=["name","type","deletion_allowed"]
switch(this.type){case"fpe":return[...e,"tweak_source","template","allowed_roles"]
case"masking":return[...e,"masking_character","template","allowed_roles"]
case"tokenization":return[...e,"mapping_mode","convergent","max_ttl","stores","allowed_roles"]
default:return[...e]}})),transformFieldAttrs:(0,n.computed)("transformAttrs",(function(){return(0,a.expandAttributeMeta)(this,this.transformAttrs)})),backend:(0,t.attr)("string",{readOnly:!0}),updatePath:(0,l.default)(l.apiPath`${"backend"}/transformation/${"id"}`,"backend","id")})
e.default=i})),define("vault/models/transform/alphabet",["exports","@ember-data/model","@ember/object","vault/macros/lazy-capabilities","vault/utils/field-to-attrs"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=t.default.extend({idPrefix:"alphabet/",idForNav:(0,n.computed)("id","idPrefix",(function(){const e=this.id||""
return`${this.idPrefix}${e}`})),name:(0,t.attr)("string",{readOnly:!0,subText:"The alphabet name. Keep in mind that spaces are not allowed and this cannot be edited later."}),alphabet:(0,t.attr)("string",{label:"Alphabet",subText:"Provide the set of valid UTF-8 characters contained within both the input and transformed value. Read more."}),attrs:(0,n.computed)((function(){return(0,a.expandAttributeMeta)(this,["name","alphabet"])})),backend:(0,t.attr)("string",{readOnly:!0}),updatePath:(0,l.default)(l.apiPath`${"backend"}/alphabet/${"id"}`,"backend","id")})
e.default=i})),define("vault/models/transform/role",["exports","@ember-data/model","@ember/object","vault/macros/lazy-capabilities","vault/utils/field-to-attrs"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=t.default.extend({idPrefix:"role/",idForNav:(0,n.computed)("id","idPrefix",(function(){const e=this.id||""
return`${this.idPrefix}${e}`})),name:(0,t.attr)("string",{label:"Name",readOnly:!0,subText:"The name for your role. This cannot be edited later."}),transformations:(0,t.attr)("array",{editType:"searchSelect",isSectionHeader:!0,fallbackComponent:"string-list",label:"Transformations",models:["transform"],onlyAllowExisting:!0,subText:"Select which transformations this role will have access to. It must already exist."}),attrs:(0,n.computed)("transformations",(function(){return(0,a.expandAttributeMeta)(this,["name","transformations"])})),backend:(0,t.attr)("string",{readOnly:!0}),updatePath:(0,l.default)(l.apiPath`${"backend"}/role/${"id"}`,"backend","id")})
e.default=i})),define("vault/models/transform/template",["exports","@ember-data/model","@ember/object","vault/macros/lazy-capabilities","vault/utils/field-to-attrs"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=t.default.extend({idPrefix:"template/",idForNav:(0,n.computed)("id","idPrefix",(function(){const e=this.id||""
return`${this.idPrefix}${e}`})),name:(0,t.attr)("string",{readOnly:!0,subText:"Templates allow Vault to determine what and how to capture the value to be transformed. This cannot be edited later."}),type:(0,t.attr)("string",{defaultValue:"regex"}),pattern:(0,t.attr)("string",{editType:"regex",subText:"The template’s pattern defines the data format. Expressed in regex."}),alphabet:(0,t.attr)("array",{subText:"Alphabet defines a set of characters (UTF-8) that is used for FPE to determine the validity of plaintext and ciphertext values. You can choose a built-in one, or create your own.",editType:"searchSelect",isSectionHeader:!0,fallbackComponent:"string-list",label:"Alphabet",models:["transform/alphabet"],selectLimit:1}),encodeFormat:(0,t.attr)("string"),decodeFormats:(0,t.attr)(),backend:(0,t.attr)("string",{readOnly:!0}),readAttrs:(0,n.computed)((function(){return(0,a.expandAttributeMeta)(this,["name","pattern","encodeFormat","decodeFormats","alphabet"])})),writeAttrs:(0,n.computed)((function(){return(0,a.expandAttributeMeta)(this,["name","pattern","alphabet"])})),updatePath:(0,l.default)(l.apiPath`${"backend"}/template/${"id"}`,"backend","id")})
e.default=i})),define("vault/models/transit-key",["exports","@ember-data/model","@ember/object/computed","@ember/object","vault/utils/clamp","vault/macros/lazy-capabilities"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r={encrypt:{isSupported:"supportsEncryption",description:"Looks up wrapping properties for the given token",glyph:"lock-fill"},decrypt:{isSupported:"supportsDecryption",description:"Decrypts the provided ciphertext using this key",glyph:"mail-open"},datakey:{isSupported:"supportsEncryption",description:"Generates a new key and value encrypted with this key",glyph:"key"},rewrap:{isSupported:"supportsEncryption",description:"Rewraps the ciphertext using the latest version of the named key",glyph:"reload"},sign:{isSupported:"supportsSigning",description:"Get the cryptographic signature of the given data",glyph:"pencil-tool"},hmac:{isSupported:!0,description:"Generate a data digest using a hash algorithm",glyph:"shuffle"},verify:{isSupported:!0,description:"Validate the provided signature for the given data",glyph:"check-circle"},export:{isSupported:"exportable",description:"Get the named key",glyph:"external-link"}}
var o=t.default.extend({type:(0,t.attr)("string",{defaultValue:"aes256-gcm96"}),name:(0,t.attr)("string",{label:"Name",readOnly:!0}),autoRotatePeriod:(0,t.attr)({defaultValue:"0",defaultShown:"Key is not automatically rotated",editType:"ttl",label:"Auto-rotation period"}),deletionAllowed:(0,t.attr)("boolean"),derived:(0,t.attr)("boolean"),exportable:(0,t.attr)("boolean"),minDecryptionVersion:(0,t.attr)("number",{defaultValue:1}),minEncryptionVersion:(0,t.attr)("number",{defaultValue:0}),latestVersion:(0,t.attr)("number"),keys:(0,t.attr)("object"),convergentEncryption:(0,t.attr)("boolean"),convergentEncryptionVersion:(0,t.attr)("number"),supportsSigning:(0,t.attr)("boolean"),supportsEncryption:(0,t.attr)("boolean"),supportsDecryption:(0,t.attr)("boolean"),supportsDerivation:(0,t.attr)("boolean"),setConvergentEncryption(e){!0===e&&(0,l.set)(this,"derived",e),(0,l.set)(this,"convergentEncryption",e)},setDerived(e){!1===e&&(0,l.set)(this,"convergentEncryption",e),(0,l.set)(this,"derived",e)},supportedActions:(0,l.computed)("type",(function(){return Object.keys(r).filter((e=>{const{isSupported:t}=r[e]
return"boolean"==typeof t||(0,l.get)(this,t)})).map((e=>{const{description:t,glyph:n}=r[e]
return{name:e,description:t,glyph:n}}))})),canDelete:(0,l.computed)("deletionAllowed","lastLoadTS",(function(){const e=Boolean(this.changedAttributes().deletionAllowed)
return this.deletionAllowed&&!1===e})),keyVersions:(0,l.computed)("validKeyVersions",(function(){let e=Math.max(...this.validKeyVersions)
const t=[]
for(;e>0;)t.unshift(e),e--
return t})),encryptionKeyVersions:(0,l.computed)("keyVerisons","keyVersions","latestVersion","minDecryptionVersion",(function(){const{keyVersions:e,minDecryptionVersion:t}=this
return e.filter((e=>e>=t)).reverse()})),keysForEncryption:(0,l.computed)("minEncryptionVersion","latestVersion",(function(){let{minEncryptionVersion:e,latestVersion:t}=this
const n=(0,a.default)(e-1,0,t),l=[]
for(;t>n;)l.push(t),t--
return l})),validKeyVersions:(0,l.computed)("keys",(function(){return Object.keys(this.keys)})),exportKeyTypes:(0,l.computed)("exportable","supportsEncryption","supportsSigning","type",(function(){const e=["hmac"]
return this.supportsSigning&&e.unshift("signing"),this.supportsEncryption&&e.unshift("encryption"),e})),backend:(0,t.attr)("string"),rotatePath:(0,i.default)(i.apiPath`${"backend"}/keys/${"id"}/rotate`,"backend","id"),canRotate:(0,n.alias)("rotatePath.canUpdate"),secretPath:(0,i.default)(i.apiPath`${"backend"}/keys/${"id"}`,"backend","id"),canRead:(0,n.alias)("secretPath.canUpdate"),canEdit:(0,n.alias)("secretPath.canUpdate")})
e.default=o})),define("vault/modifiers/basic-dropdown-trigger",["exports","ember-basic-dropdown/modifiers/basic-dropdown-trigger"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/modifiers/code-mirror",["exports","core/modifiers/code-mirror"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/modifiers/did-insert",["exports","@ember/render-modifiers/modifiers/did-insert"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/modifiers/did-update",["exports","@ember/render-modifiers/modifiers/did-update"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/modifiers/focus-trap",["exports","ember-focus-trap/modifiers/focus-trap.js"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/modifiers/hds-tooltip",["exports","@hashicorp/design-system-components/modifiers/hds-tooltip"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/modifiers/on-key",["exports","ember-keyboard/modifiers/on-key.js"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/modifiers/style",["exports","ember-style-modifier/modifiers/style"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/modifiers/will-destroy",["exports","@ember/render-modifiers/modifiers/will-destroy"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/router",["exports","@ember/routing/router","vault/config/environment"],(function(e,t,n){function l(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class a extends t.default{constructor(){super(...arguments),l(this,"location",n.default.locationType),l(this,"rootURL",n.default.rootURL)}}e.default=a,a.map((function(){this.route("vault",{path:"/"},(function(){this.route("cluster",{path:"/:cluster_name"},(function(){this.route("dashboard"),this.route("oidc-provider-ns",{path:"/*namespace/identity/oidc/provider/:provider_name/authorize"}),this.route("oidc-provider",{path:"/identity/oidc/provider/:provider_name/authorize"}),this.route("oidc-callback",{path:"/auth/*auth_path/oidc/callback"}),this.route("auth"),this.route("redirect"),this.route("init"),this.route("logout"),this.route("license"),this.route("mfa-setup"),this.route("clients",(function(){this.route("dashboard"),this.route("config"),this.route("edit")})),this.route("storage",{path:"/storage/raft"}),this.route("storage-restore",{path:"/storage/raft/restore"}),this.route("settings",(function(){this.route("index",{path:"/"}),this.route("seal"),this.route("auth",(function(){this.route("index",{path:"/"}),this.route("enable"),this.route("configure",{path:"/configure/:method"},(function(){this.route("index",{path:"/"}),this.route("section",{path:"/:section_name"})}))})),this.route("mount-secret-backend"),this.route("configure-secret-backend",{path:"/secrets/configure/:backend"},(function(){this.route("index",{path:"/"}),this.route("section",{path:"/:section_name"})}))})),this.route("unseal"),this.route("tools",(function(){this.route("tool",{path:"/:selected_action"}),this.mount("open-api-explorer",{path:"/api-explorer"})})),this.route("access",(function(){this.route("methods",{path:"/"}),this.route("method",{path:"/:path"},(function(){this.route("index",{path:"/"}),this.route("item",{path:"/item/:item_type"},(function(){this.route("list",{path:"/"}),this.route("create"),this.route("edit",{path:"/edit/:item_id"}),this.route("show",{path:"/show/:item_id"})})),this.route("section",{path:"/:section_name"})})),this.route("mfa",(function(){this.route("index",{path:"/"}),this.route("methods",(function(){this.route("index",{path:"/"}),this.route("create"),this.route("method",{path:"/:id"},(function(){this.route("edit"),this.route("enforcements")}))})),this.route("enforcements",(function(){this.route("index",{path:"/"}),this.route("create"),this.route("enforcement",{path:"/:name"},(function(){this.route("edit")}))}))})),this.route("leases",(function(){this.route("index",{path:"/"}),this.route("list-root",{path:"/list/"}),this.route("list",{path:"/list/*prefix"}),this.route("show",{path:"/show/*lease_id"})})),this.route("identity",{path:"/identity/:item_type"},(function(){this.route("index",{path:"/"}),this.route("create"),this.route("merge"),this.route("edit",{path:"/edit/:item_id"}),this.route("show",{path:"/:item_id/:section"}),this.route("aliases",(function(){this.route("index",{path:"/"}),this.route("add",{path:"/add/:item_id"}),this.route("edit",{path:"/edit/:item_alias_id"}),this.route("show",{path:"/:item_alias_id/:section"})}))})),this.route("control-groups"),this.route("control-groups-configure",{path:"/control-groups/configure"}),this.route("control-group-accessor",{path:"/control-groups/:accessor"}),this.route("namespaces",(function(){this.route("index",{path:"/"}),this.route("create")})),this.route("oidc",(function(){this.route("clients",(function(){this.route("create"),this.route("client",{path:"/:name"},(function(){this.route("details"),this.route("providers"),this.route("edit")}))})),this.route("keys",(function(){this.route("create"),this.route("key",{path:"/:name"},(function(){this.route("details"),this.route("clients"),this.route("edit")}))})),this.route("assignments",(function(){this.route("create"),this.route("assignment",{path:"/:name"},(function(){this.route("details"),this.route("edit")}))})),this.route("providers",(function(){this.route("create"),this.route("provider",{path:"/:name"},(function(){this.route("details"),this.route("clients"),this.route("edit")}))})),this.route("scopes",(function(){this.route("create"),this.route("scope",{path:"/:name"},(function(){this.route("details"),this.route("edit")}))}))}))})),this.route("secrets",(function(){this.route("backends",{path:"/"}),this.route("backend",{path:"/:backend"},(function(){this.mount("kmip"),this.mount("kubernetes"),this.mount("kv"),this.mount("ldap"),this.mount("pki"),this.route("index",{path:"/"}),this.route("configuration"),this.route("list-root",{path:"/list/"}),this.route("create-root",{path:"/create/"}),this.route("show-root",{path:"/show/"}),this.route("edit-root",{path:"/edit/"}),this.route("list",{path:"/list/*secret"}),this.route("show",{path:"/show/*secret"}),this.route("diff",{path:"/diff/*id"}),this.route("metadata",{path:"/metadata/*secret"}),this.route("edit-metadata",{path:"/edit-metadata/*secret"}),this.route("create",{path:"/create/*secret"}),this.route("edit",{path:"/edit/*secret"}),this.route("credentials-root",{path:"/credentials/"}),this.route("credentials",{path:"/credentials/*secret"}),this.route("versions-root",{path:"/versions/"}),this.route("versions",{path:"/versions/*secret"}),this.route("sign-root",{path:"/sign/"}),this.route("sign",{path:"/sign/*secret"}),this.route("actions-root",{path:"/actions/"}),this.route("actions",{path:"/actions/*secret"}),this.route("overview")}))})),this.route("policies",{path:"/policies/:type"},(function(){this.route("index",{path:"/"}),this.route("create")})),this.route("policy",{path:"/policy/:type"},(function(){this.route("show",{path:"/:policy_name"}),this.route("edit",{path:"/:policy_name/edit"})})),this.route("replication-dr-promote",(function(){this.route("details")})),n.default.addRootMounts&&n.default.addRootMounts.call(this),this.route("not-found",{path:"/*path"})})),this.route("not-found",{path:"/*path"})}))}))})),define("vault/routes/application",["exports","@ember/service","@ember/routing/route","vault/lib/control-group-error"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=n.default.extend({controlGroup:(0,t.inject)(),routing:(0,t.inject)("router"),namespaceService:(0,t.inject)("namespace"),featureFlagService:(0,t.inject)("featureFlag"),actions:{willTransition(){window.scrollTo(0,0)},error(e,t){const n=this.controlGroup
if(e instanceof l.default)return n.handleError(e)
"/v1/sys/wrapping/unwrap"===e.path&&n.unmarkTokenForUnwrap()
const a=this.routing
let i=t.intent.url
const{name:r,contexts:o,queryParams:s}=t.intent
if(!i)try{i=a.urlFor(r,...o||[],{queryParams:s})}catch(u){i=null}return i&&(i=i.replace("/ui","")),e.errorURL=i,s&&this.controllerFor("vault.cluster").set("namespaceQueryParam",s.namespace||""),i&&a.get("location").setURL(i),!0}},async beforeModel(){const e=await fetch("/v1/sys/internal/ui/feature-flags",{method:"GET"})
if(200===e.status){const t=(await e.json()).feature_flags||[]
this.featureFlagService.setFeatureFlags(t)}}})
e.default=a})),define("vault/routes/loading",["exports","@ember/routing/route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({setupController(e){this._super(...arguments)
const t=location.pathname||""
e.set("isCallback",t.includes("oidc/callback"))}})
e.default=n})),define("vault/routes/vault",["exports","@ember/runloop","rsvp","@ember/service","@ember/routing/route","ember"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=i.default.testing?0:300
var o=a.default.extend({store:(0,l.inject)(),version:(0,l.inject)(),beforeModel(){return this.version.fetchVersion()},model(){return this.store.push({data:{id:"1",type:"cluster",attributes:{name:"vault"}}}),new n.Promise((e=>{(0,t.later)((()=>{e(this.store.peekAll("cluster"))}),r)}))},redirect(e,t){if(1===e.get("length")&&"vault.index"===t.targetName)return this.transitionTo("vault.cluster",e.get("firstObject.name"))}})
e.default=o})),define("vault/routes/vault/cluster",["exports","@ember/service","@ember/object","rsvp","@ember/routing/route","ember-concurrency","ember","vault/lib/token-storage","vault/lib/local-storage","vault/mixins/cluster-route","vault/mixins/model-boundary-route","@ember/debug"],(function(e,t,n,l,a,i,r,o,s,u,d,c){Object.defineProperty(e,"__esModule",{value:!0}),e.getManagedNamespace=e.default=void 0
const p=(e,t)=>e&&e.replaceAll("/","")!==t?e.startsWith(`${t}/`)?e:`${t}/${e}`:t
e.getManagedNamespace=p
var m=a.default.extend(d.default,u.default,{namespaceService:(0,t.inject)("namespace"),version:(0,t.inject)(),permissions:(0,t.inject)(),store:(0,t.inject)(),auth:(0,t.inject)(),featureFlagService:(0,t.inject)("featureFlag"),currentCluster:(0,t.inject)(),modelTypes:(0,n.computed)((function(){return["node","secret","secret-engine"]})),queryParams:{namespaceQueryParam:{refreshModel:!0}},getClusterId(e){const{cluster_name:t}=e,n=this.modelFor("vault").findBy("name",t)
return n?n.get("id"):null},async beforeModel(){const e=this.paramsFor(this.routeName)
let t=e.namespaceQueryParam
const n=this.auth.get("currentTokenName"),a=this.featureFlagService.managedNamespaceRoot
if(t||!n||r.default.testing){if(null!==a){const e=p(t,a)
e!==t&&this.transitionTo({queryParams:{namespace:e}})}}else{t=(0,o.default)().getItem(n)?.userRootNamespace,t&&this.transitionTo({queryParams:{namespace:t}})}this.namespaceService.setNamespace(t)
const i=this.getClusterId(e)
return i?(this.auth.setCluster(i),this.auth.currentToken&&await this.permissions.getPaths.perform(),this.version.fetchFeatures()):(0,l.reject)({httpStatus:404,message:"not found",path:e.cluster_name})},model(e){s.default.isLocalStorageSupported()
const t=this.getClusterId(e)
return this.store.findRecord("cluster",t)},poll:(0,i.task)((function*(){for(;;){if(r.default.testing)return
yield(0,i.timeout)(1e4)
try{yield this.controller.model.reload(),yield this.transitionToTargetRoute()}catch(e){}}})).cancelOn("deactivate").keepLatest(),afterModel(e,t){return this._super(...arguments),this.currentCluster.setCluster(e),this.namespaceService.path&&!this.version.hasNamespaces?this.transitionTo(this.routeName,{queryParams:{namespace:""}}):this.transitionToTargetRoute(t)},setupController(){this._super(...arguments),this.poll.perform()},actions:{error(e){return 503===e.httpStatus&&"Vault is sealed"===e.errors[0]&&this.refresh(),!0}}})
e.default=m})),define("vault/routes/vault/cluster/access",["exports","@ember/object","@ember/routing/route","vault/mixins/cluster-route","vault/mixins/model-boundary-route"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=n.default.extend(a.default,l.default,{modelTypes:(0,t.computed)((function(){return["capabilities","control-group","identity/group","identity/group-alias","identity/alias"]})),model:()=>({})})
e.default=i})),define("vault/routes/vault/cluster/access/control-group-accessor",["exports","@ember/service","@ember/routing/route","vault/mixins/unload-model-route"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=n.default.extend(l.default,{store:(0,t.inject)(),version:(0,t.inject)(),beforeModel(){return this.version.fetchFeatures().then((()=>this._super(...arguments)))},model(e){return this.version.hasControlGroups?this.store.findRecord("control-group",e.accessor):null},actions:{willTransition:()=>!0,deactivate(){return this.unloadModel(),!0}}})
e.default=a}))
define("vault/routes/vault/cluster/access/control-groups-configure",["exports","@ember/service","@ember/routing/route","vault/mixins/unload-model-route"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=n.default.extend(l.default,{store:(0,t.inject)(),version:(0,t.inject)(),beforeModel(){return this.version.fetchFeatures().then((()=>this._super(...arguments)))},model(){const e="control-group-config"
return this.version.hasControlGroups?this.store.findRecord(e,"config").catch((t=>{if(404===t.httpStatus)return this.store.createRecord(e,{id:"config"})
throw t})):null},actions:{reload(){this.refresh()}}})
e.default=a})),define("vault/routes/vault/cluster/access/control-groups",["exports","@ember/service","@ember/routing/route","vault/mixins/unload-model-route"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=n.default.extend(l.default,{store:(0,t.inject)(),version:(0,t.inject)(),beforeModel(){return this.version.fetchFeatures().then((()=>this._super(...arguments)))},model(){return this.version.hasControlGroups?this.store.createRecord("control-group"):null}})
e.default=a})),define("vault/routes/vault/cluster/access/identity",["exports","@ember-data/adapter/error","@ember/object","@ember/routing/route"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const a={entities:"entity",groups:"group"}
var i=l.default.extend({model(e){const l=a[e.item_type]
if(!l){const e=new t.default
throw(0,n.set)(e,"httpStatus",404),e}return l}})
e.default=i})),define("vault/routes/vault/cluster/access/identity/aliases/add",["exports","@ember/routing/route","vault/mixins/unsaved-model-route","@ember/service"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=t.default.extend(n.default,{store:(0,l.inject)(),model(e){const t=`identity/${this.modelFor("vault.cluster.access.identity")}-alias`
return this.store.createRecord(t,{canonicalId:e.item_id})}})
e.default=a})),define("vault/routes/vault/cluster/access/identity/aliases/edit",["exports","@ember/routing/route","vault/mixins/unsaved-model-route","@ember/service"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=t.default.extend(n.default,{store:(0,l.inject)(),model(e){const t=`identity/${this.modelFor("vault.cluster.access.identity")}-alias`
return this.store.findRecord(t,e.item_alias_id)}})
e.default=a})),define("vault/routes/vault/cluster/access/identity/aliases/index",["exports","@ember/routing/route","core/mixins/list-route","@ember/service"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=t.default.extend(n.default,{store:(0,l.inject)(),model(e){const t=`identity/${this.modelFor("vault.cluster.access.identity")}-alias`
return this.store.lazyPaginatedQuery(t,{responsePath:"data.keys",page:e.page,pageFilter:e.pageFilter,sortBy:"name"}).catch((e=>{if(404===e.httpStatus)return[]
throw e}))},setupController(e){this._super(...arguments),e.set("identityType",this.modelFor("vault.cluster.access.identity"))},actions:{willTransition(e){return window.scrollTo(0,0),e&&e.targetName===this.routeName||this.store.clearAllDatasets(),!0},reload(){this.store.clearAllDatasets(),this.refresh()}}})
e.default=a})),define("vault/routes/vault/cluster/access/identity/aliases/show",["exports","@ember-data/adapter/error","rsvp","@ember/object","@ember/routing/route","vault/helpers/tabs-for-identity-show","@ember/service"],(function(e,t,n,l,a,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var o=a.default.extend({store:(0,r.inject)(),model(e){const{section:a}=e,r=this.modelFor("vault.cluster.access.identity")+"-alias",o=`identity/${r}`
if(!i.TABS[r].includes(a)){const e=new t.default
throw(0,l.set)(e,"httpStatus",404),e}return(0,n.hash)({model:this.store.findRecord(o,e.item_alias_id),section:a})},setupController(e,t){const{model:n,section:l}=t
e.setProperties({model:n,section:l})}})
e.default=o})),define("vault/routes/vault/cluster/access/identity/create",["exports","@ember/routing/route","vault/mixins/unsaved-model-route","@ember/service"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=t.default.extend(n.default,{store:(0,l.inject)(),model(){const e=`identity/${this.modelFor("vault.cluster.access.identity")}`
return this.store.createRecord(e)}})
e.default=a})),define("vault/routes/vault/cluster/access/identity/edit",["exports","@ember/routing/route","vault/mixins/unsaved-model-route","@ember/service"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=t.default.extend(n.default,{store:(0,l.inject)(),model(e){const t=`identity/${this.modelFor("vault.cluster.access.identity")}`
return this.store.findRecord(t,e.item_id)}})
e.default=a})),define("vault/routes/vault/cluster/access/identity/index",["exports","@ember/routing/route","core/mixins/list-route","@ember/service"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=t.default.extend(n.default,{store:(0,l.inject)(),model(e){const t=`identity/${this.modelFor("vault.cluster.access.identity")}`
return this.store.lazyPaginatedQuery(t,{responsePath:"data.keys",page:e.page,pageFilter:e.pageFilter,sortBy:"name"}).catch((e=>{if(404===e.httpStatus)return[]
throw e}))},setupController(e){this._super(...arguments),e.set("identityType",this.modelFor("vault.cluster.access.identity"))},actions:{willTransition(e){return window.scrollTo(0,0),e.targetName!==this.routeName&&this.store.clearAllDatasets(),!0},reload(){this.store.clearAllDatasets(),this.refresh()}}})
e.default=a})),define("vault/routes/vault/cluster/access/identity/merge",["exports","@ember/routing/route","vault/mixins/unload-model-route","@ember/service"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=t.default.extend(n.default,{store:(0,l.inject)(),beforeModel(){if("entity"!==this.modelFor("vault.cluster.access.identity"))return this.transitionTo("vault.cluster.access.identity")},model(){return this.store.createRecord("identity/entity-merge")}})
e.default=a})),define("vault/routes/vault/cluster/access/identity/show",["exports","@ember-data/adapter/error","@ember/runloop","rsvp","@ember/object","@ember/routing/route","vault/helpers/tabs-for-identity-show","@ember/service"],(function(e,t,n,l,a,i,r,o){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var s=i.default.extend({store:(0,o.inject)(),model(e){const{section:n}=e,i=this.modelFor("vault.cluster.access.identity"),o=`identity/${i}`
if(!r.TABS[i].includes(n)){const e=new t.default
throw(0,a.set)(e,"httpStatus",404),e}let s=this.store.peekRecord(o,e.item_id)
return s&&!s.get("creationTime")&&(s=s.reload()),s||(s=this.store.findRecord(o,e.item_id)),(0,l.hash)({model:s,section:n})},activate(){this.currentModel&&(0,n.next)((()=>{this.controller.get("model").reload()}))},afterModel(e){const{section:t,model:n}=e
if("group"===n.get("identityType")&&"internal"===n.get("type")&&"aliases"===t)return this.transitionTo("vault.cluster.access.identity.show",n.id,"details")},setupController(e,t){const{model:n,section:l}=t
e.setProperties({model:n,section:l})}})
e.default=s})),define("vault/routes/vault/cluster/access/leases",["exports","@ember/routing/route","vault/mixins/cluster-route","@ember/service"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=t.default.extend(n.default,{store:(0,l.inject)(),model(){return this.store.findRecord("capabilities","sys/leases/lookup/")}})
e.default=a})),define("vault/routes/vault/cluster/access/leases/index",["exports","@ember/routing/route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({beforeModel(e){return this.modelFor("vault.cluster.access.leases").get("canList")&&e.targetName===this.routeName?this.replaceWith("vault.cluster.access.leases.list-root"):void 0}})
e.default=n})),define("vault/routes/vault/cluster/access/leases/list-root",["exports","vault/routes/vault/cluster/access/leases/list"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/routes/vault/cluster/access/leases/list",["exports","@ember/object","rsvp","@ember/routing/route","@ember/service"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=l.default.extend({store:(0,a.inject)(),queryParams:{page:{refreshModel:!0},pageFilter:{refreshModel:!0}},templateName:"vault/cluster/access/leases/list",model(e){const t=e.prefix||""
if(this.modelFor("vault.cluster.access.leases").get("canList"))return(0,n.hash)({leases:this.store.lazyPaginatedQuery("lease",{prefix:t,responsePath:"data.keys",page:e.page,pageFilter:e.pageFilter}).then((e=>(this.set("has404",!1),e))).catch((e=>{if(404===e.httpStatus&&""===t)return[]
throw e})),capabilities:(0,n.hash)({revokePrefix:this.store.findRecord("capabilities",`sys/leases/revoke-prefix/${t}`),forceRevokePrefix:this.store.findRecord("capabilities",`sys/leases/revoke-force/${t}`)})})},setupController(e,t){const n=this.paramsFor(this.routeName),l=n.prefix?n.prefix:"",a=this.has404
if(e.set("hasModel",!0),e.setProperties({model:t.leases,capabilities:t.capabilities,baseKey:{id:l},has404:a}),!a){const a=n.pageFilter
let i
l?i=l+(a||""):a&&(i=a),e.setProperties({filter:i||"",page:t.leases.get("meta.currentPage")})}},resetController(e,t){this._super(...arguments),t&&e.set("filter","")},actions:{error(e,n){const{prefix:l}=this.paramsFor(this.routeName);(0,t.set)(e,"keyId",l)
if(!this.controllerFor(this.routeName).get("hasModel")||404!==e.httpStatus)return!0
this.set("has404",!0),n.abort()},willTransition(e){return window.scrollTo(0,0),e.targetName!==this.routeName&&this.store.clearAllDatasets(),!0}}})
e.default=i})),define("vault/routes/vault/cluster/access/leases/show",["exports","rsvp","@ember/object","@ember/routing/route","@ember/service","core/utils/key-utils","vault/mixins/unload-model-route"],(function(e,t,n,l,a,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var o=l.default.extend(r.default,{store:(0,a.inject)(),beforeModel(){const{lease_id:e}=this.paramsFor(this.routeName),t=(0,i.parentKeyForKey)(e)
if((0,i.keyIsFolder)(e))return t?this.transitionTo("vault.cluster.access.leases.list",t):this.transitionTo("vault.cluster.access.leases.list-root")},model(e){const{lease_id:n}=e
return(0,t.hash)({lease:this.store.queryRecord("lease",{lease_id:n}),capabilities:(0,t.hash)({renew:this.store.findRecord("capabilities","sys/leases/renew"),revoke:this.store.findRecord("capabilities","sys/leases/revoke"),leases:this.modelFor("vault.cluster.access.leases")})})},setupController(e,t){this._super(...arguments)
const{lease_id:n}=this.paramsFor(this.routeName)
e.setProperties({model:t.lease,capabilities:t.capabilities,baseKey:{id:n}})},actions:{error(e){const{lease_id:t}=this.paramsFor(this.routeName)
return(0,n.set)(e,"keyId",t),!0},refreshModel(){this.refresh()}}})
e.default=o})),define("vault/routes/vault/cluster/access/method",["exports","@ember-data/adapter/error","@ember/object","@ember/routing/route","@ember/service","vault/helpers/supported-managed-auth-backends"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=l.default.extend({store:(0,a.inject)(),pathHelp:(0,a.inject)("path-help"),model(e){const{path:l}=e
return this.store.findAll("auth-method").then((e=>{const a=e.findBy("id",l)
if(!a){const e=new t.default
throw(0,n.set)(e,"httpStatus",404),e}return(0,i.supportedManagedAuthBackends)().includes(a.methodType)?this.pathHelp.getPaths(a.apiPath,l).then((e=>(a.set("paths",e),a))):(a.set("paths",{apiPath:a.apiPath,paths:[]}),a)}))}})
e.default=r})),define("vault/routes/vault/cluster/access/method/index",["exports","@ember/routing/route","vault/helpers/tabs-for-auth-section"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend({beforeModel(){let{methodType:e,paths:t}=this.modelFor("vault.cluster.access.method")
t=t?t.paths.filter((e=>!0===e.navigation)):null
const l=(0,n.tabsForAuthSection)([e,"authConfig",t])[0].routeParams
return this.transitionTo(...l)}})
e.default=l})),define("vault/routes/vault/cluster/access/method/item",["exports","@ember/service","@ember/routing/route","ember-inflector"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=n.default.extend({pathHelp:(0,t.inject)("path-help"),beforeModel(){const{apiPath:e,type:t,authMethodPath:n,itemType:a}=this.getMethodAndModelInfo(),i=`generated-${(0,l.singularize)(a)}-${t}`
return this.pathHelp.getNewModel(i,n,e,a)},getMethodAndModelInfo(){const{item_type:e}=this.paramsFor(this.routeName),{path:t}=this.paramsFor("vault.cluster.access.method"),n=this.modelFor("vault.cluster.access.method"),{apiPath:l,type:a}=n
return{apiPath:l,type:a,authMethodPath:t,itemType:e}},setupController(e){this._super(...arguments)
const{apiPath:t,authMethodPath:n,itemType:l}=this.getMethodAndModelInfo()
e.set("itemType",l),this.pathHelp.getPaths(t,n,l).then((t=>{const n=t.paths.filter((e=>e.navigation))
e.set("paths",n.filter((e=>e.itemType.includes(l))).map((e=>e.path)))}))}})
e.default=a})),define("vault/routes/vault/cluster/access/method/item/create",["exports","@ember/routing/route","vault/mixins/unsaved-model-route","ember-inflector","@ember/service"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=t.default.extend(n.default,{store:(0,a.inject)(),model(){const{item_type:e}=this.paramsFor("vault.cluster.access.method.item"),t=this.modelFor("vault.cluster.access.method"),{type:n}=t,{path:a}=this.paramsFor("vault.cluster.access.method"),i=`generated-${(0,l.singularize)(e)}-${n}`
return this.store.createRecord(i,{itemType:e,method:a,adapterOptions:{path:`${a}/${e}`}})},setupController(e){this._super(...arguments)
const{item_type:t}=this.paramsFor("vault.cluster.access.method.item"),{path:n}=this.paramsFor("vault.cluster.access.method")
e.set("itemType",(0,l.singularize)(t)),e.set("mode","create"),e.set("method",n)}})
e.default=i})),define("vault/routes/vault/cluster/access/method/item/edit",["exports","@ember/routing/route","vault/mixins/unsaved-model-route","ember-inflector","@ember/service"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=t.default.extend(n.default,{store:(0,a.inject)(),model(e){const t=e.item_id,{item_type:n}=this.paramsFor("vault.cluster.access.method.item"),a=this.modelFor("vault.cluster.access.method"),i=`generated-${(0,l.singularize)(n)}-${a.type}`
return this.store.queryRecord(i,{id:t,authMethodPath:a.id})},setupController(e){this._super(...arguments)
const{item_type:t}=this.paramsFor("vault.cluster.access.method.item")
e.set("itemType",(0,l.singularize)(t))}})
e.default=i})),define("vault/routes/vault/cluster/access/method/item/list",["exports","@ember/service","@ember/routing/route","ember-inflector","vault/mixins/list-route"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=n.default.extend(a.default,{store:(0,t.inject)(),pathHelp:(0,t.inject)("path-help"),getMethodAndModelInfo(){const{item_type:e}=this.paramsFor("vault.cluster.access.method.item"),{path:t}=this.paramsFor("vault.cluster.access.method"),n=this.modelFor("vault.cluster.access.method"),{apiPath:l,type:a}=n
return{apiPath:l,type:a,authMethodPath:t,itemType:e,methodModel:n}},model(){const{type:e,authMethodPath:t,itemType:n}=this.getMethodAndModelInfo(),{page:a,pageFilter:i}=this.paramsFor(this.routeName),r=`generated-${(0,l.singularize)(n)}-${e}`
return this.store.lazyPaginatedQuery(r,{responsePath:"data.keys",page:a,pageFilter:i,type:n,id:t}).catch((e=>{if(404===e.httpStatus)return[]
throw e}))},actions:{willTransition(e){return window.scrollTo(0,0),e.targetName!==this.routeName&&this.store.clearAllDatasets(),!0},reload(){this.store.clearAllDatasets(),this.refresh()}},setupController(e){this._super(...arguments)
const{apiPath:t,authMethodPath:n,itemType:l,methodModel:a}=this.getMethodAndModelInfo()
e.set("itemType",l),e.set("methodModel",a),this.pathHelp.getPaths(t,n,l).then((t=>{e.set("paths",t.paths.filter((e=>e.navigation&&e.itemType.includes(l))))}))}})
e.default=i})),define("vault/routes/vault/cluster/access/method/item/show",["exports","ember-inflector","@ember/service","@ember/routing/route"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=l.default.extend({store:(0,n.inject)(),pathHelp:(0,n.inject)("path-help"),model(e){const n=e.item_id,{item_type:l}=this.paramsFor("vault.cluster.access.method.item"),a=this.modelFor("vault.cluster.access.method"),i=`generated-${(0,t.singularize)(l)}-${a.type}`
return this.store.queryRecord(i,{id:n,authMethodPath:a.id})},setupController(e){this._super(...arguments)
const{item_type:n}=this.paramsFor("vault.cluster.access.method.item")
e.set("itemType",(0,t.singularize)(n))}})
e.default=a})),define("vault/routes/vault/cluster/access/method/section",["exports","@ember-data/adapter/error","@ember/object","@ember/routing/route"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=l.default.extend({model(e){const{section_name:l}=e
if("configuration"!==l){const e=new t.default
throw(0,n.set)(e,"httpStatus",404),e}return this.modelFor("vault.cluster.access.method")},setupController(e){const{section_name:t}=this.paramsFor(this.routeName)
this._super(...arguments),e.set("section",t)
const n=this.modelFor("vault.cluster.access.method")
e.set("paths",n.paths.paths.filter((e=>e.navigation)))}})
e.default=a})),define("vault/routes/vault/cluster/access/methods",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l,i,r,o
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0}),o={page:{refreshModel:!0},pageFilter:{refreshModel:!0}},(r="queryParams")in(i=this)?Object.defineProperty(i,r,{value:o,enumerable:!0,configurable:!0,writable:!0}):i[r]=o}model(){return this.store.findAll("auth-method")}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/access/mfa/enforcements/create",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}model(){return this.store.createRecord("mfa-login-enforcement")}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/access/mfa/enforcements/enforcement",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}model(e){let{name:t}=e
return this.store.findRecord("mfa-login-enforcement",t)}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/access/mfa/enforcements/enforcement/edit",["exports","@ember/routing/route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/routes/vault/cluster/access/mfa/enforcements/index",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}model(){return this.store.query("mfa-login-enforcement",{}).catch((e=>{if(404===e.httpStatus)return[]
throw e}))}setupController(e,t){e.set("model",t)}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i}))
define("vault/routes/vault/cluster/access/mfa/index",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}beforeModel(){return this.store.query("mfa-method",{}).then((()=>{this.transitionTo("vault.cluster.access.mfa.methods.index")})).catch((()=>{}))}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/access/mfa/methods/create",["exports","@ember/routing/route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{setupController(e){super.setupController(...arguments)
const{type:t}=e
t&&e.createModels()}resetController(e,t){t&&e.set("type",null)}}e.default=n})),define("vault/routes/vault/cluster/access/mfa/methods/index",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a,i
function r(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function o(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let s=(l=class extends t.default{constructor(){super(...arguments),r(this,"store",a,this),r(this,"router",i,this)}model(){return this.store.query("mfa-method",{}).catch((e=>{if(404===e.httpStatus)return[]
throw e}))}afterModel(e){0===e.length&&this.router.transitionTo("vault.cluster.access.mfa")}setupController(e,t){e.set("model",t)}},a=o(l.prototype,"store",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),i=o(l.prototype,"router",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),l)
e.default=s})),define("vault/routes/vault/cluster/access/mfa/methods/method",["exports","@ember/routing/route","rsvp","@ember/service"],(function(e,t,n,l){var a,i
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let r=(a=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=i)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}model(e){let{id:t}=e
return(0,n.hash)({method:this.store.findRecord("mfa-method",t).then((e=>e)),enforcements:this.store.query("mfa-login-enforcement",{}).then((e=>e.filter((e=>e.hasMany("mfa_methods").ids().includes(t))))).catch((()=>{}))})}setupController(e,t){e.set("model",t)}},o=a.prototype,s="store",u=[l.inject],d={configurable:!0,enumerable:!0,writable:!0,initializer:null},p={},Object.keys(d).forEach((function(e){p[e]=d[e]})),p.enumerable=!!p.enumerable,p.configurable=!!p.configurable,("value"in p||p.initializer)&&(p.writable=!0),p=u.slice().reverse().reduce((function(e,t){return t(o,s,e)||e}),p),c&&void 0!==p.initializer&&(p.value=p.initializer?p.initializer.call(c):void 0,p.initializer=void 0),void 0===p.initializer&&(Object.defineProperty(o,s,p),p=null),i=p,a)
var o,s,u,d,c,p
e.default=r})),define("vault/routes/vault/cluster/access/mfa/methods/method/edit",["exports","@ember/routing/route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/routes/vault/cluster/access/namespaces/create",["exports","@ember/service","@ember/routing/route","vault/mixins/unload-model-route"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=n.default.extend(l.default,{store:(0,t.inject)(),version:(0,t.inject)(),beforeModel(){return this.version.fetchFeatures().then((()=>this._super(...arguments)))},model(){return this.version.hasNamespaces?this.store.createRecord("namespace"):null}})
e.default=a})),define("vault/routes/vault/cluster/access/namespaces/index",["exports","@ember/service","@ember/routing/route","vault/mixins/unload-model-route"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=n.default.extend(l.default,{store:(0,t.inject)(),queryParams:{page:{refreshModel:!0}},version:(0,t.inject)(),beforeModel(){return this.store.unloadAll("namespace"),this.version.fetchFeatures().then((()=>this._super(...arguments)))},model(e){return this.version.hasNamespaces?this.store.lazyPaginatedQuery("namespace",{responsePath:"data.keys",page:Number(e?.page)||1}).then((e=>e)).catch((e=>{if(404===e.httpStatus)return[]
throw e})):null},setupController(e,t){const n=this.has404
e.setProperties({model:t,has404:n,hasModel:!0}),n||e.setProperties({page:Number(t?.meta?.currentPage)||1})},actions:{error(e,t){if(!this.controllerFor(this.routeName).get("hasModel")||404!==e.httpStatus)return!0
this.set("has404",!0),t.abort()},willTransition(e){return window.scrollTo(0,0),e&&e.targetName===this.routeName||this.store.clearAllDatasets(),!0},reload(){this.store.clearAllDatasets(),this.refresh()}}})
e.default=a})),define("vault/routes/vault/cluster/access/oidc",["exports","@ember/routing/route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/routes/vault/cluster/access/oidc/assignments/assignment",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}model(e){let{name:t}=e
return this.store.findRecord("oidc/assignment",t)}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/access/oidc/assignments/assignment/details",["exports","@ember/routing/route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/routes/vault/cluster/access/oidc/assignments/assignment/edit",["exports","@ember/routing/route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/routes/vault/cluster/access/oidc/assignments/create",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}model(){return this.store.createRecord("oidc/assignment")}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/access/oidc/assignments/index",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}model(){return this.store.query("oidc/assignment",{}).catch((e=>{if(404===e.httpStatus)return[]
throw e}))}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/access/oidc/clients/client",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}model(e){let{name:t}=e
return this.store.findRecord("oidc/client",t)}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/access/oidc/clients/client/details",["exports","@ember/routing/route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/routes/vault/cluster/access/oidc/clients/client/edit",["exports","@ember/routing/route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/routes/vault/cluster/access/oidc/clients/client/providers",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}model(){const e=this.modelFor("vault.cluster.access.oidc.clients.client")
return this.store.query("oidc/provider",{allowed_client_id:e.clientId}).catch((e=>{if(404===e.httpStatus)return[]
throw e}))}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/access/oidc/clients/create",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}model(){return this.store.createRecord("oidc/client")}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/access/oidc/clients/index",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a,i
function r(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function o(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let s=(l=class extends t.default{constructor(){super(...arguments),r(this,"store",a,this),r(this,"router",i,this)}model(){return this.store.query("oidc/client",{}).catch((e=>{if(404===e.httpStatus)return[]
throw e}))}afterModel(e){0===e.length&&this.router.transitionTo("vault.cluster.access.oidc")}},a=o(l.prototype,"store",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),i=o(l.prototype,"router",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),l)
e.default=s})),define("vault/routes/vault/cluster/access/oidc/index",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a,i
function r(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function o(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let s=(l=class extends t.default{constructor(){super(...arguments),r(this,"store",a,this),r(this,"router",i,this)}beforeModel(){return this.store.query("oidc/client",{}).then((()=>{this.router.transitionTo("vault.cluster.access.oidc.clients")})).catch((()=>{}))}},a=o(l.prototype,"store",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),i=o(l.prototype,"router",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),l)
e.default=s})),define("vault/routes/vault/cluster/access/oidc/keys/create",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}model(){return this.store.createRecord("oidc/key")}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/access/oidc/keys/index",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}model(){return this.store.query("oidc/key",{}).catch((e=>{if(404===e.httpStatus)return[]
throw e}))}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/access/oidc/keys/key",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}model(e){let{name:t}=e
return this.store.findRecord("oidc/key",t)}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/access/oidc/keys/key/clients",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}async model(){const{allowedClientIds:e}=this.modelFor("vault.cluster.access.oidc.keys.key")
return await this.store.query("oidc/client",{paramKey:"client_id",filterFor:e})}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/access/oidc/keys/key/details",["exports","@ember/routing/route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/routes/vault/cluster/access/oidc/keys/key/edit",["exports","@ember/routing/route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/routes/vault/cluster/access/oidc/providers/create",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}model(){return this.store.createRecord("oidc/provider")}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/access/oidc/providers/index",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}model(){return this.store.query("oidc/provider",{}).catch((e=>{if(404===e.httpStatus)return[]
throw e}))}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/access/oidc/providers/provider",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}model(e){let{name:t}=e
return this.store.findRecord("oidc/provider",t)}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/access/oidc/providers/provider/clients",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}async model(){const{allowedClientIds:e}=this.modelFor("vault.cluster.access.oidc.providers.provider")
return await this.store.query("oidc/client",{paramKey:"client_id",filterFor:e})}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i}))
define("vault/routes/vault/cluster/access/oidc/providers/provider/details",["exports","@ember/routing/route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/routes/vault/cluster/access/oidc/providers/provider/edit",["exports","@ember/routing/route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/routes/vault/cluster/access/oidc/scopes/create",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}model(){return this.store.createRecord("oidc/scope")}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/access/oidc/scopes/index",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}model(){return this.store.query("oidc/scope",{}).catch((e=>{if(404===e.httpStatus)return[]
throw e}))}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/access/oidc/scopes/scope",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}model(e){let{name:t}=e
return this.store.findRecord("oidc/scope",t)}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/access/oidc/scopes/scope/details",["exports","@ember/routing/route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/routes/vault/cluster/access/oidc/scopes/scope/edit",["exports","@ember/routing/route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/routes/vault/cluster/auth",["exports","@ember/service","vault/routes/vault/cluster/cluster-route-base","vault/config/environment"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=n.default.extend({queryParams:{authMethod:{replace:!0}},flashMessages:(0,t.inject)(),version:(0,t.inject)(),beforeModel(){return this._super().then((()=>this.version.fetchFeatures()))},model(){return this._super(...arguments)},resetController(e){e.set("wrappedToken",""),e.set("authMethod","token")},afterModel(){l.default.welcomeMessage&&this.flashMessages.info(l.default.welcomeMessage,{sticky:!0,priority:300})}})
e.default=a})),define("vault/routes/vault/cluster/clients",["exports","@ember/routing/route","rsvp","@ember/object","vault/lib/token-storage","@ember/service"],(function(e,t,n,l,a,i){var r,o
function s(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let u=(r=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=o)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}async getVersionHistory(){return this.store.findAll("clients/version-history").then((e=>e.map((e=>{let{version:t,previousVersion:n,timestampInstalled:l}=e
return{version:t,previousVersion:n,timestampInstalled:l}})))).catch((()=>[]))}model(){return(0,n.hash)({config:this.store.queryRecord("clients/config",{}).catch((()=>{})),versionHistory:this.getVersionHistory()})}deactivate(){(0,a.default)().removeItem("vault:ui-inputted-start-date")}},o=s(r.prototype,"store",[i.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s(r.prototype,"deactivate",[l.action],Object.getOwnPropertyDescriptor(r.prototype,"deactivate"),r.prototype),r)
e.default=u})),define("vault/routes/vault/cluster/clients/config",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}model(){return this.store.queryRecord("clients/config",{})}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/clients/dashboard",["exports","@ember/routing/route","vault/lib/token-storage","@ember/service","core/utils/timestamp"],(function(e,t,n,l,a){var i,r
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let o=(i=class extends t.default{constructor(){var e,t,n,l,i,o,s
super(...arguments),e=this,t="store",l=this,(n=r)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0}),i=this,o="currentDate",s=a.default.now().toISOString(),o in i?Object.defineProperty(i,o,{value:s,enumerable:!0,configurable:!0,writable:!0}):i[o]=s}async getActivity(e){return e?await this.store.queryRecord("clients/activity",{start_time:{timestamp:e},end_time:{timestamp:this.currentDate}}):{}}async getLicenseStartTime(){try{return(await this.store.queryRecord("license",{})).startTime||(0,n.default)().getItem("vault:ui-inputted-start-date")||null}catch(e){return(0,n.default)().getItem("vault:ui-inputted-start-date")||null}}async model(){const{config:e,versionHistory:t}=this.modelFor("vault.cluster.clients"),n=await this.getLicenseStartTime()
return{config:e,versionHistory:t,activity:await this.getActivity(n),licenseStartTimestamp:n,currentDate:this.currentDate}}},s=i.prototype,u="store",d=[l.inject],c={configurable:!0,enumerable:!0,writable:!0,initializer:null},m={},Object.keys(c).forEach((function(e){m[e]=c[e]})),m.enumerable=!!m.enumerable,m.configurable=!!m.configurable,("value"in m||m.initializer)&&(m.writable=!0),m=d.slice().reverse().reduce((function(e,t){return t(s,u,e)||e}),m),p&&void 0!==m.initializer&&(m.value=m.initializer?m.initializer.call(p):void 0,m.initializer=void 0),void 0===m.initializer&&(Object.defineProperty(s,u,m),m=null),r=m,i)
var s,u,d,c,p,m
e.default=o})),define("vault/routes/vault/cluster/clients/edit",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend({store:(0,n.inject)(),model(){return this.store.queryRecord("clients/config",{})}})
e.default=l})),define("vault/routes/vault/cluster/clients/index",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="router",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}redirect(){this.router.transitionTo("vault.cluster.clients.dashboard")}},r=l.prototype,o="router",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/cluster-route-base",["exports","@ember/routing/route","vault/mixins/cluster-route"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend(n.default,{model(){return this.modelFor("vault.cluster")},resetController(e){e.reset&&e.reset()}})
e.default=l})),define("vault/routes/vault/cluster/dashboard",["exports","@ember/routing/route","@ember/service","rsvp","vault/mixins/cluster-route","@ember/object"],(function(e,t,n,l,a,i){var r,o,s,u
function d(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function c(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let p=(r=class extends(t.default.extend(a.default)){constructor(){super(...arguments),d(this,"store",o,this),d(this,"namespace",s,this),d(this,"version",u,this)}async getVaultConfiguration(){try{if(!this.namespace.inRootNamespace)return null
const e=this.store.adapterFor("application")
return(await e.ajax("/v1/sys/config/state/sanitized","GET")).data}catch(e){return null}}model(){const e=this.modelFor("vault.cluster"),t=e?.hasChrootNamespace,n=t?null:{dr:e.dr,performance:e.performance}
return(0,l.hash)({replication:n,secretsEngines:this.store.query("secret-engine",{}),license:this.store.queryRecord("license",{}).catch((()=>null)),isRootNamespace:this.namespace.inRootNamespace&&!t,version:this.version,vaultConfiguration:t?null:this.getVaultConfiguration()})}refreshRoute(){this.refresh()}},o=c(r.prototype,"store",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s=c(r.prototype,"namespace",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=c(r.prototype,"version",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c(r.prototype,"refreshRoute",[i.action],Object.getOwnPropertyDescriptor(r.prototype,"refreshRoute"),r.prototype),r)
e.default=p})),define("vault/routes/vault/cluster/index",["exports","@ember/routing/route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({beforeModel(){return this.transitionTo("vault.cluster.dashboard")}})
e.default=n})),define("vault/routes/vault/cluster/init",["exports","vault/routes/vault/cluster/cluster-route-base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({})
e.default=n})),define("vault/routes/vault/cluster/license",["exports","@ember/routing/route","vault/mixins/cluster-route","@ember/service"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=t.default.extend(n.default,{store:(0,l.inject)(),version:(0,l.inject)(),beforeModel(){this.version.isOSS&&this.transitionTo("vault.cluster")},model(){return this.store.queryRecord("license",{})}})
e.default=a})),define("vault/routes/vault/cluster/logout",["exports","ember","@ember/object","@ember/service","@ember/routing/route","vault/mixins/model-boundary-route"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=a.default.extend(i.default,{auth:(0,l.inject)(),controlGroup:(0,l.inject)(),flashMessages:(0,l.inject)(),console:(0,l.inject)(),permissions:(0,l.inject)(),namespaceService:(0,l.inject)("namespace"),router:(0,l.inject)(),modelTypes:(0,n.computed)((function(){return["secret","secret-engine"]})),beforeModel(e){let{to:{queryParams:n}}=e
const l=this.auth.getAuthType(),a=this.namespaceService.path
if(this.auth.deleteCurrentToken(),this.controlGroup.deleteTokens(),this.namespaceService.reset(),this.console.set("isOpen",!1),this.console.clearLog(!0),this.flashMessages.clearMessages(),this.permissions.reset(),n.with=l,a&&(n.namespace=a),t.default.testing)this.replaceWith("vault.cluster.auth",{queryParams:n})
else{const{cluster_name:e}=this.paramsFor("vault.cluster")
location.assign(this.router.urlFor("vault.cluster.auth",e,{queryParams:n}))}}})
e.default=r})),define("vault/routes/vault/cluster/mfa-setup",["exports","@ember/routing/route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/routes/vault/cluster/oidc-callback",["exports","@ember/routing/route"],(function(e,t){function n(e,t){const n=decodeURIComponent(t)
let{path:l,code:a,state:i,namespace:r}=e
i?.includes(",ns=")&&([i,r]=i.split(",ns="))
const o=new URLSearchParams(n).get("state")
o?.includes(",ns=")&&([i,r]=o.split(",ns=")),l=window.decodeURIComponent(l)
const s={source:"oidc-callback",path:l||"",code:a||"",state:i||""}
return r&&(s.namespace=r),s}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.getParamsForCallback=n
var l=t.default.extend({templateName:"vault/cluster/oidc-callback",model(){},afterModel(){const{auth_path:e,code:t,state:l}=this.paramsFor(this.routeName),{namespaceQueryParam:a}=this.paramsFor("vault.cluster"),i=n({path:e,code:t,state:l,namespace:a},window.location.search)
window.opener.postMessage(i,window.origin)},setupController(e){this._super(...arguments),e.set("pageContainer",document.querySelector(".page-container"))}})
e.default=l})),define("vault/routes/vault/cluster/oidc-provider-ns",["exports","vault/routes/vault/cluster/oidc-provider"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/routes/vault/cluster/oidc-provider",["exports","ember","@ember/routing/route","@ember/service"],(function(e,t,n,l){var a,i,r
function o(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function s(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let u=(a=class extends n.default{constructor(){super(...arguments),o(this,"auth",i,this),o(this,"router",r,this)}get win(){return this.window||window}_redirect(e,n){if(!e)return
const l=this._buildUrl(e,n)
if(t.default.testing)return l
this.win.location.replace(l)}beforeModel(e){const t=this.auth.get("currentTokenName"),n=e.to.queryParams
if(n.redirect_to=null,t||"none"!==n.prompt?.toLowerCase()){if(!t||"login"===n.prompt?.toLowerCase()){const l=!!t
return"login"===n.prompt?.toLowerCase()&&(n.prompt=null),this._redirectToAuth({...e.to.params,qp:n,logout:l})}}else this._redirect(n.redirect_uri,{state:n.state,error:"login_required"})}_redirectToAuth(e){let{provider_name:t,namespace:n=null,qp:l,logout:a=!1}=e
const{cluster_name:i}=this.paramsFor("vault.cluster")
let r=n?this.router.urlFor("vault.cluster.oidc-provider-ns",i,n,t,{queryParams:l}):this.router.urlFor("vault.cluster.oidc-provider",i,t,{queryParams:l})
r=r.replace(/^(\/?ui)/,""),a&&this.auth.deleteCurrentToken()
const o={redirect_to:r,o:t}
return n&&(o.namespace=n),this.transitionTo("vault.cluster.auth",i,{queryParams:o})}_buildUrl(e,t){try{const n=new URL(e)
return Object.keys(t).forEach((e=>{t[e]&&n.searchParams.append(e,t[e])})),n}catch(n){throw console.debug("DEBUG: parsing url failed for",e),new Error("Invalid URL")}}_handleSuccess(e,n,l){const{code:a}=e,i=this._buildUrl(n,{code:a,state:l})
return t.default.testing||this.win.location.replace(i),{redirectUrl:i}}_handleError(e,n){const l=this._buildUrl(n,{...e})
return t.default.testing||this.win.location.replace(l),{redirectUrl:l}}_getInfoFromParams(e){const{provider_name:t,namespace:n,...l}=e
return{provider_name:t,qp:l,decodedRedirect:decodeURI(l.redirect_uri),namespace:n}}async model(e){const t=this._getInfoFromParams(e),{qp:n,decodedRedirect:l,...a}=t,i=this._buildUrl(`${this.win.origin}/v1/identity/oidc/provider/${a.provider_name}/authorize`,n)
if(!n.redirect_uri)throw new Error("Missing required query params")
try{const e=await this.auth.ajax(i,"GET",{namespace:a.namespace})
return"consent"===n.prompt?.toLowerCase()?{consent:{code:e.code,redirect:l,state:n.state}}:this._handleSuccess(e,l,n.state)}catch(r){const e=await r.json(),t=e.error
if("max_age_violation"!==t&&!e?.errors?.includes("permission denied"))return"invalid_redirect_uri"===t?{error:{title:"Redirect URI mismatch",message:"The provided redirect_uri is not in the list of allowed redirect URIs. Please make sure you are sending a valid redirect URI from your application."}}:"invalid_client_id"===t?{error:{title:"Invalid client ID",message:"Your client ID is invalid. Please update your configuration and try again."}}:this._handleError(e,l)
this._redirectToAuth({...a,qp:n,logout:!0})}}},i=s(a.prototype,"auth",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),r=s(a.prototype,"router",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),a)
e.default=u})),define("vault/routes/vault/cluster/policies",["exports","@ember/service","@ember/routing/route","vault/mixins/cluster-route"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const a=["acl","egp","rgp"]
var i=n.default.extend(l.default,{version:(0,t.inject)(),beforeModel(){return this.version.fetchFeatures().then((()=>this._super(...arguments)))},model(e){const t=e.type
return a.includes(t)?{}:this.transitionTo(this.routeName,a[0])}})
e.default=i})),define("vault/routes/vault/cluster/policies/create",["exports","@ember/service","@ember/routing/route","vault/mixins/unsaved-model-route"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=n.default.extend(l.default,{store:(0,t.inject)(),version:(0,t.inject)(),model(){const e=this.policyType()
return this.version.hasSentinel||"acl"===e?this.store.createRecord(`policy/${e}`,{}):this.transitionTo("vault.cluster.policies",e)},setupController(e){this._super(...arguments),e.set("policyType",this.policyType())},policyType(){return this.paramsFor("vault.cluster.policies").type}})
e.default=a})),define("vault/routes/vault/cluster/policies/index",["exports","@ember/service","@ember/routing/route","vault/mixins/cluster-route","core/mixins/list-route"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=n.default.extend(l.default,a.default,{store:(0,t.inject)(),version:(0,t.inject)(),shouldReturnEmptyModel:(e,t)=>"acl"!==e&&(t.get("isOSS")||!t.get("hasSentinel")),model(e){const t=this.policyType()
if(!this.shouldReturnEmptyModel(t,this.version))return this.store.lazyPaginatedQuery(`policy/${t}`,{page:e.page,pageFilter:e.pageFilter,responsePath:"data.keys"}).catch((e=>{if(404===e.httpStatus&&"acl"!==this.policyType())return[]
throw e}))},setupController(e,t){const n=this.paramsFor(this.routeName)
t?e.setProperties({model:t,filter:n.pageFilter||"",page:t.get("meta.currentPage")||1,policyType:this.policyType()}):e.setProperties({model:null,policyType:this.policyType()})},resetController(e,t){this._super(...arguments),t&&e.set("filter","")},actions:{willTransition(e){return window.scrollTo(0,0),e&&e.targetName===this.routeName||this.store.clearAllDatasets(),!0},reload(){this.store.clearAllDatasets(),this.refresh()}},policyType(){return this.paramsFor("vault.cluster.policies").type}})
e.default=i})),define("vault/routes/vault/cluster/policy",["exports","@ember/service","@ember/routing/route","vault/mixins/cluster-route"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const a=["acl","egp","rgp"]
var i=n.default.extend(l.default,{version:(0,t.inject)(),beforeModel(){return this.version.fetchFeatures().then((()=>this._super(...arguments)))},model(e){const t=e.type
return a.includes(t)?this.version.hasSentinel||"acl"===t?{}:this.transitionTo("vault.cluster.policies",t):this.transitionTo("vault.cluster.policies",a[0])}})
e.default=i})),define("vault/routes/vault/cluster/policy/edit",["exports","vault/mixins/unsaved-model-route","vault/routes/vault/cluster/policy/show"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=n.default.extend(t.default,{})
e.default=l})),define("vault/routes/vault/cluster/policy/index",["exports","@ember/routing/route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({beforeModel(){return this.transitionTo("vault.cluster.policies","acl")}})
e.default=n})),define("vault/routes/vault/cluster/policy/show",["exports","rsvp","@ember/routing/route","vault/mixins/unload-model-route","@ember/service"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=n.default.extend(l.default,{store:(0,a.inject)(),beforeModel(){const e=this.paramsFor(this.routeName)
if("acl"===this.policyType()&&"root"===e.policy_name)return this.transitionTo("vault.cluster.policies","acl")},model(e){const n=this.policyType()
return(0,t.hash)({policy:this.store.findRecord(`policy/${n}`,e.policy_name),capabilities:this.store.findRecord("capabilities",`sys/policies/${n}/${e.policy_name}`)})},setupController(e,t){e.setProperties({model:t.policy,capabilities:t.capabilities,policyType:this.policyType()})},policyType(){return this.paramsFor("vault.cluster.policy").type}})
e.default=i}))
define("vault/routes/vault/cluster/redirect",["exports","@ember/routing/route","@ember/service","vault/lib/route-paths"],(function(e,t,n,l){var a,i,r
function o(e,t,n,l){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}function s(e,t,n,l,a){var i={}
return Object.keys(l).forEach((function(e){i[e]=l[e]})),i.enumerable=!!i.enumerable,i.configurable=!!i.configurable,("value"in i||i.initializer)&&(i.writable=!0),i=n.slice().reverse().reduce((function(n,l){return l(e,t,n)||n}),i),a&&void 0!==i.initializer&&(i.value=i.initializer?i.initializer.call(a):void 0,i.initializer=void 0),void 0===i.initializer&&(Object.defineProperty(e,t,i),i=null),i}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let u=(a=class extends t.default{constructor(){super(...arguments),o(this,"auth",i,this),o(this,"router",r,this)}beforeModel(e){let t,{to:{queryParams:n}}=e
const a=this.auth.currentToken,i=this.controllerFor("vault"),{redirect_to:r,...o}=n
t=a&&r?this.router.replaceWith(r):a?this.router.replaceWith(l.CLUSTER,{queryParams:o}):this.router.replaceWith(l.AUTH,{queryParams:o}),t.followRedirects().then((()=>{i.set("redirectTo","")}))}},i=s(a.prototype,"auth",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),r=s(a.prototype,"router",[n.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),a)
e.default=u})),define("vault/routes/vault/cluster/replication-dr-promote/details",["exports","@ember/service","vault/routes/vault/cluster/cluster-route-base"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=n.default.extend({replicationMode:(0,t.inject)(),beforeModel(){this._super(...arguments),this.replicationMode.setMode("dr")}})
e.default=l})),define("vault/routes/vault/cluster/replication-dr-promote/index",["exports","@ember/service","vault/routes/vault/cluster/cluster-route-base"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=n.default.extend({replicationMode:(0,t.inject)(),beforeModel(){this._super(...arguments),this.replicationMode.setMode("dr")}})
e.default=l})),define("vault/routes/vault/cluster/secrets",["exports","@ember/routing/route","vault/mixins/cluster-route"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend(n.default)
e.default=l})),define("vault/routes/vault/cluster/secrets/backend",["exports","@ember/service","@ember/routing/route"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=n.default.extend({store:(0,t.inject)(),flashMessages:(0,t.inject)(),secretMountPath:(0,t.inject)(),oldModel:null,model(e){const{backend:t}=e
return this.secretMountPath.update(t),this.store.query("secret-engine",{path:t}).then((e=>{if(e)return e.get("firstObject")}))},afterModel(e,t){const n=e&&e.get("path")
if(t.targetName===this.routeName)return this.replaceWith("vault.cluster.secrets.backend.list-root",n)}})
e.default=l})),define("vault/routes/vault/cluster/secrets/backend/actions",["exports","core/utils/key-utils","vault/routes/vault/cluster/secrets/backend/secret-edit"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=n.default.extend({queryParams:{selectedAction:{replace:!0}},templateName:"vault/cluster/secrets/backend/transitActionsLayout",beforeModel(){const{secret:e}=this.paramsFor(this.routeName),n=(0,t.parentKeyForKey)(e),{backend:l}=this.paramsFor("vault.cluster.secrets.backend")
if("transit"!==this.backendType(l))return n?this.transitionTo("vault.cluster.secrets.backend.show",n):this.transitionTo("vault.cluster.secrets.backend.show-root")},setupController(e,t){this._super(...arguments)
const{selectedAction:n}=this.paramsFor(this.routeName)
e.set("selectedAction",n||t.secret.get("supportedActions.firstObject"))}})
e.default=l})),define("vault/routes/vault/cluster/secrets/backend/configuration",["exports","@ember/service","@ember/routing/route"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=n.default.extend({store:(0,t.inject)(),async model(){const e=this.modelFor("vault.cluster.secrets.backend")
if(e.isV2KV){await this.store.findRecord("capabilities",`${e.id}/config`).then((e=>e.canRead))?(e.set("casRequired",e.casRequired?e.casRequired:"False"),e.set("deleteVersionAfter","0s"!==e.deleteVersionAfter?e.deleteVersionAfter:"Never delete"),e.set("maxVersions",e.maxVersions?e.maxVersions:"Not set")):(e.set("casRequired",null),e.set("deleteVersionAfter",null),e.set("maxVersions",null))}return e}})
e.default=l})),define("vault/routes/vault/cluster/secrets/backend/create-root",["exports","rsvp","@ember/service","vault/routes/vault/cluster/secrets/backend/secret-edit"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=l.default.extend({store:(0,n.inject)(),createModel(e){const{backend:t}=this.paramsFor("vault.cluster.secrets.backend")
let n=this.modelType(t,null,{queryParams:e.to.queryParams})
return"role-ssh"===n?this.store.createRecord(n,{keyType:"ca"}):("transform"===n&&(n=(e=>{const t="transform"
return e&&e.itemType?`transform/${e.itemType}`:t})(e.to.queryParams)),"database/connection"===n&&"role"===e.to?.queryParams?.itemType&&(n="database/role"),"secret"!==n&&"secret-v2"!==n?this.store.createRecord(n):("secret-v2"===n&&this.store.findRecord("capabilities",`${t}/metadata/`),((e,t,n)=>{const l=e.peekRecord("secret-engine",t),a=l.modelTypeForKV
if("secret-v2"!==a)return e.createRecord(a,{path:n})
const i=e.createRecord(a)
i.set("engine",l)
const r=e.createRecord("secret-v2-version",{path:n})
return i.set("selectedVersion",r),i})(this.store,t,e.to.queryParams.initialKey)))},model(e,n){return(0,t.hash)({secret:this.createModel(n),capabilities:{}})}})
e.default=a})),define("vault/routes/vault/cluster/secrets/backend/create",["exports","@ember/routing/route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({beforeModel(){const{secret:e,initialKey:t}=this.paramsFor(this.routeName),n=t||e
return this.transitionTo("vault.cluster.secrets.backend.create-root",{queryParams:{initialKey:n}})}})
e.default=n})),define("vault/routes/vault/cluster/secrets/backend/credentials-root",["exports","vault/routes/vault/cluster/secrets/backend/credentials"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/routes/vault/cluster/secrets/backend/credentials",["exports","rsvp","@ember/routing/route","@ember/service","vault/lib/control-group-error"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=["database","ssh","aws"]
var r=n.default.extend({templateName:"vault/cluster/secrets/backend/credentials",pathHelp:(0,l.inject)("path-help"),store:(0,l.inject)(),backendModel(){return this.modelFor("vault.cluster.secrets.backend")},beforeModel(){const{backend:e}=this.paramsFor("vault.cluster.secrets.backend")
if("ssh"!=e)return
return this.pathHelp.getNewModel("ssh-otp-credential",e)},getDatabaseCredential(e,t){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:""
return this.store.queryRecord("database/credential",{backend:e,secret:t,roleType:n}).catch((e=>{if(e instanceof a.default)throw e
const t=e?.httpStatus
let n,l=`We ran into a problem and could not continue: ${e?.errors?e.errors[0]:"See Vault logs for details."}`
return 403===t&&(n="You are not authorized",l="Role wasn't found or you do not have permissions. Ask your administrator if you think you should have access."),{errorHttpStatus:t,errorTitle:n,errorMessage:l}}))},async model(e){const n=e.secret,l=this.backendModel(),a=l.get("id"),r=l.get("type"),o=e.roleType
let s
return"database"===r&&(s=await this.getDatabaseCredential(a,n,o)),i.includes(l.get("type"))?(0,t.resolve)({backendPath:a,backendType:r,roleName:n,roleType:o,dbCred:s}):this.transitionTo("vault.cluster.secrets.backend.list-root",a)},resetController(e){e.reset()},actions:{willTransition(){this.store.unloadAll("database/credential")}}})
e.default=r})),define("vault/routes/vault/cluster/secrets/backend/diff",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}beforeModel(){const{backend:e}=this.paramsFor("vault.cluster.secrets.backend")
this.backend=e}model(e){const{id:t}=e
return this.store.queryRecord("secret-v2",{backend:this.backend,id:t})}setupController(e,t){e.set("backend",this.backend),e.set("id",t.id),e.set("model",t)}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/secrets/backend/edit-metadata",["exports","vault/routes/vault/cluster/secrets/backend/metadata"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/routes/vault/cluster/secrets/backend/edit-root",["exports","vault/routes/vault/cluster/secrets/backend/edit"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/routes/vault/cluster/secrets/backend/edit",["exports","vault/routes/vault/cluster/secrets/backend/secret-edit"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({queryParams:{version:{refreshModel:!0}}})
e.default=n})),define("vault/routes/vault/cluster/secrets/backend/index",["exports","@ember/routing/route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({beforeModel(){return this.replaceWith("vault.cluster.secrets.backend.list-root")}})
e.default=n})),define("vault/routes/vault/cluster/secrets/backend/list-root",["exports","vault/routes/vault/cluster/secrets/backend/list"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/routes/vault/cluster/secrets/backend/list",["exports","@ember/object","rsvp","@ember/routing/route","vault/helpers/supported-secret-backends","vault/helpers/mountable-secret-engines","@ember/service","vault/utils/path-encoding-helpers","@ember/debug","kv/utils/kv-breadcrumbs"],(function(e,t,n,l,a,i,r,o,s,u){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const d=(0,a.supportedSecretBackends)()
var c=l.default.extend({store:(0,r.inject)(),templateName:"vault/cluster/secrets/backend/list",pathHelp:(0,r.inject)("path-help"),router:(0,r.inject)(),noMetadataPermissions:!0,queryParams:{page:{refreshModel:!0},pageFilter:{refreshModel:!0},tab:{refreshModel:!0}},modelTypeForTransform(e){let t
switch(e){case"role":t="transform/role"
break
case"template":t="transform/template"
break
case"alphabet":t="transform/alphabet"
break
default:t="transform"}return t},secretParam(){const{secret:e}=this.paramsFor(this.routeName)
return e?(0,o.normalizePath)(e):""},enginePathParam(){const{backend:e}=this.paramsFor("vault.cluster.secrets.backend")
return e},beforeModel(){const e=this.secretParam(),t=this.enginePathParam(),{tab:n}=this.paramsFor("vault.cluster.secrets.backend.list-root"),l=this.store.peekRecord("secret-engine",t),a=l?.engineType,r=(0,i.allEngines)().findBy("type",a)?.engineRoute
if(!a||!d.includes(a))return this.router.transitionTo("vault.cluster.secrets")
if("vault.cluster.secrets.backend.list"===this.routeName&&!e.endsWith("/"))return this.router.replaceWith("vault.cluster.secrets.backend.list",e+"/")
if((0,i.isAddonEngine)(a,l.version))return"kv.list"===r&&(0,u.pathIsDirectory)(e)?this.router.transitionTo("vault.cluster.secrets.backend.kv.list-directory",t,e):this.router.transitionTo(`vault.cluster.secrets.backend.${r}`,t)
const o=this.getModelType(t,n)
return this.pathHelp.getNewModel(o,t).then((()=>{this.store.unloadAll("capabilities")}))},getModelType(e,t){const n=this.store.peekRecord("secret-engine",e),l=n.engineType
return{database:"role"===t?"database/role":"database/connection",transit:"transit-key",ssh:"role-ssh",transform:this.modelTypeForTransform(t),aws:"role-aws",cubbyhole:"secret",kv:n.modelTypeForKV,keymgmt:`keymgmt/${t||"key"}`,generic:n.modelTypeForKV}[l]},async model(e){const t=this.secretParam()||"",l=this.enginePathParam(),a=this.modelFor("vault.cluster.secrets.backend"),i=this.getModelType(l,e.tab)
return(0,n.hash)({secret:t,secrets:this.store.lazyPaginatedQuery(i,{id:t,backend:l,responsePath:"data.keys",page:e.page||1,pageFilter:e.pageFilter}).then((e=>(this.set("noMetadataPermissions",!1),this.set("has404",!1),e))).catch((e=>{if(a&&404===e.httpStatus&&""===t)return this.set("noMetadataPermissions",!1),[]
if(403===e.httpStatus&&a.isV2KV)return this.set("noMetadataPermissions",!0),[]
throw e}))})},setupController(e,t){const n=this.paramsFor(this.routeName),l=t.secret,a=t.secrets,i=this.enginePathParam(),r=this.store.peekRecord("secret-engine",i),o=this.has404,s=this.noMetadataPermissions
if(l!==e.get("baseKey.id")&&this.store.clearAllDatasets(),e.set("hasModel",!0),e.setProperties({model:a,has404:o,noMetadataPermissions:s,backend:i,backendModel:r,baseKey:{id:l},backendType:r.get("engineType")}),!o){const t=n.pageFilter
let i
l?i=l+(t||""):t&&(i=t),e.setProperties({filter:i||"",page:a.meta?.currentPage||1})}},resetController(e,t){this._super(...arguments),t&&(e.set("pageFilter",null),e.set("filter",null))},actions:{error(e,n){const l=this.secretParam(),a=this.enginePathParam(),i=404===e.httpStatus,r=this.controllerFor(this.routeName).get("hasModel")
if(n.data.isDeletion&&i)throw e
return(0,t.set)(e,"secret",l),(0,t.set)(e,"isRoot",!0),(0,t.set)(e,"backend",a),!r||!i||(this.set("has404",!0),n.abort(),!1)},willTransition(e){return window.scrollTo(0,0),e.targetName!==this.routeName&&this.store.clearAllDatasets(),!0},reload(){this.store.clearAllDatasets(),this.refresh()}}})
e.default=c})),define("vault/routes/vault/cluster/secrets/backend/metadata",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l,i,r,o
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0}),o=!1,(r="noReadAccess")in(i=this)?Object.defineProperty(i,r,{value:o,enumerable:!0,configurable:!0,writable:!0}):i[r]=o}beforeModel(){const{backend:e}=this.paramsFor("vault.cluster.secrets.backend")
this.backend=e}model(e){const{secret:t}=e
return this.id=t,this.store.queryRecord("secret-v2",{backend:this.backend,id:t}).catch((e=>{403===e.httpStatus&&(this.noReadAccess=!0)}))}setupController(e,t){e.set("backend",this.backend),e.set("id",this.id),e.set("model",t),e.set("noReadAccess",this.noReadAccess)}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/secrets/backend/overview",["exports","@ember/routing/route","rsvp","@ember/service"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=t.default.extend({store:(0,l.inject)(),type:"",enginePathParam(){const{backend:e}=this.paramsFor("vault.cluster.secrets.backend")
return e},async fetchConnection(e){try{return await this.store.query("database/connection",e)}catch(t){return t.httpStatus}},async fetchAllRoles(e){try{return await this.store.query("database/role",e)}catch(t){return t.httpStatus}},pathQuery:(e,t)=>({id:`${e}/${t}/`}),async fetchCapabilitiesRole(e){return this.store.queryRecord("capabilities",this.pathQuery(e.backend,"roles"))},async fetchCapabilitiesStaticRole(e){return this.store.queryRecord("capabilities",this.pathQuery(e.backend,"static-roles"))},async fetchCapabilitiesConnection(e){return this.store.queryRecord("capabilities",this.pathQuery(e.backend,"config"))},model(){const e=this.enginePathParam(),t={backend:e,id:""},l=this.fetchConnection(t),a=this.fetchAllRoles(t),i=this.fetchCapabilitiesRole(t),r=this.fetchCapabilitiesStaticRole(t),o=this.fetchCapabilitiesConnection(t)
return(0,n.hash)({backend:e,connections:l,roles:a,engineType:"database",id:e,roleCapabilities:i,staticRoleCapabilities:r,connectionCapabilities:o,icon:"database"})},setupController(e,t){this._super(...arguments)
const n=404===t.connections&&404===t.roles,l=!t.connectionCapabilities.canList&&!t.connectionCapabilities.canCreate&&!t.connectionCapabilities.canUpdate
e.set("showEmptyState",n),e.set("emptyStateMessage",l?"You cannot yet generate credentials.  Ask your administrator if you think you should have access.":"You can connect an external database to Vault.  We recommend that you create a user for Vault rather than using the database root user.")}})
e.default=a})),define("vault/routes/vault/cluster/secrets/backend/secret-edit",["exports","@ember-data/adapter/error","@ember/object","ember","rsvp","@ember/service","@ember/routing/route","vault/utils/path-encoding-helpers","core/utils/key-utils"],(function(e,t,n,l,a,i,r,o,s){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var u=r.default.extend({store:(0,i.inject)(),pathHelp:(0,i.inject)("path-help"),router:(0,i.inject)(),wizard:(0,i.inject)(),secretParam(){const{secret:e}=this.paramsFor(this.routeName)
return e?(0,o.normalizePath)(e):""},enginePathParam(){const{backend:e}=this.paramsFor("vault.cluster.secrets.backend")
return e},capabilities(e,t){const n=this.enginePathParam(),l=this.modelFor("vault.cluster.secrets.backend"),a=l.engineType
let i
return i=l.isV2KV?`${n}/data/${e}`:"transit"===a?n+"/keys/"+e:"ssh"===a||"aws"===a?n+"/roles/"+e:t.startsWith("transform/")?this.buildTransformPath(n,e,t):n+"/"+e,this.store.findRecord("capabilities",i)},buildTransformPath:(e,t,n)=>`${e}/${n.split("/")[1]}/${t}`,modelTypeForTransform:e=>e?e.startsWith("role/")?"transform/role":e.startsWith("template/")?"transform/template":e.startsWith("alphabet/")?"transform/alphabet":"transform":"transform",transformSecretName(e,t){const n=t.split("/")[1]
return e.replace(`${n}/`,"")},backendType(){return this.modelFor("vault.cluster.secrets.backend").get("engineType")},templateName:"vault/cluster/secrets/backend/secretEditLayout",beforeModel(e){let{to:{queryParams:t}}=e
const n=this.secretParam(),l=this.modelFor("vault.cluster.secrets.backend")
return this.buildModel(n,t).then((()=>{const e=(0,s.parentKeyForKey)(n),t=this.routeName.split(".").pop()
return"kv"===l.type&&2===l.version?n?this.router.transitionTo("vault.cluster.secrets.backend.kv.secret.details",l.id,n):this.router.transitionTo("vault.cluster.secrets.backend.kv.create",l.id):"edit"===t&&(0,s.keyIsFolder)(n)?e?this.router.transitionTo("vault.cluster.secrets.backend.list",(0,o.encodePath)(e)):this.router.transitionTo("vault.cluster.secrets.backend.list-root"):void 0}))},buildModel(e,t){const n=this.enginePathParam(),l=this.modelType(n,e,{queryParams:t})
return["secret","secret-v2"].includes(l)?(0,a.resolve)():this.pathHelp.getNewModel(l,n)},modelType(e,t){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{}
const l=this.modelFor("vault.cluster.secrets.backend",e),a=l.get("engineType")
return{database:t&&t.startsWith("role/")?"database/role":"database/connection",transit:"transit-key",ssh:"role-ssh",transform:this.modelTypeForTransform(t),aws:"role-aws",cubbyhole:"secret",kv:l.modelTypeForKV,keymgmt:`keymgmt/${n.queryParams?.itemType||"key"}`,generic:l.modelTypeForKV}[a]},getTargetVersion:(e,t)=>e?parseInt(t||e,10):t?parseInt(t,10):null,async fetchV2Models(e,l,a){const i=this.enginePathParam(),r=this.modelFor("vault.cluster.secrets.backend",i),o=this.getTargetVersion(l.currentVersion,a.version),s=l.versions&&l.versions.findBy("version",o)
if(!s&&!0!==l.failedServerRead){const e=new t.default
throw(0,n.set)(e,"httpStatus",404),e}return l.set("engine",r),l.set("selectedVersion",await this.fetchV2VersionModel(e,l,s,o)),l},async fetchV2VersionModel(e,t,n,l){const a=this.secretParam(),i=this.enginePathParam(),r=l?[i,a,l]:[i,a]
let o
try{t.failedServerRead?o=await this.store.findRecord("secret-v2-version",JSON.stringify(r),{reload:!0}):(n.rollbackAttributes(),o=await n.reload())}catch(s){if(403!==s.httpStatus)throw s
n?(n.set("failedServerRead",!0),o=n):(this.store.push({data:{type:"secret-v2-version",id:JSON.stringify(r),attributes:{failedServerRead:!0}}}),o=this.store.peekRecord("secret-v2-version",JSON.stringify(r)))}return o},handleSecretModelError(e,t,n,l){if(!e.get("canUpdate")&&"secret"===n)throw l
this.store.push({data:{id:t,type:n,attributes:{failedServerRead:!0}}})
return this.store.peekRecord(n,t)},updateWizard(e){"provider"===e.itemType&&"displayProvider"===this.wizard.nextStep&&this.wizard.transitionFeatureMachine(this.wizard.featureState,"CONTINUE","keymgmt")},async model(e,t){let{to:{queryParams:n}}=t
this.updateWizard(e)
let l=this.secretParam()
const a=this.enginePathParam(),i=this.modelType(a,l,{queryParams:n}),r=e.type||""
let o
l||(l=" "),i.startsWith("transform/")&&(l=this.transformSecretName(l,i)),"database/role"===i&&(l=l.replace("role/",""))
const s=this.capabilities(l,i)
try{o=await this.store.queryRecord(i,{id:l,backend:a,type:r})}catch(u){if(403!==u.httpStatus||"secret-v2"!==i&&"secret"!==i)throw u
await s,o=this.handleSecretModelError(s,l,i,u)}return await s,"secret-v2"===i&&(o=await this.fetchV2Models(s,o,e)),{secret:o,capabilities:s}},setupController(e,t){this._super(...arguments)
const n=this.secretParam(),l=this.enginePathParam(),a=this.controllerFor("vault.cluster.secrets.backend").get("preferAdvancedEdit")||!1,i=this.backendType()
t.secret.setProperties({backend:l}),e.setProperties({model:t.secret,capabilities:t.capabilities,baseKey:{id:n},mode:this.routeName.split(".").pop().replace("-root",""),backend:l,preferAdvancedEdit:a,backendType:i})},resetController(e){e.reset&&"function"==typeof e.reset&&e.reset()},actions:{error(e){const t=this.secretParam(),l=this.enginePathParam()
return(0,n.set)(e,"keyId",l+"/"+t),(0,n.set)(e,"backend",l),!0},refreshModel(){this.refresh()},willTransition(e){const{mode:t,model:n}=this.controller
if(!n.hasDirtyAttributes||n.isDeleted)return!0
const a=n.get("selectedVersion"),i=n.changedAttributes(),r=Object.keys(i)
return"edit"===t&&r.length&&"currentVersion"===r[0]?(a&&a.rollbackAttributes(),!0):"show"!==t&&r.length&&"backend"!==r[0]||"show"!==t&&a&&a.hasDirtyAttributes?l.default.testing||window.confirm("You have unsaved changes. Navigating away will discard these changes. Are you sure you want to discard your changes?")?(a&&a.rollbackAttributes(),n&&n.rollbackAttributes(),!0):(e.abort(),!1):this._super(...arguments)}}})
e.default=u})),define("vault/routes/vault/cluster/secrets/backend/show-root",["exports","vault/routes/vault/cluster/secrets/backend/show"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/routes/vault/cluster/secrets/backend/show",["exports","vault/routes/vault/cluster/secrets/backend/secret-edit"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({queryParams:{version:{refreshModel:!0}}})
e.default=n})),define("vault/routes/vault/cluster/secrets/backend/sign-root",["exports","vault/routes/vault/cluster/secrets/backend/sign"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/routes/vault/cluster/secrets/backend/sign",["exports","@ember/routing/route","vault/mixins/unload-model-route","@ember/service"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=t.default.extend(n.default,{store:(0,l.inject)(),templateName:"vault/cluster/secrets/backend/sign",backendModel(){return this.modelFor("vault.cluster.secrets.backend")},pathQuery:(e,t)=>({id:`${t}/sign/${e}`}),pathForType:()=>"sign",model(e){const t=e.secret,n=this.backendModel(),l=n.get("id")
return"ssh"!==n.get("type")?this.transitionTo("vault.cluster.secrets.backend.list-root",l):this.store.queryRecord("capabilities",this.pathQuery(t,l)).then((e=>e.get("canUpdate")?this.store.createRecord("ssh-sign",{role:{backend:l,id:t,name:t},id:`${l}-${t}`}):this.transitionTo("vault.cluster.secrets.backend.list-root",l)))},setupController(e){this._super(...arguments),e.set("backend",this.backendModel())}})
e.default=a})),define("vault/routes/vault/cluster/secrets/backend/versions-root",["exports","vault/routes/vault/cluster/secrets/backend/version"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/routes/vault/cluster/secrets/backend/versions",["exports","@ember/routing/route","vault/mixins/unload-model-route","vault/utils/path-encoding-helpers","@ember/service","core/utils/key-utils"],(function(e,t,n,l,a,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var r=t.default.extend(n.default,{store:(0,a.inject)(),templateName:"vault/cluster/secrets/backend/versions",beforeModel(){const e=this.modelFor("vault.cluster.secrets.backend"),{secret:t}=this.paramsFor(this.routeName),n=(0,i.parentKeyForKey)(t)
if(!e.get("isV2KV"))return n?this.transitionTo("vault.cluster.secrets.backend.list",n):this.transitionTo("vault.cluster.secrets.backend.list-root")},model(e){const{secret:t}=e,{backend:n}=this.paramsFor("vault.cluster.secrets.backend"),a=(0,l.normalizePath)(t)
return this.store.queryRecord("secret-v2",{id:a,backend:n})}})
e.default=r})),define("vault/routes/vault/cluster/secrets/backends",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend({store:(0,n.inject)(),model(){return this.store.query("secret-engine",{})}})
e.default=l})),define("vault/routes/vault/cluster/settings",["exports","@ember/routing/route","vault/mixins/cluster-route"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend(n.default,{model:()=>({})})
e.default=l})),define("vault/routes/vault/cluster/settings/auth/configure",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend({store:(0,n.inject)(),model(){const{method:e}=this.paramsFor(this.routeName)
return this.store.findAll("auth-method").then((()=>this.store.peekRecord("auth-method",e)))}})
e.default=l}))
define("vault/routes/vault/cluster/settings/auth/configure/index",["exports","@ember/routing/route","vault/helpers/tabs-for-auth-section"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend({beforeModel(){const e=this.modelFor("vault.cluster.settings.auth.configure"),t=(0,n.tabsForAuthSection)([e]).firstObject.routeParams.lastObject
return this.transitionTo("vault.cluster.settings.auth.configure.section",t)}})
e.default=l})),define("vault/routes/vault/cluster/settings/auth/configure/section",["exports","@ember-data/adapter/error","@ember/service","@ember/object","@ember/routing/route","rsvp","vault/mixins/unload-model-route"],(function(e,t,n,l,a,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var o=a.default.extend(r.default,{modelPath:"model.model",pathHelp:(0,n.inject)("path-help"),store:(0,n.inject)(),modelType:(e,t)=>({"aws-client":"auth-config/aws/client","aws-identity-accesslist":"auth-config/aws/identity-accesslist","aws-roletag-denylist":"auth-config/aws/roletag-denylist","azure-configuration":"auth-config/azure","github-configuration":"auth-config/github","gcp-configuration":"auth-config/gcp","jwt-configuration":"auth-config/jwt","oidc-configuration":"auth-config/oidc","kubernetes-configuration":"auth-config/kubernetes","ldap-configuration":"auth-config/ldap","okta-configuration":"auth-config/okta","radius-configuration":"auth-config/radius"}[`${e}-${t}`]),beforeModel(){const{section_name:e}=this.paramsFor(this.routeName)
if("options"===e)return
const{method:t}=this.paramsFor("vault.cluster.settings.auth.configure"),n=this.modelFor("vault.cluster.settings.auth.configure"),l=this.modelType(n.type,e)
return this.pathHelp.getNewModel(l,t,n.apiPath)},model(e){const n=this.modelFor("vault.cluster.settings.auth.configure"),{section_name:a}=e
if("options"===a)return i.default.hash({model:n,section:a})
const r=this.modelType(n.get("type"),a)
if(!r){const e=new t.default
throw(0,l.set)(e,"httpStatus",404),e}const o=this.store.peekRecord(r,n.id)
return o?i.default.hash({model:o,section:a}):this.store.findRecord(r,n.id).then((e=>(e.set("backend",n),i.default.hash({model:e,section:a})))).catch((e=>{let t
if(404===e.httpStatus)return t=this.store.createRecord(r,{id:n.id}),t.set("backend",n),i.default.hash({model:t,section:a})
throw e}))},actions:{willTransition(){if("auth-method"!==this.currentModel.model.constructor.modelName)return this.unloadModel(),!0}}})
e.default=o})),define("vault/routes/vault/cluster/settings/auth/enable",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}model(){const e=this.store.createRecord("auth-method")
return e.set("config",this.store.createRecord("mount-config")),e}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/settings/auth/index",["exports","@ember/routing/route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({beforeModel(){return this.replaceWith("vault.cluster.settings.auth.enable")}})
e.default=n})),define("vault/routes/vault/cluster/settings/configure-secret-backend",["exports","@ember-data/adapter/error","@ember/object","@ember/routing/route","@ember/service"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=["aws","ssh"]
var r=l.default.extend({store:(0,a.inject)(),model(){const{backend:e}=this.paramsFor(this.routeName)
return this.store.query("secret-engine",{path:e}).then((l=>{const a=l&&l.get("firstObject")
if(!a||!i.includes(a.get("type"))){const e=new t.default
throw(0,n.set)(e,"httpStatus",404),e}return this.store.findRecord("secret-engine",e).then((()=>a),(()=>a))}))},afterModel(e){const t=e.get("type")
return"aws"===t?this.store.queryRecord("secret-engine",{backend:e.id,type:t}).then((()=>e),(()=>e)):e},setupController(e,t){return t.get("publicKey")&&e.set("configured",!0),this._super(...arguments)},resetController(e,t){t&&e.reset()},actions:{refreshRoute(){this.refresh()}}})
e.default=r})),define("vault/routes/vault/cluster/settings/index",["exports","@ember/routing/route"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({beforeModel:function(e){if(e.targetName===this.routeName)return e.abort(),this.replaceWith("vault.cluster.settings.mount-secret-backend")}})
e.default=n})),define("vault/routes/vault/cluster/settings/mount-secret-backend",["exports","@ember/routing/route","@ember/service"],(function(e,t,n){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
let i=(l=class extends t.default{constructor(){var e,t,n,l
super(...arguments),e=this,t="store",l=this,(n=a)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(l):void 0})}model(){const e=this.store.createRecord("secret-engine")
return e.set("config",this.store.createRecord("mount-config")),e}},r=l.prototype,o="store",s=[n.inject],u={configurable:!0,enumerable:!0,writable:!0,initializer:null},c={},Object.keys(u).forEach((function(e){c[e]=u[e]})),c.enumerable=!!c.enumerable,c.configurable=!!c.configurable,("value"in c||c.initializer)&&(c.writable=!0),c=s.slice().reverse().reduce((function(e,t){return t(r,o,e)||e}),c),d&&void 0!==c.initializer&&(c.value=c.initializer?c.initializer.call(d):void 0,c.initializer=void 0),void 0===c.initializer&&(Object.defineProperty(r,o,c),c=null),a=c,l)
var r,o,s,u,d,c
e.default=i})),define("vault/routes/vault/cluster/settings/seal",["exports","rsvp","@ember/routing/route","@ember/service"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=n.default.extend({store:(0,l.inject)(),model(){return(0,t.hash)({cluster:this.modelFor("vault.cluster"),seal:this.store.findRecord("capabilities","sys/seal")})}})
e.default=a})),define("vault/routes/vault/cluster/storage",["exports","@ember/routing/route","vault/mixins/cluster-route","@ember/service"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=t.default.extend(n.default,{store:(0,l.inject)(),model(){return this.store.query("server",{})},actions:{doRefresh(){this.refresh()}}})
e.default=a})),define("vault/routes/vault/cluster/tools",["exports","@ember/routing/route","vault/mixins/cluster-route"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend(n.default,{model(){return this.modelFor("vault.cluster")}})
e.default=l})),define("vault/routes/vault/cluster/tools/index",["exports","@ember/service","@ember/routing/route","vault/helpers/tools-actions"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=n.default.extend({currentCluster:(0,t.inject)(),beforeModel(e){const t=this.currentCluster.cluster.name,n=(0,l.toolsActions)()
if(e.targetName===this.routeName)return e.abort(),this.replaceWith("vault.cluster.tools.tool",t,n[0])}})
e.default=a})),define("vault/routes/vault/cluster/tools/tool",["exports","@ember/routing/route","vault/helpers/tools-actions"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend({model(e){if((0,n.toolsActions)().includes(e.selected_action))return e.selected_action
throw new Error("Given param is not a supported tool action")},setupController(e,t){this._super(...arguments),e.set("selectedAction",t)},actions:{didTransition(){const e=this.paramsFor(this.routeName)
return this.controller.setProperties(e),!0}}})
e.default=l})),define("vault/routes/vault/cluster/unseal",["exports","vault/routes/vault/cluster/cluster-route-base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({})
e.default=n})),define("vault/serializers/-default",["exports","@ember-data/serializer/json"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/serializers/-json-api",["exports","@ember-data/serializer/json-api"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/serializers/-rest",["exports","@ember-data/serializer/rest"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/serializers/application",["exports","@ember-data/serializer/json","@ember/utils","@ember/polyfills","@ember/string"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var i=t.default.extend({keyForAttribute:function(e){return(0,a.decamelize)(e)},normalizeItems(e){if(e.data&&e.data.keys&&Array.isArray(e.data.keys)){return e.data.keys.map((t=>{if("string"!=typeof t)return t
let n={[this.primaryKey||"id"]:t}
return e._requestQuery&&(n={...n,...e._requestQuery}),n}))}return(0,l.assign)(e,e.data),delete e.data,e},pushPayload(e,t){const n=this.normalizeResponse(e,e.modelFor(t.modelName),t,t.id,"findRecord")
return e.push(n)},normalizeResponse(e,t,n,l,a){const i=this.normalizeItems(n,a)
delete n._requestQuery,l&&!i.id&&(i.id=l)
let r=this._super(e,t,i,l,a)
return t.relatedCapabilities&&(r=t.relatedCapabilities(r)),r},serializeAttribute(e,t,l,a){const i=e.attr(l),r=(0,n.isNone)(e.changedAttributes()[l]),o=(0,n.isBlank)(i)
a.options.readOnly||o&&r||this._super(e,t,l,a)},serializeBelongsTo:(e,t)=>t})
e.default=i})),define("vault/serializers/auth-method",["exports","vault/serializers/application","@ember-data/serializer/rest"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend(n.EmbeddedRecordsMixin,{attrs:{config:{embedded:"always"}},normalize(e,t){return t.config&&!t.config.id&&(t.config.id=t.uuid),this._super(e,t)},normalizeBackend(e,t){const n={...t}
return n.id=e.slice(0,-1),n.path=e,n},normalizeResponse(e,t,n,l,a){const i="createRecord"===a?n.data:Object.keys(n.data).map((e=>this.normalizeBackend(e,n.data[e])))
return this._super(e,t,i,l,a)}})
e.default=l})),define("vault/serializers/capabilities",["exports","vault/serializers/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({primaryKey:"path",normalizeResponse(e,t,n,l,a){l&&(n.path=l)
const i={...n.data,path:n.path}
return this._super(e,t,i,l,a)},modelNameFromPayloadKey:()=>"capabilities"})
e.default=n})),define("vault/serializers/clients/activity",["exports","vault/serializers/application","date-fns","core/utils/client-count-utils","core/utils/timestamp"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends t.default{normalizeResponse(e,t,i,r,o){if("no-data"===i.id)return super.normalizeResponse(e,t,i,r,o)
const s=(0,n.formatISO)(a.default.now()),u={...i,response_timestamp:s,by_namespace:(0,l.formatByNamespace)(i.data.by_namespace),by_month:(0,l.formatByMonths)(i.data.months),total:(0,l.homogenizeClientNaming)(i.data.total)}
return delete i.data.by_namespace,delete i.data.months,delete i.data.total,super.normalizeResponse(e,t,u,r,o)}}e.default=i})),define("vault/serializers/clients/config",["exports","vault/serializers/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{constructor(){var e,t,n
super(...arguments),n={billingStartTimestamp:{serialize:!1},minimumRetentionMonths:{serialize:!1},reportingEnabled:{serialize:!1}},(t="attrs")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}normalizeResponse(e,t,n,l,a){if(!n.data)return super.normalizeResponse(...arguments)
const i={id:n.id,data:{...n.data,enabled:n.data.enabled?.includes("enable")?"On":"Off"}}
return super.normalizeResponse(e,t,i,l,a)}serialize(){const e=super.serialize(...arguments)
if("On"===e.enabled||"Off"===e.enabled){const t=e.enabled
e.enabled="On"===t?"enable":"disable"}if(e.retention_months=parseInt(e.retention_months,10),isNaN(e.retention_months))throw new Error("Invalid number value")
return delete e.queries_available,e}}e.default=n})),define("vault/serializers/clients/version-history",["exports","vault/serializers/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{constructor(){var e,t,n
super(...arguments),n="version",(t="primaryKey")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}normalizeItems(e){if(e.data.keys&&Array.isArray(e.data.keys))return e.data.keys.map((t=>({version:t,...e.data.key_info[t]})))}}e.default=n})),define("vault/serializers/cluster",["exports","@ember-data/serializer/rest","@ember/polyfills","@ember/string","vault/utils/identity-manager"],(function(e,t,n,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=new a.default
var r=t.default.extend(t.EmbeddedRecordsMixin,{keyForAttribute:function(e){return(0,l.decamelize)(e)},attrs:{nodes:{embedded:"always"},dr:{embedded:"always"},performance:{embedded:"always"}},setReplicationId(e){e&&(e.id=e.cluster_id||i.fetch())},normalize(e,t){return this.setReplicationId(t.dr),this.setReplicationId(t.performance),this._super(e,t)},pushPayload(e,t){const n=this.normalizeResponse(e,e.modelFor("cluster"),t,null,"findAll")
return e.push(n)},normalizeResponse(e,t,l,a,i){const r={clusters:(0,n.assign)({id:"1"},l.data||l)}
return this._super(e,t,r,a,i)}})
e.default=r})),define("vault/serializers/config",["exports","@ember-data/serializer/rest","@ember/polyfills","@ember/string"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var a=t.default.extend({keyForAttribute:function(e){return(0,l.decamelize)(e)},normalizeAll(e){if(e.data){return[(0,n.assign)({},e,e.data)]}return[e]},normalizeResponse(e,t,n,l,a){const i=this.normalizeAll(n),{modelName:r}=t
let o={[r]:i}
return"queryRecord"===a&&(o={[r]:i[0]}),this._super(e,t,o,l,a)}})
e.default=a})),define("vault/serializers/control-group",["exports","@ember-data/serializer/rest","vault/serializers/application"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=n.default.extend(t.EmbeddedRecordsMixin,{attrs:{requestEntity:{embedded:"always"},authorizations:{embedded:"always"}},normalizeResponse(e,t,n){const l=n?.data?.request_entity
if(Array.isArray(n.data.authorizations))for(const a of n.data.authorizations)a.id=a.entity_id,a.name=a.entity_name
return l&&0===Object.keys(l).length&&(n.data.request_entity=null),this._super(...arguments)},serialize:e=>({accessor:e.id})})
e.default=l})),define("vault/serializers/database/connection",["exports","@ember-data/serializer/rest","vault/utils/database-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=t.default.extend({primaryKey:"name",serializeAttribute(e,t,n,l){void 0!==e.attr(n)&&(e.record.get("isNew")||e.changedAttributes()[n])&&this._super(e,t,n,l)},normalizeSecrets(e){if(e.data.keys&&Array.isArray(e.data.keys)){return e.data.keys.map((t=>({name:t,backend:e.backend})))}const t={id:e.id,name:e.id,backend:e.backend,...e.data,...e.data.connection_details}
return e.data.root_credentials_rotate_statements&&(t.root_rotation_statements=e.data.root_credentials_rotate_statements),t},normalizeResponse(e,t,n,l,a){const i=["updateRecord","createRecord","deleteRecord"].includes(a)?{name:n.data.name,backend:n.data.backend}:this.normalizeSecrets(n),{modelName:r}=t
let o={[r]:i}
return"queryRecord"===a&&(o={[r]:{id:l,...i}}),this._super(e,t,o,l,a)},serialize(e,t){const l=this._super(e,t)
if(!l.plugin_name)return l
const a=n.AVAILABLE_PLUGIN_TYPES.find((e=>e.value===l.plugin_name))
if(!a)return l
const i=a.fields.map((e=>e.attr)).concat("backend"),r=Object.keys(l).filter((e=>i.includes(e)))
for(const n in l)"allowed_roles"===n||r.includes(n)||delete l[n]
return l}})
e.default=l})),define("vault/serializers/database/credential",["exports","@ember-data/serializer/rest"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({primaryKey:"username",normalizePayload(e){if(e.data)return{username:e.data.username,password:e.data.password,leaseId:e.lease_id,leaseDuration:e.lease_duration,lastVaultRotation:e.data.last_vault_rotation,rotationPeriod:e.data.rotation_period,ttl:e.data.ttl,roleType:e.roleType}},normalizeResponse(e,t,n,l,a){const i=this.normalizePayload(n),{modelName:r}=t,o={[r]:i}
return this._super(e,t,o,l,a)}})
e.default=n})),define("vault/serializers/database/role",["exports","@ember-data/serializer/rest"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({primaryKey:"name",normalizeSecrets(e){if(e.data.keys&&Array.isArray(e.data.keys)){return e.data.keys.map((t=>{let n="dynamic",l="roles"
return e.data.staticRoles.includes(t)&&(n="static",l="static-roles"),{name:t,backend:e.backend,type:n,path:l}}))}let t="roles"
"static"===e.type&&(t="static-roles")
let n=[]
e.data.db_name&&(n=[e.data.db_name])
let l="",a=""
return e.data.creation_statements&&(l=e.data.creation_statements[0]),e.data.revocation_statements&&(a=e.data.revocation_statements[0]),{id:e.id,backend:e.backend,name:e.id,type:e.type,database:n,path:t,creation_statement:l,revocation_statement:a,...e.data}},normalizeResponse(e,t,n,l,a){const i=["updateRecord","createRecord","deleteRecord"].includes(a)?{name:l,backend:n.backend}:this.normalizeSecrets(n),{modelName:r}=t
let o={[r]:i}
return"queryRecord"===a&&(o={[r]:i}),this._super(e,t,o,l,a)},serializeAttribute(e,t,n,l){void 0!==e.attr(n)&&(e.record.get("isNew")||e.changedAttributes()[n])&&this._super(e,t,n,l)},serialize(e,t){const n=this._super(e,t)
if(n.database){const e=n.database[0]
n.db_name=e,delete n.database}if(n.creation_statement){const e=n.creation_statement
n.creation_statements=[e],delete n.creation_statement}if(n.revocation_statement){const e=n.revocation_statement
n.revocation_statements=[e],delete n.revocation_statement}return n}})
e.default=n})),define("vault/serializers/identity/_base",["exports","@ember/polyfills","vault/serializers/application"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=n.default.extend({normalizeItems:e=>e.data.keys&&Array.isArray(e.data.keys)?"string"!=typeof e.data.keys[0]?e.data.keys:e.data.keys.map((t=>{const n=e.data.key_info[t]
return n.id=t,n})):((0,t.assign)(e,e.data),delete e.data,e)})
e.default=l})),define("vault/serializers/identity/entity-alias",["exports","vault/serializers/identity/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend({extractLazyPaginatedData:e=>e.data.keys.map((t=>{const n=e.data.key_info[t]
return n.id=t,e.backend&&(n.backend=e.backend),n}))})
e.default=n}))
define("vault/serializers/identity/entity",["exports","@ember-data/serializer/rest","vault/serializers/identity/_base"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=n.default.extend(t.EmbeddedRecordsMixin,{serializeHasMany(){},attrs:{aliases:{embedded:"always"}},extractLazyPaginatedData:e=>e.data.keys.map((t=>{const n=e.data.key_info[t]
return n.id=t,e.backend&&(n.backend=e.backend),n}))})
e.default=l})),define("vault/serializers/identity/group-alias",["exports","vault/serializers/identity/_base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var n=t.default.extend()
e.default=n})),define("vault/serializers/identity/group",["exports","@ember-data/serializer/rest","vault/serializers/identity/_base"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
var l=n.default.extend(t.EmbeddedRecordsMixin,{attrs:{alias:{embedded:"always"}},normalizeFindRecordResponse(e,t,n){return n.alias&&0===Object.keys(n.alias).length&&delete n.alias,this._super(...arguments)},serialize(){const e=this._super(...arguments)
return delete e.alias,"external"===e.type&&(delete e.member_entity_ids,delete e.member_group_ids),e}})
e.default=l})),define("vault/serializers/keymgmt/key",["exports","vault/serializers/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{normalizeItems(e){const t=super.normalizeItems(e)
if(t.versions){let e,n
const l=[]
return Object.keys(t.versions).forEach(((a,i,r)=>{l.push({id:parseInt(a,10),...t.versions[a]}),0===i?n=t.versions[a].creation_time:r.length-1===i&&(e=t.versions[a].creation_time)})),t.versions=l,{...t,last_rotated:e,created:n}}return Array.isArray(t)?t.map((t=>({id:t.id,name:t.id,backend:e.backend}))):t}}e.default=n})),define("vault/serializers/keymgmt/provider",["exports","vault/serializers/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{constructor(){var e,t,n
super(...arguments),n="name",(t="primaryKey")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}normalizeItems(e){const t=super.normalizeItems(e)
return Array.isArray(t)&&t.forEach((t=>{t.id=t.name,t.backend=e.backend})),t}serialize(e){return{...super.serialize(...arguments),credentials:e.record.credentials}}}e.default=n})),define("vault/serializers/kubernetes/config",["exports","vault/serializers/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{constructor(){var e,t,n
super(...arguments),n="backend",(t="primaryKey")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}serialize(){const e=super.serialize(...arguments)
return delete e.backend,!1===e.disable_local_ca_jwt&&(e.kubernetes_ca_cert=null,e.kubernetes_host=null,e.service_account_jwt=null),e}}e.default=n})),define("vault/serializers/kubernetes/role",["exports","vault/serializers/application"],(function(e,t){function n(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{constructor(){super(...arguments),n(this,"primaryKey","name"),n(this,"attrs",{backend:{serialize:!1}})}}e.default=l})),define("vault/serializers/kv/data",["exports","vault/serializers/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{serialize(e){const{secretData:t,casVersion:n}=e.record
return"number"==typeof n?{data:t,options:{cas:n}}:{data:t}}normalizeKvData(e){const{data:t,metadata:n}=e.data
return{...e,data:{...e.data,secret_data:t,...n}}}normalizeResponse(e,t,n,l,a){if("queryRecord"===a){const i=this.normalizeKvData(n)
return super.normalizeResponse(e,t,i,l,a)}return super.normalizeResponse(e,t,n,l,a)}}e.default=n})),define("vault/serializers/kv/metadata",["exports","@ember/debug","vault/serializers/application","vault/utils/kv-path"],(function(e,t,n,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class a extends n.default{constructor(){var e,t,n
super(...arguments),n={backend:{serialize:!1},path:{serialize:!1},oldestVersion:{serialize:!1},createdTime:{serialize:!1},updatedTime:{serialize:!1},currentVersion:{serialize:!1},versions:{serialize:!1}},(t="attrs")in(e=this)?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n}normalizeItems(e){return e.data.keys?e.data.keys.map((t=>{const n=e.path?e.path+t:t
return{id:(0,l.kvMetadataPath)(e.back