/* This file is part of ClanBomber <http://www.nongnu.org/clanbomber>.
 * Copyright (C) 2008-2011, 2017 Rene Lopez <rsl@member.fsf.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "Extra_Snail.hpp"

#include "Bomber.h"
#include "Disease_Slow.hpp"
#include "Resources.h"

Extra_Snail::Extra_Snail(int _x, int _y, ClanBomberApplication *_app)
  : Extra(_x, _y, _app)
{
  sprite_nr = 8;
  destroyable = false;
  //TODO Network
}

//~Extra();

/*inline ExtraType Extra_Snail::get_ExtraType()
{
  return SNAIL;
  }*/

void Extra_Snail::effect(Bomber* bomber)
{
  bomber->loose_disease();
  bomber->infect(new Disease_Slow(bomber));
  //TODO Create or find a new sound for this
  Resources::Credits_rewind()->play();
}
