/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// ManagedKeyDetailsInfo struct for ManagedKeyDetailsInfo
type ManagedKeyDetailsInfo struct {
	IsProvidedByUser *bool `json:"is_provided_by_user,omitempty"`
	IsUnexportable *bool `json:"is_unexportable,omitempty"`
	// ItemState defines the different states an Item can be in
	KeyState *string `json:"key_state,omitempty"`
	KeyType *string `json:"key_type,omitempty"`
	ManagedKeyId *string `json:"managed_key_id,omitempty"`
	TargetAliasHelper *string `json:"target_alias_helper,omitempty"`
	Targets *[]ManagedKeyTargetInfo `json:"targets,omitempty"`
}

// NewManagedKeyDetailsInfo instantiates a new ManagedKeyDetailsInfo object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewManagedKeyDetailsInfo() *ManagedKeyDetailsInfo {
	this := ManagedKeyDetailsInfo{}
	return &this
}

// NewManagedKeyDetailsInfoWithDefaults instantiates a new ManagedKeyDetailsInfo object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewManagedKeyDetailsInfoWithDefaults() *ManagedKeyDetailsInfo {
	this := ManagedKeyDetailsInfo{}
	return &this
}

// GetIsProvidedByUser returns the IsProvidedByUser field value if set, zero value otherwise.
func (o *ManagedKeyDetailsInfo) GetIsProvidedByUser() bool {
	if o == nil || o.IsProvidedByUser == nil {
		var ret bool
		return ret
	}
	return *o.IsProvidedByUser
}

// GetIsProvidedByUserOk returns a tuple with the IsProvidedByUser field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ManagedKeyDetailsInfo) GetIsProvidedByUserOk() (*bool, bool) {
	if o == nil || o.IsProvidedByUser == nil {
		return nil, false
	}
	return o.IsProvidedByUser, true
}

// HasIsProvidedByUser returns a boolean if a field has been set.
func (o *ManagedKeyDetailsInfo) HasIsProvidedByUser() bool {
	if o != nil && o.IsProvidedByUser != nil {
		return true
	}

	return false
}

// SetIsProvidedByUser gets a reference to the given bool and assigns it to the IsProvidedByUser field.
func (o *ManagedKeyDetailsInfo) SetIsProvidedByUser(v bool) {
	o.IsProvidedByUser = &v
}

// GetIsUnexportable returns the IsUnexportable field value if set, zero value otherwise.
func (o *ManagedKeyDetailsInfo) GetIsUnexportable() bool {
	if o == nil || o.IsUnexportable == nil {
		var ret bool
		return ret
	}
	return *o.IsUnexportable
}

// GetIsUnexportableOk returns a tuple with the IsUnexportable field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ManagedKeyDetailsInfo) GetIsUnexportableOk() (*bool, bool) {
	if o == nil || o.IsUnexportable == nil {
		return nil, false
	}
	return o.IsUnexportable, true
}

// HasIsUnexportable returns a boolean if a field has been set.
func (o *ManagedKeyDetailsInfo) HasIsUnexportable() bool {
	if o != nil && o.IsUnexportable != nil {
		return true
	}

	return false
}

// SetIsUnexportable gets a reference to the given bool and assigns it to the IsUnexportable field.
func (o *ManagedKeyDetailsInfo) SetIsUnexportable(v bool) {
	o.IsUnexportable = &v
}

// GetKeyState returns the KeyState field value if set, zero value otherwise.
func (o *ManagedKeyDetailsInfo) GetKeyState() string {
	if o == nil || o.KeyState == nil {
		var ret string
		return ret
	}
	return *o.KeyState
}

// GetKeyStateOk returns a tuple with the KeyState field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ManagedKeyDetailsInfo) GetKeyStateOk() (*string, bool) {
	if o == nil || o.KeyState == nil {
		return nil, false
	}
	return o.KeyState, true
}

// HasKeyState returns a boolean if a field has been set.
func (o *ManagedKeyDetailsInfo) HasKeyState() bool {
	if o != nil && o.KeyState != nil {
		return true
	}

	return false
}

// SetKeyState gets a reference to the given string and assigns it to the KeyState field.
func (o *ManagedKeyDetailsInfo) SetKeyState(v string) {
	o.KeyState = &v
}

// GetKeyType returns the KeyType field value if set, zero value otherwise.
func (o *ManagedKeyDetailsInfo) GetKeyType() string {
	if o == nil || o.KeyType == nil {
		var ret string
		return ret
	}
	return *o.KeyType
}

// GetKeyTypeOk returns a tuple with the KeyType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ManagedKeyDetailsInfo) GetKeyTypeOk() (*string, bool) {
	if o == nil || o.KeyType == nil {
		return nil, false
	}
	return o.KeyType, true
}

// HasKeyType returns a boolean if a field has been set.
func (o *ManagedKeyDetailsInfo) HasKeyType() bool {
	if o != nil && o.KeyType != nil {
		return true
	}

	return false
}

// SetKeyType gets a reference to the given string and assigns it to the KeyType field.
func (o *ManagedKeyDetailsInfo) SetKeyType(v string) {
	o.KeyType = &v
}

// GetManagedKeyId returns the ManagedKeyId field value if set, zero value otherwise.
func (o *ManagedKeyDetailsInfo) GetManagedKeyId() string {
	if o == nil || o.ManagedKeyId == nil {
		var ret string
		return ret
	}
	return *o.ManagedKeyId
}

// GetManagedKeyIdOk returns a tuple with the ManagedKeyId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ManagedKeyDetailsInfo) GetManagedKeyIdOk() (*string, bool) {
	if o == nil || o.ManagedKeyId == nil {
		return nil, false
	}
	return o.ManagedKeyId, true
}

// HasManagedKeyId returns a boolean if a field has been set.
func (o *ManagedKeyDetailsInfo) HasManagedKeyId() bool {
	if o != nil && o.ManagedKeyId != nil {
		return true
	}

	return false
}

// SetManagedKeyId gets a reference to the given string and assigns it to the ManagedKeyId field.
func (o *ManagedKeyDetailsInfo) SetManagedKeyId(v string) {
	o.ManagedKeyId = &v
}

// GetTargetAliasHelper returns the TargetAliasHelper field value if set, zero value otherwise.
func (o *ManagedKeyDetailsInfo) GetTargetAliasHelper() string {
	if o == nil || o.TargetAliasHelper == nil {
		var ret string
		return ret
	}
	return *o.TargetAliasHelper
}

// GetTargetAliasHelperOk returns a tuple with the TargetAliasHelper field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ManagedKeyDetailsInfo) GetTargetAliasHelperOk() (*string, bool) {
	if o == nil || o.TargetAliasHelper == nil {
		return nil, false
	}
	return o.TargetAliasHelper, true
}

// HasTargetAliasHelper returns a boolean if a field has been set.
func (o *ManagedKeyDetailsInfo) HasTargetAliasHelper() bool {
	if o != nil && o.TargetAliasHelper != nil {
		return true
	}

	return false
}

// SetTargetAliasHelper gets a reference to the given string and assigns it to the TargetAliasHelper field.
func (o *ManagedKeyDetailsInfo) SetTargetAliasHelper(v string) {
	o.TargetAliasHelper = &v
}

// GetTargets returns the Targets field value if set, zero value otherwise.
func (o *ManagedKeyDetailsInfo) GetTargets() []ManagedKeyTargetInfo {
	if o == nil || o.Targets == nil {
		var ret []ManagedKeyTargetInfo
		return ret
	}
	return *o.Targets
}

// GetTargetsOk returns a tuple with the Targets field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ManagedKeyDetailsInfo) GetTargetsOk() (*[]ManagedKeyTargetInfo, bool) {
	if o == nil || o.Targets == nil {
		return nil, false
	}
	return o.Targets, true
}

// HasTargets returns a boolean if a field has been set.
func (o *ManagedKeyDetailsInfo) HasTargets() bool {
	if o != nil && o.Targets != nil {
		return true
	}

	return false
}

// SetTargets gets a reference to the given []ManagedKeyTargetInfo and assigns it to the Targets field.
func (o *ManagedKeyDetailsInfo) SetTargets(v []ManagedKeyTargetInfo) {
	o.Targets = &v
}

func (o ManagedKeyDetailsInfo) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.IsProvidedByUser != nil {
		toSerialize["is_provided_by_user"] = o.IsProvidedByUser
	}
	if o.IsUnexportable != nil {
		toSerialize["is_unexportable"] = o.IsUnexportable
	}
	if o.KeyState != nil {
		toSerialize["key_state"] = o.KeyState
	}
	if o.KeyType != nil {
		toSerialize["key_type"] = o.KeyType
	}
	if o.ManagedKeyId != nil {
		toSerialize["managed_key_id"] = o.ManagedKeyId
	}
	if o.TargetAliasHelper != nil {
		toSerialize["target_alias_helper"] = o.TargetAliasHelper
	}
	if o.Targets != nil {
		toSerialize["targets"] = o.Targets
	}
	return json.Marshal(toSerialize)
}

type NullableManagedKeyDetailsInfo struct {
	value *ManagedKeyDetailsInfo
	isSet bool
}

func (v NullableManagedKeyDetailsInfo) Get() *ManagedKeyDetailsInfo {
	return v.value
}

func (v *NullableManagedKeyDetailsInfo) Set(val *ManagedKeyDetailsInfo) {
	v.value = val
	v.isSet = true
}

func (v NullableManagedKeyDetailsInfo) IsSet() bool {
	return v.isSet
}

func (v *NullableManagedKeyDetailsInfo) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableManagedKeyDetailsInfo(val *ManagedKeyDetailsInfo) *NullableManagedKeyDetailsInfo {
	return &NullableManagedKeyDetailsInfo{value: val, isSet: true}
}

func (v NullableManagedKeyDetailsInfo) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableManagedKeyDetailsInfo) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


