/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// ListSRABastions struct for ListSRABastions
type ListSRABastions struct {
	// Filter the response to show only bastions allowed URLs
	AllowedUrlsOnly *bool `json:"allowed-urls-only,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewListSRABastions instantiates a new ListSRABastions object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewListSRABastions() *ListSRABastions {
	this := ListSRABastions{}
	var allowedUrlsOnly bool = false
	this.AllowedUrlsOnly = &allowedUrlsOnly
	var json bool = false
	this.Json = &json
	return &this
}

// NewListSRABastionsWithDefaults instantiates a new ListSRABastions object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewListSRABastionsWithDefaults() *ListSRABastions {
	this := ListSRABastions{}
	var allowedUrlsOnly bool = false
	this.AllowedUrlsOnly = &allowedUrlsOnly
	var json bool = false
	this.Json = &json
	return &this
}

// GetAllowedUrlsOnly returns the AllowedUrlsOnly field value if set, zero value otherwise.
func (o *ListSRABastions) GetAllowedUrlsOnly() bool {
	if o == nil || o.AllowedUrlsOnly == nil {
		var ret bool
		return ret
	}
	return *o.AllowedUrlsOnly
}

// GetAllowedUrlsOnlyOk returns a tuple with the AllowedUrlsOnly field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ListSRABastions) GetAllowedUrlsOnlyOk() (*bool, bool) {
	if o == nil || o.AllowedUrlsOnly == nil {
		return nil, false
	}
	return o.AllowedUrlsOnly, true
}

// HasAllowedUrlsOnly returns a boolean if a field has been set.
func (o *ListSRABastions) HasAllowedUrlsOnly() bool {
	if o != nil && o.AllowedUrlsOnly != nil {
		return true
	}

	return false
}

// SetAllowedUrlsOnly gets a reference to the given bool and assigns it to the AllowedUrlsOnly field.
func (o *ListSRABastions) SetAllowedUrlsOnly(v bool) {
	o.AllowedUrlsOnly = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *ListSRABastions) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ListSRABastions) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *ListSRABastions) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *ListSRABastions) SetJson(v bool) {
	o.Json = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *ListSRABastions) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ListSRABastions) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *ListSRABastions) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *ListSRABastions) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *ListSRABastions) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ListSRABastions) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *ListSRABastions) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *ListSRABastions) SetUidToken(v string) {
	o.UidToken = &v
}

func (o ListSRABastions) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AllowedUrlsOnly != nil {
		toSerialize["allowed-urls-only"] = o.AllowedUrlsOnly
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableListSRABastions struct {
	value *ListSRABastions
	isSet bool
}

func (v NullableListSRABastions) Get() *ListSRABastions {
	return v.value
}

func (v *NullableListSRABastions) Set(val *ListSRABastions) {
	v.value = val
	v.isSet = true
}

func (v NullableListSRABastions) IsSet() bool {
	return v.isSet
}

func (v *NullableListSRABastions) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableListSRABastions(val *ListSRABastions) *NullableListSRABastions {
	return &NullableListSRABastions{value: val, isSet: true}
}

func (v NullableListSRABastions) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableListSRABastions) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


