/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GKETargetDetails GKETargetDetails defines details related to connecting to a GKE (Google Kubernetes Engine) target
type GKETargetDetails struct {
	GkeClusterCaCertificate *string `json:"gke_cluster_ca_certificate,omitempty"`
	GkeClusterEndpoint *string `json:"gke_cluster_endpoint,omitempty"`
	GkeClusterName *string `json:"gke_cluster_name,omitempty"`
	GkeServiceAccountKey *string `json:"gke_service_account_key,omitempty"`
	GkeServiceAccountName *string `json:"gke_service_account_name,omitempty"`
	UseGwCloudIdentity *bool `json:"use_gw_cloud_identity,omitempty"`
}

// NewGKETargetDetails instantiates a new GKETargetDetails object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGKETargetDetails() *GKETargetDetails {
	this := GKETargetDetails{}
	return &this
}

// NewGKETargetDetailsWithDefaults instantiates a new GKETargetDetails object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGKETargetDetailsWithDefaults() *GKETargetDetails {
	this := GKETargetDetails{}
	return &this
}

// GetGkeClusterCaCertificate returns the GkeClusterCaCertificate field value if set, zero value otherwise.
func (o *GKETargetDetails) GetGkeClusterCaCertificate() string {
	if o == nil || o.GkeClusterCaCertificate == nil {
		var ret string
		return ret
	}
	return *o.GkeClusterCaCertificate
}

// GetGkeClusterCaCertificateOk returns a tuple with the GkeClusterCaCertificate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GKETargetDetails) GetGkeClusterCaCertificateOk() (*string, bool) {
	if o == nil || o.GkeClusterCaCertificate == nil {
		return nil, false
	}
	return o.GkeClusterCaCertificate, true
}

// HasGkeClusterCaCertificate returns a boolean if a field has been set.
func (o *GKETargetDetails) HasGkeClusterCaCertificate() bool {
	if o != nil && o.GkeClusterCaCertificate != nil {
		return true
	}

	return false
}

// SetGkeClusterCaCertificate gets a reference to the given string and assigns it to the GkeClusterCaCertificate field.
func (o *GKETargetDetails) SetGkeClusterCaCertificate(v string) {
	o.GkeClusterCaCertificate = &v
}

// GetGkeClusterEndpoint returns the GkeClusterEndpoint field value if set, zero value otherwise.
func (o *GKETargetDetails) GetGkeClusterEndpoint() string {
	if o == nil || o.GkeClusterEndpoint == nil {
		var ret string
		return ret
	}
	return *o.GkeClusterEndpoint
}

// GetGkeClusterEndpointOk returns a tuple with the GkeClusterEndpoint field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GKETargetDetails) GetGkeClusterEndpointOk() (*string, bool) {
	if o == nil || o.GkeClusterEndpoint == nil {
		return nil, false
	}
	return o.GkeClusterEndpoint, true
}

// HasGkeClusterEndpoint returns a boolean if a field has been set.
func (o *GKETargetDetails) HasGkeClusterEndpoint() bool {
	if o != nil && o.GkeClusterEndpoint != nil {
		return true
	}

	return false
}

// SetGkeClusterEndpoint gets a reference to the given string and assigns it to the GkeClusterEndpoint field.
func (o *GKETargetDetails) SetGkeClusterEndpoint(v string) {
	o.GkeClusterEndpoint = &v
}

// GetGkeClusterName returns the GkeClusterName field value if set, zero value otherwise.
func (o *GKETargetDetails) GetGkeClusterName() string {
	if o == nil || o.GkeClusterName == nil {
		var ret string
		return ret
	}
	return *o.GkeClusterName
}

// GetGkeClusterNameOk returns a tuple with the GkeClusterName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GKETargetDetails) GetGkeClusterNameOk() (*string, bool) {
	if o == nil || o.GkeClusterName == nil {
		return nil, false
	}
	return o.GkeClusterName, true
}

// HasGkeClusterName returns a boolean if a field has been set.
func (o *GKETargetDetails) HasGkeClusterName() bool {
	if o != nil && o.GkeClusterName != nil {
		return true
	}

	return false
}

// SetGkeClusterName gets a reference to the given string and assigns it to the GkeClusterName field.
func (o *GKETargetDetails) SetGkeClusterName(v string) {
	o.GkeClusterName = &v
}

// GetGkeServiceAccountKey returns the GkeServiceAccountKey field value if set, zero value otherwise.
func (o *GKETargetDetails) GetGkeServiceAccountKey() string {
	if o == nil || o.GkeServiceAccountKey == nil {
		var ret string
		return ret
	}
	return *o.GkeServiceAccountKey
}

// GetGkeServiceAccountKeyOk returns a tuple with the GkeServiceAccountKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GKETargetDetails) GetGkeServiceAccountKeyOk() (*string, bool) {
	if o == nil || o.GkeServiceAccountKey == nil {
		return nil, false
	}
	return o.GkeServiceAccountKey, true
}

// HasGkeServiceAccountKey returns a boolean if a field has been set.
func (o *GKETargetDetails) HasGkeServiceAccountKey() bool {
	if o != nil && o.GkeServiceAccountKey != nil {
		return true
	}

	return false
}

// SetGkeServiceAccountKey gets a reference to the given string and assigns it to the GkeServiceAccountKey field.
func (o *GKETargetDetails) SetGkeServiceAccountKey(v string) {
	o.GkeServiceAccountKey = &v
}

// GetGkeServiceAccountName returns the GkeServiceAccountName field value if set, zero value otherwise.
func (o *GKETargetDetails) GetGkeServiceAccountName() string {
	if o == nil || o.GkeServiceAccountName == nil {
		var ret string
		return ret
	}
	return *o.GkeServiceAccountName
}

// GetGkeServiceAccountNameOk returns a tuple with the GkeServiceAccountName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GKETargetDetails) GetGkeServiceAccountNameOk() (*string, bool) {
	if o == nil || o.GkeServiceAccountName == nil {
		return nil, false
	}
	return o.GkeServiceAccountName, true
}

// HasGkeServiceAccountName returns a boolean if a field has been set.
func (o *GKETargetDetails) HasGkeServiceAccountName() bool {
	if o != nil && o.GkeServiceAccountName != nil {
		return true
	}

	return false
}

// SetGkeServiceAccountName gets a reference to the given string and assigns it to the GkeServiceAccountName field.
func (o *GKETargetDetails) SetGkeServiceAccountName(v string) {
	o.GkeServiceAccountName = &v
}

// GetUseGwCloudIdentity returns the UseGwCloudIdentity field value if set, zero value otherwise.
func (o *GKETargetDetails) GetUseGwCloudIdentity() bool {
	if o == nil || o.UseGwCloudIdentity == nil {
		var ret bool
		return ret
	}
	return *o.UseGwCloudIdentity
}

// GetUseGwCloudIdentityOk returns a tuple with the UseGwCloudIdentity field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GKETargetDetails) GetUseGwCloudIdentityOk() (*bool, bool) {
	if o == nil || o.UseGwCloudIdentity == nil {
		return nil, false
	}
	return o.UseGwCloudIdentity, true
}

// HasUseGwCloudIdentity returns a boolean if a field has been set.
func (o *GKETargetDetails) HasUseGwCloudIdentity() bool {
	if o != nil && o.UseGwCloudIdentity != nil {
		return true
	}

	return false
}

// SetUseGwCloudIdentity gets a reference to the given bool and assigns it to the UseGwCloudIdentity field.
func (o *GKETargetDetails) SetUseGwCloudIdentity(v bool) {
	o.UseGwCloudIdentity = &v
}

func (o GKETargetDetails) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.GkeClusterCaCertificate != nil {
		toSerialize["gke_cluster_ca_certificate"] = o.GkeClusterCaCertificate
	}
	if o.GkeClusterEndpoint != nil {
		toSerialize["gke_cluster_endpoint"] = o.GkeClusterEndpoint
	}
	if o.GkeClusterName != nil {
		toSerialize["gke_cluster_name"] = o.GkeClusterName
	}
	if o.GkeServiceAccountKey != nil {
		toSerialize["gke_service_account_key"] = o.GkeServiceAccountKey
	}
	if o.GkeServiceAccountName != nil {
		toSerialize["gke_service_account_name"] = o.GkeServiceAccountName
	}
	if o.UseGwCloudIdentity != nil {
		toSerialize["use_gw_cloud_identity"] = o.UseGwCloudIdentity
	}
	return json.Marshal(toSerialize)
}

type NullableGKETargetDetails struct {
	value *GKETargetDetails
	isSet bool
}

func (v NullableGKETargetDetails) Get() *GKETargetDetails {
	return v.value
}

func (v *NullableGKETargetDetails) Set(val *GKETargetDetails) {
	v.value = val
	v.isSet = true
}

func (v NullableGKETargetDetails) IsSet() bool {
	return v.isSet
}

func (v *NullableGKETargetDetails) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGKETargetDetails(val *GKETargetDetails) *NullableGKETargetDetails {
	return &NullableGKETargetDetails{value: val, isSet: true}
}

func (v NullableGKETargetDetails) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGKETargetDetails) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


