/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GatewayUpdateLogForwardingSyslog gatewayUpdateLogForwardingSyslog is a command that updates log forwarding config (syslog target)
type GatewayUpdateLogForwardingSyslog struct {
	// Enable Log Forwarding [true/false]
	Enable *string `json:"enable,omitempty"`
	// Enable tls relevant only for network type TCP
	EnableTls *bool `json:"enable-tls,omitempty"`
	// Syslog formatter [text/cef]
	Formatter *string `json:"formatter,omitempty"`
	// Syslog host
	Host *string `json:"host,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Syslog network [tcp/udp]
	Network *string `json:"network,omitempty"`
	// Logs format [text/json]
	OutputFormat *string `json:"output-format,omitempty"`
	// Pull interval in seconds
	PullInterval *string `json:"pull-interval,omitempty"`
	// Syslog target tag
	TargetTag *string `json:"target-tag,omitempty"`
	// Syslog tls certificate
	TlsCertificate *string `json:"tls-certificate,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewGatewayUpdateLogForwardingSyslog instantiates a new GatewayUpdateLogForwardingSyslog object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGatewayUpdateLogForwardingSyslog() *GatewayUpdateLogForwardingSyslog {
	this := GatewayUpdateLogForwardingSyslog{}
	var enable string = "true"
	this.Enable = &enable
	var formatter string = "text"
	this.Formatter = &formatter
	var json bool = false
	this.Json = &json
	var network string = "tcp"
	this.Network = &network
	var outputFormat string = "text"
	this.OutputFormat = &outputFormat
	var pullInterval string = "10"
	this.PullInterval = &pullInterval
	var targetTag string = "use-existing"
	this.TargetTag = &targetTag
	var tlsCertificate string = "use-existing"
	this.TlsCertificate = &tlsCertificate
	return &this
}

// NewGatewayUpdateLogForwardingSyslogWithDefaults instantiates a new GatewayUpdateLogForwardingSyslog object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGatewayUpdateLogForwardingSyslogWithDefaults() *GatewayUpdateLogForwardingSyslog {
	this := GatewayUpdateLogForwardingSyslog{}
	var enable string = "true"
	this.Enable = &enable
	var formatter string = "text"
	this.Formatter = &formatter
	var json bool = false
	this.Json = &json
	var network string = "tcp"
	this.Network = &network
	var outputFormat string = "text"
	this.OutputFormat = &outputFormat
	var pullInterval string = "10"
	this.PullInterval = &pullInterval
	var targetTag string = "use-existing"
	this.TargetTag = &targetTag
	var tlsCertificate string = "use-existing"
	this.TlsCertificate = &tlsCertificate
	return &this
}

// GetEnable returns the Enable field value if set, zero value otherwise.
func (o *GatewayUpdateLogForwardingSyslog) GetEnable() string {
	if o == nil || o.Enable == nil {
		var ret string
		return ret
	}
	return *o.Enable
}

// GetEnableOk returns a tuple with the Enable field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLogForwardingSyslog) GetEnableOk() (*string, bool) {
	if o == nil || o.Enable == nil {
		return nil, false
	}
	return o.Enable, true
}

// HasEnable returns a boolean if a field has been set.
func (o *GatewayUpdateLogForwardingSyslog) HasEnable() bool {
	if o != nil && o.Enable != nil {
		return true
	}

	return false
}

// SetEnable gets a reference to the given string and assigns it to the Enable field.
func (o *GatewayUpdateLogForwardingSyslog) SetEnable(v string) {
	o.Enable = &v
}

// GetEnableTls returns the EnableTls field value if set, zero value otherwise.
func (o *GatewayUpdateLogForwardingSyslog) GetEnableTls() bool {
	if o == nil || o.EnableTls == nil {
		var ret bool
		return ret
	}
	return *o.EnableTls
}

// GetEnableTlsOk returns a tuple with the EnableTls field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLogForwardingSyslog) GetEnableTlsOk() (*bool, bool) {
	if o == nil || o.EnableTls == nil {
		return nil, false
	}
	return o.EnableTls, true
}

// HasEnableTls returns a boolean if a field has been set.
func (o *GatewayUpdateLogForwardingSyslog) HasEnableTls() bool {
	if o != nil && o.EnableTls != nil {
		return true
	}

	return false
}

// SetEnableTls gets a reference to the given bool and assigns it to the EnableTls field.
func (o *GatewayUpdateLogForwardingSyslog) SetEnableTls(v bool) {
	o.EnableTls = &v
}

// GetFormatter returns the Formatter field value if set, zero value otherwise.
func (o *GatewayUpdateLogForwardingSyslog) GetFormatter() string {
	if o == nil || o.Formatter == nil {
		var ret string
		return ret
	}
	return *o.Formatter
}

// GetFormatterOk returns a tuple with the Formatter field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLogForwardingSyslog) GetFormatterOk() (*string, bool) {
	if o == nil || o.Formatter == nil {
		return nil, false
	}
	return o.Formatter, true
}

// HasFormatter returns a boolean if a field has been set.
func (o *GatewayUpdateLogForwardingSyslog) HasFormatter() bool {
	if o != nil && o.Formatter != nil {
		return true
	}

	return false
}

// SetFormatter gets a reference to the given string and assigns it to the Formatter field.
func (o *GatewayUpdateLogForwardingSyslog) SetFormatter(v string) {
	o.Formatter = &v
}

// GetHost returns the Host field value if set, zero value otherwise.
func (o *GatewayUpdateLogForwardingSyslog) GetHost() string {
	if o == nil || o.Host == nil {
		var ret string
		return ret
	}
	return *o.Host
}

// GetHostOk returns a tuple with the Host field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLogForwardingSyslog) GetHostOk() (*string, bool) {
	if o == nil || o.Host == nil {
		return nil, false
	}
	return o.Host, true
}

// HasHost returns a boolean if a field has been set.
func (o *GatewayUpdateLogForwardingSyslog) HasHost() bool {
	if o != nil && o.Host != nil {
		return true
	}

	return false
}

// SetHost gets a reference to the given string and assigns it to the Host field.
func (o *GatewayUpdateLogForwardingSyslog) SetHost(v string) {
	o.Host = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *GatewayUpdateLogForwardingSyslog) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLogForwardingSyslog) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *GatewayUpdateLogForwardingSyslog) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *GatewayUpdateLogForwardingSyslog) SetJson(v bool) {
	o.Json = &v
}

// GetNetwork returns the Network field value if set, zero value otherwise.
func (o *GatewayUpdateLogForwardingSyslog) GetNetwork() string {
	if o == nil || o.Network == nil {
		var ret string
		return ret
	}
	return *o.Network
}

// GetNetworkOk returns a tuple with the Network field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLogForwardingSyslog) GetNetworkOk() (*string, bool) {
	if o == nil || o.Network == nil {
		return nil, false
	}
	return o.Network, true
}

// HasNetwork returns a boolean if a field has been set.
func (o *GatewayUpdateLogForwardingSyslog) HasNetwork() bool {
	if o != nil && o.Network != nil {
		return true
	}

	return false
}

// SetNetwork gets a reference to the given string and assigns it to the Network field.
func (o *GatewayUpdateLogForwardingSyslog) SetNetwork(v string) {
	o.Network = &v
}

// GetOutputFormat returns the OutputFormat field value if set, zero value otherwise.
func (o *GatewayUpdateLogForwardingSyslog) GetOutputFormat() string {
	if o == nil || o.OutputFormat == nil {
		var ret string
		return ret
	}
	return *o.OutputFormat
}

// GetOutputFormatOk returns a tuple with the OutputFormat field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLogForwardingSyslog) GetOutputFormatOk() (*string, bool) {
	if o == nil || o.OutputFormat == nil {
		return nil, false
	}
	return o.OutputFormat, true
}

// HasOutputFormat returns a boolean if a field has been set.
func (o *GatewayUpdateLogForwardingSyslog) HasOutputFormat() bool {
	if o != nil && o.OutputFormat != nil {
		return true
	}

	return false
}

// SetOutputFormat gets a reference to the given string and assigns it to the OutputFormat field.
func (o *GatewayUpdateLogForwardingSyslog) SetOutputFormat(v string) {
	o.OutputFormat = &v
}

// GetPullInterval returns the PullInterval field value if set, zero value otherwise.
func (o *GatewayUpdateLogForwardingSyslog) GetPullInterval() string {
	if o == nil || o.PullInterval == nil {
		var ret string
		return ret
	}
	return *o.PullInterval
}

// GetPullIntervalOk returns a tuple with the PullInterval field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLogForwardingSyslog) GetPullIntervalOk() (*string, bool) {
	if o == nil || o.PullInterval == nil {
		return nil, false
	}
	return o.PullInterval, true
}

// HasPullInterval returns a boolean if a field has been set.
func (o *GatewayUpdateLogForwardingSyslog) HasPullInterval() bool {
	if o != nil && o.PullInterval != nil {
		return true
	}

	return false
}

// SetPullInterval gets a reference to the given string and assigns it to the PullInterval field.
func (o *GatewayUpdateLogForwardingSyslog) SetPullInterval(v string) {
	o.PullInterval = &v
}

// GetTargetTag returns the TargetTag field value if set, zero value otherwise.
func (o *GatewayUpdateLogForwardingSyslog) GetTargetTag() string {
	if o == nil || o.TargetTag == nil {
		var ret string
		return ret
	}
	return *o.TargetTag
}

// GetTargetTagOk returns a tuple with the TargetTag field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLogForwardingSyslog) GetTargetTagOk() (*string, bool) {
	if o == nil || o.TargetTag == nil {
		return nil, false
	}
	return o.TargetTag, true
}

// HasTargetTag returns a boolean if a field has been set.
func (o *GatewayUpdateLogForwardingSyslog) HasTargetTag() bool {
	if o != nil && o.TargetTag != nil {
		return true
	}

	return false
}

// SetTargetTag gets a reference to the given string and assigns it to the TargetTag field.
func (o *GatewayUpdateLogForwardingSyslog) SetTargetTag(v string) {
	o.TargetTag = &v
}

// GetTlsCertificate returns the TlsCertificate field value if set, zero value otherwise.
func (o *GatewayUpdateLogForwardingSyslog) GetTlsCertificate() string {
	if o == nil || o.TlsCertificate == nil {
		var ret string
		return ret
	}
	return *o.TlsCertificate
}

// GetTlsCertificateOk returns a tuple with the TlsCertificate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLogForwardingSyslog) GetTlsCertificateOk() (*string, bool) {
	if o == nil || o.TlsCertificate == nil {
		return nil, false
	}
	return o.TlsCertificate, true
}

// HasTlsCertificate returns a boolean if a field has been set.
func (o *GatewayUpdateLogForwardingSyslog) HasTlsCertificate() bool {
	if o != nil && o.TlsCertificate != nil {
		return true
	}

	return false
}

// SetTlsCertificate gets a reference to the given string and assigns it to the TlsCertificate field.
func (o *GatewayUpdateLogForwardingSyslog) SetTlsCertificate(v string) {
	o.TlsCertificate = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *GatewayUpdateLogForwardingSyslog) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLogForwardingSyslog) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *GatewayUpdateLogForwardingSyslog) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *GatewayUpdateLogForwardingSyslog) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *GatewayUpdateLogForwardingSyslog) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLogForwardingSyslog) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *GatewayUpdateLogForwardingSyslog) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *GatewayUpdateLogForwardingSyslog) SetUidToken(v string) {
	o.UidToken = &v
}

func (o GatewayUpdateLogForwardingSyslog) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Enable != nil {
		toSerialize["enable"] = o.Enable
	}
	if o.EnableTls != nil {
		toSerialize["enable-tls"] = o.EnableTls
	}
	if o.Formatter != nil {
		toSerialize["formatter"] = o.Formatter
	}
	if o.Host != nil {
		toSerialize["host"] = o.Host
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Network != nil {
		toSerialize["network"] = o.Network
	}
	if o.OutputFormat != nil {
		toSerialize["output-format"] = o.OutputFormat
	}
	if o.PullInterval != nil {
		toSerialize["pull-interval"] = o.PullInterval
	}
	if o.TargetTag != nil {
		toSerialize["target-tag"] = o.TargetTag
	}
	if o.TlsCertificate != nil {
		toSerialize["tls-certificate"] = o.TlsCertificate
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableGatewayUpdateLogForwardingSyslog struct {
	value *GatewayUpdateLogForwardingSyslog
	isSet bool
}

func (v NullableGatewayUpdateLogForwardingSyslog) Get() *GatewayUpdateLogForwardingSyslog {
	return v.value
}

func (v *NullableGatewayUpdateLogForwardingSyslog) Set(val *GatewayUpdateLogForwardingSyslog) {
	v.value = val
	v.isSet = true
}

func (v NullableGatewayUpdateLogForwardingSyslog) IsSet() bool {
	return v.isSet
}

func (v *NullableGatewayUpdateLogForwardingSyslog) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGatewayUpdateLogForwardingSyslog(val *GatewayUpdateLogForwardingSyslog) *NullableGatewayUpdateLogForwardingSyslog {
	return &NullableGatewayUpdateLogForwardingSyslog{value: val, isSet: true}
}

func (v NullableGatewayUpdateLogForwardingSyslog) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGatewayUpdateLogForwardingSyslog) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


