/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// EventForwarderCreateServiceNow eventForwarderCreateServiceNow is a command that creates service-now event forwarder
type EventForwarderCreateServiceNow struct {
	// Workstation Admin Name
	AdminName *string `json:"admin-name,omitempty"`
	// Workstation Admin Password
	AdminPwd *string `json:"admin-pwd,omitempty"`
	// The RSA Private Key to use when connecting with jwt authentication
	AppPrivateKeyBase64 *string `json:"app-private-key-base64,omitempty"`
	// Auth Method Event sources
	AuthMethodsEventSourceLocations *[]string `json:"auth-methods-event-source-locations,omitempty"`
	// The authentication type to use [user-pass/jwt]
	AuthType *string `json:"auth-type,omitempty"`
	// The client ID to use when connecting with jwt authentication
	ClientId *string `json:"client-id,omitempty"`
	// The client secret to use when connecting with jwt authentication
	ClientSecret *string `json:"client-secret,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// List of event types to notify about [request-access, certificate-pending-expiration, certificate-expired, certificate-provisioning-success, certificate-provisioning-failure, auth-method-pending-expiration, auth-method-expired, next-automatic-rotation, rotated-secret-success, rotated-secret-failure, dynamic-secret-failure, multi-auth-failure, uid-rotation-failure, apply-justification, email-auth-method-approved, usage, rotation-usage, gateway-inactive, static-secret-updated, rate-limiting, usage-report]
	EventTypes *[]string `json:"event-types,omitempty"`
	// Rate of periodic runner repetition in hours
	Every *string `json:"every,omitempty"`
	// Event sources
	GatewaysEventSourceLocations []string `json:"gateways-event-source-locations"`
	// Workstation Host
	Host *string `json:"host,omitempty"`
	// Items Event sources
	ItemsEventSourceLocations *[]string `json:"items-event-source-locations,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The name of a key that used to encrypt the EventForwarder secret value (if empty, the account default protectionKey key will be used)
	Key *string `json:"key,omitempty"`
	// EventForwarder name
	Name string `json:"name"`
	RunnerType string `json:"runner-type"`
	// Targets Event sources
	TargetsEventSourceLocations *[]string `json:"targets-event-source-locations,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// The user email to identify with when connecting with jwt authentication
	UserEmail *string `json:"user-email,omitempty"`
}

// NewEventForwarderCreateServiceNow instantiates a new EventForwarderCreateServiceNow object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewEventForwarderCreateServiceNow(gatewaysEventSourceLocations []string, name string, runnerType string, ) *EventForwarderCreateServiceNow {
	this := EventForwarderCreateServiceNow{}
	var authType string = "user-pass"
	this.AuthType = &authType
	this.GatewaysEventSourceLocations = gatewaysEventSourceLocations
	var json bool = false
	this.Json = &json
	this.Name = name
	this.RunnerType = runnerType
	return &this
}

// NewEventForwarderCreateServiceNowWithDefaults instantiates a new EventForwarderCreateServiceNow object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewEventForwarderCreateServiceNowWithDefaults() *EventForwarderCreateServiceNow {
	this := EventForwarderCreateServiceNow{}
	var authType string = "user-pass"
	this.AuthType = &authType
	var json bool = false
	this.Json = &json
	return &this
}

// GetAdminName returns the AdminName field value if set, zero value otherwise.
func (o *EventForwarderCreateServiceNow) GetAdminName() string {
	if o == nil || o.AdminName == nil {
		var ret string
		return ret
	}
	return *o.AdminName
}

// GetAdminNameOk returns a tuple with the AdminName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderCreateServiceNow) GetAdminNameOk() (*string, bool) {
	if o == nil || o.AdminName == nil {
		return nil, false
	}
	return o.AdminName, true
}

// HasAdminName returns a boolean if a field has been set.
func (o *EventForwarderCreateServiceNow) HasAdminName() bool {
	if o != nil && o.AdminName != nil {
		return true
	}

	return false
}

// SetAdminName gets a reference to the given string and assigns it to the AdminName field.
func (o *EventForwarderCreateServiceNow) SetAdminName(v string) {
	o.AdminName = &v
}

// GetAdminPwd returns the AdminPwd field value if set, zero value otherwise.
func (o *EventForwarderCreateServiceNow) GetAdminPwd() string {
	if o == nil || o.AdminPwd == nil {
		var ret string
		return ret
	}
	return *o.AdminPwd
}

// GetAdminPwdOk returns a tuple with the AdminPwd field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderCreateServiceNow) GetAdminPwdOk() (*string, bool) {
	if o == nil || o.AdminPwd == nil {
		return nil, false
	}
	return o.AdminPwd, true
}

// HasAdminPwd returns a boolean if a field has been set.
func (o *EventForwarderCreateServiceNow) HasAdminPwd() bool {
	if o != nil && o.AdminPwd != nil {
		return true
	}

	return false
}

// SetAdminPwd gets a reference to the given string and assigns it to the AdminPwd field.
func (o *EventForwarderCreateServiceNow) SetAdminPwd(v string) {
	o.AdminPwd = &v
}

// GetAppPrivateKeyBase64 returns the AppPrivateKeyBase64 field value if set, zero value otherwise.
func (o *EventForwarderCreateServiceNow) GetAppPrivateKeyBase64() string {
	if o == nil || o.AppPrivateKeyBase64 == nil {
		var ret string
		return ret
	}
	return *o.AppPrivateKeyBase64
}

// GetAppPrivateKeyBase64Ok returns a tuple with the AppPrivateKeyBase64 field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderCreateServiceNow) GetAppPrivateKeyBase64Ok() (*string, bool) {
	if o == nil || o.AppPrivateKeyBase64 == nil {
		return nil, false
	}
	return o.AppPrivateKeyBase64, true
}

// HasAppPrivateKeyBase64 returns a boolean if a field has been set.
func (o *EventForwarderCreateServiceNow) HasAppPrivateKeyBase64() bool {
	if o != nil && o.AppPrivateKeyBase64 != nil {
		return true
	}

	return false
}

// SetAppPrivateKeyBase64 gets a reference to the given string and assigns it to the AppPrivateKeyBase64 field.
func (o *EventForwarderCreateServiceNow) SetAppPrivateKeyBase64(v string) {
	o.AppPrivateKeyBase64 = &v
}

// GetAuthMethodsEventSourceLocations returns the AuthMethodsEventSourceLocations field value if set, zero value otherwise.
func (o *EventForwarderCreateServiceNow) GetAuthMethodsEventSourceLocations() []string {
	if o == nil || o.AuthMethodsEventSourceLocations == nil {
		var ret []string
		return ret
	}
	return *o.AuthMethodsEventSourceLocations
}

// GetAuthMethodsEventSourceLocationsOk returns a tuple with the AuthMethodsEventSourceLocations field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderCreateServiceNow) GetAuthMethodsEventSourceLocationsOk() (*[]string, bool) {
	if o == nil || o.AuthMethodsEventSourceLocations == nil {
		return nil, false
	}
	return o.AuthMethodsEventSourceLocations, true
}

// HasAuthMethodsEventSourceLocations returns a boolean if a field has been set.
func (o *EventForwarderCreateServiceNow) HasAuthMethodsEventSourceLocations() bool {
	if o != nil && o.AuthMethodsEventSourceLocations != nil {
		return true
	}

	return false
}

// SetAuthMethodsEventSourceLocations gets a reference to the given []string and assigns it to the AuthMethodsEventSourceLocations field.
func (o *EventForwarderCreateServiceNow) SetAuthMethodsEventSourceLocations(v []string) {
	o.AuthMethodsEventSourceLocations = &v
}

// GetAuthType returns the AuthType field value if set, zero value otherwise.
func (o *EventForwarderCreateServiceNow) GetAuthType() string {
	if o == nil || o.AuthType == nil {
		var ret string
		return ret
	}
	return *o.AuthType
}

// GetAuthTypeOk returns a tuple with the AuthType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderCreateServiceNow) GetAuthTypeOk() (*string, bool) {
	if o == nil || o.AuthType == nil {
		return nil, false
	}
	return o.AuthType, true
}

// HasAuthType returns a boolean if a field has been set.
func (o *EventForwarderCreateServiceNow) HasAuthType() bool {
	if o != nil && o.AuthType != nil {
		return true
	}

	return false
}

// SetAuthType gets a reference to the given string and assigns it to the AuthType field.
func (o *EventForwarderCreateServiceNow) SetAuthType(v string) {
	o.AuthType = &v
}

// GetClientId returns the ClientId field value if set, zero value otherwise.
func (o *EventForwarderCreateServiceNow) GetClientId() string {
	if o == nil || o.ClientId == nil {
		var ret string
		return ret
	}
	return *o.ClientId
}

// GetClientIdOk returns a tuple with the ClientId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderCreateServiceNow) GetClientIdOk() (*string, bool) {
	if o == nil || o.ClientId == nil {
		return nil, false
	}
	return o.ClientId, true
}

// HasClientId returns a boolean if a field has been set.
func (o *EventForwarderCreateServiceNow) HasClientId() bool {
	if o != nil && o.ClientId != nil {
		return true
	}

	return false
}

// SetClientId gets a reference to the given string and assigns it to the ClientId field.
func (o *EventForwarderCreateServiceNow) SetClientId(v string) {
	o.ClientId = &v
}

// GetClientSecret returns the ClientSecret field value if set, zero value otherwise.
func (o *EventForwarderCreateServiceNow) GetClientSecret() string {
	if o == nil || o.ClientSecret == nil {
		var ret string
		return ret
	}
	return *o.ClientSecret
}

// GetClientSecretOk returns a tuple with the ClientSecret field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderCreateServiceNow) GetClientSecretOk() (*string, bool) {
	if o == nil || o.ClientSecret == nil {
		return nil, false
	}
	return o.ClientSecret, true
}

// HasClientSecret returns a boolean if a field has been set.
func (o *EventForwarderCreateServiceNow) HasClientSecret() bool {
	if o != nil && o.ClientSecret != nil {
		return true
	}

	return false
}

// SetClientSecret gets a reference to the given string and assigns it to the ClientSecret field.
func (o *EventForwarderCreateServiceNow) SetClientSecret(v string) {
	o.ClientSecret = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *EventForwarderCreateServiceNow) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderCreateServiceNow) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *EventForwarderCreateServiceNow) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *EventForwarderCreateServiceNow) SetDescription(v string) {
	o.Description = &v
}

// GetEventTypes returns the EventTypes field value if set, zero value otherwise.
func (o *EventForwarderCreateServiceNow) GetEventTypes() []string {
	if o == nil || o.EventTypes == nil {
		var ret []string
		return ret
	}
	return *o.EventTypes
}

// GetEventTypesOk returns a tuple with the EventTypes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderCreateServiceNow) GetEventTypesOk() (*[]string, bool) {
	if o == nil || o.EventTypes == nil {
		return nil, false
	}
	return o.EventTypes, true
}

// HasEventTypes returns a boolean if a field has been set.
func (o *EventForwarderCreateServiceNow) HasEventTypes() bool {
	if o != nil && o.EventTypes != nil {
		return true
	}

	return false
}

// SetEventTypes gets a reference to the given []string and assigns it to the EventTypes field.
func (o *EventForwarderCreateServiceNow) SetEventTypes(v []string) {
	o.EventTypes = &v
}

// GetEvery returns the Every field value if set, zero value otherwise.
func (o *EventForwarderCreateServiceNow) GetEvery() string {
	if o == nil || o.Every == nil {
		var ret string
		return ret
	}
	return *o.Every
}

// GetEveryOk returns a tuple with the Every field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderCreateServiceNow) GetEveryOk() (*string, bool) {
	if o == nil || o.Every == nil {
		return nil, false
	}
	return o.Every, true
}

// HasEvery returns a boolean if a field has been set.
func (o *EventForwarderCreateServiceNow) HasEvery() bool {
	if o != nil && o.Every != nil {
		return true
	}

	return false
}

// SetEvery gets a reference to the given string and assigns it to the Every field.
func (o *EventForwarderCreateServiceNow) SetEvery(v string) {
	o.Every = &v
}

// GetGatewaysEventSourceLocations returns the GatewaysEventSourceLocations field value
func (o *EventForwarderCreateServiceNow) GetGatewaysEventSourceLocations() []string {
	if o == nil  {
		var ret []string
		return ret
	}

	return o.GatewaysEventSourceLocations
}

// GetGatewaysEventSourceLocationsOk returns a tuple with the GatewaysEventSourceLocations field value
// and a boolean to check if the value has been set.
func (o *EventForwarderCreateServiceNow) GetGatewaysEventSourceLocationsOk() (*[]string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.GatewaysEventSourceLocations, true
}

// SetGatewaysEventSourceLocations sets field value
func (o *EventForwarderCreateServiceNow) SetGatewaysEventSourceLocations(v []string) {
	o.GatewaysEventSourceLocations = v
}

// GetHost returns the Host field value if set, zero value otherwise.
func (o *EventForwarderCreateServiceNow) GetHost() string {
	if o == nil || o.Host == nil {
		var ret string
		return ret
	}
	return *o.Host
}

// GetHostOk returns a tuple with the Host field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderCreateServiceNow) GetHostOk() (*string, bool) {
	if o == nil || o.Host == nil {
		return nil, false
	}
	return o.Host, true
}

// HasHost returns a boolean if a field has been set.
func (o *EventForwarderCreateServiceNow) HasHost() bool {
	if o != nil && o.Host != nil {
		return true
	}

	return false
}

// SetHost gets a reference to the given string and assigns it to the Host field.
func (o *EventForwarderCreateServiceNow) SetHost(v string) {
	o.Host = &v
}

// GetItemsEventSourceLocations returns the ItemsEventSourceLocations field value if set, zero value otherwise.
func (o *EventForwarderCreateServiceNow) GetItemsEventSourceLocations() []string {
	if o == nil || o.ItemsEventSourceLocations == nil {
		var ret []string
		return ret
	}
	return *o.ItemsEventSourceLocations
}

// GetItemsEventSourceLocationsOk returns a tuple with the ItemsEventSourceLocations field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderCreateServiceNow) GetItemsEventSourceLocationsOk() (*[]string, bool) {
	if o == nil || o.ItemsEventSourceLocations == nil {
		return nil, false
	}
	return o.ItemsEventSourceLocations, true
}

// HasItemsEventSourceLocations returns a boolean if a field has been set.
func (o *EventForwarderCreateServiceNow) HasItemsEventSourceLocations() bool {
	if o != nil && o.ItemsEventSourceLocations != nil {
		return true
	}

	return false
}

// SetItemsEventSourceLocations gets a reference to the given []string and assigns it to the ItemsEventSourceLocations field.
func (o *EventForwarderCreateServiceNow) SetItemsEventSourceLocations(v []string) {
	o.ItemsEventSourceLocations = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *EventForwarderCreateServiceNow) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderCreateServiceNow) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *EventForwarderCreateServiceNow) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *EventForwarderCreateServiceNow) SetJson(v bool) {
	o.Json = &v
}

// GetKey returns the Key field value if set, zero value otherwise.
func (o *EventForwarderCreateServiceNow) GetKey() string {
	if o == nil || o.Key == nil {
		var ret string
		return ret
	}
	return *o.Key
}

// GetKeyOk returns a tuple with the Key field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderCreateServiceNow) GetKeyOk() (*string, bool) {
	if o == nil || o.Key == nil {
		return nil, false
	}
	return o.Key, true
}

// HasKey returns a boolean if a field has been set.
func (o *EventForwarderCreateServiceNow) HasKey() bool {
	if o != nil && o.Key != nil {
		return true
	}

	return false
}

// SetKey gets a reference to the given string and assigns it to the Key field.
func (o *EventForwarderCreateServiceNow) SetKey(v string) {
	o.Key = &v
}

// GetName returns the Name field value
func (o *EventForwarderCreateServiceNow) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *EventForwarderCreateServiceNow) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *EventForwarderCreateServiceNow) SetName(v string) {
	o.Name = v
}

// GetRunnerType returns the RunnerType field value
func (o *EventForwarderCreateServiceNow) GetRunnerType() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.RunnerType
}

// GetRunnerTypeOk returns a tuple with the RunnerType field value
// and a boolean to check if the value has been set.
func (o *EventForwarderCreateServiceNow) GetRunnerTypeOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.RunnerType, true
}

// SetRunnerType sets field value
func (o *EventForwarderCreateServiceNow) SetRunnerType(v string) {
	o.RunnerType = v
}

// GetTargetsEventSourceLocations returns the TargetsEventSourceLocations field value if set, zero value otherwise.
func (o *EventForwarderCreateServiceNow) GetTargetsEventSourceLocations() []string {
	if o == nil || o.TargetsEventSourceLocations == nil {
		var ret []string
		return ret
	}
	return *o.TargetsEventSourceLocations
}

// GetTargetsEventSourceLocationsOk returns a tuple with the TargetsEventSourceLocations field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderCreateServiceNow) GetTargetsEventSourceLocationsOk() (*[]string, bool) {
	if o == nil || o.TargetsEventSourceLocations == nil {
		return nil, false
	}
	return o.TargetsEventSourceLocations, true
}

// HasTargetsEventSourceLocations returns a boolean if a field has been set.
func (o *EventForwarderCreateServiceNow) HasTargetsEventSourceLocations() bool {
	if o != nil && o.TargetsEventSourceLocations != nil {
		return true
	}

	return false
}

// SetTargetsEventSourceLocations gets a reference to the given []string and assigns it to the TargetsEventSourceLocations field.
func (o *EventForwarderCreateServiceNow) SetTargetsEventSourceLocations(v []string) {
	o.TargetsEventSourceLocations = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *EventForwarderCreateServiceNow) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderCreateServiceNow) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *EventForwarderCreateServiceNow) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *EventForwarderCreateServiceNow) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *EventForwarderCreateServiceNow) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderCreateServiceNow) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *EventForwarderCreateServiceNow) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *EventForwarderCreateServiceNow) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUserEmail returns the UserEmail field value if set, zero value otherwise.
func (o *EventForwarderCreateServiceNow) GetUserEmail() string {
	if o == nil || o.UserEmail == nil {
		var ret string
		return ret
	}
	return *o.UserEmail
}

// GetUserEmailOk returns a tuple with the UserEmail field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderCreateServiceNow) GetUserEmailOk() (*string, bool) {
	if o == nil || o.UserEmail == nil {
		return nil, false
	}
	return o.UserEmail, true
}

// HasUserEmail returns a boolean if a field has been set.
func (o *EventForwarderCreateServiceNow) HasUserEmail() bool {
	if o != nil && o.UserEmail != nil {
		return true
	}

	return false
}

// SetUserEmail gets a reference to the given string and assigns it to the UserEmail field.
func (o *EventForwarderCreateServiceNow) SetUserEmail(v string) {
	o.UserEmail = &v
}

func (o EventForwarderCreateServiceNow) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AdminName != nil {
		toSerialize["admin-name"] = o.AdminName
	}
	if o.AdminPwd != nil {
		toSerialize["admin-pwd"] = o.AdminPwd
	}
	if o.AppPrivateKeyBase64 != nil {
		toSerialize["app-private-key-base64"] = o.AppPrivateKeyBase64
	}
	if o.AuthMethodsEventSourceLocations != nil {
		toSerialize["auth-methods-event-source-locations"] = o.AuthMethodsEventSourceLocations
	}
	if o.AuthType != nil {
		toSerialize["auth-type"] = o.AuthType
	}
	if o.ClientId != nil {
		toSerialize["client-id"] = o.ClientId
	}
	if o.ClientSecret != nil {
		toSerialize["client-secret"] = o.ClientSecret
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.EventTypes != nil {
		toSerialize["event-types"] = o.EventTypes
	}
	if o.Every != nil {
		toSerialize["every"] = o.Every
	}
	if true {
		toSerialize["gateways-event-source-locations"] = o.GatewaysEventSourceLocations
	}
	if o.Host != nil {
		toSerialize["host"] = o.Host
	}
	if o.ItemsEventSourceLocations != nil {
		toSerialize["items-event-source-locations"] = o.ItemsEventSourceLocations
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Key != nil {
		toSerialize["key"] = o.Key
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if true {
		toSerialize["runner-type"] = o.RunnerType
	}
	if o.TargetsEventSourceLocations != nil {
		toSerialize["targets-event-source-locations"] = o.TargetsEventSourceLocations
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UserEmail != nil {
		toSerialize["user-email"] = o.UserEmail
	}
	return json.Marshal(toSerialize)
}

type NullableEventForwarderCreateServiceNow struct {
	value *EventForwarderCreateServiceNow
	isSet bool
}

func (v NullableEventForwarderCreateServiceNow) Get() *EventForwarderCreateServiceNow {
	return v.value
}

func (v *NullableEventForwarderCreateServiceNow) Set(val *EventForwarderCreateServiceNow) {
	v.value = val
	v.isSet = true
}

func (v NullableEventForwarderCreateServiceNow) IsSet() bool {
	return v.isSet
}

func (v *NullableEventForwarderCreateServiceNow) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableEventForwarderCreateServiceNow(val *EventForwarderCreateServiceNow) *NullableEventForwarderCreateServiceNow {
	return &NullableEventForwarderCreateServiceNow{value: val, isSet: true}
}

func (v NullableEventForwarderCreateServiceNow) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableEventForwarderCreateServiceNow) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


