/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// DynamicSecretUpdateRdp dynamicSecretUpdateRdp is a command that updates rdp dynamic secret
type DynamicSecretUpdateRdp struct {
	// AllowUserExtendSession
	AllowUserExtendSession *int64 `json:"allow-user-extend-session,omitempty"`
	// Protection from accidental deletion of this object [true/false]
	DeleteProtection *string `json:"delete_protection,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// Allow access using externally (IdP) provided username [true/false]
	FixedUserOnly *string `json:"fixed-user-only,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Dynamic secret name
	Name string `json:"name"`
	// Dynamic secret name
	NewName *string `json:"new-name,omitempty"`
	// The length of the password to be generated
	PasswordLength *string `json:"password-length,omitempty"`
	// Dynamic producer encryption key
	ProducerEncryptionKeyName *string `json:"producer-encryption-key-name,omitempty"`
	// RDP Admin Name
	RdpAdminName *string `json:"rdp-admin-name,omitempty"`
	// RDP Admin password
	RdpAdminPwd *string `json:"rdp-admin-pwd,omitempty"`
	// Hostname
	RdpHostName *string `json:"rdp-host-name,omitempty"`
	// Port
	RdpHostPort *string `json:"rdp-host-port,omitempty"`
	// Groups
	RdpUserGroups *string `json:"rdp-user-groups,omitempty"`
	// Allow providing external user for a domain users
	SecureAccessAllowExternalUser *bool `json:"secure-access-allow-external-user,omitempty"`
	// Enable/Disable secure remote access [true/false]
	SecureAccessEnable *string `json:"secure-access-enable,omitempty"`
	// Target servers for connections (In case of Linked Target association, host(s) will inherit Linked Target hosts - Relevant only for Dynamic Secrets/producers)
	SecureAccessHost *[]string `json:"secure-access-host,omitempty"`
	// RD Gateway server
	SecureAccessRdGatewayServer *string `json:"secure-access-rd-gateway-server,omitempty"`
	// Required when the Dynamic Secret is used for a domain user
	SecureAccessRdpDomain *string `json:"secure-access-rdp-domain,omitempty"`
	// Override the RDP Domain username
	SecureAccessRdpUser *string `json:"secure-access-rdp-user,omitempty"`
	// Add tags attached to this object
	Tags *[]string `json:"tags,omitempty"`
	// Target name
	TargetName *string `json:"target-name,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// User TTL
	UserTtl *string `json:"user-ttl,omitempty"`
	// WarnBeforeUserExpiration
	WarnUserBeforeExpiration *int64 `json:"warn-user-before-expiration,omitempty"`
}

// NewDynamicSecretUpdateRdp instantiates a new DynamicSecretUpdateRdp object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDynamicSecretUpdateRdp(name string, ) *DynamicSecretUpdateRdp {
	this := DynamicSecretUpdateRdp{}
	var fixedUserOnly string = "false"
	this.FixedUserOnly = &fixedUserOnly
	var json bool = false
	this.Json = &json
	this.Name = name
	var rdpHostPort string = "22"
	this.RdpHostPort = &rdpHostPort
	var secureAccessAllowExternalUser bool = false
	this.SecureAccessAllowExternalUser = &secureAccessAllowExternalUser
	var userTtl string = "60m"
	this.UserTtl = &userTtl
	return &this
}

// NewDynamicSecretUpdateRdpWithDefaults instantiates a new DynamicSecretUpdateRdp object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDynamicSecretUpdateRdpWithDefaults() *DynamicSecretUpdateRdp {
	this := DynamicSecretUpdateRdp{}
	var fixedUserOnly string = "false"
	this.FixedUserOnly = &fixedUserOnly
	var json bool = false
	this.Json = &json
	var rdpHostPort string = "22"
	this.RdpHostPort = &rdpHostPort
	var secureAccessAllowExternalUser bool = false
	this.SecureAccessAllowExternalUser = &secureAccessAllowExternalUser
	var userTtl string = "60m"
	this.UserTtl = &userTtl
	return &this
}

// GetAllowUserExtendSession returns the AllowUserExtendSession field value if set, zero value otherwise.
func (o *DynamicSecretUpdateRdp) GetAllowUserExtendSession() int64 {
	if o == nil || o.AllowUserExtendSession == nil {
		var ret int64
		return ret
	}
	return *o.AllowUserExtendSession
}

// GetAllowUserExtendSessionOk returns a tuple with the AllowUserExtendSession field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetAllowUserExtendSessionOk() (*int64, bool) {
	if o == nil || o.AllowUserExtendSession == nil {
		return nil, false
	}
	return o.AllowUserExtendSession, true
}

// HasAllowUserExtendSession returns a boolean if a field has been set.
func (o *DynamicSecretUpdateRdp) HasAllowUserExtendSession() bool {
	if o != nil && o.AllowUserExtendSession != nil {
		return true
	}

	return false
}

// SetAllowUserExtendSession gets a reference to the given int64 and assigns it to the AllowUserExtendSession field.
func (o *DynamicSecretUpdateRdp) SetAllowUserExtendSession(v int64) {
	o.AllowUserExtendSession = &v
}

// GetDeleteProtection returns the DeleteProtection field value if set, zero value otherwise.
func (o *DynamicSecretUpdateRdp) GetDeleteProtection() string {
	if o == nil || o.DeleteProtection == nil {
		var ret string
		return ret
	}
	return *o.DeleteProtection
}

// GetDeleteProtectionOk returns a tuple with the DeleteProtection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetDeleteProtectionOk() (*string, bool) {
	if o == nil || o.DeleteProtection == nil {
		return nil, false
	}
	return o.DeleteProtection, true
}

// HasDeleteProtection returns a boolean if a field has been set.
func (o *DynamicSecretUpdateRdp) HasDeleteProtection() bool {
	if o != nil && o.DeleteProtection != nil {
		return true
	}

	return false
}

// SetDeleteProtection gets a reference to the given string and assigns it to the DeleteProtection field.
func (o *DynamicSecretUpdateRdp) SetDeleteProtection(v string) {
	o.DeleteProtection = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *DynamicSecretUpdateRdp) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *DynamicSecretUpdateRdp) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *DynamicSecretUpdateRdp) SetDescription(v string) {
	o.Description = &v
}

// GetFixedUserOnly returns the FixedUserOnly field value if set, zero value otherwise.
func (o *DynamicSecretUpdateRdp) GetFixedUserOnly() string {
	if o == nil || o.FixedUserOnly == nil {
		var ret string
		return ret
	}
	return *o.FixedUserOnly
}

// GetFixedUserOnlyOk returns a tuple with the FixedUserOnly field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetFixedUserOnlyOk() (*string, bool) {
	if o == nil || o.FixedUserOnly == nil {
		return nil, false
	}
	return o.FixedUserOnly, true
}

// HasFixedUserOnly returns a boolean if a field has been set.
func (o *DynamicSecretUpdateRdp) HasFixedUserOnly() bool {
	if o != nil && o.FixedUserOnly != nil {
		return true
	}

	return false
}

// SetFixedUserOnly gets a reference to the given string and assigns it to the FixedUserOnly field.
func (o *DynamicSecretUpdateRdp) SetFixedUserOnly(v string) {
	o.FixedUserOnly = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *DynamicSecretUpdateRdp) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *DynamicSecretUpdateRdp) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *DynamicSecretUpdateRdp) SetJson(v bool) {
	o.Json = &v
}

// GetName returns the Name field value
func (o *DynamicSecretUpdateRdp) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *DynamicSecretUpdateRdp) SetName(v string) {
	o.Name = v
}

// GetNewName returns the NewName field value if set, zero value otherwise.
func (o *DynamicSecretUpdateRdp) GetNewName() string {
	if o == nil || o.NewName == nil {
		var ret string
		return ret
	}
	return *o.NewName
}

// GetNewNameOk returns a tuple with the NewName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetNewNameOk() (*string, bool) {
	if o == nil || o.NewName == nil {
		return nil, false
	}
	return o.NewName, true
}

// HasNewName returns a boolean if a field has been set.
func (o *DynamicSecretUpdateRdp) HasNewName() bool {
	if o != nil && o.NewName != nil {
		return true
	}

	return false
}

// SetNewName gets a reference to the given string and assigns it to the NewName field.
func (o *DynamicSecretUpdateRdp) SetNewName(v string) {
	o.NewName = &v
}

// GetPasswordLength returns the PasswordLength field value if set, zero value otherwise.
func (o *DynamicSecretUpdateRdp) GetPasswordLength() string {
	if o == nil || o.PasswordLength == nil {
		var ret string
		return ret
	}
	return *o.PasswordLength
}

// GetPasswordLengthOk returns a tuple with the PasswordLength field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetPasswordLengthOk() (*string, bool) {
	if o == nil || o.PasswordLength == nil {
		return nil, false
	}
	return o.PasswordLength, true
}

// HasPasswordLength returns a boolean if a field has been set.
func (o *DynamicSecretUpdateRdp) HasPasswordLength() bool {
	if o != nil && o.PasswordLength != nil {
		return true
	}

	return false
}

// SetPasswordLength gets a reference to the given string and assigns it to the PasswordLength field.
func (o *DynamicSecretUpdateRdp) SetPasswordLength(v string) {
	o.PasswordLength = &v
}

// GetProducerEncryptionKeyName returns the ProducerEncryptionKeyName field value if set, zero value otherwise.
func (o *DynamicSecretUpdateRdp) GetProducerEncryptionKeyName() string {
	if o == nil || o.ProducerEncryptionKeyName == nil {
		var ret string
		return ret
	}
	return *o.ProducerEncryptionKeyName
}

// GetProducerEncryptionKeyNameOk returns a tuple with the ProducerEncryptionKeyName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetProducerEncryptionKeyNameOk() (*string, bool) {
	if o == nil || o.ProducerEncryptionKeyName == nil {
		return nil, false
	}
	return o.ProducerEncryptionKeyName, true
}

// HasProducerEncryptionKeyName returns a boolean if a field has been set.
func (o *DynamicSecretUpdateRdp) HasProducerEncryptionKeyName() bool {
	if o != nil && o.ProducerEncryptionKeyName != nil {
		return true
	}

	return false
}

// SetProducerEncryptionKeyName gets a reference to the given string and assigns it to the ProducerEncryptionKeyName field.
func (o *DynamicSecretUpdateRdp) SetProducerEncryptionKeyName(v string) {
	o.ProducerEncryptionKeyName = &v
}

// GetRdpAdminName returns the RdpAdminName field value if set, zero value otherwise.
func (o *DynamicSecretUpdateRdp) GetRdpAdminName() string {
	if o == nil || o.RdpAdminName == nil {
		var ret string
		return ret
	}
	return *o.RdpAdminName
}

// GetRdpAdminNameOk returns a tuple with the RdpAdminName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetRdpAdminNameOk() (*string, bool) {
	if o == nil || o.RdpAdminName == nil {
		return nil, false
	}
	return o.RdpAdminName, true
}

// HasRdpAdminName returns a boolean if a field has been set.
func (o *DynamicSecretUpdateRdp) HasRdpAdminName() bool {
	if o != nil && o.RdpAdminName != nil {
		return true
	}

	return false
}

// SetRdpAdminName gets a reference to the given string and assigns it to the RdpAdminName field.
func (o *DynamicSecretUpdateRdp) SetRdpAdminName(v string) {
	o.RdpAdminName = &v
}

// GetRdpAdminPwd returns the RdpAdminPwd field value if set, zero value otherwise.
func (o *DynamicSecretUpdateRdp) GetRdpAdminPwd() string {
	if o == nil || o.RdpAdminPwd == nil {
		var ret string
		return ret
	}
	return *o.RdpAdminPwd
}

// GetRdpAdminPwdOk returns a tuple with the RdpAdminPwd field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetRdpAdminPwdOk() (*string, bool) {
	if o == nil || o.RdpAdminPwd == nil {
		return nil, false
	}
	return o.RdpAdminPwd, true
}

// HasRdpAdminPwd returns a boolean if a field has been set.
func (o *DynamicSecretUpdateRdp) HasRdpAdminPwd() bool {
	if o != nil && o.RdpAdminPwd != nil {
		return true
	}

	return false
}

// SetRdpAdminPwd gets a reference to the given string and assigns it to the RdpAdminPwd field.
func (o *DynamicSecretUpdateRdp) SetRdpAdminPwd(v string) {
	o.RdpAdminPwd = &v
}

// GetRdpHostName returns the RdpHostName field value if set, zero value otherwise.
func (o *DynamicSecretUpdateRdp) GetRdpHostName() string {
	if o == nil || o.RdpHostName == nil {
		var ret string
		return ret
	}
	return *o.RdpHostName
}

// GetRdpHostNameOk returns a tuple with the RdpHostName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetRdpHostNameOk() (*string, bool) {
	if o == nil || o.RdpHostName == nil {
		return nil, false
	}
	return o.RdpHostName, true
}

// HasRdpHostName returns a boolean if a field has been set.
func (o *DynamicSecretUpdateRdp) HasRdpHostName() bool {
	if o != nil && o.RdpHostName != nil {
		return true
	}

	return false
}

// SetRdpHostName gets a reference to the given string and assigns it to the RdpHostName field.
func (o *DynamicSecretUpdateRdp) SetRdpHostName(v string) {
	o.RdpHostName = &v
}

// GetRdpHostPort returns the RdpHostPort field value if set, zero value otherwise.
func (o *DynamicSecretUpdateRdp) GetRdpHostPort() string {
	if o == nil || o.RdpHostPort == nil {
		var ret string
		return ret
	}
	return *o.RdpHostPort
}

// GetRdpHostPortOk returns a tuple with the RdpHostPort field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetRdpHostPortOk() (*string, bool) {
	if o == nil || o.RdpHostPort == nil {
		return nil, false
	}
	return o.RdpHostPort, true
}

// HasRdpHostPort returns a boolean if a field has been set.
func (o *DynamicSecretUpdateRdp) HasRdpHostPort() bool {
	if o != nil && o.RdpHostPort != nil {
		return true
	}

	return false
}

// SetRdpHostPort gets a reference to the given string and assigns it to the RdpHostPort field.
func (o *DynamicSecretUpdateRdp) SetRdpHostPort(v string) {
	o.RdpHostPort = &v
}

// GetRdpUserGroups returns the RdpUserGroups field value if set, zero value otherwise.
func (o *DynamicSecretUpdateRdp) GetRdpUserGroups() string {
	if o == nil || o.RdpUserGroups == nil {
		var ret string
		return ret
	}
	return *o.RdpUserGroups
}

// GetRdpUserGroupsOk returns a tuple with the RdpUserGroups field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetRdpUserGroupsOk() (*string, bool) {
	if o == nil || o.RdpUserGroups == nil {
		return nil, false
	}
	return o.RdpUserGroups, true
}

// HasRdpUserGroups returns a boolean if a field has been set.
func (o *DynamicSecretUpdateRdp) HasRdpUserGroups() bool {
	if o != nil && o.RdpUserGroups != nil {
		return true
	}

	return false
}

// SetRdpUserGroups gets a reference to the given string and assigns it to the RdpUserGroups field.
func (o *DynamicSecretUpdateRdp) SetRdpUserGroups(v string) {
	o.RdpUserGroups = &v
}

// GetSecureAccessAllowExternalUser returns the SecureAccessAllowExternalUser field value if set, zero value otherwise.
func (o *DynamicSecretUpdateRdp) GetSecureAccessAllowExternalUser() bool {
	if o == nil || o.SecureAccessAllowExternalUser == nil {
		var ret bool
		return ret
	}
	return *o.SecureAccessAllowExternalUser
}

// GetSecureAccessAllowExternalUserOk returns a tuple with the SecureAccessAllowExternalUser field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetSecureAccessAllowExternalUserOk() (*bool, bool) {
	if o == nil || o.SecureAccessAllowExternalUser == nil {
		return nil, false
	}
	return o.SecureAccessAllowExternalUser, true
}

// HasSecureAccessAllowExternalUser returns a boolean if a field has been set.
func (o *DynamicSecretUpdateRdp) HasSecureAccessAllowExternalUser() bool {
	if o != nil && o.SecureAccessAllowExternalUser != nil {
		return true
	}

	return false
}

// SetSecureAccessAllowExternalUser gets a reference to the given bool and assigns it to the SecureAccessAllowExternalUser field.
func (o *DynamicSecretUpdateRdp) SetSecureAccessAllowExternalUser(v bool) {
	o.SecureAccessAllowExternalUser = &v
}

// GetSecureAccessEnable returns the SecureAccessEnable field value if set, zero value otherwise.
func (o *DynamicSecretUpdateRdp) GetSecureAccessEnable() string {
	if o == nil || o.SecureAccessEnable == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessEnable
}

// GetSecureAccessEnableOk returns a tuple with the SecureAccessEnable field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetSecureAccessEnableOk() (*string, bool) {
	if o == nil || o.SecureAccessEnable == nil {
		return nil, false
	}
	return o.SecureAccessEnable, true
}

// HasSecureAccessEnable returns a boolean if a field has been set.
func (o *DynamicSecretUpdateRdp) HasSecureAccessEnable() bool {
	if o != nil && o.SecureAccessEnable != nil {
		return true
	}

	return false
}

// SetSecureAccessEnable gets a reference to the given string and assigns it to the SecureAccessEnable field.
func (o *DynamicSecretUpdateRdp) SetSecureAccessEnable(v string) {
	o.SecureAccessEnable = &v
}

// GetSecureAccessHost returns the SecureAccessHost field value if set, zero value otherwise.
func (o *DynamicSecretUpdateRdp) GetSecureAccessHost() []string {
	if o == nil || o.SecureAccessHost == nil {
		var ret []string
		return ret
	}
	return *o.SecureAccessHost
}

// GetSecureAccessHostOk returns a tuple with the SecureAccessHost field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetSecureAccessHostOk() (*[]string, bool) {
	if o == nil || o.SecureAccessHost == nil {
		return nil, false
	}
	return o.SecureAccessHost, true
}

// HasSecureAccessHost returns a boolean if a field has been set.
func (o *DynamicSecretUpdateRdp) HasSecureAccessHost() bool {
	if o != nil && o.SecureAccessHost != nil {
		return true
	}

	return false
}

// SetSecureAccessHost gets a reference to the given []string and assigns it to the SecureAccessHost field.
func (o *DynamicSecretUpdateRdp) SetSecureAccessHost(v []string) {
	o.SecureAccessHost = &v
}

// GetSecureAccessRdGatewayServer returns the SecureAccessRdGatewayServer field value if set, zero value otherwise.
func (o *DynamicSecretUpdateRdp) GetSecureAccessRdGatewayServer() string {
	if o == nil || o.SecureAccessRdGatewayServer == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessRdGatewayServer
}

// GetSecureAccessRdGatewayServerOk returns a tuple with the SecureAccessRdGatewayServer field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetSecureAccessRdGatewayServerOk() (*string, bool) {
	if o == nil || o.SecureAccessRdGatewayServer == nil {
		return nil, false
	}
	return o.SecureAccessRdGatewayServer, true
}

// HasSecureAccessRdGatewayServer returns a boolean if a field has been set.
func (o *DynamicSecretUpdateRdp) HasSecureAccessRdGatewayServer() bool {
	if o != nil && o.SecureAccessRdGatewayServer != nil {
		return true
	}

	return false
}

// SetSecureAccessRdGatewayServer gets a reference to the given string and assigns it to the SecureAccessRdGatewayServer field.
func (o *DynamicSecretUpdateRdp) SetSecureAccessRdGatewayServer(v string) {
	o.SecureAccessRdGatewayServer = &v
}

// GetSecureAccessRdpDomain returns the SecureAccessRdpDomain field value if set, zero value otherwise.
func (o *DynamicSecretUpdateRdp) GetSecureAccessRdpDomain() string {
	if o == nil || o.SecureAccessRdpDomain == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessRdpDomain
}

// GetSecureAccessRdpDomainOk returns a tuple with the SecureAccessRdpDomain field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetSecureAccessRdpDomainOk() (*string, bool) {
	if o == nil || o.SecureAccessRdpDomain == nil {
		return nil, false
	}
	return o.SecureAccessRdpDomain, true
}

// HasSecureAccessRdpDomain returns a boolean if a field has been set.
func (o *DynamicSecretUpdateRdp) HasSecureAccessRdpDomain() bool {
	if o != nil && o.SecureAccessRdpDomain != nil {
		return true
	}

	return false
}

// SetSecureAccessRdpDomain gets a reference to the given string and assigns it to the SecureAccessRdpDomain field.
func (o *DynamicSecretUpdateRdp) SetSecureAccessRdpDomain(v string) {
	o.SecureAccessRdpDomain = &v
}

// GetSecureAccessRdpUser returns the SecureAccessRdpUser field value if set, zero value otherwise.
func (o *DynamicSecretUpdateRdp) GetSecureAccessRdpUser() string {
	if o == nil || o.SecureAccessRdpUser == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessRdpUser
}

// GetSecureAccessRdpUserOk returns a tuple with the SecureAccessRdpUser field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetSecureAccessRdpUserOk() (*string, bool) {
	if o == nil || o.SecureAccessRdpUser == nil {
		return nil, false
	}
	return o.SecureAccessRdpUser, true
}

// HasSecureAccessRdpUser returns a boolean if a field has been set.
func (o *DynamicSecretUpdateRdp) HasSecureAccessRdpUser() bool {
	if o != nil && o.SecureAccessRdpUser != nil {
		return true
	}

	return false
}

// SetSecureAccessRdpUser gets a reference to the given string and assigns it to the SecureAccessRdpUser field.
func (o *DynamicSecretUpdateRdp) SetSecureAccessRdpUser(v string) {
	o.SecureAccessRdpUser = &v
}

// GetTags returns the Tags field value if set, zero value otherwise.
func (o *DynamicSecretUpdateRdp) GetTags() []string {
	if o == nil || o.Tags == nil {
		var ret []string
		return ret
	}
	return *o.Tags
}

// GetTagsOk returns a tuple with the Tags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetTagsOk() (*[]string, bool) {
	if o == nil || o.Tags == nil {
		return nil, false
	}
	return o.Tags, true
}

// HasTags returns a boolean if a field has been set.
func (o *DynamicSecretUpdateRdp) HasTags() bool {
	if o != nil && o.Tags != nil {
		return true
	}

	return false
}

// SetTags gets a reference to the given []string and assigns it to the Tags field.
func (o *DynamicSecretUpdateRdp) SetTags(v []string) {
	o.Tags = &v
}

// GetTargetName returns the TargetName field value if set, zero value otherwise.
func (o *DynamicSecretUpdateRdp) GetTargetName() string {
	if o == nil || o.TargetName == nil {
		var ret string
		return ret
	}
	return *o.TargetName
}

// GetTargetNameOk returns a tuple with the TargetName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetTargetNameOk() (*string, bool) {
	if o == nil || o.TargetName == nil {
		return nil, false
	}
	return o.TargetName, true
}

// HasTargetName returns a boolean if a field has been set.
func (o *DynamicSecretUpdateRdp) HasTargetName() bool {
	if o != nil && o.TargetName != nil {
		return true
	}

	return false
}

// SetTargetName gets a reference to the given string and assigns it to the TargetName field.
func (o *DynamicSecretUpdateRdp) SetTargetName(v string) {
	o.TargetName = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *DynamicSecretUpdateRdp) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *DynamicSecretUpdateRdp) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *DynamicSecretUpdateRdp) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *DynamicSecretUpdateRdp) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *DynamicSecretUpdateRdp) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *DynamicSecretUpdateRdp) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUserTtl returns the UserTtl field value if set, zero value otherwise.
func (o *DynamicSecretUpdateRdp) GetUserTtl() string {
	if o == nil || o.UserTtl == nil {
		var ret string
		return ret
	}
	return *o.UserTtl
}

// GetUserTtlOk returns a tuple with the UserTtl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetUserTtlOk() (*string, bool) {
	if o == nil || o.UserTtl == nil {
		return nil, false
	}
	return o.UserTtl, true
}

// HasUserTtl returns a boolean if a field has been set.
func (o *DynamicSecretUpdateRdp) HasUserTtl() bool {
	if o != nil && o.UserTtl != nil {
		return true
	}

	return false
}

// SetUserTtl gets a reference to the given string and assigns it to the UserTtl field.
func (o *DynamicSecretUpdateRdp) SetUserTtl(v string) {
	o.UserTtl = &v
}

// GetWarnUserBeforeExpiration returns the WarnUserBeforeExpiration field value if set, zero value otherwise.
func (o *DynamicSecretUpdateRdp) GetWarnUserBeforeExpiration() int64 {
	if o == nil || o.WarnUserBeforeExpiration == nil {
		var ret int64
		return ret
	}
	return *o.WarnUserBeforeExpiration
}

// GetWarnUserBeforeExpirationOk returns a tuple with the WarnUserBeforeExpiration field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateRdp) GetWarnUserBeforeExpirationOk() (*int64, bool) {
	if o == nil || o.WarnUserBeforeExpiration == nil {
		return nil, false
	}
	return o.WarnUserBeforeExpiration, true
}

// HasWarnUserBeforeExpiration returns a boolean if a field has been set.
func (o *DynamicSecretUpdateRdp) HasWarnUserBeforeExpiration() bool {
	if o != nil && o.WarnUserBeforeExpiration != nil {
		return true
	}

	return false
}

// SetWarnUserBeforeExpiration gets a reference to the given int64 and assigns it to the WarnUserBeforeExpiration field.
func (o *DynamicSecretUpdateRdp) SetWarnUserBeforeExpiration(v int64) {
	o.WarnUserBeforeExpiration = &v
}

func (o DynamicSecretUpdateRdp) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AllowUserExtendSession != nil {
		toSerialize["allow-user-extend-session"] = o.AllowUserExtendSession
	}
	if o.DeleteProtection != nil {
		toSerialize["delete_protection"] = o.DeleteProtection
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.FixedUserOnly != nil {
		toSerialize["fixed-user-only"] = o.FixedUserOnly
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.NewName != nil {
		toSerialize["new-name"] = o.NewName
	}
	if o.PasswordLength != nil {
		toSerialize["password-length"] = o.PasswordLength
	}
	if o.ProducerEncryptionKeyName != nil {
		toSerialize["producer-encryption-key-name"] = o.ProducerEncryptionKeyName
	}
	if o.RdpAdminName != nil {
		toSerialize["rdp-admin-name"] = o.RdpAdminName
	}
	if o.RdpAdminPwd != nil {
		toSerialize["rdp-admin-pwd"] = o.RdpAdminPwd
	}
	if o.RdpHostName != nil {
		toSerialize["rdp-host-name"] = o.RdpHostName
	}
	if o.RdpHostPort != nil {
		toSerialize["rdp-host-port"] = o.RdpHostPort
	}
	if o.RdpUserGroups != nil {
		toSerialize["rdp-user-groups"] = o.RdpUserGroups
	}
	if o.SecureAccessAllowExternalUser != nil {
		toSerialize["secure-access-allow-external-user"] = o.SecureAccessAllowExternalUser
	}
	if o.SecureAccessEnable != nil {
		toSerialize["secure-access-enable"] = o.SecureAccessEnable
	}
	if o.SecureAccessHost != nil {
		toSerialize["secure-access-host"] = o.SecureAccessHost
	}
	if o.SecureAccessRdGatewayServer != nil {
		toSerialize["secure-access-rd-gateway-server"] = o.SecureAccessRdGatewayServer
	}
	if o.SecureAccessRdpDomain != nil {
		toSerialize["secure-access-rdp-domain"] = o.SecureAccessRdpDomain
	}
	if o.SecureAccessRdpUser != nil {
		toSerialize["secure-access-rdp-user"] = o.SecureAccessRdpUser
	}
	if o.Tags != nil {
		toSerialize["tags"] = o.Tags
	}
	if o.TargetName != nil {
		toSerialize["target-name"] = o.TargetName
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UserTtl != nil {
		toSerialize["user-ttl"] = o.UserTtl
	}
	if o.WarnUserBeforeExpiration != nil {
		toSerialize["warn-user-before-expiration"] = o.WarnUserBeforeExpiration
	}
	return json.Marshal(toSerialize)
}

type NullableDynamicSecretUpdateRdp struct {
	value *DynamicSecretUpdateRdp
	isSet bool
}

func (v NullableDynamicSecretUpdateRdp) Get() *DynamicSecretUpdateRdp {
	return v.value
}

func (v *NullableDynamicSecretUpdateRdp) Set(val *DynamicSecretUpdateRdp) {
	v.value = val
	v.isSet = true
}

func (v NullableDynamicSecretUpdateRdp) IsSet() bool {
	return v.isSet
}

func (v *NullableDynamicSecretUpdateRdp) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDynamicSecretUpdateRdp(val *DynamicSecretUpdateRdp) *NullableDynamicSecretUpdateRdp {
	return &NullableDynamicSecretUpdateRdp{value: val, isSet: true}
}

func (v NullableDynamicSecretUpdateRdp) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDynamicSecretUpdateRdp) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


