/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// AzureStorage struct for AzureStorage
type AzureStorage struct {
	AuthType *string `json:"auth_type,omitempty"`
	ClientId *string `json:"client_id,omitempty"`
	ClientSecret *string `json:"client_secret,omitempty"`
	StorageAccount *string `json:"storage_account,omitempty"`
	StorageContainerName *string `json:"storage_container_name,omitempty"`
	// creds
	TenantId *string `json:"tenant_id,omitempty"`
}

// NewAzureStorage instantiates a new AzureStorage object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAzureStorage() *AzureStorage {
	this := AzureStorage{}
	return &this
}

// NewAzureStorageWithDefaults instantiates a new AzureStorage object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAzureStorageWithDefaults() *AzureStorage {
	this := AzureStorage{}
	return &this
}

// GetAuthType returns the AuthType field value if set, zero value otherwise.
func (o *AzureStorage) GetAuthType() string {
	if o == nil || o.AuthType == nil {
		var ret string
		return ret
	}
	return *o.AuthType
}

// GetAuthTypeOk returns a tuple with the AuthType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AzureStorage) GetAuthTypeOk() (*string, bool) {
	if o == nil || o.AuthType == nil {
		return nil, false
	}
	return o.AuthType, true
}

// HasAuthType returns a boolean if a field has been set.
func (o *AzureStorage) HasAuthType() bool {
	if o != nil && o.AuthType != nil {
		return true
	}

	return false
}

// SetAuthType gets a reference to the given string and assigns it to the AuthType field.
func (o *AzureStorage) SetAuthType(v string) {
	o.AuthType = &v
}

// GetClientId returns the ClientId field value if set, zero value otherwise.
func (o *AzureStorage) GetClientId() string {
	if o == nil || o.ClientId == nil {
		var ret string
		return ret
	}
	return *o.ClientId
}

// GetClientIdOk returns a tuple with the ClientId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AzureStorage) GetClientIdOk() (*string, bool) {
	if o == nil || o.ClientId == nil {
		return nil, false
	}
	return o.ClientId, true
}

// HasClientId returns a boolean if a field has been set.
func (o *AzureStorage) HasClientId() bool {
	if o != nil && o.ClientId != nil {
		return true
	}

	return false
}

// SetClientId gets a reference to the given string and assigns it to the ClientId field.
func (o *AzureStorage) SetClientId(v string) {
	o.ClientId = &v
}

// GetClientSecret returns the ClientSecret field value if set, zero value otherwise.
func (o *AzureStorage) GetClientSecret() string {
	if o == nil || o.ClientSecret == nil {
		var ret string
		return ret
	}
	return *o.ClientSecret
}

// GetClientSecretOk returns a tuple with the ClientSecret field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AzureStorage) GetClientSecretOk() (*string, bool) {
	if o == nil || o.ClientSecret == nil {
		return nil, false
	}
	return o.ClientSecret, true
}

// HasClientSecret returns a boolean if a field has been set.
func (o *AzureStorage) HasClientSecret() bool {
	if o != nil && o.ClientSecret != nil {
		return true
	}

	return false
}

// SetClientSecret gets a reference to the given string and assigns it to the ClientSecret field.
func (o *AzureStorage) SetClientSecret(v string) {
	o.ClientSecret = &v
}

// GetStorageAccount returns the StorageAccount field value if set, zero value otherwise.
func (o *AzureStorage) GetStorageAccount() string {
	if o == nil || o.StorageAccount == nil {
		var ret string
		return ret
	}
	return *o.StorageAccount
}

// GetStorageAccountOk returns a tuple with the StorageAccount field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AzureStorage) GetStorageAccountOk() (*string, bool) {
	if o == nil || o.StorageAccount == nil {
		return nil, false
	}
	return o.StorageAccount, true
}

// HasStorageAccount returns a boolean if a field has been set.
func (o *AzureStorage) HasStorageAccount() bool {
	if o != nil && o.StorageAccount != nil {
		return true
	}

	return false
}

// SetStorageAccount gets a reference to the given string and assigns it to the StorageAccount field.
func (o *AzureStorage) SetStorageAccount(v string) {
	o.StorageAccount = &v
}

// GetStorageContainerName returns the StorageContainerName field value if set, zero value otherwise.
func (o *AzureStorage) GetStorageContainerName() string {
	if o == nil || o.StorageContainerName == nil {
		var ret string
		return ret
	}
	return *o.StorageContainerName
}

// GetStorageContainerNameOk returns a tuple with the StorageContainerName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AzureStorage) GetStorageContainerNameOk() (*string, bool) {
	if o == nil || o.StorageContainerName == nil {
		return nil, false
	}
	return o.StorageContainerName, true
}

// HasStorageContainerName returns a boolean if a field has been set.
func (o *AzureStorage) HasStorageContainerName() bool {
	if o != nil && o.StorageContainerName != nil {
		return true
	}

	return false
}

// SetStorageContainerName gets a reference to the given string and assigns it to the StorageContainerName field.
func (o *AzureStorage) SetStorageContainerName(v string) {
	o.StorageContainerName = &v
}

// GetTenantId returns the TenantId field value if set, zero value otherwise.
func (o *AzureStorage) GetTenantId() string {
	if o == nil || o.TenantId == nil {
		var ret string
		return ret
	}
	return *o.TenantId
}

// GetTenantIdOk returns a tuple with the TenantId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AzureStorage) GetTenantIdOk() (*string, bool) {
	if o == nil || o.TenantId == nil {
		return nil, false
	}
	return o.TenantId, true
}

// HasTenantId returns a boolean if a field has been set.
func (o *AzureStorage) HasTenantId() bool {
	if o != nil && o.TenantId != nil {
		return true
	}

	return false
}

// SetTenantId gets a reference to the given string and assigns it to the TenantId field.
func (o *AzureStorage) SetTenantId(v string) {
	o.TenantId = &v
}

func (o AzureStorage) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AuthType != nil {
		toSerialize["auth_type"] = o.AuthType
	}
	if o.ClientId != nil {
		toSerialize["client_id"] = o.ClientId
	}
	if o.ClientSecret != nil {
		toSerialize["client_secret"] = o.ClientSecret
	}
	if o.StorageAccount != nil {
		toSerialize["storage_account"] = o.StorageAccount
	}
	if o.StorageContainerName != nil {
		toSerialize["storage_container_name"] = o.StorageContainerName
	}
	if o.TenantId != nil {
		toSerialize["tenant_id"] = o.TenantId
	}
	return json.Marshal(toSerialize)
}

type NullableAzureStorage struct {
	value *AzureStorage
	isSet bool
}

func (v NullableAzureStorage) Get() *AzureStorage {
	return v.value
}

func (v *NullableAzureStorage) Set(val *AzureStorage) {
	v.value = val
	v.isSet = true
}

func (v NullableAzureStorage) IsSet() bool {
	return v.isSet
}

func (v *NullableAzureStorage) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAzureStorage(val *AzureStorage) *NullableAzureStorage {
	return &NullableAzureStorage{value: val, isSet: true}
}

func (v NullableAzureStorage) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAzureStorage) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


