/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// AzureADAccessRules AzureADAccessRules contains access rules specific to Azure Active Directory authentication.
type AzureADAccessRules struct {
	// The audience in the JWT.
	AdEndpoint *string `json:"ad_endpoint,omitempty"`
	// The list of group ids that login is restricted to.
	BoundGroupIds *[]string `json:"bound_group_ids,omitempty"`
	// The list of resource groups that login is restricted to.
	BoundResourceGroups *[]string `json:"bound_resource_groups,omitempty"`
	// The list of full resource ids that the login is restricted to.
	BoundResourceIds *[]string `json:"bound_resource_ids,omitempty"`
	// The list of resource names that the login is restricted to (e.g, a virtual machine name, scale set name, etc).
	BoundResourceNames *[]string `json:"bound_resource_names,omitempty"`
	// The list of resource providers that login is restricted to (e.g, Microsoft.Compute, Microsoft.ManagedIdentity, etc).
	BoundResourceProviders *[]string `json:"bound_resource_providers,omitempty"`
	// The list of resource types that login is restricted to  (e.g, virtualMachines, userAssignedIdentities, etc).
	BoundResourceTypes *[]string `json:"bound_resource_types,omitempty"`
	// The list of service principal IDs that login is restricted to.
	BoundServicePrincipalIds *[]string `json:"bound_service_principal_ids,omitempty"`
	// The list of subscription IDs that login is restricted to.
	BoundSubscriptionIds *[]string `json:"bound_subscription_ids,omitempty"`
	// The tenants id for the Azure Active Directory organization.
	BoundTenantId *string `json:"bound_tenant_id,omitempty"`
	// Issuer URL
	Issuer *string `json:"issuer,omitempty"`
	// The URL to the JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server.
	JwksUri *string `json:"jwks_uri,omitempty"`
	// A unique identifier to distinguish different users
	UniqueIdentifier *string `json:"unique_identifier,omitempty"`
}

// NewAzureADAccessRules instantiates a new AzureADAccessRules object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAzureADAccessRules() *AzureADAccessRules {
	this := AzureADAccessRules{}
	return &this
}

// NewAzureADAccessRulesWithDefaults instantiates a new AzureADAccessRules object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAzureADAccessRulesWithDefaults() *AzureADAccessRules {
	this := AzureADAccessRules{}
	return &this
}

// GetAdEndpoint returns the AdEndpoint field value if set, zero value otherwise.
func (o *AzureADAccessRules) GetAdEndpoint() string {
	if o == nil || o.AdEndpoint == nil {
		var ret string
		return ret
	}
	return *o.AdEndpoint
}

// GetAdEndpointOk returns a tuple with the AdEndpoint field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AzureADAccessRules) GetAdEndpointOk() (*string, bool) {
	if o == nil || o.AdEndpoint == nil {
		return nil, false
	}
	return o.AdEndpoint, true
}

// HasAdEndpoint returns a boolean if a field has been set.
func (o *AzureADAccessRules) HasAdEndpoint() bool {
	if o != nil && o.AdEndpoint != nil {
		return true
	}

	return false
}

// SetAdEndpoint gets a reference to the given string and assigns it to the AdEndpoint field.
func (o *AzureADAccessRules) SetAdEndpoint(v string) {
	o.AdEndpoint = &v
}

// GetBoundGroupIds returns the BoundGroupIds field value if set, zero value otherwise.
func (o *AzureADAccessRules) GetBoundGroupIds() []string {
	if o == nil || o.BoundGroupIds == nil {
		var ret []string
		return ret
	}
	return *o.BoundGroupIds
}

// GetBoundGroupIdsOk returns a tuple with the BoundGroupIds field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AzureADAccessRules) GetBoundGroupIdsOk() (*[]string, bool) {
	if o == nil || o.BoundGroupIds == nil {
		return nil, false
	}
	return o.BoundGroupIds, true
}

// HasBoundGroupIds returns a boolean if a field has been set.
func (o *AzureADAccessRules) HasBoundGroupIds() bool {
	if o != nil && o.BoundGroupIds != nil {
		return true
	}

	return false
}

// SetBoundGroupIds gets a reference to the given []string and assigns it to the BoundGroupIds field.
func (o *AzureADAccessRules) SetBoundGroupIds(v []string) {
	o.BoundGroupIds = &v
}

// GetBoundResourceGroups returns the BoundResourceGroups field value if set, zero value otherwise.
func (o *AzureADAccessRules) GetBoundResourceGroups() []string {
	if o == nil || o.BoundResourceGroups == nil {
		var ret []string
		return ret
	}
	return *o.BoundResourceGroups
}

// GetBoundResourceGroupsOk returns a tuple with the BoundResourceGroups field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AzureADAccessRules) GetBoundResourceGroupsOk() (*[]string, bool) {
	if o == nil || o.BoundResourceGroups == nil {
		return nil, false
	}
	return o.BoundResourceGroups, true
}

// HasBoundResourceGroups returns a boolean if a field has been set.
func (o *AzureADAccessRules) HasBoundResourceGroups() bool {
	if o != nil && o.BoundResourceGroups != nil {
		return true
	}

	return false
}

// SetBoundResourceGroups gets a reference to the given []string and assigns it to the BoundResourceGroups field.
func (o *AzureADAccessRules) SetBoundResourceGroups(v []string) {
	o.BoundResourceGroups = &v
}

// GetBoundResourceIds returns the BoundResourceIds field value if set, zero value otherwise.
func (o *AzureADAccessRules) GetBoundResourceIds() []string {
	if o == nil || o.BoundResourceIds == nil {
		var ret []string
		return ret
	}
	return *o.BoundResourceIds
}

// GetBoundResourceIdsOk returns a tuple with the BoundResourceIds field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AzureADAccessRules) GetBoundResourceIdsOk() (*[]string, bool) {
	if o == nil || o.BoundResourceIds == nil {
		return nil, false
	}
	return o.BoundResourceIds, true
}

// HasBoundResourceIds returns a boolean if a field has been set.
func (o *AzureADAccessRules) HasBoundResourceIds() bool {
	if o != nil && o.BoundResourceIds != nil {
		return true
	}

	return false
}

// SetBoundResourceIds gets a reference to the given []string and assigns it to the BoundResourceIds field.
func (o *AzureADAccessRules) SetBoundResourceIds(v []string) {
	o.BoundResourceIds = &v
}

// GetBoundResourceNames returns the BoundResourceNames field value if set, zero value otherwise.
func (o *AzureADAccessRules) GetBoundResourceNames() []string {
	if o == nil || o.BoundResourceNames == nil {
		var ret []string
		return ret
	}
	return *o.BoundResourceNames
}

// GetBoundResourceNamesOk returns a tuple with the BoundResourceNames field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AzureADAccessRules) GetBoundResourceNamesOk() (*[]string, bool) {
	if o == nil || o.BoundResourceNames == nil {
		return nil, false
	}
	return o.BoundResourceNames, true
}

// HasBoundResourceNames returns a boolean if a field has been set.
func (o *AzureADAccessRules) HasBoundResourceNames() bool {
	if o != nil && o.BoundResourceNames != nil {
		return true
	}

	return false
}

// SetBoundResourceNames gets a reference to the given []string and assigns it to the BoundResourceNames field.
func (o *AzureADAccessRules) SetBoundResourceNames(v []string) {
	o.BoundResourceNames = &v
}

// GetBoundResourceProviders returns the BoundResourceProviders field value if set, zero value otherwise.
func (o *AzureADAccessRules) GetBoundResourceProviders() []string {
	if o == nil || o.BoundResourceProviders == nil {
		var ret []string
		return ret
	}
	return *o.BoundResourceProviders
}

// GetBoundResourceProvidersOk returns a tuple with the BoundResourceProviders field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AzureADAccessRules) GetBoundResourceProvidersOk() (*[]string, bool) {
	if o == nil || o.BoundResourceProviders == nil {
		return nil, false
	}
	return o.BoundResourceProviders, true
}

// HasBoundResourceProviders returns a boolean if a field has been set.
func (o *AzureADAccessRules) HasBoundResourceProviders() bool {
	if o != nil && o.BoundResourceProviders != nil {
		return true
	}

	return false
}

// SetBoundResourceProviders gets a reference to the given []string and assigns it to the BoundResourceProviders field.
func (o *AzureADAccessRules) SetBoundResourceProviders(v []string) {
	o.BoundResourceProviders = &v
}

// GetBoundResourceTypes returns the BoundResourceTypes field value if set, zero value otherwise.
func (o *AzureADAccessRules) GetBoundResourceTypes() []string {
	if o == nil || o.BoundResourceTypes == nil {
		var ret []string
		return ret
	}
	return *o.BoundResourceTypes
}

// GetBoundResourceTypesOk returns a tuple with the BoundResourceTypes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AzureADAccessRules) GetBoundResourceTypesOk() (*[]string, bool) {
	if o == nil || o.BoundResourceTypes == nil {
		return nil, false
	}
	return o.BoundResourceTypes, true
}

// HasBoundResourceTypes returns a boolean if a field has been set.
func (o *AzureADAccessRules) HasBoundResourceTypes() bool {
	if o != nil && o.BoundResourceTypes != nil {
		return true
	}

	return false
}

// SetBoundResourceTypes gets a reference to the given []string and assigns it to the BoundResourceTypes field.
func (o *AzureADAccessRules) SetBoundResourceTypes(v []string) {
	o.BoundResourceTypes = &v
}

// GetBoundServicePrincipalIds returns the BoundServicePrincipalIds field value if set, zero value otherwise.
func (o *AzureADAccessRules) GetBoundServicePrincipalIds() []string {
	if o == nil || o.BoundServicePrincipalIds == nil {
		var ret []string
		return ret
	}
	return *o.BoundServicePrincipalIds
}

// GetBoundServicePrincipalIdsOk returns a tuple with the BoundServicePrincipalIds field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AzureADAccessRules) GetBoundServicePrincipalIdsOk() (*[]string, bool) {
	if o == nil || o.BoundServicePrincipalIds == nil {
		return nil, false
	}
	return o.BoundServicePrincipalIds, true
}

// HasBoundServicePrincipalIds returns a boolean if a field has been set.
func (o *AzureADAccessRules) HasBoundServicePrincipalIds() bool {
	if o != nil && o.BoundServicePrincipalIds != nil {
		return true
	}

	return false
}

// SetBoundServicePrincipalIds gets a reference to the given []string and assigns it to the BoundServicePrincipalIds field.
func (o *AzureADAccessRules) SetBoundServicePrincipalIds(v []string) {
	o.BoundServicePrincipalIds = &v
}

// GetBoundSubscriptionIds returns the BoundSubscriptionIds field value if set, zero value otherwise.
func (o *AzureADAccessRules) GetBoundSubscriptionIds() []string {
	if o == nil || o.BoundSubscriptionIds == nil {
		var ret []string
		return ret
	}
	return *o.BoundSubscriptionIds
}

// GetBoundSubscriptionIdsOk returns a tuple with the BoundSubscriptionIds field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AzureADAccessRules) GetBoundSubscriptionIdsOk() (*[]string, bool) {
	if o == nil || o.BoundSubscriptionIds == nil {
		return nil, false
	}
	return o.BoundSubscriptionIds, true
}

// HasBoundSubscriptionIds returns a boolean if a field has been set.
func (o *AzureADAccessRules) HasBoundSubscriptionIds() bool {
	if o != nil && o.BoundSubscriptionIds != nil {
		return true
	}

	return false
}

// SetBoundSubscriptionIds gets a reference to the given []string and assigns it to the BoundSubscriptionIds field.
func (o *AzureADAccessRules) SetBoundSubscriptionIds(v []string) {
	o.BoundSubscriptionIds = &v
}

// GetBoundTenantId returns the BoundTenantId field value if set, zero value otherwise.
func (o *AzureADAccessRules) GetBoundTenantId() string {
	if o == nil || o.BoundTenantId == nil {
		var ret string
		return ret
	}
	return *o.BoundTenantId
}

// GetBoundTenantIdOk returns a tuple with the BoundTenantId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AzureADAccessRules) GetBoundTenantIdOk() (*string, bool) {
	if o == nil || o.BoundTenantId == nil {
		return nil, false
	}
	return o.BoundTenantId, true
}

// HasBoundTenantId returns a boolean if a field has been set.
func (o *AzureADAccessRules) HasBoundTenantId() bool {
	if o != nil && o.BoundTenantId != nil {
		return true
	}

	return false
}

// SetBoundTenantId gets a reference to the given string and assigns it to the BoundTenantId field.
func (o *AzureADAccessRules) SetBoundTenantId(v string) {
	o.BoundTenantId = &v
}

// GetIssuer returns the Issuer field value if set, zero value otherwise.
func (o *AzureADAccessRules) GetIssuer() string {
	if o == nil || o.Issuer == nil {
		var ret string
		return ret
	}
	return *o.Issuer
}

// GetIssuerOk returns a tuple with the Issuer field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AzureADAccessRules) GetIssuerOk() (*string, bool) {
	if o == nil || o.Issuer == nil {
		return nil, false
	}
	return o.Issuer, true
}

// HasIssuer returns a boolean if a field has been set.
func (o *AzureADAccessRules) HasIssuer() bool {
	if o != nil && o.Issuer != nil {
		return true
	}

	return false
}

// SetIssuer gets a reference to the given string and assigns it to the Issuer field.
func (o *AzureADAccessRules) SetIssuer(v string) {
	o.Issuer = &v
}

// GetJwksUri returns the JwksUri field value if set, zero value otherwise.
func (o *AzureADAccessRules) GetJwksUri() string {
	if o == nil || o.JwksUri == nil {
		var ret string
		return ret
	}
	return *o.JwksUri
}

// GetJwksUriOk returns a tuple with the JwksUri field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AzureADAccessRules) GetJwksUriOk() (*string, bool) {
	if o == nil || o.JwksUri == nil {
		return nil, false
	}
	return o.JwksUri, true
}

// HasJwksUri returns a boolean if a field has been set.
func (o *AzureADAccessRules) HasJwksUri() bool {
	if o != nil && o.JwksUri != nil {
		return true
	}

	return false
}

// SetJwksUri gets a reference to the given string and assigns it to the JwksUri field.
func (o *AzureADAccessRules) SetJwksUri(v string) {
	o.JwksUri = &v
}

// GetUniqueIdentifier returns the UniqueIdentifier field value if set, zero value otherwise.
func (o *AzureADAccessRules) GetUniqueIdentifier() string {
	if o == nil || o.UniqueIdentifier == nil {
		var ret string
		return ret
	}
	return *o.UniqueIdentifier
}

// GetUniqueIdentifierOk returns a tuple with the UniqueIdentifier field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AzureADAccessRules) GetUniqueIdentifierOk() (*string, bool) {
	if o == nil || o.UniqueIdentifier == nil {
		return nil, false
	}
	return o.UniqueIdentifier, true
}

// HasUniqueIdentifier returns a boolean if a field has been set.
func (o *AzureADAccessRules) HasUniqueIdentifier() bool {
	if o != nil && o.UniqueIdentifier != nil {
		return true
	}

	return false
}

// SetUniqueIdentifier gets a reference to the given string and assigns it to the UniqueIdentifier field.
func (o *AzureADAccessRules) SetUniqueIdentifier(v string) {
	o.UniqueIdentifier = &v
}

func (o AzureADAccessRules) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AdEndpoint != nil {
		toSerialize["ad_endpoint"] = o.AdEndpoint
	}
	if o.BoundGroupIds != nil {
		toSerialize["bound_group_ids"] = o.BoundGroupIds
	}
	if o.BoundResourceGroups != nil {
		toSerialize["bound_resource_groups"] = o.BoundResourceGroups
	}
	if o.BoundResourceIds != nil {
		toSerialize["bound_resource_ids"] = o.BoundResourceIds
	}
	if o.BoundResourceNames != nil {
		toSerialize["bound_resource_names"] = o.BoundResourceNames
	}
	if o.BoundResourceProviders != nil {
		toSerialize["bound_resource_providers"] = o.BoundResourceProviders
	}
	if o.BoundResourceTypes != nil {
		toSerialize["bound_resource_types"] = o.BoundResourceTypes
	}
	if o.BoundServicePrincipalIds != nil {
		toSerialize["bound_service_principal_ids"] = o.BoundServicePrincipalIds
	}
	if o.BoundSubscriptionIds != nil {
		toSerialize["bound_subscription_ids"] = o.BoundSubscriptionIds
	}
	if o.BoundTenantId != nil {
		toSerialize["bound_tenant_id"] = o.BoundTenantId
	}
	if o.Issuer != nil {
		toSerialize["issuer"] = o.Issuer
	}
	if o.JwksUri != nil {
		toSerialize["jwks_uri"] = o.JwksUri
	}
	if o.UniqueIdentifier != nil {
		toSerialize["unique_identifier"] = o.UniqueIdentifier
	}
	return json.Marshal(toSerialize)
}

type NullableAzureADAccessRules struct {
	value *AzureADAccessRules
	isSet bool
}

func (v NullableAzureADAccessRules) Get() *AzureADAccessRules {
	return v.value
}

func (v *NullableAzureADAccessRules) Set(val *AzureADAccessRules) {
	v.value = val
	v.isSet = true
}

func (v NullableAzureADAccessRules) IsSet() bool {
	return v.isSet
}

func (v *NullableAzureADAccessRules) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAzureADAccessRules(val *AzureADAccessRules) *NullableAzureADAccessRules {
	return &NullableAzureADAccessRules{value: val, isSet: true}
}

func (v NullableAzureADAccessRules) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAzureADAccessRules) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


