// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package qldbiface provides an interface to enable mocking the Amazon QLDB service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package qldbiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/qldb"
)

// QLDBAPI provides an interface to enable mocking the
// qldb.QLDB service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon QLDB.
//	func myFunc(svc qldbiface.QLDBAPI) bool {
//	    // Make svc.CancelJournalKinesisStream request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := qldb.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockQLDBClient struct {
//	    qldbiface.QLDBAPI
//	}
//	func (m *mockQLDBClient) CancelJournalKinesisStream(input *qldb.CancelJournalKinesisStreamInput) (*qldb.CancelJournalKinesisStreamOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockQLDBClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type QLDBAPI interface {
	CancelJournalKinesisStream(*qldb.CancelJournalKinesisStreamInput) (*qldb.CancelJournalKinesisStreamOutput, error)
	CancelJournalKinesisStreamWithContext(aws.Context, *qldb.CancelJournalKinesisStreamInput, ...request.Option) (*qldb.CancelJournalKinesisStreamOutput, error)
	CancelJournalKinesisStreamRequest(*qldb.CancelJournalKinesisStreamInput) (*request.Request, *qldb.CancelJournalKinesisStreamOutput)

	CreateLedger(*qldb.CreateLedgerInput) (*qldb.CreateLedgerOutput, error)
	CreateLedgerWithContext(aws.Context, *qldb.CreateLedgerInput, ...request.Option) (*qldb.CreateLedgerOutput, error)
	CreateLedgerRequest(*qldb.CreateLedgerInput) (*request.Request, *qldb.CreateLedgerOutput)

	DeleteLedger(*qldb.DeleteLedgerInput) (*qldb.DeleteLedgerOutput, error)
	DeleteLedgerWithContext(aws.Context, *qldb.DeleteLedgerInput, ...request.Option) (*qldb.DeleteLedgerOutput, error)
	DeleteLedgerRequest(*qldb.DeleteLedgerInput) (*request.Request, *qldb.DeleteLedgerOutput)

	DescribeJournalKinesisStream(*qldb.DescribeJournalKinesisStreamInput) (*qldb.DescribeJournalKinesisStreamOutput, error)
	DescribeJournalKinesisStreamWithContext(aws.Context, *qldb.DescribeJournalKinesisStreamInput, ...request.Option) (*qldb.DescribeJournalKinesisStreamOutput, error)
	DescribeJournalKinesisStreamRequest(*qldb.DescribeJournalKinesisStreamInput) (*request.Request, *qldb.DescribeJournalKinesisStreamOutput)

	DescribeJournalS3Export(*qldb.DescribeJournalS3ExportInput) (*qldb.DescribeJournalS3ExportOutput, error)
	DescribeJournalS3ExportWithContext(aws.Context, *qldb.DescribeJournalS3ExportInput, ...request.Option) (*qldb.DescribeJournalS3ExportOutput, error)
	DescribeJournalS3ExportRequest(*qldb.DescribeJournalS3ExportInput) (*request.Request, *qldb.DescribeJournalS3ExportOutput)

	DescribeLedger(*qldb.DescribeLedgerInput) (*qldb.DescribeLedgerOutput, error)
	DescribeLedgerWithContext(aws.Context, *qldb.DescribeLedgerInput, ...request.Option) (*qldb.DescribeLedgerOutput, error)
	DescribeLedgerRequest(*qldb.DescribeLedgerInput) (*request.Request, *qldb.DescribeLedgerOutput)

	ExportJournalToS3(*qldb.ExportJournalToS3Input) (*qldb.ExportJournalToS3Output, error)
	ExportJournalToS3WithContext(aws.Context, *qldb.ExportJournalToS3Input, ...request.Option) (*qldb.ExportJournalToS3Output, error)
	ExportJournalToS3Request(*qldb.ExportJournalToS3Input) (*request.Request, *qldb.ExportJournalToS3Output)

	GetBlock(*qldb.GetBlockInput) (*qldb.GetBlockOutput, error)
	GetBlockWithContext(aws.Context, *qldb.GetBlockInput, ...request.Option) (*qldb.GetBlockOutput, error)
	GetBlockRequest(*qldb.GetBlockInput) (*request.Request, *qldb.GetBlockOutput)

	GetDigest(*qldb.GetDigestInput) (*qldb.GetDigestOutput, error)
	GetDigestWithContext(aws.Context, *qldb.GetDigestInput, ...request.Option) (*qldb.GetDigestOutput, error)
	GetDigestRequest(*qldb.GetDigestInput) (*request.Request, *qldb.GetDigestOutput)

	GetRevision(*qldb.GetRevisionInput) (*qldb.GetRevisionOutput, error)
	GetRevisionWithContext(aws.Context, *qldb.GetRevisionInput, ...request.Option) (*qldb.GetRevisionOutput, error)
	GetRevisionRequest(*qldb.GetRevisionInput) (*request.Request, *qldb.GetRevisionOutput)

	ListJournalKinesisStreamsForLedger(*qldb.ListJournalKinesisStreamsForLedgerInput) (*qldb.ListJournalKinesisStreamsForLedgerOutput, error)
	ListJournalKinesisStreamsForLedgerWithContext(aws.Context, *qldb.ListJournalKinesisStreamsForLedgerInput, ...request.Option) (*qldb.ListJournalKinesisStreamsForLedgerOutput, error)
	ListJournalKinesisStreamsForLedgerRequest(*qldb.ListJournalKinesisStreamsForLedgerInput) (*request.Request, *qldb.ListJournalKinesisStreamsForLedgerOutput)

	ListJournalKinesisStreamsForLedgerPages(*qldb.ListJournalKinesisStreamsForLedgerInput, func(*qldb.ListJournalKinesisStreamsForLedgerOutput, bool) bool) error
	ListJournalKinesisStreamsForLedgerPagesWithContext(aws.Context, *qldb.ListJournalKinesisStreamsForLedgerInput, func(*qldb.ListJournalKinesisStreamsForLedgerOutput, bool) bool, ...request.Option) error

	ListJournalS3Exports(*qldb.ListJournalS3ExportsInput) (*qldb.ListJournalS3ExportsOutput, error)
	ListJournalS3ExportsWithContext(aws.Context, *qldb.ListJournalS3ExportsInput, ...request.Option) (*qldb.ListJournalS3ExportsOutput, error)
	ListJournalS3ExportsRequest(*qldb.ListJournalS3ExportsInput) (*request.Request, *qldb.ListJournalS3ExportsOutput)

	ListJournalS3ExportsPages(*qldb.ListJournalS3ExportsInput, func(*qldb.ListJournalS3ExportsOutput, bool) bool) error
	ListJournalS3ExportsPagesWithContext(aws.Context, *qldb.ListJournalS3ExportsInput, func(*qldb.ListJournalS3ExportsOutput, bool) bool, ...request.Option) error

	ListJournalS3ExportsForLedger(*qldb.ListJournalS3ExportsForLedgerInput) (*qldb.ListJournalS3ExportsForLedgerOutput, error)
	ListJournalS3ExportsForLedgerWithContext(aws.Context, *qldb.ListJournalS3ExportsForLedgerInput, ...request.Option) (*qldb.ListJournalS3ExportsForLedgerOutput, error)
	ListJournalS3ExportsForLedgerRequest(*qldb.ListJournalS3ExportsForLedgerInput) (*request.Request, *qldb.ListJournalS3ExportsForLedgerOutput)

	ListJournalS3ExportsForLedgerPages(*qldb.ListJournalS3ExportsForLedgerInput, func(*qldb.ListJournalS3ExportsForLedgerOutput, bool) bool) error
	ListJournalS3ExportsForLedgerPagesWithContext(aws.Context, *qldb.ListJournalS3ExportsForLedgerInput, func(*qldb.ListJournalS3ExportsForLedgerOutput, bool) bool, ...request.Option) error

	ListLedgers(*qldb.ListLedgersInput) (*qldb.ListLedgersOutput, error)
	ListLedgersWithContext(aws.Context, *qldb.ListLedgersInput, ...request.Option) (*qldb.ListLedgersOutput, error)
	ListLedgersRequest(*qldb.ListLedgersInput) (*request.Request, *qldb.ListLedgersOutput)

	ListLedgersPages(*qldb.ListLedgersInput, func(*qldb.ListLedgersOutput, bool) bool) error
	ListLedgersPagesWithContext(aws.Context, *qldb.ListLedgersInput, func(*qldb.ListLedgersOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*qldb.ListTagsForResourceInput) (*qldb.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *qldb.ListTagsForResourceInput, ...request.Option) (*qldb.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*qldb.ListTagsForResourceInput) (*request.Request, *qldb.ListTagsForResourceOutput)

	StreamJournalToKinesis(*qldb.StreamJournalToKinesisInput) (*qldb.StreamJournalToKinesisOutput, error)
	StreamJournalToKinesisWithContext(aws.Context, *qldb.StreamJournalToKinesisInput, ...request.Option) (*qldb.StreamJournalToKinesisOutput, error)
	StreamJournalToKinesisRequest(*qldb.StreamJournalToKinesisInput) (*request.Request, *qldb.StreamJournalToKinesisOutput)

	TagResource(*qldb.TagResourceInput) (*qldb.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *qldb.TagResourceInput, ...request.Option) (*qldb.TagResourceOutput, error)
	TagResourceRequest(*qldb.TagResourceInput) (*request.Request, *qldb.TagResourceOutput)

	UntagResource(*qldb.UntagResourceInput) (*qldb.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *qldb.UntagResourceInput, ...request.Option) (*qldb.UntagResourceOutput, error)
	UntagResourceRequest(*qldb.UntagResourceInput) (*request.Request, *qldb.UntagResourceOutput)

	UpdateLedger(*qldb.UpdateLedgerInput) (*qldb.UpdateLedgerOutput, error)
	UpdateLedgerWithContext(aws.Context, *qldb.UpdateLedgerInput, ...request.Option) (*qldb.UpdateLedgerOutput, error)
	UpdateLedgerRequest(*qldb.UpdateLedgerInput) (*request.Request, *qldb.UpdateLedgerOutput)

	UpdateLedgerPermissionsMode(*qldb.UpdateLedgerPermissionsModeInput) (*qldb.UpdateLedgerPermissionsModeOutput, error)
	UpdateLedgerPermissionsModeWithContext(aws.Context, *qldb.UpdateLedgerPermissionsModeInput, ...request.Option) (*qldb.UpdateLedgerPermissionsModeOutput, error)
	UpdateLedgerPermissionsModeRequest(*qldb.UpdateLedgerPermissionsModeInput) (*request.Request, *qldb.UpdateLedgerPermissionsModeOutput)
}

var _ QLDBAPI = (*qldb.QLDB)(nil)
