/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.impl.BatcherImpl;
import net.sf.hibernate.util.JDBCExceptionReporter;

public class BatchingBatcher
extends BatcherImpl {
    private int batchSize;

    public BatchingBatcher(SessionImplementor session) {
        super(session);
    }

    public void addToBatch(int expectedRowCount) throws SQLException, HibernateException {
        BatcherImpl.log.trace((Object)"Adding to batch");
        PreparedStatement batchUpdate = this.getStatement();
        batchUpdate.addBatch();
        ++this.batchSize;
        if (this.batchSize == this.getFactory().getJdbcBatchSize()) {
            try {
                this.doExecuteBatch(batchUpdate);
            }
            catch (SQLException sqle) {
                this.closeStatement(batchUpdate);
                throw sqle;
            }
            catch (HibernateException he) {
                this.closeStatement(batchUpdate);
                throw he;
            }
        }
    }

    protected void doExecuteBatch(PreparedStatement ps) throws SQLException, HibernateException {
        if (BatcherImpl.log.isDebugEnabled()) {
            BatcherImpl.log.debug((Object)("Executing batch size: " + this.batchSize));
        }
        try {
            block8: {
                try {
                    if (this.batchSize == 0) break block8;
                    int[] results = ps.executeBatch();
                    int i = 0;
                    while (i < this.batchSize) {
                        if (results[i] == -3) {
                            throw new HibernateException("Batch update failed");
                        }
                        ++i;
                    }
                }
                catch (SQLException sqle) {
                    JDBCExceptionReporter.logExceptions(sqle);
                    throw sqle;
                }
                catch (RuntimeException re) {
                    BatcherImpl.log.error((Object)"Exception executing batch: ", (Throwable)re);
                    throw re;
                }
            }
            Object var5_6 = null;
            this.batchSize = 0;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.batchSize = 0;
            throw throwable;
        }
    }
}

