# Google Summer of Code


## Contacts

If you are interested in participating in GSoC as a contributor or mentor,
please have a look at our [community forums] and reach out to us. Working closely
with the community is highly encouraged, as we've seen that our most successful
contributors are generally very involved.

Felix Singer, David Hendricks and Martin Roth are the coreboot GSoC admins for
2022. Please feel free to reach out to them directly if you have any questions.


## Why work on coreboot for GSoC?

  * coreboot offers you the opportunity to work with various architectures
    right on the iron. coreboot supports both current and older silicon for a
    wide variety of chips and technologies.

  * coreboot has a worldwide developer and user base.

  * We are a very passionate team, so you will interact directly with the
    project initiators and project leaders.

  * We have a large, helpful community. coreboot has some extremely talented
    and helpful experts in firmware involved in the project. They are ready to
    assist and mentor contributors participating in GSoC.

  * One of the last areas where open source software is not common is firmware.
    Running proprietary firmware can have severe effects on user's freedom and
    security. coreboot has a mission to change that by providing a common
    framework for initial hardware initialization and you can help us succeed.


## Collection of official GSoC guides & documents

  * [Timeline][GSoC Timeline]

  * [Roles and Responsibilities][GSoC Roles and Responsibilities]

  * [Contributor Guide][GSoC Contributor Guide]

  * [Contributor Advice][GSoC Contributor Advice]

  * [Mentor Guide][GSoC Mentor Guide]

  * [FAQ][GSoC FAQ]

  * [Rules][GSoC Rules]

  * [Glossary][GSoC Glossary]


## Contributor requirements & commitments

Google Summer of Code is a significant time commitment for you. Medium-sized
projects are estimated to take 175 hours, while large-sized projects are
estimated to take 350 hours. Depending on the project size, this means we
expect you to work roughly half-time or full-time on your project during the
three months of coding. We expect to be able to see this level of effort in the
results.

The standard program duration is 12 weeks and in consultation with the mentor
it can be extended up to 22 weeks. Please keep in mind that the actual number
of hours you spend on the project highly depends on your skills and previous
experience.

Make sure that your schedule (exams, courses, day job) gives you a sufficient
amount of spare time. If this is not the case, then you should not apply.


### Before applying

  * Join the [mailing list] and our other [community forums]. Introduce yourself
    and mention that you are a prospective GSoC contributor. Ask questions and
    discuss the project that you are considering. Community involvement is a
    key component of coreboot development.

  * You accept our [Code of Conduct] and [Language style].

  * Demonstrate that you can work with the coreboot codebase.

    * Look over some of the development processes guidelines: [Getting started],
      [Tutorial], [Flashing firmware tutorial] and [Coding style].

    * Download, build and boot coreboot in QEMU or on real hardware. Please email
      your serial output results to the [mailing list].

    * Look through some patches on Gerrit to get an understanding of the review
      process and common issues.

    * Get signed up for Gerrit and push at least one patch to Gerrit for review.
      Check the [easy project list][Project ideas] or ask for simple tasks on
      the [mailing list] or on our other [community forums] if you need ideas.


### During the program

  * To pass and to be paid by Google requires that you meet certain milestones.

    * First, you must be in good standing with the community before the official
      start of the program. We expect you to post some design emails to the
      [mailing list], and get feedback on them, both before applying, and during
      the "community bonding period" between acceptance and official start.

    * You must have made progress and committed significant code before the
      mid-term point and by the final.

    * We require that accepted contributors to maintain a blog, where you are
      expected to write about your project *WEEKLY*. This is a way to measure
      progress and for the community at large to be able to help you. GSoC is
      *NOT* a private contract between your mentor and you.

  * You must be active in the community on IRC and the [mailing list].

  * You are expected to work on development publicly, and to push commits to the
    project on a regular basis. Depending on the project and what your mentor
    agrees to, these can be published directly to the project or to a public
    repository such as Gitlab or Github. If you are not publishing directly to
    the project codebase, be aware that we do not want large dumps of code that
    need to be rushed to meet the mid-term and final goals.

We don't expect our contributors to be experts in our problem domain, but we
don't want you to fail because some basic misunderstanding was in your way of
completing the task.


## Projects

There are many development tasks available in coreboot. We prepared some ideas
for Summer of Code projects. These are projects that we think can be managed in
the timeline of GSoC, and they cover areas where coreboot is trying to reach
new users and new use cases.

Of course your application does not have to be based on any of the ideas listed.
It is entirely possible that you have a great idea that we just didn't think of
yet. Please let us know!

The blog posts related to previous GSoC projects might give some insights to
what it is like to be a coreboot GSoC contributor.


## coreboot Summer of Code Application

coreboot welcomes contributors from all backgrounds and levels of experience.

Your application should include a complete project proposal. You should
document that you have the knowledge and the ability to complete your proposed
project. This may require a little research and understanding of coreboot prior
to sending your application. The community and coreboot project mentors are your
best resource in fleshing out your project ideas and helping with a project
timeline. We recommend that you get feedback and recommendations on your
proposal before the application deadline.

Please complete the standard GSoC application and project proposal. Provide the
following information as part of your application. Make sure to provide multiple
ways of communicating in case your equipment (such as a laptop) is lost,
damaged, or stolen, or in case of a natural disaster that disrupts internet
service. You risk automatically failing if your mentor cannot contact you and if
you cannot provide updates according to GSoC deadlines.

**Personal Information**

  * Name

  * Email and contact options (IRC, Matrix, …)

  * Phone number (optional, but recommended)

  * Timezone, Usual working hours (UTC)

  * School / University, Degree Program, expected graduation date

  * Short bio / Overview of your background

  * What are your other time commitments? Do you have a job, classes, vacations?
    When and how long?

**Software experience**

If applicable, please provide the following information:

  * Portfolio, Website, blog, microblog, Github, Gitlab, ...

  * Links to one or more patches submitted

  * Links to posts on the [mailing list] with the serial output of your build.

  * Please comment on your software and firmware experience.

  * Have you contributed to an open source project? Which one? What was your
    experience?

  * What was your experience while building and running coreboot? Did you have
    problems?

**Your project**

  * Provide an overview of your project (in your own words).

  * Provide a breakdown of your project in small specific weekly goals. Think
    about the potential timeline.

  * How will you accomplish this goal? What is your working style?

  * Explain what risks or potential problems your project might experience.

  * What would you expect as a minimum level of success?

  * Do you have a stretch goal?

**Other**

  * Resume (optional)


### Advice on how to apply

  * [GSoC Contributor Guide]

  * The Drupal project has a great page on how to write an GSoC application.

  * Secrets for GSoC success: [2]


## Mentors

Each accepted project will have at least one mentor. We will match mentors and
contributors based on the project and experience level. If possible, we also
will try to match their time zones.

Mentors are expected to stay in frequent contact with the contributor and
provide guidance such as code reviews, pointers to useful documentation, etc.
This should generally be a time commitment of several hours per week.

Some projects might have more than one mentor, who can serve as a backup. They
are expected to coordinate with each other and a contributor on a regular basis,
and keep track of the contributor process. They should be able to take over
mentoring duty if one of the mentors is unavailable (vacations, sickness,
emergencies).


### Volunteering to be a mentor

If you'd like to volunteer to be a mentor, please read the [GSoC Mentor Guide].
This will give you a better idea of expectations, and where to go for help.
After that, contact Org Admins (see coreboot contacts section above).

The following coreboot developers have volunteered to be GSoC 2022 mentors.
Please stop by in our community forums and say hi to them and ask them
questions.

  * Tim Wawrzynczak
  * Raul Rangel
  * Ron Minnich


[community forums]: ../community/forums.md
[mailing list]: https://mail.coreboot.org/postorius/lists/coreboot.coreboot.org
[Getting started]: ../getting_started/index.md
[Tutorial]: ../tutorial/index.md
[Flashing firmware tutorial]: ../tutorial/flashing_firmware/index.md
[Coding style]: coding_style.md
[Code of Conduct]: ../community/code_of_conduct.md
[Language style]: ../community/language_style.md
[Project ideas]: project_ideas.md
[GSoC Timeline]: https://developers.google.com/open-source/gsoc/timeline
[GSoC Roles and Responsibilities]: https://developers.google.com/open-source/gsoc/help/responsibilities
[GSoC Contributor Guide]: https://google.github.io/gsocguides/student
[GSoC Contributor Advice]: https://developers.google.com/open-source/gsoc/help/student-advice
[GSoC Mentor Guide]: https://google.github.io/gsocguides/mentor
[GSoC FAQ]: https://developers.google.com/open-source/gsoc/faq
[GSoC Rules]: https://summerofcode.withgoogle.com/rules
[GSoC Glossary]: https://developers.google.com/open-source/gsoc/resources/glossary
