'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _invariant = require('invariant');

var _invariant2 = _interopRequireDefault(_invariant);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var qhistory = function qhistory(history, stringify, parse) {

  (0, _invariant2.default)(typeof stringify === 'function', 'A stringify function is required in order to transform ' + 'query objects into search strings.');

  (0, _invariant2.default)(typeof parse === 'function', 'A parse function is required in order to transform ' + 'search strings into query objects.');

  var addSearch = function addSearch(location) {
    if ((typeof location === 'undefined' ? 'undefined' : _typeof(location)) === 'object') {
      var search = location.search || '';
      if (location.query) {
        search = stringify(location.query);
        // Ensure leading "?" for non-empty search
        if (search.length > 0 && search.charAt(0) !== '?') {
          search = '?' + search;
        }
      }
      return _extends({}, location, { search: search });
    }

    return location;
  };

  var addQuery = function addQuery(location) {
    var search = location.search;

    return _extends({}, location, {
      query: search ? parse(search.charAt(0) === '?' ? search.substring(1) : search) : {}
    });
  };

  var updateProperties = function updateProperties(history) {
    var properties = ['length', 'entries', 'index', 'action'];
    properties.forEach(function (prop) {
      if (history.hasOwnProperty(prop)) {
        queryHistory[prop] = history[prop];
      }
    });
  };

  // This relies on being the first listener called by
  // the actual history instance. If you register a
  // listener on the history instance before modifying
  // it with qhistory, the location object will not have
  // the query property set on it when that listener
  // is called.
  history.listen(function (location) {
    updateProperties(history);
  });

  var queryHistory = _extends({}, history, {
    listen: function listen(listener) {
      return history.listen(function (location, action) {
        var isV5 = location.location != null;
        if (isV5) {
          action = location.action;
          location = location.location;
        }
        var queryLocation = addQuery(location);
        isV5 ? listener({ location: queryLocation, action: action }) : listener(queryLocation, action);
      });
    },
    push: function push(location, state) {
      return history.push(addSearch(location), state);
    },
    replace: function replace(location, state) {
      return history.replace(addSearch(location), state);
    },
    createHref: function createHref(location) {
      return history.createHref(addSearch(location));
    }
  });

  Object.defineProperty(queryHistory, 'location', {
    get: function get() {
      return addQuery(history.location);
    }
  });

  return queryHistory;
};

exports.default = qhistory;