package subscription

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSubscriptionItemDetail invokes the subscription.GetSubscriptionItemDetail API synchronously
// api document: https://help.aliyun.com/api/subscription/getsubscriptionitemdetail.html
func (client *Client) GetSubscriptionItemDetail(request *GetSubscriptionItemDetailRequest) (response *GetSubscriptionItemDetailResponse, err error) {
	response = CreateGetSubscriptionItemDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetSubscriptionItemDetailWithChan invokes the subscription.GetSubscriptionItemDetail API asynchronously
// api document: https://help.aliyun.com/api/subscription/getsubscriptionitemdetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetSubscriptionItemDetailWithChan(request *GetSubscriptionItemDetailRequest) (<-chan *GetSubscriptionItemDetailResponse, <-chan error) {
	responseChan := make(chan *GetSubscriptionItemDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSubscriptionItemDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSubscriptionItemDetailWithCallback invokes the subscription.GetSubscriptionItemDetail API asynchronously
// api document: https://help.aliyun.com/api/subscription/getsubscriptionitemdetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetSubscriptionItemDetailWithCallback(request *GetSubscriptionItemDetailRequest, callback func(response *GetSubscriptionItemDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSubscriptionItemDetailResponse
		var err error
		defer close(result)
		response, err = client.GetSubscriptionItemDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSubscriptionItemDetailRequest is the request struct for api GetSubscriptionItemDetail
type GetSubscriptionItemDetailRequest struct {
	*requests.RpcRequest
	Locale string           `position:"Query" name:"Locale"`
	ItemId requests.Integer `position:"Query" name:"ItemId"`
}

// GetSubscriptionItemDetailResponse is the response struct for api GetSubscriptionItemDetail
type GetSubscriptionItemDetailResponse struct {
	*responses.BaseResponse
	Message                string                 `json:"Message" xml:"Message"`
	RequestId              string                 `json:"RequestId" xml:"RequestId"`
	Code                   string                 `json:"Code" xml:"Code"`
	Success                bool                   `json:"Success" xml:"Success"`
	SubscriptionItemDetail SubscriptionItemDetail `json:"SubscriptionItemDetail" xml:"SubscriptionItemDetail"`
}

// CreateGetSubscriptionItemDetailRequest creates a request to invoke GetSubscriptionItemDetail API
func CreateGetSubscriptionItemDetailRequest() (request *GetSubscriptionItemDetailRequest) {
	request = &GetSubscriptionItemDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Subscription", "2021-01-15", "GetSubscriptionItemDetail", "", "")
	return
}

// CreateGetSubscriptionItemDetailResponse creates a response to parse from GetSubscriptionItemDetail response
func CreateGetSubscriptionItemDetailResponse() (response *GetSubscriptionItemDetailResponse) {
	response = &GetSubscriptionItemDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
