package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FetchCall invokes the scsp.FetchCall API synchronously
func (client *Client) FetchCall(request *FetchCallRequest) (response *FetchCallResponse, err error) {
	response = CreateFetchCallResponse()
	err = client.DoAction(request, response)
	return
}

// FetchCallWithChan invokes the scsp.FetchCall API asynchronously
func (client *Client) FetchCallWithChan(request *FetchCallRequest) (<-chan *FetchCallResponse, <-chan error) {
	responseChan := make(chan *FetchCallResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FetchCall(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FetchCallWithCallback invokes the scsp.FetchCall API asynchronously
func (client *Client) FetchCallWithCallback(request *FetchCallRequest, callback func(response *FetchCallResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FetchCallResponse
		var err error
		defer close(result)
		response, err = client.FetchCall(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FetchCallRequest is the request struct for api FetchCall
type FetchCallRequest struct {
	*requests.RpcRequest
	ClientToken      string `position:"Body"`
	InstanceId       string `position:"Body"`
	AccountName      string `position:"Body"`
	CallId           string `position:"Body"`
	JobId            string `position:"Body"`
	ConnectionId     string `position:"Body"`
	HoldConnectionId string `position:"Body"`
}

// FetchCallResponse is the response struct for api FetchCall
type FetchCallResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateFetchCallRequest creates a request to invoke FetchCall API
func CreateFetchCallRequest() (request *FetchCallRequest) {
	request = &FetchCallRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "FetchCall", "", "")
	request.Method = requests.POST
	return
}

// CreateFetchCallResponse creates a response to parse from FetchCall response
func CreateFetchCallResponse() (response *FetchCallResponse) {
	response = &FetchCallResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
