package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReleaseValueAdded invokes the ddoscoo.ReleaseValueAdded API synchronously
func (client *Client) ReleaseValueAdded(request *ReleaseValueAddedRequest) (response *ReleaseValueAddedResponse, err error) {
	response = CreateReleaseValueAddedResponse()
	err = client.DoAction(request, response)
	return
}

// ReleaseValueAddedWithChan invokes the ddoscoo.ReleaseValueAdded API asynchronously
func (client *Client) ReleaseValueAddedWithChan(request *ReleaseValueAddedRequest) (<-chan *ReleaseValueAddedResponse, <-chan error) {
	responseChan := make(chan *ReleaseValueAddedResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReleaseValueAdded(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReleaseValueAddedWithCallback invokes the ddoscoo.ReleaseValueAdded API asynchronously
func (client *Client) ReleaseValueAddedWithCallback(request *ReleaseValueAddedRequest, callback func(response *ReleaseValueAddedResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReleaseValueAddedResponse
		var err error
		defer close(result)
		response, err = client.ReleaseValueAdded(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReleaseValueAddedRequest is the request struct for api ReleaseValueAdded
type ReleaseValueAddedRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	SourceIp   string `position:"Query" name:"SourceIp"`
}

// ReleaseValueAddedResponse is the response struct for api ReleaseValueAdded
type ReleaseValueAddedResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateReleaseValueAddedRequest creates a request to invoke ReleaseValueAdded API
func CreateReleaseValueAddedRequest() (request *ReleaseValueAddedRequest) {
	request = &ReleaseValueAddedRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "ReleaseValueAdded", "", "")
	request.Method = requests.POST
	return
}

// CreateReleaseValueAddedResponse creates a response to parse from ReleaseValueAdded response
func CreateReleaseValueAddedResponse() (response *ReleaseValueAddedResponse) {
	response = &ReleaseValueAddedResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
