package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UserDataShowList invokes the cloudwf.UserDataShowList API synchronously
// api document: https://help.aliyun.com/api/cloudwf/userdatashowlist.html
func (client *Client) UserDataShowList(request *UserDataShowListRequest) (response *UserDataShowListResponse, err error) {
	response = CreateUserDataShowListResponse()
	err = client.DoAction(request, response)
	return
}

// UserDataShowListWithChan invokes the cloudwf.UserDataShowList API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/userdatashowlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UserDataShowListWithChan(request *UserDataShowListRequest) (<-chan *UserDataShowListResponse, <-chan error) {
	responseChan := make(chan *UserDataShowListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UserDataShowList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UserDataShowListWithCallback invokes the cloudwf.UserDataShowList API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/userdatashowlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UserDataShowListWithCallback(request *UserDataShowListRequest, callback func(response *UserDataShowListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UserDataShowListResponse
		var err error
		defer close(result)
		response, err = client.UserDataShowList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UserDataShowListRequest is the request struct for api UserDataShowList
type UserDataShowListRequest struct {
	*requests.RpcRequest
	Iid  requests.Integer `position:"Query" name:"Iid"`
	Name string           `position:"Query" name:"Name"`
	Page requests.Integer `position:"Query" name:"Page"`
	Bid  requests.Integer `position:"Query" name:"Bid"`
	Per  requests.Integer `position:"Query" name:"Per"`
}

// UserDataShowListResponse is the response struct for api UserDataShowList
type UserDataShowListResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateUserDataShowListRequest creates a request to invoke UserDataShowList API
func CreateUserDataShowListRequest() (request *UserDataShowListRequest) {
	request = &UserDataShowListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "UserDataShowList", "cloudwf", "openAPI")
	return
}

// CreateUserDataShowListResponse creates a response to parse from UserDataShowList response
func CreateUserDataShowListResponse() (response *UserDataShowListResponse) {
	response = &UserDataShowListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
