package ccs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetHotlineRecord invokes the ccs.GetHotlineRecord API synchronously
// api document: https://help.aliyun.com/api/ccs/gethotlinerecord.html
func (client *Client) GetHotlineRecord(request *GetHotlineRecordRequest) (response *GetHotlineRecordResponse, err error) {
	response = CreateGetHotlineRecordResponse()
	err = client.DoAction(request, response)
	return
}

// GetHotlineRecordWithChan invokes the ccs.GetHotlineRecord API asynchronously
// api document: https://help.aliyun.com/api/ccs/gethotlinerecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetHotlineRecordWithChan(request *GetHotlineRecordRequest) (<-chan *GetHotlineRecordResponse, <-chan error) {
	responseChan := make(chan *GetHotlineRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetHotlineRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetHotlineRecordWithCallback invokes the ccs.GetHotlineRecord API asynchronously
// api document: https://help.aliyun.com/api/ccs/gethotlinerecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetHotlineRecordWithCallback(request *GetHotlineRecordRequest, callback func(response *GetHotlineRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetHotlineRecordResponse
		var err error
		defer close(result)
		response, err = client.GetHotlineRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetHotlineRecordRequest is the request struct for api GetHotlineRecord
type GetHotlineRecordRequest struct {
	*requests.RpcRequest
	Id            string `position:"Query" name:"Id"`
	CcsInstanceId string `position:"Query" name:"CcsInstanceId"`
}

// GetHotlineRecordResponse is the response struct for api GetHotlineRecord
type GetHotlineRecordResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	Id              string `json:"Id" xml:"Id"`
	CallType        string `json:"CallType" xml:"CallType"`
	VisitorId       string `json:"VisitorId" xml:"VisitorId"`
	VisitorPhone    string `json:"VisitorPhone" xml:"VisitorPhone"`
	VisitorProvince string `json:"VisitorProvince" xml:"VisitorProvince"`
	SceneId         string `json:"SceneId" xml:"SceneId"`
	AgentId         string `json:"AgentId" xml:"AgentId"`
	AgentName       string `json:"AgentName" xml:"AgentName"`
	CreateTime      string `json:"CreateTime" xml:"CreateTime"`
	FinishTime      string `json:"FinishTime" xml:"FinishTime"`
	Status          string `json:"Status" xml:"Status"`
	Memo            string `json:"Memo" xml:"Memo"`
	HangupType      string `json:"HangupType" xml:"HangupType"`
	Satisfaction    string `json:"Satisfaction" xml:"Satisfaction"`
	OutboundTaskId  string `json:"OutboundTaskId" xml:"OutboundTaskId"`
	Categories      string `json:"Categories" xml:"Categories"`
	CcsInstanceId   string `json:"CcsInstanceId" xml:"CcsInstanceId"`
	TalkDuration    int    `json:"TalkDuration" xml:"TalkDuration"`
	GroupId         string `json:"GroupId" xml:"GroupId"`
	GroupName       string `json:"GroupName" xml:"GroupName"`
}

// CreateGetHotlineRecordRequest creates a request to invoke GetHotlineRecord API
func CreateGetHotlineRecordRequest() (request *GetHotlineRecordRequest) {
	request = &GetHotlineRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ccs", "2017-10-01", "GetHotlineRecord", "ccs", "openAPI")
	return
}

// CreateGetHotlineRecordResponse creates a response to parse from GetHotlineRecord response
func CreateGetHotlineRecordResponse() (response *GetHotlineRecordResponse) {
	response = &GetHotlineRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
