'use client';
import dayjs from 'dayjs';
import { shiftTimezone } from './shift-timezone.mjs';

function getDefaultClampedDate({ minDate, maxDate, timezone }) {
  const today = shiftTimezone("add", /* @__PURE__ */ new Date(), timezone);
  if (!minDate && !maxDate) {
    return today;
  }
  if (minDate && dayjs(today).isBefore(minDate)) {
    return minDate;
  }
  if (maxDate && dayjs(today).isAfter(maxDate)) {
    return maxDate;
  }
  return today;
}

export { getDefaultClampedDate };
//# sourceMappingURL=get-default-clamped-date.mjs.map
